<?php

namespace App\Http\Controllers;

use Illuminate\Http\Response;

class BaseApiController extends Controller
{
    /**
     * 返回成功信息
     *
     * @param  mixed  $data
     */
    public function success($data = [], string $message = 'success', int $code = Response::HTTP_OK): \Illuminate\Http\JsonResponse
    {
        return response()->json(['status' => true, 'code' => $code, 'message' => $message, 'data' => $data]);
    }

    /**
     * 返回失败信息
     *
     * @param  string  $message  错误消息
     * @param  array  $data  返回数据
     * @param  int  $code  错误编码
     */
    public function failed(string $message = 'fail', array $data = [], int $code = Response::HTTP_INTERNAL_SERVER_ERROR): \Illuminate\Http\JsonResponse
    {
        return response()->json(['status' => false, 'code' => $code, 'message' => $message, 'data' => $data]);
    }
}
