<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\PharmacyCorrectionRepository;
use App\Models\PharmacyCorrectionModel;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Http\Controllers\AdminController;

// 药店-纠错
class PharmacyCorrectionController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new PharmacyCorrectionRepository(), function (Grid $grid) {
            $grid->model()->orderBy('id', 'DESC');

            $grid->column('id');
            // $grid->column('pharmacy_id');
            $grid->column('is_handle')->switch();
            $grid->column('pharmacy_name');
            $grid->column('content');
            $grid->column('created_at');
            // $grid->column('updated_at')->sortable();

            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel(); // 更改为 panel 布局
                $filter->expand(); // 默认展开搜索框

                $filter->like('pharmacy_name')->width(3);
                $filter->in('is_handle')->checkbox(PharmacyCorrectionModel::IS_HANDLE_MAP)->width(3);
            });

            // 行按钮控制
            $grid->disableActions(); // 禁用按钮

            // 工具栏按钮控制
            $grid->disableCreateButton(); // 禁用创建按钮
            $grid->disableBatchActions(); // 禁用批量操作
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new PharmacyCorrectionRepository(), function (Form $form) {
            $form->switch('is_handle')->width(4);

            // 右上角按钮控制
            $form->disableDeleteButton(); // 去掉删除按钮
            $form->disableViewButton(); // 去掉跳转详情页按钮
        });
    }
}
