<?php

namespace App\Admin\Controllers;

use App\Models\PrescriptionModel;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Layout\Content;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Laravel\Facades\Image;

// 药店-处方打印
class PrescriptionPrintController extends AdminController
{
    // 处方打印首页，显示输入框，可以搜索处方
    public function index(Content $content): Content
    {
        // 加载处方打印页面
        return $content->header('处方打印')
            ->description('根据处方编号搜索并打印处方')
            ->body(view('admin.prescription-print'));
    }

    /**
     * 根据处方编号搜索处方并生成图片
     */
    public function search()
    {
        $prescriptionNo = request('prescription_no');

        if (empty($prescriptionNo)) {
            return response()->json([
                'status' => false,
                'message' => '请输入处方编号',
            ]);
        }

        try {

            // 获取处方信息
            $prescription = PrescriptionModel::where('id', $prescriptionNo)->first();
            if (! $prescription) {
                return response()->json(['status' => false, 'message' => '未找到该处方']);
            }
            // 检查处方图片是否已经生成
            if ($prescription->prescription_pic) {
                return response()->json([
                    'status' => true,
                    'data' => [
                        'img_url' => Storage::url($prescription->prescription_pic),
                    ],
                ]);
            }

            // 创建处方图片
            // 处方背景图宽1653，高2339
            $img = Image::read(public_path('static/images/chufangdan.jpg'));

            // 医院
            $imageWidth = 1653;
            // 手动调整 X 坐标以居中
            $centerX = $imageWidth / 2;
            $img->text('江阴康恒诊所处方', $centerX, 70, function ($font) {
                $font->filename(public_path('static/fonts/SimHei.ttf'));
                $font->size(72);
                $font->color('#000000');
                $font->align('center'); // 使用 align('center') 以确保文本相对于 X 坐标居中
                $font->valign('top');   // 确保文本垂直对齐方式
            });
            // 处方单编号
            $img->text('处方单编号：10000001', 1170, 190, function ($font) {
                $font->filename(public_path('static/fonts/SimHei.ttf'));
                $font->size(24);
                $font->color('#000000');
            });
            // 姓名
            $img->text('周永福', 410, 260, function ($font) {
                $font->filename(public_path('static/fonts/SimHei.ttf'));
                $font->size(32);
                $font->color('#000000');
            });
            // 性别
            $img->text('男', 890, 260, function ($font) {
                $font->filename(public_path('static/fonts/SimHei.ttf'));
                $font->size(32);
                $font->color('#000000');
            });
            // 年龄
            $img->text('65岁', 1270, 260, function ($font) {
                $font->filename(public_path('static/fonts/SimHei.ttf'));
                $font->size(32);
                $font->color('#000000');
            });
            // 日期
            $img->text('2024-10-23', 1215, 330, function ($font) {
                $font->filename(public_path('static/fonts/SimHei.ttf'));
                $font->size(32);
                $font->color('#000000');
            });
            // 诊断
            $img->text('呼吸道感染', 330, 460, function ($font) {
                $font->filename(public_path('static/fonts/SimHei.ttf'));
                $font->size(32);
                $font->color('#000000');
            });

            // 假设 $prescription->medicines 是一个包含药品信息的数组
            // $medicines = $prescription->drug_info; // 每个元素包含 'name', 'spec', 'box', 'sig'
            $medicines = [
                [
                    'name' => '阿莫西林胶囊',
                    'spec' => '0.5g*20粒',
                    'box' => 2,
                    'sig' => '每日三次，每次两粒，饭后服用',
                ],
                [
                    'name' => '布洛芬片',
                    'spec' => '0.2g*30片',
                    'box' => 1,
                    'sig' => '每日两次，每次一片，必要时服用',
                ],
                [
                    'name' => '维生素C片',
                    'spec' => '100mg*100片',
                    'box' => 1,
                    'sig' => '每日一次，每次一片，早晨服用',
                ],
            ];
            // 初始 Y 坐标
            $yCoordinate = 650; // 根据需要调整初始 Y 坐标

            foreach ($medicines as $medicine) {
                // 打印药品名称、规格和盒数
                $medicineText = "{$medicine['name']}     {$medicine['spec']}      {$medicine['box']}盒";
                $img->text($medicineText, 550, $yCoordinate, function ($font) {
                    $font->filename(public_path('static/fonts/SimHei.ttf'));
                    $font->size(32);
                    $font->color('#000000');
                    $font->align('center');
                });

                // 增加 Y 坐标以打印下一行
                $yCoordinate += 40; // 根据字体大小调整行间距

                // 打印 sig 信息
                $img->text('Sig：  '.$medicine['sig'], 550, $yCoordinate, function ($font) {
                    $font->filename(public_path('static/fonts/SimHei.ttf'));
                    $font->size(32);
                    $font->color('#000000');
                    $font->align('center');
                });

                // 增加 Y 坐标以准备打印下一个药品
                $yCoordinate += 60; // 根据字体大小调整行间距
            }

            // 打印两行空白
            $yCoordinate += 30; // 空白行间距
            $yCoordinate += 30; // 空白行间距

            // 打印“以下空白”文字
            $img->text('以下空白', 650, $yCoordinate, function ($font) {
                $font->filename(public_path('static/fonts/SimHei.ttf'));
                $font->size(32);
                $font->color('#000000');
                $font->align('center');
            });

            // 医师签名图片
            if ($prescription->doctor_signed_pic) {
                $doctorSignData = base64_decode($prescription->doctor_signed_pic);
                $doctorSign = Image::read($doctorSignData);
                $doctorSign->rotate(90);
                $doctorSign->resize(150, 100);
                $img->place($doctorSign, 'bottom-left', 400, 410);
            }
            // 药师签名图片
            if ($prescription->pharmacist_signed_pic) {
                $pharmacistSignData = base64_decode($prescription->pharmacist_signed_pic);
                $pharmacistSign = Image::read($pharmacistSignData);
                $pharmacistSign->rotate(90);
                $pharmacistSign->resize(150, 100);
                $img->place($pharmacistSign, 'bottom-left', 870, 410);
            }

            // 将图片保存到临时文件
            $tempPath = storage_path('app/public').$prescriptionNo.'.jpg';
            $img->save($tempPath);

            // 上传到腾讯云
            // \Storage::disk('cos')->putFileAs('prescriptions', $tempPath, $prescriptionNo.'.jpg');

            // 删除临时文件
            // unlink($tempPath);

            // return response()->json([
            //     'status' => true,
            //     'data' => [
            //         'img_url' => \Storage::disk('cos')->url($cosPath),
            //     ],
            // ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'message' => '处方生成失败:'.$e->getMessage(),
            ]);
        }
    }
}
