<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateExternalWmPrescriptionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('external_wm_prescription', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('idcardTypeCode')->default('')->comment('患者就诊卡证类型');
            $table->string('idcardNo')->default('')->comment('患者就诊卡证号码');
            $table->string('name')->default('')->comment('姓名');
            $table->string('genderCode')->default('')->comment('性别代码');
            $table->string('birthdate')->default('')->comment('出生日期');
            $table->string('visitNo')->default('')->comment('问诊编号');
            $table->string('hosRxCode')->default('')->comment('处方编码');
            $table->string('rxTypeCode')->default('')->comment('处方分类代码');
            $table->string('rxAmount')->default('')->comment('处方药品总金额');
            $table->text('rxDescription')->comment('处方备注说明');
            $table->string('unifiedOrgCode')->default('')->comment('开处方医疗机构编码');
            $table->string('orgName')->default('')->comment('开处方医疗机构名称');
            $table->string('deptCode')->default('')->comment('开处方科室编码');
            $table->string('deptName')->default('')->comment('开处方科室名称');
            $table->string('deptClassCode')->default('')->comment('开处方科室对应诊疗科目编码');
            $table->string('deptClassName')->default('')->comment('开处方科室对应诊疗科目名称');
            $table->string('doctIdcardNo')->default('')->comment('开处方医师身份证号');
            $table->string('doctName')->default('')->comment('开处方医师姓名');
            $table->string('rxDatetime')->default('')->comment('开处方日期时间');
            $table->longText('doctCaSign')->comment('开处方医师电子签名');
            $table->longText('originalData')->comment('数据原文');
            $table->longText('certificate')->comment('数字证书');
            $table->string('rotateTypeCode')->default('')->comment('处方流向类型');
            $table->longText('items')->comment('处方明细');
            $table->longText('addAmountItems')->comment('处方附加服务费用明细');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('external_wm_prescription');
    }
}
