<?php

namespace App\Console\Commands;


use App\Models\ExternalCmPrescriptionModel;
use App\Services\ExternalService;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;

class CmPrescription extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cm-prescription:init';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '同步中药处方';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('处方信息（中药）同步开始...');
        try {
            $pageNum = 1;  // 初始页码
            $maxPage = 1;  // 默认最大页数为 1
            $baseParams = [
                // 根据文档填写必要的参数
                "beginTime"=>"1732982400000",
                "endTime"=>"1859212800000",
                "pageNum"=>1,
                "pageSize"=>20,
            ];
            $eHospitalApi = new ExternalService('jymd_15700159057_test', 'heU0zM9OrLrK0JehxiAXlPd3L48HHmcA', 'https://ehospital-openapi-test.sq580.com');
            while ($pageNum <= $maxPage) {
                // 设置当前页码参数
                $params = array_merge($baseParams, [
                    "pageNum" => $pageNum,
                ]);
                // 处方信息（中药）
                $response = $eHospitalApi->createPrescriptionCm($params);
                // 检查接口是否调用成功
                if (isset($response['err']) && $response['err'] === 0) {
                    echo "第 {$pageNum} 页查询成功。\n";

                    // 当前页数据
                    $response_data = $response['data']['list'];
                    Log::info('CmPrescription-处方信息（中药）:'.json_encode($response_data));
                    if( empty($response_data) ){
                        break;
                    }
                    # 处理数据存入到数据库，如果存在就更新否则就新增
                    foreach ($response_data as $item) {
                        $prescription = ExternalCmPrescriptionModel::where('hosRxCode', $item['hosRxCode'])->first();
                        if($prescription){
                            $this->info('更新处方（中药）：'. $item['hosRxCode']);
                            // 基本信息
                            $prescription->idcardTypeCode = $item['idcardTypeCode'] ?? null; // 患者就诊卡证类型
                            $prescription->idcardNo = $item['idcardNo'] ?? null; // 患者就诊卡证号码
                            $prescription->name = $item['name'] ?? null; // 姓名
                            $prescription->genderCode = $item['genderCode'] ?? null; // 性别代码
                            $prescription->birthdate = $item['birthdate'] ?? null; // 出生日期
                            $prescription->visitNo = $item['visitNo'] ?? null; // 门诊编号

                            // 处方基本信息
                            $prescription->hosRxCode = $item['hosRxCode'] ?? null; // 处方编码
                            $prescription->rxTypeCode = $item['rxTypeCode'] ?? null; // 处方分类
                            $prescription->tcmPasteCnt = $item['tcmPasteCnt'] ?? null; // 处方帖数
                            $prescription->tcmUseCode = $item['tcmUseCode'] ?? null; // 用药方法代码
                            $prescription->tcmUseDes = $item['tcmUseDes'] ?? null; // 用药方法描述
                            $prescription->tcmDecoctCode = $item['tcmDecoctCode'] ?? null; // 煎药方法代码
                            $prescription->tcmDecoctDes = $item['tcmDecoctDes'] ?? null; // 煎药方法描述
                            $prescription->tcmFrequencyCode = $item['tcmFrequencyCode'] ?? null; // 用药频次代码
                            $prescription->tcmFrequencyDes = $item['tcmFrequencyDes'] ?? null; // 用药频次描述
                            $prescription->tcmOnceDosage = $item['tcmOnceDosage'] ?? null; // 一次用量（ml）
                            $prescription->onceDosageDes = $item['onceDosageDes'] ?? null; // 一次用量描述
                            $prescription->rxDescription = $item['rxDescription'] ?? null; // 处方备注说明
                            $prescription->rxAmount = $item['rxAmount'] ?? null; // 处方总金额(元)

                            // 开处方单位信息
                            $prescription->unifiedOrgCode = $item['unifiedOrgCode'] ?? null; // 开处方单位编码
                            $prescription->orgName = $item['orgName'] ?? null; // 开处方单位名称

                            // 开处方科室信息
                            $prescription->deptCode = $item['deptCode'] ?? null; // 开处方科室编码
                            $prescription->deptName = $item['deptName'] ?? null; // 开处方科室名称
                            $prescription->deptClassCode = $item['deptClassCode'] ?? null; // 开处方科室对应诊疗科目编码
                            $prescription->deptClassName = $item['deptClassName'] ?? null; // 开处方科室对应诊疗科目名称

                            // 开处方医师信息
                            $prescription->doctIdcardNo = $item['doctIdcardNo'] ?? null; // 开处方医师身份证号
                            $prescription->doctName = $item['doctName'] ?? null; // 开处方医师姓名
                            $prescription->rxDatetime = $item['rxDatetime'] ?? null; // 开处方日期时间
                            $prescription->doctCaSign = $item['doctCaSign'] ?? null; // 开处方医师电子签名

                            // 数字签名相关
                            $prescription->originalData = $item['originalData'] ?? null; // 数据原文
                            $prescription->certificate = $item['certificate'] ?? null; // 数字证书

                            // 处方流向类型
                            $prescription->rotateTypeCode = $item['rotateTypeCode'] ?? null; // 处方流向类型

                            // 处方明细（对象数组）
                            if (isset($item['items'])) {
                                $prescription->items = json_encode($item['items'], JSON_UNESCAPED_UNICODE); // 处方明细数组
                            }

                            // 处方附加服务费用明细（对象数组）
                            if (isset($item['addAmountItems'])) {
                                $prescription->addAmountItems = json_encode($item['addAmountItems'], JSON_UNESCAPED_UNICODE); // 处方附加服务费用明细
                            }
                            $prescription->updated_at = Carbon::now();
                            // 保存数据
                            $prescription->save();
                        }else{
                            $this->info('更新处方（中药）：'. $item['hosRxCode']);
                            $prescription = new ExternalCmPrescriptionModel();
                            // 基本信息
                            $prescription->idcardTypeCode = $item['idcardTypeCode'] ?? null; // 患者就诊卡证类型
                            $prescription->idcardNo = $item['idcardNo'] ?? null; // 患者就诊卡证号码
                            $prescription->name = $item['name'] ?? null; // 姓名
                            $prescription->genderCode = $item['genderCode'] ?? null; // 性别代码
                            $prescription->birthdate = $item['birthdate'] ?? null; // 出生日期
                            $prescription->visitNo = $item['visitNo'] ?? null; // 门诊编号

                            // 处方基本信息
                            $prescription->hosRxCode = $item['hosRxCode'] ?? null; // 处方编码
                            $prescription->rxTypeCode = $item['rxTypeCode'] ?? null; // 处方分类
                            $prescription->tcmPasteCnt = $item['tcmPasteCnt'] ?? null; // 处方帖数
                            $prescription->tcmUseCode = $item['tcmUseCode'] ?? null; // 用药方法代码
                            $prescription->tcmUseDes = $item['tcmUseDes'] ?? null; // 用药方法描述
                            $prescription->tcmDecoctCode = $item['tcmDecoctCode'] ?? null; // 煎药方法代码
                            $prescription->tcmDecoctDes = $item['tcmDecoctDes'] ?? null; // 煎药方法描述
                            $prescription->tcmFrequencyCode = $item['tcmFrequencyCode'] ?? null; // 用药频次代码
                            $prescription->tcmFrequencyDes = $item['tcmFrequencyDes'] ?? null; // 用药频次描述
                            $prescription->tcmOnceDosage = $item['tcmOnceDosage'] ?? null; // 一次用量（ml）
                            $prescription->onceDosageDes = $item['onceDosageDes'] ?? null; // 一次用量描述
                            $prescription->rxDescription = $item['rxDescription'] ?? null; // 处方备注说明
                            $prescription->rxAmount = $item['rxAmount'] ?? null; // 处方总金额(元)

                            // 开处方单位信息
                            $prescription->unifiedOrgCode = $item['unifiedOrgCode'] ?? null; // 开处方单位编码
                            $prescription->orgName = $item['orgName'] ?? null; // 开处方单位名称

                            // 开处方科室信息
                            $prescription->deptCode = $item['deptCode'] ?? null; // 开处方科室编码
                            $prescription->deptName = $item['deptName'] ?? null; // 开处方科室名称
                            $prescription->deptClassCode = $item['deptClassCode'] ?? null; // 开处方科室对应诊疗科目编码
                            $prescription->deptClassName = $item['deptClassName'] ?? null; // 开处方科室对应诊疗科目名称

                            // 开处方医师信息
                            $prescription->doctIdcardNo = $item['doctIdcardNo'] ?? null; // 开处方医师身份证号
                            $prescription->doctName = $item['doctName'] ?? null; // 开处方医师姓名
                            $prescription->rxDatetime = $item['rxDatetime'] ?? null; // 开处方日期时间
                            $prescription->doctCaSign = $item['doctCaSign'] ?? null; // 开处方医师电子签名

                            // 数字签名相关
                            $prescription->originalData = $item['originalData'] ?? null; // 数据原文
                            $prescription->certificate = $item['certificate'] ?? null; // 数字证书

                            // 处方流向类型
                            $prescription->rotateTypeCode = $item['rotateTypeCode'] ?? null; // 处方流向类型

                            // 处方明细（对象数组）
                            if (isset($item['items'])) {
                                $prescription->items = json_encode($item['items'], JSON_UNESCAPED_UNICODE); // 处方明细数组
                            }

                            // 处方附加服务费用明细（对象数组）
                            if (isset($item['addAmountItems'])) {
                                $prescription->addAmountItems = json_encode($item['addAmountItems'], JSON_UNESCAPED_UNICODE); // 处方附加服务费用明细
                            }

                            // 保存数据
                            $prescription->save();
                        }
                    }
                    // 更新分页信息
                    if (isset($response['data']['maxPage'])) {
                        $maxPage = $response['data']['maxPage'];
                    }
                    if (isset($response['data']['pageNum'])) {
                        $pageNum = $response['data']['pageNum'] + 1; // 下一页
                    } else {
                        $pageNum++; // 如果没有明确的 pageNum，手动递增
                    }
                }else{
                    Log::info('CmPrescription-处方信息（中药）- 接口异常' .json_encode($response));
                    echo "第 {$pageNum} 页查询失败。\n";
                    break; // 如果某页失败，停止翻页
                }

                if( $maxPage == 1 ){
                    break;
                }
            }

        } catch (\Exception $e) {
            Log::info('CmPrescription-处方信息（中药）- 代码异常' .json_encode($e));
            $this->error($e->getMessage());
        }
        $this->info('处方信息（中药）同步结束...');
    }
}
