<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;

/**
 * App\Models\AdminUsers
 *
 * @property int $id
 * @property string $username
 * @property string $password
 * @property string $name
 * @property string|null $avatar
 * @property string|null $remember_token
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 *
 * @method static \Illuminate\Database\Eloquent\Builder|AdminUsers newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AdminUsers newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AdminUsers query()
 *
 * @mixin \Eloquent
 */
class AdminUsers extends Model
{
    use HasDateTimeFormatter;

    public function getIdNameMap(): array
    {
        return self::orderBy('id', 'desc')->pluck('name', 'id')->toArray();
    }
}
