<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\PrescriptionLogRepository;
use App\Models\PharmacyModel;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Show;

// 处方日志
class PrescriptionLogController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new PrescriptionLogRepository(), function (Grid $grid) {
            $grid->model()->orderBy('id', 'DESC');

            $grid->column('id');
            // $grid->column('pharmacy_id');
            $grid->column('pharmacy_name');
            $grid->column('log_info');
            $grid->column('created_at');

            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel(); // 更改为 panel 布局
                $filter->expand(); // 默认展开搜索框

                $filter->like('pharmacy_name')->width(3);
            });

            // 行按钮控制
            $grid->disableCreateButton(); // 禁用创建按钮
            $grid->disableEditButton(); // 禁用编辑按钮
            $grid->disableViewButton(); // 禁用详情按钮
            $grid->disableDeleteButton(); // 禁用删除按钮
            $grid->disableActions(); // 禁用按钮

            // 工具栏按钮控制
            $grid->disableBatchDelete(); // 禁用批量删除
        });
    }

    /**
     * Make a show builder.
     *
     * @param  mixed  $id
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new PrescriptionLogRepository(), function (Show $show) {
            $show->field('id')->width(4);
            $show->field('pharmacy_id')->width(4);
            $show->field('pharmacy_name')->width(4);
            $show->field('log_info')->width(4);
            $show->field('created_at')->width(4);
            $show->field('updated_at')->width(4);

            $show->panel()->tools(function ($tools) {
                $tools->disableDelete(); // 禁止删除按钮
            });
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new PrescriptionLogRepository(), function (Form $form) {
            $form->display('id')->width(4);
            $form->select('pharmacy_id')->options(PharmacyModel::all()->pluck('name', 'id'))->width(4)->required();
            $form->textarea('log_info')->width(4);

            $form->display('created_at')->width(4);
            $form->display('updated_at')->width(4);

            // 右上角按钮控制
            $form->disableDeleteButton(); // 去掉删除按钮
        });
    }
}
