<?php

namespace App\Admin\Extensions\ToolBar\Forms\Shop;

use App\Models\Shop\ShopProduct;
use App\Models\Shop\ShopSku;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Dcat\Admin\Widgets\Alert;
use Dcat\Admin\Widgets\Form;
use Illuminate\Support\Facades\DB;

class EditSkuForm extends Form implements LazyRenderable
{
    use LazyWidget;

    public function form()
    {
        $info = '1、只修改想要修改的项，不填则不会修改，批量修改要非常小心<br />';
        $this->html(Alert::make($info, '注意事项')->warning());
        $this->disableResetButton();
        $this->textarea('sku_ids', '已勾选SKUID')->attribute('id', 'batch-ids'); //批量选择的行的id通过隐藏元素 提交时一并传递过去
        // $this->select('alipay_cat_id', '支付宝类目')->width(3)->options($cats);
        $this->text('title', __('商品标题'))->width(6);
        $this->text('remark', __('备注'))->width(6);
        $this->currency('settle_price', __('供货价'))->symbol('￥')->width(6);
        $this->currency('crossed_price', __('划线价'))->symbol('￥')->width(6);
        $this->currency('guide_price', __('建议售价'))->symbol('￥')->width(6);
        $this->text('stock', __('库存'))->width(6);
        $this->select('online_status', __('上线状态'))->options(ShopSku::ONLINE_STATUS_ONLINE_MAP)->width(3);
    }

    public function handle(array $input)
    {
        $skuIds = $input['sku_ids'];
        $skuIdsArray = clean_ids($skuIds, true);
        if (! $skuIdsArray) {
            return $this->response()->error('请选择至少一个SKU')->refresh();
        }

        $skuData = [];
        $productData = [];
        if ($input['title']) {
            $skuData['title'] = $productData['title'] = trim($input['title']);
        }
        if ($input['remark']) {
            $skuData['remark'] = trim($input['remark']); // 不同步到商品表
        }
        if ($input['settle_price']) {
            $skuData['settle_price'] = $productData['settle_price'] = yuan_2_fen($input['settle_price']);
        }
        if ($input['crossed_price']) {
            $skuData['crossed_price'] = $productData['crossed_price'] = yuan_2_fen($input['crossed_price']);
        }
        if ($input['guide_price']) {
            $skuData['guide_price'] = $productData['guide_price'] = yuan_2_fen($input['guide_price']);
        }
        if (isset($input['stock']) && ($input['stock'] >= 0)) {
            $skuData['stock'] = $productData['stock'] = (int) $input['stock'];
        }
        if ($input['online_status']) {
            $skuData['online_status'] = $productData['sku_status'] = (int) $input['online_status'];
        }
        if (! $skuData) {
            return $this->response()->error('请至少修改一个内容');
        }

        DB::beginTransaction();
        try {
            ShopSku::whereIn('id', $skuIdsArray)->update($skuData);
            ShopProduct::whereIn('sku_id', $skuIdsArray)->update($productData);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();

            return $this->response()->error('批量修改SKU失败！');
        }
        // 如果修改了库存，需要批量修改redis中对应的库存
        if (isset($input['stock']) && ($input['stock'] >= 0)) {
            foreach ($skuIdsArray as $skuId) {
                $key = "kv:shop:product_stock_$skuId";
                app('redis')->del($key);
            }
        }

        return $this->response()->success('批量修改SKU成功')->refresh();
    }
}
