/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2019 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 6.2.1
 * @date    2019-08-01
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.JSONEditor=t():e.JSONEditor=t()}(window,function(){return n={},r.m=i=[function(e,c,t){"use strict";t(23);var o=t(24),i=t(72),n=t(73),r=t(1).translate;c.parse=function(t){try{return JSON.parse(t)}catch(e){throw c.validate(t),e}},c.repair=function(n){var i=[],r=0,e=n.match(/^\s*(\/\*(.|[\r\n])*?\*\/)?\s*[\da-zA-Z_$]+\s*\(([\s\S]*)\)\s*;?\s*$/);e&&(n=e[3]);var t,o={"\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};function s(){return n.charAt(r)}function a(){return n.charAt(r+1)}function l(e){return" "===e||"\n"===e||"\r"===e||"\t"===e}function c(){for(var e=i.length-1;0<=e;){var t=i[e];if(!l(t))return t;e--}return""}function h(){for(var e=r+1;e<n.length&&l(n[e]);)e++;return n[e]}function d(){for(r+=2;r<n.length&&("*"!==s()||"/"!==a());)r++;r+=2}function u(){for(r+=2;r<n.length&&"\n"!==s();)r++}function f(e){var t="";t+='"',r++;for(var i=s();r<n.length&&i!==e;)'"'===i&&"\\"!==n.charAt(r-1)?t+='\\"':o.hasOwnProperty(i)?t+=o[i]:("\\"===i&&(r++,"'"!==(i=s())&&(t+="\\")),t+=i),r++,i=s();return i===e&&(t+='"',r++),t}function p(){for(var e="",t=s(),i=/[a-zA-Z_$\d]/;i.test(t);)e+=t,r++,t=s();return-1===["null","true","false"].indexOf(e)?'"'+e+'"':e}function m(){for(var e,t=s(),i="";/[a-zA-Z_$]/.test(t);)i+=t,r++,t=s();if(0<i.length&&"("===t){if(r++,'"'===(t=s()))e=f(t),t=s();else for(e="";")"!==t&&""!==t;)e+=t,r++,t=s();return")"===t?(r++,e):i+"("+e+t}return i}for(;r<n.length;){var g=s();"/"===g&&"*"===a()?d():"/"===g&&"/"===a()?u():" "===(t=g)||" "<=t&&t<=" "||" "===t||" "===t||"　"===t?(i.push(" "),r++):"'"===g?i.push(f(g)):'"'===g?i.push(f('"')):"`"===g?i.push(f("´")):"‘"===g?i.push(f("’")):"“"===g?i.push(f("”")):","===g&&-1!==["]","}"].indexOf(h())?r++:/[a-zA-Z_$]/.test(g)&&-1!==["{",","].indexOf(c())?i.push(p()):/[a-zA-Z_$]/.test(g)?i.push(m()):(i.push(g),r++)}return i.join("")},c.escapeUnicodeChars=function(e){return e.replace(/[\u007F-\uFFFF]/g,function(e){return"\\u"+("0000"+e.charCodeAt(0).toString(16)).slice(-4)})},c.validate=function(e){void 0!==i?i.parse(e):JSON.parse(e)},c.extend=function(e,t){for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i]);return e},c.clear=function(e){for(var t in e)e.hasOwnProperty(t)&&delete e[t];return e},c.type=function(e){return null===e?"null":void 0===e?"undefined":e instanceof Number||"number"==typeof e?"number":e instanceof String||"string"==typeof e?"string":e instanceof Boolean||"boolean"==typeof e?"boolean":e instanceof RegExp||"regexp"==typeof e?"regexp":c.isArray(e)?"array":"object"};var s=/^https?:\/\/\S+$/;c.isUrl=function(e){return("string"==typeof e||e instanceof String)&&s.test(e)},c.isArray=function(e){return"[object Array]"===Object.prototype.toString.call(e)},c.getAbsoluteLeft=function(e){return e.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0},c.getAbsoluteTop=function(e){return e.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0},c.addClassName=function(e,t){var i=e.className.split(" ");-1==i.indexOf(t)&&(i.push(t),e.className=i.join(" "))},c.removeAllClassNames=function(e){e.className=""},c.removeClassName=function(e,t){var i=e.className.split(" "),n=i.indexOf(t);-1!=n&&(i.splice(n,1),e.className=i.join(" "))},c.stripFormatting=function(e){for(var t=e.childNodes,i=0,n=t.length;i<n;i++){var r=t[i];r.style&&r.removeAttribute("style");var o=r.attributes;if(o)for(var s=o.length-1;0<=s;s--){var a=o[s];!0===a.specified&&r.removeAttribute(a.name)}c.stripFormatting(r)}},c.setEndOfContentEditable=function(e){var t,i;document.createRange&&((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(i=window.getSelection()).removeAllRanges(),i.addRange(t))},c.selectContentEditable=function(e){var t,i;e&&"DIV"==e.nodeName&&window.getSelection&&document.createRange&&((i=document.createRange()).selectNodeContents(e),(t=window.getSelection()).removeAllRanges(),t.addRange(i))},c.getSelection=function(){if(window.getSelection){var e=window.getSelection();if(e.getRangeAt&&e.rangeCount)return e.getRangeAt(0)}return null},c.setSelection=function(e){if(e&&window.getSelection){var t=window.getSelection();t.removeAllRanges(),t.addRange(e)}},c.getSelectionOffset=function(){var e=c.getSelection();return e&&"startOffset"in e&&"endOffset"in e&&e.startContainer&&e.startContainer==e.endContainer?{startOffset:e.startOffset,endOffset:e.endOffset,container:e.startContainer.parentNode}:null},c.setSelectionOffset=function(e){if(document.createRange&&window.getSelection&&window.getSelection()){var t=document.createRange();e.container.firstChild||e.container.appendChild(document.createTextNode("")),t.setStart(e.container.firstChild,e.startOffset),t.setEnd(e.container.firstChild,e.endOffset),c.setSelection(t)}},c.getInnerText=function(e,t){if(null==t&&(t={text:"",flush:function(){var e=this.text;return this.text="",e},set:function(e){this.text=e}}),e.nodeValue)return t.flush()+e.nodeValue;if(e.hasChildNodes()){for(var i=e.childNodes,n="",r=0,o=i.length;r<o;r++){var s=i[r];if("DIV"==s.nodeName||"P"==s.nodeName){var a=i[r-1],l=a?a.nodeName:void 0;l&&"DIV"!=l&&"P"!=l&&"BR"!=l&&(n+="\n",t.flush()),n+=c.getInnerText(s,t),t.set("\n")}else"BR"==s.nodeName?(n+=t.flush(),t.set("\n")):n+=c.getInnerText(s,t)}return n}return"P"==e.nodeName&&-1!=c.getInternetExplorerVersion()?t.flush():""},c.hasParentNode=function(e,t){for(var i=e?e.parentNode:void 0;i;){if(i===t)return!0;i=i.parentNode}return!1},c.getInternetExplorerVersion=function(){if(-1==a){var e=-1;if("undefined"!=typeof navigator&&"Microsoft Internet Explorer"==navigator.appName){var t=navigator.userAgent;null!=new RegExp("MSIE ([0-9]{1,}[.0-9]{0,})").exec(t)&&(e=parseFloat(RegExp.$1))}a=e}return a},c.isFirefox=function(){return"undefined"!=typeof navigator&&-1!==navigator.userAgent.indexOf("Firefox")};var a=-1;c.addEventListener=function(e,t,i,n){if(e.addEventListener)return void 0===n&&(n=!1),"mousewheel"===t&&c.isFirefox()&&(t="DOMMouseScroll"),e.addEventListener(t,i,n),i;if(e.attachEvent){var r=function(){return i.call(e,window.event)};return e.attachEvent("on"+t,r),r}},c.removeEventListener=function(e,t,i,n){e.removeEventListener?(void 0===n&&(n=!1),"mousewheel"===t&&c.isFirefox()&&(t="DOMMouseScroll"),e.removeEventListener(t,i,n)):e.detachEvent&&e.detachEvent("on"+t,i)},c.isChildOf=function(e,t){for(var i=e.parentNode;i;){if(i===t)return!0;i=i.parentNode}return!1},c.parsePath=function(i){var e=[],n=0;function t(){for(var e="";void 0!==i[n]&&/[\w$]/.test(i[n]);)e+=i[n],n++;if(""===e)throw new Error("Invalid JSON path: property name expected at index "+n);return e}function r(e){for(var t="";void 0!==i[n]&&i[n]!==e;)t+=i[n],n++;if(i[n]!==e)throw new Error("Invalid JSON path: unexpected end, character "+e+" expected");return t}for(;void 0!==i[n];)if("."===i[n])n++,e.push(t());else{if("["!==i[n])throw new Error('Invalid JSON path: unexpected character "'+i[n]+'" at index '+n);if("'"===i[++n]||'"'===i[n]){var o=i[n];if(n++,e.push(r(o)),i[n]!==o)throw new Error("Invalid JSON path: closing quote ' expected at index "+n);n++}else{var s=r("]").trim();if(0===s.length)throw new Error("Invalid JSON path: array value expected at index "+n);s="*"===s?s:JSON.parse(s),e.push(s)}if("]"!==i[n])throw new Error("Invalid JSON path: closing bracket ] expected at index "+n);n++}return e},c.stringifyPath=function(e){return e.map(function(e){return"number"==typeof e?"["+e+"]":"string"==typeof e&&e.match(/^[A-Za-z0-9_$]+$/)?"."+e:'["'+e+'"]'}).join("")},c.improveSchemaError=function(e){if("enum"===e.keyword&&Array.isArray(e.schema)){var t=e.schema;if(t){if(5<(t=t.map(function(e){return JSON.stringify(e)})).length){var i=["("+(t.length-5)+" more...)"];(t=t.slice(0,5)).push(i)}e.message="should be equal to one of: "+t.join(", ")}}return"additionalProperties"===e.keyword&&(e.message="should NOT have additional property: "+e.params.additionalProperty),e},c.isPromise=function(e){return e&&"function"==typeof e.then&&"function"==typeof e.catch},c.isValidValidationError=function(e){return"object"==typeof e&&Array.isArray(e.path)&&"string"==typeof e.message},c.insideRect=function(e,t,i){var n=void 0!==i?i:0;return t.left-n>=e.left&&t.right+n<=e.right&&t.top-n>=e.top&&t.bottom+n<=e.bottom},c.debounce=function(n,r,o){var s;return function(){var e=this,t=arguments,i=o&&!s;clearTimeout(s),s=setTimeout(function(){s=null,o||n.apply(e,t)},r),i&&n.apply(e,t)}},c.textDiff=function(e,t){for(var i=t.length,n=0,r=e.length,o=t.length;t.charAt(n)===e.charAt(n)&&n<i;)n++;for(;t.charAt(o-1)===e.charAt(r-1)&&n<o&&0<r;)o--,r--;return{start:n,end:o}},c.getInputSelection=function(i){var e,t,n,r,o,s=0,a=0;return"number"==typeof i.selectionStart&&"number"==typeof i.selectionEnd?(s=i.selectionStart,a=i.selectionEnd):(t=document.selection.createRange())&&t.parentElement()==i&&(r=i.value.length,e=i.value.replace(/\r\n/g,"\n"),(n=i.createTextRange()).moveToBookmark(t.getBookmark()),(o=i.createTextRange()).collapse(!1),-1<n.compareEndPoints("StartToEnd",o)?s=a=r:(s=-n.moveStart("character",-r),s+=e.slice(0,s).split("\n").length-1,-1<n.compareEndPoints("EndToEnd",o)?a=r:(a=-n.moveEnd("character",-r),a+=e.slice(0,a).split("\n").length-1))),{startIndex:s,endIndex:a,start:l(s),end:l(a)};function l(e){var t=i.value.substring(0,e);return{row:(t.match(/\n/g)||[]).length+1,column:t.length-t.lastIndexOf("\n")}}},c.getIndexForPosition=function(e,t,i){var n=e.value||"";if(0<t&&0<i){var r=n.split("\n",t);t=Math.min(r.length,t),i=Math.min(r[t-1].length,i-1);var o=1==t?i:i+1;return r.slice(0,t-1).join("\n").length+o}return-1},c.getPositionForPath=function(e,t){var r,o=this,s=[];if(!t||!t.length)return s;try{r=n.parse(e)}catch(e){return s}return t.forEach(function(e){var t=o.parsePath(e),i=t.length?"/"+t.join("/"):"",n=r.pointers[i];n&&s.push({path:e,line:n.key?n.key.line:n.value?n.value.line:0,column:n.key?n.key.column:n.value?n.value.column:0})}),s},c.getColorCSS=function(e){var t=document.createElement("div");return t.style.color=e,t.style.color.split(/\s+/).join("").toLowerCase()||null},c.isValidColor=function(e){return!!c.getColorCSS(e)},c.makeFieldTooltip=function(i,e){if(!i)return"";var n="";return i.title&&(n+=i.title),i.description&&(0<n.length&&(n+="\n"),n+=i.description),i.default&&(0<n.length&&(n+="\n\n"),n+=r("default",void 0,e)+"\n",n+=JSON.stringify(i.default,null,2)),Array.isArray(i.examples)&&0<i.examples.length&&(0<n.length&&(n+="\n\n"),n+=r("examples",void 0,e)+"\n",i.examples.forEach(function(e,t){n+=JSON.stringify(e,null,2),t!==i.examples.length-1&&(n+="\n")})),n},c.get=function(e,t){for(var i=e,n=0;n<t.length&&null!=i;n++)i=i[t[n]];return i},c.findUniqueName=function(e,t){for(var i=e.replace(/ \(copy( \d+)?\)$/,""),n=i,r=1;-1!==t.indexOf(n);){n=i+" ("+("copy"+(1<r?" "+r:""))+")",r++}return n},c.getChildPaths=function(e,t){var i={};function o(t,i,n,r){(Array.isArray(t)||c.isObject(t))&&!r||(i[n||""]=!0),c.isObject(t)&&Object.keys(t).forEach(function(e){o(t[e],i,n+"."+e,r)})}if(Array.isArray(e))for(var n=Math.min(e.length,1e4),r=0;r<n;r++){o(e[r],i,"",t)}else i[""]=!0;return Object.keys(i).sort()},c.sort=function(e,t,i){var r=t&&"."!==t?c.parsePath(t):[],o="desc"===i?-1:1,n=e.slice();return n.sort(function(e,t){var i=c.get(e,r),n=c.get(t,r);return o*(n<i?1:i<n?-1:0)}),n},c.sortObjectKeys=function(t,e){var i="desc"===e?-1:1,n=Object.keys(t).sort(function(e,t){return i*o(e,t)}),r={};return n.forEach(function(e){r[e]=t[e]}),r},c.parseString=function(e){var t=e.toLowerCase(),i=Number(e),n=parseFloat(e);return""===e?"":"null"===t?null:"true"===t||"false"!==t&&(isNaN(i)||isNaN(n)?e:i)},c.formatSize=function(e){if(e<900)return e.toFixed()+" B";var t=e/1024;if(t<900)return t.toFixed(1)+" KiB";var i=t/1024;if(i<900)return i.toFixed(1)+" MiB";var n=i/1024;return n<900?n.toFixed(1)+" GiB":(n/1024).toFixed(1)+" TiB"},c.limitCharacters=function(e,t){return e.length<=t?e:e.slice(0,t)+"..."},c.isObject=function(e){return"object"==typeof e&&null!==e&&!Array.isArray(e)},c.contains=function(e,t){return-1!==e.indexOf(t)}},function(e,t,i){"use strict";i(23);var r,n=["en","pt-BR","zh-CN","tr"],o={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",collapseAll:"Collapse all fields",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Cannot parse field into JSON",cannotParseValueError:"Cannot parse value into JSON",empty:"empty",expandAll:"Expand all fields",expandTitle:"Click to expand/collapse this field (Ctrl+E). \nCtrl+Click to expand/collapse including all childs.",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",extract:"Extract",extractTitle:"Extract this ${type}",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.',modeCodeText:"Code",modeCodeTitle:"Switch to code highlighter",modeFormText:"Form",modeFormTitle:"Switch to form editor",modeTextText:"Text",modeTextTitle:"Switch to plain text editor",modeTreeText:"Tree",modeTreeTitle:"Switch to tree editor",modeViewText:"View",modeViewTitle:"Switch to tree view",modePreviewText:"Preview",modePreviewTitle:"Switch to preview mode",examples:"Examples",default:"Default"},"zh-CN":{array:"数组",auto:"自动",appendText:"追加",appendTitle:"在此字段后追加一个类型为“auto”的新字段 (Ctrl+Shift+Ins)",appendSubmenuTitle:"选择要追加的字段类型",appendTitleAuto:"追加类型为“auto”的新字段 (Ctrl+Shift+Ins)",ascending:"升序",ascendingTitle:"升序排列${type}的子节点",actionsMenu:"点击打开动作菜单(Ctrl+M)",collapseAll:"缩进所有字段",descending:"降序",descendingTitle:"降序排列${type}的子节点",drag:"拖拽移动该节点(Alt+Shift+Arrows)",duplicateKey:"重复键",duplicateText:"复制",duplicateTitle:"复制选中字段(Ctrl+D)",duplicateField:"复制该字段(Ctrl+D)",duplicateFieldError:"重复的字段名称",cannotParseFieldError:"无法将字段解析为JSON",cannotParseValueError:"无法将值解析为JSON",empty:"清空",expandAll:"展开所有字段",expandTitle:"点击 展开/收缩 该字段(Ctrl+E). \nCtrl+Click 展开/收缩 包含所有子节点.",insert:"插入",insertTitle:"在此字段前插入类型为“auto”的新字段 (Ctrl+Ins)",insertSub:"选择要插入的字段类型",object:"对象",ok:"Ok",redo:"重做 (Ctrl+Shift+Z)",removeText:"移除",removeTitle:"移除选中字段 (Ctrl+Del)",removeField:"移除该字段 (Ctrl+Del)",selectNode:"选择一个节点...",showAll:"展示全部",showMore:"展示更多",showMoreStatus:"显示${totalChilds}的${visibleChilds}项目.",sort:"排序",sortTitle:"排序${type}的子节点",sortTitleShort:"内容排序",sortFieldLabel:"字段：",sortDirectionLabel:"方向：",sortFieldTitle:"选择用于对数组或对象排序的嵌套字段",sortAscending:"升序排序",sortAscendingTitle:"按照该字段升序排序",sortDescending:"降序排序",sortDescendingTitle:"按照该字段降序排序",string:"字符串",transform:"变换",transformTitle:"筛选，排序，或者转换${type}的子节点",transformTitleShort:"筛选，排序，或者转换内容",extract:"提取",extractTitle:"提取这个 ${type}",transformQueryTitle:"输入JMESPath查询",transformWizardLabel:"向导",transformWizardFilter:"筛选",transformWizardSortBy:"排序",transformWizardSelectFields:"选择字段",transformQueryLabel:"查询",transformPreviewLabel:"预览",type:"类型",typeTitle:"更改字段类型",openUrl:"Ctrl+Click 或者 Ctrl+Enter 在新窗口打开链接",undo:"撤销上次动作 (Ctrl+Z)",validationCannotMove:"无法将字段移入其子节点",autoType:'字段类型 "auto". 字段类型由值自动确定 可以为 string，number，boolean，或者 null.',objectType:'字段类型 "object". 对象包含一组无序的键/值对.',arrayType:'字段类型 "array". 数组包含值的有序集合.',stringType:'字段类型 "string". 字段类型由值自动确定，但始终作为字符串返回.',modeCodeText:"代码",modeCodeTitle:"切换至代码高亮",modeFormText:"表单",modeFormTitle:"切换至表单编辑",modeTextText:"文本",modeTextTitle:"切换至文本编辑",modeTreeText:"树",modeTreeTitle:"切换至树编辑",modeViewText:"视图",modeViewTitle:"切换至树视图",modePreviewText:"预览",modePreviewTitle:"切换至预览模式",examples:"例子",default:"缺省"},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de ações (Ctrl+M)",collapseAll:"Fechar todos campos",descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",duplicateFieldError:"Nome do campo duplicado",cannotParseFieldError:"Não é possível analisar o campo no JSON",cannotParseValueError:"Não é possível analisar o valor em JSON",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:"Clique para expandir/encolher este campo (Ctrl+E). \nCtrl+Click para expandir/encolher incluindo todos os filhos.",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",selectNode:"Select a node...",showAll:"mostre tudo",showMore:"mostre mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"Texto",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer último ação (Ctrl+Z)",validationCannotMove:"Não pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo é determinao automaticamente a partir do seu valor e pode ser texto, número, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto contém uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma coleção de valores ordenados.',stringType:'Campo do tipo "string". Campo do tipo nao é determinado através do seu valor, mas sempre retornara um texto.',examples:"Exemplos",default:"Revelia"},tr:{array:"Dizin",auto:"Otomatik",appendText:"Ekle",appendTitle:"Bu alanın altına 'otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",appendSubmenuTitle:"Eklenecek alanın tipini seç",appendTitleAuto:"'Otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",ascending:"Artan",ascendingTitle:"${type}'ın alt tiplerini artan düzende sırala",actionsMenu:"Aksiyon menüsünü açmak için tıklayın (Ctrl+M)",collapseAll:"Tüm alanları kapat",descending:"Azalan",descendingTitle:"${type}'ın alt tiplerini azalan düzende sırala",drag:"Bu alanı taşımak için sürükleyin (Alt+Shift+Arrows)",duplicateKey:"Var olan anahtar",duplicateText:"Aşağıya kopyala",duplicateTitle:"Seçili alanlardan bir daha oluştur (Ctrl+D)",duplicateField:"Bu alandan bir daha oluştur (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Alan JSON'a ayrıştırılamıyor",cannotParseValueError:"JSON'a değer ayrıştırılamıyor",empty:"boş",expandAll:"Tüm alanları aç",expandTitle:"Bu alanı açmak/kapatmak için tıkla (Ctrl+E). \nAlt alanlarda dahil tüm alanları açmak için Ctrl+Click ",insert:"Ekle",insertTitle:"Bu alanın üstüne 'otomatik' tipinde yeni bir alan ekle (Ctrl+Ins)",insertSub:"Araya eklenecek alanın tipini seç",object:"Nesne",ok:"Tamam",redo:"Yeniden yap (Ctrl+Shift+Z)",removeText:"Kaldır",removeTitle:"Seçilen alanları kaldır (Ctrl+Del)",removeField:"Bu alanı kaldır (Ctrl+Del)",selectNode:"Bir nesne seç...",showAll:"tümünü göster",showMore:"daha fazla göster",showMoreStatus:"${totalChilds} alanın ${visibleChilds} alt alanları gösteriliyor",sort:"Sırala",sortTitle:"${type}'ın alt alanlarını sırala",sortTitleShort:"İçerikleri sırala",sortFieldLabel:"Alan:",sortDirectionLabel:"Yön:",sortFieldTitle:"Diziyi veya nesneyi sıralamak için iç içe geçmiş alanı seçin",sortAscending:"Artan",sortAscendingTitle:"Seçili alanı artan düzende sırala",sortDescending:"Azalan",sortDescendingTitle:"Seçili alanı azalan düzende sırala",string:"Karakter Dizisi",transform:"Dönüştür",transformTitle:"${type}'ın alt alanlarını filtrele, sırala veya dönüştür",transformTitleShort:"İçerikleri filterele, sırala veya dönüştür",transformQueryTitle:"JMESPath sorgusu gir",transformWizardLabel:"Sihirbaz",transformWizardFilter:"Filtre",transformWizardSortBy:"Sırala",transformWizardSelectFields:"Alanları seç",transformQueryLabel:"Sorgu",transformPreviewLabel:"Önizleme",type:"Tip",typeTitle:"Bu alanın tipini değiştir",openUrl:"URL'i yeni bir pencerede açmak için Ctrl+Click veya Ctrl+Enter",undo:"Son değişikliği geri al (Ctrl+Z)",validationCannotMove:"Alt alan olarak taşınamıyor",autoType:'Alan tipi "otomatik". Alan türü otomatik olarak değerden belirlenirve bir dize, sayı, boolean veya null olabilir.',objectType:'Alan tipi "nesne". Bir nesne, sıralanmamış bir anahtar / değer çifti kümesi içerir.',arrayType:'Alan tipi "dizi". Bir dizi, düzenli değerler koleksiyonu içerir.',stringType:'Alan tipi "karakter dizisi". Alan türü değerden belirlenmez,ancak her zaman karakter dizisi olarak döndürülür.',modeCodeText:"Kod",modeCodeTitle:"Kod vurgulayıcıya geç",modeFormText:"Form",modeFormTitle:"Form düzenleyiciye geç",modeTextText:"Metin",modeTextTitle:"Düz metin düzenleyiciye geç",modeTreeText:"Ağaç",modeTreeTitle:"Ağaç düzenleyiciye geç",modeViewText:"Görünüm",modeViewTitle:"Ağaç görünümüne geç",examples:"Örnekler",default:"Varsayılan"}},s="undefined"!=typeof navigator?navigator.language||navigator.userLanguage:void 0;r=(r=n.find(function(e){return e===s}))||"en",e.exports={_locales:n,_defs:o,_lang:r,setLanguage:function(t){if(t){var e=n.find(function(e){return e===t});e?r=e:console.error("Language not found")}},setLanguages:function(e){if(e)for(var t in e){n.find(function(e){return e===t})||n.push(t),o[t]=Object.assign({},o.en,o[t],e[t])}},translate:function(e,t,i){var n=o[i=i||r][e];if(t)for(e in t)n=n.replace("${"+e+"}",t[e]);return n||e}}},function(e,t){t.DEFAULT_MODAL_ANCHOR=document.body,t.SIZE_LARGE=10485760,t.MAX_PREVIEW_CHARACTERS=2e4,t.PREVIEW_HISTORY_LIMIT=2147483648},function(e,t,i){"use strict";function o(e,t,i){var n=i?" !== ":" === ",r=i?" || ":" && ",o=i?"!":"",s=i?"":"!";switch(e){case"null":return t+n+"null";case"array":return o+"Array.isArray("+t+")";case"object":return"("+o+t+r+"typeof "+t+n+'"object"'+r+s+"Array.isArray("+t+"))";case"integer":return"(typeof "+t+n+'"number"'+r+s+"("+t+" % 1)"+r+t+n+t+")";default:return"typeof "+t+n+'"'+e+'"'}}e.exports={copy:function(e,t){for(var i in t=t||{},e)t[i]=e[i];return t},checkDataType:o,checkDataTypes:function(e,t){switch(e.length){case 1:return o(e[0],t,!0);default:var i="",n=a(e);for(var r in n.array&&n.object&&(i=n.null?"(":"(!"+t+" || ",i+="typeof "+t+' !== "object")',delete n.null,delete n.array,delete n.object),n.number&&delete n.integer,n)i+=(i?" && ":"")+o(r,t,!0);return i}},coerceToTypes:function(e,t){if(Array.isArray(t)){for(var i=[],n=0;n<t.length;n++){var r=t[n];s[r]?i[i.length]=r:"array"===e&&"array"===r&&(i[i.length]=r)}if(i.length)return i}else{if(s[t])return[t];if("array"===e&&"array"===t)return["array"]}},toHash:a,getProperty:d,escapeQuotes:l,equal:i(7),ucs2length:i(33),varOccurences:function(e,t){t+="[^0-9]";var i=e.match(new RegExp(t,"g"));return i?i.length:0},varReplace:function(e,t,i){return t+="([^0-9])",i=i.replace(/\$/g,"$$$$"),e.replace(new RegExp(t,"g"),i+"$1")},cleanUpCode:function(e){return e.replace(c,"").replace(h,"").replace(u,"if (!($1))")},finalCleanUpCode:function(e,t){var i=e.match(f);i&&2==i.length&&(e=t?e.replace(m,"").replace(y,w):e.replace(p,"").replace(g,v));return(i=e.match(b))&&3===i.length?e.replace(C,""):e},schemaHasRules:function(e,t){if("boolean"==typeof e)return!e;for(var i in e)if(t[i])return!0},schemaHasRulesExcept:function(e,t,i){if("boolean"==typeof e)return!e&&"not"!=i;for(var n in e)if(n!=i&&t[n])return!0},schemaUnknownRules:function(e,t){if("boolean"==typeof e)return;for(var i in e)if(!t[i])return i},toQuotedString:E,getPathExpr:function(e,t,i,n){return F(e,i?"'/' + "+t+(n?"":".replace(/~/g, '~0').replace(/\\//g, '~1')"):n?"'[' + "+t+" + ']'":"'[\\'' + "+t+" + '\\']'")},getPath:function(e,t,i){var n=E(i?"/"+S(t):d(t));return F(e,n)},getData:function(e,t,i){var n,r,o,s;if(""===e)return"rootData";if("/"==e[0]){if(!A.test(e))throw new Error("Invalid JSON-pointer: "+e);r=e,o="rootData"}else{if(!(s=e.match(x)))throw new Error("Invalid JSON-pointer: "+e);if(n=+s[1],"#"==(r=s[2])){if(t<=n)throw new Error("Cannot access property/index "+n+" levels up, current level is "+t);return i[t-n]}if(t<n)throw new Error("Cannot access data "+n+" levels up, current level is "+t);if(o="data"+(t-n||""),!r)return o}for(var a=o,l=r.split("/"),c=0;c<l.length;c++){var h=l[c];h&&(o+=d(_(h)),a+=" && "+o)}return a},unescapeFragment:function(e){return _(decodeURIComponent(e))},unescapeJsonPointer:_,escapeFragment:function(e){return encodeURIComponent(S(e))},escapeJsonPointer:S};var s=a(["string","number","integer","boolean","null"]);function a(e){for(var t={},i=0;i<e.length;i++)t[e[i]]=!0;return t}var n=/^[a-z$_][a-z$_0-9]*$/i,r=/'|\\/g;function d(e){return"number"==typeof e?"["+e+"]":n.test(e)?"."+e:"['"+l(e)+"']"}function l(e){return e.replace(r,"\\$&").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/\f/g,"\\f").replace(/\t/g,"\\t")}var c=/else\s*{\s*}/g,h=/if\s*\([^)]+\)\s*\{\s*\}(?!\s*else)/g,u=/if\s*\(([^)]+)\)\s*\{\s*\}\s*else(?!\s*if)/g;var f=/[^v.]errors/g,p=/var errors = 0;|var vErrors = null;|validate.errors = vErrors;/g,m=/var errors = 0;|var vErrors = null;/g,g="return errors === 0;",v="validate.errors = null; return true;",y=/if \(errors === 0\) return data;\s*else throw new ValidationError\(vErrors\);/,w="return data;",b=/[^A-Za-z_$]rootData[^A-Za-z0-9_$]/g,C=/if \(rootData === undefined\) rootData = data;/;function E(e){return"'"+l(e)+"'"}var A=/^\/(?:[^~]|~0|~1)*$/,x=/^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;function F(e,t){return'""'==e?t:(e+" + "+t).replace(/' \+ '/g,"")}function S(e){return e.replace(/~/g,"~0").replace(/\//g,"~1")}function _(e){return e.replace(/~1/g,"/").replace(/~0/g,"~")}},function(e,t,i){"use strict";var d=i(25).createAbsoluteAnchor,u=i(0),g=i(1).translate;function f(i,e){this.dom={};var m=this,t=this.dom;this.anchor=void 0,this.items=i,this.eventListeners={},this.selection=void 0,this.onClose=e?e.close:void 0;var n=document.createElement("div");n.className="jsoneditor-contextmenu-root",t.root=n;var r=document.createElement("div");r.className="jsoneditor-contextmenu",t.menu=r,n.appendChild(r);var o=document.createElement("ul");o.className="jsoneditor-menu",r.appendChild(o),t.list=o,t.items=[];var s=document.createElement("button");s.type="button",t.focusButton=s;var a=document.createElement("li");a.style.overflow="hidden",a.style.height="0",a.appendChild(s),o.appendChild(a),function u(f,p,e){e.forEach(function(t){if("separator"==t.type){var e=document.createElement("div");e.className="jsoneditor-separator",(n=document.createElement("li")).appendChild(e),f.appendChild(n)}else{var i={},n=document.createElement("li");f.appendChild(n);var r=document.createElement("button");if(r.type="button",r.className=t.className,i.button=r,t.title&&(r.title=t.title),t.click&&(r.onclick=function(e){e.preventDefault(),m.hide(),t.click()}),n.appendChild(r),t.submenu){var o=document.createElement("div");o.className="jsoneditor-icon",r.appendChild(o);var s,a=document.createElement("div");if(a.className="jsoneditor-text"+(t.click?"":" jsoneditor-right-margin"),a.appendChild(document.createTextNode(t.text)),r.appendChild(a),t.click){r.className+=" jsoneditor-default";var l=document.createElement("button");l.type="button",(i.buttonExpand=l).className="jsoneditor-expand",l.innerHTML='<div class="jsoneditor-expand"></div>',n.appendChild(l),t.submenuTitle&&(l.title=t.submenuTitle),s=l}else{var c=document.createElement("div");c.className="jsoneditor-expand",r.appendChild(c),s=r}s.onclick=function(e){e.preventDefault(),m._onExpandItem(i),s.focus()};var h=[];i.subItems=h;var d=document.createElement("ul");(i.ul=d).className="jsoneditor-menu",d.style.height="0",n.appendChild(d),u(d,h,t.submenu)}else r.innerHTML='<div class="jsoneditor-icon"></div><div class="jsoneditor-text">'+g(t.text)+"</div>";p.push(i)}})}(o,this.dom.items,i),this.maxHeight=0,i.forEach(function(e){var t=24*(i.length+(e.submenu?e.submenu.length:0));m.maxHeight=Math.max(m.maxHeight,t)})}f.prototype._getVisibleButtons=function(){var t=[],i=this;return this.dom.items.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand),e.subItems&&e==i.expandedItem&&e.subItems.forEach(function(e){t.push(e.button),e.buttonExpand&&t.push(e.buttonExpand)})}),t},f.visibleMenu=void 0,f.prototype.show=function(e,t,i){this.hide();var n=!0,r=e.parentNode,o=e.getBoundingClientRect(),s=r.getBoundingClientRect(),a=t.getBoundingClientRect(),l=this;this.dom.absoluteAnchor=d(e,t,function(){l.hide()}),o.bottom+this.maxHeight<a.bottom||o.top-this.maxHeight>a.top&&(n=!1);var c=i?0:o.top-s.top;if(n){var h=e.offsetHeight;this.dom.menu.style.left="0",this.dom.menu.style.top=c+h+"px",this.dom.menu.style.bottom=""}else this.dom.menu.style.left="0",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px";this.dom.absoluteAnchor.appendChild(this.dom.root),this.selection=u.getSelection(),this.anchor=e,setTimeout(function(){l.dom.focusButton.focus()},0),f.visibleMenu&&f.visibleMenu.hide(),f.visibleMenu=this},f.prototype.hide=function(){this.dom.absoluteAnchor&&(this.dom.absoluteAnchor.destroy(),delete this.dom.absoluteAnchor),this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose&&this.onClose()),f.visibleMenu==this&&(f.visibleMenu=void 0)},f.prototype._onExpandItem=function(i){var n=this,e=i==this.expandedItem,t=this.expandedItem;if(t&&(t.ul.style.height="0",t.ul.style.padding="",setTimeout(function(){n.expandedItem!=t&&(t.ul.style.display="",u.removeClassName(t.ul.parentNode,"jsoneditor-selected"))},300),this.expandedItem=void 0),!e){var r=i.ul;r.style.display="block";r.clientHeight;setTimeout(function(){if(n.expandedItem==i){for(var e=0,t=0;t<r.childNodes.length;t++)e+=r.childNodes[t].clientHeight;r.style.height=e+"px",r.style.padding="5px 10px"}},0),u.addClassName(r.parentNode,"jsoneditor-selected"),this.expandedItem=i}},f.prototype._onKeyDown=function(e){var t,i,n,r,o=e.target,s=e.which,a=!1;27==s?(this.selection&&u.setSelection(this.selection),this.anchor&&this.anchor.focus(),this.hide(),a=!0):9==s?e.shiftKey?0==(i=(t=this._getVisibleButtons()).indexOf(o))&&(t[t.length-1].focus(),a=!0):(i=(t=this._getVisibleButtons()).indexOf(o))==t.length-1&&(t[0].focus(),a=!0):37==s?("jsoneditor-expand"==o.className&&(i=(t=this._getVisibleButtons()).indexOf(o),(n=t[i-1])&&n.focus()),a=!0):38==s?(i=(t=this._getVisibleButtons()).indexOf(o),(n=t[i-1])&&"jsoneditor-expand"==n.className&&(n=t[i-2]),(n=n||t[t.length-1])&&n.focus(),a=!0):39==s?(i=(t=this._getVisibleButtons()).indexOf(o),(r=t[i+1])&&"jsoneditor-expand"==r.className&&r.focus(),a=!0):40==s&&(i=(t=this._getVisibleButtons()).indexOf(o),(r=t[i+1])&&"jsoneditor-expand"==r.className&&(r=t[i+2]),(r=r||t[0])&&(r.focus(),a=!0),a=!0),a&&(e.stopPropagation(),e.preventDefault())},e.exports=f},function(e,t,i){!function(e){"use strict";function _(e){return null!==e&&"[object Array]"===Object.prototype.toString.call(e)}function k(e){return null!==e&&"[object Object]"===Object.prototype.toString.call(e)}function D(e,t){if(e===t)return!0;if(Object.prototype.toString.call(e)!==Object.prototype.toString.call(t))return!1;if(!0===_(e)){if(e.length!==t.length)return!1;for(var i=0;i<e.length;i++)if(!1===D(e[i],t[i]))return!1;return!0}if(!0!==k(e))return!1;var n={};for(var r in e)if(hasOwnProperty.call(e,r)){if(!1===D(e[r],t[r]))return!1;n[r]=!0}for(var o in t)if(hasOwnProperty.call(t,o)&&!0!==n[o])return!1;return!0}function $(e){if(""===e||!1===e||null===e)return!0;if(_(e)&&0===e.length)return!0;if(k(e)){for(var t in e)if(e.hasOwnProperty(t))return!1;return!0}return!1}var s;s="function"==typeof String.prototype.trimLeft?function(e){return e.trimLeft()}:function(e){return e.match(/^\s*(.*)/)[1]};var c=0,o=1,h=2,a=3,t=4,i=6,l=8,d=9,u="UnquotedIdentifier",f="QuotedIdentifier",p="Rbracket",m="Rparen",g="Comma",v="Colon",y="Rbrace",w="Number",B="Current",T="Expref",L="Pipe",R="GTE",P="LTE",O="Flatten",b="Star",C="Filter",E="Dot",A="Lbrace",x="Lbracket",F="Lparen",S="Literal",M={".":E,"*":b,",":g,":":v,"{":A,"}":y,"]":p,"(":F,")":m,"@":B},I={"<":!0,">":!0,"=":!0,"!":!0},N={" ":!0,"\t":!0,"\n":!0};function j(e){return"0"<=e&&e<="9"||"-"===e}function n(){}n.prototype={tokenize:function(e){var t,i,n,r,o=[];for(this._current=0;this._current<e.length;)if("a"<=(r=e[this._current])&&r<="z"||"A"<=r&&r<="Z"||"_"===r)t=this._current,i=this._consumeUnquotedIdentifier(e),o.push({type:u,value:i,start:t});else if(void 0!==M[e[this._current]])o.push({type:M[e[this._current]],value:e[this._current],start:this._current}),this._current++;else if(j(e[this._current]))n=this._consumeNumber(e),o.push(n);else if("["===e[this._current])n=this._consumeLBracket(e),o.push(n);else if('"'===e[this._current])t=this._current,i=this._consumeQuotedIdentifier(e),o.push({type:f,value:i,start:t});else if("'"===e[this._current])t=this._current,i=this._consumeRawStringLiteral(e),o.push({type:S,value:i,start:t});else if("`"===e[this._current]){t=this._current;var s=this._consumeLiteral(e);o.push({type:S,value:s,start:t})}else if(void 0!==I[e[this._current]])o.push(this._consumeOperator(e));else if(void 0!==N[e[this._current]])this._current++;else if("&"===e[this._current])t=this._current,this._current++,"&"===e[this._current]?(this._current++,o.push({type:"And",value:"&&",start:t})):o.push({type:T,value:"&",start:t});else{if("|"!==e[this._current]){var a=new Error("Unknown character:"+e[this._current]);throw a.name="LexerError",a}t=this._current,this._current++,"|"===e[this._current]?(this._current++,o.push({type:"Or",value:"||",start:t})):o.push({type:L,value:"|",start:t})}return o},_consumeUnquotedIdentifier:function(e){var t,i=this._current;for(this._current++;this._current<e.length&&("a"<=(t=e[this._current])&&t<="z"||"A"<=t&&t<="Z"||"0"<=t&&t<="9"||"_"===t);)this._current++;return e.slice(i,this._current)},_consumeQuotedIdentifier:function(e){var t=this._current;this._current++;for(var i=e.length;'"'!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&'"'!==e[n+1]?n++:n+=2,this._current=n}return this._current++,JSON.parse(e.slice(t,this._current))},_consumeRawStringLiteral:function(e){var t=this._current;this._current++;for(var i=e.length;"'"!==e[this._current]&&this._current<i;){var n=this._current;"\\"!==e[n]||"\\"!==e[n+1]&&"'"!==e[n+1]?n++:n+=2,this._current=n}return this._current++,e.slice(t+1,this._current-1).replace("\\'","'")},_consumeNumber:function(e){var t=this._current;this._current++;for(var i=e.length;j(e[this._current])&&this._current<i;)this._current++;var n=parseInt(e.slice(t,this._current));return{type:w,value:n,start:t}},_consumeLBracket:function(e){var t=this._current;return this._current++,"?"===e[this._current]?(this._current++,{type:C,value:"[?",start:t}):"]"===e[this._current]?(this._current++,{type:O,value:"[]",start:t}):{type:x,value:"[",start:t}},_consumeOperator:function(e){var t=this._current,i=e[t];return this._current++,"!"===i?"="===e[this._current]?(this._current++,{type:"NE",value:"!=",start:t}):{type:"Not",value:"!",start:t}:"<"===i?"="===e[this._current]?(this._current++,{type:P,value:"<=",start:t}):{type:"LT",value:"<",start:t}:">"===i?"="===e[this._current]?(this._current++,{type:R,value:">=",start:t}):{type:"GT",value:">",start:t}:"="===i&&"="===e[this._current]?(this._current++,{type:"EQ",value:"==",start:t}):void 0},_consumeLiteral:function(e){this._current++;for(var t,i=this._current,n=e.length;"`"!==e[this._current]&&this._current<n;){var r=this._current;"\\"!==e[r]||"\\"!==e[r+1]&&"`"!==e[r+1]?r++:r+=2,this._current=r}var o=s(e.slice(i,this._current));return o=o.replace("\\`","`"),t=this._looksLikeJSON(o)?JSON.parse(o):JSON.parse('"'+o+'"'),this._current++,t},_looksLikeJSON:function(e){if(""===e)return!1;if(0<='[{"'.indexOf(e[0]))return!0;if(0<=["true","false","null"].indexOf(e))return!0;if(!(0<="-0123456789".indexOf(e[0])))return!1;try{return JSON.parse(e),!0}catch(e){return!1}}};var H={};function V(){}function W(e){this.runtime=e}function z(e){this._interpreter=e,this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[c]}]},avg:{_func:this._functionAvg,_signature:[{types:[l]}]},ceil:{_func:this._functionCeil,_signature:[{types:[c]}]},contains:{_func:this._functionContains,_signature:[{types:[h,a]},{types:[o]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[h]},{types:[h]}]},floor:{_func:this._functionFloor,_signature:[{types:[c]}]},length:{_func:this._functionLength,_signature:[{types:[h,a,t]}]},map:{_func:this._functionMap,_signature:[{types:[i]},{types:[a]}]},max:{_func:this._functionMax,_signature:[{types:[l,d]}]},merge:{_func:this._functionMerge,_signature:[{types:[t],variadic:!0}]},max_by:{_func:this._functionMaxBy,_signature:[{types:[a]},{types:[i]}]},sum:{_func:this._functionSum,_signature:[{types:[l]}]},starts_with:{_func:this._functionStartsWith,_signature:[{types:[h]},{types:[h]}]},min:{_func:this._functionMin,_signature:[{types:[l,d]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[a]},{types:[i]}]},type:{_func:this._functionType,_signature:[{types:[o]}]},keys:{_func:this._functionKeys,_signature:[{types:[t]}]},values:{_func:this._functionValues,_signature:[{types:[t]}]},sort:{_func:this._functionSort,_signature:[{types:[d,l]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[a]},{types:[i]}]},join:{_func:this._functionJoin,_signature:[{types:[h]},{types:[d]}]},reverse:{_func:this._functionReverse,_signature:[{types:[h,a]}]},to_array:{_func:this._functionToArray,_signature:[{types:[o]}]},to_string:{_func:this._functionToString,_signature:[{types:[o]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[o]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[o],variadic:!0}]}}}H.EOF=0,H[u]=0,H[f]=0,H[p]=0,H[m]=0,H[g]=0,H[y]=0,H[w]=0,H[B]=0,H[T]=0,H[L]=1,H.Or=2,H.And=3,H.EQ=5,H.GT=5,H.LT=5,H.GTE=5,H.LTE=5,H.NE=5,H[O]=9,H[b]=20,H[C]=21,H.Dot=40,H.Not=45,H[A]=50,H[x]=55,H[F]=60,V.prototype={parse:function(e){this._loadTokens(e),this.index=0;var t=this.expression(0);if("EOF"===this._lookahead(0))return t;var i=this._lookaheadToken(0),n=new Error("Unexpected token type: "+i.type+", value: "+i.value);throw n.name="ParserError",n},_loadTokens:function(e){var t=(new n).tokenize(e);t.push({type:"EOF",value:"",start:e.length}),this.tokens=t},expression:function(e){var t=this._lookaheadToken(0);this._advance();for(var i=this.nud(t),n=this._lookahead(0);e<H[n];)this._advance(),i=this.led(n,i),n=this._lookahead(0);return i},_lookahead:function(e){return this.tokens[this.index+e].type},_lookaheadToken:function(e){return this.tokens[this.index+e]},_advance:function(){this.index++},nud:function(e){var t,i;switch(e.type){case S:return{type:"Literal",value:e.value};case u:return{type:"Field",name:e.value};case f:var n={type:"Field",name:e.value};if(this._lookahead(0)===F)throw new Error("Quoted identifier not allowed for function names.");return n;case"Not":return{type:"NotExpression",children:[t=this.expression(H.Not)]};case b:return t=null,{type:"ValueProjection",children:[{type:"Identity"},t=this._lookahead(0)===p?{type:"Identity"}:this._parseProjectionRHS(H.Star)]};case C:return this.led(e.type,{type:"Identity"});case A:return this._parseMultiselectHash();case O:return{type:"Projection",children:[{type:O,children:[{type:"Identity"}]},t=this._parseProjectionRHS(H.Flatten)]};case x:return this._lookahead(0)===w||this._lookahead(0)===v?(t=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},t)):this._lookahead(0)===b&&this._lookahead(1)===p?(this._advance(),this._advance(),{type:"Projection",children:[{type:"Identity"},t=this._parseProjectionRHS(H.Star)]}):this._parseMultiselectList();case B:return{type:B};case T:return{type:"ExpressionReference",children:[i=this.expression(H.Expref)]};case F:for(var r=[];this._lookahead(0)!==m;)this._lookahead(0)===B?(i={type:B},this._advance()):i=this.expression(0),r.push(i);return this._match(m),r[0];default:this._errorToken(e)}},led:function(e,t){var i;switch(e){case E:var n=H.Dot;return this._lookahead(0)!==b?{type:"Subexpression",children:[t,i=this._parseDotRHS(n)]}:(this._advance(),{type:"ValueProjection",children:[t,i=this._parseProjectionRHS(n)]});case L:return i=this.expression(H.Pipe),{type:L,children:[t,i]};case"Or":return{type:"OrExpression",children:[t,i=this.expression(H.Or)]};case"And":return{type:"AndExpression",children:[t,i=this.expression(H.And)]};case F:for(var r,o=t.name,s=[];this._lookahead(0)!==m;)this._lookahead(0)===B?(r={type:B},this._advance()):r=this.expression(0),this._lookahead(0)===g&&this._match(g),s.push(r);return this._match(m),{type:"Function",name:o,children:s};case C:var a=this.expression(0);return this._match(p),{type:"FilterProjection",children:[t,i=this._lookahead(0)===O?{type:"Identity"}:this._parseProjectionRHS(H.Filter),a]};case O:return{type:"Projection",children:[{type:O,children:[t]},this._parseProjectionRHS(H.Flatten)]};case"EQ":case"NE":case"GT":case R:case"LT":case P:return this._parseComparator(t,e);case x:var l=this._lookaheadToken(0);return l.type===w||l.type===v?(i=this._parseIndexExpression(),this._projectIfSlice(t,i)):(this._match(b),this._match(p),{type:"Projection",children:[t,i=this._parseProjectionRHS(H.Star)]});default:this._errorToken(this._lookaheadToken(0))}},_match:function(e){if(this._lookahead(0)!==e){var t=this._lookaheadToken(0),i=new Error("Expected "+e+", got: "+t.type);throw i.name="ParserError",i}this._advance()},_errorToken:function(e){var t=new Error("Invalid token ("+e.type+'): "'+e.value+'"');throw t.name="ParserError",t},_parseIndexExpression:function(){if(this._lookahead(0)===v||this._lookahead(1)===v)return this._parseSliceExpression();var e={type:"Index",value:this._lookaheadToken(0).value};return this._advance(),this._match(p),e},_projectIfSlice:function(e,t){var i={type:"IndexExpression",children:[e,t]};return"Slice"===t.type?{type:"Projection",children:[i,this._parseProjectionRHS(H.Star)]}:i},_parseSliceExpression:function(){for(var e=[null,null,null],t=0,i=this._lookahead(0);i!==p&&t<3;){if(i===v)t++,this._advance();else{if(i!==w){var n=this._lookahead(0),r=new Error("Syntax error, unexpected token: "+n.value+"("+n.type+")");throw r.name="Parsererror",r}e[t]=this._lookaheadToken(0).value,this._advance()}i=this._lookahead(0)}return this._match(p),{type:"Slice",children:e}},_parseComparator:function(e,t){return{type:"Comparator",name:t,children:[e,this.expression(H[t])]}},_parseDotRHS:function(e){var t=this._lookahead(0);return 0<=[u,f,b].indexOf(t)?this.expression(e):t===x?(this._match(x),this._parseMultiselectList()):t===A?(this._match(A),this._parseMultiselectHash()):void 0},_parseProjectionRHS:function(e){var t;if(H[this._lookahead(0)]<10)t={type:"Identity"};else if(this._lookahead(0)===x)t=this.expression(e);else if(this._lookahead(0)===C)t=this.expression(e);else{if(this._lookahead(0)!==E){var i=this._lookaheadToken(0),n=new Error("Sytanx error, unexpected token: "+i.value+"("+i.type+")");throw n.name="ParserError",n}this._match(E),t=this._parseDotRHS(e)}return t},_parseMultiselectList:function(){for(var e=[];this._lookahead(0)!==p;){var t=this.expression(0);if(e.push(t),this._lookahead(0)===g&&(this._match(g),this._lookahead(0)===p))throw new Error("Unexpected token Rbracket")}return this._match(p),{type:"MultiSelectList",children:e}},_parseMultiselectHash:function(){for(var e,t,i,n=[],r=[u,f];;){if(e=this._lookaheadToken(0),r.indexOf(e.type)<0)throw new Error("Expecting an identifier token, got: "+e.type);if(t=e.value,this._advance(),this._match(v),i={type:"KeyValuePair",name:t,value:this.expression(0)},n.push(i),this._lookahead(0)===g)this._match(g);else if(this._lookahead(0)===y){this._match(y);break}}return{type:"MultiSelectHash",children:n}}},W.prototype={search:function(e,t){return this.visit(e,t)},visit:function(e,t){var i,n,r,o,s,a,l,c,h;switch(e.type){case"Field":return null===t?null:k(t)?void 0===(a=t[e.name])?null:a:null;case"Subexpression":for(r=this.visit(e.children[0],t),h=1;h<e.children.length;h++)if(null===(r=this.visit(e.children[1],r)))return null;return r;case"IndexExpression":return l=this.visit(e.children[0],t),this.visit(e.children[1],l);case"Index":if(!_(t))return null;var d=e.value;return d<0&&(d=t.length+d),void 0===(r=t[d])&&(r=null),r;case"Slice":if(!_(t))return null;var u=e.children.slice(0),f=this.computeSliceParams(t.length,u),p=f[0],m=f[1],g=f[2];if(r=[],0<g)for(h=p;h<m;h+=g)r.push(t[h]);else for(h=p;m<h;h+=g)r.push(t[h]);return r;case"Projection":var v=this.visit(e.children[0],t);if(!_(v))return null;for(c=[],h=0;h<v.length;h++)null!==(n=this.visit(e.children[1],v[h]))&&c.push(n);return c;case"ValueProjection":if(!k(v=this.visit(e.children[0],t)))return null;c=[];var y=function(e){for(var t=Object.keys(e),i=[],n=0;n<t.length;n++)i.push(e[t[n]]);return i}(v);for(h=0;h<y.length;h++)null!==(n=this.visit(e.children[1],y[h]))&&c.push(n);return c;case"FilterProjection":if(!_(v=this.visit(e.children[0],t)))return null;var w=[],b=[];for(h=0;h<v.length;h++)$(i=this.visit(e.children[2],v[h]))||w.push(v[h]);for(var C=0;C<w.length;C++)null!==(n=this.visit(e.children[1],w[C]))&&b.push(n);return b;case"Comparator":switch(o=this.visit(e.children[0],t),s=this.visit(e.children[1],t),e.name){case"EQ":r=D(o,s);break;case"NE":r=!D(o,s);break;case"GT":r=s<o;break;case R:r=s<=o;break;case"LT":r=o<s;break;case P:r=o<=s;break;default:throw new Error("Unknown comparator: "+e.name)}return r;case O:var E=this.visit(e.children[0],t);if(!_(E))return null;var A=[];for(h=0;h<E.length;h++)_(n=E[h])?A.push.apply(A,n):A.push(n);return A;case"Identity":return t;case"MultiSelectList":if(null===t)return null;for(c=[],h=0;h<e.children.length;h++)c.push(this.visit(e.children[h],t));return c;case"MultiSelectHash":if(null===t)return null;var x;for(c={},h=0;h<e.children.length;h++)c[(x=e.children[h]).name]=this.visit(x.value,t);return c;case"OrExpression":return $(i=this.visit(e.children[0],t))&&(i=this.visit(e.children[1],t)),i;case"AndExpression":return!0===$(o=this.visit(e.children[0],t))?o:this.visit(e.children[1],t);case"NotExpression":return $(o=this.visit(e.children[0],t));case"Literal":return e.value;case L:return l=this.visit(e.children[0],t),this.visit(e.children[1],l);case B:return t;case"Function":var F=[];for(h=0;h<e.children.length;h++)F.push(this.visit(e.children[h],t));return this.runtime.callFunction(e.name,F);case"ExpressionReference":var S=e.children[0];return S.jmespathType=T,S;default:throw new Error("Unknown node type: "+e.type)}},computeSliceParams:function(e,t){var i=t[0],n=t[1],r=t[2],o=[null,null,null];if(null===r)r=1;else if(0===r){var s=new Error("Invalid slice, step cannot be 0");throw s.name="RuntimeError",s}var a=r<0;return i=null===i?a?e-1:0:this.capSliceRange(e,i,r),n=null===n?a?-1:e:this.capSliceRange(e,n,r),o[0]=i,o[1]=n,o[2]=r,o},capSliceRange:function(e,t,i){return t<0?(t+=e)<0&&(t=i<0?-1:0):e<=t&&(t=i<0?e-1:e),t}},z.prototype={callFunction:function(e,t){var i=this.functionTable[e];if(void 0===i)throw new Error("Unknown function: "+e+"()");return this._validateArgs(e,t,i._signature),i._func.call(this,t)},_validateArgs:function(e,t,i){var n,r,o,s;if(i[i.length-1].variadic){if(t.length<i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes at least"+i.length+n+" but received "+t.length)}else if(t.length!==i.length)throw n=1===i.length?" argument":" arguments",new Error("ArgumentError: "+e+"() takes "+i.length+n+" but received "+t.length);for(var a=0;a<i.length;a++){s=!1,r=i[a].types,o=this._getTypeName(t[a]);for(var l=0;l<r.length;l++)if(this._typeMatches(o,r[l],t[a])){s=!0;break}if(!s)throw new Error("TypeError: "+e+"() expected argument "+(a+1)+" to be type "+r+" but received type "+o+" instead.")}},_typeMatches:function(e,t,i){if(t===o)return!0;if(t!==d&&t!==l&&t!==a)return e===t;if(t===a)return e===a;if(e===a){var n;t===l?n=c:t===d&&(n=h);for(var r=0;r<i.length;r++)if(!this._typeMatches(this._getTypeName(i[r]),n,i[r]))return!1;return!0}},_getTypeName:function(e){switch(Object.prototype.toString.call(e)){case"[object String]":return h;case"[object Number]":return c;case"[object Array]":return a;case"[object Boolean]":return 5;case"[object Null]":return 7;case"[object Object]":return e.jmespathType===T?i:t}},_functionStartsWith:function(e){return 0===e[0].lastIndexOf(e[1])},_functionEndsWith:function(e){var t=e[0],i=e[1];return-1!==t.indexOf(i,t.length-i.length)},_functionReverse:function(e){if(this._getTypeName(e[0])===h){for(var t=e[0],i="",n=t.length-1;0<=n;n--)i+=t[n];return i}var r=e[0].slice(0);return r.reverse(),r},_functionAbs:function(e){return Math.abs(e[0])},_functionCeil:function(e){return Math.ceil(e[0])},_functionAvg:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t/i.length},_functionContains:function(e){return 0<=e[0].indexOf(e[1])},_functionFloor:function(e){return Math.floor(e[0])},_functionLength:function(e){return k(e[0])?Object.keys(e[0]).length:e[0].length},_functionMap:function(e){for(var t=[],i=this._interpreter,n=e[0],r=e[1],o=0;o<r.length;o++)t.push(i.visit(n,r[o]));return t},_functionMerge:function(e){for(var t={},i=0;i<e.length;i++){var n=e[i];for(var r in n)t[r]=n[r]}return t},_functionMax:function(e){if(0<e[0].length){if(this._getTypeName(e[0][0])===c)return Math.max.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)i.localeCompare(t[n])<0&&(i=t[n]);return i}return null},_functionMin:function(e){if(0<e[0].length){if(this._getTypeName(e[0][0])===c)return Math.min.apply(Math,e[0]);for(var t=e[0],i=t[0],n=1;n<t.length;n++)t[n].localeCompare(i)<0&&(i=t[n]);return i}return null},_functionSum:function(e){for(var t=0,i=e[0],n=0;n<i.length;n++)t+=i[n];return t},_functionType:function(e){switch(this._getTypeName(e[0])){case c:return"number";case h:return"string";case a:return"array";case t:return"object";case 5:return"boolean";case i:return"expref";case 7:return"null"}},_functionKeys:function(e){return Object.keys(e[0])},_functionValues:function(e){for(var t=e[0],i=Object.keys(t),n=[],r=0;r<i.length;r++)n.push(t[i[r]]);return n},_functionJoin:function(e){var t=e[0];return e[1].join(t)},_functionToArray:function(e){return this._getTypeName(e[0])===a?e[0]:[e[0]]},_functionToString:function(e){return this._getTypeName(e[0])===h?e[0]:JSON.stringify(e[0])},_functionToNumber:function(e){var t,i=this._getTypeName(e[0]);return i===c?e[0]:i!==h||(t=+e[0],isNaN(t))?null:t},_functionNotNull:function(e){for(var t=0;t<e.length;t++)if(7!==this._getTypeName(e[t]))return e[t];return null},_functionSort:function(e){var t=e[0].slice(0);return t.sort(),t},_functionSortBy:function(e){var t=e[0].slice(0);if(0===t.length)return t;var r=this._interpreter,o=e[1],s=this._getTypeName(r.visit(o,t[0]));if([c,h].indexOf(s)<0)throw new Error("TypeError");for(var a=this,i=[],n=0;n<t.length;n++)i.push([n,t[n]]);i.sort(function(e,t){var i=r.visit(o,e[1]),n=r.visit(o,t[1]);if(a._getTypeName(i)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(i));if(a._getTypeName(n)!==s)throw new Error("TypeError: expected "+s+", received "+a._getTypeName(n));return n<i?1:i<n?-1:e[0]-t[0]});for(var l=0;l<i.length;l++)t[l]=i[l][1];return t},_functionMaxBy:function(e){for(var t,i,n=e[1],r=e[0],o=this.createKeyFunction(n,[c,h]),s=-1/0,a=0;a<r.length;a++)s<(i=o(r[a]))&&(s=i,t=r[a]);return t},_functionMinBy:function(e){for(var t,i,n=e[1],r=e[0],o=this.createKeyFunction(n,[c,h]),s=1/0,a=0;a<r.length;a++)(i=o(r[a]))<s&&(s=i,t=r[a]);return t},createKeyFunction:function(n,r){var o=this,s=this._interpreter;return function(e){var t=s.visit(n,e);if(r.indexOf(o._getTypeName(t))<0){var i="TypeError: expected one of "+r+", received "+o._getTypeName(t);throw new Error(i)}return t}}},e.tokenize=function(e){return(new n).tokenize(e)},e.compile=function(e){return(new V).parse(e)},e.search=function(e,t){var i=new V,n=new z,r=new W(n);n._interpreter=r;var o=i.parse(t);return r.search(o,e)},e.strictDeepEqual=D}(t)},function(e,t,i){"use strict";var m=i(32),g=i(7),v=i(3),l=i(12),n=i(34);function c(e,t,i){var n=this._refs[i];if("string"==typeof n){if(!this._refs[n])return c.call(this,e,t,n);n=this._refs[n]}if((n=n||this._schemas[i])instanceof l)return u(n.schema,this._opts.inlineRefs)?n.schema:n.validate||this._compile(n);var r,o,s,a=h.call(this,t,i);return a&&(r=a.schema,t=a.root,s=a.baseId),r instanceof l?o=r.validate||e.call(this,r.schema,t,void 0,s):void 0!==r&&(o=u(r,this._opts.inlineRefs)?r:e.call(this,r,t,void 0,s)),o}function h(e,t){var i=m.parse(t),n=f(i),r=y(this._getId(e.schema));if(0===Object.keys(e.schema).length||n!==r){var o=w(n),s=this._refs[o];if("string"==typeof s)return function(e,t,i){var n=h.call(this,e,t);if(n){var r=n.schema,o=n.baseId;e=n.root;var s=this._getId(r);return s&&(o=p(o,s)),a.call(this,i,o,r,e)}}.call(this,e,s,i);if(s instanceof l)s.validate||this._compile(s),e=s;else{if(!((s=this._schemas[o])instanceof l))return;if(s.validate||this._compile(s),o==w(t))return{schema:s,root:e,baseId:r};e=s}if(!e.schema)return;r=y(this._getId(e.schema))}return a.call(this,i,r,e.schema,e)}(e.exports=c).normalizeId=w,c.fullPath=y,c.url=p,c.ids=function(e){var t=w(this._getId(e)),d={"":t},u={"":y(t,!1)},f={},p=this;return n(e,{allKeys:!0},function(e,t,i,n,r,o,s){if(""!==t){var a=p._getId(e),l=d[n],c=u[n]+"/"+r;if(void 0!==s&&(c+="/"+("number"==typeof s?s:v.escapeFragment(s))),"string"==typeof a){a=l=w(l?m.resolve(l,a):a);var h=p._refs[a];if("string"==typeof h&&(h=p._refs[h]),h&&h.schema){if(!g(e,h.schema))throw new Error('id "'+a+'" resolves to more than one schema')}else if(a!=w(c))if("#"==a[0]){if(f[a]&&!g(e,f[a]))throw new Error('id "'+a+'" resolves to more than one schema');f[a]=e}else p._refs[a]=c}d[t]=l,u[t]=c}}),f},c.inlineRef=u,c.schema=h;var d=v.toHash(["properties","patternProperties","enum","dependencies","definitions"]);function a(e,t,i,n){if(e.fragment=e.fragment||"","/"==e.fragment.slice(0,1)){for(var r=e.fragment.split("/"),o=1;o<r.length;o++){var s=r[o];if(s){if(void 0===(i=i[s=v.unescapeFragment(s)]))break;var a;if(!d[s]&&((a=this._getId(i))&&(t=p(t,a)),i.$ref)){var l=p(t,i.$ref),c=h.call(this,n,l);c&&(i=c.schema,n=c.root,t=c.baseId)}}}return void 0!==i&&i!==n.schema?{schema:i,root:n,baseId:t}:void 0}}var s=v.toHash(["type","format","pattern","maxLength","minLength","maxProperties","minProperties","maxItems","minItems","maximum","minimum","uniqueItems","multipleOf","required","enum"]);function u(e,t){return!1!==t&&(void 0===t||!0===t?function e(t){var i;if(Array.isArray(t)){for(var n=0;n<t.length;n++)if("object"==typeof(i=t[n])&&!e(i))return!1}else for(var r in t){if("$ref"==r)return!1;if("object"==typeof(i=t[r])&&!e(i))return!1}return!0}(e):t?function e(t){var i,n=0;if(Array.isArray(t)){for(var r=0;r<t.length;r++)if("object"==typeof(i=t[r])&&(n+=e(i)),n==1/0)return 1/0}else for(var o in t){if("$ref"==o)return 1/0;if(s[o])n++;else if("object"==typeof(i=t[o])&&(n+=e(i)+1),n==1/0)return 1/0}return n}(e)<=t:void 0)}function y(e,t){return!1!==t&&(e=w(e)),f(m.parse(e))}function f(e){return m.serialize(e).split("#")[0]+"#"}var r=/#\/?$/;function w(e){return e?e.replace(r,""):""}function p(e,t){return t=w(t),m.resolve(e,t)}},function(e,t,i){"use strict";var f=Array.isArray,p=Object.keys,m=Object.prototype.hasOwnProperty;e.exports=function e(t,i){if(t===i)return!0;if(t&&i&&"object"==typeof t&&"object"==typeof i){var n,r,o,s=f(t),a=f(i);if(s&&a){if((r=t.length)!=i.length)return!1;for(n=r;0!=n--;)if(!e(t[n],i[n]))return!1;return!0}if(s!=a)return!1;var l=t instanceof Date,c=i instanceof Date;if(l!=c)return!1;if(l&&c)return t.getTime()==i.getTime();var h=t instanceof RegExp,d=i instanceof RegExp;if(h!=d)return!1;if(h&&d)return t.toString()==i.toString();var u=p(t);if((r=u.length)!==p(i).length)return!1;for(n=r;0!=n--;)if(!m.call(i,u[n]))return!1;for(n=r;0!=n--;)if(!e(t[o=u[n]],i[o]))return!1;return!0}return t!=t&&i!=i}},function(e,t,i){"use strict";var n=i(6);function r(e,t,i){this.message=i||r.message(e,t),this.missingRef=n.url(e,t),this.missingSchema=n.normalizeId(n.fullPath(this.missingRef))}function o(e){return e.prototype=Object.create(Error.prototype),e.prototype.constructor=e}e.exports={Validation:o(function(e){this.message="validation failed",this.errors=e,this.ajv=this.validation=!0}),MissingRef:o(r)},r.message=function(e,t){return"can't resolve reference "+t+" from id "+e}},function(e,t,i){var r=i(26),o=i(1).translate,h=i(0);e.exports=function(e,t,s,i){var a=Array.isArray(t)?h.getChildPaths(t):[""],l=i&&i.path&&h.contains(a,i.path)?i.path:a[0],c=i&&i.direction||"asc",n='<div class="pico-modal-contents"><div class="pico-modal-header">'+o("sort")+"</div><form><table><tbody><tr>  <td>"+o("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+o("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+o("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+o("sortAscending")+'" title="'+o("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+o("sortDescending")+'" title="'+o("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+o("ok")+'" /></td></tr></tbody></table></form></div>';r({parent:e,content:n,overlayClass:"jsoneditor-modal-overlay",modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(t){var e=t.modalElem().querySelector("form"),i=t.modalElem().querySelector("#ok"),n=t.modalElem().querySelector("#field"),r=t.modalElem().querySelector("#direction");function o(e){r.value=e,r.className="jsoneditor-button-group jsoneditor-button-group-value-"+r.value}a.forEach(function(e){var t=document.createElement("option");t.text=function(e){return""===e?"@":"."===e[0]?e.slice(1):e}(e),t.value=e,n.appendChild(t)}),n.value=l||a[0],o(c||"asc"),r.onclick=function(e){o(e.target.getAttribute("data-value"))},i.onclick=function(e){e.preventDefault(),e.stopPropagation(),t.close(),s({path:n.value,direction:r.value})},e&&(e.onsubmit=i.onclick)}).afterClose(function(e){e.destroy()}).show()}},function(e,t,i){var F=i(5),n=i(26),S=i(79),r=i(1).translate,_=i(80).stringifyPartial,k=i(0),D=i(2).MAX_PREVIEW_CHARACTERS,$=k.debounce;e.exports=function(e,E,A){var x=E,t='<label class="pico-modal-contents"><div class="pico-modal-header">'+r("transform")+'</div><p>Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.</p><div class="jsoneditor-jmespath-label">'+r("transformWizardLabel")+' </div><div id="wizard" class="jsoneditor-jmespath-block jsoneditor-jmespath-wizard">  <table class="jsoneditor-jmespath-wizard-table">    <tbody>      <tr>        <th>'+r("transformWizardFilter")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >            <select id="filterField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >            <select id="filterRelation">              <option value="==">==</option>              <option value="!=">!=</option>              <option value="<">&lt;</option>              <option value="<=">&lt;=</option>              <option value=">">&gt;</option>              <option value=">=">&gt;=</option>            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >            <input placeholder="value..." id="filterValue" />          </div>        </td>      </tr>      <tr>        <th>'+r("transformWizardSortBy")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">            <select id="sortField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >            <select id="sortOrder">              <option value="asc">Ascending</option>              <option value="desc">Descending</option>            </select>          </div>        </td>      </tr>      <tr id="selectFieldsPart">        <th>'+r("transformWizardSelectFields")+'</th>        <td class="jsoneditor-jmespath-filter">          <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple></select>        </td>      </tr>    </tbody>  </table></div><div class="jsoneditor-jmespath-label">'+r("transformQueryLabel"
)+' </div><div class="jsoneditor-jmespath-block">  <textarea id="query"             rows="4"             autocomplete="off"             autocorrect="off"             autocapitalize="off"             spellcheck="false"            title="'+r("transformQueryTitle")+'">[*]</textarea></div><div class="jsoneditor-jmespath-label">'+r("transformPreviewLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="preview"       class="jsoneditor-transform-preview"      readonly> </textarea></div><div class="jsoneditor-jmespath-block jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+r("ok")+'" autofocus /></div></div>';n({parent:e,content:t,overlayClass:"jsoneditor-modal-overlay",modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(t){var e=t.modalElem(),i=e.querySelector("#wizard"),n=e.querySelector("#ok"),a=e.querySelector("#filterField"),l=e.querySelector("#filterRelation"),c=e.querySelector("#filterValue"),h=e.querySelector("#sortField"),d=e.querySelector("#sortOrder"),u=e.querySelector("#selectFields"),f=e.querySelector("#query"),r=e.querySelector("#preview");Array.isArray(x)||(i.style.fontStyle="italic",i.innerHTML="(wizard not available for objects, only for arrays)"),k.getChildPaths(E).forEach(function(e){var t=w(e),i=document.createElement("option");i.text=t,i.value=t,a.appendChild(i);var n=document.createElement("option");n.text=t,n.value=t,h.appendChild(n)});var o=k.getChildPaths(E,!0).filter(function(e){return""!==e});if(0<o.length)o.forEach(function(e){var t=w(e),i=document.createElement("option");i.text=t,i.value=t,u.appendChild(i)});else{var s=e.querySelector("#selectFieldsPart");s&&(s.style.display="none")}var p=new S(a,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),m=new S(l,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),g=new S(h,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),v=new S(d,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),y=new S(u,{multiple:!0,clearable:!0,defaultSelected:!1,placeholder:"select fields..."});function w(e){return""===e?"@":"."===e[0]?e.slice(1):e}function b(){if(a.value&&l.value&&c.value){var e=a.value,t="@"!==e?["0"].concat(k.parsePath("."+e)):["0"],i="string"==typeof k.get(x,t)?c.value:k.parseString(c.value);f.value="[? "+e+" "+l.value+" `"+JSON.stringify(i)+"`]"}else f.value="[*]";if(h.value&&d.value){var n=h.value;"desc"===d.value?f.value+=" | reverse(sort_by(@, &"+n+"))":f.value+=" | sort_by(@, &"+n+")"}if(u.value){for(var r=[],o=0;o<u.options.length;o++)if(u.options[o].selected){var s=u.options[o].value;r.push(s)}"]"!==f.value[f.value.length-1]&&(f.value+=" | [*]"),1===r.length?f.value+="."+r[0]:1<r.length&&(f.value+=".{"+r.map(function(e){var t=e.split(".");return t[t.length-1]+": "+e}).join(", ")+"}")}C()}p.on("selectr.change",b),m.on("selectr.change",b),c.oninput=b,g.on("selectr.change",b),v.on("selectr.change",b),y.on("selectr.change",b),e.querySelector(".pico-modal-contents").onclick=function(e){"A"!==e.target.nodeName&&e.preventDefault()},f.value=Array.isArray(x)?"[*]":"@";var C=$(function(){try{var e=F.search(x,f.value);r.className="jsoneditor-transform-preview",r.value=_(e,2,D),n.disabled=!1}catch(e){r.className="jsoneditor-transform-preview jsoneditor-error",r.value=e.toString(),n.disabled=!0}},300);(f.oninput=C)(),n.onclick=function(e){e.preventDefault(),e.stopPropagation(),t.close(),A(f.value)},setTimeout(function(){f.select(),f.focus(),f.selectionStart=3,f.selectionEnd=3})}).afterClose(function(e){e.destroy()}).show()}},function(e,t,i){"use strict";var f=i(4),p=i(1).translate;function n(e,t,i,n){for(var r={code:{text:p("modeCodeText"),title:p("modeCodeTitle"),click:function(){n("code")}},form:{text:p("modeFormText"),title:p("modeFormTitle"),click:function(){n("form")}},text:{text:p("modeTextText"),title:p("modeTextTitle"),click:function(){n("text")}},tree:{text:p("modeTreeText"),title:p("modeTreeTitle"),click:function(){n("tree")}},view:{text:p("modeViewText"),title:p("modeViewTitle"),click:function(){n("view")}},preview:{text:p("modePreviewText"),title:p("modePreviewTitle"),click:function(){n("preview")}}},o=[],s=0;s<t.length;s++){var a=t[s],l=r[a];if(!l)throw new Error('Unknown mode "'+a+'"');l.className="jsoneditor-type-modes"+(i==a?" jsoneditor-selected":""),o.push(l)}var c=r[i];if(!c)throw new Error('Unknown mode "'+i+'"');var h=c.text,d=document.createElement("button");d.type="button",d.className="jsoneditor-modes jsoneditor-separator",d.innerHTML=h+" &#x25BE;",d.title="Switch editor mode",d.onclick=function(){new f(o).show(d,e)};var u=document.createElement("div");u.className="jsoneditor-modes",u.style.position="relative",u.appendChild(d),e.appendChild(u),this.dom={container:e,box:d,frame:u}}n.prototype.focus=function(){this.dom.box.focus()},n.prototype.destroy=function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null},e.exports=n},function(e,t,i){"use strict";var n=i(3);e.exports=function(e){n.copy(e,this)}},function(e,t,i){"use strict";e.exports=function(e,t){"function"==typeof(t=t||{})&&(t={cmp:t});var o,l="boolean"==typeof t.cycles&&t.cycles,c=t.cmp&&(o=t.cmp,function(r){return function(e,t){var i={key:e,value:r[e]},n={key:t,value:r[t]};return o(i,n)}}),h=[];return function e(t){if(t&&t.toJSON&&"function"==typeof t.toJSON&&(t=t.toJSON()),void 0!==t){if("number"==typeof t)return isFinite(t)?""+t:"null";if("object"!=typeof t)return JSON.stringify(t);var i,n;if(Array.isArray(t)){for(n="[",i=0;i<t.length;i++)i&&(n+=","),n+=e(t[i])||"null";return n+"]"}if(null===t)return"null";if(-1!==h.indexOf(t)){if(l)return JSON.stringify("__cycle__");throw new TypeError("Converting circular structure to JSON")}var r=h.push(t)-1,o=Object.keys(t).sort(c&&c(t));for(n="",i=0;i<o.length;i++){var s=o[i],a=e(t[s]);a&&(n&&(n+=","),n+=JSON.stringify(s)+":"+a)}return h.splice(r,1),"{"+n+"}"}}(e)}},function(e,t,i){"use strict";e.exports=function(n,e,t){var i="",r=!0===n.schema.$async,o=n.util.schemaHasRulesExcept(n.schema,n.RULES.all,"$ref"),s=n.self._getId(n.schema);if(n.opts.strictKeywords){var a=n.util.schemaUnknownRules(n.schema,n.RULES.keywords);if(a){var l="unknown keyword: "+a;if("log"!==n.opts.strictKeywords)throw new Error(l);n.logger.warn(l)}}if(n.isTop&&(i+=" var validate = ",r&&(n.async=!0,i+="async "),i+="function(data, dataPath, parentData, parentDataProperty, rootData) { 'use strict'; ",s&&(n.opts.sourceCode||n.opts.processCode)&&(i+=" /*# sourceURL="+s+" */ ")),"boolean"==typeof n.schema||!o&&!n.schema.$ref){e="false schema";var c=n.level,h=n.dataLevel,d=n.schema[e],u=n.schemaPath+n.util.getProperty(e),f=n.errSchemaPath+"/"+e,p=!n.opts.allErrors,m="data"+(h||""),g="valid"+c;if(!1===n.schema){n.isTop?p=!0:i+=" var "+g+" = false; ",(Y=Y||[]).push(i),i="",!1!==n.createErrors?(i+=" { keyword: 'false schema' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(f)+" , params: {} ",!1!==n.opts.messages&&(i+=" , message: 'boolean schema is false' "),n.opts.verbose&&(i+=" , schema: false , parentSchema: validate.schema"+n.schemaPath+" , data: "+m+" "),i+=" } "):i+=" {} ";var v=i;i=Y.pop(),!n.compositeRule&&p?n.async?i+=" throw new ValidationError(["+v+"]); ":i+=" validate.errors = ["+v+"]; return false; ":i+=" var err = "+v+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}else n.isTop?i+=r?" return data; ":" validate.errors = null; return true; ":i+=" var "+g+" = true; ";return n.isTop&&(i+=" }; return validate; "),i}if(n.isTop){var y=n.isTop;c=n.level=0,h=n.dataLevel=0,m="data";if(n.rootId=n.resolve.fullPath(n.self._getId(n.root.schema)),n.baseId=n.baseId||n.rootId,delete n.isTop,n.dataPathArr=[void 0],void 0!==n.schema.default&&n.opts.useDefaults&&n.opts.strictDefaults){var w="default is ignored in the schema root";if("log"!==n.opts.strictDefaults)throw new Error(w);n.logger.warn(w)}i+=" var vErrors = null; ",i+=" var errors = 0;     ",i+=" if (rootData === undefined) rootData = data; "}else{c=n.level,m="data"+((h=n.dataLevel)||"");if(s&&(n.baseId=n.resolve.url(n.baseId,s)),r&&!n.async)throw new Error("async schema in sync schema");i+=" var errs_"+c+" = errors;"}g="valid"+c,p=!n.opts.allErrors;var b="",C="",E=n.schema.type,A=Array.isArray(E);if(E&&n.opts.nullable&&!0===n.schema.nullable&&(A?-1==E.indexOf("null")&&(E=E.concat("null")):"null"!=E&&(E=[E,"null"],A=!0)),A&&1==E.length&&(E=E[0],A=!1),n.schema.$ref&&o){if("fail"==n.opts.extendRefs)throw new Error('$ref: validation keywords used in schema at path "'+n.errSchemaPath+'" (see option extendRefs)');!0!==n.opts.extendRefs&&(o=!1,n.logger.warn('$ref: keywords ignored in schema at path "'+n.errSchemaPath+'"'))}if(n.schema.$comment&&n.opts.$comment&&(i+=" "+n.RULES.all.$comment.code(n,"$comment")),E){if(n.opts.coerceTypes)var x=n.util.coerceToTypes(n.opts.coerceTypes,E);var F=n.RULES.types[E];if(x||A||!0===F||F&&!X(F)){u=n.schemaPath+".type",f=n.errSchemaPath+"/type",u=n.schemaPath+".type",f=n.errSchemaPath+"/type";var S=A?"checkDataTypes":"checkDataType";if(i+=" if ("+n.util[S](E,m,!0)+") { ",x){var _="dataType"+c,k="coerced"+c;i+=" var "+_+" = typeof "+m+"; ","array"==n.opts.coerceTypes&&(i+=" if ("+_+" == 'object' && Array.isArray("+m+")) "+_+" = 'array'; "),i+=" var "+k+" = undefined; ";var D="",$=x;if($)for(var B,T=-1,L=$.length-1;T<L;)B=$[T+=1],T&&(i+=" if ("+k+" === undefined) { ",D+="}"),"array"==n.opts.coerceTypes&&"array"!=B&&(i+=" if ("+_+" == 'array' && "+m+".length == 1) { "+k+" = "+m+" = "+m+"[0]; "+_+" = typeof "+m+";  } "),"string"==B?i+=" if ("+_+" == 'number' || "+_+" == 'boolean') "+k+" = '' + "+m+"; else if ("+m+" === null) "+k+" = ''; ":"number"==B||"integer"==B?(i+=" if ("+_+" == 'boolean' || "+m+" === null || ("+_+" == 'string' && "+m+" && "+m+" == +"+m+" ","integer"==B&&(i+=" && !("+m+" % 1)"),i+=")) "+k+" = +"+m+"; "):"boolean"==B?i+=" if ("+m+" === 'false' || "+m+" === 0 || "+m+" === null) "+k+" = false; else if ("+m+" === 'true' || "+m+" === 1) "+k+" = true; ":"null"==B?i+=" if ("+m+" === '' || "+m+" === 0 || "+m+" === false) "+k+" = null; ":"array"==n.opts.coerceTypes&&"array"==B&&(i+=" if ("+_+" == 'string' || "+_+" == 'number' || "+_+" == 'boolean' || "+m+" == null) "+k+" = ["+m+"]; ");(Y=Y||[]).push(i+=" "+D+" if ("+k+" === undefined) {   "),i="",!1!==n.createErrors?(i+=" { keyword: 'type' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(f)+" , params: { type: '",i+=A?""+E.join(","):""+E,i+="' } ",!1!==n.opts.messages&&(i+=" , message: 'should be ",i+=A?""+E.join(","):""+E,i+="' "),n.opts.verbose&&(i+=" , schema: validate.schema"+u+" , parentSchema: validate.schema"+n.schemaPath+" , data: "+m+" "),i+=" } "):i+=" {} ";v=i;i=Y.pop(),!n.compositeRule&&p?n.async?i+=" throw new ValidationError(["+v+"]); ":i+=" validate.errors = ["+v+"]; return false; ":i+=" var err = "+v+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } else {  ";var R=h?"data"+(h-1||""):"parentData";i+=" "+m+" = "+k+"; ",h||(i+="if ("+R+" !== undefined)"),i+=" "+R+"["+(h?n.dataPathArr[h]:"parentDataProperty")+"] = "+k+"; } "}else{(Y=Y||[]).push(i),i="",!1!==n.createErrors?(i+=" { keyword: 'type' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(f)+" , params: { type: '",i+=A?""+E.join(","):""+E,i+="' } ",!1!==n.opts.messages&&(i+=" , message: 'should be ",i+=A?""+E.join(","):""+E,i+="' "),n.opts.verbose&&(i+=" , schema: validate.schema"+u+" , parentSchema: validate.schema"+n.schemaPath+" , data: "+m+" "),i+=" } "):i+=" {} ";v=i;i=Y.pop(),!n.compositeRule&&p?n.async?i+=" throw new ValidationError(["+v+"]); ":i+=" validate.errors = ["+v+"]; return false; ":i+=" var err = "+v+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}i+=" } "}}if(n.schema.$ref&&!o)i+=" "+n.RULES.all.$ref.code(n,"$ref")+" ",p&&(i+=" } if (errors === ",i+=y?"0":"errs_"+c,i+=") { ",C+="}");else{var P=n.RULES;if(P)for(var O=-1,M=P.length-1;O<M;)if(X(F=P[O+=1])){if(F.type&&(i+=" if ("+n.util.checkDataType(F.type,m)+") { "),n.opts.useDefaults)if("object"==F.type&&n.schema.properties){d=n.schema.properties;var I=Object.keys(d);if(I)for(var N,j=-1,H=I.length-1;j<H;){if(void 0!==(z=d[N=I[j+=1]]).default){var V=m+n.util.getProperty(N);if(n.compositeRule){if(n.opts.strictDefaults){w="default is ignored for: "+V;if("log"!==n.opts.strictDefaults)throw new Error(w);n.logger.warn(w)}}else i+=" if ("+V+" === undefined ","empty"==n.opts.useDefaults&&(i+=" || "+V+" === null || "+V+" === '' "),i+=" ) "+V+" = ","shared"==n.opts.useDefaults?i+=" "+n.useDefault(z.default)+" ":i+=" "+JSON.stringify(z.default)+" ",i+="; "}}}else if("array"==F.type&&Array.isArray(n.schema.items)){var W=n.schema.items;if(W){T=-1;for(var z,U=W.length-1;T<U;)if(void 0!==(z=W[T+=1]).default){V=m+"["+T+"]";if(n.compositeRule){if(n.opts.strictDefaults){w="default is ignored for: "+V;if("log"!==n.opts.strictDefaults)throw new Error(w);n.logger.warn(w)}}else i+=" if ("+V+" === undefined ","empty"==n.opts.useDefaults&&(i+=" || "+V+" === null || "+V+" === '' "),i+=" ) "+V+" = ","shared"==n.opts.useDefaults?i+=" "+n.useDefault(z.default)+" ":i+=" "+JSON.stringify(z.default)+" ",i+="; "}}}var K=F.rules;if(K)for(var q,G=-1,Q=K.length-1;G<Q;)if(Z(q=K[G+=1])){var J=q.code(n,q.keyword,F.type);J&&(i+=" "+J+" ",p&&(b+="}"))}if(p&&(i+=" "+b+" ",b=""),F.type&&(i+=" } ",E&&E===F.type&&!x)){i+=" else { ";var Y;u=n.schemaPath+".type",f=n.errSchemaPath+"/type";(Y=Y||[]).push(i),i="",!1!==n.createErrors?(i+=" { keyword: 'type' , dataPath: (dataPath || '') + "+n.errorPath+" , schemaPath: "+n.util.toQuotedString(f)+" , params: { type: '",i+=A?""+E.join(","):""+E,i+="' } ",!1!==n.opts.messages&&(i+=" , message: 'should be ",i+=A?""+E.join(","):""+E,i+="' "),n.opts.verbose&&(i+=" , schema: validate.schema"+u+" , parentSchema: validate.schema"+n.schemaPath+" , data: "+m+" "),i+=" } "):i+=" {} ";v=i;i=Y.pop(),!n.compositeRule&&p?n.async?i+=" throw new ValidationError(["+v+"]); ":i+=" validate.errors = ["+v+"]; return false; ":i+=" var err = "+v+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",i+=" } "}p&&(i+=" if (errors === ",i+=y?"0":"errs_"+c,i+=") { ",C+="}")}}function X(e){for(var t=e.rules,i=0;i<t.length;i++)if(Z(t[i]))return!0}function Z(e){return void 0!==n.schema[e.keyword]||e.implements&&function(e){for(var t=e.implements,i=0;i<t.length;i++)if(void 0!==n.schema[t[i]])return!0}(e)}return p&&(i+=" "+C+" "),y?(r?(i+=" if (errors === 0) return data;           ",i+=" else throw new ValidationError(vErrors); "):(i+=" validate.errors = vErrors; ",i+=" return errors === 0;       "),i+=" }; return validate;"):i+=" var "+g+" = errors === errs_"+c+";",i=n.util.cleanUpCode(i),y&&(i=n.util.finalCleanUpCode(i,r)),i}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n,r=" ",o=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),u=e.opts.$data&&a&&a.$data;n=u?(r+=" var schema"+o+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ","schema"+o):a;var f="maximum"==t,p=f?"exclusiveMaximum":"exclusiveMinimum",m=e.schema[p],g=e.opts.$data&&m&&m.$data,v=f?"<":">",y=f?">":"<",w=void 0;if(g){var b=e.util.getData(m.$data,s,e.dataPathArr),C="exclusive"+o,E="exclType"+o,A="exclIsNumber"+o,x="' + "+(_="op"+o)+" + '";r+=" var schemaExcl"+o+" = "+b+"; ";var F;w=p;(F=F||[]).push(r+=" var "+C+"; var "+E+" = typeof "+(b="schemaExcl"+o)+"; if ("+E+" != 'boolean' && "+E+" != 'undefined' && "+E+" != 'number') { "),r="",!1!==e.createErrors?(r+=" { keyword: '"+(w||"_exclusiveLimit")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: {} ",!1!==e.opts.messages&&(r+=" , message: '"+p+" should be boolean' "),e.opts.verbose&&(r+=" , schema: validate.schema"+l+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),r+=" } "):r+=" {} ";var S=r;r=F.pop(),!e.compositeRule&&h?e.async?r+=" throw new ValidationError(["+S+"]); ":r+=" validate.errors = ["+S+"]; return false; ":r+=" var err = "+S+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+=" } else if ( ",u&&(r+=" ("+n+" !== undefined && typeof "+n+" != 'number') || "),r+=" "+E+" == 'number' ? ( ("+C+" = "+n+" === undefined || "+b+" "+v+"= "+n+") ? "+d+" "+y+"= "+b+" : "+d+" "+y+" "+n+" ) : ( ("+C+" = "+b+" === true) ? "+d+" "+y+"= "+n+" : "+d+" "+y+" "+n+" ) || "+d+" !== "+d+") { var op"+o+" = "+C+" ? '"+v+"' : '"+v+"='; ",void 0===a&&(w=p,c=e.errSchemaPath+"/"+p,n=b,u=g)}else{x=v;if((A="number"==typeof m)&&u){var _="'"+x+"'";r+=" if ( ",u&&(r+=" ("+n+" !== undefined && typeof "+n+" != 'number') || "),r+=" ( "+n+" === undefined || "+m+" "+v+"= "+n+" ? "+d+" "+y+"= "+m+" : "+d+" "+y+" "+n+" ) || "+d+" !== "+d+") { "}else{A&&void 0===a?(C=!0,w=p,c=e.errSchemaPath+"/"+p,n=m,y+="="):(A&&(n=Math[f?"min":"max"](m,a)),m===(!A||n)?(C=!0,w=p,c=e.errSchemaPath+"/"+p,y+="="):(C=!1,x+="="));_="'"+x+"'";r+=" if ( ",u&&(r+=" ("+n+" !== undefined && typeof "+n+" != 'number') || "),r+=" "+d+" "+y+" "+n+" || "+d+" !== "+d+") { "}}w=w||t,(F=F||[]).push(r),r="",!1!==e.createErrors?(r+=" { keyword: '"+(w||"_limit")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { comparison: "+_+", limit: "+n+", exclusive: "+C+" } ",!1!==e.opts.messages&&(r+=" , message: 'should be "+x+" ",r+=u?"' + "+n:n+"'"),e.opts.verbose&&(r+=" , schema:  ",r+=u?"validate.schema"+l:""+a,r+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),r+=" } "):r+=" {} ";S=r;return r=F.pop(),!e.compositeRule&&h?e.async?r+=" throw new ValidationError(["+S+"]); ":r+=" validate.errors = ["+S+"]; return false; ":r+=" var err = "+S+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+=" } ",h&&(r+=" else { "),r}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n,r=" ",o=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),u=e.opts.$data&&a&&a.$data;n=u?(r+=" var schema"+o+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ","schema"+o):a,r+="if ( ",u&&(r+=" ("+n+" !== undefined && typeof "+n+" != 'number') || "),r+=" "+d+".length "+("maxItems"==t?">":"<")+" "+n+") { ";var f=t,p=p||[];p.push(r),r="",!1!==e.createErrors?(r+=" { keyword: '"+(f||"_limitItems")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { limit: "+n+" } ",!1!==e.opts.messages&&(r+=" , message: 'should NOT have ",r+="maxItems"==t?"more":"fewer",r+=" than ",r+=u?"' + "+n+" + '":""+a,r+=" items' "),e.opts.verbose&&(r+=" , schema:  ",r+=u?"validate.schema"+l:""+a,r+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),r+=" } "):r+=" {} ";var m=r;return r=p.pop(),!e.compositeRule&&h?e.async?r+=" throw new ValidationError(["+m+"]); ":r+=" validate.errors = ["+m+"]; return false; ":r+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+="} ",h&&(r+=" else { "),r}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n,r=" ",o=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),u=e.opts.$data&&a&&a.$data;n=u?(r+=" var schema"+o+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ","schema"+o):a;var f="maxLength"==t?">":"<";r+="if ( ",u&&(r+=" ("+n+" !== undefined && typeof "+n+" != 'number') || "),!1===e.opts.unicode?r+=" "+d+".length ":r+=" ucs2length("+d+") ",r+=" "+f+" "+n+") { ";var p=t,m=m||[];m.push(r),r="",!1!==e.createErrors?(r+=" { keyword: '"+(p||"_limitLength")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { limit: "+n+" } ",!1!==e.opts.messages&&(r+=" , message: 'should NOT be ",r+="maxLength"==t?"longer":"shorter",r+=" than ",r+=u?"' + "+n+" + '":""+a,r+=" characters' "),e.opts.verbose&&(r+=" , schema:  ",r+=u?"validate.schema"+l:""+a,r+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),r+=" } "):r+=" {} ";var g=r;return r=m.pop(),!e.compositeRule&&h?e.async?r+=" throw new ValidationError(["+g+"]); ":r+=" validate.errors = ["+g+"]; return false; ":r+=" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+="} ",h&&(r+=" else { "),r}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n,r=" ",o=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),u=e.opts.$data&&a&&a.$data;n=u?(r+=" var schema"+o+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ","schema"+o):a,r+="if ( ",u&&(r+=" ("+n+" !== undefined && typeof "+n+" != 'number') || "),r+=" Object.keys("+d+").length "+("maxProperties"==t?">":"<")+" "+n+") { ";var f=t,p=p||[];p.push(r),r="",!1!==e.createErrors?(r+=" { keyword: '"+(f||"_limitProperties")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { limit: "+n+" } ",!1!==e.opts.messages&&(r+=" , message: 'should NOT have ",r+="maxProperties"==t?"more":"fewer",r+=" than ",r+=u?"' + "+n+" + '":""+a,r+=" properties' "),e.opts.verbose&&(r+=" , schema:  ",r+=u?"validate.schema"+l:""+a,r+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),r+=" } "):r+=" {} ";var m=r;return r=p.pop(),!e.compositeRule&&h?e.async?r+=" throw new ValidationError(["+m+"]); ":r+=" validate.errors = ["+m+"]; return false; ":r+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+="} ",h&&(r+=" else { "),r}},function(e){e.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"http://json-schema.org/draft-07/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"$comment":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":true,"readOnly":{"type":"boolean","default":false},"examples":{"type":"array","items":true},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":true},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"propertyNames":{"format":"regex"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":true,"enum":{"type":"array","items":true,"minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"contentMediaType":{"type":"string"},"contentEncoding":{"type":"string"},"if":{"$ref":"#"},"then":{"$ref":"#"},"else":{"$ref":"#"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":true}')},function(e,t,i){var n;if(window.ace)n=window.ace;else try{n=i(64),i(65),i(67)}catch(e){}e.exports=n},function(e,t){e.exports=function(){throw new Error("define cannot be used indirect")}},function(e,t,i){var n;if(window.Picker)n=window.Picker;else try{n=i(68)}catch(e){}e.exports=n},function(e,t){function i(e){e.hasOwnProperty("remove")||Object.defineProperty(e,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){null!=this.parentNode&&this.parentNode.removeChild(this)}})}"undefined"!=typeof Element&&("undefined"!=typeof Element&&i(Element.prototype),"undefined"!=typeof CharacterData&&i(CharacterData.prototype),"undefined"!=typeof DocumentType&&i(DocumentType.prototype)),String.prototype.startsWith||(String.prototype.startsWith=function(e,t){return t=t||0,this.substr(t,e.length)===e}),Array.prototype.find||(Array.prototype.find=function(e){for(var t=0;t<this.length;t++){var i=this[t];if(e.call(this,i,t,this))return i}}),String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")})},function(e,t){e.exports=function t(e,i){"use strict";function n(e){return t.insensitive&&(""+e).toLowerCase()||""+e}var r,o,s=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,a=/(^[ ]*|[ ]*$)/g,l=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,c=/^0x[0-9a-f]+$/i,h=/^0/,d=n(e).replace(a,"")||"",u=n(i).replace(a,"")||"",f=d.replace(s,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),p=u.replace(s,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),m=parseInt(d.match(c),16)||1!==f.length&&d.match(l)&&Date.parse(d),g=parseInt(u.match(c),16)||m&&u.match(l)&&Date.parse(u)||null;if(g){if(m<g)return-1;if(g<m)return 1}for(var v=0,y=Math.max(f.length,p.length);v<y;v++){if(r=!(f[v]||"").match(h)&&parseFloat(f[v])||f[v]||0,o=!(p[v]||"").match(h)&&parseFloat(p[v])||p[v]||0,isNaN(r)!==isNaN(o))return isNaN(r)?1:-1;if(typeof r!=typeof o&&(r+="",o+=""),r<o)return-1;if(o<r)return 1}return 0}},function(e,t,i){var h=i(0);t.createAbsoluteAnchor=function(i,e,n){var r=function(e){return"function"==typeof e.getRootNode?e.getRootNode():window}(i),o={},t=i.getBoundingClientRect(),s=e.getBoundingClientRect(),a=document.createElement("div");function l(){if(a&&a.parentNode){for(var e in a.parentNode.removeChild(a),o)if(o.hasOwnProperty(e)){var t=o[e];t&&h.removeEventListener(r,e,t),delete o[e]}"function"==typeof n&&n(i)}}a.className="jsoneditor-anchor",a.style.position="absolute",a.style.left=t.left-s.left+"px",a.style.top=t.top-s.top+"px",a.style.width=t.width-2+"px",a.style.height=t.height-2+"px",a.style.boxSizing="border-box",e.appendChild(a);function c(e){var t=e.target;t===a||h.isChildOf(t,a)||l()}return o.mousedown=h.addEventListener(r,"mousedown",c),o.mousewheel=h.addEventListener(r,"mousewheel",c),a.destroy=l,a}},function(e,t,i){var n,r,o;!function(){"use strict";r=[],void 0===(o="function"==typeof(n=function(){"use strict";function g(e){if(typeof Node==="object"){return e instanceof Node}else{return e&&typeof e==="object"&&typeof e.nodeType==="number"}}function e(e){return"string"==typeof e}function v(){var o=[];return{watch:o.push.bind(o),trigger:function(e,t){var i=true;var n={detail:t,preventDefault:function e(){i=false}};for(var r=0;r<o.length;r++){o[r](e,n)}return i}}}function y(e){return window.getComputedStyle(e).display==="none"}function w(e){this.elem=e}function t(e,t){return w.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){e("overlayClose",!0)&&t()})}w.make=function(e,t){if(typeof e==="string"){e=document.querySelector(e)}var i=document.createElement(t||"div");(e||document.body).appendChild(i);return new w(i)},w.prototype={child:function(e){return w.make(this.elem,e)},stylize:function(e){e=e||{};if(typeof e.opacity!=="undefined"){e.filter="alpha(opacity="+e.opacity*100+")"}for(var t in e){if(e.hasOwnProperty(t)){this.elem.style[t]=e[t]}}return this},clazz:function(e){this.elem.className+=" "+e;return this},html:function(e){if(g(e)){this.elem.appendChild(e)}else{this.elem.innerHTML=e}return this},onClick:function(e){this.elem.addEventListener("click",e);return this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(e,t){if(t!==undefined){this.elem.setAttribute(e,t)}return this},anyAncestor:function(e){var t=this.elem;while(t){if(e(new w(t))){return true}else{t=t.parentNode}}return false},isVisible:function(){return!y(this.elem)}};var b=1;function i(e,t){var i=e("width","auto");if("number"==typeof i)i+="px";var n=e("modalId","pico-"+b++);return w.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:i,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",n).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",n)).onClick(function(e){new w(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)})&&t()})}function n(e,t){if(t("closeButton",!0))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}function C(e){return function(){return e().elem}}var E=v(),A=v();function r(n,r){function t(e,t){return(e.msMatchesSelector||e.webkitMatchesSelector||e.matches).call(e,t)}function o(e){return!(y(e)||t(e,":disabled")||e.hasAttribute("contenteditable"))&&(e.hasAttribute("tabindex")||t(e,"input,select,textarea,button,a[href],area[href],iframe"))}function s(e){for(var t=e.getElementsByTagName("*"),i=0;i<t.length;i++)if(o(t[i]))return t[i]}function o(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(o(t[i]))return t[i]}var e;n.beforeShow(function(){e=document.activeElement}),n.afterShow(function(){if(r()){var e=s(n.modalElem());e&&e.focus()}}),n.afterClose(function(){r()&&e&&e.focus(),e=null}),A.watch(function(e){if(r()&&n.isVisible()){var t=s(n.modalElem()),i=function(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(o(t[i]))return t[i]}(n.modalElem());(e.shiftKey?t:i)===document.activeElement&&((e.shiftKey?i:t).focus(),e.preventDefault())}})}function o(e,t){var i,n=new w(document.body);e.beforeShow(function(){i=n.elem.style.overflow,t()&&n.stylize({overflow:"hidden"})}),e.afterClose(function(){n.stylize({overflow:i})})}return document.documentElement.addEventListener("keydown",function(e){var t=e.which||e.keyCode;27===t?E.trigger():9===t&&A.trigger(e)}),function(n){(function(e){return"string"==typeof e}(n)||g(n))&&(n={content:n});var r=v(),t=v(),i=v(),o=v(),s=v();function a(e,t){var i=n[e];return"function"==typeof i&&(i=i(t)),void 0===i?t:i}var l,c,h=m.bind(window,"modal"),d=m.bind(window,"overlay"),u=m.bind(window,"close");function f(e){d().hide(),h().hide(),s.trigger(l,e)}function p(e){o.trigger(l,e)&&f(e)}function e(e){return function(){return e.apply(this,arguments),l}}function m(e,t){if(!c){var i=function(e,t){var i=e("width","auto");"number"==typeof i&&(i+="px");var n=e("modalId","pico-"+b++);return w.make(e("parent")).clazz("pico-content").clazz(e("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:i,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(e("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(e("content")).attr("id",n).attr("role","dialog").attr("aria-labelledby",e("ariaLabelledBy")).attr("aria-describedby",e("ariaDescribedBy",n)).onClick(function(e){new w(e.target).anyAncestor(function(e){return/\bpico-close\b/.test(e.elem.className)})&&t()})}(a,p);c={modal:i,overlay:function(e,t){return w.make(e("parent")).clazz("pico-overlay").clazz(e("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(e("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){e("overlayClose",!0)&&t()})}(a,p),close:function(e,t){if(t("closeButton",!0))return e.child("button").html(t("closeHtml","&#xD7;")).clazz("pico-close").clazz(t("closeClass","")).stylize(t("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",t("close-label","Close"))}(i,a)},r.trigger(l,t)}return c[e]}return function(n,r){function t(e,t){return(e.msMatchesSelector||e.webkitMatchesSelector||e.matches).call(e,t)}function o(e){return!(y(e)||t(e,":disabled")||e.hasAttribute("contenteditable"))&&(e.hasAttribute("tabindex")||t(e,"input,select,textarea,button,a[href],area[href],iframe"))}function s(e){for(var t=e.getElementsByTagName("*"),i=0;i<t.length;i++)if(o(t[i]))return t[i]}var e;n.beforeShow(function(){e=document.activeElement}),n.afterShow(function(){if(r()){var e=s(n.modalElem());e&&e.focus()}}),n.afterClose(function(){r()&&e&&e.focus(),e=null}),A.watch(function(e){if(r()&&n.isVisible()){var t=s(n.modalElem()),i=function(e){for(var t=e.getElementsByTagName("*"),i=t.length;i--;)if(o(t[i]))return t[i]}(n.modalElem());(e.shiftKey?t:i)===document.activeElement&&((e.shiftKey?i:t).focus(),e.preventDefault())}})}(l={modalElem:C(h),closeElem:C(u),overlayElem:C(d),buildDom:e(m.bind(null,null)),isVisible:function(){return!!(c&&h&&h().isVisible())},show:function(e){return t.trigger(l,e)&&(d().show(),u(),h().show(),i.trigger(l,e)),this},close:e(p),forceClose:e(f),destroy:function(){h().destroy(),d().destroy(),d=h=u=void 0},options:function(t){Object.keys(t).map(function(e){n[e]=t[e]})},afterCreate:e(r.watch),beforeShow:e(t.watch),afterShow:e(i.watch),beforeClose:e(o.watch),afterClose:e(s.watch)},a.bind(null,"focus",!0)),function(e,t){var i,n=new w(document.body);e.beforeShow(function(){i=n.elem.style.overflow,t()&&n.stylize({overflow:"hidden"})}),e.afterClose(function(){n.stylize({overflow:i})})}(l,a.bind(null,"bodyOverflow",!0)),E.watch(function(){a("escCloses",!0)&&l.isVisible()&&l.close()}),l}})?n.apply(t,r):n)||(e.exports=o)}()},function(e,t,E){"use strict";var A=E(20),r=E(5),x=E(1).translate,F=E(11),S=E(28),a=E(82).validateCustom,o=E(9),s=E(10),_=E(0),l=E(2).DEFAULT_MODAL_ANCHOR,i={},k="ace/theme/jsoneditor";function n(){try{this.format()}catch(e){}}i.create=function(e,t){void 0===(t=t||{}).statusBar&&(t.statusBar=!0),t.mainMenuBar=!1!==t.mainMenuBar,t.enableSort=!1!==t.enableSort,t.enableTransform=!1!==t.enableTransform,(this.options=t).indentation?this.indentation=Number(t.indentation):this.indentation=2;var i=t.ace?t.ace:A;if(this.mode="code"==t.mode?"code":"text","code"==this.mode&&void 0===i&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=t.theme||k,this.theme===k&&i)try{E(83)}catch(e){console.error(e)}t.onTextSelectionChange&&this.onTextSelectionChange(t.onTextSelectionChange);var n=this;if(this.container=e,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this.annotations=[],this._debouncedValidate=_.debounce(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(e){e.preventDefault()},this.frame.onkeydown=function(e){n._onKeyDown(e)},this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.options.mainMenuBar){_.addClassName(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var r=document.createElement("button");r.type="button",r.className="jsoneditor-format",r.title="Format JSON data, with proper indentation and line feeds (Ctrl+\\)",this.menu.appendChild(r),r.onclick=function(){try{n.format(),n._onChange()}catch(e){n._onError(e)}};var o=document.createElement("button");if(o.type="button",o.className="jsoneditor-compact",o.title="Compact JSON data, remove all whitespaces (Ctrl+Shift+\\)",this.menu.appendChild(o),o.onclick=function(){try{n.compact(),n._onChange()}catch(e){n._onError(e)}},this.options.enableSort){var s=document.createElement("button");s.type="button",s.className="jsoneditor-sort",s.title=x("sortTitleShort"),s.onclick=function(){n._showSortModal()},this.menu.appendChild(s)}if(this.options.enableTransform){var a=document.createElement("button");a.type="button",a.title=x("transformTitleShort"),a.className="jsoneditor-transform",a.onclick=function(){n._showTransformModal()},this.menu.appendChild(a)}var l=document.createElement("button");if(l.type="button",l.className="jsoneditor-repair",l.title="Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",this.menu.appendChild(l),l.onclick=function(){try{n.repair(),n._onChange()}catch(e){n._onError(e)}},this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new F(this.menu,this.options.modes,this.options.mode,function(e){n.setMode(e),n.modeSwitcher.focus()})),"code"===this.mode){var c=document.createElement("a");c.appendChild(document.createTextNode("powered by ace")),c.href="http://ace.ajax.org",c.target="_blank",c.className="jsoneditor-poweredBy",c.onclick=function(){window.open(c.href,c.target)},this.menu.appendChild(c)}}var h=this.options.onEditable&&typeof("function"===this.options.onEditable)&&!this.options.onEditable({});if(this.frame.appendChild(this.content),this.container.appendChild(this.frame),"code"===this.mode){this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom);var d=i.edit(this.editorDom),u=d.getSession();d.$blockScrolling=1/0,d.setTheme(this.theme),d.setOptions({readOnly:h}),d.setShowPrintMargin(!1),d.setFontSize(13),u.setMode("ace/mode/json"),u.setTabSize(this.indentation),u.setUseSoftTabs(!0),u.setUseWrapMode(!0);var f=u.setAnnotations;u.setAnnotations=function(e){f.call(this,e&&e.length?e:n.annotations)},d.commands.bindKey("Ctrl-L",null),d.commands.bindKey("Command-L",null),this.aceEditor=d,this.hasOwnProperty("editor")||Object.defineProperty(this,"editor",{get:function(){return console.warn('Property "editor" has been renamed to "aceEditor".'),n.aceEditor},set:function(e){console.warn('Property "editor" has been renamed to "aceEditor".'),n.aceEditor=e}}),d.on("change",this._onChange.bind(this)),d.on("changeSelection",this._onSelect.bind(this))}else{var p=document.createElement("textarea");p.className="jsoneditor-text",p.spellcheck=!1,this.content.appendChild(p),this.textarea=p,this.textarea.readOnly=h,null===this.textarea.oninput?this.textarea.oninput=this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),p.onselect=this._onSelect.bind(this),p.onmousedown=this._onMouseDown.bind(this),p.onblur=this._onBlur.bind(this)}if(this.errorTable=new S({errorTableVisible:"text"===this.mode,onToggleVisibility:function(){n.validate()},onFocusLine:function(e){n.isFocused=!0,isNaN(e)||n.setTextSelection({row:e,column:1},{row:e,column:1e3})},onChangeHeight:function(e){var t=e+n.dom.statusBar.clientHeight+1;n.content.style.marginBottom=-t+"px",n.content.style.paddingBottom=t+"px"}}),this.frame.appendChild(this.errorTable.getErrorTable()),t.statusBar){_.addClassName(this.content,"has-status-bar"),this.curserInfoElements={};var m=document.createElement("div");(this.dom.statusBar=m).className="jsoneditor-statusbar",this.frame.appendChild(m);var g=document.createElement("span");g.className="jsoneditor-curserinfo-label",g.innerText="Ln:";var v=document.createElement("span");v.className="jsoneditor-curserinfo-val",v.innerText="1",m.appendChild(g),m.appendChild(v);var y=document.createElement("span");y.className="jsoneditor-curserinfo-label",y.innerText="Col:";var w=document.createElement("span");w.className="jsoneditor-curserinfo-val",w.innerText="1",m.appendChild(y),m.appendChild(w),this.curserInfoElements.colVal=w,this.curserInfoElements.lnVal=v;var b=document.createElement("span");b.className="jsoneditor-curserinfo-label",b.innerText="characters selected",b.style.display="none";var C=document.createElement("span");C.className="jsoneditor-curserinfo-count",C.innerText="0",C.style.display="none",this.curserInfoElements.countLabel=b,this.curserInfoElements.countVal=C,m.appendChild(C),m.appendChild(b),m.appendChild(this.errorTable.getErrorCounter()),m.appendChild(this.errorTable.getWarningIcon()),m.appendChild(this.errorTable.getErrorIcon())}this.setSchema(this.options.schema,this.options.schemaRefs)},i._onChange=function(){if(!this.onChangeDisabled){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}},i._showSortModal=function(){var i=this,e=this.options.modalAnchor||l,n=this.get();o(e,n,function(e){if(Array.isArray(n)){var t=_.sort(n,e.path,e.direction);i.sortedBy=e,i.set(t)}if(_.isObject(n)){t=_.sortObjectKeys(n,e.direction);i.sortedBy=e,i.set(t)}},i.sortedBy)},i._showTransformModal=function(){var i=this,e=this.options.modalAnchor||l,n=this.get();s(e,n,function(e){var t=r.search(n,e);i.set(t)})},i._onSelect=function(){this._updateCursorInfo(),this._emitSelectionChange()},i._onKeyDown=function(e){var t=!1;220==(e.which||e.keyCode)&&e.ctrlKey&&(e.shiftKey?this.compact():this.format(),this._onChange(),t=!0),t&&(e.preventDefault(),e.stopPropagation()),this._updateCursorInfo(),this._emitSelectionChange()},i._onMouseDown=function(){this._updateCursorInfo(),this._emitSelectionChange()},i._onBlur=function(){var e=this;setTimeout(function(){e.isFocused||(e._updateCursorInfo(),e._emitSelectionChange()),e.isFocused=!1})},i._updateCursorInfo=function(){var t,i,n,r=this;if(this.textarea)setTimeout(function(){var e=_.getInputSelection(r.textarea);e.startIndex!==e.endIndex&&(n=e.endIndex-e.startIndex),i=n&&r.cursorInfo&&r.cursorInfo.line===e.end.row&&r.cursorInfo.column===e.end.column?(t=e.start.row,e.start.column):(t=e.end.row,e.end.column),r.cursorInfo={line:t,column:i,count:n},r.options.statusBar&&s()},0);else if(this.aceEditor&&this.curserInfoElements){var e=this.aceEditor.getCursorPosition(),o=this.aceEditor.getSelectedText();t=e.row+1,i=e.column+1,n=o.length,r.cursorInfo={line:t,column:i,count:n},this.options.statusBar&&s()}function s(){r.curserInfoElements.countVal.innerText!==n&&(r.curserInfoElements.countVal.innerText=n,r.curserInfoElements.countVal.style.display=n?"inline":"none",r.curserInfoElements.countLabel.style.display=n?"inline":"none"),r.curserInfoElements.lnVal.innerText=t,r.curserInfoElements.colVal.innerText=i}},i._emitSelectionChange=function(){if(this._selectionChangedHandler){var e=this.getTextSelection();this._selectionChangedHandler(e.start,e.end,e.text)}},i._refreshAnnotations=function(){var e=this.aceEditor&&this.aceEditor.getSession();if(e){var t=e.getAnnotations().filter(function(e){return"error"===e.type});e.setAnnotations(t)}},i.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null},i.compact=function(){var e=this.get(),t=JSON.stringify(e);this._setText(t,!1)},i.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this._setText(t,!1)},i.repair=function(){var e=this.getText(),t=_.repair(e);this._setText(t,!1)},i.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},i.resize=function(){if(this.aceEditor){this.aceEditor.resize(!1)}},i.set=function(e){this.setText(JSON.stringify(e,null,this.indentation))},i.update=function(e){this.updateText(JSON.stringify(e,null,this.indentation))},i.get=function(){var e=this.getText();return _.parse(e)},i.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},i._setText=function(e,t){var i;if(i=!0===this.options.escapeUnicode?_.escapeUnicodeChars(e):e,this.textarea&&(this.textarea.value=i),this.aceEditor){if(this.onChangeDisabled=!0,this.aceEditor.setValue(i,-1),t){var n=this;setTimeout(function(){n.aceEditor.session.getUndoManager().reset()},0)}this.onChangeDisabled=!1}this._debouncedValidate()},i.setText=function(e){this._setText(e,!0)},i.updateText=function(e){this.getText()!==e&&this._setText(e,!1)},i.validate=function(){var e,i=[],n=[];try{if(e=this.get(),this.validateSchema)this.validateSchema(e)||(i=this.validateSchema.errors.map(function(e){return e.type="validation",_.improveSchemaError(e)}));this.validationSequence=(this.validationSequence||0)+1;var r=this,o=this.validationSequence;a(e,this.options.onValidate).then(function(e){if(o===r.validationSequence){var t=i.concat(n).concat(e);r._renderErrors(t)}}).catch(function(e){console.error("Custom validation function did throw an error",e)})}catch(e){if(this.getText()){var t,s=/\w*line\s*(\d+)\w*/g.exec(e.message);s&&(t=+s[1]),n=[{type:"error",message:e.message.replace(/\n/g,"<br>"),line:t}]}this._renderErrors(n)}},i._renderErrors=function(n){var e=this.getText(),t=[];n.reduce(function(e,t){return-1===e.indexOf(t.dataPath)&&e.push(t.dataPath),e},t);var i=_.getPositionForPath(e,t);if(this.aceEditor&&(this.annotations=i.map(function(t){var e=n.filter(function(e){return e.dataPath===t.path}),i=e.map(function(e){return e.message}).join("\n");return i?{row:t.line,column:t.column,text:"Schema validation error"+(1!==e.length?"s":"")+": \n"+i,type:"warning",source:"jsoneditor"}:{}}),this._refreshAnnotations()),this.errorTable.setErrors(n,i),this.aceEditor){this.aceEditor.resize(!1)}},i.getTextSelection=function(){var e={};if(this.textarea){var t=_.getInputSelection(this.textarea);return this.cursorInfo&&this.cursorInfo.line===t.end.row&&this.cursorInfo.column===t.end.column?(e.start=t.end,e.end=t.start):e=t,{start:e.start,end:e.end,text:this.textarea.value.substring(t.startIndex,t.endIndex)}}if(this.aceEditor){var i=this.aceEditor.getSelection(),n=this.aceEditor.getSelectedText(),r=i.getRange(),o=i.getSelectionLead();return o.row===r.end.row&&o.column===r.end.column?e=r:(e.start=r.end,e.end=r.start),{start:{row:e.start.row+1,column:e.start.column+1},end:{row:e.end.row+1,column:e.end.column+1},text:n}}},i.onTextSelectionChange=function(e){"function"==typeof e&&(this._selectionChangedHandler=_.debounce(e,this.DEBOUNCE_INTERVAL))},i.setTextSelection=function(e,t){if(e&&t)if(this.textarea){var i=_.getIndexForPosition(this.textarea,e.row,e.column),n=_.getIndexForPosition(this.textarea,t.row,t.column);if(-1<i&&-1<n){if(this.textarea.setSelectionRange)this.textarea.focus(),this.textarea.setSelectionRange(i,n);else if(this.textarea.createTextRange){(a=this.textarea.createTextRange()).collapse(!0),a.moveEnd("character",n),a.moveStart("character",i),a.select()}var r=(this.textarea.value.match(/\n/g)||[]).length+1,o=this.textarea.scrollHeight/r,s=e.row*o;this.textarea.scrollTop=s>this.textarea.clientHeight?s-this.textarea.clientHeight/2:0}}else if(this.aceEditor){var a={start:{row:e.row-1,column:e.column-1},end:{row:t.row-1,column:t.column-1}};this.aceEditor.selection.setRange(a),this.aceEditor.scrollToLine(e.row-1,!0)}},e.exports=[{mode:"text",mixin:i,data:"text",load:n},{mode:"code",mixin:i,data:"text",load:n}]},function(e,t){function i(e){this.errorTableVisible=e.errorTableVisible,this.onToggleVisibility=e.onToggleVisibility,this.onFocusLine=e.onFocusLine||function(){},this.onChangeHeight=e.onChangeHeight,this.dom={};var t=document.createElement("div");t.className="jsoneditor-validation-errors-container",this.dom.validationErrorsContainer=t;var i=document.createElement("div");i.style.display="none",i.className="jsoneditor-additional-errors fadein",i.innerHTML="Scroll for more &#9663;",this.dom.additionalErrorsIndication=i,t.appendChild(i);var n=document.createElement("span");n.className="jsoneditor-validation-error-icon",n.style.display="none",this.dom.validationErrorIcon=n;var r=document.createElement("span");r.className="jsoneditor-validation-error-count",r.style.display="none",this.dom.validationErrorCount=r,this.dom.parseErrorIndication=document.createElement("span"),this.dom.parseErrorIndication.className="jsoneditor-parse-error-icon",this.dom.parseErrorIndication.style.display="none"}i.prototype.getErrorTable=function(){return this.dom.validationErrorsContainer},i.prototype.getErrorCounter=function(){return this.dom.validationErrorCount},i.prototype.getWarningIcon=function(){return this.dom.validationErrorIcon},i.prototype.getErrorIcon=function(){return this.dom.parseErrorIndication},i.prototype.toggleTableVisibility=function(){this.errorTableVisible=!this.errorTableVisible,this.onToggleVisibility(this.errorTableVisible)},i.prototype.setErrors=function(e,o){var s=this;if(this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.dom.additionalErrorsIndication.style.display="none"),this.errorTableVisible&&0<e.length){var t=document.createElement("div");t.className="jsoneditor-validation-errors",t.innerHTML='<table class="jsoneditor-text-errors"><tbody></tbody></table>';var a=t.getElementsByTagName("tbody")[0];e.forEach(function(t){var e,i;if(e="string"==typeof t?'<td colspan="2"><pre>'+t+"</pre></td>":"<td>"+(t.dataPath||"")+"</td><td><pre>"+t.message+"</pre></td>",isNaN(t.line)){if(t.dataPath){var n=o.find(function(e){return e.path===t.dataPath});n&&(i=n.line+1)}}else i=t.line;var r=document.createElement("tr");r.className=isNaN(i)?"":"jump-to-line","error"===t.type?r.className+=" parse-error":r.className+=" validation-error",r.innerHTML='<td><button class="jsoneditor-schema-error"></button></td><td style="white-space:nowrap;">'+(isNaN(i)?"":"Ln "+i)+"</td>"+e,r.onclick=function(){s.onFocusLine(i)},a.appendChild(r)}),this.dom.validationErrors=t,this.dom.validationErrorsContainer.appendChild(t),this.dom.additionalErrorsIndication.title=e.length+" errors total",this.dom.validationErrorsContainer.clientHeight<this.dom.validationErrorsContainer.scrollHeight?(this.dom.additionalErrorsIndication.style.display="block",this.dom.validationErrorsContainer.onscroll=function(){s.dom.additionalErrorsIndication.style.display=0<s.dom.validationErrorsContainer.clientHeight&&0===s.dom.validationErrorsContainer.scrollTop?"block":"none"}):this.dom.validationErrorsContainer.onscroll=void 0;var i=this.dom.validationErrorsContainer.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0);this.onChangeHeight(i)}else this.onChangeHeight(0);var n=e.filter(function(e){return"error"!==e.type}).length;if(0<n?(this.dom.validationErrorCount.style.display="inline",this.dom.validationErrorCount.innerText=n,this.dom.validationErrorCount.onclick=this.toggleTableVisibility.bind(this),this.dom.validationErrorIcon.style.display="inline",this.dom.validationErrorIcon.title=n+" schema validation error(s) found",this.dom.validationErrorIcon.onclick=this.toggleTableVisibility.bind(this)):(this.dom.validationErrorCount.style.display="none",this.dom.validationErrorIcon.style.display="none"),e.some(function(e){return"error"===e.type})){var r=e[0].line;this.dom.parseErrorIndication.style.display="block",this.dom.parseErrorIndication.title=isNaN(r)?"parse error - check that the json is valid":"parse error on line "+r}else this.dom.parseErrorIndication.style.display="none"},e.exports=i},function(e,t,r){"use strict";var o;try{o=r(30)}catch(e){}var i=r(20),n=r(22),s=r(69),a=r(27),l=r(84),c=r(0);function h(e,t,i){if(!(this instanceof h))throw new Error('JSONEditor constructor called without "new".');var n=c.getInternetExplorerVersion();if(-1!=n&&n<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");t&&(t.error&&(console.warn('Option "error" has been renamed to "onError"'),t.onError=t.error,delete t.error),t.change&&(console.warn('Option "change" has been renamed to "onChange"'),t.onChange=t.change,delete t.change),t.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),t.onEditable=t.editable,delete t.editable),t.onChangeJSON&&("text"!==t.mode&&"code"!==t.mode&&(!t.modes||-1===t.modes.indexOf("text")&&-1===t.modes.indexOf("code"))||console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". Use "onChangeText" or "onChange" instead.')),t&&Object.keys(t).forEach(function(e){-1===h.VALID_OPTIONS.indexOf(e)&&console.warn('Unknown option "'+e+'". This option will be ignored')})),arguments.length&&this._create(e,t,i)}"undefined"==typeof Promise&&console.error("Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor"),h.modes={},h.prototype.DEBOUNCE_INTERVAL=150,h.VALID_OPTIONS=["ajv","schema","schemaRefs","templates","ace","theme","autocomplete","onChange","onChangeJSON","onChangeText","onEditable","onError","onEvent","onModeChange","onNodeName","onValidate","onCreateMenu","onSelectionChange","onTextSelectionChange","onClassName","colorPicker","onColorPicker","timestampTag","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys","navigationBar","statusBar","mainMenuBar","languages","language","enableSort","enableTransform","maxVisibleChilds"],h.prototype._create=function(e,t,i){this.container=e,this.options=t||{},this.json=i||{};var n=this.options.mode||this.options.modes&&this.options.modes[0]||"tree";this.setMode(n)},h.prototype.destroy=function(){},h.prototype.set=function(e){this.json=e},h.prototype.get=function(){return this.json},h.prototype.setText=function(e){this.json=c.parse(e)},h.prototype.getText=function(){return JSON.stringify(this.json)},h.prototype.setName=function(e){this.options||(this.options={}),this.options.name=e},h.prototype.getName=function(){return this.options&&this.options.name},h.prototype.setMode=function(e){if(e!==this.options.mode||!this.create){var t,i,n=this.container,r=c.extend({},this.options),o=r.mode;r.mode=e;var s=h.modes[e];if(!s)throw new Error('Unknown mode "'+r.mode+'"');try{var a="text"==s.data;if(i=this.getName(),t=this[a?"getText":"get"](),this.destroy(),c.clear(this),c.extend(this,s.mixin),this.create(n,r),this.setName(i),this[a?"setText":"set"](t),"function"==typeof s.load)try{s.load.call(this)}catch(e){console.error(e)}if("function"==typeof r.onModeChange&&e!==o)try{r.onModeChange(e,o)}catch(e){console.error(e)}}catch(e){this._onError(e)}}},h.prototype.getMode=function(){return this.options.mode},h.prototype._onError=function(e){if(!this.options||"function"!=typeof this.options.onError)throw e;this.options.onError(e)},h.prototype.setSchema=function(e,t){if(e){var i;try{this.options.ajv?i=this.options.ajv:((i=o({allErrors:!0,verbose:!0,schemaId:"auto",$data:!0})).addMetaSchema(r(86)),i.addMetaSchema(r(87)))}catch(e){console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(i){if(t){for(var n in t)i.removeSchema(n),t[n]&&i.addSchema(t[n],n);this.options.schemaRefs=t}this.validateSchema=i.compile(e),this.options.schema=e,this.validate()}this.refresh()}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate(),this.refresh()},h.prototype.validate=function(){},h.prototype.refresh=function(){},h.registerMode=function(e){var t,i;if(c.isArray(e))for(t=0;t<e.length;t++)h.registerMode(e[t]);else{if(!("mode"in e))throw new Error('Property "mode" missing');if(!("mixin"in e))throw new Error('Property "mixin" missing');if(!("data"in e))throw new Error('Property "data" missing');var n=e.mode;if(n in h.modes)throw new Error('Mode "'+n+'" already registered');if("function"!=typeof e.mixin.create)throw new Error('Required function "create" missing on mixin');var r=["setMode","registerMode","modes"];for(t=0;t<r.length;t++)if((i=r[t])in e.mixin)throw new Error('Reserved property "'+i+'" not allowed in mixin');h.modes[n]=e}},h.registerMode(s),h.registerMode(a),h.registerMode(l),h.ace=i,h.Ajv=o,h.VanillaPicker=n,h.default=h,e.exports=h},function(e,t,n){"use strict";var a=n(31),u=n(6),i=n(35),f=n(12),r=n(13),o=n(36),s=n(37),l=n(58),c=n(3);(e.exports=v).prototype.validate=function(e,t){var i;if("string"==typeof e){if(!(i=this.getSchema(e)))throw new Error('no schema with key or ref "'+e+'"')}else{var n=this._addSchema(e);i=n.validate||this._compile(n)}var r=i(t);!0!==i.$async&&(this.errors=i.errors);return r},v.prototype.compile=function(e,t){var i=this._addSchema(e,void 0,t);return i.validate||this._compile(i)},v.prototype.addSchema=function(e,t,i,n){if(Array.isArray(e)){for(var r=0;r<e.length;r++)this.addSchema(e[r],void 0,i,n);return this}var o=this._getId(e);if(void 0!==o&&"string"!=typeof o)throw new Error("schema id must be string");return A(this,t=u.normalizeId(t||o)),this._schemas[t]=this._addSchema(e,i,n,!0),this},v.prototype.addMetaSchema=function(e,t,i){return this.addSchema(e,t,i,!0),this},v.prototype.validateSchema=function(e,t){var i=e.$schema;if(void 0!==i&&"string"!=typeof i)throw new Error("$schema must be a string");if(!(i=i||this._opts.defaultMeta||function(e){var t=e._opts.meta;return e._opts.defaultMeta="object"==typeof t?e._getId(t)||t:e.getSchema(p)?p:void 0,e._opts.defaultMeta}(this)))return this.logger.warn("meta-schema not available"),!(this.errors=null);var n=this.validate(i,e);if(!n&&t){var r="schema is invalid: "+this.errorsText();if("log"!=this._opts.validateSchema)throw new Error(r);this.logger.error(r)}return n},v.prototype.getSchema=function(e){var t=y(this,e);switch(typeof t){case"object":return t.validate||this._compile(t);case"string":return this.getSchema(t);case"undefined":return function(e,t){var i=u.schema.call(e,{schema:{}},t);if(i){var n=i.schema,r=i.root,o=i.baseId,s=a.call(e,n,r,void 0,o);return e._fragments[t]=new f({ref:t,fragment:!0,schema:n,root:r,baseId:o,validate:s}),s}}(this,e)}},v.prototype.removeSchema=function(e){if(e instanceof RegExp)return w(this,this._schemas,e),w(this,this._refs,e),this;switch(typeof e){case"undefined":return w(this,this._schemas),w(this,this._refs),this._cache.clear(),this;case"string":var t=y(this,e);return t&&this._cache.del(t.cacheKey),delete this._schemas[e],delete this._refs[e],this;case"object":var i=this._opts.serialize,n=i?i(e):e;this._cache.del(n);var r=this._getId(e);r&&(r=u.normalizeId(r),delete this._schemas[r],delete this._refs[r])}return this},v.prototype.addFormat=function(e,t){"string"==typeof t&&(t=new RegExp(t));return this._formats[e]=t,this},v.prototype.errorsText=function(e,t){if(!(e=e||this.errors))return"No errors";for(var i=void 0===(t=t||{}).separator?", ":t.separator,n=void 0===t.dataVar?"data":t.dataVar,r="",o=0;o<e.length;o++){var s=e[o];s&&(r+=n+s.dataPath+" "+s.message+i)}return r.slice(0,-i.length)},v.prototype._addSchema=function(e,t,i,n){if("object"!=typeof e&&"boolean"!=typeof e)throw new Error("schema should be object or boolean");var r=this._opts.serialize,o=r?r(e):e,s=this._cache.get(o);if(s)return s;n=n||!1!==this._opts.addUsedSchema;var a=u.normalizeId(this._getId(e));a&&n&&A(this,a);var l,c=!1!==this._opts.validateSchema&&!t;c&&!(l=a&&a==u.normalizeId(e.$schema))&&this.validateSchema(e,!0);var h=u.ids.call(this,e),d=new f({id:a,schema:e,localRefs:h,cacheKey:o,meta:i});"#"!=a[0]&&n&&(this._refs[a]=d);this._cache.put(o,d),c&&l&&this.validateSchema(e,!0);return d},v.prototype._compile=function(i,e){if(i.compiling)return(i.validate=r).schema=i.schema,r.errors=null,r.root=e||r,!0===i.schema.$async&&(r.$async=!0),r;var t,n;i.compiling=!0,i.meta&&(t=this._opts,this._opts=this._metaOpts);try{n=a.call(this,i.schema,e,i.localRefs)}catch(e){throw delete i.validate,e}finally{i.compiling=!1,i.meta&&(this._opts=t)}return i.validate=n,i.refs=n.refs,i.refVal=n.refVal,i.root=n.root,n;function r(){var e=i.validate,t=e.apply(this,arguments);return r.errors=e.errors,t}},v.prototype.compileAsync=n(59);var h=n(60);v.prototype.addKeyword=h.add,v.prototype.getKeyword=h.get,v.prototype.removeKeyword=h.remove,v.prototype.validateKeyword=h.validate;var d=n(8);v.ValidationError=d.Validation,v.MissingRefError=d.MissingRef,v.$dataMetaSchema=l;var p="http://json-schema.org/draft-07/schema",m=["removeAdditional","useDefaults","coerceTypes","strictDefaults"],g=["/properties"];function v(e){if(!(this instanceof v))return new v(e);e=this._opts=c.copy(e)||{},function(e){var t=e._opts.logger;if(!1===t)e.logger={log:x,warn:x,error:x};else{if(void 0===t&&(t=console),!("object"==typeof t&&t.log&&t.warn&&t.error))throw new Error("logger must implement log, warn and error methods");e.logger=t}}(this),this._schemas={},this._refs={},this._fragments={},this._formats=o(e.format),this._cache=e.cache||new i,this._loadingSchemas={},this._compilations=[],this.RULES=s(),this._getId=function(e){switch(e.schemaId){case"auto":return E;case"id":return b;default:return C}}(e),e.loopRequired=e.loopRequired||1/0,"property"==e.errorDataPath&&(e._errorDataPathProperty=!0),void 0===e.serialize&&(e.serialize=r),this._metaOpts=function(e){for(var t=c.copy(e._opts),i=0;i<m.length;i++)delete t[m[i]];return t}(this),e.formats&&function(e){for(var t in e._opts.formats){var i=e._opts.formats[t];e.addFormat(t,i)}}(this),function(e){var t;e._opts.$data&&(t=n(63),e.addMetaSchema(t,t.$id,!0));if(!1===e._opts.meta)return;var i=n(19);e._opts.$data&&(i=l(i,g));e.addMetaSchema(i,p,!0),e._refs["http://json-schema.org/schema"]=p}(this),"object"==typeof e.meta&&this.addMetaSchema(e.meta),e.nullable&&this.addKeyword("nullable",{metaSchema:{type:"boolean"}}),function(e){var t=e._opts.schemas;if(!t)return;if(Array.isArray(t))e.addSchema(t);else for(var i in t)e.addSchema(t[i],i)}(this)}function y(e,t){return t=u.normalizeId(t),e._schemas[t]||e._refs[t]||e._fragments[t]}function w(e,t,i){for(var n in t){var r=t[n];r.meta||i&&!i.test(n)||(e._cache.del(r.cacheKey),delete t[n])}}function b(e){return e.$id&&this.logger.warn("schema $id ignored",e.$id),e.id}
function C(e){return e.id&&this.logger.warn("schema id ignored",e.id),e.$id}function E(e){if(e.$id&&e.id&&e.$id!=e.id)throw new Error("schema $id is different from id");return e.$id||e.id}function A(e,t){if(e._schemas[t]||e._refs[t])throw new Error('schema with key or id "'+t+'" already exists')}function x(){}},function(e,t,i){"use strict";var $=i(6),B=i(3),T=i(8),L=i(13),R=i(14),P=B.ucs2length,O=i(7),M=T.Validation;function I(e,t,i){var n=r.call(this,e,t,i);return 0<=n?{index:n,compiling:!0}:{index:n=this._compilations.length,compiling:!(this._compilations[n]={schema:e,root:t,baseId:i})}}function N(e,t,i){var n=r.call(this,e,t,i);0<=n&&this._compilations.splice(n,1)}function r(e,t,i){for(var n=0;n<this._compilations.length;n++){var r=this._compilations[n];if(r.schema==e&&r.root==t&&r.baseId==i)return n}return-1}function j(e,t){return"var pattern"+e+" = new RegExp("+B.toQuotedString(t[e])+");"}function H(e){return"var default"+e+" = defaults["+e+"];"}function V(e,t){return void 0===t[e]?"":"var refVal"+e+" = refVal["+e+"];"}function W(e){return"var customRule"+e+" = customRules["+e+"];"}function z(e,t){if(!e.length)return"";for(var i="",n=0;n<e.length;n++)i+=t(n,e);return i}e.exports=function c(e,h,d,t){var f=this,p=this._opts,u=[void 0],m={},g=[],i={},v=[],n={},y=[];h=h||{schema:e,refVal:u,refs:m};var r=I.call(this,e,h,t);var o=this._compilations[r.index];if(r.compiling)return o.callValidate=l;var w=this._formats;var b=this.RULES;try{var s=C(e,h,d,t);o.validate=s;var a=o.callValidate;return a&&(a.schema=s.schema,a.errors=null,a.refs=s.refs,a.refVal=s.refVal,a.root=s.root,a.$async=s.$async,p.sourceCode&&(a.source=s.source)),s}finally{N.call(this,e,h,t)}function l(){var e=o.validate,t=e.apply(this,arguments);return l.errors=e.errors,t}function C(e,t,i,n){var r=!t||t&&t.schema==e;if(t.schema!=h.schema)return c.call(f,e,t,i,n);var o,s=!0===e.$async,a=R({isTop:!0,schema:e,isRoot:r,baseId:n,root:t,schemaPath:"",errSchemaPath:"#",errorPath:'""',MissingRefError:T.MissingRef,RULES:b,validate:R,util:B,resolve:$,resolveRef:E,usePattern:_,useDefault:k,useCustomRule:D,opts:p,formats:w,logger:f.logger,self:f});a=z(u,V)+z(g,j)+z(v,H)+z(y,W)+a,p.processCode&&(a=p.processCode(a));try{var l=new Function("self","RULES","formats","root","refVal","defaults","customRules","equal","ucs2length","ValidationError",a);o=l(f,b,w,h,u,v,y,O,P,M),u[0]=o}catch(e){throw f.logger.error("Error compiling schema, function code:",a),e}return o.schema=e,o.errors=null,o.refs=m,o.refVal=u,o.root=r?o:t,s&&(o.$async=!0),!0===p.sourceCode&&(o.source={code:a,patterns:g,defaults:v}),o}function E(e,t,i){t=$.url(e,t);var n,r,o=m[t];if(void 0!==o)return S(n=u[o],r="refVal["+o+"]");if(!i&&h.refs){var s=h.refs[t];if(void 0!==s)return n=h.refVal[s],r=A(t,n),S(n,r)}r=A(t);var a=$.call(f,C,h,t);if(void 0===a){var l=d&&d[t];l&&(a=$.inlineRef(l,p.inlineRefs)?l:c.call(f,l,h,d,e))}if(void 0!==a)return F(t,a),S(a,r);x(t)}function A(e,t){var i=u.length;return u[i]=t,"refVal"+(m[e]=i)}function x(e){delete m[e]}function F(e,t){var i=m[e];u[i]=t}function S(e,t){return"object"==typeof e||"boolean"==typeof e?{code:t,schema:e,inline:!0}:{code:t,$async:e&&!!e.$async}}function _(e){var t=i[e];return void 0===t&&(t=i[e]=g.length,g[t]=e),"pattern"+t}function k(e){switch(typeof e){case"boolean":case"number":return""+e;case"string":return B.toQuotedString(e);case"object":if(null===e)return"null";var t=L(e),i=n[t];return void 0===i&&(i=n[t]=v.length,v[i]=e),"default"+i}}function D(e,t,i,n){if(!1!==f._opts.validateSchema){var r=e.definition.dependencies;if(r&&!r.every(function(e){return Object.prototype.hasOwnProperty.call(i,e)}))throw new Error("parent schema must have all required keywords: "+r.join(","));var o=e.definition.validateSchema;if(o){var s=o(t);if(!s){var a="keyword schema is invalid: "+f.errorsText(o.errors);if("log"!=f._opts.validateSchema)throw new Error(a);f.logger.error(a)}}}var l,c=e.definition.compile,h=e.definition.inline,d=e.definition.macro;if(c)l=c.call(f,t,i,n);else if(d)l=d.call(f,t,i,n),!1!==p.validateSchema&&f.validateSchema(l,!0);else if(h)l=h.call(f,n,e.keyword,t,i);else if(!(l=e.definition.validate))return;if(void 0===l)throw new Error('custom keyword "'+e.keyword+'"failed to compile');var u=y.length;return y[u]=l,{code:"customRule"+u,validate:l}}}},function(e,t,i){
/** @license URI.js v4.2.1 (c) 2011 Gary Court. License: http://github.com/garycourt/uri-js */
!function(e){"use strict";function Q(){for(var e=arguments.length,t=Array(e),i=0;i<e;i++)t[i]=arguments[i];if(1<t.length){t[0]=t[0].slice(0,-1);for(var n=t.length-1,r=1;r<n;++r)t[r]=t[r].slice(1,-1);return t[n]=t[n].slice(1),t.join("")}return t[0]}function J(e){return"(?:"+e+")"}function n(e){return void 0===e?"undefined":null===e?"null":Object.prototype.toString.call(e).split(" ").pop().split("]").shift().toLowerCase()}function f(e){return e.toUpperCase()}function r(e,t){var i=e;if(t)for(var n in t)i[n]=t[n];return i}function t(e){var t="[A-Za-z]",i="[0-9]",n=Q(i,"[A-Fa-f]"),r=J(J("%[EFef]"+n+"%"+n+n+"%"+n+n)+"|"+J("%[89A-Fa-f]"+n+"%"+n+n)+"|"+J("%"+n+n)),o="[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]",s=Q("[\\:\\/\\?\\#\\[\\]\\@]",o),a=e?"[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]":"[]",l=e?"[\\uE000-\\uF8FF]":"[]",c=Q(t,i,"[\\-\\.\\_\\~]",a),h=J(t+Q(t,i,"[\\+\\-\\.]")+"*"),d=J(J(r+"|"+Q(c,o,"[\\:]"))+"*"),u=(J(J("25[0-5]")+"|"+J("2[0-4]"+i)+"|"+J("1"+i+i)+"|"+J("[1-9]"+i)+"|"+i),J(J("25[0-5]")+"|"+J("2[0-4]"+i)+"|"+J("1"+i+i)+"|"+J("0?[1-9]"+i)+"|0?0?"+i)),f=J(u+"\\."+u+"\\."+u+"\\."+u),p=J(n+"{1,4}"),m=J(J(p+"\\:"+p)+"|"+f),g=J(J(p+"\\:")+"{6}"+m),v=J("\\:\\:"+J(p+"\\:")+"{5}"+m),y=J(J(p)+"?\\:\\:"+J(p+"\\:")+"{4}"+m),w=J(J(J(p+"\\:")+"{0,1}"+p)+"?\\:\\:"+J(p+"\\:")+"{3}"+m),b=J(J(J(p+"\\:")+"{0,2}"+p)+"?\\:\\:"+J(p+"\\:")+"{2}"+m),C=J(J(J(p+"\\:")+"{0,3}"+p)+"?\\:\\:"+p+"\\:"+m),E=J(J(J(p+"\\:")+"{0,4}"+p)+"?\\:\\:"+m),A=J(J(J(p+"\\:")+"{0,5}"+p)+"?\\:\\:"+p),x=J(J(J(p+"\\:")+"{0,6}"+p)+"?\\:\\:"),F=J([g,v,y,w,b,C,E,A,x].join("|")),S=J(J(c+"|"+r)+"+"),_=(J(F+"\\%25"+S),J(F+J("\\%25|\\%(?!"+n+"{2})")+S)),k=J("[vV]"+n+"+\\."+Q(c,o,"[\\:]")+"+"),D=J("\\["+J(_+"|"+F+"|"+k)+"\\]"),$=J(J(r+"|"+Q(c,o))+"*"),B=J(D+"|"+f+"(?!"+$+")|"+$),T=J(i+"*"),L=J(J(d+"@")+"?"+B+J("\\:"+T)+"?"),R=J(r+"|"+Q(c,o,"[\\:\\@]")),P=J(R+"*"),O=J(R+"+"),M=J(J(r+"|"+Q(c,o,"[\\@]"))+"+"),I=J(J("\\/"+P)+"*"),N=J("\\/"+J(O+I)+"?"),j=J(M+I),H=J(O+I),V="(?!"+R+")",W=(J(I+"|"+N+"|"+j+"|"+H+"|"+V),J(J(R+"|"+Q("[\\/\\?]",l))+"*")),z=J(J(R+"|[\\/\\?]")+"*"),U=J(J("\\/\\/"+L+I)+"|"+N+"|"+H+"|"+V),K=J(h+"\\:"+U+J("\\?"+W)+"?"+J("\\#"+z)+"?"),q=J(J("\\/\\/"+L+I)+"|"+N+"|"+j+"|"+V),G=J(q+J("\\?"+W)+"?"+J("\\#"+z)+"?");J(K+"|"+G),J(h+"\\:"+U+J("\\?"+W)+"?"),J(J("\\/\\/("+J("("+d+")@")+"?("+B+")"+J("\\:("+T+")")+"?)")+"?("+I+"|"+N+"|"+H+"|"+V+")"),J("\\?("+W+")"),J("\\#("+z+")"),J(J("\\/\\/("+J("("+d+")@")+"?("+B+")"+J("\\:("+T+")")+"?)")+"?("+I+"|"+N+"|"+j+"|"+V+")"),J("\\?("+W+")"),J("\\#("+z+")"),J(J("\\/\\/("+J("("+d+")@")+"?("+B+")"+J("\\:("+T+")")+"?)")+"?("+I+"|"+N+"|"+H+"|"+V+")"),J("\\?("+W+")"),J("\\#("+z+")"),J("("+d+")@"),J("\\:("+T+")");return{NOT_SCHEME:new RegExp(Q("[^]",t,i,"[\\+\\-\\.]"),"g"),NOT_USERINFO:new RegExp(Q("[^\\%\\:]",c,o),"g"),NOT_HOST:new RegExp(Q("[^\\%\\[\\]\\:]",c,o),"g"),NOT_PATH:new RegExp(Q("[^\\%\\/\\:\\@]",c,o),"g"),NOT_PATH_NOSCHEME:new RegExp(Q("[^\\%\\/\\@]",c,o),"g"),NOT_QUERY:new RegExp(Q("[^\\%]",c,o,"[\\:\\@\\/\\?]",l),"g"),NOT_FRAGMENT:new RegExp(Q("[^\\%]",c,o,"[\\:\\@\\/\\?]"),"g"),ESCAPE:new RegExp(Q("[^]",c,o),"g"),UNRESERVED:new RegExp(c,"g"),OTHER_CHARS:new RegExp(Q("[^\\%]",c,s),"g"),PCT_ENCODED:new RegExp(r,"g"),IPV4ADDRESS:new RegExp("^("+f+")$"),IPV6ADDRESS:new RegExp("^\\[?("+F+")"+J(J("\\%25|\\%(?!"+n+"{2})")+"("+S+")")+"?\\]?$")}}var a=t(!1),l=t(!0),E=function(e,t){if(Array.isArray(e))return e;if(Symbol.iterator in Object(e))return function(e,t){var i=[],n=!0,r=!1,o=void 0;try{for(var s,a=e[Symbol.iterator]();!(n=(s=a.next()).done)&&(i.push(s.value),!t||i.length!==t);n=!0);}catch(e){r=!0,o=e}finally{try{!n&&a.return&&a.return()}finally{if(r)throw o}}return i}(e,t);throw new TypeError("Invalid attempt to destructure non-iterable instance")},L=2147483647,i=/^xn--/,o=/[^\0-\x7E]/,s=/[\x2E\u3002\uFF0E\uFF61]/g,c={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},R=Math.floor,P=String.fromCharCode;function O(e){throw new RangeError(c[e])}function h(e,t){var i=e.split("@"),n="";1<i.length&&(n=i[0]+"@",e=i[1]);var r=(e=e.replace(s,".")).split("."),o=function(e,t){var i=[],n=e.length;for(;n--;)i[n]=t(e[n]);return i}(r,t).join(".");return n+o}function M(e){for(var t=[],i=0,n=e.length;i<n;){var r=e.charCodeAt(i++);if(55296<=r&&r<=56319&&i<n){var o=e.charCodeAt(i++);56320==(64512&o)?t.push(((1023&r)<<10)+(1023&o)+65536):(t.push(r),i--)}else t.push(r)}return t}var g=function(e){return e-48<10?e-22:e-65<26?e-65:e-97<26?e-97:36},I=function(e,t){return e+22+75*(e<26)-((0!=t)<<5)},N=function(e,t,i){var n=0;for(e=i?R(e/700):e>>1,e+=R(e/t);455<e;n+=36)e=R(e/35);return R(n+36*e/(e+38))},d=function(e){var t=[],i=e.length,n=0,r=128,o=72,s=e.lastIndexOf("-");s<0&&(s=0);for(var a=0;a<s;++a)128<=e.charCodeAt(a)&&O("not-basic"),t.push(e.charCodeAt(a));for(var l=0<s?s+1:0;l<i;){for(var c=n,h=1,d=36;;d+=36){i<=l&&O("invalid-input");var u=g(e.charCodeAt(l++));(36<=u||u>R((L-n)/h))&&O("overflow"),n+=u*h;var f=d<=o?1:o+26<=d?26:d-o;if(u<f)break;var p=36-f;h>R(L/p)&&O("overflow"),h*=p}var m=t.length+1;o=N(n-c,m,0==c),R(n/m)>L-r&&O("overflow"),r+=R(n/m),n%=m,t.splice(n++,0,r)}return String.fromCodePoint.apply(String,t)},u=function(e){var t=[],i=(e=M(e)).length,n=128,r=0,o=72,s=!0,a=!1,l=void 0;try{for(var c,h=e[Symbol.iterator]();!(s=(c=h.next()).done);s=!0){var d=c.value;d<128&&t.push(P(d))}}catch(e){a=!0,l=e}finally{try{!s&&h.return&&h.return()}finally{if(a)throw l}}var u=t.length,f=u;for(u&&t.push("-");f<i;){var p=L,m=!0,g=!1,v=void 0;try{for(var y,w=e[Symbol.iterator]();!(m=(y=w.next()).done);m=!0){var b=y.value;n<=b&&b<p&&(p=b)}}catch(e){g=!0,v=e}finally{try{!m&&w.return&&w.return()}finally{if(g)throw v}}var C=f+1;p-n>R((L-r)/C)&&O("overflow"),r+=(p-n)*C,n=p;var E=!0,A=!1,x=void 0;try{for(var F,S=e[Symbol.iterator]();!(E=(F=S.next()).done);E=!0){var _=F.value;if(_<n&&++r>L&&O("overflow"),_==n){for(var k=r,D=36;;D+=36){var $=D<=o?1:o+26<=D?26:D-o;if(k<$)break;var B=k-$,T=36-$;t.push(P(I($+B%T,0))),k=R(B/T)}t.push(P(I(k,0))),o=N(r,C,f==u),r=0,++f}}}catch(e){A=!0,x=e}finally{try{!E&&S.return&&S.return()}finally{if(A)throw x}}++r,++n}return t.join("")},v={version:"2.1.0",ucs2:{decode:M,encode:function(e){return String.fromCodePoint.apply(String,function(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}else{return Array.from(e)}}(e))}},decode:d,encode:u,toASCII:function(e){return h(e,function(e){return o.test(e)?"xn--"+u(e):e})},toUnicode:function(e){return h(e,function(e){return i.test(e)?d(e.slice(4).toLowerCase()):e})}},p={};function m(e){var t=e.charCodeAt(0);return t<16?"%0"+t.toString(16).toUpperCase():t<128?"%"+t.toString(16).toUpperCase():t<2048?"%"+(t>>6|192).toString(16).toUpperCase()+"%"+(63&t|128).toString(16).toUpperCase():"%"+(t>>12|224).toString(16).toUpperCase()+"%"+(t>>6&63|128).toString(16).toUpperCase()+"%"+(63&t|128).toString(16).toUpperCase()}function y(e){for(var t="",i=0,n=e.length;i<n;){var r=parseInt(e.substr(i+1,2),16);if(r<128)t+=String.fromCharCode(r),i+=3;else if(194<=r&&r<224){if(6<=n-i){var o=parseInt(e.substr(i+4,2),16);t+=String.fromCharCode((31&r)<<6|63&o)}else t+=e.substr(i,6);i+=6}else if(224<=r){if(9<=n-i){var s=parseInt(e.substr(i+4,2),16),a=parseInt(e.substr(i+7,2),16);t+=String.fromCharCode((15&r)<<12|(63&s)<<6|63&a)}else t+=e.substr(i,9);i+=9}else t+=e.substr(i,3),i+=3}return t}function w(e,i){function t(e){var t=y(e);return t.match(i.UNRESERVED)?t:e}return e.scheme&&(e.scheme=String(e.scheme).replace(i.PCT_ENCODED,t).toLowerCase().replace(i.NOT_SCHEME,"")),void 0!==e.userinfo&&(e.userinfo=String(e.userinfo).replace(i.PCT_ENCODED,t).replace(i.NOT_USERINFO,m).replace(i.PCT_ENCODED,f)),void 0!==e.host&&(e.host=String(e.host).replace(i.PCT_ENCODED,t).toLowerCase().replace(i.NOT_HOST,m).replace(i.PCT_ENCODED,f)),void 0!==e.path&&(e.path=String(e.path).replace(i.PCT_ENCODED,t).replace(e.scheme?i.NOT_PATH:i.NOT_PATH_NOSCHEME,m).replace(i.PCT_ENCODED,f)),void 0!==e.query&&(e.query=String(e.query).replace(i.PCT_ENCODED,t).replace(i.NOT_QUERY,m).replace(i.PCT_ENCODED,f)),void 0!==e.fragment&&(e.fragment=String(e.fragment).replace(i.PCT_ENCODED,t).replace(i.NOT_FRAGMENT,m).replace(i.PCT_ENCODED,f)),e}function A(e){return e.replace(/^0*(.*)/,"$1")||"0"}function x(e,t){var i=e.match(t.IPV4ADDRESS)||[],n=E(i,2),r=n[1];return r?r.split(".").map(A).join("."):e}function b(e,t){var i=e.match(t.IPV6ADDRESS)||[],n=E(i,3),r=n[1],o=n[2];if(r){for(var s=r.toLowerCase().split("::").reverse(),a=E(s,2),l=a[0],c=a[1],h=c?c.split(":").map(A):[],d=l.split(":").map(A),u=t.IPV4ADDRESS.test(d[d.length-1]),f=u?7:8,p=d.length-f,m=Array(f),g=0;g<f;++g)m[g]=h[g]||d[p+g]||"";u&&(m[f-1]=x(m[f-1],t));var v=m.reduce(function(e,t,i){if(!t||"0"===t){var n=e[e.length-1];n&&n.index+n.length===i?n.length++:e.push({index:i,length:1})}return e},[]),y=v.sort(function(e,t){return t.length-e.length})[0],w=void 0;if(y&&1<y.length){var b=m.slice(0,y.index),C=m.slice(y.index+y.length);w=b.join(":")+"::"+C.join(":")}else w=m.join(":");return o&&(w+="%"+o),w}return e}var C=/^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?:\:(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i,F=void 0==="".match(/(){0}/)[1];function S(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},i={},n=!1!==t.iri?l:a;"suffix"===t.reference&&(e=(t.scheme?t.scheme+":":"")+"//"+e);var r=e.match(C);if(r){F?(i.scheme=r[1],i.userinfo=r[3],i.host=r[4],i.port=parseInt(r[5],10),i.path=r[6]||"",i.query=r[7],i.fragment=r[8],isNaN(i.port)&&(i.port=r[5])):(i.scheme=r[1]||void 0,i.userinfo=-1!==e.indexOf("@")?r[3]:void 0,i.host=-1!==e.indexOf("//")?r[4]:void 0,i.port=parseInt(r[5],10),i.path=r[6]||"",i.query=-1!==e.indexOf("?")?r[7]:void 0,i.fragment=-1!==e.indexOf("#")?r[8]:void 0,isNaN(i.port)&&(i.port=e.match(/\/\/(?:.|\n)*\:(?:\/|\?|\#|$)/)?r[4]:void 0)),i.host&&(i.host=b(x(i.host,n),n)),void 0!==i.scheme||void 0!==i.userinfo||void 0!==i.host||void 0!==i.port||i.path||void 0!==i.query?void 0===i.scheme?i.reference="relative":void 0===i.fragment?i.reference="absolute":i.reference="uri":i.reference="same-document",t.reference&&"suffix"!==t.reference&&t.reference!==i.reference&&(i.error=i.error||"URI is not a "+t.reference+" reference.");var o=p[(t.scheme||i.scheme||"").toLowerCase()];if(t.unicodeSupport||o&&o.unicodeSupport)w(i,n);else{if(i.host&&(t.domainHost||o&&o.domainHost))try{i.host=v.toASCII(i.host.replace(n.PCT_ENCODED,y).toLowerCase())}catch(e){i.error=i.error||"Host's domain name can not be converted to ASCII via punycode: "+e}w(i,a)}o&&o.parse&&o.parse(i,t)}else i.error=i.error||"URI can not be parsed.";return i}var _=/^\.\.?\//,k=/^\/\.(\/|$)/,D=/^\/\.\.(\/|$)/,$=/^\/?(?:.|\n)*?(?=\/|$)/;function B(e){for(var t=[];e.length;)if(e.match(_))e=e.replace(_,"");else if(e.match(k))e=e.replace(k,"/");else if(e.match(D))e=e.replace(D,"/"),t.pop();else if("."===e||".."===e)e="";else{var i=e.match($);if(!i)throw new Error("Unexpected dot segment condition");var n=i[0];e=e.slice(n.length),t.push(n)}return t.join("")}function T(t){var i=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},e=i.iri?l:a,n=[],r=p[(i.scheme||t.scheme||"").toLowerCase()];if(r&&r.serialize&&r.serialize(t,i),t.host)if(e.IPV6ADDRESS.test(t.host));else if(i.domainHost||r&&r.domainHost)try{t.host=i.iri?v.toUnicode(t.host):v.toASCII(t.host.replace(e.PCT_ENCODED,y).toLowerCase())}catch(e){t.error=t.error||"Host's domain name can not be converted to "+(i.iri?"Unicode":"ASCII")+" via punycode: "+e}w(t,e),"suffix"!==i.reference&&t.scheme&&(n.push(t.scheme),n.push(":"));var o=function(e,t){var i=!1!==t.iri?l:a,n=[];void 0!==e.userinfo&&(n.push(e.userinfo),n.push("@"));void 0!==e.host&&n.push(b(x(String(e.host),i),i).replace(i.IPV6ADDRESS,function(e,t,i){return"["+t+(i?"%25"+i:"")+"]"}));"number"==typeof e.port&&(n.push(":"),n.push(e.port.toString(10)));return n.length?n.join(""):void 0}(t,i);if(void 0!==o&&("suffix"!==i.reference&&n.push("//"),n.push(o),t.path&&"/"!==t.path.charAt(0)&&n.push("/")),void 0!==t.path){var s=t.path;i.absolutePath||r&&r.absolutePath||(s=B(s)),void 0===o&&(s=s.replace(/^\/\//,"/%2F")),n.push(s)}return void 0!==t.query&&(n.push("?"),n.push(t.query)),void 0!==t.fragment&&(n.push("#"),n.push(t.fragment)),n.join("")}function j(e,t){var i=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},n=arguments[3],r={};return n||(e=S(T(e,i),i),t=S(T(t,i),i)),!(i=i||{}).tolerant&&t.scheme?(r.scheme=t.scheme,r.userinfo=t.userinfo,r.host=t.host,r.port=t.port,r.path=B(t.path||""),r.query=t.query):(void 0!==t.userinfo||void 0!==t.host||void 0!==t.port?(r.userinfo=t.userinfo,r.host=t.host,r.port=t.port,r.path=B(t.path||""),r.query=t.query):(t.path?("/"===t.path.charAt(0)?r.path=B(t.path):(void 0===e.userinfo&&void 0===e.host&&void 0===e.port||e.path?e.path?r.path=e.path.slice(0,e.path.lastIndexOf("/")+1)+t.path:r.path=t.path:r.path="/"+t.path,r.path=B(r.path)),r.query=t.query):(r.path=e.path,void 0!==t.query?r.query=t.query:r.query=e.query),r.userinfo=e.userinfo,r.host=e.host,r.port=e.port),r.scheme=e.scheme),r.fragment=t.fragment,r}function H(e,t){return e&&e.toString().replace(t&&t.iri?l.PCT_ENCODED:a.PCT_ENCODED,y)}var V={scheme:"http",domainHost:!0,parse:function(e,t){return e.host||(e.error=e.error||"HTTP URIs must have a host."),e},serialize:function(e,t){return e.port!==("https"!==String(e.scheme).toLowerCase()?80:443)&&""!==e.port||(e.port=void 0),e.path||(e.path="/"),e}},W={scheme:"https",domainHost:V.domainHost,parse:V.parse,serialize:V.serialize},z={},U="[A-Za-z0-9\\-\\.\\_\\~\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]",K="[0-9A-Fa-f]",q=J(J("%[EFef]"+K+"%"+K+K+"%"+K+K)+"|"+J("%[89A-Fa-f]"+K+"%"+K+K)+"|"+J("%"+K+K)),G=Q("[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]",'[\\"\\\\]'),Y=new RegExp(U,"g"),X=new RegExp(q,"g"),Z=new RegExp(Q("[^]","[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]","[\\.]",'[\\"]',G),"g"),ee=new RegExp(Q("[^]",U,"[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]"),"g"),te=ee;function ie(e){var t=y(e);return t.match(Y)?t:e}var ne={scheme:"mailto",parse:function(e,t){var i=e,n=i.to=i.path?i.path.split(","):[];if(i.path=void 0,i.query){for(var r=!1,o={},s=i.query.split("&"),a=0,l=s.length;a<l;++a){var c=s[a].split("=");switch(c[0]){case"to":for(var h=c[1].split(","),d=0,u=h.length;d<u;++d)n.push(h[d]);break;case"subject":i.subject=H(c[1],t);break;case"body":i.body=H(c[1],t);break;default:r=!0,o[H(c[0],t)]=H(c[1],t)}}r&&(i.headers=o)}i.query=void 0;for(var f=0,p=n.length;f<p;++f){var m=n[f].split("@");if(m[0]=H(m[0]),t.unicodeSupport)m[1]=H(m[1],t).toLowerCase();else try{m[1]=v.toASCII(H(m[1],t).toLowerCase())}catch(e){i.error=i.error||"Email address's domain name can not be converted to ASCII via punycode: "+e}n[f]=m.join("@")}return i},serialize:function(e,t){var i=e,n=function(e){return null!=e?e instanceof Array?e:"number"!=typeof e.length||e.split||e.setInterval||e.call?[e]:Array.prototype.slice.call(e):[]}(e.to);if(n){for(var r=0,o=n.length;r<o;++r){var s=String(n[r]),a=s.lastIndexOf("@"),l=s.slice(0,a).replace(X,ie).replace(X,f).replace(Z,m),c=s.slice(a+1);try{c=t.iri?v.toUnicode(c):v.toASCII(H(c,t).toLowerCase())}catch(e){i.error=i.error||"Email address's domain name can not be converted to "+(t.iri?"Unicode":"ASCII")+" via punycode: "+e}n[r]=l+"@"+c}i.path=n.join(",")}var h=e.headers=e.headers||{};e.subject&&(h.subject=e.subject),e.body&&(h.body=e.body);var d=[];for(var u in h)h[u]!==z[u]&&d.push(u.replace(X,ie).replace(X,f).replace(ee,m)+"="+h[u].replace(X,ie).replace(X,f).replace(te,m));return d.length&&(i.query=d.join("&")),i}},re=/^([^\:]+)\:(.*)/,oe={scheme:"urn",parse:function(e,t){var i=e.path&&e.path.match(re),n=e;if(i){var r=t.scheme||n.scheme||"urn",o=i[1].toLowerCase(),s=i[2],a=r+":"+(t.nid||o),l=p[a];n.nid=o,n.nss=s,n.path=void 0,l&&(n=l.parse(n,t))}else n.error=n.error||"URN can not be parsed.";return n},serialize:function(e,t){var i=t.scheme||e.scheme||"urn",n=e.nid,r=i+":"+(t.nid||n),o=p[r];o&&(e=o.serialize(e,t));var s=e,a=e.nss;return s.path=(n||t.nid)+":"+a,s}},se=/^[0-9A-Fa-f]{8}(?:\-[0-9A-Fa-f]{4}){3}\-[0-9A-Fa-f]{12}$/,ae={scheme:"urn:uuid",parse:function(e,t){var i=e;return i.uuid=i.nss,i.nss=void 0,t.tolerant||i.uuid&&i.uuid.match(se)||(i.error=i.error||"UUID is not valid."),i},serialize:function(e,t){var i=e;return i.nss=(e.uuid||"").toLowerCase(),i}};p[V.scheme]=V,p[W.scheme]=W,p[ne.scheme]=ne,p[oe.scheme]=oe,p[ae.scheme]=ae,e.SCHEMES=p,e.pctEncChar=m,e.pctDecChars=y,e.parse=S,e.removeDotSegments=B,e.serialize=T,e.resolveComponents=j,e.resolve=function(e,t,i){var n=r({scheme:"null"},i);return T(j(S(e,n),S(t,n),n,!0),n)},e.normalize=function(e,t){"string"==typeof e?e=T(S(e,t),t):"object"===n(e)&&(e=S(T(e,t),t));return e},e.equal=function(e,t,i){"string"==typeof e?e=T(S(e,i),i):"object"===n(e)&&(e=T(e,i));"string"==typeof t?t=T(S(t,i),i):"object"===n(t)&&(t=T(t,i));return e===t},e.escapeComponent=function(e,t){return e&&e.toString().replace(t&&t.iri?l.ESCAPE:a.ESCAPE,m)},e.unescapeComponent=H,Object.defineProperty(e,"__esModule",{value:!0})}(t)},function(e,t,i){"use strict";e.exports=function(e){for(var t,i=0,n=e.length,r=0;r<n;)i++,55296<=(t=e.charCodeAt(r++))&&t<=56319&&r<n&&56320==(64512&(t=e.charCodeAt(r)))&&r++;return i}},function(e,t,i){"use strict";var m=e.exports=function(e,t,i){"function"==typeof t&&(i=t,t={}),function e(t,i,n,r,o,s,a,l,c,h){if(r&&"object"==typeof r&&!Array.isArray(r)){for(var d in i(r,o,s,a,l,c,h),r){var u=r[d];if(Array.isArray(u)){if(d in m.arrayKeywords)for(var f=0;f<u.length;f++)e(t,i,n,u[f],o+"/"+d+"/"+f,s,o,d,r,f)}else if(d in m.propsKeywords){if(u&&"object"==typeof u)for(var p in u)e(t,i,n,u[p],o+"/"+d+"/"+p.replace(/~/g,"~0").replace(/\//g,"~1"),s,o,d,r,p)}else(d in m.keywords||t.allKeys&&!(d in m.skipKeywords))&&e(t,i,n,u,o+"/"+d,s,o,d,r)}n(r,o,s,a,l,c,h)}}(t,"function"==typeof(i=t.cb||i)?i:i.pre||function(){},i.post||function(){},e,"",e)};m.keywords={additionalItems:!0,items:!0,contains:!0,additionalProperties:!0,propertyNames:!0,not:!0},m.arrayKeywords={items:!0,allOf:!0,anyOf:!0,oneOf:!0},m.propsKeywords={definitions:!0,properties:!0,patternProperties:!0,dependencies:!0},m.skipKeywords={default:!0,enum:!0,const:!0,required:!0,maximum:!0,minimum:!0,exclusiveMaximum:!0,exclusiveMinimum:!0,multipleOf:!0,maxLength:!0,minLength:!0,pattern:!0,format:!0,maxItems:!0,minItems:!0,uniqueItems:!0,maxProperties:!0,minProperties:!0}},function(e,t,i){"use strict";var n=e.exports=function(){this._cache={}};n.prototype.put=function(e,t){this._cache[e]=t},n.prototype.get=function(e){return this._cache[e]},n.prototype.del=function(e){delete this._cache[e]},n.prototype.clear=function(){this._cache={}}},function(e,t,i){"use strict";var n=i(3),o=/^(\d\d\d\d)-(\d\d)-(\d\d)$/,s=[0,31,28,31,30,31,30,31,31,30,31,30,31],a=/^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d:\d\d)?$/i,r=/^[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*$/i,l=/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,c=/^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i,h=/^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-?)*(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-?)*(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i,d=/^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,u=/^(?:\/(?:[^~/]|~0|~1)*)*$/,f=/^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i,p=/^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;function m(e){return e="full"==e?"full":"fast",n.copy(m[e])}function g(e){var t=e.match(o);if(!t)return!1;var i=+t[1],n=+t[2],r=+t[3];return 1<=n&&n<=12&&1<=r&&r<=(2==n&&function(e){return e%4==0&&(e%100!=0||e%400==0)}(i)?29:s[n])}function v(e,t){var i=e.match(a);if(!i)return!1;var n=i[1],r=i[2],o=i[3],s=i[5];return(n<=23&&r<=59&&o<=59||23==n&&59==r&&60==o)&&(!t||s)}(e.exports=m).fast={date:/^\d\d\d\d-[0-1]\d-[0-3]\d$/,time:/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d:\d\d)?$/i,"date-time":/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d:\d\d)$/i,uri:/^(?:[a-z][a-z0-9+-.]*:)(?:\/?\/)?[^\s]*$/i,"uri-reference":/^(?:(?:[a-z][a-z0-9+-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,"uri-template":c,url:h,email:/^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,hostname:r,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:C,uuid:d,"json-pointer":u,"json-pointer-uri-fragment":f,"relative-json-pointer":p},m.full={date:g,time:v,"date-time":function(e){var t=e.split(y);return 2==t.length&&g(t[0])&&v(t[1],!0)},uri:function(e){return w.test(e)&&l.test(e)},"uri-reference":/^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,"uri-template":c,url:h,email:/^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,hostname:function(e){return e.length<=255&&r.test(e)},ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:C,uuid:d,"json-pointer":u,"json-pointer-uri-fragment":f,"relative-json-pointer":p};var y=/t|\s/i;var w=/\/|:/;var b=/[^\\]\\Z/;function C(e){if(b.test(e))return!1;try{return new RegExp(e),!0}catch(e){return!1}}},function(e,t,i){"use strict";var o=i(38),s=i(3).toHash;e.exports=function(){var n=[{type:"number",rules:[{maximum:["exclusiveMaximum"]},{minimum:["exclusiveMinimum"]},"multipleOf","format"]},{type:"string",rules:["maxLength","minLength","pattern","format"]},{type:"array",rules:["maxItems","minItems","items","contains","uniqueItems"]},{type:"object",rules:["maxProperties","minProperties","required","dependencies","propertyNames",{properties:["additionalProperties","patternProperties"]}]},{rules:["$ref","const","enum","not","anyOf","oneOf","allOf","if"]}],r=["type","$comment"];return n.all=s(r),n.types=s(["number","integer","string","array","object","boolean","null"]),n.forEach(function(e){e.rules=e.rules.map(function(e){var t;if("object"==typeof e){var i=Object.keys(e)[0];t=e[i],e=i,t.forEach(function(e){r.push(e),n.all[e]=!0})}return r.push(e),n.all[e]={keyword:e,code:o[e],implements:t}}),n.all.$comment={keyword:"$comment",code:o.$comment},e.type&&(n.types[e.type]=e)}),n.keywords=s(r.concat(["$schema","$id","id","$data","$async","title","description","default","definitions","examples","readOnly","writeOnly","contentMediaType","contentEncoding","additionalItems","then","else"])),n.custom={},n}},function(e,t,i){"use strict";e.exports={$ref:i(39),allOf:i(40),anyOf:i(41),$comment:i(42),const:i(43),contains:i(44),dependencies:i(45),enum:i(46),format:i(47),if:i(48),items:i(49),maximum:i(15),minimum:i(15),maxItems:i(16),minItems:i(16),maxLength:i(17),minLength:i(17),maxProperties:i(18),minProperties:i(18),multipleOf:i(50),not:i(51),oneOf:i(52),pattern:i(53),properties:i(54),propertyNames:i(55),required:i(56),uniqueItems:i(57),validate:i(14)}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n,r,o=" ",s=e.level,a=e.dataLevel,l=e.schema[t],c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(a||""),u="valid"+s;if("#"==l||"#/"==l)r=e.isRoot?(n=e.async,"validate"):(n=!0===e.root.schema.$async,"root.refVal[0]");else{var f=e.resolveRef(e.baseId,l,e.isRoot);if(void 0===f){var p=e.MissingRefError.message(e.baseId,l);if("fail"==e.opts.missingRefs){e.logger.error(p),(y=y||[]).push(o),o="",!1!==e.createErrors?(o+=" { keyword: '$ref' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { ref: '"+e.util.escapeQuotes(l)+"' } ",!1!==e.opts.messages&&(o+=" , message: 'can\\'t resolve reference "+e.util.escapeQuotes(l)+"' "),e.opts.verbose&&(o+=" , schema: "+e.util.toQuotedString(l)+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),o+=" } "):o+=" {} ";var m=o;o=y.pop(),!e.compositeRule&&h?e.async?o+=" throw new ValidationError(["+m+"]); ":o+=" validate.errors = ["+m+"]; return false; ":o+=" var err = "+m+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",h&&(o+=" if (false) { ")}else{if("ignore"!=e.opts.missingRefs)throw new e.MissingRefError(e.baseId,l,p);e.logger.warn(p),h&&(o+=" if (true) { ")}}else if(f.inline){var g=e.util.copy(e);g.level++;var v="valid"+g.level;g.schema=f.schema,g.schemaPath="",g.errSchemaPath=l,o+=" "+e.validate(g).replace(/validate\.schema/g,f.code)+" ",h&&(o+=" if ("+v+") { ")}else n=!0===f.$async||e.async&&!1!==f.$async,r=f.code}if(r){var y;(y=y||[]).push(o),o="",e.opts.passContext?o+=" "+r+".call(this, ":o+=" "+r+"( ",o+=" "+d+", (dataPath || '')",'""'!=e.errorPath&&(o+=" + "+e.errorPath);var w=o+=" , "+(a?"data"+(a-1||""):"parentData")+" , "+(a?e.dataPathArr[a]:"parentDataProperty")+", rootData)  ";if(o=y.pop(),n){if(!e.async)throw new Error("async schema referenced by sync schema");h&&(o+=" var "+u+"; "),o+=" try { await "+w+"; ",h&&(o+=" "+u+" = true; "),o+=" } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ",h&&(o+=" "+u+" = false; "),o+=" } ",h&&(o+=" if ("+u+") { ")}else o+=" if (!"+w+") { if (vErrors === null) vErrors = "+r+".errors; else vErrors = vErrors.concat("+r+".errors); errors = vErrors.length; } ",h&&(o+=" else { ")}return o}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.schema[t],o=e.schemaPath+e.util.getProperty(t),s=e.errSchemaPath+"/"+t,a=!e.opts.allErrors,l=e.util.copy(e),c="";l.level++;var h="valid"+l.level,d=l.baseId,u=!0,f=r;if(f)for(var p,m=-1,g=f.length-1;m<g;)p=f[m+=1],(e.opts.strictKeywords?"object"==typeof p&&0<Object.keys(p).length:e.util.schemaHasRules(p,e.RULES.all))&&(u=!1,l.schema=p,l.schemaPath=o+"["+m+"]",l.errSchemaPath=s+"/"+m,n+="  "+e.validate(l)+" ",l.baseId=d,a&&(n+=" if ("+h+") { ",c+="}"));return a&&(n+=u?" if (true) { ":" "+c.slice(0,-1)+" "),n=e.util.cleanUpCode(n)}},function(e,t,i){"use strict";e.exports=function(t,e,i){var n=" ",r=t.level,o=t.dataLevel,s=t.schema[e],a=t.schemaPath+t.util.getProperty(e),l=t.errSchemaPath+"/"+e,c=!t.opts.allErrors,h="data"+(o||""),d="valid"+r,u="errs__"+r,f=t.util.copy(t),p="";f.level++;var m="valid"+f.level;if(s.every(function(e){return t.opts.strictKeywords?"object"==typeof e&&0<Object.keys(e).length:t.util.schemaHasRules(e,t.RULES.all)})){var g=f.baseId;n+=" var "+u+" = errors; var "+d+" = false;  ";var v=t.compositeRule;t.compositeRule=f.compositeRule=!0;var y=s;if(y)for(var w,b=-1,C=y.length-1;b<C;)w=y[b+=1],f.schema=w,f.schemaPath=a+"["+b+"]",f.errSchemaPath=l+"/"+b,n+="  "+t.validate(f)+" ",f.baseId=g,n+=" "+d+" = "+d+" || "+m+"; if (!"+d+") { ",p+="}";t.compositeRule=f.compositeRule=v,n+=" "+p+" if (!"+d+") {   var err =   ",!1!==t.createErrors?(n+=" { keyword: 'anyOf' , dataPath: (dataPath || '') + "+t.errorPath+" , schemaPath: "+t.util.toQuotedString(l)+" , params: {} ",!1!==t.opts.messages&&(n+=" , message: 'should match some schema in anyOf' "),t.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+t.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!t.compositeRule&&c&&(t.async?n+=" throw new ValidationError(vErrors); ":n+=" validate.errors = vErrors; return false; "),n+=" } else {  errors = "+u+"; if (vErrors !== null) { if ("+u+") vErrors.length = "+u+"; else vErrors = null; } ",t.opts.allErrors&&(n+=" } "),n=t.util.cleanUpCode(n)}else c&&(n+=" if (true) { ");return n}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.schema[t],o=e.errSchemaPath+"/"+t,s=(e.opts.allErrors,e.util.toQuotedString(r));return!0===e.opts.$comment?n+=" console.log("+s+");":"function"==typeof e.opts.$comment&&(n+=" self._opts.$comment("+s+", "+e.util.toQuotedString(o)+", validate.root.schema);"),n}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u=e.opts.$data&&s&&s.$data;u&&(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; "),u||(n+=" var schema"+r+" = validate.schema"+a+";"),n+="var "+d+" = equal("+h+", schema"+r+"); if (!"+d+") {   ";var f=f||[];f.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'const' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { allowedValue: schema"+r+" } ",!1!==e.opts.messages&&(n+=" , message: 'should be equal to constant' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var p=n;return n=f.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+p+"]); ":n+=" validate.errors = ["+p+"]; return false; ":n+=" var err = "+p+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" }",c&&(n+=" else { "),n}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u="errs__"+r,f=e.util.copy(e);f.level++;var p="valid"+f.level,m="i"+r,g=f.dataLevel=e.dataLevel+1,v="data"+g,y=e.baseId,w=e.opts.strictKeywords?"object"==typeof s&&0<Object.keys(s).length:e.util.schemaHasRules(s,e.RULES.all);if(n+="var "+u+" = errors;var "+d+";",w){var b=e.compositeRule;e.compositeRule=f.compositeRule=!0,f.schema=s,f.schemaPath=a,f.errSchemaPath=l,n+=" var "+p+" = false; for (var "+m+" = 0; "+m+" < "+h+".length; "+m+"++) { ",f.errorPath=e.util.getPathExpr(e.errorPath,m,e.opts.jsonPointers,!0);var C=h+"["+m+"]";f.dataPathArr[g]=m;var E=e.validate(f);f.baseId=y,e.util.varOccurences(E,v)<2?n+=" "+e.util.varReplace(E,v,C)+" ":n+=" var "+v+" = "+C+"; "+E+" ",n+=" if ("+p+") break; }  ",e.compositeRule=f.compositeRule=b,n+="  if (!"+p+") {"}else n+=" if ("+h+".length == 0) {";var A=A||[];A.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'contains' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: {} ",!1!==e.opts.messages&&(n+=" , message: 'should contain a valid item' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var x=n;return n=A.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+x+"]); ":n+=" validate.errors = ["+x+"]; return false; ":n+=" var err = "+x+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } else { ",w&&(n+="  errors = "+u+"; if (vErrors !== null) { if ("+u+") vErrors.length = "+u+"; else vErrors = null; } "),e.opts.allErrors&&(n+=" } "),n=e.util.cleanUpCode(n)}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="errs__"+r,u=e.util.copy(e),f="";u.level++;var p="valid"+u.level,m={},g={},v=e.opts.ownProperties;for(C in s){var y=s[C],w=Array.isArray(y)?g:m;w[C]=y}n+="var "+d+" = errors;";var b=e.errorPath;for(var C in n+="var missing"+r+";",g)if((w=g[C]).length){if(n+=" if ( "+h+e.util.getProperty(C)+" !== undefined ",v&&(n+=" && Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(C)+"') "),c){n+=" && ( ";var E=w;if(E)for(var A=-1,x=E.length-1;A<x;){$=E[A+=1],A&&(n+=" || "),n+=" ( ( "+(R=h+(L=e.util.getProperty($)))+" === undefined ",v&&(n+=" || ! Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes($)+"') "),n+=") && (missing"+r+" = "+e.util.toQuotedString(e.opts.jsonPointers?$:L)+") ) "}n+=")) {  ";var F="missing"+r,S="' + "+F+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(b,F,!0):b+" + "+F);var _=_||[];_.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { property: '"+e.util.escapeQuotes(C)+"', missingProperty: '"+S+"', depsCount: "+w.length+", deps: '"+e.util.escapeQuotes(1==w.length?w[0]:w.join(", "))+"' } ",!1!==e.opts.messages&&(n+=" , message: 'should have ",1==w.length?n+="property "+e.util.escapeQuotes(w[0]):n+="properties "+e.util.escapeQuotes(w.join(", ")),n+=" when property "+e.util.escapeQuotes(C)+" is present' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var k=n;n=_.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+k+"]); ":n+=" validate.errors = ["+k+"]; return false; ":n+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}else{n+=" ) { ";var D=w;if(D)for(var $,B=-1,T=D.length-1;B<T;){$=D[B+=1];var L=e.util.getProperty($),R=(S=e.util.escapeQuotes($),h+L);e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(b,$,e.opts.jsonPointers)),n+=" if ( "+R+" === undefined ",v&&(n+=" || ! Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes($)+"') "),n+=") {  var err =   ",!1!==e.createErrors?(n+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { property: '"+e.util.escapeQuotes(C)+"', missingProperty: '"+S+"', depsCount: "+w.length+", deps: '"+e.util.escapeQuotes(1==w.length?w[0]:w.join(", "))+"' } ",!1!==e.opts.messages&&(n+=" , message: 'should have ",1==w.length?n+="property "+e.util.escapeQuotes(w[0]):n+="properties "+e.util.escapeQuotes(w.join(", ")),n+=" when property "+e.util.escapeQuotes(C)+" is present' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}n+=" }   ",c&&(f+="}",n+=" else { ")}e.errorPath=b;var P=u.baseId;for(var C in m){y=m[C];(e.opts.strictKeywords?"object"==typeof y&&0<Object.keys(y).length:e.util.schemaHasRules(y,e.RULES.all))&&(n+=" "+p+" = true; if ( "+h+e.util.getProperty(C)+" !== undefined ",v&&(n+=" && Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(C)+"') "),n+=") { ",u.schema=y,u.schemaPath=a+e.util.getProperty(C),u.errSchemaPath=l+"/"+e.util.escapeFragment(C),n+="  "+e.validate(u)+" ",u.baseId=P,n+=" }  ",c&&(n+=" if ("+p+") { ",f+="}"))}return c&&(n+="   "+f+" if ("+d+" == errors) {"),n=e.util.cleanUpCode(n)}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u=e.opts.$data&&s&&s.$data;u&&(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ");var f="i"+r,p="schema"+r;u||(n+=" var "+p+" = validate.schema"+a+";"),n+="var "+d+";",u&&(n+=" if (schema"+r+" === undefined) "+d+" = true; else if (!Array.isArray(schema"+r+")) "+d+" = false; else {"),n+=d+" = false;for (var "+f+"=0; "+f+"<"+p+".length; "+f+"++) if (equal("+h+", "+p+"["+f+"])) { "+d+" = true; break; }",u&&(n+="  }  "),n+=" if (!"+d+") {   ";var m=m||[];m.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'enum' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { allowedValues: schema"+r+" } ",!1!==e.opts.messages&&(n+=" , message: 'should be equal to one of the allowed values' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var g=n;return n=m.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+g+"]); ":n+=" validate.errors = ["+g+"]; return false; ":n+=" var err = "+g+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" }",c&&(n+=" else { "),n}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||"");if(!1===e.opts.format)return c&&(n+=" if (true) { "),n;var d,u=e.opts.$data&&s&&s.$data;d=u?(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ","schema"+r):s;var f=e.opts.unknownFormats,p=Array.isArray(f);if(u){n+=" var "+(m="format"+r)+" = formats["+d+"]; var "+(g="isObject"+r)+" = typeof "+m+" == 'object' && !("+m+" instanceof RegExp) && "+m+".validate; var "+(v="formatType"+r)+" = "+g+" && "+m+".type || 'string'; if ("+g+") { ",e.async&&(n+=" var async"+r+" = "+m+".async; "),n+=" "+m+" = "+m+".validate; } if (  ",u&&(n+=" ("+d+" !== undefined && typeof "+d+" != 'string') || "),n+=" (","ignore"!=f&&(n+=" ("+d+" && !"+m+" ",p&&(n+=" && self._opts.unknownFormats.indexOf("+d+") == -1 "),n+=") || "),n+=" ("+m+" && "+v+" == '"+i+"' && !(typeof "+m+" == 'function' ? ",e.async?n+=" (async"+r+" ? await "+m+"("+h+") : "+m+"("+h+")) ":n+=" "+m+"("+h+") ",n+=" : "+m+".test("+h+"))))) {"}else{var m;if(!(m=e.formats[s])){if("ignore"==f)return e.logger.warn('unknown format "'+s+'" ignored in schema at path "'+e.errSchemaPath+'"'),c&&(n+=" if (true) { "),n;if(p&&0<=f.indexOf(s))return c&&(n+=" if (true) { "),n;throw new Error('unknown format "'+s+'" is used in schema at path "'+e.errSchemaPath+'"')}var g,v=(g="object"==typeof m&&!(m instanceof RegExp)&&m.validate)&&m.type||"string";if(g){var y=!0===m.async;m=m.validate}if(v!=i)return c&&(n+=" if (true) { "),n;if(y){if(!e.async)throw new Error("async format in sync schema");n+=" if (!(await "+(w="formats"+e.util.getProperty(s)+".validate")+"("+h+"))) { "}else{n+=" if (! ";var w="formats"+e.util.getProperty(s);g&&(w+=".validate"),n+="function"==typeof m?" "+w+"("+h+") ":" "+w+".test("+h+") ",n+=") { "}}var b=b||[];b.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'format' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { format:  ",n+=u?""+d:""+e.util.toQuotedString(s),n+="  } ",!1!==e.opts.messages&&(n+=" , message: 'should match format \"",n+=u?"' + "+d+" + '":""+e.util.escapeQuotes(s),n+="\"' "),e.opts.verbose&&(n+=" , schema:  ",n+=u?"validate.schema"+a:""+e.util.toQuotedString(s),n+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var C=n;return n=b.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+C+"]); ":n+=" validate.errors = ["+C+"]; return false; ":n+=" var err = "+C+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } ",c&&(n+=" else { "),n}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u="errs__"+r,f=e.util.copy(e);f.level++;var p="valid"+f.level,m=e.schema.then,g=e.schema.else,v=void 0!==m&&(e.opts.strictKeywords?"object"==typeof m&&0<Object.keys(m).length:e.util.schemaHasRules(m,e.RULES.all)),y=void 0!==g&&(e.opts.strictKeywords?"object"==typeof g&&0<Object.keys(g).length:e.util.schemaHasRules(g,e.RULES.all)),w=f.baseId;if(v||y){var b;f.createErrors=!1,f.schema=s,f.schemaPath=a,f.errSchemaPath=l,n+=" var "+u+" = errors; var "+d+" = true;  ";var C=e.compositeRule;e.compositeRule=f.compositeRule=!0,n+="  "+e.validate(f)+" ",f.baseId=w,f.createErrors=!0,n+="  errors = "+u+"; if (vErrors !== null) { if ("+u+") vErrors.length = "+u+"; else vErrors = null; }  ",e.compositeRule=f.compositeRule=C,v?(n+=" if ("+p+") {  ",f.schema=e.schema.then,f.schemaPath=e.schemaPath+".then",f.errSchemaPath=e.errSchemaPath+"/then",n+="  "+e.validate(f)+" ",f.baseId=w,n+=" "+d+" = "+p+"; ",v&&y?n+=" var "+(b="ifClause"+r)+" = 'then'; ":b="'then'",n+=" } ",y&&(n+=" else { ")):n+=" if (!"+p+") { ",y&&(f.schema=e.schema.else,f.schemaPath=e.schemaPath+".else",f.errSchemaPath=e.errSchemaPath+"/else",n+="  "+e.validate(f)+" ",f.baseId=w,n+=" "+d+" = "+p+"; ",v&&y?n+=" var "+(b="ifClause"+r)+" = 'else'; ":b="'else'",n+=" } "),n+=" if (!"+d+") {   var err =   ",!1!==e.createErrors?(n+=" { keyword: 'if' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { failingKeyword: "+b+" } ",!1!==e.opts.messages&&(n+=" , message: 'should match \"' + "+b+" + '\" schema' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&c&&(e.async?n+=" throw new ValidationError(vErrors); ":n+=" validate.errors = vErrors; return false; "),n+=" }   ",c&&(n+=" else { "),n=e.util.cleanUpCode(n)}else c&&(n+=" if (true) { ");return n}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u="errs__"+r,f=e.util.copy(e),p="";f.level++;var m="valid"+f.level,g="i"+r,v=f.dataLevel=e.dataLevel+1,y="data"+v,w=e.baseId;if(n+="var "+u+" = errors;var "+d+";",Array.isArray(s)){var b=e.schema.additionalItems;if(!1===b){n+=" "+d+" = "+h+".length <= "+s.length+"; ";var C=l;l=e.errSchemaPath+"/additionalItems",n+="  if (!"+d+") {   ";var E=E||[];E.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'additionalItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { limit: "+s.length+" } ",!1!==e.opts.messages&&(n+=" , message: 'should NOT have more than "+s.length+" items' "),e.opts.verbose&&(n+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var A=n;n=E.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+A+"]); ":n+=" validate.errors = ["+A+"]; return false; ":n+=" var err = "+A+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } ",l=C,c&&(p+="}",n+=" else { ")}var x=s;if(x)for(var F,S=-1,_=x.length-1;S<_;)if(F=x[S+=1],e.opts.strictKeywords?"object"==typeof F&&0<Object.keys(F).length:e.util.schemaHasRules(F,e.RULES.all)){n+=" "+m+" = true; if ("+h+".length > "+S+") { ";var k=h+"["+S+"]";f.schema=F,f.schemaPath=a+"["+S+"]",f.errSchemaPath=l+"/"+S,f.errorPath=e.util.getPathExpr(e.errorPath,S,e.opts.jsonPointers,!0),f.dataPathArr[v]=S;var D=e.validate(f);f.baseId=w,e.util.varOccurences(D,y)<2?n+=" "+e.util.varReplace(D,y,k)+" ":n+=" var "+y+" = "+k+"; "+D+" ",n+=" }  ",c&&(n+=" if ("+m+") { ",p+="}")}if("object"==typeof b&&(e.opts.strictKeywords?"object"==typeof b&&0<Object.keys(b).length:e.util.schemaHasRules(b,e.RULES.all))){f.schema=b,f.schemaPath=e.schemaPath+".additionalItems",f.errSchemaPath=e.errSchemaPath+"/additionalItems",n+=" "+m+" = true; if ("+h+".length > "+s.length+") {  for (var "+g+" = "+s.length+"; "+g+" < "+h+".length; "+g+"++) { ",f.errorPath=e.util.getPathExpr(e.errorPath,g,e.opts.jsonPointers,!0);k=h+"["+g+"]";f.dataPathArr[v]=g;D=e.validate(f);f.baseId=w,e.util.varOccurences(D,y)<2?n+=" "+e.util.varReplace(D,y,k)+" ":n+=" var "+y+" = "+k+"; "+D+" ",c&&(n+=" if (!"+m+") break; "),n+=" } }  ",c&&(n+=" if ("+m+") { ",p+="}")}}else if(e.opts.strictKeywords?"object"==typeof s&&0<Object.keys(s).length:e.util.schemaHasRules(s,e.RULES.all)){f.schema=s,f.schemaPath=a,f.errSchemaPath=l,n+="  for (var "+g+" = 0; "+g+" < "+h+".length; "+g+"++) { ",f.errorPath=e.util.getPathExpr(e.errorPath,g,e.opts.jsonPointers,!0);k=h+"["+g+"]";f.dataPathArr[v]=g;D=e.validate(f);f.baseId=w,e.util.varOccurences(D,y)<2?n+=" "+e.util.varReplace(D,y,k)+" ":n+=" var "+y+" = "+k+"; "+D+" ",c&&(n+=" if (!"+m+") break; "),n+=" }"}return c&&(n+=" "+p+" if ("+u+" == errors) {"),n=e.util.cleanUpCode(n)}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n,r=" ",o=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),u=e.opts.$data&&a&&a.$data;n=u?(r+=" var schema"+o+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ","schema"+o):a,r+="var division"+o+";if (",u&&(r+=" "+n+" !== undefined && ( typeof "+n+" != 'number' || "),r+=" (division"+o+" = "+d+" / "+n+", ",e.opts.multipleOfPrecision?r+=" Math.abs(Math.round(division"+o+") - division"+o+") > 1e-"+e.opts.multipleOfPrecision+" ":r+=" division"+o+" !== parseInt(division"+o+") ",r+=" ) ",u&&(r+="  )  "),r+=" ) {   ";var f=f||[];f.push(r),r="",!1!==e.createErrors?(r+=" { keyword: 'multipleOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { multipleOf: "+n+" } ",!1!==e.opts.messages&&(r+=" , message: 'should be multiple of ",r+=u?"' + "+n:n+"'"),e.opts.verbose&&(r+=" , schema:  ",r+=u?"validate.schema"+l:""+a,r+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),r+=" } "):r+=" {} ";var p=r;return r=f.pop(),!e.compositeRule&&h?e.async?r+=" throw new ValidationError(["+p+"]); ":r+=" validate.errors = ["+p+"]; return false; ":r+=" var err = "+p+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+="} ",h&&(r+=" else { "),r}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="errs__"+r,u=e.util.copy(e);u.level++;var f="valid"+u.level;if(e.opts.strictKeywords?"object"==typeof s&&0<Object.keys(s).length:e.util.schemaHasRules(s,e.RULES.all)){u.schema=s,u.schemaPath=a,u.errSchemaPath=l,n+=" var "+d+" = errors;  ";var p,m=e.compositeRule;e.compositeRule=u.compositeRule=!0,u.createErrors=!1,u.opts.allErrors&&(p=u.opts.allErrors,u.opts.allErrors=!1),n+=" "+e.validate(u)+" ",u.createErrors=!0,p&&(u.opts.allErrors=p),e.compositeRule=u.compositeRule=m,n+=" if ("+f+") {   ";var g=g||[];g.push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: {} ",!1!==e.opts.messages&&(n+=" , message: 'should NOT be valid' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var v=n;n=g.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+v+"]); ":n+=" validate.errors = ["+v+"]; return false; ":n+=" var err = "+v+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } else {  errors = "+d+"; if (vErrors !== null) { if ("+d+") vErrors.length = "+d+"; else vErrors = null; } ",e.opts.allErrors&&(n+=" } ")}else n+="  var err =   ",!1!==e.createErrors?(n+=" { keyword: 'not' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: {} ",!1!==e.opts.messages&&(n+=" , message: 'should NOT be valid' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",c&&(n+=" if (false) { ");return n}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u="errs__"+r,f=e.util.copy(e),p="";f.level++;var m="valid"+f.level,g=f.baseId,v="prevValid"+r,y="passingSchemas"+r;n+="var "+u+" = errors , "+v+" = false , "+d+" = false , "+y+" = null; ";var w=e.compositeRule;e.compositeRule=f.compositeRule=!0;var b=s;if(b)for(var C,E=-1,A=b.length-1;E<A;)C=b[E+=1],(e.opts.strictKeywords?"object"==typeof C&&0<Object.keys(C).length:e.util.schemaHasRules(C,e.RULES.all))?(f.schema=C,f.schemaPath=a+"["+E+"]",f.errSchemaPath=l+"/"+E,n+="  "+e.validate(f)+" ",f.baseId=g):n+=" var "+m+" = true; ",E&&(n+=" if ("+m+" && "+v+") { "+d+" = false; "+y+" = ["+y+", "+E+"]; } else { ",p+="}"),n+=" if ("+m+") { "+d+" = "+v+" = true; "+y+" = "+E+"; }";return e.compositeRule=f.compositeRule=w,n+=p+"if (!"+d+") {   var err =   ",!1!==e.createErrors?(n+=" { keyword: 'oneOf' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { passingSchemas: "+y+" } ",!1!==e.opts.messages&&(n+=" , message: 'should match exactly one schema in oneOf' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&c&&(e.async?n+=" throw new ValidationError(vErrors); ":n+=" validate.errors = vErrors; return false; "),n+="} else {  errors = "+u+"; if (vErrors !== null) { if ("+u+") vErrors.length = "+u+"; else vErrors = null; }",e.opts.allErrors&&(n+=" } "),n}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n,r=" ",o=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),u=e.opts.$data&&a&&a.$data;n=u?(r+=" var schema"+o+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ","schema"+o):a,r+="if ( ",u&&(r+=" ("+n+" !== undefined && typeof "+n+" != 'string') || "),r+=" !"+(u?"(new RegExp("+n+"))":e.usePattern(a))+".test("+d+") ) {   ";var f=f||[];f.push(r),r="",!1!==e.createErrors?(r+=" { keyword: 'pattern' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { pattern:  ",r+=u?""+n:""+e.util.toQuotedString(a),r+="  } ",!1!==e.opts.messages&&(r+=" , message: 'should match pattern \"",r+=u?"' + "+n+" + '":""+e.util.escapeQuotes(a),r+="\"' "),e.opts.verbose&&(r+=" , schema:  ",r+=u?"validate.schema"+l:""+e.util.toQuotedString(a),r+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),r+=" } "):r+=" {} ";var p=r;return r=f.pop(),!e.compositeRule&&h?e.async?r+=" throw new ValidationError(["+p+"]); ":r+=" validate.errors = ["+p+"]; return false; ":r+=" var err = "+p+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+="} ",h&&(r+=" else { "),r}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="errs__"+r,u=e.util.copy(e),f="";u.level++;var p="valid"+u.level,m="key"+r,g="idx"+r,v=u.dataLevel=e.dataLevel+1,y="data"+v,w="dataProperties"+r,b=Object.keys(s||{}),C=e.schema.patternProperties||{},E=Object.keys(C),A=e.schema.additionalProperties,x=b.length||E.length,F=!1===A,S="object"==typeof A&&Object.keys(A).length,_=e.opts.removeAdditional,k=F||S||_,D=e.opts.ownProperties,$=e.baseId,B=e.schema.required;if(B&&(!e.opts.$data||!B.$data)&&B.length<e.opts.loopRequired)var T=e.util.toHash(B);if(n+="var "+d+" = errors;var "+p+" = true;",D&&(n+=" var "+w+" = undefined;"),k){if(n+=D?" "+w+" = "+w+" || Object.keys("+h+"); for (var "+g+"=0; "+g+"<"+w+".length; "+g+"++) { var "+m+" = "+w+"["+g+"]; ":" for (var "+m+" in "+h+") { ",x){if(n+=" var isAdditional"+r+" = !(false ",b.length)if(8<b.length)n+=" || validate.schema"+a+".hasOwnProperty("+m+") ";else{var L=b;if(L)for(var R=-1,P=L.length-1;R<P;)G=L[R+=1],n+=" || "+m+" == "+e.util.toQuotedString(G)+" "}if(E.length){var O=E;if(O)for(var M=-1,I=O.length-1;M<I;)re=O[M+=1],n+=" || "+e.usePattern(re)+".test("+m+") "}n+=" ); if (isAdditional"+r+") { "}if("all"==_)n+=" delete "+h+"["+m+"]; ";else{var N=e.errorPath,j="' + "+m+" + '";if(e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(e.errorPath,m,e.opts.jsonPointers)),F)if(_)n+=" delete "+h+"["+m+"]; ";else{n+=" "+p+" = false; ";var H=l;l=e.errSchemaPath+"/additionalProperties",(te=te||[]).push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'additionalProperties' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { additionalProperty: '"+j+"' } ",!1!==e.opts.messages&&(n+=" , message: '",e.opts._errorDataPathProperty?n+="is an invalid additional property":n+="should NOT have additional properties",n+="' "),e.opts.verbose&&(n+=" , schema: false , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var V=n;n=te.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+V+"]); ":n+=" validate.errors = ["+V+"]; return false; ":n+=" var err = "+V+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",l=H,c&&(n+=" break; ")}else if(S)if("failing"==_){n+=" var "+d+" = errors;  ";var W=e.compositeRule;e.compositeRule=u.compositeRule=!0,u.schema=A,u.schemaPath=e.schemaPath+".additionalProperties",u.errSchemaPath=e.errSchemaPath+"/additionalProperties",u.errorPath=e.opts._errorDataPathProperty?e.errorPath:e.util.getPathExpr(e.errorPath,m,e.opts.jsonPointers);var z=h+"["+m+"]";u.dataPathArr[v]=m;var U=e.validate(u);u.baseId=$,e.util.varOccurences(U,y)<2?n+=" "+e.util.varReplace(U,y,z)+" ":n+=" var "+y+" = "+z+"; "+U+" ",n+=" if (!"+p+") { errors = "+d+"; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete "+h+"["+m+"]; }  ",e.compositeRule=u.compositeRule=W}else{u.schema=A,u.schemaPath=e.schemaPath+".additionalProperties",u.errSchemaPath=e.errSchemaPath+"/additionalProperties",u.errorPath=e.opts._errorDataPathProperty?e.errorPath:e.util.getPathExpr(e.errorPath,m,e.opts.jsonPointers);z=h+"["+m+"]";u.dataPathArr[v]=m;U=e.validate(u);u.baseId=$,e.util.varOccurences(U,y)<2?n+=" "+e.util.varReplace(U,y,z)+" ":n+=" var "+y+" = "+z+"; "+U+" ",c&&(n+=" if (!"+p+") break; ")}e.errorPath=N}x&&(n+=" } "),n+=" }  ",c&&(n+=" if ("+p+") { ",f+="}")}var K=e.opts.useDefaults&&!e.compositeRule;if(b.length){var q=b;if(q)for(var G,Q=-1,J=q.length-1;Q<J;){var Y=s[G=q[Q+=1]];if(e.opts.strictKeywords?"object"==typeof Y&&0<Object.keys(Y).length:e.util.schemaHasRules(Y,e.RULES.all)){var X=e.util.getProperty(G),Z=(z=h+X,K&&void 0!==Y.default);u.schema=Y,u.schemaPath=a+X,u.errSchemaPath=l+"/"+e.util.escapeFragment(G),u.errorPath=e.util.getPath(e.errorPath,G,e.opts.jsonPointers),u.dataPathArr[v]=e.util.toQuotedString(G);U=e.validate(u);if(u.baseId=$,e.util.varOccurences(U,y)<2){U=e.util.varReplace(U,y,z);var ee=z}else{ee=y;n+=" var "+y+" = "+z+"; "}if(Z)n+=" "+U+" ";else{if(T&&T[G]){n+=" if ( "+ee+" === undefined ",D&&(n+=" || ! Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(G)+"') "),n+=") { "+p+" = false; ";N=e.errorPath,H=l;var te,ie=e.util.escapeQuotes(G);e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(N,G,e.opts.jsonPointers)),l=e.errSchemaPath+"/required",(te=te||[]).push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+ie+"' } ",!1!==e.opts.messages&&(n+=" , message: '",e.opts._errorDataPathProperty?n+="is a required property":n+="should have required property \\'"+ie+"\\'",n+="' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";V=n;n=te.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+V+"]); ":n+=" validate.errors = ["+V+"]; return false; ":n+=" var err = "+V+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",l=H,e.errorPath=N,n+=" } else { "}else c?(n+=" if ( "+ee+" === undefined ",D&&(n+=" || ! Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(G)+"') "),n+=") { "+p+" = true; } else { "):(n+=" if ("+ee+" !== undefined ",D&&(n+=" &&   Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(G)+"') "),n+=" ) { ");n+=" "+U+" } "}}c&&(n+=" if ("+p+") { ",f+="}")}}if(E.length){var ne=E;if(ne)for(var re,oe=-1,se=ne.length-1;oe<se;){Y=C[re=ne[oe+=1]];if(e.opts.strictKeywords?"object"==typeof Y&&0<Object.keys(Y).length:e.util.schemaHasRules(Y,e.RULES.all)){u.schema=Y,u.schemaPath=e.schemaPath+".patternProperties"+e.util.getProperty(re),u.errSchemaPath=e.errSchemaPath+"/patternProperties/"+e.util.escapeFragment(re),n+=D?" "+w+" = "+w+" || Object.keys("+h+"); for (var "+g+"=0; "+g+"<"+w+".length; "+g+"++) { var "+m+" = "+w+"["+g+"]; ":" for (var "+m+" in "+h+") { ",n+=" if ("+e.usePattern(re)+".test("+m+")) { ",u.errorPath=e.util.getPathExpr(e.errorPath,m,e.opts.jsonPointers);z=h+"["+m+"]";u.dataPathArr[v]=m;U=e.validate(u);u.baseId=$,e.util.varOccurences(U,y)<2?n+=" "+e.util.varReplace(U,y,z)+" ":n+=" var "+y+" = "+z+"; "+U+" ",c&&(n+=" if (!"+p+") break; "),n+=" } ",c&&(n+=" else "+p+" = true; "),n+=" }  ",c&&(n+=" if ("+p+") { ",f+="}")}}}return c&&(n+=" "+f+" if ("+d+" == errors) {"),n=e.util.cleanUpCode(n)}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="errs__"+r,u=e.util.copy(e);u.level++;var f="valid"+u.level;if(n+="var "+d+" = errors;",e.opts.strictKeywords?"object"==typeof s&&0<Object.keys(s).length:e.util.schemaHasRules(s,e.RULES.all)){u.schema=s,u.schemaPath=a,u.errSchemaPath=l;var p="key"+r,m="idx"+r,g="i"+r,v="' + "+p+" + '",y="data"+(u.dataLevel=e.dataLevel+1),w="dataProperties"+r,b=e.opts.ownProperties,C=e.baseId;b&&(n+=" var "+w+" = undefined; "),n+=b?" "+w+" = "+w+" || Object.keys("+h+"); for (var "+m+"=0; "+m+"<"+w+".length; "+m+"++) { var "+p+" = "+w+"["+m+"]; ":" for (var "+p+" in "+h+") { ",n+=" var startErrs"+r+" = errors; ";var E=p,A=e.compositeRule;e.compositeRule=u.compositeRule=!0;var x=e.validate(u);u.baseId=C,e.util.varOccurences(x,y)<2?n+=" "+e.util.varReplace(x,y,E)+" ":n+=" var "+y+" = "+E+"; "+x+" ",e.compositeRule=u.compositeRule=A,
n+=" if (!"+f+") { for (var "+g+"=startErrs"+r+"; "+g+"<errors; "+g+"++) { vErrors["+g+"].propertyName = "+p+"; }   var err =   ",!1!==e.createErrors?(n+=" { keyword: 'propertyNames' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { propertyName: '"+v+"' } ",!1!==e.opts.messages&&(n+=" , message: 'property name \\'"+v+"\\' is invalid' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&c&&(e.async?n+=" throw new ValidationError(vErrors); ":n+=" validate.errors = vErrors; return false; "),c&&(n+=" break; "),n+=" } }"}return c&&(n+="  if ("+d+" == errors) {"),n=e.util.cleanUpCode(n)}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n=" ",r=e.level,o=e.dataLevel,s=e.schema[t],a=e.schemaPath+e.util.getProperty(t),l=e.errSchemaPath+"/"+t,c=!e.opts.allErrors,h="data"+(o||""),d="valid"+r,u=e.opts.$data&&s&&s.$data;u&&(n+=" var schema"+r+" = "+e.util.getData(s.$data,o,e.dataPathArr)+"; ");var f="schema"+r;if(!u)if(s.length<e.opts.loopRequired&&e.schema.properties&&Object.keys(e.schema.properties).length){var p=[],m=s;if(m)for(var g,v=-1,y=m.length-1;v<y;){g=m[v+=1];var w=e.schema.properties[g];w&&(e.opts.strictKeywords?"object"==typeof w&&0<Object.keys(w).length:e.util.schemaHasRules(w,e.RULES.all))||(p[p.length]=g)}}else p=s;if(u||p.length){var b=e.errorPath,C=u||p.length>=e.opts.loopRequired,E=e.opts.ownProperties;if(c)if(n+=" var missing"+r+"; ",C){u||(n+=" var "+f+" = validate.schema"+a+"; ");var A="' + "+(D="schema"+r+"["+(S="i"+r)+"]")+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(b,D,e.opts.jsonPointers)),n+=" var "+d+" = true; ",u&&(n+=" if (schema"+r+" === undefined) "+d+" = true; else if (!Array.isArray(schema"+r+")) "+d+" = false; else {"),n+=" for (var "+S+" = 0; "+S+" < "+f+".length; "+S+"++) { "+d+" = "+h+"["+f+"["+S+"]] !== undefined ",E&&(n+=" &&   Object.prototype.hasOwnProperty.call("+h+", "+f+"["+S+"]) "),n+="; if (!"+d+") break; } ",u&&(n+="  }  "),(k=k||[]).push(n+="  if (!"+d+") {   "),n="",!1!==e.createErrors?(n+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+A+"' } ",!1!==e.opts.messages&&(n+=" , message: '",e.opts._errorDataPathProperty?n+="is a required property":n+="should have required property \\'"+A+"\\'",n+="' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";var x=n;n=k.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+x+"]); ":n+=" validate.errors = ["+x+"]; return false; ":n+=" var err = "+x+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } else { "}else{n+=" if ( ";var F=p;if(F)for(var S=-1,_=F.length-1;S<_;){B=F[S+=1],S&&(n+=" || "),n+=" ( ( "+(P=h+(R=e.util.getProperty(B)))+" === undefined ",E&&(n+=" || ! Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(B)+"') "),n+=") && (missing"+r+" = "+e.util.toQuotedString(e.opts.jsonPointers?B:R)+") ) "}n+=") {  ";var k;A="' + "+(D="missing"+r)+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.opts.jsonPointers?e.util.getPathExpr(b,D,!0):b+" + "+D),(k=k||[]).push(n),n="",!1!==e.createErrors?(n+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+A+"' } ",!1!==e.opts.messages&&(n+=" , message: '",e.opts._errorDataPathProperty?n+="is a required property":n+="should have required property \\'"+A+"\\'",n+="' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ";x=n;n=k.pop(),!e.compositeRule&&c?e.async?n+=" throw new ValidationError(["+x+"]); ":n+=" validate.errors = ["+x+"]; return false; ":n+=" var err = "+x+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",n+=" } else { "}else if(C){u||(n+=" var "+f+" = validate.schema"+a+"; ");var D;A="' + "+(D="schema"+r+"["+(S="i"+r)+"]")+" + '";e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPathExpr(b,D,e.opts.jsonPointers)),u&&(n+=" if ("+f+" && !Array.isArray("+f+")) {  var err =   ",!1!==e.createErrors?(n+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+A+"' } ",!1!==e.opts.messages&&(n+=" , message: '",e.opts._errorDataPathProperty?n+="is a required property":n+="should have required property \\'"+A+"\\'",n+="' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if ("+f+" !== undefined) { "),n+=" for (var "+S+" = 0; "+S+" < "+f+".length; "+S+"++) { if ("+h+"["+f+"["+S+"]] === undefined ",E&&(n+=" || ! Object.prototype.hasOwnProperty.call("+h+", "+f+"["+S+"]) "),n+=") {  var err =   ",!1!==e.createErrors?(n+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+A+"' } ",!1!==e.opts.messages&&(n+=" , message: '",e.opts._errorDataPathProperty?n+="is a required property":n+="should have required property \\'"+A+"\\'",n+="' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ",u&&(n+="  }  ")}else{var $=p;if($)for(var B,T=-1,L=$.length-1;T<L;){B=$[T+=1];var R=e.util.getProperty(B),P=(A=e.util.escapeQuotes(B),h+R);e.opts._errorDataPathProperty&&(e.errorPath=e.util.getPath(b,B,e.opts.jsonPointers)),n+=" if ( "+P+" === undefined ",E&&(n+=" || ! Object.prototype.hasOwnProperty.call("+h+", '"+e.util.escapeQuotes(B)+"') "),n+=") {  var err =   ",!1!==e.createErrors?(n+=" { keyword: 'required' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(l)+" , params: { missingProperty: '"+A+"' } ",!1!==e.opts.messages&&(n+=" , message: '",e.opts._errorDataPathProperty?n+="is a required property":n+="should have required property \\'"+A+"\\'",n+="' "),e.opts.verbose&&(n+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+h+" "),n+=" } "):n+=" {} ",n+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}e.errorPath=b}else c&&(n+=" if (true) {");return n}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n,r=" ",o=e.level,s=e.dataLevel,a=e.schema[t],l=e.schemaPath+e.util.getProperty(t),c=e.errSchemaPath+"/"+t,h=!e.opts.allErrors,d="data"+(s||""),u="valid"+o,f=e.opts.$data&&a&&a.$data;if(n=f?(r+=" var schema"+o+" = "+e.util.getData(a.$data,s,e.dataPathArr)+"; ","schema"+o):a,(a||f)&&!1!==e.opts.uniqueItems){f&&(r+=" var "+u+"; if ("+n+" === false || "+n+" === undefined) "+u+" = true; else if (typeof "+n+" != 'boolean') "+u+" = false; else { "),r+=" var i = "+d+".length , "+u+" = true , j; if (i > 1) { ";var p=e.schema.items&&e.schema.items.type,m=Array.isArray(p);if(!p||"object"==p||"array"==p||m&&(0<=p.indexOf("object")||0<=p.indexOf("array")))r+=" outer: for (;i--;) { for (j = i; j--;) { if (equal("+d+"[i], "+d+"[j])) { "+u+" = false; break outer; } } } ";else{r+=" var itemIndices = {}, item; for (;i--;) { var item = "+d+"[i]; ";var g="checkDataType"+(m?"s":"");r+=" if ("+e.util[g](p,"item",!0)+") continue; ",m&&(r+=" if (typeof item == 'string') item = '\"' + item; "),r+=" if (typeof itemIndices[item] == 'number') { "+u+" = false; j = itemIndices[item]; break; } itemIndices[item] = i; } "}r+=" } ",f&&(r+="  }  "),r+=" if (!"+u+") {   ";var v=v||[];v.push(r),r="",!1!==e.createErrors?(r+=" { keyword: 'uniqueItems' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(c)+" , params: { i: i, j: j } ",!1!==e.opts.messages&&(r+=" , message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)' "),e.opts.verbose&&(r+=" , schema:  ",r+=f?"validate.schema"+l:""+a,r+="         , parentSchema: validate.schema"+e.schemaPath+" , data: "+d+" "),r+=" } "):r+=" {} ";var y=r;r=v.pop(),!e.compositeRule&&h?e.async?r+=" throw new ValidationError(["+y+"]); ":r+=" validate.errors = ["+y+"]; return false; ":r+=" var err = "+y+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",r+=" } ",h&&(r+=" else { ")}else h&&(r+=" if (true) { ");return r}},function(e,t,i){"use strict";var l=["multipleOf","maximum","exclusiveMaximum","minimum","exclusiveMinimum","maxLength","minLength","pattern","additionalItems","maxItems","minItems","uniqueItems","maxProperties","minProperties","required","additionalProperties","enum","format","const"];e.exports=function(e,t){for(var i=0;i<t.length;i++){e=JSON.parse(JSON.stringify(e));var n,r=t[i].split("/"),o=e;for(n=1;n<r.length;n++)o=o[r[n]];for(n=0;n<l.length;n++){var s=l[n],a=o[s];a&&(o[s]={anyOf:[a,{$ref:"https://raw.githubusercontent.com/epoberezkin/ajv/master/lib/refs/data.json#"}]})}}return e}},function(e,t,i){"use strict";var r=i(8).MissingRef;e.exports=function i(t,s,n){var a=this;if("function"!=typeof this._opts.loadSchema)throw new Error("options.loadSchema should be a function");"function"==typeof s&&(n=s,s=void 0);var e=l(t).then(function(){var e=a._addSchema(t,void 0,s);return e.validate||c(e)});n&&e.then(function(e){n(null,e)},n);return e;function l(e){var t=e.$schema;return t&&!a.getSchema(t)?i.call(a,{$ref:t},!0):Promise.resolve()}function c(o){try{return a._compile(o)}catch(e){if(e instanceof r)return t(e);throw e}function t(e){var t=e.missingSchema;if(r(t))throw new Error("Schema "+t+" is loaded but "+e.missingRef+" cannot be resolved");var i=a._loadingSchemas[t];return i||(i=a._loadingSchemas[t]=a._opts.loadSchema(t)).then(n,n),i.then(function(e){if(!r(t))return l(e).then(function(){r(t)||a.addSchema(e,t,void 0,s)})}).then(function(){return c(o)});function n(){delete a._loadingSchemas[t]}function r(e){return a._refs[e]||a._schemas[e]}}}}},function(e,t,i){"use strict";var s=/^[a-z_$][a-z0-9_$-]*$/i,l=i(61),r=i(62);e.exports={add:function(e,t){var a=this.RULES;if(a.keywords[e])throw new Error("Keyword "+e+" is already defined");if(!s.test(e))throw new Error("Keyword "+e+" is not a valid identifier");if(t){this.validateKeyword(t,!0);var i=t.type;if(Array.isArray(i))for(var n=0;n<i.length;n++)o(e,i[n],t);else o(e,i,t);var r=t.metaSchema;r&&(t.$data&&this._opts.$data&&(r={anyOf:[r,{$ref:"https://raw.githubusercontent.com/epoberezkin/ajv/master/lib/refs/data.json#"}]}),t.validateSchema=this.compile(r,!0))}function o(e,t,i){for(var n,r=0;r<a.length;r++){var o=a[r];if(o.type==t){n=o;break}}n||(n={type:t,rules:[]},a.push(n));var s={keyword:e,definition:i,custom:!0,code:l,implements:i.implements};n.rules.push(s),a.custom[e]=s}return a.keywords[e]=a.all[e]=!0,this},get:function(e){var t=this.RULES.custom[e];return t?t.definition:this.RULES.keywords[e]||!1},remove:function(e){var t=this.RULES;delete t.keywords[e],delete t.all[e],delete t.custom[e];for(var i=0;i<t.length;i++)for(var n=t[i].rules,r=0;r<n.length;r++)if(n[r].keyword==e){n.splice(r,1);break}return this},validate:function e(t,i){e.errors=null;var n=this._validateKeyword=this._validateKeyword||this.compile(r,!0);if(n(t))return!0;e.errors=n.errors;{if(i)throw new Error("custom keyword definition is invalid: "+this.errorsText(n.errors));return!1}}}},function(e,t,i){"use strict";e.exports=function(e,t,i){var n,r,o=" ",s=e.level,a=e.dataLevel,l=e.schema[t],c=e.schemaPath+e.util.getProperty(t),h=e.errSchemaPath+"/"+t,d=!e.opts.allErrors,u="data"+(a||""),f="valid"+s,p="errs__"+s,m=e.opts.$data&&l&&l.$data;r=m?(o+=" var schema"+s+" = "+e.util.getData(l.$data,a,e.dataPathArr)+"; ","schema"+s):l;var g,v,y,w,b,C=this,E="definition"+s,A=C.definition,x="";if(m&&A.$data){b="keywordValidate"+s;var F=A.validateSchema;o+=" var "+E+" = RULES.custom['"+t+"'].definition; var "+b+" = "+E+".validate;"}else{if(!(w=e.useCustomRule(C,l,e.schema,e)))return;r="validate.schema"+c,b=w.code,g=A.compile,v=A.inline,y=A.macro}var S=b+".errors",_="i"+s,k="ruleErr"+s,D=A.async;if(D&&!e.async)throw new Error("async keyword in sync schema");if(v||y||(o+=S+" = null;"),o+="var "+p+" = errors;var "+f+";",m&&A.$data&&(x+="}",o+=" if ("+r+" === undefined) { "+f+" = true; } else { ",F&&(x+="}",o+=" "+f+" = "+E+".validateSchema("+r+"); if ("+f+") { ")),v)A.statements?o+=" "+w.validate+" ":o+=" "+f+" = "+w.validate+"; ";else if(y){var $=e.util.copy(e);x="";$.level++;var B="valid"+$.level;$.schema=w.validate,$.schemaPath="";var T=e.compositeRule;e.compositeRule=$.compositeRule=!0;var L=e.validate($).replace(/validate\.schema/g,b);e.compositeRule=$.compositeRule=T,o+=" "+L}else{(M=M||[]).push(o),o="",o+="  "+b+".call( ",e.opts.passContext?o+="this":o+="self",g||!1===A.schema?o+=" , "+u+" ":o+=" , "+r+" , "+u+" , validate.schema"+e.schemaPath+" ",o+=" , (dataPath || '')",'""'!=e.errorPath&&(o+=" + "+e.errorPath);var R=a?"data"+(a-1||""):"parentData",P=a?e.dataPathArr[a]:"parentDataProperty",O=o+=" , "+R+" , "+P+" , rootData )  ";o=M.pop(),!1===A.errors?(o+=" "+f+" = ",D&&(o+="await "),o+=O+"; "):o+=D?" var "+(S="customErrors"+s)+" = null; try { "+f+" = await "+O+"; } catch (e) { "+f+" = false; if (e instanceof ValidationError) "+S+" = e.errors; else throw e; } ":" "+S+" = null; "+f+" = "+O+"; "}if(A.modifying&&(o+=" if ("+R+") "+u+" = "+R+"["+P+"];"),o+=""+x,A.valid)d&&(o+=" if (true) { ");else{var M;o+=" if ( ",void 0===A.valid?(o+=" !",o+=y?""+B:f):o+=" "+!A.valid+" ",o+=") { ",n=C.keyword,(M=M||[]).push(o),(M=M||[]).push(o=""),o="",!1!==e.createErrors?(o+=" { keyword: '"+(n||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { keyword: '"+C.keyword+"' } ",!1!==e.opts.messages&&(o+=" , message: 'should pass \""+C.keyword+"\" keyword validation' "),e.opts.verbose&&(o+=" , schema: validate.schema"+c+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ";var I=o;o=M.pop(),!e.compositeRule&&d?e.async?o+=" throw new ValidationError(["+I+"]); ":o+=" validate.errors = ["+I+"]; return false; ":o+=" var err = "+I+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";var N=o;o=M.pop(),v?A.errors?"full"!=A.errors&&(o+="  for (var "+_+"="+p+"; "+_+"<errors; "+_+"++) { var "+k+" = vErrors["+_+"]; if ("+k+".dataPath === undefined) "+k+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+k+".schemaPath === undefined) { "+k+'.schemaPath = "'+h+'"; } ',e.opts.verbose&&(o+=" "+k+".schema = "+r+"; "+k+".data = "+u+"; "),o+=" } "):!1===A.errors?o+=" "+N+" ":(o+=" if ("+p+" == errors) { "+N+" } else {  for (var "+_+"="+p+"; "+_+"<errors; "+_+"++) { var "+k+" = vErrors["+_+"]; if ("+k+".dataPath === undefined) "+k+".dataPath = (dataPath || '') + "+e.errorPath+"; if ("+k+".schemaPath === undefined) { "+k+'.schemaPath = "'+h+'"; } ',e.opts.verbose&&(o+=" "+k+".schema = "+r+"; "+k+".data = "+u+"; "),o+=" } } "):y?(o+="   var err =   ",!1!==e.createErrors?(o+=" { keyword: '"+(n||"custom")+"' , dataPath: (dataPath || '') + "+e.errorPath+" , schemaPath: "+e.util.toQuotedString(h)+" , params: { keyword: '"+C.keyword+"' } ",!1!==e.opts.messages&&(o+=" , message: 'should pass \""+C.keyword+"\" keyword validation' "),e.opts.verbose&&(o+=" , schema: validate.schema"+c+" , parentSchema: validate.schema"+e.schemaPath+" , data: "+u+" "),o+=" } "):o+=" {} ",o+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!e.compositeRule&&d&&(e.async?o+=" throw new ValidationError(vErrors); ":o+=" validate.errors = vErrors; return false; ")):!1===A.errors?o+=" "+N+" ":(o+=" if (Array.isArray("+S+")) { if (vErrors === null) vErrors = "+S+"; else vErrors = vErrors.concat("+S+"); errors = vErrors.length;  for (var "+_+"="+p+"; "+_+"<errors; "+_+"++) { var "+k+" = vErrors["+_+"]; if ("+k+".dataPath === undefined) "+k+".dataPath = (dataPath || '') + "+e.errorPath+";  "+k+'.schemaPath = "'+h+'";  ',e.opts.verbose&&(o+=" "+k+".schema = "+r+"; "+k+".data = "+u+"; "),o+=" } } else { "+N+" } "),o+=" } ",d&&(o+=" else { ")}return o}},function(e,t,i){"use strict";var n=i(19);e.exports={$id:"https://github.com/epoberezkin/ajv/blob/master/lib/definition_schema.js",definitions:{simpleTypes:n.definitions.simpleTypes},type:"object",dependencies:{schema:["validate"],$data:["validate"],statements:["inline"],valid:{not:{required:["macro"]}}},properties:{type:n.properties.type,schema:{type:"boolean"},statements:{type:"boolean"},dependencies:{type:"array",items:{type:"string"}},metaSchema:{type:"object"},modifying:{type:"boolean"},valid:{type:"boolean"},$data:{type:"boolean"},async:{type:"boolean"},errors:{anyOf:[{type:"boolean"},{const:"full"}]}}}},function(e){e.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"https://raw.githubusercontent.com/epoberezkin/ajv/master/lib/refs/data.json#","description":"Meta-schema for $data reference (JSON Schema extension proposal)","type":"object","required":["$data"],"properties":{"$data":{"type":"string","anyOf":[{"format":"relative-json-pointer"},{"format":"json-pointer"}]}},"additionalProperties":false}')},function(e,t,w){!function(){var e=function(){return this}();e||"undefined"==typeof window||(e=window);var o=function(e,t,i){"string"==typeof e?(2==arguments.length&&(i=t),o.modules[e]||(o.payloads[e]=i,o.modules[e]=null)):o.original?o.original.apply(this,arguments):(console.error("dropping module because define wasn't a string."),console.trace())};o.modules={},o.payloads={};function s(e,t,i){if("string"==typeof t){var n=c(e,t);if(null!=n)return i&&i(),n}else if("[object Array]"===Object.prototype.toString.call(t)){for(var r=[],o=0,s=t.length;o<s;++o){var a=c(e,t[o]);if(null==a&&l.original)return;r.push(a)}return i&&i.apply(null,r)||!0}}var t,i,l=function(e,t){var i=s("",e,t);return null==i&&l.original?l.original.apply(this,arguments):i},a=function(e,t){if(-1!==t.indexOf("!")){var i=t.split("!");return a(e,i[0])+"!"+a(e,i[1])}if("."==t.charAt(0))for(t=e.split("/").slice(0,-1).join("/")+"/"+t;-1!==t.indexOf(".")&&n!=t;){var n=t;t=t.replace(/\/\.\//,"/").replace(/[^\/]+\/\.\.\//,"")}return t},c=function(e,i){i=a(e,i);var t=o.modules[i];if(!t){if("function"==typeof(t=o.payloads[i])){var n={},r={id:i,uri:"",exports:n,packaged:!0};n=t(function(e,t){return s(i,e,t)},n,r)||r.exports,o.modules[i]=n,delete o.payloads[i]}t=o.modules[i]=n||t}return t};i=e,(t="ace")&&(e[t]||(e[t]={}),i=e[t]),i.define&&i.define.packaged||(o.original=i.define,i.define=o,i.define.packaged=!0),i.acequire&&i.acequire.packaged||(l.original=i.acequire,i.acequire=l,i.acequire.packaged=!0)}(),ace.define("ace/lib/regexp",["require","exports","module"],function(e,t,i){"use strict";var n,o={exec:RegExp.prototype.exec,test:RegExp.prototype.test,match:String.prototype.match,replace:String.prototype.replace,split:String.prototype.split},s=void 0===o.exec.call(/()??/,"")[1],a=(n=/^/g,o.test.call(n,""),!n.lastIndex);a&&s||(RegExp.prototype.exec=function(e){var t,i,n=o.exec.apply(this,arguments);if("string"==typeof e&&n){if(!s&&1<n.length&&-1<function(e,t,i){if(Array.prototype.indexOf)return e.indexOf(t,i);for(var n=i||0;n<e.length;n++)if(e[n]===t)return n;return-1}(n,"")&&(i=RegExp(this.source,o.replace.call(function(e){return(e.global?"g":"")+(e.ignoreCase?"i":"")+(e.multiline?"m":"")+(e.extended?"x":"")+(e.sticky?"y":"")}(this),"g","")),o.replace.call(e.slice(n.index),i,function(){for(var e=1;e<arguments.length-2;e++)void 0===arguments[e]&&(n[e]=void 0)})),this._xregexp&&this._xregexp.captureNames)for(var r=1;r<n.length;r++)(t=this._xregexp.captureNames[r-1])&&(n[t]=n[r]);!a&&this.global&&!n[0].length&&this.lastIndex>n.index&&this.lastIndex--}return n},a||(RegExp.prototype.test=function(e){var t=o.exec.call(this,e);return t&&this.global&&!t[0].length&&this.lastIndex>t.index&&this.lastIndex--,!!t}))}),ace.define("ace/lib/es5-shim",["require","exports","module"],function(e,t,i){function o(){}Function.prototype.bind||(Function.prototype.bind=function(t){var i=this;if("function"!=typeof i)throw new TypeError("Function.prototype.bind called on incompatible "+i);var n=u.call(arguments,1),r=function(){if(this instanceof r){var e=i.apply(this,n.concat(u.call(arguments)));return Object(e)===e?e:this}return i.apply(t,n.concat(u.call(arguments)))};return i.prototype&&(o.prototype=i.prototype,r.prototype=new o,o.prototype=null),r});var r,s,a,l,c,n=Function.prototype.call,h=Array.prototype,d=Object.prototype,u=h.slice,f=n.bind(d.toString),p=n.bind(d.hasOwnProperty);if((c=p(d,"__defineGetter__"))&&(r=n.bind(d.__defineGetter__),s=n.bind(d.__defineSetter__),a=n.bind(d.__lookupGetter__),l=n.bind(d.__lookupSetter__)),2!=[1,2].splice(0).length)if(function(){function e(e){var t=new Array(e+2);return t[0]=t[1]=0,t}var t,i=[];if(i.splice.apply(i,e(20)),i.splice.apply(i,e(26)),t=i.length,i.splice(5,0,"XXX"),i.length,t+1==i.length)return!0}()){var m=Array.prototype.splice;Array.prototype.splice=function(e,t){return arguments.length?m.apply(this,[void 0===e?0:e,void 0===t?this.length-e:t].concat(u.call(arguments,2))):[]}}else Array.prototype.splice=function(e,t){var i=this.length;0<e?i<e&&(e=i):null==e?e=0:e<0&&(e=Math.max(i+e,0)),e+t<i||(t=i-e);var n=this.slice(e,e+t),r=u.call(arguments,2),o=r.length;if(e===i)o&&this.push.apply(this,r);else{var s=Math.min(t,i-e),a=e+s,l=a+o-s,c=i-a,h=i-s;if(l<a)for(var d=0;d<c;++d)this[l+d]=this[a+d];else if(a<l)for(d=c;d--;)this[l+d]=this[a+d];if(o&&e===h)this.length=h,this.push.apply(this,r);else for(this.length=h+o,d=0;d<o;++d)this[e+d]=r[d]}return n};Array.isArray||(Array.isArray=function(e){return"[object Array]"==f(e)});var g,v=Object("a"),y="a"!=v[0]||!(0 in v);if(Array.prototype.forEach||(Array.prototype.forEach=function(e,t){var i=B(this),n=y&&"[object String]"==f(this)?this.split(""):i,r=t,o=-1,s=n.length>>>0;if("[object Function]"!=f(e))throw new TypeError;for(;++o<s;)o in n&&e.call(r,n[o],o,i)}),Array.prototype.map||(Array.prototype.map=function(e,t){var i=B(this),n=y&&"[object String]"==f(this)?this.split(""):i,r=n.length>>>0,o=Array(r),s=t;if("[object Function]"!=f(e))throw new TypeError(e+" is not a function");for(var a=0;a<r;a++)a in n&&(o[a]=e.call(s,n[a],a,i));return o}),Array.prototype.filter||(Array.prototype.filter=function(e,t){var i,n=B(this),r=y&&"[object String]"==f(this)?this.split(""):n,o=r.length>>>0,s=[],a=t;if("[object Function]"!=f(e))throw new TypeError(e+" is not a function");for(var l=0;l<o;l++)l in r&&(i=r[l],e.call(a,i,l,n)&&s.push(i));return s}),Array.prototype.every||(Array.prototype.every=function(e,t){var i=B(this),n=y&&"[object String]"==f(this)?this.split(""):i,r=n.length>>>0,o=t;if("[object Function]"!=f(e))throw new TypeError(e+" is not a function");for(var s=0;s<r;s++)if(s in n&&!e.call(o,n[s],s,i))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(e,t){var i=B(this),n=y&&"[object String]"==f(this)?this.split(""):i,r=n.length>>>0,o=t;if("[object Function]"!=f(e))throw new TypeError(e+" is not a function");for(var s=0;s<r;s++)if(s in n&&e.call(o,n[s],s,i))return!0;return!1}),Array.prototype.reduce||(Array.prototype.reduce=function(e,t){var i=B(this),n=y&&"[object String]"==f(this)?this.split(""):i,r=n.length>>>0;if("[object Function]"!=f(e))throw new TypeError(e+" is not a function");if(!r&&1==arguments.length)throw new TypeError("reduce of empty array with no initial value");var o,s=0;if(2<=arguments.length)o=t;else for(;;){if(s in n){o=n[s++];break}if(++s>=r)throw new TypeError("reduce of empty array with no initial value")}for(;s<r;s++)s in n&&(o=e.call(void 0,o,n[s],s,i));return o}),Array.prototype.reduceRight||(Array.prototype.reduceRight=function(e,t){var i=B(this),n=y&&"[object String]"==f(this)?this.split(""):i,r=n.length>>>0;if("[object Function]"!=f(e))throw new TypeError(e+" is not a function");if(!r&&1==arguments.length)throw new TypeError("reduceRight of empty array with no initial value");var o,s=r-1;if(2<=arguments.length)o=t;else for(;;){if(s in n){o=n[s--];break}if(--s<0)throw new TypeError("reduceRight of empty array with no initial value")}for(;s in this&&(o=e.call(void 0,o,n[s],s,i)),s--;);return o}),Array.prototype.indexOf&&-1==[0,1].indexOf(1,2)||(Array.prototype.indexOf=function(e,t){var i=y&&"[object String]"==f(this)?this.split(""):B(this),n=i.length>>>0;if(!n)return-1;var r=0;for(1<arguments.length&&(r=$(t)),r=0<=r?r:Math.max(0,n+r);r<n;r++)if(r in i&&i[r]===e)return r;return-1}),Array.prototype.lastIndexOf&&-1==[0,1].lastIndexOf(0,-3)||(Array.prototype.lastIndexOf=function(e,t){var i=y&&"[object String]"==f(this)?this.split(""):B(this),n=i.length>>>0;if(!n)return-1;var r=n-1;for(1<arguments.length&&(r=Math.min(r,$(t))),r=0<=r?r:n-Math.abs(r);0<=r;r--)if(r in i&&e===i[r])return r;return-1}),Object.getPrototypeOf||(Object.getPrototypeOf=function(e){return e.__proto__||(e.constructor?e.constructor.prototype:d)}),!Object.getOwnPropertyDescriptor){Object.getOwnPropertyDescriptor=function(e,t){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.getOwnPropertyDescriptor called on a non-object: "+e);if(p(e,t)){var i;if(i={enumerable:!0,configurable:!0},c){var n=e.__proto__;e.__proto__=d;var r=a(e,t),o=l(e,t);if(e.__proto__=n,r||o)return r&&(i.get=r),o&&(i.set=o),i}return i.value=e[t],i}}}Object.getOwnPropertyNames||(Object.getOwnPropertyNames=function(e){return Object.keys(e)}),Object.create||(g=null===Object.prototype.__proto__?function(){return{__proto__:null}}:function(){var e={};for(var t in e)e[t]=null;return e.constructor=e.hasOwnProperty=e.propertyIsEnumerable=e.isPrototypeOf=e.toLocaleString=e.toString=e.valueOf=e.__proto__=null,e},Object.create=function(e,t){var i;if(null===e)i=g();else{if("object"!=typeof e)throw new TypeError("typeof prototype["+typeof e+"] != 'object'");function n(){}n.prototype=e,(i=new n).__proto__=e}return void 0!==t&&Object.defineProperties(i,t),i});function w(e){try{return Object.defineProperty(e,"sentinel",{}),"sentinel"in e}catch(e){}}if(Object.defineProperty){var b=w({}),C="undefined"==typeof document||w(document.createElement("div"));if(!b||!C)var E=Object.defineProperty}if(!Object.defineProperty||E){Object.defineProperty=function(e,t,i){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.defineProperty called on non-object: "+e);if("object"!=typeof i&&"function"!=typeof i||null===i)throw new TypeError("Property description must be an object: "+i);if(E)try{return E.call(Object,e,t,i)}catch(e){}if(p(i,"value"))if(c&&(a(e,t)||l(e,t))){var n=e.__proto__;e.__proto__=d,delete e[t],e[t]=i.value,e.__proto__=n}else e[t]=i.value;else{if(!c)throw new TypeError("getters & setters can not be defined on this javascript engine");p(i,"get")&&r(e,t,i.get),p(i,"set")&&s(e,t,i.set)}return e}}Object.defineProperties||(Object.defineProperties=function(e,t){for(var i in t)p(t,i)&&Object.defineProperty(e,i,t[i]);return e}),Object.seal||(Object.seal=function(e){return e}),Object.freeze||(Object.freeze=function(e){return e});try{Object.freeze(function(){})}catch(e){Object.freeze=function(t){return function(e){return"function"==typeof e?e:t(e)}}(Object.freeze)}if(Object.preventExtensions||(Object.preventExtensions=function(e){return e}),Object.isSealed||(Object.isSealed=function(e){return!1}),Object.isFrozen||(Object.isFrozen=function(e){return!1}),Object.isExtensible||(Object.isExtensible=function(e){if(Object(e)===e)throw new TypeError;for(var t="";p(e,t);)t+="?";e[t]=!0;var i=p(e,t);return delete e[t],i}),!Object.keys){var A=!0,x=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],F=x.length;for(var S in{toString:null})A=!1;Object.keys=function(e){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.keys called on a non-object");var t=[];for(var i in e)p(e,i)&&t.push(i);if(A)for(var n=0,r=F;n<r;n++){var o=x[n];p(e,o)&&t.push(o)}return t}}Date.now||(Date.now=function(){return(new Date).getTime()});var _="\t\n\v\f\r   ᠎             　\u2028\u2029\ufeff";if(!String.prototype.trim||_.trim()){_="["+_+"]";var k=new RegExp("^"+_+_+"*"),D=new RegExp(_+_+"*$");String.prototype.trim=function(){return String(this).replace(k,"").replace(D,"")}}function $(e){return(e=+e)!=e?e=0:0!==e&&e!==1/0&&e!==-1/0&&(e=(0<e||-1)*Math.floor(Math.abs(e))),e}var B=function(e){if(null==e)throw new TypeError("can't convert "+e+" to object");return Object(e)}}),ace.define("ace/lib/fixoldbrowsers",["require","exports","module","ace/lib/regexp","ace/lib/es5-shim"],function(e,t,i){"use strict";e("./regexp"),e("./es5-shim")}),ace.define("ace/lib/dom",["require","exports","module"],function(e,a,t){"use strict";a.getDocumentHead=function(e){return(e=e||document).head||e.getElementsByTagName("head")[0]||e.documentElement},a.createElement=function(e,t){return document.createElementNS?document.createElementNS(t||"http://www.w3.org/1999/xhtml",e):document.createElement(e)},a.hasCssClass=function(e,t){return-1!==(e.className+"").split(/\s+/g).indexOf(t)},a.addCssClass=function(e,t){a.hasCssClass(e,t)||(e.className+=" "+t)},a.removeCssClass=function(e,t){for(var i=e.className.split(/\s+/g);;){var n=i.indexOf(t);if(-1==n)break;i.splice(n,1)}e.className=i.join(" ")},a.toggleCssClass=function(e,t){for(var i=e.className.split(/\s+/g),n=!0;;){var r=i.indexOf(t);if(-1==r)break;n=!1,i.splice(r,1)}return n&&i.push(t),e.className=i.join(" "),n},a.setCssClass=function(e,t,i){i?a.addCssClass(e,t):a.removeCssClass(e,t)},a.hasCssString=function(e,t){var i,n=0;if((t=t||document).createStyleSheet&&(i=t.styleSheets)){for(;n<i.length;)if(i[n++].owningElement.id===e)return!0}else if(i=t.getElementsByTagName("style"))for(;n<i.length;)if(i[n++].id===e)return!0;return!1},a.importCssString=function(e,t,i){if(i=i||document,t&&a.hasCssString(t,i))return null;var n;t&&(e+="\n/*# sourceURL=ace/css/"+t+" */"),i.createStyleSheet?((n=i.createStyleSheet()).cssText=e,t&&(n.owningElement.id=t)):((n=a.createElement("style")).appendChild(i.createTextNode(e)),t&&(n.id=t),a.getDocumentHead(i).appendChild(n))},a.importCssStylsheet=function(e,t){if(t.createStyleSheet)t.createStyleSheet(e);else{var i=a.createElement("link");i.rel="stylesheet",i.href=e,a.getDocumentHead(t).appendChild(i)}},a.getInnerWidth=function(e){return parseInt(a.computedStyle(e,"paddingLeft"),10)+parseInt(a.computedStyle(e,"paddingRight"),10)+e.clientWidth},a.getInnerHeight=function(e){return parseInt(a.computedStyle(e,"paddingTop"),10)+parseInt(a.computedStyle(e,"paddingBottom"),10)+e.clientHeight},a.scrollbarWidth=function(e){var t=a.createElement("ace_inner");t.style.width="100%",t.style.minWidth="0px",t.style.height="200px",t.style.display="block";var i=a.createElement("ace_outer"),n=i.style;n.position="absolute",n.left="-10000px",n.overflow="hidden",n.width="200px",n.minWidth="0px",n.height="150px",n.display="block",i.appendChild(t);var r=e.documentElement;r.appendChild(i);var o=t.offsetWidth;n.overflow="scroll";var s=t.offsetWidth;return o==s&&(s=i.clientWidth),r.removeChild(i),o-s},"undefined"!=typeof document?(void 0!==window.pageYOffset?(a.getPageScrollTop=function(){return window.pageYOffset},a.getPageScrollLeft=function(){return window.pageXOffset}):(a.getPageScrollTop=function(){return document.body.scrollTop},a.getPageScrollLeft=function(){return document.body.scrollLeft}),window.getComputedStyle?a.computedStyle=function(e,t){return t?(window.getComputedStyle(e,"")||{})[t]||"":window.getComputedStyle(e,"")||{}}:a.computedStyle=function(e,t){return t?e.currentStyle[t]:e.currentStyle},a.setInnerHtml=function(e,t){var i=e.cloneNode(!1);return i.innerHTML=t,e.parentNode.replaceChild(i,e),i},"textContent"in document.documentElement?(a.setInnerText=function(e,t){e.textContent=t},a.getInnerText=function(e){return e.textContent}):(a.setInnerText=function(e,t){e.innerText=t},a.getInnerText=function(e){return e.innerText}),a.getParentWindow=function(e){return e.defaultView||e.parentWindow}):a.importCssString=function(){}}),ace.define("ace/lib/oop",["require","exports","module"],function(e,i,t){"use strict";i.inherits=function(e,t){e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}})},i.mixin=function(e,t){for(var i in t)e[i]=t[i];return e},i.implement=function(e,t){i.mixin(e,t)}}),ace.define("ace/lib/keys",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/oop"],function(e,t,i){"use strict";e("./fixoldbrowsers");var n=e("./oop"),r=function(){var e,t,i={MODIFIER_KEYS:{16:"Shift",17:"Ctrl",18:"Alt",224:"Meta"},KEY_MODS:{ctrl:1,alt:2,option:2,shift:4,super:8,meta:8,command:8,cmd:8},FUNCTION_KEYS:{8:"Backspace",9:"Tab",13:"Return",19:"Pause",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"Print",45:"Insert",46:"Delete",96:"Numpad0",97:"Numpad1",98:"Numpad2",99:"Numpad3",100:"Numpad4",101:"Numpad5",102:"Numpad6",103:"Numpad7",104:"Numpad8",105:"Numpad9","-13":"NumpadEnter",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"Numlock",145:"Scrolllock"},PRINTABLE_KEYS:{32:" ",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",59:";",61:"=",65:"a",66:"b",67:"c",68:"d",69:"e",70:"f",71:"g",72:"h",73:"i",74:"j",75:"k",76:"l",77:"m",78:"n",79:"o",80:"p",81:"q",82:"r",83:"s",84:"t",85:"u",86:"v",87:"w",88:"x",89:"y",90:"z",107:"+",109:"-",110:".",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",111:"/",106:"*"}};for(t in i.FUNCTION_KEYS)e=i.FUNCTION_KEYS[t].toLowerCase(),i[e]=parseInt(t,10);for(t in i.PRINTABLE_KEYS)e=i.PRINTABLE_KEYS[t].toLowerCase(),i[e]=parseInt(t,10);return n.mixin(i,i.MODIFIER_KEYS),n.mixin(i,i.PRINTABLE_KEYS),n.mixin(i,i.FUNCTION_KEYS),i.enter=i.return,i.escape=i.esc,i.del=i.delete,i[173]="-",function(){for(var e=["cmd","ctrl","alt","shift"],t=Math.pow(2,e.length);t--;)i.KEY_MODS[t]=e.filter(function(e){return t&i.KEY_MODS[e]}).join("-")+"-"}(),i.KEY_MODS[0]="",i.KEY_MODS[-1]="input-",i}();n.mixin(t,r),t.keyCodeToString=function(e){var t=r[e];return"string"!=typeof t&&(t=String.fromCharCode(e)),t.toLowerCase()}}),ace.define("ace/lib/useragent",["require","exports","module"],function(e,t,i){"use strict";if(t.OS={LINUX:"LINUX",MAC:"MAC",WINDOWS:"WINDOWS"},t.getOS=function(){return t.isMac?t.OS.MAC:t.isLinux?t.OS.LINUX:t.OS.WINDOWS},"object"==typeof navigator){var n=(navigator.platform.match(/mac|win|linux/i)||["other"])[0].toLowerCase(),r=navigator.userAgent;t.isWin="win"==n,t.isMac="mac"==n,t.isLinux="linux"==n,t.isIE="Microsoft Internet Explorer"==navigator.appName||0<=navigator.appName.indexOf("MSAppHost")?parseFloat((r.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]):parseFloat((r.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]),t.isOldIE=t.isIE&&t.isIE<9,t.isGecko=t.isMozilla=(window.Controllers||window.controllers)&&"Gecko"===window.navigator.product,t.isOldGecko=t.isGecko&&parseInt((r.match(/rv:(\d+)/)||[])[1],10)<4,t.isOpera=window.opera&&"[object Opera]"==Object.prototype.toString.call(window.opera),t.isWebKit=parseFloat(r.split("WebKit/")[1])||void 0,t.isChrome=parseFloat(r.split(" Chrome/")[1])||void 0,t.isAIR=0<=r.indexOf("AdobeAIR"),t.isIPad=0<=r.indexOf("iPad"),t.isChromeOS=0<=r.indexOf(" CrOS "),t.isIOS=/iPad|iPhone|iPod/.test(r)&&!window.MSStream,t.isIOS&&(t.isMac=!0)}}),ace.define("ace/lib/event",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(e,d,t){"use strict";var o=e("./keys"),u=e("./useragent"),s=null,a=0;d.addListener=function(e,t,i){if(e.addEventListener)return e.addEventListener(t,i,!1);if(e.attachEvent){var n=function(){i.call(e,window.event)};i._wrapper=n,e.attachEvent("on"+t,n)}},d.removeListener=function(e,t,i){if(e.removeEventListener)return e.removeEventListener(t,i,!1);e.detachEvent&&e.detachEvent("on"+t,i._wrapper||i)},d.stopEvent=function(e){return d.stopPropagation(e),d.preventDefault(e),!1},d.stopPropagation=function(e){e.stopPropagation?e.stopPropagation():e.cancelBubble=!0},d.preventDefault=function(e){e.preventDefault?e.preventDefault():e.returnValue=!1},d.getButton=function(e){return"dblclick"==e.type?0:"contextmenu"==e.type||u.isMac&&e.ctrlKey&&!e.altKey&&!e.shiftKey?2:e.preventDefault?e.button:{1:0,2:2,4:1}[e.button]},d.capture=function(e,t,i){function n(e){t&&t(e),i&&i(e),d.removeListener(document,"mousemove",t,!0),d.removeListener(document,"mouseup",n,!0),d.removeListener(document,"dragstart",n,!0)}return d.addListener(document,"mousemove",t,!0),d.addListener(document,"mouseup",n,!0),d.addListener(document,"dragstart",n,!0),n},d.addTouchMoveListener=function(e,n){var r,o;d.addListener(e,"touchstart",function(e){var t=e.touches[0];r=t.clientX,o=t.clientY}),d.addListener(e,"touchmove",function(e){var t=e.touches;if(!(1<t.length)){var i=t[0];e.wheelX=r-i.clientX,e.wheelY=o-i.clientY,r=i.clientX,o=i.clientY,n(e)}})},d.addMouseWheelListener=function(e,t){"onmousewheel"in e?d.addListener(e,"mousewheel",function(e){void 0!==e.wheelDeltaX?(e.wheelX=-e.wheelDeltaX/8,e.wheelY=-e.wheelDeltaY/8):(e.wheelX=0,e.wheelY=-e.wheelDelta/8),t(e)}):"onwheel"in e?d.addListener(e,"wheel",function(e){switch(e.deltaMode){case e.DOM_DELTA_PIXEL:e.wheelX=.35*e.deltaX||0,e.wheelY=.35*e.deltaY||0;break;case e.DOM_DELTA_LINE:case e.DOM_DELTA_PAGE:e.wheelX=5*(e.deltaX||0),e.wheelY=5*(e.deltaY||0)}t(e)}):d.addListener(e,"DOMMouseScroll",function(e){e.axis&&e.axis==e.HORIZONTAL_AXIS?(e.wheelX=5*(e.detail||0),e.wheelY=0):(e.wheelX=0,e.wheelY=5*(e.detail||0)),t(e)})},d.addMultiMouseDownListener=function(e,i,n,r){var o,s,a,l=0,c={2:"dblclick",3:"tripleclick",4:"quadclick"};function t(e){if(0!==d.getButton(e)?l=0:1<e.detail?4<++l&&(l=1):l=1,u.isIE){var t=5<Math.abs(e.clientX-o)||5<Math.abs(e.clientY-s);a&&!t||(l=1),a&&clearTimeout(a),a=setTimeout(function(){a=null},i[l-1]||600),1==l&&(o=e.clientX,s=e.clientY)}if(e._clicks=l,n[r]("mousedown",e),4<l)l=0;else if(1<l)return n[r](c[l],e)}function h(e){l=2,a&&clearTimeout(a),a=setTimeout(function(){a=null},i[l-1]||600),n[r]("mousedown",e),n[r](c[l],e)}Array.isArray(e)||(e=[e]),e.forEach(function(e){d.addListener(e,"mousedown",t),u.isOldIE&&d.addListener(e,"dblclick",h)})};var l=!u.isMac||!u.isOpera||"KeyboardEvent"in window?function(e){return 0|(e.ctrlKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.metaKey?8:0)}:function(e){return 0|(e.metaKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.ctrlKey?8:0)};function c(e,t,i){var n=l(t);if(!u.isMac&&s){if(t.getModifierState&&(t.getModifierState("OS")||t.getModifierState("Win"))&&(n|=8),s.altGr){if(3==(3&n))return;s.altGr=0}if(18===i||17===i){var r="location"in t?t.location:t.keyLocation;if(17===i&&1===r)1==s[i]&&(a=t.timeStamp);else if(18===i&&3===n&&2===r){t.timeStamp-a<50&&(s.altGr=!0)}}}if((i in o.MODIFIER_KEYS&&(i=-1),8&n&&91<=i&&i<=93&&(i=-1),!n&&13===i)&&(3===(r="location"in t?t.location:t.keyLocation)&&(e(t,n,-i),t.defaultPrevented)))return;if(u.isChromeOS&&8&n){if(e(t,n,i),t.defaultPrevented)return;n&=-9}return!!(n||i in o.FUNCTION_KEYS||i in o.PRINTABLE_KEYS)&&e(t,n,i)}function h(){s=Object.create(null)}if(d.getModifierString=function(e){return o.KEY_MODS[l(e)]},d.addCommandKeyListener=function(e,i){var t=d.addListener;if(u.isOldGecko||u.isOpera&&!("KeyboardEvent"in window)){var n=null;t(e,"keydown",function(e){n=e.keyCode}),t(e,"keypress",function(e){return c(i,e,n)})}else{var r=null;t(e,"keydown",function(e){s[e.keyCode]=(s[e.keyCode]||0)+1;var t=c(i,e,e.keyCode);return r=e.defaultPrevented,t}),t(e,"keypress",function(e){r&&(e.ctrlKey||e.altKey||e.shiftKey||e.metaKey)&&(d.stopEvent(e),r=null)}),t(e,"keyup",function(e){s[e.keyCode]=null}),s||(h(),t(window,"focus",h))}},"object"==typeof window&&window.postMessage&&!u.isOldIE){d.nextTick=function(i,n){n=n||window;var r="zero-timeout-message-1";d.addListener(n,"message",function e(t){t.data==r&&(d.stopPropagation(t),d.removeListener(n,"message",e),i())}),n.postMessage(r,"*")}}d.nextFrame="object"==typeof window&&(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame),d.nextFrame?d.nextFrame=d.nextFrame.bind(window):d.nextFrame=function(e){setTimeout(e,17)}}),ace.define("ace/lib/lang",["require","exports","module"],function(e,t,i){"use strict";t.last=function(e){return e[e.length-1]},t.stringReverse=function(e){return e.split("").reverse().join("")},t.stringRepeat=function(e,t){for(var i="";0<t;)1&t&&(i+=e),(t>>=1)&&(e+=e);return i};var n=/^\s\s*/,r=/\s\s*$/;t.stringTrimLeft=function(e){return e.replace(n,"")},t.stringTrimRight=function(e){return e.replace(r,"")},t.copyObject=function(e){var t={};for(var i in e)t[i]=e[i];return t},t.copyArray=function(e){for(var t=[],i=0,n=e.length;i<n;i++)e[i]&&"object"==typeof e[i]?t[i]=this.copyObject(e[i]):t[i]=e[i];return t},t.deepCopy=function e(t){if("object"!=typeof t||!t)return t;var i;if(Array.isArray(t)){i=[];for(var n=0;n<t.length;n++)i[n]=e(t[n]);return i}if("[object Object]"!==Object.prototype.toString.call(t))return t;for(var n in i={},t)i[n]=e(t[n]);return i},t.arrayToMap=function(e){for(var t={},i=0;i<e.length;i++)t[e[i]]=1;return t},t.createMap=function(e){var t=Object.create(null);for(var i in e)t[i]=e[i];return t},t.arrayRemove=function(e,t){for(var i=0;i<=e.length;i++)t===e[i]&&e.splice(i,1)},t.escapeRegExp=function(e){return e.replace(/([.*+?^${}()|[\]\/\\])/g,"\\$1")},t.escapeHTML=function(e){return e.replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/'/g,"&#39;").replace(/</g,"&#60;")},t.getMatchOffsets=function(e,t){var i=[];return e.replace(t,function(e){i.push({offset:arguments[arguments.length-2],length:e.length})}),i},t.deferredCall=function(e){function t(){i=null,e()}var i=null,n=function(e){return n.cancel(),i=setTimeout(t,e||0),n};return(n.schedule=n).call=function(){return this.cancel(),e(),n},n.cancel=function(){return clearTimeout(i),i=null,n},n.isPending=function(){return i},n},t.delayedCall=function(e,t){function i(){r=null,e()}function n(e){null==r&&(r=setTimeout(i,e||t))}var r=null;return n.delay=function(e){r&&clearTimeout(r),r=setTimeout(i,e||t)},(n.schedule=n).call=function(){this.cancel(),e()},n.cancel=function(){r&&clearTimeout(r),r=null},n.isPending=function(){return r},n}}),ace.define("ace/keyboard/textinput_ios",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/lib/dom","ace/lib/lang","ace/lib/keys"],function(e,t,i){"use strict";var $=e("../lib/event"),B=e("../lib/useragent"),T=e("../lib/dom"),L=e("../lib/lang"),R=e("../lib/keys"),P=R.KEY_MODS,O=B.isChrome<18,M=B.isIE;t.TextInput=function(e,l){var c=T.createElement("textarea");c.className=B.isIOS?"ace_text-input ace_text-input-ios":"ace_text-input",B.isTouchPad&&c.setAttribute("x-palm-disable-auto-cap",!0),c.setAttribute("wrap","off"),c.setAttribute("autocorrect","off"),c.setAttribute("autocapitalize","off"),c.setAttribute("spellcheck",!1),c.style.opacity="0",e.insertBefore(c,e.firstChild);var t="\n aaaa a\n",n=!1,r=!1,i=!1,o=!1,h="",s=!0;try{var a=document.activeElement===c}catch(e){}$.addListener(c,"blur",function(e){l.onBlur(e),a=!1}),$.addListener(c,"focus",function(e){a=!0,l.onFocus(e),f()}),this.focus=function(){if(h)return c.focus();c.style.position="fixed",c.focus()},this.blur=function(){c.blur()},this.isFocused=function(){return a};var d=L.delayedCall(function(){a&&f(s)}),u=L.delayedCall(function(){o||(c.value=t,a&&f())});function f(e){if(!o){if(o=!0,m)t=0,i=e?0:c.value.length-1;else var t=4,i=5;try{c.setSelectionRange(t,i)}catch(e){}o=!1}}function p(){o||(c.value=t,B.isWebKit&&u.schedule())}B.isWebKit||l.addEventListener("changeSelection",function(){l.selection.isEmpty()!=s&&(s=!s,d.schedule())}),p(),a&&l.onFocus();var m=null;this.setInputHandler=function(e){m=e};function g(e){4===c.selectionStart&&5===c.selectionEnd||(m&&(e=m(e),m=null),i?(f(),e&&l.onPaste(e),i=!1):e==t.substr(0)&&4===c.selectionStart?w?l.execCommand("del",{source:"ace"}):l.execCommand("backspace",{source:"ace"}):n||(e.substring(0,9)==t&&e.length>t.length?e=e.substr(9):e.substr(0,4)==t.substr(0,4)?e=e.substr(4,e.length-t.length+1):e.charAt(e.length-1)==t.charAt(0)&&(e=e.slice(0,-1)),e==t.charAt(0)||e.charAt(e.length-1)==t.charAt(0)&&(e=e.slice(0,-1)),e&&l.onTextInput(e)),n=n&&!1,w=w&&!1)}function v(e){if(!o){var t=c.value;g(t),p()}}function y(e,t){var i=l.getCopyText();if(!i)return $.preventDefault(e);b(e,i)?(B.isIOS&&(r=t,c.value="\n aa"+i+"a a\n",c.setSelectionRange(4,4+i.length),n={value:i}),t?l.onCut():l.onCopy(),B.isIOS||$.preventDefault(e)):(n=!0,c.value=i,c.select(),setTimeout(function(){n=!1,p(),f(),t?l.onCut():l.onCopy()}))}var w=!(this.getInputHandler=function(){return m}),b=function(e,t,i){var n=e.clipboardData||window.clipboardData;if(n&&!O){var r=M||i?"Text":"text/plain";try{return t?!1!==n.setData(r,t):n.getData(r)}catch(e){if(!i)return b(e,t,!0)}}};$.addCommandKeyListener(c,l.onCommandKey.bind(l)),$.addListener(c,"select",function(e){!function(e){return 0===e.selectionStart&&e.selectionEnd===e.value.length}(c)?m&&f(l.selection.isEmpty()):(l.selectAll(),f())}),$.addListener(c,"input",v),$.addListener(c,"cut",function(e){y(e,!0)}),$.addListener(c,"copy",function(e){y(e,!1)}),$.addListener(c,"paste",function(e){var t=b(e);"string"==typeof t?(t&&l.onPaste(t,e),B.isIE&&setTimeout(f),$.preventDefault(e)):(c.value="",i=!0)});var C,E=function(){if(o&&l.onCompositionUpdate&&!l.$readOnly){var e=c.value.replace(/\x01/g,"");if(o.lastValue!==e&&(l.onCompositionUpdate(e),o.lastValue&&l.undo(),o.canUndo&&(o.lastValue=e),o.lastValue)){var t=l.selection.getRange();l.insert(o.lastValue),l.session.markUndoGroup(),o.range=l.selection.getRange(),l.selection.setRange(t),l.selection.clearSelection()}}},A=function(e){if(l.onCompositionEnd&&!l.$readOnly){var t=o;o=!1;var i=setTimeout(function(){i=null;var e=c.value.replace(/\x01/g,"");o||(e==t.lastValue?p():!t.lastValue&&e&&(p(),g(e)))});m=function(e){return i&&clearTimeout(i),(e=e.replace(/\x01/g,""))==t.lastValue?"":(t.lastValue&&i&&l.undo(),e)},l.onCompositionEnd(),l.removeListener("mousedown",A),"compositionend"==e.type&&t.range&&l.selection.setRange(t.range),(!!B.isChrome&&53<=B.isChrome||!!B.isWebKit&&603<=B.isWebKit)&&v()}},x=L.delayedCall(E,50);function F(){clearTimeout(C),C=setTimeout(function(){h&&(c.style.cssText=h,h=""),null==l.renderer.$keepTextAreaAtCursor&&(l.renderer.$keepTextAreaAtCursor=!0,l.renderer.$moveTextAreaToCursor())},0)}$.addListener(c,"compositionstart",function(e){o||!l.onCompositionStart||l.$readOnly||((o={}).canUndo=l.session.$undoManager,l.onCompositionStart(),setTimeout(E,0),l.on("mousedown",A),o.canUndo&&!l.selection.isEmpty()&&(l.insert(""),l.session.markUndoGroup(),l.selection.clearSelection()),l.session.markUndoGroup())}),B.isGecko?$.addListener(c,"text",function(){x.schedule()}):($.addListener(c,"keyup",function(){x.schedule()}),$.addListener(c,"keydown",function(){x.schedule()})),$.addListener(c,"compositionend",A),this.getElement=function(){return c},this.setReadOnly=function(e){c.readOnly=e},this.onContextMenu=function(e){w=!0,f(l.selection.isEmpty()),l._emit("nativecontextmenu",{target:l,domEvent:e}),this.moveToMouse(e,!0)},this.moveToMouse=function(e,t){h=h||c.style.cssText,c.style.cssText=(t?"z-index:100000;":"")+"height:"+c.style.height+";"+(B.isIE?"opacity:0.1;":"");function i(e){c.style.left=e.clientX-s-2+"px",c.style.top=Math.min(e.clientY-o-2,a)+"px"}var n=l.container.getBoundingClientRect(),r=T.computedStyle(l.container),o=n.top+(parseInt(r.borderTopWidth)||0),s=n.left+(parseInt(n.borderLeftWidth)||0),a=n.bottom-o-c.clientHeight-2;i(e),"mousedown"==e.type&&(l.renderer.$keepTextAreaAtCursor&&(l.renderer.$keepTextAreaAtCursor=null),clearTimeout(C),B.isWin&&$.capture(l.container,i,F))},this.onContextMenuClose=F;function S(e){l.textInput.onContextMenu(e),F()}if($.addListener(c,"mouseup",S),$.addListener(c,"mousedown",function(e){e.preventDefault(),F()}),$.addListener(l.renderer.scroller,"contextmenu",S),$.addListener(c,"contextmenu",S),B.isIOS){var _=null,k=!1;e.addEventListener("keydown",function(e){_&&clearTimeout(_),k=!0}),e.addEventListener("keyup",function(e){_=setTimeout(function(){k=!1},100)});var D=function(e){if(document.activeElement===c&&!k){if(r)return setTimeout(function(){r=!1},100);var t=c.selectionStart,i=c.selectionEnd;if(c.setSelectionRange(4,5),t==i)switch(t){case 0:l.onCommandKey(null,0,R.up);break;case 1:l.onCommandKey(null,0,R.home);break;case 2:l.onCommandKey(null,P.option,R.left);break;case 4:l.onCommandKey(null,0,R.left);break;case 5:l.onCommandKey(null,0,R.right);break;case 7:l.onCommandKey(null,P.option,R.right);break;case 8:l.onCommandKey(null,0,R.end);break;case 9:l.onCommandKey(null,0,R.down)}else{switch(i){case 6:l.onCommandKey(null,P.shift,R.right);break;case 7:l.onCommandKey(null,P.shift|P.option,R.right);break;case 8:l.onCommandKey(null,P.shift,R.end);break;case 9:l.onCommandKey(null,P.shift,R.down)}switch(t){case 0:l.onCommandKey(null,P.shift,R.up);break;case 1:l.onCommandKey(null,P.shift,R.home);break;case 2:l.onCommandKey(null,P.shift|P.option,R.left);break;case 3:l.onCommandKey(null,P.shift,R.left)}}}};document.addEventListener("selectionchange",D),l.on("destroy",function(){document.removeEventListener("selectionchange",D)})}}}),ace.define("ace/keyboard/textinput",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/lib/dom","ace/lib/lang","ace/keyboard/textinput_ios"],function(e,t,i){"use strict";var D=e("../lib/event"),$=e("../lib/useragent"),B=e("../lib/dom"),T=e("../lib/lang"),L=$.isChrome<18,R=$.isIE,P=e("./textinput_ios").TextInput;t.TextInput=function(e,l){if($.isIOS)return P.call(this,e,l);var c=B.createElement("textarea");c.className="ace_text-input",c.setAttribute("wrap","off"),c.setAttribute("autocorrect","off"),c.setAttribute("autocapitalize","off"),c.setAttribute("spellcheck",!1),c.style.opacity="0",e.insertBefore(c,e.firstChild);var t="\u2028\u2028",n=!1,i=!1,r=!1,h="",o=!0;try{var s=document.activeElement===c}catch(e){}D.addListener(c,"blur",function(e){l.onBlur(e),s=!1}),D.addListener(c,"focus",function(e){s=!0,l.onFocus(e),u()}),this.focus=function(){if(h)return c.focus();var e=c.style.top;c.style.position="fixed",c.style.top="0px",c.focus(),setTimeout(function(){c.style.position="","0px"==c.style.top&&(c.style.top=e)},0)},this.blur=function(){c.blur()},this.isFocused=function(){return s};var a=T.delayedCall(function(){s&&u(o)}),d=T.delayedCall(function(){r||(c.value=t,s&&u())});function u(e){if(!r){if(r=!0,p)var t=0,i=e?0:c.value.length-1;else t=e?2:1,i=2;try{c.setSelectionRange(t,i)}catch(e){}r=!1}}function f(){r||(c.value=t,$.isWebKit&&d.schedule())}$.isWebKit||l.addEventListener("changeSelection",function(){l.selection.isEmpty()!=o&&(o=!o,a.schedule())}),f(),s&&l.onFocus();var p=null;this.setInputHandler=function(e){p=e};function m(e){p&&(e=p(e),p=null),i?(u(),e&&l.onPaste(e),i=!1):e==t.charAt(0)?C?l.execCommand("del",{source:"ace"}):l.execCommand("backspace",{source:"ace"}):(e.substring(0,2)==t?e=e.substr(2):e.charAt(0)==t.charAt(0)?e=e.substr(1):e.charAt(e.length-1)==t.charAt(0)&&(e=e.slice(0,-1)),e.charAt(e.length-1)==t.charAt(0)&&(e=e.slice(0,-1)),e&&l.onTextInput(e)),C=C&&!1}function g(e){if(!r){var t=c.value;m(t),f()}}function v(e,t){var i=l.getCopyText();if(!i)return D.preventDefault(e);E(e,i)?(t?l.onCut():l.onCopy(),D.preventDefault(e)):(n=!0,c.value=i,c.select(),setTimeout(function(){n=!1,f(),u(),t?l.onCut():l.onCopy()}))}function y(e){v(e,!0)}function w(e){v(e,!1)}function b(e){var t=E(e);"string"==typeof t?(t&&l.onPaste(t,e),$.isIE&&setTimeout(u),D.preventDefault(e)):(c.value="",i=!0)}var C=!(this.getInputHandler=function(){return p}),E=function(e,t,i){var n=e.clipboardData||window.clipboardData;if(n&&!L){var r=R||i?"Text":"text/plain";try{return t?!1!==n.setData(r,t):n.getData(r)}catch(e){if(!i)return E(e,t,!0)}}};D.addCommandKeyListener(c,l.onCommandKey.bind(l)),D.addListener(c,"select",function(e){n?n=!1:!function(e){return 0===e.selectionStart&&e.selectionEnd===e.value.length}(c)?p&&u(l.selection.isEmpty()):(l.selectAll(),u())}),D.addListener(c,"input",g),D.addListener(c,"cut",y),D.addListener(c,"copy",w),D.addListener(c,"paste",b),"oncut"in c&&"oncopy"in c&&"onpaste"in c||D.addListener(e,"keydown",function(e){if((!$.isMac||e.metaKey)&&e.ctrlKey)switch(e.keyCode){case 67:w(e);break;case 86:b(e);break;case 88:y(e)}});var A,x=function(){if(r&&l.onCompositionUpdate&&!l.$readOnly){var e=c.value.replace(/\u2028/g,"");if(r.lastValue!==e&&(l.onCompositionUpdate(e),r.lastValue&&l.undo(),r.canUndo&&(r.lastValue=e),r.lastValue)){var t=l.selection.getRange();l.insert(r.lastValue),l.session.markUndoGroup(),r.range=l.selection.getRange(),l.selection.setRange(t),l.selection.clearSelection()}}},F=function(e){if(l.onCompositionEnd&&!l.$readOnly){var t=r;r=!1;var i=setTimeout(function(){i=null;var e=c.value.replace(/\u2028/g,"");r||(e==t.lastValue?f():!t.lastValue&&e&&(f(),m(e)))});p=function(e){return i&&clearTimeout(i),(e=e.replace(/\u2028/g,""))==t.lastValue?"":(t.lastValue&&i&&l.undo(),e)},l.onCompositionEnd(),l.removeListener("mousedown",F),"compositionend"==e.type&&t.range&&l.selection.setRange(t.range),(!!$.isChrome&&53<=$.isChrome||!!$.isWebKit&&603<=$.isWebKit)&&g()}},S=T.delayedCall(x,50);function _(){clearTimeout(A),A=setTimeout(function(){h&&(c.style.cssText=h,h=""),null==l.renderer.$keepTextAreaAtCursor&&(l.renderer.$keepTextAreaAtCursor=!0,l.renderer.$moveTextAreaToCursor())},0)}D.addListener(c,"compositionstart",function(e){r||!l.onCompositionStart||l.$readOnly||((r={}).canUndo=l.session.$undoManager,l.onCompositionStart(),setTimeout(x,0),l.on("mousedown",F),r.canUndo&&!l.selection.isEmpty()&&(l.insert(""),l.session.markUndoGroup(),l.selection.clearSelection()),l.session.markUndoGroup())}),$.isGecko?D.addListener(c,"text",function(){S.schedule()}):(D.addListener(c,"keyup",function(){S.schedule()}),D.addListener(c,"keydown",function(){S.schedule()})),D.addListener(c,"compositionend",F),this.getElement=function(){return c},this.setReadOnly=function(e){c.readOnly=e},this.onContextMenu=function(e){C=!0,u(l.selection.isEmpty()),l._emit("nativecontextmenu",{target:l,domEvent:e}),this.moveToMouse(e,!0)},this.moveToMouse=function(e,t){h=h||c.style.cssText,c.style.cssText=(t?"z-index:100000;":"")+"height:"+c.style.height+";"+($.isIE?"opacity:0.1;":"");function i(e){c.style.left=e.clientX-s-2+"px",c.style.top=Math.min(e.clientY-o-2,a)+"px"}var n=l.container.getBoundingClientRect(),r=B.computedStyle(l.container),o=n.top+(parseInt(r.borderTopWidth)||0),s=n.left+(parseInt(n.borderLeftWidth)||0),a=n.bottom-o-c.clientHeight-2;i(e),"mousedown"==e.type&&(l.renderer.$keepTextAreaAtCursor&&(l.renderer.$keepTextAreaAtCursor=null),clearTimeout(A),$.isWin&&D.capture(l.container,i,_))},this.onContextMenuClose=_;function k(e){l.textInput.onContextMenu(e),_()}D.addListener(c,"mouseup",k),D.addListener(c,"mousedown",function(e){e.preventDefault(),_()}),D.addListener(l.renderer.scroller,"contextmenu",k),D.addListener(c,"contextmenu",k)}}),ace.define("ace/mouse/default_handlers",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],function(e,t,i){"use strict";e("../lib/dom"),e("../lib/event");var s=e("../lib/useragent");function n(t){t.$clickSelection=null;var e=t.editor;e.setDefaultHandler("mousedown",this.onMouseDown.bind(t)),e.setDefaultHandler("dblclick",this.onDoubleClick.bind(t)),e.setDefaultHandler("tripleclick",this.onTripleClick.bind(t)),e.setDefaultHandler("quadclick",this.onQuadClick.bind(t)),e.setDefaultHandler("mousewheel",this.onMouseWheel.bind(t)),e.setDefaultHandler("touchmove",this.onTouchMove.bind(t));["select","startSelect","selectEnd","selectAllEnd","selectByWordsEnd","selectByLinesEnd","dragWait","dragWaitEnd","focusWait"].forEach(function(e){t[e]=this[e]},this),t.selectByLines=this.extendSelectionBy.bind(t,"getLineRange"),t.selectByWords=this.extendSelectionBy.bind(t,"getWordRange")}function l(e,t){if(e.start.row==e.end.row)var i=2*t.column-e.start.column-e.end.column;else if(e.start.row!=e.end.row-1||e.start.column||e.end.column)i=2*t.row-e.start.row-e.end.row;else var i=t.column-4;return i<0?{cursor:e.start,anchor:e.end}:{cursor:e.end,anchor:e.start}}(function(){this.onMouseDown=function(e){var t=e.inSelection(),i=e.getDocumentPosition();this.mousedownEvent=e;var n=this.editor,r=e.getButton();if(0===r)return this.mousedownEvent.time=Date.now(),!t||n.isFocused()||(n.focus(),!this.$focusTimout||this.$clickSelection||n.inMultiSelectMode)?(this.captureMouse(e),this.startSelect(i,1<e.domEvent._clicks),e.preventDefault()):(this.setState("focusWait"),void this.captureMouse(e));var o=n.getSelectionRange().isEmpty();return n.$blockScrolling++,!o&&1!=r||n.selection.moveToPosition(i),n.$blockScrolling--,void(2==r&&(n.textInput.onContextMenu(e.domEvent),s.isMozilla||e.preventDefault()))},this.startSelect=function(e,t){e=e||this.editor.renderer.screenToTextCoordinates(this.x,this.y);var i=this.editor;i.$blockScrolling++,this.mousedownEvent.getShiftKey()?i.selection.selectToPosition(e):t||i.selection.moveToPosition(e),t||this.select(),i.renderer.scroller.setCapture&&i.renderer.scroller.setCapture(),i.setStyle("ace_selecting"),this.setState("select"),i.$blockScrolling--},this.select=function(){var e,t=this.editor,i=t.renderer.screenToTextCoordinates(this.x,this.y);if(t.$blockScrolling++,this.$clickSelection){var n=this.$clickSelection.comparePoint(i);if(-1==n)e=this.$clickSelection.end;else if(1==n)e=this.$clickSelection.start;else{var r=l(this.$clickSelection,i);i=r.cursor,e=r.anchor}t.selection.setSelectionAnchor(e.row,e.column)}t.selection.selectToPosition(i),t.$blockScrolling--,t.renderer.scrollCursorIntoView()},this.extendSelectionBy=function(e){var t,i=this.editor,n=i.renderer.screenToTextCoordinates(this.x,this.y),r=i.selection[e](n.row,n.column);if(i.$blockScrolling++,this.$clickSelection){var o=this.$clickSelection.comparePoint(r.start),s=this.$clickSelection.comparePoint(r.end);if(-1==o&&s<=0)t=this.$clickSelection.end,r.end.row==n.row&&r.end.column==n.column||(n=r.start);else if(1==s&&0<=o)t=this.$clickSelection.start,r.start.row==n.row&&r.start.column==n.column||(n=r.end);else if(-1==o&&1==s)n=r.end,t=r.start;else{var a=l(this.$clickSelection,n);n=a.cursor,t=a.anchor}i.selection.setSelectionAnchor(t.row,t.column)}i.selection.selectToPosition(n),i.$blockScrolling--,i.renderer.scrollCursorIntoView()},this.selectEnd=this.selectAllEnd=this.selectByWordsEnd=this.selectByLinesEnd=function(){this.$clickSelection=null,this.editor.unsetStyle("ace_selecting"),this.editor.renderer.scroller.releaseCapture&&this.editor.renderer.scroller.releaseCapture()},this.focusWait=function(){var e=function(e,t,i,n){return Math.sqrt(Math.pow(i-e,2)+Math.pow(n-t,2))}(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y),t=Date.now();(0<e||t-this.mousedownEvent.time>this.$focusTimout)&&this.startSelect(this.mousedownEvent.getDocumentPosition())},this.onDoubleClick=function(e){var t=e.getDocumentPosition(),i=this.editor,n=i.session.getBracketRange(t);n?(n.isEmpty()&&(n.start.column--,n.end.column++),this.setState("select")):(n=i.selection.getWordRange(t.row,t.column),this.setState("selectByWords")),this.$clickSelection=n,this.select()},this.onTripleClick=function(e){var t=e.getDocumentPosition(),i=this.editor;this.setState("selectByLines");var n=i.getSelectionRange();n.isMultiLine()&&n.contains(t.row,t.column)?(this.$clickSelection=i.selection.getLineRange(n.start.row),this.$clickSelection.end=i.selection.getLineRange(n.end.row).end):this.$clickSelection=i.selection.getLineRange(t.row),this.select()},this.onQuadClick=function(e){var t=this.editor;t.selectAll(),this.$clickSelection=t.getSelectionRange(),this.setState("selectAll")},this.onMouseWheel=function(e){if(!e.getAccelKey()){e.getShiftKey()&&e.wheelY&&!e.wheelX&&(e.wheelX=e.wheelY,e.wheelY=0);var t=this.editor;this.$lastScroll||(this.$lastScroll={t:0,vx:0,vy:0,allowed:0});var i=this.$lastScroll,n=e.domEvent.timeStamp,r=n-i.t,o=e.wheelX/r,s=e.wheelY/r;r<250&&(o=(o+i.vx)/2,s=(s+i.vy)/2);var a=Math.abs(o/s),l=!1;if(1<=a&&t.renderer.isScrollableBy(e.wheelX*e.speed,0)&&(l=!0),a<=1&&t.renderer.isScrollableBy(0,e.wheelY*e.speed)&&(l=!0),l)i.allowed=n;else if(n-i.allowed<250){var c=Math.abs(o)<=1.1*Math.abs(i.vx)&&Math.abs(s)<=1.1*Math.abs(i.vy);i.allowed=c?(l=!0,n):0}return i.t=n,i.vx=o,i.vy=s,l?(t.renderer.scrollBy(e.wheelX*e.speed,e.wheelY*e.speed),e.stop()):void 0}},this.onTouchMove=function(e){this.editor._emit("mousewheel",e)}}).call(n.prototype),t.DefaultHandlers=n}),ace.define("ace/tooltip",["require","exports","module","ace/lib/oop","ace/lib/dom"],function(e,t,i){"use strict";e("./lib/oop");var n=e("./lib/dom");function r(e){this.isOpen=!1,this.$element=null,this.$parentNode=e}(function(){this.$init=function(){return this.$element=n.createElement("div"),this.$element.className="ace_tooltip",this.$element.style.display="none",this.$parentNode.appendChild(this.$element),this.$element},this.getElement=function(){return this.$element||this.$init()},this.setText=function(e){n.setInnerText(this.getElement(),e)},this.setHtml=function(e){this.getElement().innerHTML=e},this.setPosition=function(e,t){this.getElement().style.left=e+"px",this.getElement().style.top=t+"px"},this.setClassName=function(e){n.addCssClass(this.getElement(),e)},this.show=function(e,t,i){null!=e&&this.setText(e),null!=t&&null!=i&&this.setPosition(t,i),this.isOpen||(this.getElement().style.display="block",this.isOpen=!0)},this.hide=function(){this.isOpen&&(this.getElement().style.display="none",this.isOpen=!1)},this.getHeight=function(){return this.getElement().offsetHeight},this.getWidth=function(){return this.getElement().offsetWidth},this.destroy=function(){this.isOpen=!1,this.$element&&this.$element.parentNode&&this.$element.parentNode.removeChild(this.$element)}}).call(r.prototype),t.Tooltip=r}),ace.define("ace/mouse/default_gutter_handler",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event","ace/tooltip"],function(e,t,i){"use strict";var n=e("../lib/dom"),r=e("../lib/oop"),o=e("../lib/event"),s=e("../tooltip").Tooltip;function p(e){s.call(this,e)}r.inherits(p,s),function(){this.setPosition=function(e,t){var i=window.innerWidth||document.documentElement.clientWidth,n=window.innerHeight||document.documentElement.clientHeight,r=this.getWidth(),o=this.getHeight();i<(e+=15)+r&&(e-=e+r-i),n<(t+=15)+o&&(t-=20+o),s.prototype.setPosition.call(this,e,t)}}.call(p.prototype),t.GutterHandler=function(s){var i,a,l,c=s.editor,h=c.renderer.$gutterLayer,d=new p(c.container);function u(){i=i&&clearTimeout(i),l&&(d.hide(),l=null,c._signal("hideGutterTooltip",d),c.removeEventListener("mousewheel",u))}function f(e){d.setPosition(e.x,e.y)}s.editor.setDefaultHandler("guttermousedown",function(e){if(c.isFocused()&&0==e.getButton()&&"foldWidgets"!=h.getRegion(e)){var t=e.getDocumentPosition().row,i=c.session.selection;if(e.getShiftKey())i.selectTo(t,0);else{if(2==e.domEvent.detail)return c.selectAll(),e.preventDefault();s.$clickSelection=c.selection.getLineRange(t)}return s.setState("selectByLines"),s.captureMouse(e),e.preventDefault()}}),s.editor.setDefaultHandler("guttermousemove",function(e){var t=e.domEvent.target||e.domEvent.srcElement;if(n.hasCssClass(t,"ace_fold-widget"))return u();l&&s.$tooltipFollowsMouse&&f(e),a=e,i=i||setTimeout(function(){i=null,a&&!s.isMousePressed?function(){var e=a.getDocumentPosition().row,t=h.$annotations[e];if(!t)return u();if(e==c.session.getLength()){var i=c.renderer.pixelToScreenCoordinates(0,a.y).row,n=a.$pos;if(i>c.session.documentToScreenRow(n.row,n.column))return u()}if(l!=t)if(l=t.text.join("<br/>"),d.setHtml(l),d.show(),c._signal("showGutterTooltip",d),c.on("mousewheel",u),
s.$tooltipFollowsMouse)f(a);else{var r=a.domEvent.target.getBoundingClientRect(),o=d.getElement().style;o.left=r.right+"px",o.top=r.bottom+"px"}}():u()},50)}),o.addListener(c.renderer.$gutter,"mouseout",function(e){a=null,l&&!i&&(i=setTimeout(function(){i=null,u()},50))}),c.on("changeSession",u)}}),ace.define("ace/mouse/mouse_event",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(e,t,i){"use strict";var n=e("../lib/event"),r=e("../lib/useragent"),o=t.MouseEvent=function(e,t){this.domEvent=e,this.editor=t,this.x=this.clientX=e.clientX,this.y=this.clientY=e.clientY,this.$pos=null,this.$inSelection=null,this.propagationStopped=!1,this.defaultPrevented=!1};(function(){this.stopPropagation=function(){n.stopPropagation(this.domEvent),this.propagationStopped=!0},this.preventDefault=function(){n.preventDefault(this.domEvent),this.defaultPrevented=!0},this.stop=function(){this.stopPropagation(),this.preventDefault()},this.getDocumentPosition=function(){return this.$pos||(this.$pos=this.editor.renderer.screenToTextCoordinates(this.clientX,this.clientY)),this.$pos},this.inSelection=function(){if(null!==this.$inSelection)return this.$inSelection;var e=this.editor.getSelectionRange();if(e.isEmpty())this.$inSelection=!1;else{var t=this.getDocumentPosition();this.$inSelection=e.contains(t.row,t.column)}return this.$inSelection},this.getButton=function(){return n.getButton(this.domEvent)},this.getShiftKey=function(){return this.domEvent.shiftKey},this.getAccelKey=r.isMac?function(){return this.domEvent.metaKey}:function(){return this.domEvent.ctrlKey}}).call(o.prototype)}),ace.define("ace/mouse/dragdrop_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],function(e,t,i){"use strict";var A=e("../lib/dom"),x=e("../lib/event"),F=e("../lib/useragent");function n(t){var f=t.editor,n=A.createElement("img");n.src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==",F.isOpera&&(n.style.cssText="width:1px;height:1px;position:fixed;top:0;left:0;z-index:2147483647;opacity:0;");["dragWait","dragWaitEnd","startDrag","dragReadyEnd","onMouseDrag"].forEach(function(e){t[e]=this[e]},this),f.addEventListener("mousedown",this.onMouseDown.bind(t));var i,p,m,e,r,o,s,a,g,l,c,h=f.container,d=0;function u(){var e=o;(function(e,t){var i=Date.now(),n=!t||e.row!=t.row,r=!t||e.column!=t.column;!l||n||r?(f.$blockScrolling+=1,f.moveCursorToPosition(e),f.$blockScrolling-=1,l=i,c={x:p,y:m}):5<S(c.x,c.y,p,m)?l=null:200<=i-l&&(f.renderer.scrollCursorIntoView(),l=null)})(o=f.renderer.screenToTextCoordinates(p,m),e),function(e,t){var i=Date.now(),n=f.renderer.layerConfig.lineHeight,r=f.renderer.layerConfig.characterWidth,o=f.renderer.scroller.getBoundingClientRect(),s={x:{left:p-o.left,right:o.right-p},y:{top:m-o.top,bottom:o.bottom-m}},a=Math.min(s.x.left,s.x.right),l=Math.min(s.y.top,s.y.bottom),c={row:e.row,column:e.column};a/r<=2&&(c.column+=s.x.left<s.x.right?-3:2),l/n<=1&&(c.row+=s.y.top<s.y.bottom?-1:1);var h=e.row!=c.row,d=e.column!=c.column,u=!t||e.row!=t.row;h||d&&!u?g?200<=i-g&&f.renderer.scrollCursorIntoView(c):g=i:g=null}(o,e)}function v(){r=f.selection.toOrientedRange(),i=f.session.addMarker(r,"ace_selection",f.getSelectionStyle()),f.clearSelection(),f.isFocused()&&f.renderer.$cursorLayer.setBlinking(!1),clearInterval(e),u(),e=setInterval(u,20),d=0,x.addListener(document,"mousemove",b)}function y(){clearInterval(e),f.session.removeMarker(i),i=null,f.$blockScrolling+=1,f.selection.fromOrientedRange(r),f.$blockScrolling-=1,f.isFocused()&&!a&&f.renderer.$cursorLayer.setBlinking(!f.getReadOnly()),d=0,l=g=o=r=null,x.removeListener(document,"mousemove",b)}this.onDragStart=function(e){if(this.cancelDrag||!h.draggable){var t=this;return setTimeout(function(){t.startSelect(),t.captureMouse(e)},0),e.preventDefault()}r=f.getSelectionRange();var i=e.dataTransfer;i.effectAllowed=f.getReadOnly()?"copy":"copyMove",F.isOpera&&(f.container.appendChild(n),n.scrollTop=0),i.setDragImage&&i.setDragImage(n,0,0),F.isOpera&&f.container.removeChild(n),i.clearData(),i.setData("Text",f.session.getTextRange()),a=!0,this.setState("drag")},this.onDragEnd=function(e){if(h.draggable=!1,a=!1,this.setState(null),!f.getReadOnly()){var t=e.dataTransfer.dropEffect;s||"move"!=t||f.session.remove(f.getSelectionRange()),f.renderer.$cursorLayer.setBlinking(!0)}this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle("")},this.onDragEnter=function(e){if(!f.getReadOnly()&&C(e.dataTransfer))return p=e.clientX,m=e.clientY,i||v(),d++,e.dataTransfer.dropEffect=s=E(e),x.preventDefault(e)},this.onDragOver=function(e){if(!f.getReadOnly()&&C(e.dataTransfer))return p=e.clientX,m=e.clientY,i||(v(),d++),null!==w&&(w=null),e.dataTransfer.dropEffect=s=E(e),x.preventDefault(e)},this.onDragLeave=function(e){if(--d<=0&&i)return y(),s=null,x.preventDefault(e)},this.onDrop=function(e){if(o){var t=e.dataTransfer;if(a)switch(s){case"move":r=r.contains(o.row,o.column)?{start:o,end:o}:f.moveText(r,o);break;case"copy":r=f.moveText(r,o,!0)}else{var i=t.getData("Text");r={start:o,end:f.session.insert(o,i)},f.focus(),s=null}return y(),x.preventDefault(e)}},x.addListener(h,"dragstart",this.onDragStart.bind(t)),x.addListener(h,"dragend",this.onDragEnd.bind(t)),x.addListener(h,"dragenter",this.onDragEnter.bind(t)),x.addListener(h,"dragover",this.onDragOver.bind(t)),x.addListener(h,"dragleave",this.onDragLeave.bind(t)),x.addListener(h,"drop",this.onDrop.bind(t));var w=null;function b(){null==w&&(w=setTimeout(function(){null!=w&&i&&y()},20))}function C(e){var t=e.types;return!t||Array.prototype.some.call(t,function(e){return"text/plain"==e||"Text"==e})}function E(e){var t=["copy","copymove","all","uninitialized"],i=F.isMac?e.altKey:e.ctrlKey,n="uninitialized";try{n=e.dataTransfer.effectAllowed.toLowerCase()}catch(e){}var r="none";return i&&0<=t.indexOf(n)?r="copy":0<=["move","copymove","linkmove","all","uninitialized"].indexOf(n)?r="move":0<=t.indexOf(n)&&(r="copy"),r}}function S(e,t,i,n){return Math.sqrt(Math.pow(i-e,2)+Math.pow(n-t,2))}(function(){this.dragWait=function(){Date.now()-this.mousedownEvent.time>this.editor.getDragDelay()&&this.startDrag()},this.dragWaitEnd=function(){this.editor.container.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()),this.selectEnd()},this.dragReadyEnd=function(e){this.editor.renderer.$cursorLayer.setBlinking(!this.editor.getReadOnly()),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle(""),this.dragWaitEnd()},this.startDrag=function(){this.cancelDrag=!1;var e=this.editor;e.container.draggable=!0,e.renderer.$cursorLayer.setBlinking(!1),e.setStyle("ace_dragging");var t=F.isWin?"default":"move";e.renderer.setCursorStyle(t),this.setState("dragReady")},this.onMouseDrag=function(e){var t=this.editor.container;F.isIE&&"dragReady"==this.state&&3<S(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&t.dragDrop();"dragWait"===this.state&&0<S(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&(t.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()))},this.onMouseDown=function(e){if(this.$dragEnabled){this.mousedownEvent=e;var t=this.editor,i=e.inSelection(),n=e.getButton();if(1===(e.domEvent.detail||1)&&0===n&&i){if(e.editor.inMultiSelectMode&&(e.getAccelKey()||e.getShiftKey()))return;this.mousedownEvent.time=Date.now();var r=e.domEvent.target||e.domEvent.srcElement;if("unselectable"in r&&(r.unselectable="on"),t.getDragDelay()){if(F.isWebKit)this.cancelDrag=!0,t.container.draggable=!0;this.setState("dragWait")}else this.startDrag();this.captureMouse(e,this.onMouseDrag.bind(this)),e.defaultPrevented=!0}}}}).call(n.prototype),t.DragdropHandler=n}),ace.define("ace/lib/net",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";var r=e("./dom");t.get=function(e,t){var i=new XMLHttpRequest;i.open("GET",e,!0),i.onreadystatechange=function(){4===i.readyState&&t(i.responseText)},i.send(null)},t.loadScript=function(e,i){var t=r.getDocumentHead(),n=document.createElement("script");n.src=e,t.appendChild(n),n.onload=n.onreadystatechange=function(e,t){!t&&n.readyState&&"loaded"!=n.readyState&&"complete"!=n.readyState||(n=n.onload=n.onreadystatechange=null,t||i())}},t.qualifyURL=function(e){var t=document.createElement("a");return t.href=e,t.href}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(e,t,i){"use strict";function o(){this.propagationStopped=!0}function s(){this.defaultPrevented=!0}var n={};n._emit=n._dispatchEvent=function(e,t){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var i=this._eventRegistry[e]||[],n=this._defaultHandlers[e];if(i.length||n){"object"==typeof t&&t||(t={}),t.type||(t.type=e),t.stopPropagation||(t.stopPropagation=o),t.preventDefault||(t.preventDefault=s),i=i.slice();for(var r=0;r<i.length&&(i[r](t,this),!t.propagationStopped);r++);return n&&!t.defaultPrevented?n(t,this):void 0}},n._signal=function(e,t){var i=(this._eventRegistry||{})[e];if(i){i=i.slice();for(var n=0;n<i.length;n++)i[n](t,this)}},n.once=function(t,i){var n=this;i&&this.addEventListener(t,function e(){n.removeEventListener(t,e),i.apply(null,arguments)})},n.setDefaultHandler=function(e,t){var i=this._defaultHandlers;if((i=i||(this._defaultHandlers={_disabled_:{}}))[e]){var n=i[e],r=i._disabled_[e];r||(i._disabled_[e]=r=[]),r.push(n);var o=r.indexOf(t);-1!=o&&r.splice(o,1)}i[e]=t},n.removeDefaultHandler=function(e,t){var i=this._defaultHandlers;if(i){var n=i._disabled_[e];if(i[e]==t){i[e];n&&this.setDefaultHandler(e,n.pop())}else if(n){var r=n.indexOf(t);-1!=r&&n.splice(r,1)}}},n.on=n.addEventListener=function(e,t,i){this._eventRegistry=this._eventRegistry||{};var n=this._eventRegistry[e];return-1==(n=n||(this._eventRegistry[e]=[])).indexOf(t)&&n[i?"unshift":"push"](t),t},n.off=n.removeListener=n.removeEventListener=function(e,t){this._eventRegistry=this._eventRegistry||{};var i=this._eventRegistry[e];if(i){var n=i.indexOf(t);-1!==n&&i.splice(n,1)}},n.removeAllListeners=function(e){this._eventRegistry&&(this._eventRegistry[e]=[])},t.EventEmitter=n}),ace.define("ace/lib/app_config",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){var r=e("./oop"),n=e("./event_emitter").EventEmitter,o={setOptions:function(t){Object.keys(t).forEach(function(e){this.setOption(e,t[e])},this)},getOptions:function(e){var t={};return e?Array.isArray(e)||(t=e,e=Object.keys(t)):e=Object.keys(this.$options),e.forEach(function(e){t[e]=this.getOption(e)},this),t},setOption:function(e,t){if(this["$"+e]!==t){var i=this.$options[e];if(!i)return s('misspelled option "'+e+'"');if(i.forwardTo)return this[i.forwardTo]&&this[i.forwardTo].setOption(e,t);i.handlesSet||(this["$"+e]=t),i&&i.set&&i.set.call(this,t)}},getOption:function(e){var t=this.$options[e];return t?t.forwardTo?this[t.forwardTo]&&this[t.forwardTo].getOption(e):t&&t.get?t.get.call(this):this["$"+e]:s('misspelled option "'+e+'"')}};function s(e){"undefined"!=typeof console&&console.warn&&console.warn.apply(console,arguments)}function a(e,t){var i=new Error(e);i.data=t,"object"==typeof console&&console.error&&console.error(i),setTimeout(function(){throw i})}function l(){this.$defaultOptions={}}(function(){r.implement(this,n),this.defineOptions=function(i,e,n){return i.$options||(this.$defaultOptions[e]=i.$options={}),Object.keys(n).forEach(function(e){var t=n[e];"string"==typeof t&&(t={forwardTo:t}),t.name||(t.name=e),"initialValue"in(i.$options[t.name]=t)&&(i["$"+t.name]=t.initialValue)}),r.implement(i,o),this},this.resetOptions=function(i){Object.keys(i.$options).forEach(function(e){var t=i.$options[e];"value"in t&&i.setOption(e,t.value)})},this.setDefaultValue=function(e,t,i){var n=this.$defaultOptions[e]||(this.$defaultOptions[e]={});n[t]&&(n.forwardTo?this.setDefaultValue(n.forwardTo,t,i):n[t].value=i)},this.setDefaultValues=function(t,i){Object.keys(i).forEach(function(e){this.setDefaultValue(t,e,i[e])},this)},this.warn=s,this.reportError=a}).call(l.prototype),t.AppConfig=l}),ace.define("ace/config",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/lib/net","ace/lib/app_config"],function(p,m,g){var e=p("./lib/lang"),o=(p("./lib/oop"),p("./lib/net")),t=p("./lib/app_config").AppConfig;g.exports=m=new t;var v=function(){return this||"undefined"!=typeof window&&window}(),y={packaged:!1,workerPath:null,modePath:null,themePath:null,basePath:"",suffix:".js",$moduleUrls:{}};function i(e){if(v&&v.document){y.packaged=e||p.packaged||g.packaged||v.define&&w(21).packaged;for(var t={},i="",n=document.currentScript||document._currentScript,r=(n&&n.ownerDocument||document).getElementsByTagName("script"),o=0;o<r.length;o++){var s=r[o],a=s.src||s.getAttribute("src");if(a){for(var l=s.attributes,c=0,h=l.length;c<h;c++){var d=l[c];0===d.name.indexOf("data-ace-")&&(t[d.name.replace(/^data-ace-/,"").replace(/-(.)/g,function(e,t){return t.toUpperCase()})]=d.value)}var u=a.match(/^(.*)\/ace(\-\w+)?\.js(\?|$)/);u&&(i=u[1])}}for(var f in i&&(t.base=t.base||i,t.packaged=!0),t.basePath=t.base,t.workerPath=t.workerPath||t.base,t.modePath=t.modePath||t.base,t.themePath=t.themePath||t.base,delete t.base,t)void 0!==t[f]&&m.set(f,t[f])}}m.get=function(e){if(!y.hasOwnProperty(e))throw new Error("Unknown config key: "+e);return y[e]},m.set=function(e,t){if(!y.hasOwnProperty(e))throw new Error("Unknown config key: "+e);y[e]=t},m.all=function(){return e.copyObject(y)},m.moduleUrl=function(e,t){if(y.$moduleUrls[e])return y.$moduleUrls[e];var i=e.split("/"),n="snippets"==(t=t||i[i.length-2]||"")?"/":"-",r=i[i.length-1];if("worker"==t&&"-"==n){var o=new RegExp("^"+t+"[\\-_]|[\\-_]"+t+"$","g");r=r.replace(o,"")}(!r||r==t)&&1<i.length&&(r=i[i.length-2]);var s=y[t+"Path"];return null==s?s=y.basePath:"/"==n&&(t=n=""),s&&"/"!=s.slice(-1)&&(s+="/"),s+t+n+r+this.get("suffix")},m.setModuleUrl=function(e,t){return y.$moduleUrls[e]=t},m.$loading={},m.loadModule=function(i,e){var t,n;Array.isArray(i)&&(n=i[0],i=i[1]);try{t=p(i)}catch(e){}if(t&&!m.$loading[i])return e&&e(t);if(m.$loading[i]||(m.$loading[i]=[]),m.$loading[i].push(e),!(1<m.$loading[i].length)){function r(){p([i],function(t){m._emit("load.module",{name:i,module:t});var e=m.$loading[i];m.$loading[i]=null,e.forEach(function(e){e&&e(t)})})}if(!m.get("packaged"))return r();o.loadScript(m.moduleUrl(i,n),r)}},i(!0),m.init=i}),ace.define("ace/mouse/mouse_handler",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/mouse/default_handlers","ace/mouse/default_gutter_handler","ace/mouse/mouse_event","ace/mouse/dragdrop_handler","ace/config"],function(e,t,i){"use strict";function n(r){var o=this;function e(e){document.hasFocus&&document.hasFocus()&&(r.isFocused()||document.activeElement!=(r.textInput&&r.textInput.getElement()))||window.focus(),r.focus()}this.editor=r,new s(this),new a(this),new d(this);var t=r.renderer.getMouseEventTarget();l.addListener(t,"click",this.onMouseEvent.bind(this,"click")),l.addListener(t,"mousemove",this.onMouseMove.bind(this,"mousemove")),l.addMultiMouseDownListener([t,r.renderer.scrollBarV&&r.renderer.scrollBarV.inner,r.renderer.scrollBarH&&r.renderer.scrollBarH.inner,r.textInput&&r.textInput.getElement()].filter(Boolean),[400,300,250],this,"onMouseEvent"),l.addMouseWheelListener(r.container,this.onMouseWheel.bind(this,"mousewheel")),l.addTouchMoveListener(r.container,this.onTouchMove.bind(this,"touchmove"));var i=r.renderer.$gutter;l.addListener(i,"mousedown",this.onMouseEvent.bind(this,"guttermousedown")),l.addListener(i,"click",this.onMouseEvent.bind(this,"gutterclick")),l.addListener(i,"dblclick",this.onMouseEvent.bind(this,"gutterdblclick")),l.addListener(i,"mousemove",this.onMouseEvent.bind(this,"guttermousemove")),l.addListener(t,"mousedown",e),l.addListener(i,"mousedown",e),c.isIE&&r.renderer.scrollBarV&&(l.addListener(r.renderer.scrollBarV.element,"mousedown",e),l.addListener(r.renderer.scrollBarH.element,"mousedown",e)),r.on("mousemove",function(e){if(!o.state&&!o.$dragDelay&&o.$dragEnabled){var t=r.renderer.screenToTextCoordinates(e.x,e.y),i=r.session.selection.getRange(),n=r.renderer;!i.isEmpty()&&i.insideStart(t.row,t.column)?n.setCursorStyle("default"):n.setCursorStyle("")}})}var l=e("../lib/event"),c=e("../lib/useragent"),s=e("./default_handlers").DefaultHandlers,a=e("./default_gutter_handler").GutterHandler,h=e("./mouse_event").MouseEvent,d=e("./dragdrop_handler").DragdropHandler,r=e("../config");(function(){this.onMouseEvent=function(e,t){this.editor._emit(e,new h(t,this.editor))},this.onMouseMove=function(e,t){var i=this.editor._eventRegistry&&this.editor._eventRegistry.mousemove;i&&i.length&&this.editor._emit(e,new h(t,this.editor))},this.onMouseWheel=function(e,t){var i=new h(t,this.editor);i.speed=2*this.$scrollSpeed,i.wheelX=t.wheelX,i.wheelY=t.wheelY,this.editor._emit(e,i)},this.onTouchMove=function(e,t){var i=new h(t,this.editor);i.speed=1,i.wheelX=t.wheelX,i.wheelY=t.wheelY,this.editor._emit(e,i)},this.setState=function(e){this.state=e},this.captureMouse=function(e,t){this.x=e.x,this.y=e.y,this.isMousePressed=!0;var i=this.editor.renderer;i.$keepTextAreaAtCursor&&(i.$keepTextAreaAtCursor=null);function n(e){if(e){if(c.isWebKit&&!e.which&&o.releaseMouse)return o.releaseMouse();o.x=e.clientX,o.y=e.clientY,t&&t(e),o.mouseEvent=new h(e,o.editor),o.$mouseMoved=!0}}function r(e){clearInterval(a),s(),o[o.state+"End"]&&o[o.state+"End"](e),o.state="",null==i.$keepTextAreaAtCursor&&(i.$keepTextAreaAtCursor=!0,i.$moveTextAreaToCursor()),o.isMousePressed=!1,o.$onCaptureMouseMove=o.releaseMouse=null,e&&o.onMouseEvent("mouseup",e)}var o=this,s=function(){o[o.state]&&o[o.state](),o.$mouseMoved=!1};if(c.isOldIE&&"dblclick"==e.domEvent.type)return setTimeout(function(){r(e)});o.$onCaptureMouseMove=n,o.releaseMouse=l.capture(this.editor.container,n,r);var a=setInterval(s,20)},this.releaseMouse=null,this.cancelContextMenu=function(){var t=function(e){e&&e.domEvent&&"contextmenu"!=e.domEvent.type||(this.editor.off("nativecontextmenu",t),e&&e.domEvent&&l.stopEvent(e.domEvent))}.bind(this);setTimeout(t,10),this.editor.on("nativecontextmenu",t)}}).call(n.prototype),r.defineOptions(n.prototype,"mouseHandler",{scrollSpeed:{initialValue:2},dragDelay:{initialValue:c.isMac?150:0},dragEnabled:{initialValue:!0},focusTimout:{initialValue:0},tooltipFollowsMouse:{initialValue:!0}}),t.MouseHandler=n}),ace.define("ace/mouse/fold_handler",["require","exports","module"],function(e,t,i){"use strict";t.FoldHandler=function(s){s.on("click",function(e){var t=e.getDocumentPosition(),i=s.session,n=i.getFoldAt(t.row,t.column,1);n&&(e.getAccelKey()?i.removeFold(n):i.expandFold(n),e.stop())}),s.on("gutterclick",function(e){if("foldWidgets"==s.renderer.$gutterLayer.getRegion(e)){var t=e.getDocumentPosition().row,i=s.session;i.foldWidgets&&i.foldWidgets[t]&&s.session.onFoldWidgetClick(t,e),s.isFocused()||s.focus(),e.stop()}}),s.on("gutterdblclick",function(e){if("foldWidgets"==s.renderer.$gutterLayer.getRegion(e)){var t=e.getDocumentPosition().row,i=s.session,n=i.getParentFoldRangeData(t,!0),r=n.range||n.firstRange;if(r){t=r.start.row;var o=i.getFoldAt(t,i.getLine(t).length,1);o?i.removeFold(o):(i.addFold("...",r),s.renderer.scrollCursorIntoView({row:r.start.row,column:0}))}e.stop()}})}}),ace.define("ace/keyboard/keybinding",["require","exports","module","ace/lib/keys","ace/lib/event"],function(e,t,i){"use strict";function n(e){this.$editor=e,this.$data={editor:e},this.$handlers=[],this.setDefaultHandler(e.commands)}var r=e("../lib/keys"),l=e("../lib/event");(function(){this.setDefaultHandler=function(e){this.removeKeyboardHandler(this.$defaultHandler),this.$defaultHandler=e,this.addKeyboardHandler(e,0)},this.setKeyboardHandler=function(e){var t=this.$handlers;if(t[t.length-1]!=e){for(;t[t.length-1]&&t[t.length-1]!=this.$defaultHandler;)this.removeKeyboardHandler(t[t.length-1]);this.addKeyboardHandler(e,1)}},this.addKeyboardHandler=function(e,t){if(e){"function"!=typeof e||e.handleKeyboard||(e.handleKeyboard=e);var i=this.$handlers.indexOf(e);-1!=i&&this.$handlers.splice(i,1),null==t?this.$handlers.push(e):this.$handlers.splice(t,0,e),-1==i&&e.attach&&e.attach(this.$editor)}},this.removeKeyboardHandler=function(e){var t=this.$handlers.indexOf(e);return-1!=t&&(this.$handlers.splice(t,1),e.detach&&e.detach(this.$editor),!0)},this.getKeyboardHandler=function(){return this.$handlers[this.$handlers.length-1]},this.getStatusText=function(){var t=this.$data,i=t.editor;return this.$handlers.map(function(e){return e.getStatusText&&e.getStatusText(i,t)||""}).filter(Boolean).join(" ")},this.$callKeyboardHandlers=function(e,t,i,n){for(var r,o=!1,s=this.$editor.commands,a=this.$handlers.length;a--&&!((r=this.$handlers[a].handleKeyboard(this.$data,e,t,i,n))&&r.command&&((o="null"==r.command||s.exec(r.command,this.$editor,r.args,n))&&n&&-1!=e&&1!=r.passEvent&&1!=r.command.passEvent&&l.stopEvent(n),o)););return o||-1!=e||(r={command:"insertstring"},o=s.exec("insertstring",this.$editor,t)),o&&this.$editor._signal&&this.$editor._signal("keyboardActivity",r),o},this.onCommandKey=function(e,t,i){var n=r.keyCodeToString(i);this.$callKeyboardHandlers(t,n,i,e)},this.onTextInput=function(e){this.$callKeyboardHandlers(-1,e)}}).call(n.prototype),t.KeyBinding=n}),ace.define("ace/lib/bidiutil",["require","exports","module"],function(e,l,t){"use strict";var m=0,g=0,v=!1,y=!1,w=!1,b=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],C=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],d=0,u=1,f=2,p=3,E=4,A=5,x=6,F=7,S=8,_=9,k=10,D=11,$=12,B=13,T=14,L=15,R=16,P=17,O=18,n=[O,O,O,O,O,O,O,O,O,x,A,x,S,A,O,O,O,O,O,O,O,O,O,O,O,O,O,O,A,A,A,x,S,E,E,D,D,D,E,E,E,E,E,k,_,k,_,_,f,f,f,f,f,f,f,f,f,f,_,E,E,E,E,E,E,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,E,E,E,E,E,E,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,d,E,E,E,E,O,O,O,O,O,O,A,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,O,_,E,D,D,D,D,E,E,E,E,d,E,E,O,E,E,D,D,f,f,E,d,E,E,E,f,d,E,E,E,E,E],r=[S,S,S,S,S,S,S,S,S,S,S,O,O,O,d,u,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,S,A,B,T,L,R,P,_,D,D,D,D,D,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,_,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,E,S];function c(e,t,i){if(!(g<e))if(1!=e||1!=m||y)for(var n,r,o,s,a=i.length,l=0;l<a;){if(t[l]>=e){for(n=l+1;n<a&&t[n]>=e;)n++;for(r=l,o=n-1;r<o;r++,o--)s=i[r],i[r]=i[o],i[o]=s;l=n}l++}else i.reverse()}function M(e,t,i,n){var r,o,s,a,l=t[n];switch(l){case d:case u:v=!1;case E:case p:return l;case f:return v?p:f;case F:return v=!0,u;case S:return E;case _:return n<1||n+1>=t.length||(r=i[n-1])!=f&&r!=p||(o=t[n+1])!=f&&o!=p?E:(v&&(o=p),o==r?o:E);case k:return(r=0<n?i[n-1]:A)==f&&n+1<t.length&&t[n+1]==f?f:E;case D:if(0<n&&i[n-1]==f)return f;if(v)return E;for(a=n+1,s=t.length;a<s&&t[a]==D;)a++;return a<s&&t[a]==f?f:E;case $:for(s=t.length,a=n+1;a<s&&t[a]==$;)a++;if(a<s){var c=e[n],h=1425<=c&&c<=2303||64286==c;if(r=t[a],h&&(r==u||r==F))return u}return n<1||(r=t[n-1])==A?E:i[n-1];case A:return y=!(v=!1),m;case x:return w=!0,E;case B:case T:case R:case P:case L:v=!1;case O:return E}}function I(e){var t=e.charCodeAt(0),i=t>>8;return 0==i?191<t?d:n[t]:5==i?/[\u0591-\u05f4]/.test(e)?u:d:6==i?/[\u0610-\u061a\u064b-\u065f\u06d6-\u06e4\u06e7-\u06ed]/.test(e)?$:/[\u0660-\u0669\u066b-\u066c]/.test(e)?p:1642==t?D:/[\u06f0-\u06f9]/.test(e)?f:F:32==i&&t<=8287?r[255&t]:254==i&&65136<=t?F:E}l.L=d,l.R=u,l.EN=f,l.ON_R=3,l.AN=4,l.R_H=5,l.B=6,l.DOT="·",l.doBidiReorder=function(e,t,i){if(e.length<2)return{};var n=e.split(""),r=new Array(n.length),o=new Array(n.length),s=[];m=i?1:0,function(e,t,i,n){var r=m?C:b,o=null,s=null,a=null,l=0,c=null,h=-1,d=null,u=null,f=[];if(!n)for(d=0,n=[];d<i;d++)n[d]=I(e[d]);for(g=m,w=y=v=!1,u=0;u<i;u++){if(o=l,f[u]=s=M(e,n,f,u),c=240&(l=r[o][s]),l&=15,t[u]=a=r[l][5],0<c)if(16==c){for(d=h;d<u;d++)t[d]=1;h=-1}else h=-1;if(r[l][6])-1==h&&(h=u);else if(-1<h){for(d=h;d<u;d++)t[d]=a;h=-1}n[u]==A&&(t[u]=0),g|=a}if(w)for(d=0;d<i;d++)if(n[d]==x){t[d]=m;for(var p=d-1;0<=p&&n[p]==S;p--)t[p]=m}}(n,s,n.length,t);for(var a=0;a<r.length;r[a]=a,a++);c(2,s,r),c(1,s,r);for(a=0;a<r.length-1;a++)t[a]===p?s[a]=l.AN:s[a]===u&&(t[a]>F&&t[a]<B||t[a]===E||t[a]===O)?s[a]=l.ON_R:0<a&&"ل"===n[a-1]&&/\u0622|\u0623|\u0625|\u0627/.test(n[a])&&(s[a-1]=s[a]=l.R_H,a++);n[n.length-1]===l.DOT&&(s[n.length-1]=l.B);for(a=0;a<r.length;a++)o[a]=s[r[a]];return{logicalFromVisual:r,bidiLevels:o}},l.hasBidiCharacters=function(e,t){for(var i=!1,n=0;n<e.length;n++)t[n]=I(e.charAt(n)),i||t[n]!=u&&t[n]!=F||(i=!0);return i},l.getVisualFromLogicalIdx=function(e,t){for(var i=0;i<t.logicalFromVisual.length;i++)if(t.logicalFromVisual[i]==e)return i;return 0}}),ace.define("ace/bidihandler",["require","exports","module","ace/lib/bidiutil","ace/lib/lang","ace/lib/useragent"],function(e,t,i){"use strict";function n(e){this.session=e,this.bidiMap={},this.currentRow=null,this.bidiUtil=p,this.charWidths=[],this.EOL="¬",this.showInvisibles=!0,this.isRtlDir=!1,this.line="",this.wrapIndent=0,this.isLastRow=!1,this.EOF="¶",this.seenBidi=!1}var p=e("./lib/bidiutil"),s=e("./lib/lang"),r=e("./lib/useragent"),o=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac]/;(function(){this.isBidiRow=function(e,t,i){return!!this.seenBidi&&(e!==this.currentRow&&(this.currentRow=e,this.updateRowLine(t,i),this.updateBidiMap()),this.bidiMap.bidiLevels)},this.onChange=function(e){this.seenBidi?this.currentRow=null:"insert"==e.action&&o.test(e.lines.join("\n"))&&(this.seenBidi=!0,this.currentRow=null)},this.getDocumentRow=function(){var e=0,t=this.session.$screenRowCache;if(t.length){var i=this.session.$getRowCacheIndex(t,this.currentRow);0<=i&&(e=this.session.$docRowCache[i])}return e},this.getSplitIndex=function(){var e=0,t=this.session.$screenRowCache;if(t.length)for(var i,n=this.session.$getRowCacheIndex(t,this.currentRow);0<this.currentRow-e&&(i=this.session.$getRowCacheIndex(t,this.currentRow-e-1))===n;)n=i,e++;return e},this.updateRowLine=function(e,t){if(void 0===e&&(e=this.getDocumentRow()),this.wrapIndent=0,this.isLastRow=e===this.session.getLength()-1,this.line=this.session.getLine(e),this.session.$useWrapMode){var i=this.session.$wrapData[e];i&&(void 0===t&&(t=this.getSplitIndex()),0<t&&i.length?(this.wrapIndent=i.indent,this.line=t<i.length?this.line.substring(i[t-1],i[i.length-1]):this.line.substring(i[i.length-1])):this.line=this.line.substring(0,i[t]))}var n,r=this.session,o=0;this.line=this.line.replace(/\t|[\u1100-\u2029, \u202F-\uFFE6]/g,function(e,t){return"\t"===e||r.isFullWidth(e.charCodeAt(0))?(n="\t"===e?r.getScreenTabSize(t+o):2,o+=n-1,s.stringRepeat(p.DOT,n)):e})},this.updateBidiMap=function(){var e=[],t=this.isLastRow?this.EOF:this.EOL,i=this.line+(this.showInvisibles?t:p.DOT);p.hasBidiCharacters(i,e)?this.bidiMap=p.doBidiReorder(i,e,this.isRtlDir):this.bidiMap={}},this.markAsDirty=function(){this.currentRow=null},this.updateCharacterWidths=function(e){if(this.seenBidi&&this.characterWidth!==e.$characterSize.width){var t=this.characterWidth=e.$characterSize.width,i=e.$measureCharWidth("ה");this.charWidths[p.L]=this.charWidths[p.EN]=this.charWidths[p.ON_R]=t,this.charWidths[p.R]=this.charWidths[p.AN]=i,this.charWidths[p.R_H]=r.isChrome?i:.45*i,this.charWidths[p.B]=0,this.currentRow=null}},this.getShowInvisibles=function(){return this.showInvisibles},this.setShowInvisibles=function(e){this.showInvisibles=e,this.currentRow=null},this.setEolChar=function(e){this.EOL=e},this.setTextDir=function(e){this.isRtlDir=e},this.getPosLeft=function(e){e-=this.wrapIndent;var t=p.getVisualFromLogicalIdx(0<e?e-1:0,this.bidiMap),i=this.bidiMap.bidiLevels,n=0;0===e&&i[t]%2!=0&&t++;for(var r=0;r<t;r++)n+=this.charWidths[i[r]];return 0!==e&&i[t]%2==0&&(n+=this.charWidths[i[t]]),this.wrapIndent&&(n+=this.wrapIndent*this.charWidths[p.L]),n},this.getSelections=function(e,t){for(var i,n,r=this.bidiMap,o=r.bidiLevels,s=this.wrapIndent*this.charWidths[p.L],a=[],l=Math.min(e,t)-this.wrapIndent,c=Math.max(e,t)-this.wrapIndent,h=!1,d=!1,u=0,f=0;f<o.length;f++)n=r.logicalFromVisual[f],i=o[f],(h=l<=n&&n<c)&&!d?u=s:!h&&d&&a.push({left:u,width:s-u}),s+=this.charWidths[i],d=h;return h&&f===o.length&&a.push({left:u,width:s-u}),a},this.offsetToCol=function(e){e=Math.max(e,0);var t=0,i=0,n=this.bidiMap.bidiLevels,r=this.charWidths[n[i]];for(this.wrapIndent&&(e-=this.wrapIndent*this.charWidths[p.L]);t+r/2<e;){if(t+=r,i===n.length-1){r=0;break}r=this.charWidths[n[++i]]}return(0<i&&n[i-1]%2!=0&&n[i]%2==0?(e<t&&i--,this.bidiMap.logicalFromVisual[i]):0<i&&n[i-1]%2==0&&n[i]%2!=0?1+(t<e?this.bidiMap.logicalFromVisual[i]:this.bidiMap.logicalFromVisual[i-1]):this.isRtlDir&&i===n.length-1&&0===r&&n[i-1]%2==0||!this.isRtlDir&&0===i&&n[i]%2!=0?1+this.bidiMap.logicalFromVisual[i]:(0<i&&n[i-1]%2!=0&&0!==r&&i--,this.bidiMap.logicalFromVisual[i]))+this.wrapIndent}}).call(n.prototype),t.BidiHandler=n}),ace.define("ace/range",["require","exports","module"],function(e,t,i){"use strict";function o(e,t,i,n){this.start={row:e,column:t},this.end={row:i,column:n}}(function(){this.isEqual=function(e){return this.start.row===e.start.row&&this.end.row===e.end.row&&this.start.column===e.start.column&&this.end.column===e.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(e,t){return 0==this.compare(e,t)},this.compareRange=function(e){var t,i=e.end,n=e.start;return 1==(t=this.compare(i.row,i.column))?1==(t=this.compare(n.row,n.column))?2:0==t?1:0:-1==t?-2:-1==(t=this.compare(n.row,n.column))?-1:1==t?42:0},this.comparePoint=function(e){return this.compare(e.row,e.column)},this.containsRange=function(e){return 0==this.comparePoint(e.start)&&0==this.comparePoint(e.end)},this.intersects=function(e){var t=this.compareRange(e);return-1==t||0==t||1==t},this.isEnd=function(e,t){return this.end.row==e&&this.end.column==t},this.isStart=function(e,t){return this.start.row==e&&this.start.column==t},this.setStart=function(e,t){"object"==typeof e?(this.start.column=e.column,this.start.row=e.row):(this.start.row=e,this.start.column=t)},this.setEnd=function(e,t){"object"==typeof e?(this.end.column=e.column,this.end.row=e.row):(this.end.row=e,this.end.column=t)},this.inside=function(e,t){return 0==this.compare(e,t)&&(!this.isEnd(e,t)&&!this.isStart(e,t))},this.insideStart=function(e,t){return 0==this.compare(e,t)&&!this.isEnd(e,t)},this.insideEnd=function(e,t){return 0==this.compare(e,t)&&!this.isStart(e,t)},this.compare=function(e,t){return this.isMultiLine()||e!==this.start.row?e<this.start.row?-1:e>this.end.row?1:this.start.row===e?t>=this.start.column?0:-1:this.end.row===e?t<=this.end.column?0:1:0:t<this.start.column?-1:t>this.end.column?1:0},this.compareStart=function(e,t){return this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.compareEnd=function(e,t){return this.end.row==e&&this.end.column==t?1:this.compare(e,t)},this.compareInside=function(e,t){return this.end.row==e&&this.end.column==t?1:this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.clipRows=function(e,t){if(this.end.row>t)var i={row:t+1,column:0};else if(this.end.row<e)i={row:e,column:0};if(this.start.row>t)var n={row:t+1,column:0};else if(this.start.row<e)n={row:e,column:0};return o.fromPoints(n||this.start,i||this.end)},this.extend=function(e,t){var i=this.compare(e,t);if(0==i)return this;if(-1==i)var n={row:e,column:t};else var r={row:e,column:t};return o.fromPoints(n||this.start,r||this.end)},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return o.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new o(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new o(this.start.row,0,this.end.row,0)},this.toScreenRange=function(e){var t=e.documentToScreenPosition(this.start),i=e.documentToScreenPosition(this.end);return new o(t.row,t.column,i.row,i.column)},this.moveBy=function(e,t){this.start.row+=e,this.start.column+=t,this.end.row+=e,this.end.column+=t}}).call(o.prototype),o.fromPoints=function(e,t){return new o(e.row,e.column,t.row,t.column)},o.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},o.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},t.Range=o}),ace.define("ace/selection",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/range"],function(e,t,i){"use strict";function n(e){this.session=e,this.doc=e.getDocument(),this.clearSelection(),this.lead=this.selectionLead=this.doc.createAnchor(0,0),this.anchor=this.selectionAnchor=this.doc.createAnchor(0,0);var t=this;this.lead.on("change",function(e){t._emit("changeCursor"),t.$isEmpty||t._emit("changeSelection"),t.$keepDesiredColumnOnChange||e.old.column==e.value.column||(t.$desiredColumn=null)}),this.selectionAnchor.on("change",function(){t.$isEmpty||t._emit("changeSelection")})}var r=e("./lib/oop"),s=e("./lib/lang"),o=e("./lib/event_emitter").EventEmitter,a=e("./range").Range;(function(){r.implement(this,o),this.isEmpty=function(){return this.$isEmpty||this.anchor.row==this.lead.row&&this.anchor.column==this.lead.column},this.isMultiLine=function(){return!this.isEmpty()&&this.getRange().isMultiLine()},this.getCursor=function(){return this.lead.getPosition()},this.setSelectionAnchor=function(e,t){this.anchor.setPosition(e,t),this.$isEmpty&&(this.$isEmpty=!1,this._emit("changeSelection"))},this.getSelectionAnchor=function(){return this.$isEmpty?this.getSelectionLead():this.anchor.getPosition()},this.getSelectionLead=function(){return this.lead.getPosition()},this.shiftSelection=function(e){if(this.$isEmpty)this.moveCursorTo(this.lead.row,this.lead.column+e);else{var t=this.getSelectionAnchor(),i=this.getSelectionLead(),n=this.isBackwards();n&&0===t.column||this.setSelectionAnchor(t.row,t.column+e),!n&&0===i.column||this.$moveSelection(function(){this.moveCursorTo(i.row,i.column+e)})}},this.isBackwards=function(){var e=this.anchor,t=this.lead;return e.row>t.row||e.row==t.row&&e.column>t.column},this.getRange=function(){var e=this.anchor,t=this.lead;return this.isEmpty()?a.fromPoints(t,t):this.isBackwards()?a.fromPoints(t,e):a.fromPoints(e,t)},this.clearSelection=function(){this.$isEmpty||(this.$isEmpty=!0,this._emit("changeSelection"))},this.selectAll=function(){var e=this.doc.getLength()-1;this.setSelectionAnchor(0,0),this.moveCursorTo(e,this.doc.getLine(e).length)},this.setRange=this.setSelectionRange=function(e,t){t?(this.setSelectionAnchor(e.end.row,e.end.column),this.selectTo(e.start.row,e.start.column)):(this.setSelectionAnchor(e.start.row,e.start.column),this.selectTo(e.end.row,e.end.column)),this.getRange().isEmpty()&&(this.$isEmpty=!0),this.$desiredColumn=null},this.$moveSelection=function(e){var t=this.lead;this.$isEmpty&&this.setSelectionAnchor(t.row,t.column),e.call(this)},this.selectTo=function(e,t){this.$moveSelection(function(){this.moveCursorTo(e,t)})},this.selectToPosition=function(e){this.$moveSelection(function(){this.moveCursorToPosition(e)})},this.moveTo=function(e,t){this.clearSelection(),this.moveCursorTo(e,t)},this.moveToPosition=function(e){this.clearSelection(),this.moveCursorToPosition(e)},this.selectUp=function(){this.$moveSelection(this.moveCursorUp)},this.selectDown=function(){this.$moveSelection(this.moveCursorDown)},this.selectRight=function(){this.$moveSelection(this.moveCursorRight)},this.selectLeft=function(){this.$moveSelection(this.moveCursorLeft)},this.selectLineStart=function(){this.$moveSelection(this.moveCursorLineStart)},this.selectLineEnd=function(){this.$moveSelection(this.moveCursorLineEnd)},this.selectFileEnd=function(){this.$moveSelection(this.moveCursorFileEnd)},this.selectFileStart=function(){this.$moveSelection(this.moveCursorFileStart)},this.selectWordRight=function(){this.$moveSelection(this.moveCursorWordRight)},this.selectWordLeft=function(){this.$moveSelection(this.moveCursorWordLeft)},this.getWordRange=function(e,t){if(void 0===t){var i=e||this.lead;e=i.row,t=i.column}return this.session.getWordRange(e,t)},this.selectWord=function(){this.setSelectionRange(this.getWordRange())},this.selectAWord=function(){var e=this.getCursor(),t=this.session.getAWordRange(e.row,e.column);this.setSelectionRange(t)},this.getLineRange=function(e,t){var i,n="number"==typeof e?e:this.lead.row,r=this.session.getFoldLine(n);return i=r?(n=r.start.row,r.end.row):n,!0===t?new a(n,0,i,this.session.getLine(i).length):new a(n,0,i+1,0)},this.selectLine=function(){this.setSelectionRange(this.getLineRange())},this.moveCursorUp=function(){this.moveCursorBy(-1,0)},this.moveCursorDown=function(){this.moveCursorBy(1,0)},this.wouldMoveIntoSoftTab=function(e,t,i){var n=e.column,r=e.column+t;return i<0&&(n=e.column-t,r=e.column),this.session.isTabStop(e)&&this.doc.getLine(e.row).slice(n,r).split(" ").length-1==t},this.moveCursorLeft=function(){var e,t=this.lead.getPosition();if(e=this.session.getFoldAt(t.row,t.column,-1))this.moveCursorTo(e.start.row,e.start.column);else if(0===t.column)0<t.row&&this.moveCursorTo(t.row-1,this.doc.getLine(t.row-1).length);else{var i=this.session.getTabSize();this.wouldMoveIntoSoftTab(t,i,-1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,-i):this.moveCursorBy(0,-1)}},this.moveCursorRight=function(){var e,t=this.lead.getPosition();if(e=this.session.getFoldAt(t.row,t.column,1))this.moveCursorTo(e.end.row,e.end.column);else if(this.lead.column==this.doc.getLine(this.lead.row).length)this.lead.row<this.doc.getLength()-1&&this.moveCursorTo(this.lead.row+1,0);else{var i=this.session.getTabSize();t=this.lead;this.wouldMoveIntoSoftTab(t,i,1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,i):this.moveCursorBy(0,1)}},this.moveCursorLineStart=function(){var e=this.lead.row,t=this.lead.column,i=this.session.documentToScreenRow(e,t),n=this.session.screenToDocumentPosition(i,0),r=this.session.getDisplayLine(e,null,n.row,n.column).match(/^\s*/);r[0].length==t||this.session.$useEmacsStyleLineStart||(n.column+=r[0].length),this.moveCursorToPosition(n)},this.moveCursorLineEnd=function(){var e=this.lead,t=this.session.getDocumentLastRowColumnPosition(e.row,e.column);if(this.lead.column==t.column){var i=this.session.getLine(t.row);if(t.column==i.length){var n=i.search(/\s+$/);0<n&&(t.column=n)}}this.moveCursorTo(t.row,t.column)},this.moveCursorFileEnd=function(){var e=this.doc.getLength()-1,t=this.doc.getLine(e).length;this.moveCursorTo(e,t)},this.moveCursorFileStart=function(){this.moveCursorTo(0,0)},this.moveCursorLongWordRight=function(){var e=this.lead.row,t=this.lead.column,i=this.doc.getLine(e),n=i.substring(t);this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0;var r=this.session.getFoldAt(e,t,1);if(r)this.moveCursorTo(r.end.row,r.end.column);else{if(this.session.nonTokenRe.exec(n)&&(t+=this.session.nonTokenRe.lastIndex,this.session.nonTokenRe.lastIndex=0,n=i.substring(t)),t>=i.length)return this.moveCursorTo(e,i.length),this.moveCursorRight(),void(e<this.doc.getLength()-1&&this.moveCursorWordRight());this.session.tokenRe.exec(n)&&(t+=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(e,t)}},this.moveCursorLongWordLeft=function(){var e,t=this.lead.row,i=this.lead.column;if(e=this.session.getFoldAt(t,i,-1))this.moveCursorTo(e.start.row,e.start.column);else{var n=this.session.getFoldStringAt(t,i,-1);null==n&&(n=this.doc.getLine(t).substring(0,i));var r=s.stringReverse(n);if(this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.nonTokenRe.exec(r)&&(i-=this.session.nonTokenRe.lastIndex,r=r.slice(this.session.nonTokenRe.lastIndex),this.session.nonTokenRe.lastIndex=0),i<=0)return this.moveCursorTo(t,0),this.moveCursorLeft(),void(0<t&&this.moveCursorWordLeft());this.session.tokenRe.exec(r)&&(i-=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(t,i)}},this.$shortWordEndIndex=function(e){var t,i=0,n=/\s/,r=this.session.tokenRe;if(r.lastIndex=0,this.session.tokenRe.exec(e))i=this.session.tokenRe.lastIndex;else{for(;(t=e[i])&&n.test(t);)i++;if(i<1)for(r.lastIndex=0;(t=e[i])&&!r.test(t);)if(r.lastIndex=0,i++,n.test(t)){if(2<i){i--;break}for(;(t=e[i])&&n.test(t);)i++;if(2<i)break}}return r.lastIndex=0,i},this.moveCursorShortWordRight=function(){var e=this.lead.row,t=this.lead.column,i=this.doc.getLine(e),n=i.substring(t),r=this.session.getFoldAt(e,t,1);if(r)return this.moveCursorTo(r.end.row,r.end.column);if(t==i.length){for(var o=this.doc.getLength();e++,n=this.doc.getLine(e),e<o&&/^\s*$/.test(n););/^\s+/.test(n)||(n=""),t=0}var s=this.$shortWordEndIndex(n);this.moveCursorTo(e,t+s)},this.moveCursorShortWordLeft=function(){var e,t=this.lead.row,i=this.lead.column;if(e=this.session.getFoldAt(t,i,-1))return this.moveCursorTo(e.start.row,e.start.column);var n=this.session.getLine(t).substring(0,i);if(0===i){for(;t--,n=this.doc.getLine(t),0<t&&/^\s*$/.test(n););i=n.length,/\s+$/.test(n)||(n="")}var r=s.stringReverse(n),o=this.$shortWordEndIndex(r);return this.moveCursorTo(t,i-o)},this.moveCursorWordRight=function(){this.session.$selectLongWords?this.moveCursorLongWordRight():this.moveCursorShortWordRight()},this.moveCursorWordLeft=function(){this.session.$selectLongWords?this.moveCursorLongWordLeft():this.moveCursorShortWordLeft()},this.moveCursorBy=function(e,t){var i,n=this.session.documentToScreenPosition(this.lead.row,this.lead.column);0===t&&(0!==e&&(this.session.$bidiHandler.isBidiRow(n.row,this.lead.row)?(i=this.session.$bidiHandler.getPosLeft(n.column),n.column=Math.round(i/this.session.$bidiHandler.charWidths[0])):i=n.column*this.session.$bidiHandler.charWidths[0]),this.$desiredColumn?n.column=this.$desiredColumn:this.$desiredColumn=n.column);var r=this.session.screenToDocumentPosition(n.row+e,n.column,i);0!==e&&0===t&&r.row===this.lead.row&&r.column===this.lead.column&&this.session.lineWidgets&&this.session.lineWidgets[r.row]&&(0<r.row||0<e)&&r.row++,this.moveCursorTo(r.row,r.column+t,0===t)},this.moveCursorToPosition=function(e){this.moveCursorTo(e.row,e.column)},this.moveCursorTo=function(e,t,i){var n=this.session.getFoldAt(e,t,1);n&&(e=n.start.row,t=n.start.column),this.$keepDesiredColumnOnChange=!0;var r=this.session.getLine(e);/[\uDC00-\uDFFF]/.test(r.charAt(t))&&r.charAt(t-1)&&(this.lead.row==e&&this.lead.column==t+1?t-=1:t+=1),this.lead.setPosition(e,t),this.$keepDesiredColumnOnChange=!1,i||(this.$desiredColumn=null)},this.moveCursorToScreen=function(e,t,i){var n=this.session.screenToDocumentPosition(e,t);this.moveCursorTo(n.row,n.column,i)},this.detach=function(){this.lead.detach(),this.anchor.detach(),this.session=this.doc=null},this.fromOrientedRange=function(e){this.setSelectionRange(e,e.cursor==e.start),this.$desiredColumn=e.desiredColumn||this.$desiredColumn},this.toOrientedRange=function(e){var t=this.getRange();return e?(e.start.column=t.start.column,e.start.row=t.start.row,e.end.column=t.end.column,e.end.row=t.end.row):e=t,e.cursor=this.isBackwards()?e.start:e.end,e.desiredColumn=this.$desiredColumn,e},this.getRangeOfMovements=function(e){var t=this.getCursor();try{e(this);var i=this.getCursor();return a.fromPoints(t,i)}catch(e){return a.fromPoints(t,t)}finally{this.moveCursorToPosition(t)}},this.toJSON=function(){if(this.rangeCount)var e=this.ranges.map(function(e){var t=e.clone();return t.isBackwards=e.cursor==e.start,t});else(e=this.getRange()).isBackwards=this.isBackwards();return e},this.fromJSON=function(e){if(null==e.start){if(this.rangeList){this.toSingleRange(e[0]);for(var t=e.length;t--;){var i=a.fromPoints(e[t].start,e[t].end);e[t].isBackwards&&(i.cursor=i.start),this.addRange(i,!0)}return}e=e[0]}this.rangeList&&this.toSingleRange(e),this.setSelectionRange(e,e.isBackwards)},this.isEqual=function(e){if((e.length||this.rangeCount)&&e.length!=this.rangeCount)return!1;if(!e.length||!this.ranges)return this.getRange().isEqual(e);for(var t=this.ranges.length;t--;)if(!this.ranges[t].isEqual(e[t]))return!1;return!0}}).call(n.prototype),t.Selection=n}),ace.define("ace/tokenizer",["require","exports","module","ace/config"],function(e,t,i){"use strict";function n(e){for(var t in this.states=e,this.regExps={},this.matchMappings={},this.states){for(var i=this.states[t],n=[],r=0,o=this.matchMappings[t]={defaultToken:"text"},s="g",a=[],l=0;l<i.length;l++){var c=i[l];if(c.defaultToken&&(o.defaultToken=c.defaultToken),c.caseInsensitive&&(s="gi"),null!=c.regex){c.regex instanceof RegExp&&(c.regex=c.regex.toString().slice(1,-1));var h=c.regex,d=new RegExp("(?:("+h+")|(.))").exec("a").length-2;Array.isArray(c.token)?1==c.token.length||1==d?c.token=c.token[0]:d-1!=c.token.length?(this.reportError("number of classes and regexp groups doesn't match",{rule:c,groupCount:d-1}),c.token=c.token[0]):(c.tokenArray=c.token,c.token=null,c.onMatch=this.$arrayTokens):"function"!=typeof c.token||c.onMatch||(c.onMatch=1<d?this.$applyToken:c.token),1<d&&(h=/\\\d/.test(c.regex)?c.regex.replace(/\\([0-9]+)/g,function(e,t){return"\\"+(parseInt(t,10)+r+1)}):(d=1,this.removeCapturingGroups(c.regex)),c.splitRegex||"string"==typeof c.token||a.push(c)),o[r]=l,r+=d,n.push(h),c.onMatch||(c.onMatch=null)}}n.length||(o[0]=0,n.push("$")),a.forEach(function(e){e.splitRegex=this.createSplitterRegexp(e.regex,s)},this),this.regExps[t]=new RegExp("("+n.join(")|(")+")|($)",s)}}var r=e("./config"),y=2e3;(function(){this.$setMaxTokenCount=function(e){y=0|e},this.$applyToken=function(e){var t=this.splitRegex.exec(e).slice(1),i=this.token.apply(this,t);if("string"==typeof i)return[{type:i,value:e}];for(var n=[],r=0,o=i.length;r<o;r++)t[r]&&(n[n.length]={type:i[r],value:t[r]});return n},this.$arrayTokens=function(e){if(!e)return[];var t=this.splitRegex.exec(e);if(!t)return"text";for(var i=[],n=this.tokenArray,r=0,o=n.length;r<o;r++)t[r+1]&&(i[i.length]={type:n[r],value:t[r+1]});return i},this.removeCapturingGroups=function(e){return e.replace(/\[(?:\\.|[^\]])*?\]|\\.|\(\?[:=!]|(\()/g,function(e,t){return t?"(?:":e})},this.createSplitterRegexp=function(e,t){if(-1!=e.indexOf("(?=")){var s=0,a=!1,l={};e.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g,function(e,t,i,n,r,o){return a?a="]"!=r:r?a=!0:n?(s==l.stack&&(l.end=o+1,l.stack=-1),s--):i&&(s++,1!=i.length&&(l.stack=s,l.start=o)),e}),null!=l.end&&/^\)*$/.test(e.substr(l.end))&&(e=e.substring(0,l.start)+e.substr(l.end))}return"^"!=e.charAt(0)&&(e="^"+e),"$"!=e.charAt(e.length-1)&&(e+="$"),new RegExp(e,(t||"").replace("g",""))},this.getLineTokens=function(e,t){if(t&&"string"!=typeof t)"#tmp"===(t=(i=t.slice(0))[0])&&(i.shift(),t=i.shift());else var i=[];var n=t||"start",r=this.states[n];r||(n="start",r=this.states[n]);for(var o,s=this.matchMappings[n],a=this.regExps[n],l=[],c=a.lastIndex=0,h=0,d={type:null,value:""};o=a.exec(e);){var u=s.defaultToken,f=null,p=o[0],m=a.lastIndex;if(m-p.length>c){var g=e.substring(c,m-p.length);d.type==u?d.value+=g:(d.type&&l.push(d),d={type:u,value:g})}for(var v=0;v<o.length-2;v++)if(void 0!==o[v+1]){u=(f=r[s[v]]).onMatch?f.onMatch(p,n,i,e):f.token,f.next&&(n="string"==typeof f.next?f.next:f.next(n,i),(r=this.states[n])||(this.reportError("state doesn't exist",n),n="start",r=this.states[n]),s=this.matchMappings[n],c=m,(a=this.regExps[n]).lastIndex=m),f.consumeLineEnd&&(c=m);break}if(p)if("string"==typeof u)f&&!1===f.merge||d.type!==u?(d.type&&l.push(d),d={type:u,value:p}):d.value+=p;else if(u){d.type&&l.push(d),d={type:null,value:""};for(v=0;v<u.length;v++)l.push(u[v])}if(c==e.length)break;if(c=m,h++>y){for(h>2*e.length&&this.reportError("infinite loop with in ace tokenizer",{startState:t,line:e});c<e.length;)d.type&&l.push(d),d={value:e.substring(c,c+=2e3),type:"overflow"};n="start",i=[];break}}return d.type&&l.push(d),1<i.length&&i[0]!==n&&i.unshift("#tmp",n),{tokens:l,state:i.length?i:n}},this.reportError=r.reportError}).call(n.prototype),t.Tokenizer=n}),ace.define("ace/mode/text_highlight_rules",["require","exports","module","ace/lib/lang"],function(e,t,i){"use strict";function n(){this.$rules={start:[{token:"empty_line",regex:"^$"},{defaultToken:"text"}]}}var c=e("../lib/lang");(function(){this.addRules=function(e,t){if(t)for(var i in e){for(var n=e[i],r=0;r<n.length;r++){var o=n[r];(o.next||o.onMatch)&&("string"==typeof o.next&&0!==o.next.indexOf(t)&&(o.next=t+o.next),o.nextState&&0!==o.nextState.indexOf(t)&&(o.nextState=t+o.nextState))}this.$rules[t+i]=n}else for(var i in e)this.$rules[i]=e[i]},this.getRules=function(){return this.$rules},this.embedRules=function(e,t,i,n,r){var o="function"==typeof e?(new e).getRules():e;if(n)for(var s=0;s<n.length;s++)n[s]=t+n[s];else for(var a in n=[],o)n.push(t+a);if(this.addRules(o,t),i){var l=Array.prototype[r?"push":"unshift"];for(s=0;s<n.length;s++)l.apply(this.$rules[n[s]],c.deepCopy(i))}this.$embeds||(this.$embeds=[]),this.$embeds.push(t)},this.getEmbeds=function(){return this.$embeds};function f(e,t){return"start"==e&&!t.length||t.unshift(this.nextState,e),this.nextState}function p(e,t){return t.shift(),t.shift()||"start"}this.normalizeRules=function(){var d=0,u=this.$rules;Object.keys(u).forEach(function e(t){var i=u[t];i.processed=!0;for(var n=0;n<i.length;n++){var r=i[n],o=null;Array.isArray(r)&&(o=r,r={}),!r.regex&&r.start&&(r.regex=r.start,r.next||(r.next=[]),r.next.push({defaultToken:r.token},{token:r.token+".end",regex:r.end||r.start,next:"pop"}),r.token=r.token+".start",r.push=!0);var s=r.next||r.push;if(s&&Array.isArray(s)){var a=r.stateName;a||("string"!=typeof(a=r.token)&&(a=a[0]||""),u[a]&&(a+=d++)),u[a]=s,e(r.next=a)}else"pop"==s&&(r.next=p);if(r.push&&(r.nextState=r.next||r.push,r.next=f,delete r.push),r.rules)for(var l in r.rules)u[l]?u[l].push&&u[l].push.apply(u[l],r.rules[l]):u[l]=r.rules[l];var c="string"==typeof r?r:r.include;if(c&&(o=Array.isArray(c)?c.map(function(e){return u[e]}):u[c]),o){var h=[n,1].concat(o);r.noEscape&&(h=h.filter(function(e){return!e.next})),i.splice.apply(i,h),n--}r.keywordMap&&(r.token=this.createKeywordMapper(r.keywordMap,r.defaultToken||"text",r.caseInsensitive),delete r.defaultToken)}},this)},this.createKeywordMapper=function(r,t,o,s){var a=Object.create(null);return Object.keys(r).forEach(function(e){var t=r[e];o&&(t=t.toLowerCase());for(var i=t.split(s||"|"),n=i.length;n--;)a[i[n]]=e}),Object.getPrototypeOf(a)&&(a.__proto__=null),this.$keywordList=Object.keys(a),r=null,o?function(e){return a[e.toLowerCase()]||t}:function(e){return a[e]||t}},this.getKeywords=function(){return this.$keywords}}).call(n.prototype),t.TextHighlightRules=n}),ace.define("ace/mode/behaviour",["require","exports","module"],function(e,t,i){"use strict";function n(){this.$behaviours={}}(function(){this.add=function(e,t,i){switch(void 0){case this.$behaviours:this.$behaviours={};case this.$behaviours[e]:this.$behaviours[e]={}}this.$behaviours[e][t]=i},this.addBehaviours=function(e){for(var t in e)for(var i in e[t])this.add(t,i,e[t][i])},this.remove=function(e){this.$behaviours&&this.$behaviours[e]&&delete this.$behaviours[e]},this.inherit=function(e,t){if("function"==typeof e)var i=(new e).getBehaviours(t);else i=e.getBehaviours(t);this.addBehaviours(i)},this.getBehaviours=function(e){if(e){for(var t={},i=0;i<e.length;i++)this.$behaviours[e[i]]&&(t[e[i]]=this.$behaviours[e[i]]);return t}return this.$behaviours}}).call(n.prototype),t.Behaviour=n}),ace.define("ace/token_iterator",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(e,t,i){this.$session=e,this.$row=t,this.$rowTokens=e.getTokens(t);var n=e.getTokenAt(t,i);this.$tokenIndex=n?n.index:-1}var r=e("./range").Range;(function(){this.stepBackward=function(){for(this.$tokenIndex-=1;this.$tokenIndex<0;){if(this.$row-=1,this.$row<0)return this.$row=0,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=this.$rowTokens.length-1}return this.$rowTokens[this.$tokenIndex]},this.stepForward=function(){var e;for(this.$tokenIndex+=1;this.$tokenIndex>=this.$rowTokens.length;){if(this.$row+=1,e=e||this.$session.getLength(),this.$row>=e)return this.$row=e-1,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=0}return this.$rowTokens[this.$tokenIndex]},this.getCurrentToken=function(){return this.$rowTokens[this.$tokenIndex]},this.getCurrentTokenRow=function(){return this.$row},this.getCurrentTokenColumn=function(){var e=this.$rowTokens,t=this.$tokenIndex,i=e[t].start;if(void 0!==i)return i;for(i=0;0<t;)i+=e[t-=1].value.length;return i},this.getCurrentTokenPosition=function(){return{row:this.$row,column:this.getCurrentTokenColumn()}},this.getCurrentTokenRange=function(){var e=this.$rowTokens[this.$tokenIndex],t=this.getCurrentTokenColumn();return new r(this.$row,t,this.$row,t+e.value.length)}}).call(n.prototype),t.TokenIterator=n}),ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(e,t,i){"use strict";function C(e){var t=-1;if(e.multiSelect&&(t=e.selection.index,l.rangeCount!=e.multiSelect.rangeCount&&(l={rangeCount:e.multiSelect.rangeCount})),l[t])return p=l[t];p=l[t]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""}}function E(e,t,i,n){var r=e.end.row-e.start.row;return{text:i+t+n,selection:[0,e.start.column+1,r,e.end.column+(r?0:1)]}}var p,n=e("../../lib/oop"),r=e("../behaviour").Behaviour,o=e("../../token_iterator").TokenIterator,m=e("../../lib/lang"),s=["text","paren.rparen","punctuation.operator"],a=["text","paren.rparen","punctuation.operator","comment"],l={},A={'"':'"',"'":"'"},g=function(f){this.add("braces","insertion",function(e,t,i,n,r){var o=i.getCursorPosition(),s=n.doc.getLine(o.row);if("{"==r){C(i);var a=i.getSelectionRange(),l=n.doc.getTextRange(a);if(""!==l&&"{"!==l&&i.getWrapBehavioursEnabled())return E(a,l,"{","}");if(g.isSaneInsertion(i,n))return/[\]\}\)]/.test(s[o.column])||i.inMultiSelectMode||f&&f.braces?(g.recordAutoInsert(i,n,"}"),{text:"{}",selection:[1,1]}):(g.recordMaybeInsert(i,n,"{"),{text:"{",selection:[1,1]})}else if("}"==r){if(C(i),"}"==s.substring(o.column,o.column+1))if(null!==n.$findOpeningBracket("}",{column:o.column+1,row:o.row})&&g.isAutoInsertedClosing(o,s,r))return g.popAutoInsertedClosing(),{text:"",selection:[1,1]}}else{if("\n"==r||"\r\n"==r){C(i);var c="";if(g.isMaybeInsertedClosing(o,s)&&(c=m.stringRepeat("}",p.maybeInsertedBrackets),g.clearMaybeInsertedClosing()),"}"===s.substring(o.column,o.column+1)){var h=n.findMatchingBracket({row:o.row,column:o.column+1},"}");if(!h)return null;var d=this.$getIndent(n.getLine(h.row))}else{if(!c)return void g.clearMaybeInsertedClosing();d=this.$getIndent(s)}var u=d+n.getTabString();return{text:"\n"+u+"\n"+d+c,selection:[1,u.length,1,u.length]}}g.clearMaybeInsertedClosing()}}),this.add("braces","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&"{"==o){if(C(i),"}"==n.doc.getLine(r.start.row).substring(r.end.column,r.end.column+1))return r.end.column++,r;p.maybeInsertedBrackets--}}),this.add("parens","insertion",function(e,t,i,n,r){if("("==r){C(i);var o=i.getSelectionRange(),s=n.doc.getTextRange(o);if(""!==s&&i.getWrapBehavioursEnabled())return E(o,s,"(",")");if(g.isSaneInsertion(i,n))return g.recordAutoInsert(i,n,")"),{text:"()",selection:[1,1]}}else if(")"==r){C(i);var a=i.getCursorPosition(),l=n.doc.getLine(a.row);if(")"==l.substring(a.column,a.column+1))if(null!==n.$findOpeningBracket(")",{column:a.column+1,row:a.row})&&g.isAutoInsertedClosing(a,l,r))return g.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("parens","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&"("==o&&(C(i),")"==n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)))return r.end.column++,r}),this.add("brackets","insertion",function(e,t,i,n,r){if("["==r){C(i);var o=i.getSelectionRange(),s=n.doc.getTextRange(o);if(""!==s&&i.getWrapBehavioursEnabled())return E(o,s,"[","]");if(g.isSaneInsertion(i,n))return g.recordAutoInsert(i,n,"]"),{text:"[]",selection:[1,1]}}else if("]"==r){C(i);var a=i.getCursorPosition(),l=n.doc.getLine(a.row);if("]"==l.substring(a.column,a.column+1))if(null!==n.$findOpeningBracket("]",{column:a.column+1,row:a.row})&&g.isAutoInsertedClosing(a,l,r))return g.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("brackets","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&"["==o&&(C(i),"]"==n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)))return r.end.column++,r}),this.add("string_dquotes","insertion",function(e,t,i,n,r){var o=n.$mode.$quotes||A;if(1==r.length&&o[r]){if(this.lineCommentStart&&-1!=this.lineCommentStart.indexOf(r))return;C(i);var s=r,a=i.getSelectionRange(),l=n.doc.getTextRange(a);if(!(""===l||1==l.length&&o[l])&&i.getWrapBehavioursEnabled())return E(a,l,s,s);if(!l){var c=i.getCursorPosition(),h=n.doc.getLine(c.row),d=h.substring(c.column-1,c.column),u=h.substring(c.column,c.column+1),f=n.getTokenAt(c.row,c.column),p=n.getTokenAt(c.row,c.column+1);if("\\"==d&&f&&/escape/.test(f.type))return null;var m,g=f&&/string|escape/.test(f.type),v=!p||/string|escape/.test(p.type);if(u==s)(m=g!==v)&&/string\.end/.test(p.type)&&(m=!1);else{if(g&&!v)return null;if(g&&v)return null;var y=n.$mode.tokenRe;y.lastIndex=0;var w=y.test(d);y.lastIndex=0;var b=y.test(d);if(w||b)return null;if(u&&!/[\s;,.})\]\\]/.test(u))return null;m=!0}return{text:m?s+s:"",selection:[1,1]}}}}),this.add("string_dquotes","deletion",function(e,t,i,n,r){var o=n.doc.getTextRange(r);if(!r.isMultiLine()&&('"'==o||"'"==o)&&(C(i),n.doc.getLine(r.start.row).substring(r.start.column+1,r.start.column+2)==o))return r.end.column++,r})};g.isSaneInsertion=function(e,t){var i=e.getCursorPosition(),n=new o(t,i.row,i.column);if(!this.$matchTokenType(n.getCurrentToken()||"text",s)){var r=new o(t,i.row,i.column+1);if(!this.$matchTokenType(r.getCurrentToken()||"text",s))return!1}return n.stepForward(),n.getCurrentTokenRow()!==i.row||this.$matchTokenType(n.getCurrentToken()||"text",a)},g.$matchTokenType=function(e,t){return-1<t.indexOf(e.type||e)},g.recordAutoInsert=function(e,t,i){var n=e.getCursorPosition(),r=t.doc.getLine(n.row);this.isAutoInsertedClosing(n,r,p.autoInsertedLineEnd[0])||(p.autoInsertedBrackets=0),p.autoInsertedRow=n.row,p.autoInsertedLineEnd=i+r.substr(n.column),p.autoInsertedBrackets++},g.recordMaybeInsert=function(e,t,i){var n=e.getCursorPosition(),r=t.doc.getLine(n.row);this.isMaybeInsertedClosing(n,r)||(p.maybeInsertedBrackets=0),p.maybeInsertedRow=n.row,p.maybeInsertedLineStart=r.substr(0,n.column)+i,p.maybeInsertedLineEnd=r.substr(n.column),p.maybeInsertedBrackets++},g.isAutoInsertedClosing=function(e,t,i){return 0<p.autoInsertedBrackets&&e.row===p.autoInsertedRow&&i===p.autoInsertedLineEnd[0]&&t.substr(e.column)===p.autoInsertedLineEnd},g.isMaybeInsertedClosing=function(e,t){return 0<p.maybeInsertedBrackets&&e.row===p.maybeInsertedRow&&t.substr(e.column)===p.maybeInsertedLineEnd&&t.substr(0,e.column)==p.maybeInsertedLineStart},g.popAutoInsertedClosing=function(){p.autoInsertedLineEnd=p.autoInsertedLineEnd.substr(1),p.autoInsertedBrackets--},g.clearMaybeInsertedClosing=function(){p&&(p.maybeInsertedBrackets=0,p.maybeInsertedRow=-1)},n.inherits(g,r),t.CstyleBehaviour=g}),ace.define("ace/unicode",["require","exports","module"],function(e,n,t){"use strict";n.packages={},function(e){var t=/\w{4}/g;for(var i in e)n.packages[i]=e[i].replace(t,"\\u$&")}({L:"0041-005A0061-007A00AA00B500BA00C0-00D600D8-00F600F8-02C102C6-02D102E0-02E402EC02EE0370-037403760377037A-037D03860388-038A038C038E-03A103A3-03F503F7-0481048A-05250531-055605590561-058705D0-05EA05F0-05F20621-064A066E066F0671-06D306D506E506E606EE06EF06FA-06FC06FF07100712-072F074D-07A507B107CA-07EA07F407F507FA0800-0815081A082408280904-0939093D09500958-0961097109720979-097F0985-098C098F09900993-09A809AA-09B009B209B6-09B909BD09CE09DC09DD09DF-09E109F009F10A05-0A0A0A0F0A100A13-0A280A2A-0A300A320A330A350A360A380A390A59-0A5C0A5E0A72-0A740A85-0A8D0A8F-0A910A93-0AA80AAA-0AB00AB20AB30AB5-0AB90ABD0AD00AE00AE10B05-0B0C0B0F0B100B13-0B280B2A-0B300B320B330B35-0B390B3D0B5C0B5D0B5F-0B610B710B830B85-0B8A0B8E-0B900B92-0B950B990B9A0B9C0B9E0B9F0BA30BA40BA8-0BAA0BAE-0BB90BD00C05-0C0C0C0E-0C100C12-0C280C2A-0C330C35-0C390C3D0C580C590C600C610C85-0C8C0C8E-0C900C92-0CA80CAA-0CB30CB5-0CB90CBD0CDE0CE00CE10D05-0D0C0D0E-0D100D12-0D280D2A-0D390D3D0D600D610D7A-0D7F0D85-0D960D9A-0DB10DB3-0DBB0DBD0DC0-0DC60E01-0E300E320E330E40-0E460E810E820E840E870E880E8A0E8D0E94-0E970E99-0E9F0EA1-0EA30EA50EA70EAA0EAB0EAD-0EB00EB20EB30EBD0EC0-0EC40EC60EDC0EDD0F000F40-0F470F49-0F6C0F88-0F8B1000-102A103F1050-1055105A-105D106110651066106E-10701075-1081108E10A0-10C510D0-10FA10FC1100-1248124A-124D1250-12561258125A-125D1260-1288128A-128D1290-12B012B2-12B512B8-12BE12C012C2-12C512C8-12D612D8-13101312-13151318-135A1380-138F13A0-13F41401-166C166F-167F1681-169A16A0-16EA1700-170C170E-17111720-17311740-17511760-176C176E-17701780-17B317D717DC1820-18771880-18A818AA18B0-18F51900-191C1950-196D1970-19741980-19AB19C1-19C71A00-1A161A20-1A541AA71B05-1B331B45-1B4B1B83-1BA01BAE1BAF1C00-1C231C4D-1C4F1C5A-1C7D1CE9-1CEC1CEE-1CF11D00-1DBF1E00-1F151F18-1F1D1F20-1F451F48-1F4D1F50-1F571F591F5B1F5D1F5F-1F7D1F80-1FB41FB6-1FBC1FBE1FC2-1FC41FC6-1FCC1FD0-1FD31FD6-1FDB1FE0-1FEC1FF2-1FF41FF6-1FFC2071207F2090-209421022107210A-211321152119-211D212421262128212A-212D212F-2139213C-213F2145-2149214E218321842C00-2C2E2C30-2C5E2C60-2CE42CEB-2CEE2D00-2D252D30-2D652D6F2D80-2D962DA0-2DA62DA8-2DAE2DB0-2DB62DB8-2DBE2DC0-2DC62DC8-2DCE2DD0-2DD62DD8-2DDE2E2F300530063031-3035303B303C3041-3096309D-309F30A1-30FA30FC-30FF3105-312D3131-318E31A0-31B731F0-31FF3400-4DB54E00-9FCBA000-A48CA4D0-A4FDA500-A60CA610-A61FA62AA62BA640-A65FA662-A66EA67F-A697A6A0-A6E5A717-A71FA722-A788A78BA78CA7FB-A801A803-A805A807-A80AA80C-A822A840-A873A882-A8B3A8F2-A8F7A8FBA90A-A925A930-A946A960-A97CA984-A9B2A9CFAA00-AA28AA40-AA42AA44-AA4BAA60-AA76AA7AAA80-AAAFAAB1AAB5AAB6AAB9-AABDAAC0AAC2AADB-AADDABC0-ABE2AC00-D7A3D7B0-D7C6D7CB-D7FBF900-FA2DFA30-FA6DFA70-FAD9FB00-FB06FB13-FB17FB1DFB1F-FB28FB2A-FB36FB38-FB3CFB3EFB40FB41FB43FB44FB46-FBB1FBD3-FD3DFD50-FD8FFD92-FDC7FDF0-FDFBFE70-FE74FE76-FEFCFF21-FF3AFF41-FF5AFF66-FFBEFFC2-FFC7FFCA-FFCFFFD2-FFD7FFDA-FFDC",
Ll:"0061-007A00AA00B500BA00DF-00F600F8-00FF01010103010501070109010B010D010F01110113011501170119011B011D011F01210123012501270129012B012D012F01310133013501370138013A013C013E014001420144014601480149014B014D014F01510153015501570159015B015D015F01610163016501670169016B016D016F0171017301750177017A017C017E-0180018301850188018C018D019201950199-019B019E01A101A301A501A801AA01AB01AD01B001B401B601B901BA01BD-01BF01C601C901CC01CE01D001D201D401D601D801DA01DC01DD01DF01E101E301E501E701E901EB01ED01EF01F001F301F501F901FB01FD01FF02010203020502070209020B020D020F02110213021502170219021B021D021F02210223022502270229022B022D022F02310233-0239023C023F0240024202470249024B024D024F-02930295-02AF037103730377037B-037D039003AC-03CE03D003D103D5-03D703D903DB03DD03DF03E103E303E503E703E903EB03ED03EF-03F303F503F803FB03FC0430-045F04610463046504670469046B046D046F04710473047504770479047B047D047F0481048B048D048F04910493049504970499049B049D049F04A104A304A504A704A904AB04AD04AF04B104B304B504B704B904BB04BD04BF04C204C404C604C804CA04CC04CE04CF04D104D304D504D704D904DB04DD04DF04E104E304E504E704E904EB04ED04EF04F104F304F504F704F904FB04FD04FF05010503050505070509050B050D050F05110513051505170519051B051D051F0521052305250561-05871D00-1D2B1D62-1D771D79-1D9A1E011E031E051E071E091E0B1E0D1E0F1E111E131E151E171E191E1B1E1D1E1F1E211E231E251E271E291E2B1E2D1E2F1E311E331E351E371E391E3B1E3D1E3F1E411E431E451E471E491E4B1E4D1E4F1E511E531E551E571E591E5B1E5D1E5F1E611E631E651E671E691E6B1E6D1E6F1E711E731E751E771E791E7B1E7D1E7F1E811E831E851E871E891E8B1E8D1E8F1E911E931E95-1E9D1E9F1EA11EA31EA51EA71EA91EAB1EAD1EAF1EB11EB31EB51EB71EB91EBB1EBD1EBF1EC11EC31EC51EC71EC91ECB1ECD1ECF1ED11ED31ED51ED71ED91EDB1EDD1EDF1EE11EE31EE51EE71EE91EEB1EED1EEF1EF11EF31EF51EF71EF91EFB1EFD1EFF-1F071F10-1F151F20-1F271F30-1F371F40-1F451F50-1F571F60-1F671F70-1F7D1F80-1F871F90-1F971FA0-1FA71FB0-1FB41FB61FB71FBE1FC2-1FC41FC61FC71FD0-1FD31FD61FD71FE0-1FE71FF2-1FF41FF61FF7210A210E210F2113212F21342139213C213D2146-2149214E21842C30-2C5E2C612C652C662C682C6A2C6C2C712C732C742C76-2C7C2C812C832C852C872C892C8B2C8D2C8F2C912C932C952C972C992C9B2C9D2C9F2CA12CA32CA52CA72CA92CAB2CAD2CAF2CB12CB32CB52CB72CB92CBB2CBD2CBF2CC12CC32CC52CC72CC92CCB2CCD2CCF2CD12CD32CD52CD72CD92CDB2CDD2CDF2CE12CE32CE42CEC2CEE2D00-2D25A641A643A645A647A649A64BA64DA64FA651A653A655A657A659A65BA65DA65FA663A665A667A669A66BA66DA681A683A685A687A689A68BA68DA68FA691A693A695A697A723A725A727A729A72BA72DA72F-A731A733A735A737A739A73BA73DA73FA741A743A745A747A749A74BA74DA74FA751A753A755A757A759A75BA75DA75FA761A763A765A767A769A76BA76DA76FA771-A778A77AA77CA77FA781A783A785A787A78CFB00-FB06FB13-FB17FF41-FF5A",Lu:"0041-005A00C0-00D600D8-00DE01000102010401060108010A010C010E01100112011401160118011A011C011E01200122012401260128012A012C012E01300132013401360139013B013D013F0141014301450147014A014C014E01500152015401560158015A015C015E01600162016401660168016A016C016E017001720174017601780179017B017D018101820184018601870189-018B018E-0191019301940196-0198019C019D019F01A001A201A401A601A701A901AC01AE01AF01B1-01B301B501B701B801BC01C401C701CA01CD01CF01D101D301D501D701D901DB01DE01E001E201E401E601E801EA01EC01EE01F101F401F6-01F801FA01FC01FE02000202020402060208020A020C020E02100212021402160218021A021C021E02200222022402260228022A022C022E02300232023A023B023D023E02410243-02460248024A024C024E03700372037603860388-038A038C038E038F0391-03A103A3-03AB03CF03D2-03D403D803DA03DC03DE03E003E203E403E603E803EA03EC03EE03F403F703F903FA03FD-042F04600462046404660468046A046C046E04700472047404760478047A047C047E0480048A048C048E04900492049404960498049A049C049E04A004A204A404A604A804AA04AC04AE04B004B204B404B604B804BA04BC04BE04C004C104C304C504C704C904CB04CD04D004D204D404D604D804DA04DC04DE04E004E204E404E604E804EA04EC04EE04F004F204F404F604F804FA04FC04FE05000502050405060508050A050C050E05100512051405160518051A051C051E0520052205240531-055610A0-10C51E001E021E041E061E081E0A1E0C1E0E1E101E121E141E161E181E1A1E1C1E1E1E201E221E241E261E281E2A1E2C1E2E1E301E321E341E361E381E3A1E3C1E3E1E401E421E441E461E481E4A1E4C1E4E1E501E521E541E561E581E5A1E5C1E5E1E601E621E641E661E681E6A1E6C1E6E1E701E721E741E761E781E7A1E7C1E7E1E801E821E841E861E881E8A1E8C1E8E1E901E921E941E9E1EA01EA21EA41EA61EA81EAA1EAC1EAE1EB01EB21EB41EB61EB81EBA1EBC1EBE1EC01EC21EC41EC61EC81ECA1ECC1ECE1ED01ED21ED41ED61ED81EDA1EDC1EDE1EE01EE21EE41EE61EE81EEA1EEC1EEE1EF01EF21EF41EF61EF81EFA1EFC1EFE1F08-1F0F1F18-1F1D1F28-1F2F1F38-1F3F1F48-1F4D1F591F5B1F5D1F5F1F68-1F6F1FB8-1FBB1FC8-1FCB1FD8-1FDB1FE8-1FEC1FF8-1FFB21022107210B-210D2110-211221152119-211D212421262128212A-212D2130-2133213E213F214521832C00-2C2E2C602C62-2C642C672C692C6B2C6D-2C702C722C752C7E-2C802C822C842C862C882C8A2C8C2C8E2C902C922C942C962C982C9A2C9C2C9E2CA02CA22CA42CA62CA82CAA2CAC2CAE2CB02CB22CB42CB62CB82CBA2CBC2CBE2CC02CC22CC42CC62CC82CCA2CCC2CCE2CD02CD22CD42CD62CD82CDA2CDC2CDE2CE02CE22CEB2CEDA640A642A644A646A648A64AA64CA64EA650A652A654A656A658A65AA65CA65EA662A664A666A668A66AA66CA680A682A684A686A688A68AA68CA68EA690A692A694A696A722A724A726A728A72AA72CA72EA732A734A736A738A73AA73CA73EA740A742A744A746A748A74AA74CA74EA750A752A754A756A758A75AA75CA75EA760A762A764A766A768A76AA76CA76EA779A77BA77DA77EA780A782A784A786A78BFF21-FF3A",Lt:"01C501C801CB01F21F88-1F8F1F98-1F9F1FA8-1FAF1FBC1FCC1FFC",Lm:"02B0-02C102C6-02D102E0-02E402EC02EE0374037A0559064006E506E607F407F507FA081A0824082809710E460EC610FC17D718431AA71C78-1C7D1D2C-1D611D781D9B-1DBF2071207F2090-20942C7D2D6F2E2F30053031-3035303B309D309E30FC-30FEA015A4F8-A4FDA60CA67FA717-A71FA770A788A9CFAA70AADDFF70FF9EFF9F",Lo:"01BB01C0-01C3029405D0-05EA05F0-05F20621-063F0641-064A066E066F0671-06D306D506EE06EF06FA-06FC06FF07100712-072F074D-07A507B107CA-07EA0800-08150904-0939093D09500958-096109720979-097F0985-098C098F09900993-09A809AA-09B009B209B6-09B909BD09CE09DC09DD09DF-09E109F009F10A05-0A0A0A0F0A100A13-0A280A2A-0A300A320A330A350A360A380A390A59-0A5C0A5E0A72-0A740A85-0A8D0A8F-0A910A93-0AA80AAA-0AB00AB20AB30AB5-0AB90ABD0AD00AE00AE10B05-0B0C0B0F0B100B13-0B280B2A-0B300B320B330B35-0B390B3D0B5C0B5D0B5F-0B610B710B830B85-0B8A0B8E-0B900B92-0B950B990B9A0B9C0B9E0B9F0BA30BA40BA8-0BAA0BAE-0BB90BD00C05-0C0C0C0E-0C100C12-0C280C2A-0C330C35-0C390C3D0C580C590C600C610C85-0C8C0C8E-0C900C92-0CA80CAA-0CB30CB5-0CB90CBD0CDE0CE00CE10D05-0D0C0D0E-0D100D12-0D280D2A-0D390D3D0D600D610D7A-0D7F0D85-0D960D9A-0DB10DB3-0DBB0DBD0DC0-0DC60E01-0E300E320E330E40-0E450E810E820E840E870E880E8A0E8D0E94-0E970E99-0E9F0EA1-0EA30EA50EA70EAA0EAB0EAD-0EB00EB20EB30EBD0EC0-0EC40EDC0EDD0F000F40-0F470F49-0F6C0F88-0F8B1000-102A103F1050-1055105A-105D106110651066106E-10701075-1081108E10D0-10FA1100-1248124A-124D1250-12561258125A-125D1260-1288128A-128D1290-12B012B2-12B512B8-12BE12C012C2-12C512C8-12D612D8-13101312-13151318-135A1380-138F13A0-13F41401-166C166F-167F1681-169A16A0-16EA1700-170C170E-17111720-17311740-17511760-176C176E-17701780-17B317DC1820-18421844-18771880-18A818AA18B0-18F51900-191C1950-196D1970-19741980-19AB19C1-19C71A00-1A161A20-1A541B05-1B331B45-1B4B1B83-1BA01BAE1BAF1C00-1C231C4D-1C4F1C5A-1C771CE9-1CEC1CEE-1CF12135-21382D30-2D652D80-2D962DA0-2DA62DA8-2DAE2DB0-2DB62DB8-2DBE2DC0-2DC62DC8-2DCE2DD0-2DD62DD8-2DDE3006303C3041-3096309F30A1-30FA30FF3105-312D3131-318E31A0-31B731F0-31FF3400-4DB54E00-9FCBA000-A014A016-A48CA4D0-A4F7A500-A60BA610-A61FA62AA62BA66EA6A0-A6E5A7FB-A801A803-A805A807-A80AA80C-A822A840-A873A882-A8B3A8F2-A8F7A8FBA90A-A925A930-A946A960-A97CA984-A9B2AA00-AA28AA40-AA42AA44-AA4BAA60-AA6FAA71-AA76AA7AAA80-AAAFAAB1AAB5AAB6AAB9-AABDAAC0AAC2AADBAADCABC0-ABE2AC00-D7A3D7B0-D7C6D7CB-D7FBF900-FA2DFA30-FA6DFA70-FAD9FB1DFB1F-FB28FB2A-FB36FB38-FB3CFB3EFB40FB41FB43FB44FB46-FBB1FBD3-FD3DFD50-FD8FFD92-FDC7FDF0-FDFBFE70-FE74FE76-FEFCFF66-FF6FFF71-FF9DFFA0-FFBEFFC2-FFC7FFCA-FFCFFFD2-FFD7FFDA-FFDC",M:"0300-036F0483-04890591-05BD05BF05C105C205C405C505C70610-061A064B-065E067006D6-06DC06DE-06E406E706E806EA-06ED07110730-074A07A6-07B007EB-07F30816-0819081B-08230825-08270829-082D0900-0903093C093E-094E0951-0955096209630981-098309BC09BE-09C409C709C809CB-09CD09D709E209E30A01-0A030A3C0A3E-0A420A470A480A4B-0A4D0A510A700A710A750A81-0A830ABC0ABE-0AC50AC7-0AC90ACB-0ACD0AE20AE30B01-0B030B3C0B3E-0B440B470B480B4B-0B4D0B560B570B620B630B820BBE-0BC20BC6-0BC80BCA-0BCD0BD70C01-0C030C3E-0C440C46-0C480C4A-0C4D0C550C560C620C630C820C830CBC0CBE-0CC40CC6-0CC80CCA-0CCD0CD50CD60CE20CE30D020D030D3E-0D440D46-0D480D4A-0D4D0D570D620D630D820D830DCA0DCF-0DD40DD60DD8-0DDF0DF20DF30E310E34-0E3A0E47-0E4E0EB10EB4-0EB90EBB0EBC0EC8-0ECD0F180F190F350F370F390F3E0F3F0F71-0F840F860F870F90-0F970F99-0FBC0FC6102B-103E1056-1059105E-10601062-10641067-106D1071-10741082-108D108F109A-109D135F1712-17141732-1734175217531772177317B6-17D317DD180B-180D18A91920-192B1930-193B19B0-19C019C819C91A17-1A1B1A55-1A5E1A60-1A7C1A7F1B00-1B041B34-1B441B6B-1B731B80-1B821BA1-1BAA1C24-1C371CD0-1CD21CD4-1CE81CED1CF21DC0-1DE61DFD-1DFF20D0-20F02CEF-2CF12DE0-2DFF302A-302F3099309AA66F-A672A67CA67DA6F0A6F1A802A806A80BA823-A827A880A881A8B4-A8C4A8E0-A8F1A926-A92DA947-A953A980-A983A9B3-A9C0AA29-AA36AA43AA4CAA4DAA7BAAB0AAB2-AAB4AAB7AAB8AABEAABFAAC1ABE3-ABEAABECABEDFB1EFE00-FE0FFE20-FE26",Mn:"0300-036F0483-04870591-05BD05BF05C105C205C405C505C70610-061A064B-065E067006D6-06DC06DF-06E406E706E806EA-06ED07110730-074A07A6-07B007EB-07F30816-0819081B-08230825-08270829-082D0900-0902093C0941-0948094D0951-095509620963098109BC09C1-09C409CD09E209E30A010A020A3C0A410A420A470A480A4B-0A4D0A510A700A710A750A810A820ABC0AC1-0AC50AC70AC80ACD0AE20AE30B010B3C0B3F0B41-0B440B4D0B560B620B630B820BC00BCD0C3E-0C400C46-0C480C4A-0C4D0C550C560C620C630CBC0CBF0CC60CCC0CCD0CE20CE30D41-0D440D4D0D620D630DCA0DD2-0DD40DD60E310E34-0E3A0E47-0E4E0EB10EB4-0EB90EBB0EBC0EC8-0ECD0F180F190F350F370F390F71-0F7E0F80-0F840F860F870F90-0F970F99-0FBC0FC6102D-10301032-10371039103A103D103E10581059105E-10601071-1074108210851086108D109D135F1712-17141732-1734175217531772177317B7-17BD17C617C9-17D317DD180B-180D18A91920-19221927192819321939-193B1A171A181A561A58-1A5E1A601A621A65-1A6C1A73-1A7C1A7F1B00-1B031B341B36-1B3A1B3C1B421B6B-1B731B801B811BA2-1BA51BA81BA91C2C-1C331C361C371CD0-1CD21CD4-1CE01CE2-1CE81CED1DC0-1DE61DFD-1DFF20D0-20DC20E120E5-20F02CEF-2CF12DE0-2DFF302A-302F3099309AA66FA67CA67DA6F0A6F1A802A806A80BA825A826A8C4A8E0-A8F1A926-A92DA947-A951A980-A982A9B3A9B6-A9B9A9BCAA29-AA2EAA31AA32AA35AA36AA43AA4CAAB0AAB2-AAB4AAB7AAB8AABEAABFAAC1ABE5ABE8ABEDFB1EFE00-FE0FFE20-FE26",Mc:"0903093E-09400949-094C094E0982098309BE-09C009C709C809CB09CC09D70A030A3E-0A400A830ABE-0AC00AC90ACB0ACC0B020B030B3E0B400B470B480B4B0B4C0B570BBE0BBF0BC10BC20BC6-0BC80BCA-0BCC0BD70C01-0C030C41-0C440C820C830CBE0CC0-0CC40CC70CC80CCA0CCB0CD50CD60D020D030D3E-0D400D46-0D480D4A-0D4C0D570D820D830DCF-0DD10DD8-0DDF0DF20DF30F3E0F3F0F7F102B102C10311038103B103C105610571062-10641067-106D108310841087-108C108F109A-109C17B617BE-17C517C717C81923-19261929-192B193019311933-193819B0-19C019C819C91A19-1A1B1A551A571A611A631A641A6D-1A721B041B351B3B1B3D-1B411B431B441B821BA11BA61BA71BAA1C24-1C2B1C341C351CE11CF2A823A824A827A880A881A8B4-A8C3A952A953A983A9B4A9B5A9BAA9BBA9BD-A9C0AA2FAA30AA33AA34AA4DAA7BABE3ABE4ABE6ABE7ABE9ABEAABEC",Me:"0488048906DE20DD-20E020E2-20E4A670-A672",N:"0030-003900B200B300B900BC-00BE0660-066906F0-06F907C0-07C90966-096F09E6-09EF09F4-09F90A66-0A6F0AE6-0AEF0B66-0B6F0BE6-0BF20C66-0C6F0C78-0C7E0CE6-0CEF0D66-0D750E50-0E590ED0-0ED90F20-0F331040-10491090-10991369-137C16EE-16F017E0-17E917F0-17F91810-18191946-194F19D0-19DA1A80-1A891A90-1A991B50-1B591BB0-1BB91C40-1C491C50-1C5920702074-20792080-20892150-21822185-21892460-249B24EA-24FF2776-27932CFD30073021-30293038-303A3192-31953220-32293251-325F3280-328932B1-32BFA620-A629A6E6-A6EFA830-A835A8D0-A8D9A900-A909A9D0-A9D9AA50-AA59ABF0-ABF9FF10-FF19",Nd:"0030-00390660-066906F0-06F907C0-07C90966-096F09E6-09EF0A66-0A6F0AE6-0AEF0B66-0B6F0BE6-0BEF0C66-0C6F0CE6-0CEF0D66-0D6F0E50-0E590ED0-0ED90F20-0F291040-10491090-109917E0-17E91810-18191946-194F19D0-19DA1A80-1A891A90-1A991B50-1B591BB0-1BB91C40-1C491C50-1C59A620-A629A8D0-A8D9A900-A909A9D0-A9D9AA50-AA59ABF0-ABF9FF10-FF19",Nl:"16EE-16F02160-21822185-218830073021-30293038-303AA6E6-A6EF",No:"00B200B300B900BC-00BE09F4-09F90BF0-0BF20C78-0C7E0D70-0D750F2A-0F331369-137C17F0-17F920702074-20792080-20892150-215F21892460-249B24EA-24FF2776-27932CFD3192-31953220-32293251-325F3280-328932B1-32BFA830-A835",P:"0021-00230025-002A002C-002F003A003B003F0040005B-005D005F007B007D00A100AB00B700BB00BF037E0387055A-055F0589058A05BE05C005C305C605F305F40609060A060C060D061B061E061F066A-066D06D40700-070D07F7-07F90830-083E0964096509700DF40E4F0E5A0E5B0F04-0F120F3A-0F3D0F850FD0-0FD4104A-104F10FB1361-13681400166D166E169B169C16EB-16ED1735173617D4-17D617D8-17DA1800-180A1944194519DE19DF1A1E1A1F1AA0-1AA61AA8-1AAD1B5A-1B601C3B-1C3F1C7E1C7F1CD32010-20272030-20432045-20512053-205E207D207E208D208E2329232A2768-277527C527C627E6-27EF2983-299829D8-29DB29FC29FD2CF9-2CFC2CFE2CFF2E00-2E2E2E302E313001-30033008-30113014-301F3030303D30A030FBA4FEA4FFA60D-A60FA673A67EA6F2-A6F7A874-A877A8CEA8CFA8F8-A8FAA92EA92FA95FA9C1-A9CDA9DEA9DFAA5C-AA5FAADEAADFABEBFD3EFD3FFE10-FE19FE30-FE52FE54-FE61FE63FE68FE6AFE6BFF01-FF03FF05-FF0AFF0C-FF0FFF1AFF1BFF1FFF20FF3B-FF3DFF3FFF5BFF5DFF5F-FF65",Pd:"002D058A05BE140018062010-20152E172E1A301C303030A0FE31FE32FE58FE63FF0D",Ps:"0028005B007B0F3A0F3C169B201A201E2045207D208D23292768276A276C276E27702772277427C527E627E827EA27EC27EE2983298529872989298B298D298F299129932995299729D829DA29FC2E222E242E262E283008300A300C300E3010301430163018301A301DFD3EFE17FE35FE37FE39FE3BFE3DFE3FFE41FE43FE47FE59FE5BFE5DFF08FF3BFF5BFF5FFF62",Pe:"0029005D007D0F3B0F3D169C2046207E208E232A2769276B276D276F27712773277527C627E727E927EB27ED27EF298429862988298A298C298E2990299229942996299829D929DB29FD2E232E252E272E293009300B300D300F3011301530173019301B301E301FFD3FFE18FE36FE38FE3AFE3CFE3EFE40FE42FE44FE48FE5AFE5CFE5EFF09FF3DFF5DFF60FF63",Pi:"00AB2018201B201C201F20392E022E042E092E0C2E1C2E20",Pf:"00BB2019201D203A2E032E052E0A2E0D2E1D2E21",Pc:"005F203F20402054FE33FE34FE4D-FE4FFF3F",Po:"0021-00230025-0027002A002C002E002F003A003B003F0040005C00A100B700BF037E0387055A-055F058905C005C305C605F305F40609060A060C060D061B061E061F066A-066D06D40700-070D07F7-07F90830-083E0964096509700DF40E4F0E5A0E5B0F04-0F120F850FD0-0FD4104A-104F10FB1361-1368166D166E16EB-16ED1735173617D4-17D617D8-17DA1800-18051807-180A1944194519DE19DF1A1E1A1F1AA0-1AA61AA8-1AAD1B5A-1B601C3B-1C3F1C7E1C7F1CD3201620172020-20272030-2038203B-203E2041-20432047-205120532055-205E2CF9-2CFC2CFE2CFF2E002E012E06-2E082E0B2E0E-2E162E182E192E1B2E1E2E1F2E2A-2E2E2E302E313001-3003303D30FBA4FEA4FFA60D-A60FA673A67EA6F2-A6F7A874-A877A8CEA8CFA8F8-A8FAA92EA92FA95FA9C1-A9CDA9DEA9DFAA5C-AA5FAADEAADFABEBFE10-FE16FE19FE30FE45FE46FE49-FE4CFE50-FE52FE54-FE57FE5F-FE61FE68FE6AFE6BFF01-FF03FF05-FF07FF0AFF0CFF0EFF0FFF1AFF1BFF1FFF20FF3CFF61FF64FF65",S:"0024002B003C-003E005E0060007C007E00A2-00A900AC00AE-00B100B400B600B800D700F702C2-02C502D2-02DF02E5-02EB02ED02EF-02FF03750384038503F604820606-0608060B060E060F06E906FD06FE07F609F209F309FA09FB0AF10B700BF3-0BFA0C7F0CF10CF20D790E3F0F01-0F030F13-0F170F1A-0F1F0F340F360F380FBE-0FC50FC7-0FCC0FCE0FCF0FD5-0FD8109E109F13601390-139917DB194019E0-19FF1B61-1B6A1B74-1B7C1FBD1FBF-1FC11FCD-1FCF1FDD-1FDF1FED-1FEF1FFD1FFE20442052207A-207C208A-208C20A0-20B8210021012103-21062108210921142116-2118211E-2123212521272129212E213A213B2140-2144214A-214D214F2190-2328232B-23E82400-24262440-244A249C-24E92500-26CD26CF-26E126E326E8-26FF2701-27042706-2709270C-27272729-274B274D274F-27522756-275E2761-276727942798-27AF27B1-27BE27C0-27C427C7-27CA27CC27D0-27E527F0-29822999-29D729DC-29FB29FE-2B4C2B50-2B592CE5-2CEA2E80-2E992E9B-2EF32F00-2FD52FF0-2FFB300430123013302030363037303E303F309B309C319031913196-319F31C0-31E33200-321E322A-32503260-327F328A-32B032C0-32FE3300-33FF4DC0-4DFFA490-A4C6A700-A716A720A721A789A78AA828-A82BA836-A839AA77-AA79FB29FDFCFDFDFE62FE64-FE66FE69FF04FF0BFF1C-FF1EFF3EFF40FF5CFF5EFFE0-FFE6FFE8-FFEEFFFCFFFD",Sm:"002B003C-003E007C007E00AC00B100D700F703F60606-060820442052207A-207C208A-208C2140-2144214B2190-2194219A219B21A021A321A621AE21CE21CF21D221D421F4-22FF2308-230B23202321237C239B-23B323DC-23E125B725C125F8-25FF266F27C0-27C427C7-27CA27CC27D0-27E527F0-27FF2900-29822999-29D729DC-29FB29FE-2AFF2B30-2B442B47-2B4CFB29FE62FE64-FE66FF0BFF1C-FF1EFF5CFF5EFFE2FFE9-FFEC",Sc:"002400A2-00A5060B09F209F309FB0AF10BF90E3F17DB20A0-20B8A838FDFCFE69FF04FFE0FFE1FFE5FFE6",Sk:"005E006000A800AF00B400B802C2-02C502D2-02DF02E5-02EB02ED02EF-02FF0375038403851FBD1FBF-1FC11FCD-1FCF1FDD-1FDF1FED-1FEF1FFD1FFE309B309CA700-A716A720A721A789A78AFF3EFF40FFE3",So:"00A600A700A900AE00B000B60482060E060F06E906FD06FE07F609FA0B700BF3-0BF80BFA0C7F0CF10CF20D790F01-0F030F13-0F170F1A-0F1F0F340F360F380FBE-0FC50FC7-0FCC0FCE0FCF0FD5-0FD8109E109F13601390-1399194019E0-19FF1B61-1B6A1B74-1B7C210021012103-21062108210921142116-2118211E-2123212521272129212E213A213B214A214C214D214F2195-2199219C-219F21A121A221A421A521A7-21AD21AF-21CD21D021D121D321D5-21F32300-2307230C-231F2322-2328232B-237B237D-239A23B4-23DB23E2-23E82400-24262440-244A249C-24E92500-25B625B8-25C025C2-25F72600-266E2670-26CD26CF-26E126E326E8-26FF2701-27042706-2709270C-27272729-274B274D274F-27522756-275E2761-276727942798-27AF27B1-27BE2800-28FF2B00-2B2F2B452B462B50-2B592CE5-2CEA2E80-2E992E9B-2EF32F00-2FD52FF0-2FFB300430123013302030363037303E303F319031913196-319F31C0-31E33200-321E322A-32503260-327F328A-32B032C0-32FE3300-33FF4DC0-4DFFA490-A4C6A828-A82BA836A837A839AA77-AA79FDFDFFE4FFE8FFEDFFEEFFFCFFFD",Z:"002000A01680180E2000-200A20282029202F205F3000",Zs:"002000A01680180E2000-200A202F205F3000",Zl:"2028",Zp:"2029",C:"0000-001F007F-009F00AD03780379037F-0383038B038D03A20526-05300557055805600588058B-059005C8-05CF05EB-05EF05F5-0605061C061D0620065F06DD070E070F074B074C07B2-07BF07FB-07FF082E082F083F-08FF093A093B094F095609570973-097809800984098D098E0991099209A909B109B3-09B509BA09BB09C509C609C909CA09CF-09D609D8-09DB09DE09E409E509FC-0A000A040A0B-0A0E0A110A120A290A310A340A370A3A0A3B0A3D0A43-0A460A490A4A0A4E-0A500A52-0A580A5D0A5F-0A650A76-0A800A840A8E0A920AA90AB10AB40ABA0ABB0AC60ACA0ACE0ACF0AD1-0ADF0AE40AE50AF00AF2-0B000B040B0D0B0E0B110B120B290B310B340B3A0B3B0B450B460B490B4A0B4E-0B550B58-0B5B0B5E0B640B650B72-0B810B840B8B-0B8D0B910B96-0B980B9B0B9D0BA0-0BA20BA5-0BA70BAB-0BAD0BBA-0BBD0BC3-0BC50BC90BCE0BCF0BD1-0BD60BD8-0BE50BFB-0C000C040C0D0C110C290C340C3A-0C3C0C450C490C4E-0C540C570C5A-0C5F0C640C650C70-0C770C800C810C840C8D0C910CA90CB40CBA0CBB0CC50CC90CCE-0CD40CD7-0CDD0CDF0CE40CE50CF00CF3-0D010D040D0D0D110D290D3A-0D3C0D450D490D4E-0D560D58-0D5F0D640D650D76-0D780D800D810D840D97-0D990DB20DBC0DBE0DBF0DC7-0DC90DCB-0DCE0DD50DD70DE0-0DF10DF5-0E000E3B-0E3E0E5C-0E800E830E850E860E890E8B0E8C0E8E-0E930E980EA00EA40EA60EA80EA90EAC0EBA0EBE0EBF0EC50EC70ECE0ECF0EDA0EDB0EDE-0EFF0F480F6D-0F700F8C-0F8F0F980FBD0FCD0FD9-0FFF10C6-10CF10FD-10FF1249124E124F12571259125E125F1289128E128F12B112B612B712BF12C112C612C712D7131113161317135B-135E137D-137F139A-139F13F5-13FF169D-169F16F1-16FF170D1715-171F1737-173F1754-175F176D17711774-177F17B417B517DE17DF17EA-17EF17FA-17FF180F181A-181F1878-187F18AB-18AF18F6-18FF191D-191F192C-192F193C-193F1941-1943196E196F1975-197F19AC-19AF19CA-19CF19DB-19DD1A1C1A1D1A5F1A7D1A7E1A8A-1A8F1A9A-1A9F1AAE-1AFF1B4C-1B4F1B7D-1B7F1BAB-1BAD1BBA-1BFF1C38-1C3A1C4A-1C4C1C80-1CCF1CF3-1CFF1DE7-1DFC1F161F171F1E1F1F1F461F471F4E1F4F1F581F5A1F5C1F5E1F7E1F7F1FB51FC51FD41FD51FDC1FF01FF11FF51FFF200B-200F202A-202E2060-206F20722073208F2095-209F20B9-20CF20F1-20FF218A-218F23E9-23FF2427-243F244B-245F26CE26E226E4-26E727002705270A270B2728274C274E2753-2755275F27602795-279727B027BF27CB27CD-27CF2B4D-2B4F2B5A-2BFF2C2F2C5F2CF2-2CF82D26-2D2F2D66-2D6E2D70-2D7F2D97-2D9F2DA72DAF2DB72DBF2DC72DCF2DD72DDF2E32-2E7F2E9A2EF4-2EFF2FD6-2FEF2FFC-2FFF3040309730983100-3104312E-3130318F31B8-31BF31E4-31EF321F32FF4DB6-4DBF9FCC-9FFFA48D-A48FA4C7-A4CFA62C-A63FA660A661A674-A67BA698-A69FA6F8-A6FFA78D-A7FAA82C-A82FA83A-A83FA878-A87FA8C5-A8CDA8DA-A8DFA8FC-A8FFA954-A95EA97D-A97FA9CEA9DA-A9DDA9E0-A9FFAA37-AA3FAA4EAA4FAA5AAA5BAA7C-AA7FAAC3-AADAAAE0-ABBFABEEABEFABFA-ABFFD7A4-D7AFD7C7-D7CAD7FC-F8FFFA2EFA2FFA6EFA6FFADA-FAFFFB07-FB12FB18-FB1CFB37FB3DFB3FFB42FB45FBB2-FBD2FD40-FD4FFD90FD91FDC8-FDEFFDFEFDFFFE1A-FE1FFE27-FE2FFE53FE67FE6C-FE6FFE75FEFD-FF00FFBF-FFC1FFC8FFC9FFD0FFD1FFD8FFD9FFDD-FFDFFFE7FFEF-FFFBFFFEFFFF",Cc:"0000-001F007F-009F",Cf:"00AD0600-060306DD070F17B417B5200B-200F202A-202E2060-2064206A-206FFEFFFFF9-FFFB",Co:"E000-F8FF",Cs:"D800-DFFF",Cn:"03780379037F-0383038B038D03A20526-05300557055805600588058B-059005C8-05CF05EB-05EF05F5-05FF06040605061C061D0620065F070E074B074C07B2-07BF07FB-07FF082E082F083F-08FF093A093B094F095609570973-097809800984098D098E0991099209A909B109B3-09B509BA09BB09C509C609C909CA09CF-09D609D8-09DB09DE09E409E509FC-0A000A040A0B-0A0E0A110A120A290A310A340A370A3A0A3B0A3D0A43-0A460A490A4A0A4E-0A500A52-0A580A5D0A5F-0A650A76-0A800A840A8E0A920AA90AB10AB40ABA0ABB0AC60ACA0ACE0ACF0AD1-0ADF0AE40AE50AF00AF2-0B000B040B0D0B0E0B110B120B290B310B340B3A0B3B0B450B460B490B4A0B4E-0B550B58-0B5B0B5E0B640B650B72-0B810B840B8B-0B8D0B910B96-0B980B9B0B9D0BA0-0BA20BA5-0BA70BAB-0BAD0BBA-0BBD0BC3-0BC50BC90BCE0BCF0BD1-0BD60BD8-0BE50BFB-0C000C040C0D0C110C290C340C3A-0C3C0C450C490C4E-0C540C570C5A-0C5F0C640C650C70-0C770C800C810C840C8D0C910CA90CB40CBA0CBB0CC50CC90CCE-0CD40CD7-0CDD0CDF0CE40CE50CF00CF3-0D010D040D0D0D110D290D3A-0D3C0D450D490D4E-0D560D58-0D5F0D640D650D76-0D780D800D810D840D97-0D990DB20DBC0DBE0DBF0DC7-0DC90DCB-0DCE0DD50DD70DE0-0DF10DF5-0E000E3B-0E3E0E5C-0E800E830E850E860E890E8B0E8C0E8E-0E930E980EA00EA40EA60EA80EA90EAC0EBA0EBE0EBF0EC50EC70ECE0ECF0EDA0EDB0EDE-0EFF0F480F6D-0F700F8C-0F8F0F980FBD0FCD0FD9-0FFF10C6-10CF10FD-10FF1249124E124F12571259125E125F1289128E128F12B112B612B712BF12C112C612C712D7131113161317135B-135E137D-137F139A-139F13F5-13FF169D-169F16F1-16FF170D1715-171F1737-173F1754-175F176D17711774-177F17DE17DF17EA-17EF17FA-17FF180F181A-181F1878-187F18AB-18AF18F6-18FF191D-191F192C-192F193C-193F1941-1943196E196F1975-197F19AC-19AF19CA-19CF19DB-19DD1A1C1A1D1A5F1A7D1A7E1A8A-1A8F1A9A-1A9F1AAE-1AFF1B4C-1B4F1B7D-1B7F1BAB-1BAD1BBA-1BFF1C38-1C3A1C4A-1C4C1C80-1CCF1CF3-1CFF1DE7-1DFC1F161F171F1E1F1F1F461F471F4E1F4F1F581F5A1F5C1F5E1F7E1F7F1FB51FC51FD41FD51FDC1FF01FF11FF51FFF2065-206920722073208F2095-209F20B9-20CF20F1-20FF218A-218F23E9-23FF2427-243F244B-245F26CE26E226E4-26E727002705270A270B2728274C274E2753-2755275F27602795-279727B027BF27CB27CD-27CF2B4D-2B4F2B5A-2BFF2C2F2C5F2CF2-2CF82D26-2D2F2D66-2D6E2D70-2D7F2D97-2D9F2DA72DAF2DB72DBF2DC72DCF2DD72DDF2E32-2E7F2E9A2EF4-2EFF2FD6-2FEF2FFC-2FFF3040309730983100-3104312E-3130318F31B8-31BF31E4-31EF321F32FF4DB6-4DBF9FCC-9FFFA48D-A48FA4C7-A4CFA62C-A63FA660A661A674-A67BA698-A69FA6F8-A6FFA78D-A7FAA82C-A82FA83A-A83FA878-A87FA8C5-A8CDA8DA-A8DFA8FC-A8FFA954-A95EA97D-A97FA9CEA9DA-A9DDA9E0-A9FFAA37-AA3FAA4EAA4FAA5AAA5BAA7C-AA7FAAC3-AADAAAE0-ABBFABEEABEFABFA-ABFFD7A4-D7AFD7C7-D7CAD7FC-D7FFFA2EFA2FFA6EFA6FFADA-FAFFFB07-FB12FB18-FB1CFB37FB3DFB3FFB42FB45FBB2-FBD2FD40-FD4FFD90FD91FDC8-FDEFFDFEFDFFFE1A-FE1FFE27-FE2FFE53FE67FE6C-FE6FFE75FEFDFEFEFF00FFBF-FFC1FFC8FFC9FFD0FFD1FFD8FFD9FFDD-FFDFFFE7FFEF-FFF8FFFEFFFF"})}),ace.define("ace/mode/text",["require","exports","module","ace/tokenizer","ace/mode/text_highlight_rules","ace/mode/behaviour/cstyle","ace/unicode","ace/lib/lang","ace/token_iterator","ace/range"],function(e,t,i){"use strict";function n(){this.HighlightRules=o}var r=e("../tokenizer").Tokenizer,o=e("./text_highlight_rules").TextHighlightRules,s=e("./behaviour/cstyle").CstyleBehaviour,a=e("../unicode"),C=e("../lib/lang"),m=e("../token_iterator").TokenIterator,g=e("../range").Range;(function(){this.$defaultBehaviour=new s,this.tokenRe=new RegExp("^["+a.packages.L+a.packages.Mn+a.packages.Mc+a.packages.Nd+a.packages.Pc+"\\$_]+","g"),this.nonTokenRe=new RegExp("^(?:[^"+a.packages.L+a.packages.Mn+a.packages.Mc+a.packages.Nd+a.packages.Pc+"\\$_]|\\s])+","g"),this.getTokenizer=function(){return this.$tokenizer||(this.$highlightRules=this.$highlightRules||new this.HighlightRules(this.$highlightRuleConfig),this.$tokenizer=new r(this.$highlightRules.getRules())),this.$tokenizer},this.lineCommentStart="",this.blockComment="",this.toggleCommentLines=function(e,r,i,n){var o=r.doc,s=!0,a=!0,l=1/0,c=r.getTabSize(),t=!1;if(this.lineCommentStart){if(Array.isArray(this.lineCommentStart))p=this.lineCommentStart.map(C.escapeRegExp).join("|"),u=this.lineCommentStart[0];else p=C.escapeRegExp(this.lineCommentStart),u=this.lineCommentStart;p=new RegExp("^(\\s*)(?:"+p+") ?"),t=r.getUseSoftTabs();v=function(e,t){var i=e.match(p);if(i){var n=i[1].length,r=i[0].length;d(e,n,r)||" "!=i[0][r-1]||r--,o.removeInLine(t,n,r)}};var h=u+" ",d=(g=function(e,t){s&&!/\S/.test(e)||(d(e,l,l)?o.insertInLine({row:t,column:l},h):o.insertInLine({row:t,column:l},u))},y=function(e,t){return p.test(e)},function(e,t,i){for(var n=0;t--&&" "==e.charAt(t);)n++;if(n%c!=0)return!1;for(n=0;" "==e.charAt(i++);)n++;return 2<c?n%c!=c-1:n%c==0})}else{if(!this.blockComment)return!1;var u=this.blockComment.start,f=this.blockComment.end,p=new RegExp("^(\\s*)(?:"+C.escapeRegExp(u)+")"),m=new RegExp("(?:"+C.escapeRegExp(f)+")\\s*$"),g=function(e,t){y(e,t)||s&&!/\S/.test(e)||(o.insertInLine({row:t,column:e.length},f),o.insertInLine({row:t,column:l},u))},v=function(e,t){var i;(i=e.match(m))&&o.removeInLine(t,e.length-i[0].length,e.length),(i=e.match(p))&&o.removeInLine(t,i[1].length,i[0].length)},y=function(e,t){if(p.test(e))return!0;for(var i=r.getTokens(t),n=0;n<i.length;n++)if("comment"===i[n].type)return!0}}function w(e){for(var t=i;t<=n;t++)e(o.getLine(t),t)}var b=1/0;w(function(e,t){var i=e.search(/\S/);-1!==i?(i<l&&(l=i),a&&!y(e,t)&&(a=!1)):b>e.length&&(b=e.length)}),l==1/0&&(l=b,a=s=!1),t&&l%c!=0&&(l=Math.floor(l/c)*c),w(a?v:g)},this.toggleBlockComment=function(e,t,i,n){var r=this.blockComment;if(r){!r.start&&r[0]&&(r=r[0]);var o,s,a=(f=new m(t,n.row,n.column)).getCurrentToken(),l=(t.selection,t.selection.toOrientedRange());if(a&&/comment/.test(a.type)){for(var c,h;a&&/comment/.test(a.type);){if(-1!=(p=a.value.indexOf(r.start))){var d=f.getCurrentTokenRow(),u=f.getCurrentTokenColumn()+p;c=new g(d,u,d,u+r.start.length);break}a=f.stepBackward()}var f;for(a=(f=new m(t,n.row,n.column)).getCurrentToken();a&&/comment/.test(a.type);){var p;if(-1!=(p=a.value.indexOf(r.end))){d=f.getCurrentTokenRow(),u=f.getCurrentTokenColumn()+p;h=new g(d,u,d,u+r.end.length);break}a=f.stepForward()}h&&t.remove(h),c&&(t.remove(c),o=c.start.row,s=-r.start.length)}else s=r.start.length,o=i.start.row,t.insert(i.end,r.end),t.insert(i.start,r.start);l.start.row==o&&(l.start.column+=s),l.end.row==o&&(l.end.column+=s),t.selection.fromOrientedRange(l)}},this.getNextLineIndent=function(e,t,i){return this.$getIndent(t)},this.checkOutdent=function(e,t,i){return!1},this.autoOutdent=function(e,t,i){},this.$getIndent=function(e){return e.match(/^\s*/)[0]},this.createWorker=function(e){return null},this.createModeDelegates=function(e){for(var n in this.$embeds=[],this.$modes={},e)e[n]&&(this.$embeds.push(n),this.$modes[n]=new e[n]);var r=["toggleBlockComment","toggleCommentLines","getNextLineIndent","checkOutdent","autoOutdent","transformAction","getCompletions"];for(n=0;n<r.length;n++)!function(e){var t=r[n],i=e[t];e[r[n]]=function(){return this.$delegator(t,arguments,i)}}(this)},this.$delegator=function(e,t,i){var n=t[0];"string"!=typeof n&&(n=n[0]);for(var r=0;r<this.$embeds.length;r++)if(this.$modes[this.$embeds[r]]){var o=n.split(this.$embeds[r]);if(!o[0]&&o[1]){t[0]=o[1];var s=this.$modes[this.$embeds[r]];return s[e].apply(s,t)}}var a=i.apply(this,t);return i?a:void 0},this.transformAction=function(e,t,i,n,r){if(this.$behaviour){var o=this.$behaviour.getBehaviours();for(var s in o)if(o[s][t]){var a=o[s][t].apply(this,arguments);if(a)return a}}},this.getKeywords=function(e){if(!this.completionKeywords){var t=this.$tokenizer.rules,i=[];for(var n in t)for(var r=t[n],o=0,s=r.length;o<s;o++)if("string"==typeof r[o].token)/keyword|support|storage/.test(r[o].token)&&i.push(r[o].regex);else if("object"==typeof r[o].token)for(var a=0,l=r[o].token.length;a<l;a++)if(/keyword|support|storage/.test(r[o].token[a])){n=r[o].regex.match(/\(.+?\)/g)[a];i.push(n.substr(1,n.length-2))}this.completionKeywords=i}return e?i.concat(this.$keywordList||[]):this.$keywordList},this.$createKeywordList=function(){return this.$highlightRules||this.getTokenizer(),this.$keywordList=this.$highlightRules.$keywordList||[]},this.getCompletions=function(e,t,i,n){return(this.$keywordList||this.$createKeywordList()).map(function(e){return{name:e,value:e,score:0,meta:"keyword"}})},this.$id="ace/mode/text"}).call(n.prototype),t.Mode=n}),ace.define("ace/apply_delta",["require","exports","module"],function(e,t,i){"use strict";t.applyDelta=function(e,t,i){var n=t.start.row,r=t.start.column,o=e[n]||"";switch(t.action){case"insert":if(1===t.lines.length)e[n]=o.substring(0,r)+t.lines[0]+o.substring(r);else{var s=[n,1].concat(t.lines);e.splice.apply(e,s),e[n]=o.substring(0,r)+e[n],e[n+t.lines.length-1]+=o.substring(r)}break;case"remove":var a=t.end.column,l=t.end.row;n===l?e[n]=o.substring(0,r)+o.substring(a):e.splice(n,l-n+1,o.substring(0,r)+e[l].substring(a))}}}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){"use strict";var n=e("./lib/oop"),r=e("./lib/event_emitter").EventEmitter,o=t.Anchor=function(e,t,i){this.$onChange=this.onChange.bind(this),this.attach(e),void 0===i?this.setPosition(t.row,t.column):this.setPosition(t,i)};(function(){function l(e,t,i){var n=i?e.column<=t.column:e.column<t.column;return e.row<t.row||e.row==t.row&&n}n.implement(this,r),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(e){if(!(e.start.row==e.end.row&&e.start.row!=this.row||e.start.row>this.row)){var t=function(e,t,i){var n="insert"==e.action,r=(n?1:-1)*(e.end.row-e.start.row),o=(n?1:-1)*(e.end.column-e.start.column),s=e.start,a=n?s:e.end;if(l(t,s,i))return{row:t.row,column:t.column};if(l(a,t,!i))return{row:t.row+r,column:t.column+(t.row==a.row?o:0)};return{row:s.row,column:s.column}}(e,{row:this.row,column:this.column},this.$insertRight);this.setPosition(t.row,t.column,!0)}},this.setPosition=function(e,t,i){var n;if(n=i?{row:e,column:t}:this.$clipPositionToDocument(e,t),this.row!=n.row||this.column!=n.column){var r={row:this.row,column:this.column};this.row=n.row,this.column=n.column,this._signal("change",{old:r,value:n})}},this.detach=function(){this.document.removeEventListener("change",this.$onChange)},this.attach=function(e){this.document=e||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(e,t){var i={};return e>=this.document.getLength()?(i.row=Math.max(0,this.document.getLength()-1),i.column=this.document.getLine(i.row).length):e<0?(i.row=0,i.column=0):(i.row=e,i.column=Math.min(this.document.getLine(i.row).length,Math.max(0,t))),t<0&&(i.column=0),i}}).call(o.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(e,t,i){"use strict";function n(e){this.$lines=[""],0===e.length?this.$lines=[""]:Array.isArray(e)?this.insertMergedLines({row:0,column:0},e):this.insert({row:0,column:0},e)}var r=e("./lib/oop"),o=e("./apply_delta").applyDelta,s=e("./lib/event_emitter").EventEmitter,h=e("./range").Range,a=e("./anchor").Anchor;(function(){r.implement(this,s),this.setValue=function(e){var t=this.getLength()-1;this.remove(new h(0,0,t,this.getLine(t).length)),this.insert({row:0,column:0},e)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(e,t){return new a(this,e,t)},0==="aaa".split(/a/).length?this.$split=function(e){return e.replace(/\r\n|\r/g,"\n").split("\n")}:this.$split=function(e){return e.split(/\r\n|\r|\n/)},this.$detectNewLine=function(e){var t=e.match(/^.*?(\r\n|\r|\n)/m);this.$autoNewLine=t?t[1]:"\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\r\n";case"unix":return"\n";default:return this.$autoNewLine||"\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(e){this.$newLineMode!==e&&(this.$newLineMode=e,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(e){return"\r\n"==e||"\r"==e||"\n"==e},this.getLine=function(e){return this.$lines[e]||""},this.getLines=function(e,t){return this.$lines.slice(e,t+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(e){return this.getLinesForRange(e).join(this.getNewLineCharacter())},this.getLinesForRange=function(e){var t;if(e.start.row===e.end.row)t=[this.getLine(e.start.row).substring(e.start.column,e.end.column)];else{(t=this.getLines(e.start.row,e.end.row))[0]=(t[0]||"").substring(e.start.column);var i=t.length-1;e.end.row-e.start.row==i&&(t[i]=t[i].substring(0,e.end.column))}return t},this.insertLines=function(e,t){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(e,t)},this.removeLines=function(e,t){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(e,t)},this.insertNewLine=function(e){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, ['', '']) instead."),this.insertMergedLines(e,["",""])},this.insert=function(e,t){return this.getLength()<=1&&this.$detectNewLine(t),this.insertMergedLines(e,this.$split(t))},this.insertInLine=function(e,t){var i=this.clippedPos(e.row,e.column),n=this.pos(e.row,e.column+t.length);return this.applyDelta({start:i,end:n,action:"insert",lines:[t]},!0),this.clonePos(n)},this.clippedPos=function(e,t){var i=this.getLength();void 0===e?e=i:e<0?e=0:i<=e&&(e=i-1,t=void 0);var n=this.getLine(e);return null==t&&(t=n.length),{row:e,column:t=Math.min(Math.max(t,0),n.length)}},this.clonePos=function(e){return{row:e.row,column:e.column}},this.pos=function(e,t){return{row:e,column:t}},this.$clipPosition=function(e){var t=this.getLength();return e.row>=t?(e.row=Math.max(0,t-1),e.column=this.getLine(t-1).length):(e.row=Math.max(0,e.row),e.column=Math.min(Math.max(e.column,0),this.getLine(e.row).length)),e},this.insertFullLines=function(e,t){var i=0;i=(e=Math.min(Math.max(e,0),this.getLength()))<this.getLength()?(t=t.concat([""]),0):(t=[""].concat(t),e--,this.$lines[e].length),this.insertMergedLines({row:e,column:i},t)},this.insertMergedLines=function(e,t){var i=this.clippedPos(e.row,e.column),n={row:i.row+t.length-1,column:(1==t.length?i.column:0)+t[t.length-1].length};return this.applyDelta({start:i,end:n,action:"insert",lines:t}),this.clonePos(n)},this.remove=function(e){var t=this.clippedPos(e.start.row,e.start.column),i=this.clippedPos(e.end.row,e.end.column);return this.applyDelta({start:t,end:i,action:"remove",lines:this.getLinesForRange({start:t,end:i})}),this.clonePos(t)},this.removeInLine=function(e,t,i){var n=this.clippedPos(e,t),r=this.clippedPos(e,i);return this.applyDelta({start:n,end:r,action:"remove",lines:this.getLinesForRange({start:n,end:r})},!0),this.clonePos(n)},this.removeFullLines=function(e,t){e=Math.min(Math.max(0,e),this.getLength()-1);var i=(t=Math.min(Math.max(0,t),this.getLength()-1))==this.getLength()-1&&0<e,n=t<this.getLength()-1,r=i?e-1:e,o=i?this.getLine(r).length:0,s=n?t+1:t,a=n?0:this.getLine(s).length,l=new h(r,o,s,a),c=this.$lines.slice(e,t+1);return this.applyDelta({start:l.start,end:l.end,action:"remove",lines:this.getLinesForRange(l)}),c},this.removeNewLine=function(e){e<this.getLength()-1&&0<=e&&this.applyDelta({start:this.pos(e,this.getLine(e).length),end:this.pos(e+1,0),action:"remove",lines:["",""]})},this.replace=function(e,t){return e instanceof h||(e=h.fromPoints(e.start,e.end)),0===t.length&&e.isEmpty()?e.start:t==this.getTextRange(e)?e.end:(this.remove(e),t?this.insert(e.start,t):e.start)},this.applyDeltas=function(e){for(var t=0;t<e.length;t++)this.applyDelta(e[t])},this.revertDeltas=function(e){for(var t=e.length-1;0<=t;t--)this.revertDelta(e[t])},this.applyDelta=function(e,t){var i="insert"==e.action;(i?e.lines.length<=1&&!e.lines[0]:!h.comparePoints(e.start,e.end))||(i&&2e4<e.lines.length&&this.$splitAndapplyLargeDelta(e,2e4),o(this.$lines,e,t),this._signal("change",e))},this.$splitAndapplyLargeDelta=function(e,t){for(var i=e.lines,n=i.length,r=e.start.row,o=e.start.column,s=0,a=0;;){s=a,a+=t-1;var l=i.slice(s,a);if(n<a){e.lines=l,e.start.row=r+s,e.start.column=o;break}l.push(""),this.applyDelta({start:this.pos(r+s,o),end:this.pos(r+a,o=0),action:e.action,lines:l},!0)}},this.revertDelta=function(e){this.applyDelta({start:this.clonePos(e.start),end:this.clonePos(e.end),action:"insert"==e.action?"remove":"insert",lines:e.lines.slice()})},this.indexToPosition=function(e,t){for(var i=this.$lines||this.getAllLines(),n=this.getNewLineCharacter().length,r=t||0,o=i.length;r<o;r++)if((e-=i[r].length+n)<0)return{row:r,column:e+i[r].length+n};return{row:o-1,column:i[o-1].length}},this.positionToIndex=function(e,t){for(var i=this.$lines||this.getAllLines(),n=this.getNewLineCharacter().length,r=0,o=Math.min(e.row,i.length),s=t||0;s<o;++s)r+=i[s].length+n;return r+e.column}}).call(n.prototype),t.Document=n}),ace.define("ace/background_tokenizer",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e,t){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.tokenizer=e;var a=this;this.$worker=function(){if(a.running){for(var e=new Date,t=a.currentLine,i=-1,n=a.doc,r=t;a.lines[t];)t++;var o=n.getLength(),s=0;for(a.running=!1;t<o;){for(a.$tokenizeRow(t),i=t;t++,a.lines[t];);if(++s%5==0&&20<new Date-e){a.running=setTimeout(a.$worker,20);break}}a.currentLine=t,-1==i&&(i=t),r<=i&&a.fireUpdateEvent(r,i)}}}var r=e("./lib/oop"),o=e("./lib/event_emitter").EventEmitter;(function(){r.implement(this,o),this.setTokenizer=function(e){this.tokenizer=e,this.lines=[],this.states=[],this.start(0)},this.setDocument=function(e){this.doc=e,this.lines=[],this.states=[],this.stop()},this.fireUpdateEvent=function(e,t){var i={first:e,last:t};this._signal("update",{data:i})},this.start=function(e){this.currentLine=Math.min(e||0,this.currentLine,this.doc.getLength()),this.lines.splice(this.currentLine,this.lines.length),this.states.splice(this.currentLine,this.states.length),this.stop(),this.running=setTimeout(this.$worker,700)},this.scheduleStart=function(){this.running||(this.running=setTimeout(this.$worker,700))},this.$updateOnChange=function(e){var t=e.start.row,i=e.end.row-t;if(0==i)this.lines[t]=null;else if("remove"==e.action)this.lines.splice(t,1+i,null),this.states.splice(t,1+i,null);else{var n=Array(1+i);n.unshift(t,1),this.lines.splice.apply(this.lines,n),this.states.splice.apply(this.states,n)}this.currentLine=Math.min(t,this.currentLine,this.doc.getLength()),this.stop()},this.stop=function(){this.running&&clearTimeout(this.running),this.running=!1},this.getTokens=function(e){return this.lines[e]||this.$tokenizeRow(e)},this.getState=function(e){return this.currentLine==e&&this.$tokenizeRow(e),this.states[e]||"start"},this.$tokenizeRow=function(e){var t=this.doc.getLine(e),i=this.states[e-1],n=this.tokenizer.getLineTokens(t,i,e);return this.states[e]+""!=n.state+""?(this.states[e]=n.state,this.lines[e+1]=null,this.currentLine>e+1&&(this.currentLine=e+1)):this.currentLine==e&&(this.currentLine=e+1),this.lines[e]=n.tokens}}).call(n.prototype),t.BackgroundTokenizer=n}),ace.define("ace/search_highlight",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(e,t,i){"use strict";function n(e,t,i){this.setRegexp(e),this.clazz=t,this.type=i||"text"}var c=e("./lib/lang"),h=(e("./lib/oop"),e("./range").Range);(function(){this.MAX_RANGES=500,this.setRegexp=function(e){this.regExp+""!=e+""&&(this.regExp=e,this.cache=[])},this.update=function(e,t,i,n){if(this.regExp)for(var r=n.firstRow,o=n.lastRow,s=r;s<=o;s++){var a=this.cache[s];null==a&&((a=c.getMatchOffsets(i.getLine(s),this.regExp)).length>this.MAX_RANGES&&(a=a.slice(0,this.MAX_RANGES)),a=a.map(function(e){return new h(s,e.offset,s,e.offset+e.length)}),this.cache[s]=a.length?a:"");for(var l=a.length;l--;)t.drawSingleLineMarker(e,a[l].toScreenRange(i),this.clazz,n)}}}).call(n.prototype),t.SearchHighlight=n}),ace.define("ace/edit_session/fold_line",["require","exports","module","ace/range"],function(e,t,i){"use strict";var n=e("../range").Range;function c(e,t){this.foldData=e,Array.isArray(t)?this.folds=t:t=this.folds=[t];var i=t[t.length-1];this.range=new n(t[0].start.row,t[0].start.column,i.end.row,i.end.column),this.start=this.range.start,this.end=this.range.end,this.folds.forEach(function(e){e.setFoldLine(this)},this)}(function(){this.shiftRow=function(t){this.start.row+=t,this.end.row+=t,this.folds.forEach(function(e){e.start.row+=t,e.end.row+=t})},this.addFold=function(e){if(e.sameRow){if(e.start.row<this.startRow||e.endRow>this.endRow)throw new Error("Can't add a fold to this FoldLine as it has no connection");this.folds.push(e),this.folds.sort(function(e,t){return-e.range.compareEnd(t.start.row,t.start.column)}),0<this.range.compareEnd(e.start.row,e.start.column)?(this.end.row=e.end.row,this.end.column=e.end.column):this.range.compareStart(e.end.row,e.end.column)<0&&(this.start.row=e.start.row,this.start.column=e.start.column)}else if(e.start.row==this.end.row)this.folds.push(e),this.end.row=e.end.row,this.end.column=e.end.column;else{if(e.end.row!=this.start.row)throw new Error("Trying to add fold to FoldRow that doesn't have a matching row");this.folds.unshift(e),this.start.row=e.start.row,this.start.column=e.start.column}e.foldLine=this},this.containsRow=function(e){return e>=this.start.row&&e<=this.end.row},this.walk=function(e,t,i){var n,r,o=0,s=this.folds,a=!0;null==t&&(t=this.end.row,i=this.end.column);for(var l=0;l<s.length;l++){if(-1==(r=(n=s[l]).range.compareStart(t,i)))return void e(null,t,i,o,a);if(!e(null,n.start.row,n.start.column,o,a)&&e(n.placeholder,n.start.row,n.start.column,o)||0===r)return;a=!n.sameRow,o=n.end.column}e(null,t,i,o,a)},this.getNextFoldTo=function(e,t){for(var i,n,r=0;r<this.folds.length;r++){if(-1==(n=(i=this.folds[r]).range.compareEnd(e,t)))return{fold:i,kind:"after"};if(0===n)return{fold:i,kind:"inside"}}return null},this.addRemoveChars=function(e,t,i){var n,r,o=this.getNextFoldTo(e,t);if(o)if(n=o.fold,"inside"==o.kind&&n.start.column!=t&&n.start.row!=e)window.console&&window.console.log(e,t,n);else if(n.start.row==e){var s=(r=this.folds).indexOf(n);for(0===s&&(this.start.column+=i);s<r.length;s++){if((n=r[s]).start.column+=i,!n.sameRow)return;n.end.column+=i}this.end.column+=i}},this.split=function(e,t){var i=this.getNextFoldTo(e,t);if(!i||"inside"==i.kind)return null;var n=i.fold,r=this.folds,o=this.foldData,s=r.indexOf(n),a=r[s-1];this.end.row=a.end.row,this.end.column=a.end.column;var l=new c(o,r=r.splice(s,r.length-s));return o.splice(o.indexOf(this)+1,0,l),l},this.merge=function(e){for(var t=e.folds,i=0;i<t.length;i++)this.addFold(t[i]);var n=this.foldData;n.splice(n.indexOf(e),1)},this.toString=function(){var t=[this.range.toString()+": ["];return this.folds.forEach(function(e){t.push("  "+e.toString())}),t.push("]"),t.join("\n")},this.idxToPosition=function(e){for(var t=0,i=0;i<this.folds.length;i++){var n=this.folds[i];if((e-=n.start.column-t)<0)return{row:n.start.row,column:n.start.column+e};if((e-=n.placeholder.length)<0)return n.start;t=n.end.column}return{row:this.end.row,column:this.end.column+e}}}).call(c.prototype),t.FoldLine=c}),ace.define("ace/range_list",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(){this.ranges=[]}var l=e("./range").Range.comparePoints;(function(){this.comparePoints=l,this.pointIndex=function(e,t,i){for(var n=this.ranges,r=i||0;r<n.length;r++){var o=n[r],s=l(e,o.end);if(!(0<s)){var a=l(e,o.start);return 0===s?t&&0!==a?-r-2:r:0<a||0===a&&!t?r:-r-1}}return-r-1},this.add=function(e){var t=!e.isEmpty(),i=this.pointIndex(e.start,t);i<0&&(i=-i-1);var n=this.pointIndex(e.end,t,i);return n<0?n=-n-1:n++,this.ranges.splice(i,n-i,e)},this.addList=function(e){for(var t=[],i=e.length;i--;)t.push.apply(t,this.add(e[i]));return t},this.substractPoint=function(e){var t=this.pointIndex(e);if(0<=t)return this.ranges.splice(t,1)},this.merge=function(){for(var e,t=[],i=this.ranges,n=(i=i.sort(function(e,t){return l(e.start,t.start)}))[0],r=1;r<i.length;r++){e=n,n=i[r];var o=l(e.end,n.start);o<0||(0!=o||e.isEmpty()||n.isEmpty())&&(l(e.end,n.end)<0&&(e.end.row=n.end.row,e.end.column=n.end.column),i.splice(r,1),t.push(n),n=e,r--)}return this.ranges=i,t},this.contains=function(e,t){return 0<=this.pointIndex({row:e,column:t})},this.containsPoint=function(e){return 0<=this.pointIndex(e)},this.rangeAtPoint=function(e){var t=this.pointIndex(e);if(0<=t)return this.ranges[t]},this.clipRows=function(e,t){var i=this.ranges;if(i[0].start.row>t||i[i.length-1].start.row<e)return[];var n=this.pointIndex({row:e,column:0});n<0&&(n=-n-1);var r=this.pointIndex({row:t,column:0},n);r<0&&(r=-r-1);for(var o=[],s=n;s<r;s++)o.push(i[s]);return o},this.removeAll=function(){return this.ranges.splice(0,this.ranges.length)},this.attach=function(e){this.session&&this.detach(),this.session=e,this.onChange=this.$onChange.bind(this),this.session.on("change",this.onChange)},this.detach=function(){this.session&&(this.session.removeListener("change",this.onChange),this.session=null)},this.$onChange=function(e){if("insert"==e.action)var t=e.start,i=e.end;else i=e.start,t=e.end;for(var n=t.row,r=i.row-n,o=-t.column+i.column,s=this.ranges,a=0,l=s.length;a<l;a++){if(!((c=s[a]).end.row<n)){if(c.start.row>n)break;if(c.start.row==n&&c.start.column>=t.column&&(c.start.column==t.column&&this.$insertRight||(c.start.column+=o,c.start.row+=r)),c.end.row==n&&c.end.column>=t.column){if(c.end.column==t.column&&this.$insertRight)continue;c.end.column==t.column&&0<o&&a<l-1&&c.end.column>c.start.column&&c.end.column==s[a+1].start.column&&(c.end.column-=o),c.end.column+=o,c.end.row+=r}}}if(0!=r&&a<l)for(;a<l;a++){var c;(c=s[a]).start.row+=r,c.end.row+=r}}}).call(n.prototype),t.RangeList=n}),ace.define("ace/edit_session/fold",["require","exports","module","ace/range","ace/range_list","ace/lib/oop"],function(e,t,i){"use strict";e("../range").Range;var n=e("../range_list").RangeList,r=e("../lib/oop"),o=t.Fold=function(e,t){this.foldLine=null,this.placeholder=t,this.range=e,this.start=e.start,this.end=e.end,this.sameRow=e.start.row==e.end.row,this.subFolds=this.ranges=[]};function a(e,t){e.row-=t.row,0==e.row&&(e.column-=t.column)}function s(e,t){0==e.row&&(e.column+=t.column),e.row+=t.row}r.inherits(o,n),function(){this.toString=function(){return'"'+this.placeholder+'" '+this.range.toString()},this.setFoldLine=function(t){this.foldLine=t,this.subFolds.forEach(function(e){e.setFoldLine(t)})},this.clone=function(){var e=this.range.clone(),t=new o(e,this.placeholder);return this.subFolds.forEach(function(e){t.subFolds.push(e.clone())}),t.collapseChildren=this.collapseChildren,t},this.addSubFold=function(e){if(!this.range.isEqual(e)){if(!this.range.containsRange(e))throw new Error("A fold can't intersect already existing fold"+e.range+this.range);!function(e,t){a(e.start,t),a(e.end,t)}(e,this.start);for(var t=e.start.row,i=e.start.column,n=0,r=-1;n<this.subFolds.length&&1==(r=this.subFolds[n].range.compare(t,i));n++);var o=this.subFolds[n];if(0==r)return o.addSubFold(e);t=e.range.end.row,i=e.range.end.column;var s=n;for(r=-1;s<this.subFolds.length&&1==(r=this.subFolds[s].range.compare(t,i));s++);this.subFolds[s];if(0==r)throw new Error("A fold can't intersect already existing fold"+e.range+this.range);this.subFolds.splice(n,s-n,e);return e.setFoldLine(this.foldLine),e}},this.restoreRange=function(e){return function(e,t){s(e.start,t),s(e.end,t)}(e,this.start)}}.call(o.prototype)}),ace.define("ace/edit_session/folding",["require","exports","module","ace/range","ace/edit_session/fold_line","ace/edit_session/fold","ace/token_iterator"],function(e,t,i){"use strict";var h=e("../range").Range,m=e("./fold_line").FoldLine,g=e("./fold").Fold,d=e("../token_iterator").TokenIterator;t.Folding=function(){this.getFoldAt=function(e,t,i){var n=this.getFoldLine(e);if(!n)return null;for(var r=n.folds,o=0;o<r.length;o++){var s=r[o];if(s.range.contains(e,t)){if(1==i&&s.range.isEnd(e,t))continue;if(-1==i&&s.range.isStart(e,t))continue;return s}}},this.getFoldsInRange=function(e){var t=e.start,i=e.end,n=this.$foldData,r=[];t.column+=1,i.column-=1;for(var o=0;o<n.length;o++){var s=n[o].range.compareRange(e);if(2!=s){if(-2==s)break;for(var a=n[o].folds,l=0;l<a.length;l++){var c=a[l];if(-2==(s=c.range.compareRange(e)))break;if(2!=s){if(42==s)break;r.push(c)}}}}return t.column-=1,i.column+=1,r},this.getFoldsInRangeList=function(e){if(Array.isArray(e)){var t=[];e.forEach(function(e){t=t.concat(this.getFoldsInRange(e))},this)}else t=this.getFoldsInRange(e);return t},this.getAllFolds=function(){for(var e=[],t=this.$foldData,i=0;i<t.length;i++)for(var n=0;n<t[i].folds.length;n++)e.push(t[i].folds[n]);return e},this.getFoldStringAt=function(e,t,i,n){if(!(n=n||this.getFoldLine(e)))return null;for(var r,o,s={end:{column:0}},a=0;a<n.folds.length;a++){var l=(o=n.folds[a]).range.compareEnd(e,t);if(-1==l){r=this.getLine(o.start.row).substring(s.end.column,o.start.column);break}if(0===l)return null;s=o}return r=r||this.getLine(o.start.row).substring(s.end.column),-1==i?r.substring(0,t-s.end.column):1==i?r.substring(t-s.end.column):r},this.getFoldLine=function(e,t){var i=this.$foldData,n=0;for(t&&(n=i.indexOf(t)),-1==n&&(n=0);n<i.length;n++){var r=i[n];if(r.start.row<=e&&r.end.row>=e)return r;if(r.end.row>e)return null}return null},this.getNextFoldLine=function(e,t){var i=this.$foldData,n=0;for(t&&(n=i.indexOf(t)),-1==n&&(n=0);n<i.length;n++){var r=i[n];if(r.end.row>=e)return r}return null},this.getFoldedRowCount=function(e,t){for(var i=this.$foldData,n=t-e+1,r=0;r<i.length;r++){var o=i[r],s=o.end.row,a=o.start.row;if(t<=s){a<t&&(e<=a?n-=t-a:n=0);break}e<=s&&(n-=e<=a?s-a:s-e+1)}return n},this.$addFoldLine=function(e){return this.$foldData.push(e),this.$foldData.sort(function(e,t){return e.start.row-t.start.row}),e},this.addFold=function(e,t){var i,n=this.$foldData,r=!1;e instanceof g?i=e:(i=new g(t,e)).collapseChildren=t.collapseChildren,this.$clipRangeToDocument(i.range);var o=i.start.row,s=i.start.column,a=i.end.row,l=i.end.column;if(!(o<a||o==a&&s<=l-2))throw new Error("The range has to be at least 2 characters width");var c=this.getFoldAt(o,s,1),h=this.getFoldAt(a,l,-1);if(c&&h==c)return c.addSubFold(i);c&&!c.range.isStart(o,s)&&this.removeFold(c),h&&!h.range.isEnd(a,l)&&this.removeFold(h);var d=this.getFoldsInRange(i.range);0<d.length&&(this.removeFolds(d),d.forEach(function(e){i.addSubFold(e)}));for(var u=0;u<n.length;u++){var f=n[u];if(a==f.start.row){f.addFold(i),r=!0;break}if(o==f.end.row){if(f.addFold(i),r=!0,!i.sameRow){var p=n[u+1];if(p&&p.start.row==a){f.merge(p);break}}break}if(a<=f.start.row)break}return r||(f=this.$addFoldLine(new m(this.$foldData,i))),this.$useWrapMode?this.$updateWrapData(f.start.row,f.start.row):this.$updateRowLengthCache(f.start.row,f.start.row),this.$modified=!0,this._signal("changeFold",{data:i,action:"add"}),i},this.addFolds=function(e){e.forEach(function(e){this.addFold(e)},this)},this.removeFold=function(e){var t=e.foldLine,i=t.start.row,n=t.end.row,r=this.$foldData,o=t.folds;if(1==o.length)r.splice(r.indexOf(t),1);else if(t.range.isEnd(e.end.row,e.end.column))o.pop(),t.end.row=o[o.length-1].end.row,t.end.column=o[o.length-1].end.column;else if(t.range.isStart(e.start.row,e.start.column))o.shift(),t.start.row=o[0].start.row,t.start.column=o[0].start.column;else if(e.sameRow)o.splice(o.indexOf(e),1);else{var s=t.split(e.start.row,e.start.column);(o=s.folds).shift(),s.start.row=o[0].start.row,s.start.column=o[0].start.column}this.$updating||(this.$useWrapMode?this.$updateWrapData(i,n):this.$updateRowLengthCache(i,n)),this.$modified=!0,this._signal("changeFold",{data:e,action:"remove"})},this.removeFolds=function(e){for(var t=[],i=0;i<e.length;i++)t.push(e[i]);t.forEach(function(e){this.removeFold(e)},this),this.$modified=!0},this.expandFold=function(t){this.removeFold(t),t.subFolds.forEach(function(e){t.restoreRange(e),this.addFold(e)},this),0<t.collapseChildren&&this.foldAll(t.start.row+1,t.end.row,t.collapseChildren-1),t.subFolds=[]},this.expandFolds=function(e){e.forEach(function(e){this.expandFold(e)},this)},this.unfold=function(e,t){var i,n;if(null==e?(i=new h(0,0,this.getLength(),0),t=!0):i="number"==typeof e?new h(e,0,e,this.getLine(e).length):"row"in e?h.fromPoints(e,e):e,n=this.getFoldsInRangeList(i),t)this.removeFolds(n);else for(var r=n;r.length;)this.expandFolds(r),r=this.getFoldsInRangeList(i);if(n.length)return n},this.isRowFolded=function(e,t){return!!this.getFoldLine(e,t)},this.getRowFoldEnd=function(e,t){var i=this.getFoldLine(e,t);return i?i.end.row:e},this.getRowFoldStart=function(e,t){var i=this.getFoldLine(e,t);return i?i.start.row:e},this.getFoldDisplayLine=function(e,t,i,r,o){null==r&&(r=e.start.row),null==o&&(o=0),null==t&&(t=e.end.row),null==i&&(i=this.getLine(t).length);var s=this.doc,a="";return e.walk(function(e,t,i,n){if(!(t<r)){if(t==r){if(i<o)return;n=Math.max(o,n)}a+=null!=e?e:s.getLine(t).substring(n,i)}},t,i),a},this.getDisplayLine=function(e,t,i,n){var r,o=this.getFoldLine(e);return o?this.getFoldDisplayLine(o,e,t,i,n):(r=this.doc.getLine(e)).substring(n||0,t||r.length)},this.$cloneFoldData=function(){var i=[];return i=this.$foldData.map(function(e){var t=e.folds.map(function(e){return e.clone()});return new m(i,t)})},this.toggleFold=function(e){var t,i,n=this.selection.getRange();if(n.isEmpty()){var r=n.start;if(t=this.getFoldAt(r.row,r.column))return void this.expandFold(t);(i=this.findMatchingBracket(r))?1==n.comparePoint(i)?n.end=i:(n.start=i,n.start.column++,n.end.column--):(i=this.findMatchingBracket({row:r.row,column:r.column+1}))?(1==n.comparePoint(i)?n.end=i:n.start=i,n.start.column++):n=this.getCommentFoldRange(r.row,r.column)||n}else{var o=this.getFoldsInRange(n);if(e&&o.length)return void this.expandFolds(o);1==o.length&&(t=o[0])}if((t=t||this.getFoldAt(n.start.row,n.start.column))&&t.range.toString()==n.toString())this.expandFold(t);else{var s="...";if(!n.isMultiLine()){if((s=this.getTextRange(n)).length<4)return;s=s.trim().substring(0,2)+".."}this.addFold(s,n)}},this.getCommentFoldRange=function(e,t,i){var n=new d(this,e,t),r=n.getCurrentToken(),o=r.type;if(r&&/^comment|string/.test(o)){"comment"==(o=o.match(/comment|string/)[0])&&(o+="|doc-start");var s=new RegExp(o),a=new h;if(1!=i){for(;(r=n.stepBackward())&&s.test(r.type););n.stepForward()}if(a.start.row=n.getCurrentTokenRow(),a.start.column=n.getCurrentTokenColumn()+2,n=new d(this,e,t),-1!=i){var l=-1;do{if(r=n.stepForward(),-1==l){var c=this.getState(n.$row);s.test(c)||(l=n.$row)}else if(n.$row>l)break}while(r&&s.test(r.type));r=n.stepBackward()}else r=n.getCurrentToken();return a.end.row=n.getCurrentTokenRow(),a.end.column=n.getCurrentTokenColumn()+r.value.length-2,a}},this.foldAll=function(e,t,i){null==i&&(i=1e5);var n=this.foldWidgets;if(n){t=t||this.getLength();for(var r=e=e||0;r<t;r++)if(null==n[r]&&(n[r]=this.getFoldWidget(r)),"start"==n[r]){var o=this.getFoldWidgetRange(r);if(o&&o.isMultiLine()&&o.end.row<=t&&o.start.row>=e){r=o.end.row;try{var s=this.addFold("...",o);s&&(s.collapseChildren=i)}catch(e){}}}}},this.$foldStyles={manual:1,markbegin:1,markbeginend:1},this.$foldStyle="markbegin",this.setFoldStyle=function(e){if(!this.$foldStyles[e])throw new Error("invalid fold style: "+e+"["+Object.keys(this.$foldStyles).join(", ")+"]");if(this.$foldStyle!=e){"manual"==(this.$foldStyle=e)&&this.unfold();var t=this.$foldMode;this.$setFolding(null),this.$setFolding(t)}},this.$setFolding=function(e){this.$foldMode!=e&&(this.$foldMode=e,this.off("change",this.$updateFoldWidgets),this.off("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets),this._signal("changeAnnotation"),e&&"manual"!=this.$foldStyle?(this.foldWidgets=[],this.getFoldWidget=e.getFoldWidget.bind(e,this,this.$foldStyle),this.getFoldWidgetRange=e.getFoldWidgetRange.bind(e,this,this.$foldStyle),this.$updateFoldWidgets=this.updateFoldWidgets.bind(this),this.$tokenizerUpdateFoldWidgets=this.tokenizerUpdateFoldWidgets.bind(this),this.on("change",this.$updateFoldWidgets),this.on("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets)):this.foldWidgets=null)},this.getParentFoldRangeData=function(e,t){var i=this.foldWidgets;if(!i||t&&i[e])return{};for(var n,r=e-1;0<=r;){var o=i[r];if(null==o&&(o=i[r]=this.getFoldWidget(r)),"start"==o){var s=this.getFoldWidgetRange(r);if(n=n||s,s&&s.end.row>=e)break}r--}return{range:-1!==r&&s,firstRange:n}},this.onFoldWidgetClick=function(e,t){var i={children:(t=t.domEvent).shiftKey,all:t.ctrlKey||t.metaKey,siblings:t.altKey};if(!this.$toggleFoldWidget(e,i)){var n=t.target||t.srcElement;n&&/ace_fold-widget/.test(n.className)&&(n.className+=" ace_invalid")}},this.$toggleFoldWidget=function(e,t){if(this.getFoldWidget){var i=this.getFoldWidget(e),n=this.getLine(e),r="end"===i?-1:1,o=this.getFoldAt(e,-1==r?0:n.length,r);if(o)return t.children||t.all?this.removeFold(o):this.expandFold(o),o;var s=this.getFoldWidgetRange(e,!0);if(s&&!s.isMultiLine()&&(o=this.getFoldAt(s.start.row,s.start.column,1))&&s.isEqual(o.range))return this.removeFold(o),o;if(t.siblings){var a=this.getParentFoldRangeData(e);if(a.range)var l=a.range.start.row+1,c=a.range.end.row;this.foldAll(l,c,t.all?1e4:0)}else t.children?(c=s?s.end.row:this.getLength(),this.foldAll(e+1,c,t.all?1e4:0)):s&&(t.all&&(s.collapseChildren=1e4),this.addFold("...",s));return s}},this.toggleFoldWidget=function(e){var t=this.selection.getCursor().row;t=this.getRowFoldStart(t);var i=this.$toggleFoldWidget(t,{});if(!i){var n=this.getParentFoldRangeData(t,!0);if(i=n.range||n.firstRange){t=i.start.row;var r=this.getFoldAt(t,this.getLine(t).length,1);r?this.removeFold(r):this.addFold("...",i)}}},this.updateFoldWidgets=function(e){var t=e.start.row,i=e.end.row-t;if(0==i)this.foldWidgets[t]=null;else if("remove"==e.action)this.foldWidgets.splice(t,1+i,null);else{var n=Array(1+i);n.unshift(t,1),this.foldWidgets.splice.apply(this.foldWidgets,n)}},this.tokenizerUpdateFoldWidgets=function(e){var t=e.data;t.first!=t.last&&this.foldWidgets.length>t.first&&this.foldWidgets.splice(t.first,this.foldWidgets.length)}}}),ace.define("ace/edit_session/bracket_match",["require","exports","module","ace/token_iterator","ace/range"],function(e,t,i){"use strict";var d=e("../token_iterator").TokenIterator,a=e("../range").Range;t.BracketMatch=function(){this.findMatchingBracket=function(e,t){if(0==e.column)return null;var i=t||this.getLine(e.row).charAt(e.column-1);if(""==i)return null;var n=i.match(/([\(\[\{])|([\)\]\}])/);return n?n[1]?this.$findClosingBracket(n[1],e):this.$findOpeningBracket(n[2],e):null},this.getBracketRange=function(e){var t,i=this.getLine(e.row),n=!0,r=i.charAt(e.column-1),o=r&&r.match(/([\(\[\{])|([\)\]\}])/);if(o||(r=i.charAt(e.column),e={row:e.row,column:e.column+1},o=r&&r.match(/([\(\[\{])|([\)\]\}])/),n=!1),!o)return null;if(o[1]){if(!(s=this.$findClosingBracket(o[1],e)))return null;t=a.fromPoints(e,s),n||(t.end.column++,t.start.column--),t.cursor=t.end}else{var s;if(!(s=this.$findOpeningBracket(o[2],e)))return null;t=a.fromPoints(s,e),n||(t.start.column++,t.end.column--),t.cursor=t.start}return t},this.$brackets={")":"(","(":")","]":"[","[":"]","{":"}","}":"{"},this.$findOpeningBracket=function(e,t,i){var n=this.$brackets[e],r=1,o=new d(this,t.row,t.column),s=o.getCurrentToken();if(s=s||o.stepForward()){i=i||new RegExp("(\\.?"+s.type.replace(".","\\.").replace("rparen",".paren").replace(/\b(?:end)\b/,"(?:start|begin|end)")+")+");for(var a=t.column-o.getCurrentTokenColumn()-2,l=s.value;;){for(;0<=a;){var c=l.charAt(a);if(c==n){if(0==(r-=1))return{row:o.getCurrentTokenRow(),column:a+o.getCurrentTokenColumn()}}else c==e&&(r+=1);a-=1}for(;(s=o.stepBackward())&&!i.test(s.type););if(null==s)break;a=(l=s.value).length-1}return null}},this.$findClosingBracket=function(e,t,i){var n=this.$brackets[e],r=1,o=new d(this,t.row,t.column),s=o.getCurrentToken();if(s=s||o.stepForward()){i=i||new RegExp("(\\.?"+s.type.replace(".","\\.").replace("lparen",".paren").replace(/\b(?:start|begin)\b/,"(?:start|begin|end)")+")+");for(var a=t.column-o.getCurrentTokenColumn();;){for(var l=s.value,c=l.length;a<c;){var h=l.charAt(a);if(h==n){if(0==(r-=1))return{row:o.getCurrentTokenRow(),column:a+o.getCurrentTokenColumn()}}else h==e&&(r+=1);a+=1}for(;(s=o.stepForward())&&!i.test(s.type););if(null==s)break;a=0}return null}}}}),ace.define("ace/edit_session",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/bidihandler","ace/config","ace/lib/event_emitter","ace/selection","ace/mode/text","ace/range","ace/document","ace/background_tokenizer","ace/search_highlight","ace/edit_session/folding","ace/edit_session/bracket_match"],function(e,t,i){"use strict";var n=e("./lib/oop"),r=e("./lib/lang"),o=e("./bidihandler").BidiHandler,s=e("./config"),l=e("./lib/event_emitter").EventEmitter,a=e("./selection").Selection,c=e("./mode/text").Mode,h=e("./range").Range,d=e("./document").Document,u=e("./background_tokenizer").BackgroundTokenizer,f=e("./search_highlight").SearchHighlight,p=function(e,t){this.$breakpoints=[],this.$decorations=[],this.$frontMarkers={},this.$backMarkers={},this.$markerId=1,this.$undoSelect=!0,this.$foldData=[],this.id="session"+ ++p.$uid,this.$foldData.toString=function(){return this.join("\n")},this.on("changeFold",this.onChangeFold.bind(this)),this.$onChange=this.onChange.bind(this),"object"==typeof e&&e.getLine||(e=new d(e)),this.$bidiHandler=new o(this),this.setDocument(e),this.selection=new a(this),s.resetOptions(this),this.setMode(t),s._signal("session",this)};p.$uid=0,function(){n.implement(this,l),this.setDocument=function(e){this.doc&&this.doc.removeListener("change",this.$onChange),(this.doc=e).on("change",this.$onChange),this.bgTokenizer&&this.bgTokenizer.setDocument(this.getDocument()),this.resetCaches()},this.getDocument=function(){return this.doc},this.$resetRowCache=function(e){if(!e)return this.$docRowCache=[],void(this.$screenRowCache=[]);var t=this.$docRowCache.length,i=this.$getRowCacheIndex(this.$docRowCache,e)+1;i<t&&(this.$docRowCache.splice(i,t),this.$screenRowCache.splice(i,t))},this.$getRowCacheIndex=function(e,t){for(var i=0,n=e.length-1;i<=n;){var r=i+n>>1,o=e[r];if(o<t)i=1+r;else{if(!(t<o))return r;n=r-1}}return i-1},this.resetCaches=function(){this.$modified=!0,this.$wrapData=[],this.$rowLengthCache=[],this.$resetRowCache(0),this.bgTokenizer&&this.bgTokenizer.start(0)},this.onChangeFold=function(e){var t=e.data;this.$resetRowCache(t.start.row)},this.onChange=function(e){this.$modified=!0,this.$bidiHandler.onChange(e),this.$resetRowCache(e.start.row);var t=this.$updateInternalDataOnChange(e);this.$fromUndo||!this.$undoManager||e.ignore||(this.$deltasDoc.push(e),t&&0!=t.length&&this.$deltasFold.push({action:"removeFolds",folds:t}),this.$informUndoManager.schedule()),this.bgTokenizer&&this.bgTokenizer.$updateOnChange(e),this._signal("change",e)},this.setValue=function(e){this.doc.setValue(e),this.selection.moveTo(0,0),this.$resetRowCache(0),this.$deltas=[],this.$deltasDoc=[],this.$deltasFold=[],this.setUndoManager(this.$undoManager),this.getUndoManager().reset()},this.getValue=this.toString=function(){return this.doc.getValue()},this.getSelection=function(){return this.selection},this.getState=function(e){return this.bgTokenizer.getState(e)},this.getTokens=function(e){return this.bgTokenizer.getTokens(e)},this.getTokenAt=function(e,t){var i,n=this.bgTokenizer.getTokens(e),r=0;if(null==t){var o=n.length-1;r=this.getLine(e).length}else for(o=0;o<n.length&&!(t<=(r+=n[o].value.length));o++);return(i=n[o])?(i.index=o,i.start=r-i.value.length,i):null},this.setUndoManager=function(e){if(this.$undoManager=e,this.$deltas=[],this.$deltasDoc=[],this.$deltasFold=[],this.$informUndoManager&&this.$informUndoManager.cancel(),e){var t=this;this.$syncInformUndoManager=function(){t.$informUndoManager.cancel(),t.$deltasFold.length&&(
t.$deltas.push({group:"fold",deltas:t.$deltasFold}),t.$deltasFold=[]),t.$deltasDoc.length&&(t.$deltas.push({group:"doc",deltas:t.$deltasDoc}),t.$deltasDoc=[]),0<t.$deltas.length&&e.execute({action:"aceupdate",args:[t.$deltas,t],merge:t.mergeUndoDeltas}),t.mergeUndoDeltas=!1,t.$deltas=[]},this.$informUndoManager=r.delayedCall(this.$syncInformUndoManager)}},this.markUndoGroup=function(){this.$syncInformUndoManager&&this.$syncInformUndoManager()},this.$defaultUndoManager={undo:function(){},redo:function(){},reset:function(){}},this.getUndoManager=function(){return this.$undoManager||this.$defaultUndoManager},this.getTabString=function(){return this.getUseSoftTabs()?r.stringRepeat(" ",this.getTabSize()):"\t"},this.setUseSoftTabs=function(e){this.setOption("useSoftTabs",e)},this.getUseSoftTabs=function(){return this.$useSoftTabs&&!this.$mode.$indentWithTabs},this.setTabSize=function(e){this.setOption("tabSize",e)},this.getTabSize=function(){return this.$tabSize},this.isTabStop=function(e){return this.$useSoftTabs&&e.column%this.$tabSize==0},this.setNavigateWithinSoftTabs=function(e){this.setOption("navigateWithinSoftTabs",e)},this.getNavigateWithinSoftTabs=function(){return this.$navigateWithinSoftTabs},this.$overwrite=!1,this.setOverwrite=function(e){this.setOption("overwrite",e)},this.getOverwrite=function(){return this.$overwrite},this.toggleOverwrite=function(){this.setOverwrite(!this.$overwrite)},this.addGutterDecoration=function(e,t){this.$decorations[e]||(this.$decorations[e]=""),this.$decorations[e]+=" "+t,this._signal("changeBreakpoint",{})},this.removeGutterDecoration=function(e,t){this.$decorations[e]=(this.$decorations[e]||"").replace(" "+t,""),this._signal("changeBreakpoint",{})},this.getBreakpoints=function(){return this.$breakpoints},this.setBreakpoints=function(e){this.$breakpoints=[];for(var t=0;t<e.length;t++)this.$breakpoints[e[t]]="ace_breakpoint";this._signal("changeBreakpoint",{})},this.clearBreakpoints=function(){this.$breakpoints=[],this._signal("changeBreakpoint",{})},this.setBreakpoint=function(e,t){void 0===t&&(t="ace_breakpoint"),t?this.$breakpoints[e]=t:delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.clearBreakpoint=function(e){delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.addMarker=function(e,t,i,n){var r=this.$markerId++,o={range:e,type:i||"line",renderer:"function"==typeof i?i:null,clazz:t,inFront:!!n,id:r};return n?(this.$frontMarkers[r]=o,this._signal("changeFrontMarker")):(this.$backMarkers[r]=o,this._signal("changeBackMarker")),r},this.addDynamicMarker=function(e,t){if(e.update){var i=this.$markerId++;return e.id=i,e.inFront=!!t,t?(this.$frontMarkers[i]=e,this._signal("changeFrontMarker")):(this.$backMarkers[i]=e,this._signal("changeBackMarker")),e}},this.removeMarker=function(e){var t=this.$frontMarkers[e]||this.$backMarkers[e];if(t){var i=t.inFront?this.$frontMarkers:this.$backMarkers;t&&(delete i[e],this._signal(t.inFront?"changeFrontMarker":"changeBackMarker"))}},this.getMarkers=function(e){return e?this.$frontMarkers:this.$backMarkers},this.highlight=function(e){if(!this.$searchHighlight){var t=new f(null,"ace_selected-word","text");this.$searchHighlight=this.addDynamicMarker(t)}this.$searchHighlight.setRegexp(e)},this.highlightLines=function(e,t,i,n){"number"!=typeof t&&(i=t,t=e),i=i||"ace_step";var r=new h(e,0,t,1/0);return r.id=this.addMarker(r,i,"fullLine",n),r},this.setAnnotations=function(e){this.$annotations=e,this._signal("changeAnnotation",{})},this.getAnnotations=function(){return this.$annotations||[]},this.clearAnnotations=function(){this.setAnnotations([])},this.$detectNewLine=function(e){var t=e.match(/^.*?(\r?\n)/m);this.$autoNewLine=t?t[1]:"\n"},this.getWordRange=function(e,t){var i=this.getLine(e),n=!1;if(0<t&&(n=!!i.charAt(t-1).match(this.tokenRe)),n=n||!!i.charAt(t).match(this.tokenRe))var r=this.tokenRe;else if(/^\s+$/.test(i.slice(t-1,t+1)))r=/\s/;else r=this.nonTokenRe;var o=t;if(0<o){for(;0<=--o&&i.charAt(o).match(r););o++}for(var s=t;s<i.length&&i.charAt(s).match(r);)s++;return new h(e,o,e,s)},this.getAWordRange=function(e,t){for(var i=this.getWordRange(e,t),n=this.getLine(i.end.row);n.charAt(i.end.column).match(/[ \t]/);)i.end.column+=1;return i},this.setNewLineMode=function(e){this.doc.setNewLineMode(e)},this.getNewLineMode=function(){return this.doc.getNewLineMode()},this.setUseWorker=function(e){this.setOption("useWorker",e)},this.getUseWorker=function(){return this.$useWorker},this.onReloadTokenizer=function(e){var t=e.data;this.bgTokenizer.start(t.first),this._signal("tokenizerUpdate",e)},this.$modes={},this.$mode=null,this.$modeId=null,this.setMode=function(e,t){if(e&&"object"==typeof e){if(e.getTokenizer)return this.$onChangeMode(e);var i=e,n=i.path}else n=e||"ace/mode/text";if(this.$modes["ace/mode/text"]||(this.$modes["ace/mode/text"]=new c),this.$modes[n]&&!i)return this.$onChangeMode(this.$modes[n]),void(t&&t());this.$modeId=n,s.loadModule(["mode",n],function(e){if(this.$modeId!==n)return t&&t();this.$modes[n]&&!i?this.$onChangeMode(this.$modes[n]):e&&e.Mode&&(e=new e.Mode(i),i||((this.$modes[n]=e).$id=n),this.$onChangeMode(e)),t&&t()}.bind(this)),this.$mode||this.$onChangeMode(this.$modes["ace/mode/text"],!0)},this.$onChangeMode=function(e,t){if(t||(this.$modeId=e.$id),this.$mode!==e){this.$mode=e,this.$stopWorker(),this.$useWorker&&this.$startWorker();var i=e.getTokenizer();if(void 0!==i.addEventListener){var n=this.onReloadTokenizer.bind(this);i.addEventListener("update",n)}if(this.bgTokenizer)this.bgTokenizer.setTokenizer(i);else{this.bgTokenizer=new u(i);var r=this;this.bgTokenizer.addEventListener("update",function(e){r._signal("tokenizerUpdate",e)})}this.bgTokenizer.setDocument(this.getDocument()),this.tokenRe=e.tokenRe,this.nonTokenRe=e.nonTokenRe,t||(e.attachToSession&&e.attachToSession(this),this.$options.wrapMethod.set.call(this,this.$wrapMethod),this.$setFolding(e.foldingRules),this.bgTokenizer.start(0),this._emit("changeMode"))}},this.$stopWorker=function(){this.$worker&&(this.$worker.terminate(),this.$worker=null)},this.$startWorker=function(){try{this.$worker=this.$mode.createWorker(this)}catch(e){s.warn("Could not load worker",e),this.$worker=null}},this.getMode=function(){return this.$mode},this.$scrollTop=0,this.setScrollTop=function(e){this.$scrollTop===e||isNaN(e)||(this.$scrollTop=e,this._signal("changeScrollTop",e))},this.getScrollTop=function(){return this.$scrollTop},this.$scrollLeft=0,this.setScrollLeft=function(e){this.$scrollLeft===e||isNaN(e)||(this.$scrollLeft=e,this._signal("changeScrollLeft",e))},this.getScrollLeft=function(){return this.$scrollLeft},this.getScreenWidth=function(){return this.$computeWidth(),this.lineWidgets?Math.max(this.getLineWidgetMaxWidth(),this.screenWidth):this.screenWidth},this.getLineWidgetMaxWidth=function(){if(null!=this.lineWidgetsWidth)return this.lineWidgetsWidth;var t=0;return this.lineWidgets.forEach(function(e){e&&e.screenWidth>t&&(t=e.screenWidth)}),this.lineWidgetWidth=t},this.$computeWidth=function(e){if(this.$modified||e){if(this.$modified=!1,this.$useWrapMode)return this.screenWidth=this.$wrapLimit;for(var t=this.doc.getAllLines(),i=this.$rowLengthCache,n=0,r=0,o=this.$foldData[r],s=o?o.start.row:1/0,a=t.length,l=0;l<a;l++){if(s<l){if(a<=(l=o.end.row+1))break;s=(o=this.$foldData[r++])?o.start.row:1/0}null==i[l]&&(i[l]=this.$getStringScreenWidth(t[l])[0]),i[l]>n&&(n=i[l])}this.screenWidth=n}},this.getLine=function(e){return this.doc.getLine(e)},this.getLines=function(e,t){return this.doc.getLines(e,t)},this.getLength=function(){return this.doc.getLength()},this.getTextRange=function(e){return this.doc.getTextRange(e||this.selection.getRange())},this.insert=function(e,t){return this.doc.insert(e,t)},this.remove=function(e){return this.doc.remove(e)},this.removeFullLines=function(e,t){return this.doc.removeFullLines(e,t)},this.undoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var i=null,n=e.length-1;-1!=n;n--){var r=e[n];"doc"==r.group?(this.doc.revertDeltas(r.deltas),i=this.$getUndoSelection(r.deltas,!0,i)):r.deltas.forEach(function(e){this.addFolds(e.folds)},this)}return this.$fromUndo=!1,i&&this.$undoSelect&&!t&&this.selection.setSelectionRange(i),i}},this.redoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var i=null,n=0;n<e.length;n++){var r=e[n];"doc"==r.group&&(this.doc.applyDeltas(r.deltas),i=this.$getUndoSelection(r.deltas,!1,i))}return this.$fromUndo=!1,i&&this.$undoSelect&&!t&&this.selection.setSelectionRange(i),i}},this.setUndoSelect=function(e){this.$undoSelect=e},this.$getUndoSelection=function(e,t,i){function n(e){return t?"insert"!==e.action:"insert"===e.action}var r,o,s=e[0];n(s)?r=h.fromPoints(s.start,s.end):r=h.fromPoints(s.start,s.start);for(var a=1;a<e.length;a++)n(s=e[a])?(o=s.start,-1==r.compare(o.row,o.column)&&r.setStart(o),o=s.end,1==r.compare(o.row,o.column)&&r.setEnd(o),!0):(o=s.start,-1==r.compare(o.row,o.column)&&(r=h.fromPoints(s.start,s.start)),!1);if(null!=i){0===h.comparePoints(i.start,r.start)&&(i.start.column+=r.end.column-r.start.column,i.end.column+=r.end.column-r.start.column);var l=i.compareRange(r);1==l?r.setStart(i.start):-1==l&&r.setEnd(i.end)}return r},this.replace=function(e,t){return this.doc.replace(e,t)},this.moveText=function(e,t,i){var n=this.getTextRange(e),r=this.getFoldsInRange(e),o=h.fromPoints(t,t);if(!i){this.remove(e);var s=e.start.row-e.end.row;(c=s?-e.end.column:e.start.column-e.end.column)&&(o.start.row==e.end.row&&o.start.column>e.end.column&&(o.start.column+=c),o.end.row==e.end.row&&o.end.column>e.end.column&&(o.end.column+=c)),s&&o.start.row>=e.end.row&&(o.start.row+=s,o.end.row+=s)}if(o.end=this.insert(o.start,n),r.length){var a=e.start,l=o.start,c=(s=l.row-a.row,l.column-a.column);this.addFolds(r.map(function(e){return(e=e.clone()).start.row==a.row&&(e.start.column+=c),e.end.row==a.row&&(e.end.column+=c),e.start.row+=s,e.end.row+=s,e}))}return o},this.indentRows=function(e,t,i){i=i.replace(/\t/g,this.getTabString());for(var n=e;n<=t;n++)this.doc.insertInLine({row:n,column:0},i)},this.outdentRows=function(e){for(var t=e.collapseRows(),i=new h(0,0,0,0),n=this.getTabSize(),r=t.start.row;r<=t.end.row;++r){var o=this.getLine(r);i.start.row=r,i.end.row=r;for(var s=0;s<n&&" "==o.charAt(s);++s);s<n&&"\t"==o.charAt(s)?(i.start.column=s,i.end.column=s+1):(i.start.column=0,i.end.column=s),this.remove(i)}},this.$moveLines=function(e,t,i){if(e=this.getRowFoldStart(e),t=this.getRowFoldEnd(t),i<0){if((r=this.getRowFoldStart(e+i))<0)return 0;var n=r-e}else if(0<i){var r;if((r=this.getRowFoldEnd(t+i))>this.doc.getLength()-1)return 0;n=r-t}else{e=this.$clipRowToDocument(e);n=(t=this.$clipRowToDocument(t))-e+1}var o=new h(e,0,t,Number.MAX_VALUE),s=this.getFoldsInRange(o).map(function(e){return(e=e.clone()).start.row+=n,e.end.row+=n,e}),a=0==i?this.doc.getLines(e,t):this.doc.removeFullLines(e,t);return this.doc.insertFullLines(e+n,a),s.length&&this.addFolds(s),n},this.moveLinesUp=function(e,t){return this.$moveLines(e,t,-1)},this.moveLinesDown=function(e,t){return this.$moveLines(e,t,1)},this.duplicateLines=function(e,t){return this.$moveLines(e,t,0)},this.$clipRowToDocument=function(e){return Math.max(0,Math.min(e,this.doc.getLength()-1))},this.$clipColumnToRow=function(e,t){return t<0?0:Math.min(this.doc.getLine(e).length,t)},this.$clipPositionToDocument=function(e,t){if(t=Math.max(0,t),e<0)t=e=0;else{var i=this.doc.getLength();t=i<=e?(e=i-1,this.doc.getLine(i-1).length):Math.min(this.doc.getLine(e).length,t)}return{row:e,column:t}},this.$clipRangeToDocument=function(e){e.start.row<0?(e.start.row=0,e.start.column=0):e.start.column=this.$clipColumnToRow(e.start.row,e.start.column);var t=this.doc.getLength()-1;return e.end.row>t?(e.end.row=t,e.end.column=this.doc.getLine(t).length):e.end.column=this.$clipColumnToRow(e.end.row,e.end.column),e},this.$wrapLimit=80,this.$useWrapMode=!1,this.$wrapLimitRange={min:null,max:null},this.setUseWrapMode=function(e){if(e!=this.$useWrapMode){if(this.$useWrapMode=e,this.$modified=!0,this.$resetRowCache(0),e){var t=this.getLength();this.$wrapData=Array(t),this.$updateWrapData(0,t-1)}this._signal("changeWrapMode")}},this.getUseWrapMode=function(){return this.$useWrapMode},this.setWrapLimitRange=function(e,t){this.$wrapLimitRange.min===e&&this.$wrapLimitRange.max===t||(this.$wrapLimitRange={min:e,max:t},this.$modified=!0,this.$bidiHandler.markAsDirty(),this.$useWrapMode&&this._signal("changeWrapMode"))},this.adjustWrapLimit=function(e,t){var i=this.$wrapLimitRange;i.max<0&&(i={min:t,max:t});var n=this.$constrainWrapLimit(e,i.min,i.max);return n!=this.$wrapLimit&&1<n&&(this.$wrapLimit=n,this.$modified=!0,this.$useWrapMode&&(this.$updateWrapData(0,this.getLength()-1),this.$resetRowCache(0),this._signal("changeWrapLimit")),!0)},this.$constrainWrapLimit=function(e,t,i){return t&&(e=Math.max(t,e)),i&&(e=Math.min(i,e)),e},this.getWrapLimit=function(){return this.$wrapLimit},this.setWrapLimit=function(e){this.setWrapLimitRange(e,e)},this.getWrapLimitRange=function(){return{min:this.$wrapLimitRange.min,max:this.$wrapLimitRange.max}},this.$updateInternalDataOnChange=function(e){var t=this.$useWrapMode,i=e.action,n=e.start,r=e.end,o=n.row,s=r.row,a=s-o,l=null;if(this.$updating=!0,0!=a)if("remove"===i){this[t?"$wrapData":"$rowLengthCache"].splice(o,a);var c=this.$foldData;l=this.getFoldsInRange(e),this.removeFolds(l);var h=0;if(m=this.getFoldLine(r.row)){m.addRemoveChars(r.row,r.column,n.column-r.column),m.shiftRow(-a);var d=this.getFoldLine(o);d&&d!==m&&(d.merge(m),m=d),h=c.indexOf(m)+1}for(;h<c.length;h++){(m=c[h]).start.row>=r.row&&m.shiftRow(-a)}s=o}else{var u=Array(a);u.unshift(o,0);var f=t?this.$wrapData:this.$rowLengthCache;f.splice.apply(f,u);c=this.$foldData,h=0;if(m=this.getFoldLine(o)){var p=m.range.compareInside(n.row,n.column);0==p?(m=m.split(n.row,n.column))&&(m.shiftRow(a),m.addRemoveChars(s,0,r.column-n.column)):-1==p&&(m.addRemoveChars(o,0,r.column-n.column),m.shiftRow(a)),h=c.indexOf(m)+1}for(;h<c.length;h++){var m;(m=c[h]).start.row>=o&&m.shiftRow(a)}}else a=Math.abs(e.start.column-e.end.column),"remove"===i&&(l=this.getFoldsInRange(e),this.removeFolds(l),a=-a),(m=this.getFoldLine(o))&&m.addRemoveChars(o,n.column,a);return t&&this.$wrapData.length!=this.doc.getLength()&&console.error("doc.getLength() and $wrapData.length have to be the same!"),this.$updating=!1,t?this.$updateWrapData(o,s):this.$updateRowLengthCache(o,s),l},this.$updateRowLengthCache=function(e,t,i){this.$rowLengthCache[e]=null,this.$rowLengthCache[t]=null},this.$updateWrapData=function(e,t){var s,i,a=this.doc.getAllLines(),n=this.getTabSize(),r=this.$wrapData,o=this.$wrapLimit,l=e;for(t=Math.min(t,a.length-1);l<=t;)(i=this.getFoldLine(l,i))?(s=[],i.walk(function(e,t,i,n){var r;if(null!=e){(r=this.$getDisplayTokens(e,s.length))[0]=p;for(var o=1;o<r.length;o++)r[o]=m}else r=this.$getDisplayTokens(a[t].substring(n,i),s.length);s=s.concat(r)}.bind(this),i.end.row,a[i.end.row].length+1),r[i.start.row]=this.$computeWrapSplits(s,o,n),l=i.end.row+1):(s=this.$getDisplayTokens(a[l]),r[l]=this.$computeWrapSplits(s,o,n),l++)};var p=3,m=4;function a(e){return!(e<4352)&&(4352<=e&&e<=4447||4515<=e&&e<=4519||4602<=e&&e<=4607||9001<=e&&e<=9002||11904<=e&&e<=11929||11931<=e&&e<=12019||12032<=e&&e<=12245||12272<=e&&e<=12283||12288<=e&&e<=12350||12353<=e&&e<=12438||12441<=e&&e<=12543||12549<=e&&e<=12589||12593<=e&&e<=12686||12688<=e&&e<=12730||12736<=e&&e<=12771||12784<=e&&e<=12830||12832<=e&&e<=12871||12880<=e&&e<=13054||13056<=e&&e<=19903||19968<=e&&e<=42124||42128<=e&&e<=42182||43360<=e&&e<=43388||44032<=e&&e<=55203||55216<=e&&e<=55238||55243<=e&&e<=55291||63744<=e&&e<=64255||65040<=e&&e<=65049||65072<=e&&e<=65106||65108<=e&&e<=65126||65128<=e&&e<=65131||65281<=e&&e<=65376||65504<=e&&e<=65510)}this.$computeWrapSplits=function(n,e,r){if(0==n.length)return[];var o=[],t=n.length,s=0,a=0,l=this.$wrapAsCode,c=this.$indentedSoftWrap,h=e<=Math.max(2*r,8)||!1===c?0:Math.floor(e/2);function i(e){var t=n.slice(s,e),i=t.length;t.join("").replace(/12/g,function(){i-=1}).replace(/2/g,function(){i-=1}),o.length||(d=function(){var e=0;if(0===h)return e;if(c)for(var t=0;t<n.length;t++){var i=n[t];if(10==i)e+=1;else{if(11!=i){if(12==i)continue;break}e+=r}}return l&&!1!==c&&(e+=r),Math.min(e,h)}(),o.indent=d),a+=i,o.push(a),s=e}for(var d=0;e-d<t-s;){var u=s+e-d;if(10<=n[u-1]&&10<=n[u])i(u);else if(n[u]!=p&&n[u]!=m){for(var f=Math.max(u-(e-(e>>2)),s-1);f<u&&n[u]<p;)u--;if(l){for(;f<u&&n[u]<p;)u--;for(;f<u&&9==n[u];)u--}else for(;f<u&&n[u]<10;)u--;f<u?i(++u):(2==n[u=s+e]&&u--,i(u-d))}else{for(;u!=s-1&&n[u]!=p;u--);if(s<u){i(u);continue}for(u=s+e;u<n.length&&n[u]==m;u++);if(u==n.length)break;i(u)}}return o},this.$getDisplayTokens=function(e,t){var i,n=[];t=t||0;for(var r=0;r<e.length;r++){var o=e.charCodeAt(r);if(9==o){i=this.getScreenTabSize(n.length+t),n.push(11);for(var s=1;s<i;s++)n.push(12)}else 32==o?n.push(10):39<o&&o<48||57<o&&o<64?n.push(9):4352<=o&&a(o)?n.push(1,2):n.push(1)}return n},this.$getStringScreenWidth=function(e,t,i){if(0==t)return[0,0];var n,r;for(null==t&&(t=1/0),i=i||0,r=0;r<e.length&&(9==(n=e.charCodeAt(r))?i+=this.getScreenTabSize(i):4352<=n&&a(n)?i+=2:i+=1,!(t<i));r++);return[i,r]},this.lineWidgets=null,this.getRowLength=function(e){if(this.lineWidgets)var t=this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0;else t=0;return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},this.getRowLineCount=function(e){return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1:1},this.getRowWrapIndent=function(e){if(this.$useWrapMode){var t=this.screenToDocumentPosition(e,Number.MAX_VALUE),i=this.$wrapData[t.row];return i.length&&i[0]<t.column?i.indent:0}return 0},this.getScreenLastRowColumn=function(e){var t=this.screenToDocumentPosition(e,Number.MAX_VALUE);return this.documentToScreenColumn(t.row,t.column)},this.getDocumentLastRowColumn=function(e,t){var i=this.documentToScreenRow(e,t);return this.getScreenLastRowColumn(i)},this.getDocumentLastRowColumnPosition=function(e,t){var i=this.documentToScreenRow(e,t);return this.screenToDocumentPosition(i,Number.MAX_VALUE/10)},this.getRowSplitData=function(e){return this.$useWrapMode?this.$wrapData[e]:void 0},this.getScreenTabSize=function(e){return this.$tabSize-e%this.$tabSize},this.screenToDocumentRow=function(e,t){return this.screenToDocumentPosition(e,t).row},this.screenToDocumentColumn=function(e,t){return this.screenToDocumentPosition(e,t).column},this.screenToDocumentPosition=function(e,t,i){if(e<0)return{row:0,column:0};var n,r,o=0,s=0,a=0,l=0,c=this.$screenRowCache,h=this.$getRowCacheIndex(c,e),d=c.length;if(d&&0<=h){a=c[h],o=this.$docRowCache[h];var u=e>c[d-1]}else u=!d;for(var f=this.getLength()-1,p=this.getNextFoldLine(o),m=p?p.start.row:1/0;a<=e&&!(e<a+(l=this.getRowLength(o))||f<=o);)a+=l,m<++o&&(o=p.end.row+1,m=(p=this.getNextFoldLine(o,p))?p.start.row:1/0),u&&(this.$docRowCache.push(o),this.$screenRowCache.push(a));if(p&&p.start.row<=o)n=this.getFoldDisplayLine(p),o=p.start.row;else{if(a+l<=e||f<o)return{row:f,column:this.getLine(f).length};n=this.getLine(o),p=null}var g=0,v=Math.floor(e-a);if(this.$useWrapMode){var y=this.$wrapData[o];y&&(r=y[v],0<v&&y.length&&(g=y.indent,s=y[v-1]||y[y.length-1],n=n.substring(s)))}return void 0!==i&&this.$bidiHandler.isBidiRow(a+v,o,v)&&(t=this.$bidiHandler.offsetToCol(i)),s+=this.$getStringScreenWidth(n,t-g)[1],this.$useWrapMode&&r<=s&&(s=r-1),p?p.idxToPosition(s):{row:o,column:s}},this.documentToScreenPosition=function(e,t){if(void 0===t)var i=this.$clipPositionToDocument(e.row,e.column);else i=this.$clipPositionToDocument(e,t);e=i.row,t=i.column;var n,r=0,o=null;(n=this.getFoldAt(e,t,1))&&(e=n.start.row,t=n.start.column);var s,a=0,l=this.$docRowCache,c=this.$getRowCacheIndex(l,e),h=l.length;if(h&&0<=c){a=l[c],r=this.$screenRowCache[c];var d=e>l[h-1]}else d=!h;for(var u=this.getNextFoldLine(a),f=u?u.start.row:1/0;a<e;){if(f<=a){if(e<(s=u.end.row+1))break;f=(u=this.getNextFoldLine(s,u))?u.start.row:1/0}else s=a+1;r+=this.getRowLength(a),a=s,d&&(this.$docRowCache.push(a),this.$screenRowCache.push(r))}var p="";o=u&&f<=a?(p=this.getFoldDisplayLine(u,e,t),u.start.row):(p=this.getLine(e).substring(0,t),e);var m=0;if(this.$useWrapMode){var g=this.$wrapData[o];if(g){for(var v=0;p.length>=g[v];)r++,v++;p=p.substring(g[v-1]||0,p.length),m=0<v?g.indent:0}}return{row:r,column:m+this.$getStringScreenWidth(p)[0]}},this.documentToScreenColumn=function(e,t){return this.documentToScreenPosition(e,t).column},this.documentToScreenRow=function(e,t){return this.documentToScreenPosition(e,t).row},this.getScreenLength=function(){var e=0,t=null;if(this.$useWrapMode)for(var i=this.$wrapData.length,n=0,r=(a=0,(t=this.$foldData[a++])?t.start.row:1/0);n<i;){var o=this.$wrapData[n];e+=o?o.length+1:1,r<++n&&(n=t.end.row+1,r=(t=this.$foldData[a++])?t.start.row:1/0)}else{e=this.getLength();for(var s=this.$foldData,a=0;a<s.length;a++)e-=(t=s[a]).end.row-t.start.row}return this.lineWidgets&&(e+=this.$getWidgetScreenLength()),e},this.$setFontMetrics=function(o){this.$enableVarChar&&(this.$getStringScreenWidth=function(e,t,i){if(0===t)return[0,0];var n,r;for(t=t||1/0,i=i||0,r=0;r<e.length&&!(t<(i+="\t"===(n=e.charAt(r))?this.getScreenTabSize(i):o.getCharacterWidth(n)));r++);return[i,r]})},this.destroy=function(){this.bgTokenizer&&(this.bgTokenizer.setDocument(null),this.bgTokenizer=null),this.$stopWorker()},this.isFullWidth=a}.call(p.prototype),e("./edit_session/folding").Folding.call(p.prototype),e("./edit_session/bracket_match").BracketMatch.call(p.prototype),s.defineOptions(p.prototype,"session",{wrap:{set:function(e){if(e&&"off"!=e?"free"==e?e=!0:"printMargin"==e?e=-1:"string"==typeof e&&(e=parseInt(e,10)||!1):e=!1,this.$wrap!=e)if(this.$wrap=e){var t="number"==typeof e?e:null;this.setWrapLimitRange(t,t),this.setUseWrapMode(!0)}else this.setUseWrapMode(!1)},get:function(){return this.getUseWrapMode()?-1==this.$wrap?"printMargin":this.getWrapLimitRange().min?this.$wrap:"free":"off"},handlesSet:!0},wrapMethod:{set:function(e){(e="auto"==e?"text"!=this.$mode.type:"text"!=e)!=this.$wrapAsCode&&(this.$wrapAsCode=e,this.$useWrapMode&&(this.$modified=!0,this.$resetRowCache(0),this.$updateWrapData(0,this.getLength()-1)))},initialValue:"auto"},indentedSoftWrap:{initialValue:!0},firstLineNumber:{set:function(){this._signal("changeBreakpoint")},initialValue:1},useWorker:{set:function(e){this.$useWorker=e,this.$stopWorker(),e&&this.$startWorker()},initialValue:!0},useSoftTabs:{initialValue:!0},tabSize:{set:function(e){isNaN(e)||this.$tabSize===e||(this.$modified=!0,this.$rowLengthCache=[],this.$tabSize=e,this._signal("changeTabSize"))},initialValue:4,handlesSet:!0},navigateWithinSoftTabs:{initialValue:!1},overwrite:{set:function(e){this._signal("changeOverwrite")},initialValue:!1},newLineMode:{set:function(e){this.doc.setNewLineMode(e)},get:function(){return this.doc.getNewLineMode()},handlesSet:!0},mode:{set:function(e){this.setMode(e)},get:function(){return this.$modeId}}}),t.EditSession=p}),ace.define("ace/search",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(e,t,i){"use strict";function n(){this.$options={}}var b=e("./lib/lang"),r=e("./lib/oop"),C=e("./range").Range;(function(){this.set=function(e){return r.mixin(this.$options,e),this},this.getOptions=function(){return b.copyObject(this.$options)},this.setOptions=function(e){this.$options=e},this.find=function(e){var r=this.$options,t=this.$matchIterator(e,r);if(!t)return!1;var o=null;return t.forEach(function(e,t,i,n){return o=new C(e,t,i,n),!(t==n&&r.start&&r.start.start&&0!=r.skipCurrent&&o.isEqual(r.start))||(o=null,!1)}),o},this.findAll=function(e){var t=this.$options;if(!t.needle)return[];this.$assembleRegExp(t);var i=t.range,n=i?e.getLines(i.start.row,i.end.row):e.doc.getAllLines(),r=[],o=t.re;if(t.$isMultiLine){var s,a=o.length,l=n.length-a;e:for(var c=o.offset||0;c<=l;c++){for(var h=0;h<a;h++)if(-1==n[c+h].search(o[h]))continue e;var d=n[c],u=n[c+a-1],f=d.length-d.match(o[0])[0].length,p=u.match(o[a-1])[0].length;s&&s.end.row===c&&s.end.column>f||(r.push(s=new C(c,f,c+a-1,p)),2<a&&(c=c+a-2))}}else for(var m=0;m<n.length;m++){var g=b.getMatchOffsets(n[m],o);for(h=0;h<g.length;h++){var v=g[h];r.push(new C(m,v.offset,m,v.offset+v.length))}}if(i){var y=i.start.column,w=i.start.column;for(m=0,h=r.length-1;m<h&&r[m].start.column<y&&r[m].start.row==i.start.row;)m++;for(;m<h&&r[h].end.column>w&&r[h].end.row==i.end.row;)h--;for(r=r.slice(m,h+1),m=0,h=r.length;m<h;m++)r[m].start.row+=i.start.row,r[m].end.row+=i.start.row}return r},this.replace=function(e,t){var i=this.$options,n=this.$assembleRegExp(i);if(i.$isMultiLine)return t;if(n){var r=n.exec(e);if(!r||r[0].length!=e.length)return null;if(t=e.replace(n,t),i.preserveCase){t=t.split("");for(var o=Math.min(e.length,e.length);o--;){var s=e[o];s&&s.toLowerCase()!=s?t[o]=t[o].toUpperCase():t[o]=t[o].toLowerCase()}t=t.join("")}return t}},this.$assembleRegExp=function(e,t){if(e.needle instanceof RegExp)return e.re=e.needle;var i=e.needle;if(!e.needle)return e.re=!1;e.regExp||(i=b.escapeRegExp(i)),e.wholeWord&&(i=function(e,t){function i(e){return/\w/.test(e)||t.regExp?"\\b":""}return i(e[0])+e+i(e[e.length-1])}(i,e));var n=e.caseSensitive?"gm":"gmi";if(e.$isMultiLine=!t&&/[\n\r]/.test(i),e.$isMultiLine)return e.re=this.$assembleMultilineRegExp(i,n);try{var r=new RegExp(i,n)}catch(e){r=!1}return e.re=r},this.$assembleMultilineRegExp=function(e,t){for(var i=e.replace(/\r\n|\r|\n/g,"$\n^").split("\n"),n=[],r=0;r<i.length;r++)try{n.push(new RegExp(i[r],t))}catch(e){return!1}return n},this.$matchIterator=function(h,i){var d=this.$assembleRegExp(i);if(!d)return!1;var l=1==i.backwards,e=0!=i.skipCurrent,t=i.range,n=i.start;(n=n||(t?t[l?"end":"start"]:h.selection.getRange())).start&&(n=n[e!=l?"end":"start"]);var r=t?t.start.row:0,o=t?t.end.row:h.getLength()-1;if(l)var s=function(e){var t=n.row;if(!a(t,n.column,e)){for(t--;r<=t;t--)if(a(t,Number.MAX_VALUE,e))return;if(0!=i.wrap)for(t=o,r=n.row;r<=t;t--)if(a(t,Number.MAX_VALUE,e))return}};else s=function(e){var t=n.row;if(!a(t,n.column,e)){for(t+=1;t<=o;t++)if(a(t,0,e))return;if(0!=i.wrap)for(t=r,o=n.row;t<=o;t++)if(a(t,0,e))return}};if(i.$isMultiLine)var c=d.length,a=function(e,t,i){var n=l?e-c+1:e;if(!(n<0)){var r=h.getLine(n),o=r.search(d[0]);if(!(!l&&o<t||-1===o)){for(var s=1;s<c;s++)if(-1==(r=h.getLine(n+s)).search(d[s]))return;var a=r.match(d[c-1])[0].length;if(!(l&&t<a))return!!i(n,o,n+c-1,a)||void 0}}};else if(l)a=function(e,t,i){var n,r=h.getLine(e),o=[],s=0;for(d.lastIndex=0;n=d.exec(r);){var a=n[0].length;if(s=n.index,!a){if(s>=r.length)break;d.lastIndex=s+=1}if(n.index+a>t)break;o.push(n.index,a)}for(var l=o.length-1;0<=l;l-=2){var c=o[l-1];if(i(e,c,e,c+(a=o[l])))return!0}};else a=function(e,t,i){var n,r=h.getLine(e),o=t;for(d.lastIndex=t;n=d.exec(r);){var s=n[0].length;if(i(e,o=n.index,e,o+s))return!0;if(!s&&(d.lastIndex=o+=1,o>=r.length))return!1}};return{forEach:s}}}).call(n.prototype),t.Search=n}),ace.define("ace/keyboard/hash_handler",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(e,t,i){"use strict";var a=e("../lib/keys"),n=e("../lib/useragent"),l=a.KEY_MODS;function r(e,t){this.platform=t||(n.isMac?"mac":"win"),this.commands={},this.commandKeyBinding={},this.addCommands(e),this.$singleCommand=!0}function o(e,t){r.call(this,e,t),this.$singleCommand=!1}o.prototype=r.prototype,function(){function s(e){return"object"==typeof e&&e.bindKey&&e.bindKey.position||(e.isDefault?-100:0)}this.addCommand=function(e){this.commands[e.name]&&this.removeCommand(e),(this.commands[e.name]=e).bindKey&&this._buildKeyHash(e)},this.removeCommand=function(e,t){var i=e&&("string"==typeof e?e:e.name);e=this.commands[i],t||delete this.commands[i];var n=this.commandKeyBinding;for(var r in n){var o=n[r];if(o==e)delete n[r];else if(Array.isArray(o)){var s=o.indexOf(e);-1!=s&&(o.splice(s,1),1==o.length&&(n[r]=o[0]))}}},this.bindKey=function(e,o,s){if("object"==typeof e&&e&&(null==s&&(s=e.position),e=e[this.platform]),e)return"function"==typeof o?this.addCommand({exec:o,bindKey:e,name:o.name||e}):void e.split("|").forEach(function(e){var n="";if(-1!=e.indexOf(" ")){var t=e.split(/\s+/);e=t.pop(),t.forEach(function(e){var t=this.parseKeys(e),i=l[t.hashId]+t.key;n+=(n?" ":"")+i,this._addCommandToBinding(n,"chainKeys")},this),n+=" "}var i=this.parseKeys(e),r=l[i.hashId]+i.key;this._addCommandToBinding(n+r,o,s)},this)},this._addCommandToBinding=function(e,t,i){var n,r=this.commandKeyBinding;if(t)if(!r[e]||this.$singleCommand)r[e]=t;else{Array.isArray(r[e])?-1!=(n=r[e].indexOf(t))&&r[e].splice(n,1):r[e]=[r[e]],"number"!=typeof i&&(i=s(t));var o=r[e];for(n=0;n<o.length;n++){if(i<s(o[n]))break}o.splice(n,0,t)}else delete r[e]},this.addCommands=function(i){i&&Object.keys(i).forEach(function(e){var t=i[e];if(t){if("string"==typeof t)return this.bindKey(t,e);"function"==typeof t&&(t={exec:t}),"object"==typeof t&&(t.name||(t.name=e),this.addCommand(t))}},this)},this.removeCommands=function(t){Object.keys(t).forEach(function(e){this.removeCommand(t[e])},this)},this.bindKeys=function(t){Object.keys(t).forEach(function(e){this.bindKey(e,t[e])},this)},this._buildKeyHash=function(e){this.bindKey(e.bindKey,e)},this.parseKeys=function(e){var t=e.toLowerCase().split(/[\-\+]([\-\+])?/).filter(function(e){return e}),i=t.pop(),n=a[i];if(a.FUNCTION_KEYS[n])i=a.FUNCTION_KEYS[n].toLowerCase();else{if(!t.length)return{key:i,hashId:-1};if(1==t.length&&"shift"==t[0])return{key:i.toUpperCase(),hashId:-1}}for(var r=0,o=t.length;o--;){var s=a.KEY_MODS[t[o]];if(null==s)return"undefined"!=typeof console&&console.error("invalid modifier "+t[o]+" in "+e),!1;r|=s}return{key:i,hashId:r}},this.findKeyCommand=function(e,t){var i=l[e]+t;return this.commandKeyBinding[i]},this.handleKeyboard=function(e,t,i,n){if(!(n<0)){var r=l[t]+i,o=this.commandKeyBinding[r];return e.$keyChain&&(e.$keyChain+=" "+r,o=this.commandKeyBinding[e.$keyChain]||o),!o||"chainKeys"!=o&&"chainKeys"!=o[o.length-1]?(e.$keyChain&&(t&&4!=t||1!=i.length?(-1==t||0<n)&&(e.$keyChain=""):e.$keyChain=e.$keyChain.slice(0,-r.length-1)),{command:o}):(e.$keyChain=e.$keyChain||r,{command:"null"})}},this.getStatusText=function(e,t){return t.$keyChain||""}}.call(r.prototype),t.HashHandler=r,t.MultiHashHandler=o}),ace.define("ace/commands/command_manager",["require","exports","module","ace/lib/oop","ace/keyboard/hash_handler","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e,t){o.call(this,t,e),this.byName=this.commands,this.setDefaultHandler("exec",function(e){return e.command.exec(e.editor,e.args||{})})}var r=e("../lib/oop"),o=e("../keyboard/hash_handler").MultiHashHandler,s=e("../lib/event_emitter").EventEmitter;r.inherits(n,o),function(){r.implement(this,s),this.exec=function(e,t,i){if(Array.isArray(e)){for(var n=e.length;n--;)if(this.exec(e[n],t,i))return!0;return!1}if("string"==typeof e&&(e=this.commands[e]),!e)return!1;if(t&&t.$readOnly&&!e.readOnly)return!1;if(e.isAvailable&&!e.isAvailable(t))return!1;var r={editor:t,command:e,args:i};return r.returnValue=this._emit("exec",r),this._signal("afterExec",r),!1!==r.returnValue},this.toggleRecording=function(e){if(!this.$inReplay)return e&&e._emit("changeStatus"),this.recording?(this.macro.pop(),this.removeEventListener("exec",this.$addCommandToMacro),this.macro.length||(this.macro=this.oldMacro),this.recording=!1):(this.$addCommandToMacro||(this.$addCommandToMacro=function(e){this.macro.push([e.command,e.args])}.bind(this)),this.oldMacro=this.macro,this.macro=[],this.on("exec",this.$addCommandToMacro),this.recording=!0)},this.replay=function(t){if(!this.$inReplay&&this.macro){if(this.recording)return this.toggleRecording(t);try{this.$inReplay=!0,this.macro.forEach(function(e){"string"==typeof e?this.exec(e,t):this.exec(e[0],t,e[1])},this)}finally{this.$inReplay=!1}}},this.trimMacro=function(e){return e.map(function(e){return"string"!=typeof e[0]&&(e[0]=e[0].name),e[1]||(e=e[0]),e})}}.call(n.prototype),t.CommandManager=n}),ace.define("ace/commands/default_commands",["require","exports","module","ace/lib/lang","ace/config","ace/range"],function(e,t,i){"use strict";var c=e("../lib/lang"),n=e("../config"),h=e("../range").Range;function r(e,t){return{win:e,mac:t}}t.commands=[{name:"showSettingsMenu",bindKey:r("Ctrl-,","Command-,"),exec:function(t){n.loadModule("ace/ext/settings_menu",function(e){e.init(t),t.showSettingsMenu()})},readOnly:!0},{name:"goToNextError",bindKey:r("Alt-E","F4"),exec:function(t){n.loadModule("ace/ext/error_marker",function(e){e.showErrorMarker(t,1)})},scrollIntoView:"animate",readOnly:!0},{name:"goToPreviousError",bindKey:r("Alt-Shift-E","Shift-F4"),exec:function(t){n.loadModule("ace/ext/error_marker",function(e){e.showErrorMarker(t,-1)})},scrollIntoView:"animate",readOnly:!0},{name:"selectall",bindKey:r("Ctrl-A","Command-A"),exec:function(e){e.selectAll()},readOnly:!0},{name:"centerselection",bindKey:r(null,"Ctrl-L"),exec:function(e){e.centerSelection()},readOnly:!0},{name:"gotoline",bindKey:r("Ctrl-L","Command-L"),exec:function(e){var t=parseInt(prompt("Enter line number:"),10);isNaN(t)||e.gotoLine(t)},readOnly:!0},{name:"fold",bindKey:r("Alt-L|Ctrl-F1","Command-Alt-L|Command-F1"),exec:function(e){e.session.toggleFold(!1)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"unfold",bindKey:r("Alt-Shift-L|Ctrl-Shift-F1","Command-Alt-Shift-L|Command-Shift-F1"),exec:function(e){e.session.toggleFold(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleFoldWidget",bindKey:r("F2","F2"),exec:function(e){e.session.toggleFoldWidget()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleParentFoldWidget",bindKey:r("Alt-F2","Alt-F2"),exec:function(e){e.session.toggleFoldWidget(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"foldall",bindKey:r(null,"Ctrl-Command-Option-0"),exec:function(e){e.session.foldAll()},scrollIntoView:"center",readOnly:!0},{name:"foldOther",bindKey:r("Alt-0","Command-Option-0"),exec:function(e){e.session.foldAll(),e.session.unfold(e.selection.getAllRanges())},scrollIntoView:"center",readOnly:!0},{name:"unfoldall",bindKey:r("Alt-Shift-0","Command-Option-Shift-0"),exec:function(e){e.session.unfold()},scrollIntoView:"center",readOnly:!0},{name:"findnext",bindKey:r("Ctrl-K","Command-G"),exec:function(e){e.findNext()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"findprevious",bindKey:r("Ctrl-Shift-K","Command-Shift-G"),exec:function(e){e.findPrevious()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"selectOrFindNext",bindKey:r("Alt-K","Ctrl-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findNext()},readOnly:!0},{name:"selectOrFindPrevious",bindKey:r("Alt-Shift-K","Ctrl-Shift-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findPrevious()},readOnly:!0},{name:"find",bindKey:r("Ctrl-F","Command-F"),exec:function(t){n.loadModule("ace/ext/searchbox",function(e){e.Search(t)})},readOnly:!0},{name:"overwrite",bindKey:"Insert",exec:function(e){e.toggleOverwrite()},readOnly:!0},{name:"selecttostart",bindKey:r("Ctrl-Shift-Home","Command-Shift-Home|Command-Shift-Up"),exec:function(e){e.getSelection().selectFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotostart",bindKey:r("Ctrl-Home","Command-Home|Command-Up"),exec:function(e){e.navigateFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectup",bindKey:r("Shift-Up","Shift-Up|Ctrl-Shift-P"),exec:function(e){e.getSelection().selectUp()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golineup",bindKey:r("Up","Up|Ctrl-P"),exec:function(e,t){e.navigateUp(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttoend",bindKey:r("Ctrl-Shift-End","Command-Shift-End|Command-Shift-Down"),exec:function(e){e.getSelection().selectFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotoend",bindKey:r("Ctrl-End","Command-End|Command-Down"),exec:function(e){e.navigateFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectdown",bindKey:r("Shift-Down","Shift-Down|Ctrl-Shift-N"),exec:function(e){e.getSelection().selectDown()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golinedown",bindKey:r("Down","Down|Ctrl-N"),exec:function(e,t){e.navigateDown(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordleft",bindKey:r("Ctrl-Shift-Left","Option-Shift-Left"),exec:function(e){e.getSelection().selectWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordleft",bindKey:r("Ctrl-Left","Option-Left"),exec:function(e){e.navigateWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolinestart",bindKey:r("Alt-Shift-Left","Command-Shift-Left|Ctrl-Shift-A"),exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolinestart",bindKey:r("Alt-Left|Home","Command-Left|Home|Ctrl-A"),exec:function(e){e.navigateLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectleft",bindKey:r("Shift-Left","Shift-Left|Ctrl-Shift-B"),exec:function(e){e.getSelection().selectLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoleft",bindKey:r("Left","Left|Ctrl-B"),exec:function(e,t){e.navigateLeft(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordright",bindKey:r("Ctrl-Shift-Right","Option-Shift-Right"),exec:function(e){e.getSelection().selectWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordright",bindKey:r("Ctrl-Right","Option-Right"),exec:function(e){e.navigateWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolineend",bindKey:r("Alt-Shift-Right","Command-Shift-Right|Shift-End|Ctrl-Shift-E"),exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolineend",bindKey:r("Alt-Right|End","Command-Right|End|Ctrl-E"),exec:function(e){e.navigateLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectright",bindKey:r("Shift-Right","Shift-Right"),exec:function(e){e.getSelection().selectRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoright",bindKey:r("Right","Right|Ctrl-F"),exec:function(e,t){e.navigateRight(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectpagedown",bindKey:"Shift-PageDown",exec:function(e){e.selectPageDown()},readOnly:!0},{name:"pagedown",bindKey:r(null,"Option-PageDown"),exec:function(e){e.scrollPageDown()},readOnly:!0},{name:"gotopagedown",bindKey:r("PageDown","PageDown|Ctrl-V"),exec:function(e){e.gotoPageDown()},readOnly:!0},{name:"selectpageup",bindKey:"Shift-PageUp",exec:function(e){e.selectPageUp()},readOnly:!0},{name:"pageup",bindKey:r(null,"Option-PageUp"),exec:function(e){e.scrollPageUp()},readOnly:!0},{name:"gotopageup",bindKey:"PageUp",exec:function(e){e.gotoPageUp()},readOnly:!0},{name:"scrollup",bindKey:r("Ctrl-Up",null),exec:function(e){e.renderer.scrollBy(0,-2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"scrolldown",bindKey:r("Ctrl-Down",null),exec:function(e){e.renderer.scrollBy(0,2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"selectlinestart",bindKey:"Shift-Home",exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectlineend",bindKey:"Shift-End",exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"togglerecording",bindKey:r("Ctrl-Alt-E","Command-Option-E"),exec:function(e){e.commands.toggleRecording(e)},readOnly:!0},{name:"replaymacro",bindKey:r("Ctrl-Shift-E","Command-Shift-E"),exec:function(e){e.commands.replay(e)},readOnly:!0},{name:"jumptomatching",bindKey:r("Ctrl-P","Ctrl-P"),exec:function(e){e.jumpToMatching()},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"selecttomatching",bindKey:r("Ctrl-Shift-P","Ctrl-Shift-P"),exec:function(e){e.jumpToMatching(!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"expandToMatching",bindKey:r("Ctrl-Shift-M","Ctrl-Shift-M"),exec:function(e){e.jumpToMatching(!0,!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"passKeysToBrowser",bindKey:r(null,null),exec:function(){},passEvent:!0,readOnly:!0},{name:"copy",exec:function(e){},readOnly:!0},{name:"cut",exec:function(e){var t=e.getSelectionRange();e._emit("cut",t),e.selection.isEmpty()||(e.session.remove(t),e.clearSelection())},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"paste",exec:function(e,t){e.$handlePaste(t)},scrollIntoView:"cursor"},{name:"removeline",bindKey:r("Ctrl-D","Command-D"),exec:function(e){e.removeLines()},scrollIntoView:"cursor",multiSelectAction:"forEachLine"},{name:"duplicateSelection",bindKey:r("Ctrl-Shift-D","Command-Shift-D"),exec:function(e){e.duplicateSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"sortlines",bindKey:r("Ctrl-Alt-S","Command-Alt-S"),exec:function(e){e.sortLines()},scrollIntoView:"selection",multiSelectAction:"forEachLine"},{name:"togglecomment",bindKey:r("Ctrl-/","Command-/"),exec:function(e){e.toggleCommentLines()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"toggleBlockComment",bindKey:r("Ctrl-Shift-/","Command-Shift-/"),exec:function(e){e.toggleBlockComment()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"modifyNumberUp",bindKey:r("Ctrl-Shift-Up","Alt-Shift-Up"),exec:function(e){e.modifyNumber(1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"modifyNumberDown",bindKey:r("Ctrl-Shift-Down","Alt-Shift-Down"),exec:function(e){e.modifyNumber(-1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"replace",bindKey:r("Ctrl-H","Command-Option-F"),exec:function(t){n.loadModule("ace/ext/searchbox",function(e){e.Search(t,!0)})}},{name:"undo",bindKey:r("Ctrl-Z","Command-Z"),exec:function(e){e.undo()}},{name:"redo",bindKey:r("Ctrl-Shift-Z|Ctrl-Y","Command-Shift-Z|Command-Y"),exec:function(e){e.redo()}},{name:"copylinesup",bindKey:r("Alt-Shift-Up","Command-Option-Up"),exec:function(e){e.copyLinesUp()},scrollIntoView:"cursor"},{name:"movelinesup",bindKey:r("Alt-Up","Option-Up"),exec:function(e){e.moveLinesUp()},scrollIntoView:"cursor"},{name:"copylinesdown",bindKey:r("Alt-Shift-Down","Command-Option-Down"),exec:function(e){e.copyLinesDown()},scrollIntoView:"cursor"},{name:"movelinesdown",bindKey:r("Alt-Down","Option-Down"),exec:function(e){e.moveLinesDown()},scrollIntoView:"cursor"},{name:"del",bindKey:r("Delete","Delete|Ctrl-D|Shift-Delete"),exec:function(e){e.remove("right")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"backspace",bindKey:r("Shift-Backspace|Backspace","Ctrl-Backspace|Shift-Backspace|Backspace|Ctrl-H"),exec:function(e){e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"cut_or_delete",bindKey:r("Shift-Delete",null),exec:function(e){if(!e.selection.isEmpty())return!1;e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestart",bindKey:r("Alt-Backspace","Command-Backspace"),exec:function(e){e.removeToLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineend",bindKey:r("Alt-Delete","Ctrl-K|Command-Delete"),exec:function(e){e.removeToLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestarthard",bindKey:r("Ctrl-Shift-Backspace",null),exec:function(e){var t=e.selection.getRange();t.start.column=0,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineendhard",bindKey:r("Ctrl-Shift-Delete",null),exec:function(e){var t=e.selection.getRange();t.end.column=Number.MAX_VALUE,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordleft",bindKey:r("Ctrl-Backspace","Alt-Backspace|Ctrl-Alt-Backspace"),exec:function(e){e.removeWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordright",bindKey:r("Ctrl-Delete","Alt-Delete"),exec:function(e){e.removeWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"outdent",bindKey:r("Shift-Tab","Shift-Tab"),exec:function(e){e.blockOutdent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"indent",bindKey:r("Tab","Tab"),exec:function(e){e.indent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"blockoutdent",bindKey:r("Ctrl-[","Ctrl-["),exec:function(e){e.blockOutdent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"blockindent",bindKey:r("Ctrl-]","Ctrl-]"),exec:function(e){e.blockIndent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"insertstring",exec:function(e,t){e.insert(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"inserttext",exec:function(e,t){e.insert(c.stringRepeat(t.text||"",t.times||1))},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"splitline",bindKey:r(null,"Ctrl-O"),exec:function(e){e.splitLine()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"transposeletters",bindKey:r("Alt-Shift-X","Ctrl-T"),exec:function(e){e.transposeLetters()},multiSelectAction:function(e){e.transposeSelections(1)},scrollIntoView:"cursor"},{name:"touppercase",bindKey:r("Ctrl-U","Ctrl-U"),exec:function(e){e.toUpperCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"tolowercase",bindKey:r("Ctrl-Shift-U","Ctrl-Shift-U"),exec:function(e){e.toLowerCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"expandtoline",bindKey:r("Ctrl-Shift-L","Command-Shift-L"),exec:function(e){var t=e.selection.getRange();t.start.column=t.end.column=0,t.end.row++,e.selection.setRange(t,!1)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"joinlines",bindKey:r(null,null),exec:function(e){for(var t=e.selection.isBackwards(),i=t?e.selection.getSelectionLead():e.selection.getSelectionAnchor(),n=t?e.selection.getSelectionAnchor():e.selection.getSelectionLead(),r=e.session.doc.getLine(i.row).length,o=e.session.doc.getTextRange(e.selection.getRange()).replace(/\n\s*/," ").length,s=e.session.doc.getLine(i.row),a=i.row+1;a<=n.row+1;a++){var l=c.stringTrimLeft(c.stringTrimRight(e.session.doc.getLine(a)));0!==l.length&&(l=" "+l),s+=l}n.row+1<e.session.doc.getLength()-1&&(s+=e.session.doc.getNewLineCharacter()),e.clearSelection(),e.session.doc.replace(new h(i.row,0,n.row+2,0),s),0<o?(e.selection.moveCursorTo(i.row,i.column),e.selection.selectTo(i.row,i.column+o)):(r=e.session.doc.getLine(i.row).length>r?r+1:r,e.selection.moveCursorTo(i.row,r))},multiSelectAction:"forEach",readOnly:!0},{name:"invertSelection",bindKey:r(null,null),exec:function(e){var t=e.session.doc.getLength()-1,i=e.session.doc.getLine(t).length,n=e.selection.rangeList.ranges,r=[];n.length<1&&(n=[e.selection.getRange()]);for(var o=0;o<n.length;o++)o==n.length-1&&(n[o].end.row===t&&n[o].end.column===i||r.push(new h(n[o].end.row,n[o].end.column,t,i))),0===o?0===n[o].start.row&&0===n[o].start.column||r.push(new h(0,0,n[o].start.row,n[o].start.column)):r.push(new h(n[o-1].end.row,n[o-1].end.column,n[o].start.row,n[o].start.column));e.exitMultiSelectMode(),e.clearSelection();for(o=0;o<r.length;o++)e.selection.addRange(r[o],!1)},readOnly:!0,scrollIntoView:"none"}]}),ace.define("ace/editor",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/keyboard/textinput","ace/mouse/mouse_handler","ace/mouse/fold_handler","ace/keyboard/keybinding","ace/edit_session","ace/search","ace/range","ace/lib/event_emitter","ace/commands/command_manager","ace/commands/default_commands","ace/config","ace/token_iterator"],function(e,t,i){"use strict";e("./lib/fixoldbrowsers");var o=e("./lib/oop"),n=e("./lib/dom"),h=e("./lib/lang"),r=e("./lib/useragent"),s=e("./keyboard/textinput").TextInput,a=e("./mouse/mouse_handler").MouseHandler,l=e("./mouse/fold_handler").FoldHandler,c=e("./keyboard/keybinding").KeyBinding,d=e("./edit_session").EditSession,u=e("./search").Search,m=e("./range").Range,f=e("./lib/event_emitter").EventEmitter,p=e("./commands/command_manager").CommandManager,g=e("./commands/default_commands").commands,v=e("./config"),y=e("./token_iterator").TokenIterator,w=function(e,t){var i=e.getContainerElement();this.container=i,this.renderer=e,this.id="editor"+ ++w.$uid,this.commands=new p(r.isMac?"mac":"win",g),"object"==typeof document&&(this.textInput=new s(e.getTextAreaContainer(),this),this.renderer.textarea=this.textInput.getElement(),this.$mouseHandler=new a(this),new l(this)),this.keyBinding=new c(this),this.$blockScrolling=0,this.$search=(new u).set({wrap:!0}),this.$historyTracker=this.$historyTracker.bind(this),this.commands.on("exec",this.$historyTracker),this.$initOperationListeners(),this._$emitInputEvent=h.delayedCall(function(){this._signal("input",{}),this.session&&this.session.bgTokenizer&&this.session.bgTokenizer.scheduleStart()}.bind(this)),this.on("change",function(e,t){t._$emitInputEvent.schedule(31)}),this.setSession(t||new d("")),v.resetOptions(this),v._signal("editor",this)};w.$uid=0,function(){o.implement(this,f),this.$initOperationListeners=function(){this.selections=[],this.commands.on("exec",this.startOperation.bind(this),!0),this.commands.on("afterExec",this.endOperation.bind(this),!0),this.$opResetTimer=h.delayedCall(this.endOperation.bind(this)),this.on("change",function(){this.curOp||this.startOperation(),this.curOp.docChanged=!0}.bind(this),!0),this.on("changeSelection",function(){this.curOp||this.startOperation(),this.curOp.selectionChanged=!0}.bind(this),!0)},this.curOp=null,this.prevOp={},this.startOperation=function(e){if(this.curOp){if(!e||this.curOp.command)return;this.prevOp=this.curOp}e||(this.previousCommand=null,e={}),this.$opResetTimer.schedule(),this.curOp={command:e.command||{},args:e.args,scrollTop:this.renderer.scrollTop},this.curOp.command.name&&void 0!==this.curOp.command.scrollIntoView&&this.$blockScrolling++},this.endOperation=function(e){if(this.curOp){if(e&&!1===e.returnValue)return this.curOp=null;this._signal("beforeEndOperation");var t=this.curOp.command;t.name&&0<this.$blockScrolling&&this.$blockScrolling--;var i=t&&t.scrollIntoView;if(i){switch(i){case"center-animate":i="animate";case"center":this.renderer.scrollCursorIntoView(null,.5);break;case"animate":case"cursor":this.renderer.scrollCursorIntoView();break;case"selectionPart":var n=this.selection.getRange(),r=this.renderer.layerConfig;(n.start.row>=r.lastRow||n.end.row<=r.firstRow)&&this.renderer.scrollSelectionIntoView(this.selection.anchor,this.selection.lead)}"animate"==i&&this.renderer.animateScrolling(this.curOp.scrollTop)}this.prevOp=this.curOp,this.curOp=null}},this.$mergeableCommands=["backspace","del","insertstring"],this.$historyTracker=function(e){if(this.$mergeUndoDeltas){var t=this.prevOp,i=this.$mergeableCommands,n=t.command&&e.command.name==t.command.name;if("insertstring"==e.command.name){var r=e.args;void 0===this.mergeNextCommand&&(this.mergeNextCommand=!0),n=n&&this.mergeNextCommand&&(!/\s/.test(r)||/\s/.test(t.args)),this.mergeNextCommand=!0}else n=n&&-1!==i.indexOf(e.command.name);"always"!=this.$mergeUndoDeltas&&2e3<Date.now()-this.sequenceStartTime&&(n=!1),n?this.session.mergeUndoDeltas=!0:-1!==i.indexOf(e.command.name)&&(this.sequenceStartTime=Date.now())}},this.setKeyboardHandler=function(t,i){if(t&&"string"==typeof t){this.$keybindingId=t;var n=this;v.loadModule(["keybinding",t],function(e){n.$keybindingId==t&&n.keyBinding.setKeyboardHandler(e&&e.handler),i&&i()})}else this.$keybindingId=null,this.keyBinding.setKeyboardHandler(t),i&&i()},this.getKeyboardHandler=function(){return this.keyBinding.getKeyboardHandler()},this.setSession=function(e){if(this.session!=e){this.curOp&&this.endOperation(),this.curOp={};var t=this.session;if(t){this.session.off("change",this.$onDocumentChange),this.session.off("changeMode",this.$onChangeMode),this.session.off("tokenizerUpdate",this.$onTokenizerUpdate),this.session.off("changeTabSize",this.$onChangeTabSize),this.session.off("changeWrapLimit",this.$onChangeWrapLimit),this.session.off("changeWrapMode",this.$onChangeWrapMode),this.session.off("changeFold",this.$onChangeFold),this.session.off("changeFrontMarker",this.$onChangeFrontMarker),this.session.off("changeBackMarker",this.$onChangeBackMarker),this.session.off("changeBreakpoint",this.$onChangeBreakpoint),this.session.off("changeAnnotation",this.$onChangeAnnotation),this.session.off("changeOverwrite",this.$onCursorChange),this.session.off("changeScrollTop",this.$onScrollTopChange),this.session.off("changeScrollLeft",this.$onScrollLeftChange);var i=this.session.getSelection();i.off("changeCursor",this.$onCursorChange),i.off("changeSelection",this.$onSelectionChange)}(this.session=e)?(this.$onDocumentChange=this.onDocumentChange.bind(this),e.on("change",this.$onDocumentChange),this.renderer.setSession(e),this.$onChangeMode=this.onChangeMode.bind(this),e.on("changeMode",this.$onChangeMode),this.$onTokenizerUpdate=this.onTokenizerUpdate.bind(this),e.on("tokenizerUpdate",this.$onTokenizerUpdate),this.$onChangeTabSize=this.renderer.onChangeTabSize.bind(this.renderer),e.on("changeTabSize",this.$onChangeTabSize),this.$onChangeWrapLimit=this.onChangeWrapLimit.bind(this),e.on("changeWrapLimit",this.$onChangeWrapLimit),this.$onChangeWrapMode=this.onChangeWrapMode.bind(this),e.on("changeWrapMode",this.$onChangeWrapMode),this.$onChangeFold=this.onChangeFold.bind(this),e.on("changeFold",this.$onChangeFold),this.$onChangeFrontMarker=this.onChangeFrontMarker.bind(this),this.session.on("changeFrontMarker",this.$onChangeFrontMarker),this.$onChangeBackMarker=this.onChangeBackMarker.bind(this),this.session.on("changeBackMarker",this.$onChangeBackMarker),this.$onChangeBreakpoint=this.onChangeBreakpoint.bind(this),this.session.on("changeBreakpoint",this.$onChangeBreakpoint),this.$onChangeAnnotation=this.onChangeAnnotation.bind(this),this.session.on("changeAnnotation",this.$onChangeAnnotation),this.$onCursorChange=this.onCursorChange.bind(this),this.session.on("changeOverwrite",this.$onCursorChange),this.$onScrollTopChange=this.onScrollTopChange.bind(this),this.session.on("changeScrollTop",this.$onScrollTopChange),this.$onScrollLeftChange=this.onScrollLeftChange.bind(this),this.session.on("changeScrollLeft",this.$onScrollLeftChange),this.selection=e.getSelection(),this.selection.on("changeCursor",this.$onCursorChange),this.$onSelectionChange=this.onSelectionChange.bind(this),this.selection.on("changeSelection",this.$onSelectionChange),this.onChangeMode(),this.$blockScrolling+=1,this.onCursorChange(),this.$blockScrolling-=1,this.onScrollTopChange(),this.onScrollLeftChange(),this.onSelectionChange(),this.onChangeFrontMarker(),this.onChangeBackMarker(),this.onChangeBreakpoint(),this.onChangeAnnotation(),this.session.getUseWrapMode()&&this.renderer.adjustWrapLimit(),this.renderer.updateFull()):(this.selection=null,this.renderer.setSession(e)),this._signal("changeSession",{session:e,oldSession:t}),this.curOp=null,t&&t._signal("changeEditor",{oldEditor:this}),e&&e._signal("changeEditor",{editor:this}),e&&e.bgTokenizer&&e.bgTokenizer.scheduleStart()}},this.getSession=function(){return this.session},this.setValue=function(e,t){return this.session.doc.setValue(e),t?1==t?this.navigateFileEnd():-1==t&&this.navigateFileStart():this.selectAll(),e},this.getValue=function(){return this.session.getValue()},this.getSelection=function(){return this.selection},this.resize=function(e){this.renderer.onResize(e)},this.setTheme=function(e,t){this.renderer.setTheme(e,t)},this.getTheme=function(){return this.renderer.getTheme()},this.setStyle=function(e){this.renderer.setStyle(e)},this.unsetStyle=function(e){this.renderer.unsetStyle(e)},this.getFontSize=function(){return this.getOption("fontSize")||n.computedStyle(this.container,"fontSize")},this.setFontSize=function(e){this.setOption("fontSize",e)},this.$highlightBrackets=function(){if(this.session.$bracketHighlight&&(this.session.removeMarker(this.session.$bracketHighlight),this.session.$bracketHighlight=null),!this.$highlightPending){var n=this;this.$highlightPending=!0,setTimeout(function(){n.$highlightPending=!1;var e=n.session;if(e&&e.bgTokenizer){var t=e.findMatchingBracket(n.getCursorPosition());if(t)var i=new m(t.row,t.column,t.row,t.column+1);else if(e.$mode.getMatching)i=e.$mode.getMatching(n.session);i&&(e.$bracketHighlight=e.addMarker(i,"ace_bracket","text"))}},50)}},this.$highlightTags=function(){if(!this.$highlightTagPending){var d=this;this.$highlightTagPending=!0,setTimeout(function(){d.$highlightTagPending=!1;var e=d.session;if(e&&e.bgTokenizer){var t=d.getCursorPosition(),i=new y(d.session,t.row,t.column),n=i.getCurrentToken();if(!n||!/\b(?:tag-open|tag-name)/.test(n.type))return e.removeMarker(e.$tagHighlight),void(e.$tagHighlight=null);if(-1==n.type.indexOf("tag-open")||(n=i.stepForward())){var r=n.value,o=0,s=i.stepBackward();if("<"==s.value)for(;s=n,(n=i.stepForward())&&n.value===r&&-1!==n.type.indexOf("tag-name")&&("<"===s.value?o++:"</"===s.value&&o--),n&&0<=o;);else{for(;n=s,s=i.stepBackward(),n&&n.value===r&&-1!==n.type.indexOf("tag-name")&&("<"===s.value?o++:"</"===s.value&&o--),s&&o<=0;);i.stepForward()}if(!n)return e.removeMarker(e.$tagHighlight),void(e.$tagHighlight=null);var a=i.getCurrentTokenRow(),l=i.getCurrentTokenColumn(),c=new m(a,l,a,l+n.value.length),h=e.$backMarkers[e.$tagHighlight];e.$tagHighlight&&null!=h&&0!==c.compareRange(h.range)&&(e.removeMarker(e.$tagHighlight),e.$tagHighlight=null),c&&!e.$tagHighlight&&(e.$tagHighlight=e.addMarker(c,"ace_bracket","text"))}}},50)}},this.focus=function(){var e=this;setTimeout(function(){e.textInput.focus()}),this.textInput.focus()},this.isFocused=function(){return this.textInput.isFocused()},this.blur=function(){this.textInput.blur()},this.onFocus=function(e){this.$isFocused||(this.$isFocused=!0,this.renderer.showCursor(),this.renderer.visualizeFocus(),this._emit("focus",e))},this.onBlur=function(e){this.$isFocused&&(this.$isFocused=!1,this.renderer.hideCursor(),this.renderer.visualizeBlur(),this._emit("blur",e))},this.$cursorChange=function(){this.renderer.updateCursor()},this.onDocumentChange=function(e){var t=this.session.$useWrapMode,i=e.start.row==e.end.row?e.end.row:1/0;this.renderer.updateLines(e.start.row,i,t),this._signal("change",e),this.$cursorChange(),this.$updateHighlightActiveLine()},this.onTokenizerUpdate=function(e){var t=e.data;this.renderer.updateLines(t.first,t.last)},this.onScrollTopChange=function(){this.renderer.scrollToY(this.session.getScrollTop())},this.onScrollLeftChange=function(){this.renderer.scrollToX(this.session.getScrollLeft())},this.onCursorChange=function(){this.$cursorChange(),this.$blockScrolling||(v.warn("Automatically scrolling cursor into view after selection change","this will be disabled in the next version","set editor.$blockScrolling = Infinity to disable this message"),this.renderer.scrollCursorIntoView()),this.$highlightBrackets(),this.$highlightTags(),this.$updateHighlightActiveLine(),this._signal("changeSelection")},this.$updateHighlightActiveLine=function(){var e,t=this.getSession();if(this.$highlightActiveLine&&("line"==this.$selectionStyle&&this.selection.isMultiLine()||(e=this.getCursorPosition()),!this.renderer.$maxLines||1!==this.session.getLength()||1<this.renderer.$minLines||(e=!1)),t.$highlightLineMarker&&!e)t.removeMarker(t.$highlightLineMarker.id),t.$highlightLineMarker=null;else if(!t.$highlightLineMarker&&e){var i=new m(e.row,e.column,e.row,1/0);i.id=t.addMarker(i,"ace_active-line","screenLine"),t.$highlightLineMarker=i}else e&&(t.$highlightLineMarker.start.row=e.row,t.$highlightLineMarker.end.row=e.row,t.$highlightLineMarker.start.column=e.column,t._signal("changeBackMarker"))},this.onSelectionChange=function(e){var t=this.session;if(t.$selectionMarker&&t.removeMarker(t.$selectionMarker),t.$selectionMarker=null,this.selection.isEmpty())this.$updateHighlightActiveLine();else{var i=this.selection.getRange(),n=this.getSelectionStyle();t.$selectionMarker=t.addMarker(i,"ace_selection",n)}var r=this.$highlightSelectedWord&&this.$getSelectionHighLightRegexp();this.session.highlight(r),this._signal("changeSelection")},this.$getSelectionHighLightRegexp=function(){var e=this.session,t=this.getSelectionRange();if(!t.isEmpty()&&!t.isMultiLine()){var i=t.start.column-1,n=t.end.column+1,r=e.getLine(t.start.row),o=r.length,s=r.substring(Math.max(i,0),Math.min(n,o));if(!(0<=i&&/^[\w\d]/.test(s)||n<=o&&/[\w\d]$/.test(s)))if(s=r.substring(t.start.column,t.end.column),/^[\w\d]+$/.test(s))return this.$search.$assembleRegExp({wholeWord:!0,caseSensitive:!0,needle:s})}},this.onChangeFrontMarker=function(){this.renderer.updateFrontMarkers()},this.onChangeBackMarker=function(){this.renderer.updateBackMarkers()},this.onChangeBreakpoint=function(){this.renderer.updateBreakpoints()},this.onChangeAnnotation=function(){this.renderer.setAnnotations(this.session.getAnnotations())},this.onChangeMode=function(e){this.renderer.updateText(),this._emit("changeMode",e)},this.onChangeWrapLimit=function(){this.renderer.updateFull()},this.onChangeWrapMode=function(){this.renderer.onResize(!0)},this.onChangeFold=function(){this.$updateHighlightActiveLine(),this.renderer.updateFull()},this.getSelectedText=function(){return this.session.getTextRange(this.getSelectionRange())},this.getCopyText=function(){var e=this.getSelectedText();return this._signal("copy",e),e},this.onCopy=function(){this.commands.exec("copy",this)},this.onCut=function(){this.commands.exec("cut",this)},this.onPaste=function(e,t){var i={text:e,event:t};this.commands.exec("paste",this,i)},this.$handlePaste=function(e){"string"==typeof e&&(e={text:e}),this._signal("paste",e);var t=e.text;if(!this.inMultiSelectMode||this.inVirtualSelectionMode)this.insert(t);else{var i=t.split(/\r\n|\r|\n/),n=this.selection.rangeList.ranges;if(i.length>n.length||i.length<2||!i[1])return this.commands.exec("insertstring",this,t);for(var r=n.length;r--;){var o=n[r];o.isEmpty()||this.session.remove(o),this.session.insert(o.start,i[r])}}},this.execCommand=function(e,t){return this.commands.exec(e,this,t)},this.insert=function(e,t){var i=this.session,n=i.getMode(),r=this.getCursorPosition();if(this.getBehavioursEnabled()&&!t){var o=n.transformAction(i.getState(r.row),"insertion",this,i,e);o&&(e!==o.text&&(this.session.mergeUndoDeltas=!1,this.$mergeNextCommand=!1),e=o.text)}if("\t"==e&&(e=this.session.getTabString()),this.selection.isEmpty()){if(this.session.getOverwrite()&&-1==e.indexOf("\n")){(s=new m.fromPoints(r,r)).end.column+=e.length,this.session.remove(s)}}else{var s=this.getSelectionRange();r=this.session.remove(s),this.clearSelection()}if("\n"==e||"\r\n"==e){var a=i.getLine(r.row);if(r.column>a.search(/\S|$/)){var l=a.substr(r.column).search(/\S|$/);i.doc.removeInLine(r.row,r.column,r.column+l)}}this.clearSelection();var c=r.column,h=i.getState(r.row),d=(a=i.getLine(r.row),n.checkOutdent(h,a,e));i.insert(r,e);if(o&&o.selection&&(2==o.selection.length?this.selection.setSelectionRange(new m(r.row,c+o.selection[0],r.row,c+o.selection[1])):this.selection.setSelectionRange(new m(r.row+o.selection[0],o.selection[1],r.row+o.selection[2],o.selection[3]))),i.getDocument().isNewLine(e)){var u=n.getNextLineIndent(h,a.slice(0,r.column),i.getTabString());i.insert({row:r.row+1,column:0},u)}d&&n.autoOutdent(h,i,r.row)},this.onTextInput=function(e){this.keyBinding.onTextInput(e)},this.onCommandKey=function(e,t,i){this.keyBinding.onCommandKey(e,t,i)},this.setOverwrite=function(e){
this.session.setOverwrite(e)},this.getOverwrite=function(){return this.session.getOverwrite()},this.toggleOverwrite=function(){this.session.toggleOverwrite()},this.setScrollSpeed=function(e){this.setOption("scrollSpeed",e)},this.getScrollSpeed=function(){return this.getOption("scrollSpeed")},this.setDragDelay=function(e){this.setOption("dragDelay",e)},this.getDragDelay=function(){return this.getOption("dragDelay")},this.setSelectionStyle=function(e){this.setOption("selectionStyle",e)},this.getSelectionStyle=function(){return this.getOption("selectionStyle")},this.setHighlightActiveLine=function(e){this.setOption("highlightActiveLine",e)},this.getHighlightActiveLine=function(){return this.getOption("highlightActiveLine")},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.setHighlightSelectedWord=function(e){this.setOption("highlightSelectedWord",e)},this.getHighlightSelectedWord=function(){return this.$highlightSelectedWord},this.setAnimatedScroll=function(e){this.renderer.setAnimatedScroll(e)},this.getAnimatedScroll=function(){return this.renderer.getAnimatedScroll()},this.setShowInvisibles=function(e){this.renderer.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.renderer.getShowInvisibles()},this.setDisplayIndentGuides=function(e){this.renderer.setDisplayIndentGuides(e)},this.getDisplayIndentGuides=function(){return this.renderer.getDisplayIndentGuides()},this.setShowPrintMargin=function(e){this.renderer.setShowPrintMargin(e)},this.getShowPrintMargin=function(){return this.renderer.getShowPrintMargin()},this.setPrintMarginColumn=function(e){this.renderer.setPrintMarginColumn(e)},this.getPrintMarginColumn=function(){return this.renderer.getPrintMarginColumn()},this.setReadOnly=function(e){this.setOption("readOnly",e)},this.getReadOnly=function(){return this.getOption("readOnly")},this.setBehavioursEnabled=function(e){this.setOption("behavioursEnabled",e)},this.getBehavioursEnabled=function(){return this.getOption("behavioursEnabled")},this.setWrapBehavioursEnabled=function(e){this.setOption("wrapBehavioursEnabled",e)},this.getWrapBehavioursEnabled=function(){return this.getOption("wrapBehavioursEnabled")},this.setShowFoldWidgets=function(e){this.setOption("showFoldWidgets",e)},this.getShowFoldWidgets=function(){return this.getOption("showFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.remove=function(e){this.selection.isEmpty()&&("left"==e?this.selection.selectLeft():this.selection.selectRight());var t=this.getSelectionRange();if(this.getBehavioursEnabled()){var i=this.session,n=i.getState(t.start.row),r=i.getMode().transformAction(n,"deletion",this,i,t);if(0===t.end.column){var o=i.getTextRange(t);if("\n"==o[o.length-1]){var s=i.getLine(t.end.row);/^\s+$/.test(s)&&(t.end.column=s.length)}}r&&(t=r)}this.session.remove(t),this.clearSelection()},this.removeWordRight=function(){this.selection.isEmpty()&&this.selection.selectWordRight(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeWordLeft=function(){this.selection.isEmpty()&&this.selection.selectWordLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineStart=function(){this.selection.isEmpty()&&this.selection.selectLineStart(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineEnd=function(){this.selection.isEmpty()&&this.selection.selectLineEnd();var e=this.getSelectionRange();e.start.column==e.end.column&&e.start.row==e.end.row&&(e.end.column=0,e.end.row++),this.session.remove(e),this.clearSelection()},this.splitLine=function(){this.selection.isEmpty()||(this.session.remove(this.getSelectionRange()),this.clearSelection());var e=this.getCursorPosition();this.insert("\n"),this.moveCursorToPosition(e)},this.transposeLetters=function(){if(this.selection.isEmpty()){var e=this.getCursorPosition(),t=e.column;if(0!==t){var i,n,r=this.session.getLine(e.row);n=t<r.length?(i=r.charAt(t)+r.charAt(t-1),new m(e.row,t-1,e.row,t+1)):(i=r.charAt(t-1)+r.charAt(t-2),new m(e.row,t-2,e.row,t)),this.session.replace(n,i),this.session.selection.moveToPosition(n.end)}}},this.toLowerCase=function(){var e=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var t=this.getSelectionRange(),i=this.session.getTextRange(t);this.session.replace(t,i.toLowerCase()),this.selection.setSelectionRange(e)},this.toUpperCase=function(){var e=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var t=this.getSelectionRange(),i=this.session.getTextRange(t);this.session.replace(t,i.toUpperCase()),this.selection.setSelectionRange(e)},this.indent=function(){var e=this.session,t=this.getSelectionRange();if(!(t.start.row<t.end.row)){if(t.start.column<t.end.column){var i=e.getTextRange(t);if(!/^\s+$/.test(i)){c=this.$getSelectedRows();return void e.indentRows(c.first,c.last,"\t")}}var n=e.getLine(t.start.row),r=t.start,o=e.getTabSize(),s=e.documentToScreenColumn(r.row,r.column);if(this.session.getUseSoftTabs())var a=o-s%o,l=h.stringRepeat(" ",a);else{for(a=s%o;" "==n[t.start.column-1]&&a;)t.start.column--,a--;this.selection.setSelectionRange(t),l="\t"}return this.insert(l)}var c=this.$getSelectedRows();e.indentRows(c.first,c.last,"\t")},this.blockIndent=function(){var e=this.$getSelectedRows();this.session.indentRows(e.first,e.last,"\t")},this.blockOutdent=function(){var e=this.session.getSelection();this.session.outdentRows(e.getRange())},this.sortLines=function(){for(var e=this.$getSelectedRows(),t=this.session,i=[],n=e.first;n<=e.last;n++)i.push(t.getLine(n));i.sort(function(e,t){return e.toLowerCase()<t.toLowerCase()?-1:e.toLowerCase()>t.toLowerCase()?1:0});var r=new m(0,0,0,0);for(n=e.first;n<=e.last;n++){var o=t.getLine(n);r.start.row=n,r.end.row=n,r.end.column=o.length,t.replace(r,i[n-e.first])}},this.toggleCommentLines=function(){var e=this.session.getState(this.getCursorPosition().row),t=this.$getSelectedRows();this.session.getMode().toggleCommentLines(e,this.session,t.first,t.last)},this.toggleBlockComment=function(){var e=this.getCursorPosition(),t=this.session.getState(e.row),i=this.getSelectionRange();this.session.getMode().toggleBlockComment(t,this.session,i,e)},this.getNumberAt=function(e,t){var i=/[\-]?[0-9]+(?:\.[0-9]+)?/g;i.lastIndex=0;for(var n=this.session.getLine(e);i.lastIndex<t;){var r=i.exec(n);if(r.index<=t&&r.index+r[0].length>=t)return{value:r[0],start:r.index,end:r.index+r[0].length}}return null},this.modifyNumber=function(e){var t=this.selection.getCursor().row,i=this.selection.getCursor().column,n=new m(t,i-1,t,i),r=this.session.getTextRange(n);if(!isNaN(parseFloat(r))&&isFinite(r)){var o=this.getNumberAt(t,i);if(o){var s=0<=o.value.indexOf(".")?o.start+o.value.indexOf(".")+1:o.end,a=o.start+o.value.length-s,l=parseFloat(o.value);l*=Math.pow(10,a),s!==o.end&&i<s?e*=Math.pow(10,o.end-i-1):e*=Math.pow(10,o.end-i),l+=e;var c=(l/=Math.pow(10,a)).toFixed(a),h=new m(t,o.start,t,o.end);this.session.replace(h,c),this.moveCursorTo(t,Math.max(o.start+1,i+c.length-o.value.length))}}},this.removeLines=function(){var e=this.$getSelectedRows();this.session.removeFullLines(e.first,e.last),this.clearSelection()},this.duplicateSelection=function(){var e=this.selection,t=this.session,i=e.getRange(),n=e.isBackwards();if(i.isEmpty()){var r=i.start.row;t.duplicateLines(r,r)}else{var o=n?i.start:i.end,s=t.insert(o,t.getTextRange(i),!1);i.start=o,i.end=s,e.setSelectionRange(i,n)}},this.moveLinesDown=function(){this.$moveLines(1,!1)},this.moveLinesUp=function(){this.$moveLines(-1,!1)},this.moveText=function(e,t,i){return this.session.moveText(e,t,i)},this.copyLinesUp=function(){this.$moveLines(-1,!0)},this.copyLinesDown=function(){this.$moveLines(1,!0)},this.$moveLines=function(e,t){var i,n,r=this.selection;if(!r.inMultiSelectMode||this.inVirtualSelectionMode){var o=r.toOrientedRange();i=this.$getSelectedRows(o),n=this.session.$moveLines(i.first,i.last,t?0:e),t&&-1==e&&(n=0),o.moveBy(n,0),r.fromOrientedRange(o)}else{var s=r.rangeList.ranges;r.rangeList.detach(this.session),this.inVirtualSelectionMode=!0;for(var a=0,l=0,c=s.length,h=0;h<c;h++){var d=h;s[h].moveBy(a,0);for(var u=(i=this.$getSelectedRows(s[h])).first,f=i.last;++h<c;){l&&s[h].moveBy(l,0);var p=this.$getSelectedRows(s[h]);if(t&&p.first!=f)break;if(!t&&p.first>f+1)break;f=p.last}for(h--,a=this.session.$moveLines(u,f,t?0:e),t&&-1==e&&(d=h+1);d<=h;)s[d].moveBy(a,0),d++;t||(a=0),l+=a}r.fromOrientedRange(r.ranges[0]),r.rangeList.attach(this.session),this.inVirtualSelectionMode=!1}},this.$getSelectedRows=function(e){return e=(e||this.getSelectionRange()).collapseRows(),{first:this.session.getRowFoldStart(e.start.row),last:this.session.getRowFoldEnd(e.end.row)}},this.onCompositionStart=function(e){this.renderer.showComposition(this.getCursorPosition())},this.onCompositionUpdate=function(e){this.renderer.setCompositionText(e)},this.onCompositionEnd=function(){this.renderer.hideComposition()},this.getFirstVisibleRow=function(){return this.renderer.getFirstVisibleRow()},this.getLastVisibleRow=function(){return this.renderer.getLastVisibleRow()},this.isRowVisible=function(e){return e>=this.getFirstVisibleRow()&&e<=this.getLastVisibleRow()},this.isRowFullyVisible=function(e){return e>=this.renderer.getFirstFullyVisibleRow()&&e<=this.renderer.getLastFullyVisibleRow()},this.$getVisibleRowCount=function(){return this.renderer.getScrollBottomRow()-this.renderer.getScrollTopRow()+1},this.$moveByPage=function(e,t){var i=this.renderer,n=this.renderer.layerConfig,r=e*Math.floor(n.height/n.lineHeight);this.$blockScrolling++,!0===t?this.selection.$moveSelection(function(){this.moveCursorBy(r,0)}):!1===t&&(this.selection.moveCursorBy(r,0),this.selection.clearSelection()),this.$blockScrolling--;var o=i.scrollTop;i.scrollBy(0,r*n.lineHeight),null!=t&&i.scrollCursorIntoView(null,.5),i.animateScrolling(o)},this.selectPageDown=function(){this.$moveByPage(1,!0)},this.selectPageUp=function(){this.$moveByPage(-1,!0)},this.gotoPageDown=function(){this.$moveByPage(1,!1)},this.gotoPageUp=function(){this.$moveByPage(-1,!1)},this.scrollPageDown=function(){this.$moveByPage(1)},this.scrollPageUp=function(){this.$moveByPage(-1)},this.scrollToRow=function(e){this.renderer.scrollToRow(e)},this.scrollToLine=function(e,t,i,n){this.renderer.scrollToLine(e,t,i,n)},this.centerSelection=function(){var e=this.getSelectionRange(),t={row:Math.floor(e.start.row+(e.end.row-e.start.row)/2),column:Math.floor(e.start.column+(e.end.column-e.start.column)/2)};this.renderer.alignCursor(t,.5)},this.getCursorPosition=function(){return this.selection.getCursor()},this.getCursorPositionScreen=function(){return this.session.documentToScreenPosition(this.getCursorPosition())},this.getSelectionRange=function(){return this.selection.getRange()},this.selectAll=function(){this.$blockScrolling+=1,this.selection.selectAll(),this.$blockScrolling-=1},this.clearSelection=function(){this.selection.clearSelection()},this.moveCursorTo=function(e,t){this.selection.moveCursorTo(e,t)},this.moveCursorToPosition=function(e){this.selection.moveCursorToPosition(e)},this.jumpToMatching=function(e,t){var i=this.getCursorPosition(),n=new y(this.session,i.row,i.column),r=n.getCurrentToken(),o=r||n.stepForward();if(o){var s,a,l=!1,c={},h=i.column-o.start,d={")":"(","(":"(","]":"[","[":"[","{":"{","}":"{"};do{if(o.value.match(/[{}()\[\]]/g)){for(;h<o.value.length&&!l;h++)if(d[o.value[h]])switch(a=d[o.value[h]]+"."+o.type.replace("rparen","lparen"),isNaN(c[a])&&(c[a]=0),o.value[h]){case"(":case"[":case"{":c[a]++;break;case")":case"]":case"}":c[a]--,-1===c[a]&&(s="bracket",l=!0)}}else o&&-1!==o.type.indexOf("tag-name")&&(isNaN(c[o.value])&&(c[o.value]=0),"<"===r.value?c[o.value]++:"</"===r.value&&c[o.value]--,-1===c[o.value]&&(s="tag",l=!0));l||(r=o,o=n.stepForward(),h=0)}while(o&&!l);if(s){var u,f;if("bracket"===s)(u=this.session.getBracketRange(i))||(f=(u=new m(n.getCurrentTokenRow(),n.getCurrentTokenColumn()+h-1,n.getCurrentTokenRow(),n.getCurrentTokenColumn()+h-1)).start,(t||f.row===i.row&&Math.abs(f.column-i.column)<2)&&(u=this.session.getBracketRange(f)));else if("tag"===s){if(!o||-1===o.type.indexOf("tag-name"))return;var p=o.value;if(0===(u=new m(n.getCurrentTokenRow(),n.getCurrentTokenColumn()-2,n.getCurrentTokenRow(),n.getCurrentTokenColumn()-2)).compare(i.row,i.column))for(l=!1;o=r,(r=n.stepBackward())&&(-1!==r.type.indexOf("tag-close")&&u.setEnd(n.getCurrentTokenRow(),n.getCurrentTokenColumn()+1),o.value===p&&-1!==o.type.indexOf("tag-name")&&("<"===r.value?c[p]++:"</"===r.value&&c[p]--,0===c[p]&&(l=!0))),r&&!l;);o&&o.type.indexOf("tag-name")&&(f=u.start).row==i.row&&Math.abs(f.column-i.column)<2&&(f=u.end)}(f=u&&u.cursor||f)&&(e?u&&t?this.selection.setRange(u):u&&u.isEqual(this.getSelectionRange())?this.clearSelection():this.selection.selectTo(f.row,f.column):this.selection.moveTo(f.row,f.column))}}},this.gotoLine=function(e,t,i){this.selection.clearSelection(),this.session.unfold({row:e-1,column:t||0}),this.$blockScrolling+=1,this.exitMultiSelectMode&&this.exitMultiSelectMode(),this.moveCursorTo(e-1,t||0),this.$blockScrolling-=1,this.isRowFullyVisible(e-1)||this.scrollToLine(e-1,!0,i)},this.navigateTo=function(e,t){this.selection.moveTo(e,t)},this.navigateUp=function(e){if(this.selection.isMultiLine()&&!this.selection.isBackwards()){var t=this.selection.anchor.getPosition();return this.moveCursorToPosition(t)}this.selection.clearSelection(),this.selection.moveCursorBy(-e||-1,0)},this.navigateDown=function(e){if(this.selection.isMultiLine()&&this.selection.isBackwards()){var t=this.selection.anchor.getPosition();return this.moveCursorToPosition(t)}this.selection.clearSelection(),this.selection.moveCursorBy(e||1,0)},this.navigateLeft=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorLeft();else{var t=this.getSelectionRange().start;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateRight=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorRight();else{var t=this.getSelectionRange().end;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateLineStart=function(){this.selection.moveCursorLineStart(),this.clearSelection()},this.navigateLineEnd=function(){this.selection.moveCursorLineEnd(),this.clearSelection()},this.navigateFileEnd=function(){this.selection.moveCursorFileEnd(),this.clearSelection()},this.navigateFileStart=function(){this.selection.moveCursorFileStart(),this.clearSelection()},this.navigateWordRight=function(){this.selection.moveCursorWordRight(),this.clearSelection()},this.navigateWordLeft=function(){this.selection.moveCursorWordLeft(),this.clearSelection()},this.replace=function(e,t){t&&this.$search.set(t);var i=this.$search.find(this.session),n=0;return i&&(this.$tryReplace(i,e)&&(n=1),null!==i&&(this.selection.setSelectionRange(i),this.renderer.scrollSelectionIntoView(i.start,i.end))),n},this.replaceAll=function(e,t){t&&this.$search.set(t);var i=this.$search.findAll(this.session),n=0;if(!i.length)return n;this.$blockScrolling+=1;var r=this.getSelectionRange();this.selection.moveTo(0,0);for(var o=i.length-1;0<=o;--o)this.$tryReplace(i[o],e)&&n++;return this.selection.setSelectionRange(r),this.$blockScrolling-=1,n},this.$tryReplace=function(e,t){var i=this.session.getTextRange(e);return null!==(t=this.$search.replace(i,t))?(e.end=this.session.replace(e,t),e):null},this.getLastSearchOptions=function(){return this.$search.getOptions()},this.find=function(e,t,i){t=t||{},"string"==typeof e||e instanceof RegExp?t.needle=e:"object"==typeof e&&o.mixin(t,e);var n=this.selection.getRange();null==t.needle&&((e=this.session.getTextRange(n)||this.$search.$options.needle)||(n=this.session.getWordRange(n.start.row,n.start.column),e=this.session.getTextRange(n)),this.$search.set({needle:e})),this.$search.set(t),t.start||this.$search.set({start:n});var r=this.$search.find(this.session);return t.preventScroll?r:r?(this.revealRange(r,i),r):(t.backwards?n.start=n.end:n.end=n.start,void this.selection.setRange(n))},this.findNext=function(e,t){this.find({skipCurrent:!0,backwards:!1},e,t)},this.findPrevious=function(e,t){this.find(e,{skipCurrent:!0,backwards:!0},t)},this.revealRange=function(e,t){this.$blockScrolling+=1,this.session.unfold(e),this.selection.setSelectionRange(e),this.$blockScrolling-=1;var i=this.renderer.scrollTop;this.renderer.scrollSelectionIntoView(e.start,e.end,.5),!1!==t&&this.renderer.animateScrolling(i)},this.undo=function(){this.$blockScrolling++,this.session.getUndoManager().undo(),this.$blockScrolling--,this.renderer.scrollCursorIntoView(null,.5)},this.redo=function(){this.$blockScrolling++,this.session.getUndoManager().redo(),this.$blockScrolling--,this.renderer.scrollCursorIntoView(null,.5)},this.destroy=function(){this.renderer.destroy(),this._signal("destroy",this),this.session&&this.session.destroy()},this.setAutoScrollEditorIntoView=function(e){if(e){var r,o=this,s=!1;this.$scrollAnchor||(this.$scrollAnchor=document.createElement("div"));var a=this.$scrollAnchor;a.style.cssText="position:absolute",this.container.insertBefore(a,this.container.firstChild);var t=this.on("changeSelection",function(){s=!0}),i=this.renderer.on("beforeRender",function(){s&&(r=o.renderer.container.getBoundingClientRect())}),n=this.renderer.on("afterRender",function(){if(s&&r&&(o.isFocused()||o.searchBox&&o.searchBox.isFocused())){var e=o.renderer,t=e.$cursorLayer.$pixelPos,i=e.layerConfig,n=t.top-i.offset;null!=(s=0<=t.top&&n+r.top<0||!(t.top<i.height&&t.top+r.top+i.lineHeight>window.innerHeight)&&null)&&(a.style.top=n+"px",a.style.left=t.left+"px",a.style.height=i.lineHeight+"px",a.scrollIntoView(s)),s=r=null}});this.setAutoScrollEditorIntoView=function(e){e||(delete this.setAutoScrollEditorIntoView,this.off("changeSelection",t),this.renderer.off("afterRender",n),this.renderer.off("beforeRender",i))}}},this.$resetCursorStyle=function(){var e=this.$cursorStyle||"ace",t=this.renderer.$cursorLayer;t&&(t.setSmoothBlinking(/smooth/.test(e)),t.isBlinking=!this.$readOnly&&"wide"!=e,n.setCssClass(t.element,"ace_slim-cursors",/slim/.test(e)))}}.call(w.prototype),v.defineOptions(w.prototype,"editor",{selectionStyle:{set:function(e){this.onSelectionChange(),this._signal("changeSelectionStyle",{data:e})},initialValue:"line"},highlightActiveLine:{set:function(){this.$updateHighlightActiveLine()},initialValue:!0},highlightSelectedWord:{set:function(e){this.$onSelectionChange()},initialValue:!0},readOnly:{set:function(e){this.$resetCursorStyle()},initialValue:!1},cursorStyle:{set:function(e){this.$resetCursorStyle()},values:["ace","slim","smooth","wide"],initialValue:"ace"},mergeUndoDeltas:{values:[!1,!0,"always"],initialValue:!0},behavioursEnabled:{initialValue:!0},wrapBehavioursEnabled:{initialValue:!0},autoScrollEditorIntoView:{set:function(e){this.setAutoScrollEditorIntoView(e)}},keyboardHandler:{set:function(e){this.setKeyboardHandler(e)},get:function(){return this.keybindingId},handlesSet:!0},hScrollBarAlwaysVisible:"renderer",vScrollBarAlwaysVisible:"renderer",highlightGutterLine:"renderer",animatedScroll:"renderer",showInvisibles:"renderer",showPrintMargin:"renderer",printMarginColumn:"renderer",printMargin:"renderer",fadeFoldWidgets:"renderer",showFoldWidgets:"renderer",showLineNumbers:"renderer",showGutter:"renderer",displayIndentGuides:"renderer",fontSize:"renderer",fontFamily:"renderer",maxLines:"renderer",minLines:"renderer",scrollPastEnd:"renderer",fixedWidthGutter:"renderer",theme:"renderer",scrollSpeed:"$mouseHandler",dragDelay:"$mouseHandler",dragEnabled:"$mouseHandler",focusTimout:"$mouseHandler",tooltipFollowsMouse:"$mouseHandler",firstLineNumber:"session",overwrite:"session",newLineMode:"session",useWorker:"session",useSoftTabs:"session",tabSize:"session",wrap:"session",indentedSoftWrap:"session",foldStyle:"session",mode:"session"}),t.Editor=w}),ace.define("ace/undomanager",["require","exports","module"],function(e,t,i){"use strict";function n(){this.reset()}(function(){function t(e){return{action:e.action,start:e.start,end:e.end,lines:1==e.lines.length?null:e.lines,text:1==e.lines.length?e.lines[0]:null}}function i(e){return{action:e.action,start:e.start,end:e.end,lines:e.lines||[e.text]}}function n(e,t){for(var i=new Array(e.length),n=0;n<e.length;n++){for(var r=e[n],o={group:r.group,deltas:new Array(r.length)},s=0;s<r.deltas.length;s++){var a=r.deltas[s];o.deltas[s]=t(a)}i[n]=o}return i}this.execute=function(e){var t=e.args[0];this.$doc=e.args[1],e.merge&&this.hasUndo()&&(this.dirtyCounter--,t=this.$undoStack.pop().concat(t)),this.$undoStack.push(t),this.$redoStack=[],this.dirtyCounter<0&&(this.dirtyCounter=NaN),this.dirtyCounter++},this.undo=function(e){var t=this.$undoStack.pop(),i=null;return t&&(i=this.$doc.undoChanges(t,e),this.$redoStack.push(t),this.dirtyCounter--),i},this.redo=function(e){var t=this.$redoStack.pop(),i=null;return t&&(i=this.$doc.redoChanges(this.$deserializeDeltas(t),e),this.$undoStack.push(t),this.dirtyCounter++),i},this.reset=function(){this.$undoStack=[],this.$redoStack=[],this.dirtyCounter=0},this.hasUndo=function(){return 0<this.$undoStack.length},this.hasRedo=function(){return 0<this.$redoStack.length},this.markClean=function(){this.dirtyCounter=0},this.isClean=function(){return 0===this.dirtyCounter},this.$serializeDeltas=function(e){return n(e,t)},this.$deserializeDeltas=function(e){return n(e,i)}}).call(n.prototype),t.UndoManager=n}),ace.define("ace/layer/gutter",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e){this.element=C.createElement("div"),this.element.className="ace_layer ace_gutter-layer",e.appendChild(this.element),this.setShowFoldWidgets(this.$showFoldWidgets),this.gutterWidth=0,this.$annotations=[],this.$updateAnnotations=this.$updateAnnotations.bind(this),this.$cells=[]}var C=e("../lib/dom"),r=e("../lib/oop"),a=e("../lib/lang"),o=e("../lib/event_emitter").EventEmitter;(function(){r.implement(this,o),this.setSession=function(e){this.session&&this.session.removeEventListener("change",this.$updateAnnotations),(this.session=e)&&e.on("change",this.$updateAnnotations)},this.addGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.addGutterDecoration"),this.session.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.removeGutterDecoration"),this.session.removeGutterDecoration(e,t)},this.setAnnotations=function(e){this.$annotations=[];for(var t=0;t<e.length;t++){var i=e[t],n=i.row,r=this.$annotations[n];r=r||(this.$annotations[n]={text:[]});var o=i.text;o=o?a.escapeHTML(o):i.html||"",-1===r.text.indexOf(o)&&r.text.push(o);var s=i.type;"error"==s?r.className=" ace_error":"warning"==s&&" ace_error"!=r.className?r.className=" ace_warning":"info"!=s||r.className||(r.className=" ace_info")}},this.$updateAnnotations=function(e){if(this.$annotations.length){var t=e.start.row,i=e.end.row-t;if(0==i);else if("remove"==e.action)this.$annotations.splice(t,1+i,null);else{var n=new Array(1+i);n.unshift(t,1),this.$annotations.splice.apply(this.$annotations,n)}}},this.update=function(e){for(var t=this.session,i=e.firstRow,n=Math.min(e.lastRow+e.gutterOffset,t.getLength()-1),r=t.getNextFoldLine(i),o=r?r.start.row:1/0,s=this.$showFoldWidgets&&t.foldWidgets,a=t.$breakpoints,l=t.$decorations,c=t.$firstLineNumber,h=0,d=t.gutterRenderer||this.$renderer,u=null,f=-1,p=i;;){if(o<p&&(p=r.end.row+1,o=(r=t.getNextFoldLine(p,r))?r.start.row:1/0),n<p){for(;this.$cells.length>f+1;)u=this.$cells.pop(),this.element.removeChild(u.element);break}(u=this.$cells[++f])||((u={element:null,textNode:null,foldWidget:null}).element=C.createElement("div"),u.textNode=document.createTextNode(""),u.element.appendChild(u.textNode),this.element.appendChild(u.element),this.$cells[f]=u);var m="ace_gutter-cell ";if(a[p]&&(m+=a[p]),l[p]&&(m+=l[p]),this.$annotations[p]&&(m+=this.$annotations[p].className),u.element.className!=m&&(u.element.className=m),(v=t.getRowLength(p)*e.lineHeight+"px")!=u.element.style.height&&(u.element.style.height=v),s){var g=s[p];null==g&&(g=s[p]=t.getFoldWidget(p))}if(g){u.foldWidget||(u.foldWidget=C.createElement("span"),u.element.appendChild(u.foldWidget));m="ace_fold-widget ace_"+g;"start"==g&&p==o&&p<r.end.row?m+=" ace_closed":m+=" ace_open",u.foldWidget.className!=m&&(u.foldWidget.className=m);var v=e.lineHeight+"px";u.foldWidget.style.height!=v&&(u.foldWidget.style.height=v)}else u.foldWidget&&(u.element.removeChild(u.foldWidget),u.foldWidget=null);var y=h=d?d.getText(t,p):p+c;y!==u.textNode.data&&(u.textNode.data=y),p++}this.element.style.height=e.minHeight+"px",(this.$fixedWidth||t.$useWrapMode)&&(h=t.getLength()+c);var w=d?d.getWidth(t,h,e):h.toString().length*e.characterWidth,b=this.$padding||this.$computePadding();(w+=b.left+b.right)===this.gutterWidth||isNaN(w)||(this.gutterWidth=w,this.element.style.width=Math.ceil(this.gutterWidth)+"px",this._emit("changeGutterWidth",w))},this.$fixedWidth=!1,this.$showLineNumbers=!0,this.$renderer="",this.setShowLineNumbers=function(e){this.$renderer=!e&&{getWidth:function(){return""},getText:function(){return""}}},this.getShowLineNumbers=function(){return this.$showLineNumbers},this.$showFoldWidgets=!0,this.setShowFoldWidgets=function(e){e?C.addCssClass(this.element,"ace_folding-enabled"):C.removeCssClass(this.element,"ace_folding-enabled"),this.$showFoldWidgets=e,this.$padding=null},this.getShowFoldWidgets=function(){return this.$showFoldWidgets},this.$computePadding=function(){if(!this.element.firstChild)return{left:0,right:0};var e=C.computedStyle(this.element.firstChild);return this.$padding={},this.$padding.left=parseInt(e.paddingLeft)+1||0,this.$padding.right=parseInt(e.paddingRight)||0,this.$padding},this.getRegion=function(e){var t=this.$padding||this.$computePadding(),i=this.element.getBoundingClientRect();return e.x<t.left+i.left?"markers":this.$showFoldWidgets&&e.x>i.right-t.right?"foldWidgets":void 0}}).call(n.prototype),t.Gutter=n}),ace.define("ace/layer/marker",["require","exports","module","ace/range","ace/lib/dom"],function(e,t,i){"use strict";function n(e){this.element=r.createElement("div"),this.element.className="ace_layer ace_marker-layer",e.appendChild(this.element)}var p=e("../range").Range,r=e("../lib/dom");(function(){this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setMarkers=function(e){this.markers=e},this.update=function(e){if(e){this.config=e;var t=[];for(var i in this.markers){var n=this.markers[i];if(n.range){var r=n.range.clipRows(e.firstRow,e.lastRow);if(!r.isEmpty())if(r=r.toScreenRange(this.session),n.renderer){var o=this.$getTop(r.start.row,e),s=this.$padding+(this.session.$bidiHandler.isBidiRow(r.start.row)?this.session.$bidiHandler.getPosLeft(r.start.column):r.start.column*e.characterWidth);n.renderer(t,r,s,o,e)}else"fullLine"==n.type?this.drawFullLineMarker(t,r,n.clazz,e):"screenLine"==n.type?this.drawScreenLineMarker(t,r,n.clazz,e):r.isMultiLine()?"text"==n.type?this.drawTextMarker(t,r,n.clazz,e):this.drawMultiLineMarker(t,r,n.clazz,e):this.session.$bidiHandler.isBidiRow(r.start.row)?this.drawBidiSingleLineMarker(t,r,n.clazz+" ace_start ace_br15",e):this.drawSingleLineMarker(t,r,n.clazz+" ace_start ace_br15",e)}else n.update(t,this,this.session,e)}this.element.innerHTML=t.join("")}},this.$getTop=function(e,t){return(e-t.firstRowScreen)*t.lineHeight},this.drawTextMarker=function(e,t,i,n,r){for(var o=this.session,s=t.start.row,a=t.end.row,l=s,c=0,h=0,d=o.getScreenLastRowColumn(l),u=null,f=new p(l,t.start.column,l,h);l<=a;l++)f.start.row=f.end.row=l,f.start.column=l==s?t.start.column:o.getRowWrapIndent(l),c=h,h=f.end.column=d,d=l+1<a?o.getScreenLastRowColumn(l+1):l==a?0:t.end.column,u=i+(l==s?" ace_start":"")+" ace_br"+((l==s||l==s+1&&t.start.column?1:0)|(c<h?2:0)|(d<h?4:0)|(l==a?8:0)),this.session.$bidiHandler.isBidiRow(l)?this.drawBidiSingleLineMarker(e,f,u,n,l==a?0:1,r):this.drawSingleLineMarker(e,f,u,n,l==a?0:1,r)},this.drawMultiLineMarker=function(e,t,i,n,r){var o,s,a,l=this.$padding;(r=r||"",this.session.$bidiHandler.isBidiRow(t.start.row))?((c=t.clone()).end.row=c.start.row,c.end.column=this.session.getLine(c.start.row).length,this.drawBidiSingleLineMarker(e,c,i+" ace_br1 ace_start",n,null,r)):(o=n.lineHeight,s=this.$getTop(t.start.row,n),a=l+t.start.column*n.characterWidth,e.push("<div class='",i," ace_br1 ace_start' style='","height:",o,"px;","right:0;","top:",s,"px;","left:",a,"px;",r,"'></div>"));if(this.session.$bidiHandler.isBidiRow(t.end.row)){var c;(c=t.clone()).start.row=c.end.row,c.start.column=0,this.drawBidiSingleLineMarker(e,c,i+" ace_br12",n,null,r)}else{var h=t.end.column*n.characterWidth;o=n.lineHeight,s=this.$getTop(t.end.row,n),e.push("<div class='",i," ace_br12' style='","height:",o,"px;","width:",h,"px;","top:",s,"px;","left:",l,"px;",r,"'></div>")}if(!((o=(t.end.row-t.start.row-1)*n.lineHeight)<=0)){s=this.$getTop(t.start.row+1,n);var d=(t.start.column?1:0)|(t.end.column?0:8);e.push("<div class='",i,d?" ace_br"+d:"","' style='","height:",o,"px;","right:0;","top:",s,"px;","left:",l,"px;",r,"'></div>")}},this.drawSingleLineMarker=function(e,t,i,n,r,o){var s=n.lineHeight,a=(t.end.column+(r||0)-t.start.column)*n.characterWidth,l=this.$getTop(t.start.row,n),c=this.$padding+t.start.column*n.characterWidth;e.push("<div class='",i,"' style='","height:",s,"px;","width:",a,"px;","top:",l,"px;","left:",c,"px;",o||"","'></div>")},this.drawBidiSingleLineMarker=function(t,e,i,n,r,o){var s=n.lineHeight,a=this.$getTop(e.start.row,n),l=this.$padding;this.session.$bidiHandler.getSelections(e.start.column,e.end.column).forEach(function(e){t.push("<div class='",i,"' style='","height:",s,"px;","width:",e.width+(r||0),"px;","top:",a,"px;","left:",l+e.left,"px;",o||"","'></div>")})},this.drawFullLineMarker=function(e,t,i,n,r){var o=this.$getTop(t.start.row,n),s=n.lineHeight;t.start.row!=t.end.row&&(s+=this.$getTop(t.end.row,n)-o),e.push("<div class='",i,"' style='","height:",s,"px;","top:",o,"px;","left:0;right:0;",r||"","'></div>")},this.drawScreenLineMarker=function(e,t,i,n,r){var o=this.$getTop(t.start.row,n),s=n.lineHeight;e.push("<div class='",i,"' style='","height:",s,"px;","top:",o,"px;","left:0;right:0;",r||"","'></div>")}}).call(n.prototype),t.Marker=n}),ace.define("ace/layer/text",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e){this.element=c.createElement("div"),this.element.className="ace_layer ace_text-layer",e.appendChild(this.element),this.$updateEolChar=this.$updateEolChar.bind(this)}var r=e("../lib/oop"),c=e("../lib/dom"),d=e("../lib/lang"),o=(e("../lib/useragent"),e("../lib/event_emitter").EventEmitter);(function(){r.implement(this,o),this.EOF_CHAR="¶",this.EOL_CHAR_LF="¬",this.EOL_CHAR_CRLF="¤",this.EOL_CHAR=this.EOL_CHAR_LF,this.TAB_CHAR="—",this.SPACE_CHAR="·",this.$padding=0,this.$updateEolChar=function(){var e="\n"==this.session.doc.getNewLineCharacter()?this.EOL_CHAR_LF:this.EOL_CHAR_CRLF;if(this.EOL_CHAR!=e)return this.EOL_CHAR=e,!0},this.setPadding=function(e){this.$padding=e,this.element.style.padding="0 "+e+"px"},this.getLineHeight=function(){return this.$fontMetrics.$characterSize.height||0},this.getCharacterWidth=function(){return this.$fontMetrics.$characterSize.width||0},this.$setFontMetrics=function(e){this.$fontMetrics=e,this.$fontMetrics.on("changeCharacterSize",function(e){this._signal("changeCharacterSize",e)}.bind(this)),this.$pollSizeChanges()},this.checkForSizeChanges=function(){this.$fontMetrics.checkForSizeChanges()},this.$pollSizeChanges=function(){return this.$pollSizeChangesTimer=this.$fontMetrics.$pollSizeChanges()},this.setSession=function(e){(this.session=e)&&this.$computeTabString()},this.showInvisibles=!1,this.setShowInvisibles=function(e){return this.showInvisibles!=e&&(this.showInvisibles=e,this.$computeTabString(),!0)},this.displayIndentGuides=!0,this.setDisplayIndentGuides=function(e){return this.displayIndentGuides!=e&&(this.displayIndentGuides=e,this.$computeTabString(),!0)},this.$tabStrings=[],this.onChangeTabSize=this.$computeTabString=function(){var e=this.session.getTabSize();this.tabSize=e;for(var t=this.$tabStrings=[0],i=1;i<e+1;i++)this.showInvisibles?t.push("<span class='ace_invisible ace_invisible_tab'>"+d.stringRepeat(this.TAB_CHAR,i)+"</span>"):t.push(d.stringRepeat(" ",i));if(this.displayIndentGuides){this.$indentGuideRe=/\s\S| \t|\t |\s$/;var n="ace_indent-guide",r="",o="";if(this.showInvisibles){n+=" ace_invisible",r=" ace_invisible_space",o=" ace_invisible_tab";var s=d.stringRepeat(this.SPACE_CHAR,this.tabSize),a=d.stringRepeat(this.TAB_CHAR,this.tabSize)}else a=s=d.stringRepeat(" ",this.tabSize);this.$tabStrings[" "]="<span class='"+n+r+"'>"+s+"</span>",this.$tabStrings["\t"]="<span class='"+n+o+"'>"+a+"</span>"}},this.updateLines=function(e,t,i){this.config.lastRow==e.lastRow&&this.config.firstRow==e.firstRow||this.scrollLines(e),this.config=e;for(var n=Math.max(t,e.firstRow),r=Math.min(i,e.lastRow),o=this.element.childNodes,s=0,a=e.firstRow;a<n;a++){if(l=this.session.getFoldLine(a)){if(l.containsRow(n)){n=l.start.row;break}a=l.end.row}s++}a=n;for(var l,c=(l=this.session.getNextFoldLine(a))?l.start.row:1/0;c<a&&(a=l.end.row+1,c=(l=this.session.getNextFoldLine(a,l))?l.start.row:1/0),!(r<a);){var h=o[s++];if(h){var d=[];this.$renderLine(d,a,!this.$useLineGroups(),a==c&&l),h.style.height=e.lineHeight*this.session.getRowLength(a)+"px",h.innerHTML=d.join("")}a++}},this.scrollLines=function(e){var t=this.config;if(this.config=e,!t||t.lastRow<e.firstRow)return this.update(e);if(e.lastRow<t.firstRow)return this.update(e);var i=this.element;if(t.firstRow<e.firstRow)for(var n=this.session.getFoldedRowCount(t.firstRow,e.firstRow-1);0<n;n--)i.removeChild(i.firstChild);if(t.lastRow>e.lastRow)for(n=this.session.getFoldedRowCount(e.lastRow+1,t.lastRow);0<n;n--)i.removeChild(i.lastChild);if(e.firstRow<t.firstRow){var r=this.$renderLinesFragment(e,e.firstRow,t.firstRow-1);i.firstChild?i.insertBefore(r,i.firstChild):i.appendChild(r)}if(e.lastRow>t.lastRow){r=this.$renderLinesFragment(e,t.lastRow+1,e.lastRow);i.appendChild(r)}},this.$renderLinesFragment=function(e,t,i){for(var n=this.element.ownerDocument.createDocumentFragment(),r=t,o=this.session.getNextFoldLine(r),s=o?o.start.row:1/0;s<r&&(r=o.end.row+1,s=(o=this.session.getNextFoldLine(r,o))?o.start.row:1/0),!(i<r);){var a=c.createElement("div"),l=[];if(this.$renderLine(l,r,!1,r==s&&o),a.innerHTML=l.join(""),this.$useLineGroups())a.className="ace_line_group",n.appendChild(a),a.style.height=e.lineHeight*this.session.getRowLength(r)+"px";else for(;a.firstChild;)n.appendChild(a.firstChild);r++}return n},this.update=function(e){for(var t=[],i=(this.config=e).firstRow,n=e.lastRow,r=i,o=this.session.getNextFoldLine(r),s=o?o.start.row:1/0;s<r&&(r=o.end.row+1,s=(o=this.session.getNextFoldLine(r,o))?o.start.row:1/0),!(n<r);)this.$useLineGroups()&&t.push("<div class='ace_line_group' style='height:",e.lineHeight*this.session.getRowLength(r),"px'>"),this.$renderLine(t,r,!1,r==s&&o),this.$useLineGroups()&&t.push("</div>"),r++;this.element.innerHTML=t.join("")},this.$textToken={text:!0,rparen:!0,lparen:!0},this.$renderToken=function(e,l,t,i){var c=this,n=i.replace(/\t|&|<|>|( +)|([\x00-\x1f\x80-\xa0\xad\u1680\u180E\u2000-\u200f\u2028\u2029\u202F\u205F\u3000\uFEFF\uFFF9-\uFFFC])|[\u1100-\u115F\u11A3-\u11A7\u11FA-\u11FF\u2329-\u232A\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3000-\u303E\u3041-\u3096\u3099-\u30FF\u3105-\u312D\u3131-\u318E\u3190-\u31BA\u31C0-\u31E3\u31F0-\u321E\u3220-\u3247\u3250-\u32FE\u3300-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFAFF\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFF01-\uFF60\uFFE0-\uFFE6]|[\uD800-\uDBFF][\uDC00-\uDFFF]/g,function(e,t,i,n,r){if(t)return c.showInvisibles?"<span class='ace_invisible ace_invisible_space'>"+d.stringRepeat(c.SPACE_CHAR,e.length)+"</span>":e;if("&"==e)return"&#38;";if("<"==e)return"&#60;";if(">"==e)return"&#62;";if("\t"==e){var o=c.session.getScreenTabSize(l+n);return l+=o-1,c.$tabStrings[o]}if("　"!=e)return i?"<span class='ace_invisible ace_invisible_space ace_invalid'>"+c.SPACE_CHAR+"</span>":(l+=1,"<span class='ace_cjk' style='width:"+2*c.config.characterWidth+"px'>"+e+"</span>");var s=c.showInvisibles?"ace_cjk ace_invisible ace_invisible_space":"ace_cjk",a=c.showInvisibles?c.SPACE_CHAR:"";return l+=1,"<span class='"+s+"' style='width:"+2*c.config.characterWidth+"px'>"+a+"</span>"});if(this.$textToken[t.type])e.push(n);else{var r="ace_"+t.type.replace(/\./g," ace_"),o="";"fold"==t.type&&(o=" style='width:"+t.value.length*this.config.characterWidth+"px;' "),e.push("<span class='",r,"'",o,">",n,"</span>")}return l+i.length},this.renderIndentGuide=function(e,t,i){var n=t.search(this.$indentGuideRe);return n<=0||i<=n?t:" "==t[0]?(n-=n%this.tabSize,e.push(d.stringRepeat(this.$tabStrings[" "],n/this.tabSize)),t.substr(n)):"\t"==t[0]?(e.push(d.stringRepeat(this.$tabStrings["\t"],n)),t.substr(n)):t},this.$renderWrappedLine=function(e,t,i,n){for(var r=0,o=0,s=i[0],a=0,l=0;l<t.length;l++){var c=t[l],h=c.value;if(0==l&&this.displayIndentGuides){if(r=h.length,!(h=this.renderIndentGuide(e,h,s)))continue;r-=h.length}if(r+h.length<s)a=this.$renderToken(e,a,c,h),r+=h.length;else{for(;r+h.length>=s;)a=this.$renderToken(e,a,c,h.substring(0,s-r)),h=h.substring(s-r),r=s,n||e.push("</div>","<div class='ace_line' style='height:",this.config.lineHeight,"px'>"),e.push(d.stringRepeat(" ",i.indent)),a=0,s=i[++o]||Number.MAX_VALUE;0!=h.length&&(r+=h.length,a=this.$renderToken(e,a,c,h))}}},this.$renderSimpleLine=function(e,t){var i=0,n=t[0],r=n.value;this.displayIndentGuides&&(r=this.renderIndentGuide(e,r)),r&&(i=this.$renderToken(e,i,n,r));for(var o=1;o<t.length;o++)r=(n=t[o]).value,i=this.$renderToken(e,i,n,r)},this.$renderLine=function(e,t,i,n){if(n||0==n||(n=this.session.getFoldLine(t)),n)var r=this.$getFoldLineTokens(t,n);else r=this.session.getTokens(t);if(i||e.push("<div class='ace_line' style='height:",this.config.lineHeight*(this.$useLineGroups()?1:this.session.getRowLength(t)),"px'>"),r.length){var o=this.session.getRowSplitData(t);o&&o.length?this.$renderWrappedLine(e,r,o,i):this.$renderSimpleLine(e,r)}this.showInvisibles&&(n&&(t=n.end.row),e.push("<span class='ace_invisible ace_invisible_eol'>",t==this.session.getLength()-1?this.EOF_CHAR:this.EOL_CHAR,"</span>")),i||e.push("</div>")},this.$getFoldLineTokens=function(e,t){var o=this.session,s=[];var a=o.getTokens(e);return t.walk(function(e,t,i,n,r){null!=e?s.push({type:"fold",value:e}):(r&&(a=o.getTokens(t)),a.length&&function(e,t,i){for(var n=0,r=0;r+e[n].value.length<t;)if(r+=e[n].value.length,++n==e.length)return;for(r!=t&&((o=e[n].value.substring(t-r)).length>i-t&&(o=o.substring(0,i-t)),s.push({type:e[n].type,value:o}),r=t+o.length,n+=1);r<i&&n<e.length;){var o;(o=e[n].value).length+r>i?s.push({type:e[n].type,value:o.substring(0,i-r)}):s.push(e[n]),r+=o.length,n+=1}}(a,n,i))},t.end.row,this.session.getLine(t.end.row).length),s},this.$useLineGroups=function(){return this.session.getUseWrapMode()},this.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.$measureNode&&this.$measureNode.parentNode.removeChild(this.$measureNode),delete this.$measureNode}}).call(n.prototype),t.Text=n}),ace.define("ace/layer/cursor",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";function n(e){this.element=o.createElement("div"),this.element.className="ace_layer ace_cursor-layer",e.appendChild(this.element),void 0===r&&(r=!("opacity"in this.element.style)),this.isVisible=!1,this.isBlinking=!0,this.blinkInterval=1e3,this.smoothBlinking=!1,this.cursors=[],this.cursor=this.addCursor(),o.addCssClass(this.element,"ace_hidden-cursors"),this.$updateCursors=(r?this.$updateVisibility:this.$updateOpacity).bind(this)}var r,o=e("../lib/dom");(function(){this.$updateVisibility=function(e){for(var t=this.cursors,i=t.length;i--;)t[i].style.visibility=e?"":"hidden"},this.$updateOpacity=function(e){for(var t=this.cursors,i=t.length;i--;)t[i].style.opacity=e?"":"0"},this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setBlinking=function(e){e!=this.isBlinking&&(this.isBlinking=e,this.restartTimer())},this.setBlinkInterval=function(e){e!=this.blinkInterval&&(this.blinkInterval=e,this.restartTimer())},this.setSmoothBlinking=function(e){e==this.smoothBlinking||r||(this.smoothBlinking=e,o.setCssClass(this.element,"ace_smooth-blinking",e),this.$updateCursors(!0),this.$updateCursors=this.$updateOpacity.bind(this),this.restartTimer())},this.addCursor=function(){var e=o.createElement("div");return e.className="ace_cursor",this.element.appendChild(e),this.cursors.push(e),e},this.removeCursor=function(){if(1<this.cursors.length){var e=this.cursors.pop();return e.parentNode.removeChild(e),e}},this.hideCursor=function(){this.isVisible=!1,o.addCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.showCursor=function(){this.isVisible=!0,o.removeCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.restartTimer=function(){var e=this.$updateCursors;if(clearInterval(this.intervalId),clearTimeout(this.timeoutId),this.smoothBlinking&&o.removeCssClass(this.element,"ace_smooth-blinking"),e(!0),this.isBlinking&&this.blinkInterval&&this.isVisible){this.smoothBlinking&&setTimeout(function(){o.addCssClass(this.element,"ace_smooth-blinking")}.bind(this));var t=function(){this.timeoutId=setTimeout(function(){e(!1)},.6*this.blinkInterval)}.bind(this);this.intervalId=setInterval(function(){e(!0),t()},this.blinkInterval),t()}},this.getPixelPosition=function(e,t){if(!this.config||!this.session)return{left:0,top:0};e=e||this.session.selection.getCursor();var i=this.session.documentToScreenPosition(e);return{left:this.$padding+(this.session.$bidiHandler.isBidiRow(i.row,e.row)?this.session.$bidiHandler.getPosLeft(i.column):i.column*this.config.characterWidth),top:(i.row-(t?this.config.firstRowScreen:0))*this.config.lineHeight}},this.update=function(e){this.config=e;var t=this.session.$selectionMarkers,i=0,n=0;void 0!==t&&0!==t.length||(t=[{cursor:null}]);i=0;for(var r=t.length;i<r;i++){var o=this.getPixelPosition(t[i].cursor,!0);if(!((o.top>e.height+e.offset||o.top<0)&&1<i)){var s=(this.cursors[n++]||this.addCursor()).style;this.drawCursor?this.drawCursor(s,o,e,t[i],this.session):(s.left=o.left+"px",s.top=o.top+"px",s.width=e.characterWidth+"px",s.height=e.lineHeight+"px")}}for(;this.cursors.length>n;)this.removeCursor();var a=this.session.getOverwrite();this.$setOverwrite(a),this.$pixelPos=o,this.restartTimer()},this.drawCursor=null,this.$setOverwrite=function(e){e!=this.overwrite&&((this.overwrite=e)?o.addCssClass(this.element,"ace_overwrite-cursors"):o.removeCssClass(this.element,"ace_overwrite-cursors"))},this.destroy=function(){clearInterval(this.intervalId),clearTimeout(this.timeoutId)}}).call(n.prototype),t.Cursor=n}),ace.define("ace/scrollbar",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],function(e,t,i){"use strict";function n(e){this.element=o.createElement("div"),this.element.className="ace_scrollbar ace_scrollbar"+this.classSuffix,this.inner=o.createElement("div"),this.inner.className="ace_scrollbar-inner",this.element.appendChild(this.inner),e.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,s.addListener(this.element,"scroll",this.onScroll.bind(this)),s.addListener(this.element,"mousedown",s.preventDefault)}var r=e("./lib/oop"),o=e("./lib/dom"),s=e("./lib/event"),a=e("./lib/event_emitter").EventEmitter;(function(){r.implement(this,a),this.setVisible=function(e){this.element.style.display=e?"":"none",this.isVisible=e,this.coeff=1}}).call(n.prototype);function l(e,t){n.call(this,e),this.scrollTop=0,this.scrollHeight=0,t.$scrollbarWidth=this.width=o.scrollbarWidth(e.ownerDocument),this.inner.style.width=this.element.style.width=(this.width||15)+5+"px",this.$minWidth=0}r.inherits(l,n),function(){this.classSuffix="-v",this.onScroll=function(){if(!this.skipEvent){if(this.scrollTop=this.element.scrollTop,1!=this.coeff){var e=this.element.clientHeight/this.scrollHeight;this.scrollTop=this.scrollTop*(1-e)/(this.coeff-e)}this._emit("scroll",{data:this.scrollTop})}this.skipEvent=!1},this.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)},this.setHeight=function(e){this.element.style.height=e+"px"},this.setInnerHeight=this.setScrollHeight=function(e){32768<(this.scrollHeight=e)?(this.coeff=32768/e,e=32768):1!=this.coeff&&(this.coeff=1),this.inner.style.height=e+"px"},this.setScrollTop=function(e){this.scrollTop!=e&&(this.skipEvent=!0,this.scrollTop=e,this.element.scrollTop=e*this.coeff)}}.call(l.prototype);function c(e,t){n.call(this,e),this.scrollLeft=0,this.height=t.$scrollbarWidth,this.inner.style.height=this.element.style.height=(this.height||15)+5+"px"}r.inherits(c,n),function(){this.classSuffix="-h",this.onScroll=function(){this.skipEvent||(this.scrollLeft=this.element.scrollLeft,this._emit("scroll",{data:this.scrollLeft})),this.skipEvent=!1},this.getHeight=function(){return this.isVisible?this.height:0},this.setWidth=function(e){this.element.style.width=e+"px"},this.setInnerWidth=function(e){this.inner.style.width=e+"px"},this.setScrollWidth=function(e){this.inner.style.width=e+"px"},this.setScrollLeft=function(e){this.scrollLeft!=e&&(this.skipEvent=!0,this.scrollLeft=this.element.scrollLeft=e)}}.call(c.prototype),t.ScrollBar=l,t.ScrollBarV=l,t.ScrollBarH=c,t.VScrollBar=l,t.HScrollBar=c}),ace.define("ace/renderloop",["require","exports","module","ace/lib/event"],function(e,t,i){"use strict";function n(e,t){this.onRender=e,this.pending=!1,this.changes=0,this.window=t||window}var r=e("./lib/event");(function(){this.schedule=function(e){if(this.changes=this.changes|e,!this.pending&&this.changes){this.pending=!0;var t=this;r.nextFrame(function(){var e;for(t.pending=!1;e=t.changes;)t.changes=0,t.onRender(e)},this.window)}}}).call(n.prototype),t.RenderLoop=n}),ace.define("ace/layer/font_metrics",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/lib/event_emitter"],function(e,t,i){var n=e("../lib/oop"),r=e("../lib/dom"),o=e("../lib/lang"),s=e("../lib/useragent"),a=e("../lib/event_emitter").EventEmitter,l=0,c=t.FontMetrics=function(e){this.el=r.createElement("div"),this.$setMeasureNodeStyles(this.el.style,!0),this.$main=r.createElement("div"),this.$setMeasureNodeStyles(this.$main.style),this.$measureNode=r.createElement("div"),this.$setMeasureNodeStyles(this.$measureNode.style),this.el.appendChild(this.$main),this.el.appendChild(this.$measureNode),e.appendChild(this.el),l||this.$testFractionalRect(),this.$measureNode.innerHTML=o.stringRepeat("X",l),this.$characterSize={width:0,height:0},this.checkForSizeChanges()};(function(){n.implement(this,a),this.$characterSize={width:0,height:0},this.$testFractionalRect=function(){var e=r.createElement("div");this.$setMeasureNodeStyles(e.style),e.style.width="0.2px",document.documentElement.appendChild(e);var t=e.getBoundingClientRect().width;l=0<t&&t<1?50:100,e.parentNode.removeChild(e)},this.$setMeasureNodeStyles=function(e,t){e.width=e.height="auto",e.left=e.top="0px",e.visibility="hidden",e.position="absolute",e.whiteSpace="pre",s.isIE<8?e["font-family"]="inherit":e.font="inherit",e.overflow=t?"hidden":"visible"},this.checkForSizeChanges=function(){var e=this.$measureSizes();if(e&&(this.$characterSize.width!==e.width||this.$characterSize.height!==e.height)){this.$measureNode.style.fontWeight="bold";var t=this.$measureSizes();this.$measureNode.style.fontWeight="",this.$characterSize=e,this.charSizes=Object.create(null),this.allowBoldFonts=t&&t.width===e.width&&t.height===e.height,this._emit("changeCharacterSize",{data:e})}},this.$pollSizeChanges=function(){if(this.$pollSizeChangesTimer)return this.$pollSizeChangesTimer;var e=this;return this.$pollSizeChangesTimer=setInterval(function(){e.checkForSizeChanges()},500)},this.setPolling=function(e){e?this.$pollSizeChanges():this.$pollSizeChangesTimer&&(clearInterval(this.$pollSizeChangesTimer),this.$pollSizeChangesTimer=0)},this.$measureSizes=function(){if(50===l){var t=null;try{t=this.$measureNode.getBoundingClientRect()}catch(e){t={width:0,height:0}}var e={height:t.height,width:t.width/l}}else e={height:this.$measureNode.clientHeight,width:this.$measureNode.clientWidth/l};return 0===e.width||0===e.height?null:e},this.$measureCharWidth=function(e){return this.$main.innerHTML=o.stringRepeat(e,l),this.$main.getBoundingClientRect().width/l},this.getCharacterWidth=function(e){var t=this.charSizes[e];return void 0===t&&(t=this.charSizes[e]=this.$measureCharWidth(e)/this.$characterSize.width),t},this.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.el&&this.el.parentNode&&this.el.parentNode.removeChild(this.el)}}).call(c.prototype)}),ace.define("ace/virtual_renderer",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/config","ace/lib/useragent","ace/layer/gutter","ace/layer/marker","ace/layer/text","ace/layer/cursor","ace/scrollbar","ace/scrollbar","ace/renderloop","ace/layer/font_metrics","ace/lib/event_emitter"],function(e,t,i){"use strict";var n=e("./lib/oop"),o=e("./lib/dom"),s=e("./config"),r=e("./lib/useragent"),a=e("./layer/gutter").Gutter,l=e("./layer/marker").Marker,c=e("./layer/text").Text,h=e("./layer/cursor").Cursor,d=e("./scrollbar").HScrollBar,u=e("./scrollbar").VScrollBar,f=e("./renderloop").RenderLoop,p=e("./layer/font_metrics").FontMetrics,m=e("./lib/event_emitter").EventEmitter;o.importCssString('.ace_editor {position: relative;overflow: hidden;font: 12px/normal \'Monaco\', \'Menlo\', \'Ubuntu Mono\', \'Consolas\', \'source-code-pro\', monospace;direction: ltr;text-align: left;-webkit-tap-highlight-color: rgba(0, 0, 0, 0);}.ace_scroller {position: absolute;overflow: hidden;top: 0;bottom: 0;background-color: inherit;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;cursor: text;}.ace_content {position: absolute;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;min-width: 100%;}.ace_dragging .ace_scroller:before{position: absolute;top: 0;left: 0;right: 0;bottom: 0;content: \'\';background: rgba(250, 250, 250, 0.01);z-index: 1000;}.ace_dragging.ace_dark .ace_scroller:before{background: rgba(0, 0, 0, 0.01);}.ace_selecting, .ace_selecting * {cursor: text !important;}.ace_gutter {position: absolute;overflow : hidden;width: auto;top: 0;bottom: 0;left: 0;cursor: default;z-index: 4;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;}.ace_gutter-active-line {position: absolute;left: 0;right: 0;}.ace_scroller.ace_scroll-left {box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;}.ace_gutter-cell {padding-left: 19px;padding-right: 6px;background-repeat: no-repeat;}.ace_gutter-cell.ace_error {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: 2px center;}.ace_gutter-cell.ace_warning {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==");background-position: 2px center;}.ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=");background-position: 2px center;}.ace_dark .ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC");}.ace_scrollbar {position: absolute;right: 0;bottom: 0;z-index: 6;}.ace_scrollbar-inner {position: absolute;cursor: text;left: 0;top: 0;}.ace_scrollbar-v{overflow-x: hidden;overflow-y: scroll;top: 0;}.ace_scrollbar-h {overflow-x: scroll;overflow-y: hidden;left: 0;}.ace_print-margin {position: absolute;height: 100%;}.ace_text-input {position: absolute;z-index: 0;width: 0.5em;height: 1em;opacity: 0;background: transparent;-moz-appearance: none;appearance: none;border: none;resize: none;outline: none;overflow: hidden;font: inherit;padding: 0 1px;margin: 0 -1px;text-indent: -1em;-ms-user-select: text;-moz-user-select: text;-webkit-user-select: text;user-select: text;white-space: pre!important;}.ace_text-input.ace_composition {background: inherit;color: inherit;z-index: 1000;opacity: 1;text-indent: 0;}.ace_layer {z-index: 1;position: absolute;overflow: hidden;word-wrap: normal;white-space: pre;height: 100%;width: 100%;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;pointer-events: none;}.ace_gutter-layer {position: relative;width: auto;text-align: right;pointer-events: auto;}.ace_text-layer {font: inherit !important;}.ace_cjk {display: inline-block;text-align: center;}.ace_cursor-layer {z-index: 4;}.ace_cursor {z-index: 4;position: absolute;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;border-left: 2px solid;transform: translatez(0);}.ace_multiselect .ace_cursor {border-left-width: 1px;}.ace_slim-cursors .ace_cursor {border-left-width: 1px;}.ace_overwrite-cursors .ace_cursor {border-left-width: 0;border-bottom: 1px solid;}.ace_hidden-cursors .ace_cursor {opacity: 0.2;}.ace_smooth-blinking .ace_cursor {-webkit-transition: opacity 0.18s;transition: opacity 0.18s;}.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {position: absolute;z-index: 3;}.ace_marker-layer .ace_selection {position: absolute;z-index: 5;}.ace_marker-layer .ace_bracket {position: absolute;z-index: 6;}.ace_marker-layer .ace_active-line {position: absolute;z-index: 2;}.ace_marker-layer .ace_selected-word {position: absolute;z-index: 4;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;}.ace_line .ace_fold {-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;display: inline-block;height: 11px;margin-top: -2px;vertical-align: middle;background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=");background-repeat: no-repeat, repeat-x;background-position: center center, top left;color: transparent;border: 1px solid black;border-radius: 2px;cursor: pointer;pointer-events: auto;}.ace_dark .ace_fold {}.ace_fold:hover{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC");}.ace_tooltip {background-color: #FFF;background-image: -webkit-linear-gradient(top, transparent, rgba(0, 0, 0, 0.1));background-image: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.1));border: 1px solid gray;border-radius: 1px;box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);color: black;max-width: 100%;padding: 3px 4px;position: fixed;z-index: 999999;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;cursor: default;white-space: pre;word-wrap: break-word;line-height: normal;font-style: normal;font-weight: normal;letter-spacing: normal;pointer-events: none;}.ace_folding-enabled > .ace_gutter-cell {padding-right: 13px;}.ace_fold-widget {-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;margin: 0 -12px 0 1px;display: none;width: 11px;vertical-align: top;background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: center;border-radius: 3px;border: 1px solid transparent;cursor: pointer;}.ace_folding-enabled .ace_fold-widget {display: inline-block;   }.ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==");}.ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==");}.ace_fold-widget:hover {border: 1px solid rgba(0, 0, 0, 0.3);background-color: rgba(255, 255, 255, 0.2);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);}.ace_fold-widget:active {border: 1px solid rgba(0, 0, 0, 0.4);background-color: rgba(0, 0, 0, 0.05);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);}.ace_dark .ace_fold-widget {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC");}.ace_dark .ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget:hover {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);background-color: rgba(255, 255, 255, 0.1);}.ace_dark .ace_fold-widget:active {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);}.ace_fold-widget.ace_invalid {background-color: #FFB4B4;border-color: #DE5555;}.ace_fade-fold-widgets .ace_fold-widget {-webkit-transition: opacity 0.4s ease 0.05s;transition: opacity 0.4s ease 0.05s;opacity: 0;}.ace_fade-fold-widgets:hover .ace_fold-widget {-webkit-transition: opacity 0.05s ease 0.05s;transition: opacity 0.05s ease 0.05s;opacity:1;}.ace_underline {text-decoration: underline;}.ace_bold {font-weight: bold;}.ace_nobold .ace_bold {font-weight: normal;}.ace_italic {font-style: italic;}.ace_error-marker {background-color: rgba(255, 0, 0,0.2);position: absolute;z-index: 9;}.ace_highlight-marker {background-color: rgba(255, 255, 0,0.2);position: absolute;z-index: 8;}.ace_br1 {border-top-left-radius    : 3px;}.ace_br2 {border-top-right-radius   : 3px;}.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}.ace_br4 {border-bottom-right-radius: 3px;}.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}.ace_br8 {border-bottom-left-radius : 3px;}.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}.ace_text-input-ios {position: absolute !important;top: -100000px !important;left: -100000px !important;}',"ace_editor.css");function g(e,t){var i=this;this.container=e||o.createElement("div"),this.$keepTextAreaAtCursor=!r.isOldIE,o.addCssClass(this.container,"ace_editor"),this.setTheme(t),this.$gutter=o.createElement("div"),this.$gutter.className="ace_gutter",this.container.appendChild(this.$gutter),this.$gutter.setAttribute("aria-hidden",!0),this.scroller=o.createElement("div"),this.scroller.className="ace_scroller",this.container.appendChild(this.scroller),this.content=o.createElement("div"),this.content.className="ace_content",this.scroller.appendChild(this.content),this.$gutterLayer=new a(this.$gutter),this.$gutterLayer.on("changeGutterWidth",this.onGutterResize.bind(this)),this.$markerBack=new l(this.content);var n=this.$textLayer=new c(this.content);this.canvas=n.element,this.$markerFront=new l(this.content),this.$cursorLayer=new h(this.content),this.$horizScroll=!1,this.$vScroll=!1,this.scrollBar=this.scrollBarV=new u(this.container,this),this.scrollBarH=new d(this.container,this),this.scrollBarV.addEventListener("scroll",function(e){i.$scrollAnimation||i.session.setScrollTop(e.data-i.scrollMargin.top)}),this.scrollBarH.addEventListener("scroll",function(e){i.$scrollAnimation||i.session.setScrollLeft(e.data-i.scrollMargin.left)}),this.scrollTop=0,this.scrollLeft=0,this.cursorPos={row:0,column:0},this.$fontMetrics=new p(this.container),this.$textLayer.$setFontMetrics(this.$fontMetrics),this.$textLayer.addEventListener("changeCharacterSize",function(e){i.updateCharacterSize(),i.onResize(!0,i.gutterWidth,i.$size.width,i.$size.height),i._signal("changeCharacterSize",e)}),this.$size={width:0,height:0,scrollerHeight:0,scrollerWidth:0,$dirty:!0},this.layerConfig={width:1,padding:0,firstRow:0,firstRowScreen:0,lastRow:0,lineHeight:0,characterWidth:0,minHeight:1,maxHeight:1,offset:0,height:1,gutterOffset:1},this.scrollMargin={left:0,
right:0,top:0,bottom:0,v:0,h:0},this.$loop=new f(this.$renderChanges.bind(this),this.container.ownerDocument.defaultView),this.$loop.schedule(this.CHANGE_FULL),this.updateCharacterSize(),this.setPadding(4),s.resetOptions(this),s._emit("renderer",this)}(function(){this.CHANGE_CURSOR=1,this.CHANGE_MARKER=2,this.CHANGE_GUTTER=4,this.CHANGE_SCROLL=8,this.CHANGE_LINES=16,this.CHANGE_TEXT=32,this.CHANGE_SIZE=64,this.CHANGE_MARKER_BACK=128,this.CHANGE_MARKER_FRONT=256,this.CHANGE_FULL=512,this.CHANGE_H_SCROLL=1024,n.implement(this,m),this.updateCharacterSize=function(){this.$textLayer.allowBoldFonts!=this.$allowBoldFonts&&(this.$allowBoldFonts=this.$textLayer.allowBoldFonts,this.setStyle("ace_nobold",!this.$allowBoldFonts)),this.layerConfig.characterWidth=this.characterWidth=this.$textLayer.getCharacterWidth(),this.layerConfig.lineHeight=this.lineHeight=this.$textLayer.getLineHeight(),this.$updatePrintMargin()},this.setSession=function(e){this.session&&this.session.doc.off("changeNewLineMode",this.onChangeNewLineMode),(this.session=e)&&this.scrollMargin.top&&e.getScrollTop()<=0&&e.setScrollTop(-this.scrollMargin.top),this.$cursorLayer.setSession(e),this.$markerBack.setSession(e),this.$markerFront.setSession(e),this.$gutterLayer.setSession(e),this.$textLayer.setSession(e),e&&(this.$loop.schedule(this.CHANGE_FULL),this.session.$setFontMetrics(this.$fontMetrics),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.onChangeNewLineMode=this.onChangeNewLineMode.bind(this),this.onChangeNewLineMode(),this.session.doc.on("changeNewLineMode",this.onChangeNewLineMode))},this.updateLines=function(e,t,i){if(void 0===t&&(t=1/0),this.$changedLines?(this.$changedLines.firstRow>e&&(this.$changedLines.firstRow=e),this.$changedLines.lastRow<t&&(this.$changedLines.lastRow=t)):this.$changedLines={firstRow:e,lastRow:t},this.$changedLines.lastRow<this.layerConfig.firstRow){if(!i)return;this.$changedLines.lastRow=this.layerConfig.lastRow}this.$changedLines.firstRow>this.layerConfig.lastRow||this.$loop.schedule(this.CHANGE_LINES)},this.onChangeNewLineMode=function(){this.$loop.schedule(this.CHANGE_TEXT),this.$textLayer.$updateEolChar(),this.session.$bidiHandler.setEolChar(this.$textLayer.EOL_CHAR)},this.onChangeTabSize=function(){this.$loop.schedule(this.CHANGE_TEXT|this.CHANGE_MARKER),this.$textLayer.onChangeTabSize()},this.updateText=function(){this.$loop.schedule(this.CHANGE_TEXT)},this.updateFull=function(e){e?this.$renderChanges(this.CHANGE_FULL,!0):this.$loop.schedule(this.CHANGE_FULL)},this.updateFontSize=function(){this.$textLayer.checkForSizeChanges()},this.$changes=0,this.$updateSizeAsync=function(){this.$loop.pending?this.$size.$dirty=!0:this.onResize()},this.onResize=function(e,t,i,n){if(!(2<this.resizing)){0<this.resizing?this.resizing++:this.resizing=e?1:0;var r=this.container;n=n||(r.clientHeight||r.scrollHeight),i=i||(r.clientWidth||r.scrollWidth);var o=this.$updateCachedSize(e,t,i,n);if(!this.$size.scrollerHeight||!i&&!n)return this.resizing=0;e&&(this.$gutterLayer.$padding=null),e?this.$renderChanges(o|this.$changes,!0):this.$loop.schedule(o|this.$changes),this.resizing&&(this.resizing=0),this.scrollBarV.scrollLeft=this.scrollBarV.scrollTop=null}},this.$updateCachedSize=function(e,t,i,n){n-=this.$extraHeight||0;var r=0,o=this.$size,s={width:o.width,height:o.height,scrollerHeight:o.scrollerHeight,scrollerWidth:o.scrollerWidth};return n&&(e||o.height!=n)&&(o.height=n,r|=this.CHANGE_SIZE,o.scrollerHeight=o.height,this.$horizScroll&&(o.scrollerHeight-=this.scrollBarH.getHeight()),this.scrollBarV.element.style.bottom=this.scrollBarH.getHeight()+"px",r|=this.CHANGE_SCROLL),i&&(e||o.width!=i)&&(r|=this.CHANGE_SIZE,o.width=i,null==t&&(t=this.$showGutter?this.$gutter.offsetWidth:0),this.gutterWidth=t,this.scrollBarH.element.style.left=this.scroller.style.left=t+"px",o.scrollerWidth=Math.max(0,i-t-this.scrollBarV.getWidth()),this.scrollBarH.element.style.right=this.scroller.style.right=this.scrollBarV.getWidth()+"px",this.scroller.style.bottom=this.scrollBarH.getHeight()+"px",(this.session&&this.session.getUseWrapMode()&&this.adjustWrapLimit()||e)&&(r|=this.CHANGE_FULL)),o.$dirty=!i||!n,r&&this._signal("resize",s),r},this.onGutterResize=function(){var e=this.$showGutter?this.$gutter.offsetWidth:0;e!=this.gutterWidth&&(this.$changes|=this.$updateCachedSize(!0,e,this.$size.width,this.$size.height)),this.session.getUseWrapMode()&&this.adjustWrapLimit()?this.$loop.schedule(this.CHANGE_FULL):this.$size.$dirty?this.$loop.schedule(this.CHANGE_FULL):(this.$computeLayerConfig(),this.$loop.schedule(this.CHANGE_MARKER))},this.adjustWrapLimit=function(){var e=this.$size.scrollerWidth-2*this.$padding,t=Math.floor(e/this.characterWidth);return this.session.adjustWrapLimit(t,this.$showPrintMargin&&this.$printMarginColumn)},this.setAnimatedScroll=function(e){this.setOption("animatedScroll",e)},this.getAnimatedScroll=function(){return this.$animatedScroll},this.setShowInvisibles=function(e){this.setOption("showInvisibles",e),this.session.$bidiHandler.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.getOption("showInvisibles")},this.getDisplayIndentGuides=function(){return this.getOption("displayIndentGuides")},this.setDisplayIndentGuides=function(e){this.setOption("displayIndentGuides",e)},this.setShowPrintMargin=function(e){this.setOption("showPrintMargin",e)},this.getShowPrintMargin=function(){return this.getOption("showPrintMargin")},this.setPrintMarginColumn=function(e){this.setOption("printMarginColumn",e)},this.getPrintMarginColumn=function(){return this.getOption("printMarginColumn")},this.getShowGutter=function(){return this.getOption("showGutter")},this.setShowGutter=function(e){return this.setOption("showGutter",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.$updateGutterLineHighlight=function(){var e=this.$cursorLayer.$pixelPos,t=this.layerConfig.lineHeight;if(this.session.getUseWrapMode()){var i=this.session.selection.getCursor();i.column=0,e=this.$cursorLayer.getPixelPosition(i,!0),t*=this.session.getRowLength(i.row)}this.$gutterLineHighlight.style.top=e.top-this.layerConfig.offset+"px",this.$gutterLineHighlight.style.height=t+"px"},this.$updatePrintMargin=function(){if(this.$showPrintMargin||this.$printMarginEl){if(!this.$printMarginEl){var e=o.createElement("div");e.className="ace_layer ace_print-margin-layer",this.$printMarginEl=o.createElement("div"),this.$printMarginEl.className="ace_print-margin",e.appendChild(this.$printMarginEl),this.content.insertBefore(e,this.content.firstChild)}var t=this.$printMarginEl.style;t.left=this.characterWidth*this.$printMarginColumn+this.$padding+"px",t.visibility=this.$showPrintMargin?"visible":"hidden",this.session&&-1==this.session.$wrap&&this.adjustWrapLimit()}},this.getContainerElement=function(){return this.container},this.getMouseEventTarget=function(){return this.scroller},this.getTextAreaContainer=function(){return this.container},this.$moveTextAreaToCursor=function(){if(this.$keepTextAreaAtCursor){var e=this.layerConfig,t=this.$cursorLayer.$pixelPos.top,i=this.$cursorLayer.$pixelPos.left;t-=e.offset;var n=this.textarea.style,r=this.lineHeight;if(t<0||t>e.height-r)n.top=n.left="0";else{var o=this.characterWidth;if(this.$composition){var s=this.textarea.value.replace(/^\x01+/,"");o*=this.session.$getStringScreenWidth(s)[0]+2,r+=2}(i-=this.scrollLeft)>this.$size.scrollerWidth-o&&(i=this.$size.scrollerWidth-o),i+=this.gutterWidth,n.height=r+"px",n.width=o+"px",n.left=Math.min(i,this.$size.scrollerWidth-o)+"px",n.top=Math.min(t,this.$size.height-r)+"px"}}},this.getFirstVisibleRow=function(){return this.layerConfig.firstRow},this.getFirstFullyVisibleRow=function(){return this.layerConfig.firstRow+(0===this.layerConfig.offset?0:1)},this.getLastFullyVisibleRow=function(){var e=this.layerConfig,t=e.lastRow;return this.session.documentToScreenRow(t,0)*e.lineHeight-this.session.getScrollTop()>e.height-e.lineHeight?t-1:t},this.getLastVisibleRow=function(){return this.layerConfig.lastRow},this.$padding=null,this.setPadding=function(e){this.$padding=e,this.$textLayer.setPadding(e),this.$cursorLayer.setPadding(e),this.$markerFront.setPadding(e),this.$markerBack.setPadding(e),this.$loop.schedule(this.CHANGE_FULL),this.$updatePrintMargin()},this.setScrollMargin=function(e,t,i,n){var r=this.scrollMargin;r.top=0|e,r.bottom=0|t,r.right=0|n,r.left=0|i,r.v=r.top+r.bottom,r.h=r.left+r.right,r.top&&this.scrollTop<=0&&this.session&&this.session.setScrollTop(-r.top),this.updateFull()},this.getHScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible},this.setHScrollBarAlwaysVisible=function(e){this.setOption("hScrollBarAlwaysVisible",e)},this.getVScrollBarAlwaysVisible=function(){return this.$vScrollBarAlwaysVisible},this.setVScrollBarAlwaysVisible=function(e){this.setOption("vScrollBarAlwaysVisible",e)},this.$updateScrollBarV=function(){var e=this.layerConfig.maxHeight,t=this.$size.scrollerHeight;!this.$maxLines&&this.$scrollPastEnd&&(e-=(t-this.lineHeight)*this.$scrollPastEnd,this.scrollTop>e-t&&(e=this.scrollTop+t,this.scrollBarV.scrollTop=null)),this.scrollBarV.setScrollHeight(e+this.scrollMargin.v),this.scrollBarV.setScrollTop(this.scrollTop+this.scrollMargin.top)},this.$updateScrollBarH=function(){this.scrollBarH.setScrollWidth(this.layerConfig.width+2*this.$padding+this.scrollMargin.h),this.scrollBarH.setScrollLeft(this.scrollLeft+this.scrollMargin.left)},this.$frozen=!1,this.freeze=function(){this.$frozen=!0},this.unfreeze=function(){this.$frozen=!1},this.$renderChanges=function(e,t){if(this.$changes&&(e|=this.$changes,this.$changes=0),this.session&&this.container.offsetWidth&&!this.$frozen&&(e||t)){if(this.$size.$dirty)return this.$changes|=e,this.onResize(!0);this.lineHeight||this.$textLayer.checkForSizeChanges(),this._signal("beforeRender"),this.session&&this.session.$bidiHandler&&this.session.$bidiHandler.updateCharacterWidths(this.$fontMetrics);var i=this.layerConfig;if(e&this.CHANGE_FULL||e&this.CHANGE_SIZE||e&this.CHANGE_TEXT||e&this.CHANGE_LINES||e&this.CHANGE_SCROLL||e&this.CHANGE_H_SCROLL){if(e|=this.$computeLayerConfig(),i.firstRow!=this.layerConfig.firstRow&&i.firstRowScreen==this.layerConfig.firstRowScreen){var n=this.scrollTop+(i.firstRow-this.layerConfig.firstRow)*this.lineHeight;0<n&&(this.scrollTop=n,e|=this.CHANGE_SCROLL,e|=this.$computeLayerConfig())}i=this.layerConfig,this.$updateScrollBarV(),e&this.CHANGE_H_SCROLL&&this.$updateScrollBarH(),this.$gutterLayer.element.style.marginTop=-i.offset+"px",this.content.style.marginTop=-i.offset+"px",this.content.style.width=i.width+2*this.$padding+"px",this.content.style.height=i.minHeight+"px"}if(e&this.CHANGE_H_SCROLL&&(this.content.style.marginLeft=-this.scrollLeft+"px",this.scroller.className=this.scrollLeft<=0?"ace_scroller":"ace_scroller ace_scroll-left"),e&this.CHANGE_FULL)return this.$textLayer.update(i),this.$showGutter&&this.$gutterLayer.update(i),this.$markerBack.update(i),this.$markerFront.update(i),this.$cursorLayer.update(i),this.$moveTextAreaToCursor(),this.$highlightGutterLine&&this.$updateGutterLineHighlight(),void this._signal("afterRender");if(e&this.CHANGE_SCROLL)return e&this.CHANGE_TEXT||e&this.CHANGE_LINES?this.$textLayer.update(i):this.$textLayer.scrollLines(i),this.$showGutter&&this.$gutterLayer.update(i),this.$markerBack.update(i),this.$markerFront.update(i),this.$cursorLayer.update(i),this.$highlightGutterLine&&this.$updateGutterLineHighlight(),this.$moveTextAreaToCursor(),void this._signal("afterRender");e&this.CHANGE_TEXT?(this.$textLayer.update(i),this.$showGutter&&this.$gutterLayer.update(i)):e&this.CHANGE_LINES?(this.$updateLines()||e&this.CHANGE_GUTTER&&this.$showGutter)&&this.$gutterLayer.update(i):(e&this.CHANGE_TEXT||e&this.CHANGE_GUTTER)&&this.$showGutter&&this.$gutterLayer.update(i),e&this.CHANGE_CURSOR&&(this.$cursorLayer.update(i),this.$moveTextAreaToCursor(),this.$highlightGutterLine&&this.$updateGutterLineHighlight()),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_FRONT)&&this.$markerFront.update(i),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_BACK)&&this.$markerBack.update(i),this._signal("afterRender")}else this.$changes|=e},this.$autosize=function(){var e=this.session.getScreenLength()*this.lineHeight,t=this.$maxLines*this.lineHeight,i=Math.min(t,Math.max((this.$minLines||1)*this.lineHeight,e))+this.scrollMargin.v+(this.$extraHeight||0);this.$horizScroll&&(i+=this.scrollBarH.getHeight()),this.$maxPixelHeight&&i>this.$maxPixelHeight&&(i=this.$maxPixelHeight);var n=t<e;if(i!=this.desiredHeight||this.$size.height!=this.desiredHeight||n!=this.$vScroll){n!=this.$vScroll&&(this.$vScroll=n,this.scrollBarV.setVisible(n));var r=this.container.clientWidth;this.container.style.height=i+"px",this.$updateCachedSize(!0,this.$gutterWidth,r,i),this.desiredHeight=i,this._signal("autosize")}},this.$computeLayerConfig=function(){var e=this.session,t=this.$size,i=t.height<=2*this.lineHeight,n=this.session.getScreenLength()*this.lineHeight,r=this.$getLongestLine(),o=!i&&(this.$hScrollBarAlwaysVisible||t.scrollerWidth-r-2*this.$padding<0),s=this.$horizScroll!==o;s&&(this.$horizScroll=o,this.scrollBarH.setVisible(o));var a=this.$vScroll;this.$maxLines&&1<this.lineHeight&&this.$autosize();var l=this.scrollTop%this.lineHeight,c=t.scrollerHeight+this.lineHeight,h=!this.$maxLines&&this.$scrollPastEnd?(t.scrollerHeight-this.lineHeight)*this.$scrollPastEnd:0;n+=h;var d=this.scrollMargin;this.session.setScrollTop(Math.max(-d.top,Math.min(this.scrollTop,n-t.scrollerHeight+d.bottom))),this.session.setScrollLeft(Math.max(-d.left,Math.min(this.scrollLeft,r+2*this.$padding-t.scrollerWidth+d.right)));var u=!i&&(this.$vScrollBarAlwaysVisible||t.scrollerHeight-n+h<0||this.scrollTop>d.top),f=a!==u;f&&(this.$vScroll=u,this.scrollBarV.setVisible(u));var p,m,g=Math.ceil(c/this.lineHeight)-1,v=Math.max(0,Math.round((this.scrollTop-l)/this.lineHeight)),y=v+g,w=this.lineHeight;v=e.screenToDocumentRow(v,0);var b=e.getFoldLine(v);b&&(v=b.start.row),p=e.documentToScreenRow(v,0),m=e.getRowLength(v)*w,y=Math.min(e.screenToDocumentRow(y,0),e.getLength()-1),c=t.scrollerHeight+e.getRowLength(y)*w+m,l=this.scrollTop-p*w;var C=0;return this.layerConfig.width!=r&&(C=this.CHANGE_H_SCROLL),(s||f)&&(C=this.$updateCachedSize(!0,this.gutterWidth,t.width,t.height),this._signal("scrollbarVisibilityChanged"),f&&(r=this.$getLongestLine())),this.layerConfig={width:r,padding:this.$padding,firstRow:v,firstRowScreen:p,lastRow:y,lineHeight:w,characterWidth:this.characterWidth,minHeight:c,maxHeight:n,offset:l,gutterOffset:w?Math.max(0,Math.ceil((l+t.height-t.scrollerHeight)/w)):0,height:this.$size.scrollerHeight},C},this.$updateLines=function(){if(this.$changedLines){var e=this.$changedLines.firstRow,t=this.$changedLines.lastRow;this.$changedLines=null;var i=this.layerConfig;if(!(e>i.lastRow+1||t<i.firstRow))return t===1/0?(this.$showGutter&&this.$gutterLayer.update(i),void this.$textLayer.update(i)):(this.$textLayer.updateLines(i,e,t),!0)}},this.$getLongestLine=function(){var e=this.session.getScreenWidth();return this.showInvisibles&&!this.session.$useWrapMode&&(e+=1),Math.max(this.$size.scrollerWidth-2*this.$padding,Math.round(e*this.characterWidth))},this.updateFrontMarkers=function(){this.$markerFront.setMarkers(this.session.getMarkers(!0)),this.$loop.schedule(this.CHANGE_MARKER_FRONT)},this.updateBackMarkers=function(){this.$markerBack.setMarkers(this.session.getMarkers()),this.$loop.schedule(this.CHANGE_MARKER_BACK)},this.addGutterDecoration=function(e,t){this.$gutterLayer.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){this.$gutterLayer.removeGutterDecoration(e,t)},this.updateBreakpoints=function(e){this.$loop.schedule(this.CHANGE_GUTTER)},this.setAnnotations=function(e){this.$gutterLayer.setAnnotations(e),this.$loop.schedule(this.CHANGE_GUTTER)},this.updateCursor=function(){this.$loop.schedule(this.CHANGE_CURSOR)},this.hideCursor=function(){this.$cursorLayer.hideCursor()},this.showCursor=function(){this.$cursorLayer.showCursor()},this.scrollSelectionIntoView=function(e,t,i){this.scrollCursorIntoView(e,i),this.scrollCursorIntoView(t,i)},this.scrollCursorIntoView=function(e,t,i){if(0!==this.$size.scrollerHeight){var n=this.$cursorLayer.getPixelPosition(e),r=n.left,o=n.top,s=i&&i.top||0,a=i&&i.bottom||0,l=this.$scrollAnimation?this.session.getScrollTop():this.scrollTop;o<l+s?(t&&l+s>o+this.lineHeight&&(o-=t*this.$size.scrollerHeight),0===o&&(o=-this.scrollMargin.top),this.session.setScrollTop(o)):l+this.$size.scrollerHeight-a<o+this.lineHeight&&(t&&l+this.$size.scrollerHeight-a<o-this.lineHeight&&(o+=t*this.$size.scrollerHeight),this.session.setScrollTop(o+this.lineHeight-this.$size.scrollerHeight));var c=this.scrollLeft;r<c?(r<this.$padding+2*this.layerConfig.characterWidth&&(r=-this.scrollMargin.left),this.session.setScrollLeft(r)):c+this.$size.scrollerWidth<r+this.characterWidth?this.session.setScrollLeft(Math.round(r+this.characterWidth-this.$size.scrollerWidth)):c<=this.$padding&&r-c<this.characterWidth&&this.session.setScrollLeft(0)}},this.getScrollTop=function(){return this.session.getScrollTop()},this.getScrollLeft=function(){return this.session.getScrollLeft()},this.getScrollTopRow=function(){return this.scrollTop/this.lineHeight},this.getScrollBottomRow=function(){return Math.max(0,Math.floor((this.scrollTop+this.$size.scrollerHeight)/this.lineHeight)-1)},this.scrollToRow=function(e){this.session.setScrollTop(e*this.lineHeight)},this.alignCursor=function(e,t){"number"==typeof e&&(e={row:e,column:0});var i=this.$cursorLayer.getPixelPosition(e),n=this.$size.scrollerHeight-this.lineHeight,r=i.top-n*(t||0);return this.session.setScrollTop(r),r},this.STEPS=8,this.$calcSteps=function(e,t){var i,n,r=0,o=this.STEPS,s=[];for(r=0;r<o;++r)s.push((i=r/this.STEPS,(t-(n=e))*(Math.pow(i-1,3)+1)+n));return s},this.scrollToLine=function(e,t,i,n){var r=this.$cursorLayer.getPixelPosition({row:e,column:0}).top;t&&(r-=this.$size.scrollerHeight/2);var o=this.scrollTop;this.session.setScrollTop(r),!1!==i&&this.animateScrolling(o,n)},this.animateScrolling=function(e,t){var i=this.scrollTop;if(this.$animatedScroll){var n=this;if(e!=i){if(this.$scrollAnimation){var r=this.$scrollAnimation.steps;if(r.length&&(e=r[0])==i)return}var o=n.$calcSteps(e,i);this.$scrollAnimation={from:e,to:i,steps:o},clearInterval(this.$timer),n.session.setScrollTop(o.shift()),n.session.$scrollTop=i,this.$timer=setInterval(function(){o.length?(n.session.setScrollTop(o.shift()),n.session.$scrollTop=i):null!=i?(n.session.$scrollTop=-1,n.session.setScrollTop(i),i=null):(n.$timer=clearInterval(n.$timer),n.$scrollAnimation=null,t&&t())},10)}}},this.scrollToY=function(e){this.scrollTop!==e&&(this.$loop.schedule(this.CHANGE_SCROLL),this.scrollTop=e)},this.scrollToX=function(e){this.scrollLeft!==e&&(this.scrollLeft=e),this.$loop.schedule(this.CHANGE_H_SCROLL)},this.scrollTo=function(e,t){this.session.setScrollTop(t),this.session.setScrollLeft(t)},this.scrollBy=function(e,t){t&&this.session.setScrollTop(this.session.getScrollTop()+t),e&&this.session.setScrollLeft(this.session.getScrollLeft()+e)},this.isScrollableBy=function(e,t){return t<0&&this.session.getScrollTop()>=1-this.scrollMargin.top||(0<t&&this.session.getScrollTop()+this.$size.scrollerHeight-this.layerConfig.maxHeight<-1+this.scrollMargin.bottom||(e<0&&this.session.getScrollLeft()>=1-this.scrollMargin.left||(0<e&&this.session.getScrollLeft()+this.$size.scrollerWidth-this.layerConfig.width<-1+this.scrollMargin.right||void 0)))},this.pixelToScreenCoordinates=function(e,t){var i=this.scroller.getBoundingClientRect(),n=e+this.scrollLeft-i.left-this.$padding,r=n/this.characterWidth,o=Math.floor((t+this.scrollTop-i.top)/this.lineHeight),s=Math.round(r);return{row:o,column:s,side:0<r-s?1:-1,offsetX:n}},this.screenToTextCoordinates=function(e,t){var i=this.scroller.getBoundingClientRect(),n=e+this.scrollLeft-i.left-this.$padding,r=Math.round(n/this.characterWidth),o=(t+this.scrollTop-i.top)/this.lineHeight;return this.session.screenToDocumentPosition(o,Math.max(r,0),n)},this.textToScreenCoordinates=function(e,t){var i=this.scroller.getBoundingClientRect(),n=this.session.documentToScreenPosition(e,t),r=this.$padding+(this.session.$bidiHandler.isBidiRow(n.row,e)?this.session.$bidiHandler.getPosLeft(n.column):Math.round(n.column*this.characterWidth)),o=n.row*this.lineHeight;return{pageX:i.left+r-this.scrollLeft,pageY:i.top+o-this.scrollTop}},this.visualizeFocus=function(){o.addCssClass(this.container,"ace_focus")},this.visualizeBlur=function(){o.removeCssClass(this.container,"ace_focus")},this.showComposition=function(e){this.$composition||(this.$composition={keepTextAreaAtCursor:this.$keepTextAreaAtCursor,cssText:this.textarea.style.cssText}),this.$keepTextAreaAtCursor=!0,o.addCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText="",this.$moveTextAreaToCursor()},this.setCompositionText=function(e){this.$moveTextAreaToCursor()},this.hideComposition=function(){this.$composition&&(o.removeCssClass(this.textarea,"ace_composition"),this.$keepTextAreaAtCursor=this.$composition.keepTextAreaAtCursor,this.textarea.style.cssText=this.$composition.cssText,this.$composition=null)},this.setTheme=function(i,n){var r=this;if(this.$themeId=i,r._dispatchEvent("themeChange",{theme:i}),i&&"string"!=typeof i)t(i);else{var e=i||this.$options.theme.initialValue;s.loadModule(["theme",e],t)}function t(e){if(r.$themeId!=i)return n&&n();if(!e||!e.cssClass)throw new Error("couldn't load module "+i+" or it didn't call define");o.importCssString(e.cssText,e.cssClass,r.container.ownerDocument),r.theme&&o.removeCssClass(r.container,r.theme.cssClass);var t="padding"in e?e.padding:"padding"in(r.theme||{})?4:r.$padding;r.$padding&&t!=r.$padding&&r.setPadding(t),r.$theme=e.cssClass,r.theme=e,o.addCssClass(r.container,e.cssClass),o.setCssClass(r.container,"ace_dark",e.isDark),r.$size&&(r.$size.width=0,r.$updateSizeAsync()),r._dispatchEvent("themeLoaded",{theme:e}),n&&n()}},this.getTheme=function(){return this.$themeId},this.setStyle=function(e,t){o.setCssClass(this.container,e,!1!==t)},this.unsetStyle=function(e){o.removeCssClass(this.container,e)},this.setCursorStyle=function(e){this.scroller.style.cursor!=e&&(this.scroller.style.cursor=e)},this.setMouseCursor=function(e){this.scroller.style.cursor=e},this.destroy=function(){this.$textLayer.destroy(),this.$cursorLayer.destroy()}}).call(g.prototype),s.defineOptions(g.prototype,"renderer",{animatedScroll:{initialValue:!1},showInvisibles:{set:function(e){this.$textLayer.setShowInvisibles(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!1},showPrintMargin:{set:function(){this.$updatePrintMargin()},initialValue:!0},printMarginColumn:{set:function(){this.$updatePrintMargin()},initialValue:80},printMargin:{set:function(e){"number"==typeof e&&(this.$printMarginColumn=e),this.$showPrintMargin=!!e,this.$updatePrintMargin()},get:function(){return this.$showPrintMargin&&this.$printMarginColumn}},showGutter:{set:function(e){this.$gutter.style.display=e?"block":"none",this.$loop.schedule(this.CHANGE_FULL),this.onGutterResize()},initialValue:!0},fadeFoldWidgets:{set:function(e){o.setCssClass(this.$gutter,"ace_fade-fold-widgets",e)},initialValue:!1},showFoldWidgets:{set:function(e){this.$gutterLayer.setShowFoldWidgets(e)},initialValue:!0},showLineNumbers:{set:function(e){this.$gutterLayer.setShowLineNumbers(e),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},displayIndentGuides:{set:function(e){this.$textLayer.setDisplayIndentGuides(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!0},highlightGutterLine:{set:function(e){if(!this.$gutterLineHighlight)return this.$gutterLineHighlight=o.createElement("div"),this.$gutterLineHighlight.className="ace_gutter-active-line",void this.$gutter.appendChild(this.$gutterLineHighlight);this.$gutterLineHighlight.style.display=e?"":"none",this.$cursorLayer.$pixelPos&&this.$updateGutterLineHighlight()},initialValue:!1,value:!0},hScrollBarAlwaysVisible:{set:function(e){this.$hScrollBarAlwaysVisible&&this.$horizScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},vScrollBarAlwaysVisible:{set:function(e){this.$vScrollBarAlwaysVisible&&this.$vScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},fontSize:{set:function(e){"number"==typeof e&&(e+="px"),this.container.style.fontSize=e,this.updateFontSize()},initialValue:12},fontFamily:{set:function(e){this.container.style.fontFamily=e,this.updateFontSize()}},maxLines:{set:function(e){this.updateFull()}},minLines:{set:function(e){this.updateFull()}},maxPixelHeight:{set:function(e){this.updateFull()},initialValue:0},scrollPastEnd:{set:function(e){e=+e||0,this.$scrollPastEnd!=e&&(this.$scrollPastEnd=e,this.$loop.schedule(this.CHANGE_SCROLL))},initialValue:0,handlesSet:!0},fixedWidthGutter:{set:function(e){this.$gutterLayer.$fixedWidth=!!e,this.$loop.schedule(this.CHANGE_GUTTER)}},theme:{set:function(e){this.setTheme(e)},get:function(){return this.$themeId||this.theme},initialValue:"./theme/textmate",handlesSet:!0}}),t.VirtualRenderer=g}),ace.define("ace/worker/worker_client",["require","exports","module","ace/lib/oop","ace/lib/net","ace/lib/event_emitter","ace/config"],function(a,e,t){"use strict";var i=a("../lib/oop"),r=a("../lib/net"),l=a("../lib/event_emitter").EventEmitter,c=a("../config");function h(e,t){var i=function(e,t){var i=t.src;r.qualifyURL(e);try{return new Blob([i],{type:"application/javascript"})}catch(e){var n=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder);return n.append(i),n.getBlob("application/javascript")}}(e,t),n=(window.URL||window.webkitURL).createObjectURL(i);return new Worker(n)}function n(e,t,i,n,r){if(this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.onMessage=this.onMessage.bind(this),a.nameToUrl&&!a.toUrl&&(a.toUrl=a.nameToUrl),c.get("packaged")||!a.toUrl)n=n||c.moduleUrl(t.id,"worker");else{var o=this.$normalizePath;n=n||o(a.toUrl("ace/worker/worker.js",null,"_"));var s={};e.forEach(function(e){s[e]=o(a.toUrl(e,null,"_").replace(/(\.js)?(\?.*)?$/,""))})}this.$worker=h(n,t),r&&this.send("importScripts",r),this.$worker.postMessage({init:!0,tlns:s,module:t.id,classname:i}),this.callbackId=1,this.callbacks={},this.$worker.onmessage=this.onMessage}(function(){i.implement(this,l),this.onMessage=function(e){var t=e.data;switch(t.type){case"event":this._signal(t.name,{data:t.data});break;case"call":var i=this.callbacks[t.id];i&&(i(t.data),delete this.callbacks[t.id]);break;case"error":this.reportError(t.data);break;case"log":window.console&&console.log&&console.log.apply(console,t.data)}},this.reportError=function(e){window.console&&console.error&&console.error(e)},this.$normalizePath=function(e){return r.qualifyURL(e)},this.terminate=function(){this._signal("terminate",{}),this.deltaQueue=null,this.$worker.terminate(),this.$worker=null,this.$doc&&this.$doc.off("change",this.changeListener),this.$doc=null},this.send=function(e,t){this.$worker.postMessage({command:e,args:t})},this.call=function(e,t,i){if(i){var n=this.callbackId++;this.callbacks[n]=i,t.push(n)}this.send(e,t)},this.emit=function(e,t){try{this.$worker.postMessage({event:e,data:{data:t.data}})}catch(e){console.error(e.stack)}},this.attachToDocument=function(e){this.$doc&&this.terminate(),this.$doc=e,this.call("setValue",[e.getValue()]),e.on("change",this.changeListener)},this.changeListener=function(e){this.deltaQueue||(this.deltaQueue=[],setTimeout(this.$sendDeltaQueue,0)),"insert"==e.action?this.deltaQueue.push(e.start,e.lines):this.deltaQueue.push(e.start,e.end)},this.$sendDeltaQueue=function(){var e=this.deltaQueue;e&&(this.deltaQueue=null,50<e.length&&e.length>this.$doc.getLength()>>1?this.call("setValue",[this.$doc.getValue()]):this.emit("change",{data:e}))}}).call(n.prototype);function o(e,t,i){this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.callbackId=1,this.callbacks={},this.messageBuffer=[];var n=null,r=!1,o=Object.create(l),s=this;this.$worker={},this.$worker.terminate=function(){},this.$worker.postMessage=function(e){s.messageBuffer.push(e),n&&(r?setTimeout(a):a())},this.setEmitSync=function(e){r=e};var a=function(){var e=s.messageBuffer.shift();e.command?n[e.command].apply(n,e.args):e.event&&o._signal(e.event,e.data)};o.postMessage=function(e){s.onMessage({data:e})},o.callback=function(e,t){this.postMessage({type:"call",id:t,data:e})},o.emit=function(e,t){this.postMessage({type:"event",name:e,data:t})},c.loadModule(["worker",t],function(e){for(n=new e[i](o);s.messageBuffer.length;)a()})}o.prototype=n.prototype,e.UIWorkerClient=o,e.WorkerClient=n,e.createWorker=h}),ace.define("ace/placeholder",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/oop"],function(e,t,i){"use strict";function n(e,t,i,n,r,o){var s=this;this.length=t,this.session=e,this.doc=e.getDocument(),this.mainClass=r,this.othersClass=o,this.$onUpdate=this.onUpdate.bind(this),this.doc.on("change",this.$onUpdate),this.$others=n,this.$onCursorChange=function(){setTimeout(function(){s.onCursorChange()})},this.$pos=i;var a=e.getUndoManager().$undoStack||e.getUndoManager().$undostack||{length:-1};this.$undoStackDepth=a.length,this.setup(),e.selection.on("changeCursor",this.$onCursorChange)}var l=e("./range").Range,r=e("./lib/event_emitter").EventEmitter,o=e("./lib/oop");(function(){o.implement(this,r),this.setup=function(){var i=this,n=this.doc,e=this.session;this.selectionBefore=e.selection.toJSON(),e.selection.inMultiSelectMode&&e.selection.toSingleRange(),this.pos=n.createAnchor(this.$pos.row,this.$pos.column);var t=this.pos;t.$insertRight=!0,t.detach(),t.markerId=e.addMarker(new l(t.row,t.column,t.row,t.column+this.length),this.mainClass,null,!1),this.others=[],this.$others.forEach(function(e){var t=n.createAnchor(e.row,e.column);t.$insertRight=!0,t.detach(),i.others.push(t)}),e.setUndoSelect(!1)},this.showOtherMarkers=function(){if(!this.othersActive){var t=this.session,i=this;this.othersActive=!0,this.others.forEach(function(e){e.markerId=t.addMarker(new l(e.row,e.column,e.row,e.column+i.length),i.othersClass,null,!1)})}},this.hideOtherMarkers=function(){if(this.othersActive){this.othersActive=!1;for(var e=0;e<this.others.length;e++)this.session.removeMarker(this.others[e].markerId)}},this.onUpdate=function(e){if(this.$updating)return this.updateAnchors(e);var t=e;if(t.start.row===t.end.row&&t.start.row===this.pos.row){this.$updating=!0;var i="insert"===e.action?t.end.column-t.start.column:t.start.column-t.end.column,n=t.start.column>=this.pos.column&&t.start.column<=this.pos.column+this.length+1,r=t.start.column-this.pos.column;if(this.updateAnchors(e),n&&(this.length+=i),n&&!this.session.$fromUndo)if("insert"===e.action)for(var o=this.others.length-1;0<=o;o--){var s={row:(a=this.others[o]).row,column:a.column+r};this.doc.insertMergedLines(s,e.lines)}else if("remove"===e.action)for(o=this.others.length-1;0<=o;o--){var a;s={row:(a=this.others[o]).row,column:a.column+r};this.doc.remove(new l(s.row,s.column,s.row,s.column-i))}this.$updating=!1,this.updateMarkers()}},this.updateAnchors=function(e){this.pos.onChange(e);for(var t=this.others.length;t--;)this.others[t].onChange(e);this.updateMarkers()},this.updateMarkers=function(){if(!this.$updating){var i=this,n=this.session,e=function(e,t){n.removeMarker(e.markerId),e.markerId=n.addMarker(new l(e.row,e.column,e.row,e.column+i.length),t,null,!1)};e(this.pos,this.mainClass);for(var t=this.others.length;t--;)e(this.others[t],this.othersClass)}},this.onCursorChange=function(e){if(!this.$updating&&this.session){var t=this.session.selection.getCursor();t.row===this.pos.row&&t.column>=this.pos.column&&t.column<=this.pos.column+this.length?(this.showOtherMarkers(),this._emit("cursorEnter",e)):(this.hideOtherMarkers(),this._emit("cursorLeave",e))}},this.detach=function(){this.session.removeMarker(this.pos&&this.pos.markerId),this.hideOtherMarkers(),this.doc.removeEventListener("change",this.$onUpdate),this.session.selection.removeEventListener("changeCursor",this.$onCursorChange),this.session.setUndoSelect(!0),this.session=null},this.cancel=function(){if(-1!==this.$undoStackDepth){for(var e=this.session.getUndoManager(),t=(e.$undoStack||e.$undostack).length-this.$undoStackDepth,i=0;i<t;i++)e.undo(!0);this.selectionBefore&&this.session.selection.fromJSON(this.selectionBefore)}}}).call(n.prototype),t.PlaceHolder=n}),ace.define("ace/mouse/multi_select_handler",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(e,t,i){var F=e("../lib/event"),S=e("../lib/useragent");function _(e,t){return e.row==t.row&&e.column==t.column}t.onMouseDown=function(e){var t=e.domEvent,i=t.altKey,n=t.shiftKey,r=t.ctrlKey,o=e.getAccelKey(),s=e.getButton();if(r&&S.isMac&&(s=t.button),e.editor.inMultiSelectMode&&2==s)e.editor.textInput.onContextMenu(e.domEvent);else if(r||i||o){if(0===s){var a,l=e.editor,c=l.selection,h=l.inMultiSelectMode,d=e.getDocumentPosition(),u=c.getCursor(),f=e.inSelection()||c.isEmpty()&&_(d,u),p=e.x,m=e.y,g=l.session,v=l.renderer.pixelToScreenCoordinates(p,m),y=v;if(l.$mouseHandler.$enableJumpToDef)r&&i||o&&i?a=n?"block":"add":i&&l.$blockSelectEnabled&&(a="block");else if(o&&!i){if(a="add",!h&&n)return}else i&&l.$blockSelectEnabled&&(a="block");if(a&&S.isMac&&t.ctrlKey&&l.$mouseHandler.cancelContextMenu(),"add"==a){if(!h&&f)return;if(!h){var w=c.toOrientedRange();l.addSelectionMarker(w)}var b=c.rangeList.rangeAtPoint(d);l.$blockScrolling++,l.inVirtualSelectionMode=!0,n&&(b=null,w=c.ranges[0]||w,l.removeSelectionMarker(w)),l.once("mouseup",function(){var e=c.toOrientedRange();b&&e.isEmpty()&&_(b.cursor,e.cursor)?c.substractPoint(e.cursor):(n?c.substractPoint(w.cursor):w&&(l.removeSelectionMarker(w),c.addRange(w)),c.addRange(e)),l.$blockScrolling--,l.inVirtualSelectionMode=!1})}else if("block"==a){var C;e.stop(),l.inVirtualSelectionMode=!0;var E=[];l.$blockScrolling++,h&&!o?c.toSingleRange():!h&&o&&(C=c.toOrientedRange(),l.addSelectionMarker(C)),n?v=g.documentToScreenPosition(c.lead):c.moveToPosition(d),l.$blockScrolling--,y={row:-1,column:-1};var A=function(){var e=l.renderer.pixelToScreenCoordinates(p,m),t=g.screenToDocumentPosition(e.row,e.column,e.offsetX);_(y,e)&&_(t,c.lead)||(y=e,l.$blockScrolling++,l.selection.moveToPosition(t),l.renderer.scrollCursorIntoView(),l.removeSelectionMarkers(E),E=c.rectangularRangeBlock(y,v),l.$mouseHandler.$clickSelection&&1==E.length&&E[0].isEmpty()&&(E[0]=l.$mouseHandler.$clickSelection.clone()),E.forEach(l.addSelectionMarker,l),l.updateSelectionMarkers(),l.$blockScrolling--)};F.capture(l.container,function(e){p=e.clientX,m=e.clientY},function(e){clearInterval(x),l.removeSelectionMarkers(E),E.length||(E=[c.toOrientedRange()]),l.$blockScrolling++,C&&(l.removeSelectionMarker(C),c.toSingleRange(C));for(var t=0;t<E.length;t++)c.addRange(E[t]);l.inVirtualSelectionMode=!1,l.$mouseHandler.$clickSelection=null,l.$blockScrolling--});var x=setInterval(function(){A()},20);return e.preventDefault()}}}else 0===s&&e.editor.inMultiSelectMode&&e.editor.exitMultiSelectMode()}}),ace.define("ace/commands/multi_select_commands",["require","exports","module","ace/keyboard/hash_handler"],function(e,t,i){t.defaultCommands=[{name:"addCursorAbove",exec:function(e){e.selectMoreLines(-1)},bindKey:{win:"Ctrl-Alt-Up",mac:"Ctrl-Alt-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelow",exec:function(e){e.selectMoreLines(1)},bindKey:{win:"Ctrl-Alt-Down",mac:"Ctrl-Alt-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorAboveSkipCurrent",exec:function(e){e.selectMoreLines(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Up",mac:"Ctrl-Alt-Shift-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelowSkipCurrent",exec:function(e){e.selectMoreLines(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Down",mac:"Ctrl-Alt-Shift-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreBefore",exec:function(e){e.selectMore(-1)},bindKey:{win:"Ctrl-Alt-Left",mac:"Ctrl-Alt-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreAfter",exec:function(e){e.selectMore(1)},bindKey:{win:"Ctrl-Alt-Right",mac:"Ctrl-Alt-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextBefore",exec:function(e){e.selectMore(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Left",mac:"Ctrl-Alt-Shift-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextAfter",exec:function(e){e.selectMore(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Right",mac:"Ctrl-Alt-Shift-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"splitIntoLines",exec:function(e){e.multiSelect.splitIntoLines()},bindKey:{win:"Ctrl-Alt-L",mac:"Ctrl-Alt-L"},readOnly:!0},{name:"alignCursors",exec:function(e){e.alignCursors()},bindKey:{win:"Ctrl-Alt-A",mac:"Ctrl-Alt-A"},scrollIntoView:"cursor"},{name:"findAll",exec:function(e){e.findAll()},bindKey:{win:"Ctrl-Alt-K",mac:"Ctrl-Alt-G"},scrollIntoView:"cursor",readOnly:!0}],t.multiSelectCommands=[{name:"singleSelection",bindKey:"esc",exec:function(e){e.exitMultiSelectMode()},scrollIntoView:"cursor",readOnly:!0,isAvailable:function(e){return e&&e.inMultiSelectMode}}];var n=e("../keyboard/hash_handler").HashHandler;t.keyboardHandler=new n(t.multiSelectCommands)}),ace.define("ace/multi_select",["require","exports","module","ace/range_list","ace/range","ace/selection","ace/mouse/multi_select_handler","ace/lib/event","ace/lib/lang","ace/commands/multi_select_commands","ace/search","ace/edit_session","ace/editor","ace/config"],function(e,t,i){var n=e("./range_list").RangeList,b=e("./range").Range,m=e("./selection").Selection,r=e("./mouse/multi_select_handler").onMouseDown,o=e("./lib/event"),g=e("./lib/lang"),s=e("./commands/multi_select_commands");t.commands=s.defaultCommands.concat(s.multiSelectCommands);var a=new(e("./search").Search);var l=e("./edit_session").EditSession;(function(){this.getSelectionMarkers=function(){return this.$selectionMarkers}}).call(l.prototype),function(){this.ranges=null,this.rangeList=null,this.addRange=function(e,t){if(e){if(!this.inMultiSelectMode&&0===this.rangeCount){var i=this.toOrientedRange();if(this.rangeList.add(i),this.rangeList.add(e),2!=this.rangeList.ranges.length)return this.rangeList.removeAll(),t||this.fromOrientedRange(e);this.rangeList.removeAll(),this.rangeList.add(i),this.$onAddRange(i)}e.cursor||(e.cursor=e.end);var n=this.rangeList.add(e);return this.$onAddRange(e),n.length&&this.$onRemoveRange(n),1<this.rangeCount&&!this.inMultiSelectMode&&(this._signal("multiSelect"),this.inMultiSelectMode=!0,this.session.$undoSelect=!1,this.rangeList.attach(this.session)),t||this.fromOrientedRange(e)}},this.toSingleRange=function(e){e=e||this.ranges[0];var t=this.rangeList.removeAll();t.length&&this.$onRemoveRange(t),e&&this.fromOrientedRange(e)},this.substractPoint=function(e){var t=this.rangeList.substractPoint(e);if(t)return this.$onRemoveRange(t),t[0]},this.mergeOverlappingRanges=function(){var e=this.rangeList.merge();e.length?this.$onRemoveRange(e):this.ranges[0]&&this.fromOrientedRange(this.ranges[0])},this.$onAddRange=function(e){this.rangeCount=this.rangeList.ranges.length,this.ranges.unshift(e),this._signal("addRange",{range:e})},this.$onRemoveRange=function(e){if(this.rangeCount=this.rangeList.ranges.length,1==this.rangeCount&&this.inMultiSelectMode){var t=this.rangeList.ranges.pop();e.push(t),this.rangeCount=0}for(var i=e.length;i--;){var n=this.ranges.indexOf(e[i]);this.ranges.splice(n,1)}this._signal("removeRange",{ranges:e}),0===this.rangeCount&&this.inMultiSelectMode&&(this.inMultiSelectMode=!1,this._signal("singleSelect"),this.session.$undoSelect=!0,this.rangeList.detach(this.session)),(t=t||this.ranges[0])&&!t.isEqual(this.getRange())&&this.fromOrientedRange(t)},this.$initRangeList=function(){this.rangeList||(this.rangeList=new n,this.ranges=[],this.rangeCount=0)},this.getAllRanges=function(){return this.rangeCount?this.rangeList.ranges.concat():[this.getRange()]},this.splitIntoLines=function(){if(1<this.rangeCount){var e=this.rangeList.ranges,t=e[e.length-1],i=b.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(i,t.cursor==t.start)}else{i=this.getRange();var n=this.isBackwards(),r=i.start.row,o=i.end.row;if(r==o){if(n)var s=i.end,a=i.start;else s=i.start,a=i.end;return this.addRange(b.fromPoints(a,a)),void this.addRange(b.fromPoints(s,s))}var l=[],c=this.getLineRange(r,!0);c.start.column=i.start.column,l.push(c);for(var h=r+1;h<o;h++)l.push(this.getLineRange(h,!0));(c=this.getLineRange(o,!0)).end.column=i.end.column,l.push(c),l.forEach(this.addRange,this)}},this.toggleBlockSelection=function(){if(1<this.rangeCount){var e=this.rangeList.ranges,t=e[e.length-1],i=b.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(i,t.cursor==t.start)}else{var n=this.session.documentToScreenPosition(this.selectionLead),r=this.session.documentToScreenPosition(this.selectionAnchor);this.rectangularRangeBlock(n,r).forEach(this.addRange,this)}},this.rectangularRangeBlock=function(e,t,i){var n=[],r=e.column<t.column;if(r)var o=e.column,s=t.column,a=e.offsetX,l=t.offsetX;else o=t.column,s=e.column,a=t.offsetX,l=e.offsetX;var c,h,d=e.row<t.row;if(d)var u=e.row,f=t.row;else u=t.row,f=e.row;o<0&&(o=0),u<0&&(u=0),u==f&&(i=!0);for(var p=u;p<=f;p++){var m=b.fromPoints(this.session.screenToDocumentPosition(p,o,a),this.session.screenToDocumentPosition(p,s,l));if(m.isEmpty()){if(g&&(c=m.end,h=g,c.row==h.row&&c.column==h.column))break;var g=m.end}m.cursor=r?m.start:m.end,n.push(m)}if(d&&n.reverse(),!i){for(var v=n.length-1;n[v].isEmpty()&&0<v;)v--;if(0<v)for(var y=0;n[y].isEmpty();)y++;for(var w=v;y<=w;w--)n[w].isEmpty()&&n.splice(w,1)}return n}}.call(m.prototype);var c=e("./editor").Editor;function h(e){e.$multiselectOnSessionChange||(e.$onAddRange=e.$onAddRange.bind(e),e.$onRemoveRange=e.$onRemoveRange.bind(e),e.$onMultiSelect=e.$onMultiSelect.bind(e),e.$onSingleSelect=e.$onSingleSelect.bind(e),e.$multiselectOnSessionChange=t.onSessionChange.bind(e),e.$checkMultiselectChange=e.$checkMultiselectChange.bind(e),e.$multiselectOnSessionChange(e),e.on("changeSession",e.$multiselectOnSessionChange),e.on("mousedown",r),e.commands.addCommands(s.defaultCommands),function(i){var e=i.textInput.getElement(),n=!1;function r(e){n&&(i.renderer.setMouseCursor(""),n=!1)}o.addListener(e,"keydown",function(e){var t=18==e.keyCode&&!(e.ctrlKey||e.shiftKey||e.metaKey);i.$blockSelectEnabled&&t?n||(i.renderer.setMouseCursor("crosshair"),n=!0):n&&r()}),o.addListener(e,"keyup",r),o.addListener(e,"blur",r)}(e))}(function(){this.updateSelectionMarkers=function(){this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.addSelectionMarker=function(e){e.cursor||(e.cursor=e.end);var t=this.getSelectionStyle();return e.marker=this.session.addMarker(e,"ace_selection",t),this.session.$selectionMarkers.push(e),this.session.selectionMarkerCount=this.session.$selectionMarkers.length,e},this.removeSelectionMarker=function(e){if(e.marker){this.session.removeMarker(e.marker);var t=this.session.$selectionMarkers.indexOf(e);-1!=t&&this.session.$selectionMarkers.splice(t,1),this.session.selectionMarkerCount=this.session.$selectionMarkers.length}},this.removeSelectionMarkers=function(e){for(var t=this.session.$selectionMarkers,i=e.length;i--;){var n=e[i];if(n.marker){this.session.removeMarker(n.marker);var r=t.indexOf(n);-1!=r&&t.splice(r,1)}}this.session.selectionMarkerCount=t.length},this.$onAddRange=function(e){this.addSelectionMarker(e.range),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onRemoveRange=function(e){this.removeSelectionMarkers(e.ranges),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onMultiSelect=function(e){this.inMultiSelectMode||(this.inMultiSelectMode=!0,this.setStyle("ace_multiselect"),this.keyBinding.addKeyboardHandler(s.keyboardHandler),this.commands.setDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers())},this.$onSingleSelect=function(e){this.session.multiSelect.inVirtualMode||(this.inMultiSelectMode=!1,this.unsetStyle("ace_multiselect"),this.keyBinding.removeKeyboardHandler(s.keyboardHandler),this.commands.removeDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers(),this._emit("changeSelection"))},this.$onMultiSelectExec=function(e){var t=e.command,i=e.editor;if(i.multiSelect){if(t.multiSelectAction)n="forEach"==t.multiSelectAction?i.forEachSelection(t,e.args):"forEachLine"==t.multiSelectAction?i.forEachSelection(t,e.args,!0):"single"==t.multiSelectAction?(i.exitMultiSelectMode(),t.exec(i,e.args||{})):t.multiSelectAction(i,e.args||{});else{var n=t.exec(i,e.args||{});i.multiSelect.addRange(i.multiSelect.toOrientedRange()),i.multiSelect.mergeOverlappingRanges()}return n}},this.forEachSelection=function(e,t,i){if(!this.inVirtualSelectionMode){var n,r=i&&i.keepOrder,o=1==i||i&&i.$byLines,s=this.session,a=this.selection,l=a.rangeList,c=(r?a:l).ranges;if(!c.length)return e.exec?e.exec(this,t||{}):e(this,t||{});var h=a._eventRegistry;a._eventRegistry={};var d=new m(s);this.inVirtualSelectionMode=!0;for(var u=c.length;u--;){if(o)for(;0<u&&c[u].start.row==c[u-1].end.row;)u--;d.fromOrientedRange(c[u]),d.index=u,this.selection=s.selection=d;var f=e.exec?e.exec(this,t||{}):e(this,t||{});n||void 0===f||(n=f),d.toOrientedRange(c[u])}d.detach(),this.selection=s.selection=a,this.inVirtualSelectionMode=!1,a._eventRegistry=h,a.mergeOverlappingRanges();var p=this.renderer.$scrollAnimation;return this.onCursorChange(),this.onSelectionChange(),p&&p.from==p.to&&this.renderer.animateScrolling(p.from),n}},this.exitMultiSelectMode=function(){this.inMultiSelectMode&&!this.inVirtualSelectionMode&&this.multiSelect.toSingleRange()},this.getSelectedText=function(){var e="";if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){for(var t=this.multiSelect.rangeList.ranges,i=[],n=0;n<t.length;n++)i.push(this.session.getTextRange(t[n]));var r=this.session.getDocument().getNewLineCharacter();(e=i.join(r)).length==(i.length-1)*r.length&&(e="")}else this.selection.isEmpty()||(e=this.session.getTextRange(this.getSelectionRange()));return e},this.$checkMultiselectChange=function(e,t){if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){var i=this.multiSelect.ranges[0];if(this.multiSelect.isEmpty()&&t==this.multiSelect.anchor)return;var n=t==this.multiSelect.anchor?i.cursor==i.start?i.end:i.start:i.cursor;n.row==t.row&&this.session.$clipPositionToDocument(n.row,n.column).column==t.column||this.multiSelect.toSingleRange(this.multiSelect.toOrientedRange())}},this.findAll=function(e,t,i){if((t=t||{}).needle=e||t.needle,null==t.needle){var n=this.selection.isEmpty()?this.selection.getWordRange():this.selection.getRange();t.needle=this.session.getTextRange(n)}this.$search.set(t);var r=this.$search.findAll(this.session);if(!r.length)return 0;this.$blockScrolling+=1;var o=this.multiSelect;i||o.toSingleRange(r[0]);for(var s=r.length;s--;)o.addRange(r[s],!0);return n&&o.rangeList.rangeAtPoint(n.start)&&o.addRange(n,!0),this.$blockScrolling-=1,r.length},this.selectMoreLines=function(e,t){var i=this.selection.toOrientedRange(),n=i.cursor==i.end,r=this.session.documentToScreenPosition(i.cursor);this.selection.$desiredColumn&&(r.column=this.selection.$desiredColumn);var o,s=this.session.screenToDocumentPosition(r.row+e,r.column);if(i.isEmpty())l=s;else var a=this.session.documentToScreenPosition(n?i.end:i.start),l=this.session.screenToDocumentPosition(a.row+e,a.column);n?(o=b.fromPoints(s,l)).cursor=o.start:(o=b.fromPoints(l,s)).cursor=o.end;if(o.desiredColumn=r.column,this.selection.inMultiSelectMode){if(t)var c=i.cursor}else this.selection.addRange(i);this.selection.addRange(o),c&&this.selection.substractPoint(c)},this.transposeSelections=function(e){for(var t=this.session,i=t.multiSelect,n=i.ranges,r=n.length;r--;){if((a=n[r]).isEmpty()){var o=t.getWordRange(a.start.row,a.start.column);a.start.row=o.start.row,a.start.column=o.start.column,a.end.row=o.end.row,a.end.column=o.end.column}}i.mergeOverlappingRanges();var s=[];for(r=n.length;r--;){var a=n[r];s.unshift(t.getTextRange(a))}e<0?s.unshift(s.pop()):s.push(s.shift());for(r=n.length;r--;){o=(a=n[r]).clone();t.replace(a,s[r]),a.start.row=o.start.row,a.start.column=o.start.column}},this.selectMore=function(e,t,i){var n=this.session,r=n.multiSelect.toOrientedRange();if(!r.isEmpty()||((r=n.getWordRange(r.start.row,r.start.column)).cursor=-1==e?r.start:r.end,this.multiSelect.addRange(r),!i)){var o=n.getTextRange(r),s=function(e,t,i){return a.$options.wrap=!0,a.$options.needle=t,a.$options.backwards=-1==i,a.find(e)}(n,o,e);s&&(s.cursor=-1==e?s.start:s.end,this.$blockScrolling+=1,this.session.unfold(s),this.multiSelect.addRange(s),this.$blockScrolling-=1,this.renderer.scrollCursorIntoView(null,.5)),t&&this.multiSelect.substractPoint(r.cursor)}},this.alignCursors=function(){var o=this.session,t=o.multiSelect,e=t.ranges,i=-1,n=e.filter(function(e){if(e.cursor.row==i)return!0;i=e.cursor.row});if(e.length&&n.length!=e.length-1){n.forEach(function(e){t.substractPoint(e.cursor)});var s=0,a=1/0,l=e.map(function(e){var t=e.cursor,i=o.getLine(t.row).substr(t.column).search(/\S/g);return-1==i&&(i=0),t.column>s&&(s=t.column),i<a&&(a=i),i});e.forEach(function(e,t){var i=e.cursor,n=s-i.column,r=l[t]-a;r<n?o.insert(i,g.stringRepeat(" ",n-r)):o.remove(new b(i.row,i.column,i.row,i.column-n+r)),e.start.column=e.end.column=s,e.start.row=e.end.row=i.row,e.cursor=e.end}),t.fromOrientedRange(e[0]),this.renderer.updateCursor(),this.renderer.updateBackMarkers()}else{var r=this.selection.getRange(),c=r.start.row,h=r.end.row,d=c==h;if(d){for(var u,f=this.session.getLength();u=this.session.getLine(h),/[=:]/.test(u)&&++h<f;);for(;u=this.session.getLine(c),/[=:]/.test(u)&&0<--c;);c<0&&(c=0),f<=h&&(h=f-1)}var p=this.session.removeFullLines(c,h);p=this.$reAlignText(p,d),this.session.insert({row:c,column:0},p.join("\n")+"\n"),d||(r.start.column=0,r.end.column=p[p.length-1].length),this.selection.setRange(r)}},this.$reAlignText=function(e,t){var i,n,r,o=!0,s=!0;return e.map(function(e){var t=e.match(/(\s*)(.*?)(\s*)([=:].*)/);return t?(null==i?(i=t[1].length,n=t[2].length,r=t[3].length):(i+n+r!=t[1].length+t[2].length+t[3].length&&(s=!1),i!=t[1].length&&(o=!1),i>t[1].length&&(i=t[1].length),n<t[2].length&&(n=t[2].length),r>t[3].length&&(r=t[3].length)),t):[e]}).map(t?l:o?s?function(e){return e[2]?a(i+n-e[2].length)+e[2]+a(r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}:l:function(e){return e[2]?a(i)+e[2]+a(r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]});function a(e){return g.stringRepeat(" ",e)}function l(e){return e[2]?a(i)+e[2]+a(n-e[2].length+r)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}}}).call(c.prototype),t.onSessionChange=function(e){var t=e.session;t&&!t.multiSelect&&(t.$selectionMarkers=[],t.selection.$initRangeList(),t.multiSelect=t.selection),this.multiSelect=t&&t.multiSelect;var i=e.oldSession;i&&(i.multiSelect.off("addRange",this.$onAddRange),i.multiSelect.off("removeRange",this.$onRemoveRange),i.multiSelect.off("multiSelect",this.$onMultiSelect),i.multiSelect.off("singleSelect",this.$onSingleSelect),i.multiSelect.lead.off("change",this.$checkMultiselectChange),i.multiSelect.anchor.off("change",this.$checkMultiselectChange)),t&&(t.multiSelect.on("addRange",this.$onAddRange),t.multiSelect.on("removeRange",this.$onRemoveRange),t.multiSelect.on("multiSelect",this.$onMultiSelect),t.multiSelect.on("singleSelect",this.$onSingleSelect),t.multiSelect.lead.on("change",this.$checkMultiselectChange),t.multiSelect.anchor.on("change",this.$checkMultiselectChange)),t&&this.inMultiSelectMode!=t.selection.inMultiSelectMode&&(t.selection.inMultiSelectMode?this.$onMultiSelect():this.$onSingleSelect())},t.MultiSelect=h,e("./config").defineOptions(c.prototype,"editor",{enableMultiselect:{set:function(e){h(this),e?(this.on("changeSession",this.$multiselectOnSessionChange),this.on("mousedown",r)):(this.off("changeSession",this.$multiselectOnSessionChange),this.off("mousedown",r))},value:!0},enableBlockSelect:{set:function(e){this.$blockSelectEnabled=e},value:!0}})}),ace.define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],function(e,t,i){"use strict";var u=e("../../range").Range,n=t.FoldMode=function(){};(function(){this.foldingStartMarker=null,this.foldingStopMarker=null,this.getFoldWidget=function(e,t,i){var n=e.getLine(i);return this.foldingStartMarker.test(n)?"start":"markbeginend"==t&&this.foldingStopMarker&&this.foldingStopMarker.test(n)?"end":""},this.getFoldWidgetRange=function(e,t,i){return null},this.indentationBlock=function(e,t,i){var n=/\S/,r=e.getLine(t),o=r.search(n);if(-1!=o){for(var s=i||r.length,a=e.getLength(),l=t,c=t;++t<a;){var h=e.getLine(t).search(n);if(-1!=h){if(h<=o)break;c=t}}if(l<c){var d=e.getLine(c).length;return new u(l,s,c,d)}}},this.openingBracketBlock=function(e,t,i,n,r){var o={row:i,column:n+1},s=e.$findClosingBracket(t,o,r);if(s){var a=e.foldWidgets[s.row];return null==a&&(a=e.getFoldWidget(s.row)),"start"==a&&s.row>o.row&&(s.row--,s.column=e.getLine(s.row).length),u.fromPoints(o,s)}},this.closingBracketBlock=function(e,t,i,n,r){var o={row:i,column:n},s=e.$findOpeningBracket(t,o);if(s)return s.column++,o.column--,u.fromPoints(s,o)}}).call(n.prototype)}),ace.define("ace/theme/textmate",["require","exports","module","ace/lib/dom"],function(e,t,i){"use strict";t.isDark=!1,t.cssClass="ace-tm",t.cssText='.ace-tm .ace_gutter {background: #f0f0f0;color: #333;}.ace-tm .ace_print-margin {width: 1px;background: #e8e8e8;}.ace-tm .ace_fold {background-color: #6B72E6;}.ace-tm {background-color: #FFFFFF;color: black;}.ace-tm .ace_cursor {color: black;}.ace-tm .ace_invisible {color: rgb(191, 191, 191);}.ace-tm .ace_storage,.ace-tm .ace_keyword {color: blue;}.ace-tm .ace_constant {color: rgb(197, 6, 11);}.ace-tm .ace_constant.ace_buildin {color: rgb(88, 72, 246);}.ace-tm .ace_constant.ace_language {color: rgb(88, 92, 246);}.ace-tm .ace_constant.ace_library {color: rgb(6, 150, 14);}.ace-tm .ace_invalid {background-color: rgba(255, 0, 0, 0.1);color: red;}.ace-tm .ace_support.ace_function {color: rgb(60, 76, 114);}.ace-tm .ace_support.ace_constant {color: rgb(6, 150, 14);}.ace-tm .ace_support.ace_type,.ace-tm .ace_support.ace_class {color: rgb(109, 121, 222);}.ace-tm .ace_keyword.ace_operator {color: rgb(104, 118, 135);}.ace-tm .ace_string {color: rgb(3, 106, 7);}.ace-tm .ace_comment {color: rgb(76, 136, 107);}.ace-tm .ace_comment.ace_doc {color: rgb(0, 102, 255);}.ace-tm .ace_comment.ace_doc.ace_tag {color: rgb(128, 159, 191);}.ace-tm .ace_constant.ace_numeric {color: rgb(0, 0, 205);}.ace-tm .ace_variable {color: rgb(49, 132, 149);}.ace-tm .ace_xml-pe {color: rgb(104, 104, 91);}.ace-tm .ace_entity.ace_name.ace_function {color: #0000A2;}.ace-tm .ace_heading {color: rgb(12, 7, 255);}.ace-tm .ace_list {color:rgb(185, 6, 144);}.ace-tm .ace_meta.ace_tag {color:rgb(0, 22, 142);}.ace-tm .ace_string.ace_regex {color: rgb(255, 0, 0)}.ace-tm .ace_marker-layer .ace_selection {background: rgb(181, 213, 255);}.ace-tm.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px white;}.ace-tm .ace_marker-layer .ace_step {background: rgb(252, 255, 0);}.ace-tm .ace_marker-layer .ace_stack {background: rgb(164, 229, 101);}.ace-tm .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid rgb(192, 192, 192);}.ace-tm .ace_marker-layer .ace_active-line {background: rgba(0, 0, 0, 0.07);}.ace-tm .ace_gutter-active-line {background-color : #dcdcdc;}.ace-tm .ace_marker-layer .ace_selected-word {background: rgb(250, 250, 255);border: 1px solid rgb(200, 200, 250);}.ace-tm .ace_indent-guide {background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;}',e("../lib/dom").importCssString(t.cssText,t.cssClass)}),ace.define("ace/line_widgets",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/range"],function(e,t,i){"use strict";e("./lib/oop");var o=e("./lib/dom");e("./range").Range;function n(e){this.session=e,(this.session.widgetManager=this).session.getRowLength=this.getRowLength,this.session.$getWidgetScreenLength=this.$getWidgetScreenLength,this.updateOnChange=this.updateOnChange.bind(this),this.renderWidgets=this.renderWidgets.bind(this),this.measureWidgets=this.measureWidgets.bind(this),this.session._changedWidgets=[],this.$onChangeEditor=this.$onChangeEditor.bind(this),this.session.on("change",this.updateOnChange),this.session.on("changeFold",this.updateOnFold),this.session.on("changeEditor",this.$onChangeEditor)}(function(){this.getRowLength=function(e){var t;return t=this.lineWidgets&&this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0,this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},this.$getWidgetScreenLength=function(){var t=0;return this.lineWidgets.forEach(function(e){e&&e.rowCount&&!e.hidden&&(t+=e.rowCount)}),t},this.$onChangeEditor=function(e){this.attach(e.editor)},this.attach=function(e){e&&e.widgetManager&&e.widgetManager!=this&&e.widgetManager.detach(),this.editor!=e&&(this.detach(),(this.editor=e)&&(e.widgetManager=this,e.renderer.on("beforeRender",this.measureWidgets),e.renderer.on("afterRender",this.renderWidgets)))},this.detach=function(e){var t=this.editor;if(t){this.editor=null,t.widgetManager=null,t.renderer.off("beforeRender",this.measureWidgets),t.renderer.off("afterRender",this.renderWidgets);var i=this.session.lineWidgets;i&&i.forEach(function(e){e&&e.el&&e.el.parentNode&&(e._inDocument=!1,e.el.parentNode.removeChild(e.el))})}},this.updateOnFold=function(e,t){var i=t.lineWidgets;if(i&&e.action){for(var n=e.data,r=n.start.row,o=n.end.row,s="add"==e.action,a=r+1;a<o;a++)i[a]&&(i[a].hidden=s);i[o]&&(s?i[r]?i[o].hidden=s:i[r]=i[o]:(i[r]==i[o]&&(i[r]=void 0),i[o].hidden=s))}},this.updateOnChange=function(e){var t=this.session.lineWidgets;if(t){var i=e.start.row,n=e.end.row-i;if(0==n);else if("remove"==e.action){t.splice(i+1,n).forEach(function(e){e&&this.removeLineWidget(e)},this),this.$updateRows()}else{var r=new Array(n);r.unshift(i,0),t.splice.apply(t,r),this.$updateRows()}}},this.$updateRows=function(){var e=this.session.lineWidgets;if(e){var i=!0;e.forEach(function(e,t){if(e)for(i=!1,e.row=t;e.$oldWidget;)e.$oldWidget.row=t,e=e.$oldWidget}),i&&(this.session.lineWidgets=null)}},this.addLineWidget=function(e){this.session.lineWidgets||(this.session.lineWidgets=new Array(this.session.getLength()));var t=this.session.lineWidgets[e.row];t&&(e.$oldWidget=t).el&&t.el.parentNode&&(t.el.parentNode.removeChild(t.el),t._inDocument=!1),(this.session.lineWidgets[e.row]=e).session=this.session;var i=this.editor.renderer;e.html&&!e.el&&(e.el=o.createElement("div"),e.el.innerHTML=e.html),e.el&&(o.addCssClass(e.el,"ace_lineWidgetContainer"),e.el.style.position="absolute",e.el.style.zIndex=5,i.container.appendChild(e.el),e._inDocument=!0),e.coverGutter||(e.el.style.zIndex=3),null==e.pixelHeight&&(e.pixelHeight=e.el.offsetHeight),null==e.rowCount&&(e.rowCount=e.pixelHeight/i.layerConfig.lineHeight);var n=this.session.getFoldAt(e.row,0);if(e.$fold=n){var r=this.session.lineWidgets;e.row!=n.end.row||r[n.start.row]?e.hidden=!0:r[n.start.row]=e}return this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows(),this.renderWidgets(null,i),this.onWidgetChanged(e),e},this.removeLineWidget=function(e){if(e._inDocument=!1,e.session=null,e.el&&e.el.parentNode&&e.el.parentNode.removeChild(e.el),e.editor&&e.editor.destroy)try{e.editor.destroy()}catch(e){}if(this.session.lineWidgets){var t=this.session.lineWidgets[e.row];if(t==e)this.session.lineWidgets[e.row]=e.$oldWidget,e.$oldWidget&&this.onWidgetChanged(e.$oldWidget);else for(;t;){if(t.$oldWidget==e){t.$oldWidget=e.$oldWidget;break}t=t.$oldWidget}}this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows()},this.getWidgetsAtRow=function(e){for(var t=this.session.lineWidgets,i=t&&t[e],n=[];i;)n.push(i),i=i.$oldWidget;return n},this.onWidgetChanged=function(e){this.session._changedWidgets.push(e),this.editor&&this.editor.renderer.updateFull()},this.measureWidgets=function(e,t){var i=this.session._changedWidgets,n=t.layerConfig;if(i&&i.length){for(var r=1/0,o=0;o<i.length;o++){var s=i[o];if(s&&s.el&&s.session==this.session){if(!s._inDocument){if(this.session.lineWidgets[s.row]!=s)continue;s._inDocument=!0,t.container.appendChild(s.el)}s.h=s.el.offsetHeight,s.fixedWidth||(s.w=s.el.offsetWidth,s.screenWidth=Math.ceil(s.w/n.characterWidth));var a=s.h/n.lineHeight;s.coverLine&&(a-=this.session.getRowLineCount(s.row))<0&&(a=0),s.rowCount!=a&&(s.rowCount=a,s.row<r&&(r=s.row))}}r!=1/0&&(this.session._emit("changeFold",{data:{start:{row:r}}}),this.session.lineWidgetWidth=null),this.session._changedWidgets=[]}},this.renderWidgets=function(e,t){var i=t.layerConfig,n=this.session.lineWidgets;if(n){for(var r=Math.min(this.firstRow,i.firstRow),o=Math.max(this.lastRow,i.lastRow,n.length);0<r&&!n[r];)r--;this.firstRow=i.firstRow,this.lastRow=i.lastRow,t.$cursorLayer.config=i;for(var s=r;s<=o;s++){var a=n[s];if(a&&a.el)if(a.hidden)a.el.style.top=-100-(a.pixelHeight||0)+"px";else{a._inDocument||(a._inDocument=!0,t.container.appendChild(a.el));var l=t.$cursorLayer.getPixelPosition({row:s,column:0},!0).top;a.coverLine||(l+=i.lineHeight*this.session.getRowLineCount(a.row)),a.el.style.top=l-i.offset+"px";var c=a.coverGutter?0:t.gutterWidth;a.fixedWidth||(c-=t.scrollLeft),a.el.style.left=c+"px",a.fullWidth&&a.screenWidth&&(a.el.style.minWidth=i.width+2*i.padding+"px"),a.fixedWidth?a.el.style.right=t.scrollBar.getWidth()+"px":a.el.style.right=""}}}}}).call(n.prototype),t.LineWidgets=n}),ace.define("ace/ext/error_marker",["require","exports","module","ace/line_widgets","ace/lib/dom","ace/range"],function(e,t,i){"use strict";var p=e("../line_widgets").LineWidgets,m=e("../lib/dom"),g=e("../range").Range;t.showErrorMarker=function(e,t){var i=e.session;i.widgetManager||(i.widgetManager=new p(i),i.widgetManager.attach(e));var n=e.getCursorPosition(),r=n.row,o=i.widgetManager.getWidgetsAtRow(r).filter(function(e){return"errorMarker"==e.type})[0];o?o.destroy():r-=t;var s,a=function(e,t,i){var n=e.getAnnotations().sort(g.comparePoints);if(n.length){var r=function(e,t,i){for(var n=0,r=e.length-1;n<=r;){var o=n+r>>1,s=i(t,e[o]);if(0<s)n=1+o;else{if(!(s<0))return o;r=o-1}}return-(n+1)}(n,{row:t,column:-1},g.comparePoints);r<0&&(r=-r-1),r>=n.length?r=0<i?0:n.length-1:0===r&&i<0&&(r=n.length-1);var o=n[r];if(o&&i){if(o.row===t){for(;(o=n[r+=i])&&o.row===t;);if(!o)return n.slice()}var s=[];for(t=o.row;s[i<0?"unshift":"push"](o),(o=n[r+=i])&&o.row==t;);return s.length&&s}}}(i,r,t);if(a){var l=a[0];n.column=(l.pos&&"number"!=typeof l.column?l.pos.sc:l.column)||0,n.row=l.row,s=e.renderer.$gutterLayer.$annotations[n.row]}else{if(o)return;s={text:["Looks good!"],className:"ace_ok"}}e.session.unfold(n.row),e.selection.moveToPosition(n);var c={row:n.row,fixedWidth:!0,coverGutter:!0,el:m.createElement("div"),type:"errorMarker"},h=c.el.appendChild(m.createElement("div")),d=c.el.appendChild(m.createElement("div"));d.className="error_widget_arrow "+s.className;var u=e.renderer.$cursorLayer.getPixelPosition(n).left;d.style.left=u+e.renderer.gutterWidth-5+"px",c.el.className="error_widget_wrapper",h.className="error_widget "+s.className,h.innerHTML=s.text.join("<br>"),h.appendChild(m.createElement("div"));function f(e,t,i){if(0===t&&("esc"===i||"return"===i))return c.destroy(),{command:"null"}}c.destroy=function(){e.$mouseHandler.isMousePressed||(e.keyBinding.removeKeyboardHandler(f),i.widgetManager.removeLineWidget(c),e.off("changeSelection",c.destroy),e.off("changeSession",c.destroy),e.off("mouseup",c.destroy),e.off("change",c.destroy))},e.keyBinding.addKeyboardHandler(f),e.on("changeSelection",c.destroy),e.on("changeSession",c.destroy),e.on("mouseup",c.destroy),e.on("change",c.destroy),e.session.widgetManager.addLineWidget(c
),c.el.onmousedown=e.focus.bind(e),e.renderer.scrollCursorIntoView(null,.5,{bottom:c.el.offsetHeight})},m.importCssString("    .error_widget_wrapper {        background: inherit;        color: inherit;        border:none    }    .error_widget {        border-top: solid 2px;        border-bottom: solid 2px;        margin: 5px 0;        padding: 10px 40px;        white-space: pre-wrap;    }    .error_widget.ace_error, .error_widget_arrow.ace_error{        border-color: #ff5a5a    }    .error_widget.ace_warning, .error_widget_arrow.ace_warning{        border-color: #F1D817    }    .error_widget.ace_info, .error_widget_arrow.ace_info{        border-color: #5a5a5a    }    .error_widget.ace_ok, .error_widget_arrow.ace_ok{        border-color: #5aaa5a    }    .error_widget_arrow {        position: absolute;        border: solid 5px;        border-top-color: transparent!important;        border-right-color: transparent!important;        border-left-color: transparent!important;        top: -5px;    }","")}),ace.define("ace/ace",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/dom","ace/lib/event","ace/editor","ace/edit_session","ace/undomanager","ace/virtual_renderer","ace/worker/worker_client","ace/keyboard/hash_handler","ace/placeholder","ace/multi_select","ace/mode/folding/fold_mode","ace/theme/textmate","ace/ext/error_marker","ace/config"],function(e,a,t){"use strict";e("./lib/fixoldbrowsers");var l=e("./lib/dom"),c=e("./lib/event"),h=e("./editor").Editor,n=e("./edit_session").EditSession,r=e("./undomanager").UndoManager,d=e("./virtual_renderer").VirtualRenderer;e("./worker/worker_client"),e("./keyboard/hash_handler"),e("./placeholder"),e("./multi_select"),e("./mode/folding/fold_mode"),e("./theme/textmate"),e("./ext/error_marker"),a.config=e("./config"),a.acequire=e,a.define=w(21),a.edit=function(e){if("string"==typeof e){var t=e;if(!(e=document.getElementById(t)))throw new Error("ace.edit can't find div #"+t)}if(e&&e.env&&e.env.editor instanceof h)return e.env.editor;var i="";if(e&&/input|textarea/i.test(e.tagName)){var n=e;i=n.value,e=l.createElement("pre"),n.parentNode.replaceChild(e,n)}else e&&(i=l.getInnerText(e),e.innerHTML="");var r=a.createEditSession(i),o=new h(new d(e));o.setSession(r);var s={document:r,editor:o,onResize:o.resize.bind(o,null)};return n&&(s.textarea=n),c.addListener(window,"resize",s.onResize),o.on("destroy",function(){c.removeListener(window,"resize",s.onResize),s.editor.container.env=null}),o.container.env=o.env=s,o},a.createEditSession=function(e,t){var i=new n(e,t);return i.setUndoManager(new r),i},a.EditSession=n,a.UndoManager=r,a.version="1.2.9"}),ace.acequire(["ace/ace"],function(e){for(var t in e&&(e.config.init(!0),e.define=ace.define),window.ace||(window.ace=e),e)e.hasOwnProperty(t)&&(window.ace[t]=e[t])}),e.exports=window.ace.acequire("ace/ace")},function(e,t,d){ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,i){"use strict";function n(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"text",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"comment",regex:"\\/\\/.*$"},{token:"comment.start",regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'"|$',next:"start"},{defaultToken:"string"}],comment:[{token:"comment.end",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]}}var r=e("../lib/oop"),o=e("./text_highlight_rules").TextHighlightRules;r.inherits(n,o),t.JsonHighlightRules=n}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(e,t,i){"use strict";function n(){}var s=e("../range").Range;(function(){this.checkOutdent=function(e,t){return!!/^\s+$/.test(e)&&/^\s*\}/.test(t)},this.autoOutdent=function(e,t){var i=e.getLine(t).match(/^(\s*\})/);if(!i)return 0;var n=i[1].length,r=e.findMatchingBracket({row:t,column:n});if(!r||r.row==t)return 0;var o=this.$getIndent(e.getLine(r.row));e.replace(new s(t,0,t,n-1),o)},this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(n.prototype),t.MatchingBraceOutdent=n}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(e,t,i){"use strict";var n=e("../../lib/oop"),h=e("../../range").Range,r=e("./fold_mode").FoldMode,o=t.FoldMode=function(e){e&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+e.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+e.end)))};n.inherits(o,r),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(e,t,i){var n=e.getLine(i);if(this.singleLineBlockCommentRe.test(n)&&!this.startRegionRe.test(n)&&!this.tripleStarBlockCommentRe.test(n))return"";var r=this._getFoldWidgetBase(e,t,i);return!r&&this.startRegionRe.test(n)?"start":r},this.getFoldWidgetRange=function(e,t,i,n){var r,o=e.getLine(i);if(this.startRegionRe.test(o))return this.getCommentRegionBlock(e,o,i);if(r=o.match(this.foldingStartMarker)){var s=r.index;if(r[1])return this.openingBracketBlock(e,r[1],i,s);var a=e.getCommentFoldRange(i,s+r[0].length,1);return a&&!a.isMultiLine()&&(n?a=this.getSectionRange(e,i):"all"!=t&&(a=null)),a}if("markbegin"!==t&&(r=o.match(this.foldingStopMarker))){s=r.index+r[0].length;return r[1]?this.closingBracketBlock(e,r[1],i,s):e.getCommentFoldRange(i,s,-1)}},this.getSectionRange=function(e,t){for(var i=e.getLine(t),n=i.search(/\S/),r=t,o=i.length,s=t+=1,a=e.getLength();++t<a;){var l=(i=e.getLine(t)).search(/\S/);if(-1!==l){if(l<n)break;var c=this.getFoldWidgetRange(e,"all",t);if(c){if(c.start.row<=r)break;if(c.isMultiLine())t=c.end.row;else if(n==l)break}s=t}}return new h(r,o,s,e.getLine(s).length)},this.getCommentRegionBlock=function(e,t,i){for(var n=t.search(/\s*$/),r=e.getLength(),o=i,s=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,a=1;++i<r;){t=e.getLine(i);var l=s.exec(t);if(l&&(l[1]?a--:a++,!a))break}if(o<i)return new h(o,n,i,t.length)}}.call(o.prototype)}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle","ace/worker/worker_client"],function(e,t,i){"use strict";function n(){this.HighlightRules=s,this.$outdent=new a,this.$behaviour=new l,this.foldingRules=new c}var r=e("../lib/oop"),o=e("./text").Mode,s=e("./json_highlight_rules").JsonHighlightRules,a=e("./matching_brace_outdent").MatchingBraceOutdent,l=e("./behaviour/cstyle").CstyleBehaviour,c=e("./folding/cstyle").FoldMode,h=e("../worker/worker_client").WorkerClient;r.inherits(n,o),function(){this.getNextLineIndent=function(e,t,i){var n=this.$getIndent(t);"start"==e&&t.match(/^.*[\{\(\[]\s*$/)&&(n+=i);return n},this.checkOutdent=function(e,t,i){return this.$outdent.checkOutdent(t,i)},this.autoOutdent=function(e,t,i){this.$outdent.autoOutdent(t,i)},this.createWorker=function(t){var e=new h(["ace"],d(66),"JsonWorker");return e.attachToDocument(t.getDocument()),e.on("annotate",function(e){t.setAnnotations(e.data)}),e.on("terminate",function(){t.clearAnnotations()}),e},this.$id="ace/mode/json"}.call(n.prototype),t.Mode=n})},function(e,t){e.exports.id="ace/mode/json_worker",e.exports.src='"no use strict";!function(window){function resolveModuleId(id,paths){for(var testPath=id,tail="";testPath;){var alias=paths[testPath];if("string"==typeof alias)return alias+tail;if(alias)return alias.location.replace(/\\/*$/,"/")+(tail||alias.main||alias.name);if(alias===!1)return"";var i=testPath.lastIndexOf("/");if(-1===i)break;tail=testPath.substr(i)+tail,testPath=testPath.slice(0,i)}return id}if(!(void 0!==window.window&&window.document||window.acequire&&window.define)){window.console||(window.console=function(){var msgs=Array.prototype.slice.call(arguments,0);postMessage({type:"log",data:msgs})},window.console.error=window.console.warn=window.console.log=window.console.trace=window.console),window.window=window,window.ace=window,window.onerror=function(message,file,line,col,err){postMessage({type:"error",data:{message:message,data:err.data,file:file,line:line,col:col,stack:err.stack}})},window.normalizeModule=function(parentId,moduleName){if(-1!==moduleName.indexOf("!")){var chunks=moduleName.split("!");return window.normalizeModule(parentId,chunks[0])+"!"+window.normalizeModule(parentId,chunks[1])}if("."==moduleName.charAt(0)){var base=parentId.split("/").slice(0,-1).join("/");for(moduleName=(base?base+"/":"")+moduleName;-1!==moduleName.indexOf(".")&&previous!=moduleName;){var previous=moduleName;moduleName=moduleName.replace(/^\\.\\//,"").replace(/\\/\\.\\//,"/").replace(/[^\\/]+\\/\\.\\.\\//,"")}}return moduleName},window.acequire=function acequire(parentId,id){if(id||(id=parentId,parentId=null),!id.charAt)throw Error("worker.js acequire() accepts only (parentId, id) as arguments");id=window.normalizeModule(parentId,id);var module=window.acequire.modules[id];if(module)return module.initialized||(module.initialized=!0,module.exports=module.factory().exports),module.exports;if(!window.acequire.tlns)return console.log("unable to load "+id);var path=resolveModuleId(id,window.acequire.tlns);return".js"!=path.slice(-3)&&(path+=".js"),window.acequire.id=id,window.acequire.modules[id]={},importScripts(path),window.acequire(parentId,id)},window.acequire.modules={},window.acequire.tlns={},window.define=function(id,deps,factory){if(2==arguments.length?(factory=deps,"string"!=typeof id&&(deps=id,id=window.acequire.id)):1==arguments.length&&(factory=id,deps=[],id=window.acequire.id),"function"!=typeof factory)return window.acequire.modules[id]={exports:factory,initialized:!0},void 0;deps.length||(deps=["require","exports","module"]);var req=function(childId){return window.acequire(id,childId)};window.acequire.modules[id]={exports:{},factory:function(){var module=this,returnExports=factory.apply(this,deps.map(function(dep){switch(dep){case"require":return req;case"exports":return module.exports;case"module":return module;default:return req(dep)}}));return returnExports&&(module.exports=returnExports),module}}},window.define.amd={},acequire.tlns={},window.initBaseUrls=function(topLevelNamespaces){for(var i in topLevelNamespaces)acequire.tlns[i]=topLevelNamespaces[i]},window.initSender=function(){var EventEmitter=window.acequire("ace/lib/event_emitter").EventEmitter,oop=window.acequire("ace/lib/oop"),Sender=function(){};return function(){oop.implement(this,EventEmitter),this.callback=function(data,callbackId){postMessage({type:"call",id:callbackId,data:data})},this.emit=function(name,data){postMessage({type:"event",name:name,data:data})}}.call(Sender.prototype),new Sender};var main=window.main=null,sender=window.sender=null;window.onmessage=function(e){var msg=e.data;if(msg.event&&sender)sender._signal(msg.event,msg.data);else if(msg.command)if(main[msg.command])main[msg.command].apply(main,msg.args);else{if(!window[msg.command])throw Error("Unknown command:"+msg.command);window[msg.command].apply(window,msg.args)}else if(msg.init){window.initBaseUrls(msg.tlns),acequire("ace/lib/es5-shim"),sender=window.sender=window.initSender();var clazz=acequire(msg.module)[msg.classname];main=window.main=new clazz(sender)}}}}(this),ace.define("ace/lib/oop",["require","exports","module"],function(acequire,exports){"use strict";exports.inherits=function(ctor,superCtor){ctor.super_=superCtor,ctor.prototype=Object.create(superCtor.prototype,{constructor:{value:ctor,enumerable:!1,writable:!0,configurable:!0}})},exports.mixin=function(obj,mixin){for(var key in mixin)obj[key]=mixin[key];return obj},exports.implement=function(proto,mixin){exports.mixin(proto,mixin)}}),ace.define("ace/range",["require","exports","module"],function(acequire,exports){"use strict";var comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},Range=function(startRow,startColumn,endRow,endColumn){this.start={row:startRow,column:startColumn},this.end={row:endRow,column:endColumn}};(function(){this.isEqual=function(range){return this.start.row===range.start.row&&this.end.row===range.end.row&&this.start.column===range.start.column&&this.end.column===range.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(row,column){return 0==this.compare(row,column)},this.compareRange=function(range){var cmp,end=range.end,start=range.start;return cmp=this.compare(end.row,end.column),1==cmp?(cmp=this.compare(start.row,start.column),1==cmp?2:0==cmp?1:0):-1==cmp?-2:(cmp=this.compare(start.row,start.column),-1==cmp?-1:1==cmp?42:0)},this.comparePoint=function(p){return this.compare(p.row,p.column)},this.containsRange=function(range){return 0==this.comparePoint(range.start)&&0==this.comparePoint(range.end)},this.intersects=function(range){var cmp=this.compareRange(range);return-1==cmp||0==cmp||1==cmp},this.isEnd=function(row,column){return this.end.row==row&&this.end.column==column},this.isStart=function(row,column){return this.start.row==row&&this.start.column==column},this.setStart=function(row,column){"object"==typeof row?(this.start.column=row.column,this.start.row=row.row):(this.start.row=row,this.start.column=column)},this.setEnd=function(row,column){"object"==typeof row?(this.end.column=row.column,this.end.row=row.row):(this.end.row=row,this.end.column=column)},this.inside=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)||this.isStart(row,column)?!1:!0:!1},this.insideStart=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)?!1:!0:!1},this.insideEnd=function(row,column){return 0==this.compare(row,column)?this.isStart(row,column)?!1:!0:!1},this.compare=function(row,column){return this.isMultiLine()||row!==this.start.row?this.start.row>row?-1:row>this.end.row?1:this.start.row===row?column>=this.start.column?0:-1:this.end.row===row?this.end.column>=column?0:1:0:this.start.column>column?-1:column>this.end.column?1:0},this.compareStart=function(row,column){return this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.compareEnd=function(row,column){return this.end.row==row&&this.end.column==column?1:this.compare(row,column)},this.compareInside=function(row,column){return this.end.row==row&&this.end.column==column?1:this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.clipRows=function(firstRow,lastRow){if(this.end.row>lastRow)var end={row:lastRow+1,column:0};else if(firstRow>this.end.row)var end={row:firstRow,column:0};if(this.start.row>lastRow)var start={row:lastRow+1,column:0};else if(firstRow>this.start.row)var start={row:firstRow,column:0};return Range.fromPoints(start||this.start,end||this.end)},this.extend=function(row,column){var cmp=this.compare(row,column);if(0==cmp)return this;if(-1==cmp)var start={row:row,column:column};else var end={row:row,column:column};return Range.fromPoints(start||this.start,end||this.end)},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return Range.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new Range(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new Range(this.start.row,0,this.end.row,0)},this.toScreenRange=function(session){var screenPosStart=session.documentToScreenPosition(this.start),screenPosEnd=session.documentToScreenPosition(this.end);return new Range(screenPosStart.row,screenPosStart.column,screenPosEnd.row,screenPosEnd.column)},this.moveBy=function(row,column){this.start.row+=row,this.start.column+=column,this.end.row+=row,this.end.column+=column}}).call(Range.prototype),Range.fromPoints=function(start,end){return new Range(start.row,start.column,end.row,end.column)},Range.comparePoints=comparePoints,Range.comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},exports.Range=Range}),ace.define("ace/apply_delta",["require","exports","module"],function(acequire,exports){"use strict";exports.applyDelta=function(docLines,delta){var row=delta.start.row,startColumn=delta.start.column,line=docLines[row]||"";switch(delta.action){case"insert":var lines=delta.lines;if(1===lines.length)docLines[row]=line.substring(0,startColumn)+delta.lines[0]+line.substring(startColumn);else{var args=[row,1].concat(delta.lines);docLines.splice.apply(docLines,args),docLines[row]=line.substring(0,startColumn)+docLines[row],docLines[row+delta.lines.length-1]+=line.substring(startColumn)}break;case"remove":var endColumn=delta.end.column,endRow=delta.end.row;row===endRow?docLines[row]=line.substring(0,startColumn)+line.substring(endColumn):docLines.splice(row,endRow-row+1,line.substring(0,startColumn)+docLines[endRow].substring(endColumn))}}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(acequire,exports){"use strict";var EventEmitter={},stopPropagation=function(){this.propagationStopped=!0},preventDefault=function(){this.defaultPrevented=!0};EventEmitter._emit=EventEmitter._dispatchEvent=function(eventName,e){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var listeners=this._eventRegistry[eventName]||[],defaultHandler=this._defaultHandlers[eventName];if(listeners.length||defaultHandler){"object"==typeof e&&e||(e={}),e.type||(e.type=eventName),e.stopPropagation||(e.stopPropagation=stopPropagation),e.preventDefault||(e.preventDefault=preventDefault),listeners=listeners.slice();for(var i=0;listeners.length>i&&(listeners[i](e,this),!e.propagationStopped);i++);return defaultHandler&&!e.defaultPrevented?defaultHandler(e,this):void 0}},EventEmitter._signal=function(eventName,e){var listeners=(this._eventRegistry||{})[eventName];if(listeners){listeners=listeners.slice();for(var i=0;listeners.length>i;i++)listeners[i](e,this)}},EventEmitter.once=function(eventName,callback){var _self=this;callback&&this.addEventListener(eventName,function newCallback(){_self.removeEventListener(eventName,newCallback),callback.apply(null,arguments)})},EventEmitter.setDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers||(handlers=this._defaultHandlers={_disabled_:{}}),handlers[eventName]){var old=handlers[eventName],disabled=handlers._disabled_[eventName];disabled||(handlers._disabled_[eventName]=disabled=[]),disabled.push(old);var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}handlers[eventName]=callback},EventEmitter.removeDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers){var disabled=handlers._disabled_[eventName];if(handlers[eventName]==callback)handlers[eventName],disabled&&this.setDefaultHandler(eventName,disabled.pop());else if(disabled){var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}}},EventEmitter.on=EventEmitter.addEventListener=function(eventName,callback,capturing){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];return listeners||(listeners=this._eventRegistry[eventName]=[]),-1==listeners.indexOf(callback)&&listeners[capturing?"unshift":"push"](callback),callback},EventEmitter.off=EventEmitter.removeListener=EventEmitter.removeEventListener=function(eventName,callback){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];if(listeners){var index=listeners.indexOf(callback);-1!==index&&listeners.splice(index,1)}},EventEmitter.removeAllListeners=function(eventName){this._eventRegistry&&(this._eventRegistry[eventName]=[])},exports.EventEmitter=EventEmitter}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),EventEmitter=acequire("./lib/event_emitter").EventEmitter,Anchor=exports.Anchor=function(doc,row,column){this.$onChange=this.onChange.bind(this),this.attach(doc),column===void 0?this.setPosition(row.row,row.column):this.setPosition(row,column)};(function(){function $pointsInOrder(point1,point2,equalPointsInOrder){var bColIsAfter=equalPointsInOrder?point1.column<=point2.column:point1.column<point2.column;return point1.row<point2.row||point1.row==point2.row&&bColIsAfter}function $getTransformedPoint(delta,point,moveIfEqual){var deltaIsInsert="insert"==delta.action,deltaRowShift=(deltaIsInsert?1:-1)*(delta.end.row-delta.start.row),deltaColShift=(deltaIsInsert?1:-1)*(delta.end.column-delta.start.column),deltaStart=delta.start,deltaEnd=deltaIsInsert?deltaStart:delta.end;return $pointsInOrder(point,deltaStart,moveIfEqual)?{row:point.row,column:point.column}:$pointsInOrder(deltaEnd,point,!moveIfEqual)?{row:point.row+deltaRowShift,column:point.column+(point.row==deltaEnd.row?deltaColShift:0)}:{row:deltaStart.row,column:deltaStart.column}}oop.implement(this,EventEmitter),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(delta){if(!(delta.start.row==delta.end.row&&delta.start.row!=this.row||delta.start.row>this.row)){var point=$getTransformedPoint(delta,{row:this.row,column:this.column},this.$insertRight);this.setPosition(point.row,point.column,!0)}},this.setPosition=function(row,column,noClip){var pos;if(pos=noClip?{row:row,column:column}:this.$clipPositionToDocument(row,column),this.row!=pos.row||this.column!=pos.column){var old={row:this.row,column:this.column};this.row=pos.row,this.column=pos.column,this._signal("change",{old:old,value:pos})}},this.detach=function(){this.document.removeEventListener("change",this.$onChange)},this.attach=function(doc){this.document=doc||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(row,column){var pos={};return row>=this.document.getLength()?(pos.row=Math.max(0,this.document.getLength()-1),pos.column=this.document.getLine(pos.row).length):0>row?(pos.row=0,pos.column=0):(pos.row=row,pos.column=Math.min(this.document.getLine(pos.row).length,Math.max(0,column))),0>column&&(pos.column=0),pos}}).call(Anchor.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),applyDelta=acequire("./apply_delta").applyDelta,EventEmitter=acequire("./lib/event_emitter").EventEmitter,Range=acequire("./range").Range,Anchor=acequire("./anchor").Anchor,Document=function(textOrLines){this.$lines=[""],0===textOrLines.length?this.$lines=[""]:Array.isArray(textOrLines)?this.insertMergedLines({row:0,column:0},textOrLines):this.insert({row:0,column:0},textOrLines)};(function(){oop.implement(this,EventEmitter),this.setValue=function(text){var len=this.getLength()-1;this.remove(new Range(0,0,len,this.getLine(len).length)),this.insert({row:0,column:0},text)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(row,column){return new Anchor(this,row,column)},this.$split=0==="aaa".split(/a/).length?function(text){return text.replace(/\\r\\n|\\r/g,"\\n").split("\\n")}:function(text){return text.split(/\\r\\n|\\r|\\n/)},this.$detectNewLine=function(text){var match=text.match(/^.*?(\\r\\n|\\r|\\n)/m);this.$autoNewLine=match?match[1]:"\\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\\r\\n";case"unix":return"\\n";default:return this.$autoNewLine||"\\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(newLineMode){this.$newLineMode!==newLineMode&&(this.$newLineMode=newLineMode,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(text){return"\\r\\n"==text||"\\r"==text||"\\n"==text},this.getLine=function(row){return this.$lines[row]||""},this.getLines=function(firstRow,lastRow){return this.$lines.slice(firstRow,lastRow+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(range){return this.getLinesForRange(range).join(this.getNewLineCharacter())},this.getLinesForRange=function(range){var lines;if(range.start.row===range.end.row)lines=[this.getLine(range.start.row).substring(range.start.column,range.end.column)];else{lines=this.getLines(range.start.row,range.end.row),lines[0]=(lines[0]||"").substring(range.start.column);var l=lines.length-1;range.end.row-range.start.row==l&&(lines[l]=lines[l].substring(0,range.end.column))}return lines},this.insertLines=function(row,lines){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(row,lines)},this.removeLines=function(firstRow,lastRow){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(firstRow,lastRow)},this.insertNewLine=function(position){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, [\'\', \'\']) instead."),this.insertMergedLines(position,["",""])},this.insert=function(position,text){return 1>=this.getLength()&&this.$detectNewLine(text),this.insertMergedLines(position,this.$split(text))},this.insertInLine=function(position,text){var start=this.clippedPos(position.row,position.column),end=this.pos(position.row,position.column+text.length);return this.applyDelta({start:start,end:end,action:"insert",lines:[text]},!0),this.clonePos(end)},this.clippedPos=function(row,column){var length=this.getLength();void 0===row?row=length:0>row?row=0:row>=length&&(row=length-1,column=void 0);var line=this.getLine(row);return void 0==column&&(column=line.length),column=Math.min(Math.max(column,0),line.length),{row:row,column:column}},this.clonePos=function(pos){return{row:pos.row,column:pos.column}},this.pos=function(row,column){return{row:row,column:column}},this.$clipPosition=function(position){var length=this.getLength();return position.row>=length?(position.row=Math.max(0,length-1),position.column=this.getLine(length-1).length):(position.row=Math.max(0,position.row),position.column=Math.min(Math.max(position.column,0),this.getLine(position.row).length)),position},this.insertFullLines=function(row,lines){row=Math.min(Math.max(row,0),this.getLength());var column=0;this.getLength()>row?(lines=lines.concat([""]),column=0):(lines=[""].concat(lines),row--,column=this.$lines[row].length),this.insertMergedLines({row:row,column:column},lines)},this.insertMergedLines=function(position,lines){var start=this.clippedPos(position.row,position.column),end={row:start.row+lines.length-1,column:(1==lines.length?start.column:0)+lines[lines.length-1].length};return this.applyDelta({start:start,end:end,action:"insert",lines:lines}),this.clonePos(end)},this.remove=function(range){var start=this.clippedPos(range.start.row,range.start.column),end=this.clippedPos(range.end.row,range.end.column);return this.applyDelta({start:start,end:end,action:"remove",lines:this.getLinesForRange({start:start,end:end})}),this.clonePos(start)},this.removeInLine=function(row,startColumn,endColumn){var start=this.clippedPos(row,startColumn),end=this.clippedPos(row,endColumn);return this.applyDelta({start:start,end:end,action:"remove",lines:this.getLinesForRange({start:start,end:end})},!0),this.clonePos(start)},this.removeFullLines=function(firstRow,lastRow){firstRow=Math.min(Math.max(0,firstRow),this.getLength()-1),lastRow=Math.min(Math.max(0,lastRow),this.getLength()-1);var deleteFirstNewLine=lastRow==this.getLength()-1&&firstRow>0,deleteLastNewLine=this.getLength()-1>lastRow,startRow=deleteFirstNewLine?firstRow-1:firstRow,startCol=deleteFirstNewLine?this.getLine(startRow).length:0,endRow=deleteLastNewLine?lastRow+1:lastRow,endCol=deleteLastNewLine?0:this.getLine(endRow).length,range=new Range(startRow,startCol,endRow,endCol),deletedLines=this.$lines.slice(firstRow,lastRow+1);return this.applyDelta({start:range.start,end:range.end,action:"remove",lines:this.getLinesForRange(range)}),deletedLines},this.removeNewLine=function(row){this.getLength()-1>row&&row>=0&&this.applyDelta({start:this.pos(row,this.getLine(row).length),end:this.pos(row+1,0),action:"remove",lines:["",""]})},this.replace=function(range,text){if(range instanceof Range||(range=Range.fromPoints(range.start,range.end)),0===text.length&&range.isEmpty())return range.start;if(text==this.getTextRange(range))return range.end;this.remove(range);var end;return end=text?this.insert(range.start,text):range.start},this.applyDeltas=function(deltas){for(var i=0;deltas.length>i;i++)this.applyDelta(deltas[i])},this.revertDeltas=function(deltas){for(var i=deltas.length-1;i>=0;i--)this.revertDelta(deltas[i])},this.applyDelta=function(delta,doNotValidate){var isInsert="insert"==delta.action;(isInsert?1>=delta.lines.length&&!delta.lines[0]:!Range.comparePoints(delta.start,delta.end))||(isInsert&&delta.lines.length>2e4&&this.$splitAndapplyLargeDelta(delta,2e4),applyDelta(this.$lines,delta,doNotValidate),this._signal("change",delta))},this.$splitAndapplyLargeDelta=function(delta,MAX){for(var lines=delta.lines,l=lines.length,row=delta.start.row,column=delta.start.column,from=0,to=0;;){from=to,to+=MAX-1;var chunk=lines.slice(from,to);if(to>l){delta.lines=chunk,delta.start.row=row+from,delta.start.column=column;break}chunk.push(""),this.applyDelta({start:this.pos(row+from,column),end:this.pos(row+to,column=0),action:delta.action,lines:chunk},!0)}},this.revertDelta=function(delta){this.applyDelta({start:this.clonePos(delta.start),end:this.clonePos(delta.end),action:"insert"==delta.action?"remove":"insert",lines:delta.lines.slice()})},this.indexToPosition=function(index,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,i=startRow||0,l=lines.length;l>i;i++)if(index-=lines[i].length+newlineLength,0>index)return{row:i,column:index+lines[i].length+newlineLength};return{row:l-1,column:lines[l-1].length}},this.positionToIndex=function(pos,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,index=0,row=Math.min(pos.row,lines.length),i=startRow||0;row>i;++i)index+=lines[i].length+newlineLength;return index+pos.column}}).call(Document.prototype),exports.Document=Document}),ace.define("ace/lib/lang",["require","exports","module"],function(acequire,exports){"use strict";exports.last=function(a){return a[a.length-1]},exports.stringReverse=function(string){return string.split("").reverse().join("")},exports.stringRepeat=function(string,count){for(var result="";count>0;)1&count&&(result+=string),(count>>=1)&&(string+=string);return result};var trimBeginRegexp=/^\\s\\s*/,trimEndRegexp=/\\s\\s*$/;exports.stringTrimLeft=function(string){return string.replace(trimBeginRegexp,"")},exports.stringTrimRight=function(string){return string.replace(trimEndRegexp,"")},exports.copyObject=function(obj){var copy={};for(var key in obj)copy[key]=obj[key];return copy},exports.copyArray=function(array){for(var copy=[],i=0,l=array.length;l>i;i++)copy[i]=array[i]&&"object"==typeof array[i]?this.copyObject(array[i]):array[i];return copy},exports.deepCopy=function deepCopy(obj){if("object"!=typeof obj||!obj)return obj;var copy;if(Array.isArray(obj)){copy=[];for(var key=0;obj.length>key;key++)copy[key]=deepCopy(obj[key]);return copy}if("[object Object]"!==Object.prototype.toString.call(obj))return obj;copy={};for(var key in obj)copy[key]=deepCopy(obj[key]);return copy},exports.arrayToMap=function(arr){for(var map={},i=0;arr.length>i;i++)map[arr[i]]=1;return map},exports.createMap=function(props){var map=Object.create(null);for(var i in props)map[i]=props[i];return map},exports.arrayRemove=function(array,value){for(var i=0;array.length>=i;i++)value===array[i]&&array.splice(i,1)},exports.escapeRegExp=function(str){return str.replace(/([.*+?^${}()|[\\]\\/\\\\])/g,"\\\\$1")},exports.escapeHTML=function(str){return str.replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/\'/g,"&#39;").replace(/</g,"&#60;")},exports.getMatchOffsets=function(string,regExp){var matches=[];return string.replace(regExp,function(str){matches.push({offset:arguments[arguments.length-2],length:str.length})}),matches},exports.deferredCall=function(fcn){var timer=null,callback=function(){timer=null,fcn()},deferred=function(timeout){return deferred.cancel(),timer=setTimeout(callback,timeout||0),deferred};return deferred.schedule=deferred,deferred.call=function(){return this.cancel(),fcn(),deferred},deferred.cancel=function(){return clearTimeout(timer),timer=null,deferred},deferred.isPending=function(){return timer},deferred},exports.delayedCall=function(fcn,defaultTimeout){var timer=null,callback=function(){timer=null,fcn()},_self=function(timeout){null==timer&&(timer=setTimeout(callback,timeout||defaultTimeout))};return _self.delay=function(timeout){timer&&clearTimeout(timer),timer=setTimeout(callback,timeout||defaultTimeout)},_self.schedule=_self,_self.call=function(){this.cancel(),fcn()},_self.cancel=function(){timer&&clearTimeout(timer),timer=null},_self.isPending=function(){return timer},_self}}),ace.define("ace/worker/mirror",["require","exports","module","ace/range","ace/document","ace/lib/lang"],function(acequire,exports){"use strict";acequire("../range").Range;var Document=acequire("../document").Document,lang=acequire("../lib/lang"),Mirror=exports.Mirror=function(sender){this.sender=sender;var doc=this.doc=new Document(""),deferredUpdate=this.deferredUpdate=lang.delayedCall(this.onUpdate.bind(this)),_self=this;sender.on("change",function(e){var data=e.data;if(data[0].start)doc.applyDeltas(data);else for(var i=0;data.length>i;i+=2){if(Array.isArray(data[i+1]))var d={action:"insert",start:data[i],lines:data[i+1]};else var d={action:"remove",start:data[i],end:data[i+1]};doc.applyDelta(d,!0)}return _self.$timeout?deferredUpdate.schedule(_self.$timeout):(_self.onUpdate(),void 0)})};(function(){this.$timeout=500,this.setTimeout=function(timeout){this.$timeout=timeout},this.setValue=function(value){this.doc.setValue(value),this.deferredUpdate.schedule(this.$timeout)},this.getValue=function(callbackId){this.sender.callback(this.doc.getValue(),callbackId)},this.onUpdate=function(){},this.isPending=function(){return this.deferredUpdate.isPending()}}).call(Mirror.prototype)}),ace.define("ace/mode/json/json_parse",["require","exports","module"],function(){"use strict";var at,ch,text,value,escapee={\'"\':\'"\',"\\\\":"\\\\","/":"/",b:"\\b",f:"\\f",n:"\\n",r:"\\r",t:"\t"},error=function(m){throw{name:"SyntaxError",message:m,at:at,text:text}},next=function(c){return c&&c!==ch&&error("Expected \'"+c+"\' instead of \'"+ch+"\'"),ch=text.charAt(at),at+=1,ch},number=function(){var number,string="";for("-"===ch&&(string="-",next("-"));ch>="0"&&"9">=ch;)string+=ch,next();if("."===ch)for(string+=".";next()&&ch>="0"&&"9">=ch;)string+=ch;if("e"===ch||"E"===ch)for(string+=ch,next(),("-"===ch||"+"===ch)&&(string+=ch,next());ch>="0"&&"9">=ch;)string+=ch,next();return number=+string,isNaN(number)?(error("Bad number"),void 0):number},string=function(){var hex,i,uffff,string="";if(\'"\'===ch)for(;next();){if(\'"\'===ch)return next(),string;if("\\\\"===ch)if(next(),"u"===ch){for(uffff=0,i=0;4>i&&(hex=parseInt(next(),16),isFinite(hex));i+=1)uffff=16*uffff+hex;string+=String.fromCharCode(uffff)}else{if("string"!=typeof escapee[ch])break;string+=escapee[ch]}else string+=ch}error("Bad string")},white=function(){for(;ch&&" ">=ch;)next()},word=function(){switch(ch){case"t":return next("t"),next("r"),next("u"),next("e"),!0;case"f":return next("f"),next("a"),next("l"),next("s"),next("e"),!1;case"n":return next("n"),next("u"),next("l"),next("l"),null}error("Unexpected \'"+ch+"\'")},array=function(){var array=[];if("["===ch){if(next("["),white(),"]"===ch)return next("]"),array;for(;ch;){if(array.push(value()),white(),"]"===ch)return next("]"),array;next(","),white()}}error("Bad array")},object=function(){var key,object={};if("{"===ch){if(next("{"),white(),"}"===ch)return next("}"),object;for(;ch;){if(key=string(),white(),next(":"),Object.hasOwnProperty.call(object,key)&&error(\'Duplicate key "\'+key+\'"\'),object[key]=value(),white(),"}"===ch)return next("}"),object;next(","),white()}}error("Bad object")};return value=function(){switch(white(),ch){case"{":return object();case"[":return array();case\'"\':return string();case"-":return number();default:return ch>="0"&&"9">=ch?number():word()}},function(source,reviver){var result;return text=source,at=0,ch=" ",result=value(),white(),ch&&error("Syntax error"),"function"==typeof reviver?function walk(holder,key){var k,v,value=holder[key];if(value&&"object"==typeof value)for(k in value)Object.hasOwnProperty.call(value,k)&&(v=walk(value,k),void 0!==v?value[k]=v:delete value[k]);return reviver.call(holder,key,value)}({"":result},""):result}}),ace.define("ace/mode/json_worker",["require","exports","module","ace/lib/oop","ace/worker/mirror","ace/mode/json/json_parse"],function(acequire,exports){"use strict";var oop=acequire("../lib/oop"),Mirror=acequire("../worker/mirror").Mirror,parse=acequire("./json/json_parse"),JsonWorker=exports.JsonWorker=function(sender){Mirror.call(this,sender),this.setTimeout(200)};oop.inherits(JsonWorker,Mirror),function(){this.onUpdate=function(){var value=this.doc.getValue(),errors=[];try{value&&parse(value)}catch(e){var pos=this.doc.indexToPosition(e.at-1);errors.push({row:pos.row,column:pos.column,text:e.message,type:"error"})}this.sender.emit("annotate",errors)}}.call(JsonWorker.prototype)}),ace.define("ace/lib/es5-shim",["require","exports","module"],function(){function Empty(){}function doesDefinePropertyWork(object){try{return Object.defineProperty(object,"sentinel",{}),"sentinel"in object}catch(exception){}}function toInteger(n){return n=+n,n!==n?n=0:0!==n&&n!==1/0&&n!==-(1/0)&&(n=(n>0||-1)*Math.floor(Math.abs(n))),n}Function.prototype.bind||(Function.prototype.bind=function(that){var target=this;if("function"!=typeof target)throw new TypeError("Function.prototype.bind called on incompatible "+target);var args=slice.call(arguments,1),bound=function(){if(this instanceof bound){var result=target.apply(this,args.concat(slice.call(arguments)));return Object(result)===result?result:this}return target.apply(that,args.concat(slice.call(arguments)))};return target.prototype&&(Empty.prototype=target.prototype,bound.prototype=new Empty,Empty.prototype=null),bound});var defineGetter,defineSetter,lookupGetter,lookupSetter,supportsAccessors,call=Function.prototype.call,prototypeOfArray=Array.prototype,prototypeOfObject=Object.prototype,slice=prototypeOfArray.slice,_toString=call.bind(prototypeOfObject.toString),owns=call.bind(prototypeOfObject.hasOwnProperty);if((supportsAccessors=owns(prototypeOfObject,"__defineGetter__"))&&(defineGetter=call.bind(prototypeOfObject.__defineGetter__),defineSetter=call.bind(prototypeOfObject.__defineSetter__),lookupGetter=call.bind(prototypeOfObject.__lookupGetter__),lookupSetter=call.bind(prototypeOfObject.__lookupSetter__)),2!=[1,2].splice(0).length)if(function(){function makeArray(l){var a=Array(l+2);return a[0]=a[1]=0,a}var lengthBefore,array=[];return array.splice.apply(array,makeArray(20)),array.splice.apply(array,makeArray(26)),lengthBefore=array.length,array.splice(5,0,"XXX"),lengthBefore+1==array.length,lengthBefore+1==array.length?!0:void 0\n}()){var array_splice=Array.prototype.splice;Array.prototype.splice=function(start,deleteCount){return arguments.length?array_splice.apply(this,[void 0===start?0:start,void 0===deleteCount?this.length-start:deleteCount].concat(slice.call(arguments,2))):[]}}else Array.prototype.splice=function(pos,removeCount){var length=this.length;pos>0?pos>length&&(pos=length):void 0==pos?pos=0:0>pos&&(pos=Math.max(length+pos,0)),length>pos+removeCount||(removeCount=length-pos);var removed=this.slice(pos,pos+removeCount),insert=slice.call(arguments,2),add=insert.length;if(pos===length)add&&this.push.apply(this,insert);else{var remove=Math.min(removeCount,length-pos),tailOldPos=pos+remove,tailNewPos=tailOldPos+add-remove,tailCount=length-tailOldPos,lengthAfterRemove=length-remove;if(tailOldPos>tailNewPos)for(var i=0;tailCount>i;++i)this[tailNewPos+i]=this[tailOldPos+i];else if(tailNewPos>tailOldPos)for(i=tailCount;i--;)this[tailNewPos+i]=this[tailOldPos+i];if(add&&pos===lengthAfterRemove)this.length=lengthAfterRemove,this.push.apply(this,insert);else for(this.length=lengthAfterRemove+add,i=0;add>i;++i)this[pos+i]=insert[i]}return removed};Array.isArray||(Array.isArray=function(obj){return"[object Array]"==_toString(obj)});var boxedString=Object("a"),splitString="a"!=boxedString[0]||!(0 in boxedString);if(Array.prototype.forEach||(Array.prototype.forEach=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,thisp=arguments[1],i=-1,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError;for(;length>++i;)i in self&&fun.call(thisp,self[i],i,object)}),Array.prototype.map||(Array.prototype.map=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=Array(length),thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(result[i]=fun.call(thisp,self[i],i,object));return result}),Array.prototype.filter||(Array.prototype.filter=function(fun){var value,object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=[],thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(value=self[i],fun.call(thisp,value,i,object)&&result.push(value));return result}),Array.prototype.every||(Array.prototype.every=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&!fun.call(thisp,self[i],i,object))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&fun.call(thisp,self[i],i,object))return!0;return!1}),Array.prototype.reduce||(Array.prototype.reduce=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduce of empty array with no initial value");var result,i=0;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i++];break}if(++i>=length)throw new TypeError("reduce of empty array with no initial value")}for(;length>i;i++)i in self&&(result=fun.call(void 0,result,self[i],i,object));return result}),Array.prototype.reduceRight||(Array.prototype.reduceRight=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduceRight of empty array with no initial value");var result,i=length-1;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i--];break}if(0>--i)throw new TypeError("reduceRight of empty array with no initial value")}do i in this&&(result=fun.call(void 0,result,self[i],i,object));while(i--);return result}),Array.prototype.indexOf&&-1==[0,1].indexOf(1,2)||(Array.prototype.indexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=0;for(arguments.length>1&&(i=toInteger(arguments[1])),i=i>=0?i:Math.max(0,length+i);length>i;i++)if(i in self&&self[i]===sought)return i;return-1}),Array.prototype.lastIndexOf&&-1==[0,1].lastIndexOf(0,-3)||(Array.prototype.lastIndexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=length-1;for(arguments.length>1&&(i=Math.min(i,toInteger(arguments[1]))),i=i>=0?i:length-Math.abs(i);i>=0;i--)if(i in self&&sought===self[i])return i;return-1}),Object.getPrototypeOf||(Object.getPrototypeOf=function(object){return object.__proto__||(object.constructor?object.constructor.prototype:prototypeOfObject)}),!Object.getOwnPropertyDescriptor){var ERR_NON_OBJECT="Object.getOwnPropertyDescriptor called on a non-object: ";Object.getOwnPropertyDescriptor=function(object,property){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT+object);if(owns(object,property)){var descriptor,getter,setter;if(descriptor={enumerable:!0,configurable:!0},supportsAccessors){var prototype=object.__proto__;object.__proto__=prototypeOfObject;var getter=lookupGetter(object,property),setter=lookupSetter(object,property);if(object.__proto__=prototype,getter||setter)return getter&&(descriptor.get=getter),setter&&(descriptor.set=setter),descriptor}return descriptor.value=object[property],descriptor}}}if(Object.getOwnPropertyNames||(Object.getOwnPropertyNames=function(object){return Object.keys(object)}),!Object.create){var createEmpty;createEmpty=null===Object.prototype.__proto__?function(){return{__proto__:null}}:function(){var empty={};for(var i in empty)empty[i]=null;return empty.constructor=empty.hasOwnProperty=empty.propertyIsEnumerable=empty.isPrototypeOf=empty.toLocaleString=empty.toString=empty.valueOf=empty.__proto__=null,empty},Object.create=function(prototype,properties){var object;if(null===prototype)object=createEmpty();else{if("object"!=typeof prototype)throw new TypeError("typeof prototype["+typeof prototype+"] != \'object\'");var Type=function(){};Type.prototype=prototype,object=new Type,object.__proto__=prototype}return void 0!==properties&&Object.defineProperties(object,properties),object}}if(Object.defineProperty){var definePropertyWorksOnObject=doesDefinePropertyWork({}),definePropertyWorksOnDom="undefined"==typeof document||doesDefinePropertyWork(document.createElement("div"));if(!definePropertyWorksOnObject||!definePropertyWorksOnDom)var definePropertyFallback=Object.defineProperty}if(!Object.defineProperty||definePropertyFallback){var ERR_NON_OBJECT_DESCRIPTOR="Property description must be an object: ",ERR_NON_OBJECT_TARGET="Object.defineProperty called on non-object: ",ERR_ACCESSORS_NOT_SUPPORTED="getters & setters can not be defined on this javascript engine";Object.defineProperty=function(object,property,descriptor){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT_TARGET+object);if("object"!=typeof descriptor&&"function"!=typeof descriptor||null===descriptor)throw new TypeError(ERR_NON_OBJECT_DESCRIPTOR+descriptor);if(definePropertyFallback)try{return definePropertyFallback.call(Object,object,property,descriptor)}catch(exception){}if(owns(descriptor,"value"))if(supportsAccessors&&(lookupGetter(object,property)||lookupSetter(object,property))){var prototype=object.__proto__;object.__proto__=prototypeOfObject,delete object[property],object[property]=descriptor.value,object.__proto__=prototype}else object[property]=descriptor.value;else{if(!supportsAccessors)throw new TypeError(ERR_ACCESSORS_NOT_SUPPORTED);owns(descriptor,"get")&&defineGetter(object,property,descriptor.get),owns(descriptor,"set")&&defineSetter(object,property,descriptor.set)}return object}}Object.defineProperties||(Object.defineProperties=function(object,properties){for(var property in properties)owns(properties,property)&&Object.defineProperty(object,property,properties[property]);return object}),Object.seal||(Object.seal=function(object){return object}),Object.freeze||(Object.freeze=function(object){return object});try{Object.freeze(function(){})}catch(exception){Object.freeze=function(freezeObject){return function(object){return"function"==typeof object?object:freezeObject(object)}}(Object.freeze)}if(Object.preventExtensions||(Object.preventExtensions=function(object){return object}),Object.isSealed||(Object.isSealed=function(){return!1}),Object.isFrozen||(Object.isFrozen=function(){return!1}),Object.isExtensible||(Object.isExtensible=function(object){if(Object(object)===object)throw new TypeError;for(var name="";owns(object,name);)name+="?";object[name]=!0;var returnValue=owns(object,name);return delete object[name],returnValue}),!Object.keys){var hasDontEnumBug=!0,dontEnums=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],dontEnumsLength=dontEnums.length;for(var key in{toString:null})hasDontEnumBug=!1;Object.keys=function(object){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError("Object.keys called on a non-object");var keys=[];for(var name in object)owns(object,name)&&keys.push(name);if(hasDontEnumBug)for(var i=0,ii=dontEnumsLength;ii>i;i++){var dontEnum=dontEnums[i];owns(object,dontEnum)&&keys.push(dontEnum)}return keys}}Date.now||(Date.now=function(){return(new Date).getTime()});var ws="\t\\n\v\\f\\r   ᠎             　\\u2028\\u2029\ufeff";if(!String.prototype.trim||ws.trim()){ws="["+ws+"]";var trimBeginRegexp=RegExp("^"+ws+ws+"*"),trimEndRegexp=RegExp(ws+ws+"*$");String.prototype.trim=function(){return(this+"").replace(trimBeginRegexp,"").replace(trimEndRegexp,"")}}var toObject=function(o){if(null==o)throw new TypeError("can\'t convert "+o+" to object");return Object(o)}});'},function(e,t){ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/keyboard/hash_handler","ace/lib/keys"],function(e,t,i){"use strict";var r=e("../lib/dom"),n=e("../lib/lang"),s=e("../lib/event"),o=e("../keyboard/hash_handler").HashHandler,a=e("../lib/keys");r.importCssString('.ace_search {background-color: #ddd;color: #666;border: 1px solid #cbcbcb;border-top: 0 none;overflow: hidden;margin: 0;padding: 4px 6px 0 4px;position: absolute;top: 0;z-index: 99;white-space: normal;}.ace_search.left {border-left: 0 none;border-radius: 0px 0px 5px 0px;left: 0;}.ace_search.right {border-radius: 0px 0px 0px 5px;border-right: 0 none;right: 0;}.ace_search_form, .ace_replace_form {margin: 0 20px 4px 0;overflow: hidden;line-height: 1.9;}.ace_replace_form {margin-right: 0;}.ace_search_form.ace_nomatch {outline: 1px solid red;}.ace_search_field {border-radius: 3px 0 0 3px;background-color: white;color: black;border: 1px solid #cbcbcb;border-right: 0 none;box-sizing: border-box!important;outline: 0;padding: 0;font-size: inherit;margin: 0;line-height: inherit;padding: 0 6px;min-width: 17em;vertical-align: top;}.ace_searchbtn {border: 1px solid #cbcbcb;line-height: inherit;display: inline-block;padding: 0 6px;background: #fff;border-right: 0 none;border-left: 1px solid #dcdcdc;cursor: pointer;margin: 0;position: relative;box-sizing: content-box!important;color: #666;}.ace_searchbtn:last-child {border-radius: 0 3px 3px 0;border-right: 1px solid #cbcbcb;}.ace_searchbtn:disabled {background: none;cursor: default;}.ace_searchbtn:hover {background-color: #eef1f6;}.ace_searchbtn.prev, .ace_searchbtn.next {padding: 0px 0.7em}.ace_searchbtn.prev:after, .ace_searchbtn.next:after {content: "";border: solid 2px #888;width: 0.5em;height: 0.5em;border-width:  2px 0 0 2px;display:inline-block;transform: rotate(-45deg);}.ace_searchbtn.next:after {border-width: 0 2px 2px 0 ;}.ace_searchbtn_close {background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;border-radius: 50%;border: 0 none;color: #656565;cursor: pointer;font: 16px/16px Arial;padding: 0;height: 14px;width: 14px;top: 9px;right: 7px;position: absolute;}.ace_searchbtn_close:hover {background-color: #656565;background-position: 50% 100%;color: white;}.ace_button {margin-left: 2px;cursor: pointer;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;overflow: hidden;opacity: 0.7;border: 1px solid rgba(100,100,100,0.23);padding: 1px;box-sizing:    border-box!important;color: black;}.ace_button:hover {background-color: #eee;opacity:1;}.ace_button:active {background-color: #ddd;}.ace_button.checked {border-color: #3399ff;opacity:1;}.ace_search_options{margin-bottom: 3px;text-align: right;-webkit-user-select: none;-moz-user-select: none;-o-user-select: none;-ms-user-select: none;user-select: none;clear: both;}.ace_search_counter {float: left;font-family: arial;padding: 0 8px;}',"ace_searchbox");function l(e,t,i){var n=r.createElement("div");n.innerHTML=c,this.element=n.firstChild,this.setSession=this.setSession.bind(this),this.$init(),this.setEditor(e)}var c='<div class="ace_search right">    <span action="hide" class="ace_searchbtn_close"></span>    <div class="ace_search_form">        <input class="ace_search_field" placeholder="Search for" spellcheck="false"></input>        <span action="findPrev" class="ace_searchbtn prev"></span>        <span action="findNext" class="ace_searchbtn next"></span>        <span action="findAll" class="ace_searchbtn" title="Alt-Enter">All</span>    </div>    <div class="ace_replace_form">        <input class="ace_search_field" placeholder="Replace with" spellcheck="false"></input>        <span action="replaceAndFindNext" class="ace_searchbtn">Replace</span>        <span action="replaceAll" class="ace_searchbtn">All</span>    </div>    <div class="ace_search_options">        <span action="toggleReplace" class="ace_button" title="Toggel Replace mode"            style="float:left;margin-top:-2px;padding:0 5px;">+</span>        <span class="ace_search_counter"></span>        <span action="toggleRegexpMode" class="ace_button" title="RegExp Search">.*</span>        <span action="toggleCaseSensitive" class="ace_button" title="CaseSensitive Search">Aa</span>        <span action="toggleWholeWords" class="ace_button" title="Whole Word Search">\\b</span>        <span action="searchInSelection" class="ace_button" title="Search In Selection">S</span>    </div></div>'.replace(/> +/g,">");(function(){this.setEditor=function(e){e.searchBox=this,e.renderer.scroller.appendChild(this.element),this.editor=e},this.setSession=function(e){this.searchRange=null,this.$syncOptions(!0)},this.$initElements=function(e){this.searchBox=e.querySelector(".ace_search_form"),this.replaceBox=e.querySelector(".ace_replace_form"),this.searchOption=e.querySelector("[action=searchInSelection]"),this.replaceOption=e.querySelector("[action=toggleReplace]"),this.regExpOption=e.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=e.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=e.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field"),this.searchCounter=e.querySelector(".ace_search_counter")},this.$init=function(){var e=this.element;this.$initElements(e);var o=this;s.addListener(e,"mousedown",function(e){setTimeout(function(){o.activeInput.focus()},0),s.stopPropagation(e)}),s.addListener(e,"click",function(e){var t=(e.target||e.srcElement).getAttribute("action");t&&o[t]?o[t]():o.$searchBarKb.commands[t]&&o.$searchBarKb.commands[t].exec(o),s.stopPropagation(e)}),s.addCommandKeyListener(e,function(e,t,i){var n=a.keyCodeToString(i),r=o.$searchBarKb.findKeyCommand(t,n);r&&r.exec&&(r.exec(o),s.stopEvent(e))}),this.$onChange=n.delayedCall(function(){o.find(!1,!1)}),s.addListener(this.searchInput,"input",function(){o.$onChange.schedule(20)}),s.addListener(this.searchInput,"focus",function(){o.activeInput=o.searchInput,o.searchInput.value&&o.highlight()}),s.addListener(this.replaceInput,"focus",function(){o.activeInput=o.replaceInput,o.searchInput.value&&o.highlight()})},this.$closeSearchBarKb=new o([{bindKey:"Esc",name:"closeSearchBar",exec:function(e){e.searchBox.hide()}}]),this.$searchBarKb=new o,this.$searchBarKb.bindKeys({"Ctrl-f|Command-f":function(e){var t=e.isReplace=!e.isReplace;e.replaceBox.style.display=t?"":"none",e.replaceOption.checked=!1,e.$syncOptions(),e.searchInput.focus()},"Ctrl-H|Command-Option-F":function(e){e.replaceOption.checked=!0,e.$syncOptions(),e.replaceInput.focus()},"Ctrl-G|Command-G":function(e){e.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(e){e.findPrev()},esc:function(e){setTimeout(function(){e.hide()})},Return:function(e){e.activeInput==e.replaceInput&&e.replace(),e.findNext()},"Shift-Return":function(e){e.activeInput==e.replaceInput&&e.replace(),e.findPrev()},"Alt-Return":function(e){e.activeInput==e.replaceInput&&e.replaceAll(),e.findAll()},Tab:function(e){(e.activeInput==e.replaceInput?e.searchInput:e.replaceInput).focus()}}),this.$searchBarKb.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(e){e.regExpOption.checked=!e.regExpOption.checked,e.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(e){e.caseSensitiveOption.checked=!e.caseSensitiveOption.checked,e.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(e){e.wholeWordOption.checked=!e.wholeWordOption.checked,e.$syncOptions()}},{name:"toggleReplace",exec:function(e){e.replaceOption.checked=!e.replaceOption.checked,e.$syncOptions()}},{name:"searchInSelection",exec:function(e){e.searchOption.checked=!e.searchRange,e.setSearchRange(e.searchOption.checked&&e.editor.getSelectionRange()),e.$syncOptions()}}]),this.setSearchRange=function(e){(this.searchRange=e)?this.searchRangeMarker=this.editor.session.addMarker(e,"ace_active-line"):this.searchRangeMarker&&(this.editor.session.removeMarker(this.searchRangeMarker),this.searchRangeMarker=null)},this.$syncOptions=function(e){r.setCssClass(this.replaceOption,"checked",this.searchRange),r.setCssClass(this.searchOption,"checked",this.searchOption.checked),this.replaceOption.textContent=this.replaceOption.checked?"-":"+",r.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),r.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),r.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked),this.replaceBox.style.display=this.replaceOption.checked?"":"none",this.find(!1,!1,e)},this.highlight=function(e){this.editor.session.highlight(e||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},this.find=function(e,t,i){var n=!this.editor.find(this.searchInput.value,{skipCurrent:e,backwards:t,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:i,range:this.searchRange})&&this.searchInput.value;r.setCssClass(this.searchBox,"ace_nomatch",n),this.editor._emit("findSearchBox",{match:!n}),this.highlight(),this.updateCounter()},this.updateCounter=function(){var e=this.editor,t=e.$search.$options.re,i=0,n=0;if(t){var r=this.searchRange?e.session.getTextRange(this.searchRange):e.getValue(),o=e.session.doc.positionToIndex(e.selection.anchor);this.searchRange&&(o-=e.session.doc.positionToIndex(this.searchRange.start));for(var s,a=t.lastIndex=0;(s=t.exec(r))&&(i++,(a=s.index)<=o&&n++,!(999<i))&&(s[0]||(t.lastIndex=a+=1,!(a>=r.length))););}this.searchCounter.textContent=n+" of "+(999<i?"999+":i)},this.findNext=function(){this.find(!0,!1)},this.findPrev=function(){this.find(!0,!0)},this.findAll=function(){var e=!this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked})&&this.searchInput.value;r.setCssClass(this.searchBox,"ace_nomatch",e),this.editor._emit("findSearchBox",{match:!e}),this.highlight(),this.hide()},this.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},this.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},this.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},this.hide=function(){this.active=!1,this.setSearchRange(null),this.editor.off("changeSession",this.setSession),this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},this.show=function(e,t){this.active=!0,this.editor.on("changeSession",this.setSession),this.element.style.display="",this.replaceOption.checked=t,e&&(this.searchInput.value=e),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb),this.$syncOptions(!0)},this.isFocused=function(){var e=document.activeElement;return e==this.searchInput||e==this.replaceInput}}).call(l.prototype),t.SearchBox=l,t.Search=function(e,t){(e.searchBox||new l(e)).show(e.session.getTextRange(),t)}}),ace.acequire(["ace/ext/searchbox"],function(){})},function(e,t,i){e.exports=function(){"use strict";var o=function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")},e=function(){function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(e,t,i){return t&&n(e.prototype,t),i&&n(e,i),e}}(),m=function(e,t){if(Array.isArray(e))return e;if(Symbol.iterator in Object(e))return function(e,t){var i=[],n=!0,r=!1,o=void 0;try{for(var s,a=e[Symbol.iterator]();!(n=(s=a.next()).done)&&(i.push(s.value),!t||i.length!==t);n=!0);}catch(e){r=!0,o=e}finally{try{!n&&a.return&&a.return()}finally{if(r)throw o}}return i}(e,t);throw new TypeError("Invalid attempt to destructure non-iterable instance")};String.prototype.startsWith=String.prototype.startsWith||function(e){return 0===this.indexOf(e)},String.prototype.padStart=String.prototype.padStart||function(e,t){for(var i=this;i.length<e;)i=t+i;return i};var i={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",
darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",rebeccapurple:"#663399",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"};function s(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:1,i=0<t?e.toFixed(t).replace(/0+$/,"").replace(/\.$/,""):e.toString();return i||"0"}var r=function(){function p(e,t,i,n){o(this,p);var f=this;if(void 0===e);else if(Array.isArray(e))this.rgba=e;else if(void 0===i){var r=e&&""+e;r&&function(e){if(e.startsWith("hsl")){var t=e.match(/([\-\d\.e]+)/g).map(Number),i=m(t,4),n=i[0],r=i[1],o=i[2],s=i[3];void 0===s&&(s=1),n/=360,r/=100,o/=100,f.hsla=[n,r,o,s]}else if(e.startsWith("rgb")){var a=e.match(/([\-\d\.e]+)/g).map(Number),l=m(a,4),c=l[0],h=l[1],d=l[2],u=l[3];void 0===u&&(u=1),f.rgba=[c,h,d,u]}else e.startsWith("#")?f.rgba=p.hexToRgb(e):f.rgba=p.nameToRgb(e)||p.hexToRgb(e)}(r.toLowerCase())}else this.rgba=[e,t,i,void 0===n?1:n]}return e(p,[{key:"printRGB",value:function(e){var t=e?this.rgba:this.rgba.slice(0,3),i=t.map(function(e,t){return s(e,3===t?3:0)});return e?"rgba("+i+")":"rgb("+i+")"}},{key:"printHSL",value:function(e){var i=[360,100,100,1],n=["","%","%",""],t=e?this.hsla:this.hsla.slice(0,3),r=t.map(function(e,t){return s(e*i[t],3===t?3:1)+n[t]});return e?"hsla("+r+")":"hsl("+r+")"}},{key:"printHex",value:function(e){var t=this.hex;return e?t:t.substring(0,7)}},{key:"rgba",get:function(){if(this._rgba)return this._rgba;if(!this._hsla)throw new Error("No color is set");return this._rgba=p.hslToRgb(this._hsla)},set:function(e){3===e.length&&(e[3]=1),this._rgba=e,this._hsla=null}},{key:"rgbString",get:function(){return this.printRGB()}},{key:"rgbaString",get:function(){return this.printRGB(!0)}},{key:"hsla",get:function(){if(this._hsla)return this._hsla;if(!this._rgba)throw new Error("No color is set");return this._hsla=p.rgbToHsl(this._rgba)},set:function(e){3===e.length&&(e[3]=1),this._hsla=e,this._rgba=null}},{key:"hslString",get:function(){return this.printHSL()}},{key:"hslaString",get:function(){return this.printHSL(!0)}},{key:"hex",get:function(){var e=this.rgba,t=e.map(function(e,t){return t<3?e.toString(16):Math.round(255*e).toString(16)});return"#"+t.map(function(e){return e.padStart(2,"0")}).join("")},set:function(e){this.rgba=p.hexToRgb(e)}}],[{key:"hexToRgb",value:function(e){var t=(e.startsWith("#")?e.slice(1):e).replace(/^(\w{3})$/,"$1F").replace(/^(\w)(\w)(\w)(\w)$/,"$1$1$2$2$3$3$4$4").replace(/^(\w{6})$/,"$1FF");if(!t.match(/^([0-9a-fA-F]{8})$/))throw new Error("Unknown hex color; "+e);var i=t.match(/^(\w\w)(\w\w)(\w\w)(\w\w)$/).slice(1).map(function(e){return parseInt(e,16)});return i[3]=i[3]/255,i}},{key:"nameToRgb",value:function(e){var t=i[e];if(t)return p.hexToRgb(t)}},{key:"rgbToHsl",value:function(e){var t=m(e,4),i=t[0],n=t[1],r=t[2],o=t[3];i/=255,n/=255,r/=255;var s=Math.max(i,n,r),a=Math.min(i,n,r),l=void 0,c=void 0,h=(s+a)/2;if(s===a)l=c=0;else{var d=s-a;switch(c=.5<h?d/(2-s-a):d/(s+a),s){case i:l=(n-r)/d+(n<r?6:0);break;case n:l=(r-i)/d+2;break;case r:l=(i-n)/d+4}l/=6}return[l,c,h,o]}},{key:"hslToRgb",value:function(e){var t=m(e,4),i=t[0],n=t[1],r=t[2],o=t[3],s=void 0,a=void 0,l=void 0;if(0===n)s=a=l=r;else{var c=function(e,t,i){return i<0&&(i+=1),1<i&&(i-=1),i<1/6?e+6*(t-e)*i:i<.5?t:i<2/3?e+(t-e)*(2/3-i)*6:e},h=r<.5?r*(1+n):r+n-r*n,d=2*r-h;s=c(d,h,i+1/3),a=c(d,h,i),l=c(d,h,i-1/3)}var u=[255*s,255*a,255*l].map(Math.round);return u[3]=o,u}}]),p}();function a(h,d){var u=!1;function e(e,t,i){e.addEventListener(t,i,!1)}function f(e,t,i){return Math.max(t,Math.min(e,i))}function n(e,t,i){if(i&&(u=!0),u){e.preventDefault();var n=h.getBoundingClientRect(),r=n.width,o=n.height,s=t.clientX,a=t.clientY,l=f(s-n.left,0,r),c=f(a-n.top,0,o);d(l/r,c/o)}}function t(e,t){var i=void 0===e.buttons?e.which:e.buttons;1===i?n(e,e,t):u=!1}function i(e,t){1===e.touches.length?n(e,e.touches[0],t):u=!1}e(h,"mousedown",function(e){t(e,!0)}),e(h,"touchstart",function(e){i(e,!0)}),e(window,"mousemove",t),e(h,"touchmove",i),e(window,"mouseup",function(e){u=!1}),e(h,"touchend",function(e){u=!1}),e(h,"touchcancel",function(e){u=!1})}var l="mousedown",c="focusin";function b(e,t){return(t||document).querySelector(e)}function h(e,t,i){e.addEventListener(t,i,!1)}function d(e){e.preventDefault(),e.stopPropagation()}function u(e,t,i,n){h(e,"keydown",function(e){0<=t.indexOf(e.key)&&(n&&d(e),i(e))})}var t=document.createElement("style");return t.textContent=".picker_wrapper.no_alpha .picker_alpha{display:none}.picker_wrapper.no_editor .picker_editor{position:absolute;z-index:-1;opacity:0}.picker_wrapper.no_cancel .picker_cancel{display:none}.layout_default.picker_wrapper{display:-webkit-box;display:flex;-webkit-box-orient:horizontal;-webkit-box-direction:normal;flex-flow:row wrap;-webkit-box-pack:justify;justify-content:space-between;-webkit-box-align:stretch;align-items:stretch;font-size:10px;width:25em;padding:.5em}.layout_default.picker_wrapper input,.layout_default.picker_wrapper button{font-size:1rem}.layout_default.picker_wrapper>*{margin:.5em}.layout_default.picker_wrapper::before{content:'';display:block;width:100%;height:0;-webkit-box-ordinal-group:2;order:1}.layout_default .picker_slider,.layout_default .picker_selector{padding:1em}.layout_default .picker_hue{width:100%}.layout_default .picker_sl{-webkit-box-flex:1;flex:1 1 auto}.layout_default .picker_sl::before{content:'';display:block;padding-bottom:100%}.layout_default .picker_editor{-webkit-box-ordinal-group:2;order:1;width:6.5rem}.layout_default .picker_editor input{width:100%;height:100%}.layout_default .picker_sample{-webkit-box-ordinal-group:2;order:1;-webkit-box-flex:1;flex:1 1 auto}.layout_default .picker_done,.layout_default .picker_cancel{-webkit-box-ordinal-group:2;order:1}.picker_wrapper{box-sizing:border-box;background:#f2f2f2;box-shadow:0 0 0 1px silver;cursor:default;font-family:sans-serif;color:#444;pointer-events:auto}.picker_wrapper:focus{outline:none}.picker_wrapper button,.picker_wrapper input{box-sizing:border-box;border:none;box-shadow:0 0 0 1px silver;outline:none}.picker_wrapper button:focus,.picker_wrapper button:active,.picker_wrapper input:focus,.picker_wrapper input:active{box-shadow:0 0 2px 1px dodgerblue}.picker_wrapper button{padding:.4em .6em;cursor:pointer;background-color:whitesmoke;background-image:-webkit-gradient(linear, left bottom, left top, from(gainsboro), to(transparent));background-image:-webkit-linear-gradient(bottom, gainsboro, transparent);background-image:linear-gradient(0deg, gainsboro, transparent)}.picker_wrapper button:active{background-image:-webkit-gradient(linear, left bottom, left top, from(transparent), to(gainsboro));background-image:-webkit-linear-gradient(bottom, transparent, gainsboro);background-image:linear-gradient(0deg, transparent, gainsboro)}.picker_wrapper button:hover{background-color:white}.picker_selector{position:absolute;z-index:1;display:block;-webkit-transform:translate(-50%, -50%);transform:translate(-50%, -50%);border:2px solid white;border-radius:100%;box-shadow:0 0 3px 1px #67b9ff;background:currentColor;cursor:pointer}.picker_slider .picker_selector{border-radius:2px}.picker_hue{position:relative;background-image:-webkit-gradient(linear, left top, right top, from(red), color-stop(yellow), color-stop(lime), color-stop(cyan), color-stop(blue), color-stop(magenta), to(red));background-image:-webkit-linear-gradient(left, red, yellow, lime, cyan, blue, magenta, red);background-image:linear-gradient(90deg, red, yellow, lime, cyan, blue, magenta, red);box-shadow:0 0 0 1px silver}.picker_sl{position:relative;box-shadow:0 0 0 1px silver;background-image:-webkit-gradient(linear, left top, left bottom, from(white), color-stop(50%, rgba(255,255,255,0))),-webkit-gradient(linear, left bottom, left top, from(black), color-stop(50%, rgba(0,0,0,0))),-webkit-gradient(linear, left top, right top, from(gray), to(rgba(128,128,128,0)));background-image:-webkit-linear-gradient(top, white, rgba(255,255,255,0) 50%),-webkit-linear-gradient(bottom, black, rgba(0,0,0,0) 50%),-webkit-linear-gradient(left, gray, rgba(128,128,128,0));background-image:linear-gradient(180deg, white, rgba(255,255,255,0) 50%),linear-gradient(0deg, black, rgba(0,0,0,0) 50%),linear-gradient(90deg, gray, rgba(128,128,128,0))}.picker_alpha,.picker_sample{position:relative;background:url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='2' height='2'%3E%3Cpath d='M1,0H0V1H2V2H1' fill='lightgrey'/%3E%3C/svg%3E\") left top/contain white;box-shadow:0 0 0 1px silver}.picker_alpha .picker_selector,.picker_sample .picker_selector{background:none}.picker_editor input{font-family:monospace;padding:.2em .4em}.picker_sample::before{content:'';position:absolute;display:block;width:100%;height:100%;background:currentColor}.picker_arrow{position:absolute;z-index:-1}.picker_wrapper.popup{position:absolute;z-index:2;margin:1.5em}.picker_wrapper.popup,.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{background:#f2f2f2;box-shadow:0 0 10px 1px rgba(0,0,0,0.4)}.picker_wrapper.popup .picker_arrow{width:3em;height:3em;margin:0}.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{content:\"\";display:block;position:absolute;top:0;left:0;z-index:-99}.picker_wrapper.popup .picker_arrow::before{width:100%;height:100%;-webkit-transform:skew(45deg);transform:skew(45deg);-webkit-transform-origin:0 100%;transform-origin:0 100%}.picker_wrapper.popup .picker_arrow::after{width:150%;height:150%;box-shadow:none}.popup.popup_top{bottom:100%;left:0}.popup.popup_top .picker_arrow{bottom:0;left:0;-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.popup.popup_bottom{top:100%;left:0}.popup.popup_bottom .picker_arrow{top:0;left:0;-webkit-transform:rotate(90deg) scale(1, -1);transform:rotate(90deg) scale(1, -1)}.popup.popup_left{top:0;right:100%}.popup.popup_left .picker_arrow{top:0;right:0;-webkit-transform:scale(-1, 1);transform:scale(-1, 1)}.popup.popup_right{top:0;left:100%}.popup.popup_right .picker_arrow{top:0;left:0}",document.documentElement.firstElementChild.appendChild(t),function(){function i(e){var t=this;o(this,i),this.settings={popup:"right",layout:"default",alpha:!0,editor:!0,editorFormat:"hex",cancelButton:!1},this._openProxy=function(e){return t.openHandler(e)},this.onChange=null,this.onDone=null,this.onOpen=null,this.onClose=null,this.setOptions(e)}return e(i,[{key:"setOptions",value:function(e){if(e){var t=this.settings;if(e instanceof HTMLElement)t.parent=e;else{t.parent&&e.parent&&t.parent!==e.parent&&(t.parent.removeEventListener("click",this._openProxy,!1),this._popupInited=!1),function(e,t,i){for(var n in e)i&&0<=i.indexOf(n)||(t[n]=e[n])}(e,t),e.onChange&&(this.onChange=e.onChange),e.onDone&&(this.onDone=e.onDone),e.onOpen&&(this.onOpen=e.onOpen),e.onClose&&(this.onClose=e.onClose);var i=e.color||e.colour;i&&this._setColor(i)}var n=t.parent;n&&t.popup&&!this._popupInited?(h(n,"click",this._openProxy),u(n,[" ","Spacebar","Enter"],this._openProxy),this._popupInited=!0):e.parent&&!t.popup&&this.show()}}},{key:"openHandler",value:function(e){if(this.show()){e&&e.preventDefault(),this.settings.parent.style.pointerEvents="none";var t=e&&"keydown"===e.type?this._domEdit:this.domElement;setTimeout(function(){return t.focus()},100),this.onOpen&&this.onOpen(this.colour)}}},{key:"closeHandler",value:function(e){var t=e&&e.type,i=!1;if(e)if(t===l||t===c){var n=(this.__containedEvent||0)+100;e.timeStamp>n&&(i=!0)}else d(e),i=!0;else i=!0;i&&this.hide()&&(this.settings.parent.style.pointerEvents="",t!==l&&this.settings.parent.focus(),this.onClose&&this.onClose(this.colour))}},{key:"movePopup",value:function(e,t){this.closeHandler(),this.setOptions(e),t&&this.openHandler()}},{key:"setColor",value:function(e,t){this._setColor(e,{silent:t})}},{key:"_setColor",value:function(e,t){if("string"==typeof e&&(e=e.trim()),e){t=t||{};var i=void 0;try{i=new r(e)}catch(e){if(t.failSilently)return;throw e}if(!this.settings.alpha){var n=i.hsla;n[3]=1,i.hsla=n}this.colour=this.color=i,this._setHSLA(null,null,null,null,t)}}},{key:"setColour",value:function(e,t){this.setColor(e,t)}},{key:"show",value:function(){if(!this.settings.parent)return!1;if(this.domElement){var e=this._toggleDOM(!0);return this._setPosition(),e}var t=function(e){var t=document.createElement("div");return t.innerHTML=e,t.firstElementChild}(this.settings.template||'<div class="picker_wrapper" tabindex="-1"><div class="picker_arrow"></div><div class="picker_hue picker_slider"><div class="picker_selector"></div></div><div class="picker_sl"><div class="picker_selector"></div></div><div class="picker_alpha picker_slider"><div class="picker_selector"></div></div><div class="picker_editor"><input aria-label="Type a color name or hex value"/></div><div class="picker_sample"></div><div class="picker_done"><button>Ok</button></div><div class="picker_cancel"><button>Cancel</button></div></div>');return this.domElement=t,this._domH=b(".picker_hue",t),this._domSL=b(".picker_sl",t),this._domA=b(".picker_alpha",t),this._domEdit=b(".picker_editor input",t),this._domSample=b(".picker_sample",t),this._domOkay=b(".picker_done button",t),this._domCancel=b(".picker_cancel button",t),t.classList.add("layout_"+this.settings.layout),this.settings.alpha||t.classList.add("no_alpha"),this.settings.editor||t.classList.add("no_editor"),this.settings.cancelButton||t.classList.add("no_cancel"),this._ifPopup(function(){return t.classList.add("popup")}),this._setPosition(),this.colour?this._updateUI():this._setColor("#0cf"),this._bindEvents(),!0}},{key:"hide",value:function(){return this._toggleDOM(!1)}},{key:"_bindEvents",value:function(){var i=this,n=this,r=this.domElement;h(r,"click",function(e){return e.preventDefault()}),a(this._domH,function(e,t){return n._setHSLA(e)}),a(this._domSL,function(e,t){return n._setHSLA(null,e,1-t)}),this.settings.alpha&&a(this._domA,function(e,t){return n._setHSLA(null,null,null,1-t)});var e=this._domEdit;function t(e){i._ifPopup(function(){return i.closeHandler(e)}),i.onDone&&i.onDone(i.colour)}h(e,"input",function(e){n._setColor(this.value,{fromEditor:!0,failSilently:!0})}),h(e,"focus",function(e){this.selectionStart===this.selectionEnd&&this.select()}),this._ifPopup(function(){function e(e){return i.closeHandler(e)}function t(e){i.__containedEvent=e.timeStamp}h(window,l,e),h(window,c,e),u(r,["Esc","Escape"],e),h(r,l,t),h(r,c,t),h(i._domCancel,"click",e)}),h(this._domOkay,"click",t),u(r,["Enter"],t)}},{key:"_setPosition",value:function(){var i=this.settings.parent,n=this.domElement;i!==n.parentNode&&i.appendChild(n),this._ifPopup(function(e){"static"===getComputedStyle(i).position&&(i.style.position="relative");var t=!0===e?"popup_right":"popup_"+e;["popup_top","popup_bottom","popup_left","popup_right"].forEach(function(e){e===t?n.classList.add(e):n.classList.remove(e)}),n.classList.add(t)})}},{key:"_setHSLA",value:function(e,t,i,n,r){r=r||{};var o=this.colour,s=o.hsla;[e,t,i,n].forEach(function(e,t){!e&&0!==e||(s[t]=e)}),o.hsla=s,this._updateUI(r),this.onChange&&!r.silent&&this.onChange(o)}},{key:"_updateUI",value:function(e){if(this.domElement){e=e||{};var t=this.colour,i=t.hsla,n="hsl("+360*i[0]+", 100%, 50%)",r=t.hslString,o=t.hslaString,s=this._domH,a=this._domSL,l=this._domA,c=b(".picker_selector",s),h=b(".picker_selector",a),d=b(".picker_selector",l);y(0,c,i[0]),this._domSL.style.backgroundColor=this._domH.style.color=n,y(0,h,i[1]),w(0,h,1-i[2]),a.style.color=r,w(0,d,1-i[3]);var u=r,f=u.replace("hsl","hsla").replace(")",", 0)"),p="linear-gradient("+[u,f]+")";if(this._domA.style.backgroundImage=p+", url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='2' height='2'%3E%3Cpath d='M1,0H0V1H2V2H1' fill='lightgrey'/%3E%3C/svg%3E\")",!e.fromEditor){var m=this.settings.editorFormat,g=this.settings.alpha,v=void 0;switch(m){case"rgb":v=t.printRGB(g);break;case"hsl":v=t.printHSL(g);break;default:v=t.printHex(g)}this._domEdit.value=v}this._domSample.style.color=o}function y(e,t,i){t.style.left=100*i+"%"}function w(e,t,i){t.style.top=100*i+"%"}}},{key:"_ifPopup",value:function(e,t){this.settings.parent&&this.settings.popup?e&&e(this.settings.popup):t&&t()}},{key:"_toggleDOM",value:function(e){var t=this.domElement;if(!t)return!1;var i=e?"":"none",n=t.style.display!==i;return n&&(t.style.display=i),n}}],[{key:"StyleElement",get:function(){return t}}]),i}()}()},function(e,t,i){"use strict";var n=i(22),r=i(70),o=i(71),c=i(74),s=i(4),h=i(75),l=i(76),d=i(11),u=i(0),a=i(81),f=i(1).translate,p=i(1).setLanguages,m=i(1).setLanguage,g={create:function(e,t){if(!e)throw new Error("No container element provided.");this.container=e,this.dom={},this.highlighter=new r,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.validationSequence=0,this.errorNodes=[],this.node=null,this.focusTarget=null,this._setOptions(t),t.autocomplete&&(this.autocomplete=new a(t.autocomplete)),this.options.history&&"view"!==this.options.mode&&(this.history=new o(this)),this._createFrame(),this._createTable()},destroy:function(){this.frame&&this.container&&this.frame.parentNode==this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null)},_setOptions:function(e){if(this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,mainMenuBar:!0,onSelectionChange:null,colorPicker:!0,onColorPicker:function(e,t,i){n?new n({parent:e,color:t,popup:"bottom",onDone:function(e){var t=1===e.rgba[3]?e.hex.substr(0,7):e.hex;i(t)}}).show():console.warn("Cannot open color picker: the `vanilla-picker` library is not included in the bundle. Either use the full bundle or implement your own color picker using `onColorPicker`.")},timestampTag:!0,onEvent:null,enableSort:!0,enableTransform:!0},e)for(var t in e)e.hasOwnProperty(t)&&(this.options[t]=e[t]);this.setSchema(this.options.schema,this.options.schemaRefs),this._debouncedValidate=u.debounce(this.validate.bind(this),this.DEBOUNCE_INTERVAL),e.onSelectionChange&&this.onSelectionChange(e.onSelectionChange),p(this.options.languages),m(this.options.language)},set:function(e){if(e instanceof Function||void 0===e)this.clear();else{this.content.removeChild(this.table);var t={field:this.options.name,value:e},i=new l(this,t);this._setRoot(i),this.validate();this.node.expand(!1),this.content.appendChild(this.table)}this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},update:function(e){if(!this.node.deepEqual(e)){var t=this.getSelection();if(this.onChangeDisabled=!0,this.node.update(e),this.onChangeDisabled=!1,this.validate(),this.searchBox&&!this.searchBox.isEmpty()&&this.searchBox.forceSearch(),t&&t.start&&t.end){var i=this.node.findNodeByPath(t.start.path),n=this.node.findNodeByPath(t.end.path);i&&n?this.setSelection(t.start,t.end):this.setSelection({},{})}else this.setSelection({},{})}},get:function(){return this.node?this.node.getValue():void 0},getText:function(){return JSON.stringify(this.get())},setText:function(t){try{this.set(u.parse(t))}catch(e){var i=u.repair(t);this.set(u.parse(i))}},updateText:function(t){try{this.update(u.parse(t))}catch(e){var i=u.repair(t);this.update(u.parse(i))}},setName:function(e){this.options.name=e,this.node&&this.node.updateField(this.options.name)},getName:function(){return this.options.name},focus:function(){var e=this.scrollableContent.querySelector("[contenteditable=true]");e?e.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(e=this.frame.querySelector("button"))&&e.focus()},clear:function(){this.node&&(this.node.hide(),delete this.node),this.treePath&&this.treePath.reset()},_setRoot:function(e){this.clear(),(this.node=e).setParent(null),e.setField(void 0,!1),delete e.index,this.tbody.appendChild(e.getDom())},search:function(e){var t;return this.node?(this.content.removeChild(this.table),t=this.node.search(e),this.content.appendChild(this.table)):t=[],t},expandAll:function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},collapseAll:function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},_onAction:function(e,t){this.history&&this.history.add(e,t),this._onChange()},_onChange:function(){if(!this.onChangeDisabled){if(this.selection=this.getDomSelection(),this._debouncedValidate(),this.treePath){var e=this.selection?this.node.findNodeByInternalPath(this.selection.path):this.multiselection?this.multiselection.nodes[0]:void 0;e?this._updateTreePath(e.getNodePath()):this.treePath.reset()}if(this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}if(this.options.onClassName&&this.node.recursivelyUpdateCssClassesOnNodes(),this.options.onNodeName&&this.node.childs)try{this.node.recursivelyUpdateNodeName()}catch(e){console.error("Error in onNodeName callback: ",e)}}},validate:function(){var t=this.node;if(t){var e=t.getValue(),i=[];if(this.validateSchema)this.validateSchema(e)||(i=this.validateSchema.errors.map(function(e){return u.improveSchemaError(e)}).map(function(e){return{node:t.findNode(e.dataPath),error:e}}).filter(function(e){return null!=e.node}));try{this.validationSequence++;var n=this,r=this.validationSequence;this._validateCustom(e).then(function(e){if(r===n.validationSequence){var t=[].concat(i,e||[]);n._renderValidationErrors(t)}}).catch(function(e){console.error(e)})}catch(e){console.error(e)}}},_renderValidationErrors:function(e){this.errorNodes&&this.errorNodes.forEach(function(e){e.setError(null)});var t=e.reduce(function(e,t){return t.node.findParents().filter(function(t){return!e.some(function(e){return e[0]===t})}).map(function(e){return[e,t.node]}).concat(e)},[]);this.errorNodes=t.map(function(e){return{node:e[0],child:e[1],error:{message:"object"===e[0].type?"Contains invalid properties":"Contains invalid items"}}}).concat(e).map(function(e){return e.node.setError(e.error,e.child),e.node})},_validateCustom:function(e){try{if(this.options.onValidate){var i=this.node,t=this.options.onValidate(e);return(u.isPromise(t)?t:Promise.resolve(t)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=u.isValidValidationError(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){var t;try{t=e&&e.path?i.findNodeByPath(e.path):null}catch(e){}return t||console.warn("Ignoring validation error: node not found. Path:",e.path,"Error:",e),{node:t,error:e}}).filter(function(e){return e&&e.node&&e.error&&e.error.message}):null})}}catch(e){return Promise.reject(e)}return Promise.resolve(null)},refresh:function(){this.node&&this.node.updateDom({recurse:!0})},startAutoScroll:function(e){var t=this,i=this.scrollableContent,n=u.getAbsoluteTop(i),r=i.clientHeight,o=n+r;e<n+24&&0<i.scrollTop?this.autoScrollStep=(n+24-e)/3:o-24<e&&r+i.scrollTop<i.scrollHeight?this.autoScrollStep=(o-24-e)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){t.autoScrollStep?i.scrollTop-=t.autoScrollStep:t.stopAutoScroll()},50)):this.stopAutoScroll()},stopAutoScroll:function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},setDomSelection:function(e){if(e)if("scrollTop"in e&&this.scrollableContent&&(this.scrollableContent.scrollTop=e.scrollTop),e.paths){var t=this,i=e.paths.map(function(e){return t.node.findNodeByInternalPath(e)});this.select(i)}else{var n=e.path?this.node.findNodeByInternalPath(e.path):null,r=n&&e.domName?n.dom[e.domName]:null;if(e.range&&r){var o=Object.assign({},e.range,{container:r});u.setSelectionOffset(o)}else n&&n.focus()}},getDomSelection:function(){var t=l.getNodeFromTarget(this.focusTarget),i=this.focusTarget,e=t?Object.keys(t.dom).find(function(e){return t.dom[e]===i}):null,n=u.getSelectionOffset();return n&&"DIV"!==n.container.nodeName&&(n=null),n&&n.container!==i&&(n=null),n&&delete n.container,{path:t?t.getInternalPath():null,domName:e,range:n,paths:0<this.multiselection.length?this.multiselection.nodes.map(function(e){return e.getInternalPath()}):null,scrollTop:this.scrollableContent?this.scrollableContent.scrollTop:0}},scrollTo:function(e,i){var n=this.scrollableContent;if(n){var r=this;r.animateTimeout&&(clearTimeout(r.animateTimeout),delete r.animateTimeout),r.animateCallback&&(r.animateCallback(!1),delete r.animateCallback);var t=n.clientHeight,o=n.scrollHeight-t,s=Math.min(Math.max(e-t/4,0),o),a=function(){var e=n.scrollTop,t=s-e;3<Math.abs(t)?(n.scrollTop+=t/3,r.animateCallback=i,r.animateTimeout=setTimeout(a,50)):(i&&i(!0),n.scrollTop=s,delete r.animateTimeout,delete r.animateCallback)};a()}else i&&i(!1)},_createFrame:function(){this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame),this.contentOuter=document.createElement("div"),this.contentOuter.className="jsoneditor-outer";var t=this;function i(e){t._onEvent&&t._onEvent(e)}if(this.frame.onclick=function(e){var t=e.target;i(e),"BUTTON"==t.nodeName&&e.preventDefault()},this.frame.oninput=i,this.frame.onchange=i,this.frame.onkeydown=i,this.frame.onkeyup=i,this.frame.oncut=i,this.frame.onpaste=i,this.frame.onmousedown=i,this.frame.onmouseup=i,this.frame.onmouseover=i,this.frame.onmouseout=i,u.addEventListener(this.frame,"focus",i,!0),u.addEventListener(this.frame,"blur",i,!0),this.frame.onfocusin=i,this.frame.onfocusout=i,this.options.mainMenuBar){u.addClassName(this.contentOuter,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var e=document.createElement("button");e.type="button",e.className="jsoneditor-expand-all",e.title=f("expandAll"),e.onclick=function(){t.expandAll()},this.menu.appendChild(e);var n=document.createElement("button");if(n.type="button",n.title=f("collapseAll"),n.className="jsoneditor-collapse-all",n.onclick=function(){t.collapseAll()},this.menu.appendChild(n),this.options.enableSort){var r=document.createElement("button");r.type="button",r.className="jsoneditor-sort",r.title=f("sortTitleShort"),r.onclick=function(){t.node.showSortModal()},this.menu.appendChild(r)}if(this.options.enableTransform){var o=document.createElement("button");o.type="button",o.title=f("transformTitleShort"),o.className="jsoneditor-transform",o.onclick=function(){t.node.showTransformModal()},this.menu.appendChild(o)}if(this.history){var s=document.createElement("button");s.type="button",s.className="jsoneditor-undo jsoneditor-separator",s.title=f("undo"),s.onclick=function(){t._onUndo()},this.menu.appendChild(s),this.dom.undo=s;var a=document.createElement("button");a.type="button",a.className="jsoneditor-redo",a.title=f("redo"),a.onclick=function(){t._onRedo()},this.menu.appendChild(a),this.dom.redo=a,this.history.onChange=function(){s.disabled=!t.history.canUndo(),a.disabled=!t.history.canRedo()},this.history.onChange()}if(this.options&&this.options.modes&&this.options.modes.length){var l=this;this.modeSwitcher=new d(this.menu,this.options.modes,this.options.mode,function(e){l.setMode(e),l.modeSwitcher.focus()})}this.options.search&&(this.searchBox=new c(this,this.menu))}this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new h(this.navBar,this.frame),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},_onUndo:function(){this.history&&(this.history.undo(),this._onChange())},_onRedo:function(){this.history&&(this.history.redo(),this._onChange())},_onEvent:function(e){if(!l.targetIsColorPicker(e.target)){var t=l.getNodeFromTarget(e.target);if("keydown"===e.type&&this._onKeyDown(e),"focus"===e.type&&(this.focusTarget=e.target,this.options.autocomplete&&"focus"===this.options.autocomplete.trigger&&this._showAutoComplete(e.target)),"mousedown"===e.type&&this._startDragDistance(e),"mousemove"!==e.type&&"mouseup"!==e.type&&"click"!==e.type||this._updateDragDistance(e),t&&this.options&&this.options.navigationBar&&t&&("keydown"===e.type||"mousedown"===e.type)){var i=this;setTimeout(function(){i._updateTreePath(t.getNodePath())})}if(t&&t.selected){if("click"===e.type){if(e.target===t.dom.menu)return void this.showContextMenu(e.target);e.hasMoved||this.deselect()}"mousedown"===e.type&&l.onDragStart(this.multiselection.nodes,e)}else"mousedown"===e.type&&u.hasParentNode(e.target,this.content)&&(this.deselect(),t&&e.target===t.dom.drag?l.onDragStart(t,e):t&&(e.target===t.dom.field||e.target===t.dom.value||e.target===t.dom.select)||this._onMultiSelectStart(e));t&&t.onEvent(e)}},_updateTreePath:function(e){if(e&&e.length){u.removeClassName(this.navBar,"nav-bar-empty");var i=[];e.forEach(function(e){var t={name:n(e),node:e,children:[]};e.childs&&e.childs.length&&e.childs.forEach(function(e){t.children.push({name:n(e),node:e})}),i.push(t)}),this.treePath.setPath(i)}else u.addClassName(this.navBar,"nav-bar-empty");function n(e){return e.parent?"array"===e.parent.type?e.index:e.field:e.type}},_onTreePathSectionSelected:function(e){e&&e.node&&(e.node.expandTo(),e.node.focus())},_onTreePathMenuItemSelected:function(e,t){if(e&&e.children.length){var i=e.children.find(function(e){return e.name===t});i&&i.node&&(this._updateTreePath(i.node.getNodePath()),i.node.expandTo(),i.node.focus())}},_startDragDistance:function(e){this.dragDistanceEvent={initialTarget:e.target,initialPageX:e.pageX,initialPageY:e.pageY,dragDistance:0,hasMoved:!1}},_updateDragDistance:function(e){this.dragDistanceEvent||this._startDragDistance(e);var t=e.pageX-this.dragDistanceEvent.initialPageX,i=e.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(t*t+i*i),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||10<this.dragDistanceEvent.dragDistance,e.dragDistance=this.dragDistanceEvent.dragDistance,e.hasMoved=this.dragDistanceEvent.hasMoved,e.dragDistance},_onMultiSelectStart:function(e){var t=l.getNodeFromTarget(e.target);if("tree"===this.options.mode&&void 0===this.options.onEditable){this.multiselection={start:t||null,end:null,nodes:[]},this._startDragDistance(e);var i=this;this.mousemove||(this.mousemove=u.addEventListener(window,"mousemove",function(e){i._onMultiSelect(e)})),this.mouseup||(this.mouseup=u.addEventListener(window,"mouseup",function(e){i._onMultiSelectEnd(e)})),e.preventDefault()}},_onMultiSelect:function(e){if(e.preventDefault(),this._updateDragDistance(e),e.hasMoved){var t=l.getNodeFromTarget(e.target);t&&(null==this.multiselection.start&&(this.multiselection.start=t),this.multiselection.end=t),this.deselect();var i=this.multiselection.start,n=this.multiselection.end||this.multiselection.start;if(i&&n){if(this.multiselection.nodes=this._findTopLevelNodes(i,n),this.multiselection.nodes&&this.multiselection.nodes.length){var r=this.multiselection.nodes[0];this.multiselection.start===r||this.multiselection.start.isDescendantOf(r)?this.multiselection.direction="down":this.multiselection.direction="up"}this.select(this.multiselection.nodes)}}},_onMultiSelectEnd:function(){this.multiselection.nodes[0]&&this.multiselection.nodes[0].dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&(u.removeEventListener(window,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&(u.removeEventListener(window,"mouseup",this.mouseup),delete this.mouseup)},deselect:function(e){var t=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(e){e.setSelected(!1)}),this.multiselection.nodes=[],e&&(this.multiselection.start=null,this.multiselection.end=null),t&&this._selectionChangedHandler&&this._selectionChangedHandler()},select:function(e){if(!Array.isArray(e))return this.select([e]);if(e){this.deselect(),this.multiselection.nodes=e.slice(0);var t=e[0];if(e.forEach(function(e){e.expandPathToNode(),e.setSelected(!0,e===t)}),this._selectionChangedHandler){var i=this.getSelection();this._selectionChangedHandler(i.start,i.end)}}},_findTopLevelNodes:function(e,t){for(var i=e.getNodePath(),n=t.getNodePath(),r=0;r<i.length&&i[r]===n[r];)r++;var o=i[r-1],s=i[r],a=n[r];if(s&&a||(o.parent?o=(a=s=o).parent:(s=o.childs[0],a=o.childs[o.childs.length-1])),o&&s&&a){var l=o.childs.indexOf(s),c=o.childs.indexOf(a),h=Math.min(l,c),d=Math.max(l,c);return o.childs.slice(h,d+1)}return[]},_showAutoComplete:function(t){var i=l.getNodeFromTarget(t),n="";0<=event.target.className.indexOf("jsoneditor-value")&&(n="value"),0<=event.target.className.indexOf("jsoneditor-field")&&(n="field");var r=this;setTimeout(function(){if("focus"===r.options.autocomplete.trigger||0<t.innerText.length){var e=r.options.autocomplete.getOptions(t.innerText,i.getPath(),n,i.editor);null===e?r.autocomplete.hideDropDown():"function"==typeof e.then?e.then(function(e){null===e?r.autocomplete.hideDropDown():e.options?r.autocomplete.show(t,e.startFrom,e.options):r.autocomplete.show(t,0,e)}.bind(r)):e.options?r.autocomplete.show(t,e.startFrom,e.options):r.autocomplete.show(t,0,e)}else r.autocomplete.hideDropDown()},50)},_onKeyDown:function(e){var t=e.which||e.keyCode,i=e.altKey,n=e.ctrlKey,r=e.metaKey,o=e.shiftKey,s=!1;if(9==t){var a=this;setTimeout(function(){u.selectContentEditable(a.focusTarget)},0)}if(this.searchBox)if(n&&70==t)this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),s=!0;else if(114==t||n&&71==t){o?this.searchBox.previous(!0):this.searchBox.next(!0),s=!0}if(this.history&&(n&&!o&&90==t?(this._onUndo(),s=!0):n&&o&&90==t&&(this._onRedo(),s=!0)),this.options.autocomplete&&!s&&!(n||i||r||1!=e.key.length&&8!=t&&46!=t)){s=!1;l.getNodeFromTarget(e.target);this._showAutoComplete(e.target)}s&&(e.preventDefault(),e.stopPropagation())},_createTable:function(){var e;this.options.navigationBar&&u.addClassName(this.contentOuter,"has-nav-bar"),this.scrollableContent=document.createElement("div"),this.scrollableContent.className="jsoneditor-tree",this.contentOuter.appendChild(this.scrollableContent),this.content=document.createElement("div"),this.content.className="jsoneditor-tree-inner",this.scrollableContent.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table),this.colgroupContent=document.createElement("colgroup"),"tree"===this.options.mode&&((e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e)),(e=document.createElement("col")).width="24px",this.colgroupContent.appendChild(e),e=document.createElement("col"),this.colgroupContent.appendChild(e),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(this.contentOuter)},showContextMenu:function(e,t){var i=[],n=this.multiselection.nodes.slice();if(i.push({text:f("duplicateText"),title:f("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){l.onDuplicate(n)}}),i.push({text:f("remove"),title:f("removeTitle"),className:"jsoneditor-remove",click:function(){l.onRemove(n)}}),this.options.onCreateMenu){var r=n.map(function(e){return e.getPath()});i=this.options.onCreateMenu(i,{type:"multiple",path:r[0],paths:r})}new s(i,{close:t}).show(e,this.frame)},getSelection:function(){var e={start:null,end:null};if(this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length){var t=this.multiselection.nodes[0],i=this.multiselection.nodes[this.multiselection.nodes.length-1];"down"===this.multiselection.direction?(e.start=t.serialize(),e.end=i.serialize()):(e.start=i.serialize(),e.end=t.serialize())}return e},onSelectionChange:function(e){"function"==typeof e&&(this._selectionChangedHandler=u.debounce(e,this.DEBOUNCE_INTERVAL))},setSelection:function(e,t){e&&e.dom&&e.range&&(console.warn("setSelection/getSelection usage for text selection is deprecated and should not be used, see documentation for supported selection options"),this.setDomSelection(e));var i=this._getNodeInstancesByRange(e,t);i.forEach(function(e){e.expandTo()}),this.select(i)},_getNodeInstancesByRange:function(e,t){var i,n;e&&e.path&&(i=this.node.findNodeByPath(e.path),t&&t.path&&(n=this.node.findNodeByPath(t.path)));var r=[];if(i instanceof l)if(n instanceof l&&n!==i)if(i.parent===n.parent){t=i.getIndex()<n.getIndex()?(e=i,n):(e=n,i);var o=e;for(r.push(o);o=o.nextSibling(),r.push(o),o&&o!==t;);}else r=this._findTopLevelNodes(i,n);else r.push(i);return r},getNodesByRange:function(e,t){var i=this._getNodeInstancesByRange(e,t),n=[];return i.forEach(function(e){n.push(e.serialize())}),n}};e.exports=[{mode:"tree",mixin:g,data:"json"},{mode:"view",mixin:g,data:"json"},{mode:"form",mixin:g,data:"json"}]},function(e,t,i){"use strict";function n(){this.locked=!1}n.prototype.highlight=function(e){this.locked||(this.node!=e&&(this.node&&this.node.setHighlight(!1),this.node=e,this.node.setHighlight(!0)),this._cancelUnhighlight())},n.prototype.unhighlight=function(){if(!this.locked){var e=this;this.node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){e.node.setHighlight(!1),e.node=void 0,e.unhighlightTimer=void 0},0))}},n.prototype._cancelUnhighlight=function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)},n.prototype.lock=function(){this.locked=!0},n.prototype.unlock=function(){this.locked=!1},e.exports=n},function(e,t,i){"use strict";var s=i(0);function n(t){function o(e){return t.node.findNodeByInternalPath(e)}this.editor=t,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function(e){o(e.parentPath).childs[e.index].updateField(e.oldValue)},redo:function(e){o(e.parentPath).childs[e.index].updateField(e.newValue)}},editValue:{undo:function(e){o(e.path).updateValue(e.oldValue)},redo:function(e){o(e.path).updateValue(e.newValue)}},changeType:{undo:function(e){o(e.path).changeType(e.oldType)},redo:function(e){o(e.path).changeType(e.newType)}},appendNodes:{undo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=o(e.parentPath);e.nodes.forEach(function(e){t.appendChild(e)})}},insertBeforeNodes:{undo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=o(e.parentPath),i=o(e.beforePath);e.nodes.forEach(function(e){t.insertBefore(e,i)})}},insertAfterNodes:{undo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var t=o(e.parentPath),i=o(e.afterPath);e.nodes.forEach(function(e){t.insertAfter(e,i),i=e})}},removeNodes:{undo:function(e){var t=o(e.parentPath),i=t.childs[e.index]||t.append;e.nodes.forEach(function(e){t.insertBefore(e,i)})},redo:function(e){var t=o(e.parentPath);e.paths.map(o).forEach(function(e){t.removeChild(e)})}},duplicateNodes:{undo:function(e){var t=o(e.parentPath);e.clonePaths.map(o).forEach(function(e){t.removeChild(e)})},redo:function(e){var n=o(e.parentPath),r=o(e.afterPath);e.paths.map(o).forEach(function(e){var t=e.clone();if("object"===n.type){var i=n.getFieldNames();t.field=s.findUniqueName(e.field,i)}n.insertAfter(t,r),r=t})}},moveNodes:{undo:function(i){var n=o(i.oldParentPath),e=o(i.newParentPath),r=n.childs[i.oldIndex]||n.append;e.childs.slice(i.newIndex,i.newIndex+i.count).forEach(function(e,t){e.field=i.fieldNames[t],n.moveBefore(e,r)}),null===i.newParentPathRedo&&(i.newParentPathRedo=e.getInternalPath())},redo:function(i){var e=o(i.oldParentPathRedo),n=o(i.newParentPathRedo),r=n.childs[i.newIndexRedo]||n.append;e.childs.slice(i.oldIndexRedo,i.oldIndexRedo+i.count).forEach(function(e,t){e.field=i.fieldNames[t],n.moveBefore(e,r)})}},sort:{undo:function(e){var t=o(e.path);t.hideChilds(),t.childs=e.oldChilds,t.updateDom({updateIndexes:!0}),t.showChilds()},redo:function(e){var t=o(e.path);t.hideChilds(),t.childs=e.newChilds,t.updateDom({updateIndexes:!0}),t.showChilds()}},transform:{undo:function(e){o(e.path).setInternalValue(e.oldValue)},redo:function(e){o(e.path).setInternalValue(e.newValue)}}}}n.prototype.onChange=function(){},n.prototype.add=function(e,t){this.index++,this.history[this.index]={action:e,params:t,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()},n.prototype.clear=function(){this.history=[],this.index=-1,this.onChange()},n.prototype.canUndo=function(){return 0<=this.index},n.prototype.canRedo=function(){return this.index<this.history.length-1},n.prototype.undo=function(){if(this.canUndo()){var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.undo){if(t.undo(e.params),e.params.oldSelection)try{this.editor.setDomSelection(e.params.oldSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.index--,this.onChange()}},n.prototype.redo=function(){if(this.canRedo()){this.index++;var e=this.history[this.index];if(e){var t=this.actions[e.action];if(t&&t.redo){if(t.redo(e.params),e.params.newSelection)try{this.editor.setDomSelection(e.params.newSelection)}catch(e){console.error(e)}}else console.error(new Error('unknown action "'+e.action+'"'))}this.onChange()}},n.prototype.destroy=function(){this.editor=null,this.history=[],this.index=-1},e.exports=n},function(e,t,i){var n,r=((n={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(e,t,i,n,r,o,s){var a=o.length-1;switch(r){case 1:this.$=e.replace(/\\(\\|")/g,"$1").replace(/\\n/g,"\n").replace(/\\r/g,"\r").replace(/\\t/g,"\t").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(e);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=o[a-1];case 13:this.$={};break;case 14:this.$=o[a-1];break;case 15:this.$=[o[a-2],o[a]];break;case 16:this.$={},this.$[o[a][0]]=o[a][1];break;case 17:this.$=o[a-2],o[a-2][o[a][0]]=o[a][1];break;case 18:this.$=[];break;case 19:this.$=o[a-1];break;case 20:this.$=[o[a]];break;case 21:this.$=o[a-2],o[a-2].push(o[a])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(e,t){throw new Error(e)},parse:function(e){var t=this,i=[0],n=[null],r=[],o=this.table,s="",a=0,l=0,c=0;this.lexer.setInput(e),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,void 0===this.lexer.yylloc&&(this.lexer.yylloc={});var h=this.lexer.yylloc;function d(){var e;return"number"!=typeof(e=t.lexer.lex()||1)&&(e=t.symbols_[e]||e),e}r.push(h),"function"==typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var u,f,p,m,g,v,y,w,b,C,E={};;){if(p=i[i.length-1],void 0===(m=this.defaultActions[p]?this.defaultActions[p]:(null==u&&(u=d()),o[p]&&o[p][u]))||!m.length||!m[0]){if(!c){for(v in b=[],o[p])this.terminals_[v]&&2<v&&b.push("'"+this.terminals_[v]+"'");var A="";A=this.lexer.showPosition?"Parse error on line "+(a+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+b.join(", ")+", got '"+this.terminals_[u]+"'":"Parse error on line "+(a+1)+": Unexpected "+(1==u?"end of input":"'"+(this.terminals_[u]||u)+"'"),this.parseError(A,{text:this.lexer.match,token:this.terminals_[u]||u,line:this.lexer.yylineno,loc:h,expected:b})}if(3==c){if(1==u)throw new Error(A||"Parsing halted.");l=this.lexer.yyleng,s=this.lexer.yytext,a=this.lexer.yylineno,h=this.lexer.yylloc,u=d()}for(;!(2..toString()in o[p]);){if(0==p)throw new Error(A||"Parsing halted.");C=1,i.length=i.length-2*C,n.length=n.length-C,r.length=r.length-C,p=i[i.length-1]}f=u,u=2,m=o[p=i[i.length-1]]&&o[p][2],c=3}if(m[0]instanceof Array&&1<m.length)throw new Error("Parse Error: multiple actions possible at state: "+p+", token: "+u);switch(m[0]){case 1:i.push(u),n.push(this.lexer.yytext),r.push(this.lexer.yylloc),i.push(m[1]),u=null,f?(u=f,f=null):(l=this.lexer.yyleng,s=this.lexer.yytext,a=this.lexer.yylineno,h=this.lexer.yylloc,0<c&&c--);break;case 2:if(y=this.productions_[m[1]][1],E.$=n[n.length-y],E._$={first_line:r[r.length-(y||1)].first_line,last_line:r[r.length-1].last_line,first_column:r[r.length-(y||1)].first_column,last_column:r[r.length-1].last_column},void 0!==(g=this.performAction.call(E,s,l,a,this.yy,m[1],n,r)))return g;y&&(i=i.slice(0,-1*y*2),n=n.slice(0,-1*y),r=r.slice(0,-1*y)),i.push(this.productions_[m[1]][0]),n.push(E.$),r.push(E._$),w=o[i[i.length-2]][i[i.length-1]],i.push(w);break;case 3:return!0}}return!0}}).lexer={EOF:1,parseError:function(e,t){if(!this.yy.parseError)throw new Error(e);this.yy.parseError(e,t)},setInput:function(e){return this._input=e,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var e=this._input[0];return this.yytext+=e,this.yyleng++,this.match+=e,this.matched+=e,e.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),e},unput:function(e){return this._input=e+this._input,this},more:function(){return this._more=!0,this},less:function(e){this._input=this.match.slice(e)+this._input},pastInput:function(){var e=this.matched.substr(0,this.matched.length-this.match.length);return(20<e.length?"...":"")+e.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var e=this.match;return e.length<20&&(e+=this._input.substr(0,20-e.length)),(e.substr(0,20)+(20<e.length?"...":"")).replace(/\n/g,"")},showPosition:function(){var e=this.pastInput(),t=new Array(e.length+1).join("-");return e+this.upcomingInput()+"\n"+t+"^"},next:function(){if(this.done)return this.EOF;var e,t,i,n,r;this._input||(this.done=!0),this._more||(this.yytext="",this.match="");for(var o=this._currentRules(),s=0;s<o.length&&(!(i=this._input.match(this.rules[o[s]]))||t&&!(i[0].length>t[0].length)||(t=i,n=s,this.options.flex));s++);return t?((r=t[0].match(/\n.*/g))&&(this.yylineno+=r.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:r?r[r.length-1].length-1:this.yylloc.last_column+t[0].length},this.yytext+=t[0],this.match+=t[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(t[0].length),this.matched+=t[0],e=this.performAction.call(this,this.yy,this,o[n],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),e||void 0):""===this._input?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var e=this.next();return void 0!==e?e:this.lex()},begin:function(e){this.conditionStack.push(e)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(e){this.begin(e)},options:{},performAction:function(e,t,i,n){switch(i){case 0:break;case 1:return 6;case 2:return t.yytext=t.yytext.substr(1,t.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}}},n);t.parser=r,t.parse=r.parse.bind(r)},function(e,t,i){"use strict";var w={b:"\b",f:"\f",n:"\n",r:"\r",t:"\t",'"':'"',"/":"/","\\":"\\"},b="a".charCodeAt();t.parse=function(r){var n={},e=0,t=0,o=0;return{data:s("",!0),pointers:n};function s(e,t){var i;a(),f(e,"value");var n=h();switch(n){case"t":c("rue"),i=!0;break;case"f":c("alse"),i=!1;break;case"n":c("ull"),i=null;break;case'"':i=l();break;case"[":i=function(e){a();var t=[],i=0;if("]"==h())return t;d();for(;;){var n=e+"/"+i;t.push(s(n)),a();var r=h();if("]"==r)break;","!=r&&v(),a(),i++}return t}(e);break;case"{":i=function(e){a();var t={};if("}"==h())return t;d();for(;;){var i=m();'"'!=h()&&v();var n=l(),r=e+"/"+C(n);p(r,"key",i),f(r,"keyEnd"),a(),":"!=h()&&v(),a(),t[n]=s(r),a();var o=h();if("}"==o)break;","!=o&&v(),a()}return t}(e);break;default:d(),0<="-0123456789".indexOf(n)?i=function(){var e="";"-"==r[o]&&(e+=h());e+="0"==r[o]?h():u(),"."==r[o]&&(e+=h()+u());"e"!=r[o]&&"E"!=r[o]||(e+=h(),"+"!=r[o]&&"-"!=r[o]||(e+=h()),e+=u());return+e}():g()}return f(e,"valueEnd"),a(),t&&o<r.length&&g(),i}function a(){e:for(;o<r.length;){switch(r[o]){case" ":t++;break;case"\t":t+=4;break;case"\r":t=0;break;case"\n":t=0,e++;break;default:break e}o++}}function l(){for(var e,t="";'"'!=(e=h());)"\\"==e?(e=h())in w?t+=w[e]:"u"==e?t+=i():v():t+=e;return t}function c(e){for(var t=0;t<e.length;t++)h()!==e[t]&&v()}function h(){y();var e=r[o];return o++,t++,e}function d(){o--,t--}function i(){for(var e=4,t=0;e--;){t<<=4;var i=h().toLowerCase();"a"<=i&&i<="f"?t+=i.charCodeAt()-b+10:"0"<=i&&i<="9"?t+=+i:v()}return String.fromCharCode(t)}function u(){for(var e="";"0"<=r[o]&&r[o]<="9";)e+=h();if(e.length)return e;y(),g()}function f(e,t){p(e,t,m())}function p(e,t,i){n[e]=n[e]||{},n[e][t]=i}function m(){return{line:e,column:t,pos:o}}function g(){throw new SyntaxError("Unexpected token "+r[o]+" in JSON at position "+o)}function v(){d(),g()}function y(){if(o>=r.length)throw new SyntaxError("Unexpected end of JSON input")}},t.stringify=function(e,t,h){if(v(e)){var i,n,r=0;switch(typeof h){case"number":var o=10<h?10:h<0?0:Math.floor(h);h=o&&g(o," "),n=i=o;break;case"string":h=h.slice(0,10);for(var s=n=i=0;s<h.length;s++){switch(h[s]){case" ":n++;break;case"\t":n+=4;break;case"\r":n=0;break;case"\n":n=0,r++;break;default:throw new Error("whitespace characters not allowed in JSON")}i++}break;default:h=void 0}var a="",l={},c=0,d=0,u=0;return function s(a,l,c){m(c,"value");switch(typeof a){case"number":case"boolean":f(""+a);break;case"string":f(y(a));break;case"object":null===a?f("null"):"function"==typeof a.toJSON?f(y(a.toJSON())):Array.isArray(a)?e():t()}m(c,"valueEnd");function e(){if(a.length){f("[");for(var e=l+1,t=0;t<a.length;t++){t&&f(","),p(e);var i=v(a[t])?a[t]:null,n=c+"/"+t;s(i,e,n)}p(l),f("]")}else f("[]")}function t(){var e=Object.keys(a);if(e.length){f("{");for(var t=l+1,i=0;i<e.length;i++){var n=e[i],r=a[n];if(v(r)){i&&f(",");var o=c+"/"+C(n);p(t),m(o,"key"),f(y(n)),m(o,"keyEnd"),f(":"),h&&f(" "),s(r,t,o)}}p(l),f("}")}else f("{}")}}(e,0,""),{json:a,pointers:l}}function f(e){d+=e.length,u+=e.length,a+=e}function p(e){if(h){for(a+="\n"+g(e,h),c++,d=0;e--;)r?(c+=r,d=n):d+=n,u+=i;u+=1}}function m(e,t){l[e]=l[e]||{},l[e][t]={line:c,column:d,pos:u}}function g(e,t){return Array(e+1).join(t)}};var n=["number","boolean","string","object"];function v(e){return 0<=n.indexOf(typeof e)}var r=/"|\\/g,o=/[\b]/g,s=/\f/g,a=/\n/g,l=/\r/g,c=/\t/g;function y(e){return'"'+(e=e.replace(r,"\\$&").replace(s,"\\f").replace(o,"\\b").replace(a,"\\n").replace(l,"\\r").replace(c,"\\t"))+'"'}var h=/~/g,d=/\//g;function C(e){return e.replace(h,"~0").replace(d,"~1")}},function(e,t,i){"use strict";function n(e,t){var i=this;this.editor=e,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.dom={},this.dom.container=t;var n=document.createElement("table");(this.dom.table=n).className="jsoneditor-search",t.appendChild(n);var r=document.createElement("tbody");this.dom.tbody=r,n.appendChild(r);var o=document.createElement("tr");r.appendChild(o);var s=document.createElement("td");o.appendChild(s);var a=document.createElement("div");(this.dom.results=a).className="jsoneditor-results",s.appendChild(a),s=document.createElement("td"),o.appendChild(s);var l=document.createElement("div");(this.dom.input=l).className="jsoneditor-frame",l.title="Search fields and values",s.appendChild(l);var c=document.createElement("table");l.appendChild(c);var h=document.createElement("tbody");c.appendChild(h),o=document.createElement("tr"),h.appendChild(o);var d=document.createElement("button");d.type="button",d.className="jsoneditor-refresh",(s=document.createElement("td")).appendChild(d),o.appendChild(s);var u=document.createElement("input");(this.dom.search=u).oninput=function(e){i._onDelayedSearch(e)},u.onchange=function(e){i._onSearch()},u.onkeydown=function(e){i._onKeyDown(e)},u.onkeyup=function(e){i._onKeyUp(e)},d.onclick=function(e){u.select()},(s=document.createElement("td")).appendChild(u),o.appendChild(s);var f=document.createElement("button");f.type="button",f.title="Next result (Enter)",f.className="jsoneditor-next",f.onclick=function(){i.next()},(s=document.createElement("td")).appendChild(f),o.appendChild(s);var p=document.createElement("button");p.type="button",p.title="Previous result (Shift+Enter)",p.className="jsoneditor-previous",p.onclick=function(){i.previous()},(s=document.createElement("td")).appendChild(p),o.appendChild(s)}n.prototype.next=function(e){if(null!=this.results){var t=null!=this.resultIndex?this.resultIndex+1:0;t>this.results.length-1&&(t=0),this._setActiveResult(t,e)}},n.prototype.previous=function(e){if(null!=this.results){var t=this.results.length-1,i=null!=this.resultIndex?this.resultIndex-1:t;i<0&&(i=t),this._setActiveResult(i,e)}},n.prototype._setActiveResult=function(e,t){if(this.activeResult){var i=this.activeResult.node;"field"==this.activeResult.elem?delete i.searchFieldActive:delete i.searchValueActive,i.updateDom()}if(!this.results||!this.results[e])return this.resultIndex=void 0,void(this.activeResult=void 0);this.resultIndex=e;var n=this.results[this.resultIndex].node,r=this.results[this.resultIndex].elem;"field"==r?n.searchFieldActive=!0:n.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],n.updateDom(),n.scrollTo(function(){t&&n.focus(r)})},n.prototype._clearDelay=function(){null!=this.timeout&&(clearTimeout(this.timeout),delete this.timeout)},n.prototype._onDelayedSearch=function(e){this._clearDelay();var t=this;this.timeout=setTimeout(function(e){t._onSearch()},this.delay)},n.prototype._onSearch=function(e){this._clearDelay();var t=this.dom.search.value,i=0<t.length?t:void 0;if(i!==this.lastText||e){this.lastText=i,this.results=this.editor.search(i);var n=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:1/0,r=0;if(this.activeResult)for(var o=0;o<this.results.length;o++)if(this.results[o].node===this.activeResult.node){r=o;break}if(this._setActiveResult(r,!1),void 0!==i){var s=this.results.length;this.dom.results.innerHTML=0===s?"no&nbsp;results":1===s?"1&nbsp;result":n<s?n+"+&nbsp;results":s+"&nbsp;results"}else this.dom.results.innerHTML=""}},n.prototype._onKeyDown=function(e){var t=e.which;27==t?(this.dom.search.value="",this._onSearch(),e.preventDefault(),e.stopPropagation()):13==t&&(e.ctrlKey?this._onSearch(!0):e.shiftKey?this.previous():this.next(),e.preventDefault(),e.stopPropagation())},n.prototype._onKeyUp=function(e){var t=e.keyCode;27!=t&&13!=t&&this._onDelayedSearch(e)},n.prototype.clear=function(){this.dom.search.value="",this._onSearch()},n.prototype.forceSearch=function(){this._onSearch(!0)},n.prototype.isEmpty=function(){return""===this.dom.search.value},n.prototype.destroy=function(){this.editor=null,this.dom.container.removeChild(this.dom.table),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()},e.exports=n},function(e,t,i){"use strict";var l=i(4),n=i(1).translate,c=i(0);function r(e,t){e&&(this.root=t,this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",this.path.setAttribute("tabindex",0),this.contentMenuClicked,e.appendChild(this.path),this.reset())}r.prototype.reset=function(){this.path.innerHTML=n("selectNode")},r.prototype.setPath=function(s){var a=this;this.path.innerHTML="",s&&s.length&&s.forEach(function(i,n){var e,t=document.createElement("span");if(t.className="jsoneditor-treepath-element",t.innerText=i.name,t.onclick=function(e){this.selectionCallback&&this.selectionCallback(e)}.bind(a,i),a.path.appendChild(t),i.children.length&&((e=document.createElement("span")).className="jsoneditor-treepath-seperator",e.innerHTML="&#9658;",e.onclick=function(){a.contentMenuClicked=!0;var t=[];i.children.forEach(function(e){t.push({text:e.name,className:"jsoneditor-type-modes"+(s[n+1]+1&&s[n+1].name===e.name?" jsoneditor-selected":""),click:function(e,t){this.contextMenuCallback&&this.contextMenuCallback(e,t)}.bind(a,i,e.name)})}),new l(t).show(e,a.root,!0)},a.path.appendChild(e)),n===s.length-1){var r=(e||t).getBoundingClientRect().right;if(a.path.offsetWidth<r&&(a.path.scrollLeft=r),a.path.scrollLeft){var o=document.createElement("span");o.className="jsoneditor-treepath-show-all-btn",o.title="show all path",o.innerHTML="...",o.onclick=function(e){a.contentMenuClicked=!1,c.addClassName(a.path,"show-all"),a.path.style.width=a.path.parentNode.getBoundingClientRect().width-10+"px",a.path.onblur=function(){if(a.contentMenuClicked)return a.contentMenuClicked=!1,void a.path.focus();c.removeClassName(a.path,"show-all"),a.path.onblur=void 0,a.path.style.width="",a.setPath(e)}}.bind(a,s),a.path.insertBefore(o,a.path.firstChild)}}})},r.prototype.onSectionSelected=function(e){"function"==typeof e&&(this.selectionCallback=e)},r.prototype.onContextMenuItemSelected=function(e){"function"==typeof e&&(this.contextMenuCallback=e)},e.exports=r},function(e,t,i){"use strict";var o=i(5),l=i(24),n=i(25).createAbsoluteAnchor,c=i(4),r=i(77),s=i(78),a=i(9),h=i(10),L=i(0),d=i(1).translate,u=i(2).DEFAULT_MODAL_ANCHOR;function R(e,t){this.editor=e,this.dom={},this.expanded=!1,t&&t instanceof Object?(this.setField(t.field,t.fieldEditable),"value"in t&&this.setValue(t.value,t.type),"internalValue"in t&&this.setInternalValue(t.internalValue)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=L.debounce(this._onChangeValue.bind(this),R.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=L.debounce(this._onChangeField.bind(this),R.prototype.DEBOUNCE_INTERVAL),this.visibleChilds=this.getMaxVisibleChilds()}R.prototype.DEBOUNCE_INTERVAL=150,R.prototype.MAX_SEARCH_RESULTS=999;function f(e){return e.getInternalPath()}function P(e){return e.getField()}R.prototype.getMaxVisibleChilds=function(){return this.editor&&this.editor.options&&this.editor.options.maxVisibleChilds?this.editor.options.maxVisibleChilds:100},R.prototype._updateEditability=function(){if(this.editable={field:!0,value:!0},this.editor&&(this.editable.field="tree"===this.editor.options.mode,this.editable.value="view"!==this.editor.options.mode,("tree"===this.editor.options.mode||"form"===this.editor.options.mode)&&"function"==typeof this.editor.options.onEditable)){var e=this.editor.options.onEditable({field:this.field,value:this.value,path:this.getPath()});"boolean"==typeof e?(this.editable.field=e,this.editable.value=e):("boolean"==typeof e.field&&(
this.editable.field=e.field),"boolean"==typeof e.value&&(this.editable.value=e.value))}},R.prototype.getPath=function(){for(var e=this,t=[];e;){var i=e.getName();void 0!==i&&t.unshift(i),e=e.parent}return t},R.prototype.getInternalPath=function(){for(var e=this,t=[];e;)e.parent&&t.unshift(e.getIndex()),e=e.parent;return t},R.prototype.getName=function(){return this.parent?"array"!=this.parent.type?this.field:this.index:void 0},R.prototype.findNodeByPath=function(e){if(e){if(0==e.length)return this;if(e.length&&this.childs&&this.childs.length)for(var t=0;t<this.childs.length;++t)if(""+e[0]==""+this.childs[t].getName())return this.childs[t].findNodeByPath(e.slice(1))}},R.prototype.findNodeByInternalPath=function(e){if(e){for(var t=this,i=0;i<e.length&&t;i++){var n=e[i];t=t.childs[n]}return t}},R.prototype.serialize=function(){return{value:this.getValue(),path:this.getPath()}},R.prototype.findNode=function(e){for(var t=L.parsePath(e),i=this;i&&0<t.length;){var n=t.shift();if("number"==typeof n){if("array"!==i.type)throw new Error("Cannot get child node at index "+n+": node is no array");i=i.childs[n]}else{if("object"!==i.type)throw new Error("Cannot get child node "+n+": node is no object");i=i.childs.filter(function(e){return e.field===n})[0]}}return i},R.prototype.findParents=function(){for(var e=[],t=this.parent;t;)e.unshift(t),t=t.parent;return e},R.prototype.setError=function(e,t){this.error=e,this.errorChild=t,this.dom&&this.dom.tr&&this.updateError()},R.prototype.updateError=function(){var e=this.fieldError||this.valueError||this.error,t=this.dom.tdError;if(e&&this.dom&&this.dom.tr){L.addClassName(this.dom.tr,"jsoneditor-validation-error"),t||(t=document.createElement("td"),this.dom.tdError=t,this.dom.tdValue.parentNode.appendChild(t));var o=document.createElement("div");o.className="jsoneditor-popover jsoneditor-right",o.appendChild(document.createTextNode(e.message));var i=document.createElement("button");i.type="button",i.className="jsoneditor-button jsoneditor-schema-error",i.appendChild(o),i.onmouseover=i.onfocus=function(){for(var e=["right","above","below","left"],t=0;t<e.length;t++){var i=e[t];o.className="jsoneditor-popover jsoneditor-"+i;var n=this.editor.content.getBoundingClientRect(),r=o.getBoundingClientRect();if(L.insideRect(n,r,20))break}}.bind(this);var n=this.errorChild;for(n&&(i.onclick=function(){n.findParents().forEach(function(e){e.expand(!1)}),n.scrollTo(function(){n.focus()})});t.firstChild;)t.removeChild(t.firstChild);t.appendChild(i)}else this.dom.tr&&L.removeClassName(this.dom.tr,"jsoneditor-validation-error"),t&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)},R.prototype.getIndex=function(){if(this.parent){var e=this.parent.childs.indexOf(this);return-1!==e?e:null}return-1},R.prototype.setParent=function(e){this.parent=e},R.prototype.setField=function(e,t){this.field=e,this.previousField=e,this.fieldEditable=!0===t},R.prototype.getField=function(){return void 0===this.field&&this._getDomField(),this.field},R.prototype.setValue=function(e,t){var i,n,r,o,s,a=this.childs;if(this.type=this._getType(e),t&&t!==this.type){if("string"!==t||"auto"!==this.type)throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+t+'"');this.type=t}if("array"===this.type){for(this.childs||(this.childs=[]),o=0;o<e.length;o++)void 0===(i=e[o])||i instanceof Function||(o<this.childs.length?((n=this.childs[o]).fieldEditable=!1,n.index=o,n.setValue(i)):(n=new R(this.editor,{value:i}),r=o<this.getMaxVisibleChilds(),this.appendChild(n,r,!1)));for(s=this.childs.length;s>=e.length;s--)this.removeChild(this.childs[s],!1)}else if("object"===this.type){for(this.childs||(this.childs=[]),s=this.childs.length-1;0<=s;s--)e.hasOwnProperty(this.childs[s].field)||this.removeChild(this.childs[s],!1);for(var l in o=0,e)e.hasOwnProperty(l)&&(void 0===(i=e[l])||i instanceof Function||((n=this.findChildByProperty(l))?(n.setField(l,!0),n.setValue(i)):(n=new R(this.editor,{field:l,value:i}),r=o<this.getMaxVisibleChilds(),this.appendChild(n,r,!1))),o++);!(this.value="")===this.editor.options.sortObjectKeys&&this.sort([],"asc")}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e;Array.isArray(a)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value},R.prototype.setInternalValue=function(e){var t,i,n,r,o,s=this.childs;if(this.type=e.type,"array"===e.type){for(this.childs||(this.childs=[]),r=0;r<e.childs.length;r++)void 0===(t=e.childs[r])||t instanceof Function||(r<this.childs.length?((i=this.childs[r]).fieldEditable=!1,i.index=r,i.setInternalValue(t)):(i=new R(this.editor,{internalValue:t}),n=r<this.getMaxVisibleChilds(),this.appendChild(i,n,!1)));for(o=this.childs.length;o>=e.childs.length;o--)this.removeChild(this.childs[o],!1)}else if("object"===e.type){for(this.childs||(this.childs=[]),r=0;r<e.childs.length;r++)void 0===(t=e.childs[r])||t instanceof Function||(r<this.childs.length?(delete(i=this.childs[r]).index,i.setField(t.field,!0),i.setInternalValue(t.value)):(i=new R(this.editor,{field:t.field,internalValue:t.value}),n=r<this.getMaxVisibleChilds(),this.appendChild(i,n,!1)));for(o=this.childs.length;o>=e.childs.length;o--)this.removeChild(this.childs[o],!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=e.value;Array.isArray(s)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value},R.prototype.recreateDom=function(){if(this.dom&&this.dom.tr&&this.dom.tr.parentNode){var e=this._detachFromDom();this.clearDom(),this._attachToDom(e)}else this.clearDom()},R.prototype.getValue=function(){if("array"==this.type){var t=[];return this.childs.forEach(function(e){t.push(e.getValue())}),t}if("object"!=this.type)return void 0===this.value&&this._getDomValue(),this.value;var i={};return this.childs.forEach(function(e){i[e.getField()]=e.getValue()}),i},R.prototype.getInternalValue=function(){return"array"===this.type?{type:this.type,childs:this.childs.map(function(e){return e.getInternalValue()})}:"object"===this.type?{type:this.type,childs:this.childs.map(function(e){return{field:e.getField(),value:e.getInternalValue()}})}:(void 0===this.value&&this._getDomValue(),{type:this.type,value:this.value})},R.prototype.getLevel=function(){return this.parent?this.parent.getLevel()+1:0},R.prototype.getNodePath=function(){var e=this.parent?this.parent.getNodePath():[];return e.push(this),e},R.prototype.clone=function(){var i=new R(this.editor);if(i.type=this.type,i.field=this.field,i.fieldInnerText=this.fieldInnerText,i.fieldEditable=this.fieldEditable,i.previousField=this.previousField,i.value=this.value,i.valueInnerText=this.valueInnerText,i.previousValue=this.previousValue,i.expanded=this.expanded,i.visibleChilds=this.visibleChilds,this.childs){var n=[];this.childs.forEach(function(e){var t=e.clone();t.setParent(i),n.push(t)}),i.childs=n}else i.childs=void 0;return i},R.prototype.expand=function(t){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-expanded"),this.showChilds(),!1!==t&&this.childs.forEach(function(e){e.expand(t)}))},R.prototype.collapse=function(t){this.childs&&(this.hideChilds(),!1!==t&&this.childs.forEach(function(e){e.collapse(t)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-collapsed"),this.expanded=!1)},R.prototype.showChilds=function(){if(this.childs&&this.expanded){var e=this.dom.tr,t=e?e.parentNode:void 0;if(t){var i=this.getAppendDom();if(!i.parentNode)(r=e.nextSibling)?t.insertBefore(i,r):t.appendChild(i);for(var n=Math.min(this.childs.length,this.visibleChilds),r=this._getNextTr(),o=0;o<n;o++){var s=this.childs[o];s.getDom().parentNode||t.insertBefore(s.getDom(),r),s.showChilds()}var a=this.getShowMoreDom();r=this._getNextTr();a.parentNode||t.insertBefore(a,r),this.showMore.updateDom()}}},R.prototype._getNextTr=function(){return this.showMore&&this.showMore.getDom().parentNode?this.showMore.getDom():this.append&&this.append.getDom().parentNode?this.append.getDom():void 0},R.prototype.hide=function(e){var t=this.dom.tr,i=t?t.parentNode:void 0;i&&i.removeChild(t),this.hideChilds(e)},R.prototype.hideChilds=function(e){if(this.childs&&this.expanded){var t=this.getAppendDom();t.parentNode&&t.parentNode.removeChild(t),this.childs.forEach(function(e){e.hide()});var i=this.getShowMoreDom();i.parentNode&&i.parentNode.removeChild(i),e&&!e.resetVisibleChilds||(this.visibleChilds=this.getMaxVisibleChilds())}},R.prototype._updateCssClassName=function(){if(this.dom.field&&this.editor&&this.editor.options&&"function"==typeof this.editor.options.onClassName&&this.dom.tree){L.removeAllClassNames(this.dom.tree);var e=this.editor.options.onClassName({path:this.getPath(),field:this.field,value:this.value})||"";L.addClassName(this.dom.tree,"jsoneditor-values "+e)}},R.prototype.recursivelyUpdateCssClassesOnNodes=function(){if(this._updateCssClassName(),Array.isArray(this.childs))for(var e=0;e<this.childs.length;e++)this.childs[e].recursivelyUpdateCssClassesOnNodes()},R.prototype.expandTo=function(){for(var e=this.parent;e;)e.expanded||e.expand(),e=e.parent},R.prototype.appendChild=function(e,t,i){if(this._hasChilds()){if(e.setParent(this),e.fieldEditable="object"==this.type,"array"==this.type&&(e.index=this.childs.length),"object"===this.type&&null==e.field&&e.setField(""),this.childs.push(e),this.expanded&&!1!==t){var n=e.getDom(),r=this._getNextTr(),o=r?r.parentNode:void 0;r&&o&&o.insertBefore(n,r),e.showChilds(),this.visibleChilds++}!1!==i&&(this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0}))}},R.prototype.moveBefore=function(e,t){if(this._hasChilds()){var i=this.dom.tr?this.dom.tr.parentNode:void 0;if(i){var n=document.createElement("tr");n.style.height=i.clientHeight+"px",i.appendChild(n)}if(e.parent&&e.parent.removeChild(e),t instanceof O||!t)if(this.childs.length+1>this.visibleChilds){var r=this.childs[this.visibleChilds-1];this.insertBefore(e,r)}else this.appendChild(e);else this.insertBefore(e,t);i&&i.removeChild(n)}},R.prototype.insertBefore=function(e,t){if(this._hasChilds()){if(this.visibleChilds++,"object"===this.type&&null==e.field&&e.setField(""),t===this.append)e.setParent(this),e.fieldEditable="object"==this.type,this.childs.push(e);else{var i=this.childs.indexOf(t);if(-1==i)throw new Error("Node not found");e.setParent(this),e.fieldEditable="object"==this.type,this.childs.splice(i,0,e)}if(this.expanded){var n=e.getDom(),r=t.getDom(),o=r?r.parentNode:void 0;r&&o&&o.insertBefore(n,r),e.showChilds(),this.showChilds()}this.updateDom({updateIndexes:!0}),e.updateDom({recurse:!0})}},R.prototype.insertAfter=function(e,t){if(this._hasChilds()){var i=this.childs.indexOf(t),n=this.childs[i+1];n?this.insertBefore(e,n):this.appendChild(e)}},R.prototype.search=function(t,i){Array.isArray(i)||(i=[]);var e=t?t.toLowerCase():void 0;delete this.searchField,delete this.searchValue,void 0!==this.field&&i.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.field).toLowerCase().indexOf(e)&&(this.searchField=!0,i.push({node:this,elem:"field"})),this._updateDomField());this._hasChilds()?this.childs&&this.childs.forEach(function(e){e.search(t,i)}):void 0!==this.value&&i.length<=this.MAX_SEARCH_RESULTS&&(-1!==String(this.value).toLowerCase().indexOf(e)&&(this.searchValue=!0,i.push({node:this,elem:"value"})),this._updateDomValue());return i},R.prototype.scrollTo=function(e){this.expandPathToNode(),this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,e)},R.prototype.expandPathToNode=function(){for(var e=this;e&&e.parent;){for(var t="array"===e.parent.type?e.index:e.parent.childs.indexOf(e);e.parent.visibleChilds<t+1;)e.parent.visibleChilds+=this.getMaxVisibleChilds();e.parent.expand(!1),e=e.parent}},R.focusElement=void 0,R.prototype.focus=function(e){if(R.focusElement=e,this.dom.tr&&this.dom.tr.parentNode){var t=this.dom;switch(e){case"drag":t.drag?t.drag.focus():t.menu.focus();break;case"menu":t.menu.focus();break;case"expand":this._hasChilds()?t.expand.focus():t.field&&this.fieldEditable?(t.field.focus(),L.selectContentEditable(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),L.selectContentEditable(t.value)):t.menu.focus();break;case"field":t.field&&this.fieldEditable?(t.field.focus(),L.selectContentEditable(t.field)):t.value&&!this._hasChilds()?(t.value.focus(),L.selectContentEditable(t.value)):this._hasChilds()?t.expand.focus():t.menu.focus();break;case"value":default:t.select?t.select.focus():t.value&&!this._hasChilds()?(t.value.focus(),L.selectContentEditable(t.value)):t.field&&this.fieldEditable?(t.field.focus(),L.selectContentEditable(t.field)):this._hasChilds()?t.expand.focus():t.menu.focus()}}},R.select=function(e){setTimeout(function(){L.selectContentEditable(e)},0)},R.prototype.containsNode=function(e){if(this==e)return!0;var t=this.childs;if(t)for(var i=0,n=t.length;i<n;i++)if(t[i].containsNode(e))return!0;return!1},R.prototype.removeChild=function(e,t){if(this.childs){var i=this.childs.indexOf(e);if(-1!==i){i<this.visibleChilds&&this.expanded&&this.visibleChilds--,e.hide(),delete e.searchField,delete e.searchValue;var n=this.childs.splice(i,1)[0];return n.parent=null,!1!==t&&this.updateDom({updateIndexes:!0}),n}}},R.prototype._remove=function(e){this.removeChild(e)},R.prototype.changeType=function(e){var t=this.type;if(t!=e){if("string"!=e&&"auto"!=e||"string"!=t&&"auto"!=t){var i=this._detachFromDom();this.clearDom(),"object"==(this.type=e)?(this.childs||(this.childs=[]),this.childs.forEach(function(e){e.clearDom(),delete e.index,e.fieldEditable=!0,null==e.field&&(e.field="")}),"string"!=t&&"auto"!=t||(this.expanded=!0)):"array"==e?(this.childs||(this.childs=[]),this.childs.forEach(function(e,t){e.clearDom(),e.fieldEditable=!1,e.index=t}),"string"!=t&&"auto"!=t||(this.expanded=!0)):this.expanded=!1,this._attachToDom(i)}else this.type=e;"auto"!=e&&"string"!=e||(this.value="string"==e?String(this.value):L.parseString(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0})}},R.prototype.deepEqual=function(e){var t;if("array"===this.type){if(!Array.isArray(e))return!1;if(this.childs.length!==e.length)return!1;for(t=0;t<this.childs.length;t++)if(!this.childs[t].deepEqual(e[t]))return!1}else if("object"===this.type){if("object"!=typeof e||!e)return!1;var i={},n=0;for(t=0;t<this.childs.length;t++){var r=this.childs[t];if(!i[r.field]){if(i[r.field]=!0,n++,!(r.field in e))return!1;if(!r.deepEqual(e[r.field]))return!1}}if(n!==Object.keys(e).length)return!1}else if(this.value!==e)return!1;return!0},R.prototype._getDomValue=function(){if(this._clearValueError(),this.dom.value&&"array"!=this.type&&"object"!=this.type&&(this.valueInnerText=L.getInnerText(this.dom.value)),null!=this.valueInnerText)try{var e;if("string"==this.type)e=this._unescapeHTML(this.valueInnerText);else{var t=this._unescapeHTML(this.valueInnerText);e=L.parseString(t)}e!==this.value&&(this.value=e,this._debouncedOnChangeValue())}catch(e){this._setValueError(d("cannotParseValueError"))}},R.prototype._setValueError=function(e){this.valueError={message:e},this.updateError()},R.prototype._clearValueError=function(){this.valueError&&(this.valueError=null,this.updateError())},R.prototype._setFieldError=function(e){this.fieldError={message:e},this.updateError()},R.prototype._clearFieldError=function(){this.fieldError&&(this.fieldError=null,this.updateError())},R.prototype._onChangeValue=function(){var e=this.editor.getDomSelection();if(e.range){var t=L.textDiff(String(this.value),String(this.previousValue));e.range.startOffset=t.start,e.range.endOffset=t.end}var i=this.editor.getDomSelection();if(i.range){var n=L.textDiff(String(this.previousValue),String(this.value));i.range.startOffset=n.start,i.range.endOffset=n.end}this.editor._onAction("editValue",{path:this.getInternalPath(),oldValue:this.previousValue,newValue:this.value,oldSelection:e,newSelection:i}),this.previousValue=this.value},R.prototype._onChangeField=function(){var e=this.editor.getDomSelection(),t=this.previousField||"";if(e.range){var i=L.textDiff(this.field,t);e.range.startOffset=i.start,e.range.endOffset=i.end}var n=this.editor.getDomSelection();if(n.range){var r=L.textDiff(t,this.field);n.range.startOffset=r.start,n.range.endOffset=r.end}this.editor._onAction("editField",{parentPath:this.parent.getInternalPath(),index:this.getIndex(),oldValue:this.previousField,newValue:this.field,oldSelection:e,newSelection:n}),this.previousField=this.field},R.prototype._updateDomValue=function(){var e=this.dom.value;if(e){var t=["jsoneditor-value"],i=this.value,n="auto"==this.type?L.type(i):this.type,r="string"==n&&L.isUrl(i);if(t.push("jsoneditor-"+n),r&&t.push("jsoneditor-url"),""==String(this.value)&&"array"!=this.type&&"object"!=this.type&&t.push("jsoneditor-empty"),this.searchValueActive&&t.push("jsoneditor-highlight-active"),this.searchValue&&t.push("jsoneditor-highlight"),e.className=t.join(" "),"array"==n||"object"==n){var o=this.childs?this.childs.length:0;e.title=this.type+" containing "+o+" items"}else r&&this.editable.value?e.title=d("openUrl"):e.title="";if("boolean"===n&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value){if(!this.dom.select){this.dom.select=document.createElement("select"),this.id=this.field+"_"+(new Date).getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id,this.dom.select.option=document.createElement("option"),this.dom.select.option.value="",this.dom.select.option.innerHTML="--",this.dom.select.appendChild(this.dom.select.option);for(var s=0;s<this.enum.length;s++)this.dom.select.option=document.createElement("option"),this.dom.select.option.value=this.enum[s],this.dom.select.option.innerHTML=this.enum[s],this.dom.select.option.value==this.value&&(this.dom.select.option.selected=!0),this.dom.select.appendChild(this.dom.select.option);this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)}!this.schema||this.schema.hasOwnProperty("oneOf")||this.schema.hasOwnProperty("anyOf")||this.schema.hasOwnProperty("allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.innerHTML="")}else this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML);this.editable.value&&this.editor.options.colorPicker&&"string"==typeof i&&L.isValidColor(i)?(this.dom.color||(this.dom.color=document.createElement("div"),this.dom.color.className="jsoneditor-color",this.dom.tdColor=document.createElement("td"),this.dom.tdColor.className="jsoneditor-tree",this.dom.tdColor.appendChild(this.dom.color),this.dom.tdValue.parentNode.insertBefore(this.dom.tdColor,this.dom.tdValue),this.dom.value.style.color="#1A1A1A"),this.dom.color.style.backgroundColor=i):this._deleteDomColor(),this.editor.options.timestampTag&&"number"==typeof i&&9466848e5<i&&!isNaN(new Date(i).valueOf())?(this.dom.date||(this.dom.date=document.createElement("div"),this.dom.date.className="jsoneditor-date",this.dom.value.parentNode.appendChild(this.dom.date)),this.dom.date.innerHTML=new Date(i).toISOString(),this.dom.date.title=new Date(i).toString()):this.dom.date&&(this.dom.date.parentNode.removeChild(this.dom.date),delete this.dom.date),L.stripFormatting(e),this._updateDomDefault()}},R.prototype._deleteDomColor=function(){this.dom.color&&(this.dom.tdColor.parentNode.removeChild(this.dom.tdColor),delete this.dom.tdColor,delete this.dom.color,this.dom.value.style.color="")},R.prototype._updateDomField=function(){var e=this.dom.field;if(e){var t=L.makeFieldTooltip(this.schema,this.editor.options.language);t&&(e.title=t),""==String(this.field)&&"array"!=this.parent.type?L.addClassName(e,"jsoneditor-empty"):L.removeClassName(e,"jsoneditor-empty"),this.searchFieldActive?L.addClassName(e,"jsoneditor-highlight-active"):L.removeClassName(e,"jsoneditor-highlight-active"),this.searchField?L.addClassName(e,"jsoneditor-highlight"):L.removeClassName(e,"jsoneditor-highlight"),L.stripFormatting(e)}},R.prototype._getDomField=function(e){if(this._clearFieldError(),this.dom.field&&this.fieldEditable&&(this.fieldInnerText=L.getInnerText(this.dom.field)),void 0!==this.fieldInnerText)try{var t=this._unescapeHTML(this.fieldInnerText),i=this.parent.getFieldNames(this);-1!==i.indexOf(t)?e?(t=L.findUniqueName(t,i))!==this.field&&(this.field=t,this._debouncedOnChangeField()):this._setFieldError(d("duplicateFieldError")):t!==this.field&&(this.field=t,this._debouncedOnChangeField())}catch(e){this._setFieldError(d("cannotParseFieldError"))}},R.prototype._updateDomDefault=function(){if(this.schema&&void 0!==this.schema.default&&!this._hasChilds()){var e=this.dom.select?this.dom.select:this.dom.value;e&&(this.value===this.schema.default?(e.title=d("default"),L.addClassName(e,"jsoneditor-is-default"),L.removeClassName(e,"jsoneditor-is-not-default")):(e.removeAttribute("title"),L.removeClassName(e,"jsoneditor-is-default"),L.addClassName(e,"jsoneditor-is-not-default")))}},R.prototype.clearDom=function(){this.dom={}},R.prototype.getDom=function(){var e=this.dom;if(e.tr)return e.tr;if(this._updateEditability(),e.tr=document.createElement("tr"),"tree"===(e.tr.node=this).editor.options.mode){var t=document.createElement("td");if(this.editable.field&&this.parent){var i=document.createElement("button");i.type="button",(e.drag=i).className="jsoneditor-button jsoneditor-dragarea",i.title=d("drag"),t.appendChild(i)}e.tr.appendChild(t);var n=document.createElement("td"),r=document.createElement("button");r.type="button",(e.menu=r).className="jsoneditor-button jsoneditor-contextmenu",r.title=d("actionsMenu"),n.appendChild(e.menu),e.tr.appendChild(n)}var o=document.createElement("td");return e.tr.appendChild(o),e.tree=this._createDomTree(),o.appendChild(e.tree),this.updateDom({updateIndexes:!0}),e.tr},R.prototype.isVisible=function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1},R.onDragStart=function(t,e){if(!Array.isArray(t))return R.onDragStart([t],e);if(0!==t.length){var i=t[0],n=t[t.length-1],r=i.parent,o=R.getNodeFromTarget(e.target),s=i.editor,a=L.getAbsoluteTop(o.dom.tr)-L.getAbsoluteTop(i.dom.tr);s.mousemove||(s.mousemove=L.addEventListener(window,"mousemove",function(e){R.onDrag(t,e)})),s.mouseup||(s.mouseup=L.addEventListener(window,"mouseup",function(e){R.onDragEnd(t,e)})),s.highlighter.lock(),s.drag={oldCursor:document.body.style.cursor,oldSelection:s.getDomSelection(),oldPaths:t.map(f),oldParent:r,oldNextNode:r.childs[n.getIndex()+1]||r.append,oldParentPathRedo:r.getInternalPath(),oldIndexRedo:i.getIndex(),mouseX:e.pageX,offsetY:a,level:i.getLevel()},document.body.style.cursor="move",e.preventDefault()}},R.onDrag=function(e,t){if(!Array.isArray(e))return R.onDrag([e],t);if(0!==e.length){var i,n,r,o,s,a,l,c,h,d,u,f,p,m,g=e[0].editor,v=t.pageY-g.drag.offsetY,y=t.pageX,w=!1,b=e[0];if(i=b.dom.tr,h=L.getAbsoluteTop(i),f=i.offsetHeight,v<h){for(n=i;n=n.previousSibling,l=R.getNodeFromTarget(n),d=n?L.getAbsoluteTop(n):0,n&&v<d;);l&&!l.parent&&(l=void 0),l||(n=(a=i.parentNode.firstChild)?a.nextSibling:void 0,(l=R.getNodeFromTarget(n))==b&&(l=void 0)),l&&l.isVisible()&&(d=(n=l.dom.tr)?L.getAbsoluteTop(n):0)+f<v&&(l=void 0),l&&(e.forEach(function(e){l.parent.moveBefore(e,l)}),w=!0)}else{var C=e[e.length-1];if(o=(s=C.expanded&&C.append?C.append.getDom():C.dom.tr)?s.nextSibling:void 0){for(u=L.getAbsoluteTop(o),r=o;c=R.getNodeFromTarget(r),r&&(p=r.nextSibling?L.getAbsoluteTop(r.nextSibling):0,m=r?p-u:0,c&&c.parent.childs.length==e.length&&c.parent.childs[e.length-1]==C&&(h+=27),r=r.nextSibling),r&&h+m<v;);if(c&&c.parent){var E=y-g.drag.mouseX,A=Math.round(E/24/2),x=g.drag.level+A,F=c.getLevel();for(n=c.dom.tr&&c.dom.tr.previousSibling;F<x&&n;){if(l=R.getNodeFromTarget(n),e.some(function(e){return e===l||l.isDescendantOf(e)}));else{if(!(l instanceof O))break;var S=l.parent.childs;if(S.length==e.length&&S[e.length-1]==C)break;F=(c=R.getNodeFromTarget(n)).getLevel()}n=n.previousSibling}c instanceof O&&!c.isVisible()&&c.parent.showMore.isVisible()&&(c=c._nextNode()),c&&c.dom.tr&&s.nextSibling!=c.dom.tr&&(e.forEach(function(e){c.parent.moveBefore(e,c)}),w=!0)}}}w&&(g.drag.mouseX=y,g.drag.level=b.getLevel()),g.startAutoScroll(v),t.preventDefault()}},R.onDragEnd=function(e,t){if(!Array.isArray(e))return R.onDrag([e],t);if(0!==e.length){var i=e[0],n=i.editor;e[0]&&e[0].dom.menu.focus();var r=n.drag.oldParent.getInternalPath(),o=i.parent.getInternalPath(),s=n.drag.oldParent===i.parent,a=n.drag.oldNextNode.getIndex(),l=i.getIndex(),c=n.drag.oldParentPathRedo,h=n.drag.oldIndexRedo,d=s&&h<l?l+e.length:l;s&&h===l||n._onAction("moveNodes",{count:e.length,fieldNames:e.map(P),oldParentPath:r,newParentPath:o,oldIndex:a,newIndex:l,oldIndexRedo:h,newIndexRedo:d,oldParentPathRedo:c,newParentPathRedo:null,oldSelection:n.drag.oldSelection,newSelection:n.getDomSelection()}),document.body.style.cursor=n.drag.oldCursor,n.highlighter.unlock(),e.forEach(function(e){e.updateDom(),t.target!==e.dom.drag&&t.target!==e.dom.menu&&n.highlighter.unhighlight()}),delete n.drag,n.mousemove&&(L.removeEventListener(window,"mousemove",n.mousemove),delete n.mousemove),n.mouseup&&(L.removeEventListener(window,"mouseup",n.mouseup),delete n.mouseup),n.stopAutoScroll(),t.preventDefault()}},R.prototype.isDescendantOf=function(e){for(var t=this.parent;t;){if(t==e)return!0;t=t.parent}return!1},R.prototype._createDomField=function(){return document.createElement("div")},R.prototype.setHighlight=function(t){this.dom.tr&&(t?L.addClassName(this.dom.tr,"jsoneditor-highlight"):L.removeClassName(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(t),this.childs&&this.childs.forEach(function(e){e.setHighlight(t)}))},R.prototype.setSelected=function(t,e){this.selected=t,this.dom.tr&&(t?L.addClassName(this.dom.tr,"jsoneditor-selected"):L.removeClassName(this.dom.tr,"jsoneditor-selected"),e?L.addClassName(this.dom.tr,"jsoneditor-first"):L.removeClassName(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(t),this.showMore&&this.showMore.setSelected(t),this.childs&&this.childs.forEach(function(e){e.setSelected(t)}))},R.prototype.updateValue=function(e){this.value=e,this.previousValue=e,this.valueError=void 0,this.updateDom()},R.prototype.updateField=function(e){this.field=e,this.previousField=e,this.fieldError=void 0,this.updateDom()},R.prototype.updateDom=function(t){var e=this.dom.tree;e&&(e.style.marginLeft=24*this.getLevel()+"px");var i=this.dom.field;if(i){var n;if(this.fieldEditable?(i.contentEditable=this.editable.field,i.spellcheck=!1,i.className="jsoneditor-field"):(i.contentEditable=!1,i.className="jsoneditor-readonly"),null!=this.index)n=this.index;else if(null!=this.field)n=this.field;else{var r=this.editor.options.schema?R._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):void 0;n=r&&r.title?r.title:this._hasChilds()?this.type:""}i.innerHTML=this._escapeHTML(n),this._updateSchema()}var o=this.dom.value;o&&("array"==this.type?(this.updateNodeName(),L.addClassName(this.dom.tr,"jsoneditor-expandable")):"object"==this.type?(this.updateNodeName(),L.addClassName(this.dom.tr,"jsoneditor-expandable")):(o.innerHTML=this._escapeHTML(this.value),L.removeClassName(this.dom.tr,"jsoneditor-expandable"))),this._updateDomField(),this._updateDomValue(),this._updateCssClassName(),t&&!0===t.updateIndexes&&this._updateDomIndexes(),t&&!0===t.recurse&&this.childs&&this.childs.forEach(function(e){e.updateDom(t)}),this.error&&this.updateError(),this.append&&this.append.updateDom(),this.showMore&&this.showMore.updateDom()},R.prototype._updateSchema=function(){this.editor&&this.editor.options&&(this.schema=this.editor.options.schema?R._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):null,this.schema?this.enum=R._findEnum(this.schema):delete this.enum)},R._findEnum=function(e){if(e.enum)return e.enum;var t=e.oneOf||e.anyOf||e.allOf;if(t){var i=t.filter(function(e){return e.enum});if(0<i.length)return i[0].enum}return null},R._findSchema=function(e,t,i){var n=e,r=n,o=e.oneOf||e.anyOf||e.allOf;o=o||[e];for(var s=0;s<o.length;s++){"$ref"in(n=o[s])&&"string"==typeof n.$ref&&(n=t[n.$ref])&&(r=R._findSchema(n,t,i));for(var a=0;a<i.length&&n;a++){var l=i.slice(a+1,i.length),c=i[a];if("string"!=typeof c||!n.patternProperties||n.properties&&c in n.properties)"string"==typeof c&&n.properties?c in n.properties?(n=n.properties[c])&&(r=R._findSchema(n,t,l)):r=null:"number"==typeof c&&n.items&&(n=n.items)&&(r=R._findSchema(n,t,l));else for(var h in n.patternProperties)c.match(h)&&(r=R._findSchema(n.patternProperties[h],t,l))}}return r===e&&0<i.length?null:r},R.prototype._updateDomIndexes=function(){var e=this.dom.value,t=this.childs;e&&t&&("array"==this.type?t.forEach(function(e,t){e.index=t;var i=e.dom.field;i&&(i.innerHTML=t)}):"object"==this.type&&t.forEach(function(e){null!=e.index&&(delete e.index,null==e.field&&(e.field=""))}))},R.prototype._createDomValue=function(){var e;return"array"==this.type?(e=document.createElement("div")).innerHTML="[...]":"object"==this.type?(e=document.createElement("div")).innerHTML="{...}":(!this.editable.value&&L.isUrl(this.value)?(e=document.createElement("a")).href=this.value:((e=document.createElement("div")).contentEditable=this.editable.value,e.spellcheck=!1),e.innerHTML=this._escapeHTML(this.value)),e},R.prototype._createDomExpandButton=function(){var e=document.createElement("button");return e.type="button",this._hasChilds()?(e.className=this.expanded?"jsoneditor-button jsoneditor-expanded":"jsoneditor-button jsoneditor-collapsed",e.title=d("expandTitle")):(e.className="jsoneditor-button jsoneditor-invisible",e.title=""),e},R.prototype._createDomTree=function(){var e=this.dom,t=document.createElement("table"),i=document.createElement("tbody");t.style.borderCollapse="collapse",t.className="jsoneditor-values",t.appendChild(i);var n=document.createElement("tr");i.appendChild(n);var r=document.createElement("td");r.className="jsoneditor-tree",n.appendChild(r),e.expand=this._createDomExpandButton(),r.appendChild(e.expand),e.tdExpand=r;var o=document.createElement("td");o.className="jsoneditor-tree",n.appendChild(o),e.field=this._createDomField(),o.appendChild(e.field),e.tdField=o;var s=document.createElement("td");s.className="jsoneditor-tree",n.appendChild(s),"object"!=this.type&&"array"!=this.type&&(s.appendChild(document.createTextNode(":")),s.className="jsoneditor-separator"),e.tdSeparator=s;var a=document.createElement("td");return a.className="jsoneditor-tree",n.appendChild(a),e.value=this._createDomValue(),a.appendChild(e.value),e.tdValue=a,t},R.prototype.onEvent=function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom,r=this,o=this._hasChilds();if("function"==typeof this.editor.options.onEvent&&this._onEvent(e),i!=n.drag&&i!=n.menu||("mouseover"==t?this.editor.highlighter.highlight(this):"mouseout"==t&&this.editor.highlighter.unhighlight()),"click"==t&&i==n.menu){var s=r.editor.highlighter;s.highlight(r),s.lock(),L.addClassName(n.menu,"jsoneditor-selected"),this.showContextMenu(n.menu,function(){L.removeClassName(n.menu,"jsoneditor-selected"),s.unlock(),s.unhighlight()})}if("click"==t&&(i==n.expand||("view"===r.editor.options.mode||"form"===r.editor.options.mode)&&"DIV"===i.nodeName)&&o){var a=e.ctrlKey;this._onExpand(a)}"click"!==t||e.target!==r.dom.tdColor&&e.target!==r.dom.color||this._showColorPicker(),"change"==t&&i==n.checkbox&&(this.dom.value.innerHTML=!this.value,this._getDomValue(),this._updateDomDefault()),"change"==t&&i==n.select&&(this.dom.value.innerHTML=n.select.value,this._getDomValue(),this._updateDomValue());var l=n.value;if(i==l)switch(t){case"blur":case"change":this._getDomValue(),this._clearValueError(),this._updateDomValue(),this.value&&(l.innerHTML=this._escapeHTML(this.value));break;case"input":this._getDomValue(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"click":e.ctrlKey&&this.editable.value&&L.isUrl(this.value)&&(e.preventDefault(),window.open(this.value,"_blank"));break;case"keyup":this._getDomValue(),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){r._getDomValue(),r._updateDomValue()},1)}var c=n.field;if(i==c)switch(t){case"blur":this._getDomField(!0),this._updateDomField(),this.field&&(c.innerHTML=this._escapeHTML(this.field));break;case"input":this._getDomField(),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"keyup":this._getDomField(),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){r._getDomField(),r._updateDomField()},1)}var h=n.tree;h&&i==h.parentNode&&"click"==t&&!e.hasMoved&&((null!=e.offsetX?e.offsetX<24*(this.getLevel()+1):e.pageX<L.getAbsoluteLeft(n.tdSeparator))||o?c&&(L.setEndOfContentEditable(c),c.focus()):l&&!this.enum&&(L.setEndOfContentEditable(l),l.focus()));(i!=n.tdExpand||o)&&i!=n.tdField&&i!=n.tdSeparator||"click"!=t||e.hasMoved||c&&(L.setEndOfContentEditable(c),c.focus()),"keydown"==t&&this.onKeyDown(e)},R.prototype._onEvent=function(e){var t=e.target;if(t===this.dom.field||t===this.dom.value){var i={field:this.getField(),path:this.getPath()};this._hasChilds()||t!==this.dom.value||(i.value=this.getValue()),this.editor.options.onEvent(i,e)}},R.prototype.onKeyDown=function(e){var t,i,n,r,o,s,a,l,c,h,d,u,f,p=e.which||e.keyCode,m=e.target||e.srcElement,g=e.ctrlKey,v=e.shiftKey,y=e.altKey,w=!1,b="tree"===this.editor.options.mode,C=0<this.editor.multiselection.nodes.length?this.editor.multiselection.nodes:[this],E=C[0],A=C[C.length-1];if(13==p){if(m==this.dom.value)this.editable.value&&!e.ctrlKey||L.isUrl(this.value)&&(window.open(this.value,"_blank"),w=!0);else if(m==this.dom.expand){if(this._hasChilds()){var x=e.ctrlKey;this._onExpand(x),m.focus(),w=!0}}}else if(68==p)g&&b&&(R.onDuplicate(C),w=!0);else if(69==p)g&&(this._onExpand(v),m.focus(),w=!0);else if(77==p&&b)g&&(this.showContextMenu(m),w=!0);else if(46==p&&b)g&&(R.onRemove(C),w=!0);else if(45==p&&b)g&&!v?(this._onInsertBefore(),w=!0):g&&v&&(this._onInsertAfter(),w=!0);else if(35==p){if(y){var F=this._lastNode();F&&F.focus(R.focusElement||this._getElementName(m)),w=!0}}else if(36==p){if(y){var S=this._firstNode();S&&S.focus(R.focusElement||this._getElementName(m)),w=!0}}else if(37==p){if(y&&!v){var _=this._previousElement(m);_&&this.focus(this._getElementName(_)),w=!0}else if(y&&v&&b){if(A.expanded){var k=A.getAppendDom();n=k?k.nextSibling:void 0}else{var D=A.getDom();n=D.nextSibling}n&&(i=R.getNodeFromTarget(n),r=n.nextSibling,T=R.getNodeFromTarget(r),i&&i instanceof O&&1!=A.parent.childs.length&&T&&T.parent&&(o=this.editor.getDomSelection(),s=(a=E.parent).childs[A.getIndex()+1]||a.append,l=E.getIndex(),c=T.getIndex(),h=a.getInternalPath(),d=T.parent.getInternalPath(),C.forEach(function(e){T.parent.moveBefore(e,T)}),this.focus(R.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:C.length,fieldNames:C.map(P),oldParentPath:a.getInternalPath(),newParentPath:E.parent.getInternalPath(),oldIndex:s.getIndex(),newIndex:E.getIndex(),oldIndexRedo:l,newIndexRedo:c,oldParentPathRedo:h,newParentPathRedo:d,oldSelection:o,newSelection:this.editor.getDomSelection()})))}}else if(38==p)y&&!v?((t=this._previousNode())&&(this.editor.deselect(!0),t.focus(R.focusElement||this._getElementName(m))),w=!0):!y&&g&&v&&b?((t=this._previousNode())&&((f=this.editor.multiselection).start=f.start||this,f.end=t,u=this.editor._findTopLevelNodes(f.start,f.end),this.editor.select(u),t.focus("field")),w=!0):y&&v&&b&&((t=E._previousNode())&&t.parent&&(o=this.editor.getDomSelection(),s=(a=E.parent).childs[A.getIndex()+1]||a.append,l=E.getIndex(),c=t.getIndex(),h=a.getInternalPath(),d=t.parent.getInternalPath(),C.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(R.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:C.length,fieldNames:C.map(P),oldParentPath:a.getInternalPath(),newParentPath:E.parent.getInternalPath(),oldIndex:s.getIndex(),newIndex:E.getIndex(),oldIndexRedo:l,newIndexRedo:c,oldParentPathRedo:h,newParentPathRedo:d,oldSelection:o,newSelection:this.editor.getDomSelection()})),w=!0);else if(39==p){if(y&&!v){var $=this._nextElement(m);$&&this.focus(this._getElementName($)),w=!0}else if(y&&v&&b){var B=(D=E.getDom()).previousSibling;B&&(t=R.getNodeFromTarget(B))&&t.parent&&!t.isVisible()&&(o=this.editor.getDomSelection(),s=(a=E.parent).childs[A.getIndex()+1]||a.append,l=E.getIndex(),c=t.getIndex(),h=a.getInternalPath(),d=t.parent.getInternalPath(),C.forEach(function(e){t.parent.moveBefore(e,t)}),this.focus(R.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:C.length,fieldNames:C.map(P),oldParentPath:a.getInternalPath(),newParentPath:E.parent.getInternalPath(),oldIndex:s.getIndex(),newIndex:E.getIndex(),oldIndexRedo:l,newIndexRedo:c,oldParentPathRedo:h,newParentPathRedo:d,oldSelection:o,newSelection:this.editor.getDomSelection()}))}}else if(40==p)if(y&&!v)(i=this._nextNode())&&(this.editor.deselect(!0),i.focus(R.focusElement||this._getElementName(m))),w=!0;else if(!y&&g&&v&&b)(i=this._nextNode())&&((f=this.editor.multiselection).start=f.start||this,f.end=i,u=this.editor._findTopLevelNodes(f.start,f.end),this.editor.select(u),i.focus("field")),w=!0;else if(y&&v&&b){(i=A.expanded?A.append?A.append._nextNode():void 0:A._nextNode())&&!i.isVisible()&&(i=i.parent.showMore),i&&i instanceof O&&(i=A);var T=i&&(i._nextNode()||i.parent.append);T&&T.parent&&(o=this.editor.getDomSelection(),s=(a=E.parent).childs[A.getIndex()+1]||a.append,l=E.getIndex(),c=T.getIndex(),h=a.getInternalPath(),d=T.parent.getInternalPath(),C.forEach(function(e){T.parent.moveBefore(e,T)}),this.focus(R.focusElement||this._getElementName(m)),this.editor._onAction("moveNodes",{count:C.length,fieldNames:C.map(P),oldParentPath:a.getInternalPath(),newParentPath:E.parent.getInternalPath(),oldParentPathRedo:h,newParentPathRedo:d,oldIndexRedo:l,newIndexRedo:c,oldIndex:s.getIndex(),newIndex:E.getIndex(),oldSelection:o,newSelection:this.editor.getDomSelection()})),w=!0}w&&(e.preventDefault(),e.stopPropagation())},R.prototype._onExpand=function(e){if(e){var t=this.dom.tr.parentNode,i=t.parentNode,n=i.scrollTop;i.removeChild(t)}this.expanded?this.collapse(e):this.expand(e),e&&(i.appendChild(t),i.scrollTop=n)},R.prototype._showColorPicker=function(){if("function"==typeof this.editor.options.onColorPicker&&this.dom.color){var t=this;t._deleteDomColor(),t.updateDom();var e=n(this.dom.color,this.editor.frame);this.editor.options.onColorPicker(e,this.value,function(e){"string"==typeof e&&e!==t.value&&(t._deleteDomColor(),t.value=e,t.updateDom(),t._debouncedOnChangeValue())})}},R.prototype.getFieldNames=function(t){return"object"===this.type?this.childs.filter(function(e){return e!==t}).map(function(e){return e.field}):[]},R.onRemove=function(e){if(!Array.isArray(e))return R.onRemove([e]);if(e&&0<e.length){var t=e[0],i=t.parent,n=t.editor,r=t.getIndex();n.highlighter.unhighlight();var o=n.getDomSelection();R.blurNodes(e);var s=n.getDomSelection(),a=e.map(f);e.forEach(function(e){e.parent._remove(e)}),n._onAction("removeNodes",{nodes:e,paths:a,parentPath:i.getInternalPath(),index:r,oldSelection:o,newSelection:s})}},R.onDuplicate=function(e){if(!Array.isArray(e))return R.onDuplicate([e]);if(e&&0<e.length){var t=e[e.length-1],n=t.parent,i=t.editor;i.deselect(i.multiselection.nodes);var r=i.getDomSelection(),o=t,s=e.map(function(e){var t=e.clone();if("object"===e.parent.type){var i=e.parent.getFieldNames();t.field=L.findUniqueName(e.field,i)}return n.insertAfter(t,o),o=t});1===e.length?s[0].focus():i.select(s);var a=i.getDomSelection();i._onAction("duplicateNodes",{paths:e.map(f),clonePaths:s.map(f),afterPath:t.getInternalPath(),parentPath:n.getInternalPath(),oldSelection:r,newSelection:a})}},R.prototype._onInsertBefore=function(e,t,i){var n=this.editor.getDomSelection(),r=new R(this.editor,{field:null!=e?e:"",value:null!=t?t:"",type:i});r.expand(!0);var o=this.getInternalPath();this.parent.insertBefore(r,this),this.editor.highlighter.unhighlight(),r.focus("field");var s=this.editor.getDomSelection();this.editor._onAction("insertBeforeNodes",{nodes:[r],paths:[r.getInternalPath()],beforePath:o,parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:s})},R.prototype._onInsertAfter=function(e,t,i){var n=this.editor.getDomSelection(),r=new R(this.editor,{field:null!=e?e:"",value:null!=t?t:"",type:i});r.expand(!0),this.parent.insertAfter(r,this),this.editor.highlighter.unhighlight(),r.focus("field");var o=this.editor.getDomSelection();this.editor._onAction("insertAfterNodes",{nodes:[r],paths:[r.getInternalPath()],afterPath:this.getInternalPath(),parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:o})},R.prototype._onAppend=function(e,t,i){var n=this.editor.getDomSelection(),r=new R(this.editor,{field:null!=e?e:"",value:null!=t?t:"",type:i});r.expand(!0),this.parent.appendChild(r),this.editor.highlighter.unhighlight(),r.focus("field");var o=this.editor.getDomSelection();this.editor._onAction("appendNodes",{nodes:[r],paths:[r.getInternalPath()],parentPath:this.parent.getInternalPath(),oldSelection:n,newSelection:o})},R.prototype._onChangeType=function(e){var t=this.type;if(e!=t){var i=this.editor.getDomSelection();this.changeType(e);var n=this.editor.getDomSelection();this.editor._onAction("changeType",{path:this.getInternalPath(),oldType:t,newType:e,oldSelection:i,newSelection:n})}},R.prototype.sort=function(s,e){if("string"==typeof s&&(s=L.parsePath(s)),this._hasChilds()){this.hideChilds();var t=this.childs;this.childs=this.childs.concat();var a="desc"===e?-1:1;"object"===this.type?this.childs.sort(function(e,t){return a*l(e.field,t.field)}):this.childs.sort(function(e,t){var i=e.getNestedChild(s),n=t.getNestedChild(s);if(!i)return a;if(!n)return-a;var r=i.value,o=n.value;return"string"!=typeof r&&"string"!=typeof o?o<r?a:r<o?-a:0:a*l(r,o)}),this._updateDomIndexes(),this.editor._onAction("sort",{path:this.getInternalPath(),oldChilds:t,newChilds:this.childs}),this.showChilds()}},R.prototype.update=function(e){var t=this.getInternalValue();this.setValue(e),this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:this.getInternalValue()})},R.prototype._detachFromDom=function(){var e,t=this.dom.tr?this.dom.tr.parentNode:void 0,i=(e=this.expanded?this.getAppendDom():this.getDom())&&e.parentNode?e.nextSibling:void 0;return this.hide({resetVisibleChilds:!1}),{table:t,nextTr:i}},R.prototype._attachToDom=function(e){e.table&&(e.nextTr?e.table.insertBefore(this.getDom(),e.nextTr):e.table.appendChild(this.getDom())),this.expanded&&this.showChilds()},R.prototype.transform=function(e){if(this._hasChilds()){this.hideChilds();try{var t=this.getInternalValue(),i=this.getValue(),n=o.search(i,e);this.setValue(n);var r=this.getInternalValue();this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:t,newValue:r}),this.showChilds()}catch(e){this.showChilds(),this.editor._onError(e)}}},R.prototype.extract=function(){this.editor.node.hideChilds(),this.hideChilds();try{var e=this.editor.node.getInternalValue();this.editor._setRoot(this);var t=this.editor.node.getInternalValue();this.editor._onAction("transform",{path:this.editor.node.getInternalPath(),oldValue:e,newValue:t})}catch(e){this.editor._onError(e)}finally{this.updateDom({recurse:!0}),this.showChilds()}},R.prototype.getNestedChild=function(e){for(var t=0,i=this;i&&t<e.length;)i=i.findChildByProperty(e[t]),t++;return i},R.prototype.findChildByProperty=function(t){if("object"===this.type)return this.childs.find(function(e){return e.field===t})},R.prototype.getAppendDom=function(){return this.append||(this.append=new O(this.editor),this.append.setParent(this)),this.append.getDom()},R.prototype.getShowMoreDom=function(){return this.showMore||(this.showMore=new p(this.editor,this)),this.showMore.getDom()},R.getNodeFromTarget=function(e){for(;e;){if(e.node)return e.node;e=e.parentNode}},R.targetIsColorPicker=function(e){var t=R.getNodeFromTarget(e);if(t)for(var i=e&&e.parentNode;i;){if(i===t.dom.color)return!0;i=i.parentNode}return!1},R.blurNodes=function(e){if(Array.isArray(e)){var t=e[0],i=t.parent,n=t.getIndex();i.childs[n+e.length]?i.childs[n+e.length].focus():i.childs[n-1]?i.childs[n-1].focus():i.focus()}else R.blurNodes([e])},R.prototype.nextSibling=function(){var e=this.parent.childs.indexOf(this);return this.parent.childs[e+1]||this.parent.append},R.prototype._previousNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var i=t;i=i.previousSibling,e=R.getNodeFromTarget(i),i&&e&&e instanceof O&&!e.isVisible(););return e},R.prototype._nextNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode)for(var i=t;i=i.nextSibling,e=R.getNodeFromTarget(i),i&&e&&e instanceof O&&!e.isVisible(););return e},R.prototype._firstNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.firstChild;e=R.getNodeFromTarget(i)}return e},R.prototype._lastNode=function(){var e=null,t=this.getDom();if(t&&t.parentNode){var i=t.parentNode.lastChild;for(e=R.getNodeFromTarget(i);i&&e&&!e.isVisible();)i=i.previousSibling,e=R.getNodeFromTarget(i)}return e},R.prototype._previousElement=function(e){var t=this.dom;switch(e){case t.value:if(this.fieldEditable)return t.field;case t.field:if(this._hasChilds())return t.expand;case t.expand:return t.menu;case t.menu:if(t.drag)return t.drag;default:return null}},R.prototype._nextElement=function(e){var t=this.dom;switch(e){case t.drag:return t.menu;case t.menu:if(this._hasChilds())return t.expand;case t.expand:if(this.fieldEditable)return t.field;case t.field:if(!this._hasChilds())return t.value;default:return null}},R.prototype._getElementName=function(e){var t=this.dom;for(var i in t)if(t.hasOwnProperty(i)&&t[i]==e)return i;return null},R.prototype._hasChilds=function(){return"array"==this.type||"object"==this.type},R.TYPE_TITLES={auto:d("autoType"),object:d("objectType"),array:d("arrayType"),string:d("stringType")},R.prototype.addTemplates=function(t,i){var n=this,e=n.editor.options.templates;if(null!=e){e.length&&t.push({type:"separator"});e.forEach(function(e){t.push({text:e.text,className:e.className||"jsoneditor-type-object",title:e.title,click:i?function(e,t){n._onAppend(e,t)}.bind(this,e.field,e.value):function(e,t){n._onInsertBefore(e,t)}.bind(this,e.field,e.value)})})}},R.prototype.showContextMenu=function(e,t){var i=this,n=R.TYPE_TITLES,r=[];if(this.editable.value&&r.push({text:d("type"),title:d("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:d("auto"),className:"jsoneditor-type-auto"+("auto"==this.type?" jsoneditor-selected":""),title:n.auto,click:function(){i._onChangeType("auto")}},{text:d("array"),className:"jsoneditor-type-array"+("array"==this.type?" jsoneditor-selected":""),title:n.array,click:function(){i._onChangeType("array")}},{text:d("object"),className:"jsoneditor-type-object"+("object"==this.type?" jsoneditor-selected":""),title:n.object,click:function(){i._onChangeType("object")}},{text:d("string"),className:"jsoneditor-type-string"+("string"==this.type?" jsoneditor-selected":""),title:n.string,click:function(){i._onChangeType("string")}}]}),this._hasChilds()&&(this.editor.options.enableSort&&r.push({text:d("sort"),title:d("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){i.showSortModal()}}),this.editor.options.enableTransform&&r.push({text:d("transform"),title:d("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){i.showTransformModal()}}),this.parent&&r.push({text:d("extract"),title:d("extractTitle",{type:this.type}),className:"jsoneditor-extract",click:function(){i.extract()}})),this.parent&&this.parent._hasChilds()){r.length&&r.push({type:"separator"});var o=i.parent.childs;if(i===o[o.length-1]){var s=[{text:d("auto"),className:"jsoneditor-type-auto",title:n.auto,click:function(){i._onAppend("","","auto")}},{text:d("array"),className:"jsoneditor-type-array",title:n.array,click:function(){i._onAppend("",[])}},{text:d("object"),className:"jsoneditor-type-object",title:n.object,click:function(){i._onAppend("",{})}},{text:d("string"),className:"jsoneditor-type-string",title:n.string,click:function(){i._onAppend("","","string")}}];i.addTemplates(s,!0),r.push({text:d("appendText"),title:d("appendTitle"),submenuTitle:d("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){i._onAppend("","","auto")},submenu:s})}var a=[{text:d("auto"),className:"jsoneditor-type-auto",title:n.auto,click:function(){i._onInsertBefore("","","auto")}},{text:d("array"),className:"jsoneditor-type-array",title:n.array,click:function(){i._onInsertBefore("",[])}},{text:d("object"),className:"jsoneditor-type-object",title:n.object,click:function(){i._onInsertBefore("",{})}},{text:d("string"),className:"jsoneditor-type-string",title:n.string,click:function(){i._onInsertBefore("","","string")}}];i.addTemplates(a,!1),r.push({text:d("insert"),title:d("insertTitle"),submenuTitle:d("insertSub"),className:"jsoneditor-insert",click:function(){i._onInsertBefore("","","auto")},submenu:a}),this.editable.field&&(r.push({text:d("duplicateText"),title:d("duplicateField"),className:"jsoneditor-duplicate",click:function(){R.onDuplicate(i)}}),r.push({text:d("removeText"),title:d("removeField"),className:"jsoneditor-remove",click:function(){R.onRemove(i)}}))}if(this.editor.options.onCreateMenu){var l=i.getPath();r=this.editor.options.onCreateMenu(r,{type:"single",path:l,paths:[l]})}new c(r,{close:t}).show(e,this.editor.frame)},R.prototype.showSortModal=function(){var n=this,e=this.editor.options.modalAnchor||u,t=this.getValue();a(e,t,function(e){var t=e.path,i=L.parsePath(t);n.sortedBy=e,n.sort(i,e.direction)},n.sortedBy)},R.prototype.showTransformModal=function(){var t=this,e=this.editor.options.modalAnchor||u,i=t.getValue();h(e,i,function(e){t.transform(e)})},R.prototype._getType=function(e){return e instanceof Array?"array":e instanceof Object?"object":"string"==typeof e&&"string"!=typeof L.parseString(e)?"string":"auto"},R.prototype._escapeHTML=function(e){if("string"!=typeof e)return String(e);var t=String(e).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/  /g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),i=JSON.stringify(t),n=i.substring(1,i.length-1);return!0===this.editor.options.escapeUnicode&&(n=L.escapeUnicodeChars(n)),n},R.prototype._unescapeHTML=function(e){var t='"'+this._escapeJSON(e)+'"';return L.parse(t).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")},R.prototype._escapeJSON=function(e){for(var t="",i=0;i<e.length;){var n=e.charAt(i);"\n"==n?t+="\\n":"\\"==n?(t+=n,i++,""!==(n=e.charAt(i))&&-1!='"\\/bfnrtu'.indexOf(n)||(t+="\\"),t+=n):t+='"'==n?'\\"':n,i++}return t},R.prototype.updateNodeName=function(){var e,t=this.childs?this.childs.length:0;if("object"===this.type||"array"===this.type){if(this.editor.options.onNodeName)try{e=this.editor.options.onNodeName({path:this.getPath(),size:t,type:this.type})}catch(e){console.error("Error in onNodeName callback: ",e)}this.dom.value.innerHTML="object"===this.type?"{"+(e||t)+"}":"["+(e||t)+"]"}},R.prototype.recursivelyUpdateNodeName=function(){var e;if(this.expanded&&(this.updateNodeName(),"undefined"!==this.childs))for(e in this.childs)this.childs[e].recursivelyUpdateNodeName()};var O=r(R),p=s(R);e.exports=R},function(e,t,i){"use strict";var o=i(0),l=i(4),c=i(1).translate;e.exports=function(a){function e(e){this.editor=e,this.dom={}}return(e.prototype=new a).getDom=function(){var e=this.dom;if(e.tr)return e.tr;this._updateEditability();var t=document.createElement("tr");if(t.className="jsoneditor-append",t.node=this,e.tr=t,"tree"===this.editor.options.mode){e.tdDrag=document.createElement("td");var i=document.createElement("td");e.tdMenu=i;var n=document.createElement("button");n.type="button",n.className="jsoneditor-button jsoneditor-contextmenu",n.title="Click to open the actions menu (Ctrl+M)",e.menu=n,i.appendChild(e.menu)}var r=document.createElement("td"),o=document.createElement("div");return o.innerHTML="("+c("empty")+")",o.className="jsoneditor-readonly",r.appendChild(o),e.td=r,e.text=o,this.updateDom(),t},e.prototype.getPath=function(){return null},e.prototype.getIndex=function(){return null},e.prototype.updateDom=function(e){var t=this.dom,i=t.td;i&&(i.style.paddingLeft=24*this.getLevel()+26+"px");var n=t.text;n&&(n.innerHTML="("+c("empty")+" "+this.parent.type+")");var r=t.tr;this.isVisible()?t.tr.firstChild||(t.tdDrag&&r.appendChild(t.tdDrag),t.tdMenu&&r.appendChild(t.tdMenu),r.appendChild(i)):t.tr.firstChild&&(t.tdDrag&&r.removeChild(t.tdDrag),t.tdMenu&&r.removeChild(t.tdMenu),r.removeChild(i))},e.prototype.isVisible=function(){return 0==this.parent.childs.length},e.prototype.showContextMenu=function(e,t){var i=this,n=a.TYPE_TITLES,r=[{text:c("auto"),className:"jsoneditor-type-auto",title:n.auto,click:function(){i._onAppend("","","auto")}},{text:c("array"),className:"jsoneditor-type-array",title:n.array,click:function(){i._onAppend("",[])}},{text:c("object"),className:"jsoneditor-type-object",title:n.object,click:function(){i._onAppend("",{})}},{text:c("string"),className:"jsoneditor-type-string",title:n.string,click:function(){i._onAppend("","","string")}}];i.addTemplates(r,!0);var o=[{text:c("appendText"),title:c("appendTitleAuto"),submenuTitle:c("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){i._onAppend("","","auto")},submenu:r}];if(this.editor.options.onCreateMenu){var s=i.parent.getPath();o=this.editor.options.onCreateMenu(o,{type:"append",path:s,paths:[s]})}new l(o,{close:t}).show(e,this.editor.frame)},e.prototype.onEvent=function(e){var t=e.type,i=e.target||e.srcElement,n=this.dom;if(i==n.menu&&("mouseover"==t?this.editor.highlighter.highlight(this.parent):"mouseout"==t&&this.editor.highlighter.unhighlight()),"click"==t&&i==n.menu){var r=this.editor.highlighter;r.highlight(this.parent),r.lock(),o.addClassName(n.menu,"jsoneditor-selected"),this.showContextMenu(n.menu,function(){o.removeClassName(n.menu,"jsoneditor-selected"),r.unlock(),r.unhighlight()})}"keydown"==t&&this.onKeyDown(e)},e}},function(e,t,i){"use strict";var l=i(1).translate;e.exports=function(e){function t(e,t){this.editor=e,this.parent=t,this.dom={}}return(t.prototype=new e).getDom=function(){if(this.dom.tr)return this.dom.tr;if(this._updateEditability(),!this.dom.tr){var t=this,i=this.parent,e=document.createElement("a");e.appendChild(document.createTextNode(l("showMore"))),e.href="#",e.onclick=function(e){return i.visibleChilds=Math.floor(i.visibleChilds/i.getMaxVisibleChilds()+1)*i.getMaxVisibleChilds(),t.updateDom(),i.showChilds(),e.preventDefault(),!1};var n=document.createElement("a");n.appendChild(document.createTextNode(l("showAll"))),n.href="#",n.onclick=function(e){return i.visibleChilds=1/0,t.updateDom(),i.showChilds(),e.preventDefault(),!1};var r=document.createElement("div"),o=document.createTextNode(this._getShowMoreText());r.className="jsoneditor-show-more",r.appendChild(o),r.appendChild(e),r.appendChild(document.createTextNode(". ")),r.appendChild(n),r.appendChild(document.createTextNode(". "));var s=document.createElement("td");s.appendChild(r);var a=document.createElement("tr");"tree"===this.editor.options.mode&&(a.appendChild(document.createElement("td")),a.appendChild(document.createElement("td"))),a.appendChild(s),a.className="jsoneditor-show-more",this.dom.tr=a,this.dom.moreContents=r,this.dom.moreText=o}return this.updateDom(),this.dom.tr},t.prototype.updateDom=function(e){if(this.isVisible()){if(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],!this.dom.tr.parentNode){var t=this.parent._getNextTr();t&&t.parentNode.insertBefore(this.dom.tr,t)}this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"}else this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)},t.prototype._getShowMoreText=function(){return l("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "},t.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds},t.prototype.onEvent=function(e){"keydown"===e.type&&this.onKeyDown(e)},t}},function(e,t,i){"use strict";function n(){}var r={defaultSelected:!0,width:"auto",disabled:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag..."};n.prototype={on:function(e,t){this._events=this._events||{},this._events[e]=this._events[e]||[],this._events[e].push(t)},off:function(e,t){this._events=this._events||{},e in this._events!=!1&&this._events[e].splice(this._events[e].indexOf(t),1)},emit:function(e){if(this._events=this._events||{},e in this._events!=!1)for(var t=0;t<this._events[e].length;t++)this._events[e][t].apply(this,Array.prototype.slice.call(arguments,1))}},n.mixin=function(e){for(var t=["on","off","emit"],i=0;i<t.length;i++)"function"==typeof e?e.prototype[t[i]]=n.prototype[t[i]]:e[t[i]]=n.prototype[t[i]];return e};var l={extend:function(e,t){var i;for(i in t=t||{},e)e.hasOwnProperty(i)&&(t.hasOwnProperty(i)||(t[i]=e[i]));return t},each:function(e,t,i){if("[object Object]"===Object.prototype.toString.call(e))for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.call(i,n,e[n],e);else for(var r=0,o=e.length;r<o;r++)t.call(i,r,e[r],e)},createElement:function(e,t){var i,n=document,r=n.createElement(e);if(t&&"[object Object]"===Object.prototype.toString.call(t))for(i in t)if(i in r)r[i]=t[i];else if("html"===i)r.innerHTML=t[i];else if("text"===i){var o=n.createTextNode(t[i]);r.appendChild(o)}else r.setAttribute(i,t[i]);return r},hasClass:function(e,t){if(e)return e.classList?e.classList.contains(t):!!e.className&&!!e.className.match(new RegExp("(\\s|^)"+t+"(\\s|$)"))},addClass:function(e,t){l.hasClass(e,t)||(e.classList?e.classList.add(t):e.className=e.className.trim()+" "+t)},removeClass:function(e,t){l.hasClass(e,t)&&(e.classList?e.classList.remove(t):e.className=e.className.replace(new RegExp("(^|\\s)"+t.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(e,t){return e&&e!==document.body&&(t(e)?e:l.closest(e.parentNode,t))},isInt:function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},debounce:function(n,r,o){var s;return function(){var e=this,t=arguments,i=o&&!s;clearTimeout(s),s=setTimeout(function(){s=null,o||n.apply(e,t)},r),i&&n.apply(e,t)}},rect:function(e,t){var i=window,n=e.getBoundingClientRect(),r=t?i.pageXOffset:0,o=t?i.pageYOffset:0;return{bottom:n.bottom+o,height:n.height,left:n.left+r,right:n.right+r,top:n.top+o,width:n.width}},includes:function(e,t){return-1<e.indexOf(t)},truncate:function(e){for(;e.firstChild;)e.removeChild(e.firstChild)}};function c(e,t){return e.hasOwnProperty(t)&&(!0===e[t]||e[t].length)}function o(e,t,i){e.parentNode?e.parentNode.parentNode||t.appendChild(e.parentNode):t.appendChild(e),l.removeClass(e,"excluded"),i||(e.innerHTML=e.textContent)}function s(){if(this.items.length){var i=document.createDocumentFragment();if(this.config.pagination){var e=this.pages.slice(0,this.pageIndex);l.each(e,function(e,t){l.each(t,function(e,t){o(t,i,this.customOption)},this)},this)}else l.each(this.items,function(e,t){o(t,i,this.customOption)},this);i.childElementCount&&(l.removeClass(this.items[this.navIndex],"active"),this.navIndex=i.querySelector(".selectr-option").idx,l.addClass(this.items[this.navIndex],"active")),this.tree.appendChild(i)}}function h(e,t){t=t||e;var i=this.customOption?this.config.renderOption(t):e.textContent,n=l.createElement("li",{class:"selectr-option",html:i,role:"treeitem","aria-selected":!1});return n.idx=e.idx,this.items.push(n),e.defaultSelected&&this.defaultSelected.push(e.idx),e.disabled&&(n.disabled=!0,l.addClass(n,"disabled")),n}function a(){(this.config.searchable||this.config.taggable)&&(this.input.value=null,this.searching=!1,this.config.searchable&&l.removeClass(this.inputContainer,"active"),l.hasClass(this.container,"notice")&&(l.removeClass(this.container,"notice"),l.addClass(this.container,"open"),this.input.focus()),l.each(this.items,function(e,t){l.removeClass(t,"excluded"),this.customOption||(t.innerHTML=t.textContent)},this))}function d(e,t){if(t=t||{},!e)throw new Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");if("string"==typeof(this.el=e)&&(this.el=document.querySelector(e)),null===this.el)throw new Error("The element you passed to Selectr can not be found.");if("select"!==this.el.nodeName.toLowerCase())throw new Error("The element you passed to Selectr is not a HTMLSelectElement.");this.render(t)}var u=function(){var e=this.tree,t=e.scrollTop;if(e.scrollHeight-e.offsetHeight<=t&&this.pageIndex<this.pages.length){var i=document.createDocumentFragment();l.each(this.pages[this.pageIndex],function(e,t){o(t,i,this.customOption)},this),e.appendChild(i),this.pageIndex++,this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length})}};d.prototype.render=function(e){if(!this.rendered){this.config=l.extend(r,e),this.originalType=this.el.type,this.originalIndex=this.el.tabIndex,this.defaultSelected=[],this.originalOptionCount=this.el.options.length,(this.config.multiple||this.config.taggable)&&(this.el.multiple=!0),this.disabled=c(this.config,"disabled"),this.opened=!1,this.config.taggable&&(this.config.searchable=!1),this.navigating=!1,this.mobileDevice=!1,/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&(this.mobileDevice=!0),this.customOption=this.config.hasOwnProperty("renderOption")&&"function"==typeof this.config.renderOption,this.customSelected=this.config.hasOwnProperty("renderSelection")&&"function"==typeof this.config.renderSelection,n.mixin(this),function(){this.requiresPagination=this.config.pagination&&0<this.config.pagination,c(this.config,"width")&&(l.isInt(this.config.width)?this.width=this.config.width+"px":"auto"===this.config.width?this.width="100%":l.includes(this.config.width,"%")&&(this.width=this.config.width)),this.container=l.createElement("div",{class:"selectr-container"}),this.config.customClass&&l.addClass(this.container,this.config.customClass),this.mobileDevice?l.addClass(this.container,"selectr-mobile"):l.addClass(this.container,"selectr-desktop"),this.el.tabIndex=-1,this.config.nativeDropdown||this.mobileDevice?l.addClass(this.el,"selectr-visible"):l.addClass(this.el,"selectr-hidden"),this.selected=l.createElement("div",{class:"selectr-selected",disabled:this.disabled,tabIndex:1,"aria-expanded":!1}),this.label=l.createElement(this.el.multiple?"ul":"span",{class:"selectr-label"});var e=l.createElement("div",{class:"selectr-options-container"});if(this.tree=l.createElement("ul",{class:"selectr-options",role:"tree",
"aria-hidden":!0,"aria-expanded":!1}),this.notice=l.createElement("div",{class:"selectr-notice"}),this.el.setAttribute("aria-hidden",!0),this.disabled&&(this.el.disabled=!0),this.el.multiple&&(l.addClass(this.label,"selectr-tags"),l.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=this.getSelectedProperties("value"),this.selectedIndexes=this.getSelectedProperties("idx")),this.selected.appendChild(this.label),this.config.clearable&&(this.selectClear=l.createElement("button",{class:"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),l.addClass(this.container,"clearable")),this.config.taggable){var t=l.createElement("li",{class:"input-tag"});this.input=l.createElement("input",{class:"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),t.appendChild(this.input),this.label.appendChild(t),l.addClass(this.container,"taggable"),this.tagSeperators=[","],this.config.tagSeperators&&(this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators))}this.config.searchable&&(this.input=l.createElement("input",{class:"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),this.inputClear=l.createElement("button",{class:"selectr-input-clear",type:"button"}),this.inputContainer=l.createElement("div",{class:"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),e.appendChild(this.inputContainer)),e.appendChild(this.notice),e.appendChild(this.tree),this.items=[],this.options=[],this.el.options.length&&(this.options=[].slice.call(this.el.options));var i,n=!1,r=0;if(this.el.children.length&&l.each(this.el.children,function(e,t){"OPTGROUP"===t.nodeName?(n=l.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.label+"</li>"}),l.each(t.children,function(e,t){t.idx=r,n.appendChild(h.call(this,t,n)),r++},this)):(t.idx=r,h.call(this,t),r++)},this),this.config.data&&Array.isArray(this.config.data)){var o,s=!(this.data=[]);n=!1,r=0,l.each(this.config.data,function(e,t){c(t,"children")?(s=l.createElement("optgroup",{label:t.text}),n=l.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+t.text+"</li>"}),l.each(t.children,function(e,t){(o=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=c(t,"disabled"),this.options.push(o),s.appendChild(o),o.idx=r,n.appendChild(h.call(this,o,t)),this.data[r]=t,r++},this)):((o=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&!0===t.selected)).disabled=c(t,"disabled"),this.options.push(o),o.idx=r,h.call(this,o,t),this.data[r]=t,r++)},this)}this.setSelected(!0);for(var a=this.navIndex=0;a<this.items.length;a++)if(i=this.items[a],!l.hasClass(i,"disabled")){l.addClass(i,"active"),this.navIndex=a;break}this.requiresPagination&&(this.pageIndex=1,this.paginate()),this.container.appendChild(this.selected),this.container.appendChild(e),this.placeEl=l.createElement("div",{class:"selectr-placeholder"}),this.setPlaceholder(),this.selected.appendChild(this.placeEl),this.disabled&&this.disable(),this.el.parentNode.insertBefore(this.container,this.el),this.container.appendChild(this.el)}.call(this),this.bindEvents(),this.update(),this.optsRect=l.rect(this.tree),this.rendered=!0,this.el.multiple||(this.el.selectedIndex=this.selectedIndex);var t=this;setTimeout(function(){t.emit("selectr.init")},20)}},d.prototype.getSelected=function(){return this.el.querySelectorAll("option:checked")},d.prototype.getSelectedProperties=function(t){var e=this.getSelected();return[].slice.call(e).map(function(e){return e[t]}).filter(function(e){return null!=e})},d.prototype.bindEvents=function(){var n=this;if(this.events={},this.events.dismiss=function(e){var t=e.target;this.container.contains(t)||!this.opened&&!l.hasClass(this.container,"notice")||this.close()}.bind(this),this.events.navigate=function(e){if(e=e||window.event,this.items.length&&this.opened&&l.includes([13,38,40],e.which)){if(e.preventDefault(),13===e.which)return!(this.config.taggable&&0<this.input.value.length)&&this.change(this.navIndex);var t,i=this.items[this.navIndex];switch(e.which){case 38:(t=0)<this.navIndex&&this.navIndex--;break;case 40:t=1,this.navIndex<this.items.length-1&&this.navIndex++}for(this.navigating=!0;l.hasClass(this.items[this.navIndex],"disabled")||l.hasClass(this.items[this.navIndex],"excluded");)if(t?this.navIndex++:this.navIndex--,this.searching){if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}}var n=l.rect(this.items[this.navIndex]);t?(0===this.navIndex?this.tree.scrollTop=0:n.top+n.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop=this.tree.scrollTop+(n.top+n.height-(this.optsRect.top+this.optsRect.height))),this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&u.call(this)):0===this.navIndex?this.tree.scrollTop=0:n.top-this.optsRect.top<0&&(this.tree.scrollTop=this.tree.scrollTop+(n.top-this.optsRect.top)),i&&l.removeClass(i,"active"),l.addClass(this.items[this.navIndex],"active")}else this.navigating=!1}.bind(this),this.events.reset=this.reset.bind(this),this.config.nativeDropdown||this.mobileDevice){this.container.addEventListener("touchstart",function(e){e.changedTouches[0].target===n.el&&n.toggle()}),(this.config.nativeDropdown||this.mobileDevice)&&this.container.addEventListener("click",function(e){e.preventDefault(),e.stopPropagation(),e.target===n.el&&n.toggle()});this.el.addEventListener("change",function(e){if(n.el.multiple){var t=n.getSelectedProperties("idx"),i=function(e,t){for(var i,n=[],r=e.slice(0),o=0;o<t.length;o++)-1<(i=r.indexOf(t[o]))?r.splice(i,1):n.push(t[o]);return[n,r]}(n.selectedIndexes,t);l.each(i[0],function(e,t){n.select(t)},n),l.each(i[1],function(e,t){n.deselect(t)},n)}else-1<n.el.selectedIndex&&n.select(n.el.selectedIndex)})}this.config.nativeDropdown&&this.container.addEventListener("keydown",function(e){"Enter"===e.key&&n.selected===document.activeElement&&(n.toggle(),setTimeout(function(){n.el.focus()},200))}),this.selected.addEventListener("click",function(e){n.disabled||n.toggle(),e.preventDefault(),e.stopPropagation()}),this.label.addEventListener("click",function(e){l.hasClass(e.target,"selectr-tag-remove")&&n.deselect(e.target.parentNode.idx)}),this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this)),this.tree.addEventListener("mousedown",function(e){e.preventDefault()}),this.tree.addEventListener("click",function(e){e.preventDefault(),e.stopPropagation();var t=l.closest(e.target,function(e){return e&&l.hasClass(e,"selectr-option")});t&&(l.hasClass(t,"disabled")||(l.hasClass(t,"selected")?(n.el.multiple||!n.el.multiple&&n.config.allowDeselect)&&n.deselect(t.idx):n.select(t.idx),n.opened&&!n.el.multiple&&n.close()))}),this.tree.addEventListener("mouseover",function(e){l.hasClass(e.target,"selectr-option")&&(l.hasClass(e.target,"disabled")||(l.removeClass(n.items[n.navIndex],"active"),l.addClass(e.target,"active"),n.navIndex=[].slice.call(n.items).indexOf(e.target)))}),this.config.searchable&&(this.input.addEventListener("focus",function(e){n.searching=!0}),this.input.addEventListener("blur",function(e){n.searching=!1}),this.input.addEventListener("keyup",function(e){n.search(),n.config.taggable||(this.value.length?l.addClass(this.parentNode,"active"):l.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(e){n.input.value=null,a.call(n),n.tree.childElementCount||s.call(n)})),this.config.taggable&&this.input.addEventListener("keyup",function(e){if(n.search(),n.config.taggable&&this.value.length){var i=this.value.trim();if(13===e.which||l.includes(n.tagSeperators,e.key))l.each(n.tagSeperators,function(e,t){i=i.replace(t,"")}),n.add({value:i,text:i,selected:!0},!0)?(n.close(),a.call(n)):(this.value="",n.setMessage("That tag is already in use."))}}),this.update=l.debounce(function(){n.opened&&n.config.closeOnScroll&&n.close(),n.width&&(n.container.style.width=n.width),n.invert()},50),this.requiresPagination&&(this.paginateItems=l.debounce(function(){u.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this))),document.addEventListener("click",this.events.dismiss),window.addEventListener("keydown",this.events.navigate),window.addEventListener("resize",this.update),window.addEventListener("scroll",this.update),this.el.form&&this.el.form.addEventListener("reset",this.events.reset)},d.prototype.setSelected=function(e){if(this.config.data||this.el.multiple||!this.el.options.length||(0===this.el.selectedIndex&&(this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1)),this.selectedIndex=this.el.selectedIndex,-1<this.selectedIndex&&this.select(this.selectedIndex)),this.config.multiple&&"select-one"===this.originalType&&!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1),l.each(this.options,function(e,t){t.selected&&t.defaultSelected&&this.select(t.idx)},this),this.config.selectedValue&&this.setValue(this.config.selectedValue),this.config.data){!this.el.multiple&&this.config.defaultSelected&&this.el.selectedIndex<0&&this.select(0);var i=0;l.each(this.config.data,function(e,t){c(t,"children")?l.each(t.children,function(e,t){t.hasOwnProperty("selected")&&!0===t.selected&&this.select(i),i++},this):(t.hasOwnProperty("selected")&&!0===t.selected&&this.select(i),i++)},this)}},d.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),"select-one"===this.originalType&&(this.el.multiple=!1),this.config.data&&(this.el.innerHTML=""),l.removeClass(this.el,"selectr-hidden"),this.el.form&&l.off(this.el.form,"reset",this.events.reset),l.off(document,"click",this.events.dismiss),l.off(document,"keydown",this.events.navigate),l.off(window,"resize",this.update),l.off(window,"scroll",this.update),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1)},d.prototype.change=function(e){var t=this.items[e],i=this.options[e];i.disabled||(i.selected&&l.hasClass(t,"selected")?this.deselect(e):this.select(e),this.opened&&!this.el.multiple&&this.close())},d.prototype.select=function(n){var e=this.items[n],t=[].slice.call(this.el.options),i=this.options[n];if(this.el.multiple){if(l.includes(this.selectedIndexes,n))return!1;if(this.config.maxSelections&&this.tags.length===this.config.maxSelections)return this.setMessage("A maximum of "+this.config.maxSelections+" items can be selected.",!0),!1;this.selectedValues.push(i.value),this.selectedIndexes.push(n),function(e){var c,h=this,i=document.createDocumentFragment(),t=this.options[e.idx],n=this.data?this.data[e.idx]:t,r=this.customSelected?this.config.renderSelection(n):t.textContent,o=l.createElement("li",{class:"selectr-tag",html:r}),s=l.createElement("button",{class:"selectr-tag-remove",type:"button"});if(o.appendChild(s),o.idx=e.idx,o.tag=t.value,this.tags.push(o),this.config.sortSelected){var a=this.tags.slice();c=function(e,n){e.replace(/(\d+)|(\D+)/g,function(e,t,i){n.push([t||1/0,i||""])})},a.sort(function(e,t){var i,n,r=[],o=[];for(!0===h.config.sortSelected?(i=e.tag,n=t.tag):"text"===h.config.sortSelected&&(i=e.textContent,n=t.textContent),c(i,r),c(n,o);r.length&&o.length;){var s=r.shift(),a=o.shift(),l=s[0]-a[0]||s[1].localeCompare(a[1]);if(l)return l}return r.length-o.length}),l.each(a,function(e,t){i.appendChild(t)}),this.label.innerHTML=""}else i.appendChild(o);this.config.taggable?this.label.insertBefore(i,this.input.parentNode):this.label.appendChild(i)}.call(this,e)}else{var r=this.data?this.data[n]:i;this.label.innerHTML=this.customSelected?this.config.renderSelection(r):i.textContent,this.selectedValue=i.value,this.selectedIndex=n,l.each(this.options,function(e,t){var i=this.items[e];e!==n&&(i&&l.removeClass(i,"selected"),t.selected=!1,t.removeAttribute("selected"))},this)}l.includes(t,i)||this.el.add(i),e.setAttribute("aria-selected",!0),l.addClass(e,"selected"),l.addClass(this.container,"has-selected"),i.selected=!0,i.setAttribute("selected",""),this.emit("selectr.change",i),this.emit("selectr.select",i)},d.prototype.deselect=function(e,t){var i=this.items[e],n=this.options[e];if(this.el.multiple){var r=this.selectedIndexes.indexOf(e);this.selectedIndexes.splice(r,1);var o=this.selectedValues.indexOf(n.value);this.selectedValues.splice(o,1),function(i){var n=!1;l.each(this.tags,function(e,t){t.idx===i.idx&&(n=t)},this),n&&(this.label.removeChild(n),this.tags.splice(this.tags.indexOf(n),1))}.call(this,i),this.tags.length||l.removeClass(this.container,"has-selected")}else{if(!t&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.innerHTML="",this.selectedValue=null,this.el.selectedIndex=this.selectedIndex=-1,l.removeClass(this.container,"has-selected")}this.items[e].setAttribute("aria-selected",!1),l.removeClass(this.items[e],"selected"),n.selected=!1,n.removeAttribute("selected"),this.emit("selectr.change",null),this.emit("selectr.deselect",n)},d.prototype.setValue=function(i){var n=Array.isArray(i);if(n||(i=i.toString().trim()),!this.el.multiple&&n)return!1;l.each(this.options,function(e,t){(n&&l.includes(i.toString(),t.value)||t.value===i)&&this.change(t.idx)},this)},d.prototype.getValue=function(e,t){var n;if(this.el.multiple)e?this.selectedIndexes.length&&(n={values:[]},l.each(this.selectedIndexes,function(e,t){var i=this.options[t];n.values[e]={value:i.value,text:i.textContent}},this)):n=this.selectedValues.slice();else if(e){var i=this.options[this.selectedIndex];n={value:i.value,text:i.textContent}}else n=this.selectedValue;return e&&t&&(n=JSON.stringify(n)),n},d.prototype.add=function(i,n){if(i){if(this.data=this.data||[],this.items=this.items||[],this.options=this.options||[],Array.isArray(i))l.each(i,function(e,t){this.add(t,n)},this);else if("[object Object]"===Object.prototype.toString.call(i)){if(n){var r=!1;if(l.each(this.options,function(e,t){t.value.toLowerCase()===i.value.toLowerCase()&&(r=!0)}),r)return!1}var e=l.createElement("option",i);return this.data.push(i),this.options.push(e),e.idx=0<this.options.length?this.options.length-1:0,h.call(this,e),i.selected&&this.select(e.idx),e}return this.setPlaceholder(),this.config.pagination&&this.paginate(),!0}},d.prototype.remove=function(i){var n,r=[];Array.isArray(i)?l.each(i,function(e,t){l.isInt(t)?r.push(this.getOptionByIndex(t)):"string"==typeof i&&r.push(this.getOptionByValue(t))},this):l.isInt(i)?r.push(this.getOptionByIndex(i)):"string"==typeof i&&r.push(this.getOptionByValue(i)),r.length&&(l.each(r,function(e,t){n=t.idx,this.el.remove(t),this.options.splice(n,1);var i=this.items[n].parentNode;i&&i.removeChild(this.items[n]),this.items.splice(n,1),l.each(this.options,function(e,t){t.idx=e,this.items[e].idx=e},this)},this),this.setPlaceholder(),this.config.pagination&&this.paginate())},d.prototype.removeAll=function(){this.clear(!0),l.each(this.el.options,function(e,t){this.el.remove(t)},this),l.truncate(this.tree),this.items=[],this.options=[],this.data=[],this.navIndex=0,this.requiresPagination&&(this.requiresPagination=!1,this.pageIndex=1,this.pages=[]),this.setPlaceholder()},d.prototype.search=function(n){if(!this.navigating){n=n||this.input.value;var r=document.createDocumentFragment();if(this.removeMessage(),l.truncate(this.tree),1<n.length)if(l.each(this.options,function(e,t){var i=this.items[t.idx];l.includes(t.textContent.toLowerCase(),n.toLowerCase())&&!t.disabled?(o(i,r,this.customOption),l.removeClass(i,"excluded"),this.customOption||(i.innerHTML=function(e,t){var i=new RegExp(e,"i").exec(t.textContent);return!!i&&t.textContent.replace(i[0],"<span class='selectr-match'>"+i[0]+"</span>")}(n,t))):l.addClass(i,"excluded")},this),r.childElementCount){var e=this.items[this.navIndex],t=r.firstElementChild;l.removeClass(e,"active"),this.navIndex=t.idx,l.addClass(t,"active")}else this.config.taggable||this.setMessage("no results.");else s.call(this);this.tree.appendChild(r)}},d.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())},d.prototype.open=function(){var e=this;return!!this.options.length&&(this.opened||this.emit("selectr.open"),this.opened=!0,this.mobileDevice||this.config.nativeDropdown?(l.addClass(this.container,"native-open"),void(this.config.data&&l.each(this.options,function(e,t){this.el.add(t)},this))):(l.addClass(this.container,"open"),s.call(this),this.invert(),this.tree.scrollTop=0,l.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),void(this.config.searchable&&!this.config.taggable&&setTimeout(function(){e.input.focus(),e.input.tabIndex=0},10))))},d.prototype.close=function(){if(this.opened&&this.emit("selectr.close"),this.opened=!1,this.mobileDevice||this.config.nativeDropdown)l.removeClass(this.container,"native-open");else{var e=l.hasClass(this.container,"notice");this.config.searchable&&!e&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1),e&&(l.removeClass(this.container,"notice"),this.notice.textContent=""),l.removeClass(this.container,"open"),l.removeClass(this.container,"native-open"),this.selected.setAttribute("aria-expanded",!1),this.tree.setAttribute("aria-hidden",!0),this.tree.setAttribute("aria-expanded",!1),l.truncate(this.tree),a.call(this)}},d.prototype.enable=function(){this.disabled=!1,this.el.disabled=!1,this.selected.tabIndex=this.originalIndex,this.el.multiple&&l.each(this.tags,function(e,t){t.lastElementChild.tabIndex=0}),l.removeClass(this.container,"selectr-disabled")},d.prototype.disable=function(e){e||(this.el.disabled=!0),this.selected.tabIndex=-1,this.el.multiple&&l.each(this.tags,function(e,t){t.lastElementChild.tabIndex=-1}),this.disabled=!0,l.addClass(this.container,"selectr-disabled")},d.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),l.each(this.defaultSelected,function(e,t){this.select(t)},this),this.emit("selectr.reset"))},d.prototype.clear=function(e){if(this.el.multiple){if(this.selectedIndexes.length){var t=this.selectedIndexes.slice();l.each(t,function(e,t){this.deselect(t)},this)}}else-1<this.selectedIndex&&this.deselect(this.selectedIndex,e);this.emit("selectr.clear")},d.prototype.serialise=function(e){var n=[];return l.each(this.options,function(e,t){var i={value:t.value,text:t.textContent};t.selected&&(i.selected=!0),t.disabled&&(i.disabled=!0),n[e]=i}),e?JSON.stringify(n):n},d.prototype.serialize=function(e){return this.serialise(e)},d.prototype.setPlaceholder=function(e){e=e||this.config.placeholder||this.el.getAttribute("placeholder"),this.options.length||(e="No options available"),this.placeEl.innerHTML=e},d.prototype.paginate=function(){if(this.items.length){var i=this;return this.pages=this.items.map(function(e,t){return t%i.config.pagination==0?i.items.slice(t,t+i.config.pagination):null}).filter(function(e){return e}),this.pages}},d.prototype.setMessage=function(e,t){t&&this.close(),l.addClass(this.container,"notice"),this.notice.textContent=e},d.prototype.removeMessage=function(){l.removeClass(this.container,"notice"),this.notice.innerHTML=""},d.prototype.invert=function(){var e=l.rect(this.selected),t=this.tree.parentNode.offsetHeight,i=window.innerHeight;e.top+e.height+t>i?(l.addClass(this.container,"inverted"),this.isInverted=!0):(l.removeClass(this.container,"inverted"),this.isInverted=!1),this.optsRect=l.rect(this.tree)},d.prototype.getOptionByIndex=function(e){return this.options[e]},d.prototype.getOptionByValue=function(e){for(var t=!1,i=0,n=this.options.length;i<n;i++)if(this.options[i].value.trim()===e.toString().trim()){t=this.options[i];break}return t},e.exports=d},function(e,t,i){"use strict";function c(e,t,i,n){return"boolean"==typeof e||e instanceof Boolean||null===e||"number"==typeof e||e instanceof Number||"string"==typeof e||e instanceof String||e instanceof Date?JSON.stringify(e):Array.isArray(e)?function(e,t,i,n){for(var r=t?i+t:void 0,o=t?"[\n":"[",s=0;s<e.length;s++){var a=e[s];if(t&&(o+=r),o+=void 0!==a&&"function"!=typeof a?c(a,t,r,n):"null",s<e.length-1&&(o+=t?",\n":","),o.length>n)return o+"..."}return o+=t?"\n"+i+"]":"]"}(e,t,i,n):e&&"object"==typeof e?function(e,t,i,n){var r=t?i+t:void 0,o=!0,s=t?"{\n":"{";if("function"==typeof e.toJSON)return c(e.toJSON(),t,i,n);for(var a in e)if(e.hasOwnProperty(a)){var l=e[a];if(o?o=!1:s+=t?",\n":",",s+=t?r+'"'+a+'": ':'"'+a+'":',(s+=c(l,t,r,n)).length>n)return s+"..."}return s+=t?"\n"+i+"}":"}"}(e,t,i,n):void 0}function o(e,t){for(var i="";0<t--;)i+=e;return i}t.stringifyPartial=function(e,t,i){var n;"number"==typeof t?10<t?n=o(" ",10):1<=t&&(n=o(" ",t)):"string"==typeof t&&""!==t&&(n=t);var r=c(e,n,"",i);return r.length>i?function(e,t){return"number"==typeof t?e.slice(0,t):e}(r,i)+"...":r},t.containsArray=function(e){return/^\s*\[/.test(e)}},function(e,t,i){"use strict";var E={start:function(e,t,i){return 0===t.indexOf(e)},contain:function(e,t,i){return-1<t.indexOf(e)}};e.exports=function(l){(l=l||{}).filter=l.filter||"start",l.trigger=l.trigger||"keydown",l.confirmKeys=l.confirmKeys||[39,35,9],l.caseSensitive=l.caseSensitive||!1;var n="",r="",o=document.createElement("div");o.style.position="relative",o.style.outline="0",o.style.border="0",o.style.margin="0",o.style.padding="0";var t,s,a=document.createElement("div");function c(e){var t,i;document.createRange?((t=document.createRange()).selectNodeContents(e),t.collapse(!1),(i=window.getSelection()).removeAllRanges(),i.addRange(t)):document.selection&&((t=document.body.createTextRange()).moveToElementText(e),t.collapse(!1),t.select())}function h(e){return void 0===t&&((t=document.createElement("span")).style.visibility="hidden",t.style.position="fixed",t.style.outline="0",t.style.margin="0",t.style.padding="0",t.style.border="0",t.style.left="0",t.style.whiteSpace="pre",t.style.fontSize=n,t.style.fontFamily=r,t.style.fontWeight="normal",document.body.appendChild(t)),t.innerHTML=String(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;"),t.getBoundingClientRect().right}a.className="autocomplete dropdown",a.style.position="absolute",a.style.visibility="hidden";var d,u,f,i,p,m={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:o,show:function(e,t,i){this.startFrom=t,this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null),""==n&&(n=window.getComputedStyle(e).getPropertyValue("font-size")),""==r&&(r=window.getComputedStyle(e).getPropertyValue("font-family"));e.getBoundingClientRect().right,e.getBoundingClientRect().left;a.style.marginLeft="0",a.style.marginTop=e.getBoundingClientRect().height+"px",this.options=i,this.element!=e&&(this.element=e,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor}),this.element.style.zIndex=3,this.element.style.position="relative",this.element.style.backgroundColor="transparent",this.element.style.borderColor="transparent",this.elementHint=e.cloneNode(),this.elementHint.className="autocomplete hint",this.elementHint.style.zIndex=2,this.elementHint.style.position="absolute",this.elementHint.onfocus=function(){this.element.focus()}.bind(this),this.element.addEventListener&&(this.element.removeEventListener("keydown",b),this.element.addEventListener("keydown",b,!1),this.element.removeEventListener("blur",C),this.element.addEventListener("blur",C,!1)),o.appendChild(this.elementHint),o.appendChild(a),e.parentElement.appendChild(o),this.repaint(e)},setText:function(e){this.element.innerText=e},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null,g.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(e){var t=e.innerText;t=t.replace("\n","");this.startFrom,this.options;var i=this.options.length,n=t.substring(this.startFrom);s=t.substring(0,this.startFrom);for(var r=0;r<i;r++){var o=this.options[r];if(!l.caseSensitive&&0===o.toLowerCase().indexOf(n.toLowerCase())||l.caseSensitive&&0===o.indexOf(n)){this.elementHint.innerText=s+n+o.substring(n.length),this.elementHint.realInnerText=s+o;break}}a.style.left=h(s)+"px",g.refresh(n,this.options),this.elementHint.style.width=h(this.elementHint.innerText)+10+"px","hidden"==a.style.visibility||(this.elementHint.style.width=h(this.elementHint.innerText)+a.clientWidth+"px")}},g=(d=a,u=[],f=0,i=-1,p={rs:m,hide:function(){d.style.visibility="hidden"},refresh:function(i,e){d.style.visibility="hidden",f=0,d.innerHTML="";var t=window.innerHeight||document.documentElement.clientHeight,n=d.parentNode.getBoundingClientRect(),r=n.top-6,o=t-n.bottom-6;u=[];var s="function"==typeof l.filter?l.filter:E[l.filter],a=s?e.filter(function(e){return s(l.caseSensitive?i:i.toLowerCase(),l.caseSensitive?e:e.toLowerCase(),l)}):[];0!==(u=a.map(function(e){var t=document.createElement("div");return t.className="item",t.onmouseover=v,t.onmouseout=y,t.onmousedown=w,t.__hint=e,t.innerHTML=e.substring(0,i.length)+"<b>"+e.substring(i.length)+"</b>",d.appendChild(t),t})).length&&(1===u.length&&(i.toLowerCase()===u[0].__hint.toLowerCase()&&!l.caseSensitive||i===u[0].__hint&&l.caseSensitive)||u.length<2||(p.highlight(0),3*o<r?(d.style.maxHeight=r+"px",d.style.top="",d.style.bottom="100%"):(d.style.top="100%",d.style.bottom="",d.style.maxHeight=o+"px"),d.style.visibility="visible"))},highlight:function(e){-1!=i&&u[i]&&(u[i].className="item"),u[e].className="item hover",i=e},move:function(e){return"hidden"===d.style.visibility?"":(f+e===-1||f+e===u.length||(f+=e,p.highlight(f)),u[f].__hint)},onmouseselection:function(){}});function v(){this.style.outline="1px solid #ddd"}function y(){this.style.outline="0"}function w(){p.hide(),p.onmouseselection(this.__hint,p.rs)}var b=function(e){var t=(e=e||window.event).keyCode;if(null!=this.elementHint&&33!=t&&34!=t){if(27==t)return m.hideDropDown(),m.element.focus(),e.preventDefault(),void e.stopPropagation();var i=this.element.innerText;i=i.replace("\n","");this.startFrom;if(0<=l.confirmKeys.indexOf(t))return 9==t&&0==this.elementHint.innerText.length&&m.onTab(),void(0<this.elementHint.innerText.length&&this.element.innerText!=this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,m.hideDropDown(),c(this.element),9==t&&(m.element.focus(),e.preventDefault(),e.stopPropagation())));if(13!=t){if(40==t){var n=i.substring(this.startFrom);return""==(r=g.move(1))&&m.onArrowDown(),this.elementHint.innerText=s+n+r.substring(n.length),this.elementHint.realInnerText=s+r,e.preventDefault(),void e.stopPropagation()}if(38==t){var r;n=i.substring(this.startFrom);return""==(r=g.move(-1))&&m.onArrowUp(),this.elementHint.innerText=s+n+r.substring(n.length),this.elementHint.realInnerText=s+r,e.preventDefault(),void e.stopPropagation()}}else if(0==this.elementHint.innerText.length)m.onEnter();else{var o="hidden"==a.style.visibility;if(g.hide(),o)return m.hideDropDown(),m.element.focus(),void m.onEnter();this.element.innerText=this.elementHint.realInnerText,m.hideDropDown(),c(this.element),e.preventDefault(),e.stopPropagation()}}}.bind(m),C=function(e){m.hideDropDown()}.bind(m);return g.onmouseselection=function(e,t){t.element.innerText=t.elementHint.innerText=s+e,t.hideDropDown(),window.setTimeout(function(){t.element.focus(),c(t.element)},1)},m}},function(e,t,i){var n=i(0).isPromise,r=i(0).isValidValidationError,o=i(0).stringifyPath;t.validateCustom=function(e,t){if(!t)return Promise.resolve([]);try{var i=t(e);return(n(i)?i:Promise.resolve(i)).then(function(e){return Array.isArray(e)?e.filter(function(e){var t=r(e);return t||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',e),t}).map(function(e){return{dataPath:o(e.path),message:e.message}}):[]})}catch(e){return Promise.reject(e)}}},function(e,t){ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(e,t,i){t.isDark=!1,t.cssClass="ace-jsoneditor",t.cssText='.ace-jsoneditor .ace_gutter {background: #ebebeb;color: #333}.ace-jsoneditor.ace_editor {font-family: "dejavu sans mono", "droid sans mono", consolas, monaco, "lucida console", "courier new", courier, monospace, sans-serif;line-height: 1.3;background-color: #fff;}.ace-jsoneditor .ace_print-margin {width: 1px;background: #e8e8e8}.ace-jsoneditor .ace_scroller {background-color: #FFFFFF}.ace-jsoneditor .ace_text-layer {color: gray}.ace-jsoneditor .ace_variable {color: #1a1a1a}.ace-jsoneditor .ace_cursor {border-left: 2px solid #000000}.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {border-left: 0px;border-bottom: 1px solid #000000}.ace-jsoneditor .ace_marker-layer .ace_selection {background: lightgray}.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px #FFFFFF;border-radius: 2px}.ace-jsoneditor .ace_marker-layer .ace_step {background: rgb(255, 255, 0)}.ace-jsoneditor .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid #BFBFBF}.ace-jsoneditor .ace_marker-layer .ace_active-line {background: #FFFBD1}.ace-jsoneditor .ace_gutter-active-line {background-color : #dcdcdc}.ace-jsoneditor .ace_marker-layer .ace_selected-word {border: 1px solid lightgray}.ace-jsoneditor .ace_invisible {color: #BFBFBF}.ace-jsoneditor .ace_keyword,.ace-jsoneditor .ace_meta,.ace-jsoneditor .ace_support.ace_constant.ace_property-value {color: #AF956F}.ace-jsoneditor .ace_keyword.ace_operator {color: #484848}.ace-jsoneditor .ace_keyword.ace_other.ace_unit {color: #96DC5F}.ace-jsoneditor .ace_constant.ace_language {color: darkorange}.ace-jsoneditor .ace_constant.ace_numeric {color: red}.ace-jsoneditor .ace_constant.ace_character.ace_entity {color: #BF78CC}.ace-jsoneditor .ace_invalid {color: #FFFFFF;background-color: #FF002A;}.ace-jsoneditor .ace_fold {background-color: #AF956F;border-color: #000000}.ace-jsoneditor .ace_storage,.ace-jsoneditor .ace_support.ace_class,.ace-jsoneditor .ace_support.ace_function,.ace-jsoneditor .ace_support.ace_other,.ace-jsoneditor .ace_support.ace_type {color: #C52727}.ace-jsoneditor .ace_string {color: green}.ace-jsoneditor .ace_comment {color: #BCC8BA}.ace-jsoneditor .ace_entity.ace_name.ace_tag,.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {color: #606060}.ace-jsoneditor .ace_markup.ace_underline {text-decoration: underline}.ace-jsoneditor .ace_indent-guide {background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y}',e("../lib/dom").importCssString(t.cssText,t.cssClass)})},function(e,t,i){"use strict";var r=i(5),d=i(1).translate,u=i(11),f=i(28),n=i(27)[0].mixin,o=i(9),s=i(10),a=i(2).MAX_PREVIEW_CHARACTERS,l=i(2).DEFAULT_MODAL_ANCHOR,c=i(2).SIZE_LARGE,p=i(2).PREVIEW_HISTORY_LIMIT,m=i(0),g=i(85),h={create:function(e,t){void 0===(t=t||{}).statusBar&&(t.statusBar=!0),t.mainMenuBar=!1!==t.mainMenuBar,t.enableSort=!1!==t.enableSort,t.enableTransform=!1!==t.enableTransform,(this.options=t).indentation?this.indentation=Number(t.indentation):this.indentation=2,this.mode="preview";var i=this;if(this.container=e,this.dom={},this.json=void 0,this.text="",this._debouncedValidate=m.debounce(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=e.clientWidth,this.height=e.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-preview",this.frame.onclick=function(e){e.preventDefault()},this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.dom.busy=document.createElement("div"),this.dom.busy.className="jsoneditor-busy",this.dom.busyContent=document.createElement("span"),this.dom.busyContent.innerHTML="busy...",this.dom.busy.appendChild(this.dom.busyContent),this.content.appendChild(this.dom.busy),this.dom.previewContent=document.createElement("pre"),this.dom.previewContent.className="jsoneditor-preview",this.dom.previewText=document.createTextNode(""),this.dom.previewContent.appendChild(this.dom.previewText),this.content.appendChild(this.dom.previewContent),this.options.mainMenuBar){m.addClassName(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu);var n=document.createElement("button");n.type="button",n.className="jsoneditor-format",n.title="Format JSON data, with proper indentation and line feeds (Ctrl+\\)",this.menu.appendChild(n),n.onclick=function(){i.executeWithBusyMessage(function(){try{i.format()}catch(e){i._onError(e)}},"formatting...")};var r=document.createElement("button");if(r.type="button",r.className="jsoneditor-compact",r.title="Compact JSON data, remove all whitespaces (Ctrl+Shift+\\)",this.menu.appendChild(r),r.onclick=function(){i.executeWithBusyMessage(function(){try{i.compact()}catch(e){i._onError(e)}},"compacting...")},this.options.enableSort){var o=document.createElement("button");o.type="button",o.className="jsoneditor-sort",o.title=d("sortTitleShort"),o.onclick=function(){i._showSortModal()},this.menu.appendChild(o)}if(this.options.enableTransform){var s=document.createElement("button");s.type="button",s.title=d("transformTitleShort"),s.className="jsoneditor-transform",s.onclick=function(){i._showTransformModal()},this.dom.transform=s,this.menu.appendChild(s)}var a=document.createElement("button");if(a.type="button",a.className="jsoneditor-repair",a.title="Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",this.menu.appendChild(a),!(a.onclick=function(){void 0===i.json&&i.executeWithBusyMessage(function(){try{i.repair()}catch(e){i._onError(e)}},"repairing...")})!==this.options.history){this.history=new g(function(){i.dom.undo.disabled=!i.history.canUndo(),i.dom.redo.disabled=!i.history.canRedo()},function(e){return 2*e.text.length},p);var l=document.createElement("button");l.type="button",l.className="jsoneditor-undo jsoneditor-separator",l.title=d("undo"),l.onclick=function(){var e=i.history.undo();e&&i._applyHistory(e)},this.menu.appendChild(l),this.dom.undo=l;var c=document.createElement("button");c.type="button",c.className="jsoneditor-redo",c.title=d("redo"),c.onclick=function(){var e=i.history.redo();e&&i._applyHistory(e)},this.menu.appendChild(c),this.dom.redo=c,this.history.onChange()}this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new u(this.menu,this.options.modes,this.options.mode,function(e){i.setMode(e),i.modeSwitcher.focus()}))}if(this.errorTable=new f({errorTableVisible:!0,onToggleVisibility:function(){i.validate()},onFocusLine:null,onChangeHeight:function(e){var t=e+i.dom.statusBar.clientHeight+1;i.content.style.marginBottom=-t+"px",i.content.style.paddingBottom=t+"px"}}),this.frame.appendChild(this.content),this.frame.appendChild(this.errorTable.getErrorTable()),this.container.appendChild(this.frame),t.statusBar){m.addClassName(this.content,"has-status-bar");var h=document.createElement("div");(this.dom.statusBar=h).className="jsoneditor-statusbar",this.frame.appendChild(h),this.dom.fileSizeInfo=document.createElement("span"),this.dom.fileSizeInfo.className="jsoneditor-size-info",this.dom.fileSizeInfo.innerText="",h.appendChild(this.dom.fileSizeInfo),this.dom.arrayInfo=document.createElement("span"),this.dom.arrayInfo.className="jsoneditor-size-info",this.dom.arrayInfo.innerText="",h.appendChild(this.dom.arrayInfo),h.appendChild(this.errorTable.getErrorCounter()),h.appendChild(this.errorTable.getWarningIcon()),h.appendChild(this.errorTable.getErrorIcon())}this._renderPreview(),this.setSchema(this.options.schema,this.options.schemaRefs)},_renderPreview:function(){var e=this.getText();this.dom.previewText.nodeValue=m.limitCharacters(e,a),this.dom.fileSizeInfo&&(this.dom.fileSizeInfo.innerText="Size: "+m.formatSize(e.length)),this.dom.arrayInfo&&(Array.isArray(this.json)?this.dom.arrayInfo.innerText="Array: "+this.json.length+" items":this.dom.arrayInfo.innerText="")},_onChange:function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(e){console.error("Error in onChange callback: ",e)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(e){console.error("Error in onChangeJSON callback: ",e)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(e){console.error("Error in onChangeText callback: ",e)}}};h._showSortModal=function(){var r=this;this.executeWithBusyMessage(function(){var e=r.options.modalAnchor||l,t=r.get();r._renderPreview(),o(e,t,function(e){r.executeWithBusyMessage(function(){!function(e,t){if(Array.isArray(e)){var i=m.sort(e,t.path,t.direction);r.sortedBy=t,r._setAndFireOnChange(i)}if(m.isObject(e)){var n=m.sortObjectKeys(e,t.direction);r.sortedBy=t,r._setAndFireOnChange(n)}}(t,e)},"sorting...")},r.sortedBy)},"parsing...")},h._showTransformModal=function(){var n=this;this.executeWithBusyMessage(function(){var e=n.options.modalAnchor||l,i=n.get();n._renderPreview(),s(e,i,function(t){n.executeWithBusyMessage(function(){var e=r.search(i,t);n._setAndFireOnChange(e)},"transforming...")})},"parsing...")},h.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this._debouncedValidate=null,this.history.clear(),this.history=null},h.compact=function(){var e=this.get(),t=JSON.stringify(e);this._setTextAndFireOnChange(t,e)},h.format=function(){var e=this.get(),t=JSON.stringify(e,null,this.indentation);this._setTextAndFireOnChange(t,e)},h.repair=function(){var e=this.getText(),t=m.repair(e);this._setTextAndFireOnChange(t)},h.focus=function(){this.dom.transform.focus()},h.set=function(e){this.history&&this.history.clear(),this._set(e)},h.update=function(e){this._set(e)},h._set=function(e){this.text=void 0,this.json=e,this._renderPreview(),this._pushHistory(),this._debouncedValidate()},h._setAndFireOnChange=function(e){this._set(e),this._onChange()},h.get=function(){if(void 0===this.json){var e=this.getText();this.json=m.parse(e)}return this.json},h.getText=function(){return void 0===this.text&&(this.text=JSON.stringify(this.json,null,this.indentation),!0===this.options.escapeUnicode&&(this.text=m.escapeUnicodeChars(this.text))),this.text},h.setText=function(e){this.history&&this.history.clear(),this._setText(e)},h.updateText=function(e){this.getText()!==e&&this._setText(e)},h._setText=function(e,t){if(!0===this.options.escapeUnicode?this.text=m.escapeUnicodeChars(e):this.text=e,this.json=t,this._renderPreview(),void 0===this.json){var i=this;this.executeWithBusyMessage(function(){try{i.json=i.get(),i._renderPreview(),i._pushHistory()}catch(e){}},"parsing...")}else this._pushHistory();this._debouncedValidate()},h._setTextAndFireOnChange=function(e,t){this._setText(e,t),this._onChange()},h._applyHistory=function(e){this.json=e.json,this.text=e.text,this._renderPreview(),this._debouncedValidate()},h._pushHistory=function(){if(this.history){var e={text:this.text,json:this.json};this.history.add(e)}},h.executeWithBusyMessage=function(e,t){var i=this.getText().length;if(c<i){var n=this;m.addClassName(n.frame,"busy"),n.dom.busyContent.innerText=t,setTimeout(function(){e(),m.removeClassName(n.frame,"busy"),n.dom.busyContent.innerText=""},100)}else e()},h.validate=n.validate,h._renderErrors=n._renderErrors,e.exports=[{mode:"preview",mixin:h,data:"json"}]},function(e,t){function i(e,t,i){this.onChange=e,this.calculateItemSize=t||function(){return 1},this.limit=i,this.items=[],this.index=-1}i.prototype.add=function(e){for(;this._calculateHistorySize()>this.limit&&1<this.items.length;)this.items.shift(),this.index--;this.items=this.items.slice(0,this.index+1),this.items.push(e),this.index++,this.onChange()},i.prototype._calculateHistorySize=function(){var t=this.calculateItemSize,i=0;return this.items.forEach(function(e){i+=t(e)}),i},i.prototype.undo=function(){if(this.canUndo())return this.index--,this.onChange(),this.items[this.index]},i.prototype.redo=function(){if(this.canRedo())return this.index++,this.onChange(),this.items[this.index]},i.prototype.canUndo=function(){return 0<this.index},i.prototype.canRedo=function(){return this.index<this.items.length-1},i.prototype.clear=function(){this.items=[],this.index=-1,this.onChange()},e.exports=i},function(e){e.exports=JSON.parse('{"id":"http://json-schema.org/draft-04/schema#","$schema":"http://json-schema.org/draft-04/schema#","description":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"positiveInteger":{"type":"integer","minimum":0},"positiveIntegerDefault0":{"allOf":[{"$ref":"#/definitions/positiveInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"minItems":1,"uniqueItems":true}},"type":"object","properties":{"id":{"type":"string"},"$schema":{"type":"string"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"multipleOf":{"type":"number","minimum":0,"exclusiveMinimum":true},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"boolean","default":false},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"boolean","default":false},"maxLength":{"$ref":"#/definitions/positiveInteger"},"minLength":{"$ref":"#/definitions/positiveIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"anyOf":[{"type":"boolean"},{"$ref":"#"}],"default":{}},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/positiveInteger"},"minItems":{"$ref":"#/definitions/positiveIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"maxProperties":{"$ref":"#/definitions/positiveInteger"},"minProperties":{"$ref":"#/definitions/positiveIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"anyOf":[{"type":"boolean"},{"$ref":"#"}],"default":{}},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"enum":{"type":"array","minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"dependencies":{"exclusiveMaximum":["maximum"],"exclusiveMinimum":["minimum"]},"default":{}}')},function(e){e.exports=JSON.parse('{"$schema":"http://json-schema.org/draft-06/schema#","$id":"http://json-schema.org/draft-06/schema#","title":"Core schema meta-schema","definitions":{"schemaArray":{"type":"array","minItems":1,"items":{"$ref":"#"}},"nonNegativeInteger":{"type":"integer","minimum":0},"nonNegativeIntegerDefault0":{"allOf":[{"$ref":"#/definitions/nonNegativeInteger"},{"default":0}]},"simpleTypes":{"enum":["array","boolean","integer","null","number","object","string"]},"stringArray":{"type":"array","items":{"type":"string"},"uniqueItems":true,"default":[]}},"type":["object","boolean"],"properties":{"$id":{"type":"string","format":"uri-reference"},"$schema":{"type":"string","format":"uri"},"$ref":{"type":"string","format":"uri-reference"},"title":{"type":"string"},"description":{"type":"string"},"default":{},"examples":{"type":"array","items":{}},"multipleOf":{"type":"number","exclusiveMinimum":0},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maxLength":{"$ref":"#/definitions/nonNegativeInteger"},"minLength":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"pattern":{"type":"string","format":"regex"},"additionalItems":{"$ref":"#"},"items":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/schemaArray"}],"default":{}},"maxItems":{"$ref":"#/definitions/nonNegativeInteger"},"minItems":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"uniqueItems":{"type":"boolean","default":false},"contains":{"$ref":"#"},"maxProperties":{"$ref":"#/definitions/nonNegativeInteger"},"minProperties":{"$ref":"#/definitions/nonNegativeIntegerDefault0"},"required":{"$ref":"#/definitions/stringArray"},"additionalProperties":{"$ref":"#"},"definitions":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"properties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"patternProperties":{"type":"object","additionalProperties":{"$ref":"#"},"default":{}},"dependencies":{"type":"object","additionalProperties":{"anyOf":[{"$ref":"#"},{"$ref":"#/definitions/stringArray"}]}},"propertyNames":{"$ref":"#"},"const":{},"enum":{"type":"array","minItems":1,"uniqueItems":true},"type":{"anyOf":[{"$ref":"#/definitions/simpleTypes"},{"type":"array","items":{"$ref":"#/definitions/simpleTypes"},"minItems":1,"uniqueItems":true}]},"format":{"type":"string"},"allOf":{"$ref":"#/definitions/schemaArray"},"anyOf":{"$ref":"#/definitions/schemaArray"},"oneOf":{"$ref":"#/definitions/schemaArray"},"not":{"$ref":"#"}},"default":{}}')}],r.c=n,r.d=function(e,t,i){r.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:i})},r.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},r.t=function(t,e){if(1&e&&(t=r(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var i=Object.create(null);if(r.r(i),Object.defineProperty(i,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var n in t)r.d(i,n,function(e){return t[e]}.bind(null,n));return i},r.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return r.d(t,"a",t),t},r.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},r.p="",r(r.s=29);function r(e){if(n[e])return n[e].exports;var t=n[e]={i:e,l:!1,exports:{}};return i[e].call(t.exports,t,t.exports,r),t.l=!0,t.exports}var i,n});
//# sourceMappingURL=jsoneditor.map