<?php

namespace App\Admin\Extensions\ToolBar\Actions;

use App\Admin\Extensions\ToolBar\Forms\PharmacyImportForm;
use Dcat\Admin\Grid\Tools\AbstractTool;
use Dcat\Admin\Widgets\Modal;

class PharmacyImportAction extends AbstractTool
{
    public $title = '导入药店';

    public function html(): Modal
    {
        return Modal::make()
            ->lg()
            ->title($this->title)
            ->body(new PharmacyImportForm())
            ->button("<button class='btn btn-success'><i class='feather icon-upload'></i>&nbsp;{$this->title}</button>");
    }
}
