<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PharmacistModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'pharmacist';

    // 药师关联的药店,多对一
    public function pharmacy()
    {
        return $this->belongsTo(PharmacyModel::class, 'pharmacy_id', 'id');
    }
}
