<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\Medical;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;

class MedicalController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new Medical(), function (Grid $grid) {
            $grid->model()->orderBy('id', 'desc');
            $grid->column('id')->sortable();
            $grid->column('visitNo');
            $grid->column('idcardTypeCode')->display(function($idcardTypeCode){
                if($idcardTypeCode == "01"){
                    return '身份证';
                }else if($idcardTypeCode == "02"){
                    return '居民户口薄';
                }else if($idcardTypeCode == "03"){
                    return '护照';
                }else if($idcardTypeCode == "04"){
                    return '军官证';
                }else if($idcardTypeCode == "05"){
                   return '驾驶证';
                }else if($idcardTypeCode == "06"){
                    return '港澳居民来往内地通行证';
                }else if($idcardTypeCode == "07"){
                    return '台湾居民来往内地通行证';
                }else if($idcardTypeCode == "99"){
                    return '其他有效证件';
                }else{
                    return '未知';
                }
            });
            $grid->column('idcardNo');
            $grid->column('name');
            $grid->column('genderCode','性别')->display(function ($genderCode){
                if($genderCode == 1){
                    return '男';
                }else if($genderCode == 2){
                    return '女';
                }else{
                    return '未知';
                }
            });
            $grid->column('birthdate')->display(function($birthdate){
                // 检查字符串长度是否为8
                if (strlen($birthdate) == 8 && ctype_digit($birthdate)) {
                    // 提取年、月、日部分
                    $year = substr($birthdate, 0, 4); // 截取前4位作为年份
                    $month = substr($birthdate, 4, 2); // 截取中间2位作为月份
                    $day = substr($birthdate, 6, 2); // 截取最后2位作为日期
                    // 拼接成目标格式
                    $formattedDate = $year . "-" . $month . "-" . $day . "-";
                    // 输出结果
                    return $formattedDate;
                } else {
                    // 如果长度不符合要求或包含非数字字符
                    return '';
                }
            });
            $grid->column('guardName');
            $grid->column('guardIdcardNo');
            $grid->column('subjComplaint');
            $grid->column('mainSymptoms');
            $grid->column('prexHx');
            $grid->column('prevHist');
            $grid->column('pastHist');
            $grid->column('alleHist');
            $grid->column('tcmDdCode');
            $grid->column('tcmDdName');
            $grid->column('tcmSdCode');
            $grid->column('tcmSdName');
            $grid->column('mdDisCode');
            $grid->column('mdDisName');
            $grid->column('disCode1');
            $grid->column('disName1');
            $grid->column('disCode2');
            $grid->column('disName2');
            $grid->column('disDescription');
            $grid->column('treatMeas');
            $grid->column('unifiedOrgCode');
            $grid->column('orgName');
            $grid->column('deptCode');
            $grid->column('deptName');
            $grid->column('deptClassCode');
            $grid->column('deptClassName');
            $grid->column('doctIdcardNo');
            $grid->column('doctName');
            $grid->column('visitTimeStart')->display(function ($visitTimeStart) {
                return self::formatDateTime($visitTimeStart);
            });
            $grid->column('visitTimeEnd')->display(function ($visitTimeEnd) {
                return self::formatDateTime($visitTimeEnd);
            });
            $grid->column('doctCaSign');
            $grid->column('originalData');
            $grid->column('certificate');
            # $grid->column('reviewUrl')->width(3);
            $grid->column('textRecords')->width(3);
            $grid->column('firstVisitRecord')->width(3);
            $grid->column('created_at');
            $grid->column('updated_at')->sortable();
        
            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel(); // 更改为 panel 布局
                $filter->expand(); // 默认展开搜索框
                $filter->equal('visitNo','问诊编号')->width(3);
                $filter->equal('idcardNo')->width(3);
                $filter->equal('name')->width(3);
                $filter->equal('doctName')->width(3);
            });
            // 禁用详情按钮
            $grid->disableViewButton();
            // 禁用编辑按钮
            $grid->disableEditButton();
            // 禁用删除按钮
            $grid->disableDeleteButton();
            $grid->disableCreateButton(); // 禁用创建按钮
            $titles = [
                // 'id' => 'ID', 
                'visitNo' => '问诊编号', 
                'idcardNo' => '患者就诊卡证号码',
                'name' => '患者姓名',
                'subjComplaint' => '主诉记录',
                'prevHist' => '现病史',
                'pastHist' => '既往史',
                'alleHist' => '过敏史',
                'orgName' => '就诊医疗机构名称',
                'deptName' => '就诊科室名称',
                'deptClassName' => '就诊科室对应诊疗科目名称',
                'doctName' => '就诊医师姓名',
                'visitTimeStart' => '就诊开始时间',
                'visitTimeEnd' => '诊断结束时间',
                'reviewUrl' => '诊疗过程调阅地址',
                'textRecords' => '诊疗过程数据',
                'firstVisitRecord' => '线下初诊记录',
            ];
            $grid->export($titles)->filename("问诊信息")->rows(function($rows){
                foreach ($rows as $index => &$row) {
                    $row['visitTimeStart'] = self::formatDateTime($row['visitTimeStart']);
                    $row['visitTimeEnd'] = self::formatDateTime($row['visitTimeEnd']);
                }
                return $rows;
            });
        });
    }

    public static function formatDateTime($timeString) {
        // 判断字符串是否为空
        if (empty($timeString)) {
            return "";
        }
    
        // 去除可能的多余空格
        $timeString = trim($timeString);
    
        // 检查字符串长度是否为15（YYYYMMDD HHMMSS）
        if (strlen($timeString) != 15 || !ctype_digit(str_replace(' ', '', $timeString))) {
            return "";
        }
    
        // 提取日期部分
        $datePart = substr($timeString, 0, 8); // 截取前8位作为日期部分
        $year = substr($datePart, 0, 4); // 年
        $month = substr($datePart, 4, 2); // 月
        $day = substr($datePart, 6, 2); // 日
    
        // 提取时间部分
        $timePart = substr($timeString, 9, 6); // 截取后6位作为时间部分
        $hour = substr($timePart, 0, 2); // 时
        $minute = substr($timePart, 2, 2); // 分
        $second = substr($timePart, 4, 2); // 秒
    
        // 拼接成目标格式
        $formattedDateTime = $year . "-" . $month . "-" . $day . " " . $hour . ":" . $minute . ":" . $second;
    
        // 返回结果
        return $formattedDateTime;
    }


    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new Medical(), function (Show $show) {
            $show->field('id');
            $show->field('visitNo');
            $show->field('idcardTypeCode');
            $show->field('idcardNo');
            $show->field('name');
            $show->field('genderCode');
            $show->field('birthdate');
            $show->field('guardName');
            $show->field('guardIdcardNo');
            $show->field('subjComplaint');
            $show->field('mainSymptoms');
            $show->field('prexHx');
            $show->field('prevHist');
            $show->field('pastHist');
            $show->field('alleHist');
            $show->field('tcmDdCode');
            $show->field('tcmDdName');
            $show->field('tcmSdCode');
            $show->field('tcmSdName');
            $show->field('mdDisCode');
            $show->field('mdDisName');
            $show->field('disCode1');
            $show->field('disName1');
            $show->field('disCode2');
            $show->field('disName2');
            $show->field('disDescription');
            $show->field('treatMeas');
            $show->field('unifiedOrgCode');
            $show->field('orgName');
            $show->field('deptCode');
            $show->field('deptName');
            $show->field('deptClassCode');
            $show->field('deptClassName');
            $show->field('doctIdcardNo');
            $show->field('doctName');
            $show->field('visitTimeStart');
            $show->field('visitTimeEnd');
            $show->field('doctCaSign');
            $show->field('originalData');
            $show->field('certificate');
            $show->field('reviewUrl');
            $show->field('firstVisitRecord');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new Medical(), function (Form $form) {
            $form->display('id');
            $form->text('visitNo');
            $form->text('idcardTypeCode');
            $form->text('idcardNo');
            $form->text('name');
            $form->text('genderCode');
            $form->text('birthdate');
            $form->text('guardName');
            $form->text('guardIdcardNo');
            $form->text('subjComplaint');
            $form->text('mainSymptoms');
            $form->text('prexHx');
            $form->text('prevHist');
            $form->text('pastHist');
            $form->text('alleHist');
            $form->text('tcmDdCode');
            $form->text('tcmDdName');
            $form->text('tcmSdCode');
            $form->text('tcmSdName');
            $form->text('mdDisCode');
            $form->text('mdDisName');
            $form->text('disCode1');
            $form->text('disName1');
            $form->text('disCode2');
            $form->text('disName2');
            $form->text('disDescription');
            $form->text('treatMeas');
            $form->text('unifiedOrgCode');
            $form->text('orgName');
            $form->text('deptCode');
            $form->text('deptName');
            $form->text('deptClassCode');
            $form->text('deptClassName');
            $form->text('doctIdcardNo');
            $form->text('doctName');
            $form->text('visitTimeStart');
            $form->text('visitTimeEnd');
            $form->text('doctCaSign');
            $form->text('originalData');
            $form->text('certificate');
            $form->text('reviewUrl');
            $form->text('firstVisitRecord');
        
            $form->display('created_at');
            $form->display('updated_at');
        });
    }
}
