<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class PharmacyDrugModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'pharmacy_drug';

    public $fillable = ['pharmacy_id', 'drug_id'];

    // 关联药品池
    public function drug(): BelongsTo
    {
        return $this->belongsTo(DrugModel::class, 'drug_id', 'id');
    }

    // 关联用法用量
    public function dosage(): BelongsTo
    {
        return $this->belongsTo(DosageModel::class, 'dosage_id', 'id');
    }

    // 关联药店
    public function pharmacy(): BelongsTo
    {
        return $this->belongsTo(PharmacyModel::class, 'pharmacy_id', 'id');
    }
}
