<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Overtrue\Pinyin\Pinyin;

// 诊断
class DiagnosiModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'diagnosis';

    public function setCodeAttribute($value)
    {
        $pinyin = new Pinyin();
        $abbr = $pinyin->abbr($this->name)->join(''); // 获取拼音首字母
        $this->attributes['code'] = strtoupper($abbr);
    }
}
