<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patient', function (Blueprint $table) {
            $table->comment('问诊人');
            $table->bigIncrements('id');
            $table->string('name', 50)->nullable()->comment('姓名');
            $table->tinyInteger('gender')->default(0)->comment('性别。[1=男性,2=女性,0=未知]');
            $table->string('id_card', 18)->nullable()->index('idx_idcard')->comment('身份证号');
            $table->string('mobile', 11)->nullable()->index('idx_mobile')->comment('手机号');
            $table->string('miniapp_openid', 40)->nullable()->index('idx_miniappopenid')->comment('小程序openid');
            $table->string('avatar')->nullable()->comment('头像');
            $table->string('nick_name', 100)->nullable()->comment('昵称');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('patient');
    }
};
