<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('admin_operation_log', function (Blueprint $table) {
            $table->comment('管理员操作日志表');
            $table->bigIncrements('id')->comment('操作日志id');
            $table->bigInteger('user_id')->index('idx_userid')->comment('管理员id');
            $table->string('path')->comment('操作路径');
            $table->string('method', 10)->comment('操作方法');
            $table->string('ip')->comment('ip地址');
            $table->text('input')->comment('请求参数');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('admin_operation_log');
    }
};
