<?php

namespace App\Api\Controllers;

use App\Http\Controllers\BaseApiController;
use App\Models\DrugRelatedTagModel;
use App\Models\DrugTagRelatedInquiryModel;
use App\Models\InquiryModel;
use Illuminate\Http\Request;

// 问诊问题控制器
class InquiryController extends BaseApiController
{
    public function InquirytList(Request $request)
    {
        $inquiry_list = [];
        // 获取通用问题
        $inquiry_list_1 = InquiryModel::where('is_common', InquiryModel::INQUIRY_COMMON_TRUE)->get()->toArray();
        // 通过药品id获取标签
        $inquiry_list_2 = [];
        $drug_ids = $request->input('drug_ids');
        if ($drug_ids) {
            $tag_ids = DrugRelatedTagModel::whereIn('drug_id', explode(',', $drug_ids))->pluck('tag_id')->toArray();
            // 获取标签关联的问题
            if ($tag_ids) {
                $inquiry_ids = DrugTagRelatedInquiryModel::whereIn('tag_id', $tag_ids)->pluck('inquiry_id')->toArray();
                // 获取非通用问题
                if ($inquiry_ids) {
                    $inquiry_list_2 = InquiryModel::whereIn('id', array_column($inquiry_ids, 'inquiry_id'))->get()->toArray();
                }
            }
        }
        // 合并问题列表
        $inquiry_list = array_merge($inquiry_list_1, $inquiry_list_2);

        return $this->success($inquiry_list);
    }
}
