<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\PharmacyRepository;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Show;

// 药店
class PharmacyController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new PharmacyRepository(), function (Grid $grid) {
            $grid->model()->orderBy('id', 'desc');

            $grid->column('id')->sortable();
            $grid->column('name');
            $grid->column('business_license');
            $grid->column('drug_biz_license');
            $grid->column('food_biz_license');
            $grid->column('med_device_biz_license');
            $grid->column('drug_info_service_cert');
            $grid->column('pre_packaged_food');
            $grid->column('area');
            $grid->column('address');
            $grid->column('mobile');
            $grid->column('business_hours');
            $grid->column('lng');
            $grid->column('lat');
            $grid->column('status');
            $grid->column('created_at');
            $grid->column('updated_at')->sortable();

            // 快捷搜索
            $grid->quickSearch(['name', 'mobile'])->placeholder('请输入[姓名|手机号|身份证号码]')->width(25);

            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel(); // 更改为 panel 布局
                $filter->expand(); // 默认展开搜索框

                $filter->like('name')->width(3);
                $filter->like('mobile')->width(3);
            });

            // 行按钮控制
            $grid->disableDeleteButton(); // 禁用删除按钮

            // 工具栏按钮控制
            $grid->disableBatchDelete(); // 禁用批量删除
        });
    }

    /**
     * Make a show builder.
     *
     * @param  mixed  $id
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new PharmacyRepository(), function (Show $show) {
            $show->field('id')->width(4);
            $show->field('name')->width(4);
            $show->field('business_license')->width(4);
            $show->field('drug_biz_license')->width(4);
            $show->field('food_biz_license')->width(4);
            $show->field('med_device_biz_license')->width(4);
            $show->field('drug_info_service_cert')->width(4);
            $show->field('pre_packaged_food')->width(4);
            $show->field('area')->width(4);
            $show->field('address')->width(4);
            $show->field('mobile')->width(4);
            $show->field('business_hours')->width(4);
            $show->field('lng')->width(4);
            $show->field('lat')->width(4);
            $show->field('status')->width(4);
            $show->field('created_at')->width(4);
            $show->field('updated_at')->width(4);

            $show->panel()->tools(function ($tools) {
                $tools->disableDelete(); // 禁止删除按钮
            });
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new PharmacyRepository(), function (Form $form) {
            $form->display('id')->width(4);
            $form->text('name')->width(4);
            $form->image('business_license')->accept('jpg,png,jpeg')->uniqueName()->autoUpload()->retainable()->removable(false)->width(4);
            $form->image('drug_biz_license')->accept('jpg,png,jpeg')->uniqueName()->autoUpload()->retainable()->removable(false)->width(4);
            $form->image('food_biz_license')->accept('jpg,png,jpeg')->uniqueName()->autoUpload()->retainable()->removable(false)->width(4);
            $form->image('med_device_biz_license')->accept('jpg,png,jpeg')->uniqueName()->autoUpload()->retainable()->removable(false)->width(4);
            $form->image('drug_info_service_cert')->accept('jpg,png,jpeg')->uniqueName()->autoUpload()->retainable()->removable(false)->width(4);
            $form->image('pre_packaged_food')->accept('jpg,png,jpeg')->uniqueName()->autoUpload()->retainable()->removable(false)->width(4);
            $form->text('area')->width(4);
            $form->text('address')->width(4);
            $form->text('mobile')->width(4);
            $form->text('business_hours')->width(4);
            $form->text('lng')->width(4);
            $form->text('lat')->width(4);
            $form->switch('status')->width(4);

            $form->display('created_at')->width(4);
            $form->display('updated_at')->width(4);

            // 右上角按钮控制
            $form->disableDeleteButton(); // 去掉删除按钮
        });
    }
}
