<?php

use Dcat\Admin\Admin;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;

Admin::routes();

Route::group([
    'prefix' => config('admin.route.prefix'),
    'namespace' => config('admin.route.namespace'),
    'middleware' => config('admin.route.middleware'),
], function (Router $router) {
    $router->resource('auth/users', 'AdminUserController');
    $router->get('/', 'HomeController@index');

    /** 平台菜单-start **/
    // 药品-诊断
    $router->resource('diagnosi', 'DiagnosiController');
    // 药品-药品
    $router->resource('drug', 'DrugController');
    // 下载导出模板
    $router->get('drug-template', 'DrugController@exportDrugTemplate');
    // 药品-标签
    $router->resource('drug-tag', 'DrugTagController');
    // 药品-单位
    $router->resource('drug-unit', 'DrugUnitController');

    // 问诊-问诊人
    $router->resource('patient', 'PatientController');
    // 问诊-问诊问题
    $router->resource('inquiry', 'InquiryController');

    // 医师-医师
    $router->resource('doctor', 'DoctorController');
    // 医师-医师纠错
    $router->resource('doctor-correction', 'DoctorCorrectionController');

    // 药店-药店列表
    $router->resource('pharmacy', 'PharmacyController');
    // 药店-药师
    $router->resource('pharmacist', 'PharmacistController');
    // 药店-药店纠错
    $router->resource('pharmacy-correction', 'PharmacyCorrectionController');
    // 下载导出模板
    $router->get('pharmacy-template', 'PharmacyController@exportPharmacyTemplate');

    // 处方-处方列表
    $router->resource('prescription', 'PrescriptionController');
    // 处方-处方日志
    $router->resource('prescription-log', 'PrescriptionLogController');
    // 处方-外部处方列表
    $router->resource('external-prescription', 'ExternalPrescriptionController');

    // 系统-设置
    $router->resource('site-config', 'SiteConfigController');

    // 导入日志
    $router->resource('/import-log', 'Common\ImportLogController')->names('import-log');
    /** 平台菜单-end **/

    /** 药店菜单-start **/
    // 默认判断只有药店管理员角色才能访问
    Route::group([
        'middleware' => 'admin.permission:allow,pharmacy',
    ], function ($router) {
        // 药品管理
        $router->resource('pharmacy-drug', 'PharmacyDrugController');
        // 处方打印
        $router->resource('prescription-print', 'PrescriptionPrintController');
        // 用法用量
        $router->resource('dosage', 'DosageController');
        // 下载导出模板
        $router->get('dosage-template', 'DosageController@exportDosageTemplate');
        // 搜索生成处方单
        $router->post('prescription-search', 'PrescriptionPrintController@search');
        // 打印处方单
        $router->get('/print', 'PrintController@print');
        // 药店-设置
        $router->resource('pharmacy-config', 'PharmacyConfigController');
        // 药店-外部处方单
        $router->resource('pharmacy-external-prescription', 'PharmacyExternalPrescriptionController');
    });
    $router->get('/auth/smscode', 'AuthController@getLoginSmsCode');
    /** 药店菜单-end **/
});
