<?php

namespace App\Admin\Extensions\ToolBar\Forms;

use App\Models\DosageModel;
use App\Models\ExternalPrescriptionModel;
use Dcat\Admin\Admin;
use Dcat\Admin\Http\JsonResponse;
use Dcat\Admin\Widgets\Form;
use Dcat\EasyExcel\Excel;
use Dcat\EasyExcel\Support\SheetCollection;
use Illuminate\Support\Facades\Log;
use Exception;

set_time_limit(1800);
ini_set('memory_limit', '-1');
ini_set('max_execution_time', 10800);
ini_set('max_input_time', 10800);


class ExternalPrescriptionImportForm extends Form
{
    /**
     * 处理表单提交逻辑.
     */
    public function handle(array $input): JsonResponse
    {
       // 表单参数
       $file = $input['import_file'];
       $filePath = storage_path('app/'.$file);
       // Log::info("====>".$filePath);
       try {
           // 每100行数据为一批数据进行读取
           $chunkSize = 10;
           $successNum = 0;
           $failNum = 0;
           $data = Excel::import($filePath)->sheet('处方明细列表')->toArray();
           if(!empty($data) && is_array($data)){
                // 判断处方单编号是会否重复，如果重复需进行合并药品数据
                $prescriptions = [];
                foreach($data as $row){
                    $prescriptionNo = $row['处方编号'];
                    $drug_info['drug_name'] = $row['药品名称'];
                    $drug_info['drug_spec'] = $row['药品规格'];
                    $drug_info['drug_num'] = $row['药品数量'];
                    if(!isset($prescriptions[$prescriptionNo])){
                        $prescriptions[$prescriptionNo] = $row;
                    }
                    $prescriptions[$prescriptionNo]['药品明细'][] = $drug_info;
                }
                Log::info("prescriptions====>".json_encode($prescriptions));
           }
           
           $return = $this->response()->success("导入成功{$successNum}条")->refresh();
           unlink($filePath);
       } catch (Exception $e) {
           $return = $this->response()->error("导入失败{$failNum}条：".$e->getMessage());
       }

       return $return;
    }

    /**
     * 构造表单.
     */
    public function form()
    {
        $this->file('import_file', '文件')
            ->disk('local')
            ->accept('xlsx,csv')
            ->maxSize(1024 * 30)
            ->autoUpload()
            ->uniqueName()
            ->required()
            ->help("导入要求：<br />
                   <span style='color:red;'>
                   1、支持xlsx、csv两种格式
                   </span>");
        // $downloadUrl = admin_url('dosage-template');
        // $this->html("<a target='_blank' href='{$downloadUrl}'>下载用法用量导入模板</a>");
    }
}