import streamlit as st
from PIL import Image
import io,os,json
import numpy as np 
import pandas as pd
from pdf2image import convert_from_path 
from datetime import datetime
from db import dbModel
import fitz 
import appbuilder
from pathlib import Path
# 设置文心一言图片分辨率最大4000
RESOLUTION = 4000
dpi = 200
file_directory = r"\output\pdf"
image_directory = './output/convert/'
upload_pdf_directory = r"upload\pdf"

def get_current_datetime():
    # 获取当前时间  
    now = datetime.now()  
    # 格式化时间字符串  
    formatted_time = now.strftime("%Y%m%d%H%M%S") 
    return formatted_time


def covert2pic(file_path, zoom, png_path):
    now = get_current_datetime()
    doc = fitz.open(file_path)
    total = doc.page_count
    image_list = []
    for pg in range(total):
        page = doc[pg]
        zoom = int(zoom)  # 值越大，分辨率越高，文件越清晰
        rotate = int(0)

        trans = fitz.Matrix(zoom / 100.0, zoom / 100.0).prerotate(rotate)
        pm = page.get_pixmap(matrix=trans, alpha=False)
        if not os.path.exists(png_path):
            os.mkdir(png_path)
        save_path = os.path.join(png_path, f"{now}_{pg}.png")
        image_list.append(save_path)
        pm.save(save_path)
    doc.close()
    return image_list
        
        
def wx_image_parser(image_path):
    # 配置密钥与应用ID
    os.environ["APPBUILDER_TOKEN"] ="bce-v3/ALTAK-SsXWQJtdNpOuxGOiRm5jo/736adf01c0b6c5d354c9815bfb3b616f3d36736b"
    app_id = "e18c7b93-2d42-478e-9baa-07e36fa67452" 
    # 初始化Agent实例
    builder = appbuilder.AppBuilderClient(app_id)
    # 创建会话ID
    conversation_id = builder.create_conversation()
    # 上传图片
    file_id = builder.upload_local_file(conversation_id, image_path )
    # 识别
    msg = builder.run(conversation_id, '识别出来的内容以json格式返回,商品可能存在多条，货物(商品)信息为list格式可包含多商品,表头信息包含发货人、发货人编号、统一社会信用码、收货人、离境口岸、运抵国、指运港、件数、总毛重、总净重,表体信息包含项号、商品编号、商品名称、规格型号、数量、单位、单价、总价、原产国、目的国、境内货源地、包装种类、数量、毛重、净重,识别不到的信息为空值,并且只有一个表头。', file_ids=[file_id])
    print("助理回答内容：", msg.content.answer)  
    return  msg.content.answer

def main():
    # 防止重复上传
    if "file" not in st.session_state:
        st.session_state["file"] = None
    # 定义一个文件上传的组件  
    uploaded_file = st.file_uploader('文件',type=['pdf']) 
    image_path_list =  []
    now = get_current_datetime()
    # 判空  
    if uploaded_file is not None:
        if st.session_state["file"] == uploaded_file:
            st.write("You have already uploaded this file.")
        else:   
            print(uploaded_file)
            filename = uploaded_file.name
            filetype = os.path.splitext(uploaded_file.name)[1]
            print(filetype)
            script_path = Path(__file__).resolve()
            script_dir = script_path.parent
            full_directory = script_dir / upload_pdf_directory
            file_name = f"{now}{filetype}"
            # file_path = os.path.join(full_directory, "" + now + "."+filetype)
            file_path = full_directory / file_name
            bsolute_file_path = file_path.resolve()
            with open(bsolute_file_path, 'wb') as f:
                f.write(uploaded_file.getbuffer())
            # 上传完成后清空upload
            file_type = uploaded_file.name.split('.')[-1]
            if file_type == 'pdf':
                # pdf转换图片
                # image_list = covert2pic(file_path,480,image_directory)
                
                path_list = str(bsolute_file_path).split('\\')
                print(bsolute_file_path,path_list)
                # 文件记录数据库
                sql = f"INSERT INTO ai_file_parser (file_path,status) VALUES ('{json.dumps(path_list)}',0)"
                file_id = dbModel().insert(sql)
                # 百度智能云appbuilder解析
                # for image_path in image_list:
                #     wx_ai_parser = wx_image_parser(image_path).strip()
                #     print(wx_ai_parser)
                #     sql = f"INSERT INTO ai_image_parser (image_path,wx_ai_parser,file_id) VALUES ('{image_path}','{wx_ai_parser}',{file_id})"
                #     new_id = dbModel().insert(sql)
            else:
                st.text('File type not supported.')
            uploaded_file = None
    else:
        st.text('Please upload a file.')
    
    st.subheader('上传结果:')
    rows = dbModel().selectAll("select * from ai_file_image")
    df = pd.DataFrame(rows)
    for index, row in df.iterrows():
        col1, col2, col3 = st.columns(3)
        with col1:
            st.text(row['id'])  # 显示第一列数据
        with col2:
            st.text(row['file_path'])  # 显示第二列数据
        with col3:
            if st.button('查看详情', key=f'detail_{index}'):
                st.query_params['view']="detail"
                st.query_params['id'] = row['id']
            
        
            
    if len(image_path_list) > 0:
        # 请求百度API接口
        pass

def detail_page(id):
    sql = f"select * from ai_file_image where id={id}"
    result = dbModel().selectOne(sql)
    
    if result is not None:
        if st.button('返回'):
            st.query_params['view']="main"
            st.query_params['id'] = 0
        sql = f"select * from ai_image_parser where file_id={id}"
        rows = dbModel().selectAll(sql)
        for row in rows:
            st.subheader(f"图片：{row['image_path']}")
            image = Image.open(row['image_path'])
            st.image(image, use_column_width=True)
            st.text(f"百度智能云解析：{row['wx_ai_parser']}")   
    else:
        print("None")


view = st.query_params.get('view', '')
if view == "detail":
    id = st.query_params.get('id', 0)
    detail_page(id)
else:
    main()




