import datetime
from applications.extensions import db

class AiPrompt(db.Model):
    __tablename__ = 'ai_prompt'
    id = db.Column(db.Integer, primary_key=True)
    prompt = db.Column(db.Text, nullable=False)
    type = db.Column(db.String(255), nullable=False)
    create_date = db.Column(db.DateTime, default=datetime.datetime.now, onupdate=datetime.datetime.now, comment='创建时间')
    
    
    def __repr__(self):
        return '<User %r>' % self.id
    
    def to_dict(self):
        return {c.name: getattr(self, c.name) for c in self.__table__.columns}
