import os, datetime, time, json
from flask.cli import AppGroup
from applications.extensions import db
from applications.models import AiFileParser
from applications.common.utils.kimi_ai import KimiAi
from applications.common.utils.yiyan_ai import YiyanAi
parser_cli = AppGroup("parser")
@parser_cli.command("kimi_init")

def kimi_init():
    # 常驻脚本扫描数据库中是否存在未解析文件
    window = KimiAi()
    window.open_url('https://kimi.moonshot.cn')
    # print("等待10s,先扫码登录!")
    time.sleep(15)
    
    while True:
        # path_parts = ["D:", "www", "ImageAiParser", "upload", "pdf", "20240812110609.pdf"]  
        # path = os.path.join(*path_parts)
        # print(path)
        db.session.commit()
        file_parser_list = AiFileParser.query.filter(AiFileParser.status==0,AiFileParser.parser_engine=="kimi").all()  
        print(len(file_parser_list),file_parser_list) 
        if len(file_parser_list) > 0 :
            for file_parser in file_parser_list:
                print(file_parser.id, file_parser.file_path)
                path_parts = json.loads(file_parser.file_path)
                if path_parts[0].endswith(':') and not path_parts[0].endswith(os.sep):  
                    path_parts[0] += os.sep 
                path = os.path.join(*path_parts)
                print(path_parts)
                # print(path)
                # exit()
                # prompt = f"现在需要你帮我把编号为{file_parser.file_id}的pdf中表格数据识别解析出来,表格数据存在键值对对应关系,需要包含表头信息(表头信息中包含pdf编号)和表体信息信息(商品list格式),以markdown的json格式输出,只输出解析后的json数据"
                prompt = f"pdf编号：{file_parser.file_id}，解析阅读pdf，识别出来的内容以list[json]格式返回，json中需包含pdf编号,商品可能存在多条，货物(商品)信息为list格式可包含多商品,表头信息包含如下字段发货人、发货人编号、统一社会信用码、收货人、离境口岸、运抵国、指运港、件数、毛重(单位千克，同一框中数字)、净重(单位千克，同一框中数字),表体信息包含如下字段项号、商品编号、商品名称、规格型号、数量、单位、单价、总价、原产国、目的国、境内货源地、包装种类、数量、毛重、净重,识别不到的信息为空值,并且只有一个表头"
                res = window.parser(path, prompt)
                AiFileParser.query.filter_by(id=file_parser.id).update({ "status": 2,"kimi_ai_parser": res.strip()},synchronize_session=False)
                db.session.commit()
            # db.session.expire(AiFileParser)
            time.sleep(10)
        else:
            print("没有未解析文件")
            time.sleep(10)
            continue
        
@parser_cli.command("yiyan_init")

def yiyan_init():
    # 常驻脚本扫描数据库中是否存在未解析文件
    window = YiyanAi()
    window.open_url('https://yiyan.baidu.com/')
    # print("等待40s,先登录!")
    time.sleep(40)
    
    while True:
        # path_parts = ["D:", "www", "ImageAiParser", "upload", "pdf", "20240812110609.pdf"]  
        # path = os.path.join(*path_parts)
        # print(path)
        db.session.commit()
        file_parser_list = AiFileParser.query.filter(AiFileParser.status==0,AiFileParser.parser_engine=="yiyan").all()  
        print(len(file_parser_list),file_parser_list) 
        if len(file_parser_list) > 0 :
            for file_parser in file_parser_list:
                print(file_parser.id, file_parser.file_path)
                path_parts = json.loads(file_parser.file_path)
                if path_parts[0].endswith(':') and not path_parts[0].endswith(os.sep):  
                    path_parts[0] += os.sep 
                path = os.path.join(*path_parts)
                print(path_parts)
                # print(path)
                # exit()
                # prompt = f"现在需要你帮我把编号为{file_parser.file_id}的pdf中表格数据识别解析出来,表格数据存在键值对对应关系,需要包含表头信息(表头信息中包含pdf编号)和表体信息信息(商品list格式),以markdown的json格式输出,只输出解析后的json数据"
                # prompt = f"pdf编号：{file_parser.file_id}，解析阅读pdf，识别出来的内容以list[json]格式返回，json中需包含pdf编号,商品可能存在多条，货物(商品)信息为list格式可包含多商品,表头信息包含如下字段发货人、发货人编号、统一社会信用码、收货人、离境口岸、运抵国、指运港、件数、毛重(单位千克，同一框中数字)、净重(单位千克，同一框中数字),表体信息包含如下字段项号、商品编号、商品名称、规格型号、数量、单位、单价、总价、原产国、目的国、境内货源地、包装种类、数量、毛重、净重,识别不到的信息为空值,并且只有一个表头"
                prompt = f"pdf编号：{file_parser.file_id}，解析阅读pdf理解pdf中报关单表格信息，识别出来的内容以list[json]格式返回，json中需包含pdf编号,报关单商品详情可能存在多条，报关单商品详情为list格式可包含多商品,报关单头部信息包含如下字段 ：发货人、统一社会信用码（由18位数字或大写拉丁字母组成）、收货人、件数（纯数字）、毛重(千克)、净重(千克),报关单商品详情包含如下字段：项号、商品编号、商品名称、规格型号、数量(纯数字包括浮点型)、单位（千克、kg、pcs、个）、单价（纯数字包含浮点型）、总价（纯数字包含浮点型）、货币（USD、RMB等）、原产国、毛重、净重......,识别不到的信息为空值。"
                res = window.parser(path, prompt)
                AiFileParser.query.filter_by(id=file_parser.id).update({ "status": 2,"kimi_ai_parser": res.strip()},synchronize_session=False)
                db.session.commit()
            # db.session.expire(AiFileParser)
            time.sleep(10)
        else:
            print("没有未解析文件")
            time.sleep(10)
            continue       

@parser_cli.command("")

def test():
    while True:
        db.session.commit()
        file_parser_list = db.session.query(AiFileParser).filter(AiFileParser.status==0).all()  
        print(len(file_parser_list),file_parser_list) 
        # print(len(file_parser_list),file_parser_list) 
        if len(file_parser_list) > 0 :
            for file_parser in file_parser_list:
                print(file_parser.id, file_parser.file_path)
        
        
        time.sleep(5)