from flask import Flask, request, jsonify  
import os, requests, base64
from pathlib import Path
from datetime import datetime
from model import AiFileParser
from flask_sqlalchemy import SQLAlchemy  
db = SQLAlchemy()
def create_app():  
    app = Flask(__name__)  
    app.config['SQLALCHEMY_DATABASE_URI'] = 'mysql+pymysql://root:Imohe@2023@192.168.3.151:3306/image_ai_parser'  
    app.config['SQLALCHEMY_TRACK_MODIFICATIONS'] = False  
  
    db.init_app(app)  
  
    # 其他配置和初始化...  
  
    return app  

upload_pdf_directory = r"upload\pdf"
script_path = Path(__file__).resolve()
script_dir = script_path.parent
full_directory = script_dir / upload_pdf_directory


app = create_app()

@app.route("/")
def index():
    a_list = AiFileParser.query.filter().all()
    print(a_list)
    return "<p>Hello, World123!123123</p>"


@app.route("/detail/<int:id>")
def detail(id):
    print(id)
    return "123"



@app.route("/upload_page")
def upload_page():
    return "<form action='/upload' method='post'><input type='file' name='file'></form>"


@ app.route("/upload", methods=['POST'])
def upload():
    
    data = request.json  
    base64_pdf = data.get('pdf_base64')  
    file_code = data.get('file_code')  
    print(file_code)
    if base64_pdf is None or file_code is None:  
        return jsonify({'error': 'Missing PDF or file_code'}), 400  
  
    # 检查base64字符串是否以正确的头部开始（可选，但有助于验证输入）  
    if not base64_pdf.startswith('data:application/pdf;base64,'):  
        return jsonify({'error': 'Invalid Base64 string'}), 400  
  
    # 移除Base64字符串的头部（如果存在）  
    base64_pdf = base64_pdf.split(',')[1]  
  
    # 解码Base64字符串为二进制数据  
    pdf_data = base64.b64decode(base64_pdf)  
    now = get_current_datetime()
    # 指定文件保存的路径（这里只是示例，你可能需要根据你的应用进行调整）  
    file_name = f"{now}.pdf"
    # file_path = os.path.join(full_directory, "" + now + "."+filetype)
    if not os.path.exists(full_directory):  
        os.makedirs(full_directory)  
    # full_path = os.path.join(bsolute_file_path, filename)  
    file_path = full_directory / file_name
    bsolute_file_path = file_path.resolve() 
    # 将解码后的数据写入文件  
    with open(bsolute_file_path, 'wb') as file:  
        file.write(pdf_data)  
    path_list = str(bsolute_file_path).split('\\')
    
    return jsonify({'message': 'PDF uploaded successfully', 'path_list': path_list}), 200 

def get_current_datetime():
    # 获取当前时间  
    now = datetime.now()  
    # 格式化时间字符串  
    formatted_time = now.strftime("%Y%m%d%H%M%S") 
    return formatted_time

