# GUI Application automation and testing library
# Copyright (C) 2006-2018 Mark Mc Mahon and Contributors
# https://github.com/pywinauto/pywinauto/graphs/contributors
# http://pywinauto.readthedocs.io/en/latest/credits.html
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice, this
#   list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
# * Neither the name of pywinauto nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# generated by 'xml2py'
# flags 'commctrl.xml -d -w -kde -v -o win32defines.py'

"""Definition of Windows defines"""
from __future__ import unicode_literals
from ctypes import c_int
import win32con

__revision__ = "$Revision$"



ABE_LEFT   = 0 # Variable c_int
ABE_TOP    = 1 # Variable c_int
ABE_RIGHT  = 2 # Variable c_int
ABE_BOTTOM = 3 # Variable c_int

ABM_NEW              = 0 # Variable c_int
ABM_REMOVE           = 1 # Variable c_int
ABM_QUERYPOS         = 2 # Variable c_int
ABM_SETPOS           = 3 # Variable c_int
ABM_GETSTATE         = 4 # Variable c_int
ABM_GETTASKBARPOS    = 5 # Variable c_int
ABM_ACTIVATE         = 6 # Variable c_int
ABM_GETAUTOHIDEBAR   = 7 # Variable c_int
ABM_SETAUTOHIDEBAR   = 8 # Variable c_int
ABM_WINDOWPOSCHANGED = 9 # Variable c_int

ABN_STATECHANGE   = 0 # Variable c_int
ABN_POSCHANGED    = 1 # Variable c_int
ABN_FULLSCREENAPP = 2 # Variable c_int
ABN_WINDOWARRANGE = 3 # Variable c_int

ABS_AUTOHIDE    = 1 # Variable c_int
ABS_ALWAYSONTOP = 2 # Variable c_int

ACCESS_OBJECT_GUID               = 0 # Variable c_int
ACCESS_MIN_MS_ACE_TYPE           = 0 # Variable c_int
ACCESS_ALLOWED_ACE_TYPE          = win32con.ACCESS_ALLOWED_ACE_TYPE # 0
ACCESS_PROPERTY_SET_GUID         = 1 # Variable c_int
ACCESS_DENIED_ACE_TYPE           = win32con.ACCESS_DENIED_ACE_TYPE # 1
ACCESS_PROPERTY_GUID             = 2 # Variable c_int
ACCESS_MAX_MS_V2_ACE_TYPE        = 3 # Variable c_int
ACCESS_MAX_LEVEL                 = 4 # Variable c_int
ACCESS_ALLOWED_COMPOUND_ACE_TYPE = 4 # Variable c_int
ACCESS_MAX_MS_V3_ACE_TYPE        = 4 # Variable c_int
ACCESS_MIN_MS_OBJECT_ACE_TYPE    = 5 # Variable c_int
ACCESS_ALLOWED_OBJECT_ACE_TYPE   = 5 # Variable c_int
ACCESS_DENIED_OBJECT_ACE_TYPE    = 6 # Variable c_int
ACCESS_MAX_MS_ACE_TYPE           = 8 # Variable c_int
ACCESS_MAX_MS_V4_ACE_TYPE        = 8 # Variable c_int
ACCESS_MAX_MS_OBJECT_ACE_TYPE    = 8 # Variable c_int
ACCESS_SYSTEM_SECURITY           = win32con.ACCESS_SYSTEM_SECURITY # 16777216
ACCESS_DS_SOURCE_A               = 'DS' # Variable POINTER(c_char)
ACCESS_DS_SOURCE_W               = 'DS' # Variable POINTER(c_wchar)
ACCESS_DS_OBJECT_TYPE_NAME_A     = 'Directory Service Object' # Variable POINTER(c_char)
ACCESS_DS_OBJECT_TYPE_NAME_W     = 'Directory Service Object' # Variable POINTER(c_wchar)

ACE_OBJECT_TYPE_PRESENT           = 1 # Variable c_int
ACE_INHERITED_OBJECT_TYPE_PRESENT = 2 # Variable c_int

ACL_REVISION1   = win32con.ACL_REVISION1 # 1
ACL_REVISION2   = win32con.ACL_REVISION2 # 2
ACL_REVISION    = win32con.ACL_REVISION # 2
ACL_REVISION3   = 3 # Variable c_int
ACL_REVISION_DS = 4 # Variable c_int
ACL_REVISION4   = 4 # Variable c_int

ACM_OPENA = 1124 # Variable c_int
ACM_PLAY  = 1125 # Variable c_int
ACM_STOP  = 1126 # Variable c_int
ACM_OPENW = 1127 # Variable c_int

ACN_START = 1 # Variable c_int
ACN_STOP  = 2 # Variable c_int

ACS_CENTER      = 1 # Variable c_int
ACS_TRANSPARENT = 2 # Variable c_int
ACS_AUTOPLAY    = 4 # Variable c_int
ACS_TIMER       = 8 # Variable c_int

ACTFLG_RunLocally  = 1 # Variable c_int
ACTFLG_RunOnce     = 2 # Variable c_int
ACTFLG_SystemWide  = 4 # Variable c_int
ACTFLG_Published   = 8 # Variable c_int
ACTFLG_Assigned    = 16 # Variable c_int
ACTFLG_UserInstall = 32 # Variable c_int

ACTIVEOBJECT_STRONG = 0 # Variable c_int
ACTIVEOBJECT_WEAK   = 1 # Variable c_int

AC_SRC_OVER             = win32con.AC_SRC_OVER # 0
AC_LINE_OFFLINE         = win32con.AC_LINE_OFFLINE # 0
AC_LINE_ONLINE          = win32con.AC_LINE_ONLINE # 1
AC_SRC_NO_PREMULT_ALPHA = 1 # Variable c_int
AC_SRC_NO_ALPHA         = 2 # Variable c_int
AC_LINE_BACKUP_POWER    = win32con.AC_LINE_BACKUP_POWER # 2
AC_DST_NO_PREMULT_ALPHA = 16 # Variable c_int
AC_DST_NO_ALPHA         = 32 # Variable c_int
AC_LINE_UNKNOWN         = win32con.AC_LINE_UNKNOWN # 255

ADVFCACHE_NOHANDLER    = 8
ADVFCACHE_FORCEBUILTIN = 16
ADVFCACHE_ONSAVE       = 32

ADVF_NODATA     = 1
ADVF_PRIMEFIRST = 2
ADVF_ONLYONCE   = 4
ADVF_DATAONSTOP = 64

AD_COUNTERCLOCKWISE = win32con.AD_COUNTERCLOCKWISE # 1
AD_CLOCKWISE        = win32con.AD_CLOCKWISE # 2

AF_UNSPEC    = 0 # Variable c_int
AF_UNIX      = 1 # Variable c_int
AF_INET      = 2 # Variable c_int
AF_IMPLINK   = 3 # Variable c_int
AF_PUP       = 4 # Variable c_int
AF_CHAOS     = 5 # Variable c_int
AF_IPX       = 6 # Variable c_int
AF_NS        = 6 # Variable c_int
AF_ISO       = 7 # Variable c_int
AF_ECMA      = 8 # Variable c_int
AF_DATAKIT   = 9 # Variable c_int
AF_CCITT     = 10 # Variable c_int
AF_SNA       = 11 # Variable c_int
AF_DECnet    = 12 # Variable c_int
AF_DLI       = 13 # Variable c_int
AF_LAT       = 14 # Variable c_int
AF_HYLINK    = 15 # Variable c_int
AF_APPLETALK = 16 # Variable c_int
AF_NETBIOS   = 17 # Variable c_int
AF_VOICEVIEW = 18 # Variable c_int
AF_FIREFOX   = 19 # Variable c_int
AF_UNKNOWN1  = 20 # Variable c_int
AF_BAN       = 21 # Variable c_int
AF_MAX       = 22 # Variable c_int

ALL_TRANSPORTS = 'M\x00\x00\x00' # Variable POINTER(c_char)

ANIMATE_CLASSA = 'SysAnimate32' # Variable POINTER(c_char)
ANIMATE_CLASSW = 'SysAnimate32' # Variable POINTER(c_wchar)

ANSI_NULL       = 0 # Variable c_char
ANSI_CHARSET    = win32con.ANSI_CHARSET # 0
ANSI_FIXED_FONT = win32con.ANSI_FIXED_FONT # 11
ANSI_VAR_FONT   = win32con.ANSI_VAR_FONT # 12

ANTIALIASED_QUALITY = win32con.ANTIALIASED_QUALITY # 4

ANYSIZE_ARRAY = 1 # Variable c_int

APD_STRICT_UPGRADE   = 1 # Variable c_int
APD_STRICT_DOWNGRADE = 2 # Variable c_int
APD_COPY_ALL_FILES   = 4 # Variable c_int
APD_COPY_NEW_FILES   = 8 # Variable c_int

APPCLASS_STANDARD = 0 # Variable c_long
APPCLASS_MONITOR  = 1 # Variable c_long
APPCLASS_MASK     = 15 # Variable c_long

APPCMD_CLIENTONLY  = 16 # Variable c_long
APPCMD_FILTERINITS = 32 # Variable c_long
APPCMD_MASK        = 4080 # Variable c_long

APPINFO_PUBLISHED  = 1
APPINFO_SHELLNEW   = 2
APPINFO_INSERTABLE = 3

APPLICATION_ERROR_MASK = win32con.APPLICATION_ERROR_MASK # 536870912

ARABIC_CHARSET = win32con.ARABIC_CHARSET # 178

ARW_LEFT        = win32con.ARW_LEFT # 0
ARW_RIGHT       = win32con.ARW_RIGHT # 0
ARW_BOTTOMLEFT  = win32con.ARW_BOTTOMLEFT # 0
ARW_BOTTOMRIGHT = win32con.ARW_BOTTOMRIGHT # 1
ARW_STARTRIGHT  = win32con.ARW_STARTRIGHT # 1
ARW_TOPLEFT     = win32con.ARW_TOPLEFT # 2
ARW_STARTTOP    = win32con.ARW_STARTTOP # 2
ARW_STARTMASK   = win32con.ARW_STARTMASK # 3
ARW_TOPRIGHT    = win32con.ARW_TOPRIGHT # 3
ARW_DOWN        = win32con.ARW_DOWN # 4
ARW_UP          = win32con.ARW_UP # 4
ARW_HIDE        = win32con.ARW_HIDE # 8

ASPECT_FILTERING = win32con.ASPECT_FILTERING # 1

ASYNC_MODE_DEFAULT       = 0 # Variable c_long
ASYNC_MODE_COMPATIBILITY = 1 # Variable c_long

ATF_TIMEOUTON     = win32con.ATF_TIMEOUTON # 1
ATF_ONOFFFEEDBACK = win32con.ATF_ONOFFFEEDBACK # 2

ATTR_INPUT               = 0 # Variable c_int
ATTR_TARGET_CONVERTED    = 1 # Variable c_int
ATTR_CONVERTED           = 2 # Variable c_int
ATTR_TARGET_NOTCONVERTED = 3 # Variable c_int
ATTR_INPUT_ERROR         = 4 # Variable c_int
ATTR_FIXEDCONVERTED      = 5 # Variable c_int

AUDIT_ALLOW_NO_PRIVILEGE = 1 # Variable c_int

AUXCAPS_VOLUME   = 1 # Variable c_int
AUXCAPS_CDAUDIO  = 1 # Variable c_int
AUXCAPS_AUXIN    = 2 # Variable c_int
AUXCAPS_LRVOLUME = 2 # Variable c_int

AUX_MAPPER = 4294967295 # Variable c_uint

BACKGROUND_BLUE      = 16 # Variable c_int
BACKGROUND_GREEN     = 32 # Variable c_int
BACKGROUND_RED       = 64 # Variable c_int
BACKGROUND_INTENSITY = 128 # Variable c_int

BACKUP_INVALID        = win32con.BACKUP_INVALID # 0
BACKUP_DATA           = win32con.BACKUP_DATA # 1
BACKUP_EA_DATA        = win32con.BACKUP_EA_DATA # 2
BACKUP_SECURITY_DATA  = win32con.BACKUP_SECURITY_DATA # 3
BACKUP_ALTERNATE_DATA = win32con.BACKUP_ALTERNATE_DATA # 4
BACKUP_LINK           = win32con.BACKUP_LINK # 5
BACKUP_PROPERTY_DATA  = win32con.BACKUP_PROPERTY_DATA # 6
BACKUP_OBJECT_ID      = win32con.BACKUP_OBJECT_ID # 7
BACKUP_REPARSE_DATA   = win32con.BACKUP_REPARSE_DATA # 8
BACKUP_SPARSE_BLOCK   = win32con.BACKUP_SPARSE_BLOCK # 9

BALTIC_CHARSET = win32con.BALTIC_CHARSET # 186

BATTERY_FLAG_HIGH          = win32con.BATTERY_FLAG_HIGH # 1
BATTERY_FLAG_LOW           = win32con.BATTERY_FLAG_LOW # 2
BATTERY_FLAG_CRITICAL      = win32con.BATTERY_FLAG_CRITICAL # 4
BATTERY_FLAG_CHARGING      = win32con.BATTERY_FLAG_CHARGING # 8
BATTERY_FLAG_NO_BATTERY    = win32con.BATTERY_FLAG_NO_BATTERY # 128
BATTERY_FLAG_UNKNOWN       = win32con.BATTERY_FLAG_UNKNOWN # 255
BATTERY_PERCENTAGE_UNKNOWN = win32con.BATTERY_PERCENTAGE_UNKNOWN # 255
BATTERY_LIFE_UNKNOWN       = win32con.BATTERY_LIFE_UNKNOWN # -1

BAUD_075    = 1 # Variable c_ulong
BAUD_110    = 2 # Variable c_ulong
BAUD_134_5  = 4 # Variable c_ulong
BAUD_150    = 8 # Variable c_ulong
BAUD_300    = 16 # Variable c_ulong
BAUD_600    = 32 # Variable c_ulong
BAUD_1200   = 64 # Variable c_ulong
BAUD_1800   = 128 # Variable c_ulong
BAUD_2400   = 256 # Variable c_ulong
BAUD_4800   = 512 # Variable c_ulong
BAUD_7200   = 1024 # Variable c_ulong
BAUD_9600   = 2048 # Variable c_ulong
BAUD_14400  = 4096 # Variable c_ulong
BAUD_19200  = 8192 # Variable c_ulong
BAUD_38400  = 16384 # Variable c_ulong
BAUD_56K    = 32768 # Variable c_ulong
BAUD_128K   = 65536 # Variable c_ulong
BAUD_115200 = 131072 # Variable c_ulong
BAUD_57600  = 262144 # Variable c_ulong
BAUD_USER   = 268435456 # Variable c_ulong

BDR_RAISEDOUTER = win32con.BDR_RAISEDOUTER # 1
BDR_SUNKENOUTER = win32con.BDR_SUNKENOUTER # 2
BDR_OUTER       = win32con.BDR_OUTER # 3
BDR_RAISEDINNER = win32con.BDR_RAISEDINNER # 4
BDR_SUNKENINNER = win32con.BDR_SUNKENINNER # 8
BDR_INNER       = win32con.BDR_INNER # 12

BEGIN_PATH = win32con.BEGIN_PATH # 4096

BF_LEFT                    = win32con.BF_LEFT # 1
BF_TOP                     = win32con.BF_TOP # 2
BF_TOPLEFT                 = win32con.BF_TOPLEFT # 3
BF_RIGHT                   = win32con.BF_RIGHT # 4
BF_TOPRIGHT                = win32con.BF_TOPRIGHT # 6
BF_BOTTOM                  = win32con.BF_BOTTOM # 8
BF_BOTTOMLEFT              = win32con.BF_BOTTOMLEFT # 9
BF_BOTTOMRIGHT             = win32con.BF_BOTTOMRIGHT # 12
BF_RECT                    = win32con.BF_RECT # 15
BF_DIAGONAL                = win32con.BF_DIAGONAL # 16
BF_DIAGONAL_ENDTOPLEFT     = win32con.BF_DIAGONAL_ENDTOPLEFT # 19
BF_DIAGONAL_ENDTOPRIGHT    = win32con.BF_DIAGONAL_ENDTOPRIGHT # 22
BF_DIAGONAL_ENDBOTTOMLEFT  = win32con.BF_DIAGONAL_ENDBOTTOMLEFT # 25
BF_DIAGONAL_ENDBOTTOMRIGHT = win32con.BF_DIAGONAL_ENDBOTTOMRIGHT # 28
BF_MIDDLE                  = win32con.BF_MIDDLE # 2048
BF_SOFT                    = win32con.BF_SOFT # 4096
BF_ADJUST                  = win32con.BF_ADJUST # 8192
BF_FLAT                    = win32con.BF_FLAT # 16384
BF_MONO                    = win32con.BF_MONO # 32768

BINDF_ASYNCHRONOUS             = 1
BINDF_ASYNCSTORAGE             = 2
BINDF_NOPROGRESSIVERENDERING   = 4
BINDF_OFFLINEOPERATION         = 8
BINDF_GETNEWESTVERSION         = 16
BINDF_NOWRITECACHE             = 32
BINDF_NEEDFILE                 = 64
BINDF_PULLDATA                 = 128
BINDF_IGNORESECURITYPROBLEM    = 256
BINDF_RESYNCHRONIZE            = 512
BINDF_HYPERLINK                = 1024
BINDF_NO_UI                    = 2048
BINDF_SILENTOPERATION          = 4096
BINDF_PRAGMA_NO_CACHE          = 8192
BINDF_FREE_THREADED            = 65536
BINDF_DIRECT_READ              = 131072
BINDF_FORMS_SUBMIT             = 262144
BINDF_GETFROMCACHE_IF_NET_FAIL = 524288

BINDINFOF_URLENCODESTGMEDDATA = 1
BINDINFOF_URLENCODEDEXTRAINFO = 2

BINDSPEED_INDEFINITE = 1
BINDSPEED_MODERATE   = 2
BINDSPEED_IMMEDIATE  = 3

BINDSTATUS_FINDINGRESOURCE           = 1
BINDSTATUS_CONNECTING                = 2
BINDSTATUS_REDIRECTING               = 3
BINDSTATUS_BEGINDOWNLOADDATA         = 4
BINDSTATUS_DOWNLOADINGDATA           = 5
BINDSTATUS_ENDDOWNLOADDATA           = 6
BINDSTATUS_BEGINDOWNLOADCOMPONENTS   = 7
BINDSTATUS_INSTALLINGCOMPONENTS      = 8
BINDSTATUS_ENDDOWNLOADCOMPONENTS     = 9
BINDSTATUS_USINGCACHEDCOPY           = 10
BINDSTATUS_SENDINGREQUEST            = 11
BINDSTATUS_CLASSIDAVAILABLE          = 12
BINDSTATUS_MIMETYPEAVAILABLE         = 13
BINDSTATUS_CACHEFILENAMEAVAILABLE    = 14
BINDSTATUS_BEGINSYNCOPERATION        = 15
BINDSTATUS_ENDSYNCOPERATION          = 16
BINDSTATUS_BEGINUPLOADDATA           = 17
BINDSTATUS_UPLOADINGDATA             = 18
BINDSTATUS_ENDUPLOADDATA             = 19
BINDSTATUS_PROTOCOLCLASSID           = 20
BINDSTATUS_ENCODING                  = 21
BINDSTATUS_VERIFIEDMIMETYPEAVAILABLE = 22
BINDSTATUS_CLASSINSTALLLOCATION      = 23
BINDSTATUS_DECODING                  = 24
BINDSTATUS_LOADINGMIMEHANDLER        = 25

BINDSTRING_HEADERS          = 1
BINDSTRING_ACCEPT_MIMES     = 2
BINDSTRING_EXTRA_URL        = 3
BINDSTRING_LANGUAGE         = 4
BINDSTRING_USERNAME         = 5
BINDSTRING_PASSWORD         = 6
BINDSTRING_UA_PIXELS        = 7
BINDSTRING_UA_COLOR         = 8
BINDSTRING_OS               = 9
BINDSTRING_USER_AGENT       = 10
BINDSTRING_ACCEPT_ENCODINGS = 11
BINDSTRING_POST_COOKIE      = 12
BINDSTRING_POST_DATA_MIME   = 13
BINDSTRING_URL              = 14

BINDVERB_GET    = 0
BINDVERB_POST   = 1
BINDVERB_PUT    = 2
BINDVERB_CUSTOM = 3

BIND_MAYBOTHERUSER     = 1
BIND_JUSTTESTEXISTENCE = 2

BI_RGB       = win32con.BI_RGB # 0
BI_RLE8      = win32con.BI_RLE8 # 1
BI_RLE4      = win32con.BI_RLE4 # 2
BI_BITFIELDS = win32con.BI_BITFIELDS # 3

BKMODE_LAST = win32con.BKMODE_LAST # 2

BLACK_BRUSH = win32con.BLACK_BRUSH # 4
BLACK_PEN   = win32con.BLACK_PEN # 7

BM_GETCHECK = win32con.BM_GETCHECK # 240
BM_SETCHECK = win32con.BM_SETCHECK # 241
BM_GETSTATE = win32con.BM_GETSTATE # 242
BM_SETSTATE = win32con.BM_SETSTATE # 243
BM_SETSTYLE = win32con.BM_SETSTYLE # 244
BM_CLICK    = win32con.BM_CLICK # 245
BM_GETIMAGE = win32con.BM_GETIMAGE # 246
BM_SETIMAGE = win32con.BM_SETIMAGE # 247

BN_CLICKED       = win32con.BN_CLICKED # 0
BN_PAINT         = win32con.BN_PAINT # 1
BN_HILITE        = win32con.BN_HILITE # 2
BN_UNHILITE      = win32con.BN_UNHILITE # 3
BN_DISABLE       = win32con.BN_DISABLE # 4
BN_DOUBLECLICKED = win32con.BN_DOUBLECLICKED # 5
BN_SETFOCUS      = win32con.BN_SETFOCUS # 6
BN_KILLFOCUS     = win32con.BN_KILLFOCUS # 7
BN_DBLCLK        = win32con.BN_DBLCLK
BN_PUSHED        = win32con.BN_PUSHED
BN_UNPUSHED      = win32con.BN_UNPUSHED

BCN_DROPDOWN      = 4294966048
BCN_HOTITEMCHANGE = 4294966047

BOLD_FONTTYPE = win32con.BOLD_FONTTYPE # 256

BROADCAST_QUERY_DENY = win32con.BROADCAST_QUERY_DENY # 1112363332

BSCF_FIRSTDATANOTIFICATION        = 1
BSCF_INTERMEDIATEDATANOTIFICATION = 2
BSCF_LASTDATANOTIFICATION         = 4
BSCF_DATAFULLYAVAILABLE           = 8
BSCF_AVAILABLEDATASIZEUNKNOWN     = 16

BSF_QUERY              = win32con.BSF_QUERY # 1
BSF_IGNORECURRENTTASK  = win32con.BSF_IGNORECURRENTTASK # 2
BSF_FLUSHDISK          = win32con.BSF_FLUSHDISK # 4
BSF_NOHANG             = win32con.BSF_NOHANG # 8
BSF_POSTMESSAGE        = win32con.BSF_POSTMESSAGE # 16
BSF_FORCEIFHUNG        = win32con.BSF_FORCEIFHUNG # 32
BSF_NOTIMEOUTIFNOTHUNG = win32con.BSF_NOTIMEOUTIFNOTHUNG # 64

BSM_ALLCOMPONENTS      = win32con.BSM_ALLCOMPONENTS # 0
BSM_VXDS               = win32con.BSM_VXDS # 1
BSM_NETDRIVER          = win32con.BSM_NETDRIVER # 2
BSM_INSTALLABLEDRIVERS = win32con.BSM_INSTALLABLEDRIVERS # 4
BSM_APPLICATIONS       = win32con.BSM_APPLICATIONS # 8
BSM_ALLDESKTOPS        = win32con.BSM_ALLDESKTOPS # 16

BST_UNCHECKED     = win32con.BST_UNCHECKED # 0
BST_CHECKED       = win32con.BST_CHECKED # 1
BST_INDETERMINATE = win32con.BST_INDETERMINATE # 2
BST_PUSHED        = win32con.BST_PUSHED # 4
BST_FOCUS         = win32con.BST_FOCUS # 8

BS_SOLID           = win32con.BS_SOLID # 0
BS_TEXT            = win32con.BS_TEXT # 0
BS_PUSHBUTTON      = win32con.BS_PUSHBUTTON # 0
BS_NULL            = win32con.BS_NULL # 1
BS_DEFPUSHBUTTON   = win32con.BS_DEFPUSHBUTTON # 1
BS_HATCHED         = win32con.BS_HATCHED # 2
BS_CHECKBOX        = win32con.BS_CHECKBOX # 2
BS_PATTERN         = win32con.BS_PATTERN # 3
BS_AUTOCHECKBOX    = win32con.BS_AUTOCHECKBOX # 3
BS_INDEXED         = win32con.BS_INDEXED # 4
BS_RADIOBUTTON     = win32con.BS_RADIOBUTTON # 4
BS_DIBPATTERN      = win32con.BS_DIBPATTERN # 5
BS_3STATE          = win32con.BS_3STATE # 5
BS_DIBPATTERNPT    = win32con.BS_DIBPATTERNPT # 6
BS_AUTO3STATE      = win32con.BS_AUTO3STATE # 6
BS_PATTERN8X8      = win32con.BS_PATTERN8X8 # 7
BS_GROUPBOX        = win32con.BS_GROUPBOX # 7
BS_DIBPATTERN8X8   = win32con.BS_DIBPATTERN8X8 # 8
BS_USERBUTTON      = win32con.BS_USERBUTTON # 8
BS_MONOPATTERN     = 9 # Variable c_int
BS_AUTORADIOBUTTON = win32con.BS_AUTORADIOBUTTON # 9
BS_OWNERDRAW       = win32con.BS_OWNERDRAW # 11
BS_COMMANDLINK     = 14
BS_LEFTTEXT        = win32con.BS_LEFTTEXT # 32
BS_ICON            = win32con.BS_ICON # 64
BS_BITMAP          = win32con.BS_BITMAP # 128
BS_LEFT            = win32con.BS_LEFT # 256
BS_RIGHT           = win32con.BS_RIGHT # 512
BS_CENTER          = win32con.BS_CENTER # 768
BS_TOP             = win32con.BS_TOP # 1024
BS_BOTTOM          = win32con.BS_BOTTOM # 2048
BS_VCENTER         = win32con.BS_VCENTER # 3072
BS_PUSHLIKE        = win32con.BS_PUSHLIKE # 4096
BS_MULTILINE       = win32con.BS_MULTILINE # 8192
BS_NOTIFY          = win32con.BS_NOTIFY # 16384
BS_FLAT            = win32con.BS_FLAT # 32768

C1_UPPER  = 1 # Variable c_int
C1_LOWER  = 2 # Variable c_int
C1_DIGIT  = 4 # Variable c_int
C1_SPACE  = 8 # Variable c_int
C1_PUNCT  = 16 # Variable c_int
C1_CNTRL  = 32 # Variable c_int
C1_BLANK  = 64 # Variable c_int
C1_XDIGIT = 128 # Variable c_int
C1_ALPHA  = 256 # Variable c_int

C2_NOTAPPLICABLE    = 0 # Variable c_int
C2_LEFTTORIGHT      = 1 # Variable c_int
C2_RIGHTTOLEFT      = 2 # Variable c_int
C2_EUROPENUMBER     = 3 # Variable c_int
C2_EUROPESEPARATOR  = 4 # Variable c_int
C2_EUROPETERMINATOR = 5 # Variable c_int
C2_ARABICNUMBER     = 6 # Variable c_int
C2_COMMONSEPARATOR  = 7 # Variable c_int
C2_BLOCKSEPARATOR   = 8 # Variable c_int
C2_SEGMENTSEPARATOR = 9 # Variable c_int
C2_WHITESPACE       = 10 # Variable c_int
C2_OTHERNEUTRAL     = 11 # Variable c_int

C3_NOTAPPLICABLE = 0 # Variable c_int
C3_NONSPACING    = 1 # Variable c_int
C3_DIACRITIC     = 2 # Variable c_int
C3_VOWELMARK     = 4 # Variable c_int
C3_SYMBOL        = 8 # Variable c_int
C3_KATAKANA      = 16 # Variable c_int
C3_HIRAGANA      = 32 # Variable c_int
C3_HALFWIDTH     = 64 # Variable c_int
C3_FULLWIDTH     = 128 # Variable c_int
C3_IDEOGRAPH     = 256 # Variable c_int
C3_KASHIDA       = 512 # Variable c_int
C3_LEXICAL       = 1024 # Variable c_int
C3_ALPHA         = 32768 # Variable c_int

CACHE_S_FIRST                  = 262512 # Variable c_long
CACHE_S_FORMATETC_NOTSUPPORTED = 262512 # Variable c_long
CACHE_S_SAMECACHE              = 262513 # Variable c_long
CACHE_S_SOMECACHES_NOTUPDATED  = 262514 # Variable c_long
CACHE_S_LAST                   = 262527 # Variable c_long
CACHE_E_FIRST                  = 2147746160 # Variable c_ulong
CACHE_E_LAST                   = 2147746175 # Variable c_ulong
CACHE_E_NOCACHE_UPDATED        = -2147221136 # Variable c_long

CADV_LATEACK = 65535 # Variable c_int

CALLBACK_NULL     = 0 # Variable c_long
CALLBACK_WINDOW   = 65536 # Variable c_long
CALLBACK_TASK     = 131072 # Variable c_long
CALLBACK_THREAD   = 131072 # Variable c_long
CALLBACK_FUNCTION = 196608 # Variable c_long
CALLBACK_EVENT    = 327680 # Variable c_long
CALLBACK_TYPEMASK = 458752 # Variable c_long

CALLTYPE_TOPLEVEL             = 1
CALLTYPE_NESTED               = 2
CALLTYPE_ASYNC                = 3
CALLTYPE_TOPLEVEL_CALLPENDING = 4
CALLTYPE_ASYNC_CALLPENDING    = 5

CALL_PENDING = 2 # Variable c_int

CAL_ICALINTVALUE           = 1 # Variable c_int
CAL_GREGORIAN              = 1 # Variable c_int
CAL_SCALNAME               = 2 # Variable c_int
CAL_GREGORIAN_US           = 2 # Variable c_int
CAL_IYEAROFFSETRANGE       = 3 # Variable c_int
CAL_JAPAN                  = 3 # Variable c_int
CAL_SERASTRING             = 4 # Variable c_int
CAL_TAIWAN                 = 4 # Variable c_int
CAL_SSHORTDATE             = 5 # Variable c_int
CAL_KOREA                  = 5 # Variable c_int
CAL_SLONGDATE              = 6 # Variable c_int
CAL_HIJRI                  = 6 # Variable c_int
CAL_SDAYNAME1              = 7 # Variable c_int
CAL_THAI                   = 7 # Variable c_int
CAL_SDAYNAME2              = 8 # Variable c_int
CAL_HEBREW                 = 8 # Variable c_int
CAL_SDAYNAME3              = 9 # Variable c_int
CAL_GREGORIAN_ME_FRENCH    = 9 # Variable c_int
CAL_SDAYNAME4              = 10 # Variable c_int
CAL_GREGORIAN_ARABIC       = 10 # Variable c_int
CAL_SDAYNAME5              = 11 # Variable c_int
CAL_GREGORIAN_XLIT_ENGLISH = 11 # Variable c_int
CAL_SDAYNAME6              = 12 # Variable c_int
CAL_GREGORIAN_XLIT_FRENCH  = 12 # Variable c_int
CAL_SDAYNAME7              = 13 # Variable c_int
CAL_SABBREVDAYNAME1        = 14 # Variable c_int
CAL_SABBREVDAYNAME2        = 15 # Variable c_int
CAL_SABBREVDAYNAME3        = 16 # Variable c_int
CAL_SABBREVDAYNAME4        = 17 # Variable c_int
CAL_SABBREVDAYNAME5        = 18 # Variable c_int
CAL_SABBREVDAYNAME6        = 19 # Variable c_int
CAL_SABBREVDAYNAME7        = 20 # Variable c_int
CAL_SMONTHNAME1            = 21 # Variable c_int
CAL_SMONTHNAME2            = 22 # Variable c_int
CAL_SMONTHNAME3            = 23 # Variable c_int
CAL_UMALQURA               = 23 # Variable c_int
CAL_SMONTHNAME4            = 24 # Variable c_int
CAL_SMONTHNAME5            = 25 # Variable c_int
CAL_SMONTHNAME6            = 26 # Variable c_int
CAL_SMONTHNAME7            = 27 # Variable c_int
CAL_SMONTHNAME8            = 28 # Variable c_int
CAL_SMONTHNAME9            = 29 # Variable c_int
CAL_SMONTHNAME10           = 30 # Variable c_int
CAL_SMONTHNAME11           = 31 # Variable c_int
CAL_SMONTHNAME12           = 32 # Variable c_int
CAL_SMONTHNAME13           = 33 # Variable c_int
CAL_SABBREVMONTHNAME1      = 34 # Variable c_int
CAL_SABBREVMONTHNAME2      = 35 # Variable c_int
CAL_SABBREVMONTHNAME3      = 36 # Variable c_int
CAL_SABBREVMONTHNAME4      = 37 # Variable c_int
CAL_SABBREVMONTHNAME5      = 38 # Variable c_int
CAL_SABBREVMONTHNAME6      = 39 # Variable c_int
CAL_SABBREVMONTHNAME7      = 40 # Variable c_int
CAL_SABBREVMONTHNAME8      = 41 # Variable c_int
CAL_SABBREVMONTHNAME9      = 42 # Variable c_int
CAL_SABBREVMONTHNAME10     = 43 # Variable c_int
CAL_SABBREVMONTHNAME11     = 44 # Variable c_int
CAL_SABBREVMONTHNAME12     = 45 # Variable c_int
CAL_SABBREVMONTHNAME13     = 46 # Variable c_int

CAPSLOCK_ON = win32con.CAPSLOCK_ON # 128

CAT_E_FIRST         = 2147746144 # Variable c_ulong
CAT_E_LAST          = 2147746145 # Variable c_ulong
CAT_E_NODESCRIPTION = -2147221151 # Variable c_long
CAT_E_CATIDNOEXIST  = -2147221152 # Variable c_long

CA_NEGATIVE   = win32con.CA_NEGATIVE # 1
CA_LOG_FILTER = win32con.CA_LOG_FILTER # 2

CBEIF_TEXT          = 1 # Variable c_int
CBEIF_IMAGE         = 2 # Variable c_int
CBEIF_SELECTEDIMAGE = 4 # Variable c_int
CBEIF_OVERLAY       = 8 # Variable c_int
CBEIF_INDENT        = 16 # Variable c_int
CBEIF_LPARAM        = 32 # Variable c_int
CBEIF_DI_SETITEM    = 268435456 # Variable c_int

CBEM_INSERTITEMA      = 1025 # Variable c_int
CBEM_SETIMAGELIST     = 1026 # Variable c_int
CBEM_GETIMAGELIST     = 1027 # Variable c_int
CBEM_GETITEMA         = 1028 # Variable c_int
CBEM_SETITEMA         = 1029 # Variable c_int
CBEM_GETCOMBOCONTROL  = 1030 # Variable c_int
CBEM_GETEDITCONTROL   = 1031 # Variable c_int
CBEM_SETEXSTYLE       = 1032 # Variable c_int
CBEM_GETEXTENDEDSTYLE = 1033 # Variable c_int
CBEM_GETEXSTYLE       = 1033 # Variable c_int
CBEM_HASEDITCHANGED   = 1034 # Variable c_int
CBEM_INSERTITEMW      = 1035 # Variable c_int
CBEM_SETITEMW         = 1036 # Variable c_int
CBEM_GETITEMW         = 1037 # Variable c_int
CBEM_SETEXTENDEDSTYLE = 1038 # Variable c_int

CBENF_KILLFOCUS = 1 # Variable c_int
CBENF_RETURN    = 2 # Variable c_int
CBENF_ESCAPE    = 3 # Variable c_int
CBENF_DROPDOWN  = 4 # Variable c_int

CBEN_LAST         = 4294966466 # Variable c_uint
CBEN_DRAGBEGINW   = 4294966487 # Variable c_uint
CBEN_DRAGBEGINA   = 4294966488 # Variable c_uint
CBEN_GETDISPINFOW = 4294966489 # Variable c_uint
CBEN_ENDEDITW     = 4294966490 # Variable c_uint
CBEN_ENDEDITA     = 4294966491 # Variable c_uint
CBEN_BEGINEDIT    = 4294966492 # Variable c_uint
CBEN_DELETEITEM   = 4294966494 # Variable c_uint
CBEN_INSERTITEM   = 4294966495 # Variable c_uint
CBEN_FIRST        = 4294966496 # Variable c_uint
CBEN_GETDISPINFOA = 4294966496 # Variable c_uint
CBEN_DRAGBEGIN    = 4294966488 # Variable c_uint
CBEN_ENDEDIT      = 4294966491 # Variable c_uint
CBEN_GETDISPINFO  = 4294966496 # Variable c_uint

CBES_EX_NOEDITIMAGE       = 1 # Variable c_int
CBES_EX_NOEDITIMAGEINDENT = 2 # Variable c_int
CBES_EX_PATHWORDBREAKPROC = 4 # Variable c_int
CBES_EX_NOSIZELIMIT       = 8 # Variable c_int
CBES_EX_CASESENSITIVE     = 16 # Variable c_int

CBF_FAIL_SELFCONNECTIONS  = 4096 # Variable c_int
CBF_FAIL_CONNECTIONS      = 8192 # Variable c_int
CBF_FAIL_ADVISES          = 16384 # Variable c_int
CBF_FAIL_EXECUTES         = 32768 # Variable c_int
CBF_FAIL_POKES            = 65536 # Variable c_int
CBF_FAIL_REQUESTS         = 131072 # Variable c_int
CBF_FAIL_ALLSVRXACTIONS   = 258048 # Variable c_int
CBF_SKIP_CONNECT_CONFIRMS = 262144 # Variable c_int
CBF_SKIP_REGISTRATIONS    = 524288 # Variable c_int
CBF_SKIP_UNREGISTRATIONS  = 1048576 # Variable c_int
CBF_SKIP_DISCONNECTS      = 2097152 # Variable c_int
CBF_SKIP_ALLNOTIFICATIONS = 3932160 # Variable c_int

CBM_INIT = win32con.CBM_INIT # 4

CBN_SELCHANGE    = win32con.CBN_SELCHANGE # 1
CBN_DBLCLK       = win32con.CBN_DBLCLK # 2
CBN_SETFOCUS     = win32con.CBN_SETFOCUS # 3
CBN_KILLFOCUS    = win32con.CBN_KILLFOCUS # 4
CBN_EDITCHANGE   = win32con.CBN_EDITCHANGE # 5
CBN_EDITUPDATE   = win32con.CBN_EDITUPDATE # 6
CBN_DROPDOWN     = win32con.CBN_DROPDOWN # 7
CBN_CLOSEUP      = win32con.CBN_CLOSEUP # 8
CBN_SELENDOK     = win32con.CBN_SELENDOK # 9
CBN_SELENDCANCEL = win32con.CBN_SELENDCANCEL # 10
CBN_ERRSPACE     = win32con.CBN_ERRSPACE # -1

CBR_110    = win32con.CBR_110 # 110
CBR_300    = win32con.CBR_300 # 300
CBR_600    = win32con.CBR_600 # 600
CBR_1200   = win32con.CBR_1200 # 1200
CBR_2400   = win32con.CBR_2400 # 2400
CBR_4800   = win32con.CBR_4800 # 4800
CBR_9600   = win32con.CBR_9600 # 9600
CBR_14400  = win32con.CBR_14400 # 14400
CBR_19200  = win32con.CBR_19200 # 19200
CBR_38400  = win32con.CBR_38400 # 38400
CBR_56000  = win32con.CBR_56000 # 56000
CBR_57600  = win32con.CBR_57600 # 57600
CBR_115200 = win32con.CBR_115200 # 115200
CBR_128000 = win32con.CBR_128000 # 128000
CBR_256000 = win32con.CBR_256000 # 256000
CBR_BLOCK  = 4294967295 # Variable POINTER(HDDEDATA__)

CBS_SIMPLE            = win32con.CBS_SIMPLE # 1
CBS_DROPDOWN          = win32con.CBS_DROPDOWN # 2
CBS_DROPDOWNLIST      = win32con.CBS_DROPDOWNLIST # 3
CBS_OWNERDRAWFIXED    = win32con.CBS_OWNERDRAWFIXED # 16
CBS_OWNERDRAWVARIABLE = win32con.CBS_OWNERDRAWVARIABLE # 32
CBS_AUTOHSCROLL       = win32con.CBS_AUTOHSCROLL # 64
CBS_OEMCONVERT        = win32con.CBS_OEMCONVERT # 128
CBS_SORT              = win32con.CBS_SORT # 256
CBS_HASSTRINGS        = win32con.CBS_HASSTRINGS # 512
CBS_NOINTEGRALHEIGHT  = win32con.CBS_NOINTEGRALHEIGHT # 1024
CBS_DISABLENOSCROLL   = win32con.CBS_DISABLENOSCROLL # 2048
CBS_UPPERCASE         = win32con.CBS_UPPERCASE # 8192
CBS_LOWERCASE         = win32con.CBS_LOWERCASE # 16384

CB_OKAY                  = win32con.CB_OKAY # 0
CB_GETEDITSEL            = win32con.CB_GETEDITSEL # 320
CB_LIMITTEXT             = win32con.CB_LIMITTEXT # 321
CB_SETEDITSEL            = win32con.CB_SETEDITSEL # 322
CB_ADDSTRING             = win32con.CB_ADDSTRING # 323
CB_DELETESTRING          = win32con.CB_DELETESTRING # 324
CB_DIR                   = win32con.CB_DIR # 325
CB_GETCOUNT              = win32con.CB_GETCOUNT # 326
CB_GETCURSEL             = win32con.CB_GETCURSEL # 327
CB_GETLBTEXT             = win32con.CB_GETLBTEXT # 328
CB_GETLBTEXTLEN          = win32con.CB_GETLBTEXTLEN # 329
CB_INSERTSTRING          = win32con.CB_INSERTSTRING # 330
CB_RESETCONTENT          = win32con.CB_RESETCONTENT # 331
CB_FINDSTRING            = win32con.CB_FINDSTRING # 332
CB_SELECTSTRING          = win32con.CB_SELECTSTRING # 333
CB_SETCURSEL             = win32con.CB_SETCURSEL # 334
CB_SHOWDROPDOWN          = win32con.CB_SHOWDROPDOWN # 335
CB_GETITEMDATA           = win32con.CB_GETITEMDATA # 336
CB_SETITEMDATA           = win32con.CB_SETITEMDATA # 337
CB_GETDROPPEDCONTROLRECT = win32con.CB_GETDROPPEDCONTROLRECT # 338
CB_SETITEMHEIGHT         = win32con.CB_SETITEMHEIGHT # 339
CB_GETITEMHEIGHT         = win32con.CB_GETITEMHEIGHT # 340
CB_SETEXTENDEDUI         = win32con.CB_SETEXTENDEDUI # 341
CB_GETEXTENDEDUI         = win32con.CB_GETEXTENDEDUI # 342
CB_GETDROPPEDSTATE       = win32con.CB_GETDROPPEDSTATE # 343
CB_FINDSTRINGEXACT       = win32con.CB_FINDSTRINGEXACT # 344
CB_SETLOCALE             = win32con.CB_SETLOCALE # 345
CB_GETLOCALE             = win32con.CB_GETLOCALE # 346
CB_GETTOPINDEX           = win32con.CB_GETTOPINDEX # 347
CB_SETTOPINDEX           = win32con.CB_SETTOPINDEX # 348
CB_GETHORIZONTALEXTENT   = win32con.CB_GETHORIZONTALEXTENT # 349
CB_SETHORIZONTALEXTENT   = win32con.CB_SETHORIZONTALEXTENT # 350
CB_GETDROPPEDWIDTH       = win32con.CB_GETDROPPEDWIDTH # 351
CB_SETDROPPEDWIDTH       = win32con.CB_SETDROPPEDWIDTH # 352
CB_INITSTORAGE           = win32con.CB_INITSTORAGE # 353
CB_MSGMAX                = win32con.CB_MSGMAX # 354
CB_ERR                   = win32con.CB_ERR # -1
CB_ERRSPACE              = win32con.CB_ERRSPACE # -2

CCERR_CHOOSECOLORCODES = 20480 # Variable c_int

CCH_MAX_PROPSTG_NAME = 31 # Variable c_int

CCM_FIRST            = 8192 # Variable c_int
CCM_SETBKCOLOR       = 8193 # Variable c_int
CCM_SETCOLORSCHEME   = 8194 # Variable c_int
CCM_GETCOLORSCHEME   = 8195 # Variable c_int
CCM_GETDROPTARGET    = 8196 # Variable c_int
CCM_SETUNICODEFORMAT = 8197 # Variable c_int
CCM_GETUNICODEFORMAT = 8198 # Variable c_int

CCS_TOP           = 1 # Variable c_long
CCS_NOMOVEY       = 2 # Variable c_long
CCS_BOTTOM        = 3 # Variable c_long
CCS_NORESIZE      = 4 # Variable c_long
CCS_NOPARENTALIGN = 8 # Variable c_long
CCS_ADJUSTABLE    = 32 # Variable c_long
CCS_NODIVIDER     = 64 # Variable c_long
CCS_VERT          = 128 # Variable c_long
CCS_LEFT          = 129 # Variable c_long
CCS_NOMOVEX       = 130 # Variable c_long
CCS_RIGHT         = 131 # Variable c_long

CC_FASTCALL             = 0
CC_NONE                 = win32con.CC_NONE # 0
CC_CDECL                = 1
CC_CIRCLES              = win32con.CC_CIRCLES # 1
CC_RGBINIT              = win32con.CC_RGBINIT # 1
CC_MSCPASCAL            = 2
CC_PASCAL               = 2
CC_PIE                  = win32con.CC_PIE # 2
CC_FULLOPEN             = win32con.CC_FULLOPEN # 2
CC_MACPASCAL            = 3
CC_STDCALL              = 4
CC_PREVENTFULLOPEN      = win32con.CC_PREVENTFULLOPEN # 4
CC_CHORD                = win32con.CC_CHORD # 4
CC_FPFASTCALL           = 5
CC_SYSCALL              = 6
CC_MPWCDECL             = 7
CC_MPWPASCAL            = 8
CC_SHOWHELP             = win32con.CC_SHOWHELP # 8
CC_ELLIPSES             = win32con.CC_ELLIPSES # 8
CC_MAX                  = 9
CC_WIDE                 = win32con.CC_WIDE # 16
CC_ENABLEHOOK           = win32con.CC_ENABLEHOOK # 16
CC_ENABLETEMPLATE       = win32con.CC_ENABLETEMPLATE # 32
CC_STYLED               = win32con.CC_STYLED # 32
CC_WIDESTYLED           = win32con.CC_WIDESTYLED # 64
CC_ENABLETEMPLATEHANDLE = win32con.CC_ENABLETEMPLATEHANDLE # 64
CC_SOLIDCOLOR           = win32con.CC_SOLIDCOLOR # 128
CC_INTERIORS            = win32con.CC_INTERIORS # 128
CC_ROUNDRECT            = win32con.CC_ROUNDRECT # 256
CC_ANYCOLOR             = win32con.CC_ANYCOLOR # 256

CDDS_PREPAINT      = 1 # Variable c_int
CDDS_POSTPAINT     = 2 # Variable c_int
CDDS_PREERASE      = 3 # Variable c_int
CDDS_POSTERASE     = 4 # Variable c_int
CDDS_ITEM          = 65536 # Variable c_int
CDDS_ITEMPREPAINT  = 65537 # Variable c_int
CDDS_ITEMPOSTPAINT = 65538 # Variable c_int
CDDS_ITEMPREERASE  = 65539 # Variable c_int
CDDS_ITEMPOSTERASE = 65540 # Variable c_int
CDDS_SUBITEM       = 131072 # Variable c_int

CDERR_GENERALCODES    = 0 # Variable c_int
CDERR_STRUCTSIZE      = 1 # Variable c_int
CDERR_INITIALIZATION  = 2 # Variable c_int
CDERR_NOTEMPLATE      = 3 # Variable c_int
CDERR_NOHINSTANCE     = 4 # Variable c_int
CDERR_LOADSTRFAILURE  = 5 # Variable c_int
CDERR_FINDRESFAILURE  = 6 # Variable c_int
CDERR_LOADRESFAILURE  = 7 # Variable c_int
CDERR_LOCKRESFAILURE  = 8 # Variable c_int
CDERR_MEMALLOCFAILURE = 9 # Variable c_int
CDERR_MEMLOCKFAILURE  = 10 # Variable c_int
CDERR_NOHOOK          = 11 # Variable c_int
CDERR_REGISTERMSGFAIL = 12 # Variable c_int
CDERR_DIALOGFAILURE   = 65535 # Variable c_int

CDIS_SELECTED      = 1 # Variable c_int
CDIS_GRAYED        = 2 # Variable c_int
CDIS_DISABLED      = 4 # Variable c_int
CDIS_CHECKED       = 8 # Variable c_int
CDIS_FOCUS         = 16 # Variable c_int
CDIS_DEFAULT       = 32 # Variable c_int
CDIS_HOT           = 64 # Variable c_int
CDIS_MARKED        = 128 # Variable c_int
CDIS_INDETERMINATE = 256 # Variable c_int

CDM_GETSPEC         = win32con.CDM_GETSPEC # 1124
CDM_FIRST           = win32con.CDM_FIRST # 1124
CDM_GETFILEPATH     = win32con.CDM_GETFILEPATH # 1125
CDM_GETFOLDERPATH   = win32con.CDM_GETFOLDERPATH # 1126
CDM_GETFOLDERIDLIST = win32con.CDM_GETFOLDERIDLIST # 1127
CDM_SETCONTROLTEXT  = win32con.CDM_SETCONTROLTEXT # 1128
CDM_HIDECONTROL     = win32con.CDM_HIDECONTROL # 1129
CDM_SETDEFEXT       = win32con.CDM_SETDEFEXT # 1130
CDM_LAST            = win32con.CDM_LAST # 1224

CDN_LAST           = win32con.CDN_LAST # -699
CDN_INCLUDEITEM    = win32con.CDN_INCLUDEITEM # -608
CDN_TYPECHANGE     = win32con.CDN_TYPECHANGE # -607
CDN_FILEOK         = win32con.CDN_FILEOK # -606
CDN_HELP           = win32con.CDN_HELP # -605
CDN_SHAREVIOLATION = win32con.CDN_SHAREVIOLATION # -604
CDN_FOLDERCHANGE   = win32con.CDN_FOLDERCHANGE # -603
CDN_SELCHANGE      = win32con.CDN_SELCHANGE # -602
CDN_FIRST          = win32con.CDN_FIRST # -601
CDN_INITDONE       = win32con.CDN_INITDONE # -601

CDRF_DODEFAULT         = 0 # Variable c_int
CDRF_NEWFONT           = 2 # Variable c_int
CDRF_SKIPDEFAULT       = 4 # Variable c_int
CDRF_NOTIFYPOSTPAINT   = 16 # Variable c_int
CDRF_NOTIFYSUBITEMDRAW = 32 # Variable c_int
CDRF_NOTIFYITEMDRAW    = 32 # Variable c_int
CDRF_NOTIFYPOSTERASE   = 64 # Variable c_int

CDS_UPDATEREGISTRY = win32con.CDS_UPDATEREGISTRY # 1
CDS_TEST           = win32con.CDS_TEST # 2
CDS_FULLSCREEN     = win32con.CDS_FULLSCREEN # 4
CDS_GLOBAL         = win32con.CDS_GLOBAL # 8
CDS_SET_PRIMARY    = win32con.CDS_SET_PRIMARY # 16
CDS_NORESET        = win32con.CDS_NORESET # 268435456
CDS_SETRECT        = win32con.CDS_SETRECT # 536870912
CDS_RESET          = win32con.CDS_RESET # 1073741824

CD_LBSELCHANGE  = win32con.CD_LBSELCHANGE # 0
CD_LBSELSUB     = win32con.CD_LBSELSUB # 1
CD_LBSELADD     = win32con.CD_LBSELADD # 2
CD_LBSELNOITEMS = win32con.CD_LBSELNOITEMS # -1

CERTDB_E_JET_ERROR = -2146873344 # Variable c_long

CERTSRV_E_PROPERTY_EMPTY     = -2146877436 # Variable c_long
CERTSRV_E_BAD_REQUESTSTATUS  = -2146877437 # Variable c_long
CERTSRV_E_NO_REQUEST         = -2146877438 # Variable c_long
CERTSRV_E_BAD_REQUESTSUBJECT = -2146877439 # Variable c_long

CERT_E_WRONG_USAGE           = -2146762480 # Variable c_long
CERT_E_CN_NO_MATCH           = -2146762481 # Variable c_long
CERT_E_REVOCATION_FAILURE    = -2146762482 # Variable c_long
CERT_E_UNTRUSTEDTESTROOT     = -2146762483 # Variable c_long
CERT_E_REVOKED               = -2146762484 # Variable c_long
CERT_E_CHAINING              = -2146762486 # Variable c_long
CERT_E_UNTRUSTEDROOT         = -2146762487 # Variable c_long
CERT_E_MALFORMED             = -2146762488 # Variable c_long
CERT_E_ISSUERCHAINING        = -2146762489 # Variable c_long
CERT_E_PURPOSE               = -2146762490 # Variable c_long
CERT_E_CRITICAL              = -2146762491 # Variable c_long
CERT_E_PATHLENCONST          = -2146762492 # Variable c_long
CERT_E_ROLE                  = -2146762493 # Variable c_long
CERT_E_VALIDITYPERIODNESTING = -2146762494 # Variable c_long
CERT_E_EXPIRED               = -2146762495 # Variable c_long

CE_RXOVER   = 1 # Variable c_int
CE_OVERRUN  = 2 # Variable c_int
CE_RXPARITY = 4 # Variable c_int
CE_FRAME    = 8 # Variable c_int
CE_BREAK    = 16 # Variable c_int
CE_TXFULL   = 256 # Variable c_int
CE_PTO      = 512 # Variable c_int
CE_IOE      = 1024 # Variable c_int
CE_DNS      = 2048 # Variable c_int
CE_OOP      = 4096 # Variable c_int
CE_MODE     = 32768 # Variable c_int

CFERR_CHOOSEFONTCODES = 8192 # Variable c_int
CFERR_NOFONTS         = 8193 # Variable c_int
CFERR_MAXLESSTHANMIN  = 8194 # Variable c_int

CFSTR_MIME_FRACTALS    = 'application/fractals' # Variable POINTER(c_wchar)
CFSTR_MIME_RAWDATA     = 'application/octet-stream' # Variable POINTER(c_wchar)
CFSTR_MIME_RAWDATASTRM = 'application/octet-stream' # Variable POINTER(c_wchar)
CFSTR_MIME_PDF         = 'application/pdf' # Variable POINTER(c_wchar)
CFSTR_MIME_POSTSCRIPT  = 'application/postscript' # Variable POINTER(c_wchar)
CFSTR_MIME_AIFF        = 'audio/aiff' # Variable POINTER(c_wchar)
CFSTR_MIME_BASICAUDIO  = 'audio/basic' # Variable POINTER(c_wchar)
CFSTR_MIME_WAV         = 'audio/wav' # Variable POINTER(c_wchar)
CFSTR_MIME_X_AIFF      = 'audio/x-aiff' # Variable POINTER(c_wchar)
CFSTR_MIME_X_REALAUDIO = 'audio/x-pn-realaudio' # Variable POINTER(c_wchar)
CFSTR_MIME_X_WAV       = 'audio/x-wav' # Variable POINTER(c_wchar)
CFSTR_MIME_BMP         = 'image/bmp' # Variable POINTER(c_wchar)
CFSTR_MIME_GIF         = 'image/gif' # Variable POINTER(c_wchar)
CFSTR_MIME_JPEG        = 'image/jpeg' # Variable POINTER(c_wchar)
CFSTR_MIME_PJPEG       = 'image/pjpeg' # Variable POINTER(c_wchar)
CFSTR_MIME_TIFF        = 'image/tiff' # Variable POINTER(c_wchar)
CFSTR_MIME_X_EMF       = 'image/x-emf' # Variable POINTER(c_wchar)
CFSTR_MIME_X_ART       = 'image/x-jg' # Variable POINTER(c_wchar)
CFSTR_MIME_X_PNG       = 'image/x-png' # Variable POINTER(c_wchar)
CFSTR_MIME_X_WMF       = 'image/x-wmf' # Variable POINTER(c_wchar)
CFSTR_MIME_X_BITMAP    = 'image/x-xbitmap' # Variable POINTER(c_wchar)
CFSTR_MIME_XBM         = 'image/xbm' # Variable POINTER(c_wchar)
CFSTR_MIME_HTML        = 'text/html' # Variable POINTER(c_wchar)
CFSTR_MIME_TEXT        = 'text/plain' # Variable POINTER(c_wchar)
CFSTR_MIME_RICHTEXT    = 'text/richtext' # Variable POINTER(c_wchar)
CFSTR_MIME_AVI         = 'video/avi' # Variable POINTER(c_wchar)
CFSTR_MIME_MPEG        = 'video/mpeg' # Variable POINTER(c_wchar)
CFSTR_MIME_QUICKTIME   = 'video/quicktime' # Variable POINTER(c_wchar)
CFSTR_MIME_X_MSVIDEO   = 'video/x-msvideo' # Variable POINTER(c_wchar)
CFSTR_MIME_X_SGI_MOVIE = 'video/x-sgi-movie' # Variable POINTER(c_wchar)

CFS_DEFAULT        = 0 # Variable c_int
CFS_RECT           = 1 # Variable c_int
CFS_POINT          = 2 # Variable c_int
CFS_FORCE_POSITION = 32 # Variable c_int
CFS_CANDIDATEPOS   = 64 # Variable c_int
CFS_EXCLUDE        = 128 # Variable c_int

CF_NULL                 = 0 # Variable c_int
CF_SCREENFONTS          = win32con.CF_SCREENFONTS # 1
CF_TEXT                 = win32con.CF_TEXT # 1
CF_PRINTERFONTS         = win32con.CF_PRINTERFONTS # 2
CF_BITMAP               = win32con.CF_BITMAP # 2
CF_METAFILEPICT         = win32con.CF_METAFILEPICT # 3
CF_BOTH                 = win32con.CF_BOTH # 3
CF_SYLK                 = win32con.CF_SYLK # 4
CF_SHOWHELP             = win32con.CF_SHOWHELP # 4
CF_DIF                  = win32con.CF_DIF # 5
CF_TIFF                 = win32con.CF_TIFF # 6
CF_OEMTEXT              = win32con.CF_OEMTEXT # 7
CF_DIB                  = win32con.CF_DIB # 8
CF_ENABLEHOOK           = win32con.CF_ENABLEHOOK # 8
CF_PALETTE              = win32con.CF_PALETTE # 9
CF_PENDATA              = win32con.CF_PENDATA # 10
CF_RIFF                 = win32con.CF_RIFF # 11
CF_WAVE                 = win32con.CF_WAVE # 12
CF_UNICODETEXT          = win32con.CF_UNICODETEXT # 13
CF_ENHMETAFILE          = win32con.CF_ENHMETAFILE # 14
CF_HDROP                = win32con.CF_HDROP # 15
CF_LOCALE               = win32con.CF_LOCALE # 16
CF_ENABLETEMPLATE       = win32con.CF_ENABLETEMPLATE # 16
CF_MAX                  = win32con.CF_MAX # 18
CF_ENABLETEMPLATEHANDLE = win32con.CF_ENABLETEMPLATEHANDLE # 32
CF_INITTOLOGFONTSTRUCT  = win32con.CF_INITTOLOGFONTSTRUCT # 64
CF_OWNERDISPLAY         = win32con.CF_OWNERDISPLAY # 128
CF_USESTYLE             = win32con.CF_USESTYLE # 128
CF_DSPTEXT              = win32con.CF_DSPTEXT # 129
CF_DSPBITMAP            = win32con.CF_DSPBITMAP # 130
CF_DSPMETAFILEPICT      = win32con.CF_DSPMETAFILEPICT # 131
CF_DSPENHMETAFILE       = win32con.CF_DSPENHMETAFILE # 142
CF_EFFECTS              = win32con.CF_EFFECTS # 256
CF_PRIVATEFIRST         = win32con.CF_PRIVATEFIRST # 512
CF_APPLY                = win32con.CF_APPLY # 512
CF_PRIVATELAST          = win32con.CF_PRIVATELAST # 767
CF_GDIOBJFIRST          = win32con.CF_GDIOBJFIRST # 768
CF_GDIOBJLAST           = win32con.CF_GDIOBJLAST # 1023
CF_ANSIONLY             = win32con.CF_ANSIONLY # 1024
CF_NOVECTORFONTS        = win32con.CF_NOVECTORFONTS # 2048
CF_NOSIMULATIONS        = win32con.CF_NOSIMULATIONS # 4096
CF_LIMITSIZE            = win32con.CF_LIMITSIZE # 8192
CF_FIXEDPITCHONLY       = win32con.CF_FIXEDPITCHONLY # 16384
CF_WYSIWYG              = win32con.CF_WYSIWYG # 32768
CF_FORCEFONTEXIST       = win32con.CF_FORCEFONTEXIST # 65536
CF_SCALABLEONLY         = win32con.CF_SCALABLEONLY # 131072
CF_TTONLY               = win32con.CF_TTONLY # 262144
CF_NOFACESEL            = win32con.CF_NOFACESEL # 524288
CF_NOSTYLESEL           = win32con.CF_NOSTYLESEL # 1048576
CF_NOSIZESEL            = win32con.CF_NOSIZESEL # 2097152
CF_SELECTSCRIPT         = win32con.CF_SELECTSCRIPT # 4194304
CF_NOSCRIPTSEL          = win32con.CF_NOSCRIPTSEL # 8388608
CF_NOVERTFONTS          = win32con.CF_NOVERTFONTS # 16777216

CHANGEKIND_ADDMEMBER        = 0
CHANGEKIND_DELETEMEMBER     = 1
CHANGEKIND_SETNAMES         = 2
CHANGEKIND_SETDOCUMENTATION = 3
CHANGEKIND_GENERAL          = 4
CHANGEKIND_INVALIDATE       = 5
CHANGEKIND_CHANGEFAILED     = 6
CHANGEKIND_MAX              = 7

CHINESEBIG5_CHARSET = win32con.CHINESEBIG5_CHARSET # 136

CIP_DISK_FULL                            = 0
CIP_ACCESS_DENIED                        = 1
CIP_NEWER_VERSION_EXISTS                 = 2
CIP_OLDER_VERSION_EXISTS                 = 3
CIP_NAME_CONFLICT                        = 4
CIP_TRUST_VERIFICATION_COMPONENT_MISSING = 5
CIP_EXE_SELF_REGISTERATION_TIMEOUT       = 6
CIP_UNSAFE_TO_ABORT                      = 7
CIP_NEED_REBOOT                          = 8

CLASSFACTORY_S_FIRST = 262416 # Variable c_long
CLASSFACTORY_S_LAST  = 262431 # Variable c_long
CLASSFACTORY_E_FIRST = 2147746064 # Variable c_ulong
CLASSFACTORY_E_LAST  = 2147746079 # Variable c_ulong

CLASS_E_NOTLICENSED       = -2147221230 # Variable c_long
CLASS_E_CLASSNOTAVAILABLE = -2147221231 # Variable c_long
CLASS_E_NOAGGREGATION     = -2147221232 # Variable c_long

CLIENTSITE_S_FIRST = 262544 # Variable c_long
CLIENTSITE_S_LAST  = 262559 # Variable c_long
CLIENTSITE_E_FIRST = 2147746192 # Variable c_ulong
CLIENTSITE_E_LAST  = 2147746207 # Variable c_ulong

CLIPBRD_S_FIRST      = 262608 # Variable c_long
CLIPBRD_S_LAST       = 262623 # Variable c_long
CLIPBRD_E_FIRST      = 2147746256 # Variable c_ulong
CLIPBRD_E_LAST       = 2147746271 # Variable c_ulong
CLIPBRD_E_CANT_CLOSE = -2147221036 # Variable c_long
CLIPBRD_E_BAD_DATA   = -2147221037 # Variable c_long
CLIPBRD_E_CANT_SET   = -2147221038 # Variable c_long
CLIPBRD_E_CANT_EMPTY = -2147221039 # Variable c_long
CLIPBRD_E_CANT_OPEN  = -2147221040 # Variable c_long

CLIP_DEFAULT_PRECIS   = win32con.CLIP_DEFAULT_PRECIS # 0
CLIP_CHARACTER_PRECIS = win32con.CLIP_CHARACTER_PRECIS # 1
CLIP_STROKE_PRECIS    = win32con.CLIP_STROKE_PRECIS # 2
CLIP_MASK             = win32con.CLIP_MASK # 15
CLIP_LH_ANGLES        = win32con.CLIP_LH_ANGLES # 16
CLIP_TT_ALWAYS        = win32con.CLIP_TT_ALWAYS # 32
CLIP_EMBEDDED         = win32con.CLIP_EMBEDDED # 128
CLIP_TO_PATH          = win32con.CLIP_TO_PATH # 4097

CLR_DEFAULT = 4278190080 # Variable c_ulong
CLR_INVALID = win32con.CLR_INVALID # -1
CLR_NONE    = 4294967295 # Variable c_ulong

CLSCTX_INPROC_SERVER     = 1
CLSCTX_INPROC_HANDLER    = 2
CLSCTX_INPROC            = 3 # Variable c_int
CLSCTX_LOCAL_SERVER      = 4
CLSCTX_SERVER            = 5 # Variable c_int
CLSCTX_ALL               = 7 # Variable c_int
CLSCTX_INPROC_SERVER16   = 8
CLSCTX_REMOTE_SERVER     = 16
CLSCTX_INPROC_HANDLER16  = 32
CLSCTX_INPROC_SERVERX86  = 64
CLSCTX_INPROC_HANDLERX86 = 128
CLSCTX_ESERVER_HANDLER   = 256

CMB_MASKED = 2 # Variable c_int

CM_IN_GAMUT     = 0 # Variable c_int
CM_OUT_OF_GAMUT = 255 # Variable c_int

COINIT_APARTMENTTHREADED = 2

COLOR_SCROLLBAR           = win32con.COLOR_SCROLLBAR # 0
COLOR_BACKGROUND          = win32con.COLOR_BACKGROUND # 1
COLOR_ACTIVECAPTION       = win32con.COLOR_ACTIVECAPTION # 2
COLOR_INACTIVECAPTION     = win32con.COLOR_INACTIVECAPTION # 3
COLOR_MENU                = win32con.COLOR_MENU # 4
COLOR_WINDOW              = win32con.COLOR_WINDOW # 5
COLOR_WINDOWFRAME         = win32con.COLOR_WINDOWFRAME # 6
COLOR_MENUTEXT            = win32con.COLOR_MENUTEXT # 7
COLOR_WINDOWTEXT          = win32con.COLOR_WINDOWTEXT # 8
COLOR_CAPTIONTEXT         = win32con.COLOR_CAPTIONTEXT # 9
COLOR_ACTIVEBORDER        = win32con.COLOR_ACTIVEBORDER # 10
COLOR_INACTIVEBORDER      = win32con.COLOR_INACTIVEBORDER # 11
COLOR_APPWORKSPACE        = win32con.COLOR_APPWORKSPACE # 12
COLOR_HIGHLIGHT           = win32con.COLOR_HIGHLIGHT # 13
COLOR_HIGHLIGHTTEXT       = win32con.COLOR_HIGHLIGHTTEXT # 14
COLOR_BTNFACE             = win32con.COLOR_BTNFACE # 15
COLOR_BTNSHADOW           = win32con.COLOR_BTNSHADOW # 16
COLOR_GRAYTEXT            = win32con.COLOR_GRAYTEXT # 17
COLOR_BTNTEXT             = win32con.COLOR_BTNTEXT # 18
COLOR_INACTIVECAPTIONTEXT = win32con.COLOR_INACTIVECAPTIONTEXT # 19
COLOR_BTNHIGHLIGHT        = win32con.COLOR_BTNHIGHLIGHT # 20
COLOR_3DDKSHADOW          = win32con.COLOR_3DDKSHADOW # 21
COLOR_3DLIGHT             = win32con.COLOR_3DLIGHT # 22
COLOR_INFOTEXT            = win32con.COLOR_INFOTEXT # 23
COLOR_INFOBK              = win32con.COLOR_INFOBK # 24
COLOR_ADJ_MAX             = 100 # Variable c_short
COLOR_ADJ_MIN             = -100 # Variable c_short

COMMON_LVB_LEADING_BYTE    = 256 # Variable c_int
COMMON_LVB_TRAILING_BYTE   = 512 # Variable c_int
COMMON_LVB_SBCSDBCS        = 768 # Variable c_int
COMMON_LVB_GRID_HORIZONTAL = 1024 # Variable c_int
COMMON_LVB_GRID_LVERTICAL  = 2048 # Variable c_int
COMMON_LVB_GRID_RVERTICAL  = 4096 # Variable c_int
COMMON_LVB_REVERSE_VIDEO   = 16384 # Variable c_int
COMMON_LVB_UNDERSCORE      = 32768 # Variable c_int

COMMPROP_INITIALIZED = 3879531822 # Variable c_ulong

COMPRESSION_FORMAT_NONE     = win32con.COMPRESSION_FORMAT_NONE # 0
COMPRESSION_ENGINE_STANDARD = win32con.COMPRESSION_ENGINE_STANDARD # 0
COMPRESSION_FORMAT_DEFAULT  = win32con.COMPRESSION_FORMAT_DEFAULT # 1
COMPRESSION_FORMAT_LZNT1    = win32con.COMPRESSION_FORMAT_LZNT1 # 2
COMPRESSION_ENGINE_MAXIMUM  = win32con.COMPRESSION_ENGINE_MAXIMUM # 256

CONNDLG_RO_PATH     = 1 # Variable c_int
CONNDLG_CONN_POINT  = 2 # Variable c_int
CONNDLG_USE_MRU     = 4 # Variable c_int
CONNDLG_HIDE_BOX    = 8 # Variable c_int
CONNDLG_PERSIST     = 16 # Variable c_int
CONNDLG_NOT_PERSIST = 32 # Variable c_int

CONNECT_UPDATE_PROFILE = 1 # Variable c_int
CONNECT_UPDATE_RECENT  = 2 # Variable c_int
CONNECT_TEMPORARY      = 4 # Variable c_int
CONNECT_INTERACTIVE    = 8 # Variable c_int
CONNECT_PROMPT         = 16 # Variable c_int
CONNECT_NEED_DRIVE     = 32 # Variable c_int
CONNECT_REFCOUNT       = 64 # Variable c_int
CONNECT_REDIRECT       = 128 # Variable c_int
CONNECT_LOCALDRIVE     = 256 # Variable c_int
CONNECT_CURRENT_MEDIA  = 512 # Variable c_int
CONNECT_DEFERRED       = 1024 # Variable c_int
CONNECT_RESERVED       = 4278190080 # Variable c_uint

CONSOLE_TEXTMODE_BUFFER = 1 # Variable c_int

CONTAINER_INHERIT_ACE = win32con.CONTAINER_INHERIT_ACE # 2

CONTEXT_i486               = 65536 # Variable c_int
CONTEXT_i386               = 65536 # Variable c_int
CONTEXT_CONTROL            = win32con.CONTEXT_CONTROL # 1
CONTEXT_INTEGER            = win32con.CONTEXT_INTEGER # 4
CONTEXT_SEGMENTS           = 65540 # Variable c_long
CONTEXT_FULL               = win32con.CONTEXT_FULL # 7
CONTEXT_FLOATING_POINT     = win32con.CONTEXT_FLOATING_POINT # 2
CONTEXT_DEBUG_REGISTERS    = 65552 # Variable c_long
CONTEXT_EXTENDED_REGISTERS = 65568 # Variable c_long

CO_S_FIRST                          = 262640 # Variable c_long
CO_S_LAST                           = 262655 # Variable c_long
CO_S_NOTALLINTERFACES               = 524306 # Variable c_long
CO_E_FIRST                          = 2147746288 # Variable c_ulong
CO_E_LAST                           = 2147746303 # Variable c_ulong
CO_E_SERVER_STOPPING                = -2146959352 # Variable c_long
CO_E_OBJSRV_RPC_FAILURE             = -2146959354 # Variable c_long
CO_E_SERVER_EXEC_FAILURE            = -2146959355 # Variable c_long
CO_E_BAD_PATH                       = -2146959356 # Variable c_long
CO_E_SCM_RPC_FAILURE                = -2146959357 # Variable c_long
CO_E_SCM_ERROR                      = -2146959358 # Variable c_long
CO_E_CLASS_CREATE_FAILED            = -2146959359 # Variable c_long
CO_E_ACNOTINITIALIZED               = -2147220965 # Variable c_long
CO_E_DECODEFAILED                   = -2147220966 # Variable c_long
CO_E_FAILEDTOOPENPROCESSTOKEN       = -2147220967 # Variable c_long
CO_E_INCOMPATIBLESTREAMVERSION      = -2147220968 # Variable c_long
CO_E_ACESINWRONGORDER               = -2147220969 # Variable c_long
CO_E_EXCEEDSYSACLLIMIT              = -2147220970 # Variable c_long
CO_E_FAILEDTOCLOSEHANDLE            = -2147220971 # Variable c_long
CO_E_FAILEDTOCREATEFILE             = -2147220972 # Variable c_long
CO_E_FAILEDTOGENUUID                = -2147220973 # Variable c_long
CO_E_PATHTOOLONG                    = -2147220974 # Variable c_long
CO_E_FAILEDTOGETWINDIR              = -2147220975 # Variable c_long
CO_E_SETSERLHNDLFAILED              = -2147220976 # Variable c_long
CO_E_LOOKUPACCNAMEFAILED            = -2147220977 # Variable c_long
CO_E_NOMATCHINGNAMEFOUND            = -2147220978 # Variable c_long
CO_E_LOOKUPACCSIDFAILED             = -2147220979 # Variable c_long
CO_E_NOMATCHINGSIDFOUND             = -2147220980 # Variable c_long
CO_E_CONVERSIONFAILED               = -2147220981 # Variable c_long
CO_E_INVALIDSID                     = -2147220982 # Variable c_long
CO_E_WRONGTRUSTEENAMESYNTAX         = -2147220983 # Variable c_long
CO_E_NETACCESSAPIFAILED             = -2147220984 # Variable c_long
CO_E_ACCESSCHECKFAILED              = -2147220985 # Variable c_long
CO_E_FAILEDTOSETDACL                = -2147220986 # Variable c_long
CO_E_FAILEDTOQUERYCLIENTBLANKET     = -2147220987 # Variable c_long
CO_E_TRUSTEEDOESNTMATCHCLIENT       = -2147220988 # Variable c_long
CO_E_FAILEDTOGETTOKENINFO           = -2147220989 # Variable c_long
CO_E_FAILEDTOOPENTHREADTOKEN        = -2147220990 # Variable c_long
CO_E_FAILEDTOGETSECCTX              = -2147220991 # Variable c_long
CO_E_FAILEDTOIMPERSONATE            = -2147220992 # Variable c_long
CO_E_RELEASED                       = -2147220993 # Variable c_long
CO_E_APPDIDNTREG                    = -2147220994 # Variable c_long
CO_E_OBJNOTCONNECTED                = -2147220995 # Variable c_long
CO_E_OBJISREG                       = -2147220996 # Variable c_long
CO_E_OBJNOTREG                      = -2147220997 # Variable c_long
CO_E_WRONGOSFORAPP                  = -2147220998 # Variable c_long
CO_E_ERRORINDLL                     = -2147220999 # Variable c_long
CO_E_DLLNOTFOUND                    = -2147221000 # Variable c_long
CO_E_ERRORINAPP                     = -2147221001 # Variable c_long
CO_E_APPSINGLEUSE                   = -2147221002 # Variable c_long
CO_E_APPNOTFOUND                    = -2147221003 # Variable c_long
CO_E_IIDSTRING                      = -2147221004 # Variable c_long
CO_E_CLASSSTRING                    = -2147221005 # Variable c_long
CO_E_CANTDETERMINECLASS             = -2147221006 # Variable c_long
CO_E_ALREADYINITIALIZED             = -2147221007 # Variable c_long
CO_E_NOTINITIALIZED                 = -2147221008 # Variable c_long
CO_E_MSI_ERROR                      = -2147467229 # Variable c_long
CO_E_RELOAD_DLL                     = -2147467230 # Variable c_long
CO_E_NOT_SUPPORTED                  = -2147467231 # Variable c_long
CO_E_IIDREG_INCONSISTENT            = -2147467232 # Variable c_long
CO_E_CLSREG_INCONSISTENT            = -2147467233 # Variable c_long
CO_E_SERVER_START_TIMEOUT           = -2147467234 # Variable c_long
CO_E_REMOTE_COMMUNICATION_FAILURE   = -2147467235 # Variable c_long
CO_E_START_SERVICE_FAILURE          = -2147467236 # Variable c_long
CO_E_LAUNCH_PERMSSION_DENIED        = -2147467237 # Variable c_long
CO_E_RUNAS_LOGON_FAILURE            = -2147467238 # Variable c_long
CO_E_RUNAS_CREATEPROCESS_FAILURE    = -2147467239 # Variable c_long
CO_E_CREATEPROCESS_FAILURE          = -2147467240 # Variable c_long
CO_E_RUNAS_SYNTAX                   = -2147467241 # Variable c_long
CO_E_OLE1DDE_DISABLED               = -2147467242 # Variable c_long
CO_E_WRONG_SERVER_IDENTITY          = -2147467243 # Variable c_long
CO_E_BAD_SERVER_NAME                = -2147467244 # Variable c_long
CO_E_CANT_REMOTE                    = -2147467245 # Variable c_long
CO_E_INIT_ONLY_SINGLE_THREADED      = -2147467246 # Variable c_long
CO_E_INIT_SCM_EXEC_FAILURE          = -2147467247 # Variable c_long
CO_E_INIT_SCM_MAP_VIEW_OF_FILE      = -2147467248 # Variable c_long
CO_E_INIT_SCM_FILE_MAPPING_EXISTS   = -2147467249 # Variable c_long
CO_E_INIT_SCM_MUTEX_EXISTS          = -2147467250 # Variable c_long
CO_E_INIT_UNACCEPTED_USER_ALLOCATOR = -2147467251 # Variable c_long
CO_E_INIT_TLS_CHANNEL_CONTROL       = -2147467252 # Variable c_long
CO_E_INIT_TLS_SET_CHANNEL_CONTROL   = -2147467253 # Variable c_long
CO_E_INIT_RPC_CHANNEL               = -2147467254 # Variable c_long
CO_E_INIT_CLASS_CACHE               = -2147467255 # Variable c_long
CO_E_INIT_MEMORY_ALLOCATOR          = -2147467256 # Variable c_long
CO_E_INIT_SHARED_ALLOCATOR          = -2147467257 # Variable c_long
CO_E_INIT_TLS                       = -2147467258 # Variable c_long

CPS_COMPLETE = 1 # Variable c_int
CPS_CONVERT  = 2 # Variable c_int
CPS_REVERT   = 3 # Variable c_int
CPS_CANCEL   = 4 # Variable c_int

CP_ACP        = 0 # Variable c_int
CP_NONE       = win32con.CP_NONE # 0
CP_INSTALLED  = 1 # Variable c_int
CP_RECTANGLE  = win32con.CP_RECTANGLE # 1
CP_OEMCP      = 1 # Variable c_int
CP_REGION     = win32con.CP_REGION # 2
CP_SUPPORTED  = 2 # Variable c_int
CP_MACCP      = 2 # Variable c_int
CP_THREAD_ACP = 3 # Variable c_int
CP_SYMBOL     = 42 # Variable c_int
CP_WINANSI    = 1004 # Variable c_int
CP_WINUNICODE = 1200 # Variable c_int
CP_UTF7       = 65000 # Variable c_int
CP_UTF8       = 65001 # Variable c_int

CREATE_NEW                 = win32con.CREATE_NEW # 1
CREATE_FOR_IMPORT          = 1 # Variable c_int
CREATE_FOR_DIR             = 2 # Variable c_int
CREATE_ALWAYS              = win32con.CREATE_ALWAYS # 2
CREATE_THREAD_DEBUG_EVENT  = win32con.CREATE_THREAD_DEBUG_EVENT # 2
CREATE_PROCESS_DEBUG_EVENT = win32con.CREATE_PROCESS_DEBUG_EVENT # 3
CREATE_SUSPENDED           = win32con.CREATE_SUSPENDED # 4
CREATE_NEW_CONSOLE         = win32con.CREATE_NEW_CONSOLE # 16
CREATE_NEW_PROCESS_GROUP   = win32con.CREATE_NEW_PROCESS_GROUP # 512
CREATE_UNICODE_ENVIRONMENT = win32con.CREATE_UNICODE_ENVIRONMENT # 1024
CREATE_SEPARATE_WOW_VDM    = win32con.CREATE_SEPARATE_WOW_VDM # 2048
CREATE_SHARED_WOW_VDM      = win32con.CREATE_SHARED_WOW_VDM # 4096
CREATE_FORCEDOS            = 8192 # Variable c_int
CREATE_DEFAULT_ERROR_MODE  = win32con.CREATE_DEFAULT_ERROR_MODE # 67108864
CREATE_NO_WINDOW           = win32con.CREATE_NO_WINDOW # 134217728

CRYPT_E_OSS_ERROR                  = -2146881536 # Variable c_long
CRYPT_E_NO_TRUSTED_SIGNER          = -2146885589 # Variable c_long
CRYPT_E_NOT_IN_CTL                 = -2146885590 # Variable c_long
CRYPT_E_VERIFY_USAGE_OFFLINE       = -2146885591 # Variable c_long
CRYPT_E_NO_VERIFY_USAGE_CHECK      = -2146885592 # Variable c_long
CRYPT_E_NO_VERIFY_USAGE_DLL        = -2146885593 # Variable c_long
CRYPT_E_SECURITY_SETTINGS          = -2146885594 # Variable c_long
CRYPT_E_FILERESIZED                = -2146885595 # Variable c_long
CRYPT_E_NOT_CHAR_STRING            = -2146885596 # Variable c_long
CRYPT_E_INVALID_X500_STRING        = -2146885597 # Variable c_long
CRYPT_E_INVALID_IA5_STRING         = -2146885598 # Variable c_long
CRYPT_E_INVALID_PRINTABLE_STRING   = -2146885599 # Variable c_long
CRYPT_E_INVALID_NUMERIC_STRING     = -2146885600 # Variable c_long
CRYPT_E_NOT_IN_REVOCATION_DATABASE = -2146885612 # Variable c_long
CRYPT_E_REVOCATION_OFFLINE         = -2146885613 # Variable c_long
CRYPT_E_NO_REVOCATION_CHECK        = -2146885614 # Variable c_long
CRYPT_E_NO_REVOCATION_DLL          = -2146885615 # Variable c_long
CRYPT_E_REVOKED                    = -2146885616 # Variable c_long
CRYPT_E_PENDING_CLOSE              = -2146885617 # Variable c_long
CRYPT_E_NO_SIGNER                  = -2146885618 # Variable c_long
CRYPT_E_BAD_MSG                    = -2146885619 # Variable c_long
CRYPT_E_NO_DECRYPT_CERT            = -2146885620 # Variable c_long
CRYPT_E_NO_KEY_PROPERTY            = -2146885621 # Variable c_long
CRYPT_E_UNEXPECTED_MSG_TYPE        = -2146885622 # Variable c_long
CRYPT_E_NO_MATCH                   = -2146885623 # Variable c_long
CRYPT_E_DELETED_PREV               = -2146885624 # Variable c_long
CRYPT_E_SELF_SIGNED                = -2146885625 # Variable c_long
CRYPT_E_NO_PROVIDER                = -2146885626 # Variable c_long
CRYPT_E_EXISTS                     = -2146885627 # Variable c_long
CRYPT_E_NOT_FOUND                  = -2146885628 # Variable c_long
CRYPT_E_FILE_ERROR                 = -2146885629 # Variable c_long
CRYPT_E_BAD_ENCODE                 = -2146885630 # Variable c_long
CRYPT_E_BAD_LEN                    = -2146885631 # Variable c_long
CRYPT_E_STREAM_INSUFFICIENT_DATA   = -2146889711 # Variable c_long
CRYPT_E_STREAM_MSG_NOT_READY       = -2146889712 # Variable c_long
CRYPT_E_ATTRIBUTES_MISSING         = -2146889713 # Variable c_long
CRYPT_E_SIGNER_NOT_FOUND           = -2146889714 # Variable c_long
CRYPT_E_ISSUER_SERIALNUMBER        = -2146889715 # Variable c_long
CRYPT_E_CONTROL_TYPE               = -2146889716 # Variable c_long
CRYPT_E_RECIPIENT_NOT_FOUND        = -2146889717 # Variable c_long
CRYPT_E_NOT_DECRYPTED              = -2146889718 # Variable c_long
CRYPT_E_ALREADY_DECRYPTED          = -2146889719 # Variable c_long
CRYPT_E_INVALID_INDEX              = -2146889720 # Variable c_long
CRYPT_E_HASH_VALUE                 = -2146889721 # Variable c_long
CRYPT_E_AUTH_ATTR_MISSING          = -2146889722 # Variable c_long
CRYPT_E_UNEXPECTED_ENCODING        = -2146889723 # Variable c_long
CRYPT_E_INVALID_MSG_TYPE           = -2146889724 # Variable c_long
CRYPT_E_OID_FORMAT                 = -2146889725 # Variable c_long
CRYPT_E_UNKNOWN_ALGO               = -2146889726 # Variable c_long
CRYPT_E_MSG_ERROR                  = -2146889727 # Variable c_long

CSTR_LESS_THAN    = 1 # Variable c_int
CSTR_EQUAL        = 2 # Variable c_int
CSTR_GREATER_THAN = 3 # Variable c_int

CS_VREDRAW            = win32con.CS_VREDRAW # 1
CS_ENABLE             = 1 # Variable c_long
CS_HREDRAW            = win32con.CS_HREDRAW # 2
CS_DISABLE            = 2 # Variable c_long
CS_DELETE_TRANSFORM   = 3 # Variable c_long
CS_DBLCLKS            = win32con.CS_DBLCLKS # 8
CS_OWNDC              = win32con.CS_OWNDC # 32
CS_CLASSDC            = win32con.CS_CLASSDC # 64
CS_PARENTDC           = win32con.CS_PARENTDC # 128
CS_NOCLOSE            = win32con.CS_NOCLOSE # 512
CS_SAVEBITS           = win32con.CS_SAVEBITS # 2048
CS_BYTEALIGNCLIENT    = win32con.CS_BYTEALIGNCLIENT # 4096
CS_BYTEALIGNWINDOW    = win32con.CS_BYTEALIGNWINDOW # 8192
CS_INSERTCHAR         = 8192 # Variable c_int
CS_NOMOVECARET        = 16384 # Variable c_int
CS_GLOBALCLASS        = win32con.CS_GLOBALCLASS # 16384
CS_IME                = win32con.CS_IME # 65536
CS_E_FIRST            = 2147746148 # Variable c_ulong
CS_E_LAST             = 2147746152 # Variable c_ulong
CS_E_NO_CLASSSTORE    = -2147221144 # Variable c_long
CS_E_INVALID_VERSION  = -2147221145 # Variable c_long
CS_E_CLASS_NOTFOUND   = -2147221146 # Variable c_long
CS_E_NOT_DELETABLE    = -2147221147 # Variable c_long
CS_E_PACKAGE_NOTFOUND = -2147221148 # Variable c_long

CTLCOLOR_MSGBOX    = win32con.CTLCOLOR_MSGBOX # 0
CTLCOLOR_EDIT      = win32con.CTLCOLOR_EDIT # 1
CTLCOLOR_LISTBOX   = win32con.CTLCOLOR_LISTBOX # 2
CTLCOLOR_BTN       = win32con.CTLCOLOR_BTN # 3
CTLCOLOR_DLG       = win32con.CTLCOLOR_DLG # 4
CTLCOLOR_SCROLLBAR = win32con.CTLCOLOR_SCROLLBAR # 5
CTLCOLOR_STATIC    = win32con.CTLCOLOR_STATIC # 6
CTLCOLOR_MAX       = win32con.CTLCOLOR_MAX # 7

CTRL_C_EVENT        = win32con.CTRL_C_EVENT # 0
CTRL_BREAK_EVENT    = win32con.CTRL_BREAK_EVENT # 1
CTRL_CLOSE_EVENT    = win32con.CTRL_CLOSE_EVENT # 2
CTRL_LOGOFF_EVENT   = win32con.CTRL_LOGOFF_EVENT # 5
CTRL_SHUTDOWN_EVENT = win32con.CTRL_SHUTDOWN_EVENT # 6

CTRY_DEFAULT            = 0 # Variable c_int
CTRY_UNITED_STATES      = 1 # Variable c_int
CTRY_TRINIDAD_Y_TOBAGO  = 1 # Variable c_int
CTRY_PUERTO_RICO        = 1 # Variable c_int
CTRY_JAMAICA            = 1 # Variable c_int
CTRY_DOMINICAN_REPUBLIC = 1 # Variable c_int
CTRY_CARIBBEAN          = 1 # Variable c_int
CTRY_CANADA             = 2 # Variable c_int
CTRY_RUSSIA             = 7 # Variable c_int
CTRY_EGYPT              = 20 # Variable c_int
CTRY_SOUTH_AFRICA       = 27 # Variable c_int
CTRY_GREECE             = 30 # Variable c_int
CTRY_NETHERLANDS        = 31 # Variable c_int
CTRY_BELGIUM            = 32 # Variable c_int
CTRY_FRANCE             = 33 # Variable c_int
CTRY_MONACO             = 33 # Variable c_int
CTRY_SPAIN              = 34 # Variable c_int
CTRY_HUNGARY            = 36 # Variable c_int
CTRY_ITALY              = 39 # Variable c_int
CTRY_ROMANIA            = 40 # Variable c_int
CTRY_LIECHTENSTEIN      = 41 # Variable c_int
CTRY_SWITZERLAND        = 41 # Variable c_int
CTRY_AUSTRIA            = 43 # Variable c_int
CTRY_UNITED_KINGDOM     = 44 # Variable c_int
CTRY_DENMARK            = 45 # Variable c_int
CTRY_SWEDEN             = 46 # Variable c_int
CTRY_NORWAY             = 47 # Variable c_int
CTRY_POLAND             = 48 # Variable c_int
CTRY_GERMANY            = 49 # Variable c_int
CTRY_PERU               = 51 # Variable c_int
CTRY_MEXICO             = 52 # Variable c_int
CTRY_ARGENTINA          = 54 # Variable c_int
CTRY_BRAZIL             = 55 # Variable c_int
CTRY_CHILE              = 56 # Variable c_int
CTRY_COLOMBIA           = 57 # Variable c_int
CTRY_VENEZUELA          = 58 # Variable c_int
CTRY_MALAYSIA           = 60 # Variable c_int
CTRY_AUSTRALIA          = 61 # Variable c_int
CTRY_INDONESIA          = 62 # Variable c_int
CTRY_PHILIPPINES        = 63 # Variable c_int
CTRY_NEW_ZEALAND        = 64 # Variable c_int
CTRY_SINGAPORE          = 65 # Variable c_int
CTRY_THAILAND           = 66 # Variable c_int
CTRY_JAPAN              = 81 # Variable c_int
CTRY_SOUTH_KOREA        = 82 # Variable c_int
CTRY_VIET_NAM           = 84 # Variable c_int
CTRY_PRCHINA            = 86 # Variable c_int
CTRY_TURKEY             = 90 # Variable c_int
CTRY_INDIA              = 91 # Variable c_int
CTRY_PAKISTAN           = 92 # Variable c_int
CTRY_MOROCCO            = 212 # Variable c_int
CTRY_ALGERIA            = 213 # Variable c_int
CTRY_TUNISIA            = 216 # Variable c_int
CTRY_LIBYA              = 218 # Variable c_int
CTRY_KENYA              = 254 # Variable c_int
CTRY_ZIMBABWE           = 263 # Variable c_int
CTRY_FAEROE_ISLANDS     = 298 # Variable c_int
CTRY_PORTUGAL           = 351 # Variable c_int
CTRY_LUXEMBOURG         = 352 # Variable c_int
CTRY_IRELAND            = 353 # Variable c_int
CTRY_ICELAND            = 354 # Variable c_int
CTRY_ALBANIA            = 355 # Variable c_int
CTRY_FINLAND            = 358 # Variable c_int
CTRY_BULGARIA           = 359 # Variable c_int
CTRY_LITHUANIA          = 370 # Variable c_int
CTRY_LATVIA             = 371 # Variable c_int
CTRY_ESTONIA            = 372 # Variable c_int
CTRY_BELARUS            = 375 # Variable c_int
CTRY_UKRAINE            = 380 # Variable c_int
CTRY_SERBIA             = 381 # Variable c_int
CTRY_CROATIA            = 385 # Variable c_int
CTRY_SLOVENIA           = 386 # Variable c_int
CTRY_MACEDONIA          = 389 # Variable c_int
CTRY_CZECH              = 420 # Variable c_int
CTRY_SLOVAK             = 421 # Variable c_int
CTRY_BELIZE             = 501 # Variable c_int
CTRY_GUATEMALA          = 502 # Variable c_int
CTRY_EL_SALVADOR        = 503 # Variable c_int
CTRY_HONDURAS           = 504 # Variable c_int
CTRY_NICARAGUA          = 505 # Variable c_int
CTRY_COSTA_RICA         = 506 # Variable c_int
CTRY_PANAMA             = 507 # Variable c_int
CTRY_BOLIVIA            = 591 # Variable c_int
CTRY_ECUADOR            = 593 # Variable c_int
CTRY_PARAGUAY           = 595 # Variable c_int
CTRY_URUGUAY            = 598 # Variable c_int
CTRY_BRUNEI_DARUSSALAM  = 673 # Variable c_int
CTRY_HONG_KONG          = 852 # Variable c_int
CTRY_MACAU              = 853 # Variable c_int
CTRY_TAIWAN             = 886 # Variable c_int
CTRY_LEBANON            = 961 # Variable c_int
CTRY_JORDAN             = 962 # Variable c_int
CTRY_SYRIA              = 963 # Variable c_int
CTRY_IRAQ               = 964 # Variable c_int
CTRY_KUWAIT             = 965 # Variable c_int
CTRY_SAUDI_ARABIA       = 966 # Variable c_int
CTRY_YEMEN              = 967 # Variable c_int
CTRY_OMAN               = 968 # Variable c_int
CTRY_UAE                = 971 # Variable c_int
CTRY_ISRAEL             = 972 # Variable c_int
CTRY_BAHRAIN            = 973 # Variable c_int
CTRY_QATAR              = 974 # Variable c_int
CTRY_IRAN               = 981 # Variable c_int

CT_CTYPE1 = 1 # Variable c_int
CT_CTYPE2 = 2 # Variable c_int
CT_CTYPE3 = 4 # Variable c_int

CUDR_NORMAL             = win32con.CUDR_NORMAL # 0
CUDR_NOSNAPTOGRID       = win32con.CUDR_NOSNAPTOGRID # 1
CUDR_NORESOLVEPOSITIONS = win32con.CUDR_NORESOLVEPOSITIONS # 2
CUDR_NOCLOSEGAPS        = win32con.CUDR_NOCLOSEGAPS # 4
CUDR_NEGATIVECOORDS     = win32con.CUDR_NEGATIVECOORDS # 8
CUDR_NOPRIMARY          = win32con.CUDR_NOPRIMARY # 16

CWP_ALL             = win32con.CWP_ALL # 0
CWP_SKIPINVISIBLE   = win32con.CWP_SKIPINVISIBLE # 1
CWP_SKIPDISABLED    = win32con.CWP_SKIPDISABLED # 2
CWP_SKIPTRANSPARENT = win32con.CWP_SKIPTRANSPARENT # 4

CW_USEDEFAULT = win32con.CW_USEDEFAULT # -2147483648

DACL_SECURITY_INFORMATION = win32con.DACL_SECURITY_INFORMATION # 4

DATABITS_5   = 1 # Variable c_ushort
DATABITS_6   = 2 # Variable c_ushort
DATABITS_7   = 4 # Variable c_ushort
DATABITS_8   = 8 # Variable c_ushort
DATABITS_16  = 16 # Variable c_ushort
DATABITS_16X = 32 # Variable c_ushort

DATADIR_GET = 1
DATADIR_SET = 2

DATA_S_SAMEFORMATETC = 262448 # Variable c_long
DATA_S_FIRST         = 262448 # Variable c_long
DATA_S_LAST          = 262463 # Variable c_long
DATA_E_FIRST         = 2147746096 # Variable c_ulong
DATA_E_LAST          = 2147746111 # Variable c_ulong

DATETIMEPICK_CLASSA = 'SysDateTimePick32' # Variable POINTER(c_char)
DATETIMEPICK_CLASSW = 'SysDateTimePick32' # Variable POINTER(c_wchar)

DATE_SHORTDATE        = 1 # Variable c_int
DATE_LONGDATE         = 2 # Variable c_int
DATE_USE_ALT_CALENDAR = 4 # Variable c_int

DBG_CONTINUE              = 65538 # Variable c_ulong
DBG_TERMINATE_THREAD      = 1073807363 # Variable c_ulong
DBG_TERMINATE_PROCESS     = 1073807364 # Variable c_ulong
DBG_CONTROL_C             = 1073807365 # Variable c_ulong
DBG_CONTROL_BREAK         = 1073807368 # Variable c_ulong
DBG_EXCEPTION_NOT_HANDLED = 2147549185 # Variable c_ulong

DCBA_FACEUPNONE     = win32con.DCBA_FACEUPNONE # 0
DCBA_FACEUPCENTER   = win32con.DCBA_FACEUPCENTER # 1
DCBA_FACEUPLEFT     = win32con.DCBA_FACEUPLEFT # 2
DCBA_FACEUPRIGHT    = win32con.DCBA_FACEUPRIGHT # 3
DCBA_FACEDOWNNONE   = win32con.DCBA_FACEDOWNNONE # 256
DCBA_FACEDOWNCENTER = win32con.DCBA_FACEDOWNCENTER # 257
DCBA_FACEDOWNLEFT   = win32con.DCBA_FACEDOWNLEFT # 258
DCBA_FACEDOWNRIGHT  = win32con.DCBA_FACEDOWNRIGHT # 259

DCB_RESET      = win32con.DCB_RESET # 1
DCB_ACCUMULATE = win32con.DCB_ACCUMULATE # 2
DCB_SET        = win32con.DCB_SET # 3
DCB_ENABLE     = win32con.DCB_ENABLE # 4
DCB_DISABLE    = win32con.DCB_DISABLE # 8

DCE_C_ERROR_STRING_LEN = 256 # Variable c_int

DCOM_NONE          = 0
DCOM_CALL_COMPLETE = 1
DCOM_CALL_CANCELED = 2

DCTT_BITMAP           = win32con.DCTT_BITMAP # 1
DCTT_DOWNLOAD         = win32con.DCTT_DOWNLOAD # 2
DCTT_SUBDEV           = win32con.DCTT_SUBDEV # 4
DCTT_DOWNLOAD_OUTLINE = win32con.DCTT_DOWNLOAD_OUTLINE # 8

DCX_WINDOW           = win32con.DCX_WINDOW # 1
DCX_CACHE            = win32con.DCX_CACHE # 2
DCX_NORESETATTRS     = win32con.DCX_NORESETATTRS # 4
DCX_CLIPCHILDREN     = win32con.DCX_CLIPCHILDREN # 8
DCX_CLIPSIBLINGS     = win32con.DCX_CLIPSIBLINGS # 16
DCX_PARENTCLIP       = win32con.DCX_PARENTCLIP # 32
DCX_EXCLUDERGN       = win32con.DCX_EXCLUDERGN # 64
DCX_INTERSECTRGN     = win32con.DCX_INTERSECTRGN # 128
DCX_EXCLUDEUPDATE    = win32con.DCX_EXCLUDEUPDATE # 256
DCX_INTERSECTUPDATE  = win32con.DCX_INTERSECTUPDATE # 512
DCX_LOCKWINDOWUPDATE = win32con.DCX_LOCKWINDOWUPDATE # 1024
DCX_VALIDATE         = win32con.DCX_VALIDATE # 2097152

DC_ACTIVE            = win32con.DC_ACTIVE # 1
DC_FIELDS            = win32con.DC_FIELDS # 1
DC_SMALLCAP          = win32con.DC_SMALLCAP # 2
DC_PAPERS            = win32con.DC_PAPERS # 2
DC_PAPERSIZE         = win32con.DC_PAPERSIZE # 3
DC_ICON              = win32con.DC_ICON # 4
DC_MINEXTENT         = win32con.DC_MINEXTENT # 4
DC_MAXEXTENT         = win32con.DC_MAXEXTENT # 5
DC_BINS              = win32con.DC_BINS # 6
DC_DUPLEX            = win32con.DC_DUPLEX # 7
DC_TEXT              = win32con.DC_TEXT # 8
DC_SIZE              = win32con.DC_SIZE # 8
DC_EXTRA             = win32con.DC_EXTRA # 9
DC_VERSION           = win32con.DC_VERSION # 10
DC_DRIVER            = win32con.DC_DRIVER # 11
DC_BINNAMES          = win32con.DC_BINNAMES # 12
DC_ENUMRESOLUTIONS   = win32con.DC_ENUMRESOLUTIONS # 13
DC_FILEDEPENDENCIES  = win32con.DC_FILEDEPENDENCIES # 14
DC_TRUETYPE          = win32con.DC_TRUETYPE # 15
DC_PAPERNAMES        = win32con.DC_PAPERNAMES # 16
DC_INBUTTON          = win32con.DC_INBUTTON # 16
DC_ORIENTATION       = win32con.DC_ORIENTATION # 17
DC_COPIES            = win32con.DC_COPIES # 18
DC_BINADJUST         = win32con.DC_BINADJUST # 19
DC_EMF_COMPLIANT     = win32con.DC_EMF_COMPLIANT # 20
DC_DATATYPE_PRODUCED = win32con.DC_DATATYPE_PRODUCED # 21
DC_COLLATE           = win32con.DC_COLLATE # 22
DC_MANUFACTURER      = win32con.DC_MANUFACTURER # 23
DC_MODEL             = win32con.DC_MODEL # 24
DC_HASDEFID          = win32con.DC_HASDEFID # 21323

DDD_RAW_TARGET_PATH       = win32con.DDD_RAW_TARGET_PATH # 1
DDD_REMOVE_DEFINITION     = win32con.DDD_REMOVE_DEFINITION # 2
DDD_EXACT_MATCH_ON_REMOVE = win32con.DDD_EXACT_MATCH_ON_REMOVE # 4
DDD_NO_BROADCAST_SYSTEM   = 8 # Variable c_int

DDE_FNOTPROCESSED = 0 # Variable c_int
DDE_FAPPSTATUS    = 255 # Variable c_int
DDE_FREQUESTED    = 4096 # Variable c_int
DDE_FRELEASE      = 8192 # Variable c_int
DDE_FBUSY         = 16384 # Variable c_int
DDE_FDEFERUPD     = 16384 # Variable c_int
DDE_FACKREQ       = 32768 # Variable c_int
DDE_FACK          = 32768 # Variable c_int
DDE_FPOKRESERVED  = -8193 # Variable c_int
DDE_FDATRESERVED  = -45057 # Variable c_int
DDE_FADVRESERVED  = -49153 # Variable c_int
DDE_FACKRESERVED  = -49408 # Variable c_int

DDL_READWRITE = win32con.DDL_READWRITE # 0
DDL_READONLY  = win32con.DDL_READONLY # 1
DDL_HIDDEN    = win32con.DDL_HIDDEN # 2
DDL_SYSTEM    = win32con.DDL_SYSTEM # 4
DDL_DIRECTORY = win32con.DDL_DIRECTORY # 16
DDL_ARCHIVE   = win32con.DDL_ARCHIVE # 32
DDL_POSTMSGS  = win32con.DDL_POSTMSGS # 8192
DDL_DRIVES    = win32con.DDL_DRIVES # 16384
DDL_EXCLUSIVE = win32con.DDL_EXCLUSIVE # 32768

DD_DEFDRAGMINDIST    = 2 # Variable c_int
DD_DEFSCROLLINSET    = 11 # Variable c_int
DD_DEFSCROLLDELAY    = 50 # Variable c_int
DD_DEFSCROLLINTERVAL = 50 # Variable c_int
DD_DEFDRAGDELAY      = 200 # Variable c_int

DEBUG_PROCESS           = win32con.DEBUG_PROCESS # 1
DEBUG_ONLY_THIS_PROCESS = win32con.DEBUG_ONLY_THIS_PROCESS # 2

DECIMAL_NEG = 128 # Variable c_ubyte

DEFAULT_PITCH    = win32con.DEFAULT_PITCH # 0
DEFAULT_QUALITY  = win32con.DEFAULT_QUALITY # 0
DEFAULT_CHARSET  = win32con.DEFAULT_CHARSET # 1
DEFAULT_PALETTE  = win32con.DEFAULT_PALETTE # 15
DEFAULT_GUI_FONT = 17 # Variable c_int

DEF_PRIORITY = 1 # Variable c_int

DESCKIND_NONE           = 0
DESCKIND_FUNCDESC       = 1
DESCKIND_VARDESC        = 2
DESCKIND_TYPECOMP       = 3
DESCKIND_IMPLICITAPPOBJ = 4
DESCKIND_MAX            = 5

DESKTOP_READOBJECTS     = win32con.DESKTOP_READOBJECTS # 1
DESKTOP_CREATEWINDOW    = win32con.DESKTOP_CREATEWINDOW # 2
DESKTOP_CREATEMENU      = win32con.DESKTOP_CREATEMENU # 4
DESKTOP_HOOKCONTROL     = win32con.DESKTOP_HOOKCONTROL # 8
DESKTOP_JOURNALRECORD   = win32con.DESKTOP_JOURNALRECORD # 16
DESKTOP_JOURNALPLAYBACK = win32con.DESKTOP_JOURNALPLAYBACK # 32
DESKTOP_ENUMERATE       = win32con.DESKTOP_ENUMERATE # 64
DESKTOP_WRITEOBJECTS    = win32con.DESKTOP_WRITEOBJECTS # 128
DESKTOP_SWITCHDESKTOP   = win32con.DESKTOP_SWITCHDESKTOP # 256

DETACHED_PROCESS = win32con.DETACHED_PROCESS # 8

DEVICE_FONTTYPE     = win32con.DEVICE_FONTTYPE # 2
DEVICE_DEFAULT_FONT = win32con.DEVICE_DEFAULT_FONT # 14

DFCS_MENUARROW           = win32con.DFCS_MENUARROW # 0
DFCS_SCROLLUP            = win32con.DFCS_SCROLLUP # 0
DFCS_CAPTIONCLOSE        = win32con.DFCS_CAPTIONCLOSE # 0
DFCS_BUTTONCHECK         = win32con.DFCS_BUTTONCHECK # 0
DFCS_SCROLLDOWN          = win32con.DFCS_SCROLLDOWN # 1
DFCS_MENUCHECK           = win32con.DFCS_MENUCHECK # 1
DFCS_BUTTONRADIOIMAGE    = win32con.DFCS_BUTTONRADIOIMAGE # 1
DFCS_CAPTIONMIN          = win32con.DFCS_CAPTIONMIN # 1
DFCS_MENUBULLET          = win32con.DFCS_MENUBULLET # 2
DFCS_BUTTONRADIOMASK     = win32con.DFCS_BUTTONRADIOMASK # 2
DFCS_SCROLLLEFT          = win32con.DFCS_SCROLLLEFT # 2
DFCS_CAPTIONMAX          = win32con.DFCS_CAPTIONMAX # 2
DFCS_CAPTIONRESTORE      = win32con.DFCS_CAPTIONRESTORE # 3
DFCS_SCROLLRIGHT         = win32con.DFCS_SCROLLRIGHT # 3
DFCS_BUTTONRADIO         = win32con.DFCS_BUTTONRADIO # 4
DFCS_MENUARROWRIGHT      = win32con.DFCS_MENUARROWRIGHT # 4
DFCS_CAPTIONHELP         = win32con.DFCS_CAPTIONHELP # 4
DFCS_SCROLLCOMBOBOX      = win32con.DFCS_SCROLLCOMBOBOX # 5
DFCS_SCROLLSIZEGRIP      = win32con.DFCS_SCROLLSIZEGRIP # 8
DFCS_BUTTON3STATE        = win32con.DFCS_BUTTON3STATE # 8
DFCS_SCROLLSIZEGRIPRIGHT = win32con.DFCS_SCROLLSIZEGRIPRIGHT # 16
DFCS_BUTTONPUSH          = win32con.DFCS_BUTTONPUSH # 16
DFCS_INACTIVE            = win32con.DFCS_INACTIVE # 256
DFCS_PUSHED              = win32con.DFCS_PUSHED # 512
DFCS_CHECKED             = win32con.DFCS_CHECKED # 1024
DFCS_ADJUSTRECT          = win32con.DFCS_ADJUSTRECT # 8192
DFCS_FLAT                = win32con.DFCS_FLAT # 16384
DFCS_MONO                = win32con.DFCS_MONO # 32768

DFC_CAPTION = win32con.DFC_CAPTION # 1
DFC_MENU    = win32con.DFC_MENU # 2
DFC_SCROLL  = win32con.DFC_SCROLL # 3
DFC_BUTTON  = win32con.DFC_BUTTON # 4

DF_ALLOWOTHERACCOUNTHOOK = win32con.DF_ALLOWOTHERACCOUNTHOOK # 1

DIALOPTION_BILLING  = 64 # Variable c_int
DIALOPTION_QUIET    = 128 # Variable c_int
DIALOPTION_DIALTONE = 256 # Variable c_int

DIB_RGB_COLORS = win32con.DIB_RGB_COLORS # 0
DIB_PAL_COLORS = win32con.DIB_PAL_COLORS # 1

DIGSIG_E_CRYPTO        = -2146762744 # Variable c_long
DIGSIG_E_EXTENSIBILITY = -2146762745 # Variable c_long
DIGSIG_E_DECODE        = -2146762746 # Variable c_long
DIGSIG_E_ENCODE        = -2146762747 # Variable c_long

DISCARDCACHE_SAVEIFDIRTY = 0
DISCARDCACHE_NOSAVE      = 1

DISC_UPDATE_PROFILE = 1 # Variable c_int
DISC_NO_FORCE       = 64 # Variable c_int

DISPATCH_METHOD         = 1 # Variable c_int
DISPATCH_PROPERTYGET    = 2 # Variable c_int
DISPATCH_PROPERTYPUT    = 4 # Variable c_int
DISPATCH_PROPERTYPUTREF = 8 # Variable c_int

DISPID_VALUE       = 0 # Variable c_int
DISPID_UNKNOWN     = -1 # Variable c_int
DISPID_PROPERTYPUT = -3 # Variable c_int
DISPID_NEWENUM     = -4 # Variable c_int
DISPID_EVALUATE    = -5 # Variable c_int
DISPID_CONSTRUCTOR = -6 # Variable c_int
DISPID_DESTRUCTOR  = -7 # Variable c_int
DISPID_COLLECT     = -8 # Variable c_int

DISPLAY_DEVICE_ATTACHED_TO_DESKTOP = win32con.DISPLAY_DEVICE_ATTACHED_TO_DESKTOP # 1
DISPLAY_DEVICE_MULTI_DRIVER        = win32con.DISPLAY_DEVICE_MULTI_DRIVER # 2
DISPLAY_DEVICE_PRIMARY_DEVICE      = win32con.DISPLAY_DEVICE_PRIMARY_DEVICE # 4
DISPLAY_DEVICE_MIRRORING_DRIVER    = win32con.DISPLAY_DEVICE_MIRRORING_DRIVER # 8
DISPLAY_DEVICE_VGA_COMPATIBLE      = win32con.DISPLAY_DEVICE_VGA_COMPATIBLE # 16

DISP_CHANGE_SUCCESSFUL  = win32con.DISP_CHANGE_SUCCESSFUL # 0
DISP_CHANGE_RESTART     = win32con.DISP_CHANGE_RESTART # 1
DISP_CHANGE_FAILED      = win32con.DISP_CHANGE_FAILED # -1
DISP_CHANGE_BADMODE     = win32con.DISP_CHANGE_BADMODE # -2
DISP_CHANGE_NOTUPDATED  = win32con.DISP_CHANGE_NOTUPDATED # -3
DISP_CHANGE_BADFLAGS    = win32con.DISP_CHANGE_BADFLAGS # -4
DISP_CHANGE_BADPARAM    = win32con.DISP_CHANGE_BADPARAM # -5
DISP_E_DIVBYZERO        = -2147352558 # Variable c_long
DISP_E_NOTACOLLECTION   = -2147352559 # Variable c_long
DISP_E_BADCALLEE        = -2147352560 # Variable c_long
DISP_E_PARAMNOTOPTIONAL = -2147352561 # Variable c_long
DISP_E_BADPARAMCOUNT    = -2147352562 # Variable c_long
DISP_E_ARRAYISLOCKED    = -2147352563 # Variable c_long
DISP_E_UNKNOWNLCID      = -2147352564 # Variable c_long
DISP_E_BADINDEX         = -2147352565 # Variable c_long
DISP_E_OVERFLOW         = -2147352566 # Variable c_long
DISP_E_EXCEPTION        = -2147352567 # Variable c_long
DISP_E_BADVARTYPE       = -2147352568 # Variable c_long
DISP_E_NONAMEDARGS      = -2147352569 # Variable c_long
DISP_E_UNKNOWNNAME      = -2147352570 # Variable c_long
DISP_E_TYPEMISMATCH     = -2147352571 # Variable c_long
DISP_E_PARAMNOTFOUND    = -2147352572 # Variable c_long
DISP_E_MEMBERNOTFOUND   = -2147352573 # Variable c_long
DISP_E_UNKNOWNINTERFACE = -2147352575 # Variable c_long

DI_CHANNEL               = 1 # Variable c_int
DI_APPBANDING            = 1 # Variable c_int
DI_MASK                  = win32con.DI_MASK # 1
DI_IMAGE                 = win32con.DI_IMAGE # 2
DI_ROPS_READ_DESTINATION = 2 # Variable c_int
DI_NORMAL                = win32con.DI_NORMAL # 3
DI_READ_SPOOL_JOB        = 3 # Variable c_int
DI_COMPAT                = win32con.DI_COMPAT # 4
DI_DEFAULTSIZE           = win32con.DI_DEFAULTSIZE # 8

DKGRAY_BRUSH = win32con.DKGRAY_BRUSH # 3

DLGC_WANTARROWS      = win32con.DLGC_WANTARROWS # 1
DLGC_WANTTAB         = win32con.DLGC_WANTTAB # 2
DLGC_WANTALLKEYS     = win32con.DLGC_WANTALLKEYS # 4
DLGC_WANTMESSAGE     = win32con.DLGC_WANTMESSAGE # 4
DLGC_HASSETSEL       = win32con.DLGC_HASSETSEL # 8
DLGC_DEFPUSHBUTTON   = win32con.DLGC_DEFPUSHBUTTON # 16
DLGC_UNDEFPUSHBUTTON = win32con.DLGC_UNDEFPUSHBUTTON # 32
DLGC_RADIOBUTTON     = win32con.DLGC_RADIOBUTTON # 64
DLGC_WANTCHARS       = win32con.DLGC_WANTCHARS # 128
DLGC_STATIC          = win32con.DLGC_STATIC # 256
DLGC_BUTTON          = win32con.DLGC_BUTTON # 8192

DLL_PROCESS_DETACH = win32con.DLL_PROCESS_DETACH # 0
DLL_PROCESS_ATTACH = win32con.DLL_PROCESS_ATTACH # 1
DLL_THREAD_ATTACH  = win32con.DLL_THREAD_ATTACH # 2
DLL_THREAD_DETACH  = win32con.DLL_THREAD_DETACH # 3

DL_CURSORSET  = 0 # Variable c_int
DL_STOPCURSOR = 1 # Variable c_int
DL_COPYCURSOR = 2 # Variable c_int
DL_MOVECURSOR = 3 # Variable c_int
DL_BEGINDRAG  = 1157 # Variable c_int
DL_DRAGGING   = 1158 # Variable c_int
DL_DROPPED    = 1159 # Variable c_int
DL_CANCELDRAG = 1160 # Variable c_int

DMBIN_ONLYONE       = win32con.DMBIN_ONLYONE # 1
DMBIN_UPPER         = win32con.DMBIN_UPPER # 1
DMBIN_LOWER         = win32con.DMBIN_LOWER # 2
DMBIN_MIDDLE        = win32con.DMBIN_MIDDLE # 3
DMBIN_MANUAL        = win32con.DMBIN_MANUAL # 4
DMBIN_ENVELOPE      = win32con.DMBIN_ENVELOPE # 5
DMBIN_ENVMANUAL     = win32con.DMBIN_ENVMANUAL # 6
DMBIN_AUTO          = win32con.DMBIN_AUTO # 7
DMBIN_TRACTOR       = win32con.DMBIN_TRACTOR # 8
DMBIN_SMALLFMT      = win32con.DMBIN_SMALLFMT # 9
DMBIN_LARGEFMT      = win32con.DMBIN_LARGEFMT # 10
DMBIN_LARGECAPACITY = win32con.DMBIN_LARGECAPACITY # 11
DMBIN_CASSETTE      = win32con.DMBIN_CASSETTE # 14
DMBIN_FORMSOURCE    = win32con.DMBIN_FORMSOURCE # 15
DMBIN_USER          = win32con.DMBIN_USER # 256

DMCOLLATE_FALSE = win32con.DMCOLLATE_FALSE # 0
DMCOLLATE_TRUE  = win32con.DMCOLLATE_TRUE # 1

DMCOLOR_MONOCHROME = win32con.DMCOLOR_MONOCHROME # 1
DMCOLOR_COLOR      = win32con.DMCOLOR_COLOR # 2

DMDISPLAYFLAGS_TEXTMODE = 4 # Variable c_int

DMDITHER_NONE           = win32con.DMDITHER_NONE # 1
DMDITHER_COARSE         = win32con.DMDITHER_COARSE # 2
DMDITHER_FINE           = win32con.DMDITHER_FINE # 3
DMDITHER_LINEART        = win32con.DMDITHER_LINEART # 4
DMDITHER_ERRORDIFFUSION = win32con.DMDITHER_ERRORDIFFUSION # 5
DMDITHER_RESERVED6      = win32con.DMDITHER_RESERVED6 # 6
DMDITHER_RESERVED7      = win32con.DMDITHER_RESERVED7 # 7
DMDITHER_RESERVED8      = win32con.DMDITHER_RESERVED8 # 8
DMDITHER_RESERVED9      = win32con.DMDITHER_RESERVED9 # 9
DMDITHER_GRAYSCALE      = win32con.DMDITHER_GRAYSCALE # 10
DMDITHER_USER           = win32con.DMDITHER_USER # 256

DMDUP_SIMPLEX    = win32con.DMDUP_SIMPLEX # 1
DMDUP_VERTICAL   = win32con.DMDUP_VERTICAL # 2
DMDUP_HORIZONTAL = win32con.DMDUP_HORIZONTAL # 3

DMICMMETHOD_NONE   = win32con.DMICMMETHOD_NONE # 1
DMICMMETHOD_SYSTEM = win32con.DMICMMETHOD_SYSTEM # 2
DMICMMETHOD_DRIVER = win32con.DMICMMETHOD_DRIVER # 3
DMICMMETHOD_DEVICE = win32con.DMICMMETHOD_DEVICE # 4
DMICMMETHOD_USER   = win32con.DMICMMETHOD_USER # 256

DMICM_SATURATE         = win32con.DMICM_SATURATE # 1
DMICM_CONTRAST         = win32con.DMICM_CONTRAST # 2
DMICM_COLORIMETRIC     = win32con.DMICM_COLORIMETRIC # 3
DMICM_ABS_COLORIMETRIC = win32con.DMICM_ABS_COLORIMETRIC # 4
DMICM_USER             = win32con.DMICM_USER # 256

DMLERR_NO_ERROR            = 0 # Variable c_int
DMLERR_ADVACKTIMEOUT       = 16384 # Variable c_int
DMLERR_FIRST               = 16384 # Variable c_int
DMLERR_BUSY                = 16385 # Variable c_int
DMLERR_DATAACKTIMEOUT      = 16386 # Variable c_int
DMLERR_DLL_NOT_INITIALIZED = 16387 # Variable c_int
DMLERR_DLL_USAGE           = 16388 # Variable c_int
DMLERR_EXECACKTIMEOUT      = 16389 # Variable c_int
DMLERR_INVALIDPARAMETER    = 16390 # Variable c_int
DMLERR_LOW_MEMORY          = 16391 # Variable c_int
DMLERR_MEMORY_ERROR        = 16392 # Variable c_int
DMLERR_NOTPROCESSED        = 16393 # Variable c_int
DMLERR_NO_CONV_ESTABLISHED = 16394 # Variable c_int
DMLERR_POKEACKTIMEOUT      = 16395 # Variable c_int
DMLERR_POSTMSG_FAILED      = 16396 # Variable c_int
DMLERR_REENTRANCY          = 16397 # Variable c_int
DMLERR_SERVER_DIED         = 16398 # Variable c_int
DMLERR_SYS_ERROR           = 16399 # Variable c_int
DMLERR_UNADVACKTIMEOUT     = 16400 # Variable c_int
DMLERR_UNFOUND_QUEUE_ID    = 16401 # Variable c_int
DMLERR_LAST                = 16401 # Variable c_int

DMMEDIA_STANDARD     = win32con.DMMEDIA_STANDARD # 1
DMMEDIA_TRANSPARENCY = win32con.DMMEDIA_TRANSPARENCY # 2
DMMEDIA_GLOSSY       = win32con.DMMEDIA_GLOSSY # 3
DMMEDIA_USER         = win32con.DMMEDIA_USER # 256

DMORIENT_PORTRAIT  = win32con.DMORIENT_PORTRAIT # 1
DMORIENT_LANDSCAPE = win32con.DMORIENT_LANDSCAPE # 2

DMPAPER_LETTER                  = win32con.DMPAPER_LETTER # 1
DMPAPER_LETTERSMALL             = win32con.DMPAPER_LETTERSMALL # 2
DMPAPER_TABLOID                 = win32con.DMPAPER_TABLOID # 3
DMPAPER_LEDGER                  = win32con.DMPAPER_LEDGER # 4
DMPAPER_LEGAL                   = win32con.DMPAPER_LEGAL # 5
DMPAPER_STATEMENT               = win32con.DMPAPER_STATEMENT # 6
DMPAPER_EXECUTIVE               = win32con.DMPAPER_EXECUTIVE # 7
DMPAPER_A3                      = win32con.DMPAPER_A3 # 8
DMPAPER_A4                      = win32con.DMPAPER_A4 # 9
DMPAPER_A4SMALL                 = win32con.DMPAPER_A4SMALL # 10
DMPAPER_A5                      = win32con.DMPAPER_A5 # 11
DMPAPER_B4                      = win32con.DMPAPER_B4 # 12
DMPAPER_B5                      = win32con.DMPAPER_B5 # 13
DMPAPER_FOLIO                   = win32con.DMPAPER_FOLIO # 14
DMPAPER_QUARTO                  = win32con.DMPAPER_QUARTO # 15
DMPAPER_10X14                   = win32con.DMPAPER_10X14 # 16
DMPAPER_11X17                   = win32con.DMPAPER_11X17 # 17
DMPAPER_NOTE                    = win32con.DMPAPER_NOTE # 18
DMPAPER_ENV_9                   = win32con.DMPAPER_ENV_9 # 19
DMPAPER_ENV_10                  = win32con.DMPAPER_ENV_10 # 20
DMPAPER_ENV_11                  = win32con.DMPAPER_ENV_11 # 21
DMPAPER_ENV_12                  = win32con.DMPAPER_ENV_12 # 22
DMPAPER_ENV_14                  = win32con.DMPAPER_ENV_14 # 23
DMPAPER_CSHEET                  = win32con.DMPAPER_CSHEET # 24
DMPAPER_DSHEET                  = win32con.DMPAPER_DSHEET # 25
DMPAPER_ESHEET                  = win32con.DMPAPER_ESHEET # 26
DMPAPER_ENV_DL                  = win32con.DMPAPER_ENV_DL # 27
DMPAPER_ENV_C5                  = win32con.DMPAPER_ENV_C5 # 28
DMPAPER_ENV_C3                  = win32con.DMPAPER_ENV_C3 # 29
DMPAPER_ENV_C4                  = win32con.DMPAPER_ENV_C4 # 30
DMPAPER_ENV_C6                  = win32con.DMPAPER_ENV_C6 # 31
DMPAPER_ENV_C65                 = win32con.DMPAPER_ENV_C65 # 32
DMPAPER_ENV_B4                  = win32con.DMPAPER_ENV_B4 # 33
DMPAPER_ENV_B5                  = win32con.DMPAPER_ENV_B5 # 34
DMPAPER_ENV_B6                  = win32con.DMPAPER_ENV_B6 # 35
DMPAPER_ENV_ITALY               = win32con.DMPAPER_ENV_ITALY # 36
DMPAPER_ENV_MONARCH             = win32con.DMPAPER_ENV_MONARCH # 37
DMPAPER_ENV_PERSONAL            = win32con.DMPAPER_ENV_PERSONAL # 38
DMPAPER_FANFOLD_US              = win32con.DMPAPER_FANFOLD_US # 39
DMPAPER_FANFOLD_STD_GERMAN      = win32con.DMPAPER_FANFOLD_STD_GERMAN # 40
DMPAPER_FANFOLD_LGL_GERMAN      = win32con.DMPAPER_FANFOLD_LGL_GERMAN # 41
DMPAPER_ISO_B4                  = win32con.DMPAPER_ISO_B4 # 42
DMPAPER_JAPANESE_POSTCARD       = win32con.DMPAPER_JAPANESE_POSTCARD # 43
DMPAPER_9X11                    = win32con.DMPAPER_9X11 # 44
DMPAPER_10X11                   = win32con.DMPAPER_10X11 # 45
DMPAPER_15X11                   = win32con.DMPAPER_15X11 # 46
DMPAPER_ENV_INVITE              = win32con.DMPAPER_ENV_INVITE # 47
DMPAPER_RESERVED_48             = win32con.DMPAPER_RESERVED_48 # 48
DMPAPER_RESERVED_49             = win32con.DMPAPER_RESERVED_49 # 49
DMPAPER_LETTER_EXTRA            = win32con.DMPAPER_LETTER_EXTRA # 50
DMPAPER_LEGAL_EXTRA             = win32con.DMPAPER_LEGAL_EXTRA # 51
DMPAPER_TABLOID_EXTRA           = win32con.DMPAPER_TABLOID_EXTRA # 52
DMPAPER_A4_EXTRA                = win32con.DMPAPER_A4_EXTRA # 53
DMPAPER_LETTER_TRANSVERSE       = win32con.DMPAPER_LETTER_TRANSVERSE # 54
DMPAPER_A4_TRANSVERSE           = win32con.DMPAPER_A4_TRANSVERSE # 55
DMPAPER_LETTER_EXTRA_TRANSVERSE = win32con.DMPAPER_LETTER_EXTRA_TRANSVERSE # 56
DMPAPER_A_PLUS                  = win32con.DMPAPER_A_PLUS # 57
DMPAPER_B_PLUS                  = win32con.DMPAPER_B_PLUS # 58
DMPAPER_LETTER_PLUS             = win32con.DMPAPER_LETTER_PLUS # 59
DMPAPER_A4_PLUS                 = win32con.DMPAPER_A4_PLUS # 60
DMPAPER_A5_TRANSVERSE           = win32con.DMPAPER_A5_TRANSVERSE # 61
DMPAPER_B5_TRANSVERSE           = win32con.DMPAPER_B5_TRANSVERSE # 62
DMPAPER_A3_EXTRA                = win32con.DMPAPER_A3_EXTRA # 63
DMPAPER_A5_EXTRA                = win32con.DMPAPER_A5_EXTRA # 64
DMPAPER_B5_EXTRA                = win32con.DMPAPER_B5_EXTRA # 65
DMPAPER_A2                      = win32con.DMPAPER_A2 # 66
DMPAPER_A3_TRANSVERSE           = win32con.DMPAPER_A3_TRANSVERSE # 67
DMPAPER_A3_EXTRA_TRANSVERSE     = win32con.DMPAPER_A3_EXTRA_TRANSVERSE # 68
DMPAPER_USER                    = win32con.DMPAPER_USER # 256

DMRES_DRAFT  = win32con.DMRES_DRAFT # -1
DMRES_LOW    = win32con.DMRES_LOW # -2
DMRES_MEDIUM = win32con.DMRES_MEDIUM # -3
DMRES_HIGH   = win32con.DMRES_HIGH # -4

DMTT_BITMAP           = win32con.DMTT_BITMAP # 1
DMTT_DOWNLOAD         = win32con.DMTT_DOWNLOAD # 2
DMTT_SUBDEV           = win32con.DMTT_SUBDEV # 3
DMTT_DOWNLOAD_OUTLINE = win32con.DMTT_DOWNLOAD_OUTLINE # 4

DM_UPDATE           = win32con.DM_UPDATE # 1
DM_ORIENTATION      = win32con.DM_ORIENTATION # 1
DM_COPY             = win32con.DM_COPY # 2
DM_PAPERSIZE        = win32con.DM_PAPERSIZE # 2
DM_PROMPT           = win32con.DM_PROMPT # 4
DM_PAPERLENGTH      = win32con.DM_PAPERLENGTH # 4
DM_MODIFY           = win32con.DM_MODIFY # 8
DM_PAPERWIDTH       = win32con.DM_PAPERWIDTH # 8
DM_SCALE            = win32con.DM_SCALE # 16
DM_COPIES           = win32con.DM_COPIES # 256
DM_DEFAULTSOURCE    = win32con.DM_DEFAULTSOURCE # 512
DM_GETDEFID         = win32con.DM_GETDEFID # 1024
DM_SPECVERSION      = win32con.DM_SPECVERSION # 800
DM_PRINTQUALITY     = win32con.DM_PRINTQUALITY # 1024
DM_SETDEFID         = win32con.DM_SETDEFID # 1025
DM_REPOSITION       = win32con.DM_REPOSITION # 1026
DM_COLOR            = win32con.DM_COLOR # 2048
DM_DUPLEX           = win32con.DM_DUPLEX # 4096
DM_YRESOLUTION      = win32con.DM_YRESOLUTION # 8192
DM_TTOPTION         = win32con.DM_TTOPTION # 16384
DM_COLLATE          = win32con.DM_COLLATE # 32768
DM_FORMNAME         = win32con.DM_FORMNAME # 65536
DM_LOGPIXELS        = win32con.DM_LOGPIXELS # 131072
DM_BITSPERPEL       = win32con.DM_BITSPERPEL # 262144
DM_PELSWIDTH        = win32con.DM_PELSWIDTH # 524288
DM_PELSHEIGHT       = win32con.DM_PELSHEIGHT # 1048576
DM_DISPLAYFLAGS     = win32con.DM_DISPLAYFLAGS # 2097152
DM_DISPLAYFREQUENCY = win32con.DM_DISPLAYFREQUENCY # 4194304
DM_ICMMETHOD        = win32con.DM_ICMMETHOD # 8388608
DM_ICMINTENT        = win32con.DM_ICMINTENT # 16777216
DM_MEDIATYPE        = win32con.DM_MEDIATYPE # 33554432
DM_DITHERTYPE       = win32con.DM_DITHERTYPE # 67108864
DM_PANNINGWIDTH     = win32con.DM_PANNINGWIDTH # 134217728
DM_PANNINGHEIGHT    = win32con.DM_PANNINGHEIGHT # 268435456

DNS_REGISTER   = 1 # Variable c_int
DNS_UNREGISTER = 2 # Variable c_int
DNS_FILTERON   = 4 # Variable c_int
DNS_FILTEROFF  = 8 # Variable c_int

DN_DEFAULTPRN = win32con.DN_DEFAULTPRN # 1

DOF_PROGMAN    = win32con.DOF_PROGMAN # 1
DOF_SHELLDATA  = win32con.DOF_SHELLDATA # 2
DOF_EXECUTABLE = win32con.DOF_EXECUTABLE # 32769
DOF_DOCUMENT   = win32con.DOF_DOCUMENT # 32770
DOF_DIRECTORY  = win32con.DOF_DIRECTORY # 32771
DOF_MULTIPLE   = win32con.DOF_MULTIPLE # 32772

DOMAIN_USER_RID_ADMIN          = win32con.DOMAIN_USER_RID_ADMIN # 500
DOMAIN_USER_RID_GUEST          = win32con.DOMAIN_USER_RID_GUEST # 501
DOMAIN_USER_RID_KRBTGT         = 502 # Variable c_long
DOMAIN_GROUP_RID_ADMINS        = win32con.DOMAIN_GROUP_RID_ADMINS # 512
DOMAIN_GROUP_RID_USERS         = win32con.DOMAIN_GROUP_RID_USERS # 513
DOMAIN_GROUP_RID_GUESTS        = win32con.DOMAIN_GROUP_RID_GUESTS # 514
DOMAIN_GROUP_RID_COMPUTERS     = 515 # Variable c_long
DOMAIN_GROUP_RID_CONTROLLERS   = 516 # Variable c_long
DOMAIN_GROUP_RID_CERT_ADMINS   = 517 # Variable c_long
DOMAIN_GROUP_RID_SCHEMA_ADMINS = 518 # Variable c_long
DOMAIN_ALIAS_RID_ADMINS        = win32con.DOMAIN_ALIAS_RID_ADMINS # 544
DOMAIN_ALIAS_RID_USERS         = win32con.DOMAIN_ALIAS_RID_USERS # 545
DOMAIN_ALIAS_RID_GUESTS        = win32con.DOMAIN_ALIAS_RID_GUESTS # 546
DOMAIN_ALIAS_RID_POWER_USERS   = win32con.DOMAIN_ALIAS_RID_POWER_USERS # 547
DOMAIN_ALIAS_RID_ACCOUNT_OPS   = win32con.DOMAIN_ALIAS_RID_ACCOUNT_OPS # 548
DOMAIN_ALIAS_RID_SYSTEM_OPS    = win32con.DOMAIN_ALIAS_RID_SYSTEM_OPS # 549
DOMAIN_ALIAS_RID_PRINT_OPS     = win32con.DOMAIN_ALIAS_RID_PRINT_OPS # 550
DOMAIN_ALIAS_RID_BACKUP_OPS    = win32con.DOMAIN_ALIAS_RID_BACKUP_OPS # 551
DOMAIN_ALIAS_RID_REPLICATOR    = win32con.DOMAIN_ALIAS_RID_REPLICATOR # 552

DONT_RESOLVE_DLL_REFERENCES = win32con.DONT_RESOLVE_DLL_REFERENCES # 1

DOUBLE_CLICK = win32con.DOUBLE_CLICK # 2

DO_DROPFILE  = win32con.DO_DROPFILE # 1162627398
DO_PRINTFILE = win32con.DO_PRINTFILE # 1414419024

DPD_DELETE_UNUSED_FILES     = 1 # Variable c_int
DPD_DELETE_SPECIFIC_VERSION = 2 # Variable c_int
DPD_DELETE_ALL_FILES        = 4 # Variable c_int

DRAFT_QUALITY = win32con.DRAFT_QUALITY # 1

DRAGDROP_S_DROP              = 262400 # Variable c_long
DRAGDROP_S_FIRST             = 262400 # Variable c_long
DRAGDROP_S_CANCEL            = 262401 # Variable c_long
DRAGDROP_S_USEDEFAULTCURSORS = 262402 # Variable c_long
DRAGDROP_S_LAST              = 262415 # Variable c_long
DRAGDROP_E_FIRST             = 2147746048 # Variable c_ulong
DRAGDROP_E_LAST              = 2147746063 # Variable c_ulong
DRAGDROP_E_INVALIDHWND       = -2147221246 # Variable c_long
DRAGDROP_E_ALREADYREGISTERED = -2147221247 # Variable c_long
DRAGDROP_E_NOTREGISTERED     = -2147221248 # Variable c_long

DRIVE_UNKNOWN     = win32con.DRIVE_UNKNOWN # 0
DRIVE_NO_ROOT_DIR = win32con.DRIVE_NO_ROOT_DIR # 1
DRIVE_REMOVABLE   = win32con.DRIVE_REMOVABLE # 2
DRIVE_FIXED       = win32con.DRIVE_FIXED # 3
DRIVE_REMOTE      = win32con.DRIVE_REMOTE # 4
DRIVE_CDROM       = win32con.DRIVE_CDROM # 5
DRIVE_RAMDISK     = win32con.DRIVE_RAMDISK # 6

DROPEFFECT_NONE   = 0 # Variable c_int
DROPEFFECT_COPY   = 1 # Variable c_int
DROPEFFECT_MOVE   = 2 # Variable c_int
DROPEFFECT_LINK   = 4 # Variable c_int
DROPEFFECT_SCROLL = 2147483648 # Variable c_uint

DRVCNF_CANCEL  = 0 # Variable c_int
DRVCNF_OK      = 1 # Variable c_int
DRVCNF_RESTART = 2 # Variable c_int

DRV_LOAD           = 1 # Variable c_int
DRV_ENABLE         = 2 # Variable c_int
DRV_OPEN           = 3 # Variable c_int
DRV_CLOSE          = 4 # Variable c_int
DRV_DISABLE        = 5 # Variable c_int
DRV_FREE           = 6 # Variable c_int
DRV_CONFIGURE      = 7 # Variable c_int
DRV_QUERYCONFIGURE = 8 # Variable c_int
DRV_INSTALL        = 9 # Variable c_int
DRV_REMOVE         = 10 # Variable c_int
DRV_EXITSESSION    = 11 # Variable c_int
DRV_POWER          = 15 # Variable c_int
DRV_RESERVED       = 2048 # Variable c_int
DRV_MCI_LAST       = 6143 # Variable c_int
DRV_USER           = 16384 # Variable c_int

DSIG_FONTTYPE = win32con.DSIG_FONTTYPE # 262144

DSPRINT_PUBLISH   = 1 # Variable c_int
DSPRINT_UPDATE    = 2 # Variable c_int
DSPRINT_UNPUBLISH = 3 # Variable c_int

DSS_NORMAL   = win32con.DSS_NORMAL # 0
DSS_UNION    = win32con.DSS_UNION # 16
DSS_DISABLED = win32con.DSS_DISABLED # 32
DSS_MONO     = win32con.DSS_MONO # 128
DSS_RIGHT    = win32con.DSS_RIGHT # 32768

DST_COMPLEX    = win32con.DST_COMPLEX # 0
DST_TEXT       = win32con.DST_TEXT # 1
DST_PREFIXTEXT = win32con.DST_PREFIXTEXT # 2
DST_ICON       = win32con.DST_ICON # 3
DST_BITMAP     = win32con.DST_BITMAP # 4

DS_ABSALIGN      = win32con.DS_ABSALIGN # 1
DS_SYSMODAL      = win32con.DS_SYSMODAL # 2
DS_3DLOOK        = win32con.DS_3DLOOK # 4
DS_FIXEDSYS      = win32con.DS_FIXEDSYS # 8
DS_NOFAILCREATE  = win32con.DS_NOFAILCREATE # 16
DS_LOCALEDIT     = win32con.DS_LOCALEDIT # 32
DS_SETFONT       = win32con.DS_SETFONT # 64
DS_MODALFRAME    = win32con.DS_MODALFRAME # 128
DS_NOIDLEMSG     = win32con.DS_NOIDLEMSG # 256
DS_SETFOREGROUND = win32con.DS_SETFOREGROUND # 512
DS_CONTROL       = win32con.DS_CONTROL # 1024
DS_CENTER        = win32con.DS_CENTER # 2048
DS_CENTERMOUSE   = win32con.DS_CENTERMOUSE # 4096
DS_CONTEXTHELP   = win32con.DS_CONTEXTHELP # 8192

DTM_FIRST         = 4096 # Variable c_int
DTM_GETSYSTEMTIME = 4097 # Variable c_int
DTM_SETSYSTEMTIME = 4098 # Variable c_int
DTM_GETRANGE      = 4099 # Variable c_int
DTM_SETRANGE      = 4100 # Variable c_int
DTM_SETFORMATA    = 4101 # Variable c_int
DTM_SETMCCOLOR    = 4102 # Variable c_int
DTM_GETMCCOLOR    = 4103 # Variable c_int
DTM_GETMONTHCAL   = 4104 # Variable c_int
DTM_SETMCFONT     = 4105 # Variable c_int
DTM_GETMCFONT     = 4106 # Variable c_int
DTM_SETFORMATW    = 4146 # Variable c_int

DTN_LAST           = 4294966497 # Variable c_uint
DTN_FIRST          = 4294966536 # Variable c_uint
DTN_DATETIMECHANGE = 4294966537 # Variable c_uint
DTN_USERSTRINGA    = 4294966538 # Variable c_uint
DTN_WMKEYDOWNA     = 4294966539 # Variable c_uint
DTN_FORMATA        = 4294966540 # Variable c_uint
DTN_FORMATQUERYA   = 4294966541 # Variable c_uint
DTN_DROPDOWN       = 4294966542 # Variable c_uint
DTN_CLOSEUP        = 4294966543 # Variable c_uint
DTN_USERSTRINGW    = 4294966551 # Variable c_uint
DTN_WMKEYDOWNW     = 4294966552 # Variable c_uint
DTN_FORMATW        = 4294966553 # Variable c_uint
DTN_FORMATQUERYW   = 4294966554 # Variable c_uint
DTN_FORMAT         = 4294966540 # Variable c_uint
DTN_FORMATQUERY    = 4294966541 # Variable c_uint
DTN_USERSTRING     = 4294966538 # Variable c_uint
DTN_WMKEYDOWN      = 4294966539 # Variable c_uint

DTR_CONTROL_DISABLE   = win32con.DTR_CONTROL_DISABLE # 0
DTR_CONTROL_ENABLE    = win32con.DTR_CONTROL_ENABLE # 1
DTR_CONTROL_HANDSHAKE = win32con.DTR_CONTROL_HANDSHAKE # 2

DTS_SHORTDATEFORMAT = 0 # Variable c_int
DTS_UPDOWN          = 1 # Variable c_int
DTS_SHOWNONE        = 2 # Variable c_int
DTS_LONGDATEFORMAT  = 4 # Variable c_int
DTS_TIMEFORMAT      = 9 # Variable c_int
DTS_APPCANPARSE     = 16 # Variable c_int
DTS_RIGHTALIGN      = 32 # Variable c_int

DT_LEFT            = win32con.DT_LEFT # 0
DT_TOP             = win32con.DT_TOP # 0
DT_PLOTTER         = win32con.DT_PLOTTER # 0
DT_RASDISPLAY      = win32con.DT_RASDISPLAY # 1
DT_CENTER          = win32con.DT_CENTER # 1
DT_RIGHT           = win32con.DT_RIGHT # 2
DT_RASPRINTER      = win32con.DT_RASPRINTER # 2
DT_RASCAMERA       = win32con.DT_RASCAMERA # 3
DT_CHARSTREAM      = win32con.DT_CHARSTREAM # 4
DT_VCENTER         = win32con.DT_VCENTER # 4
DT_METAFILE        = win32con.DT_METAFILE # 5
DT_DISPFILE        = win32con.DT_DISPFILE # 6
DT_BOTTOM          = win32con.DT_BOTTOM # 8
DT_WORDBREAK       = win32con.DT_WORDBREAK # 16
DT_SINGLELINE      = win32con.DT_SINGLELINE # 32
DT_EXPANDTABS      = win32con.DT_EXPANDTABS # 64
DT_TABSTOP         = win32con.DT_TABSTOP # 128
DT_NOCLIP          = win32con.DT_NOCLIP # 256
DT_EXTERNALLEADING = win32con.DT_EXTERNALLEADING # 512
DT_CALCRECT        = win32con.DT_CALCRECT # 1024
DT_NOPREFIX        = win32con.DT_NOPREFIX # 2048
DT_INTERNAL        = win32con.DT_INTERNAL # 4096
DT_EDITCONTROL     = win32con.DT_EDITCONTROL # 8192
DT_PATH_ELLIPSIS   = win32con.DT_PATH_ELLIPSIS # 16384
DT_END_ELLIPSIS    = win32con.DT_END_ELLIPSIS # 32768
DT_MODIFYSTRING    = win32con.DT_MODIFYSTRING # 65536
DT_RTLREADING      = win32con.DT_RTLREADING # 131072
DT_WORD_ELLIPSIS   = win32con.DT_WORD_ELLIPSIS # 262144

DUPLICATE_CLOSE_SOURCE = win32con.DUPLICATE_CLOSE_SOURCE # 1
DUPLICATE_SAME_ACCESS  = win32con.DUPLICATE_SAME_ACCESS # 2
DUPLICATE_DEREG        = 7 # Variable c_int

DVASPECT_CONTENT   = 1
DVASPECT_THUMBNAIL = 2
DVASPECT_ICON      = 4
DVASPECT_DOCPRINT  = 8

DV_E_NOIVIEWOBJECT       = -2147221395 # Variable c_long
DV_E_DVTARGETDEVICE_SIZE = -2147221396 # Variable c_long
DV_E_DVASPECT            = -2147221397 # Variable c_long
DV_E_CLIPFORMAT          = -2147221398 # Variable c_long
DV_E_TYMED               = -2147221399 # Variable c_long
DV_E_LINDEX              = -2147221400 # Variable c_long
DV_E_STATDATA            = -2147221401 # Variable c_long
DV_E_STGMEDIUM           = -2147221402 # Variable c_long
DV_E_DVTARGETDEVICE      = -2147221403 # Variable c_long
DV_E_FORMATETC           = -2147221404 # Variable c_long

DWL_MSGRESULT = win32con.DWL_MSGRESULT # 0
DWL_DLGPROC   = win32con.DWL_DLGPROC # 4
DWL_USER      = win32con.DWL_USER # 8

EASTEUROPE_CHARSET = win32con.EASTEUROPE_CHARSET # 238

EC_ENABLEALL    = 0 # Variable c_int
EC_LEFTMARGIN   = win32con.EC_LEFTMARGIN # 1
EC_QUERYWAITING = 2 # Variable c_int
EC_RIGHTMARGIN  = win32con.EC_RIGHTMARGIN # 2
EC_USEFONTINFO  = win32con.EC_USEFONTINFO # 65535

EDGE_RAISED = win32con.EDGE_RAISED # 5
EDGE_ETCHED = win32con.EDGE_ETCHED # 6
EDGE_BUMP   = win32con.EDGE_BUMP # 9
EDGE_SUNKEN = win32con.EDGE_SUNKEN # 10

EFS_USE_RECOVERY_KEYS = 1 # Variable c_int

ELF_VERSION       = win32con.ELF_VERSION # 0
ELF_CULTURE_LATIN = win32con.ELF_CULTURE_LATIN # 0
ELF_VENDOR_SIZE   = win32con.ELF_VENDOR_SIZE # 4

EMARCH_ENC_I17_IMM7B_VAL_POS_X        = 0 # Variable c_int
EMARCH_ENC_I17_IMM41c_INST_WORD_POS_X = 0 # Variable c_int
EMARCH_ENC_I17_IMM41a_INST_WORD_X     = 1 # Variable c_int
EMARCH_ENC_I17_IC_SIZE_X              = 1 # Variable c_int
EMARCH_ENC_I17_IMM41b_INST_WORD_X     = 1 # Variable c_int
EMARCH_ENC_I17_SIGN_SIZE_X            = 1 # Variable c_int
EMARCH_ENC_I17_IMM41c_INST_WORD_X     = 2 # Variable c_int
EMARCH_ENC_I17_SIGN_INST_WORD_X       = 3 # Variable c_int
EMARCH_ENC_I17_IMM7B_INST_WORD_X      = 3 # Variable c_int
EMARCH_ENC_I17_IMM9D_INST_WORD_X      = 3 # Variable c_int
EMARCH_ENC_I17_IC_INST_WORD_X         = 3 # Variable c_int
EMARCH_ENC_I17_IMM5C_INST_WORD_X      = 3 # Variable c_int
EMARCH_ENC_I17_IMM7B_INST_WORD_POS_X  = 4 # Variable c_int
EMARCH_ENC_I17_IMM5C_SIZE_X           = 5 # Variable c_int
EMARCH_ENC_I17_IMM7B_SIZE_X           = 7 # Variable c_int
EMARCH_ENC_I17_IMM9D_VAL_POS_X        = 7 # Variable c_int
EMARCH_ENC_I17_IMM41b_SIZE_X          = 8 # Variable c_int
EMARCH_ENC_I17_IMM9D_SIZE_X           = 9 # Variable c_int
EMARCH_ENC_I17_IMM41a_SIZE_X          = 10 # Variable c_int
EMARCH_ENC_I17_IC_INST_WORD_POS_X     = 12 # Variable c_int
EMARCH_ENC_I17_IMM5C_INST_WORD_POS_X  = 13 # Variable c_int
EMARCH_ENC_I17_IMM41a_INST_WORD_POS_X = 14 # Variable c_int
EMARCH_ENC_I17_IMM5C_VAL_POS_X        = 16 # Variable c_int
EMARCH_ENC_I17_IMM9D_INST_WORD_POS_X  = 18 # Variable c_int
EMARCH_ENC_I17_IC_VAL_POS_X           = 21 # Variable c_int
EMARCH_ENC_I17_IMM41a_VAL_POS_X       = 22 # Variable c_int
EMARCH_ENC_I17_IMM41c_SIZE_X          = 23 # Variable c_int
EMARCH_ENC_I17_IMM41b_INST_WORD_POS_X = 24 # Variable c_int
EMARCH_ENC_I17_SIGN_INST_WORD_POS_X   = 27 # Variable c_int
EMARCH_ENC_I17_IMM41b_VAL_POS_X       = 32 # Variable c_int
EMARCH_ENC_I17_IMM41c_VAL_POS_X       = 40 # Variable c_int
EMARCH_ENC_I17_SIGN_VAL_POS_X         = 63 # Variable c_int

EMBDHLP_INPROC_HANDLER = 0 # Variable c_long
EMBDHLP_CREATENOW      = 0 # Variable c_long
EMBDHLP_INPROC_SERVER  = 1 # Variable c_long
EMBDHLP_DELAYCREATE    = 65536 # Variable c_long

EMR_HEADER                  = win32con.EMR_HEADER # 1
EMR_MIN                     = win32con.EMR_MIN # 1
EMR_POLYBEZIER              = win32con.EMR_POLYBEZIER # 2
EMR_POLYGON                 = win32con.EMR_POLYGON # 3
EMR_POLYLINE                = win32con.EMR_POLYLINE # 4
EMR_POLYBEZIERTO            = win32con.EMR_POLYBEZIERTO # 5
EMR_POLYLINETO              = win32con.EMR_POLYLINETO # 6
EMR_POLYPOLYLINE            = win32con.EMR_POLYPOLYLINE # 7
EMR_POLYPOLYGON             = win32con.EMR_POLYPOLYGON # 8
EMR_SETWINDOWEXTEX          = win32con.EMR_SETWINDOWEXTEX # 9
EMR_SETWINDOWORGEX          = win32con.EMR_SETWINDOWORGEX # 10
EMR_SETVIEWPORTEXTEX        = win32con.EMR_SETVIEWPORTEXTEX # 11
EMR_SETVIEWPORTORGEX        = win32con.EMR_SETVIEWPORTORGEX # 12
EMR_SETBRUSHORGEX           = win32con.EMR_SETBRUSHORGEX # 13
EMR_EOF                     = win32con.EMR_EOF # 14
EMR_SETPIXELV               = win32con.EMR_SETPIXELV # 15
EMR_SETMAPPERFLAGS          = win32con.EMR_SETMAPPERFLAGS # 16
EMR_SETMAPMODE              = win32con.EMR_SETMAPMODE # 17
EMR_SETBKMODE               = win32con.EMR_SETBKMODE # 18
EMR_SETPOLYFILLMODE         = win32con.EMR_SETPOLYFILLMODE # 19
EMR_SETROP2                 = win32con.EMR_SETROP2 # 20
EMR_SETSTRETCHBLTMODE       = win32con.EMR_SETSTRETCHBLTMODE # 21
EMR_SETTEXTALIGN            = win32con.EMR_SETTEXTALIGN # 22
EMR_SETCOLORADJUSTMENT      = win32con.EMR_SETCOLORADJUSTMENT # 23
EMR_SETTEXTCOLOR            = win32con.EMR_SETTEXTCOLOR # 24
EMR_SETBKCOLOR              = win32con.EMR_SETBKCOLOR # 25
EMR_OFFSETCLIPRGN           = win32con.EMR_OFFSETCLIPRGN # 26
EMR_MOVETOEX                = win32con.EMR_MOVETOEX # 27
EMR_SETMETARGN              = win32con.EMR_SETMETARGN # 28
EMR_EXCLUDECLIPRECT         = win32con.EMR_EXCLUDECLIPRECT # 29
EMR_INTERSECTCLIPRECT       = win32con.EMR_INTERSECTCLIPRECT # 30
EMR_SCALEVIEWPORTEXTEX      = win32con.EMR_SCALEVIEWPORTEXTEX # 31
EMR_SCALEWINDOWEXTEX        = win32con.EMR_SCALEWINDOWEXTEX # 32
EMR_SAVEDC                  = win32con.EMR_SAVEDC # 33
EMR_RESTOREDC               = win32con.EMR_RESTOREDC # 34
EMR_SETWORLDTRANSFORM       = win32con.EMR_SETWORLDTRANSFORM # 35
EMR_MODIFYWORLDTRANSFORM    = win32con.EMR_MODIFYWORLDTRANSFORM # 36
EMR_SELECTOBJECT            = win32con.EMR_SELECTOBJECT # 37
EMR_CREATEPEN               = win32con.EMR_CREATEPEN # 38
EMR_CREATEBRUSHINDIRECT     = win32con.EMR_CREATEBRUSHINDIRECT # 39
EMR_DELETEOBJECT            = win32con.EMR_DELETEOBJECT # 40
EMR_ANGLEARC                = win32con.EMR_ANGLEARC # 41
EMR_ELLIPSE                 = win32con.EMR_ELLIPSE # 42
EMR_RECTANGLE               = win32con.EMR_RECTANGLE # 43
EMR_ROUNDRECT               = win32con.EMR_ROUNDRECT # 44
EMR_ARC                     = win32con.EMR_ARC # 45
EMR_CHORD                   = win32con.EMR_CHORD # 46
EMR_PIE                     = win32con.EMR_PIE # 47
EMR_SELECTPALETTE           = win32con.EMR_SELECTPALETTE # 48
EMR_CREATEPALETTE           = win32con.EMR_CREATEPALETTE # 49
EMR_SETPALETTEENTRIES       = win32con.EMR_SETPALETTEENTRIES # 50
EMR_RESIZEPALETTE           = win32con.EMR_RESIZEPALETTE # 51
EMR_REALIZEPALETTE          = win32con.EMR_REALIZEPALETTE # 52
EMR_EXTFLOODFILL            = win32con.EMR_EXTFLOODFILL # 53
EMR_LINETO                  = win32con.EMR_LINETO # 54
EMR_ARCTO                   = win32con.EMR_ARCTO # 55
EMR_POLYDRAW                = win32con.EMR_POLYDRAW # 56
EMR_SETARCDIRECTION         = win32con.EMR_SETARCDIRECTION # 57
EMR_SETMITERLIMIT           = win32con.EMR_SETMITERLIMIT # 58
EMR_BEGINPATH               = win32con.EMR_BEGINPATH # 59
EMR_ENDPATH                 = win32con.EMR_ENDPATH # 60
EMR_CLOSEFIGURE             = win32con.EMR_CLOSEFIGURE # 61
EMR_FILLPATH                = win32con.EMR_FILLPATH # 62
EMR_STROKEANDFILLPATH       = win32con.EMR_STROKEANDFILLPATH # 63
EMR_STROKEPATH              = win32con.EMR_STROKEPATH # 64
EMR_FLATTENPATH             = win32con.EMR_FLATTENPATH # 65
EMR_WIDENPATH               = win32con.EMR_WIDENPATH # 66
EMR_SELECTCLIPPATH          = win32con.EMR_SELECTCLIPPATH # 67
EMR_ABORTPATH               = win32con.EMR_ABORTPATH # 68
EMR_GDICOMMENT              = win32con.EMR_GDICOMMENT # 70
EMR_FILLRGN                 = win32con.EMR_FILLRGN # 71
EMR_FRAMERGN                = win32con.EMR_FRAMERGN # 72
EMR_INVERTRGN               = win32con.EMR_INVERTRGN # 73
EMR_PAINTRGN                = win32con.EMR_PAINTRGN # 74
EMR_EXTSELECTCLIPRGN        = win32con.EMR_EXTSELECTCLIPRGN # 75
EMR_BITBLT                  = win32con.EMR_BITBLT # 76
EMR_STRETCHBLT              = win32con.EMR_STRETCHBLT # 77
EMR_MASKBLT                 = win32con.EMR_MASKBLT # 78
EMR_PLGBLT                  = win32con.EMR_PLGBLT # 79
EMR_SETDIBITSTODEVICE       = win32con.EMR_SETDIBITSTODEVICE # 80
EMR_STRETCHDIBITS           = win32con.EMR_STRETCHDIBITS # 81
EMR_EXTCREATEFONTINDIRECTW  = win32con.EMR_EXTCREATEFONTINDIRECTW # 82
EMR_EXTTEXTOUTA             = win32con.EMR_EXTTEXTOUTA # 83
EMR_EXTTEXTOUTW             = win32con.EMR_EXTTEXTOUTW # 84
EMR_POLYBEZIER16            = win32con.EMR_POLYBEZIER16 # 85
EMR_POLYGON16               = win32con.EMR_POLYGON16 # 86
EMR_POLYLINE16              = win32con.EMR_POLYLINE16 # 87
EMR_POLYBEZIERTO16          = win32con.EMR_POLYBEZIERTO16 # 88
EMR_POLYLINETO16            = win32con.EMR_POLYLINETO16 # 89
EMR_POLYPOLYLINE16          = win32con.EMR_POLYPOLYLINE16 # 90
EMR_POLYPOLYGON16           = win32con.EMR_POLYPOLYGON16 # 91
EMR_POLYDRAW16              = win32con.EMR_POLYDRAW16 # 92
EMR_CREATEMONOBRUSH         = win32con.EMR_CREATEMONOBRUSH # 93
EMR_CREATEDIBPATTERNBRUSHPT = win32con.EMR_CREATEDIBPATTERNBRUSHPT # 94
EMR_EXTCREATEPEN            = win32con.EMR_EXTCREATEPEN # 95
EMR_POLYTEXTOUTA            = win32con.EMR_POLYTEXTOUTA # 96
EMR_POLYTEXTOUTW            = win32con.EMR_POLYTEXTOUTW # 97
EMR_SETICMMODE              = 98 # Variable c_int
EMR_CREATECOLORSPACE        = 99 # Variable c_int
EMR_SETCOLORSPACE           = 100 # Variable c_int
EMR_DELETECOLORSPACE        = 101 # Variable c_int
EMR_GLSRECORD               = 102 # Variable c_int
EMR_GLSBOUNDEDRECORD        = 103 # Variable c_int
EMR_MAX                     = win32con.EMR_MAX # 97
EMR_PIXELFORMAT             = 104 # Variable c_int

EM_GETSEL              = win32con.EM_GETSEL # 176
EM_SETSEL              = win32con.EM_SETSEL # 177
EM_GETRECT             = win32con.EM_GETRECT # 178
EM_SETRECT             = win32con.EM_SETRECT # 179
EM_SETRECTNP           = win32con.EM_SETRECTNP # 180
EM_SCROLL              = win32con.EM_SCROLL # 181
EM_LINESCROLL          = win32con.EM_LINESCROLL # 182
EM_SCROLLCARET         = win32con.EM_SCROLLCARET # 183
EM_GETMODIFY           = win32con.EM_GETMODIFY # 184
EM_SETMODIFY           = win32con.EM_SETMODIFY # 185
EM_GETLINECOUNT        = win32con.EM_GETLINECOUNT # 186
EM_LINEINDEX           = win32con.EM_LINEINDEX # 187
EM_SETHANDLE           = win32con.EM_SETHANDLE # 188
EM_GETHANDLE           = win32con.EM_GETHANDLE # 189
EM_GETTHUMB            = win32con.EM_GETTHUMB # 190
EM_LINELENGTH          = win32con.EM_LINELENGTH # 193
EM_REPLACESEL          = win32con.EM_REPLACESEL # 194
EM_GETLINE             = win32con.EM_GETLINE # 196
EM_LIMITTEXT           = win32con.EM_LIMITTEXT # 197
EM_CANUNDO             = win32con.EM_CANUNDO # 198
EM_UNDO                = win32con.EM_UNDO # 199
EM_FMTLINES            = win32con.EM_FMTLINES # 200
EM_LINEFROMCHAR        = win32con.EM_LINEFROMCHAR # 201
EM_SETTABSTOPS         = win32con.EM_SETTABSTOPS # 203
EM_SETPASSWORDCHAR     = win32con.EM_SETPASSWORDCHAR # 204
EM_EMPTYUNDOBUFFER     = win32con.EM_EMPTYUNDOBUFFER # 205
EM_GETFIRSTVISIBLELINE = win32con.EM_GETFIRSTVISIBLELINE # 206
EM_SETREADONLY         = win32con.EM_SETREADONLY # 207
EM_SETWORDBREAKPROC    = win32con.EM_SETWORDBREAKPROC # 208
EM_GETWORDBREAKPROC    = win32con.EM_GETWORDBREAKPROC # 209
EM_GETPASSWORDCHAR     = win32con.EM_GETPASSWORDCHAR # 210
EM_SETMARGINS          = win32con.EM_SETMARGINS # 211
EM_GETMARGINS          = win32con.EM_GETMARGINS # 212
EM_GETLIMITTEXT        = win32con.EM_GETLIMITTEXT # 213
EM_POSFROMCHAR         = win32con.EM_POSFROMCHAR # 214
EM_CHARFROMPOS         = win32con.EM_CHARFROMPOS # 215
EM_SETTEXTEX           = 1121 # Variable c_int

ENABLE_PROCESSED_INPUT    = 1 # Variable c_int
ENABLE_PROCESSED_OUTPUT   = 1 # Variable c_int
ENABLE_LINE_INPUT         = 2 # Variable c_int
ENABLE_WRAP_AT_EOL_OUTPUT = 2 # Variable c_int
ENABLE_ECHO_INPUT         = 4 # Variable c_int
ENABLE_WINDOW_INPUT       = 8 # Variable c_int
ENABLE_MOUSE_INPUT        = 16 # Variable c_int

ENCAPSULATED_POSTSCRIPT = win32con.ENCAPSULATED_POSTSCRIPT # 4116

ENDSESSION_LOGOFF = win32con.ENDSESSION_LOGOFF # -2147483648

END_PATH = win32con.END_PATH # 4098

ENHANCED_KEY = win32con.ENHANCED_KEY # 256

ENHMETA_SIGNATURE    = win32con.ENHMETA_SIGNATURE # 1179469088
ENHMETA_STOCK_OBJECT = win32con.ENHMETA_STOCK_OBJECT # -2147483648

ENUM_S_FIRST           = 262576 # Variable c_long
ENUM_S_LAST            = 262591 # Variable c_long
ENUM_E_FIRST           = 2147746224 # Variable c_ulong
ENUM_E_LAST            = 2147746239 # Variable c_ulong
ENUM_REGISTRY_SETTINGS = win32con.ENUM_REGISTRY_SETTINGS # -2
ENUM_ALL_CALENDARS     = 4294967295 # Variable c_uint
ENUM_CURRENT_SETTINGS  = win32con.ENUM_CURRENT_SETTINGS # -1

EN_SETFOCUS     = win32con.EN_SETFOCUS # 256
EN_KILLFOCUS    = win32con.EN_KILLFOCUS # 512
EN_CHANGE       = win32con.EN_CHANGE # 768
EN_UPDATE       = win32con.EN_UPDATE # 1024
EN_ERRSPACE     = win32con.EN_ERRSPACE # 1280
EN_MAXTEXT      = win32con.EN_MAXTEXT # 1281
EN_HSCROLL      = win32con.EN_HSCROLL # 1537
EN_VSCROLL      = win32con.EN_VSCROLL # 1538
EN_ALIGN_LTR_EC = 1792
EN_ALIGN_RTL_EC = 1793

EPS_SIGNATURE = 1179865157 # Variable c_int

EPT_S_INVALID_ENTRY   = 1751 # Variable c_long
EPT_S_CANT_PERFORM_OP = 1752 # Variable c_long
EPT_S_NOT_REGISTERED  = 1753 # Variable c_long
EPT_S_CANT_CREATE     = 1899 # Variable c_long

ERROR_SEVERITY_SUCCESS                   = win32con.ERROR_SEVERITY_SUCCESS # 0
ERROR_SUCCESS                            = 0 # Variable c_long
ERROR_INVALID_FUNCTION                   = 1 # Variable c_long
ERROR_FILE_NOT_FOUND                     = 2 # Variable c_long
ERROR_PATH_NOT_FOUND                     = 3 # Variable c_long
ERROR_TOO_MANY_OPEN_FILES                = 4 # Variable c_long
ERROR_ACCESS_DENIED                      = 5 # Variable c_long
ERROR_INVALID_HANDLE                     = 6 # Variable c_long
ERROR_ARENA_TRASHED                      = 7 # Variable c_long
ERROR_NOT_ENOUGH_MEMORY                  = 8 # Variable c_long
ERROR_INVALID_BLOCK                      = 9 # Variable c_long
ERROR_BAD_ENVIRONMENT                    = 10 # Variable c_long
ERROR_BAD_FORMAT                         = 11 # Variable c_long
ERROR_INVALID_ACCESS                     = 12 # Variable c_long
ERROR_INVALID_DATA                       = 13 # Variable c_long
ERROR_OUTOFMEMORY                        = 14 # Variable c_long
ERROR_INVALID_DRIVE                      = 15 # Variable c_long
ERROR_CURRENT_DIRECTORY                  = 16 # Variable c_long
ERROR_NOT_SAME_DEVICE                    = 17 # Variable c_long
ERROR_NO_MORE_FILES                      = 18 # Variable c_long
ERROR_WRITE_PROTECT                      = 19 # Variable c_long
ERROR_BAD_UNIT                           = 20 # Variable c_long
ERROR_NOT_READY                          = 21 # Variable c_long
ERROR_BAD_COMMAND                        = 22 # Variable c_long
ERROR_CRC                                = 23 # Variable c_long
ERROR_BAD_LENGTH                         = 24 # Variable c_long
ERROR_SEEK                               = 25 # Variable c_long
ERROR_NOT_DOS_DISK                       = 26 # Variable c_long
ERROR_SECTOR_NOT_FOUND                   = 27 # Variable c_long
ERROR_OUT_OF_PAPER                       = 28 # Variable c_long
ERROR_WRITE_FAULT                        = 29 # Variable c_long
ERROR_READ_FAULT                         = 30 # Variable c_long
ERROR_GEN_FAILURE                        = 31 # Variable c_long
ERROR_SHARING_VIOLATION                  = 32 # Variable c_long
ERROR_LOCK_VIOLATION                     = 33 # Variable c_long
ERROR_WRONG_DISK                         = 34 # Variable c_long
ERROR_SHARING_BUFFER_EXCEEDED            = 36 # Variable c_long
ERROR_HANDLE_EOF                         = 38 # Variable c_long
ERROR_HANDLE_DISK_FULL                   = 39 # Variable c_long
ERROR_NOT_SUPPORTED                      = 50 # Variable c_long
ERROR_REM_NOT_LIST                       = 51 # Variable c_long
ERROR_DUP_NAME                           = 52 # Variable c_long
ERROR_BAD_NETPATH                        = 53 # Variable c_long
ERROR_NETWORK_BUSY                       = 54 # Variable c_long
ERROR_DEV_NOT_EXIST                      = 55 # Variable c_long
ERROR_TOO_MANY_CMDS                      = 56 # Variable c_long
ERROR_ADAP_HDW_ERR                       = 57 # Variable c_long
ERROR_BAD_NET_RESP                       = 58 # Variable c_long
ERROR_UNEXP_NET_ERR                      = 59 # Variable c_long
ERROR_BAD_REM_ADAP                       = 60 # Variable c_long
ERROR_PRINTQ_FULL                        = 61 # Variable c_long
ERROR_NO_SPOOL_SPACE                     = 62 # Variable c_long
ERROR_PRINT_CANCELLED                    = 63 # Variable c_long
ERROR_NETNAME_DELETED                    = 64 # Variable c_long
ERROR_NETWORK_ACCESS_DENIED              = 65 # Variable c_long
ERROR_BAD_DEV_TYPE                       = 66 # Variable c_long
ERROR_BAD_NET_NAME                       = 67 # Variable c_long
ERROR_TOO_MANY_NAMES                     = 68 # Variable c_long
ERROR_TOO_MANY_SESS                      = 69 # Variable c_long
ERROR_SHARING_PAUSED                     = 70 # Variable c_long
ERROR_REQ_NOT_ACCEP                      = 71 # Variable c_long
ERROR_REDIR_PAUSED                       = 72 # Variable c_long
ERROR_FILE_EXISTS                        = 80 # Variable c_long
ERROR_CANNOT_MAKE                        = 82 # Variable c_long
ERROR_FAIL_I24                           = 83 # Variable c_long
ERROR_OUT_OF_STRUCTURES                  = 84 # Variable c_long
ERROR_ALREADY_ASSIGNED                   = 85 # Variable c_long
ERROR_INVALID_PASSWORD                   = 86 # Variable c_long
ERROR_INVALID_PARAMETER                  = 87 # Variable c_long
ERROR_NET_WRITE_FAULT                    = 88 # Variable c_long
ERROR_NO_PROC_SLOTS                      = 89 # Variable c_long
ERROR_TOO_MANY_SEMAPHORES                = 100 # Variable c_long
ERROR_EXCL_SEM_ALREADY_OWNED             = 101 # Variable c_long
ERROR_SEM_IS_SET                         = 102 # Variable c_long
ERROR_TOO_MANY_SEM_REQUESTS              = 103 # Variable c_long
ERROR_INVALID_AT_INTERRUPT_TIME          = 104 # Variable c_long
ERROR_SEM_OWNER_DIED                     = 105 # Variable c_long
ERROR_SEM_USER_LIMIT                     = 106 # Variable c_long
ERROR_DISK_CHANGE                        = 107 # Variable c_long
ERROR_DRIVE_LOCKED                       = 108 # Variable c_long
ERROR_BROKEN_PIPE                        = 109 # Variable c_long
ERROR_OPEN_FAILED                        = 110 # Variable c_long
ERROR_BUFFER_OVERFLOW                    = 111 # Variable c_long
ERROR_DISK_FULL                          = 112 # Variable c_long
ERROR_NO_MORE_SEARCH_HANDLES             = 113 # Variable c_long
ERROR_INVALID_TARGET_HANDLE              = 114 # Variable c_long
ERROR_INVALID_CATEGORY                   = 117 # Variable c_long
ERROR_INVALID_VERIFY_SWITCH              = 118 # Variable c_long
ERROR_BAD_DRIVER_LEVEL                   = 119 # Variable c_long
ERROR_CALL_NOT_IMPLEMENTED               = 120 # Variable c_long
ERROR_SEM_TIMEOUT                        = 121 # Variable c_long
ERROR_INSUFFICIENT_BUFFER                = 122 # Variable c_long
ERROR_INVALID_NAME                       = 123 # Variable c_long
ERROR_INVALID_LEVEL                      = 124 # Variable c_long
ERROR_NO_VOLUME_LABEL                    = 125 # Variable c_long
ERROR_MOD_NOT_FOUND                      = 126 # Variable c_long
ERROR_PROC_NOT_FOUND                     = 127 # Variable c_long
ERROR_WAIT_NO_CHILDREN                   = 128 # Variable c_long
ERROR_CHILD_NOT_COMPLETE                 = 129 # Variable c_long
ERROR_DIRECT_ACCESS_HANDLE               = 130 # Variable c_long
ERROR_NEGATIVE_SEEK                      = 131 # Variable c_long
ERROR_SEEK_ON_DEVICE                     = 132 # Variable c_long
ERROR_IS_JOIN_TARGET                     = 133 # Variable c_long
ERROR_IS_JOINED                          = 134 # Variable c_long
ERROR_IS_SUBSTED                         = 135 # Variable c_long
ERROR_NOT_JOINED                         = 136 # Variable c_long
ERROR_NOT_SUBSTED                        = 137 # Variable c_long
ERROR_JOIN_TO_JOIN                       = 138 # Variable c_long
ERROR_SUBST_TO_SUBST                     = 139 # Variable c_long
ERROR_JOIN_TO_SUBST                      = 140 # Variable c_long
ERROR_SUBST_TO_JOIN                      = 141 # Variable c_long
ERROR_BUSY_DRIVE                         = 142 # Variable c_long
ERROR_SAME_DRIVE                         = 143 # Variable c_long
ERROR_DIR_NOT_ROOT                       = 144 # Variable c_long
ERROR_DIR_NOT_EMPTY                      = 145 # Variable c_long
ERROR_IS_SUBST_PATH                      = 146 # Variable c_long
ERROR_IS_JOIN_PATH                       = 147 # Variable c_long
ERROR_PATH_BUSY                          = 148 # Variable c_long
ERROR_IS_SUBST_TARGET                    = 149 # Variable c_long
ERROR_SYSTEM_TRACE                       = 150 # Variable c_long
ERROR_INVALID_EVENT_COUNT                = 151 # Variable c_long
ERROR_TOO_MANY_MUXWAITERS                = 152 # Variable c_long
ERROR_INVALID_LIST_FORMAT                = 153 # Variable c_long
ERROR_LABEL_TOO_LONG                     = 154 # Variable c_long
ERROR_TOO_MANY_TCBS                      = 155 # Variable c_long
ERROR_SIGNAL_REFUSED                     = 156 # Variable c_long
ERROR_DISCARDED                          = 157 # Variable c_long
ERROR_NOT_LOCKED                         = 158 # Variable c_long
ERROR_BAD_THREADID_ADDR                  = 159 # Variable c_long
ERROR_BAD_ARGUMENTS                      = 160 # Variable c_long
ERROR_BAD_PATHNAME                       = 161 # Variable c_long
ERROR_SIGNAL_PENDING                     = 162 # Variable c_long
ERROR_MAX_THRDS_REACHED                  = 164 # Variable c_long
ERROR_LOCK_FAILED                        = 167 # Variable c_long
ERROR_BUSY                               = 170 # Variable c_long
ERROR_CANCEL_VIOLATION                   = 173 # Variable c_long
ERROR_ATOMIC_LOCKS_NOT_SUPPORTED         = 174 # Variable c_long
ERROR_INVALID_SEGMENT_NUMBER             = 180 # Variable c_long
ERROR_INVALID_ORDINAL                    = 182 # Variable c_long
ERROR_ALREADY_EXISTS                     = 183 # Variable c_long
ERROR_INVALID_FLAG_NUMBER                = 186 # Variable c_long
ERROR_SEM_NOT_FOUND                      = 187 # Variable c_long
ERROR_INVALID_STARTING_CODESEG           = 188 # Variable c_long
ERROR_INVALID_STACKSEG                   = 189 # Variable c_long
ERROR_INVALID_MODULETYPE                 = 190 # Variable c_long
ERROR_INVALID_EXE_SIGNATURE              = 191 # Variable c_long
ERROR_EXE_MARKED_INVALID                 = 192 # Variable c_long
ERROR_BAD_EXE_FORMAT                     = 193 # Variable c_long
ERROR_ITERATED_DATA_EXCEEDS_64k          = 194 # Variable c_long
ERROR_INVALID_MINALLOCSIZE               = 195 # Variable c_long
ERROR_DYNLINK_FROM_INVALID_RING          = 196 # Variable c_long
ERROR_IOPL_NOT_ENABLED                   = 197 # Variable c_long
ERROR_INVALID_SEGDPL                     = 198 # Variable c_long
ERROR_AUTODATASEG_EXCEEDS_64k            = 199 # Variable c_long
ERROR_RING2SEG_MUST_BE_MOVABLE           = 200 # Variable c_long
ERROR_RELOC_CHAIN_XEEDS_SEGLIM           = 201 # Variable c_long
ERROR_INFLOOP_IN_RELOC_CHAIN             = 202 # Variable c_long
ERROR_ENVVAR_NOT_FOUND                   = 203 # Variable c_long
ERROR_NO_SIGNAL_SENT                     = 205 # Variable c_long
ERROR_FILENAME_EXCED_RANGE               = 206 # Variable c_long
ERROR_RING2_STACK_IN_USE                 = 207 # Variable c_long
ERROR_META_EXPANSION_TOO_LONG            = 208 # Variable c_long
ERROR_INVALID_SIGNAL_NUMBER              = 209 # Variable c_long
ERROR_THREAD_1_INACTIVE                  = 210 # Variable c_long
ERROR_LOCKED                             = 212 # Variable c_long
ERROR_TOO_MANY_MODULES                   = 214 # Variable c_long
ERROR_NESTING_NOT_ALLOWED                = 215 # Variable c_long
ERROR_EXE_MACHINE_TYPE_MISMATCH          = 216 # Variable c_long
ERROR_BAD_PIPE                           = 230 # Variable c_long
ERROR_PIPE_BUSY                          = 231 # Variable c_long
ERROR_NO_DATA                            = 232 # Variable c_long
ERROR_PIPE_NOT_CONNECTED                 = 233 # Variable c_long
ERROR_MORE_DATA                          = 234 # Variable c_long
ERROR_VC_DISCONNECTED                    = 240 # Variable c_long
ERROR_INVALID_EA_NAME                    = 254 # Variable c_long
ERROR_EA_LIST_INCONSISTENT               = 255 # Variable c_long
ERROR_NO_MORE_ITEMS                      = 259 # Variable c_long
ERROR_CANNOT_COPY                        = 266 # Variable c_long
ERROR_DIRECTORY                          = 267 # Variable c_long
ERROR_EAS_DIDNT_FIT                      = 275 # Variable c_long
ERROR_EA_FILE_CORRUPT                    = 276 # Variable c_long
ERROR_EA_TABLE_FULL                      = 277 # Variable c_long
ERROR_INVALID_EA_HANDLE                  = 278 # Variable c_long
ERROR_EAS_NOT_SUPPORTED                  = 282 # Variable c_long
ERROR_NOT_OWNER                          = 288 # Variable c_long
ERROR_TOO_MANY_POSTS                     = 298 # Variable c_long
ERROR_PARTIAL_COPY                       = 299 # Variable c_long
ERROR_OPLOCK_NOT_GRANTED                 = 300 # Variable c_long
ERROR_INVALID_OPLOCK_PROTOCOL            = 301 # Variable c_long
ERROR_MR_MID_NOT_FOUND                   = 317 # Variable c_long
ERROR_INVALID_ADDRESS                    = 487 # Variable c_long
ERROR_ARITHMETIC_OVERFLOW                = 534 # Variable c_long
ERROR_PIPE_CONNECTED                     = 535 # Variable c_long
ERROR_PIPE_LISTENING                     = 536 # Variable c_long
ERROR_EA_ACCESS_DENIED                   = 994 # Variable c_long
ERROR_OPERATION_ABORTED                  = 995 # Variable c_long
ERROR_IO_INCOMPLETE                      = 996 # Variable c_long
ERROR_IO_PENDING                         = 997 # Variable c_long
ERROR_NOACCESS                           = 998 # Variable c_long
ERROR_SWAPERROR                          = 999 # Variable c_long
ERROR_STACK_OVERFLOW                     = 1001 # Variable c_long
ERROR_INVALID_MESSAGE                    = 1002 # Variable c_long
ERROR_CAN_NOT_COMPLETE                   = 1003 # Variable c_long
ERROR_INVALID_FLAGS                      = 1004 # Variable c_long
ERROR_UNRECOGNIZED_VOLUME                = 1005 # Variable c_long
ERROR_FILE_INVALID                       = 1006 # Variable c_long
ERROR_FULLSCREEN_MODE                    = 1007 # Variable c_long
ERROR_NO_TOKEN                           = 1008 # Variable c_long
ERROR_BADDB                              = 1009 # Variable c_long
ERROR_BADKEY                             = 1010 # Variable c_long
ERROR_CANTOPEN                           = 1011 # Variable c_long
ERROR_CANTREAD                           = 1012 # Variable c_long
ERROR_CANTWRITE                          = 1013 # Variable c_long
ERROR_REGISTRY_RECOVERED                 = 1014 # Variable c_long
ERROR_REGISTRY_CORRUPT                   = 1015 # Variable c_long
ERROR_REGISTRY_IO_FAILED                 = 1016 # Variable c_long
ERROR_NOT_REGISTRY_FILE                  = 1017 # Variable c_long
ERROR_KEY_DELETED                        = 1018 # Variable c_long
ERROR_NO_LOG_SPACE                       = 1019 # Variable c_long
ERROR_KEY_HAS_CHILDREN                   = 1020 # Variable c_long
ERROR_CHILD_MUST_BE_VOLATILE             = 1021 # Variable c_long
ERROR_NOTIFY_ENUM_DIR                    = 1022 # Variable c_long
ERROR_DEPENDENT_SERVICES_RUNNING         = 1051 # Variable c_long
ERROR_INVALID_SERVICE_CONTROL            = 1052 # Variable c_long
ERROR_SERVICE_REQUEST_TIMEOUT            = 1053 # Variable c_long
ERROR_SERVICE_NO_THREAD                  = 1054 # Variable c_long
ERROR_SERVICE_DATABASE_LOCKED            = 1055 # Variable c_long
ERROR_SERVICE_ALREADY_RUNNING            = 1056 # Variable c_long
ERROR_INVALID_SERVICE_ACCOUNT            = 1057 # Variable c_long
ERROR_SERVICE_DISABLED                   = 1058 # Variable c_long
ERROR_CIRCULAR_DEPENDENCY                = 1059 # Variable c_long
ERROR_SERVICE_DOES_NOT_EXIST             = 1060 # Variable c_long
ERROR_SERVICE_CANNOT_ACCEPT_CTRL         = 1061 # Variable c_long
ERROR_SERVICE_NOT_ACTIVE                 = 1062 # Variable c_long
ERROR_FAILED_SERVICE_CONTROLLER_CONNECT  = 1063 # Variable c_long
ERROR_EXCEPTION_IN_SERVICE               = 1064 # Variable c_long
ERROR_DATABASE_DOES_NOT_EXIST            = 1065 # Variable c_long
ERROR_SERVICE_SPECIFIC_ERROR             = 1066 # Variable c_long
ERROR_PROCESS_ABORTED                    = 1067 # Variable c_long
ERROR_SERVICE_DEPENDENCY_FAIL            = 1068 # Variable c_long
ERROR_SERVICE_LOGON_FAILED               = 1069 # Variable c_long
ERROR_SERVICE_START_HANG                 = 1070 # Variable c_long
ERROR_INVALID_SERVICE_LOCK               = 1071 # Variable c_long
ERROR_SERVICE_MARKED_FOR_DELETE          = 1072 # Variable c_long
ERROR_SERVICE_EXISTS                     = 1073 # Variable c_long
ERROR_ALREADY_RUNNING_LKG                = 1074 # Variable c_long
ERROR_SERVICE_DEPENDENCY_DELETED         = 1075 # Variable c_long
ERROR_BOOT_ALREADY_ACCEPTED              = 1076 # Variable c_long
ERROR_SERVICE_NEVER_STARTED              = 1077 # Variable c_long
ERROR_DUPLICATE_SERVICE_NAME             = 1078 # Variable c_long
ERROR_DIFFERENT_SERVICE_ACCOUNT          = 1079 # Variable c_long
ERROR_CANNOT_DETECT_DRIVER_FAILURE       = 1080 # Variable c_long
ERROR_CANNOT_DETECT_PROCESS_ABORT        = 1081 # Variable c_long
ERROR_NO_RECOVERY_PROGRAM                = 1082 # Variable c_long
ERROR_END_OF_MEDIA                       = 1100 # Variable c_long
ERROR_FILEMARK_DETECTED                  = 1101 # Variable c_long
ERROR_BEGINNING_OF_MEDIA                 = 1102 # Variable c_long
ERROR_SETMARK_DETECTED                   = 1103 # Variable c_long
ERROR_NO_DATA_DETECTED                   = 1104 # Variable c_long
ERROR_PARTITION_FAILURE                  = 1105 # Variable c_long
ERROR_INVALID_BLOCK_LENGTH               = 1106 # Variable c_long
ERROR_DEVICE_NOT_PARTITIONED             = 1107 # Variable c_long
ERROR_UNABLE_TO_LOCK_MEDIA               = 1108 # Variable c_long
ERROR_UNABLE_TO_UNLOAD_MEDIA             = 1109 # Variable c_long
ERROR_MEDIA_CHANGED                      = 1110 # Variable c_long
ERROR_BUS_RESET                          = 1111 # Variable c_long
ERROR_NO_MEDIA_IN_DRIVE                  = 1112 # Variable c_long
ERROR_NO_UNICODE_TRANSLATION             = 1113 # Variable c_long
ERROR_DLL_INIT_FAILED                    = 1114 # Variable c_long
ERROR_SHUTDOWN_IN_PROGRESS               = 1115 # Variable c_long
ERROR_NO_SHUTDOWN_IN_PROGRESS            = 1116 # Variable c_long
ERROR_IO_DEVICE                          = 1117 # Variable c_long
ERROR_SERIAL_NO_DEVICE                   = 1118 # Variable c_long
ERROR_IRQ_BUSY                           = 1119 # Variable c_long
ERROR_MORE_WRITES                        = 1120 # Variable c_long
ERROR_COUNTER_TIMEOUT                    = 1121 # Variable c_long
ERROR_FLOPPY_ID_MARK_NOT_FOUND           = 1122 # Variable c_long
ERROR_FLOPPY_WRONG_CYLINDER              = 1123 # Variable c_long
ERROR_FLOPPY_UNKNOWN_ERROR               = 1124 # Variable c_long
ERROR_FLOPPY_BAD_REGISTERS               = 1125 # Variable c_long
ERROR_DISK_RECALIBRATE_FAILED            = 1126 # Variable c_long
ERROR_DISK_OPERATION_FAILED              = 1127 # Variable c_long
ERROR_DISK_RESET_FAILED                  = 1128 # Variable c_long
ERROR_EOM_OVERFLOW                       = 1129 # Variable c_long
ERROR_NOT_ENOUGH_SERVER_MEMORY           = 1130 # Variable c_long
ERROR_POSSIBLE_DEADLOCK                  = 1131 # Variable c_long
ERROR_MAPPED_ALIGNMENT                   = 1132 # Variable c_long
ERROR_SET_POWER_STATE_VETOED             = 1140 # Variable c_long
ERROR_SET_POWER_STATE_FAILED             = 1141 # Variable c_long
ERROR_TOO_MANY_LINKS                     = 1142 # Variable c_long
ERROR_OLD_WIN_VERSION                    = 1150 # Variable c_long
ERROR_APP_WRONG_OS                       = 1151 # Variable c_long
ERROR_SINGLE_INSTANCE_APP                = 1152 # Variable c_long
ERROR_RMODE_APP                          = 1153 # Variable c_long
ERROR_INVALID_DLL                        = 1154 # Variable c_long
ERROR_NO_ASSOCIATION                     = 1155 # Variable c_long
ERROR_DDE_FAIL                           = 1156 # Variable c_long
ERROR_DLL_NOT_FOUND                      = 1157 # Variable c_long
ERROR_NO_MORE_USER_HANDLES               = 1158 # Variable c_long
ERROR_MESSAGE_SYNC_ONLY                  = 1159 # Variable c_long
ERROR_SOURCE_ELEMENT_EMPTY               = 1160 # Variable c_long
ERROR_DESTINATION_ELEMENT_FULL           = 1161 # Variable c_long
ERROR_ILLEGAL_ELEMENT_ADDRESS            = 1162 # Variable c_long
ERROR_MAGAZINE_NOT_PRESENT               = 1163 # Variable c_long
ERROR_DEVICE_REINITIALIZATION_NEEDED     = 1164 # Variable c_long
ERROR_DEVICE_REQUIRES_CLEANING           = 1165 # Variable c_long
ERROR_DEVICE_DOOR_OPEN                   = 1166 # Variable c_long
ERROR_DEVICE_NOT_CONNECTED               = 1167 # Variable c_long
ERROR_NOT_FOUND                          = 1168 # Variable c_long
ERROR_NO_MATCH                           = 1169 # Variable c_long
ERROR_SET_NOT_FOUND                      = 1170 # Variable c_long
ERROR_POINT_NOT_FOUND                    = 1171 # Variable c_long
ERROR_NO_TRACKING_SERVICE                = 1172 # Variable c_long
ERROR_NO_VOLUME_ID                       = 1173 # Variable c_long
ERROR_BAD_DEVICE                         = 1200 # Variable c_long
ERROR_CONNECTION_UNAVAIL                 = 1201 # Variable c_long
ERROR_DEVICE_ALREADY_REMEMBERED          = 1202 # Variable c_long
ERROR_NO_NET_OR_BAD_PATH                 = 1203 # Variable c_long
ERROR_BAD_PROVIDER                       = 1204 # Variable c_long
ERROR_CANNOT_OPEN_PROFILE                = 1205 # Variable c_long
ERROR_BAD_PROFILE                        = 1206 # Variable c_long
ERROR_NOT_CONTAINER                      = 1207 # Variable c_long
ERROR_EXTENDED_ERROR                     = 1208 # Variable c_long
ERROR_INVALID_GROUPNAME                  = 1209 # Variable c_long
ERROR_INVALID_COMPUTERNAME               = 1210 # Variable c_long
ERROR_INVALID_EVENTNAME                  = 1211 # Variable c_long
ERROR_INVALID_DOMAINNAME                 = 1212 # Variable c_long
ERROR_INVALID_SERVICENAME                = 1213 # Variable c_long
ERROR_INVALID_NETNAME                    = 1214 # Variable c_long
ERROR_INVALID_SHARENAME                  = 1215 # Variable c_long
ERROR_INVALID_PASSWORDNAME               = 1216 # Variable c_long
ERROR_INVALID_MESSAGENAME                = 1217 # Variable c_long
ERROR_INVALID_MESSAGEDEST                = 1218 # Variable c_long
ERROR_SESSION_CREDENTIAL_CONFLICT        = 1219 # Variable c_long
ERROR_REMOTE_SESSION_LIMIT_EXCEEDED      = 1220 # Variable c_long
ERROR_DUP_DOMAINNAME                     = 1221 # Variable c_long
ERROR_NO_NETWORK                         = 1222 # Variable c_long
ERROR_CANCELLED                          = 1223 # Variable c_long
ERROR_USER_MAPPED_FILE                   = 1224 # Variable c_long
ERROR_CONNECTION_REFUSED                 = 1225 # Variable c_long
ERROR_GRACEFUL_DISCONNECT                = 1226 # Variable c_long
ERROR_ADDRESS_ALREADY_ASSOCIATED         = 1227 # Variable c_long
ERROR_ADDRESS_NOT_ASSOCIATED             = 1228 # Variable c_long
ERROR_CONNECTION_INVALID                 = 1229 # Variable c_long
ERROR_CONNECTION_ACTIVE                  = 1230 # Variable c_long
ERROR_NETWORK_UNREACHABLE                = 1231 # Variable c_long
ERROR_HOST_UNREACHABLE                   = 1232 # Variable c_long
ERROR_PROTOCOL_UNREACHABLE               = 1233 # Variable c_long
ERROR_PORT_UNREACHABLE                   = 1234 # Variable c_long
ERROR_REQUEST_ABORTED                    = 1235 # Variable c_long
ERROR_CONNECTION_ABORTED                 = 1236 # Variable c_long
ERROR_RETRY                              = 1237 # Variable c_long
ERROR_CONNECTION_COUNT_LIMIT             = 1238 # Variable c_long
ERROR_LOGIN_TIME_RESTRICTION             = 1239 # Variable c_long
ERROR_LOGIN_WKSTA_RESTRICTION            = 1240 # Variable c_long
ERROR_INCORRECT_ADDRESS                  = 1241 # Variable c_long
ERROR_ALREADY_REGISTERED                 = 1242 # Variable c_long
ERROR_SERVICE_NOT_FOUND                  = 1243 # Variable c_long
ERROR_NOT_AUTHENTICATED                  = 1244 # Variable c_long
ERROR_NOT_LOGGED_ON                      = 1245 # Variable c_long
ERROR_CONTINUE                           = 1246 # Variable c_long
ERROR_ALREADY_INITIALIZED                = 1247 # Variable c_long
ERROR_NO_MORE_DEVICES                    = 1248 # Variable c_long
ERROR_NO_SUCH_SITE                       = 1249 # Variable c_long
ERROR_DOMAIN_CONTROLLER_EXISTS           = 1250 # Variable c_long
ERROR_DS_NOT_INSTALLED                   = 1251 # Variable c_long
ERROR_NOT_ALL_ASSIGNED                   = 1300 # Variable c_long
ERROR_SOME_NOT_MAPPED                    = 1301 # Variable c_long
ERROR_NO_QUOTAS_FOR_ACCOUNT              = 1302 # Variable c_long
ERROR_LOCAL_USER_SESSION_KEY             = 1303 # Variable c_long
ERROR_NULL_LM_PASSWORD                   = 1304 # Variable c_long
ERROR_UNKNOWN_REVISION                   = 1305 # Variable c_long
ERROR_REVISION_MISMATCH                  = 1306 # Variable c_long
ERROR_INVALID_OWNER                      = 1307 # Variable c_long
ERROR_INVALID_PRIMARY_GROUP              = 1308 # Variable c_long
ERROR_NO_IMPERSONATION_TOKEN             = 1309 # Variable c_long
ERROR_CANT_DISABLE_MANDATORY             = 1310 # Variable c_long
ERROR_NO_LOGON_SERVERS                   = 1311 # Variable c_long
ERROR_NO_SUCH_LOGON_SESSION              = 1312 # Variable c_long
ERROR_NO_SUCH_PRIVILEGE                  = 1313 # Variable c_long
ERROR_PRIVILEGE_NOT_HELD                 = 1314 # Variable c_long
ERROR_INVALID_ACCOUNT_NAME               = 1315 # Variable c_long
ERROR_USER_EXISTS                        = 1316 # Variable c_long
ERROR_NO_SUCH_USER                       = 1317 # Variable c_long
ERROR_GROUP_EXISTS                       = 1318 # Variable c_long
ERROR_NO_SUCH_GROUP                      = 1319 # Variable c_long
ERROR_MEMBER_IN_GROUP                    = 1320 # Variable c_long
ERROR_MEMBER_NOT_IN_GROUP                = 1321 # Variable c_long
ERROR_LAST_ADMIN                         = 1322 # Variable c_long
ERROR_WRONG_PASSWORD                     = 1323 # Variable c_long
ERROR_ILL_FORMED_PASSWORD                = 1324 # Variable c_long
ERROR_PASSWORD_RESTRICTION               = 1325 # Variable c_long
ERROR_LOGON_FAILURE                      = 1326 # Variable c_long
ERROR_ACCOUNT_RESTRICTION                = 1327 # Variable c_long
ERROR_INVALID_LOGON_HOURS                = 1328 # Variable c_long
ERROR_INVALID_WORKSTATION                = 1329 # Variable c_long
ERROR_PASSWORD_EXPIRED                   = 1330 # Variable c_long
ERROR_ACCOUNT_DISABLED                   = 1331 # Variable c_long
ERROR_NONE_MAPPED                        = 1332 # Variable c_long
ERROR_TOO_MANY_LUIDS_REQUESTED           = 1333 # Variable c_long
ERROR_LUIDS_EXHAUSTED                    = 1334 # Variable c_long
ERROR_INVALID_SUB_AUTHORITY              = 1335 # Variable c_long
ERROR_INVALID_ACL                        = 1336 # Variable c_long
ERROR_INVALID_SID                        = 1337 # Variable c_long
ERROR_INVALID_SECURITY_DESCR             = 1338 # Variable c_long
ERROR_BAD_INHERITANCE_ACL                = 1340 # Variable c_long
ERROR_SERVER_DISABLED                    = 1341 # Variable c_long
ERROR_SERVER_NOT_DISABLED                = 1342 # Variable c_long
ERROR_INVALID_ID_AUTHORITY               = 1343 # Variable c_long
ERROR_ALLOTTED_SPACE_EXCEEDED            = 1344 # Variable c_long
ERROR_INVALID_GROUP_ATTRIBUTES           = 1345 # Variable c_long
ERROR_BAD_IMPERSONATION_LEVEL            = 1346 # Variable c_long
ERROR_CANT_OPEN_ANONYMOUS                = 1347 # Variable c_long
ERROR_BAD_VALIDATION_CLASS               = 1348 # Variable c_long
ERROR_BAD_TOKEN_TYPE                     = 1349 # Variable c_long
ERROR_NO_SECURITY_ON_OBJECT              = 1350 # Variable c_long
ERROR_CANT_ACCESS_DOMAIN_INFO            = 1351 # Variable c_long
ERROR_INVALID_SERVER_STATE               = 1352 # Variable c_long
ERROR_INVALID_DOMAIN_STATE               = 1353 # Variable c_long
ERROR_INVALID_DOMAIN_ROLE                = 1354 # Variable c_long
ERROR_NO_SUCH_DOMAIN                     = 1355 # Variable c_long
ERROR_DOMAIN_EXISTS                      = 1356 # Variable c_long
ERROR_DOMAIN_LIMIT_EXCEEDED              = 1357 # Variable c_long
ERROR_INTERNAL_DB_CORRUPTION             = 1358 # Variable c_long
ERROR_INTERNAL_ERROR                     = 1359 # Variable c_long
ERROR_GENERIC_NOT_MAPPED                 = 1360 # Variable c_long
ERROR_BAD_DESCRIPTOR_FORMAT              = 1361 # Variable c_long
ERROR_NOT_LOGON_PROCESS                  = 1362 # Variable c_long
ERROR_LOGON_SESSION_EXISTS               = 1363 # Variable c_long
ERROR_NO_SUCH_PACKAGE                    = 1364 # Variable c_long
ERROR_BAD_LOGON_SESSION_STATE            = 1365 # Variable c_long
ERROR_LOGON_SESSION_COLLISION            = 1366 # Variable c_long
ERROR_INVALID_LOGON_TYPE                 = 1367 # Variable c_long
ERROR_CANNOT_IMPERSONATE                 = 1368 # Variable c_long
ERROR_RXACT_INVALID_STATE                = 1369 # Variable c_long
ERROR_RXACT_COMMIT_FAILURE               = 1370 # Variable c_long
ERROR_SPECIAL_ACCOUNT                    = 1371 # Variable c_long
ERROR_SPECIAL_GROUP                      = 1372 # Variable c_long
ERROR_SPECIAL_USER                       = 1373 # Variable c_long
ERROR_MEMBERS_PRIMARY_GROUP              = 1374 # Variable c_long
ERROR_TOKEN_ALREADY_IN_USE               = 1375 # Variable c_long
ERROR_NO_SUCH_ALIAS                      = 1376 # Variable c_long
ERROR_MEMBER_NOT_IN_ALIAS                = 1377 # Variable c_long
ERROR_MEMBER_IN_ALIAS                    = 1378 # Variable c_long
ERROR_ALIAS_EXISTS                       = 1379 # Variable c_long
ERROR_LOGON_NOT_GRANTED                  = 1380 # Variable c_long
ERROR_TOO_MANY_SECRETS                   = 1381 # Variable c_long
ERROR_SECRET_TOO_LONG                    = 1382 # Variable c_long
ERROR_INTERNAL_DB_ERROR                  = 1383 # Variable c_long
ERROR_TOO_MANY_CONTEXT_IDS               = 1384 # Variable c_long
ERROR_LOGON_TYPE_NOT_GRANTED             = 1385 # Variable c_long
ERROR_NT_CROSS_ENCRYPTION_REQUIRED       = 1386 # Variable c_long
ERROR_NO_SUCH_MEMBER                     = 1387 # Variable c_long
ERROR_INVALID_MEMBER                     = 1388 # Variable c_long
ERROR_TOO_MANY_SIDS                      = 1389 # Variable c_long
ERROR_LM_CROSS_ENCRYPTION_REQUIRED       = 1390 # Variable c_long
ERROR_NO_INHERITANCE                     = 1391 # Variable c_long
ERROR_FILE_CORRUPT                       = 1392 # Variable c_long
ERROR_DISK_CORRUPT                       = 1393 # Variable c_long
ERROR_NO_USER_SESSION_KEY                = 1394 # Variable c_long
ERROR_LICENSE_QUOTA_EXCEEDED             = 1395 # Variable c_long
ERROR_INVALID_WINDOW_HANDLE              = 1400 # Variable c_long
ERROR_INVALID_MENU_HANDLE                = 1401 # Variable c_long
ERROR_INVALID_CURSOR_HANDLE              = 1402 # Variable c_long
ERROR_INVALID_ACCEL_HANDLE               = 1403 # Variable c_long
ERROR_INVALID_HOOK_HANDLE                = 1404 # Variable c_long
ERROR_INVALID_DWP_HANDLE                 = 1405 # Variable c_long
ERROR_TLW_WITH_WSCHILD                   = 1406 # Variable c_long
ERROR_CANNOT_FIND_WND_CLASS              = 1407 # Variable c_long
ERROR_WINDOW_OF_OTHER_THREAD             = 1408 # Variable c_long
ERROR_HOTKEY_ALREADY_REGISTERED          = 1409 # Variable c_long
ERROR_CLASS_ALREADY_EXISTS               = 1410 # Variable c_long
ERROR_CLASS_DOES_NOT_EXIST               = 1411 # Variable c_long
ERROR_CLASS_HAS_WINDOWS                  = 1412 # Variable c_long
ERROR_INVALID_INDEX                      = 1413 # Variable c_long
ERROR_INVALID_ICON_HANDLE                = 1414 # Variable c_long
ERROR_PRIVATE_DIALOG_INDEX               = 1415 # Variable c_long
ERROR_LISTBOX_ID_NOT_FOUND               = 1416 # Variable c_long
ERROR_NO_WILDCARD_CHARACTERS             = 1417 # Variable c_long
ERROR_CLIPBOARD_NOT_OPEN                 = 1418 # Variable c_long
ERROR_HOTKEY_NOT_REGISTERED              = 1419 # Variable c_long
ERROR_WINDOW_NOT_DIALOG                  = 1420 # Variable c_long
ERROR_CONTROL_ID_NOT_FOUND               = 1421 # Variable c_long
ERROR_INVALID_COMBOBOX_MESSAGE           = 1422 # Variable c_long
ERROR_WINDOW_NOT_COMBOBOX                = 1423 # Variable c_long
ERROR_INVALID_EDIT_HEIGHT                = 1424 # Variable c_long
ERROR_DC_NOT_FOUND                       = 1425 # Variable c_long
ERROR_INVALID_HOOK_FILTER                = 1426 # Variable c_long
ERROR_INVALID_FILTER_PROC                = 1427 # Variable c_long
ERROR_HOOK_NEEDS_HMOD                    = 1428 # Variable c_long
ERROR_GLOBAL_ONLY_HOOK                   = 1429 # Variable c_long
ERROR_JOURNAL_HOOK_SET                   = 1430 # Variable c_long
ERROR_HOOK_NOT_INSTALLED                 = 1431 # Variable c_long
ERROR_INVALID_LB_MESSAGE                 = 1432 # Variable c_long
ERROR_SETCOUNT_ON_BAD_LB                 = 1433 # Variable c_long
ERROR_LB_WITHOUT_TABSTOPS                = 1434 # Variable c_long
ERROR_DESTROY_OBJECT_OF_OTHER_THREAD     = 1435 # Variable c_long
ERROR_CHILD_WINDOW_MENU                  = 1436 # Variable c_long
ERROR_NO_SYSTEM_MENU                     = 1437 # Variable c_long
ERROR_INVALID_MSGBOX_STYLE               = 1438 # Variable c_long
ERROR_INVALID_SPI_VALUE                  = 1439 # Variable c_long
ERROR_SCREEN_ALREADY_LOCKED              = 1440 # Variable c_long
ERROR_HWNDS_HAVE_DIFF_PARENT             = 1441 # Variable c_long
ERROR_NOT_CHILD_WINDOW                   = 1442 # Variable c_long
ERROR_INVALID_GW_COMMAND                 = 1443 # Variable c_long
ERROR_INVALID_THREAD_ID                  = 1444 # Variable c_long
ERROR_NON_MDICHILD_WINDOW                = 1445 # Variable c_long
ERROR_POPUP_ALREADY_ACTIVE               = 1446 # Variable c_long
ERROR_NO_SCROLLBARS                      = 1447 # Variable c_long
ERROR_INVALID_SCROLLBAR_RANGE            = 1448 # Variable c_long
ERROR_INVALID_SHOWWIN_COMMAND            = 1449 # Variable c_long
ERROR_NO_SYSTEM_RESOURCES                = 1450 # Variable c_long
ERROR_NONPAGED_SYSTEM_RESOURCES          = 1451 # Variable c_long
ERROR_PAGED_SYSTEM_RESOURCES             = 1452 # Variable c_long
ERROR_WORKING_SET_QUOTA                  = 1453 # Variable c_long
ERROR_PAGEFILE_QUOTA                     = 1454 # Variable c_long
ERROR_COMMITMENT_LIMIT                   = 1455 # Variable c_long
ERROR_MENU_ITEM_NOT_FOUND                = 1456 # Variable c_long
ERROR_INVALID_KEYBOARD_HANDLE            = 1457 # Variable c_long
ERROR_HOOK_TYPE_NOT_ALLOWED              = 1458 # Variable c_long
ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION = 1459 # Variable c_long
ERROR_TIMEOUT                            = 1460 # Variable c_long
ERROR_INVALID_MONITOR_HANDLE             = 1461 # Variable c_long
ERROR_EVENTLOG_FILE_CORRUPT              = 1500 # Variable c_long
ERROR_EVENTLOG_CANT_START                = 1501 # Variable c_long
ERROR_LOG_FILE_FULL                      = 1502 # Variable c_long
ERROR_EVENTLOG_FILE_CHANGED              = 1503 # Variable c_long
ERROR_INSTALL_SERVICE                    = 1601 # Variable c_long
ERROR_INSTALL_USEREXIT                   = 1602 # Variable c_long
ERROR_INSTALL_FAILURE                    = 1603 # Variable c_long
ERROR_INSTALL_SUSPEND                    = 1604 # Variable c_long
ERROR_UNKNOWN_PRODUCT                    = 1605 # Variable c_long
ERROR_UNKNOWN_FEATURE                    = 1606 # Variable c_long
ERROR_UNKNOWN_COMPONENT                  = 1607 # Variable c_long
ERROR_UNKNOWN_PROPERTY                   = 1608 # Variable c_long
ERROR_INVALID_HANDLE_STATE               = 1609 # Variable c_long
ERROR_BAD_CONFIGURATION                  = 1610 # Variable c_long
ERROR_INDEX_ABSENT                       = 1611 # Variable c_long
ERROR_INSTALL_SOURCE_ABSENT              = 1612 # Variable c_long
ERROR_BAD_DATABASE_VERSION               = 1613 # Variable c_long
ERROR_PRODUCT_UNINSTALLED                = 1614 # Variable c_long
ERROR_BAD_QUERY_SYNTAX                   = 1615 # Variable c_long
ERROR_INVALID_FIELD                      = 1616 # Variable c_long
ERROR_INVALID_USER_BUFFER                = 1784 # Variable c_long
ERROR_UNRECOGNIZED_MEDIA                 = 1785 # Variable c_long
ERROR_NO_TRUST_LSA_SECRET                = 1786 # Variable c_long
ERROR_NO_TRUST_SAM_ACCOUNT               = 1787 # Variable c_long
ERROR_TRUSTED_DOMAIN_FAILURE             = 1788 # Variable c_long
ERROR_TRUSTED_RELATIONSHIP_FAILURE       = 1789 # Variable c_long
ERROR_TRUST_FAILURE                      = 1790 # Variable c_long
ERROR_NETLOGON_NOT_STARTED               = 1792 # Variable c_long
ERROR_ACCOUNT_EXPIRED                    = 1793 # Variable c_long
ERROR_REDIRECTOR_HAS_OPEN_HANDLES        = 1794 # Variable c_long
ERROR_PRINTER_DRIVER_ALREADY_INSTALLED   = 1795 # Variable c_long
ERROR_UNKNOWN_PORT                       = 1796 # Variable c_long
ERROR_UNKNOWN_PRINTER_DRIVER             = 1797 # Variable c_long
ERROR_UNKNOWN_PRINTPROCESSOR             = 1798 # Variable c_long
ERROR_INVALID_SEPARATOR_FILE             = 1799 # Variable c_long
ERROR_INVALID_PRIORITY                   = 1800 # Variable c_long
ERROR_INVALID_PRINTER_NAME               = 1801 # Variable c_long
ERROR_PRINTER_ALREADY_EXISTS             = 1802 # Variable c_long
ERROR_INVALID_PRINTER_COMMAND            = 1803 # Variable c_long
ERROR_INVALID_DATATYPE                   = 1804 # Variable c_long
ERROR_INVALID_ENVIRONMENT                = 1805 # Variable c_long
ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT  = 1807 # Variable c_long
ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT  = 1808 # Variable c_long
ERROR_NOLOGON_SERVER_TRUST_ACCOUNT       = 1809 # Variable c_long
ERROR_DOMAIN_TRUST_INCONSISTENT          = 1810 # Variable c_long
ERROR_SERVER_HAS_OPEN_HANDLES            = 1811 # Variable c_long
ERROR_RESOURCE_DATA_NOT_FOUND            = 1812 # Variable c_long
ERROR_RESOURCE_TYPE_NOT_FOUND            = 1813 # Variable c_long
ERROR_RESOURCE_NAME_NOT_FOUND            = 1814 # Variable c_long
ERROR_RESOURCE_LANG_NOT_FOUND            = 1815 # Variable c_long
ERROR_NOT_ENOUGH_QUOTA                   = 1816 # Variable c_long
ERROR_INVALID_TIME                       = 1901 # Variable c_long
ERROR_INVALID_FORM_NAME                  = 1902 # Variable c_long
ERROR_INVALID_FORM_SIZE                  = 1903 # Variable c_long
ERROR_ALREADY_WAITING                    = 1904 # Variable c_long
ERROR_PRINTER_DELETED                    = 1905 # Variable c_long
ERROR_INVALID_PRINTER_STATE              = 1906 # Variable c_long
ERROR_PASSWORD_MUST_CHANGE               = 1907 # Variable c_long
ERROR_DOMAIN_CONTROLLER_NOT_FOUND        = 1908 # Variable c_long
ERROR_ACCOUNT_LOCKED_OUT                 = 1909 # Variable c_long
ERROR_NO_SITENAME                        = 1919 # Variable c_long
ERROR_CANT_ACCESS_FILE                   = 1920 # Variable c_long
ERROR_CANT_RESOLVE_FILENAME              = 1921 # Variable c_long
ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY    = 1922 # Variable c_long
ERROR_DS_NO_ATTRIBUTE_OR_VALUE           = 1923 # Variable c_long
ERROR_DS_INVALID_ATTRIBUTE_SYNTAX        = 1924 # Variable c_long
ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED        = 1925 # Variable c_long
ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS       = 1926 # Variable c_long
ERROR_DS_BUSY                            = 1927 # Variable c_long
ERROR_DS_UNAVAILABLE                     = 1928 # Variable c_long
ERROR_DS_NO_RIDS_ALLOCATED               = 1929 # Variable c_long
ERROR_DS_NO_MORE_RIDS                    = 1930 # Variable c_long
ERROR_DS_INCORRECT_ROLE_OWNER            = 1931 # Variable c_long
ERROR_DS_RIDMGR_INIT_ERROR               = 1932 # Variable c_long
ERROR_DS_OBJ_CLASS_VIOLATION             = 1933 # Variable c_long
ERROR_DS_CANT_ON_NON_LEAF                = 1934 # Variable c_long
ERROR_DS_CANT_ON_RDN                     = 1935 # Variable c_long
ERROR_DS_CANT_MOD_OBJ_CLASS              = 1936 # Variable c_long
ERROR_DS_CROSS_DOM_MOVE_ERROR            = 1937 # Variable c_long
ERROR_DS_GC_NOT_AVAILABLE                = 1938 # Variable c_long
ERROR_INVALID_PIXEL_FORMAT               = 2000 # Variable c_long
ERROR_BAD_DRIVER                         = 2001 # Variable c_long
ERROR_INVALID_WINDOW_STYLE               = 2002 # Variable c_long
ERROR_METAFILE_NOT_SUPPORTED             = 2003 # Variable c_long
ERROR_TRANSFORM_NOT_SUPPORTED            = 2004 # Variable c_long
ERROR_CLIPPING_NOT_SUPPORTED             = 2005 # Variable c_long
ERROR_CONNECTED_OTHER_PASSWORD           = 2108 # Variable c_long
ERROR_BAD_USERNAME                       = 2202 # Variable c_long
ERROR_NOT_CONNECTED                      = 2250 # Variable c_long
ERROR_INVALID_CMM                        = 2300 # Variable c_long
ERROR_INVALID_PROFILE                    = 2301 # Variable c_long
ERROR_TAG_NOT_FOUND                      = 2302 # Variable c_long
ERROR_TAG_NOT_PRESENT                    = 2303 # Variable c_long
ERROR_DUPLICATE_TAG                      = 2304 # Variable c_long
ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE = 2305 # Variable c_long
ERROR_PROFILE_NOT_FOUND                  = 2306 # Variable c_long
ERROR_INVALID_COLORSPACE                 = 2307 # Variable c_long
ERROR_ICM_NOT_ENABLED                    = 2308 # Variable c_long
ERROR_DELETING_ICM_XFORM                 = 2309 # Variable c_long
ERROR_INVALID_TRANSFORM                  = 2310 # Variable c_long
ERROR_OPEN_FILES                         = 2401 # Variable c_long
ERROR_ACTIVE_CONNECTIONS                 = 2402 # Variable c_long
ERROR_DEVICE_IN_USE                      = 2404 # Variable c_long
ERROR_UNKNOWN_PRINT_MONITOR              = 3000 # Variable c_long
ERROR_PRINTER_DRIVER_IN_USE              = 3001 # Variable c_long
ERROR_SPOOL_FILE_NOT_FOUND               = 3002 # Variable c_long
ERROR_SPL_NO_STARTDOC                    = 3003 # Variable c_long
ERROR_SPL_NO_ADDJOB                      = 3004 # Variable c_long
ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED  = 3005 # Variable c_long
ERROR_PRINT_MONITOR_ALREADY_INSTALLED    = 3006 # Variable c_long
ERROR_INVALID_PRINT_MONITOR              = 3007 # Variable c_long
ERROR_PRINT_MONITOR_IN_USE               = 3008 # Variable c_long
ERROR_PRINTER_HAS_JOBS_QUEUED            = 3009 # Variable c_long
ERROR_SUCCESS_REBOOT_REQUIRED            = 3010 # Variable c_long
ERROR_SUCCESS_RESTART_REQUIRED           = 3011 # Variable c_long
ERROR_WINS_INTERNAL                      = 4000 # Variable c_long
ERROR_CAN_NOT_DEL_LOCAL_WINS             = 4001 # Variable c_long
ERROR_STATIC_INIT                        = 4002 # Variable c_long
ERROR_INC_BACKUP                         = 4003 # Variable c_long
ERROR_FULL_BACKUP                        = 4004 # Variable c_long
ERROR_REC_NON_EXISTENT                   = 4005 # Variable c_long
ERROR_RPL_NOT_ALLOWED                    = 4006 # Variable c_long
ERROR_DHCP_ADDRESS_CONFLICT              = 4100 # Variable c_long
ERROR_WMI_GUID_NOT_FOUND                 = 4200 # Variable c_long
ERROR_WMI_INSTANCE_NOT_FOUND             = 4201 # Variable c_long
ERROR_WMI_ITEMID_NOT_FOUND               = 4202 # Variable c_long
ERROR_WMI_TRY_AGAIN                      = 4203 # Variable c_long
ERROR_WMI_DP_NOT_FOUND                   = 4204 # Variable c_long
ERROR_WMI_UNRESOLVED_INSTANCE_REF        = 4205 # Variable c_long
ERROR_WMI_ALREADY_ENABLED                = 4206 # Variable c_long
ERROR_WMI_GUID_DISCONNECTED              = 4207 # Variable c_long
ERROR_WMI_SERVER_UNAVAILABLE             = 4208 # Variable c_long
ERROR_WMI_DP_FAILED                      = 4209 # Variable c_long
ERROR_WMI_INVALID_MOF                    = 4210 # Variable c_long
ERROR_WMI_INVALID_REGINFO                = 4211 # Variable c_long
ERROR_INVALID_MEDIA                      = 4300 # Variable c_long
ERROR_INVALID_LIBRARY                    = 4301 # Variable c_long
ERROR_INVALID_MEDIA_POOL                 = 4302 # Variable c_long
ERROR_DRIVE_MEDIA_MISMATCH               = 4303 # Variable c_long
ERROR_MEDIA_OFFLINE                      = 4304 # Variable c_long
ERROR_LIBRARY_OFFLINE                    = 4305 # Variable c_long
ERROR_EMPTY                              = 4306 # Variable c_long
ERROR_NOT_EMPTY                          = 4307 # Variable c_long
ERROR_MEDIA_UNAVAILABLE                  = 4308 # Variable c_long
ERROR_RESOURCE_DISABLED                  = 4309 # Variable c_long
ERROR_INVALID_CLEANER                    = 4310 # Variable c_long
ERROR_UNABLE_TO_CLEAN                    = 4311 # Variable c_long
ERROR_OBJECT_NOT_FOUND                   = 4312 # Variable c_long
ERROR_DATABASE_FAILURE                   = 4313 # Variable c_long
ERROR_DATABASE_FULL                      = 4314 # Variable c_long
ERROR_MEDIA_INCOMPATIBLE                 = 4315 # Variable c_long
ERROR_RESOURCE_NOT_PRESENT               = 4316 # Variable c_long
ERROR_INVALID_OPERATION                  = 4317 # Variable c_long
ERROR_MEDIA_NOT_AVAILABLE                = 4318 # Variable c_long
ERROR_DEVICE_NOT_AVAILABLE               = 4319 # Variable c_long
ERROR_REQUEST_REFUSED                    = 4320 # Variable c_long
ERROR_FILE_OFFLINE                       = 4350 # Variable c_long
ERROR_REMOTE_STORAGE_NOT_ACTIVE          = 4351 # Variable c_long
ERROR_REMOTE_STORAGE_MEDIA_ERROR         = 4352 # Variable c_long
ERROR_NOT_A_REPARSE_POINT                = 4390 # Variable c_long
ERROR_REPARSE_ATTRIBUTE_CONFLICT         = 4391 # Variable c_long
ERROR_DEPENDENT_RESOURCE_EXISTS          = 5001 # Variable c_long
ERROR_DEPENDENCY_NOT_FOUND               = 5002 # Variable c_long
ERROR_DEPENDENCY_ALREADY_EXISTS          = 5003 # Variable c_long
ERROR_RESOURCE_NOT_ONLINE                = 5004 # Variable c_long
ERROR_HOST_NODE_NOT_AVAILABLE            = 5005 # Variable c_long
ERROR_RESOURCE_NOT_AVAILABLE             = 5006 # Variable c_long
ERROR_RESOURCE_NOT_FOUND                 = 5007 # Variable c_long
ERROR_SHUTDOWN_CLUSTER                   = 5008 # Variable c_long
ERROR_CANT_EVICT_ACTIVE_NODE             = 5009 # Variable c_long
ERROR_OBJECT_ALREADY_EXISTS              = 5010 # Variable c_long
ERROR_OBJECT_IN_LIST                     = 5011 # Variable c_long
ERROR_GROUP_NOT_AVAILABLE                = 5012 # Variable c_long
ERROR_GROUP_NOT_FOUND                    = 5013 # Variable c_long
ERROR_GROUP_NOT_ONLINE                   = 5014 # Variable c_long
ERROR_HOST_NODE_NOT_RESOURCE_OWNER       = 5015 # Variable c_long
ERROR_HOST_NODE_NOT_GROUP_OWNER          = 5016 # Variable c_long
ERROR_RESMON_CREATE_FAILED               = 5017 # Variable c_long
ERROR_RESMON_ONLINE_FAILED               = 5018 # Variable c_long
ERROR_RESOURCE_ONLINE                    = 5019 # Variable c_long
ERROR_QUORUM_RESOURCE                    = 5020 # Variable c_long
ERROR_NOT_QUORUM_CAPABLE                 = 5021 # Variable c_long
ERROR_CLUSTER_SHUTTING_DOWN              = 5022 # Variable c_long
ERROR_INVALID_STATE                      = 5023 # Variable c_long
ERROR_RESOURCE_PROPERTIES_STORED         = 5024 # Variable c_long
ERROR_NOT_QUORUM_CLASS                   = 5025 # Variable c_long
ERROR_CORE_RESOURCE                      = 5026 # Variable c_long
ERROR_QUORUM_RESOURCE_ONLINE_FAILED      = 5027 # Variable c_long
ERROR_QUORUMLOG_OPEN_FAILED              = 5028 # Variable c_long
ERROR_CLUSTERLOG_CORRUPT                 = 5029 # Variable c_long
ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE  = 5030 # Variable c_long
ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE         = 5031 # Variable c_long
ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND      = 5032 # Variable c_long
ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE        = 5033 # Variable c_long
ERROR_ENCRYPTION_FAILED                  = 6000 # Variable c_long
ERROR_DECRYPTION_FAILED                  = 6001 # Variable c_long
ERROR_FILE_ENCRYPTED                     = 6002 # Variable c_long
ERROR_NO_RECOVERY_POLICY                 = 6003 # Variable c_long
ERROR_NO_EFS                             = 6004 # Variable c_long
ERROR_WRONG_EFS                          = 6005 # Variable c_long
ERROR_NO_USER_KEYS                       = 6006 # Variable c_long
ERROR_FILE_NOT_ENCRYPTED                 = 6007 # Variable c_long
ERROR_NOT_EXPORT_FORMAT                  = 6008 # Variable c_long
ERROR_NO_BROWSER_SERVERS_FOUND           = 6118 # Variable c_long
ERROR_SEVERITY_INFORMATIONAL             = win32con.ERROR_SEVERITY_INFORMATIONAL # 1073741824
ERROR_SEVERITY_WARNING                   = win32con.ERROR_SEVERITY_WARNING # -2147483648
ERROR_SEVERITY_ERROR                     = win32con.ERROR_SEVERITY_ERROR # -1073741824

ESB_ENABLE_BOTH   = win32con.ESB_ENABLE_BOTH # 0
ESB_DISABLE_UP    = win32con.ESB_DISABLE_UP # 1
ESB_DISABLE_LEFT  = win32con.ESB_DISABLE_LEFT # 1
ESB_DISABLE_RIGHT = win32con.ESB_DISABLE_RIGHT # 2
ESB_DISABLE_DOWN  = win32con.ESB_DISABLE_DOWN # 2
ESB_DISABLE_BOTH  = win32con.ESB_DISABLE_BOTH # 3

ES_LEFT             = win32con.ES_LEFT # 0
ES_CENTER           = win32con.ES_CENTER # 1
ES_SYSTEM_REQUIRED  = 1 # Variable c_ulong
ES_RIGHT            = win32con.ES_RIGHT # 2
ES_DISPLAY_REQUIRED = 2 # Variable c_ulong
ES_MULTILINE        = win32con.ES_MULTILINE # 4
ES_USER_PRESENT     = 4 # Variable c_ulong
ES_UPPERCASE        = win32con.ES_UPPERCASE # 8
ES_LOWERCASE        = win32con.ES_LOWERCASE # 16
ES_PASSWORD         = win32con.ES_PASSWORD # 32
ES_AUTOVSCROLL      = win32con.ES_AUTOVSCROLL # 64
ES_AUTOHSCROLL      = win32con.ES_AUTOHSCROLL # 128
ES_NOHIDESEL        = win32con.ES_NOHIDESEL # 256
ES_OEMCONVERT       = win32con.ES_OEMCONVERT # 1024
ES_READONLY         = win32con.ES_READONLY # 2048
ES_WANTRETURN       = win32con.ES_WANTRETURN # 4096
ES_NUMBER           = win32con.ES_NUMBER # 8192
ES_CONTINUOUS       = 2147483648 # Variable c_ulong

ETO_OPAQUE         = win32con.ETO_OPAQUE # 2
ETO_CLIPPED        = win32con.ETO_CLIPPED # 4
ETO_GLYPH_INDEX    = 16 # Variable c_int
ETO_RTLREADING     = 128 # Variable c_int
ETO_NUMERICSLOCAL  = 1024 # Variable c_int
ETO_NUMERICSLATIN  = 2048 # Variable c_int
ETO_IGNORELANGUAGE = 4096 # Variable c_int

EVENTLOG_SUCCESS               = win32con.EVENTLOG_SUCCESS # 0
EVENTLOG_SEQUENTIAL_READ       = win32con.EVENTLOG_SEQUENTIAL_READ # 1
EVENTLOG_ERROR_TYPE            = win32con.EVENTLOG_ERROR_TYPE # 1
EVENTLOG_START_PAIRED_EVENT    = win32con.EVENTLOG_START_PAIRED_EVENT # 1
EVENTLOG_END_PAIRED_EVENT      = win32con.EVENTLOG_END_PAIRED_EVENT # 2
EVENTLOG_WARNING_TYPE          = win32con.EVENTLOG_WARNING_TYPE # 2
EVENTLOG_SEEK_READ             = win32con.EVENTLOG_SEEK_READ # 2
EVENTLOG_FORWARDS_READ         = win32con.EVENTLOG_FORWARDS_READ # 4
EVENTLOG_END_ALL_PAIRED_EVENTS = win32con.EVENTLOG_END_ALL_PAIRED_EVENTS # 4
EVENTLOG_INFORMATION_TYPE      = win32con.EVENTLOG_INFORMATION_TYPE # 4
EVENTLOG_BACKWARDS_READ        = win32con.EVENTLOG_BACKWARDS_READ # 8
EVENTLOG_PAIRED_EVENT_ACTIVE   = win32con.EVENTLOG_PAIRED_EVENT_ACTIVE # 8
EVENTLOG_AUDIT_SUCCESS         = win32con.EVENTLOG_AUDIT_SUCCESS # 8
EVENTLOG_PAIRED_EVENT_INACTIVE = win32con.EVENTLOG_PAIRED_EVENT_INACTIVE # 16
EVENTLOG_AUDIT_FAILURE         = win32con.EVENTLOG_AUDIT_FAILURE # 16

EVENT_MODIFY_STATE = win32con.EVENT_MODIFY_STATE # 2
EVENT_ALL_ACCESS   = 2031619 # Variable c_long

EV_RXCHAR   = 1 # Variable c_int
EV_RXFLAG   = 2 # Variable c_int
EV_TXEMPTY  = 4 # Variable c_int
EV_CTS      = 8 # Variable c_int
EV_DSR      = 16 # Variable c_int
EV_RLSD     = 32 # Variable c_int
EV_BREAK    = 64 # Variable c_int
EV_ERR      = 128 # Variable c_int
EV_RING     = 256 # Variable c_int
EV_PERR     = 512 # Variable c_int
EV_RX80FULL = 1024 # Variable c_int
EV_EVENT1   = 2048 # Variable c_int
EV_EVENT2   = 4096 # Variable c_int

EWX_LOGOFF   = win32con.EWX_LOGOFF # 0
EWX_SHUTDOWN = win32con.EWX_SHUTDOWN # 1
EWX_REBOOT   = win32con.EWX_REBOOT # 2
EWX_FORCE    = win32con.EWX_FORCE # 4
EWX_POWEROFF = win32con.EWX_POWEROFF # 8

EXCEPTION_CONTINUE_SEARCH    = 0 # Variable c_int
EXCEPTION_DEBUG_EVENT        = win32con.EXCEPTION_DEBUG_EVENT # 1
EXCEPTION_EXECUTE_HANDLER    = 1 # Variable c_int
EXCEPTION_NONCONTINUABLE     = 1 # Variable c_int
EXCEPTION_MAXIMUM_PARAMETERS = 15 # Variable c_int
EXCEPTION_CONTINUE_EXECUTION = -1 # Variable c_int

EXIT_SUCCESS             = 0 # Variable c_int
EXIT_FAILURE             = 1 # Variable c_int
EXIT_THREAD_DEBUG_EVENT  = win32con.EXIT_THREAD_DEBUG_EVENT # 4
EXIT_PROCESS_DEBUG_EVENT = win32con.EXIT_PROCESS_DEBUG_EVENT # 5

EXTCONN_STRONG   = 1
EXTCONN_WEAK     = 2
EXTCONN_CALLABLE = 4

EXT_DEVICE_CAPS = win32con.EXT_DEVICE_CAPS # 4099

E_INVALIDARG   = -2147024809 # Variable c_long
E_OUTOFMEMORY  = -2147024882 # Variable c_long
E_HANDLE       = -2147024890 # Variable c_long
E_ACCESSDENIED = -2147024891 # Variable c_long
E_UNEXPECTED   = -2147418113 # Variable c_long
E_FAIL         = -2147467259 # Variable c_long
E_ABORT        = -2147467260 # Variable c_long
E_POINTER      = -2147467261 # Variable c_long
E_NOINTERFACE  = -2147467262 # Variable c_long
E_NOTIMPL      = -2147467263 # Variable c_long
E_PENDING      = -2147483638 # Variable c_long

FACILITY_NULL        = 0 # Variable c_int
FACILITY_RPC         = 1 # Variable c_int
FACILITY_DISPATCH    = 2 # Variable c_int
FACILITY_STORAGE     = 3 # Variable c_int
FACILITY_ITF         = 4 # Variable c_int
FACILITY_WIN32       = 7 # Variable c_int
FACILITY_WINDOWS     = 8 # Variable c_int
FACILITY_SSPI        = 9 # Variable c_int
FACILITY_CONTROL     = 10 # Variable c_int
FACILITY_CERT        = 11 # Variable c_int
FACILITY_INTERNET    = 12 # Variable c_int
FACILITY_MEDIASERVER = 13 # Variable c_int
FACILITY_MSMQ        = 14 # Variable c_int
FACILITY_SETUPAPI    = 15 # Variable c_int
FACILITY_NT_BIT      = 268435456 # Variable c_int

FADF_AUTO        = 1 # Variable c_int
FADF_STATIC      = 2 # Variable c_int
FADF_EMBEDDED    = 4 # Variable c_int
FADF_FIXEDSIZE   = 16 # Variable c_int
FADF_RECORD      = 32 # Variable c_int
FADF_HAVEIID     = 64 # Variable c_int
FADF_HAVEVARTYPE = 128 # Variable c_int
FADF_BSTR        = 256 # Variable c_int
FADF_UNKNOWN     = 512 # Variable c_int
FADF_DISPATCH    = 1024 # Variable c_int
FADF_VARIANT     = 2048 # Variable c_int
FADF_RESERVED    = 61448 # Variable c_int

FAILED_ACCESS_ACE_FLAG = win32con.FAILED_ACCESS_ACE_FLAG # 128

FD_READ    = 1 # Variable c_int
FD_WRITE   = 2 # Variable c_int
FD_OOB     = 4 # Variable c_int
FD_ACCEPT  = 8 # Variable c_int
FD_CONNECT = 16 # Variable c_int
FD_CLOSE   = 32 # Variable c_int
FD_SETSIZE = 64 # Variable c_int

FF_DONTCARE   = win32con.FF_DONTCARE # 0
FF_ROMAN      = win32con.FF_ROMAN # 16
FF_SWISS      = win32con.FF_SWISS # 32
FF_MODERN     = win32con.FF_MODERN # 48
FF_SCRIPT     = win32con.FF_SCRIPT # 64
FF_DECORATIVE = win32con.FF_DECORATIVE # 80

FILE_BEGIN                         = win32con.FILE_BEGIN # 0
FILE_TYPE_UNKNOWN                  = win32con.FILE_TYPE_UNKNOWN # 0
FILE_CASE_SENSITIVE_SEARCH         = win32con.FILE_CASE_SENSITIVE_SEARCH # 1
FILE_CURRENT                       = win32con.FILE_CURRENT # 1
FILE_READ_DATA                     = 1 # Variable c_int
FILE_ATTRIBUTE_READONLY            = win32con.FILE_ATTRIBUTE_READONLY # 1
FILE_SHARE_READ                    = win32con.FILE_SHARE_READ # 1
FILE_TYPE_DISK                     = win32con.FILE_TYPE_DISK # 1
FILE_NOTIFY_CHANGE_FILE_NAME       = win32con.FILE_NOTIFY_CHANGE_FILE_NAME # 1
FILE_ACTION_ADDED                  = 1 # Variable c_int
FILE_LIST_DIRECTORY                = 1 # Variable c_int
FILE_ACTION_REMOVED                = 2 # Variable c_int
FILE_ATTRIBUTE_HIDDEN              = win32con.FILE_ATTRIBUTE_HIDDEN # 2
FILE_TYPE_CHAR                     = win32con.FILE_TYPE_CHAR # 2
FILE_SHARE_WRITE                   = win32con.FILE_SHARE_WRITE # 2
FILE_CASE_PRESERVED_NAMES          = win32con.FILE_CASE_PRESERVED_NAMES # 2
FILE_WRITE_DATA                    = 2 # Variable c_int
FILE_END                           = win32con.FILE_END # 2
FILE_NOTIFY_CHANGE_DIR_NAME        = win32con.FILE_NOTIFY_CHANGE_DIR_NAME # 2
FILE_ADD_FILE                      = 2 # Variable c_int
FILE_ACTION_MODIFIED               = 3 # Variable c_int
FILE_TYPE_PIPE                     = win32con.FILE_TYPE_PIPE # 3
FILE_UNICODE_ON_DISK               = win32con.FILE_UNICODE_ON_DISK # 4
FILE_APPEND_DATA                   = 4 # Variable c_int
FILE_ADD_SUBDIRECTORY              = 4 # Variable c_int
FILE_CREATE_PIPE_INSTANCE          = 4 # Variable c_int
FILE_NOTIFY_CHANGE_ATTRIBUTES      = win32con.FILE_NOTIFY_CHANGE_ATTRIBUTES # 4
FILE_SHARE_DELETE                  = win32con.FILE_SHARE_DELETE # 4
FILE_ACTION_RENAMED_OLD_NAME       = 4 # Variable c_int
FILE_ATTRIBUTE_SYSTEM              = win32con.FILE_ATTRIBUTE_SYSTEM # 4
FILE_ACTION_RENAMED_NEW_NAME       = 5 # Variable c_int
FILE_PERSISTENT_ACLS               = win32con.FILE_PERSISTENT_ACLS # 8
FILE_READ_EA                       = 8 # Variable c_int
FILE_NOTIFY_CHANGE_SIZE            = win32con.FILE_NOTIFY_CHANGE_SIZE # 8
FILE_FILE_COMPRESSION              = win32con.FILE_FILE_COMPRESSION # 16
FILE_WRITE_EA                      = 16 # Variable c_int
FILE_ATTRIBUTE_DIRECTORY           = win32con.FILE_ATTRIBUTE_DIRECTORY # 16
FILE_NOTIFY_CHANGE_LAST_WRITE      = win32con.FILE_NOTIFY_CHANGE_LAST_WRITE # 16
FILE_EXECUTE                       = 32 # Variable c_int
FILE_VOLUME_QUOTAS                 = 32 # Variable c_int
FILE_TRAVERSE                      = 32 # Variable c_int
FILE_ATTRIBUTE_ARCHIVE             = win32con.FILE_ATTRIBUTE_ARCHIVE # 32
FILE_NOTIFY_CHANGE_LAST_ACCESS     = 32 # Variable c_int
FILE_NOTIFY_CHANGE_CREATION        = 64 # Variable c_int
FILE_ATTRIBUTE_ENCRYPTED           = win32con.FILE_ATTRIBUTE_ENCRYPTED # 16384
FILE_DELETE_CHILD                  = 64 # Variable c_int
FILE_SUPPORTS_SPARSE_FILES         = 64 # Variable c_int
FILE_ATTRIBUTE_NORMAL              = win32con.FILE_ATTRIBUTE_NORMAL # 128
FILE_SUPPORTS_REPARSE_POINTS       = 128 # Variable c_int
FILE_READ_ATTRIBUTES               = 128 # Variable c_int
FILE_SUPPORTS_REMOTE_STORAGE       = 256 # Variable c_int
FILE_WRITE_ATTRIBUTES              = 256 # Variable c_int
FILE_ATTRIBUTE_TEMPORARY           = win32con.FILE_ATTRIBUTE_TEMPORARY # 256
FILE_NOTIFY_CHANGE_SECURITY        = win32con.FILE_NOTIFY_CHANGE_SECURITY # 256
FILE_ATTRIBUTE_SPARSE_FILE         = win32con.FILE_ATTRIBUTE_SPARSE_FILE # 512
FILE_ATTRIBUTE_REPARSE_POINT       = win32con.FILE_ATTRIBUTE_REPARSE_POINT # 1024
FILE_ATTRIBUTE_COMPRESSED          = win32con.FILE_ATTRIBUTE_COMPRESSED # 2048
FILE_ATTRIBUTE_OFFLINE             = win32con.FILE_ATTRIBUTE_OFFLINE # 4096
FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = win32con.FILE_ATTRIBUTE_NOT_CONTENT_INDEXED # 8192
FILE_TYPE_REMOTE                   = win32con.FILE_TYPE_REMOTE # 32768
FILE_VOLUME_IS_COMPRESSED          = win32con.FILE_VOLUME_IS_COMPRESSED # 32768
FILE_SUPPORTS_OBJECT_IDS           = 65536 # Variable c_int
FILE_SUPPORTS_ENCRYPTION           = 131072 # Variable c_int
FILE_FLAG_OPEN_NO_RECALL           = 1048576 # Variable c_int
FILE_GENERIC_READ                  = 1179785 # Variable c_long
FILE_GENERIC_EXECUTE               = 1179808 # Variable c_long
FILE_GENERIC_WRITE                 = 1179926 # Variable c_long
FILE_ALL_ACCESS                    = 2032639 # Variable c_long
FILE_FLAG_OPEN_REPARSE_POINT       = 2097152 # Variable c_int
FILE_FLAG_POSIX_SEMANTICS          = win32con.FILE_FLAG_POSIX_SEMANTICS # 16777216
FILE_FLAG_BACKUP_SEMANTICS         = win32con.FILE_FLAG_BACKUP_SEMANTICS # 33554432
FILE_FLAG_DELETE_ON_CLOSE          = win32con.FILE_FLAG_DELETE_ON_CLOSE # 67108864
FILE_FLAG_SEQUENTIAL_SCAN          = win32con.FILE_FLAG_SEQUENTIAL_SCAN # 134217728
FILE_FLAG_RANDOM_ACCESS            = win32con.FILE_FLAG_RANDOM_ACCESS # 268435456
FILE_FLAG_NO_BUFFERING             = win32con.FILE_FLAG_NO_BUFFERING # 536870912
FILE_FLAG_OVERLAPPED               = win32con.FILE_FLAG_OVERLAPPED # 1073741824
FILE_FLAG_WRITE_THROUGH            = win32con.FILE_FLAG_WRITE_THROUGH # -2147483648

FIXED_PITCH = win32con.FIXED_PITCH # 1

FKF_FILTERKEYSON  = win32con.FKF_FILTERKEYSON # 1
FKF_AVAILABLE     = win32con.FKF_AVAILABLE # 2
FKF_HOTKEYACTIVE  = win32con.FKF_HOTKEYACTIVE # 4
FKF_CONFIRMHOTKEY = win32con.FKF_CONFIRMHOTKEY # 8
FKF_HOTKEYSOUND   = win32con.FKF_HOTKEYSOUND # 16
FKF_INDICATOR     = win32con.FKF_INDICATOR # 32
FKF_CLICKON       = win32con.FKF_CLICKON # 64

FLI_MASK   = 4155 # Variable c_int
FLI_GLYPHS = 262144 # Variable c_long

FNERR_FILENAMECODES   = 12288 # Variable c_int
FNERR_SUBCLASSFAILURE = 12289 # Variable c_int
FNERR_INVALIDFILENAME = 12290 # Variable c_int
FNERR_BUFFERTOOSMALL  = 12291 # Variable c_int

FOCUS_EVENT = 16 # Variable c_int

FOF_MULTIDESTFILES        = 1 # Variable c_int
FOF_CONFIRMMOUSE          = 2 # Variable c_int
FOF_SILENT                = 4 # Variable c_int
FOF_RENAMEONCOLLISION     = 8 # Variable c_int
FOF_NOCONFIRMATION        = 16 # Variable c_int
FOF_WANTMAPPINGHANDLE     = 32 # Variable c_int
FOF_ALLOWUNDO             = 64 # Variable c_int
FOF_FILESONLY             = 128 # Variable c_int
FOF_SIMPLEPROGRESS        = 256 # Variable c_int
FOF_NOCONFIRMMKDIR        = 512 # Variable c_int
FOF_NOERRORUI             = 1024 # Variable c_int
FOF_NOCOPYSECURITYATTRIBS = 2048 # Variable c_int

FONTMAPPER_MAX = win32con.FONTMAPPER_MAX # 10

FOREGROUND_BLUE      = 1 # Variable c_int
FOREGROUND_GREEN     = 2 # Variable c_int
FOREGROUND_RED       = 4 # Variable c_int
FOREGROUND_INTENSITY = 8 # Variable c_int

FORMAT_MESSAGE_MAX_WIDTH_MASK  = win32con.FORMAT_MESSAGE_MAX_WIDTH_MASK # 255
FORMAT_MESSAGE_ALLOCATE_BUFFER = win32con.FORMAT_MESSAGE_ALLOCATE_BUFFER # 256
FORMAT_MESSAGE_IGNORE_INSERTS  = win32con.FORMAT_MESSAGE_IGNORE_INSERTS # 512
FORMAT_MESSAGE_FROM_STRING     = win32con.FORMAT_MESSAGE_FROM_STRING # 1024
FORMAT_MESSAGE_FROM_HMODULE    = win32con.FORMAT_MESSAGE_FROM_HMODULE # 2048
FORMAT_MESSAGE_FROM_SYSTEM     = win32con.FORMAT_MESSAGE_FROM_SYSTEM # 4096
FORMAT_MESSAGE_ARGUMENT_ARRAY  = win32con.FORMAT_MESSAGE_ARGUMENT_ARRAY # 8192

FORM_USER    = 0 # Variable c_int
FORM_BUILTIN = 1 # Variable c_int
FORM_PRINTER = 2 # Variable c_int

FOURCC_MEM  = 541934925 # Variable c_ulong
FOURCC_DOS  = 542330692 # Variable c_ulong
FOURCC_RIFF = 1179011410 # Variable c_ulong
FOURCC_LIST = 1414744396 # Variable c_ulong

FO_MOVE   = 1 # Variable c_int
FO_COPY   = 2 # Variable c_int
FO_DELETE = 3 # Variable c_int
FO_RENAME = 4 # Variable c_int

FRAME_FPO    = win32con.FRAME_FPO # 0
FRAME_TRAP   = win32con.FRAME_TRAP # 1
FRAME_TSS    = win32con.FRAME_TSS # 2
FRAME_NONFPO = 3 # Variable c_int

FRERR_FINDREPLACECODES = 16384 # Variable c_int
FRERR_BUFFERLENGTHZERO = 16385 # Variable c_int

FROM_LEFT_1ST_BUTTON_PRESSED = win32con.FROM_LEFT_1ST_BUTTON_PRESSED # 1
FROM_LEFT_2ND_BUTTON_PRESSED = win32con.FROM_LEFT_2ND_BUTTON_PRESSED # 4
FROM_LEFT_3RD_BUTTON_PRESSED = win32con.FROM_LEFT_3RD_BUTTON_PRESSED # 8
FROM_LEFT_4TH_BUTTON_PRESSED = win32con.FROM_LEFT_4TH_BUTTON_PRESSED # 16

FR_DOWN                 = win32con.FR_DOWN # 1
FR_WHOLEWORD            = win32con.FR_WHOLEWORD # 2
FR_MATCHCASE            = win32con.FR_MATCHCASE # 4
FR_FINDNEXT             = win32con.FR_FINDNEXT # 8
FR_REPLACE              = win32con.FR_REPLACE # 16
FR_REPLACEALL           = win32con.FR_REPLACEALL # 32
FR_DIALOGTERM           = win32con.FR_DIALOGTERM # 64
FR_SHOWHELP             = win32con.FR_SHOWHELP # 128
FR_ENABLEHOOK           = win32con.FR_ENABLEHOOK # 256
FR_ENABLETEMPLATE       = win32con.FR_ENABLETEMPLATE # 512
FR_NOUPDOWN             = win32con.FR_NOUPDOWN # 1024
FR_NOMATCHCASE          = win32con.FR_NOMATCHCASE # 2048
FR_NOWHOLEWORD          = win32con.FR_NOWHOLEWORD # 4096
FR_ENABLETEMPLATEHANDLE = win32con.FR_ENABLETEMPLATEHANDLE # 8192
FR_HIDEUPDOWN           = win32con.FR_HIDEUPDOWN # 16384
FR_HIDEMATCHCASE        = win32con.FR_HIDEMATCHCASE # 32768
FR_HIDEWHOLEWORD        = win32con.FR_HIDEWHOLEWORD # 65536

FSB_REGULAR_MODE = 0 # Variable c_int
FSB_ENCARTA_MODE = 1 # Variable c_int
FSB_FLAT_MODE    = 2 # Variable c_int

FS_LATIN1      = 1 # Variable c_long
FS_LATIN2      = 2 # Variable c_long
FS_CYRILLIC    = 4 # Variable c_long
FS_GREEK       = 8 # Variable c_long
FS_TURKISH     = 16 # Variable c_long
FS_HEBREW      = 32 # Variable c_long
FS_ARABIC      = 64 # Variable c_long
FS_BALTIC      = 128 # Variable c_long
FS_VIETNAMESE  = 256 # Variable c_long
FS_THAI        = 65536 # Variable c_long
FS_JISJAPAN    = 131072 # Variable c_long
FS_CHINESESIMP = 262144 # Variable c_long
FS_WANSUNG     = 524288 # Variable c_long
FS_CHINESETRAD = 1048576 # Variable c_long
FS_JOHAB       = 2097152 # Variable c_long
FS_SYMBOL      = 2147483648 # Variable c_ulong

FUNCFLAG_FRESTRICTED       = 1
FUNCFLAG_FSOURCE           = 2
FUNCFLAG_FBINDABLE         = 4
FUNCFLAG_FREQUESTEDIT      = 8
FUNCFLAG_FDISPLAYBIND      = 16
FUNCFLAG_FDEFAULTBIND      = 32
FUNCFLAG_FHIDDEN           = 64
FUNCFLAG_FUSESGETLASTERROR = 128
FUNCFLAG_FDEFAULTCOLLELEM  = 256
FUNCFLAG_FUIDEFAULT        = 512
FUNCFLAG_FNONBROWSABLE     = 1024
FUNCFLAG_FREPLACEABLE      = 2048
FUNCFLAG_FIMMEDIATEBIND    = 4096

FUNC_VIRTUAL     = 0
FUNC_PUREVIRTUAL = 1
FUNC_NONVIRTUAL  = 2
FUNC_STATIC      = 3
FUNC_DISPATCH    = 4

FW_DONTCARE   = win32con.FW_DONTCARE # 0
FW_THIN       = win32con.FW_THIN # 100
FW_EXTRALIGHT = win32con.FW_EXTRALIGHT # 200
FW_LIGHT      = win32con.FW_LIGHT # 300
FW_NORMAL     = win32con.FW_NORMAL # 400
FW_MEDIUM     = win32con.FW_MEDIUM # 500
FW_SEMIBOLD   = win32con.FW_SEMIBOLD # 600
FW_BOLD       = win32con.FW_BOLD # 700
FW_EXTRABOLD  = win32con.FW_EXTRABOLD # 800
FW_HEAVY      = win32con.FW_HEAVY # 900

GB2312_CHARSET = 134 # Variable c_int

GCL_CONVERSION        = 1 # Variable c_int
GCL_REVERSECONVERSION = 2 # Variable c_int
GCL_REVERSE_LENGTH    = 3 # Variable c_int
GCL_MENUNAME          = win32con.GCL_MENUNAME # -8
GCL_HBRBACKGROUND     = win32con.GCL_HBRBACKGROUND # -10
GCL_HCURSOR           = win32con.GCL_HCURSOR # -12
GCL_HICON             = win32con.GCL_HICON # -14
GCL_HMODULE           = win32con.GCL_HMODULE # -16
GCL_CBWNDEXTRA        = win32con.GCL_CBWNDEXTRA # -18
GCL_CBCLSEXTRA        = win32con.GCL_CBCLSEXTRA # -20
GCL_WNDPROC           = win32con.GCL_WNDPROC # -24
GCL_STYLE             = win32con.GCL_STYLE # -26
GCL_HICONSM           = win32con.GCL_HICONSM # -34

GCPCLASS_LATIN                  = 1 # Variable c_int
GCPCLASS_HEBREW                 = 2 # Variable c_int
GCPCLASS_ARABIC                 = 2 # Variable c_int
GCPCLASS_NEUTRAL                = 3 # Variable c_int
GCPCLASS_LOCALNUMBER            = 4 # Variable c_int
GCPCLASS_LATINNUMBER            = 5 # Variable c_int
GCPCLASS_LATINNUMERICTERMINATOR = 6 # Variable c_int
GCPCLASS_LATINNUMERICSEPARATOR  = 7 # Variable c_int
GCPCLASS_NUMERICSEPARATOR       = 8 # Variable c_int
GCPCLASS_POSTBOUNDRTL           = 16 # Variable c_int
GCPCLASS_POSTBOUNDLTR           = 32 # Variable c_int
GCPCLASS_PREBOUNDRTL            = 64 # Variable c_int
GCPCLASS_PREBOUNDLTR            = 128 # Variable c_int

GCPGLYPH_LINKAFTER  = 16384 # Variable c_int
GCPGLYPH_LINKBEFORE = 32768 # Variable c_int

GCP_DBCS            = 1 # Variable c_int
GCP_REORDER         = 2 # Variable c_int
GCP_USEKERNING      = 8 # Variable c_int
GCP_GLYPHSHAPE      = 16 # Variable c_int
GCP_LIGATE          = 32 # Variable c_int
GCP_DIACRITIC       = 256 # Variable c_int
GCP_KASHIDA         = 1024 # Variable c_int
GCP_ERROR           = 32768 # Variable c_int
GCP_JUSTIFY         = 65536 # Variable c_long
GCP_CLASSIN         = 524288 # Variable c_long
GCP_MAXEXTENT       = 1048576 # Variable c_long
GCP_JUSTIFYIN       = 2097152 # Variable c_long
GCP_DISPLAYZWG      = 4194304 # Variable c_long
GCP_SYMSWAPOFF      = 8388608 # Variable c_long
GCP_NUMERICOVERRIDE = 16777216 # Variable c_long
GCP_NEUTRALOVERRIDE = 33554432 # Variable c_long
GCP_NUMERICSLATIN   = 67108864 # Variable c_long
GCP_NUMERICSLOCAL   = 134217728 # Variable c_long

GCS_COMPREADSTR      = 1 # Variable c_int
GCS_COMPREADATTR     = 2 # Variable c_int
GCS_COMPREADCLAUSE   = 4 # Variable c_int
GCS_COMPSTR          = 8 # Variable c_int
GCS_COMPATTR         = 16 # Variable c_int
GCS_COMPCLAUSE       = 32 # Variable c_int
GCS_CURSORPOS        = 128 # Variable c_int
GCS_DELTASTART       = 256 # Variable c_int
GCS_RESULTREADSTR    = 512 # Variable c_int
GCS_RESULTREADCLAUSE = 1024 # Variable c_int
GCS_RESULTSTR        = 2048 # Variable c_int
GCS_RESULTCLAUSE     = 4096 # Variable c_int

GCW_ATOM = win32con.GCW_ATOM # -32

GDICOMMENT_BEGINGROUP       = 2 # Variable c_int
GDICOMMENT_ENDGROUP         = 3 # Variable c_int
GDICOMMENT_MULTIFORMATS     = 1073741828 # Variable c_int
GDICOMMENT_IDENTIFIER       = 1128875079 # Variable c_int
GDICOMMENT_WINDOWS_METAFILE = 2147483649 # Variable c_uint

GDI_ERROR = win32con.GDI_ERROR # -1

GDTR_MIN = 1 # Variable c_int
GDTR_MAX = 2 # Variable c_int

GDT_VALID = 0 # Variable c_int
GDT_NONE  = 1 # Variable c_int
GDT_ERROR = -1 # Variable c_int

GENERIC_ALL     = win32con.GENERIC_ALL # 268435456
GENERIC_EXECUTE = win32con.GENERIC_EXECUTE # 536870912
GENERIC_WRITE   = win32con.GENERIC_WRITE # 1073741824
GENERIC_READ    = win32con.GENERIC_READ # -2147483648

GET_TAPE_MEDIA_INFORMATION = win32con.GET_TAPE_MEDIA_INFORMATION # 0
GET_TAPE_DRIVE_INFORMATION = win32con.GET_TAPE_DRIVE_INFORMATION # 1

GGL_LEVEL   = 1 # Variable c_int
GGL_INDEX   = 2 # Variable c_int
GGL_STRING  = 3 # Variable c_int
GGL_PRIVATE = 4 # Variable c_int

GGO_METRICS      = win32con.GGO_METRICS # 0
GGO_BITMAP       = win32con.GGO_BITMAP # 1
GGO_NATIVE       = win32con.GGO_NATIVE # 2
GGO_BEZIER       = 3 # Variable c_int
GGO_GRAY2_BITMAP = 4 # Variable c_int
GGO_GRAY4_BITMAP = 5 # Variable c_int
GGO_GRAY8_BITMAP = 6 # Variable c_int
GGO_GLYPH_INDEX  = 128 # Variable c_int

GL_ID_UNKNOWN           = 0 # Variable c_int
GL_LEVEL_NOGUIDELINE    = 0 # Variable c_int
GL_ID_NOMODULE          = 1 # Variable c_int
GL_LEVEL_FATAL          = 1 # Variable c_int
GL_LEVEL_ERROR          = 2 # Variable c_int
GL_LEVEL_WARNING        = 3 # Variable c_int
GL_LEVEL_INFORMATION    = 4 # Variable c_int
GL_ID_NODICTIONARY      = 16 # Variable c_int
GL_ID_CANNOTSAVE        = 17 # Variable c_int
GL_ID_NOCONVERT         = 32 # Variable c_int
GL_ID_TYPINGERROR       = 33 # Variable c_int
GL_ID_TOOMANYSTROKE     = 34 # Variable c_int
GL_ID_READINGCONFLICT   = 35 # Variable c_int
GL_ID_INPUTREADING      = 36 # Variable c_int
GL_ID_INPUTRADICAL      = 37 # Variable c_int
GL_ID_INPUTCODE         = 38 # Variable c_int
GL_ID_INPUTSYMBOL       = 39 # Variable c_int
GL_ID_CHOOSECANDIDATE   = 40 # Variable c_int
GL_ID_REVERSECONVERSION = 41 # Variable c_int
GL_ID_PRIVATE_FIRST     = 32768 # Variable c_int
GL_ID_PRIVATE_LAST      = 65535 # Variable c_int

GMDI_USEDISABLED  = win32con.GMDI_USEDISABLED # 1
GMDI_GOINTOPOPUPS = win32con.GMDI_GOINTOPOPUPS # 2

GMEM_FIXED          = win32con.GMEM_FIXED # 0
GMEM_MOVEABLE       = win32con.GMEM_MOVEABLE # 2
GMEM_NOCOMPACT      = win32con.GMEM_NOCOMPACT # 16
GMEM_NODISCARD      = win32con.GMEM_NODISCARD # 32
GMEM_ZEROINIT       = win32con.GMEM_ZEROINIT # 64
GMEM_MODIFY         = win32con.GMEM_MODIFY # 128
GMEM_LOCKCOUNT      = win32con.GMEM_LOCKCOUNT # 255
GMEM_DISCARDABLE    = win32con.GMEM_DISCARDABLE # 256
GMEM_NOT_BANKED     = win32con.GMEM_NOT_BANKED # 4096
GMEM_DDESHARE       = win32con.GMEM_DDESHARE # 8192
GMEM_SHARE          = win32con.GMEM_SHARE # 8192
GMEM_DISCARDED      = win32con.GMEM_DISCARDED # 16384
GMEM_NOTIFY         = win32con.GMEM_NOTIFY # 16384
GMEM_VALID_FLAGS    = win32con.GMEM_VALID_FLAGS # 32626
GMEM_INVALID_HANDLE = win32con.GMEM_INVALID_HANDLE # 32768

GMR_VISIBLE  = 0 # Variable c_int
GMR_DAYSTATE = 1 # Variable c_int

GM_COMPATIBLE = win32con.GM_COMPATIBLE # 1
GM_ADVANCED   = win32con.GM_ADVANCED # 2
GM_LAST       = win32con.GM_LAST # 2

GRADIENT_FILL_RECT_H   = win32con.GRADIENT_FILL_RECT_H # 0
GRADIENT_FILL_RECT_V   = win32con.GRADIENT_FILL_RECT_V # 1
GRADIENT_FILL_TRIANGLE = win32con.GRADIENT_FILL_TRIANGLE # 2
GRADIENT_FILL_OP_FLAG  = win32con.GRADIENT_FILL_OP_FLAG # 255

GRAY_BRUSH = win32con.GRAY_BRUSH # 2

GREEK_CHARSET = win32con.GREEK_CHARSET # 161

GROUP_SECURITY_INFORMATION = win32con.GROUP_SECURITY_INFORMATION # 2
GROUP_NAME                 = 128 # Variable c_int

GWL_WNDPROC    = win32con.GWL_WNDPROC # -4
GWL_HINSTANCE  = win32con.GWL_HINSTANCE # -6
GWL_HWNDPARENT = win32con.GWL_HWNDPARENT # -8
GWL_ID         = win32con.GWL_ID # -12
GWL_STYLE      = win32con.GWL_STYLE # -16
GWL_EXSTYLE    = win32con.GWL_EXSTYLE # -20
GWL_USERDATA   = win32con.GWL_USERDATA # -21

GW_HWNDFIRST    = win32con.GW_HWNDFIRST # 0
GW_HWNDLAST     = win32con.GW_HWNDLAST # 1
GW_HWNDNEXT     = win32con.GW_HWNDNEXT # 2
GW_HWNDPREV     = win32con.GW_HWNDPREV # 3
GW_OWNER        = win32con.GW_OWNER # 4
GW_CHILD        = win32con.GW_CHILD # 5
GW_MAX          = win32con.GW_MAX # 6
GW_ENABLEDPOPUP = win32con.GW_ENABLEDPOPUP # 6

HANDLE_FLAG_INHERIT            = win32con.HANDLE_FLAG_INHERIT # 1
HANDLE_FLAG_PROTECT_FROM_CLOSE = win32con.HANDLE_FLAG_PROTECT_FROM_CLOSE # 2

HANGEUL_CHARSET = win32con.HANGEUL_CHARSET # 129

HANGUL_CHARSET = 129 # Variable c_int

HANGUP_PENDING  = 4 # Variable c_int
HANGUP_COMPLETE = 5 # Variable c_int

HCBT_MOVESIZE     = win32con.HCBT_MOVESIZE # 0
HCBT_MINMAX       = win32con.HCBT_MINMAX # 1
HCBT_QS           = win32con.HCBT_QS # 2
HCBT_CREATEWND    = win32con.HCBT_CREATEWND # 3
HCBT_DESTROYWND   = win32con.HCBT_DESTROYWND # 4
HCBT_ACTIVATE     = win32con.HCBT_ACTIVATE # 5
HCBT_CLICKSKIPPED = win32con.HCBT_CLICKSKIPPED # 6
HCBT_KEYSKIPPED   = win32con.HCBT_KEYSKIPPED # 7
HCBT_SYSCOMMAND   = win32con.HCBT_SYSCOMMAND # 8
HCBT_SETFOCUS     = win32con.HCBT_SETFOCUS # 9

HCF_HIGHCONTRASTON  = win32con.HCF_HIGHCONTRASTON # 1
HCF_AVAILABLE       = win32con.HCF_AVAILABLE # 2
HCF_HOTKEYACTIVE    = win32con.HCF_HOTKEYACTIVE # 4
HCF_CONFIRMHOTKEY   = win32con.HCF_CONFIRMHOTKEY # 8
HCF_HOTKEYSOUND     = win32con.HCF_HOTKEYSOUND # 16
HCF_INDICATOR       = win32con.HCF_INDICATOR # 32
HCF_HOTKEYAVAILABLE = win32con.HCF_HOTKEYAVAILABLE # 64

HC_ACTION      = win32con.HC_ACTION # 0
HC_GETNEXT     = win32con.HC_GETNEXT # 1
HC_SKIP        = win32con.HC_SKIP # 2
HC_NOREMOVE    = win32con.HC_NOREMOVE # 3
HC_SYSMODALON  = win32con.HC_SYSMODALON # 4
HC_SYSMODALOFF = win32con.HC_SYSMODALOFF # 5

HDATA_APPOWNED = 1 # Variable c_int

HDF_LEFT            = 0 # Variable c_int
HDF_RIGHT           = 1 # Variable c_int
HDF_CENTER          = 2 # Variable c_int
HDF_JUSTIFYMASK     = 3 # Variable c_int
HDF_RTLREADING      = 4 # Variable c_int
HDF_IMAGE           = 2048 # Variable c_int
HDF_BITMAP_ON_RIGHT = 4096 # Variable c_int
HDF_BITMAP          = 8192 # Variable c_int
HDF_STRING          = 16384 # Variable c_int
HDF_OWNERDRAW       = 32768 # Variable c_int

HDITEMA_V1_SIZE = 28 # Variable c_uint

HDITEMW_V1_SIZE = 28 # Variable c_uint

HDI_WIDTH      = 1 # Variable c_int
HDI_TEXT       = 2 # Variable c_int
HDI_FORMAT     = 4 # Variable c_int
HDI_LPARAM     = 8 # Variable c_int
HDI_BITMAP     = 16 # Variable c_int
HDI_IMAGE      = 32 # Variable c_int
HDI_DI_SETITEM = 64 # Variable c_int
HDI_ORDER      = 128 # Variable c_int

HDM_GETITEMCOUNT    = 4608 # Variable c_int
HDM_FIRST           = 4608 # Variable c_int
HDM_INSERTITEMA     = 4609 # Variable c_int
HDM_DELETEITEM      = 4610 # Variable c_int
HDM_GETITEMA        = 4611 # Variable c_int
HDM_SETITEMA        = 4612 # Variable c_int
HDM_LAYOUT          = 4613 # Variable c_int
HDM_HITTEST         = 4614 # Variable c_int
HDM_GETITEMRECT     = 4615 # Variable c_int
HDM_SETIMAGELIST    = 4616 # Variable c_int
HDM_GETIMAGELIST    = 4617 # Variable c_int
HDM_INSERTITEMW     = 4618 # Variable c_int
HDM_GETITEMW        = 4619 # Variable c_int
HDM_SETITEMW        = 4620 # Variable c_int
HDM_ORDERTOINDEX    = 4623 # Variable c_int
HDM_CREATEDRAGIMAGE = 4624 # Variable c_int
HDM_GETORDERARRAY   = 4625 # Variable c_int
HDM_SETORDERARRAY   = 4626 # Variable c_int
HDM_SETHOTDIVIDER   = 4627 # Variable c_int

HDN_LAST             = 4294966897 # Variable c_uint
HDN_GETDISPINFOW     = 4294966967 # Variable c_uint
HDN_TRACKW           = 4294966968 # Variable c_uint
HDN_ENDTRACKW        = 4294966969 # Variable c_uint
HDN_BEGINTRACKW      = 4294966970 # Variable c_uint
HDN_DIVIDERDBLCLICKW = 4294966971 # Variable c_uint
HDN_ITEMDBLCLICKW    = 4294966973 # Variable c_uint
HDN_ITEMCLICKW       = 4294966974 # Variable c_uint
HDN_ITEMCHANGEDW     = 4294966975 # Variable c_uint
HDN_ITEMCHANGINGW    = 4294966976 # Variable c_uint
HDN_ENDDRAG          = 4294966985 # Variable c_uint
HDN_BEGINDRAG        = 4294966986 # Variable c_uint
HDN_GETDISPINFOA     = 4294966987 # Variable c_uint
HDN_TRACKA           = 4294966988 # Variable c_uint
HDN_ENDTRACKA        = 4294966989 # Variable c_uint
HDN_BEGINTRACKA      = 4294966990 # Variable c_uint
HDN_DIVIDERDBLCLICKA = 4294966991 # Variable c_uint
HDN_ITEMDBLCLICKA    = 4294966993 # Variable c_uint
HDN_ITEMCLICKA       = 4294966994 # Variable c_uint
HDN_ITEMCHANGEDA     = 4294966995 # Variable c_uint
HDN_ITEMCHANGINGA    = 4294966996 # Variable c_uint
HDN_FIRST            = 4294966996 # Variable c_uint
HDN_BEGINFILTEREDIT  = 4294966982
HDN_DROPDOWN         = 4294966978
HDN_ENDFILTEREDIT    = 4294966981
HDN_FILTERBTNCLICK   = 4294966983
HDN_FILTERCHANGE     = 4294966984
HDN_ITEMCHANGED      = 4294966995
HDN_ITEMKEYDOWN      = 4294966979
HDN_OVERFLOWCLICK    = 4294966977
HDN_ITEMSTATEICONCLICK = 4294966980

HDS_HORZ     = 0 # Variable c_int
HDS_BUTTONS  = 2 # Variable c_int
HDS_HOTTRACK = 4 # Variable c_int
HDS_HIDDEN   = 8 # Variable c_int
HDS_DRAGDROP = 64 # Variable c_int
HDS_FULLDRAG = 128 # Variable c_int

HEAP_NO_SERIALIZE             = win32con.HEAP_NO_SERIALIZE # 1
HEAP_GROWABLE                 = win32con.HEAP_GROWABLE # 2
HEAP_GENERATE_EXCEPTIONS      = win32con.HEAP_GENERATE_EXCEPTIONS # 4
HEAP_ZERO_MEMORY              = win32con.HEAP_ZERO_MEMORY # 8
HEAP_REALLOC_IN_PLACE_ONLY    = win32con.HEAP_REALLOC_IN_PLACE_ONLY # 16
HEAP_TAG_SHIFT                = 18 # Variable c_int
HEAP_TAIL_CHECKING_ENABLED    = win32con.HEAP_TAIL_CHECKING_ENABLED # 32
HEAP_FREE_CHECKING_ENABLED    = win32con.HEAP_FREE_CHECKING_ENABLED # 64
HEAP_DISABLE_COALESCE_ON_FREE = win32con.HEAP_DISABLE_COALESCE_ON_FREE # 128
HEAP_MAXIMUM_TAG              = 4095 # Variable c_int
HEAP_PSEUDO_TAG_FLAG          = 32768 # Variable c_int
HEAP_CREATE_ALIGN_16          = 65536 # Variable c_int
HEAP_CREATE_ENABLE_TRACING    = 131072 # Variable c_int

HEBREW_CHARSET = win32con.HEBREW_CHARSET # 177

HELPINFO_WINDOW   = win32con.HELPINFO_WINDOW # 1
HELPINFO_MENUITEM = win32con.HELPINFO_MENUITEM # 2

HELP_CONTEXT            = win32con.HELP_CONTEXT # 1
HELP_QUIT               = win32con.HELP_QUIT # 2
HELP_CONTENTS           = win32con.HELP_CONTENTS # 3
HELP_INDEX              = win32con.HELP_INDEX # 3
HELP_HELPONHELP         = win32con.HELP_HELPONHELP # 4
HELP_SETINDEX           = win32con.HELP_SETINDEX # 5
HELP_SETCONTENTS        = win32con.HELP_SETCONTENTS # 5
HELP_CONTEXTPOPUP       = win32con.HELP_CONTEXTPOPUP # 8
HELP_FORCEFILE          = win32con.HELP_FORCEFILE # 9
HELP_CONTEXTMENU        = win32con.HELP_CONTEXTMENU # 10
HELP_FINDER             = win32con.HELP_FINDER # 11
HELP_WM_HELP            = win32con.HELP_WM_HELP # 12
HELP_SETPOPUP_POS       = win32con.HELP_SETPOPUP_POS # 13
HELP_TCARD_DATA         = win32con.HELP_TCARD_DATA # 16
HELP_TCARD_OTHER_CALLER = win32con.HELP_TCARD_OTHER_CALLER # 17
HELP_KEY                = win32con.HELP_KEY # 257
HELP_COMMAND            = win32con.HELP_COMMAND # 258
HELP_PARTIALKEY         = win32con.HELP_PARTIALKEY # 261
HELP_MULTIKEY           = win32con.HELP_MULTIKEY # 513
HELP_SETWINPOS          = win32con.HELP_SETWINPOS # 515
HELP_TCARD              = win32con.HELP_TCARD # 32768

HFILE_ERROR = -1 # Variable c_int

HGDI_ERROR = 4294967295 # Variable c_void_p

HHT_NOWHERE   = 1 # Variable c_int
HHT_ONHEADER  = 2 # Variable c_int
HHT_ONDIVIDER = 4 # Variable c_int
HHT_ONDIVOPEN = 8 # Variable c_int
HHT_ABOVE     = 256 # Variable c_int
HHT_BELOW     = 512 # Variable c_int
HHT_TORIGHT   = 1024 # Variable c_int
HHT_TOLEFT    = 2048 # Variable c_int

HICF_OTHER       = 0 # Variable c_int
HICF_MOUSE       = 1 # Variable c_int
HICF_ARROWKEYS   = 2 # Variable c_int
HICF_ACCELERATOR = 4 # Variable c_int
HICF_DUPACCEL    = 8 # Variable c_int
HICF_ENTERING    = 16 # Variable c_int
HICF_LEAVING     = 32 # Variable c_int
HICF_RESELECT    = 64 # Variable c_int

HIDE_WINDOW = win32con.HIDE_WINDOW # 0

HIGH_PRIORITY_CLASS = win32con.HIGH_PRIORITY_CLASS # 128

HINSTANCE_ERROR = win32con.HINSTANCE_ERROR # 32

HINST_COMMCTRL = 4294967295 # Variable POINTER(HINSTANCE__)

HIST_BACK           = 0 # Variable c_int
HIST_FORWARD        = 1 # Variable c_int
HIST_FAVORITES      = 2 # Variable c_int
HIST_ADDTOFAVORITES = 3 # Variable c_int
HIST_VIEWTREE       = 4 # Variable c_int

HKCOMB_NONE = 1 # Variable c_int
HKCOMB_S    = 2 # Variable c_int
HKCOMB_C    = 4 # Variable c_int
HKCOMB_A    = 8 # Variable c_int
HKCOMB_SC   = 16 # Variable c_int
HKCOMB_SA   = 32 # Variable c_int
HKCOMB_CA   = 64 # Variable c_int
HKCOMB_SCA  = 128 # Variable c_int

HKEY_CLASSES_ROOT     = win32con.HKEY_CLASSES_ROOT # -2147483648
HKEY_CURRENT_USER     = win32con.HKEY_CURRENT_USER # -2147483647
HKEY_LOCAL_MACHINE    = win32con.HKEY_LOCAL_MACHINE # -2147483646
HKEY_USERS            = win32con.HKEY_USERS # -2147483645
HKEY_PERFORMANCE_DATA = win32con.HKEY_PERFORMANCE_DATA # -2147483644
HKEY_CURRENT_CONFIG   = win32con.HKEY_CURRENT_CONFIG # -2147483643
HKEY_DYN_DATA         = win32con.HKEY_DYN_DATA # -2147483642

HKL_PREV = win32con.HKL_PREV # 0
HKL_NEXT = win32con.HKL_NEXT # 1

HKM_SETHOTKEY = 1025 # Variable c_int
HKM_GETHOTKEY = 1026 # Variable c_int
HKM_SETRULES  = 1027 # Variable c_int

HOTKEYF_SHIFT   = 1 # Variable c_int
HOTKEYF_CONTROL = 2 # Variable c_int
HOTKEYF_ALT     = 4 # Variable c_int
HOTKEYF_EXT     = 8 # Variable c_int

HOTKEY_CLASSA = 'msctls_hotkey32' # Variable POINTER(c_char)
HOTKEY_CLASSW = 'msctls_hotkey32' # Variable POINTER(c_wchar)

HOVER_DEFAULT = win32con.HOVER_DEFAULT # -1

HSHELL_WINDOWCREATED       = win32con.HSHELL_WINDOWCREATED # 1
HSHELL_WINDOWDESTROYED     = win32con.HSHELL_WINDOWDESTROYED # 2
HSHELL_ACTIVATESHELLWINDOW = win32con.HSHELL_ACTIVATESHELLWINDOW # 3
HSHELL_WINDOWACTIVATED     = win32con.HSHELL_WINDOWACTIVATED # 4
HSHELL_GETMINRECT          = win32con.HSHELL_GETMINRECT # 5
HSHELL_REDRAW              = win32con.HSHELL_REDRAW # 6
HSHELL_TASKMAN             = win32con.HSHELL_TASKMAN # 7
HSHELL_LANGUAGE            = win32con.HSHELL_LANGUAGE # 8

HS_HORIZONTAL = win32con.HS_HORIZONTAL # 0
HS_VERTICAL   = win32con.HS_VERTICAL # 1
HS_FDIAGONAL  = win32con.HS_FDIAGONAL # 2
HS_BDIAGONAL  = win32con.HS_BDIAGONAL # 3
HS_CROSS      = win32con.HS_CROSS # 4
HS_DIAGCROSS  = win32con.HS_DIAGCROSS # 5

HWND_DESKTOP   = win32con.HWND_DESKTOP # 0
HWND_TOP       = win32con.HWND_TOP # 0
HWND_BOTTOM    = win32con.HWND_BOTTOM # 1
HWND_BROADCAST = win32con.HWND_BROADCAST # 65535
HWND_NOTOPMOST = win32con.HWND_NOTOPMOST # -2
HWND_TOPMOST   = win32con.HWND_TOPMOST # -1

IA64_JMPE_MARKER        = 3473423 # Variable c_int
IA64_JMPE_MASK          = 16777215 # Variable c_int
IA64_STUB_NOT_AVAILABLE = 4294967295 # Variable c_void_p

ICC_LISTVIEW_CLASSES   = 1 # Variable c_int
ICC_TREEVIEW_CLASSES   = 2 # Variable c_int
ICC_BAR_CLASSES        = 4 # Variable c_int
ICC_TAB_CLASSES        = 8 # Variable c_int
ICC_UPDOWN_CLASS       = 16 # Variable c_int
ICC_PROGRESS_CLASS     = 32 # Variable c_int
ICC_HOTKEY_CLASS       = 64 # Variable c_int
ICC_ANIMATE_CLASS      = 128 # Variable c_int
ICC_WIN95_CLASSES      = 255 # Variable c_int
ICC_DATE_CLASSES       = 256 # Variable c_int
ICC_USEREX_CLASSES     = 512 # Variable c_int
ICC_COOL_CLASSES       = 1024 # Variable c_int
ICC_INTERNET_CLASSES   = 2048 # Variable c_int
ICC_PAGESCROLLER_CLASS = 4096 # Variable c_int
ICC_NATIVEFNTCTL_CLASS = 8192 # Variable c_int

ICM_OFF                 = 1 # Variable c_int
ICM_ADDPROFILE          = 1 # Variable c_int
ICM_DELETEPROFILE       = 2 # Variable c_int
ICM_ON                  = 2 # Variable c_int
ICM_QUERYPROFILE        = 3 # Variable c_int
ICM_QUERY               = 3 # Variable c_int
ICM_DONE_OUTSIDEDC      = 4 # Variable c_int
ICM_SETDEFAULTPROFILE   = 4 # Variable c_int
ICM_REGISTERICMATCHER   = 5 # Variable c_int
ICM_UNREGISTERICMATCHER = 6 # Variable c_int
ICM_QUERYMATCH          = 7 # Variable c_int

ICON_SMALL = win32con.ICON_SMALL # 0
ICON_BIG   = win32con.ICON_BIG # 1

IDANI_OPEN    = win32con.IDANI_OPEN # 1
IDANI_CLOSE   = win32con.IDANI_CLOSE # 2
IDANI_CAPTION = win32con.IDANI_CAPTION # 3

IDB_STD_SMALL_COLOR  = 0 # Variable c_int
IDB_STD_LARGE_COLOR  = 1 # Variable c_int
IDB_VIEW_SMALL_COLOR = 4 # Variable c_int
IDB_VIEW_LARGE_COLOR = 5 # Variable c_int
IDB_HIST_SMALL_COLOR = 8 # Variable c_int
IDB_HIST_LARGE_COLOR = 9 # Variable c_int

IDC_ARROW       = win32con.IDC_ARROW # 32512
IDC_IBEAM       = win32con.IDC_IBEAM # 32513
IDC_WAIT        = win32con.IDC_WAIT # 32514
IDC_CROSS       = win32con.IDC_CROSS # 32515
IDC_UPARROW     = win32con.IDC_UPARROW # 32516
IDC_SIZE        = win32con.IDC_SIZE # 32640
IDC_ICON        = win32con.IDC_ICON # 32641
IDC_SIZENWSE    = win32con.IDC_SIZENWSE # 32642
IDC_SIZENESW    = win32con.IDC_SIZENESW # 32643
IDC_SIZEWE      = win32con.IDC_SIZEWE # 32644
IDC_SIZENS      = win32con.IDC_SIZENS # 32645
IDC_SIZEALL     = win32con.IDC_SIZEALL # 32646
IDC_NO          = win32con.IDC_NO # 32648
IDC_APPSTARTING = win32con.IDC_APPSTARTING # 32650
IDC_HELP        = win32con.IDC_HELP # 32651

IDHOT_SNAPWINDOW  = win32con.IDHOT_SNAPWINDOW # -1
IDHOT_SNAPDESKTOP = win32con.IDHOT_SNAPDESKTOP # -2

IDH_NO_HELP             = win32con.IDH_NO_HELP # 28440
IDH_MISSING_CONTEXT     = win32con.IDH_MISSING_CONTEXT # 28441
IDH_GENERIC_HELP_BUTTON = win32con.IDH_GENERIC_HELP_BUTTON # 28442
IDH_OK                  = win32con.IDH_OK # 28443
IDH_CANCEL              = win32con.IDH_CANCEL # 28444
IDH_HELP                = win32con.IDH_HELP # 28445

IDI_APPLICATION = win32con.IDI_APPLICATION # 32512
IDI_HAND        = win32con.IDI_HAND # 32513
IDI_QUESTION    = win32con.IDI_QUESTION # 32514
IDI_EXCLAMATION = win32con.IDI_EXCLAMATION # 32515
IDI_ASTERISK    = win32con.IDI_ASTERISK # 32516
IDI_WINLOGO     = win32con.IDI_WINLOGO # 32517

IDLE_PRIORITY_CLASS = win32con.IDLE_PRIORITY_CLASS # 64

IDLFLAG_NONE    = 0 # Variable c_int
IDLFLAG_FIN     = 1 # Variable c_int
IDLFLAG_FOUT    = 2 # Variable c_int
IDLFLAG_FLCID   = 4 # Variable c_int
IDLFLAG_FRETVAL = 8 # Variable c_int

ID_PSRESTARTWINDOWS = 2 # Variable c_int
ID_PSREBOOTSYSTEM   = 3 # Variable c_int
ID_DEFAULTINST      = -2 # Variable c_int

IE_BADID    = -1 # Variable c_int
IE_OPEN     = -2 # Variable c_int
IE_NOPEN    = -3 # Variable c_int
IE_MEMORY   = -4 # Variable c_int
IE_DEFAULT  = -5 # Variable c_int
IE_HARDWARE = -10 # Variable c_int
IE_BYTESIZE = -11 # Variable c_int
IE_BAUDRATE = -12 # Variable c_int

IGP_PROPERTY      = 4 # Variable c_int
IGP_CONVERSION    = 8 # Variable c_int
IGP_SENTENCE      = 12 # Variable c_int
IGP_UI            = 16 # Variable c_int
IGP_SETCOMPSTR    = 20 # Variable c_int
IGP_SELECT        = 24 # Variable c_int
IGP_GETIMEVERSION = 4294967292 # Variable c_ulong

ILCF_MOVE = 0 # Variable c_int
ILCF_SWAP = 1 # Variable c_int

ILC_COLOR    = 0 # Variable c_int
ILC_MASK     = 1 # Variable c_int
ILC_COLOR4   = 4 # Variable c_int
ILC_COLOR8   = 8 # Variable c_int
ILC_COLOR16  = 16 # Variable c_int
ILC_COLOR24  = 24 # Variable c_int
ILC_COLOR32  = 32 # Variable c_int
ILC_COLORDDB = 254 # Variable c_int
ILC_PALETTE  = 2048 # Variable c_int

ILD_NORMAL      = 0 # Variable c_int
ILD_TRANSPARENT = 1 # Variable c_int
ILD_BLEND25     = 2 # Variable c_int
ILD_BLEND50     = 4 # Variable c_int
ILD_MASK        = 16 # Variable c_int
ILD_IMAGE       = 32 # Variable c_int
ILD_ROP         = 64 # Variable c_int
ILD_OVERLAYMASK = 3840 # Variable c_int

ILLUMINANT_DEVICE_DEFAULT = win32con.ILLUMINANT_DEVICE_DEFAULT # 0
ILLUMINANT_A              = win32con.ILLUMINANT_A # 1
ILLUMINANT_B              = win32con.ILLUMINANT_B # 2
ILLUMINANT_C              = win32con.ILLUMINANT_C # 3
ILLUMINANT_D50            = win32con.ILLUMINANT_D50 # 4
ILLUMINANT_D55            = win32con.ILLUMINANT_D55 # 5
ILLUMINANT_D65            = win32con.ILLUMINANT_D65 # 6
ILLUMINANT_D75            = win32con.ILLUMINANT_D75 # 7
ILLUMINANT_F2             = win32con.ILLUMINANT_F2 # 8

IMAGE_REL_SH3_ABSOLUTE               = 0 # Variable c_int
IMAGE_DIRECTORY_ENTRY_EXPORT         = 0 # Variable c_int
IMAGE_SYM_TYPE_NULL                  = 0 # Variable c_int
IMAGE_BITMAP                         = win32con.IMAGE_BITMAP # 0
IMAGE_SUBSYSTEM_UNKNOWN              = 0 # Variable c_int
IMAGE_REL_BASED_ABSOLUTE             = win32con.IMAGE_REL_BASED_ABSOLUTE # 0
IMAGE_REL_MIPS_ABSOLUTE              = 0 # Variable c_int
IMAGE_REL_I386_ABSOLUTE              = 0 # Variable c_int
IMAGE_REL_ALPHA_ABSOLUTE             = win32con.IMAGE_REL_ALPHA_ABSOLUTE # 0
IMAGE_REL_IA64_ABSOLUTE              = 0 # Variable c_int
IMAGE_DEBUG_TYPE_UNKNOWN             = win32con.IMAGE_DEBUG_TYPE_UNKNOWN # 0
IMAGE_SYM_DTYPE_NULL                 = 0 # Variable c_int
IMAGE_SYM_CLASS_NULL                 = win32con.IMAGE_SYM_CLASS_NULL # 0
IMAGE_FILE_MACHINE_UNKNOWN           = win32con.IMAGE_FILE_MACHINE_UNKNOWN # 0
IMAGE_REL_ARM_ABSOLUTE               = 0 # Variable c_int
IMAGE_REL_PPC_ABSOLUTE               = 0 # Variable c_int
IMAGE_SYM_UNDEFINED                  = 0 # Variable c_short
IMAGE_SYM_TYPE_VOID                  = 1 # Variable c_int
IMAGE_REL_ARM_ADDR32                 = 1 # Variable c_int
IMAGE_SUBSYSTEM_NATIVE               = 1 # Variable c_int
IMAGE_REL_MIPS_REFHALF               = win32con.IMAGE_REL_MIPS_REFHALF # 1
IMAGE_SYM_CLASS_AUTOMATIC            = win32con.IMAGE_SYM_CLASS_AUTOMATIC # 1
IMAGE_REL_PPC_ADDR64                 = 1 # Variable c_int
IMAGE_COMDAT_SELECT_NODUPLICATES     = win32con.IMAGE_COMDAT_SELECT_NODUPLICATES # 1
IMAGE_REL_SH3_DIRECT16               = 1 # Variable c_int
IMAGE_REL_BASED_HIGH                 = win32con.IMAGE_REL_BASED_HIGH # 1
IMAGE_REL_ALPHA_REFLONG              = win32con.IMAGE_REL_ALPHA_REFLONG # 1
IMAGE_WEAK_EXTERN_SEARCH_NOLIBRARY   = win32con.IMAGE_WEAK_EXTERN_SEARCH_NOLIBRARY # 1
IMAGE_DEBUG_MISC_EXENAME             = win32con.IMAGE_DEBUG_MISC_EXENAME # 1
IMAGE_DIRECTORY_ENTRY_IMPORT         = 1 # Variable c_int
IMAGE_FILE_RELOCS_STRIPPED           = 1 # Variable c_int
IMAGE_SCN_SCALE_INDEX                = 1 # Variable c_int
IMAGE_REL_IA64_IMM14                 = 1 # Variable c_int
IMAGE_REL_I386_DIR16                 = 1 # Variable c_int
IMAGE_ICON                           = win32con.IMAGE_ICON # 1
IMAGE_DEBUG_TYPE_COFF                = win32con.IMAGE_DEBUG_TYPE_COFF # 1
IMAGE_SYM_DTYPE_POINTER              = 1 # Variable c_int
IMAGE_SYM_CLASS_EXTERNAL             = win32con.IMAGE_SYM_CLASS_EXTERNAL # 2
IMAGE_REL_ARM_ADDR32NB               = 2 # Variable c_int
IMAGE_CURSOR                         = win32con.IMAGE_CURSOR # 2
IMAGE_MIX_ISA_LIMIT                  = 2 # Variable c_int
IMAGE_REL_SH3_DIRECT32               = 2 # Variable c_int
IMAGE_REL_PPC_ADDR32                 = 2 # Variable c_int
IMAGE_REL_BASED_LOW                  = win32con.IMAGE_REL_BASED_LOW # 2
IMAGE_REL_IA64_IMM22                 = 2 # Variable c_int
IMAGE_REL_MIPS_REFWORD               = win32con.IMAGE_REL_MIPS_REFWORD # 2
IMAGE_SYM_TYPE_CHAR                  = 2 # Variable c_int
IMAGE_COMDAT_SELECT_ANY              = win32con.IMAGE_COMDAT_SELECT_ANY # 2
IMAGE_WEAK_EXTERN_SEARCH_LIBRARY     = win32con.IMAGE_WEAK_EXTERN_SEARCH_LIBRARY # 2
IMAGE_SYM_DTYPE_FUNCTION             = 2 # Variable c_int
IMAGE_DEBUG_TYPE_CODEVIEW            = win32con.IMAGE_DEBUG_TYPE_CODEVIEW # 2
IMAGE_REL_I386_REL16                 = 2 # Variable c_int
IMAGE_REL_ALPHA_REFQUAD              = win32con.IMAGE_REL_ALPHA_REFQUAD # 2
IMAGE_SUBSYSTEM_WINDOWS_GUI          = 2 # Variable c_int
IMAGE_FILE_EXECUTABLE_IMAGE          = 2 # Variable c_int
IMAGE_DIRECTORY_ENTRY_RESOURCE       = 2 # Variable c_int
IMAGE_REL_SH3_DIRECT8                = 3 # Variable c_int
IMAGE_SYM_TYPE_SHORT                 = 3 # Variable c_int
IMAGE_REL_IA64_IMM64                 = 3 # Variable c_int
IMAGE_SYM_CLASS_STATIC               = win32con.IMAGE_SYM_CLASS_STATIC # 3
IMAGE_COMDAT_SELECT_SAME_SIZE        = win32con.IMAGE_COMDAT_SELECT_SAME_SIZE # 3
IMAGE_REL_BASED_HIGHLOW              = win32con.IMAGE_REL_BASED_HIGHLOW # 3
IMAGE_SUBSYSTEM_WINDOWS_CUI          = 3 # Variable c_int
IMAGE_REL_ARM_BRANCH24               = 3 # Variable c_int
IMAGE_SYM_DTYPE_ARRAY                = 3 # Variable c_int
IMAGE_REL_ALPHA_GPREL32              = win32con.IMAGE_REL_ALPHA_GPREL32 # 3
IMAGE_REL_PPC_ADDR24                 = 3 # Variable c_int
IMAGE_REL_MIPS_JMPADDR               = win32con.IMAGE_REL_MIPS_JMPADDR # 3
IMAGE_DIRECTORY_ENTRY_EXCEPTION      = 3 # Variable c_int
IMAGE_ENHMETAFILE                    = win32con.IMAGE_ENHMETAFILE # 3
IMAGE_DEBUG_TYPE_FPO                 = win32con.IMAGE_DEBUG_TYPE_FPO # 3
IMAGE_WEAK_EXTERN_SEARCH_ALIAS       = win32con.IMAGE_WEAK_EXTERN_SEARCH_ALIAS # 3
IMAGE_REL_SH3_DIRECT8_WORD           = 4 # Variable c_int
IMAGE_FILE_LINE_NUMS_STRIPPED        = 4 # Variable c_int
IMAGE_REL_PPC_ADDR16                 = 4 # Variable c_int
IMAGE_REL_BASED_HIGHADJ              = win32con.IMAGE_REL_BASED_HIGHADJ # 4
IMAGE_REL_MIPS_REFHI                 = win32con.IMAGE_REL_MIPS_REFHI # 4
IMAGE_SYM_TYPE_INT                   = 4 # Variable c_int
IMAGE_COMDAT_SELECT_EXACT_MATCH      = win32con.IMAGE_COMDAT_SELECT_EXACT_MATCH # 4
IMAGE_REL_IA64_DIR32                 = 4 # Variable c_int
IMAGE_SYM_CLASS_REGISTER             = win32con.IMAGE_SYM_CLASS_REGISTER # 4
IMAGE_DIRECTORY_ENTRY_SECURITY       = 4 # Variable c_int
IMAGE_REL_ARM_BRANCH11               = 4 # Variable c_int
IMAGE_DEBUG_TYPE_MISC                = win32con.IMAGE_DEBUG_TYPE_MISC # 4
IMAGE_REL_ALPHA_LITERAL              = win32con.IMAGE_REL_ALPHA_LITERAL # 4
IMAGE_REL_BASED_MIPS_JMPADDR         = win32con.IMAGE_REL_BASED_MIPS_JMPADDR # 5
IMAGE_SYM_CLASS_EXTERNAL_DEF         = win32con.IMAGE_SYM_CLASS_EXTERNAL_DEF # 5
IMAGE_REL_ALPHA_LITUSE               = win32con.IMAGE_REL_ALPHA_LITUSE # 5
IMAGE_REL_IA64_DIR64                 = 5 # Variable c_int
IMAGE_SYM_TYPE_LONG                  = 5 # Variable c_int
IMAGE_COMDAT_SELECT_ASSOCIATIVE      = win32con.IMAGE_COMDAT_SELECT_ASSOCIATIVE # 5
IMAGE_REL_SH3_DIRECT8_LONG           = 5 # Variable c_int
IMAGE_SUBSYSTEM_OS2_CUI              = 5 # Variable c_int
IMAGE_REL_MIPS_REFLO                 = win32con.IMAGE_REL_MIPS_REFLO # 5
IMAGE_DEBUG_TYPE_EXCEPTION           = win32con.IMAGE_DEBUG_TYPE_EXCEPTION # 5
IMAGE_DIRECTORY_ENTRY_BASERELOC      = 5 # Variable c_int
IMAGE_REL_PPC_ADDR14                 = 5 # Variable c_int
IMAGE_REL_PPC_REL24                  = 6 # Variable c_int
IMAGE_REL_IA64_PCREL21B              = 6 # Variable c_int
IMAGE_REL_ALPHA_GPDISP               = win32con.IMAGE_REL_ALPHA_GPDISP # 6
IMAGE_DIRECTORY_ENTRY_DEBUG          = 6 # Variable c_int
IMAGE_REL_SH3_DIRECT4                = 6 # Variable c_int
IMAGE_COMDAT_SELECT_LARGEST          = 6 # Variable c_int
IMAGE_REL_BASED_SECTION              = 6 # Variable c_int
IMAGE_REL_I386_DIR32                 = 6 # Variable c_int
IMAGE_SYM_TYPE_FLOAT                 = 6 # Variable c_int
IMAGE_SIZEOF_LINENUMBER              = win32con.IMAGE_SIZEOF_LINENUMBER # 6
IMAGE_REL_MIPS_GPREL                 = win32con.IMAGE_REL_MIPS_GPREL # 6
IMAGE_DEBUG_TYPE_FIXUP               = win32con.IMAGE_DEBUG_TYPE_FIXUP # 6
IMAGE_SYM_CLASS_LABEL                = win32con.IMAGE_SYM_CLASS_LABEL # 6
IMAGE_REL_PPC_REL14                  = 7 # Variable c_int
IMAGE_REL_SH3_DIRECT4_WORD           = 7 # Variable c_int
IMAGE_SYM_CLASS_UNDEFINED_LABEL      = win32con.IMAGE_SYM_CLASS_UNDEFINED_LABEL # 7
IMAGE_SYM_TYPE_DOUBLE                = 7 # Variable c_int
IMAGE_DEBUG_TYPE_OMAP_TO_SRC         = win32con.IMAGE_DEBUG_TYPE_OMAP_TO_SRC # 7
IMAGE_REL_IA64_PCREL21M              = 7 # Variable c_int
IMAGE_REL_BASED_REL32                = 7 # Variable c_int
IMAGE_REL_ALPHA_BRADDR               = win32con.IMAGE_REL_ALPHA_BRADDR # 7
IMAGE_DIRECTORY_ENTRY_ARCHITECTURE   = 7 # Variable c_int
IMAGE_COMDAT_SELECT_NEWEST           = 7 # Variable c_int
IMAGE_SUBSYSTEM_POSIX_CUI            = 7 # Variable c_int
IMAGE_REL_I386_DIR32NB               = 7 # Variable c_int
IMAGE_REL_MIPS_LITERAL               = win32con.IMAGE_REL_MIPS_LITERAL # 7
IMAGE_REL_SH3_DIRECT4_LONG           = 8 # Variable c_int
IMAGE_REL_PPC_TOCREL16               = 8 # Variable c_int
IMAGE_FILE_LOCAL_SYMS_STRIPPED       = 8 # Variable c_int
IMAGE_REL_ALPHA_HINT                 = win32con.IMAGE_REL_ALPHA_HINT # 8
IMAGE_DEBUG_TYPE_OMAP_FROM_SRC       = win32con.IMAGE_DEBUG_TYPE_OMAP_FROM_SRC # 8
IMAGE_SIZEOF_SHORT_NAME              = win32con.IMAGE_SIZEOF_SHORT_NAME # 8
IMAGE_SIZEOF_BASE_RELOCATION         = win32con.IMAGE_SIZEOF_BASE_RELOCATION # 8
IMAGE_SCN_TYPE_NO_PAD                = 8 # Variable c_int
IMAGE_SYM_CLASS_MEMBER_OF_STRUCT     = win32con.IMAGE_SYM_CLASS_MEMBER_OF_STRUCT # 8
IMAGE_REL_IA64_PCREL21F              = 8 # Variable c_int
IMAGE_SUBSYSTEM_NATIVE_WINDOWS       = 8 # Variable c_int
IMAGE_ARCHIVE_START_SIZE             = win32con.IMAGE_ARCHIVE_START_SIZE # 8
IMAGE_DIRECTORY_ENTRY_GLOBALPTR      = 8 # Variable c_int
IMAGE_SYM_TYPE_STRUCT                = 8 # Variable c_int
IMAGE_REL_PPC_TOCREL14               = 9 # Variable c_int
IMAGE_SYM_TYPE_UNION                 = 9 # Variable c_int
IMAGE_REL_SH3_PCREL8_WORD            = 9 # Variable c_int
IMAGE_SUBSYSTEM_WINDOWS_CE_GUI       = 9 # Variable c_int
IMAGE_REL_BASED_IA64_IMM64           = 9 # Variable c_int
IMAGE_REL_BASED_MIPS_JMPADDR16       = 9 # Variable c_int
IMAGE_DEBUG_TYPE_BORLAND             = 9 # Variable c_int
IMAGE_REL_ALPHA_INLINE_REFLONG       = win32con.IMAGE_REL_ALPHA_INLINE_REFLONG # 9
IMAGE_REL_IA64_GPREL22               = 9 # Variable c_int
IMAGE_SYM_CLASS_ARGUMENT             = win32con.IMAGE_SYM_CLASS_ARGUMENT # 9
IMAGE_REL_I386_SEG12                 = 9 # Variable c_int
IMAGE_DIRECTORY_ENTRY_TLS            = 9 # Variable c_int
IMAGE_REL_ALPHA_REFHI                = win32con.IMAGE_REL_ALPHA_REFHI # 10
IMAGE_REL_MIPS_SECTION               = win32con.IMAGE_REL_MIPS_SECTION # 10
IMAGE_SYM_TYPE_ENUM                  = 10 # Variable c_int
IMAGE_REL_SH3_PCREL8_LONG            = 10 # Variable c_int
IMAGE_REL_BASED_DIR64                = 10 # Variable c_int
IMAGE_REL_PPC_ADDR32NB               = 10 # Variable c_int
IMAGE_REL_IA64_LTOFF22               = 10 # Variable c_int
IMAGE_SYM_CLASS_STRUCT_TAG           = win32con.IMAGE_SYM_CLASS_STRUCT_TAG # 10
IMAGE_DEBUG_TYPE_RESERVED10          = 10 # Variable c_int
IMAGE_REL_I386_SECTION               = win32con.IMAGE_REL_I386_SECTION # 10
IMAGE_SIZEOF_RELOCATION              = win32con.IMAGE_SIZEOF_RELOCATION # 10
IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG    = 10 # Variable c_int
IMAGE_REL_PPC_SECREL                 = 11 # Variable c_int
IMAGE_REL_SH3_PCREL12_WORD           = 11 # Variable c_int
IMAGE_SYM_TYPE_MOE                   = 11 # Variable c_int
IMAGE_REL_ALPHA_REFLO                = win32con.IMAGE_REL_ALPHA_REFLO # 11
IMAGE_REL_I386_SECREL                = win32con.IMAGE_REL_I386_SECREL # 11
IMAGE_REL_BASED_HIGH3ADJ             = 11 # Variable c_int
IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT   = 11 # Variable c_int
IMAGE_REL_IA64_SECTION               = 11 # Variable c_int
IMAGE_REL_MIPS_SECREL                = win32con.IMAGE_REL_MIPS_SECREL # 11
IMAGE_SYM_CLASS_MEMBER_OF_UNION      = win32con.IMAGE_SYM_CLASS_MEMBER_OF_UNION # 11
IMAGE_REL_IA64_SECREL22              = 12 # Variable c_int
IMAGE_REL_SH3_STARTOF_SECTION        = 12 # Variable c_int
IMAGE_REL_ALPHA_PAIR                 = win32con.IMAGE_REL_ALPHA_PAIR # 12
IMAGE_SYM_CLASS_UNION_TAG            = win32con.IMAGE_SYM_CLASS_UNION_TAG # 12
IMAGE_REL_MIPS_SECRELLO              = 12 # Variable c_int
IMAGE_REL_PPC_SECTION                = 12 # Variable c_int
IMAGE_SYM_TYPE_BYTE                  = 12 # Variable c_int
IMAGE_DIRECTORY_ENTRY_IAT            = 12 # Variable c_int
IMAGE_SYM_CLASS_TYPE_DEFINITION      = win32con.IMAGE_SYM_CLASS_TYPE_DEFINITION # 13
IMAGE_REL_PPC_IFGLUE                 = 13 # Variable c_int
IMAGE_REL_IA64_SECREL64I             = 13 # Variable c_int
IMAGE_SYM_TYPE_WORD                  = 13 # Variable c_int
IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT   = 13 # Variable c_int
IMAGE_REL_SH3_SIZEOF_SECTION         = 13 # Variable c_int
IMAGE_REL_ALPHA_MATCH                = win32con.IMAGE_REL_ALPHA_MATCH # 13
IMAGE_REL_MIPS_SECRELHI              = 13 # Variable c_int
IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR = 14 # Variable c_int
IMAGE_REL_SH3_SECTION                = 14 # Variable c_int
IMAGE_REL_ALPHA_SECTION              = win32con.IMAGE_REL_ALPHA_SECTION # 14
IMAGE_REL_ARM_SECTION                = 14 # Variable c_int
IMAGE_REL_IA64_SECREL32              = 14 # Variable c_int
IMAGE_REL_PPC_IMGLUE                 = 14 # Variable c_int
IMAGE_SYM_CLASS_UNDEFINED_STATIC     = win32con.IMAGE_SYM_CLASS_UNDEFINED_STATIC # 14
IMAGE_SYM_TYPE_UINT                  = 14 # Variable c_int
IMAGE_SYM_CLASS_ENUM_TAG             = win32con.IMAGE_SYM_CLASS_ENUM_TAG # 15
IMAGE_REL_IA64_LTOFF64               = 15 # Variable c_int
IMAGE_SYM_TYPE_DWORD                 = 15 # Variable c_int
IMAGE_REL_ARM_SECREL                 = 15 # Variable c_int
IMAGE_REL_SH3_SECREL                 = 15 # Variable c_int
IMAGE_REL_ALPHA_SECREL               = win32con.IMAGE_REL_ALPHA_SECREL # 15
IMAGE_REL_PPC_SECREL16               = 15 # Variable c_int
IMAGE_REL_IA64_DIR32NB               = 16 # Variable c_int
IMAGE_REL_SH3_DIRECT32_NB            = 16 # Variable c_int
IMAGE_FILE_AGGRESIVE_WS_TRIM         = 16 # Variable c_int
IMAGE_REL_PPC_REFHI                  = 16 # Variable c_int
IMAGE_REL_ALPHA_REFLONGNB            = win32con.IMAGE_REL_ALPHA_REFLONGNB # 16
IMAGE_SYM_CLASS_MEMBER_OF_ENUM       = win32con.IMAGE_SYM_CLASS_MEMBER_OF_ENUM # 16
IMAGE_NUMBEROF_DIRECTORY_ENTRIES     = win32con.IMAGE_NUMBEROF_DIRECTORY_ENTRIES # 16
IMAGE_REL_MIPS_JMPADDR16             = 16 # Variable c_int
IMAGE_REL_PPC_REFLO                  = 17 # Variable c_int
IMAGE_SYM_CLASS_REGISTER_PARAM       = win32con.IMAGE_SYM_CLASS_REGISTER_PARAM # 17
IMAGE_REL_ALPHA_SECRELLO             = 17 # Variable c_int
IMAGE_REL_IA64_RESERVED_11           = 17 # Variable c_int
IMAGE_SIZEOF_SYMBOL                  = win32con.IMAGE_SIZEOF_SYMBOL # 18
IMAGE_SYM_CLASS_BIT_FIELD            = win32con.IMAGE_SYM_CLASS_BIT_FIELD # 18
IMAGE_SIZEOF_AUX_SYMBOL              = win32con.IMAGE_SIZEOF_AUX_SYMBOL # 18
IMAGE_REL_ALPHA_SECRELHI             = 18 # Variable c_int
IMAGE_REL_IA64_RESERVED_12           = 18 # Variable c_int
IMAGE_REL_PPC_PAIR                   = 18 # Variable c_int
IMAGE_REL_PPC_SECRELLO               = 19 # Variable c_int
IMAGE_REL_ALPHA_REFQ3                = 19 # Variable c_int
IMAGE_REL_IA64_RESERVED_13           = 19 # Variable c_int
IMAGE_REL_I386_REL32                 = 20 # Variable c_int
IMAGE_REL_ALPHA_REFQ2                = 20 # Variable c_int
IMAGE_REL_IA64_RESERVED_14           = 20 # Variable c_int
IMAGE_SIZEOF_FILE_HEADER             = win32con.IMAGE_SIZEOF_FILE_HEADER # 20
IMAGE_REL_PPC_SECRELHI               = 20 # Variable c_int
IMAGE_REL_PPC_GPREL                  = 21 # Variable c_int
IMAGE_REL_ALPHA_REFQ1                = 21 # Variable c_int
IMAGE_REL_IA64_RESERVED_15           = 21 # Variable c_int
IMAGE_REL_ALPHA_GPRELLO              = 22 # Variable c_int
IMAGE_REL_IA64_RESERVED_16           = 22 # Variable c_int
IMAGE_REL_ALPHA_GPRELHI              = 23 # Variable c_int
IMAGE_SIZEOF_STD_OPTIONAL_HEADER     = win32con.IMAGE_SIZEOF_STD_OPTIONAL_HEADER # 28
IMAGE_REL_IA64_ADDEND                = 31 # Variable c_int
IMAGE_FILE_LARGE_ADDRESS_AWARE       = 32 # Variable c_int
IMAGE_SCN_CNT_CODE                   = 32 # Variable c_int
IMAGE_REL_MIPS_REFWORDNB             = win32con.IMAGE_REL_MIPS_REFWORDNB # 34
IMAGE_REL_MIPS_PAIR                  = win32con.IMAGE_REL_MIPS_PAIR # 37
IMAGE_SIZEOF_SECTION_HEADER          = win32con.IMAGE_SIZEOF_SECTION_HEADER # 40
IMAGE_SIZEOF_ROM_OPTIONAL_HEADER     = win32con.IMAGE_SIZEOF_ROM_OPTIONAL_HEADER # 56
IMAGE_SIZEOF_ARCHIVE_MEMBER_HDR      = win32con.IMAGE_SIZEOF_ARCHIVE_MEMBER_HDR # 60
IMAGE_SCN_CNT_INITIALIZED_DATA       = 64 # Variable c_int
IMAGE_SYM_CLASS_FAR_EXTERNAL         = 68 # Variable c_int
IMAGE_SYM_CLASS_BLOCK                = win32con.IMAGE_SYM_CLASS_BLOCK # 100
IMAGE_SYM_CLASS_FUNCTION             = win32con.IMAGE_SYM_CLASS_FUNCTION # 101
IMAGE_SYM_CLASS_END_OF_STRUCT        = win32con.IMAGE_SYM_CLASS_END_OF_STRUCT # 102
IMAGE_SYM_CLASS_FILE                 = win32con.IMAGE_SYM_CLASS_FILE # 103
IMAGE_SYM_CLASS_SECTION              = win32con.IMAGE_SYM_CLASS_SECTION # 104
IMAGE_SYM_CLASS_WEAK_EXTERNAL        = win32con.IMAGE_SYM_CLASS_WEAK_EXTERNAL # 105
IMAGE_FILE_BYTES_REVERSED_LO         = 128 # Variable c_int
IMAGE_SCN_CNT_UNINITIALIZED_DATA     = 128 # Variable c_int
IMAGE_SIZEOF_NT_OPTIONAL32_HEADER    = 224 # Variable c_int
IMAGE_SIZEOF_NT_OPTIONAL64_HEADER    = 240 # Variable c_int
IMAGE_REL_PPC_TYPEMASK               = 255 # Variable c_int
IMAGE_SYM_CLASS_END_OF_FUNCTION      = 255 # Variable c_ubyte
IMAGE_REL_PPC_NEG                    = 256 # Variable c_int
IMAGE_FILE_32BIT_MACHINE             = 256 # Variable c_int
IMAGE_SCN_LNK_OTHER                  = 256 # Variable c_int
IMAGE_ROM_OPTIONAL_HDR_MAGIC         = win32con.IMAGE_ROM_OPTIONAL_HDR_MAGIC # 263
IMAGE_NT_OPTIONAL_HDR32_MAGIC        = 267 # Variable c_int
IMAGE_FILE_MACHINE_I386              = 332 # Variable c_int
IMAGE_FILE_MACHINE_R3000             = 354 # Variable c_int
IMAGE_FILE_MACHINE_R4000             = 358 # Variable c_int
IMAGE_FILE_MACHINE_R10000            = 360 # Variable c_int
IMAGE_FILE_MACHINE_WCEMIPSV2         = 361 # Variable c_int
IMAGE_FILE_MACHINE_ALPHA             = 388 # Variable c_int
IMAGE_FILE_MACHINE_SH3               = 418 # Variable c_int
IMAGE_FILE_MACHINE_SH3E              = 420 # Variable c_int
IMAGE_FILE_MACHINE_SH4               = 422 # Variable c_int
IMAGE_FILE_MACHINE_ARM               = 448 # Variable c_int
IMAGE_FILE_MACHINE_THUMB             = 450 # Variable c_int
IMAGE_FILE_MACHINE_POWERPC           = 496 # Variable c_int
IMAGE_FILE_MACHINE_IA64              = 512 # Variable c_int
IMAGE_REL_PPC_BRTAKEN                = 512 # Variable c_int
IMAGE_SCN_LNK_INFO                   = 512 # Variable c_int
IMAGE_FILE_DEBUG_STRIPPED            = 512 # Variable c_int
IMAGE_NT_OPTIONAL_HDR64_MAGIC        = 523 # Variable c_int
IMAGE_FILE_MACHINE_MIPS16            = 614 # Variable c_int
IMAGE_FILE_MACHINE_ALPHA64           = 644 # Variable c_int
IMAGE_FILE_MACHINE_MIPSFPU           = 870 # Variable c_int
IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP   = 1024 # Variable c_int
IMAGE_REL_PPC_BRNTAKEN               = 1024 # Variable c_int
IMAGE_FILE_MACHINE_MIPSFPU16         = 1126 # Variable c_int
IMAGE_FILE_NET_RUN_FROM_SWAP         = 2048 # Variable c_int
IMAGE_SCN_LNK_REMOVE                 = 2048 # Variable c_int
IMAGE_REL_PPC_TOCDEFN                = 2048 # Variable c_int
IMAGE_SCN_LNK_COMDAT                 = 4096 # Variable c_int
IMAGE_FILE_SYSTEM                    = 4096 # Variable c_int
IMAGE_DLLCHARACTERISTICS_WDM_DRIVER  = 8192 # Variable c_int
IMAGE_FILE_DLL                       = 8192 # Variable c_int
IMAGE_FILE_UP_SYSTEM_ONLY            = 16384 # Variable c_int
IMAGE_SCN_NO_DEFER_SPEC_EXC          = 16384 # Variable c_int
IMAGE_OS2_SIGNATURE_LE               = 17740 # Variable c_int
IMAGE_VXD_SIGNATURE                  = 17740 # Variable c_int
IMAGE_OS2_SIGNATURE                  = 17742 # Variable c_int
IMAGE_NT_SIGNATURE                   = 17744 # Variable c_int
IMAGE_SEPARATE_DEBUG_SIGNATURE       = win32con.IMAGE_SEPARATE_DEBUG_SIGNATURE # 18756
IMAGE_DOS_SIGNATURE                  = 23117 # Variable c_int
IMAGE_SEPARATE_DEBUG_FLAGS_MASK      = 32768 # Variable c_int
IMAGE_SCN_MEM_FARDATA                = 32768 # Variable c_int
IMAGE_SEPARATE_DEBUG_MISMATCH        = 32768 # Variable c_int
IMAGE_SYM_TYPE_PCODE                 = 32768 # Variable c_int
IMAGE_SCN_GPREL                      = 32768 # Variable c_int
IMAGE_FILE_BYTES_REVERSED_HI         = 32768 # Variable c_int
IMAGE_SCN_MEM_16BIT                  = 131072 # Variable c_int
IMAGE_SCN_MEM_PURGEABLE              = 131072 # Variable c_int
IMAGE_SCN_MEM_LOCKED                 = 262144 # Variable c_int
IMAGE_SCN_MEM_PRELOAD                = 524288 # Variable c_int
IMAGE_SCN_ALIGN_1BYTES               = 1048576 # Variable c_int
IMAGE_SCN_ALIGN_2BYTES               = 2097152 # Variable c_int
IMAGE_SCN_ALIGN_4BYTES               = 3145728 # Variable c_int
IMAGE_SCN_ALIGN_8BYTES               = 4194304 # Variable c_int
IMAGE_SCN_ALIGN_16BYTES              = 5242880 # Variable c_int
IMAGE_SCN_ALIGN_32BYTES              = 6291456 # Variable c_int
IMAGE_SCN_ALIGN_64BYTES              = 7340032 # Variable c_int
IMAGE_SCN_ALIGN_128BYTES             = 8388608 # Variable c_int
IMAGE_SCN_ALIGN_256BYTES             = 9437184 # Variable c_int
IMAGE_SCN_ALIGN_512BYTES             = 10485760 # Variable c_int
IMAGE_SCN_ALIGN_1024BYTES            = 11534336 # Variable c_int
IMAGE_SCN_ALIGN_2048BYTES            = 12582912 # Variable c_int
IMAGE_SCN_ALIGN_4096BYTES            = 13631488 # Variable c_int
IMAGE_SCN_ALIGN_8192BYTES            = 14680064 # Variable c_int
IMAGE_SCN_LNK_NRELOC_OVFL            = 16777216 # Variable c_int
IMAGE_SCN_MEM_DISCARDABLE            = 33554432 # Variable c_int
IMAGE_SCN_MEM_NOT_CACHED             = 67108864 # Variable c_int
IMAGE_SCN_MEM_NOT_PAGED              = 134217728 # Variable c_int
IMAGE_SCN_MEM_SHARED                 = 268435456 # Variable c_int
IMAGE_SCN_MEM_EXECUTE                = 536870912 # Variable c_int
IMAGE_SCN_MEM_READ                   = 1073741824 # Variable c_int
IMAGE_ORDINAL_FLAG32                 = 2147483648 # Variable c_uint
IMAGE_RESOURCE_DATA_IS_DIRECTORY     = win32con.IMAGE_RESOURCE_DATA_IS_DIRECTORY # -2147483648
IMAGE_SCN_MEM_WRITE                  = 2147483648 # Variable c_uint
IMAGE_RESOURCE_NAME_IS_STRING        = win32con.IMAGE_RESOURCE_NAME_IS_STRING # -2147483648
IMAGE_ARCHIVE_START                  = win32con.IMAGE_ARCHIVE_START # !<arch>

IMAGE_ARCHIVE_LINKER_MEMBER          = win32con.IMAGE_ARCHIVE_LINKER_MEMBER # /
IMAGE_ARCHIVE_LONGNAMES_MEMBER       = win32con.IMAGE_ARCHIVE_LONGNAMES_MEMBER # //
IMAGE_ARCHIVE_PAD                    = win32con.IMAGE_ARCHIVE_PAD #

IMAGE_ARCHIVE_END                    = win32con.IMAGE_ARCHIVE_END # `

IMAGE_SYM_ABSOLUTE                   = -1 # Variable c_short
IMAGE_SYM_DEBUG                      = -2 # Variable c_short

IMC_GETCANDIDATEPOS      = win32con.IMC_GETCANDIDATEPOS # 7
IMC_SETCANDIDATEPOS      = win32con.IMC_SETCANDIDATEPOS # 8
IMC_GETCOMPOSITIONFONT   = win32con.IMC_GETCOMPOSITIONFONT # 9
IMC_SETCOMPOSITIONFONT   = win32con.IMC_SETCOMPOSITIONFONT # 10
IMC_GETCOMPOSITIONWINDOW = win32con.IMC_GETCOMPOSITIONWINDOW # 11
IMC_SETCOMPOSITIONWINDOW = win32con.IMC_SETCOMPOSITIONWINDOW # 12
IMC_GETSTATUSWINDOWPOS   = win32con.IMC_GETSTATUSWINDOWPOS # 15
IMC_SETSTATUSWINDOWPOS   = win32con.IMC_SETSTATUSWINDOWPOS # 16
IMC_CLOSESTATUSWINDOW    = win32con.IMC_CLOSESTATUSWINDOW # 33
IMC_OPENSTATUSWINDOW     = win32con.IMC_OPENSTATUSWINDOW # 34

IMEVER_0310 = 196618 # Variable c_int
IMEVER_0400 = 262144 # Variable c_int

IME_CMODE_ALPHANUMERIC            = 0 # Variable c_int
IME_SMODE_NONE                    = 0 # Variable c_int
IME_CAND_UNKNOWN                  = 0 # Variable c_int
IME_CONFIG_GENERAL                = 1 # Variable c_int
IME_SMODE_PLAURALCLAUSE           = 1 # Variable c_int
IME_REGWORD_STYLE_EUDC            = 1 # Variable c_int
IME_CMODE_NATIVE                  = 1 # Variable c_int
IME_CAND_READ                     = 1 # Variable c_int
IME_CAND_CODE                     = 2 # Variable c_int
IME_SMODE_SINGLECONVERT           = 2 # Variable c_int
IME_CMODE_KATAKANA                = 2 # Variable c_int
IME_CONFIG_REGISTERWORD           = 2 # Variable c_int
IME_CONFIG_SELECTDICTIONARY       = 3 # Variable c_int
IME_CAND_MEANING                  = 3 # Variable c_int
IME_ESC_QUERY_SUPPORT             = 3 # Variable c_int
IME_CMODE_LANGUAGE                = 3 # Variable c_int
IME_CAND_RADICAL                  = 4 # Variable c_int
IME_ESC_RESERVED_FIRST            = 4 # Variable c_int
IME_SMODE_AUTOMATIC               = 4 # Variable c_int
IME_CAND_STROKE                   = 5 # Variable c_int
IME_SMODE_PHRASEPREDICT           = 8 # Variable c_int
IME_CMODE_FULLSHAPE               = 8 # Variable c_int
IME_CMODE_ROMAN                   = 16 # Variable c_int
IME_SMODE_CONVERSATION            = 16 # Variable c_int
IME_CHOTKEY_IME_NONIME_TOGGLE     = 16 # Variable c_int
IME_CHOTKEY_SHAPE_TOGGLE          = 17 # Variable c_int
IME_CHOTKEY_SYMBOL_TOGGLE         = 18 # Variable c_int
IME_CMODE_CHARCODE                = 32 # Variable c_int
IME_JHOTKEY_CLOSE_OPEN            = 48 # Variable c_int
IME_CMODE_HANJACONVERT            = 64 # Variable c_int
IME_KHOTKEY_SHAPE_TOGGLE          = 80 # Variable c_int
IME_KHOTKEY_HANJACONVERT          = 81 # Variable c_int
IME_KHOTKEY_ENGLISH               = 82 # Variable c_int
IME_THOTKEY_IME_NONIME_TOGGLE     = 112 # Variable c_int
IME_THOTKEY_SHAPE_TOGGLE          = 113 # Variable c_int
IME_THOTKEY_SYMBOL_TOGGLE         = 114 # Variable c_int
IME_CMODE_SOFTKBD                 = 128 # Variable c_int
IME_HOTKEY_DSWITCH_FIRST          = 256 # Variable c_int
IME_CMODE_NOCONVERSION            = 256 # Variable c_int
IME_HOTKEY_DSWITCH_LAST           = 287 # Variable c_int
IME_ITHOTKEY_RESEND_RESULTSTR     = 512 # Variable c_int
IME_CMODE_EUDC                    = 512 # Variable c_int
IME_HOTKEY_PRIVATE_FIRST          = 512 # Variable c_int
IME_ITHOTKEY_PREVIOUS_COMPOSITION = 513 # Variable c_int
IME_ITHOTKEY_UISTYLE_TOGGLE       = 514 # Variable c_int
IME_ITHOTKEY_RECONVERTSTRING      = 515 # Variable c_int
IME_HOTKEY_PRIVATE_LAST           = 543 # Variable c_int
IME_CMODE_SYMBOL                  = 1024 # Variable c_int
IME_ESC_RESERVED_LAST             = 2047 # Variable c_int
IME_ESC_PRIVATE_FIRST             = 2048 # Variable c_int
IME_CMODE_FIXED                   = 2048 # Variable c_int
IME_ESC_PRIVATE_LAST              = 4095 # Variable c_int
IME_ESC_SEQUENCE_TO_INTERNAL      = 4097 # Variable c_int
IME_ESC_GET_EUDC_DICTIONARY       = 4099 # Variable c_int
IME_ESC_SET_EUDC_DICTIONARY       = 4100 # Variable c_int
IME_ESC_MAX_KEY                   = 4101 # Variable c_int
IME_ESC_IME_NAME                  = 4102 # Variable c_int
IME_ESC_SYNC_HOTKEY               = 4103 # Variable c_int
IME_ESC_HANJA_MODE                = 4104 # Variable c_int
IME_ESC_AUTOMATA                  = 4105 # Variable c_int
IME_ESC_PRIVATE_HOTKEY            = 4106 # Variable c_int
IME_ESC_GETHELPFILENAME           = 4107 # Variable c_int
IME_PROP_AT_CARET                 = 65536 # Variable c_int
IME_PROP_SPECIAL_UI               = 131072 # Variable c_int
IME_PROP_CANDLIST_START_FROM_1    = 262144 # Variable c_int
IME_PROP_UNICODE                  = 524288 # Variable c_int
IME_PROP_COMPLETE_ON_UNSELECT     = 1048576 # Variable c_int
IME_REGWORD_STYLE_USER_FIRST      = 2147483648 # Variable c_uint
IME_REGWORD_STYLE_USER_LAST       = 4294967295 # Variable c_uint

IMM_ERROR_NODATA  = -1 # Variable c_int
IMM_ERROR_GENERAL = -2 # Variable c_int

IMN_CLOSESTATUSWINDOW    = win32con.IMN_CLOSESTATUSWINDOW # 1
IMN_OPENSTATUSWINDOW     = win32con.IMN_OPENSTATUSWINDOW # 2
IMN_CHANGECANDIDATE      = win32con.IMN_CHANGECANDIDATE # 3
IMN_CLOSECANDIDATE       = win32con.IMN_CLOSECANDIDATE # 4
IMN_OPENCANDIDATE        = win32con.IMN_OPENCANDIDATE # 5
IMN_SETCONVERSIONMODE    = win32con.IMN_SETCONVERSIONMODE # 6
IMN_SETSENTENCEMODE      = win32con.IMN_SETSENTENCEMODE # 7
IMN_SETOPENSTATUS        = win32con.IMN_SETOPENSTATUS # 8
IMN_SETCANDIDATEPOS      = win32con.IMN_SETCANDIDATEPOS # 9
IMN_SETCOMPOSITIONFONT   = win32con.IMN_SETCOMPOSITIONFONT # 10
IMN_SETCOMPOSITIONWINDOW = win32con.IMN_SETCOMPOSITIONWINDOW # 11
IMN_SETSTATUSWINDOWPOS   = win32con.IMN_SETSTATUSWINDOWPOS # 12
IMN_GUIDELINE            = win32con.IMN_GUIDELINE # 13
IMN_PRIVATE              = win32con.IMN_PRIVATE # 14

IMPLINK_IP        = 155 # Variable c_int
IMPLINK_LOWEXPER  = 156 # Variable c_int
IMPLINK_HIGHEXPER = 158 # Variable c_int

IMPLTYPEFLAG_FDEFAULT       = 1 # Variable c_int
IMPLTYPEFLAG_FSOURCE        = 2 # Variable c_int
IMPLTYPEFLAG_FRESTRICTED    = 4 # Variable c_int
IMPLTYPEFLAG_FDEFAULTVTABLE = 8 # Variable c_int

IMPORT_OBJECT_CODE            = 0
IMPORT_OBJECT_ORDINAL         = 0
IMPORT_OBJECT_DATA            = 1
IMPORT_OBJECT_NAME            = 1
IMPORT_OBJECT_CONST           = 2
IMPORT_OBJECT_NAME_NO_PREFIX  = 2
IMPORT_OBJECT_NAME_UNDECORATE = 3
IMPORT_OBJECT_HDR_SIG2        = 65535 # Variable c_int
IMPORT_OBJECT_TYPE            = c_int # enum
IMPORT_OBJECT_NAME_TYPE       = c_int # enum

INADDR_ANY       = 0 # Variable c_ulong
INADDR_LOOPBACK  = 2130706433 # Variable c_int
INADDR_NONE      = 4294967295 # Variable c_uint
INADDR_BROADCAST = 4294967295 # Variable c_ulong

INET_E_CANNOT_LOCK_REQUEST         = -2146697194 # Variable c_long
INET_E_REDIRECT_TO_DIR             = -2146697195 # Variable c_long
INET_E_REDIRECTING                 = -2146697196 # Variable c_long
INET_E_REDIRECT_FAILED             = -2146697196 # Variable c_long
INET_E_QUERYOPTION_UNKNOWN         = -2146697197 # Variable c_long
INET_E_USE_DEFAULT_SETTING         = -2146697198 # Variable c_long
INET_E_USE_DEFAULT_PROTOCOLHANDLER = -2146697199 # Variable c_long
INET_E_CANNOT_INSTANTIATE_OBJECT   = -2146697200 # Variable c_long
INET_E_CANNOT_LOAD_DATA            = -2146697201 # Variable c_long
INET_E_SECURITY_PROBLEM            = -2146697202 # Variable c_long
INET_E_UNKNOWN_PROTOCOL            = -2146697203 # Variable c_long
INET_E_INVALID_REQUEST             = -2146697204 # Variable c_long
INET_E_CONNECTION_TIMEOUT          = -2146697205 # Variable c_long
INET_E_NO_VALID_MEDIA              = -2146697206 # Variable c_long
INET_E_AUTHENTICATION_REQUIRED     = -2146697207 # Variable c_long
INET_E_DOWNLOAD_FAILURE            = -2146697208 # Variable c_long
INET_E_DATA_NOT_AVAILABLE          = -2146697209 # Variable c_long
INET_E_OBJECT_NOT_FOUND            = -2146697210 # Variable c_long
INET_E_RESOURCE_NOT_FOUND          = -2146697211 # Variable c_long
INET_E_CANNOT_CONNECT              = -2146697212 # Variable c_long
INET_E_NO_SESSION                  = -2146697213 # Variable c_long
INET_E_ERROR_FIRST                 = -2146697214 # Variable c_long
INET_E_INVALID_URL                 = -2146697214 # Variable c_long

INHERITED_ACE = 16 # Variable c_int

INHERIT_ONLY_ACE = win32con.INHERIT_ONLY_ACE # 8

INPLACE_S_TRUNCATED   = 262560 # Variable c_long
INPLACE_S_FIRST       = 262560 # Variable c_long
INPLACE_S_LAST        = 262575 # Variable c_long
INPLACE_E_FIRST       = 2147746208 # Variable c_ulong
INPLACE_E_LAST        = 2147746223 # Variable c_ulong
INPLACE_E_NOTOOLSPACE = -2147221087 # Variable c_long
INPLACE_E_NOTUNDOABLE = -2147221088 # Variable c_long

INPUT_MOUSE    = win32con.INPUT_MOUSE # 0
INPUT_KEYBOARD = win32con.INPUT_KEYBOARD # 1
INPUT_HARDWARE = win32con.INPUT_HARDWARE # 2

INVALID_ATOM         = 0 # Variable c_ushort
INVALID_SOCKET       = 4294967295 # Variable c_uint
INVALID_FILE_SIZE    = 4294967295 # Variable c_ulong
INVALID_HANDLE_VALUE = 4294967295 # Variable c_void_p

INVOKE_FUNC           = 1
INVOKE_PROPERTYGET    = 2
INVOKE_PROPERTYPUT    = 4
INVOKE_PROPERTYPUTREF = 8

IN_CLASSC_NSHIFT = 8 # Variable c_int
IN_CLASSB_NSHIFT = 16 # Variable c_int
IN_CLASSA_NSHIFT = 24 # Variable c_int
IN_CLASSA_MAX    = 128 # Variable c_int
IN_CLASSC_HOST   = 255 # Variable c_int
IN_CLASSB_HOST   = 65535 # Variable c_int
IN_CLASSB_MAX    = 65536 # Variable c_int
IN_CLASSA_HOST   = 16777215 # Variable c_int
IN_CLASSA_NET    = 4278190080 # Variable c_uint
IN_CLASSB_NET    = 4294901760 # Variable c_uint
IN_CLASSC_NET    = 4294967040 # Variable c_uint

IOCPARM_MASK = 127 # Variable c_int

IOC_VOID  = 536870912 # Variable c_int
IOC_OUT   = 1073741824 # Variable c_int
IOC_IN    = 2147483648 # Variable c_uint
IOC_INOUT = 3221225472 # Variable c_uint

IO_REPARSE_TAG_RESERVED_ZERO = 0 # Variable c_int
IO_REPARSE_TAG_RESERVED_ONE  = 1 # Variable c_int
IO_COMPLETION_MODIFY_STATE   = win32con.IO_COMPLETION_MODIFY_STATE # 2
IO_COMPLETION_ALL_ACCESS     = 2031619 # Variable c_long
IO_REPARSE_TAG_NSS           = 2147483653 # Variable c_uint
IO_REPARSE_TAG_NSSRECOVER    = 2147483654 # Variable c_uint
IO_REPARSE_TAG_SIS           = 2147483655 # Variable c_uint
IO_REPARSE_TAG_DFS           = 2147483656 # Variable c_uint
IO_REPARSE_TAG_MOUNT_POINT   = 2684354563 # Variable c_uint
IO_REPARSE_TAG_HSM           = 3221225476 # Variable c_uint
IO_REPARSE_TAG_VALID_VALUES  = 3758161919 # Variable c_uint

IPM_CLEARADDRESS = 1124 # Variable c_int
IPM_SETADDRESS   = 1125 # Variable c_int
IPM_GETADDRESS   = 1126 # Variable c_int
IPM_SETRANGE     = 1127 # Variable c_int
IPM_SETFOCUS     = 1128 # Variable c_int
IPM_ISBLANK      = 1129 # Variable c_int

IPN_LAST         = 4294966417 # Variable c_uint
IPN_FIRST        = 4294966436 # Variable c_uint
IPN_FIELDCHANGED = 4294966436 # Variable c_uint

IPPORT_ECHO        = 7 # Variable c_int
IPPORT_DISCARD     = 9 # Variable c_int
IPPORT_SYSTAT      = 11 # Variable c_int
IPPORT_DAYTIME     = 13 # Variable c_int
IPPORT_NETSTAT     = 15 # Variable c_int
IPPORT_FTP         = 21 # Variable c_int
IPPORT_TELNET      = 23 # Variable c_int
IPPORT_SMTP        = 25 # Variable c_int
IPPORT_TIMESERVER  = 37 # Variable c_int
IPPORT_NAMESERVER  = 42 # Variable c_int
IPPORT_WHOIS       = 43 # Variable c_int
IPPORT_MTP         = 57 # Variable c_int
IPPORT_TFTP        = 69 # Variable c_int
IPPORT_RJE         = 77 # Variable c_int
IPPORT_FINGER      = 79 # Variable c_int
IPPORT_TTYLINK     = 87 # Variable c_int
IPPORT_SUPDUP      = 95 # Variable c_int
IPPORT_EXECSERVER  = 512 # Variable c_int
IPPORT_BIFFUDP     = 512 # Variable c_int
IPPORT_LOGINSERVER = 513 # Variable c_int
IPPORT_WHOSERVER   = 513 # Variable c_int
IPPORT_CMDSERVER   = 514 # Variable c_int
IPPORT_ROUTESERVER = 520 # Variable c_int
IPPORT_EFSSERVER   = 520 # Variable c_int
IPPORT_RESERVED    = 1024 # Variable c_int

IPPROTO_IP   = 0 # Variable c_int
IPPROTO_ICMP = 1 # Variable c_int
IPPROTO_IGMP = 2 # Variable c_int
IPPROTO_GGP  = 3 # Variable c_int
IPPROTO_TCP  = 6 # Variable c_int
IPPROTO_PUP  = 12 # Variable c_int
IPPROTO_UDP  = 17 # Variable c_int
IPPROTO_IDP  = 22 # Variable c_int
IPPROTO_ND   = 77 # Variable c_int
IPPROTO_RAW  = 255 # Variable c_int
IPPROTO_MAX  = 256 # Variable c_int

IP_OPTIONS                = 1 # Variable c_int
IP_DEFAULT_MULTICAST_LOOP = 1 # Variable c_int
IP_DEFAULT_MULTICAST_TTL  = 1 # Variable c_int
IP_MULTICAST_IF           = 2 # Variable c_int
IP_MULTICAST_TTL          = 3 # Variable c_int
IP_MULTICAST_LOOP         = 4 # Variable c_int
IP_ADD_MEMBERSHIP         = 5 # Variable c_int
IP_DROP_MEMBERSHIP        = 6 # Variable c_int
IP_TTL                    = 7 # Variable c_int
IP_TOS                    = 8 # Variable c_int
IP_DONTFRAGMENT           = 9 # Variable c_int
IP_MAX_MEMBERSHIPS        = 20 # Variable c_int

ISC_SHOWUICANDIDATEWINDOW    = 1 # Variable c_int
ISC_SHOWUIALLCANDIDATEWINDOW = 15 # Variable c_int
ISC_SHOWUIGUIDELINE          = 1073741824 # Variable c_int
ISC_SHOWUICOMPOSITIONWINDOW  = 2147483648 # Variable c_uint
ISC_SHOWUIALL                = 3221225487 # Variable c_uint

IS_TEXT_UNICODE_ASCII16            = win32con.IS_TEXT_UNICODE_ASCII16 # 1
IS_TEXT_UNICODE_STATISTICS         = win32con.IS_TEXT_UNICODE_STATISTICS # 2
IS_TEXT_UNICODE_CONTROLS           = win32con.IS_TEXT_UNICODE_CONTROLS # 4
IS_TEXT_UNICODE_SIGNATURE          = win32con.IS_TEXT_UNICODE_SIGNATURE # 8
IS_TEXT_UNICODE_UNICODE_MASK       = win32con.IS_TEXT_UNICODE_UNICODE_MASK # 15
IS_TEXT_UNICODE_REVERSE_ASCII16    = win32con.IS_TEXT_UNICODE_REVERSE_ASCII16 # 16
IS_TEXT_UNICODE_REVERSE_STATISTICS = win32con.IS_TEXT_UNICODE_REVERSE_STATISTICS # 32
IS_TEXT_UNICODE_REVERSE_CONTROLS   = win32con.IS_TEXT_UNICODE_REVERSE_CONTROLS # 64
IS_TEXT_UNICODE_REVERSE_SIGNATURE  = win32con.IS_TEXT_UNICODE_REVERSE_SIGNATURE # 128
IS_TEXT_UNICODE_REVERSE_MASK       = win32con.IS_TEXT_UNICODE_REVERSE_MASK # 240
IS_TEXT_UNICODE_ILLEGAL_CHARS      = win32con.IS_TEXT_UNICODE_ILLEGAL_CHARS # 256
IS_TEXT_UNICODE_ODD_LENGTH         = win32con.IS_TEXT_UNICODE_ODD_LENGTH # 512
IS_TEXT_UNICODE_DBCS_LEADBYTE      = win32con.IS_TEXT_UNICODE_DBCS_LEADBYTE # 1024
IS_TEXT_UNICODE_NOT_UNICODE_MASK   = win32con.IS_TEXT_UNICODE_NOT_UNICODE_MASK # 3840
IS_TEXT_UNICODE_NULL_BYTES         = win32con.IS_TEXT_UNICODE_NULL_BYTES # 4096
IS_TEXT_UNICODE_NOT_ASCII_MASK     = win32con.IS_TEXT_UNICODE_NOT_ASCII_MASK # 61440

ITALIC_FONTTYPE = win32con.ITALIC_FONTTYPE # 512

I_INDENTCALLBACK   = -1 # Variable c_int
I_IMAGECALLBACK    = -1 # Variable c_int
I_CHILDRENCALLBACK = -1 # Variable c_int

JOB_NOTIFY_FIELD_PRINTER_NAME        = 0 # Variable c_int
JOB_OBJECT_TERMINATE_AT_END_OF_JOB   = 0 # Variable c_int
JOB_POSITION_UNSPECIFIED             = 0 # Variable c_int
JOB_OBJECT_UILIMIT_NONE              = 0 # Variable c_int
JOB_OBJECT_UILIMIT_HANDLES           = 1 # Variable c_int
JOB_OBJECT_MSG_END_OF_JOB_TIME       = 1 # Variable c_int
JOB_OBJECT_SECURITY_NO_ADMIN         = 1 # Variable c_int
JOB_NOTIFY_TYPE                      = 1 # Variable c_int
JOB_OBJECT_POST_AT_END_OF_JOB        = 1 # Variable c_int
JOB_OBJECT_LIMIT_WORKINGSET          = 1 # Variable c_int
JOB_STATUS_PAUSED                    = 1 # Variable c_int
JOB_NOTIFY_FIELD_MACHINE_NAME        = 1 # Variable c_int
JOB_OBJECT_ASSIGN_PROCESS            = 1 # Variable c_int
JOB_CONTROL_PAUSE                    = 1 # Variable c_int
JOB_CONTROL_RESUME                   = 2 # Variable c_int
JOB_OBJECT_SET_ATTRIBUTES            = 2 # Variable c_int
JOB_NOTIFY_FIELD_PORT_NAME           = 2 # Variable c_int
JOB_OBJECT_UILIMIT_READCLIPBOARD     = 2 # Variable c_int
JOB_STATUS_ERROR                     = 2 # Variable c_int
JOB_OBJECT_LIMIT_PROCESS_TIME        = 2 # Variable c_int
JOB_OBJECT_SECURITY_RESTRICTED_TOKEN = 2 # Variable c_int
JOB_OBJECT_MSG_END_OF_PROCESS_TIME   = 2 # Variable c_int
JOB_OBJECT_MSG_ACTIVE_PROCESS_LIMIT  = 3 # Variable c_int
JOB_NOTIFY_FIELD_USER_NAME           = 3 # Variable c_int
JOB_CONTROL_CANCEL                   = 3 # Variable c_int
JOB_CONTROL_RESTART                  = 4 # Variable c_int
JOB_OBJECT_UILIMIT_WRITECLIPBOARD    = 4 # Variable c_int
JOB_STATUS_DELETING                  = 4 # Variable c_int
JOB_OBJECT_LIMIT_JOB_TIME            = 4 # Variable c_int
JOB_NOTIFY_FIELD_NOTIFY_NAME         = 4 # Variable c_int
JOB_OBJECT_MSG_ACTIVE_PROCESS_ZERO   = 4 # Variable c_int
JOB_OBJECT_QUERY                     = 4 # Variable c_int
JOB_OBJECT_SECURITY_ONLY_TOKEN       = 4 # Variable c_int
JOB_NOTIFY_FIELD_DATATYPE            = 5 # Variable c_int
JOB_CONTROL_DELETE                   = 5 # Variable c_int
JOB_NOTIFY_FIELD_PRINT_PROCESSOR     = 6 # Variable c_int
JOB_CONTROL_SENT_TO_PRINTER          = 6 # Variable c_int
JOB_NOTIFY_FIELD_PARAMETERS          = 7 # Variable c_int
JOB_CONTROL_LAST_PAGE_EJECTED        = 7 # Variable c_int
JOB_STATUS_SPOOLING                  = 8 # Variable c_int
JOB_NOTIFY_FIELD_DRIVER_NAME         = 8 # Variable c_int
JOB_OBJECT_SECURITY_FILTER_TOKENS    = 8 # Variable c_int
JOB_OBJECT_LIMIT_ACTIVE_PROCESS      = 8 # Variable c_int
JOB_OBJECT_TERMINATE                 = 8 # Variable c_int
JOB_OBJECT_UILIMIT_SYSTEMPARAMETERS  = 8 # Variable c_int
JOB_NOTIFY_FIELD_DEVMODE             = 9 # Variable c_int
JOB_NOTIFY_FIELD_STATUS              = 10 # Variable c_int
JOB_NOTIFY_FIELD_STATUS_STRING       = 11 # Variable c_int
JOB_NOTIFY_FIELD_SECURITY_DESCRIPTOR = 12 # Variable c_int
JOB_NOTIFY_FIELD_DOCUMENT            = 13 # Variable c_int
JOB_NOTIFY_FIELD_PRIORITY            = 14 # Variable c_int
JOB_NOTIFY_FIELD_POSITION            = 15 # Variable c_int
JOB_OBJECT_SECURITY_VALID_FLAGS      = 15 # Variable c_int
JOB_ACCESS_ADMINISTER                = 16 # Variable c_int
JOB_STATUS_PRINTING                  = 16 # Variable c_int
JOB_OBJECT_UILIMIT_DISPLAYSETTINGS   = 16 # Variable c_int
JOB_OBJECT_SET_SECURITY_ATTRIBUTES   = 16 # Variable c_int
JOB_OBJECT_LIMIT_AFFINITY            = 16 # Variable c_int
JOB_NOTIFY_FIELD_SUBMITTED           = 16 # Variable c_int
JOB_NOTIFY_FIELD_START_TIME          = 17 # Variable c_int
JOB_NOTIFY_FIELD_UNTIL_TIME          = 18 # Variable c_int
JOB_NOTIFY_FIELD_TIME                = 19 # Variable c_int
JOB_NOTIFY_FIELD_TOTAL_PAGES         = 20 # Variable c_int
JOB_NOTIFY_FIELD_PAGES_PRINTED       = 21 # Variable c_int
JOB_NOTIFY_FIELD_TOTAL_BYTES         = 22 # Variable c_int
JOB_NOTIFY_FIELD_BYTES_PRINTED       = 23 # Variable c_int
JOB_OBJECT_LIMIT_PRIORITY_CLASS      = 32 # Variable c_int
JOB_OBJECT_UILIMIT_GLOBALATOMS       = 32 # Variable c_int
JOB_STATUS_OFFLINE                   = 32 # Variable c_int
JOB_OBJECT_LIMIT_PRESERVE_JOB_TIME   = 64 # Variable c_int
JOB_OBJECT_UILIMIT_DESKTOP           = 64 # Variable c_int
JOB_STATUS_PAPEROUT                  = 64 # Variable c_int
JOB_OBJECT_LIMIT_VALID_FLAGS         = 127 # Variable c_int
JOB_STATUS_PRINTED                   = 128 # Variable c_int
JOB_OBJECT_UILIMIT_EXITWINDOWS       = 128 # Variable c_int
JOB_OBJECT_UILIMIT_ALL               = 255 # Variable c_int
JOB_OBJECT_UI_VALID_FLAGS            = 255 # Variable c_int
JOB_STATUS_DELETED                   = 256 # Variable c_int
JOB_STATUS_BLOCKED_DEVQ              = 512 # Variable c_int
JOB_STATUS_USER_INTERVENTION         = 1024 # Variable c_int
JOB_STATUS_RESTART                   = 2048 # Variable c_int
JOB_EXECUTE                          = 131088 # Variable c_long
JOB_READ                             = 131088 # Variable c_long
JOB_WRITE                            = 131088 # Variable c_long
JOB_ALL_ACCESS                       = 983056 # Variable c_long
JOB_OBJECT_ALL_ACCESS                = 2031647 # Variable c_long

JOHAB_CHARSET = win32con.JOHAB_CHARSET # 130

JOYCAPS_HASZ    = 1 # Variable c_int
JOYCAPS_HASR    = 2 # Variable c_int
JOYCAPS_HASU    = 4 # Variable c_int
JOYCAPS_HASV    = 8 # Variable c_int
JOYCAPS_HASPOV  = 16 # Variable c_int
JOYCAPS_POV4DIR = 32 # Variable c_int
JOYCAPS_POVCTS  = 64 # Variable c_int

JOYERR_NOERROR   = 0 # Variable c_int
JOYERR_BASE      = 160 # Variable c_int
JOYERR_PARMS     = 165 # Variable c_int
JOYERR_NOCANDO   = 166 # Variable c_int
JOYERR_UNPLUGGED = 167 # Variable c_int

JOY_POVFORWARD     = 0 # Variable c_int
JOY_BUTTON1        = 1 # Variable c_int
JOY_RETURNX        = 1 # Variable c_long
JOY_BUTTON2        = 2 # Variable c_int
JOY_RETURNY        = 2 # Variable c_long
JOY_BUTTON3        = 4 # Variable c_int
JOY_RETURNZ        = 4 # Variable c_long
JOY_BUTTON4        = 8 # Variable c_int
JOY_RETURNR        = 8 # Variable c_long
JOY_RETURNU        = 16 # Variable c_long
JOY_BUTTON5        = 16 # Variable c_long
JOY_BUTTON6        = 32 # Variable c_long
JOY_RETURNV        = 32 # Variable c_long
JOY_BUTTON7        = 64 # Variable c_long
JOY_RETURNPOV      = 64 # Variable c_long
JOY_RETURNBUTTONS  = 128 # Variable c_long
JOY_BUTTON8        = 128 # Variable c_long
JOY_RETURNALL      = 255 # Variable c_long
JOY_BUTTON1CHG     = 256 # Variable c_int
JOY_BUTTON9        = 256 # Variable c_long
JOY_RETURNRAWDATA  = 256 # Variable c_long
JOY_BUTTON2CHG     = 512 # Variable c_int
JOY_BUTTON10       = 512 # Variable c_long
JOY_RETURNPOVCTS   = 512 # Variable c_long
JOY_BUTTON3CHG     = 1024 # Variable c_int
JOY_BUTTON11       = 1024 # Variable c_long
JOY_RETURNCENTERED = 1024 # Variable c_long
JOY_BUTTON4CHG     = 2048 # Variable c_int
JOY_USEDEADZONE    = 2048 # Variable c_long
JOY_BUTTON12       = 2048 # Variable c_long
JOY_BUTTON13       = 4096 # Variable c_long
JOY_BUTTON14       = 8192 # Variable c_long
JOY_POVRIGHT       = 9000 # Variable c_int
JOY_BUTTON15       = 16384 # Variable c_long
JOY_POVBACKWARD    = 18000 # Variable c_int
JOY_POVLEFT        = 27000 # Variable c_int
JOY_BUTTON16       = 32768 # Variable c_long
JOY_POVCENTERED    = 65535 # Variable c_ushort
JOY_BUTTON17       = 65536 # Variable c_long
JOY_CAL_READALWAYS = 65536 # Variable c_long
JOY_CAL_READXYONLY = 131072 # Variable c_long
JOY_BUTTON18       = 131072 # Variable c_long
JOY_BUTTON19       = 262144 # Variable c_long
JOY_CAL_READ3      = 262144 # Variable c_long
JOY_BUTTON20       = 524288 # Variable c_long
JOY_CAL_READ4      = 524288 # Variable c_long
JOY_CAL_READXONLY  = 1048576 # Variable c_long
JOY_BUTTON21       = 1048576 # Variable c_long
JOY_CAL_READYONLY  = 2097152 # Variable c_long
JOY_BUTTON22       = 2097152 # Variable c_long
JOY_BUTTON23       = 4194304 # Variable c_long
JOY_CAL_READ5      = 4194304 # Variable c_long
JOY_CAL_READ6      = 8388608 # Variable c_long
JOY_BUTTON24       = 8388608 # Variable c_long
JOY_BUTTON25       = 16777216 # Variable c_long
JOY_CAL_READZONLY  = 16777216 # Variable c_long
JOY_BUTTON26       = 33554432 # Variable c_long
JOY_CAL_READRONLY  = 33554432 # Variable c_long
JOY_BUTTON27       = 67108864 # Variable c_long
JOY_CAL_READUONLY  = 67108864 # Variable c_long
JOY_BUTTON28       = 134217728 # Variable c_long
JOY_CAL_READVONLY  = 134217728 # Variable c_long
JOY_BUTTON29       = 268435456 # Variable c_long
JOY_BUTTON30       = 536870912 # Variable c_long
JOY_BUTTON31       = 1073741824 # Variable c_long
JOY_BUTTON32       = 2147483648 # Variable c_ulong

KEYEVENTF_UNICODE     = 0x0004
KEYEVENTF_SCANCODE    = 0x0008
KEYEVENTF_EXTENDEDKEY = win32con.KEYEVENTF_EXTENDEDKEY # 1
KEYEVENTF_KEYUP       = win32con.KEYEVENTF_KEYUP # 2

KEY_QUERY_VALUE        = win32con.KEY_QUERY_VALUE # 1
KEY_EVENT              = 1 # Variable c_int
KEY_SET_VALUE          = win32con.KEY_SET_VALUE # 2
KEY_CREATE_SUB_KEY     = win32con.KEY_CREATE_SUB_KEY # 4
KEY_ENUMERATE_SUB_KEYS = win32con.KEY_ENUMERATE_SUB_KEYS # 8
KEY_NOTIFY             = win32con.KEY_NOTIFY # 16
KEY_CREATE_LINK        = win32con.KEY_CREATE_LINK # 32
KEY_WRITE              = win32con.KEY_WRITE # 131078
KEY_EXECUTE            = win32con.KEY_EXECUTE # 131097
KEY_READ               = win32con.KEY_READ # 131097
KEY_ALL_ACCESS         = win32con.KEY_ALL_ACCESS # 983103

KF_EXTENDED = win32con.KF_EXTENDED # 256
KF_DLGMODE  = win32con.KF_DLGMODE # 2048
KF_MENUMODE = win32con.KF_MENUMODE # 4096
KF_ALTDOWN  = win32con.KF_ALTDOWN # 8192
KF_REPEAT   = win32con.KF_REPEAT # 16384
KF_UP       = win32con.KF_UP # 32768

KLF_ACTIVATE       = win32con.KLF_ACTIVATE # 1
KLF_SUBSTITUTE_OK  = win32con.KLF_SUBSTITUTE_OK # 2
KLF_UNLOADPREVIOUS = win32con.KLF_UNLOADPREVIOUS # 4
KLF_REORDER        = win32con.KLF_REORDER # 8
KLF_REPLACELANG    = win32con.KLF_REPLACELANG # 16
KLF_NOTELLSHELL    = win32con.KLF_NOTELLSHELL # 128
KLF_SETFORPROCESS  = win32con.KLF_SETFORPROCESS # 256

KL_NAMELENGTH = win32con.KL_NAMELENGTH # 9

LANG_NEUTRAL        = win32con.LANG_NEUTRAL # 0
LANG_ARABIC         = 1 # Variable c_int
LANG_BULGARIAN      = win32con.LANG_BULGARIAN # 2
LANG_CATALAN        = 3 # Variable c_int
LANG_CHINESE        = win32con.LANG_CHINESE # 4
LANG_CZECH          = win32con.LANG_CZECH # 5
LANG_DANISH         = win32con.LANG_DANISH # 6
LANG_GERMAN         = win32con.LANG_GERMAN # 7
LANG_GREEK          = win32con.LANG_GREEK # 8
LANG_ENGLISH        = win32con.LANG_ENGLISH # 9
LANG_SPANISH        = win32con.LANG_SPANISH # 10
LANG_FINNISH        = win32con.LANG_FINNISH # 11
LANG_FRENCH         = win32con.LANG_FRENCH # 12
LANG_HEBREW         = 13 # Variable c_int
LANG_HUNGARIAN      = win32con.LANG_HUNGARIAN # 14
LANG_ICELANDIC      = win32con.LANG_ICELANDIC # 15
LANG_ITALIAN        = win32con.LANG_ITALIAN # 16
LANG_JAPANESE       = win32con.LANG_JAPANESE # 17
LANG_KOREAN         = win32con.LANG_KOREAN # 18
LANG_DUTCH          = win32con.LANG_DUTCH # 19
LANG_NORWEGIAN      = win32con.LANG_NORWEGIAN # 20
LANG_POLISH         = win32con.LANG_POLISH # 21
LANG_PORTUGUESE     = win32con.LANG_PORTUGUESE # 22
LANG_ROMANIAN       = win32con.LANG_ROMANIAN # 24
LANG_RUSSIAN        = win32con.LANG_RUSSIAN # 25
LANG_CROATIAN       = win32con.LANG_CROATIAN # 26
LANG_SERBIAN        = 26 # Variable c_int
LANG_SLOVAK         = win32con.LANG_SLOVAK # 27
LANG_ALBANIAN       = 28 # Variable c_int
LANG_SWEDISH        = win32con.LANG_SWEDISH # 29
LANG_THAI           = 30 # Variable c_int
LANG_TURKISH        = win32con.LANG_TURKISH # 31
LANG_URDU           = 32 # Variable c_int
LANG_INDONESIAN     = 33 # Variable c_int
LANG_UKRAINIAN      = 34 # Variable c_int
LANG_BELARUSIAN     = 35 # Variable c_int
LANG_SLOVENIAN      = win32con.LANG_SLOVENIAN # 36
LANG_ESTONIAN       = 37 # Variable c_int
LANG_LATVIAN        = 38 # Variable c_int
LANG_LITHUANIAN     = 39 # Variable c_int
LANG_FARSI          = 41 # Variable c_int
LANG_VIETNAMESE     = 42 # Variable c_int
LANG_ARMENIAN       = 43 # Variable c_int
LANG_AZERI          = 44 # Variable c_int
LANG_BASQUE         = 45 # Variable c_int
LANG_MACEDONIAN     = 47 # Variable c_int
LANG_AFRIKAANS      = 54 # Variable c_int
LANG_GEORGIAN       = 55 # Variable c_int
LANG_FAEROESE       = 56 # Variable c_int
LANG_HINDI          = 57 # Variable c_int
LANG_MALAY          = 62 # Variable c_int
LANG_KAZAK          = 63 # Variable c_int
LANG_SWAHILI        = 65 # Variable c_int
LANG_UZBEK          = 67 # Variable c_int
LANG_TATAR          = 68 # Variable c_int
LANG_BENGALI        = 69 # Variable c_int
LANG_PUNJABI        = 70 # Variable c_int
LANG_GUJARATI       = 71 # Variable c_int
LANG_ORIYA          = 72 # Variable c_int
LANG_TAMIL          = 73 # Variable c_int
LANG_TELUGU         = 74 # Variable c_int
LANG_KANNADA        = 75 # Variable c_int
LANG_MALAYALAM      = 76 # Variable c_int
LANG_ASSAMESE       = 77 # Variable c_int
LANG_MARATHI        = 78 # Variable c_int
LANG_SANSKRIT       = 79 # Variable c_int
LANG_KONKANI        = 87 # Variable c_int
LANG_MANIPURI       = 88 # Variable c_int
LANG_SINDHI         = 89 # Variable c_int
LANG_KASHMIRI       = 96 # Variable c_int
LANG_NEPALI         = 97 # Variable c_int
LANG_USER_DEFAULT   = 1024 # Variable c_int
LANG_SYSTEM_DEFAULT = 2048 # Variable c_int

LATENCY_TIME = c_int # enum

LBN_SELCHANGE = win32con.LBN_SELCHANGE # 1
LBN_DBLCLK    = win32con.LBN_DBLCLK # 2
LBN_SELCANCEL = win32con.LBN_SELCANCEL # 3
LBN_SETFOCUS  = win32con.LBN_SETFOCUS # 4
LBN_KILLFOCUS = win32con.LBN_KILLFOCUS # 5
LBN_ERRSPACE  = win32con.LBN_ERRSPACE # -2

LBS_NOTIFY            = win32con.LBS_NOTIFY # 1
LBS_SORT              = win32con.LBS_SORT # 2
LBS_NOREDRAW          = win32con.LBS_NOREDRAW # 4
LBS_MULTIPLESEL       = win32con.LBS_MULTIPLESEL # 8
LBS_OWNERDRAWFIXED    = win32con.LBS_OWNERDRAWFIXED # 16
LBS_OWNERDRAWVARIABLE = win32con.LBS_OWNERDRAWVARIABLE # 32
LBS_HASSTRINGS        = win32con.LBS_HASSTRINGS # 64
LBS_USETABSTOPS       = win32con.LBS_USETABSTOPS # 128
LBS_NOINTEGRALHEIGHT  = win32con.LBS_NOINTEGRALHEIGHT # 256
LBS_MULTICOLUMN       = win32con.LBS_MULTICOLUMN # 512
LBS_WANTKEYBOARDINPUT = win32con.LBS_WANTKEYBOARDINPUT # 1024
LBS_EXTENDEDSEL       = win32con.LBS_EXTENDEDSEL # 2048
LBS_DISABLENOSCROLL   = win32con.LBS_DISABLENOSCROLL # 4096
LBS_NODATA            = win32con.LBS_NODATA # 8192
LBS_NOSEL             = win32con.LBS_NOSEL # 16384
LBS_STANDARD          = win32con.LBS_STANDARD # 10485763

LB_OKAY                = win32con.LB_OKAY # 0
LB_CTLCODE             = win32con.LB_CTLCODE # 0
LB_ADDSTRING           = win32con.LB_ADDSTRING # 384
LB_INSERTSTRING        = win32con.LB_INSERTSTRING # 385
LB_DELETESTRING        = win32con.LB_DELETESTRING # 386
LB_SELITEMRANGEEX      = win32con.LB_SELITEMRANGEEX # 387
LB_RESETCONTENT        = win32con.LB_RESETCONTENT # 388
LB_SETSEL              = win32con.LB_SETSEL # 389
LB_SETCURSEL           = win32con.LB_SETCURSEL # 390
LB_GETSEL              = win32con.LB_GETSEL # 391
LB_GETCURSEL           = win32con.LB_GETCURSEL # 392
LB_GETTEXT             = win32con.LB_GETTEXT # 393
LB_GETTEXTLEN          = win32con.LB_GETTEXTLEN # 394
LB_GETCOUNT            = win32con.LB_GETCOUNT # 395
LB_SELECTSTRING        = win32con.LB_SELECTSTRING # 396
LB_DIR                 = win32con.LB_DIR # 397
LB_GETTOPINDEX         = win32con.LB_GETTOPINDEX # 398
LB_FINDSTRING          = win32con.LB_FINDSTRING # 399
LB_GETSELCOUNT         = win32con.LB_GETSELCOUNT # 400
LB_GETSELITEMS         = win32con.LB_GETSELITEMS # 401
LB_SETTABSTOPS         = win32con.LB_SETTABSTOPS # 402
LB_GETHORIZONTALEXTENT = win32con.LB_GETHORIZONTALEXTENT # 403
LB_SETHORIZONTALEXTENT = win32con.LB_SETHORIZONTALEXTENT # 404
LB_SETCOLUMNWIDTH      = win32con.LB_SETCOLUMNWIDTH # 405
LB_ADDFILE             = win32con.LB_ADDFILE # 406
LB_SETTOPINDEX         = win32con.LB_SETTOPINDEX # 407
LB_GETITEMRECT         = win32con.LB_GETITEMRECT # 408
LB_GETITEMDATA         = win32con.LB_GETITEMDATA # 409
LB_SETITEMDATA         = win32con.LB_SETITEMDATA # 410
LB_SELITEMRANGE        = win32con.LB_SELITEMRANGE # 411
LB_SETANCHORINDEX      = win32con.LB_SETANCHORINDEX # 412
LB_GETANCHORINDEX      = win32con.LB_GETANCHORINDEX # 413
LB_SETCARETINDEX       = win32con.LB_SETCARETINDEX # 414
LB_GETCARETINDEX       = win32con.LB_GETCARETINDEX # 415
LB_SETITEMHEIGHT       = win32con.LB_SETITEMHEIGHT # 416
LB_GETITEMHEIGHT       = win32con.LB_GETITEMHEIGHT # 417
LB_FINDSTRINGEXACT     = win32con.LB_FINDSTRINGEXACT # 418
LB_SETLOCALE           = win32con.LB_SETLOCALE # 421
LB_GETLOCALE           = win32con.LB_GETLOCALE # 422
LB_SETCOUNT            = win32con.LB_SETCOUNT # 423
LB_INITSTORAGE         = win32con.LB_INITSTORAGE # 424
LB_ITEMFROMPOINT       = win32con.LB_ITEMFROMPOINT # 425
LB_MSGMAX              = win32con.LB_MSGMAX # 432
LB_ERR                 = win32con.LB_ERR # -1
LB_ERRSPACE            = win32con.LB_ERRSPACE # -2

LCID_INSTALLED       = 1 # Variable c_int
LCID_SUPPORTED       = 2 # Variable c_int
LCID_ALTERNATE_SORTS = 4 # Variable c_int

LCMAP_LOWERCASE           = 256 # Variable c_int
LCMAP_UPPERCASE           = 512 # Variable c_int
LCMAP_SORTKEY             = 1024 # Variable c_int
LCMAP_BYTEREV             = 2048 # Variable c_int
LCMAP_HIRAGANA            = 1048576 # Variable c_int
LCMAP_KATAKANA            = 2097152 # Variable c_int
LCMAP_HALFWIDTH           = 4194304 # Variable c_int
LCMAP_FULLWIDTH           = 8388608 # Variable c_int
LCMAP_LINGUISTIC_CASING   = 16777216 # Variable c_int
LCMAP_SIMPLIFIED_CHINESE  = 33554432 # Variable c_int
LCMAP_TRADITIONAL_CHINESE = 67108864 # Variable c_int

LCS_CALIBRATED_RGB      = 0 # Variable c_long
LCS_GM_BUSINESS         = 1 # Variable c_long
LCS_DEVICE_RGB          = 1 # Variable c_long
LCS_GM_GRAPHICS         = 2 # Variable c_long
LCS_DEVICE_CMYK         = 2 # Variable c_long
LCS_GM_IMAGES           = 4 # Variable c_long
LCS_GM_ABS_COLORIMETRIC = 8 # Variable c_long
LCS_SIGNATURE           = 1347637059 # Variable c_int
LCS_WINDOWS_COLOR_SPACE = 1466527264 # Variable c_int
LCS_sRGB                = 1934772034 # Variable c_int

LC_NONE       = win32con.LC_NONE # 0
LC_POLYLINE   = win32con.LC_POLYLINE # 2
LC_MARKER     = win32con.LC_MARKER # 4
LC_POLYMARKER = win32con.LC_POLYMARKER # 8
LC_WIDE       = win32con.LC_WIDE # 16
LC_STYLED     = win32con.LC_STYLED # 32
LC_WIDESTYLED = win32con.LC_WIDESTYLED # 64
LC_INTERIORS  = win32con.LC_INTERIORS # 128

LEFT_ALT_PRESSED  = win32con.LEFT_ALT_PRESSED # 2
LEFT_CTRL_PRESSED = win32con.LEFT_CTRL_PRESSED # 8

LF_FACESIZE     = win32con.LF_FACESIZE # 32
LF_FULLFACESIZE = win32con.LF_FULLFACESIZE # 64

LIBFLAG_FRESTRICTED   = 1
LIBFLAG_FCONTROL      = 2
LIBFLAG_FHIDDEN       = 4
LIBFLAG_FHASDISKIMAGE = 8

LISTEN_OUTSTANDING = 1 # Variable c_int

LMEM_FIXED          = win32con.LMEM_FIXED # 0
LMEM_MOVEABLE       = win32con.LMEM_MOVEABLE # 2
LMEM_NOCOMPACT      = win32con.LMEM_NOCOMPACT # 16
LMEM_NODISCARD      = win32con.LMEM_NODISCARD # 32
LMEM_ZEROINIT       = win32con.LMEM_ZEROINIT # 64
LMEM_MODIFY         = win32con.LMEM_MODIFY # 128
LMEM_LOCKCOUNT      = win32con.LMEM_LOCKCOUNT # 255
LMEM_DISCARDABLE    = win32con.LMEM_DISCARDABLE # 3840
LMEM_VALID_FLAGS    = win32con.LMEM_VALID_FLAGS # 3954
LMEM_DISCARDED      = win32con.LMEM_DISCARDED # 16384
LMEM_INVALID_HANDLE = win32con.LMEM_INVALID_HANDLE # 32768

LOAD_LIBRARY_AS_DATAFILE      = win32con.LOAD_LIBRARY_AS_DATAFILE # 2
LOAD_DLL_DEBUG_EVENT          = win32con.LOAD_DLL_DEBUG_EVENT # 6
LOAD_WITH_ALTERED_SEARCH_PATH = win32con.LOAD_WITH_ALTERED_SEARCH_PATH # 8

LOCALE_NEUTRAL              = 0 # Variable c_ulong
LOCALE_ILANGUAGE            = 1 # Variable c_int
LOCALE_SLANGUAGE            = 2 # Variable c_int
LOCALE_SABBREVLANGNAME      = 3 # Variable c_int
LOCALE_SNATIVELANGNAME      = 4 # Variable c_int
LOCALE_ICOUNTRY             = 5 # Variable c_int
LOCALE_SCOUNTRY             = 6 # Variable c_int
LOCALE_SABBREVCTRYNAME      = 7 # Variable c_int
LOCALE_SNATIVECTRYNAME      = 8 # Variable c_int
LOCALE_IDEFAULTLANGUAGE     = 9 # Variable c_int
LOCALE_IDEFAULTCOUNTRY      = 10 # Variable c_int
LOCALE_IDEFAULTCODEPAGE     = 11 # Variable c_int
LOCALE_SLIST                = 12 # Variable c_int
LOCALE_IMEASURE             = 13 # Variable c_int
LOCALE_SDECIMAL             = 14 # Variable c_int
LOCALE_STHOUSAND            = 15 # Variable c_int
LOCALE_SGROUPING            = 16 # Variable c_int
LOCALE_IDIGITS              = 17 # Variable c_int
LOCALE_ILZERO               = 18 # Variable c_int
LOCALE_SNATIVEDIGITS        = 19 # Variable c_int
LOCALE_SCURRENCY            = 20 # Variable c_int
LOCALE_SINTLSYMBOL          = 21 # Variable c_int
LOCALE_SMONDECIMALSEP       = 22 # Variable c_int
LOCALE_SMONTHOUSANDSEP      = 23 # Variable c_int
LOCALE_SMONGROUPING         = 24 # Variable c_int
LOCALE_ICURRDIGITS          = 25 # Variable c_int
LOCALE_IINTLCURRDIGITS      = 26 # Variable c_int
LOCALE_ICURRENCY            = 27 # Variable c_int
LOCALE_INEGCURR             = 28 # Variable c_int
LOCALE_SDATE                = 29 # Variable c_int
LOCALE_STIME                = 30 # Variable c_int
LOCALE_SSHORTDATE           = 31 # Variable c_int
LOCALE_SLONGDATE            = 32 # Variable c_int
LOCALE_IDATE                = 33 # Variable c_int
LOCALE_ILDATE               = 34 # Variable c_int
LOCALE_ITIME                = 35 # Variable c_int
LOCALE_ICENTURY             = 36 # Variable c_int
LOCALE_ITLZERO              = 37 # Variable c_int
LOCALE_IDAYLZERO            = 38 # Variable c_int
LOCALE_IMONLZERO            = 39 # Variable c_int
LOCALE_S1159                = 40 # Variable c_int
LOCALE_S2359                = 41 # Variable c_int
LOCALE_SDAYNAME1            = 42 # Variable c_int
LOCALE_SDAYNAME2            = 43 # Variable c_int
LOCALE_SDAYNAME3            = 44 # Variable c_int
LOCALE_SDAYNAME4            = 45 # Variable c_int
LOCALE_SDAYNAME5            = 46 # Variable c_int
LOCALE_SDAYNAME6            = 47 # Variable c_int
LOCALE_SDAYNAME7            = 48 # Variable c_int
LOCALE_SABBREVDAYNAME1      = 49 # Variable c_int
LOCALE_SABBREVDAYNAME2      = 50 # Variable c_int
LOCALE_SABBREVDAYNAME3      = 51 # Variable c_int
LOCALE_SABBREVDAYNAME4      = 52 # Variable c_int
LOCALE_SABBREVDAYNAME5      = 53 # Variable c_int
LOCALE_SABBREVDAYNAME6      = 54 # Variable c_int
LOCALE_SABBREVDAYNAME7      = 55 # Variable c_int
LOCALE_SMONTHNAME1          = 56 # Variable c_int
LOCALE_SMONTHNAME2          = 57 # Variable c_int
LOCALE_SMONTHNAME3          = 58 # Variable c_int
LOCALE_SMONTHNAME4          = 59 # Variable c_int
LOCALE_SMONTHNAME5          = 60 # Variable c_int
LOCALE_SMONTHNAME6          = 61 # Variable c_int
LOCALE_SMONTHNAME7          = 62 # Variable c_int
LOCALE_SMONTHNAME8          = 63 # Variable c_int
LOCALE_SMONTHNAME9          = 64 # Variable c_int
LOCALE_SMONTHNAME10         = 65 # Variable c_int
LOCALE_SMONTHNAME11         = 66 # Variable c_int
LOCALE_SMONTHNAME12         = 67 # Variable c_int
LOCALE_SABBREVMONTHNAME1    = 68 # Variable c_int
LOCALE_SABBREVMONTHNAME2    = 69 # Variable c_int
LOCALE_SABBREVMONTHNAME3    = 70 # Variable c_int
LOCALE_SABBREVMONTHNAME4    = 71 # Variable c_int
LOCALE_SABBREVMONTHNAME5    = 72 # Variable c_int
LOCALE_SABBREVMONTHNAME6    = 73 # Variable c_int
LOCALE_SABBREVMONTHNAME7    = 74 # Variable c_int
LOCALE_SABBREVMONTHNAME8    = 75 # Variable c_int
LOCALE_SABBREVMONTHNAME9    = 76 # Variable c_int
LOCALE_SABBREVMONTHNAME10   = 77 # Variable c_int
LOCALE_SABBREVMONTHNAME11   = 78 # Variable c_int
LOCALE_SABBREVMONTHNAME12   = 79 # Variable c_int
LOCALE_SPOSITIVESIGN        = 80 # Variable c_int
LOCALE_SNEGATIVESIGN        = 81 # Variable c_int
LOCALE_IPOSSIGNPOSN         = 82 # Variable c_int
LOCALE_INEGSIGNPOSN         = 83 # Variable c_int
LOCALE_IPOSSYMPRECEDES      = 84 # Variable c_int
LOCALE_IPOSSEPBYSPACE       = 85 # Variable c_int
LOCALE_INEGSYMPRECEDES      = 86 # Variable c_int
LOCALE_INEGSEPBYSPACE       = 87 # Variable c_int
LOCALE_FONTSIGNATURE        = 88 # Variable c_int
LOCALE_SISO639LANGNAME      = 89 # Variable c_int
LOCALE_SISO3166CTRYNAME     = 90 # Variable c_int
LOCALE_USER_DEFAULT         = 1024 # Variable c_ulong
LOCALE_SYSTEM_DEFAULT       = 2048 # Variable c_ulong
LOCALE_SENGLANGUAGE         = 4097 # Variable c_int
LOCALE_SENGCOUNTRY          = 4098 # Variable c_int
LOCALE_STIMEFORMAT          = 4099 # Variable c_int
LOCALE_IDEFAULTANSICODEPAGE = 4100 # Variable c_int
LOCALE_ITIMEMARKPOSN        = 4101 # Variable c_int
LOCALE_ICALENDARTYPE        = 4105 # Variable c_int
LOCALE_IOPTIONALCALENDAR    = 4107 # Variable c_int
LOCALE_IFIRSTDAYOFWEEK      = 4108 # Variable c_int
LOCALE_IFIRSTWEEKOFYEAR     = 4109 # Variable c_int
LOCALE_SMONTHNAME13         = 4110 # Variable c_int
LOCALE_SABBREVMONTHNAME13   = 4111 # Variable c_int
LOCALE_INEGNUMBER           = 4112 # Variable c_int
LOCALE_IDEFAULTMACCODEPAGE  = 4113 # Variable c_int
LOCALE_RETURN_NUMBER        = 536870912 # Variable c_int
LOCALE_USE_CP_ACP           = 1073741824 # Variable c_int
LOCALE_NOUSEROVERRIDE       = 2147483648 # Variable c_uint

LOCKFILE_FAIL_IMMEDIATELY = win32con.LOCKFILE_FAIL_IMMEDIATELY # 1
LOCKFILE_EXCLUSIVE_LOCK   = win32con.LOCKFILE_EXCLUSIVE_LOCK # 2

LOCK_WRITE     = 1
LOCK_EXCLUSIVE = 2
LOCK_ONLYONCE  = 4

LOGON32_PROVIDER_DEFAULT  = win32con.LOGON32_PROVIDER_DEFAULT # 0
LOGON32_PROVIDER_WINNT35  = win32con.LOGON32_PROVIDER_WINNT35 # 1
LOGON32_LOGON_INTERACTIVE = win32con.LOGON32_LOGON_INTERACTIVE # 2
LOGON32_LOGON_NETWORK     = win32con.LOGON32_LOGON_NETWORK # 3
LOGON32_LOGON_BATCH       = win32con.LOGON32_LOGON_BATCH # 4
LOGON32_LOGON_SERVICE     = win32con.LOGON32_LOGON_SERVICE # 5

LPD_TYPE_RGBA       = 0 # Variable c_int
LPD_TYPE_COLORINDEX = 1 # Variable c_int
LPD_DOUBLEBUFFER    = 1 # Variable c_int
LPD_STEREO          = 2 # Variable c_int
LPD_SUPPORT_GDI     = 16 # Variable c_int
LPD_SUPPORT_OPENGL  = 32 # Variable c_int
LPD_SHARE_DEPTH     = 64 # Variable c_int
LPD_SHARE_STENCIL   = 128 # Variable c_int
LPD_SHARE_ACCUM     = 256 # Variable c_int
LPD_SWAP_EXCHANGE   = 512 # Variable c_int
LPD_SWAP_COPY       = 1024 # Variable c_int
LPD_TRANSPARENT     = 4096 # Variable c_int

LPSTR_TEXTCALLBACKA = 4294967295 # Variable POINTER(c_char)
LPSTR_TEXTCALLBACKW = 4294967295 # Variable POINTER(c_wchar)

LR_DEFAULTCOLOR     = win32con.LR_DEFAULTCOLOR # 0
LR_MONOCHROME       = win32con.LR_MONOCHROME # 1
LR_COLOR            = win32con.LR_COLOR # 2
LR_COPYRETURNORG    = win32con.LR_COPYRETURNORG # 4
LR_COPYDELETEORG    = win32con.LR_COPYDELETEORG # 8
LR_LOADFROMFILE     = win32con.LR_LOADFROMFILE # 16
LR_LOADTRANSPARENT  = win32con.LR_LOADTRANSPARENT # 32
LR_DEFAULTSIZE      = win32con.LR_DEFAULTSIZE # 64
LR_VGACOLOR         = 128 # Variable c_int
LR_LOADMAP3DCOLORS  = win32con.LR_LOADMAP3DCOLORS # 4096
LR_CREATEDIBSECTION = win32con.LR_CREATEDIBSECTION # 8192
LR_COPYFROMRESOURCE = win32con.LR_COPYFROMRESOURCE # 16384
LR_SHARED           = win32con.LR_SHARED # 32768

LTGRAY_BRUSH = win32con.LTGRAY_BRUSH # 1

LT_DONT_CARE      = 0
LT_LOWEST_LATENCY = 1

LVA_DEFAULT    = 0 # Variable c_int
LVA_ALIGNLEFT  = 1 # Variable c_int
LVA_ALIGNTOP   = 2 # Variable c_int
LVA_SNAPTOGRID = 5 # Variable c_int

LVBKIF_STYLE_NORMAL   = 0 # Variable c_int
LVBKIF_SOURCE_NONE    = 0 # Variable c_int
LVBKIF_SOURCE_HBITMAP = 1 # Variable c_int
LVBKIF_SOURCE_URL     = 2 # Variable c_int
LVBKIF_SOURCE_MASK    = 3 # Variable c_int
LVBKIF_STYLE_TILE     = 16 # Variable c_int
LVBKIF_STYLE_MASK     = 16 # Variable c_int

LVCFMT_LEFT            = 0 # Variable c_int
LVCFMT_RIGHT           = 1 # Variable c_int
LVCFMT_CENTER          = 2 # Variable c_int
LVCFMT_JUSTIFYMASK     = 3 # Variable c_int
LVCFMT_IMAGE           = 2048 # Variable c_int
LVCFMT_BITMAP_ON_RIGHT = 4096 # Variable c_int
LVCFMT_COL_HAS_IMAGES  = 32768 # Variable c_int

LVCF_FMT     = 1 # Variable c_int
LVCF_WIDTH   = 2 # Variable c_int
LVCF_TEXT    = 4 # Variable c_int
LVCF_SUBITEM = 8 # Variable c_int
LVCF_IMAGE   = 16 # Variable c_int
LVCF_ORDER   = 32 # Variable c_int

LVCOLUMNA_V1_SIZE = 24 # Variable c_uint

LVCOLUMNW_V1_SIZE = 24 # Variable c_uint

LVFI_PARAM     = 1 # Variable c_int
LVFI_STRING    = 2 # Variable c_int
LVFI_PARTIAL   = 8 # Variable c_int
LVFI_WRAP      = 32 # Variable c_int
LVFI_NEARESTXY = 64 # Variable c_int

LVGIT_UNFOLDED = 1 # Variable c_int

LVHITTESTINFO_V1_SIZE = 16 # Variable c_uint

LVHT_NOWHERE         = 1 # Variable c_int
LVHT_ONITEMICON      = 2 # Variable c_int
LVHT_ONITEMLABEL     = 4 # Variable c_int
LVHT_ONITEMSTATEICON = 8 # Variable c_int
LVHT_ABOVE           = 8 # Variable c_int
LVHT_ONITEM          = 14 # Variable c_int
LVHT_BELOW           = 16 # Variable c_int
LVHT_TORIGHT         = 32 # Variable c_int
LVHT_TOLEFT          = 64 # Variable c_int

LVIF_TEXT        = 1 # Variable c_int
LVIF_IMAGE       = 2 # Variable c_int
LVIF_PARAM       = 4 # Variable c_int
LVIF_STATE       = 8 # Variable c_int
LVIF_INDENT      = 16 # Variable c_int
LVIF_NORECOMPUTE = 2048 # Variable c_int
LVIF_DI_SETITEM  = 4096 # Variable c_int

LVIR_BOUNDS       = 0 # Variable c_int
LVIR_ICON         = 1 # Variable c_int
LVIR_LABEL        = 2 # Variable c_int
LVIR_SELECTBOUNDS = 3 # Variable c_int

LVIS_FOCUSED        = 1 # Variable c_int
LVIS_SELECTED       = 2 # Variable c_int
LVIS_CUT            = 4 # Variable c_int
LVIS_DROPHILITED    = 8 # Variable c_int
LVIS_ACTIVATING     = 32 # Variable c_int
LVIS_OVERLAYMASK    = 3840 # Variable c_int
LVIS_STATEIMAGEMASK = 61440 # Variable c_int

LVITEMA_V1_SIZE = 36 # Variable c_uint

LVITEMW_V1_SIZE = 36 # Variable c_uint

LVKF_ALT     = 1 # Variable c_int
LVKF_CONTROL = 2 # Variable c_int
LVKF_SHIFT   = 4 # Variable c_int

LVM_FIRST                    = 4096 # Variable c_int
LVM_GETBKCOLOR               = 4096 # Variable c_int
LVM_SETBKCOLOR               = 4097 # Variable c_int
LVM_GETIMAGELIST             = 4098 # Variable c_int
LVM_SETIMAGELIST             = 4099 # Variable c_int
LVM_GETITEMCOUNT             = 4100 # Variable c_int
LVM_GETITEMA                 = 4101 # Variable c_int
LVM_SETITEMA                 = 4102 # Variable c_int
LVM_INSERTITEMA              = 4103 # Variable c_int
LVM_DELETEITEM               = 4104 # Variable c_int
LVM_DELETEALLITEMS           = 4105 # Variable c_int
LVM_GETCALLBACKMASK          = 4106 # Variable c_int
LVM_SETCALLBACKMASK          = 4107 # Variable c_int
LVM_GETNEXTITEM              = 4108 # Variable c_int
LVM_FINDITEMA                = 4109 # Variable c_int
LVM_GETITEMRECT              = 4110 # Variable c_int
LVM_SETITEMPOSITION          = 4111 # Variable c_int
LVM_GETITEMPOSITION          = 4112 # Variable c_int
LVM_GETSTRINGWIDTHA          = 4113 # Variable c_int
LVM_HITTEST                  = 4114 # Variable c_int
LVM_ENSUREVISIBLE            = 4115 # Variable c_int
LVM_SCROLL                   = 4116 # Variable c_int
LVM_REDRAWITEMS              = 4117 # Variable c_int
LVM_ARRANGE                  = 4118 # Variable c_int
LVM_EDITLABELA               = 4119 # Variable c_int
LVM_GETEDITCONTROL           = 4120 # Variable c_int
LVM_GETCOLUMNA               = 4121 # Variable c_int
LVM_SETCOLUMNA               = 4122 # Variable c_int
LVM_INSERTCOLUMNA            = 4123 # Variable c_int
LVM_DELETECOLUMN             = 4124 # Variable c_int
LVM_GETCOLUMNWIDTH           = 4125 # Variable c_int
LVM_SETCOLUMNWIDTH           = 4126 # Variable c_int
LVM_GETHEADER                = 4127 # Variable c_int
LVM_CREATEDRAGIMAGE          = 4129 # Variable c_int
LVM_GETVIEWRECT              = 4130 # Variable c_int
LVM_GETTEXTCOLOR             = 4131 # Variable c_int
LVM_SETTEXTCOLOR             = 4132 # Variable c_int
LVM_GETTEXTBKCOLOR           = 4133 # Variable c_int
LVM_SETTEXTBKCOLOR           = 4134 # Variable c_int
LVM_GETTOPINDEX              = 4135 # Variable c_int
LVM_GETCOUNTPERPAGE          = 4136 # Variable c_int
LVM_GETORIGIN                = 4137 # Variable c_int
LVM_UPDATE                   = 4138 # Variable c_int
LVM_SETITEMSTATE             = 4139 # Variable c_int
LVM_GETITEMSTATE             = 4140 # Variable c_int
LVM_GETITEMTEXTA             = 4141 # Variable c_int
LVM_SETITEMTEXTA             = 4142 # Variable c_int
LVM_SETITEMCOUNT             = 4143 # Variable c_int
LVM_SORTITEMS                = 4144 # Variable c_int
LVM_SETITEMPOSITION32        = 4145 # Variable c_int
LVM_GETSELECTEDCOUNT         = 4146 # Variable c_int
LVM_GETITEMSPACING           = 4147 # Variable c_int
LVM_GETISEARCHSTRINGA        = 4148 # Variable c_int
LVM_SETICONSPACING           = 4149 # Variable c_int
LVM_SETEXTENDEDLISTVIEWSTYLE = 4150 # Variable c_int
LVM_GETEXTENDEDLISTVIEWSTYLE = 4151 # Variable c_int
LVM_GETSUBITEMRECT           = 4152 # Variable c_int
LVM_SUBITEMHITTEST           = 4153 # Variable c_int
LVM_SETCOLUMNORDERARRAY      = 4154 # Variable c_int
LVM_GETCOLUMNORDERARRAY      = 4155 # Variable c_int
LVM_SETHOTITEM               = 4156 # Variable c_int
LVM_GETHOTITEM               = 4157 # Variable c_int
LVM_SETHOTCURSOR             = 4158 # Variable c_int
LVM_GETHOTCURSOR             = 4159 # Variable c_int
LVM_APPROXIMATEVIEWRECT      = 4160 # Variable c_int
LVM_SETWORKAREAS             = 4161 # Variable c_int
LVM_GETSELECTIONMARK         = 4162 # Variable c_int
LVM_SETSELECTIONMARK         = 4163 # Variable c_int
LVM_SETBKIMAGEA              = 4164 # Variable c_int
LVM_GETBKIMAGEA              = 4165 # Variable c_int
LVM_GETWORKAREAS             = 4166 # Variable c_int
LVM_SETHOVERTIME             = 4167 # Variable c_int
LVM_GETHOVERTIME             = 4168 # Variable c_int
LVM_GETNUMBEROFWORKAREAS     = 4169 # Variable c_int
LVM_SETTOOLTIPS              = 4170 # Variable c_int
LVM_GETITEMW                 = 4171 # Variable c_int
LVM_SETITEMW                 = 4172 # Variable c_int
LVM_INSERTITEMW              = 4173 # Variable c_int
LVM_GETTOOLTIPS              = 4174 # Variable c_int
LVM_FINDITEMW                = 4179 # Variable c_int
LVM_GETSTRINGWIDTHW          = 4183 # Variable c_int
LVM_GETCOLUMNW               = 4191 # Variable c_int
LVM_SETCOLUMNW               = 4192 # Variable c_int
LVM_INSERTCOLUMNW            = 4193 # Variable c_int
LVM_GETITEMTEXTW             = 4211 # Variable c_int
LVM_SETITEMTEXTW             = 4212 # Variable c_int
LVM_GETISEARCHSTRINGW        = 4213 # Variable c_int
LVM_EDITLABELW               = 4214 # Variable c_int
LVM_SETBKIMAGEW              = 4234 # Variable c_int
LVM_GETBKIMAGEW              = 4235 # Variable c_int

LVNI_ALL         = 0 # Variable c_int
LVNI_FOCUSED     = 1 # Variable c_int
LVNI_SELECTED    = 2 # Variable c_int
LVNI_CUT         = 4 # Variable c_int
LVNI_DROPHILITED = 8 # Variable c_int
LVNI_ABOVE       = 256 # Variable c_int
LVNI_BELOW       = 512 # Variable c_int
LVNI_TOLEFT      = 1024 # Variable c_int
LVNI_TORIGHT     = 2048 # Variable c_int

LVN_LAST            = 4294967097 # Variable c_uint
LVN_ODFINDITEMW     = 4294967117 # Variable c_uint
LVN_SETDISPINFOW    = 4294967118 # Variable c_uint
LVN_GETDISPINFOW    = 4294967119 # Variable c_uint
LVN_ENDLABELEDITW   = 4294967120 # Variable c_uint
LVN_BEGINLABELEDITW = 4294967121 # Variable c_uint
LVN_GETINFOTIPW     = 4294967138 # Variable c_uint
LVN_GETINFOTIPA     = 4294967139 # Variable c_uint
LVN_MARQUEEBEGIN    = 4294967140 # Variable c_uint
LVN_KEYDOWN         = 4294967141 # Variable c_uint
LVN_ODFINDITEMA     = 4294967144 # Variable c_uint
LVN_SETDISPINFOA    = 4294967145 # Variable c_uint
LVN_GETDISPINFOA    = 4294967146 # Variable c_uint
LVN_HOTTRACK        = 4294967175 # Variable c_uint
LVN_ODSTATECHANGED  = 4294967181 # Variable c_uint
LVN_ITEMACTIVATE    = 4294967182 # Variable c_uint
LVN_ODCACHEHINT     = 4294967183 # Variable c_uint
LVN_BEGINRDRAG      = 4294967185 # Variable c_uint
LVN_BEGINDRAG       = 4294967187 # Variable c_uint
LVN_COLUMNCLICK     = 4294967188 # Variable c_uint
LVN_ENDLABELEDITA   = 4294967190 # Variable c_uint
LVN_BEGINLABELEDITA = 4294967191 # Variable c_uint
LVN_DELETEALLITEMS  = 4294967192 # Variable c_uint
LVN_DELETEITEM      = 4294967193 # Variable c_uint
LVN_INSERTITEM      = 4294967194 # Variable c_uint
LVN_ITEMCHANGED     = 4294967195 # Variable c_uint
LVN_FIRST           = 4294967196 # Variable c_uint
LVN_ITEMCHANGING    = 4294967196 # Variable c_uint
LVN_BEGINSCROLL     = 4294967116
LVN_COLUMNDROPDOWN  = 4294967132
LVN_ENDLABELEDIT    = 4294967190
LVN_ENDSCROLL       = 4294967115
LVN_GETDISPINFO     = 4294967146
LVN_GETEMPTYMARKUP  = 4294967109
LVN_GETINFOTIP      = 4294967139
LVN_LINKCLICK       = 4294967112
LVN_ODFINDITEM      = 4294967144
LVN_SETDISPINFO     = 4294967145
LVN_INCREMENTALSEARCH   = 4294967134
LVN_COLUMNOVERFLOWCLICK = 4294967130

LVSCW_AUTOSIZE           = -1 # Variable c_int
LVSCW_AUTOSIZE_USEHEADER = -2 # Variable c_int

LVSICF_NOINVALIDATEALL = 1 # Variable c_int
LVSICF_NOSCROLL        = 2 # Variable c_int

LVSIL_NORMAL = 0 # Variable c_int
LVSIL_SMALL  = 1 # Variable c_int
LVSIL_STATE  = 2 # Variable c_int

LVS_ICON                = 0 # Variable c_int
LVS_ALIGNTOP            = 0 # Variable c_int
LVS_EX_GRIDLINES        = 1 # Variable c_int
LVS_REPORT              = 1 # Variable c_int
LVS_SMALLICON           = 2 # Variable c_int
LVS_EX_SUBITEMIMAGES    = 2 # Variable c_int
LVS_LIST                = 3 # Variable c_int
LVS_TYPEMASK            = 3 # Variable c_int
LVS_SINGLESEL           = 4 # Variable c_int
LVS_EX_CHECKBOXES       = 4 # Variable c_int
LVS_SHOWSELALWAYS       = 8 # Variable c_int
LVS_EX_TRACKSELECT      = 8 # Variable c_int
LVS_SORTASCENDING       = 16 # Variable c_int
LVS_EX_HEADERDRAGDROP   = 16 # Variable c_int
LVS_EX_FULLROWSELECT    = 32 # Variable c_int
LVS_SORTDESCENDING      = 32 # Variable c_int
LVS_SHAREIMAGELISTS     = 64 # Variable c_int
LVS_EX_ONECLICKACTIVATE = 64 # Variable c_int
LVS_EX_TWOCLICKACTIVATE = 128 # Variable c_int
LVS_NOLABELWRAP         = 128 # Variable c_int
LVS_EX_FLATSB           = 256 # Variable c_int
LVS_AUTOARRANGE         = 256 # Variable c_int
LVS_EDITLABELS          = 512 # Variable c_int
LVS_EX_REGIONAL         = 512 # Variable c_int
LVS_OWNERDRAWFIXED      = 1024 # Variable c_int
LVS_EX_INFOTIP          = 1024 # Variable c_int
LVS_EX_UNDERLINEHOT     = 2048 # Variable c_int
LVS_ALIGNLEFT           = 2048 # Variable c_int
LVS_ALIGNMASK           = 3072 # Variable c_int
LVS_OWNERDATA           = 4096 # Variable c_int
LVS_EX_UNDERLINECOLD    = 4096 # Variable c_int
LVS_NOSCROLL            = 8192 # Variable c_int
LVS_EX_MULTIWORKAREAS   = 8192 # Variable c_int
LVS_NOCOLUMNHEADER      = 16384 # Variable c_int
LVS_NOSORTHEADER        = 32768 # Variable c_int
LVS_TYPESTYLEMASK       = 64512 # Variable c_int

LV_MAX_WORKAREAS = 16 # Variable c_int

LZERROR_BADINHANDLE  = -1 # Variable c_int
LZERROR_BADOUTHANDLE = -2 # Variable c_int
LZERROR_READ         = -3 # Variable c_int
LZERROR_WRITE        = -4 # Variable c_int
LZERROR_GLOBALLOC    = -5 # Variable c_int
LZERROR_GLOBLOCK     = -6 # Variable c_int
LZERROR_BADVALUE     = -7 # Variable c_int
LZERROR_UNKNOWNALG   = -8 # Variable c_int

MCN_VIEWCHANGE = 4294966546

MAC_CHARSET = win32con.MAC_CHARSET # 77

MAILSLOT_WAIT_FOREVER = 4294967295 # Variable c_ulong
MAILSLOT_NO_MESSAGE   = 4294967295 # Variable c_ulong

MAP_FOLDCZONE   = 16 # Variable c_int
MAP_PRECOMPOSED = 32 # Variable c_int
MAP_COMPOSITE   = 64 # Variable c_int
MAP_FOLDDIGITS  = 128 # Variable c_int

MARSHALINTERFACE_MIN = 500 # Variable c_int

MARSHAL_S_FIRST = 262432 # Variable c_long
MARSHAL_S_LAST  = 262447 # Variable c_long
MARSHAL_E_FIRST = 2147746080 # Variable c_ulong
MARSHAL_E_LAST  = 2147746095 # Variable c_ulong

MAXHALF_PTR = 32767 # Variable c_int

MAXIMUM_PROCESSORS               = 32 # Variable c_int
MAXIMUM_WAIT_OBJECTS             = 64 # Variable c_int
MAXIMUM_SUPPORTED_EXTENSION      = 512 # Variable c_int
MAXIMUM_REPARSE_DATA_BUFFER_SIZE = 16384 # Variable c_int
MAXIMUM_ALLOWED                  = win32con.MAXIMUM_ALLOWED # 33554432

MAXINT_PTR = 2147483647 # Variable c_long

MAXUHALF_PTR = 65535 # Variable c_int

MAXUINT_PTR = 4294967295 # Variable c_ulong

MAX_DEFAULTCHAR                    = 2 # Variable c_int
MAX_MONITORS                       = 4 # Variable c_int
MAX_NATURAL_ALIGNMENT              = 4 # Variable c_uint
MAX_PERF_OBJECTS_IN_QUERY_FUNCTION = 8 # Variable c_long
MAX_LEADBYTES                      = 12 # Variable c_int
MAX_COMPUTERNAME_LENGTH            = win32con.MAX_COMPUTERNAME_LENGTH # 15
MAX_PRIORITY                       = 99 # Variable c_int
MAX_ZONE_DESCRIPTION               = 200
MAX_LANA                           = 254 # Variable c_int
MAX_ZONE_PATH                      = 260
MAX_PATH                           = win32con.MAX_PATH # 260
MAX_JOYSTICKOEMVXDNAME             = 260 # Variable c_int
MAX_SIZE_SECURITY_ID               = 512 # Variable c_int

MA_ACTIVATE         = win32con.MA_ACTIVATE # 1
MA_ACTIVATEANDEAT   = win32con.MA_ACTIVATEANDEAT # 2
MA_NOACTIVATE       = win32con.MA_NOACTIVATE # 3
MA_NOACTIVATEANDEAT = win32con.MA_NOACTIVATEANDEAT # 4

MB_APPLMODAL            = win32con.MB_APPLMODAL # 0
MB_OK                   = win32con.MB_OK # 0
MB_DEFBUTTON1           = win32con.MB_DEFBUTTON1 # 0
MB_PRECOMPOSED          = 1 # Variable c_int
MB_OKCANCEL             = win32con.MB_OKCANCEL # 1
MB_COMPOSITE            = 2 # Variable c_int
MB_ABORTRETRYIGNORE     = win32con.MB_ABORTRETRYIGNORE # 2
MB_YESNOCANCEL          = win32con.MB_YESNOCANCEL # 3
MB_USEGLYPHCHARS        = 4 # Variable c_int
MB_YESNO                = win32con.MB_YESNO # 4
MB_RETRYCANCEL          = win32con.MB_RETRYCANCEL # 5
MB_ERR_INVALID_CHARS    = 8 # Variable c_int
MB_TYPEMASK             = win32con.MB_TYPEMASK # 15
MB_ICONHAND             = win32con.MB_ICONHAND # 16
MB_ICONQUESTION         = win32con.MB_ICONQUESTION # 32
MB_ICONEXCLAMATION      = win32con.MB_ICONEXCLAMATION # 48
MB_ICONASTERISK         = win32con.MB_ICONASTERISK # 64
MB_USERICON             = win32con.MB_USERICON # 128
MB_ICONMASK             = win32con.MB_ICONMASK # 240
MB_DEFBUTTON2           = win32con.MB_DEFBUTTON2 # 256
MB_DEFBUTTON3           = win32con.MB_DEFBUTTON3 # 512
MB_DEFBUTTON4           = win32con.MB_DEFBUTTON4 # 768
MB_DEFMASK              = win32con.MB_DEFMASK # 3840
MB_SYSTEMMODAL          = win32con.MB_SYSTEMMODAL # 4096
MB_TASKMODAL            = win32con.MB_TASKMODAL # 8192
MB_MODEMASK             = win32con.MB_MODEMASK # 12288
MB_HELP                 = win32con.MB_HELP # 16384
MB_NOFOCUS              = win32con.MB_NOFOCUS # 32768
MB_MISCMASK             = win32con.MB_MISCMASK # 49152
MB_SETFOREGROUND        = win32con.MB_SETFOREGROUND # 65536
MB_DEFAULT_DESKTOP_ONLY = win32con.MB_DEFAULT_DESKTOP_ONLY # 131072
MB_TOPMOST              = win32con.MB_TOPMOST # 262144
MB_RIGHT                = win32con.MB_RIGHT # 524288
MB_RTLREADING           = win32con.MB_RTLREADING # 1048576

MCHT_NOWHERE          = 0 # Variable c_int
MCHT_TITLE            = 65536 # Variable c_int
MCHT_TITLEBK          = 65536 # Variable c_int
MCHT_TITLEMONTH       = 65537 # Variable c_int
MCHT_TITLEYEAR        = 65538 # Variable c_int
MCHT_CALENDARBK       = 131072 # Variable c_int
MCHT_CALENDAR         = 131072 # Variable c_int
MCHT_CALENDARDATE     = 131073 # Variable c_int
MCHT_CALENDARDAY      = 131074 # Variable c_int
MCHT_CALENDARWEEKNUM  = 131075 # Variable c_int
MCHT_TODAYLINK        = 196608 # Variable c_int
MCHT_NEXT             = 16777216 # Variable c_int
MCHT_TITLEBTNNEXT     = 16842755 # Variable c_int
MCHT_CALENDARDATENEXT = 16908289 # Variable c_int
MCHT_PREV             = 33554432 # Variable c_int
MCHT_TITLEBTNPREV     = 33619971 # Variable c_int
MCHT_CALENDARDATEPREV = 33685505 # Variable c_int

MCIERR_BASE                     = 256 # Variable c_int
MCIERR_INVALID_DEVICE_ID        = 257 # Variable c_int
MCIERR_UNRECOGNIZED_KEYWORD     = 259 # Variable c_int
MCIERR_UNRECOGNIZED_COMMAND     = 261 # Variable c_int
MCIERR_HARDWARE                 = 262 # Variable c_int
MCIERR_INVALID_DEVICE_NAME      = 263 # Variable c_int
MCIERR_OUT_OF_MEMORY            = 264 # Variable c_int
MCIERR_DEVICE_OPEN              = 265 # Variable c_int
MCIERR_CANNOT_LOAD_DRIVER       = 266 # Variable c_int
MCIERR_MISSING_COMMAND_STRING   = 267 # Variable c_int
MCIERR_PARAM_OVERFLOW           = 268 # Variable c_int
MCIERR_MISSING_STRING_ARGUMENT  = 269 # Variable c_int
MCIERR_BAD_INTEGER              = 270 # Variable c_int
MCIERR_PARSER_INTERNAL          = 271 # Variable c_int
MCIERR_DRIVER_INTERNAL          = 272 # Variable c_int
MCIERR_MISSING_PARAMETER        = 273 # Variable c_int
MCIERR_UNSUPPORTED_FUNCTION     = 274 # Variable c_int
MCIERR_FILE_NOT_FOUND           = 275 # Variable c_int
MCIERR_DEVICE_NOT_READY         = 276 # Variable c_int
MCIERR_INTERNAL                 = 277 # Variable c_int
MCIERR_DRIVER                   = 278 # Variable c_int
MCIERR_CANNOT_USE_ALL           = 279 # Variable c_int
MCIERR_MULTIPLE                 = 280 # Variable c_int
MCIERR_EXTENSION_NOT_FOUND      = 281 # Variable c_int
MCIERR_OUTOFRANGE               = 282 # Variable c_int
MCIERR_FLAGS_NOT_COMPATIBLE     = 284 # Variable c_int
MCIERR_FILE_NOT_SAVED           = 286 # Variable c_int
MCIERR_DEVICE_TYPE_REQUIRED     = 287 # Variable c_int
MCIERR_DEVICE_LOCKED            = 288 # Variable c_int
MCIERR_DUPLICATE_ALIAS          = 289 # Variable c_int
MCIERR_BAD_CONSTANT             = 290 # Variable c_int
MCIERR_MUST_USE_SHAREABLE       = 291 # Variable c_int
MCIERR_MISSING_DEVICE_NAME      = 292 # Variable c_int
MCIERR_BAD_TIME_FORMAT          = 293 # Variable c_int
MCIERR_NO_CLOSING_QUOTE         = 294 # Variable c_int
MCIERR_DUPLICATE_FLAGS          = 295 # Variable c_int
MCIERR_INVALID_FILE             = 296 # Variable c_int
MCIERR_NULL_PARAMETER_BLOCK     = 297 # Variable c_int
MCIERR_UNNAMED_RESOURCE         = 298 # Variable c_int
MCIERR_NEW_REQUIRES_ALIAS       = 299 # Variable c_int
MCIERR_NOTIFY_ON_AUTO_OPEN      = 300 # Variable c_int
MCIERR_NO_ELEMENT_ALLOWED       = 301 # Variable c_int
MCIERR_NONAPPLICABLE_FUNCTION   = 302 # Variable c_int
MCIERR_ILLEGAL_FOR_AUTO_OPEN    = 303 # Variable c_int
MCIERR_FILENAME_REQUIRED        = 304 # Variable c_int
MCIERR_EXTRA_CHARACTERS         = 305 # Variable c_int
MCIERR_DEVICE_NOT_INSTALLED     = 306 # Variable c_int
MCIERR_GET_CD                   = 307 # Variable c_int
MCIERR_SET_CD                   = 308 # Variable c_int
MCIERR_SET_DRIVE                = 309 # Variable c_int
MCIERR_DEVICE_LENGTH            = 310 # Variable c_int
MCIERR_DEVICE_ORD_LENGTH        = 311 # Variable c_int
MCIERR_NO_INTEGER               = 312 # Variable c_int
MCIERR_WAVE_OUTPUTSINUSE        = 320 # Variable c_int
MCIERR_WAVE_SETOUTPUTINUSE      = 321 # Variable c_int
MCIERR_WAVE_INPUTSINUSE         = 322 # Variable c_int
MCIERR_WAVE_SETINPUTINUSE       = 323 # Variable c_int
MCIERR_WAVE_OUTPUTUNSPECIFIED   = 324 # Variable c_int
MCIERR_WAVE_INPUTUNSPECIFIED    = 325 # Variable c_int
MCIERR_WAVE_OUTPUTSUNSUITABLE   = 326 # Variable c_int
MCIERR_WAVE_SETOUTPUTUNSUITABLE = 327 # Variable c_int
MCIERR_WAVE_INPUTSUNSUITABLE    = 328 # Variable c_int
MCIERR_WAVE_SETINPUTUNSUITABLE  = 329 # Variable c_int
MCIERR_SEQ_DIV_INCOMPATIBLE     = 336 # Variable c_int
MCIERR_SEQ_PORT_INUSE           = 337 # Variable c_int
MCIERR_SEQ_PORT_NONEXISTENT     = 338 # Variable c_int
MCIERR_SEQ_PORT_MAPNODEVICE     = 339 # Variable c_int
MCIERR_SEQ_PORT_MISCERROR       = 340 # Variable c_int
MCIERR_SEQ_TIMER                = 341 # Variable c_int
MCIERR_SEQ_PORTUNSPECIFIED      = 342 # Variable c_int
MCIERR_SEQ_NOMIDIPRESENT        = 343 # Variable c_int
MCIERR_NO_WINDOW                = 346 # Variable c_int
MCIERR_CREATEWINDOW             = 347 # Variable c_int
MCIERR_FILE_READ                = 348 # Variable c_int
MCIERR_FILE_WRITE               = 349 # Variable c_int
MCIERR_NO_IDENTITY              = 350 # Variable c_int
MCIERR_CUSTOM_DRIVER_BASE       = 512 # Variable c_int

MCI_FORMAT_MILLISECONDS         = 0 # Variable c_int
MCI_ANIM_WINDOW_DEFAULT         = 0 # Variable c_long
MCI_OVLY_WINDOW_DEFAULT         = 0 # Variable c_long
MCI_SET_AUDIO_ALL               = 0 # Variable c_long
MCI_FORMAT_HMS                  = 1 # Variable c_int
MCI_NOTIFY_SUCCESSFUL           = 1 # Variable c_int
MCI_GETDEVCAPS_CAN_RECORD       = 1 # Variable c_long
MCI_STATUS_LENGTH               = 1 # Variable c_long
MCI_SET_AUDIO_LEFT              = 1 # Variable c_long
MCI_NOTIFY                      = 1 # Variable c_long
MCI_NOTIFY_SUPERSEDED           = 2 # Variable c_int
MCI_FORMAT_MSF                  = 2 # Variable c_int
MCI_GETDEVCAPS_HAS_AUDIO        = 2 # Variable c_long
MCI_STATUS_POSITION             = 2 # Variable c_long
MCI_SET_AUDIO_RIGHT             = 2 # Variable c_long
MCI_WAIT                        = 2 # Variable c_long
MCI_FORMAT_FRAMES               = 3 # Variable c_int
MCI_GETDEVCAPS_HAS_VIDEO        = 3 # Variable c_long
MCI_STATUS_NUMBER_OF_TRACKS     = 3 # Variable c_long
MCI_FORMAT_SMPTE_24             = 4 # Variable c_int
MCI_NOTIFY_ABORTED              = 4 # Variable c_int
MCI_FROM                        = 4 # Variable c_long
MCI_STATUS_MODE                 = 4 # Variable c_long
MCI_GETDEVCAPS_DEVICE_TYPE      = 4 # Variable c_long
MCI_FORMAT_SMPTE_25             = 5 # Variable c_int
MCI_STATUS_MEDIA_PRESENT        = 5 # Variable c_long
MCI_GETDEVCAPS_USES_FILES       = 5 # Variable c_long
MCI_FORMAT_SMPTE_30             = 6 # Variable c_int
MCI_STATUS_TIME_FORMAT          = 6 # Variable c_long
MCI_GETDEVCAPS_COMPOUND_DEVICE  = 6 # Variable c_long
MCI_FORMAT_SMPTE_30DROP         = 7 # Variable c_int
MCI_GETDEVCAPS_CAN_EJECT        = 7 # Variable c_long
MCI_STATUS_READY                = 7 # Variable c_long
MCI_NOTIFY_FAILURE              = 8 # Variable c_int
MCI_FORMAT_BYTES                = 8 # Variable c_int
MCI_TO                          = 8 # Variable c_long
MCI_STATUS_CURRENT_TRACK        = 8 # Variable c_long
MCI_GETDEVCAPS_CAN_PLAY         = 8 # Variable c_long
MCI_FORMAT_SAMPLES              = 9 # Variable c_int
MCI_GETDEVCAPS_CAN_SAVE         = 9 # Variable c_long
MCI_FORMAT_TMSF                 = 10 # Variable c_int
MCI_TRACK                       = 16 # Variable c_long
MCI_STATUS_ITEM                 = 256 # Variable c_long
MCI_SEEK_TO_START               = 256 # Variable c_long
MCI_SAVE_FILE                   = 256 # Variable c_long
MCI_OPEN_SHAREABLE              = 256 # Variable c_long
MCI_SET_DOOR_OPEN               = 256 # Variable c_long
MCI_BREAK_KEY                   = 256 # Variable c_long
MCI_INFO_PRODUCT                = 256 # Variable c_long
MCI_VD_ESCAPE_STRING            = 256 # Variable c_long
MCI_SYSINFO_QUANTITY            = 256 # Variable c_long
MCI_LOAD_FILE                   = 256 # Variable c_long
MCI_RECORD_INSERT               = 256 # Variable c_long
MCI_GETDEVCAPS_ITEM             = 256 # Variable c_long
MCI_STRING_OFFSET               = 512 # Variable c_int
MCI_RECORD_OVERWRITE            = 512 # Variable c_long
MCI_OPEN_ELEMENT                = 512 # Variable c_long
MCI_STATUS_START                = 512 # Variable c_long
MCI_INFO_FILE                   = 512 # Variable c_long
MCI_SET_DOOR_CLOSED             = 512 # Variable c_long
MCI_SYSINFO_OPEN                = 512 # Variable c_long
MCI_BREAK_HWND                  = 512 # Variable c_long
MCI_SEEK_TO_END                 = 512 # Variable c_long
MCI_DEVTYPE_VCR                 = 513 # Variable c_int
MCI_DEVTYPE_VIDEODISC           = 514 # Variable c_int
MCI_DEVTYPE_OVERLAY             = 515 # Variable c_int
MCI_DEVTYPE_CD_AUDIO            = 516 # Variable c_int
MCI_DEVTYPE_DAT                 = 517 # Variable c_int
MCI_DEVTYPE_SCANNER             = 518 # Variable c_int
MCI_DEVTYPE_ANIMATION           = 519 # Variable c_int
MCI_DEVTYPE_DIGITAL_VIDEO       = 520 # Variable c_int
MCI_DEVTYPE_OTHER               = 521 # Variable c_int
MCI_DEVTYPE_WAVEFORM_AUDIO      = 522 # Variable c_int
MCI_DEVTYPE_SEQUENCER           = 523 # Variable c_int
MCI_MODE_NOT_READY              = 524 # Variable c_int
MCI_MODE_STOP                   = 525 # Variable c_int
MCI_MODE_PLAY                   = 526 # Variable c_int
MCI_MODE_RECORD                 = 527 # Variable c_int
MCI_MODE_SEEK                   = 528 # Variable c_int
MCI_MODE_PAUSE                  = 529 # Variable c_int
MCI_MODE_OPEN                   = 530 # Variable c_int
MCI_VD_OFFSET                   = 1024 # Variable c_int
MCI_INFO_MEDIA_UPC              = 1024 # Variable c_long
MCI_SYSINFO_NAME                = 1024 # Variable c_long
MCI_BREAK_OFF                   = 1024 # Variable c_long
MCI_SET_TIME_FORMAT             = 1024 # Variable c_long
MCI_OPEN_ALIAS                  = 1024 # Variable c_long
MCI_VD_MODE_PARK                = 1025 # Variable c_int
MCI_VD_MEDIA_CLV                = 1026 # Variable c_int
MCI_VD_MEDIA_CAV                = 1027 # Variable c_int
MCI_VD_MEDIA_OTHER              = 1028 # Variable c_int
MCI_CDA_TRACK_AUDIO             = 1088 # Variable c_int
MCI_CD_OFFSET                   = 1088 # Variable c_int
MCI_CDA_TRACK_OTHER             = 1089 # Variable c_int
MCI_WAVE_PCM                    = 1152 # Variable c_int
MCI_WAVE_OFFSET                 = 1152 # Variable c_int
MCI_WAVE_MAPPER                 = 1153 # Variable c_int
MCI_SEQ_OFFSET                  = 1216 # Variable c_int
MCI_SEQ_DIV_PPQN                = 1216 # Variable c_int
MCI_SEQ_DIV_SMPTE_24            = 1217 # Variable c_int
MCI_SEQ_DIV_SMPTE_25            = 1218 # Variable c_int
MCI_SEQ_DIV_SMPTE_30DROP        = 1219 # Variable c_int
MCI_SEQ_DIV_SMPTE_30            = 1220 # Variable c_int
MCI_SET_AUDIO                   = 2048 # Variable c_long
MCI_SYSINFO_INSTALLNAME         = 2048 # Variable c_long
MCI_INFO_MEDIA_IDENTITY         = 2048 # Variable c_long
MCI_OPEN_ELEMENT_ID             = 2048 # Variable c_long
MCI_OPEN                        = 2051 # Variable c_int
MCI_CLOSE                       = 2052 # Variable c_int
MCI_ESCAPE                      = 2053 # Variable c_int
MCI_PLAY                        = 2054 # Variable c_int
MCI_SEEK                        = 2055 # Variable c_int
MCI_STOP                        = 2056 # Variable c_int
MCI_PAUSE                       = 2057 # Variable c_int
MCI_INFO                        = 2058 # Variable c_int
MCI_GETDEVCAPS                  = 2059 # Variable c_int
MCI_SPIN                        = 2060 # Variable c_int
MCI_SET                         = 2061 # Variable c_int
MCI_STEP                        = 2062 # Variable c_int
MCI_RECORD                      = 2063 # Variable c_int
MCI_SYSINFO                     = 2064 # Variable c_int
MCI_BREAK                       = 2065 # Variable c_int
MCI_SAVE                        = 2067 # Variable c_int
MCI_STATUS                      = 2068 # Variable c_int
MCI_CUE                         = 2096 # Variable c_int
MCI_REALIZE                     = 2112 # Variable c_int
MCI_WINDOW                      = 2113 # Variable c_int
MCI_PUT                         = 2114 # Variable c_int
MCI_WHERE                       = 2115 # Variable c_int
MCI_FREEZE                      = 2116 # Variable c_int
MCI_UNFREEZE                    = 2117 # Variable c_int
MCI_LOAD                        = 2128 # Variable c_int
MCI_CUT                         = 2129 # Variable c_int
MCI_COPY                        = 2130 # Variable c_int
MCI_PASTE                       = 2131 # Variable c_int
MCI_UPDATE                      = 2132 # Variable c_int
MCI_RESUME                      = 2133 # Variable c_int
MCI_DELETE                      = 2134 # Variable c_int
MCI_USER_MESSAGES               = 3072 # Variable c_int
MCI_LAST                        = 4095 # Variable c_int
MCI_DEVTYPE_FIRST_USER          = 4096 # Variable c_int
MCI_SET_VIDEO                   = 4096 # Variable c_long
MCI_INFO_NAME                   = 4096 # Variable c_long
MCI_OPEN_TYPE_ID                = 4096 # Variable c_long
MCI_SET_ON                      = 8192 # Variable c_long
MCI_OPEN_TYPE                   = 8192 # Variable c_long
MCI_INFO_COPYRIGHT              = 8192 # Variable c_long
MCI_SET_OFF                     = 16384 # Variable c_long
MCI_VD_FORMAT_TRACK             = 16385 # Variable c_int
MCI_SEQ_FORMAT_SONGPTR          = 16385 # Variable c_int
MCI_ANIM_STATUS_SPEED           = 16385 # Variable c_long
MCI_OVLY_GETDEVCAPS_CAN_STRETCH = 16385 # Variable c_long
MCI_WAVE_STATUS_FORMATTAG       = 16385 # Variable c_long
MCI_ANIM_GETDEVCAPS_CAN_REVERSE = 16385 # Variable c_long
MCI_WAVE_GETDEVCAPS_INPUTS      = 16385 # Variable c_long
MCI_CDA_STATUS_TYPE_TRACK       = 16385 # Variable c_long
MCI_OVLY_STATUS_HWND            = 16385 # Variable c_long
MCI_SEQ_FILE                    = 16386 # Variable c_int
MCI_SEQ_STATUS_TEMPO            = 16386 # Variable c_long
MCI_WAVE_STATUS_CHANNELS        = 16386 # Variable c_long
MCI_ANIM_GETDEVCAPS_FAST_RATE   = 16386 # Variable c_long
MCI_OVLY_GETDEVCAPS_CAN_FREEZE  = 16386 # Variable c_long
MCI_OVLY_STATUS_STRETCH         = 16386 # Variable c_long
MCI_VD_GETDEVCAPS_CAN_REVERSE   = 16386 # Variable c_long
MCI_VD_STATUS_SPEED             = 16386 # Variable c_long
MCI_WAVE_GETDEVCAPS_OUTPUTS     = 16386 # Variable c_long
MCI_ANIM_STATUS_FORWARD         = 16386 # Variable c_long
MCI_SEQ_MIDI                    = 16387 # Variable c_int
MCI_VD_GETDEVCAPS_FAST_RATE     = 16387 # Variable c_long
MCI_WAVE_STATUS_SAMPLESPERSEC   = 16387 # Variable c_long
MCI_VD_STATUS_FORWARD           = 16387 # Variable c_long
MCI_ANIM_GETDEVCAPS_SLOW_RATE   = 16387 # Variable c_long
MCI_OVLY_GETDEVCAPS_MAX_WINDOWS = 16387 # Variable c_long
MCI_SEQ_STATUS_PORT             = 16387 # Variable c_long
MCI_ANIM_STATUS_HWND            = 16387 # Variable c_long
MCI_SEQ_SMPTE                   = 16388 # Variable c_int
MCI_ANIM_GETDEVCAPS_NORMAL_RATE = 16388 # Variable c_long
MCI_VD_STATUS_MEDIA_TYPE        = 16388 # Variable c_long
MCI_ANIM_STATUS_HPAL            = 16388 # Variable c_long
MCI_WAVE_STATUS_AVGBYTESPERSEC  = 16388 # Variable c_long
MCI_VD_GETDEVCAPS_SLOW_RATE     = 16388 # Variable c_long
MCI_VD_GETDEVCAPS_NORMAL_RATE   = 16389 # Variable c_long
MCI_ANIM_STATUS_STRETCH         = 16389 # Variable c_long
MCI_WAVE_STATUS_BLOCKALIGN      = 16389 # Variable c_long
MCI_VD_STATUS_SIDE              = 16389 # Variable c_long
MCI_WAVE_STATUS_BITSPERSAMPLE   = 16390 # Variable c_long
MCI_VD_STATUS_DISC_SIZE         = 16390 # Variable c_long
MCI_ANIM_GETDEVCAPS_PALETTES    = 16390 # Variable c_long
MCI_ANIM_GETDEVCAPS_CAN_STRETCH = 16391 # Variable c_long
MCI_SEQ_STATUS_SLAVE            = 16391 # Variable c_long
MCI_WAVE_STATUS_LEVEL           = 16391 # Variable c_long
MCI_SEQ_STATUS_MASTER           = 16392 # Variable c_long
MCI_ANIM_GETDEVCAPS_MAX_WINDOWS = 16392 # Variable c_long
MCI_SEQ_STATUS_OFFSET           = 16393 # Variable c_long
MCI_SEQ_STATUS_DIVTYPE          = 16394 # Variable c_long
MCI_SEQ_STATUS_NAME             = 16395 # Variable c_long
MCI_SEQ_STATUS_COPYRIGHT        = 16396 # Variable c_long
MCI_SEQ_NONE                    = 65533 # Variable c_int
MCI_SEQ_MAPPER                  = 65535 # Variable c_int
MCI_WAVE_SET_FORMATTAG          = 65536 # Variable c_long
MCI_VD_SPIN_UP                  = 65536 # Variable c_long
MCI_SEQ_SET_TEMPO               = 65536 # Variable c_long
MCI_VD_SEEK_REVERSE             = 65536 # Variable c_long
MCI_OVLY_WINDOW_HWND            = 65536 # Variable c_long
MCI_ANIM_OPEN_WS                = 65536 # Variable c_long
MCI_ANIM_PLAY_SPEED             = 65536 # Variable c_long
MCI_ANIM_WINDOW_HWND            = 65536 # Variable c_long
MCI_ANIM_RECT                   = 65536 # Variable c_long
MCI_OVLY_RECT                   = 65536 # Variable c_long
MCI_ANIM_REALIZE_NORM           = 65536 # Variable c_long
MCI_VD_PLAY_REVERSE             = 65536 # Variable c_long
MCI_OVLY_INFO_TEXT              = 65536 # Variable c_long
MCI_ANIM_INFO_TEXT              = 65536 # Variable c_long
MCI_VD_GETDEVCAPS_CLV           = 65536 # Variable c_long
MCI_VD_STEP_FRAMES              = 65536 # Variable c_long
MCI_ANIM_STEP_REVERSE           = 65536 # Variable c_long
MCI_OVLY_OPEN_WS                = 65536 # Variable c_long
MCI_WAVE_OPEN_BUFFER            = 65536 # Variable c_long
MCI_VD_PLAY_FAST                = 131072 # Variable c_long
MCI_VD_GETDEVCAPS_CAV           = 131072 # Variable c_long
MCI_OVLY_WHERE_SOURCE           = 131072 # Variable c_long
MCI_ANIM_OPEN_PARENT            = 131072 # Variable c_long
MCI_VD_STEP_REVERSE             = 131072 # Variable c_long
MCI_SEQ_SET_PORT                = 131072 # Variable c_long
MCI_VD_SPIN_DOWN                = 131072 # Variable c_long
MCI_ANIM_UPDATE_HDC             = 131072 # Variable c_long
MCI_ANIM_PUT_SOURCE             = 131072 # Variable c_long
MCI_OVLY_PUT_SOURCE             = 131072 # Variable c_long
MCI_OVLY_OPEN_PARENT            = 131072 # Variable c_long
MCI_ANIM_REALIZE_BKGD           = 131072 # Variable c_long
MCI_ANIM_PLAY_REVERSE           = 131072 # Variable c_long
MCI_ANIM_STEP_FRAMES            = 131072 # Variable c_long
MCI_ANIM_WHERE_SOURCE           = 131072 # Variable c_long
MCI_WAVE_SET_CHANNELS           = 131072 # Variable c_long
MCI_ANIM_PLAY_FAST              = 262144 # Variable c_long
MCI_OVLY_WINDOW_STATE           = 262144 # Variable c_long
MCI_OVLY_WHERE_DESTINATION      = 262144 # Variable c_long
MCI_OVLY_PUT_DESTINATION        = 262144 # Variable c_long
MCI_WAVE_SET_SAMPLESPERSEC      = 262144 # Variable c_long
MCI_SEQ_SET_SLAVE               = 262144 # Variable c_long
MCI_ANIM_PUT_DESTINATION        = 262144 # Variable c_long
MCI_ANIM_WINDOW_STATE           = 262144 # Variable c_long
MCI_ANIM_WHERE_DESTINATION      = 262144 # Variable c_long
MCI_ANIM_OPEN_NOSTATIC          = 262144 # Variable c_long
MCI_VD_PLAY_SPEED               = 262144 # Variable c_long
MCI_WAVE_SET_AVGBYTESPERSEC     = 524288 # Variable c_long
MCI_OVLY_WHERE_FRAME            = 524288 # Variable c_long
MCI_ANIM_WINDOW_TEXT            = 524288 # Variable c_long
MCI_OVLY_PUT_FRAME              = 524288 # Variable c_long
MCI_SEQ_SET_MASTER              = 524288 # Variable c_long
MCI_OVLY_WINDOW_TEXT            = 524288 # Variable c_long
MCI_VD_PLAY_SCAN                = 524288 # Variable c_long
MCI_ANIM_PLAY_SLOW              = 524288 # Variable c_long
MCI_OVLY_WHERE_VIDEO            = 1048576 # Variable c_long
MCI_WAVE_SET_BLOCKALIGN         = 1048576 # Variable c_long
MCI_VD_PLAY_SLOW                = 1048576 # Variable c_long
MCI_OVLY_PUT_VIDEO              = 1048576 # Variable c_long
MCI_OVLY_WINDOW_ENABLE_STRETCH  = 1048576 # Variable c_long
MCI_ANIM_WINDOW_ENABLE_STRETCH  = 1048576 # Variable c_long
MCI_ANIM_PLAY_SCAN              = 1048576 # Variable c_long
MCI_ANIM_WINDOW_DISABLE_STRETCH = 2097152 # Variable c_long
MCI_WAVE_SET_BITSPERSAMPLE      = 2097152 # Variable c_long
MCI_OVLY_WINDOW_DISABLE_STRETCH = 2097152 # Variable c_long
MCI_WAVE_INPUT                  = 4194304 # Variable c_long
MCI_WAVE_OUTPUT                 = 8388608 # Variable c_long
MCI_SEQ_SET_OFFSET              = 16777216 # Variable c_long
MCI_WAVE_SET_ANYINPUT           = 67108864 # Variable c_long
MCI_WAVE_SET_ANYOUTPUT          = 134217728 # Variable c_long
MCI_ALL_DEVICE_ID               = 4294967295 # Variable c_uint

MCMV_MONTH   = 0
MCMV_YEAR    = 1
MCMV_DECADE  = 2
MCMV_CENTURY = 3

MCM_FIRST             = 4096 # Variable c_int
MCM_GETCURSEL         = 4097 # Variable c_int
MCM_SETCURSEL         = 4098 # Variable c_int
MCM_GETMAXSELCOUNT    = 4099 # Variable c_int
MCM_SETMAXSELCOUNT    = 4100 # Variable c_int
MCM_GETSELRANGE       = 4101 # Variable c_int
MCM_SETSELRANGE       = 4102 # Variable c_int
MCM_GETMONTHRANGE     = 4103 # Variable c_int
MCM_SETDAYSTATE       = 4104 # Variable c_int
MCM_GETMINREQRECT     = 4105 # Variable c_int
MCM_SETCOLOR          = 4106 # Variable c_int
MCM_GETCOLOR          = 4107 # Variable c_int
MCM_SETTODAY          = 4108 # Variable c_int
MCM_GETTODAY          = 4109 # Variable c_int
MCM_HITTEST           = 4110 # Variable c_int
MCM_SETFIRSTDAYOFWEEK = 4111 # Variable c_int
MCM_GETFIRSTDAYOFWEEK = 4112 # Variable c_int
MCM_GETRANGE          = 4113 # Variable c_int
MCM_SETRANGE          = 4114 # Variable c_int
MCM_GETMONTHDELTA     = 4115 # Variable c_int
MCM_SETMONTHDELTA     = 4116 # Variable c_int
MCM_GETMAXTODAYWIDTH  = 4117 # Variable c_int
MCM_GETCURRENTVIEW    = 4118
MCM_GETCALENDARCOUNT  = 4119
MCM_GETCALID          = 4121 # Variable. c_int
MCM_SETCALID          = 4122 # Variable c_int
MCM_SIZERECTTOMIN     = 4125
MCM_SETCALENDARBORDER = 4126 # Variable c_int
MCM_GETCALENDARBORDER = 4127 # Variable c_int
MCM_SETCURRENTVIEW    = 4128

MCN_LAST        = 4294966537 # Variable c_uint
MCN_FIRST       = 4294966546 # Variable c_uint
MCN_SELCHANGE   = 4294966547 # Variable c_uint
MCN_GETDAYSTATE = 4294966549 # Variable c_uint
MCN_SELECT      = 4294966550 # Variable c_uint

MCSC_BACKGROUND   = 0 # Variable c_int
MCSC_TEXT         = 1 # Variable c_int
MCSC_TITLEBK      = 2 # Variable c_int
MCSC_TITLETEXT    = 3 # Variable c_int
MCSC_MONTHBK      = 4 # Variable c_int
MCSC_TRAILINGTEXT = 5 # Variable c_int

MCS_DAYSTATE      = 1 # Variable c_int
MCS_MULTISELECT   = 2 # Variable c_int
MCS_WEEKNUMBERS   = 4 # Variable c_int
MCS_NOTODAYCIRCLE = 8 # Variable c_int
MCS_NOTODAY       = 16 # Variable c_int

MDIS_ALLCHILDSTYLES = win32con.MDIS_ALLCHILDSTYLES # 1

MDITILE_VERTICAL     = win32con.MDITILE_VERTICAL # 0
MDITILE_HORIZONTAL   = win32con.MDITILE_HORIZONTAL # 1
MDITILE_SKIPDISABLED = win32con.MDITILE_SKIPDISABLED # 2

MDMSPKRFLAG_OFF       = 1 # Variable c_int
MDMSPKRFLAG_DIAL      = 2 # Variable c_int
MDMSPKRFLAG_ON        = 4 # Variable c_int
MDMSPKRFLAG_CALLSETUP = 8 # Variable c_int

MDMSPKR_OFF       = 0 # Variable c_int
MDMSPKR_DIAL      = 1 # Variable c_int
MDMSPKR_ON        = 2 # Variable c_int
MDMSPKR_CALLSETUP = 3 # Variable c_int

MDMVOLFLAG_LOW    = 1 # Variable c_int
MDMVOLFLAG_MEDIUM = 2 # Variable c_int
MDMVOLFLAG_HIGH   = 4 # Variable c_int

MDMVOL_LOW    = 0 # Variable c_int
MDMVOL_MEDIUM = 1 # Variable c_int
MDMVOL_HIGH   = 2 # Variable c_int

MDM_COMPRESSION      = 1 # Variable c_int
MDM_ERROR_CONTROL    = 2 # Variable c_int
MDM_FORCED_EC        = 4 # Variable c_int
MDM_CELLULAR         = 8 # Variable c_int
MDM_FLOWCONTROL_HARD = 16 # Variable c_int
MDM_FLOWCONTROL_SOFT = 32 # Variable c_int
MDM_CCITT_OVERRIDE   = 64 # Variable c_int
MDM_SPEED_ADJUST     = 128 # Variable c_int
MDM_TONE_DIAL        = 256 # Variable c_int
MDM_BLIND_DIAL       = 512 # Variable c_int
MDM_V23_OVERRIDE     = 1024 # Variable c_int

MEMCTX_TASK      = 1
MEMCTX_SHARED    = 2
MEMCTX_MACSYSTEM = 3
MEMCTX_UNKNOWN   = -1
MEMCTX_SAME      = -2

MEM_COMMIT         = win32con.MEM_COMMIT # 4096
MEM_RESERVE        = win32con.MEM_RESERVE # 8192
MEM_DECOMMIT       = win32con.MEM_DECOMMIT # 16384
MEM_RELEASE        = win32con.MEM_RELEASE # 32768
MEM_FREE           = win32con.MEM_FREE # 65536
MEM_PRIVATE        = win32con.MEM_PRIVATE # 131072
MEM_MAPPED         = win32con.MEM_MAPPED # 262144
MEM_RESET          = 524288 # Variable c_int
MEM_TOP_DOWN       = win32con.MEM_TOP_DOWN # 1048576
MEM_4MB_PAGES      = 2147483648 # Variable c_uint
MEM_E_INVALID_SIZE = -2146959343 # Variable c_long
MEM_E_INVALID_LINK = -2146959344 # Variable c_long
MEM_E_INVALID_ROOT = -2146959351 # Variable c_long

MENU_EVENT = 8 # Variable c_int

MESSAGE_RESOURCE_UNICODE = win32con.MESSAGE_RESOURCE_UNICODE # 1

META_SAVEDC                = win32con.META_SAVEDC # 30
META_REALIZEPALETTE        = win32con.META_REALIZEPALETTE # 53
META_SETPALENTRIES         = win32con.META_SETPALENTRIES # 55
META_CREATEPALETTE         = win32con.META_CREATEPALETTE # 247
META_SETBKMODE             = win32con.META_SETBKMODE # 258
META_SETMAPMODE            = win32con.META_SETMAPMODE # 259
META_SETROP2               = win32con.META_SETROP2 # 260
META_SETRELABS             = win32con.META_SETRELABS # 261
META_SETPOLYFILLMODE       = win32con.META_SETPOLYFILLMODE # 262
META_SETSTRETCHBLTMODE     = win32con.META_SETSTRETCHBLTMODE # 263
META_SETTEXTCHAREXTRA      = win32con.META_SETTEXTCHAREXTRA # 264
META_RESTOREDC             = win32con.META_RESTOREDC # 295
META_INVERTREGION          = win32con.META_INVERTREGION # 298
META_PAINTREGION           = win32con.META_PAINTREGION # 299
META_SELECTCLIPREGION      = win32con.META_SELECTCLIPREGION # 300
META_SELECTOBJECT          = win32con.META_SELECTOBJECT # 301
META_SETTEXTALIGN          = win32con.META_SETTEXTALIGN # 302
META_RESIZEPALETTE         = win32con.META_RESIZEPALETTE # 313
META_DIBCREATEPATTERNBRUSH = win32con.META_DIBCREATEPATTERNBRUSH # 322
META_DELETEOBJECT          = win32con.META_DELETEOBJECT # 496
META_CREATEPATTERNBRUSH    = win32con.META_CREATEPATTERNBRUSH # 505
META_SETBKCOLOR            = win32con.META_SETBKCOLOR # 513
META_SETTEXTCOLOR          = win32con.META_SETTEXTCOLOR # 521
META_SETTEXTJUSTIFICATION  = win32con.META_SETTEXTJUSTIFICATION # 522
META_SETWINDOWORG          = win32con.META_SETWINDOWORG # 523
META_SETWINDOWEXT          = win32con.META_SETWINDOWEXT # 524
META_SETVIEWPORTORG        = win32con.META_SETVIEWPORTORG # 525
META_SETVIEWPORTEXT        = win32con.META_SETVIEWPORTEXT # 526
META_OFFSETWINDOWORG       = win32con.META_OFFSETWINDOWORG # 527
META_OFFSETVIEWPORTORG     = win32con.META_OFFSETVIEWPORTORG # 529
META_LINETO                = win32con.META_LINETO # 531
META_MOVETO                = win32con.META_MOVETO # 532
META_OFFSETCLIPRGN         = win32con.META_OFFSETCLIPRGN # 544
META_FILLREGION            = win32con.META_FILLREGION # 552
META_SETMAPPERFLAGS        = win32con.META_SETMAPPERFLAGS # 561
META_SELECTPALETTE         = win32con.META_SELECTPALETTE # 564
META_CREATEPENINDIRECT     = win32con.META_CREATEPENINDIRECT # 762
META_CREATEFONTINDIRECT    = win32con.META_CREATEFONTINDIRECT # 763
META_CREATEBRUSHINDIRECT   = win32con.META_CREATEBRUSHINDIRECT # 764
META_POLYGON               = win32con.META_POLYGON # 804
META_POLYLINE              = win32con.META_POLYLINE # 805
META_SCALEWINDOWEXT        = win32con.META_SCALEWINDOWEXT # 1040
META_SCALEVIEWPORTEXT      = win32con.META_SCALEVIEWPORTEXT # 1042
META_EXCLUDECLIPRECT       = win32con.META_EXCLUDECLIPRECT # 1045
META_INTERSECTCLIPRECT     = win32con.META_INTERSECTCLIPRECT # 1046
META_ELLIPSE               = win32con.META_ELLIPSE # 1048
META_FLOODFILL             = win32con.META_FLOODFILL # 1049
META_RECTANGLE             = win32con.META_RECTANGLE # 1051
META_SETPIXEL              = win32con.META_SETPIXEL # 1055
META_FRAMEREGION           = win32con.META_FRAMEREGION # 1065
META_ANIMATEPALETTE        = win32con.META_ANIMATEPALETTE # 1078
META_TEXTOUT               = win32con.META_TEXTOUT # 1313
META_POLYPOLYGON           = win32con.META_POLYPOLYGON # 1336
META_EXTFLOODFILL          = win32con.META_EXTFLOODFILL # 1352
META_ROUNDRECT             = win32con.META_ROUNDRECT # 1564
META_PATBLT                = win32con.META_PATBLT # 1565
META_ESCAPE                = win32con.META_ESCAPE # 1574
META_CREATEREGION          = win32con.META_CREATEREGION # 1791
META_ARC                   = win32con.META_ARC # 2071
META_PIE                   = win32con.META_PIE # 2074
META_CHORD                 = win32con.META_CHORD # 2096
META_BITBLT                = win32con.META_BITBLT # 2338
META_DIBBITBLT             = win32con.META_DIBBITBLT # 2368
META_EXTTEXTOUT            = win32con.META_EXTTEXTOUT # 2610
META_STRETCHBLT            = win32con.META_STRETCHBLT # 2851
META_DIBSTRETCHBLT         = win32con.META_DIBSTRETCHBLT # 2881
META_SETDIBTODEV           = win32con.META_SETDIBTODEV # 3379
META_STRETCHDIB            = win32con.META_STRETCHDIB # 3907

METRICS_USEDEFAULT = win32con.METRICS_USEDEFAULT # -1

MEVT_F_SHORT    = 0 # Variable c_long
MEVT_SHORTMSG   = 0 # Variable c_ubyte
MEVT_TEMPO      = 1 # Variable c_ubyte
MEVT_NOP        = 2 # Variable c_ubyte
MEVT_LONGMSG    = 128 # Variable c_ubyte
MEVT_COMMENT    = 130 # Variable c_ubyte
MEVT_VERSION    = 132 # Variable c_ubyte
MEVT_F_CALLBACK = 1073741824 # Variable c_long
MEVT_F_LONG     = 2147483648 # Variable c_ulong

MFS_GRAYED = win32con.MFS_GRAYED # 3

MFT_RADIOCHECK = win32con.MFT_RADIOCHECK # 512
MFT_RIGHTORDER = win32con.MFT_RIGHTORDER # 8192

MF_INSERT          = win32con.MF_INSERT # 0
MF_BYCOMMAND       = win32con.MF_BYCOMMAND # 0
MF_UNCHECKED       = win32con.MF_UNCHECKED # 0
MF_STRING          = win32con.MF_STRING # 0
MF_UNHILITE        = win32con.MF_UNHILITE # 0
MF_ENABLED         = win32con.MF_ENABLED # 0
MF_GRAYED          = win32con.MF_GRAYED # 1
MF_DISABLED        = win32con.MF_DISABLED # 2
MF_BITMAP          = win32con.MF_BITMAP # 4
MF_CHECKED         = win32con.MF_CHECKED # 8
MF_POPUP           = win32con.MF_POPUP # 16
MF_MENUBARBREAK    = win32con.MF_MENUBARBREAK # 32
MF_MENUBREAK       = win32con.MF_MENUBREAK # 64
MF_HILITE          = win32con.MF_HILITE # 128
MF_END             = win32con.MF_END # 128
MF_CHANGE          = win32con.MF_CHANGE # 128
MF_OWNERDRAW       = win32con.MF_OWNERDRAW # 256
MF_APPEND          = win32con.MF_APPEND # 256
MF_DELETE          = win32con.MF_DELETE # 512
MF_USECHECKBITMAPS = win32con.MF_USECHECKBITMAPS # 512
MF_BYPOSITION      = win32con.MF_BYPOSITION # 1024
MF_SEPARATOR       = win32con.MF_SEPARATOR # 2048
MF_DEFAULT         = win32con.MF_DEFAULT # 4096
MF_REMOVE          = win32con.MF_REMOVE # 4096
MF_SYSMENU         = win32con.MF_SYSMENU # 8192
MF_HELP            = win32con.MF_HELP # 16384
MF_RIGHTJUSTIFY    = win32con.MF_RIGHTJUSTIFY # 16384
MF_MOUSESELECT     = win32con.MF_MOUSESELECT # 32768
MF_HSZ_INFO        = 16777216 # Variable c_int
MF_SENDMSGS        = 33554432 # Variable c_int
MF_POSTMSGS        = 67108864 # Variable c_int
MF_CALLBACKS       = 134217728 # Variable c_int
MF_ERRORS          = 268435456 # Variable c_int
MF_LINKS           = 536870912 # Variable c_int
MF_CONV            = 1073741824 # Variable c_int
MF_MASK            = 4278190080 # Variable c_uint

MHDR_DONE     = 1 # Variable c_int
MHDR_PREPARED = 2 # Variable c_int
MHDR_INQUEUE  = 4 # Variable c_int
MHDR_ISSTRM   = 8 # Variable c_int

MH_CREATE  = 1 # Variable c_int
MH_KEEP    = 2 # Variable c_int
MH_DELETE  = 3 # Variable c_int
MH_CLEANUP = 4 # Variable c_int

MIDICAPS_VOLUME   = 1 # Variable c_int
MIDICAPS_LRVOLUME = 2 # Variable c_int
MIDICAPS_CACHE    = 4 # Variable c_int
MIDICAPS_STREAM   = 8 # Variable c_int

MIDIERR_UNPREPARED    = 64 # Variable c_int
MIDIERR_BASE          = 64 # Variable c_int
MIDIERR_STILLPLAYING  = 65 # Variable c_int
MIDIERR_NOMAP         = 66 # Variable c_int
MIDIERR_NOTREADY      = 67 # Variable c_int
MIDIERR_NODEVICE      = 68 # Variable c_int
MIDIERR_INVALIDSETUP  = 69 # Variable c_int
MIDIERR_BADOPENMODE   = 70 # Variable c_int
MIDIERR_DONT_CONTINUE = 71 # Variable c_int
MIDIERR_LASTERROR     = 71 # Variable c_int

MIDIPROP_TIMEDIV = 1 # Variable c_long
MIDIPROP_TEMPO   = 2 # Variable c_long
MIDIPROP_GET     = 1073741824 # Variable c_long
MIDIPROP_SET     = 2147483648 # Variable c_ulong

MIDISTRM_ERROR = -2 # Variable c_int

MIDI_CACHE_ALL     = 1 # Variable c_int
MIDI_CACHE_BESTFIT = 2 # Variable c_int
MIDI_CACHE_QUERY   = 3 # Variable c_int
MIDI_UNCACHE       = 4 # Variable c_int
MIDI_IO_STATUS     = 32 # Variable c_long
MIDI_MAPPER        = 4294967295 # Variable c_uint

MIIM_STATE      = win32con.MIIM_STATE # 1
MIIM_ID         = win32con.MIIM_ID # 2
MIIM_SUBMENU    = win32con.MIIM_SUBMENU # 4
MIIM_CHECKMARKS = win32con.MIIM_CHECKMARKS # 8
MIIM_TYPE       = win32con.MIIM_TYPE # 16
MIIM_DATA       = win32con.MIIM_DATA # 32
MIIM_STRING     = win32con.MIIM_STRING # 64
MIIM_BITMAP     = win32con.MIIM_BITMAP # 128
MIIM_FTYPE      = win32con.MIIM_FTYPE # 256

MIM_MAXHEIGHT       = win32con.MIM_MAXHEIGHT # 1
MIM_BACKGROUND      = win32con.MIM_BACKGROUND # 2
MIM_HELPID          = win32con.MIM_HELPID # 4
MIM_MENUDATA        = win32con.MIM_MENUDATA # 8
MIM_STYLE           = win32con.MIM_STYLE # 16
MIM_APPLYTOSUBMENUS = win32con.MIM_APPLYTOSUBMENUS # -2147483648

MINHALF_PTR = 32768 # Variable c_int

MININT_PTR = 2147483648 # Variable c_ulong

MIN_PRIORITY = 1 # Variable c_int

MIXERCONTROL_CONTROLTYPE_CUSTOM         = 0 # Variable c_long
MIXERCONTROL_CT_SC_TIME_MICROSECS       = 0 # Variable c_long
MIXERCONTROL_CT_SC_LIST_SINGLE          = 0 # Variable c_long
MIXERCONTROL_CT_UNITS_CUSTOM            = 0 # Variable c_long
MIXERCONTROL_CT_SC_METER_POLLED         = 0 # Variable c_long
MIXERCONTROL_CT_SC_SWITCH_BOOLEAN       = 0 # Variable c_long
MIXERCONTROL_CT_CLASS_CUSTOM            = 0 # Variable c_long
MIXERCONTROL_CONTROLF_UNIFORM           = 1 # Variable c_long
MIXERCONTROL_CONTROLF_MULTIPLE          = 2 # Variable c_long
MIXERCONTROL_CT_UNITS_BOOLEAN           = 65536 # Variable c_long
MIXERCONTROL_CT_UNITS_SIGNED            = 131072 # Variable c_long
MIXERCONTROL_CT_UNITS_UNSIGNED          = 196608 # Variable c_long
MIXERCONTROL_CT_UNITS_DECIBELS          = 262144 # Variable c_long
MIXERCONTROL_CT_UNITS_PERCENT           = 327680 # Variable c_long
MIXERCONTROL_CT_UNITS_MASK              = 16711680 # Variable c_long
MIXERCONTROL_CT_SC_LIST_MULTIPLE        = 16777216 # Variable c_long
MIXERCONTROL_CT_SC_SWITCH_BUTTON        = 16777216 # Variable c_long
MIXERCONTROL_CT_SC_TIME_MILLISECS       = 16777216 # Variable c_long
MIXERCONTROL_CT_SUBCLASS_MASK           = 251658240 # Variable c_long
MIXERCONTROL_CT_CLASS_METER             = 268435456 # Variable c_long
MIXERCONTROL_CONTROLTYPE_BOOLEANMETER   = 268500992 # Variable c_long
MIXERCONTROL_CONTROLTYPE_SIGNEDMETER    = 268566528 # Variable c_long
MIXERCONTROL_CONTROLTYPE_PEAKMETER      = 268566529 # Variable c_long
MIXERCONTROL_CONTROLTYPE_UNSIGNEDMETER  = 268632064 # Variable c_long
MIXERCONTROL_CT_CLASS_SWITCH            = 536870912 # Variable c_long
MIXERCONTROL_CONTROLTYPE_BOOLEAN        = 536936448 # Variable c_long
MIXERCONTROL_CONTROLTYPE_ONOFF          = 536936449 # Variable c_long
MIXERCONTROL_CONTROLTYPE_MUTE           = 536936450 # Variable c_long
MIXERCONTROL_CONTROLTYPE_MONO           = 536936451 # Variable c_long
MIXERCONTROL_CONTROLTYPE_LOUDNESS       = 536936452 # Variable c_long
MIXERCONTROL_CONTROLTYPE_STEREOENH      = 536936453 # Variable c_long
MIXERCONTROL_CONTROLTYPE_BUTTON         = 553713664 # Variable c_long
MIXERCONTROL_CT_CLASS_NUMBER            = 805306368 # Variable c_long
MIXERCONTROL_CONTROLTYPE_SIGNED         = 805437440 # Variable c_long
MIXERCONTROL_CONTROLTYPE_UNSIGNED       = 805502976 # Variable c_long
MIXERCONTROL_CONTROLTYPE_DECIBELS       = 805568512 # Variable c_long
MIXERCONTROL_CONTROLTYPE_PERCENT        = 805634048 # Variable c_long
MIXERCONTROL_CT_CLASS_SLIDER            = 1073741824 # Variable c_long
MIXERCONTROL_CONTROLTYPE_SLIDER         = 1073872896 # Variable c_long
MIXERCONTROL_CONTROLTYPE_PAN            = 1073872897 # Variable c_long
MIXERCONTROL_CONTROLTYPE_QSOUNDPAN      = 1073872898 # Variable c_long
MIXERCONTROL_CT_CLASS_FADER             = 1342177280 # Variable c_long
MIXERCONTROL_CONTROLTYPE_FADER          = 1342373888 # Variable c_long
MIXERCONTROL_CONTROLTYPE_VOLUME         = 1342373889 # Variable c_long
MIXERCONTROL_CONTROLTYPE_BASS           = 1342373890 # Variable c_long
MIXERCONTROL_CONTROLTYPE_TREBLE         = 1342373891 # Variable c_long
MIXERCONTROL_CONTROLTYPE_EQUALIZER      = 1342373892 # Variable c_long
MIXERCONTROL_CT_CLASS_TIME              = 1610612736 # Variable c_long
MIXERCONTROL_CONTROLTYPE_MICROTIME      = 1610809344 # Variable c_long
MIXERCONTROL_CONTROLTYPE_MILLITIME      = 1627586560 # Variable c_long
MIXERCONTROL_CT_CLASS_LIST              = 1879048192 # Variable c_long
MIXERCONTROL_CONTROLTYPE_SINGLESELECT   = 1879113728 # Variable c_long
MIXERCONTROL_CONTROLTYPE_MUX            = 1879113729 # Variable c_long
MIXERCONTROL_CONTROLTYPE_MULTIPLESELECT = 1895890944 # Variable c_long
MIXERCONTROL_CONTROLTYPE_MIXER          = 1895890945 # Variable c_long
MIXERCONTROL_CONTROLF_DISABLED          = 2147483648 # Variable c_ulong
MIXERCONTROL_CT_CLASS_MASK              = 4026531840 # Variable c_ulong

MIXERLINE_TARGETTYPE_UNDEFINED          = 0 # Variable c_int
MIXERLINE_COMPONENTTYPE_DST_UNDEFINED   = 0 # Variable c_long
MIXERLINE_COMPONENTTYPE_DST_FIRST       = 0 # Variable c_long
MIXERLINE_TARGETTYPE_WAVEOUT            = 1 # Variable c_int
MIXERLINE_COMPONENTTYPE_DST_DIGITAL     = 1 # Variable c_long
MIXERLINE_LINEF_ACTIVE                  = 1 # Variable c_long
MIXERLINE_TARGETTYPE_WAVEIN             = 2 # Variable c_int
MIXERLINE_COMPONENTTYPE_DST_LINE        = 2 # Variable c_long
MIXERLINE_TARGETTYPE_MIDIOUT            = 3 # Variable c_int
MIXERLINE_COMPONENTTYPE_DST_MONITOR     = 3 # Variable c_long
MIXERLINE_TARGETTYPE_MIDIIN             = 4 # Variable c_int
MIXERLINE_COMPONENTTYPE_DST_SPEAKERS    = 4 # Variable c_long
MIXERLINE_TARGETTYPE_AUX                = 5 # Variable c_int
MIXERLINE_COMPONENTTYPE_DST_HEADPHONES  = 5 # Variable c_long
MIXERLINE_COMPONENTTYPE_DST_TELEPHONE   = 6 # Variable c_long
MIXERLINE_COMPONENTTYPE_DST_WAVEIN      = 7 # Variable c_long
MIXERLINE_COMPONENTTYPE_DST_VOICEIN     = 8 # Variable c_long
MIXERLINE_COMPONENTTYPE_DST_LAST        = 8 # Variable c_long
MIXERLINE_COMPONENTTYPE_SRC_UNDEFINED   = 4096 # Variable c_long
MIXERLINE_COMPONENTTYPE_SRC_FIRST       = 4096 # Variable c_long
MIXERLINE_COMPONENTTYPE_SRC_DIGITAL     = 4097 # Variable c_long
MIXERLINE_COMPONENTTYPE_SRC_LINE        = 4098 # Variable c_long
MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE  = 4099 # Variable c_long
MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER = 4100 # Variable c_long
MIXERLINE_COMPONENTTYPE_SRC_COMPACTDISC = 4101 # Variable c_long
MIXERLINE_COMPONENTTYPE_SRC_TELEPHONE   = 4102 # Variable c_long
MIXERLINE_COMPONENTTYPE_SRC_PCSPEAKER   = 4103 # Variable c_long
MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT     = 4104 # Variable c_long
MIXERLINE_COMPONENTTYPE_SRC_AUXILIARY   = 4105 # Variable c_long
MIXERLINE_COMPONENTTYPE_SRC_LAST        = 4106 # Variable c_long
MIXERLINE_COMPONENTTYPE_SRC_ANALOG      = 4106 # Variable c_long
MIXERLINE_LINEF_DISCONNECTED            = 32768 # Variable c_long
MIXERLINE_LINEF_SOURCE                  = 2147483648 # Variable c_ulong

MIXERR_INVALLINE    = 1024 # Variable c_int
MIXERR_BASE         = 1024 # Variable c_int
MIXERR_INVALCONTROL = 1025 # Variable c_int
MIXERR_LASTERROR    = 1026 # Variable c_int
MIXERR_INVALVALUE   = 1026 # Variable c_int

MIXER_SETCONTROLDETAILSF_VALUE     = 0 # Variable c_long
MIXER_OBJECTF_MIXER                = 0 # Variable c_long
MIXER_GETLINEINFOF_DESTINATION     = 0 # Variable c_long
MIXER_GETCONTROLDETAILSF_VALUE     = 0 # Variable c_long
MIXER_GETLINECONTROLSF_ALL         = 0 # Variable c_long
MIXER_GETLINEINFOF_SOURCE          = 1 # Variable c_long
MIXER_GETCONTROLDETAILSF_LISTTEXT  = 1 # Variable c_long
MIXER_GETLINECONTROLSF_ONEBYID     = 1 # Variable c_long
MIXER_SETCONTROLDETAILSF_CUSTOM    = 1 # Variable c_long
MIXER_GETLINECONTROLSF_ONEBYTYPE   = 2 # Variable c_long
MIXER_GETLINEINFOF_LINEID          = 2 # Variable c_long
MIXER_GETLINEINFOF_COMPONENTTYPE   = 3 # Variable c_long
MIXER_GETLINEINFOF_TARGETTYPE      = 4 # Variable c_long
MIXER_GETLINEINFOF_QUERYMASK       = 15 # Variable c_long
MIXER_GETLINECONTROLSF_QUERYMASK   = 15 # Variable c_long
MIXER_SETCONTROLDETAILSF_QUERYMASK = 15 # Variable c_long
MIXER_GETCONTROLDETAILSF_QUERYMASK = 15 # Variable c_long
MIXER_SHORT_NAME_CHARS             = 16 # Variable c_int
MIXER_LONG_NAME_CHARS              = 64 # Variable c_int
MIXER_OBJECTF_WAVEOUT              = 268435456 # Variable c_long
MIXER_OBJECTF_WAVEIN               = 536870912 # Variable c_long
MIXER_OBJECTF_MIDIOUT              = 805306368 # Variable c_long
MIXER_OBJECTF_MIDIIN               = 1073741824 # Variable c_long
MIXER_OBJECTF_AUX                  = 1342177280 # Variable c_long
MIXER_OBJECTF_HANDLE               = 2147483648 # Variable c_ulong
MIXER_OBJECTF_HMIXER               = 2147483648 # Variable c_ulong
MIXER_OBJECTF_HWAVEOUT             = 2415919104 # Variable c_ulong
MIXER_OBJECTF_HWAVEIN              = 2684354560 # Variable c_ulong
MIXER_OBJECTF_HMIDIOUT             = 2952790016 # Variable c_ulong
MIXER_OBJECTF_HMIDIIN              = 3221225472 # Variable c_ulong

MKF_MOUSEKEYSON    = win32con.MKF_MOUSEKEYSON # 1
MKF_AVAILABLE      = win32con.MKF_AVAILABLE # 2
MKF_HOTKEYACTIVE   = win32con.MKF_HOTKEYACTIVE # 4
MKF_CONFIRMHOTKEY  = win32con.MKF_CONFIRMHOTKEY # 8
MKF_HOTKEYSOUND    = win32con.MKF_HOTKEYSOUND # 16
MKF_INDICATOR      = win32con.MKF_INDICATOR # 32
MKF_MODIFIERS      = win32con.MKF_MODIFIERS # 64
MKF_REPLACENUMBERS = win32con.MKF_REPLACENUMBERS # 128

MKRREDUCE_ALL         = 0
MKRREDUCE_THROUGHUSER = 65536
MKRREDUCE_TOUSER      = 131072
MKRREDUCE_ONE         = 196608

MKSYS_NONE             = 0
MKSYS_GENERICCOMPOSITE = 1
MKSYS_FILEMONIKER      = 2
MKSYS_ANTIMONIKER      = 3
MKSYS_ITEMMONIKER      = 4
MKSYS_POINTERMONIKER   = 5
MKSYS_URLMONIKER       = 6 # Variable c_int
MKSYS_CLASSMONIKER     = 7

MK_LBUTTON                             = win32con.MK_LBUTTON # 1
MK_RBUTTON                             = win32con.MK_RBUTTON # 2
MK_SHIFT                               = win32con.MK_SHIFT # 4
MK_CONTROL                             = win32con.MK_CONTROL # 8
MK_MBUTTON                             = win32con.MK_MBUTTON # 16
MK_ALT                                 = 32 # Variable c_int
MK_S_FIRST                             = 262624 # Variable c_long
MK_S_REDUCED_TO_SELF                   = 262626 # Variable c_long
MK_S_ME                                = 262628 # Variable c_long
MK_S_HIM                               = 262629 # Variable c_long
MK_S_US                                = 262630 # Variable c_long
MK_S_MONIKERALREADYREGISTERED          = 262631 # Variable c_long
MK_S_ASYNCHRONOUS                      = 262632 # Variable c_long
MK_S_LAST                              = 262639 # Variable c_long
MK_E_FIRST                             = 2147746272 # Variable c_ulong
MK_E_LAST                              = 2147746287 # Variable c_ulong
MK_E_NO_NORMALIZED                     = -2146959353 # Variable c_long
MK_E_ENUMERATION_FAILED                = -2147221009 # Variable c_long
MK_E_NOPREFIX                          = -2147221010 # Variable c_long
MK_E_NOSTORAGE                         = -2147221011 # Variable c_long
MK_E_NOINVERSE                         = -2147221012 # Variable c_long
MK_E_MUSTBOTHERUSER                    = -2147221013 # Variable c_long
MK_E_CANTOPENFILE                      = -2147221014 # Variable c_long
MK_E_NOTBOUND                          = -2147221015 # Variable c_long
MK_E_NOTBINDABLE                       = -2147221016 # Variable c_long
MK_E_INTERMEDIATEINTERFACENOTSUPPORTED = -2147221017 # Variable c_long
MK_E_INVALIDEXTENSION                  = -2147221018 # Variable c_long
MK_E_NOOBJECT                          = -2147221019 # Variable c_long
MK_E_SYNTAX                            = -2147221020 # Variable c_long
MK_E_UNAVAILABLE                       = -2147221021 # Variable c_long
MK_E_NEEDGENERIC                       = -2147221022 # Variable c_long
MK_E_EXCEEDEDDEADLINE                  = -2147221023 # Variable c_long
MK_E_CONNECTMANUALLY                   = -2147221024 # Variable c_long

MMIOERR_BASE             = 256 # Variable c_int
MMIOERR_FILENOTFOUND     = 257 # Variable c_int
MMIOERR_OUTOFMEMORY      = 258 # Variable c_int
MMIOERR_CANNOTOPEN       = 259 # Variable c_int
MMIOERR_CANNOTCLOSE      = 260 # Variable c_int
MMIOERR_CANNOTREAD       = 261 # Variable c_int
MMIOERR_CANNOTWRITE      = 262 # Variable c_int
MMIOERR_CANNOTSEEK       = 263 # Variable c_int
MMIOERR_CANNOTEXPAND     = 264 # Variable c_int
MMIOERR_CHUNKNOTFOUND    = 265 # Variable c_int
MMIOERR_UNBUFFERED       = 266 # Variable c_int
MMIOERR_PATHNOTFOUND     = 267 # Variable c_int
MMIOERR_ACCESSDENIED     = 268 # Variable c_int
MMIOERR_SHARINGVIOLATION = 269 # Variable c_int
MMIOERR_NETWORKERROR     = 270 # Variable c_int
MMIOERR_TOOMANYOPENFILES = 271 # Variable c_int
MMIOERR_INVALIDFILE      = 272 # Variable c_int

MMIOM_SEEK       = 2 # Variable c_int
MMIOM_OPEN       = 3 # Variable c_int
MMIOM_CLOSE      = 4 # Variable c_int
MMIOM_WRITEFLUSH = 5 # Variable c_int
MMIOM_RENAME     = 6 # Variable c_int
MMIOM_USER       = 32768 # Variable c_int

MMIO_COMPAT        = 0 # Variable c_int
MMIO_READ          = 0 # Variable c_int
MMIO_WRITE         = 1 # Variable c_int
MMIO_READWRITE     = 2 # Variable c_int
MMIO_RWMODE        = 3 # Variable c_int
MMIO_EXCLUSIVE     = 16 # Variable c_int
MMIO_FHOPEN        = 16 # Variable c_int
MMIO_FINDCHUNK     = 16 # Variable c_int
MMIO_EMPTYBUF      = 16 # Variable c_int
MMIO_TOUPPER       = 16 # Variable c_int
MMIO_FINDRIFF      = 32 # Variable c_int
MMIO_CREATERIFF    = 32 # Variable c_int
MMIO_DENYWRITE     = 32 # Variable c_int
MMIO_DENYREAD      = 48 # Variable c_int
MMIO_CREATELIST    = 64 # Variable c_int
MMIO_DENYNONE      = 64 # Variable c_int
MMIO_FINDLIST      = 64 # Variable c_int
MMIO_SHAREMODE     = 112 # Variable c_int
MMIO_PARSE         = 256 # Variable c_int
MMIO_DELETE        = 512 # Variable c_int
MMIO_CREATE        = 4096 # Variable c_int
MMIO_DEFAULTBUFFER = 8192 # Variable c_int
MMIO_EXIST         = 16384 # Variable c_int
MMIO_INSTALLPROC   = 65536 # Variable c_int
MMIO_ALLOCBUF      = 65536 # Variable c_int
MMIO_REMOVEPROC    = 131072 # Variable c_int
MMIO_GETTEMP       = 131072 # Variable c_int
MMIO_FINDPROC      = 262144 # Variable c_int
MMIO_UNICODEPROC   = 16777216 # Variable c_int
MMIO_DIRTY         = 268435456 # Variable c_int
MMIO_GLOBALPROC    = 268435456 # Variable c_int

MMSYSERR_NOERROR      = 0 # Variable c_int
MMSYSERR_BASE         = 0 # Variable c_int
MMSYSERR_ERROR        = 1 # Variable c_int
MMSYSERR_BADDEVICEID  = 2 # Variable c_int
MMSYSERR_NOTENABLED   = 3 # Variable c_int
MMSYSERR_ALLOCATED    = 4 # Variable c_int
MMSYSERR_INVALHANDLE  = 5 # Variable c_int
MMSYSERR_NODRIVER     = 6 # Variable c_int
MMSYSERR_NOMEM        = 7 # Variable c_int
MMSYSERR_NOTSUPPORTED = 8 # Variable c_int
MMSYSERR_BADERRNUM    = 9 # Variable c_int
MMSYSERR_INVALFLAG    = 10 # Variable c_int
MMSYSERR_INVALPARAM   = 11 # Variable c_int
MMSYSERR_HANDLEBUSY   = 12 # Variable c_int
MMSYSERR_INVALIDALIAS = 13 # Variable c_int
MMSYSERR_BADDB        = 14 # Variable c_int
MMSYSERR_KEYNOTFOUND  = 15 # Variable c_int
MMSYSERR_READERROR    = 16 # Variable c_int
MMSYSERR_WRITEERROR   = 17 # Variable c_int
MMSYSERR_DELETEERROR  = 18 # Variable c_int
MMSYSERR_VALNOTFOUND  = 19 # Variable c_int
MMSYSERR_LASTERROR    = 20 # Variable c_int
MMSYSERR_NODRIVERCB   = 20 # Variable c_int

MM_TEXT                = win32con.MM_TEXT # 1
MM_LOMETRIC            = win32con.MM_LOMETRIC # 2
MM_HIMETRIC            = win32con.MM_HIMETRIC # 3
MM_LOENGLISH           = win32con.MM_LOENGLISH # 4
MM_HIENGLISH           = win32con.MM_HIENGLISH # 5
MM_TWIPS               = win32con.MM_TWIPS # 6
MM_ISOTROPIC           = win32con.MM_ISOTROPIC # 7
MM_ANISOTROPIC         = win32con.MM_ANISOTROPIC # 8
MM_JOY1MOVE            = 928 # Variable c_int
MM_JOY2MOVE            = 929 # Variable c_int
MM_JOY1ZMOVE           = 930 # Variable c_int
MM_JOY2ZMOVE           = 931 # Variable c_int
MM_JOY1BUTTONDOWN      = 949 # Variable c_int
MM_JOY2BUTTONDOWN      = 950 # Variable c_int
MM_JOY1BUTTONUP        = 951 # Variable c_int
MM_JOY2BUTTONUP        = 952 # Variable c_int
MM_MCINOTIFY           = 953 # Variable c_int
MM_WOM_OPEN            = 955 # Variable c_int
MM_WOM_CLOSE           = 956 # Variable c_int
MM_WOM_DONE            = 957 # Variable c_int
MM_WIM_OPEN            = 958 # Variable c_int
MM_WIM_CLOSE           = 959 # Variable c_int
MM_WIM_DATA            = 960 # Variable c_int
MM_MIM_OPEN            = 961 # Variable c_int
MM_MIM_CLOSE           = 962 # Variable c_int
MM_MIM_DATA            = 963 # Variable c_int
MM_MIM_LONGDATA        = 964 # Variable c_int
MM_MIM_ERROR           = 965 # Variable c_int
MM_MIM_LONGERROR       = 966 # Variable c_int
MM_MOM_OPEN            = 967 # Variable c_int
MM_MOM_CLOSE           = 968 # Variable c_int
MM_MOM_DONE            = 969 # Variable c_int
MM_MOM_POSITIONCB      = 970 # Variable c_int
MM_MCISIGNAL           = 971 # Variable c_int
MM_MIM_MOREDATA        = 972 # Variable c_int
MM_MIXM_LINE_CHANGE    = 976 # Variable c_int
MM_DRVM_OPEN           = 976 # Variable c_int
MM_DRVM_CLOSE          = 977 # Variable c_int
MM_MIXM_CONTROL_CHANGE = 977 # Variable c_int
MM_DRVM_DATA           = 978 # Variable c_int
MM_DRVM_ERROR          = 979 # Variable c_int
MM_STREAM_OPEN         = 980 # Variable c_int
MM_STREAM_CLOSE        = 981 # Variable c_int
MM_STREAM_DONE         = 982 # Variable c_int
MM_STREAM_ERROR        = 983 # Variable c_int

MNC_IGNORE  = win32con.MNC_IGNORE # 0
MNC_CLOSE   = win32con.MNC_CLOSE # 1
MNC_EXECUTE = win32con.MNC_EXECUTE # 2
MNC_SELECT  = win32con.MNC_SELECT # 3

MNS_CHECKORBMP  = win32con.MNS_CHECKORBMP # 67108864
MNS_NOTIFYBYPOS = win32con.MNS_NOTIFYBYPOS # 134217728
MNS_AUTODISMISS = win32con.MNS_AUTODISMISS # 268435456
MNS_DRAGDROP    = win32con.MNS_DRAGDROP # 536870912
MNS_MODELESS    = win32con.MNS_MODELESS # 1073741824
MNS_NOCHECK     = win32con.MNS_NOCHECK # -2147483648

MN_GETHMENU = 0x01E1

MOD_ALT                 = win32con.MOD_ALT # 1
MOD_MIDIPORT            = 1 # Variable c_int
MOD_CONTROL             = win32con.MOD_CONTROL # 2
MOD_SYNTH               = 2 # Variable c_int
MOD_SQSYNTH             = 3 # Variable c_int
MOD_FMSYNTH             = 4 # Variable c_int
MOD_SHIFT               = win32con.MOD_SHIFT # 4
MOD_MAPPER              = 5 # Variable c_int
MOD_WIN                 = win32con.MOD_WIN # 8
MOD_IGNORE_ALL_MODIFIER = 1024 # Variable c_int
MOD_ON_KEYUP            = 2048 # Variable c_int
MOD_RIGHT               = 16384 # Variable c_int
MOD_LEFT                = 32768 # Variable c_int

MONO_FONT = 8 # Variable c_int

MONTHCAL_CLASSA = 'SysMonthCal32' # Variable POINTER(c_char)
MONTHCAL_CLASSW = 'SysMonthCal32' # Variable POINTER(c_wchar)

MOUSEEVENTF_MOVE       = win32con.MOUSEEVENTF_MOVE # 1
MOUSEEVENTF_LEFTDOWN   = win32con.MOUSEEVENTF_LEFTDOWN # 2
MOUSEEVENTF_LEFTUP     = win32con.MOUSEEVENTF_LEFTUP # 4
MOUSEEVENTF_RIGHTDOWN  = win32con.MOUSEEVENTF_RIGHTDOWN # 8
MOUSEEVENTF_RIGHTUP    = win32con.MOUSEEVENTF_RIGHTUP # 16
MOUSEEVENTF_MIDDLEDOWN = win32con.MOUSEEVENTF_MIDDLEDOWN # 32
MOUSEEVENTF_MIDDLEUP   = win32con.MOUSEEVENTF_MIDDLEUP # 64
MOUSEEVENTF_WHEEL      = win32con.MOUSEEVENTF_WHEEL # 2048
MOUSEEVENTF_ABSOLUTE   = win32con.MOUSEEVENTF_ABSOLUTE # 32768

MOUSE_MOVED   = win32con.MOUSE_MOVED # 1
MOUSE_EVENT   = 2 # Variable c_int
MOUSE_WHEELED = win32con.MOUSE_WHEELED # 4

MOVEFILE_REPLACE_EXISTING   = win32con.MOVEFILE_REPLACE_EXISTING # 1
MOVEFILE_COPY_ALLOWED       = win32con.MOVEFILE_COPY_ALLOWED # 2
MOVEFILE_DELAY_UNTIL_REBOOT = win32con.MOVEFILE_DELAY_UNTIL_REBOOT # 4
MOVEFILE_WRITE_THROUGH      = 8 # Variable c_int

MSGF_DIALOGBOX            = win32con.MSGF_DIALOGBOX # 0
MSGF_MESSAGEBOX           = win32con.MSGF_MESSAGEBOX # 1
MSGF_MENU                 = win32con.MSGF_MENU # 2
MSGF_SCROLLBAR            = win32con.MSGF_SCROLLBAR # 5
MSGF_NEXTWINDOW           = win32con.MSGF_NEXTWINDOW # 6
MSGF_MAX                  = win32con.MSGF_MAX # 8
MSGF_USER                 = win32con.MSGF_USER # 4096
MSGF_COMMCTRL_BEGINDRAG   = 16896 # Variable c_int
MSGF_COMMCTRL_SIZEHEADER  = 16897 # Variable c_int
MSGF_COMMCTRL_DRAGSELECT  = 16898 # Variable c_int
MSGF_COMMCTRL_TOOLBARCUST = 16899 # Variable c_int
MSGF_DDEMGR               = 32769 # Variable c_int

MSG_OOB       = 1 # Variable c_int
MSG_PEEK      = 2 # Variable c_int
MSG_DONTROUTE = 4 # Variable c_int
MSG_MAXIOVLEN = 16 # Variable c_int
MSG_PARTIAL   = 32768 # Variable c_int

MSHCTX_LOCAL            = 0
MSHCTX_NOSHAREDMEM      = 1
MSHCTX_DIFFERENTMACHINE = 2
MSHCTX_INPROC           = 3

MSHLFLAGS_NORMAL      = 0
MSHLFLAGS_TABLESTRONG = 1
MSHLFLAGS_TABLEWEAK   = 2
MSHLFLAGS_NOPING      = 4

MS_CTS_ON  = 16 # Variable c_ulong
MS_DSR_ON  = 32 # Variable c_ulong
MS_RING_ON = 64 # Variable c_ulong
MS_RLSD_ON = 128 # Variable c_ulong
MS_NBF     = 'MNBF' # Variable POINTER(c_char)

MUTANT_QUERY_STATE = win32con.MUTANT_QUERY_STATE # 1
MUTANT_ALL_ACCESS  = 2031617 # Variable c_long

MWMO_WAITALL        = win32con.MWMO_WAITALL # 1
MWMO_ALERTABLE      = win32con.MWMO_ALERTABLE # 2
MWMO_INPUTAVAILABLE = win32con.MWMO_INPUTAVAILABLE # 4

MWT_IDENTITY      = win32con.MWT_IDENTITY # 1
MWT_LEFTMULTIPLY  = win32con.MWT_LEFTMULTIPLY # 2
MWT_RIGHTMULTIPLY = win32con.MWT_RIGHTMULTIPLY # 3

NAME_FLAGS_MASK = 135 # Variable c_int

NDR_IEEE_FLOAT                = 0 # Variable c_ulong
NDR_BIG_ENDIAN                = 0 # Variable c_ulong
NDR_ASCII_CHAR                = 0 # Variable c_ulong
NDR_EBCDIC_CHAR               = 1 # Variable c_ulong
NDR_CHAR_REP_MASK             = 15 # Variable c_ulong
NDR_LITTLE_ENDIAN             = 16 # Variable c_ulong
NDR_LOCAL_DATA_REPRESENTATION = 16 # Variable c_ulong
NDR_INT_REP_MASK              = 240 # Variable c_ulong
NDR_VAX_FLOAT                 = 256 # Variable c_ulong
NDR_FLOAT_REP_MASK            = 65280 # Variable c_ulong

NETINFO_DLL16      = 1 # Variable c_int
NETINFO_DISKRED    = 4 # Variable c_int
NETINFO_PRINTERRED = 8 # Variable c_int

NETPROPERTY_PERSISTENT = 1 # Variable c_int

NFR_ANSI    = win32con.NFR_ANSI # 1
NFR_UNICODE = win32con.NFR_UNICODE # 2

NFS_EDIT      = 1 # Variable c_int
NFS_STATIC    = 2 # Variable c_int
NFS_LISTCOMBO = 4 # Variable c_int
NFS_BUTTON    = 8 # Variable c_int
NFS_ALL       = 16 # Variable c_int

NF_QUERY   = win32con.NF_QUERY # 3
NF_REQUERY = win32con.NF_REQUERY # 4

NIF_MESSAGE = 1 # Variable c_int
NIF_ICON    = 2 # Variable c_int
NIF_TIP     = 4 # Variable c_int

NIM_ADD    = 0 # Variable c_int
NIM_MODIFY = 1 # Variable c_int
NIM_DELETE = 2 # Variable c_int

NI_OPENCANDIDATE            = 16 # Variable c_int
NI_CLOSECANDIDATE           = 17 # Variable c_int
NI_SELECTCANDIDATESTR       = 18 # Variable c_int
NI_CHANGECANDIDATELIST      = 19 # Variable c_int
NI_FINALIZECONVERSIONRESULT = 20 # Variable c_int
NI_COMPOSITIONSTR           = 21 # Variable c_int
NI_SETCANDIDATE_PAGESTART   = 22 # Variable c_int
NI_SETCANDIDATE_PAGESIZE    = 23 # Variable c_int
NI_IMEMENUSELECTED          = 24 # Variable c_int

NLS_ALPHANUMERIC      = win32con.NLS_ALPHANUMERIC # 0
NLS_DBCSCHAR          = win32con.NLS_DBCSCHAR # 65536
NLS_KATAKANA          = win32con.NLS_KATAKANA # 131072
NLS_HIRAGANA          = win32con.NLS_HIRAGANA # 262144
NLS_VALID_LOCALE_MASK = win32con.NLS_VALID_LOCALE_MASK # 1048575
NLS_ROMAN             = win32con.NLS_ROMAN # 4194304
NLS_IME_CONVERSION    = win32con.NLS_IME_CONVERSION # 8388608
NLS_IME_DISABLE       = win32con.NLS_IME_DISABLE # 536870912

NMPWAIT_USE_DEFAULT_WAIT = win32con.NMPWAIT_USE_DEFAULT_WAIT # 0
NMPWAIT_NOWAIT           = win32con.NMPWAIT_NOWAIT # 1
NMPWAIT_WAIT_FOREVER     = win32con.NMPWAIT_WAIT_FOREVER # -1

NMTTDISPINFOA_V1_SIZE = 104 # Variable c_uint

NMTTDISPINFOW_V1_SIZE = 184 # Variable c_uint

NMTVCUSTOMDRAW_V3_SIZE = 56 # Variable c_uint

NM_FIRST           = 0 # Variable c_uint
NM_LAST            = 4294967197 # Variable c_uint
NM_CHAR            = 4294967278 # Variable c_uint
NM_SETCURSOR       = 4294967279 # Variable c_uint
NM_RELEASEDCAPTURE = 4294967280 # Variable c_uint
NM_KEYDOWN         = 4294967281 # Variable c_uint
NM_NCHITTEST       = 4294967282 # Variable c_uint
NM_HOVER           = 4294967283 # Variable c_uint
NM_CUSTOMDRAW      = 4294967284 # Variable c_uint
NM_KILLFOCUS       = 4294967288 # Variable c_uint
NM_SETFOCUS        = 4294967289 # Variable c_uint
NM_RDBLCLK         = 4294967290 # Variable c_uint
NM_RCLICK          = 4294967291 # Variable c_uint
NM_RETURN          = 4294967292 # Variable c_uint
NM_DBLCLK          = 4294967293 # Variable c_uint
NM_CLICK           = 4294967294 # Variable c_uint
NM_OUTOFMEMORY     = 4294967295 # Variable c_uint
NM_LDOWN           = (NM_FIRST-20)
NM_TOOLTIPSCREATED = 4294967277

NONANTIALIASED_QUALITY = win32con.NONANTIALIASED_QUALITY # 3

NORMAL_PRIORITY_CLASS = win32con.NORMAL_PRIORITY_CLASS # 32

NORM_IGNORECASE     = 1 # Variable c_int
NORM_IGNORENONSPACE = 2 # Variable c_int
NORM_IGNORESYMBOLS  = 4 # Variable c_int
NORM_IGNOREKANATYPE = 65536 # Variable c_int
NORM_IGNOREWIDTH    = 131072 # Variable c_int

NO_PRIORITY              = 0 # Variable c_int
NO_ERROR                 = 0 # Variable c_long
NO_PROPAGATE_INHERIT_ACE = win32con.NO_PROPAGATE_INHERIT_ACE # 4

NRC_GOODRET     = 0 # Variable c_int
NRC_BUFLEN      = 1 # Variable c_int
NRC_ILLCMD      = 3 # Variable c_int
NRC_CMDTMO      = 5 # Variable c_int
NRC_INCOMP      = 6 # Variable c_int
NRC_BADDR       = 7 # Variable c_int
NRC_SNUMOUT     = 8 # Variable c_int
NRC_NORES       = 9 # Variable c_int
NRC_SCLOSED     = 10 # Variable c_int
NRC_CMDCAN      = 11 # Variable c_int
NRC_DUPNAME     = 13 # Variable c_int
NRC_NAMTFUL     = 14 # Variable c_int
NRC_ACTSES      = 15 # Variable c_int
NRC_LOCTFUL     = 17 # Variable c_int
NRC_REMTFUL     = 18 # Variable c_int
NRC_ILLNN       = 19 # Variable c_int
NRC_NOCALL      = 20 # Variable c_int
NRC_NOWILD      = 21 # Variable c_int
NRC_INUSE       = 22 # Variable c_int
NRC_NAMERR      = 23 # Variable c_int
NRC_SABORT      = 24 # Variable c_int
NRC_NAMCONF     = 25 # Variable c_int
NRC_IFBUSY      = 33 # Variable c_int
NRC_TOOMANY     = 34 # Variable c_int
NRC_BRIDGE      = 35 # Variable c_int
NRC_CANOCCR     = 36 # Variable c_int
NRC_CANCEL      = 38 # Variable c_int
NRC_DUPENV      = 48 # Variable c_int
NRC_ENVNOTDEF   = 52 # Variable c_int
NRC_OSRESNOTAV  = 53 # Variable c_int
NRC_MAXAPPS     = 54 # Variable c_int
NRC_NOSAPS      = 55 # Variable c_int
NRC_NORESOURCES = 56 # Variable c_int
NRC_INVADDRESS  = 57 # Variable c_int
NRC_INVDDID     = 59 # Variable c_int
NRC_LOCKFAIL    = 60 # Variable c_int
NRC_OPENERR     = 63 # Variable c_int
NRC_SYSTEM      = 64 # Variable c_int
NRC_PENDING     = 255 # Variable c_int

NT351_INTERFACE_SIZE = 64 # Variable c_int

NTE_OP_OK               = 0 # Variable c_int
NTE_SYS_ERR             = -2146893791 # Variable c_long
NTE_FAIL                = -2146893792 # Variable c_long
NTE_BAD_KEYSET_PARAM    = -2146893793 # Variable c_long
NTE_PROV_DLL_NOT_FOUND  = -2146893794 # Variable c_long
NTE_PROVIDER_DLL_FAIL   = -2146893795 # Variable c_long
NTE_SIGNATURE_FILE_BAD  = -2146893796 # Variable c_long
NTE_PROV_TYPE_NO_MATCH  = -2146893797 # Variable c_long
NTE_KEYSET_ENTRY_BAD    = -2146893798 # Variable c_long
NTE_KEYSET_NOT_DEF      = -2146893799 # Variable c_long
NTE_PROV_TYPE_ENTRY_BAD = -2146893800 # Variable c_long
NTE_PROV_TYPE_NOT_DEF   = -2146893801 # Variable c_long
NTE_BAD_KEYSET          = -2146893802 # Variable c_long
NTE_BAD_PUBLIC_KEY      = -2146893803 # Variable c_long
NTE_BAD_PROV_TYPE       = -2146893804 # Variable c_long
NTE_BAD_PROVIDER        = -2146893805 # Variable c_long
NTE_DOUBLE_ENCRYPT      = -2146893806 # Variable c_long
NTE_NOT_FOUND           = -2146893807 # Variable c_long
NTE_PERM                = -2146893808 # Variable c_long
NTE_EXISTS              = -2146893809 # Variable c_long
NTE_NO_MEMORY           = -2146893810 # Variable c_long
NTE_NO_KEY              = -2146893811 # Variable c_long
NTE_BAD_HASH_STATE      = -2146893812 # Variable c_long
NTE_BAD_KEY_STATE       = -2146893813 # Variable c_long
NTE_BAD_TYPE            = -2146893814 # Variable c_long
NTE_BAD_FLAGS           = -2146893815 # Variable c_long
NTE_BAD_ALGID           = -2146893816 # Variable c_long
NTE_BAD_VER             = -2146893817 # Variable c_long
NTE_BAD_SIGNATURE       = -2146893818 # Variable c_long
NTE_BAD_DATA            = -2146893819 # Variable c_long
NTE_BAD_LEN             = -2146893820 # Variable c_long
NTE_BAD_KEY             = -2146893821 # Variable c_long
NTE_BAD_HASH            = -2146893822 # Variable c_long
NTE_BAD_UID             = -2146893823 # Variable c_long

NTM_ITALIC         = win32con.NTM_ITALIC # 1
NTM_BOLD           = win32con.NTM_BOLD # 32
NTM_REGULAR        = win32con.NTM_REGULAR # 64
NTM_NONNEGATIVE_AC = 65536 # Variable c_int
NTM_OPENTYPE       = 131072 # Variable c_int
NTM_MULTIPLEMASTER = 262144 # Variable c_int
NTM_MM_INSTANCE    = 524288 # Variable c_int
NTM_TYPE1          = 1048576 # Variable c_int
NTM_DSIG           = 2097152 # Variable c_int

NULL_BRUSH = win32con.NULL_BRUSH # 5
NULL_PEN   = win32con.NULL_PEN # 8

NUMLOCK_ON = win32con.NUMLOCK_ON # 32

NUMPRS_LEADING_WHITE  = 1 # Variable c_int
NUMPRS_TRAILING_WHITE = 2 # Variable c_int
NUMPRS_LEADING_PLUS   = 4 # Variable c_int
NUMPRS_TRAILING_PLUS  = 8 # Variable c_int
NUMPRS_LEADING_MINUS  = 16 # Variable c_int
NUMPRS_TRAILING_MINUS = 32 # Variable c_int
NUMPRS_HEX_OCT        = 64 # Variable c_int
NUMPRS_PARENS         = 128 # Variable c_int
NUMPRS_DECIMAL        = 256 # Variable c_int
NUMPRS_THOUSANDS      = 512 # Variable c_int
NUMPRS_CURRENCY       = 1024 # Variable c_int
NUMPRS_EXPONENT       = 2048 # Variable c_int
NUMPRS_USE_ALL        = 4096 # Variable c_int
NUMPRS_STD            = 8191 # Variable c_int
NUMPRS_NEG            = 65536 # Variable c_int
NUMPRS_INEXACT        = 131072 # Variable c_int

N_TSHIFT = win32con.N_TSHIFT # 2
N_BTSHFT = win32con.N_BTSHFT # 4
N_BTMASK = win32con.N_BTMASK # 15
N_TMASK  = win32con.N_TMASK # 48
N_TMASK1 = win32con.N_TMASK1 # 192
N_TMASK2 = win32con.N_TMASK2 # 240

OBJECT_INHERIT_ACE = win32con.OBJECT_INHERIT_ACE # 1

OBJID_CLIENT = win32con.OBJID_CLIENT # -4

OBJ_PEN         = win32con.OBJ_PEN # 1
OBJ_BRUSH       = win32con.OBJ_BRUSH # 2
OBJ_DC          = win32con.OBJ_DC # 3
OBJ_METADC      = win32con.OBJ_METADC # 4
OBJ_PAL         = win32con.OBJ_PAL # 5
OBJ_FONT        = win32con.OBJ_FONT # 6
OBJ_BITMAP      = win32con.OBJ_BITMAP # 7
OBJ_REGION      = win32con.OBJ_REGION # 8
OBJ_METAFILE    = win32con.OBJ_METAFILE # 9
OBJ_MEMDC       = win32con.OBJ_MEMDC # 10
OBJ_EXTPEN      = win32con.OBJ_EXTPEN # 11
OBJ_ENHMETADC   = win32con.OBJ_ENHMETADC # 12
OBJ_ENHMETAFILE = win32con.OBJ_ENHMETAFILE # 13

ODA_DRAWENTIRE = win32con.ODA_DRAWENTIRE # 1
ODA_SELECT     = win32con.ODA_SELECT # 2
ODA_FOCUS      = win32con.ODA_FOCUS # 4

ODS_SELECTED     = win32con.ODS_SELECTED # 1
ODS_GRAYED       = win32con.ODS_GRAYED # 2
ODS_DISABLED     = win32con.ODS_DISABLED # 4
ODS_CHECKED      = win32con.ODS_CHECKED # 8
ODS_FOCUS        = win32con.ODS_FOCUS # 16
ODS_DEFAULT      = win32con.ODS_DEFAULT # 32
ODS_COMBOBOXEDIT = win32con.ODS_COMBOBOXEDIT # 4096

ODT_MENU     = win32con.ODT_MENU # 1
ODT_LISTBOX  = win32con.ODT_LISTBOX # 2
ODT_COMBOBOX = win32con.ODT_COMBOBOX # 3
ODT_BUTTON   = win32con.ODT_BUTTON # 4
ODT_STATIC   = win32con.ODT_STATIC # 5
ODT_HEADER   = 100 # Variable c_int
ODT_TAB      = 101 # Variable c_int
ODT_LISTVIEW = 102 # Variable c_int

OEM_FIXED_FONT = win32con.OEM_FIXED_FONT # 10
OEM_CHARSET    = win32con.OEM_CHARSET # 255

OFN_SHAREWARN            = win32con.OFN_SHAREWARN # 0
OFN_SHARENOWARN          = win32con.OFN_SHARENOWARN # 1
OFN_READONLY             = win32con.OFN_READONLY # 1
OFN_SHAREFALLTHROUGH     = win32con.OFN_SHAREFALLTHROUGH # 2
OFN_OVERWRITEPROMPT      = win32con.OFN_OVERWRITEPROMPT # 2
OFN_HIDEREADONLY         = win32con.OFN_HIDEREADONLY # 4
OFN_NOCHANGEDIR          = win32con.OFN_NOCHANGEDIR # 8
OFN_SHOWHELP             = win32con.OFN_SHOWHELP # 16
OFN_ENABLEHOOK           = win32con.OFN_ENABLEHOOK # 32
OFN_ENABLETEMPLATE       = win32con.OFN_ENABLETEMPLATE # 64
OFN_ENABLETEMPLATEHANDLE = win32con.OFN_ENABLETEMPLATEHANDLE # 128
OFN_NOVALIDATE           = win32con.OFN_NOVALIDATE # 256
OFN_ALLOWMULTISELECT     = win32con.OFN_ALLOWMULTISELECT # 512
OFN_EXTENSIONDIFFERENT   = win32con.OFN_EXTENSIONDIFFERENT # 1024
OFN_PATHMUSTEXIST        = win32con.OFN_PATHMUSTEXIST # 2048
OFN_FILEMUSTEXIST        = win32con.OFN_FILEMUSTEXIST # 4096
OFN_CREATEPROMPT         = win32con.OFN_CREATEPROMPT # 8192
OFN_SHAREAWARE           = win32con.OFN_SHAREAWARE # 16384
OFN_NOREADONLYRETURN     = win32con.OFN_NOREADONLYRETURN # 32768
OFN_NOTESTFILECREATE     = win32con.OFN_NOTESTFILECREATE # 65536
OFN_NONETWORKBUTTON      = win32con.OFN_NONETWORKBUTTON # 131072
OFN_NOLONGNAMES          = win32con.OFN_NOLONGNAMES # 262144
OFN_EXPLORER             = win32con.OFN_EXPLORER # 524288
OFN_NODEREFERENCELINKS   = win32con.OFN_NODEREFERENCELINKS # 1048576
OFN_LONGNAMES            = win32con.OFN_LONGNAMES # 2097152
OFN_ENABLEINCLUDENOTIFY  = win32con.OFN_ENABLEINCLUDENOTIFY # 4194304
OFN_ENABLESIZING         = win32con.OFN_ENABLESIZING # 8388608

OFS_MAXPATHNAME = win32con.OFS_MAXPATHNAME # 128

OF_SHARE_COMPAT     = win32con.OF_SHARE_COMPAT # 0
OF_READ             = win32con.OF_READ # 0
OF_WRITE            = win32con.OF_WRITE # 1
OF_READWRITE        = win32con.OF_READWRITE # 2
OF_SHARE_EXCLUSIVE  = win32con.OF_SHARE_EXCLUSIVE # 16
OF_SHARE_DENY_WRITE = win32con.OF_SHARE_DENY_WRITE # 32
OF_SHARE_DENY_READ  = win32con.OF_SHARE_DENY_READ # 48
OF_SHARE_DENY_NONE  = win32con.OF_SHARE_DENY_NONE # 64
OF_PARSE            = win32con.OF_PARSE # 256
OF_DELETE           = win32con.OF_DELETE # 512
OF_VERIFY           = win32con.OF_VERIFY # 1024
OF_CANCEL           = win32con.OF_CANCEL # 2048
OF_CREATE           = win32con.OF_CREATE # 4096
OF_PROMPT           = win32con.OF_PROMPT # 8192
OF_EXIST            = win32con.OF_EXIST # 16384
OF_REOPEN           = win32con.OF_REOPEN # 32768

OIBDG_APARTMENTTHREADED = 256

OLECLOSE_SAVEIFDIRTY = 0
OLECLOSE_NOSAVE      = 1
OLECLOSE_PROMPTSAVE  = 2

OLECONTF_EMBEDDINGS    = 1
OLECONTF_LINKS         = 2
OLECONTF_OTHERS        = 4
OLECONTF_ONLYUSER      = 8
OLECONTF_ONLYIFRUNNING = 16

OLECREATE_LEAVERUNNING = 1 # Variable c_int

OLEGETMONIKER_ONLYIFTHERE = 1
OLEGETMONIKER_FORCEASSIGN = 2
OLEGETMONIKER_UNASSIGN    = 3
OLEGETMONIKER_TEMPFORUSER = 4

OLEIVERB_PRIMARY          = 0 # Variable c_long
OLEIVERB_SHOW             = -1 # Variable c_long
OLEIVERB_OPEN             = -2 # Variable c_long
OLEIVERB_HIDE             = -3 # Variable c_long
OLEIVERB_UIACTIVATE       = -4 # Variable c_long
OLEIVERB_INPLACEACTIVATE  = -5 # Variable c_long
OLEIVERB_DISCARDUNDOSTATE = -6 # Variable c_long

OLELINKBIND_EVENIFCLASSDIFF = 1

OLEMISC_RECOMPOSEONRESIZE            = 1
OLEMISC_ONLYICONIC                   = 2
OLEMISC_INSERTNOTREPLACE             = 4
OLEMISC_STATIC                       = 8
OLEMISC_CANTLINKINSIDE               = 16
OLEMISC_CANLINKBYOLE1                = 32
OLEMISC_ISLINKOBJECT                 = 64
OLEMISC_INSIDEOUT                    = 128
OLEMISC_ACTIVATEWHENVISIBLE          = 256
OLEMISC_RENDERINGISDEVICEINDEPENDENT = 512
OLEMISC_INVISIBLEATRUNTIME           = 1024
OLEMISC_ALWAYSRUN                    = 2048
OLEMISC_ACTSLIKEBUTTON               = 4096
OLEMISC_ACTSLIKELABEL                = 8192
OLEMISC_NOUIACTIVATE                 = 16384
OLEMISC_ALIGNABLE                    = 32768
OLEMISC_SIMPLEFRAME                  = 65536
OLEMISC_SETCLIENTSITEFIRST           = 131072
OLEMISC_IMEMODE                      = 262144
OLEMISC_IGNOREACTIVATEWHENVISIBLE    = 524288
OLEMISC_WANTSTOMENUMERGE             = 1048576
OLEMISC_SUPPORTSMULTILEVELUNDO       = 2097152

OLEOBJ_S_FIRST             = 262528 # Variable c_long
OLEOBJ_S_INVALIDVERB       = 262528 # Variable c_long
OLEOBJ_S_CANNOT_DOVERB_NOW = 262529 # Variable c_long
OLEOBJ_S_INVALIDHWND       = 262530 # Variable c_long
OLEOBJ_S_LAST              = 262543 # Variable c_long
OLEOBJ_E_FIRST             = 2147746176 # Variable c_ulong
OLEOBJ_E_LAST              = 2147746191 # Variable c_ulong
OLEOBJ_E_INVALIDVERB       = -2147221119 # Variable c_long
OLEOBJ_E_NOVERBS           = -2147221120 # Variable c_long

OLERENDER_NONE   = 0
OLERENDER_DRAW   = 1
OLERENDER_FORMAT = 2
OLERENDER_ASIS   = 3

OLEUPDATE_ALWAYS = 1
OLEUPDATE_ONCALL = 3

OLEVERBATTRIB_NEVERDIRTIES    = 1
OLEVERBATTRIB_ONCONTAINERMENU = 2

OLEWHICHMK_CONTAINER = 1
OLEWHICHMK_OBJREL    = 2
OLEWHICHMK_OBJFULL   = 3

OLE_S_USEREG              = 262144 # Variable c_long
OLE_S_FIRST               = 262144 # Variable c_long
OLE_S_STATIC              = 262145 # Variable c_long
OLE_S_MAC_CLIPFORMAT      = 262146 # Variable c_long
OLE_S_LAST                = 262399 # Variable c_long
OLE_E_LAST                = -2147221249 # Variable c_long
OLE_E_NOSTORAGE           = -2147221486 # Variable c_long
OLE_E_CANTCONVERT         = -2147221487 # Variable c_long
OLE_E_NOT_INPLACEACTIVE   = -2147221488 # Variable c_long
OLE_E_INVALIDHWND         = -2147221489 # Variable c_long
OLE_E_WRONGCOMPOBJ        = -2147221490 # Variable c_long
OLE_E_INVALIDRECT         = -2147221491 # Variable c_long
OLE_E_PROMPTSAVECANCELLED = -2147221492 # Variable c_long
OLE_E_STATIC              = -2147221493 # Variable c_long
OLE_E_CANT_BINDTOSOURCE   = -2147221494 # Variable c_long
OLE_E_CANT_GETMONIKER     = -2147221495 # Variable c_long
OLE_E_CLASSDIFF           = -2147221496 # Variable c_long
OLE_E_BLANK               = -2147221497 # Variable c_long
OLE_E_NOCACHE             = -2147221498 # Variable c_long
OLE_E_NOTRUNNING          = -2147221499 # Variable c_long
OLE_E_NOCONNECTION        = -2147221500 # Variable c_long
OLE_E_ADVISENOTSUPPORTED  = -2147221501 # Variable c_long
OLE_E_ENUM_NOMORE         = -2147221502 # Variable c_long
OLE_E_ADVF                = -2147221503 # Variable c_long
OLE_E_FIRST               = -2147221504 # Variable c_long
OLE_E_OLEVERB             = -2147221504 # Variable c_long

OPENTYPE_FONTTYPE = win32con.OPENTYPE_FONTTYPE # 65536

OPEN_EXISTING = win32con.OPEN_EXISTING # 3
OPEN_ALWAYS   = win32con.OPEN_ALWAYS # 4

ORD_LANGDRIVER = win32con.ORD_LANGDRIVER # 1

OR_INVALID_OXID = 1910 # Variable c_long
OR_INVALID_OID  = 1911 # Variable c_long
OR_INVALID_SET  = 1912 # Variable c_long

OUTPUT_DEBUG_STRING_EVENT = win32con.OUTPUT_DEBUG_STRING_EVENT # 8

OUT_DEFAULT_PRECIS        = win32con.OUT_DEFAULT_PRECIS # 0
OUT_STRING_PRECIS         = win32con.OUT_STRING_PRECIS # 1
OUT_CHARACTER_PRECIS      = win32con.OUT_CHARACTER_PRECIS # 2
OUT_STROKE_PRECIS         = win32con.OUT_STROKE_PRECIS # 3
OUT_TT_PRECIS             = win32con.OUT_TT_PRECIS # 4
OUT_DEVICE_PRECIS         = win32con.OUT_DEVICE_PRECIS # 5
OUT_RASTER_PRECIS         = win32con.OUT_RASTER_PRECIS # 6
OUT_TT_ONLY_PRECIS        = win32con.OUT_TT_ONLY_PRECIS # 7
OUT_OUTLINE_PRECIS        = win32con.OUT_OUTLINE_PRECIS # 8
OUT_SCREEN_OUTLINE_PRECIS = 9 # Variable c_int

OWNER_SECURITY_INFORMATION = win32con.OWNER_SECURITY_INFORMATION # 1

PAGE_NOACCESS          = win32con.PAGE_NOACCESS # 1
PAGE_READONLY          = win32con.PAGE_READONLY # 2
PAGE_READWRITE         = win32con.PAGE_READWRITE # 4
PAGE_WRITECOPY         = win32con.PAGE_WRITECOPY # 8
PAGE_EXECUTE           = win32con.PAGE_EXECUTE # 16
PAGE_EXECUTE_READ      = win32con.PAGE_EXECUTE_READ # 32
PAGE_EXECUTE_READWRITE = win32con.PAGE_EXECUTE_READWRITE # 64
PAGE_EXECUTE_WRITECOPY = win32con.PAGE_EXECUTE_WRITECOPY # 128
PAGE_GUARD             = win32con.PAGE_GUARD # 256
PAGE_NOCACHE           = win32con.PAGE_NOCACHE # 512
PAGE_WRITECOMBINE      = 1024 # Variable c_int

PANOSE_COUNT = win32con.PANOSE_COUNT # 10

PGN_HOTITEMCHANGE = 4294966393

PAN_ANY                        = win32con.PAN_ANY # 0
PAN_CULTURE_LATIN              = win32con.PAN_CULTURE_LATIN # 0
PAN_FAMILYTYPE_INDEX           = win32con.PAN_FAMILYTYPE_INDEX # 0
PAN_NO_FIT                     = win32con.PAN_NO_FIT # 1
PAN_SERIFSTYLE_INDEX           = win32con.PAN_SERIFSTYLE_INDEX # 1
PAN_XHEIGHT_CONSTANT_SMALL     = win32con.PAN_XHEIGHT_CONSTANT_SMALL # 2
PAN_CONTRAST_NONE              = win32con.PAN_CONTRAST_NONE # 2
PAN_LETT_NORMAL_CONTACT        = win32con.PAN_LETT_NORMAL_CONTACT # 2
PAN_MIDLINE_STANDARD_TRIMMED   = win32con.PAN_MIDLINE_STANDARD_TRIMMED # 2
PAN_WEIGHT_VERY_LIGHT          = win32con.PAN_WEIGHT_VERY_LIGHT # 2
PAN_FAMILY_TEXT_DISPLAY        = win32con.PAN_FAMILY_TEXT_DISPLAY # 2
PAN_STROKE_GRADUAL_DIAG        = win32con.PAN_STROKE_GRADUAL_DIAG # 2
PAN_SERIF_COVE                 = win32con.PAN_SERIF_COVE # 2
PAN_PROP_OLD_STYLE             = win32con.PAN_PROP_OLD_STYLE # 2
PAN_STRAIGHT_ARMS_HORZ         = win32con.PAN_STRAIGHT_ARMS_HORZ # 2
PAN_WEIGHT_INDEX               = win32con.PAN_WEIGHT_INDEX # 2
PAN_STROKE_GRADUAL_TRAN        = win32con.PAN_STROKE_GRADUAL_TRAN # 3
PAN_SERIF_OBTUSE_COVE          = win32con.PAN_SERIF_OBTUSE_COVE # 3
PAN_FAMILY_SCRIPT              = win32con.PAN_FAMILY_SCRIPT # 3
PAN_MIDLINE_STANDARD_POINTED   = win32con.PAN_MIDLINE_STANDARD_POINTED # 3
PAN_PROPORTION_INDEX           = win32con.PAN_PROPORTION_INDEX # 3
PAN_WEIGHT_LIGHT               = win32con.PAN_WEIGHT_LIGHT # 3
PAN_PROP_MODERN                = win32con.PAN_PROP_MODERN # 3
PAN_LETT_NORMAL_WEIGHTED       = win32con.PAN_LETT_NORMAL_WEIGHTED # 3
PAN_STRAIGHT_ARMS_WEDGE        = win32con.PAN_STRAIGHT_ARMS_WEDGE # 3
PAN_XHEIGHT_CONSTANT_STD       = win32con.PAN_XHEIGHT_CONSTANT_STD # 3
PAN_CONTRAST_VERY_LOW          = win32con.PAN_CONTRAST_VERY_LOW # 3
PAN_STROKE_GRADUAL_VERT        = win32con.PAN_STROKE_GRADUAL_VERT # 4
PAN_CONTRAST_LOW               = win32con.PAN_CONTRAST_LOW # 4
PAN_XHEIGHT_CONSTANT_LARGE     = win32con.PAN_XHEIGHT_CONSTANT_LARGE # 4
PAN_PROP_EVEN_WIDTH            = win32con.PAN_PROP_EVEN_WIDTH # 4
PAN_SERIF_SQUARE_COVE          = win32con.PAN_SERIF_SQUARE_COVE # 4
PAN_FAMILY_DECORATIVE          = win32con.PAN_FAMILY_DECORATIVE # 4
PAN_MIDLINE_STANDARD_SERIFED   = win32con.PAN_MIDLINE_STANDARD_SERIFED # 4
PAN_CONTRAST_INDEX             = win32con.PAN_CONTRAST_INDEX # 4
PAN_LETT_NORMAL_BOXED          = win32con.PAN_LETT_NORMAL_BOXED # 4
PAN_STRAIGHT_ARMS_VERT         = win32con.PAN_STRAIGHT_ARMS_VERT # 4
PAN_WEIGHT_THIN                = win32con.PAN_WEIGHT_THIN # 4
PAN_FAMILY_PICTORIAL           = win32con.PAN_FAMILY_PICTORIAL # 5
PAN_WEIGHT_BOOK                = win32con.PAN_WEIGHT_BOOK # 5
PAN_CONTRAST_MEDIUM_LOW        = win32con.PAN_CONTRAST_MEDIUM_LOW # 5
PAN_LETT_NORMAL_FLATTENED      = win32con.PAN_LETT_NORMAL_FLATTENED # 5
PAN_STRAIGHT_ARMS_SINGLE_SERIF = win32con.PAN_STRAIGHT_ARMS_SINGLE_SERIF # 5
PAN_SERIF_OBTUSE_SQUARE_COVE   = win32con.PAN_SERIF_OBTUSE_SQUARE_COVE # 5
PAN_MIDLINE_HIGH_TRIMMED       = win32con.PAN_MIDLINE_HIGH_TRIMMED # 5
PAN_STROKEVARIATION_INDEX      = win32con.PAN_STROKEVARIATION_INDEX # 5
PAN_XHEIGHT_DUCKING_SMALL      = win32con.PAN_XHEIGHT_DUCKING_SMALL # 5
PAN_STROKE_GRADUAL_HORZ        = win32con.PAN_STROKE_GRADUAL_HORZ # 5
PAN_PROP_EXPANDED              = win32con.PAN_PROP_EXPANDED # 5
PAN_STRAIGHT_ARMS_DOUBLE_SERIF = win32con.PAN_STRAIGHT_ARMS_DOUBLE_SERIF # 6
PAN_PROP_CONDENSED             = win32con.PAN_PROP_CONDENSED # 6
PAN_ARMSTYLE_INDEX             = win32con.PAN_ARMSTYLE_INDEX # 6
PAN_MIDLINE_HIGH_POINTED       = win32con.PAN_MIDLINE_HIGH_POINTED # 6
PAN_WEIGHT_MEDIUM              = win32con.PAN_WEIGHT_MEDIUM # 6
PAN_CONTRAST_MEDIUM            = win32con.PAN_CONTRAST_MEDIUM # 6
PAN_STROKE_RAPID_VERT          = win32con.PAN_STROKE_RAPID_VERT # 6
PAN_SERIF_SQUARE               = win32con.PAN_SERIF_SQUARE # 6
PAN_LETT_NORMAL_ROUNDED        = win32con.PAN_LETT_NORMAL_ROUNDED # 6
PAN_XHEIGHT_DUCKING_STD        = win32con.PAN_XHEIGHT_DUCKING_STD # 6
PAN_BENT_ARMS_HORZ             = win32con.PAN_BENT_ARMS_HORZ # 7
PAN_XHEIGHT_DUCKING_LARGE      = win32con.PAN_XHEIGHT_DUCKING_LARGE # 7
PAN_LETT_NORMAL_OFF_CENTER     = win32con.PAN_LETT_NORMAL_OFF_CENTER # 7
PAN_CONTRAST_MEDIUM_HIGH       = win32con.PAN_CONTRAST_MEDIUM_HIGH # 7
PAN_SERIF_THIN                 = win32con.PAN_SERIF_THIN # 7
PAN_WEIGHT_DEMI                = win32con.PAN_WEIGHT_DEMI # 7
PAN_MIDLINE_HIGH_SERIFED       = win32con.PAN_MIDLINE_HIGH_SERIFED # 7
PAN_LETTERFORM_INDEX           = win32con.PAN_LETTERFORM_INDEX # 7
PAN_STROKE_RAPID_HORZ          = win32con.PAN_STROKE_RAPID_HORZ # 7
PAN_PROP_VERY_EXPANDED         = win32con.PAN_PROP_VERY_EXPANDED # 7
PAN_STROKE_INSTANT_VERT        = win32con.PAN_STROKE_INSTANT_VERT # 8
PAN_MIDLINE_CONSTANT_TRIMMED   = win32con.PAN_MIDLINE_CONSTANT_TRIMMED # 8
PAN_PROP_VERY_CONDENSED        = win32con.PAN_PROP_VERY_CONDENSED # 8
PAN_MIDLINE_INDEX              = win32con.PAN_MIDLINE_INDEX # 8
PAN_SERIF_BONE                 = win32con.PAN_SERIF_BONE # 8
PAN_LETT_NORMAL_SQUARE         = win32con.PAN_LETT_NORMAL_SQUARE # 8
PAN_BENT_ARMS_WEDGE            = win32con.PAN_BENT_ARMS_WEDGE # 8
PAN_CONTRAST_HIGH              = win32con.PAN_CONTRAST_HIGH # 8
PAN_WEIGHT_BOLD                = win32con.PAN_WEIGHT_BOLD # 8
PAN_CONTRAST_VERY_HIGH         = win32con.PAN_CONTRAST_VERY_HIGH # 9
PAN_WEIGHT_HEAVY               = win32con.PAN_WEIGHT_HEAVY # 9
PAN_SERIF_EXAGGERATED          = win32con.PAN_SERIF_EXAGGERATED # 9
PAN_MIDLINE_CONSTANT_POINTED   = win32con.PAN_MIDLINE_CONSTANT_POINTED # 9
PAN_BENT_ARMS_VERT             = win32con.PAN_BENT_ARMS_VERT # 9
PAN_XHEIGHT_INDEX              = win32con.PAN_XHEIGHT_INDEX # 9
PAN_LETT_OBLIQUE_CONTACT       = win32con.PAN_LETT_OBLIQUE_CONTACT # 9
PAN_PROP_MONOSPACED            = win32con.PAN_PROP_MONOSPACED # 9
PAN_WEIGHT_BLACK               = win32con.PAN_WEIGHT_BLACK # 10
PAN_MIDLINE_CONSTANT_SERIFED   = win32con.PAN_MIDLINE_CONSTANT_SERIFED # 10
PAN_LETT_OBLIQUE_WEIGHTED      = win32con.PAN_LETT_OBLIQUE_WEIGHTED # 10
PAN_BENT_ARMS_SINGLE_SERIF     = win32con.PAN_BENT_ARMS_SINGLE_SERIF # 10
PAN_SERIF_TRIANGLE             = win32con.PAN_SERIF_TRIANGLE # 10
PAN_LETT_OBLIQUE_BOXED         = win32con.PAN_LETT_OBLIQUE_BOXED # 11
PAN_BENT_ARMS_DOUBLE_SERIF     = win32con.PAN_BENT_ARMS_DOUBLE_SERIF # 11
PAN_SERIF_NORMAL_SANS          = win32con.PAN_SERIF_NORMAL_SANS # 11
PAN_MIDLINE_LOW_TRIMMED        = win32con.PAN_MIDLINE_LOW_TRIMMED # 11
PAN_WEIGHT_NORD                = win32con.PAN_WEIGHT_NORD # 11
PAN_LETT_OBLIQUE_FLATTENED     = win32con.PAN_LETT_OBLIQUE_FLATTENED # 12
PAN_SERIF_OBTUSE_SANS          = win32con.PAN_SERIF_OBTUSE_SANS # 12
PAN_MIDLINE_LOW_POINTED        = win32con.PAN_MIDLINE_LOW_POINTED # 12
PAN_SERIF_PERP_SANS            = win32con.PAN_SERIF_PERP_SANS # 13
PAN_LETT_OBLIQUE_ROUNDED       = win32con.PAN_LETT_OBLIQUE_ROUNDED # 13
PAN_MIDLINE_LOW_SERIFED        = win32con.PAN_MIDLINE_LOW_SERIFED # 13
PAN_SERIF_FLARED               = win32con.PAN_SERIF_FLARED # 14
PAN_LETT_OBLIQUE_OFF_CENTER    = win32con.PAN_LETT_OBLIQUE_OFF_CENTER # 14
PAN_SERIF_ROUNDED              = win32con.PAN_SERIF_ROUNDED # 15
PAN_LETT_OBLIQUE_SQUARE        = win32con.PAN_LETT_OBLIQUE_SQUARE # 15

PARAMFLAG_NONE         = 0 # Variable c_int
PARAMFLAG_FIN          = 1 # Variable c_int
PARAMFLAG_FOUT         = 2 # Variable c_int
PARAMFLAG_FLCID        = 4 # Variable c_int
PARAMFLAG_FRETVAL      = 8 # Variable c_int
PARAMFLAG_FOPT         = 16 # Variable c_int
PARAMFLAG_FHASDEFAULT  = 32 # Variable c_int
PARAMFLAG_FHASCUSTDATA = 64 # Variable c_int

PARITY_NONE  = 256 # Variable c_ushort
PARITY_ODD   = 512 # Variable c_ushort
PARITY_EVEN  = 1024 # Variable c_ushort
PARITY_MARK  = 2048 # Variable c_ushort
PARITY_SPACE = 4096 # Variable c_ushort

PARSE_CANONICALIZE    = 1
PARSE_FRIENDLY        = 2
PARSE_SECURITY_URL    = 3
PARSE_ROOTDOCUMENT    = 4
PARSE_DOCUMENT        = 5
PARSE_ANCHOR          = 6
PARSE_ENCODE          = 7
PARSE_DECODE          = 8
PARSE_PATH_FROM_URL   = 9
PARSE_URL_FROM_PATH   = 10
PARSE_MIME            = 11
PARSE_SERVER          = 12
PARSE_SCHEMA          = 13
PARSE_SITE            = 14
PARSE_DOMAIN          = 15
PARSE_LOCATION        = 16
PARSE_SECURITY_DOMAIN = 17

PBM_SETMARQUEE  = 0x040A # Windows XP ~
PBM_GETSTEP     = 0x040D # Windows Vista ~
PBM_GETBKCOLOR  = 0x040E
PBM_GETBARCOLOR = 0x040F
PBM_SETRANGE    = 0x0401  # 1025, Variable c_int
PBM_SETPOS      = 0x0402  # 1026, Variable c_int
PBM_SETRANGE32  = 0x0406  # 1030, Variable c_int, Internet Explorer 3.0 ~
PBM_SETSTATE    = 0x0410
PBM_GETSTATE    = 0x0411
PBM_SETBKCOLOR  = 0x2001
PBM_DELTAPOS    = 1027 # Variable c_int
PBM_SETSTEP     = 1028 # Variable c_int
PBM_STEPIT      = 1029 # Variable c_int
PBM_GETRANGE    = 1031 # Variable c_int
PBM_GETPOS      = 1032 # Variable c_int
PBM_SETBARCOLOR = 1033 # Variable c_int

PBST_NORMAL = 0x0001 # Windows Vista ~
PBST_ERROR  = 0x0002
PBST_PAUSED = 0x0003

PBS_MARQUEE       = 0x08 # Windows XP ~
PBS_SMOOTHREVERSE = 0x10 # Windows Vista ~
PBS_SMOOTH        = 1 # Variable c_int
PBS_VERTICAL      = 4 # Variable c_int

PBTF_APMRESUMEFROMFAILURE = win32con.PBTF_APMRESUMEFROMFAILURE # 1

PBT_APMQUERYSUSPEND       = win32con.PBT_APMQUERYSUSPEND # 0
PBT_APMQUERYSTANDBY       = win32con.PBT_APMQUERYSTANDBY # 1
PBT_APMQUERYSUSPENDFAILED = win32con.PBT_APMQUERYSUSPENDFAILED # 2
PBT_APMQUERYSTANDBYFAILED = win32con.PBT_APMQUERYSTANDBYFAILED # 3
PBT_APMSUSPEND            = win32con.PBT_APMSUSPEND # 4
PBT_APMSTANDBY            = win32con.PBT_APMSTANDBY # 5
PBT_APMRESUMECRITICAL     = win32con.PBT_APMRESUMECRITICAL # 6
PBT_APMRESUMESUSPEND      = win32con.PBT_APMRESUMESUSPEND # 7
PBT_APMRESUMESTANDBY      = win32con.PBT_APMRESUMESTANDBY # 8
PBT_APMBATTERYLOW         = win32con.PBT_APMBATTERYLOW # 9
PBT_APMPOWERSTATUSCHANGE  = win32con.PBT_APMPOWERSTATUSCHANGE # 10
PBT_APMOEMEVENT           = win32con.PBT_APMOEMEVENT # 11
PBT_APMRESUMEAUTOMATIC    = win32con.PBT_APMRESUMEAUTOMATIC # 18

PCF_DTRDSR        = 1 # Variable c_ulong
PCF_RTSCTS        = 2 # Variable c_ulong
PCF_RLSD          = 4 # Variable c_ulong
PCF_PARITY_CHECK  = 8 # Variable c_ulong
PCF_XONXOFF       = 16 # Variable c_ulong
PCF_SETXCHAR      = 32 # Variable c_ulong
PCF_TOTALTIMEOUTS = 64 # Variable c_ulong
PCF_INTTIMEOUTS   = 128 # Variable c_ulong
PCF_SPECIALCHARS  = 256 # Variable c_ulong
PCF_16BITMODE     = 512 # Variable c_ulong

PC_NONE        = win32con.PC_NONE # 0
PC_RESERVED    = win32con.PC_RESERVED # 1
PC_POLYGON     = win32con.PC_POLYGON # 1
PC_RECTANGLE   = win32con.PC_RECTANGLE # 2
PC_EXPLICIT    = win32con.PC_EXPLICIT # 2
PC_NOCOLLAPSE  = win32con.PC_NOCOLLAPSE # 4
PC_WINDPOLYGON = win32con.PC_WINDPOLYGON # 4
PC_TRAPEZOID   = win32con.PC_TRAPEZOID # 4
PC_SCANLINE    = win32con.PC_SCANLINE # 8
PC_WIDE        = win32con.PC_WIDE # 16
PC_STYLED      = win32con.PC_STYLED # 32
PC_WIDESTYLED  = win32con.PC_WIDESTYLED # 64
PC_INTERIORS   = win32con.PC_INTERIORS # 128
PC_POLYPOLYGON = 256 # Variable c_int
PC_PATHS       = 512 # Variable c_int

PDERR_PRINTERCODES     = 4096 # Variable c_int
PDERR_SETUPFAILURE     = 4097 # Variable c_int
PDERR_PARSEFAILURE     = 4098 # Variable c_int
PDERR_RETDEFFAILURE    = 4099 # Variable c_int
PDERR_LOADDRVFAILURE   = 4100 # Variable c_int
PDERR_GETDEVMODEFAIL   = 4101 # Variable c_int
PDERR_INITFAILURE      = 4102 # Variable c_int
PDERR_NODEVICES        = 4103 # Variable c_int
PDERR_NODEFAULTPRN     = 4104 # Variable c_int
PDERR_DNDMMISMATCH     = 4105 # Variable c_int
PDERR_CREATEICFAILURE  = 4106 # Variable c_int
PDERR_PRINTERNOTFOUND  = 4107 # Variable c_int
PDERR_DEFAULTDIFFERENT = 4108 # Variable c_int

PD_ALLPAGES                   = win32con.PD_ALLPAGES # 0
PD_SELECTION                  = win32con.PD_SELECTION # 1
PD_PAGENUMS                   = win32con.PD_PAGENUMS # 2
PD_NOSELECTION                = win32con.PD_NOSELECTION # 4
PD_NOPAGENUMS                 = win32con.PD_NOPAGENUMS # 8
PD_COLLATE                    = win32con.PD_COLLATE # 16
PD_PRINTTOFILE                = win32con.PD_PRINTTOFILE # 32
PD_PRINTSETUP                 = win32con.PD_PRINTSETUP # 64
PD_NOWARNING                  = win32con.PD_NOWARNING # 128
PD_RETURNDC                   = win32con.PD_RETURNDC # 256
PD_RETURNIC                   = win32con.PD_RETURNIC # 512
PD_RETURNDEFAULT              = win32con.PD_RETURNDEFAULT # 1024
PD_SHOWHELP                   = win32con.PD_SHOWHELP # 2048
PD_ENABLEPRINTHOOK            = win32con.PD_ENABLEPRINTHOOK # 4096
PD_ENABLESETUPHOOK            = win32con.PD_ENABLESETUPHOOK # 8192
PD_ENABLEPRINTTEMPLATE        = win32con.PD_ENABLEPRINTTEMPLATE # 16384
PD_ENABLESETUPTEMPLATE        = win32con.PD_ENABLESETUPTEMPLATE # 32768
PD_FORCE_SWITCH               = 65536
PD_ENABLEPRINTTEMPLATEHANDLE  = win32con.PD_ENABLEPRINTTEMPLATEHANDLE # 65536
PD_ENABLESETUPTEMPLATEHANDLE  = win32con.PD_ENABLESETUPTEMPLATEHANDLE # 131072
PD_USEDEVMODECOPIES           = win32con.PD_USEDEVMODECOPIES # 262144
PD_USEDEVMODECOPIESANDCOLLATE = 262144 # Variable c_int
PD_DISABLEPRINTTOFILE         = win32con.PD_DISABLEPRINTTOFILE # 524288
PD_HIDEPRINTTOFILE            = win32con.PD_HIDEPRINTTOFILE # 1048576
PD_NONETWORKBUTTON            = win32con.PD_NONETWORKBUTTON # 2097152

PENDINGMSG_CANCELCALL     = 0
PENDINGMSG_WAITNOPROCESS  = 1
PENDINGMSG_WAITDEFPROCESS = 2

PENDINGTYPE_TOPLEVEL = 1
PENDINGTYPE_NESTED   = 2

PERF_COUNTER_RAWCOUNT_HEX        = 0 # Variable c_int
PERF_TYPE_NUMBER                 = 0 # Variable c_int
PERF_SIZE_DWORD                  = 0 # Variable c_int
PERF_DISPLAY_NO_SUFFIX           = 0 # Variable c_int
PERF_TEXT_UNICODE                = 0 # Variable c_int
PERF_NUMBER_HEX                  = 0 # Variable c_int
PERF_COUNTER_VALUE               = 0 # Variable c_int
PERF_TIMER_TICK                  = 0 # Variable c_int
PERF_DATA_REVISION               = 1 # Variable c_int
PERF_DATA_VERSION                = 1 # Variable c_int
PERF_DETAIL_NOVICE               = 100 # Variable c_int
PERF_DETAIL_ADVANCED             = 200 # Variable c_int
PERF_COUNTER_LARGE_RAWCOUNT_HEX  = 256 # Variable c_int
PERF_SIZE_LARGE                  = 256 # Variable c_int
PERF_DETAIL_EXPERT               = 300 # Variable c_int
PERF_DETAIL_WIZARD               = 400 # Variable c_int
PERF_SIZE_ZERO                   = 512 # Variable c_int
PERF_SIZE_VARIABLE_LEN           = 768 # Variable c_int
PERF_TYPE_COUNTER                = 1024 # Variable c_int
PERF_TYPE_TEXT                   = 2048 # Variable c_int
PERF_COUNTER_TEXT                = 2816 # Variable c_int
PERF_TYPE_ZERO                   = 3072 # Variable c_int
PERF_COUNTER_RATE                = 65536 # Variable c_int
PERF_TEXT_ASCII                  = 65536 # Variable c_int
PERF_COUNTER_RAWCOUNT            = 65536 # Variable c_int
PERF_NUMBER_DECIMAL              = 65536 # Variable c_int
PERF_COUNTER_LARGE_RAWCOUNT      = 65792 # Variable c_int
PERF_COUNTER_FRACTION            = 131072 # Variable c_int
PERF_NUMBER_DEC_1000             = 131072 # Variable c_int
PERF_COUNTER_BASE                = 196608 # Variable c_int
PERF_COUNTER_ELAPSED             = 262144 # Variable c_int
PERF_COUNTER_QUEUELEN            = 327680 # Variable c_int
PERF_COUNTER_HISTOGRAM           = 393216 # Variable c_int
PERF_TIMER_100NS                 = 1048576 # Variable c_int
PERF_OBJECT_TIMER                = 2097152 # Variable c_int
PERF_DELTA_COUNTER               = 4194304 # Variable c_int
PERF_COUNTER_DELTA               = 4195328 # Variable c_int
PERF_COUNTER_LARGE_DELTA         = 4195584 # Variable c_int
PERF_SAMPLE_COUNTER              = 4260864 # Variable c_int
PERF_COUNTER_QUEUELEN_TYPE       = 4523008 # Variable c_int
PERF_COUNTER_LARGE_QUEUELEN_TYPE = 4523264 # Variable c_int
PERF_DELTA_BASE                  = 8388608 # Variable c_int
PERF_INVERSE_COUNTER             = 16777216 # Variable c_int
PERF_MULTI_COUNTER               = 33554432 # Variable c_int
PERF_DISPLAY_PER_SEC             = 268435456 # Variable c_int
PERF_COUNTER_COUNTER             = 272696320 # Variable c_int
PERF_COUNTER_BULK_COUNT          = 272696576 # Variable c_int
PERF_DISPLAY_PERCENT             = 536870912 # Variable c_int
PERF_RAW_FRACTION                = 537003008 # Variable c_int
PERF_COUNTER_TIMER               = 541132032 # Variable c_int
PERF_100NSEC_TIMER               = 542180608 # Variable c_int
PERF_SAMPLE_FRACTION             = 549585920 # Variable c_int
PERF_COUNTER_TIMER_INV           = 557909248 # Variable c_int
PERF_100NSEC_TIMER_INV           = 558957824 # Variable c_int
PERF_COUNTER_MULTI_TIMER         = 574686464 # Variable c_int
PERF_100NSEC_MULTI_TIMER         = 575735040 # Variable c_int
PERF_COUNTER_MULTI_TIMER_INV     = 591463680 # Variable c_int
PERF_100NSEC_MULTI_TIMER_INV     = 592512256 # Variable c_int
PERF_DISPLAY_SECONDS             = 805306368 # Variable c_int
PERF_AVERAGE_TIMER               = 805438464 # Variable c_int
PERF_ELAPSED_TIME                = 807666944 # Variable c_int
PERF_DISPLAY_NOSHOW              = 1073741824 # Variable c_int
PERF_COUNTER_NODATA              = 1073742336 # Variable c_int
PERF_AVERAGE_BULK                = 1073874176 # Variable c_int
PERF_SAMPLE_BASE                 = 1073939457 # Variable c_int
PERF_AVERAGE_BASE                = 1073939458 # Variable c_int
PERF_RAW_BASE                    = 1073939459 # Variable c_int
PERF_COUNTER_MULTI_BASE          = 1107494144 # Variable c_int
PERF_COUNTER_HISTOGRAM_TYPE      = 2147483648 # Variable c_uint
PERF_NO_INSTANCES                = -1 # Variable c_int
PERF_NO_UNIQUE_ID                = -1 # Variable c_int
PERF_QUERY_COSTLY                = -2147483646 # Variable c_long
PERF_QUERY_GLOBAL                = -2147483647 # Variable c_long
PERF_QUERY_OBJECTS               = -2147483648 # Variable c_long

PERSIST_E_NOTSELFSIZING  = -2146762741 # Variable c_long
PERSIST_E_SIZEINDEFINITE = -2146762742 # Variable c_long
PERSIST_E_SIZEDEFINITE   = -2146762743 # Variable c_long

PFD_TYPE_RGBA             = 0 # Variable c_int
PFD_MAIN_PLANE            = 0 # Variable c_int
PFD_TYPE_COLORINDEX       = 1 # Variable c_int
PFD_OVERLAY_PLANE         = 1 # Variable c_int
PFD_DOUBLEBUFFER          = 1 # Variable c_int
PFD_STEREO                = 2 # Variable c_int
PFD_DRAW_TO_WINDOW        = 4 # Variable c_int
PFD_DRAW_TO_BITMAP        = 8 # Variable c_int
PFD_SUPPORT_GDI           = 16 # Variable c_int
PFD_SUPPORT_OPENGL        = 32 # Variable c_int
PFD_GENERIC_FORMAT        = 64 # Variable c_int
PFD_NEED_PALETTE          = 128 # Variable c_int
PFD_NEED_SYSTEM_PALETTE   = 256 # Variable c_int
PFD_SWAP_EXCHANGE         = 512 # Variable c_int
PFD_SWAP_COPY             = 1024 # Variable c_int
PFD_SWAP_LAYER_BUFFERS    = 2048 # Variable c_int
PFD_GENERIC_ACCELERATED   = 4096 # Variable c_int
PFD_SUPPORT_DIRECTDRAW    = 8192 # Variable c_int
PFD_DEPTH_DONTCARE        = 536870912 # Variable c_int
PFD_DOUBLEBUFFER_DONTCARE = 1073741824 # Variable c_int
PFD_STEREO_DONTCARE       = 2147483648 # Variable c_uint
PFD_UNDERLAY_PLANE        = -1 # Variable c_int

PF_FLOATING_POINT_PRECISION_ERRATA = 0 # Variable c_int
PF_FLOATING_POINT_EMULATED         = 1 # Variable c_int
PF_COMPARE_EXCHANGE_DOUBLE         = 2 # Variable c_int
PF_MMX_INSTRUCTIONS_AVAILABLE      = 3 # Variable c_int
PF_PPC_MOVEMEM_64BIT_OK            = 4 # Variable c_int
PF_ALPHA_BYTE_INSTRUCTIONS         = 5 # Variable c_int
PF_XMMI_INSTRUCTIONS_AVAILABLE     = 6 # Variable c_int
PF_AMD3D_INSTRUCTIONS_AVAILABLE    = 7 # Variable c_int

PGB_TOPORLEFT     = 0 # Variable c_int
PGB_BOTTOMORRIGHT = 1 # Variable c_int

PGF_INVISIBLE   = 0 # Variable c_int
PGF_CALCWIDTH   = 1 # Variable c_int
PGF_NORMAL      = 1 # Variable c_int
PGF_SCROLLUP    = 1 # Variable c_int
PGF_SCROLLDOWN  = 2 # Variable c_int
PGF_CALCHEIGHT  = 2 # Variable c_int
PGF_GRAYED      = 2 # Variable c_int
PGF_DEPRESSED   = 4 # Variable c_int
PGF_SCROLLLEFT  = 4 # Variable c_int
PGF_HOT         = 8 # Variable c_int
PGF_SCROLLRIGHT = 8 # Variable c_int

PGK_SHIFT   = 1 # Variable c_int
PGK_CONTROL = 2 # Variable c_int
PGK_MENU    = 4 # Variable c_int

PGM_FIRST          = 5120 # Variable c_int
PGM_SETCHILD       = 5121 # Variable c_int
PGM_RECALCSIZE     = 5122 # Variable c_int
PGM_FORWARDMOUSE   = 5123 # Variable c_int
PGM_SETBKCOLOR     = 5124 # Variable c_int
PGM_GETBKCOLOR     = 5125 # Variable c_int
PGM_SETBORDER      = 5126 # Variable c_int
PGM_GETBORDER      = 5127 # Variable c_int
PGM_SETPOS         = 5128 # Variable c_int
PGM_GETPOS         = 5129 # Variable c_int
PGM_SETBUTTONSIZE  = 5130 # Variable c_int
PGM_GETBUTTONSIZE  = 5131 # Variable c_int
PGM_GETBUTTONSTATE = 5132 # Variable c_int

PGN_LAST     = 4294966346 # Variable c_uint
PGN_CALCSIZE = 4294966394 # Variable c_uint
PGN_SCROLL   = 4294966395 # Variable c_uint
PGN_FIRST    = 4294966396 # Variable c_uint

PGS_VERT       = 0 # Variable c_int
PGS_HORZ       = 1 # Variable c_int
PGS_AUTOSCROLL = 2 # Variable c_int
PGS_DRAGNDROP  = 4 # Variable c_int

PIDSI_TITLE        = 2 # Variable c_long
PIDSI_SUBJECT      = 3 # Variable c_long
PIDSI_AUTHOR       = 4 # Variable c_long
PIDSI_KEYWORDS     = 5 # Variable c_long
PIDSI_COMMENTS     = 6 # Variable c_long
PIDSI_TEMPLATE     = 7 # Variable c_long
PIDSI_LASTAUTHOR   = 8 # Variable c_long
PIDSI_REVNUMBER    = 9 # Variable c_long
PIDSI_EDITTIME     = 10 # Variable c_long
PIDSI_LASTPRINTED  = 11 # Variable c_long
PIDSI_CREATE_DTM   = 12 # Variable c_long
PIDSI_LASTSAVE_DTM = 13 # Variable c_long
PIDSI_PAGECOUNT    = 14 # Variable c_long
PIDSI_WORDCOUNT    = 15 # Variable c_long
PIDSI_CHARCOUNT    = 16 # Variable c_long
PIDSI_THUMBNAIL    = 17 # Variable c_long
PIDSI_APPNAME      = 18 # Variable c_long
PIDSI_DOC_SECURITY = 19 # Variable c_long

PID_DICTIONARY         = 0 # Variable c_int
PID_CODEPAGE           = 1 # Variable c_int
PID_FIRST_USABLE       = 2 # Variable c_int
PID_FIRST_NAME_DEFAULT = 4095 # Variable c_int
PID_LOCALE             = 2147483648 # Variable c_uint
PID_MODIFY_TIME        = 2147483649 # Variable c_uint
PID_SECURITY           = 2147483650 # Variable c_uint
PID_ILLEGAL            = 4294967295 # Variable c_uint

PIPE_WAIT                = win32con.PIPE_WAIT # 0
PIPE_CLIENT_END          = win32con.PIPE_CLIENT_END # 0
PIPE_READMODE_BYTE       = win32con.PIPE_READMODE_BYTE # 0
PIPE_TYPE_BYTE           = win32con.PIPE_TYPE_BYTE # 0
PIPE_NOWAIT              = win32con.PIPE_NOWAIT # 1
PIPE_ACCESS_INBOUND      = win32con.PIPE_ACCESS_INBOUND # 1
PIPE_SERVER_END          = win32con.PIPE_SERVER_END # 1
PIPE_READMODE_MESSAGE    = win32con.PIPE_READMODE_MESSAGE # 2
PIPE_ACCESS_OUTBOUND     = win32con.PIPE_ACCESS_OUTBOUND # 2
PIPE_ACCESS_DUPLEX       = win32con.PIPE_ACCESS_DUPLEX # 3
PIPE_TYPE_MESSAGE        = win32con.PIPE_TYPE_MESSAGE # 4
PIPE_UNLIMITED_INSTANCES = win32con.PIPE_UNLIMITED_INSTANCES # 255

PI_PARSE_URL         = 1
PI_FILTER_MODE       = 2
PI_FORCE_ASYNC       = 4
PI_USE_WORKERTHREAD  = 8
PI_MIMEVERIFICATION  = 16
PI_CLSIDLOOKUP       = 32
PI_DATAPROGRESS      = 64
PI_SYNCHRONOUS       = 128
PI_APARTMENTTHREADED = 256
PI_CLASSINSTALL      = 512

PM_NOREMOVE = win32con.PM_NOREMOVE # 0
PM_REMOVE   = win32con.PM_REMOVE # 1
PM_NOYIELD  = win32con.PM_NOYIELD # 2

POLYFILL_LAST = win32con.POLYFILL_LAST # 2

PORT_STATUS_OFFLINE           = 1 # Variable c_int
PORT_STATUS_TYPE_ERROR        = 1 # Variable c_int
PORT_TYPE_WRITE               = 1 # Variable c_int
PORT_STATUS_TYPE_WARNING      = 2 # Variable c_int
PORT_STATUS_PAPER_JAM         = 2 # Variable c_int
PORT_TYPE_READ                = 2 # Variable c_int
PORT_STATUS_TYPE_INFO         = 3 # Variable c_int
PORT_STATUS_PAPER_OUT         = 3 # Variable c_int
PORT_STATUS_OUTPUT_BIN_FULL   = 4 # Variable c_int
PORT_TYPE_REDIRECTED          = 4 # Variable c_int
PORT_STATUS_PAPER_PROBLEM     = 5 # Variable c_int
PORT_STATUS_NO_TONER          = 6 # Variable c_int
PORT_STATUS_DOOR_OPEN         = 7 # Variable c_int
PORT_TYPE_NET_ATTACHED        = 8 # Variable c_int
PORT_STATUS_USER_INTERVENTION = 8 # Variable c_int
PORT_STATUS_OUT_OF_MEMORY     = 9 # Variable c_int
PORT_STATUS_TONER_LOW         = 10 # Variable c_int
PORT_STATUS_WARMING_UP        = 11 # Variable c_int
PORT_STATUS_POWER_SAVE        = 12 # Variable c_int

POSTSCRIPT_DATA        = win32con.POSTSCRIPT_DATA # 37
POSTSCRIPT_IGNORE      = win32con.POSTSCRIPT_IGNORE # 38
POSTSCRIPT_PASSTHROUGH = win32con.POSTSCRIPT_PASSTHROUGH # 4115
POSTSCRIPT_IDENTIFY    = 4117 # Variable c_int
POSTSCRIPT_INJECTION   = 4118 # Variable c_int

PO_DELETE     = 19 # Variable c_int
PO_RENAME     = 20 # Variable c_int
PO_PORTCHANGE = 32 # Variable c_int
PO_REN_PORT   = 52 # Variable c_int

PP_DISPLAYERRORS = 1 # Variable c_int

PRF_CHECKVISIBLE = win32con.PRF_CHECKVISIBLE # 1
PRF_NONCLIENT    = win32con.PRF_NONCLIENT # 2
PRF_CLIENT       = win32con.PRF_CLIENT # 4
PRF_ERASEBKGND   = win32con.PRF_ERASEBKGND # 8
PRF_CHILDREN     = win32con.PRF_CHILDREN # 16
PRF_OWNED        = win32con.PRF_OWNED # 32

PRINTACTION_OPEN             = 0 # Variable c_int
PRINTACTION_PROPERTIES       = 1 # Variable c_int
PRINTACTION_NETINSTALL       = 2 # Variable c_int
PRINTACTION_NETINSTALLLINK   = 3 # Variable c_int
PRINTACTION_TESTPAGE         = 4 # Variable c_int
PRINTACTION_OPENNETPRN       = 5 # Variable c_int
PRINTACTION_DOCUMENTDEFAULTS = 6 # Variable c_int
PRINTACTION_SERVERPROPERTIES = 7 # Variable c_int

PRINTER_HTML_VIEW_QUEUE                  = 0 # Variable c_int
PRINTER_NOTIFY_TYPE                      = 0 # Variable c_int
PRINTER_NOTIFY_FIELD_SERVER_NAME         = 0 # Variable c_int
PRINTER_HTML_VIEW_PRINTPROPERTIES        = 1 # Variable c_int
PRINTER_ENUM_DEFAULT                     = 1 # Variable c_int
PRINTER_CHANGE_ADD_PRINTER               = 1 # Variable c_int
PRINTER_ERROR_OUTOFPAPER                 = 1 # Variable c_int
PRINTER_ATTRIBUTE_QUEUED                 = 1 # Variable c_int
PRINTER_NOTIFY_INFO_DISCARDED            = 1 # Variable c_int
PRINTER_CONTROL_PAUSE                    = 1 # Variable c_int
PRINTER_NOTIFY_FIELD_PRINTER_NAME        = 1 # Variable c_int
PRINTER_STATUS_PAUSED                    = 1 # Variable c_int
PRINTER_NOTIFY_OPTIONS_REFRESH           = 1 # Variable c_int
PRINTER_NOTIFY_FIELD_SHARE_NAME          = 2 # Variable c_int
PRINTER_ATTRIBUTE_DIRECT                 = 2 # Variable c_int
PRINTER_ERROR_JAM                        = 2 # Variable c_int
PRINTER_CHANGE_SET_PRINTER               = 2 # Variable c_int
PRINTER_CONTROL_RESUME                   = 2 # Variable c_int
PRINTER_STATUS_ERROR                     = 2 # Variable c_int
PRINTER_ENUM_LOCAL                       = 2 # Variable c_int
PRINTER_HTML_VIEW_INSTALL                = 2 # Variable c_int
PRINTER_HTML_VIEW_JOBPROPERTIES          = 3 # Variable c_int
PRINTER_NOTIFY_FIELD_PORT_NAME           = 3 # Variable c_int
PRINTER_CONTROL_PURGE                    = 3 # Variable c_int
PRINTER_NOTIFY_FIELD_DRIVER_NAME         = 4 # Variable c_int
PRINTER_ATTRIBUTE_DEFAULT                = 4 # Variable c_int
PRINTER_STATUS_PENDING_DELETION          = 4 # Variable c_int
PRINTER_CONTROL_SET_STATUS               = 4 # Variable c_int
PRINTER_ENUM_CONNECTIONS                 = 4 # Variable c_int
PRINTER_ENUM_FAVORITE                    = 4 # Variable c_int
PRINTER_ERROR_OUTOFTONER                 = 4 # Variable c_int
PRINTER_CHANGE_DELETE_PRINTER            = 4 # Variable c_int
PRINTER_ACCESS_ADMINISTER                = 4 # Variable c_int
PRINTER_NOTIFY_FIELD_COMMENT             = 5 # Variable c_int
PRINTER_NOTIFY_FIELD_LOCATION            = 6 # Variable c_int
PRINTER_NOTIFY_FIELD_DEVMODE             = 7 # Variable c_int
PRINTER_ACCESS_USE                       = 8 # Variable c_int
PRINTER_ATTRIBUTE_SHARED                 = 8 # Variable c_int
PRINTER_STATUS_PAPER_JAM                 = 8 # Variable c_int
PRINTER_ENUM_NAME                        = 8 # Variable c_int
PRINTER_NOTIFY_FIELD_SEPFILE             = 8 # Variable c_int
PRINTER_CHANGE_FAILED_CONNECTION_PRINTER = 8 # Variable c_int
PRINTER_NOTIFY_FIELD_PRINT_PROCESSOR     = 9 # Variable c_int
PRINTER_NOTIFY_FIELD_PARAMETERS          = 10 # Variable c_int
PRINTER_NOTIFY_FIELD_DATATYPE            = 11 # Variable c_int
PRINTER_NOTIFY_FIELD_SECURITY_DESCRIPTOR = 12 # Variable c_int
PRINTER_NOTIFY_FIELD_ATTRIBUTES          = 13 # Variable c_int
PRINTER_NOTIFY_FIELD_PRIORITY            = 14 # Variable c_int
PRINTER_NOTIFY_FIELD_DEFAULT_PRIORITY    = 15 # Variable c_int
PRINTER_ATTRIBUTE_NETWORK                = 16 # Variable c_int
PRINTER_STATUS_PAPER_OUT                 = 16 # Variable c_int
PRINTER_ENUM_REMOTE                      = 16 # Variable c_int
PRINTER_NOTIFY_FIELD_START_TIME          = 16 # Variable c_int
PRINTER_NOTIFY_FIELD_UNTIL_TIME          = 17 # Variable c_int
PRINTER_NOTIFY_FIELD_STATUS              = 18 # Variable c_int
PRINTER_NOTIFY_FIELD_STATUS_STRING       = 19 # Variable c_int
PRINTER_NOTIFY_FIELD_CJOBS               = 20 # Variable c_int
PRINTER_NOTIFY_FIELD_AVERAGE_PPM         = 21 # Variable c_int
PRINTER_NOTIFY_FIELD_TOTAL_PAGES         = 22 # Variable c_int
PRINTER_NOTIFY_FIELD_PAGES_PRINTED       = 23 # Variable c_int
PRINTER_NOTIFY_FIELD_TOTAL_BYTES         = 24 # Variable c_int
PRINTER_NOTIFY_FIELD_BYTES_PRINTED       = 25 # Variable c_int
PRINTER_NOTIFY_FIELD_OBJECT_GUID         = 26 # Variable c_int
PRINTER_ENUM_SHARED                      = 32 # Variable c_int
PRINTER_ATTRIBUTE_HIDDEN                 = 32 # Variable c_int
PRINTER_STATUS_MANUAL_FEED               = 32 # Variable c_int
PRINTER_ENUM_NETWORK                     = 64 # Variable c_int
PRINTER_STATUS_PAPER_PROBLEM             = 64 # Variable c_int
PRINTER_ATTRIBUTE_LOCAL                  = 64 # Variable c_int
PRINTER_ATTRIBUTE_ENABLE_DEVQ            = 128 # Variable c_int
PRINTER_STATUS_OFFLINE                   = 128 # Variable c_int
PRINTER_CHANGE_PRINTER                   = 255 # Variable c_int
PRINTER_CHANGE_ADD_JOB                   = 256 # Variable c_int
PRINTER_ATTRIBUTE_KEEPPRINTEDJOBS        = 256 # Variable c_int
PRINTER_STATUS_IO_ACTIVE                 = 256 # Variable c_int
PRINTER_CHANGE_SET_JOB                   = 512 # Variable c_int
PRINTER_STATUS_BUSY                      = 512 # Variable c_int
PRINTER_ATTRIBUTE_DO_COMPLETE_FIRST      = 512 # Variable c_int
PRINTER_STATUS_PRINTING                  = 1024 # Variable c_int
PRINTER_CHANGE_DELETE_JOB                = 1024 # Variable c_int
PRINTER_ATTRIBUTE_WORK_OFFLINE           = 1024 # Variable c_int
PRINTER_STATUS_OUTPUT_BIN_FULL           = 2048 # Variable c_int
PRINTER_ATTRIBUTE_ENABLE_BIDI            = 2048 # Variable c_int
PRINTER_CHANGE_WRITE_JOB                 = 2048 # Variable c_int
PRINTER_ATTRIBUTE_RAW_ONLY               = 4096 # Variable c_int
PRINTER_STATUS_NOT_AVAILABLE             = 4096 # Variable c_int
PRINTER_STATUS_WAITING                   = 8192 # Variable c_int
PRINTER_ATTRIBUTE_PUBLISHED              = 8192 # Variable c_int
PRINTER_STATUS_PROCESSING                = 16384 # Variable c_int
PRINTER_FONTTYPE                         = win32con.PRINTER_FONTTYPE # 16384
PRINTER_ENUM_EXPAND                      = 16384 # Variable c_int
PRINTER_ENUM_CONTAINER                   = 32768 # Variable c_int
PRINTER_STATUS_INITIALIZING              = 32768 # Variable c_int
PRINTER_CHANGE_JOB                       = 65280 # Variable c_int
PRINTER_STATUS_WARMING_UP                = 65536 # Variable c_int
PRINTER_ENUM_ICON1                       = 65536 # Variable c_int
PRINTER_CHANGE_ADD_FORM                  = 65536 # Variable c_int
PRINTER_ENUM_ICON2                       = 131072 # Variable c_int
PRINTER_CHANGE_SET_FORM                  = 131072 # Variable c_int
PRINTER_STATUS_TONER_LOW                 = 131072 # Variable c_int
PRINTER_WRITE                            = 131080 # Variable c_long
PRINTER_EXECUTE                          = 131080 # Variable c_long
PRINTER_READ                             = 131080 # Variable c_long
PRINTER_CHANGE_DELETE_FORM               = 262144 # Variable c_int
PRINTER_STATUS_NO_TONER                  = 262144 # Variable c_int
PRINTER_ENUM_ICON3                       = 262144 # Variable c_int
PRINTER_CHANGE_FORM                      = 458752 # Variable c_int
PRINTER_ENUM_ICON4                       = 524288 # Variable c_int
PRINTER_STATUS_PAGE_PUNT                 = 524288 # Variable c_int
PRINTER_ALL_ACCESS                       = 983052 # Variable c_long
PRINTER_ENUM_ICON5                       = 1048576 # Variable c_int
PRINTER_CHANGE_ADD_PORT                  = 1048576 # Variable c_int
PRINTER_STATUS_USER_INTERVENTION         = 1048576 # Variable c_int
PRINTER_STATUS_OUT_OF_MEMORY             = 2097152 # Variable c_int
PRINTER_CHANGE_CONFIGURE_PORT            = 2097152 # Variable c_int
PRINTER_ENUM_ICON6                       = 2097152 # Variable c_int
PRINTER_STATUS_DOOR_OPEN                 = 4194304 # Variable c_int
PRINTER_ENUM_ICON7                       = 4194304 # Variable c_int
PRINTER_CHANGE_DELETE_PORT               = 4194304 # Variable c_int
PRINTER_CHANGE_PORT                      = 7340032 # Variable c_int
PRINTER_ENUM_ICON8                       = 8388608 # Variable c_int
PRINTER_STATUS_SERVER_UNKNOWN            = 8388608 # Variable c_int
PRINTER_ENUM_ICONMASK                    = 16711680 # Variable c_int
PRINTER_CHANGE_ADD_PRINT_PROCESSOR       = 16777216 # Variable c_int
PRINTER_STATUS_POWER_SAVE                = 16777216 # Variable c_int
PRINTER_CHANGE_DELETE_PRINT_PROCESSOR    = 67108864 # Variable c_int
PRINTER_CHANGE_PRINT_PROCESSOR           = 117440512 # Variable c_int
PRINTER_CHANGE_ADD_PRINTER_DRIVER        = 268435456 # Variable c_int
PRINTER_CHANGE_SET_PRINTER_DRIVER        = 536870912 # Variable c_int
PRINTER_ERROR_SEVERE                     = 536870912 # Variable c_int
PRINTER_CHANGE_DELETE_PRINTER_DRIVER     = 1073741824 # Variable c_int
PRINTER_ERROR_WARNING                    = 1073741824 # Variable c_int
PRINTER_CHANGE_PRINTER_DRIVER            = 1879048192 # Variable c_int
PRINTER_CHANGE_ALL                       = 2004353023 # Variable c_int
PRINTER_ERROR_INFORMATION                = 2147483648 # Variable c_uint
PRINTER_CHANGE_TIMEOUT                   = 2147483648 # Variable c_uint

PRIVILEGE_SET_ALL_NECESSARY = win32con.PRIVILEGE_SET_ALL_NECESSARY # 1

PROCESSOR_ARCHITECTURE_INTEL   = 0 # Variable c_int
PROCESSOR_ARCHITECTURE_MIPS    = 1 # Variable c_int
PROCESSOR_ARCHITECTURE_ALPHA   = 2 # Variable c_int
PROCESSOR_ARCHITECTURE_PPC     = 3 # Variable c_int
PROCESSOR_ARCHITECTURE_SHX     = 4 # Variable c_int
PROCESSOR_ARCHITECTURE_ARM     = 5 # Variable c_int
PROCESSOR_ARCHITECTURE_IA64    = 6 # Variable c_int
PROCESSOR_ARCHITECTURE_ALPHA64 = 7 # Variable c_int
PROCESSOR_SHx_SH3              = 103 # Variable c_int
PROCESSOR_SHx_SH4              = 104 # Variable c_int
PROCESSOR_INTEL_386            = win32con.PROCESSOR_INTEL_386 # 386
PROCESSOR_INTEL_486            = win32con.PROCESSOR_INTEL_486 # 486
PROCESSOR_INTEL_PENTIUM        = win32con.PROCESSOR_INTEL_PENTIUM # 586
PROCESSOR_PPC_601              = win32con.PROCESSOR_PPC_601 # 601
PROCESSOR_PPC_603              = win32con.PROCESSOR_PPC_603 # 603
PROCESSOR_PPC_604              = win32con.PROCESSOR_PPC_604 # 604
PROCESSOR_PPC_620              = win32con.PROCESSOR_PPC_620 # 620
PROCESSOR_MOTOROLA_821         = 821 # Variable c_int
PROCESSOR_ARM720               = 1824 # Variable c_int
PROCESSOR_ARM820               = 2080 # Variable c_int
PROCESSOR_ARM920               = 2336 # Variable c_int
PROCESSOR_STRONGARM            = 2577 # Variable c_int
PROCESSOR_MIPS_R4000           = win32con.PROCESSOR_MIPS_R4000 # 4000
PROCESSOR_HITACHI_SH3          = 10003 # Variable c_int
PROCESSOR_HITACHI_SH3E         = 10004 # Variable c_int
PROCESSOR_HITACHI_SH4          = 10005 # Variable c_int
PROCESSOR_ALPHA_21064          = win32con.PROCESSOR_ALPHA_21064 # 21064
PROCESSOR_ARCHITECTURE_UNKNOWN = 65535 # Variable c_int
PROCESSOR_ARM_7TDMI            = 70001 # Variable c_int

PROCESS_TERMINATE              = win32con.PROCESS_TERMINATE # 1
PROCESS_HEAP_REGION            = win32con.PROCESS_HEAP_REGION # 1
PROCESS_CREATE_THREAD          = win32con.PROCESS_CREATE_THREAD # 2
PROCESS_HEAP_UNCOMMITTED_RANGE = win32con.PROCESS_HEAP_UNCOMMITTED_RANGE # 2
PROCESS_HEAP_ENTRY_BUSY        = win32con.PROCESS_HEAP_ENTRY_BUSY # 4
PROCESS_SET_SESSIONID          = 4 # Variable c_int
PROCESS_VM_OPERATION           = win32con.PROCESS_VM_OPERATION # 8
PROCESS_HEAP_ENTRY_MOVEABLE    = win32con.PROCESS_HEAP_ENTRY_MOVEABLE # 16
PROCESS_VM_READ                = win32con.PROCESS_VM_READ # 16
PROCESS_VM_WRITE               = win32con.PROCESS_VM_WRITE # 32
PROCESS_HEAP_ENTRY_DDESHARE    = win32con.PROCESS_HEAP_ENTRY_DDESHARE # 32
PROCESS_DUP_HANDLE             = win32con.PROCESS_DUP_HANDLE # 64
PROCESS_CREATE_PROCESS         = win32con.PROCESS_CREATE_PROCESS # 128
PROCESS_SET_QUOTA              = win32con.PROCESS_SET_QUOTA # 256
PROCESS_STILL_ACTIVE           = 259 # Variable c_int
PROCESS_SET_INFORMATION        = win32con.PROCESS_SET_INFORMATION # 512
PROCESS_QUERY_INFORMATION      = win32con.PROCESS_QUERY_INFORMATION # 1024
PROCESS_ALL_ACCESS             = win32con.PROCESS_ALL_ACCESS # 2035711

PROFILE_USER   = win32con.PROFILE_USER # 268435456
PROFILE_KERNEL = win32con.PROFILE_KERNEL # 536870912
PROFILE_SERVER = win32con.PROFILE_SERVER # 1073741824

PROGRESS_CLASSA = 'msctls_progress32' # Variable POINTER(c_char)
PROGRESS_CLASSW = 'msctls_progress32' # Variable POINTER(c_wchar)

PROOF_QUALITY = win32con.PROOF_QUALITY # 2

PROPSETFLAG_DEFAULT    = 0 # Variable c_int
PROPSETFLAG_NONSIMPLE  = 1 # Variable c_int
PROPSETFLAG_ANSI       = 2 # Variable c_int
PROPSETFLAG_UNBUFFERED = 4 # Variable c_int

PROPSETHDR_OSVERSION_UNKNOWN = 4294967295 # Variable c_uint

PROPSHEETHEADERW_V1_SIZE = 40 # Variable c_uint

PROPSHEETPAGEA_V1_SIZE = 40 # Variable c_uint

PROPSHEETPAGEW_V1_SIZE = 40 # Variable c_uint

PROP_SM_CYDLG  = 188 # Variable c_int
PROP_SM_CXDLG  = 212 # Variable c_int
PROP_MED_CYDLG = 215 # Variable c_int
PROP_LG_CYDLG  = 218 # Variable c_int
PROP_MED_CXDLG = 227 # Variable c_int
PROP_LG_CXDLG  = 252 # Variable c_int

PROTOCOLFLAG_NO_PICS_CHECK = 1 # Variable c_int

PROVIDER_KEEPS_VALUE_LENGTH = 1 # Variable c_int

PROXY_CALCSIZE    = 0
PROXY_GETBUFFER   = 1
PROXY_MARSHAL     = 2
PROXY_SENDRECEIVE = 3
PROXY_UNMARSHAL   = 4
PROXY_PHASE       = c_int # enum

PRSPEC_LPWSTR  = 0 # Variable c_int
PRSPEC_PROPID  = 1 # Variable c_int
PRSPEC_INVALID = 4294967295 # Variable c_uint

PR_JOBSTATUS = win32con.PR_JOBSTATUS # 0

PSBTN_BACK     = 0 # Variable c_int
PSBTN_NEXT     = 1 # Variable c_int
PSBTN_FINISH   = 2 # Variable c_int
PSBTN_OK       = 3 # Variable c_int
PSBTN_APPLYNOW = 4 # Variable c_int
PSBTN_CANCEL   = 5 # Variable c_int
PSBTN_MAX      = 6 # Variable c_int
PSBTN_HELP     = 6 # Variable c_int

PSCB_INITIALIZED = 1 # Variable c_int
PSCB_PRECREATE   = 2 # Variable c_int

PSD_DEFAULTMINMARGINS             = win32con.PSD_DEFAULTMINMARGINS # 0
PSD_INWININIINTLMEASURE           = win32con.PSD_INWININIINTLMEASURE # 0
PSD_MINMARGINS                    = win32con.PSD_MINMARGINS # 1
PSD_MARGINS                       = win32con.PSD_MARGINS # 2
PSD_INTHOUSANDTHSOFINCHES         = win32con.PSD_INTHOUSANDTHSOFINCHES # 4
PSD_INHUNDREDTHSOFMILLIMETERS     = win32con.PSD_INHUNDREDTHSOFMILLIMETERS # 8
PSD_DISABLEMARGINS                = win32con.PSD_DISABLEMARGINS # 16
PSD_DISABLEPRINTER                = win32con.PSD_DISABLEPRINTER # 32
PSD_NOWARNING                     = win32con.PSD_NOWARNING # 128
PSD_DISABLEORIENTATION            = win32con.PSD_DISABLEORIENTATION # 256
PSD_DISABLEPAPER                  = win32con.PSD_DISABLEPAPER # 512
PSD_RETURNDEFAULT                 = win32con.PSD_RETURNDEFAULT # 1024
PSD_SHOWHELP                      = win32con.PSD_SHOWHELP # 2048
PSD_ENABLEPAGESETUPHOOK           = win32con.PSD_ENABLEPAGESETUPHOOK # 8192
PSD_ENABLEPAGESETUPTEMPLATE       = win32con.PSD_ENABLEPAGESETUPTEMPLATE # 32768
PSD_ENABLEPAGESETUPTEMPLATEHANDLE = win32con.PSD_ENABLEPAGESETUPTEMPLATEHANDLE # 131072
PSD_ENABLEPAGEPAINTHOOK           = win32con.PSD_ENABLEPAGEPAINTHOOK # 262144
PSD_DISABLEPAGEPAINTING           = win32con.PSD_DISABLEPAGEPAINTING # 524288
PSD_NONETWORKBUTTON               = win32con.PSD_NONETWORKBUTTON # 2097152

PSH_DEFAULT           = 0 # Variable c_int
PSH_PROPTITLE         = 1 # Variable c_int
PSH_USEHICON          = 2 # Variable c_int
PSH_USEICONID         = 4 # Variable c_int
PSH_PROPSHEETPAGE     = 8 # Variable c_int
PSH_WIZARDHASFINISH   = 16 # Variable c_int
PSH_WIZARD            = 32 # Variable c_int
PSH_USEPSTARTPAGE     = 64 # Variable c_int
PSH_NOAPPLYNOW        = 128 # Variable c_int
PSH_USECALLBACK       = 256 # Variable c_int
PSH_HASHELP           = 512 # Variable c_int
PSH_MODELESS          = 1024 # Variable c_int
PSH_RTLREADING        = 2048 # Variable c_int
PSH_WIZARDCONTEXTHELP = 4096 # Variable c_int
PSH_WIZARD97          = 8192 # Variable c_int
PSH_WATERMARK         = 32768 # Variable c_int
PSH_USEHBMWATERMARK   = 65536 # Variable c_int
PSH_USEHPLWATERMARK   = 131072 # Variable c_int
PSH_STRETCHWATERMARK  = 262144 # Variable c_int
PSH_HEADER            = 524288 # Variable c_int
PSH_USEHBMHEADER      = 1048576 # Variable c_int
PSH_USEPAGELANG       = 2097152 # Variable c_int

PSIDENT_GDICENTRIC = 0 # Variable c_int
PSIDENT_PSCENTRIC  = 1 # Variable c_int

PSINJECT_APPEND          = 0 # Variable c_int
PSINJECT_BEGINSTREAM     = 0 # Variable c_int
PSINJECT_PSADOBE         = 1 # Variable c_int
PSINJECT_REPLACE         = 1 # Variable c_int
PSINJECT_COMMENTS        = 2 # Variable c_int
PSINJECT_BEGINDEFAULTS   = 3 # Variable c_int
PSINJECT_ENDDEFAULTS     = 4 # Variable c_int
PSINJECT_BEGINPROLOG     = 5 # Variable c_int
PSINJECT_ENDPROLOG       = 6 # Variable c_int
PSINJECT_BEGINSETUP      = 7 # Variable c_int
PSINJECT_ENDSETUP        = 8 # Variable c_int
PSINJECT_ENDPAGECOMMENTS = 9 # Variable c_int
PSINJECT_BEGINPAGESETUP  = 10 # Variable c_int
PSINJECT_ENDPAGESETUP    = 11 # Variable c_int
PSINJECT_SHOWPAGE        = 12 # Variable c_int
PSINJECT_PAGETRAILER     = 13 # Variable c_int
PSINJECT_TRAILER         = 14 # Variable c_int
PSINJECT_EOF             = 15 # Variable c_int
PSINJECT_ENDSTREAM       = 16 # Variable c_int
PSINJECT_VMSAVE          = 17 # Variable c_int
PSINJECT_VMRESTORE       = 18 # Variable c_int
PSINJECT_DOCNEEDEDRES    = 19 # Variable c_int
PSINJECT_DOCSUPPLIEDRES  = 20 # Variable c_int
PSINJECT_PAGES           = 21 # Variable c_int
PSINJECT_PAGEORDER       = 22 # Variable c_int
PSINJECT_ORIENTATION     = 23 # Variable c_int
PSINJECT_BOUNDINGBOX     = 24 # Variable c_int
PSINJECT_PAGENUMBER      = 25 # Variable c_int
PSINJECT_PAGEBBOX        = 26 # Variable c_int
PSINJECT_MAX             = 27 # Variable c_int

PSM_SETCURSEL          = win32con.PSM_SETCURSEL # 1125
PSM_REMOVEPAGE         = win32con.PSM_REMOVEPAGE # 1126
PSM_ADDPAGE            = win32con.PSM_ADDPAGE # 1127
PSM_CHANGED            = win32con.PSM_CHANGED # 1128
PSM_RESTARTWINDOWS     = win32con.PSM_RESTARTWINDOWS # 1129
PSM_REBOOTSYSTEM       = win32con.PSM_REBOOTSYSTEM # 1130
PSM_CANCELTOCLOSE      = win32con.PSM_CANCELTOCLOSE # 1131
PSM_QUERYSIBLINGS      = win32con.PSM_QUERYSIBLINGS # 1132
PSM_UNCHANGED          = win32con.PSM_UNCHANGED # 1133
PSM_APPLY              = win32con.PSM_APPLY # 1134
PSM_SETTITLEA          = win32con.PSM_SETTITLEA # 1135
PSM_SETWIZBUTTONS      = win32con.PSM_SETWIZBUTTONS # 1136
PSM_PRESSBUTTON        = win32con.PSM_PRESSBUTTON # 1137
PSM_SETCURSELID        = win32con.PSM_SETCURSELID # 1138
PSM_SETFINISHTEXTA     = win32con.PSM_SETFINISHTEXTA # 1139
PSM_GETTABCONTROL      = win32con.PSM_GETTABCONTROL # 1140
PSM_ISDIALOGMESSAGE    = win32con.PSM_ISDIALOGMESSAGE # 1141
PSM_GETCURRENTPAGEHWND = win32con.PSM_GETCURRENTPAGEHWND # 1142
PSM_SETTITLEW          = win32con.PSM_SETTITLEW # 1144
PSM_SETFINISHTEXTW     = win32con.PSM_SETFINISHTEXTW # 1145

PSNRET_NOERROR              = 0 # Variable c_int
PSNRET_INVALID              = 1 # Variable c_int
PSNRET_INVALID_NOCHANGEPAGE = 2 # Variable c_int

PSN_LAST        = 4294966997 # Variable c_uint
PSN_GETOBJECT   = 4294967086 # Variable c_uint
PSN_QUERYCANCEL = 4294967087 # Variable c_uint
PSN_WIZFINISH   = 4294967088 # Variable c_uint
PSN_WIZNEXT     = 4294967089 # Variable c_uint
PSN_WIZBACK     = 4294967090 # Variable c_uint
PSN_HELP        = 4294967091 # Variable c_uint
PSN_RESET       = 4294967093 # Variable c_uint
PSN_APPLY       = 4294967094 # Variable c_uint
PSN_KILLACTIVE  = 4294967095 # Variable c_uint
PSN_SETACTIVE   = 4294967096 # Variable c_uint
PSN_FIRST       = 4294967096 # Variable c_uint

PSPCB_RELEASE = 1 # Variable c_int
PSPCB_CREATE  = 2 # Variable c_int

PSP_DEFAULT           = 0 # Variable c_int
PSP_DLGINDIRECT       = 1 # Variable c_int
PSP_USEHICON          = 2 # Variable c_int
PSP_USEICONID         = 4 # Variable c_int
PSP_USETITLE          = 8 # Variable c_int
PSP_RTLREADING        = 16 # Variable c_int
PSP_HASHELP           = 32 # Variable c_int
PSP_USEREFPARENT      = 64 # Variable c_int
PSP_USECALLBACK       = 128 # Variable c_int
PSP_PREMATURE         = 1024 # Variable c_int
PSP_HIDEHEADER        = 2048 # Variable c_int
PSP_USEHEADERTITLE    = 4096 # Variable c_int
PSP_USEHEADERSUBTITLE = 8192 # Variable c_int

PST_UNSPECIFIED    = 0 # Variable c_ulong
PST_RS232          = 1 # Variable c_ulong
PST_PARALLELPORT   = 2 # Variable c_ulong
PST_RS422          = 3 # Variable c_ulong
PST_RS423          = 4 # Variable c_ulong
PST_RS449          = 5 # Variable c_ulong
PST_MODEM          = 6 # Variable c_ulong
PST_FAX            = 33 # Variable c_ulong
PST_SCANNER        = 34 # Variable c_ulong
PST_NETWORK_BRIDGE = 256 # Variable c_ulong
PST_LAT            = 257 # Variable c_ulong
PST_TCPIP_TELNET   = 258 # Variable c_ulong
PST_X25            = 259 # Variable c_ulong

PSU_DEFAULT           = 1
PSU_SECURITY_URL_ONLY = 2

PSWIZB_BACK           = 1 # Variable c_int
PSWIZB_NEXT           = 2 # Variable c_int
PSWIZB_FINISH         = 4 # Variable c_int
PSWIZB_DISABLEDFINISH = 8 # Variable c_int

PS_JOIN_ROUND    = win32con.PS_JOIN_ROUND # 0
PS_ENDCAP_ROUND  = win32con.PS_ENDCAP_ROUND # 0
PS_COSMETIC      = win32con.PS_COSMETIC # 0
PS_SOLID         = win32con.PS_SOLID # 0
PS_DASH          = win32con.PS_DASH # 1
PS_DOT           = win32con.PS_DOT # 2
PS_DASHDOT       = win32con.PS_DASHDOT # 3
PS_DASHDOTDOT    = win32con.PS_DASHDOTDOT # 4
PS_NULL          = win32con.PS_NULL # 5
PS_INSIDEFRAME   = win32con.PS_INSIDEFRAME # 6
PS_USERSTYLE     = win32con.PS_USERSTYLE # 7
PS_ALTERNATE     = win32con.PS_ALTERNATE # 8
PS_STYLE_MASK    = win32con.PS_STYLE_MASK # 15
PS_ENDCAP_SQUARE = win32con.PS_ENDCAP_SQUARE # 256
PS_ENDCAP_FLAT   = win32con.PS_ENDCAP_FLAT # 512
PS_ENDCAP_MASK   = win32con.PS_ENDCAP_MASK # 3840
PS_JOIN_BEVEL    = win32con.PS_JOIN_BEVEL # 4096
PS_JOIN_MITER    = win32con.PS_JOIN_MITER # 8192
PS_JOIN_MASK     = win32con.PS_JOIN_MASK # 61440
PS_GEOMETRIC     = win32con.PS_GEOMETRIC # 65536
PS_TYPE_MASK     = win32con.PS_TYPE_MASK # 983040

PT_CLOSEFIGURE = win32con.PT_CLOSEFIGURE # 1
PT_LINETO      = win32con.PT_LINETO # 2
PT_BEZIERTO    = win32con.PT_BEZIERTO # 4
PT_MOVETO      = win32con.PT_MOVETO # 6

PUAF_DEFAULT            = 0
PUAF_NOUI               = 1
PUAF_ISFILE             = 2
PUAF_WARN_IF_DENIED     = 4
PUAF_FORCEUI_FOREGROUND = 8
PUAF_CHECK_TIFS         = 16

PURGE_TXABORT = 1 # Variable c_int
PURGE_RXABORT = 2 # Variable c_int
PURGE_TXCLEAR = 4 # Variable c_int
PURGE_RXCLEAR = 8 # Variable c_int

PWR_SUSPENDREQUEST = win32con.PWR_SUSPENDREQUEST # 1
PWR_OK             = win32con.PWR_OK # 1
PWR_SUSPENDRESUME  = win32con.PWR_SUSPENDRESUME # 2
PWR_CRITICALRESUME = win32con.PWR_CRITICALRESUME # 3
PWR_FAIL           = win32con.PWR_FAIL # -1

QDI_SETDIBITS   = 1 # Variable c_int
QDI_GETDIBITS   = 2 # Variable c_int
QDI_DIBTOSCREEN = 4 # Variable c_int
QDI_STRETCHDIB  = 8 # Variable c_int

QID_SYNC = 4294967295 # Variable c_uint

QS_KEY            = win32con.QS_KEY # 1
QS_MOUSEMOVE      = win32con.QS_MOUSEMOVE # 2
QS_MOUSEBUTTON    = win32con.QS_MOUSEBUTTON # 4
QS_MOUSE          = win32con.QS_MOUSE # 6
QS_INPUT          = win32con.QS_INPUT # 7
QS_POSTMESSAGE    = win32con.QS_POSTMESSAGE # 8
QS_TIMER          = win32con.QS_TIMER # 16
QS_PAINT          = win32con.QS_PAINT # 32
QS_SENDMESSAGE    = win32con.QS_SENDMESSAGE # 64
QS_HOTKEY         = win32con.QS_HOTKEY # 128
QS_ALLEVENTS      = win32con.QS_ALLEVENTS # 191
QS_ALLINPUT       = win32con.QS_ALLINPUT # 255
QS_ALLPOSTMESSAGE = 256 # Variable c_int

QUERY_EXPIRATION_DATE     = 1
QUERY_TIME_OF_LAST_CHANGE = 2
QUERY_CONTENT_ENCODING    = 3
QUERY_CONTENT_TYPE        = 4
QUERY_REFRESH             = 5
QUERY_RECOMBINE           = 6
QUERY_CAN_NAVIGATE        = 7
QUERY_USES_NETWORK        = 8
QUERY_IS_CACHED           = 9
QUERY_IS_INSTALLEDENTRY   = 10
QUERY_IS_CACHED_OR_MAPPED = 11
QUERY_USES_CACHE          = 12

R2_BLACK       = win32con.R2_BLACK # 1
R2_NOTMERGEPEN = win32con.R2_NOTMERGEPEN # 2
R2_MASKNOTPEN  = win32con.R2_MASKNOTPEN # 3
R2_NOTCOPYPEN  = win32con.R2_NOTCOPYPEN # 4
R2_MASKPENNOT  = win32con.R2_MASKPENNOT # 5
R2_NOT         = win32con.R2_NOT # 6
R2_XORPEN      = win32con.R2_XORPEN # 7
R2_NOTMASKPEN  = win32con.R2_NOTMASKPEN # 8
R2_MASKPEN     = win32con.R2_MASKPEN # 9
R2_NOTXORPEN   = win32con.R2_NOTXORPEN # 10
R2_NOP         = win32con.R2_NOP # 11
R2_MERGENOTPEN = win32con.R2_MERGENOTPEN # 12
R2_COPYPEN     = win32con.R2_COPYPEN # 13
R2_MERGEPENNOT = win32con.R2_MERGEPENNOT # 14
R2_MERGEPEN    = win32con.R2_MERGEPEN # 15
R2_WHITE       = win32con.R2_WHITE # 16
R2_LAST        = win32con.R2_LAST # 16

RAND_MAX = 32767 # Variable c_int

RASTER_FONTTYPE = win32con.RASTER_FONTTYPE # 1

RBBIM_STYLE      = 1 # Variable c_int
RBBIM_COLORS     = 2 # Variable c_int
RBBIM_TEXT       = 4 # Variable c_int
RBBIM_IMAGE      = 8 # Variable c_int
RBBIM_CHILD      = 16 # Variable c_int
RBBIM_CHILDSIZE  = 32 # Variable c_int
RBBIM_SIZE       = 64 # Variable c_int
RBBIM_BACKGROUND = 128 # Variable c_int
RBBIM_ID         = 256 # Variable c_int
RBBIM_IDEALSIZE  = 512 # Variable c_int
RBBIM_LPARAM     = 1024 # Variable c_int
RBBIM_HEADERSIZE = 2048 # Variable c_int

RBBS_BREAK          = 1 # Variable c_int
RBBS_FIXEDSIZE      = 2 # Variable c_int
RBBS_CHILDEDGE      = 4 # Variable c_int
RBBS_HIDDEN         = 8 # Variable c_int
RBBS_NOVERT         = 16 # Variable c_int
RBBS_FIXEDBMP       = 32 # Variable c_int
RBBS_VARIABLEHEIGHT = 64 # Variable c_int
RBBS_GRIPPERALWAYS  = 128 # Variable c_int
RBBS_NOGRIPPER      = 256 # Variable c_int

RBHT_NOWHERE = 1 # Variable c_int
RBHT_CAPTION = 2 # Variable c_int
RBHT_CLIENT  = 3 # Variable c_int
RBHT_GRABBER = 4 # Variable c_int

RBIM_IMAGELIST = 1 # Variable c_int

RBNM_ID     = 1 # Variable c_int
RBNM_STYLE  = 2 # Variable c_int
RBNM_LPARAM = 4 # Variable c_int

RBN_LAST          = 4294966437 # Variable c_uint
RBN_CHILDSIZE     = 4294966457 # Variable c_uint
RBN_DELETEDBAND   = 4294966458 # Variable c_uint
RBN_DELETINGBAND  = 4294966459 # Variable c_uint
RBN_ENDDRAG       = 4294966460 # Variable c_uint
RBN_BEGINDRAG     = 4294966461 # Variable c_uint
RBN_AUTOSIZE      = 4294966462 # Variable c_uint
RBN_LAYOUTCHANGED = 4294966463 # Variable c_uint
RBN_GETOBJECT     = 4294966464 # Variable c_uint
RBN_HEIGHTCHANGE  = 4294966465 # Variable c_uint
RBN_FIRST         = 4294966465 # Variable c_uint
RBN_AUTOBREAK     = 4294966443
RBN_CHEVRONPUSHED = 4294966455
RBN_MINMAX        = 4294966444
RBN_SPLITTERDRAG  = 4294966454

RBS_TOOLTIPS        = 256 # Variable c_int
RBS_VARHEIGHT       = 512 # Variable c_int
RBS_BANDBORDERS     = 1024 # Variable c_int
RBS_FIXEDORDER      = 2048 # Variable c_int
RBS_REGISTERDROP    = 4096 # Variable c_int
RBS_AUTOSIZE        = 8192 # Variable c_int
RBS_VERTICALGRIPPER = 16384 # Variable c_int
RBS_DBLCLKTOGGLE    = 32768 # Variable c_int

RB_INSERTBANDA    = 1025 # Variable c_int
RB_DELETEBAND     = 1026 # Variable c_int
RB_GETBARINFO     = 1027 # Variable c_int
RB_SETBARINFO     = 1028 # Variable c_int
RB_SETBANDINFOA   = 1030 # Variable c_int
RB_SETPARENT      = 1031 # Variable c_int
RB_HITTEST        = 1032 # Variable c_int
RB_GETRECT        = 1033 # Variable c_int
RB_INSERTBANDW    = 1034 # Variable c_int
RB_SETBANDINFOW   = 1035 # Variable c_int
RB_GETBANDCOUNT   = 1036 # Variable c_int
RB_GETROWCOUNT    = 1037 # Variable c_int
RB_GETROWHEIGHT   = 1038 # Variable c_int
RB_IDTOINDEX      = 1040 # Variable c_int
RB_GETTOOLTIPS    = 1041 # Variable c_int
RB_SETTOOLTIPS    = 1042 # Variable c_int
RB_SETBKCOLOR     = 1043 # Variable c_int
RB_GETBKCOLOR     = 1044 # Variable c_int
RB_SETTEXTCOLOR   = 1045 # Variable c_int
RB_GETTEXTCOLOR   = 1046 # Variable c_int
RB_SIZETORECT     = 1047 # Variable c_int
RB_BEGINDRAG      = 1048 # Variable c_int
RB_ENDDRAG        = 1049 # Variable c_int
RB_DRAGMOVE       = 1050 # Variable c_int
RB_GETBARHEIGHT   = 1051 # Variable c_int
RB_GETBANDINFOW   = 1052 # Variable c_int
RB_GETBANDINFOA   = 1053 # Variable c_int
RB_MINIMIZEBAND   = 1054 # Variable c_int
RB_MAXIMIZEBAND   = 1055 # Variable c_int
RB_GETBANDBORDERS = 1058 # Variable c_int
RB_SHOWBAND       = 1059 # Variable c_int
RB_SETPALETTE     = 1061 # Variable c_int
RB_GETPALETTE     = 1062 # Variable c_int
RB_MOVEBAND       = 1063 # Variable c_int
RB_GETDROPTARGET  = 8196 # Variable c_int

RC_BITBLT       = win32con.RC_BITBLT # 1
RC_BANDING      = win32con.RC_BANDING # 2
RC_SCALING      = win32con.RC_SCALING # 4
RC_BITMAP64     = win32con.RC_BITMAP64 # 8
RC_GDI20_OUTPUT = win32con.RC_GDI20_OUTPUT # 16
RC_GDI20_STATE  = win32con.RC_GDI20_STATE # 32
RC_SAVEBITMAP   = win32con.RC_SAVEBITMAP # 64
RC_DI_BITMAP    = win32con.RC_DI_BITMAP # 128
RC_PALETTE      = win32con.RC_PALETTE # 256
RC_DIBTODEV     = win32con.RC_DIBTODEV # 512
RC_BIGFONT      = win32con.RC_BIGFONT # 1024
RC_STRETCHBLT   = win32con.RC_STRETCHBLT # 2048
RC_FLOODFILL    = win32con.RC_FLOODFILL # 4096
RC_STRETCHDIB   = win32con.RC_STRETCHDIB # 8192
RC_OP_DX_OUTPUT = win32con.RC_OP_DX_OUTPUT # 16384
RC_DEVBITS      = win32con.RC_DEVBITS # 32768

RDH_RECTANGLES = win32con.RDH_RECTANGLES # 1

RDW_INVALIDATE      = win32con.RDW_INVALIDATE # 1
RDW_INTERNALPAINT   = win32con.RDW_INTERNALPAINT # 2
RDW_ERASE           = win32con.RDW_ERASE # 4
RDW_VALIDATE        = win32con.RDW_VALIDATE # 8
RDW_NOINTERNALPAINT = win32con.RDW_NOINTERNALPAINT # 16
RDW_NOERASE         = win32con.RDW_NOERASE # 32
RDW_NOCHILDREN      = win32con.RDW_NOCHILDREN # 64
RDW_ALLCHILDREN     = win32con.RDW_ALLCHILDREN # 128
RDW_UPDATENOW       = win32con.RDW_UPDATENOW # 256
RDW_ERASENOW        = win32con.RDW_ERASENOW # 512
RDW_FRAME           = win32con.RDW_FRAME # 1024
RDW_NOFRAME         = win32con.RDW_NOFRAME # 2048

READ_CONTROL = win32con.READ_CONTROL # 131072

REALTIME_PRIORITY_CLASS = win32con.REALTIME_PRIORITY_CLASS # 256

REBARBANDINFOA_V3_SIZE = 56 # Variable c_uint

REBARBANDINFOW_V3_SIZE = 56 # Variable c_uint

REFERENCE_BLACK_MIN = 0 # Variable c_ushort
REFERENCE_BLACK_MAX = 4000 # Variable c_ushort
REFERENCE_WHITE_MIN = 6000 # Variable c_ushort
REFERENCE_WHITE_MAX = 10000 # Variable c_ushort

REGCLS_SINGLEUSE      = 0
REGCLS_MULTIPLEUSE    = 1
REGCLS_MULTI_SEPARATE = 2
REGCLS_SUSPENDED      = 4
REGCLS_SURROGATE      = 8

REGDB_S_FIRST        = 262480 # Variable c_long
REGDB_S_LAST         = 262495 # Variable c_long
REGDB_E_FIRST        = 2147746128 # Variable c_ulong
REGDB_E_LAST         = 2147746143 # Variable c_ulong
REGDB_E_IIDNOTREG    = -2147221163 # Variable c_long
REGDB_E_CLASSNOTREG  = -2147221164 # Variable c_long
REGDB_E_INVALIDVALUE = -2147221165 # Variable c_long
REGDB_E_KEYMISSING   = -2147221166 # Variable c_long
REGDB_E_WRITEREGDB   = -2147221167 # Variable c_long
REGDB_E_READREGDB    = -2147221168 # Variable c_long

REGKIND_DEFAULT  = 0
REGKIND_REGISTER = 1
REGKIND_NONE     = 2

REGULAR_FONTTYPE = win32con.REGULAR_FONTTYPE # 1024

REG_NONE                       = win32con.REG_NONE # 0
REG_OPTION_RESERVED            = 0 # Variable c_long
REG_OPTION_NON_VOLATILE        = 0 # Variable c_long
REG_SZ                         = win32con.REG_SZ # 1
REG_WHOLE_HIVE_VOLATILE        = 1 # Variable c_long
REG_CREATED_NEW_KEY            = 1 # Variable c_long
REG_NOTIFY_CHANGE_NAME         = 1 # Variable c_long
REG_OPTION_VOLATILE            = 1 # Variable c_long
REG_EXPAND_SZ                  = win32con.REG_EXPAND_SZ # 2
REG_REFRESH_HIVE               = 2 # Variable c_long
REG_OPTION_CREATE_LINK         = 2 # Variable c_long
REG_NOTIFY_CHANGE_ATTRIBUTES   = win32con.REG_NOTIFY_CHANGE_ATTRIBUTES # 2
REG_OPENED_EXISTING_KEY        = 2 # Variable c_long
REG_BINARY                     = win32con.REG_BINARY # 3
REG_DWORD_LITTLE_ENDIAN        = win32con.REG_DWORD_LITTLE_ENDIAN # 4
REG_DWORD                      = win32con.REG_DWORD # 4
REG_NOTIFY_CHANGE_LAST_SET     = 4 # Variable c_long
REG_OPTION_BACKUP_RESTORE      = 4 # Variable c_long
REG_NO_LAZY_FLUSH              = 4 # Variable c_long
REG_DWORD_BIG_ENDIAN           = win32con.REG_DWORD_BIG_ENDIAN # 5
REG_LINK                       = win32con.REG_LINK # 6
REG_MULTI_SZ                   = win32con.REG_MULTI_SZ # 7
REG_RESOURCE_LIST              = win32con.REG_RESOURCE_LIST # 8
REG_OPTION_OPEN_LINK           = 8 # Variable c_long
REG_NOTIFY_CHANGE_SECURITY     = win32con.REG_NOTIFY_CHANGE_SECURITY # 8
REG_FULL_RESOURCE_DESCRIPTOR   = win32con.REG_FULL_RESOURCE_DESCRIPTOR # 9
REG_RESOURCE_REQUIREMENTS_LIST = win32con.REG_RESOURCE_REQUIREMENTS_LIST # 10
REG_LEGAL_OPTION               = 15 # Variable c_long
REG_LEGAL_CHANGE_FILTER        = 15 # Variable c_long

REMOTE_NAME_INFO_LEVEL = 2 # Variable c_int

REPARSE_DATA_BUFFER_HEADER_SIZE      = 8 # Variable c_long
REPARSE_GUID_DATA_BUFFER_HEADER_SIZE = 24 # Variable c_long

RESOURCEDISPLAYTYPE_GENERIC      = 0 # Variable c_int
RESOURCEDISPLAYTYPE_DOMAIN       = 1 # Variable c_int
RESOURCEDISPLAYTYPE_SERVER       = 2 # Variable c_int
RESOURCEDISPLAYTYPE_SHARE        = 3 # Variable c_int
RESOURCEDISPLAYTYPE_FILE         = 4 # Variable c_int
RESOURCEDISPLAYTYPE_GROUP        = 5 # Variable c_int
RESOURCEDISPLAYTYPE_NETWORK      = 6 # Variable c_int
RESOURCEDISPLAYTYPE_ROOT         = 7 # Variable c_int
RESOURCEDISPLAYTYPE_SHAREADMIN   = 8 # Variable c_int
RESOURCEDISPLAYTYPE_DIRECTORY    = 9 # Variable c_int
RESOURCEDISPLAYTYPE_TREE         = 10 # Variable c_int
RESOURCEDISPLAYTYPE_NDSCONTAINER = 11 # Variable c_int

RESOURCETYPE_ANY      = 0 # Variable c_int
RESOURCETYPE_DISK     = 1 # Variable c_int
RESOURCETYPE_PRINT    = 2 # Variable c_int
RESOURCETYPE_RESERVED = 8 # Variable c_int
RESOURCETYPE_UNKNOWN  = 4294967295 # Variable c_uint

RESOURCEUSAGE_CONNECTABLE   = 1 # Variable c_int
RESOURCEUSAGE_CONTAINER     = 2 # Variable c_int
RESOURCEUSAGE_NOLOCALDEVICE = 4 # Variable c_int
RESOURCEUSAGE_SIBLING       = 8 # Variable c_int
RESOURCEUSAGE_ATTACHED      = 16 # Variable c_int
RESOURCEUSAGE_ALL           = 19 # Variable c_int
RESOURCEUSAGE_RESERVED      = 2147483648 # Variable c_uint

RESOURCE_CONNECTED  = 1 # Variable c_int
RESOURCE_GLOBALNET  = 2 # Variable c_int
RESOURCE_REMEMBERED = 3 # Variable c_int
RESOURCE_RECENT     = 4 # Variable c_int
RESOURCE_CONTEXT    = 5 # Variable c_int

RESTORE_CTM = win32con.RESTORE_CTM # 4100

RES_ICON   = win32con.RES_ICON # 1
RES_CURSOR = win32con.RES_CURSOR # 2

RGB_GAMMA_MIN = 1344 # Variable c_ushort
RGB_GAMMA_MAX = 65000 # Variable c_ushort

RGN_AND  = win32con.RGN_AND # 1
RGN_OR   = win32con.RGN_OR # 2
RGN_XOR  = win32con.RGN_XOR # 3
RGN_DIFF = win32con.RGN_DIFF # 4
RGN_COPY = win32con.RGN_COPY # 5

RIGHTMOST_BUTTON_PRESSED = win32con.RIGHTMOST_BUTTON_PRESSED # 2

RIGHT_ALT_PRESSED  = win32con.RIGHT_ALT_PRESSED # 1
RIGHT_CTRL_PRESSED = win32con.RIGHT_CTRL_PRESSED # 4

RIP_EVENT = win32con.RIP_EVENT # 9

ROTFLAGS_REGISTRATIONKEEPSALIVE = 1 # Variable c_int
ROTFLAGS_ALLOWANYCLIENT         = 2 # Variable c_int

ROT_COMPARE_MAX = 2048 # Variable c_int

RPCFLG_MESSAGE           = 16777216 # Variable c_ulong
RPCFLG_AUTO_COMPLETE     = 134217728 # Variable c_ulong
RPCFLG_LOCAL_CALL        = 268435456 # Variable c_ulong
RPCFLG_INPUT_SYNCHRONOUS = 536870912 # Variable c_ulong
RPCFLG_ASYNCHRONOUS      = 1073741824 # Variable c_ulong
RPCFLG_NON_NDR           = 2147483648 # Variable c_ulong

RPC_C_PROFILE_DEFAULT_ELT          = 0 # Variable c_int
RPC_C_MQ_TEMPORARY                 = 0 # Variable c_int
RPC_C_EP_ALL_ELTS                  = 0 # Variable c_int
RPC_C_MQ_EXPRESS                   = 0 # Variable c_int
RPC_C_QOS_CAPABILITIES_DEFAULT     = 0 # Variable c_int
RPC_C_STATS_CALLS_IN               = 0 # Variable c_int
RPC_C_NS_SYNTAX_DEFAULT            = 0 # Variable c_int
RPC_C_MQ_AUTHN_LEVEL_NONE          = 0 # Variable c_int
RPC_C_PROTECT_LEVEL_DEFAULT        = 0 # Variable c_int
RPC_C_AUTHZ_NONE                   = 0 # Variable c_int
RPC_NCA_FLAGS_DEFAULT              = 0 # Variable c_int
RPC_C_MGMT_INQ_IF_IDS              = 0 # Variable c_int
RPC_C_AUTHN_LEVEL_DEFAULT          = 0 # Variable c_int
RPC_C_MQ_JOURNAL_NONE              = 0 # Variable c_int
RPC_C_AUTHN_NONE                   = 0 # Variable c_int
RPC_C_BINDING_MIN_TIMEOUT          = 0 # Variable c_int
RPC_C_QOS_IDENTITY_STATIC          = 0 # Variable c_int
RPC_C_EP_MATCH_BY_IF               = 1 # Variable c_int
RPC_C_NOTIFY_ON_SEND_COMPLETE      = 1 # Variable c_int
RPC_C_QOS_IDENTITY_DYNAMIC         = 1 # Variable c_int
RPC_C_MQ_JOURNAL_DEADLETTER        = 1 # Variable c_int
RPC_C_VERS_ALL                     = 1 # Variable c_int
RPC_C_MQ_PERMANENT                 = 1 # Variable c_int
RPC_C_STATS_CALLS_OUT              = 1 # Variable c_int
RPC_C_MQ_RECOVERABLE               = 1 # Variable c_int
RPC_C_USE_INTERNET_PORT            = 1 # Variable c_int
RPC_C_AUTHZ_NAME                   = 1 # Variable c_int
RPC_IF_AUTOLISTEN                  = 1 # Variable c_int
RPC_C_OPT_MQ_DELIVERY              = 1 # Variable c_int
RPC_NCA_FLAGS_IDEMPOTENT           = 1 # Variable c_int
RPC_C_IMP_LEVEL_ANONYMOUS          = 1 # Variable c_int
RPC_INTERFACE_HAS_PIPES            = 1 # Variable c_int
RPC_C_PROFILE_ALL_ELT              = 1 # Variable c_int
RPC_C_MGMT_INQ_PRINC_NAME          = 1 # Variable c_int
RPC_C_AUTHN_DCE_PRIVATE            = 1 # Variable c_int
RPC_C_QOS_CAPABILITIES_MUTUAL_AUTH = 1 # Variable c_int
RPC_C_BIND_TO_ALL_NICS             = 1 # Variable c_int
RPC_C_AUTHN_LEVEL_NONE             = 1 # Variable c_int
RPC_C_PROTECT_LEVEL_NONE           = 1 # Variable c_int
RPC_C_PARM_MAX_PACKET_LENGTH       = 1 # Variable c_int
RPC_C_SECURITY_QOS_VERSION         = 1 # Variable c_long
RPC_C_AUTHN_DCE_PUBLIC             = 2 # Variable c_int
RPC_C_IMP_LEVEL_IDENTIFY           = 2 # Variable c_int
RPC_C_MQ_CLEAR_ON_OPEN             = 2 # Variable c_int
RPC_C_PROFILE_MATCH_BY_IF          = 2 # Variable c_int
RPC_C_VERS_COMPATIBLE              = 2 # Variable c_int
RPC_C_PROTECT_LEVEL_CONNECT        = 2 # Variable c_int
RPC_C_MQ_JOURNAL_ALWAYS            = 2 # Variable c_int
RPC_C_AUTHN_LEVEL_CONNECT          = 2 # Variable c_int
RPC_IF_OLE                         = 2 # Variable c_int
RPC_C_PARM_BUFFER_LENGTH           = 2 # Variable c_int
RPC_C_STATS_PKTS_IN                = 2 # Variable c_int
RPC_NCA_FLAGS_BROADCAST            = 2 # Variable c_int
RPC_C_MGMT_INQ_STATS               = 2 # Variable c_int
RPC_C_AUTHZ_DCE                    = 2 # Variable c_int
RPC_C_EP_MATCH_BY_OBJ              = 2 # Variable c_int
RPC_C_OPT_MQ_PRIORITY              = 2 # Variable c_int
RPC_C_USE_INTRANET_PORT            = 2 # Variable c_int
RPC_C_VERS_EXACT                   = 3 # Variable c_int
RPC_C_PROFILE_MATCH_BY_MBR         = 3 # Variable c_int
RPC_C_MGMT_IS_SERVER_LISTEN        = 3 # Variable c_int
RPC_C_STATS_PKTS_OUT               = 3 # Variable c_int
RPC_C_IMP_LEVEL_IMPERSONATE        = 3 # Variable c_int
RPC_C_AUTHN_LEVEL_CALL             = 3 # Variable c_int
RPC_C_PROTECT_LEVEL_CALL           = 3 # Variable c_int
RPC_C_OPT_MQ_JOURNAL               = 3 # Variable c_int
RPC_C_NS_SYNTAX_DCE                = 3 # Variable c_int
RPC_C_EP_MATCH_BY_BOTH             = 3 # Variable c_int
RPC_C_PROTECT_LEVEL_PKT            = 4 # Variable c_int
RPC_C_PROFILE_MATCH_BY_BOTH        = 4 # Variable c_int
RPC_C_VERS_MAJOR_ONLY              = 4 # Variable c_int
RPC_C_OPT_MQ_ACKNOWLEDGE           = 4 # Variable c_int
RPC_C_AUTHN_LEVEL_PKT              = 4 # Variable c_int
RPC_C_MQ_USE_EXISTING_SECURITY     = 4 # Variable c_int
RPC_C_MGMT_STOP_SERVER_LISTEN      = 4 # Variable c_int
RPC_C_AUTHN_DEC_PUBLIC             = 4 # Variable c_int
RPC_C_IMP_LEVEL_DELEGATE           = 4 # Variable c_int
RPC_NCA_FLAGS_MAYBE                = 4 # Variable c_int
RPC_C_VERS_UPTO                    = 5 # Variable c_int
RPC_C_AUTHN_LEVEL_PKT_INTEGRITY    = 5 # Variable c_int
RPC_C_PROTECT_LEVEL_PKT_INTEGRITY  = 5 # Variable c_int
RPC_C_OPT_MQ_AUTHN_SERVICE         = 5 # Variable c_int
RPC_C_BINDING_DEFAULT_TIMEOUT      = 5 # Variable c_int
RPC_C_PROTECT_LEVEL_PKT_PRIVACY    = 6 # Variable c_int
RPC_C_OPT_MQ_AUTHN_LEVEL           = 6 # Variable c_int
RPC_C_AUTHN_LEVEL_PKT_PRIVACY      = 6 # Variable c_int
RPC_C_OPT_MQ_TIME_TO_REACH_QUEUE   = 7 # Variable c_int
RPC_C_MQ_AUTHN_LEVEL_PKT_INTEGRITY = 8 # Variable c_int
RPC_C_OPT_MQ_TIME_TO_BE_RECEIVED   = 8 # Variable c_int
RPC_C_OPT_BINDING_NONCAUSAL        = 9 # Variable c_int
RPC_C_BINDING_MAX_TIMEOUT          = 9 # Variable c_int
RPC_C_OPT_MAX_OPTIONS              = 10 # Variable c_int
RPC_C_PROTSEQ_MAX_REQS_DEFAULT     = 10 # Variable c_int
RPC_C_AUTHN_WINNT                  = 10 # Variable c_int
RPC_C_BINDING_INFINITE_TIMEOUT     = 10 # Variable c_int
RPC_C_AUTHN_DPA                    = 16 # Variable c_int
RPC_C_MQ_AUTHN_LEVEL_PKT_PRIVACY   = 16 # Variable c_int
RPC_C_AUTHN_MSN                    = 17 # Variable c_int
RPC_C_AUTHN_GSS_KERBEROS           = 18 # Variable c_int
RPC_ASYNC_VERSION_1_0              = 68 # Variable c_uint
RPC_C_AUTHN_MQ                     = 100 # Variable c_int
RPC_C_LISTEN_MAX_CALLS_DEFAULT     = 1234 # Variable c_int
RPC_S_INVALID_STRING_BINDING       = 1700 # Variable c_long
RPC_S_WRONG_KIND_OF_BINDING        = 1701 # Variable c_long
RPC_S_INVALID_BINDING              = 1702 # Variable c_long
RPC_S_PROTSEQ_NOT_SUPPORTED        = 1703 # Variable c_long
RPC_S_INVALID_RPC_PROTSEQ          = 1704 # Variable c_long
RPC_S_INVALID_STRING_UUID          = 1705 # Variable c_long
RPC_S_INVALID_ENDPOINT_FORMAT      = 1706 # Variable c_long
RPC_S_INVALID_NET_ADDR             = 1707 # Variable c_long
RPC_S_NO_ENDPOINT_FOUND            = 1708 # Variable c_long
RPC_S_INVALID_TIMEOUT              = 1709 # Variable c_long
RPC_S_OBJECT_NOT_FOUND             = 1710 # Variable c_long
RPC_S_ALREADY_REGISTERED           = 1711 # Variable c_long
RPC_S_TYPE_ALREADY_REGISTERED      = 1712 # Variable c_long
RPC_S_ALREADY_LISTENING            = 1713 # Variable c_long
RPC_S_NO_PROTSEQS_REGISTERED       = 1714 # Variable c_long
RPC_S_NOT_LISTENING                = 1715 # Variable c_long
RPC_S_UNKNOWN_MGR_TYPE             = 1716 # Variable c_long
RPC_S_UNKNOWN_IF                   = 1717 # Variable c_long
RPC_S_NO_BINDINGS                  = 1718 # Variable c_long
RPC_S_NO_PROTSEQS                  = 1719 # Variable c_long
RPC_S_CANT_CREATE_ENDPOINT         = 1720 # Variable c_long
RPC_S_OUT_OF_RESOURCES             = 1721 # Variable c_long
RPC_S_SERVER_UNAVAILABLE           = 1722 # Variable c_long
RPC_S_SERVER_TOO_BUSY              = 1723 # Variable c_long
RPC_S_INVALID_NETWORK_OPTIONS      = 1724 # Variable c_long
RPC_S_NO_CALL_ACTIVE               = 1725 # Variable c_long
RPC_S_CALL_FAILED                  = 1726 # Variable c_long
RPC_S_CALL_FAILED_DNE              = 1727 # Variable c_long
RPC_S_PROTOCOL_ERROR               = 1728 # Variable c_long
RPC_S_UNSUPPORTED_TRANS_SYN        = 1730 # Variable c_long
RPC_S_UNSUPPORTED_TYPE             = 1732 # Variable c_long
RPC_S_INVALID_TAG                  = 1733 # Variable c_long
RPC_S_INVALID_BOUND                = 1734 # Variable c_long
RPC_S_NO_ENTRY_NAME                = 1735 # Variable c_long
RPC_S_INVALID_NAME_SYNTAX          = 1736 # Variable c_long
RPC_S_UNSUPPORTED_NAME_SYNTAX      = 1737 # Variable c_long
RPC_S_UUID_NO_ADDRESS              = 1739 # Variable c_long
RPC_S_DUPLICATE_ENDPOINT           = 1740 # Variable c_long
RPC_S_UNKNOWN_AUTHN_TYPE           = 1741 # Variable c_long
RPC_S_MAX_CALLS_TOO_SMALL          = 1742 # Variable c_long
RPC_S_STRING_TOO_LONG              = 1743 # Variable c_long
RPC_S_PROTSEQ_NOT_FOUND            = 1744 # Variable c_long
RPC_S_PROCNUM_OUT_OF_RANGE         = 1745 # Variable c_long
RPC_S_BINDING_HAS_NO_AUTH          = 1746 # Variable c_long
RPC_S_UNKNOWN_AUTHN_SERVICE        = 1747 # Variable c_long
RPC_S_UNKNOWN_AUTHN_LEVEL          = 1748 # Variable c_long
RPC_S_INVALID_AUTH_IDENTITY        = 1749 # Variable c_long
RPC_S_UNKNOWN_AUTHZ_SERVICE        = 1750 # Variable c_long
RPC_S_NOTHING_TO_EXPORT            = 1754 # Variable c_long
RPC_S_INCOMPLETE_NAME              = 1755 # Variable c_long
RPC_S_INVALID_VERS_OPTION          = 1756 # Variable c_long
RPC_S_NO_MORE_MEMBERS              = 1757 # Variable c_long
RPC_S_NOT_ALL_OBJS_UNEXPORTED      = 1758 # Variable c_long
RPC_S_INTERFACE_NOT_FOUND          = 1759 # Variable c_long
RPC_S_ENTRY_ALREADY_EXISTS         = 1760 # Variable c_long
RPC_S_ENTRY_NOT_FOUND              = 1761 # Variable c_long
RPC_S_NAME_SERVICE_UNAVAILABLE     = 1762 # Variable c_long
RPC_S_INVALID_NAF_ID               = 1763 # Variable c_long
RPC_S_CANNOT_SUPPORT               = 1764 # Variable c_long
RPC_S_NO_CONTEXT_AVAILABLE         = 1765 # Variable c_long
RPC_S_INTERNAL_ERROR               = 1766 # Variable c_long
RPC_S_ZERO_DIVIDE                  = 1767 # Variable c_long
RPC_S_ADDRESS_ERROR                = 1768 # Variable c_long
RPC_S_FP_DIV_ZERO                  = 1769 # Variable c_long
RPC_S_FP_UNDERFLOW                 = 1770 # Variable c_long
RPC_S_FP_OVERFLOW                  = 1771 # Variable c_long
RPC_X_NO_MORE_ENTRIES              = 1772 # Variable c_long
RPC_X_SS_CHAR_TRANS_OPEN_FAIL      = 1773 # Variable c_long
RPC_X_SS_CHAR_TRANS_SHORT_FILE     = 1774 # Variable c_long
RPC_X_SS_IN_NULL_CONTEXT           = 1775 # Variable c_long
RPC_X_SS_CONTEXT_DAMAGED           = 1777 # Variable c_long
RPC_X_SS_HANDLES_MISMATCH          = 1778 # Variable c_long
RPC_X_SS_CANNOT_GET_CALL_HANDLE    = 1779 # Variable c_long
RPC_X_NULL_REF_POINTER             = 1780 # Variable c_long
RPC_X_ENUM_VALUE_OUT_OF_RANGE      = 1781 # Variable c_long
RPC_X_BYTE_COUNT_TOO_SMALL         = 1782 # Variable c_long
RPC_X_BAD_STUB_DATA                = 1783 # Variable c_long
RPC_S_CALL_IN_PROGRESS             = 1791 # Variable c_long
RPC_S_NO_MORE_BINDINGS             = 1806 # Variable c_long
RPC_S_NO_INTERFACES                = 1817 # Variable c_long
RPC_S_CALL_CANCELLED               = 1818 # Variable c_long
RPC_S_BINDING_INCOMPLETE           = 1819 # Variable c_long
RPC_S_COMM_FAILURE                 = 1820 # Variable c_long
RPC_S_UNSUPPORTED_AUTHN_LEVEL      = 1821 # Variable c_long
RPC_S_NO_PRINC_NAME                = 1822 # Variable c_long
RPC_S_NOT_RPC_ERROR                = 1823 # Variable c_long
RPC_S_UUID_LOCAL_ONLY              = 1824 # Variable c_long
RPC_S_SEC_PKG_ERROR                = 1825 # Variable c_long
RPC_S_NOT_CANCELLED                = 1826 # Variable c_long
RPC_X_INVALID_ES_ACTION            = 1827 # Variable c_long
RPC_X_WRONG_ES_VERSION             = 1828 # Variable c_long
RPC_X_WRONG_STUB_VERSION           = 1829 # Variable c_long
RPC_X_INVALID_PIPE_OBJECT          = 1830 # Variable c_long
RPC_X_WRONG_PIPE_ORDER             = 1831 # Variable c_long
RPC_X_WRONG_PIPE_VERSION           = 1832 # Variable c_long
RPC_S_GROUP_MEMBER_NOT_FOUND       = 1898 # Variable c_long
RPC_S_INVALID_OBJECT               = 1900 # Variable c_long
RPC_S_SEND_INCOMPLETE              = 1913 # Variable c_long
RPC_S_INVALID_ASYNC_HANDLE         = 1914 # Variable c_long
RPC_S_INVALID_ASYNC_CALL           = 1915 # Variable c_long
RPC_X_PIPE_CLOSED                  = 1916 # Variable c_long
RPC_X_PIPE_DISCIPLINE_ERROR        = 1917 # Variable c_long
RPC_X_PIPE_EMPTY                   = 1918 # Variable c_long
RPC_BUFFER_COMPLETE                = 4096 # Variable c_int
RPC_BUFFER_PARTIAL                 = 8192 # Variable c_int
RPC_BUFFER_EXTRA                   = 16384 # Variable c_int
RPC_BUFFER_ASYNC                   = 32768 # Variable c_int
RPC_FLAGS_VALID_BIT                = 32768 # Variable c_int
RPC_BUFFER_NONOTIFY                = 65536 # Variable c_int
RPC_C_AUTHN_DEFAULT                = 4294967295 # Variable c_ulong
RPC_C_NS_DEFAULT_EXP_AGE           = -1 # Variable c_int
RPC_C_CANCEL_INFINITE_TIMEOUT      = -1 # Variable c_int
RPC_E_UNEXPECTED                   = -2147352577 # Variable c_long
RPC_E_NO_SYNC                      = -2147417824 # Variable c_long
RPC_E_TIMEOUT                      = -2147417825 # Variable c_long
RPC_E_NO_CONTEXT                   = -2147417826 # Variable c_long
RPC_E_INVALID_OBJREF               = -2147417827 # Variable c_long
RPC_E_REMOTE_DISABLED              = -2147417828 # Variable c_long
RPC_E_ACCESS_DENIED                = -2147417829 # Variable c_long
RPC_E_NO_GOOD_SECURITY_PACKAGES    = -2147417830 # Variable c_long
RPC_E_TOO_LATE                     = -2147417831 # Variable c_long
RPC_E_UNSECURE_CALL                = -2147417832 # Variable c_long
RPC_E_CALL_COMPLETE                = -2147417833 # Variable c_long
RPC_S_WAITONTIMER                  = -2147417834 # Variable c_long
RPC_S_CALLPENDING                  = -2147417835 # Variable c_long
RPC_E_INVALID_OBJECT               = -2147417836 # Variable c_long
RPC_E_INVALID_IPID                 = -2147417837 # Variable c_long
RPC_E_INVALID_EXTENSION            = -2147417838 # Variable c_long
RPC_E_INVALID_HEADER               = -2147417839 # Variable c_long
RPC_E_VERSION_MISMATCH             = -2147417840 # Variable c_long
RPC_E_THREAD_NOT_INIT              = -2147417841 # Variable c_long
RPC_E_WRONG_THREAD                 = -2147417842 # Variable c_long
RPC_E_CANTCALLOUT_ININPUTSYNCCALL  = -2147417843 # Variable c_long
RPC_E_INVALID_CALLDATA             = -2147417844 # Variable c_long
RPC_E_SERVERCALL_REJECTED          = -2147417845 # Variable c_long
RPC_E_SERVERCALL_RETRYLATER        = -2147417846 # Variable c_long
RPC_E_RETRY                        = -2147417847 # Variable c_long
RPC_E_DISCONNECTED                 = -2147417848 # Variable c_long
RPC_E_INVALIDMETHOD                = -2147417849 # Variable c_long
RPC_E_CHANGED_MODE                 = -2147417850 # Variable c_long
RPC_E_SERVERFAULT                  = -2147417851 # Variable c_long
RPC_E_FAULT                        = -2147417852 # Variable c_long
RPC_E_NOT_REGISTERED               = -2147417853 # Variable c_long
RPC_E_ATTEMPTED_MULTITHREAD        = -2147417854 # Variable c_long
RPC_E_OUT_OF_RESOURCES             = -2147417855 # Variable c_long
RPC_E_SYS_CALL_FAILED              = -2147417856 # Variable c_long
RPC_E_SERVER_DIED_DNE              = -2147418094 # Variable c_long
RPC_E_CANTCALLOUT_AGAIN            = -2147418095 # Variable c_long
RPC_E_INVALID_PARAMETER            = -2147418096 # Variable c_long
RPC_E_INVALID_DATA                 = -2147418097 # Variable c_long
RPC_E_SERVER_CANTUNMARSHAL_DATA    = -2147418098 # Variable c_long
RPC_E_SERVER_CANTMARSHAL_DATA      = -2147418099 # Variable c_long
RPC_E_CLIENT_CANTUNMARSHAL_DATA    = -2147418100 # Variable c_long
RPC_E_CLIENT_CANTMARSHAL_DATA      = -2147418101 # Variable c_long
RPC_E_CANTTRANSMIT_CALL            = -2147418102 # Variable c_long
RPC_E_INVALID_DATAPACKET           = -2147418103 # Variable c_long
RPC_E_CLIENT_DIED                  = -2147418104 # Variable c_long
RPC_E_SERVER_DIED                  = -2147418105 # Variable c_long
RPC_E_CONNECTION_TERMINATED        = -2147418106 # Variable c_long
RPC_E_CANTCALLOUT_INEXTERNALCALL   = -2147418107 # Variable c_long
RPC_E_CANTCALLOUT_INASYNCCALL      = -2147418108 # Variable c_long
RPC_E_CANTPOST_INSENDCALL          = -2147418109 # Variable c_long
RPC_E_CALL_CANCELED                = -2147418110 # Variable c_long
RPC_E_CALL_REJECTED                = -2147418111 # Variable c_long

RP_LOGON   = 1 # Variable c_int
RP_INIFILE = 2 # Variable c_int

RTL_CRITSECT_TYPE = win32con.RTL_CRITSECT_TYPE # 0
RTL_RESOURCE_TYPE = win32con.RTL_RESOURCE_TYPE # 1

RTS_CONTROL_DISABLE   = win32con.RTS_CONTROL_DISABLE # 0
RTS_CONTROL_ENABLE    = win32con.RTS_CONTROL_ENABLE # 1
RTS_CONTROL_HANDSHAKE = win32con.RTS_CONTROL_HANDSHAKE # 2
RTS_CONTROL_TOGGLE    = win32con.RTS_CONTROL_TOGGLE # 3

RT_CURSOR       = win32con.RT_CURSOR # 1
RT_BITMAP       = win32con.RT_BITMAP # 2
RT_ICON         = win32con.RT_ICON # 3
RT_MENU         = win32con.RT_MENU # 4
RT_DIALOG       = win32con.RT_DIALOG # 5
RT_STRING       = win32con.RT_STRING # 6
RT_FONTDIR      = win32con.RT_FONTDIR # 7
RT_FONT         = win32con.RT_FONT # 8
RT_ACCELERATOR  = win32con.RT_ACCELERATOR # 9
RT_RCDATA       = win32con.RT_RCDATA # 10
RT_MESSAGETABLE = win32con.RT_MESSAGETABLE # 11
RT_GROUP_CURSOR = win32con.RT_GROUP_CURSOR # 12
RT_GROUP_ICON   = win32con.RT_GROUP_ICON # 14
RT_VERSION      = win32con.RT_VERSION # 16
RT_DLGINCLUDE   = win32con.RT_DLGINCLUDE # 17
RT_PLUGPLAY     = win32con.RT_PLUGPLAY # 19
RT_VXD          = win32con.RT_VXD # 20
RT_ANICURSOR    = win32con.RT_ANICURSOR # 21
RT_ANIICON      = win32con.RT_ANIICON # 22
RT_HTML         = win32con.RT_HTML # 23

RUSSIAN_CHARSET = win32con.RUSSIAN_CHARSET # 204

SACL_SECURITY_INFORMATION = win32con.SACL_SECURITY_INFORMATION # 8

SAVE_CTM = win32con.SAVE_CTM # 4101

SBARS_SIZEGRIP = 256 # Variable c_int

SBM_SETPOS         = win32con.SBM_SETPOS # 224
SBM_GETPOS         = win32con.SBM_GETPOS # 225
SBM_SETRANGE       = win32con.SBM_SETRANGE # 226
SBM_GETRANGE       = win32con.SBM_GETRANGE # 227
SBM_ENABLE_ARROWS  = win32con.SBM_ENABLE_ARROWS # 228
SBM_SETRANGEREDRAW = win32con.SBM_SETRANGEREDRAW # 230
SBM_SETSCROLLINFO  = win32con.SBM_SETSCROLLINFO # 233
SBM_GETSCROLLINFO  = win32con.SBM_GETSCROLLINFO # 234

SBN_LAST             = 4294966397 # Variable c_uint
SBN_SIMPLEMODECHANGE = 4294966416 # Variable c_uint
SBN_FIRST            = 4294966416 # Variable c_uint

SBS_HORZ                    = win32con.SBS_HORZ # 0
SBS_VERT                    = win32con.SBS_VERT # 1
SBS_SIZEBOXTOPLEFTALIGN     = win32con.SBS_SIZEBOXTOPLEFTALIGN # 2
SBS_LEFTALIGN               = win32con.SBS_LEFTALIGN # 2
SBS_TOPALIGN                = win32con.SBS_TOPALIGN # 2
SBS_SIZEBOXBOTTOMRIGHTALIGN = win32con.SBS_SIZEBOXBOTTOMRIGHTALIGN # 4
SBS_BOTTOMALIGN             = win32con.SBS_BOTTOMALIGN # 4
SBS_RIGHTALIGN              = win32con.SBS_RIGHTALIGN # 4
SBS_SIZEBOX                 = win32con.SBS_SIZEBOX # 8
SBS_SIZEGRIP                = win32con.SBS_SIZEGRIP # 16

SBT_NOBORDERS  = 256 # Variable c_int
SBT_POPOUT     = 512 # Variable c_int
SBT_RTLREADING = 1024 # Variable c_int
SBT_TOOLTIPS   = 2048 # Variable c_int
SBT_OWNERDRAW  = 4096 # Variable c_int

SB_LINELEFT       = win32con.SB_LINELEFT # 0
SB_HORZ           = win32con.SB_HORZ # 0
SB_LINEUP         = win32con.SB_LINEUP # 0
SB_LINERIGHT      = win32con.SB_LINERIGHT # 1
SB_LINEDOWN       = win32con.SB_LINEDOWN # 1
SB_VERT           = win32con.SB_VERT # 1
SB_CTL            = win32con.SB_CTL # 2
SB_PAGEUP         = win32con.SB_PAGEUP # 2
SB_PAGELEFT       = win32con.SB_PAGELEFT # 2
SB_BOTH           = win32con.SB_BOTH # 3
SB_PAGERIGHT      = win32con.SB_PAGERIGHT # 3
SB_PAGEDOWN       = win32con.SB_PAGEDOWN # 3
SB_THUMBPOSITION  = win32con.SB_THUMBPOSITION # 4
SB_THUMBTRACK     = win32con.SB_THUMBTRACK # 5
SB_TOP            = win32con.SB_TOP # 6
SB_LEFT           = win32con.SB_LEFT # 6
SB_RIGHT          = win32con.SB_RIGHT # 7
SB_BOTTOM         = win32con.SB_BOTTOM # 7
SB_ENDSCROLL      = win32con.SB_ENDSCROLL # 8
SB_SETTEXTA       = 1025 # Variable c_int
SB_GETTEXTA       = 1026 # Variable c_int
SB_GETTEXTLENGTHA = 1027 # Variable c_int
SB_SETPARTS       = 1028 # Variable c_int
SB_GETPARTS       = 1030 # Variable c_int
SB_GETBORDERS     = 1031 # Variable c_int
SB_SETMINHEIGHT   = 1032 # Variable c_int
SB_SIMPLE         = 1033 # Variable c_int
SB_GETRECT        = 1034 # Variable c_int
SB_SETTEXTW       = 1035 # Variable c_int
SB_GETTEXTLENGTHW = 1036 # Variable c_int
SB_GETTEXTW       = 1037 # Variable c_int
SB_ISSIMPLE       = 1038 # Variable c_int
SB_SETICON        = 1039 # Variable c_int
SB_SETTIPTEXTA    = 1040 # Variable c_int
SB_SETTIPTEXTW    = 1041 # Variable c_int
SB_GETTIPTEXTA    = 1042 # Variable c_int
SB_GETTIPTEXTW    = 1043 # Variable c_int
SB_GETICON        = 1044 # Variable c_int

SCREEN_FONTTYPE = win32con.SCREEN_FONTTYPE # 8192

SCROLLLOCK_ON = win32con.SCROLLLOCK_ON # 64

SCS_32BIT_BINARY           = win32con.SCS_32BIT_BINARY # 0
SCS_CAP_COMPSTR            = 1 # Variable c_int
SCS_DOS_BINARY             = win32con.SCS_DOS_BINARY # 1
SCS_CAP_MAKEREAD           = 2 # Variable c_int
SCS_WOW_BINARY             = win32con.SCS_WOW_BINARY # 2
SCS_PIF_BINARY             = win32con.SCS_PIF_BINARY # 3
SCS_POSIX_BINARY           = win32con.SCS_POSIX_BINARY # 4
SCS_CAP_SETRECONVERTSTRING = 4 # Variable c_int
SCS_OS216_BINARY           = win32con.SCS_OS216_BINARY # 5
SCS_SETSTR                 = 9 # Variable c_int
SCS_CHANGEATTR             = 18 # Variable c_int
SCS_CHANGECLAUSE           = 36 # Variable c_int
SCS_SETRECONVERTSTRING     = 65536 # Variable c_int
SCS_QUERYRECONVERTSTRING   = 131072 # Variable c_int

SC_ACTION_NONE                = 0
SC_ACTION_RESTART             = 1
SC_MANAGER_CONNECT            = 1 # Variable c_int
SC_ACTION_REBOOT              = 2
SC_MANAGER_CREATE_SERVICE     = 2 # Variable c_int
SC_ACTION_RUN_COMMAND         = 3
SC_MANAGER_ENUMERATE_SERVICE  = 4 # Variable c_int
SC_MANAGER_LOCK               = 8 # Variable c_int
SC_MANAGER_QUERY_LOCK_STATUS  = 16 # Variable c_int
SC_MANAGER_MODIFY_BOOT_CONFIG = 32 # Variable c_int
SC_SIZE                       = win32con.SC_SIZE # 61440
SC_SEPARATOR                  = win32con.SC_SEPARATOR # 61455
SC_MOVE                       = win32con.SC_MOVE # 61456
SC_MINIMIZE                   = win32con.SC_MINIMIZE # 61472
SC_MAXIMIZE                   = win32con.SC_MAXIMIZE # 61488
SC_NEXTWINDOW                 = win32con.SC_NEXTWINDOW # 61504
SC_PREVWINDOW                 = win32con.SC_PREVWINDOW # 61520
SC_CLOSE                      = win32con.SC_CLOSE # 61536
SC_VSCROLL                    = win32con.SC_VSCROLL # 61552
SC_HSCROLL                    = win32con.SC_HSCROLL # 61568
SC_MOUSEMENU                  = win32con.SC_MOUSEMENU # 61584
SC_KEYMENU                    = win32con.SC_KEYMENU # 61696
SC_ARRANGE                    = win32con.SC_ARRANGE # 61712
SC_RESTORE                    = win32con.SC_RESTORE # 61728
SC_TASKLIST                   = win32con.SC_TASKLIST # 61744
SC_SCREENSAVE                 = win32con.SC_SCREENSAVE # 61760
SC_HOTKEY                     = win32con.SC_HOTKEY # 61776
SC_DEFAULT                    = win32con.SC_DEFAULT # 61792
SC_MONITORPOWER               = win32con.SC_MONITORPOWER # 61808
SC_CONTEXTHELP                = win32con.SC_CONTEXTHELP # 61824
SC_MANAGER_ALL_ACCESS         = 983103 # Variable c_long
SC_GROUP_IDENTIFIERA          = '+' # Variable c_char
SC_GROUP_IDENTIFIERW          = '+' # Variable c_wchar

SECTION_QUERY       = win32con.SECTION_QUERY # 1
SECTION_MAP_WRITE   = win32con.SECTION_MAP_WRITE # 2
SECTION_MAP_READ    = win32con.SECTION_MAP_READ # 4
SECTION_MAP_EXECUTE = win32con.SECTION_MAP_EXECUTE # 8
SECTION_EXTEND_SIZE = win32con.SECTION_EXTEND_SIZE # 16
SECTION_ALL_ACCESS  = 983071 # Variable c_long

SECURITY_ANONYMOUS                  = 0 # Variable c_int
SECURITY_STATIC_TRACKING            = 0 # Variable c_int
SECURITY_WORLD_RID                  = win32con.SECURITY_WORLD_RID # 0
SECURITY_NULL_RID                   = win32con.SECURITY_NULL_RID # 0
SECURITY_CREATOR_OWNER_RID          = win32con.SECURITY_CREATOR_OWNER_RID # 0
SECURITY_LOCAL_RID                  = win32con.SECURITY_LOCAL_RID # 0
SECURITY_DESCRIPTOR_REVISION1       = win32con.SECURITY_DESCRIPTOR_REVISION1 # 1
SECURITY_DESCRIPTOR_REVISION        = win32con.SECURITY_DESCRIPTOR_REVISION # 1
SECURITY_DYNAMIC_TRACKING           = 1 # Variable c_int
SECURITY_CREATOR_GROUP_RID          = win32con.SECURITY_CREATOR_GROUP_RID # 1
SECURITY_DIALUP_RID                 = win32con.SECURITY_DIALUP_RID # 1
SECURITY_CREATOR_OWNER_SERVER_RID   = 2 # Variable c_long
SECURITY_NETWORK_RID                = win32con.SECURITY_NETWORK_RID # 2
SECURITY_LOGON_IDS_RID_COUNT        = win32con.SECURITY_LOGON_IDS_RID_COUNT # 3
SECURITY_BATCH_RID                  = win32con.SECURITY_BATCH_RID # 3
SECURITY_CREATOR_GROUP_SERVER_RID   = 3 # Variable c_long
SECURITY_INTERACTIVE_RID            = win32con.SECURITY_INTERACTIVE_RID # 4
SECURITY_LOGON_IDS_RID              = win32con.SECURITY_LOGON_IDS_RID # 5
SECURITY_SERVICE_RID                = win32con.SECURITY_SERVICE_RID # 6
SECURITY_ANONYMOUS_LOGON_RID        = win32con.SECURITY_ANONYMOUS_LOGON_RID # 7
SECURITY_PROXY_RID                  = 8 # Variable c_long
SECURITY_ENTERPRISE_CONTROLLERS_RID = 9 # Variable c_long
SECURITY_PRINCIPAL_SELF_RID         = 10 # Variable c_long
SECURITY_AUTHENTICATED_USER_RID     = 11 # Variable c_long
SECURITY_RESTRICTED_CODE_RID        = 12 # Variable c_long
SECURITY_LOCAL_SYSTEM_RID           = win32con.SECURITY_LOCAL_SYSTEM_RID # 18
SECURITY_DESCRIPTOR_MIN_LENGTH      = win32con.SECURITY_DESCRIPTOR_MIN_LENGTH # 20
SECURITY_NT_NON_UNIQUE              = win32con.SECURITY_NT_NON_UNIQUE # 21
SECURITY_BUILTIN_DOMAIN_RID         = win32con.SECURITY_BUILTIN_DOMAIN_RID # 32
SECURITY_IDENTIFICATION             = 65536 # Variable c_int
SECURITY_IMPERSONATION              = 131072 # Variable c_int
SECURITY_DELEGATION                 = 196608 # Variable c_int
SECURITY_CONTEXT_TRACKING           = win32con.SECURITY_CONTEXT_TRACKING # 262144
SECURITY_EFFECTIVE_ONLY             = win32con.SECURITY_EFFECTIVE_ONLY # 524288
SECURITY_SQOS_PRESENT               = win32con.SECURITY_SQOS_PRESENT # 1048576
SECURITY_VALID_SQOS_FLAGS           = win32con.SECURITY_VALID_SQOS_FLAGS # 2031616

SEC_WINNT_AUTH_IDENTITY_ANSI    = 1 # Variable c_int
SEC_WINNT_AUTH_IDENTITY_UNICODE = 2 # Variable c_int
SEC_FILE                        = win32con.SEC_FILE # 8388608
SEC_IMAGE                       = win32con.SEC_IMAGE # 16777216
SEC_VLM                         = 33554432 # Variable c_int
SEC_RESERVE                     = win32con.SEC_RESERVE # 67108864
SEC_COMMIT                      = win32con.SEC_COMMIT # 134217728
SEC_NOCACHE                     = win32con.SEC_NOCACHE # 268435456

SEEK_SET = 0 # Variable c_int
SEEK_CUR = 1 # Variable c_int
SEEK_END = 2 # Variable c_int

SEE_MASK_CLASSNAME      = 1 # Variable c_int
SEE_MASK_CLASSKEY       = 3 # Variable c_int
SEE_MASK_IDLIST         = 4 # Variable c_int
SEE_MASK_INVOKEIDLIST   = 12 # Variable c_int
SEE_MASK_ICON           = 16 # Variable c_int
SEE_MASK_HOTKEY         = 32 # Variable c_int
SEE_MASK_NOCLOSEPROCESS = 64 # Variable c_int
SEE_MASK_CONNECTNETDRV  = 128 # Variable c_int
SEE_MASK_FLAG_DDEWAIT   = 256 # Variable c_int
SEE_MASK_DOENVSUBST     = 512 # Variable c_int
SEE_MASK_FLAG_NO_UI     = 1024 # Variable c_int
SEE_MASK_UNICODE        = 16384 # Variable c_int
SEE_MASK_NO_CONSOLE     = 32768 # Variable c_int
SEE_MASK_ASYNCOK        = 1048576 # Variable c_int
SEE_MASK_HMONITOR       = 2097152 # Variable c_int

SEF_DACL_AUTO_INHERIT             = 1 # Variable c_int
SEF_SACL_AUTO_INHERIT             = 2 # Variable c_int
SEF_DEFAULT_DESCRIPTOR_FOR_OBJECT = 4 # Variable c_int
SEF_AVOID_PRIVILEGE_CHECK         = 8 # Variable c_int

SELECT_CAP_CONVERSION = 1 # Variable c_int
SELECT_CAP_SENTENCE   = 2 # Variable c_int

SEMAPHORE_MODIFY_STATE = win32con.SEMAPHORE_MODIFY_STATE # 2
SEMAPHORE_ALL_ACCESS   = 2031619 # Variable c_long

SEM_FAILCRITICALERRORS     = win32con.SEM_FAILCRITICALERRORS # 1
SEM_NOGPFAULTERRORBOX      = win32con.SEM_NOGPFAULTERRORBOX # 2
SEM_NOALIGNMENTFAULTEXCEPT = win32con.SEM_NOALIGNMENTFAULTEXCEPT # 4
SEM_NOOPENFILEERRORBOX     = win32con.SEM_NOOPENFILEERRORBOX # 32768

SERKF_SERIALKEYSON = win32con.SERKF_SERIALKEYSON # 1
SERKF_AVAILABLE    = win32con.SERKF_AVAILABLE # 2
SERKF_INDICATOR    = win32con.SERKF_INDICATOR # 4

SERVERCALL_ISHANDLED  = 0
SERVERCALL_REJECTED   = 1
SERVERCALL_RETRYLATER = 2

SERVER_ACCESS_ADMINISTER = 1 # Variable c_int
SERVER_ACCESS_ENUMERATE  = 2 # Variable c_int
SERVER_READ              = 131074 # Variable c_long
SERVER_EXECUTE           = 131074 # Variable c_long
SERVER_WRITE             = 131075 # Variable c_long
SERVER_ALL_ACCESS        = 983043 # Variable c_long

SERVICES_ACTIVE_DATABASEA = 'ServicesActive' # Variable POINTER(c_char)
SERVICES_ACTIVE_DATABASEW = 'ServicesActive' # Variable POINTER(c_wchar)
SERVICES_FAILED_DATABASEA = 'ServicesFailed' # Variable POINTER(c_char)
SERVICES_FAILED_DATABASEW = 'ServicesFailed' # Variable POINTER(c_wchar)

SERVICE_ERROR_IGNORE           = win32con.SERVICE_ERROR_IGNORE # 0
SERVICE_BOOT_START             = win32con.SERVICE_BOOT_START # 0
SERVICE_ERROR_NORMAL           = win32con.SERVICE_ERROR_NORMAL # 1
SERVICE_KERNEL_DRIVER          = win32con.SERVICE_KERNEL_DRIVER # 1
SERVICE_ACTIVE                 = 1 # Variable c_int
SERVICE_CONTROL_STOP           = 1 # Variable c_int
SERVICE_CONFIG_DESCRIPTION     = 1 # Variable c_int
SERVICE_QUERY_CONFIG           = 1 # Variable c_int
SERVICE_ACCEPT_STOP            = 1 # Variable c_int
SERVICE_SYSTEM_START           = win32con.SERVICE_SYSTEM_START # 1
SERVICE_STOPPED                = 1 # Variable c_int
SERVICE_CONFIG_FAILURE_ACTIONS = 2 # Variable c_int
SERVICE_AUTO_START             = win32con.SERVICE_AUTO_START # 2
SERVICE_ACCEPT_PAUSE_CONTINUE  = 2 # Variable c_int
SERVICE_FILE_SYSTEM_DRIVER     = win32con.SERVICE_FILE_SYSTEM_DRIVER # 2
SERVICE_ERROR_SEVERE           = win32con.SERVICE_ERROR_SEVERE # 2
SERVICE_CHANGE_CONFIG          = 2 # Variable c_int
SERVICE_CONTROL_PAUSE          = 2 # Variable c_int
SERVICE_START_PENDING          = 2 # Variable c_int
SERVICE_INACTIVE               = 2 # Variable c_int
SERVICE_CONTROL_CONTINUE       = 3 # Variable c_int
SERVICE_ERROR_CRITICAL         = win32con.SERVICE_ERROR_CRITICAL # 3
SERVICE_STOP_PENDING           = 3 # Variable c_int
SERVICE_DEMAND_START           = win32con.SERVICE_DEMAND_START # 3
SERVICE_STATE_ALL              = 3 # Variable c_int
SERVICE_DISABLED               = win32con.SERVICE_DISABLED # 4
SERVICE_CONTROL_INTERROGATE    = 4 # Variable c_int
SERVICE_ACCEPT_SHUTDOWN        = 4 # Variable c_int
SERVICE_RUNNING                = 4 # Variable c_int
SERVICE_QUERY_STATUS           = 4 # Variable c_int
SERVICE_ADAPTER                = win32con.SERVICE_ADAPTER # 4
SERVICE_CONTROL_SHUTDOWN       = 5 # Variable c_int
SERVICE_CONTINUE_PENDING       = 5 # Variable c_int
SERVICE_PAUSE_PENDING          = 6 # Variable c_int
SERVICE_CONTROL_PARAMCHANGE    = 6 # Variable c_int
SERVICE_CONTROL_NETBINDADD     = 7 # Variable c_int
SERVICE_PAUSED                 = 7 # Variable c_int
SERVICE_RECOGNIZER_DRIVER      = win32con.SERVICE_RECOGNIZER_DRIVER # 8
SERVICE_ACCEPT_PARAMCHANGE     = 8 # Variable c_int
SERVICE_CONTROL_NETBINDREMOVE  = 8 # Variable c_int
SERVICE_ENUMERATE_DEPENDENTS   = 8 # Variable c_int
SERVICE_CONTROL_NETBINDENABLE  = 9 # Variable c_int
SERVICE_CONTROL_NETBINDDISABLE = 10 # Variable c_int
SERVICE_DRIVER                 = win32con.SERVICE_DRIVER # 11
SERVICE_WIN32_OWN_PROCESS      = win32con.SERVICE_WIN32_OWN_PROCESS # 16
SERVICE_START                  = 16 # Variable c_int
SERVICE_ACCEPT_NETBINDCHANGE   = 16 # Variable c_int
SERVICE_WIN32_SHARE_PROCESS    = win32con.SERVICE_WIN32_SHARE_PROCESS # 32
SERVICE_STOP                   = 32 # Variable c_int
SERVICE_WIN32                  = win32con.SERVICE_WIN32 # 48
SERVICE_PAUSE_CONTINUE         = 64 # Variable c_int
SERVICE_INTERROGATE            = 128 # Variable c_int
SERVICE_INTERACTIVE_PROCESS    = win32con.SERVICE_INTERACTIVE_PROCESS # 256
SERVICE_USER_DEFINED_CONTROL   = 256 # Variable c_int
SERVICE_TYPE_ALL               = win32con.SERVICE_TYPE_ALL # 319
SERVICE_ALL_ACCESS             = 983551 # Variable c_long
SERVICE_NO_CHANGE              = 4294967295 # Variable c_uint

SESSION_ESTABLISHED = 3 # Variable c_int
SESSION_ABORTED     = 6 # Variable c_int

SETICMPROFILE_EMBEDED = 1 # Variable c_int

SET_TAPE_MEDIA_INFORMATION = win32con.SET_TAPE_MEDIA_INFORMATION # 0
SET_TAPE_DRIVE_INFORMATION = win32con.SET_TAPE_DRIVE_INFORMATION # 1
SET_ARC_DIRECTION          = win32con.SET_ARC_DIRECTION # 4102
SET_BACKGROUND_COLOR       = win32con.SET_BACKGROUND_COLOR # 4103
SET_POLY_MODE              = win32con.SET_POLY_MODE # 4104
SET_SCREEN_ANGLE           = win32con.SET_SCREEN_ANGLE # 4105
SET_SPREAD                 = win32con.SET_SPREAD # 4106
SET_CLIP_BOX               = win32con.SET_CLIP_BOX # 4108
SET_BOUNDS                 = win32con.SET_BOUNDS # 4109
SET_MIRROR_MODE            = win32con.SET_MIRROR_MODE # 4110

SEVERITY_SUCCESS = 0 # Variable c_int
SEVERITY_ERROR   = 1 # Variable c_int

SE_OWNER_DEFAULTED              = win32con.SE_OWNER_DEFAULTED # 1
SE_GROUP_MANDATORY              = win32con.SE_GROUP_MANDATORY # 1
SE_PRIVILEGE_ENABLED_BY_DEFAULT = win32con.SE_PRIVILEGE_ENABLED_BY_DEFAULT # 1
SE_GROUP_DEFAULTED              = win32con.SE_GROUP_DEFAULTED # 2
SE_ERR_FNF                      = 2 # Variable c_int
SE_GROUP_ENABLED_BY_DEFAULT     = win32con.SE_GROUP_ENABLED_BY_DEFAULT # 2
SE_PRIVILEGE_ENABLED            = win32con.SE_PRIVILEGE_ENABLED # 2
SE_ERR_PNF                      = 3 # Variable c_int
SE_DACL_PRESENT                 = win32con.SE_DACL_PRESENT # 4
SE_GROUP_ENABLED                = win32con.SE_GROUP_ENABLED # 4
SE_ERR_ACCESSDENIED             = 5 # Variable c_int
SE_DACL_DEFAULTED               = win32con.SE_DACL_DEFAULTED # 8
SE_ERR_OOM                      = 8 # Variable c_int
SE_GROUP_OWNER                  = win32con.SE_GROUP_OWNER # 8
SE_SACL_PRESENT                 = win32con.SE_SACL_PRESENT # 16
SE_GROUP_USE_FOR_DENY_ONLY      = 16 # Variable c_long
SE_ERR_SHARE                    = 26 # Variable c_int
SE_ERR_ASSOCINCOMPLETE          = 27 # Variable c_int
SE_ERR_DDETIMEOUT               = 28 # Variable c_int
SE_ERR_DDEFAIL                  = 29 # Variable c_int
SE_ERR_DDEBUSY                  = 30 # Variable c_int
SE_ERR_NOASSOC                  = 31 # Variable c_int
SE_SACL_DEFAULTED               = win32con.SE_SACL_DEFAULTED # 32
SE_ERR_DLLNOTFOUND              = 32 # Variable c_int
SE_DACL_AUTO_INHERIT_REQ        = 256 # Variable c_int
SE_SACL_AUTO_INHERIT_REQ        = 512 # Variable c_int
SE_DACL_AUTO_INHERITED          = 1024 # Variable c_int
SE_SACL_AUTO_INHERITED          = 2048 # Variable c_int
SE_DACL_PROTECTED               = 4096 # Variable c_int
SE_SACL_PROTECTED               = 8192 # Variable c_int
SE_SELF_RELATIVE                = win32con.SE_SELF_RELATIVE # 32768
SE_PRIVILEGE_USED_FOR_ACCESS    = win32con.SE_PRIVILEGE_USED_FOR_ACCESS # -2147483648
SE_GROUP_LOGON_ID               = win32con.SE_GROUP_LOGON_ID # -1073741824
SE_ASSIGNPRIMARYTOKEN_NAME      = win32con.SE_ASSIGNPRIMARYTOKEN_NAME # SeAssignPrimaryTokenPrivilege
SE_AUDIT_NAME                   = win32con.SE_AUDIT_NAME # SeAuditPrivilege
SE_BACKUP_NAME                  = win32con.SE_BACKUP_NAME # SeBackupPrivilege
SE_CHANGE_NOTIFY_NAME           = win32con.SE_CHANGE_NOTIFY_NAME # SeChangeNotifyPrivilege
SE_CREATE_PAGEFILE_NAME         = win32con.SE_CREATE_PAGEFILE_NAME # SeCreatePagefilePrivilege
SE_CREATE_PERMANENT_NAME        = win32con.SE_CREATE_PERMANENT_NAME # SeCreatePermanentPrivilege
SE_CREATE_TOKEN_NAME            = win32con.SE_CREATE_TOKEN_NAME # SeCreateTokenPrivilege
SE_DEBUG_NAME                   = win32con.SE_DEBUG_NAME # SeDebugPrivilege
SE_INC_BASE_PRIORITY_NAME       = win32con.SE_INC_BASE_PRIORITY_NAME # SeIncreaseBasePriorityPrivilege
SE_INCREASE_QUOTA_NAME          = win32con.SE_INCREASE_QUOTA_NAME # SeIncreaseQuotaPrivilege
SE_LOAD_DRIVER_NAME             = win32con.SE_LOAD_DRIVER_NAME # SeLoadDriverPrivilege
SE_LOCK_MEMORY_NAME             = win32con.SE_LOCK_MEMORY_NAME # SeLockMemoryPrivilege
SE_MACHINE_ACCOUNT_NAME         = win32con.SE_MACHINE_ACCOUNT_NAME # SeMachineAccountPrivilege
SE_PROF_SINGLE_PROCESS_NAME     = win32con.SE_PROF_SINGLE_PROCESS_NAME # SeProfileSingleProcessPrivilege
SE_REMOTE_SHUTDOWN_NAME         = win32con.SE_REMOTE_SHUTDOWN_NAME # SeRemoteShutdownPrivilege
SE_RESTORE_NAME                 = win32con.SE_RESTORE_NAME # SeRestorePrivilege
SE_SECURITY_NAME                = win32con.SE_SECURITY_NAME # SeSecurityPrivilege
SE_SHUTDOWN_NAME                = win32con.SE_SHUTDOWN_NAME # SeShutdownPrivilege
SE_SYSTEM_ENVIRONMENT_NAME      = win32con.SE_SYSTEM_ENVIRONMENT_NAME # SeSystemEnvironmentPrivilege
SE_SYSTEM_PROFILE_NAME          = win32con.SE_SYSTEM_PROFILE_NAME # SeSystemProfilePrivilege
SE_SYSTEMTIME_NAME              = win32con.SE_SYSTEMTIME_NAME # SeSystemtimePrivilege
SE_TAKE_OWNERSHIP_NAME          = win32con.SE_TAKE_OWNERSHIP_NAME # SeTakeOwnershipPrivilege
SE_TCB_NAME                     = win32con.SE_TCB_NAME # SeTcbPrivilege
SE_UNSOLICITED_INPUT_NAME       = win32con.SE_UNSOLICITED_INPUT_NAME # SeUnsolicitedInputPrivilege

SF_I2       = 2
SF_I4       = 3
SF_BSTR     = 8
SF_DISPATCH = 9
SF_ERROR    = 10
SF_VARIANT  = 12
SF_UNKNOWN  = 13
SF_I1       = 16
SF_I8       = 20
SF_RECORD   = 36
SF_HAVEIID  = 32781

SHERB_NOCONFIRMATION = 1 # Variable c_int
SHERB_NOPROGRESSUI   = 2 # Variable c_int
SHERB_NOSOUND        = 4 # Variable c_int

SHGFI_LARGEICON         = 0 # Variable c_int
SHGFI_SMALLICON         = 1 # Variable c_int
SHGFI_OPENICON          = 2 # Variable c_int
SHGFI_SHELLICONSIZE     = 4 # Variable c_int
SHGFI_PIDL              = 8 # Variable c_int
SHGFI_USEFILEATTRIBUTES = 16 # Variable c_int
SHGFI_ICON              = 256 # Variable c_int
SHGFI_DISPLAYNAME       = 512 # Variable c_int
SHGFI_TYPENAME          = 1024 # Variable c_int
SHGFI_ATTRIBUTES        = 2048 # Variable c_int
SHGFI_ICONLOCATION      = 4096 # Variable c_int
SHGFI_EXETYPE           = 8192 # Variable c_int
SHGFI_SYSICONINDEX      = 16384 # Variable c_int
SHGFI_LINKOVERLAY       = 32768 # Variable c_int
SHGFI_SELECTED          = 65536 # Variable c_int
SHGFI_ATTR_SPECIFIED    = 131072 # Variable c_int

SHGNLI_PIDL       = 1 # Variable c_int
SHGNLI_PREFIXNAME = 2 # Variable c_int
SHGNLI_NOUNIQUE   = 4 # Variable c_int

SHIFTJIS_CHARSET = win32con.SHIFTJIS_CHARSET # 128

SHIFT_PRESSED = win32con.SHIFT_PRESSED # 16

SHOW_OPENWINDOW     = win32con.SHOW_OPENWINDOW # 1
SHOW_ICONWINDOW     = win32con.SHOW_ICONWINDOW # 2
SHOW_FULLSCREEN     = win32con.SHOW_FULLSCREEN # 3
SHOW_OPENNOACTIVATE = win32con.SHOW_OPENNOACTIVATE # 4

SHUTDOWN_NORETRY = win32con.SHUTDOWN_NORETRY # 1

SID_RECOMMENDED_SUB_AUTHORITIES = 1 # Variable c_int
SID_REVISION                    = 1 # Variable c_int
SID_MAX_SUB_AUTHORITIES         = win32con.SID_MAX_SUB_AUTHORITIES # 15

SIF_RANGE           = win32con.SIF_RANGE # 1
SIF_PAGE            = win32con.SIF_PAGE # 2
SIF_POS             = win32con.SIF_POS # 4
SIF_DISABLENOSCROLL = win32con.SIF_DISABLENOSCROLL # 8
SIF_TRACKPOS        = win32con.SIF_TRACKPOS # 16
SIF_ALL             = win32con.SIF_ALL # 23

SIMULATED_FONTTYPE = win32con.SIMULATED_FONTTYPE # 32768

SIZEOF_RFPO_DATA = win32con.SIZEOF_RFPO_DATA # 16

SIZE_RESTORED           = win32con.SIZE_RESTORED # 0
SIZE_MINIMIZED          = win32con.SIZE_MINIMIZED # 1
SIZE_MAXIMIZED          = win32con.SIZE_MAXIMIZED # 2
SIZE_MAXSHOW            = win32con.SIZE_MAXSHOW # 3
SIZE_MAXHIDE            = win32con.SIZE_MAXHIDE # 4
SIZE_OF_80387_REGISTERS = win32con.SIZE_OF_80387_REGISTERS # 80

SKF_STICKYKEYSON    = win32con.SKF_STICKYKEYSON # 1
SKF_AVAILABLE       = win32con.SKF_AVAILABLE # 2
SKF_HOTKEYACTIVE    = win32con.SKF_HOTKEYACTIVE # 4
SKF_CONFIRMHOTKEY   = win32con.SKF_CONFIRMHOTKEY # 8
SKF_HOTKEYSOUND     = win32con.SKF_HOTKEYSOUND # 16
SKF_INDICATOR       = win32con.SKF_INDICATOR # 32
SKF_AUDIBLEFEEDBACK = win32con.SKF_AUDIBLEFEEDBACK # 64
SKF_TRISTATE        = win32con.SKF_TRISTATE # 128
SKF_TWOKEYSOFF      = win32con.SKF_TWOKEYSOFF # 256

SLE_ERROR      = win32con.SLE_ERROR # 1
SLE_MINORERROR = win32con.SLE_MINORERROR # 2
SLE_WARNING    = win32con.SLE_WARNING # 3

SMEXF_SERVER  = 1
SMEXF_HANDLER = 2

SMTO_NORMAL             = win32con.SMTO_NORMAL # 0
SMTO_NOTIMEOUTIFNOTHUNG = win32con.SMTO_NOTIMEOUTIFNOTHUNG # 8
SMTO_BLOCK              = win32con.SMTO_BLOCK # 1
SMTO_ABORTIFHUNG        = win32con.SMTO_ABORTIFHUNG # 2

SM_CXSCREEN          = win32con.SM_CXSCREEN # 0
SM_CYSCREEN          = win32con.SM_CYSCREEN # 1
SM_CXVSCROLL         = win32con.SM_CXVSCROLL # 2
SM_CYHSCROLL         = win32con.SM_CYHSCROLL # 3
SM_CYCAPTION         = win32con.SM_CYCAPTION # 4
SM_CXBORDER          = win32con.SM_CXBORDER # 5
SM_CYBORDER          = win32con.SM_CYBORDER # 6
SM_CXDLGFRAME        = win32con.SM_CXDLGFRAME # 7
SM_CYDLGFRAME        = win32con.SM_CYDLGFRAME # 8
SM_CYVTHUMB          = win32con.SM_CYVTHUMB # 9
SM_CXHTHUMB          = win32con.SM_CXHTHUMB # 10
SM_CXICON            = win32con.SM_CXICON # 11
SM_CYICON            = win32con.SM_CYICON # 12
SM_CXCURSOR          = win32con.SM_CXCURSOR # 13
SM_CYCURSOR          = win32con.SM_CYCURSOR # 14
SM_CYMENU            = win32con.SM_CYMENU # 15
SM_CXFULLSCREEN      = win32con.SM_CXFULLSCREEN # 16
SM_CYFULLSCREEN      = win32con.SM_CYFULLSCREEN # 17
SM_CYKANJIWINDOW     = win32con.SM_CYKANJIWINDOW # 18
SM_MOUSEPRESENT      = win32con.SM_MOUSEPRESENT # 19
SM_CYVSCROLL         = win32con.SM_CYVSCROLL # 20
SM_CXHSCROLL         = win32con.SM_CXHSCROLL # 21
SM_DEBUG             = win32con.SM_DEBUG # 22
SM_SWAPBUTTON        = win32con.SM_SWAPBUTTON # 23
SM_RESERVED1         = win32con.SM_RESERVED1 # 24
SM_RESERVED2         = win32con.SM_RESERVED2 # 25
SM_RESERVED3         = win32con.SM_RESERVED3 # 26
SM_RESERVED4         = win32con.SM_RESERVED4 # 27
SM_CXMIN             = win32con.SM_CXMIN # 28
SM_CYMIN             = win32con.SM_CYMIN # 29
SM_CXSIZE            = win32con.SM_CXSIZE # 30
SM_CYSIZE            = win32con.SM_CYSIZE # 31
SM_CXFRAME           = win32con.SM_CXFRAME # 32
SM_CYFRAME           = win32con.SM_CYFRAME # 33
SM_CXMINTRACK        = win32con.SM_CXMINTRACK # 34
SM_CYMINTRACK        = win32con.SM_CYMINTRACK # 35
SM_CXDOUBLECLK       = win32con.SM_CXDOUBLECLK # 36
SM_CYDOUBLECLK       = win32con.SM_CYDOUBLECLK # 37
SM_CXICONSPACING     = win32con.SM_CXICONSPACING # 38
SM_CYICONSPACING     = win32con.SM_CYICONSPACING # 39
SM_MENUDROPALIGNMENT = win32con.SM_MENUDROPALIGNMENT # 40
SM_PENWINDOWS        = win32con.SM_PENWINDOWS # 41
SM_DBCSENABLED       = win32con.SM_DBCSENABLED # 42
SM_CMOUSEBUTTONS     = win32con.SM_CMOUSEBUTTONS # 43
SM_SECURE            = win32con.SM_SECURE # 44
SM_CXEDGE            = win32con.SM_CXEDGE # 45
SM_CYEDGE            = win32con.SM_CYEDGE # 46
SM_CXMINSPACING      = win32con.SM_CXMINSPACING # 47
SM_CYMINSPACING      = win32con.SM_CYMINSPACING # 48
SM_CXSMICON          = win32con.SM_CXSMICON # 49
SM_CYSMICON          = win32con.SM_CYSMICON # 50
SM_CYSMCAPTION       = win32con.SM_CYSMCAPTION # 51
SM_CXSMSIZE          = win32con.SM_CXSMSIZE # 52
SM_CYSMSIZE          = win32con.SM_CYSMSIZE # 53
SM_CXMENUSIZE        = win32con.SM_CXMENUSIZE # 54
SM_CYMENUSIZE        = win32con.SM_CYMENUSIZE # 55
SM_ARRANGE           = win32con.SM_ARRANGE # 56
SM_CXMINIMIZED       = win32con.SM_CXMINIMIZED # 57
SM_CYMINIMIZED       = win32con.SM_CYMINIMIZED # 58
SM_CXMAXTRACK        = win32con.SM_CXMAXTRACK # 59
SM_CYMAXTRACK        = win32con.SM_CYMAXTRACK # 60
SM_CXMAXIMIZED       = win32con.SM_CXMAXIMIZED # 61
SM_CYMAXIMIZED       = win32con.SM_CYMAXIMIZED # 62
SM_NETWORK           = win32con.SM_NETWORK # 63
SM_CLEANBOOT         = win32con.SM_CLEANBOOT # 67
SM_CXDRAG            = win32con.SM_CXDRAG # 68
SM_CYDRAG            = win32con.SM_CYDRAG # 69
SM_SHOWSOUNDS        = win32con.SM_SHOWSOUNDS # 70
SM_CXMENUCHECK       = win32con.SM_CXMENUCHECK # 71
SM_CYMENUCHECK       = win32con.SM_CYMENUCHECK # 72
SM_SLOWMACHINE       = win32con.SM_SLOWMACHINE # 73
SM_MIDEASTENABLED    = win32con.SM_MIDEASTENABLED # 74
SM_CMETRICS          = win32con.SM_CMETRICS # 83

SND_SYNC                    = 0 # Variable c_int
SND_ALIAS_START             = 0 # Variable c_int
SND_ASYNC                   = 1 # Variable c_int
SND_NODEFAULT               = 2 # Variable c_int
SND_MEMORY                  = 4 # Variable c_int
SND_LOOP                    = 8 # Variable c_int
SND_NOSTOP                  = 16 # Variable c_int
SND_PURGE                   = 64 # Variable c_int
SND_APPLICATION             = 128 # Variable c_int
SND_NOWAIT                  = 8192 # Variable c_long
SND_ALIAS_SYSTEMEXCLAMATION = 8531 # Variable c_ulong
SND_ALIAS_SYSTEMASTERISK    = 10835 # Variable c_ulong
SND_ALIAS_SYSTEMQUESTION    = 16211 # Variable c_ulong
SND_ALIAS_SYSTEMDEFAULT     = 17491 # Variable c_ulong
SND_ALIAS_SYSTEMEXIT        = 17747 # Variable c_ulong
SND_ALIAS_SYSTEMHAND        = 18515 # Variable c_ulong
SND_ALIAS_SYSTEMSTART       = 21331 # Variable c_ulong
SND_ALIAS_SYSTEMWELCOME     = 22355 # Variable c_ulong
SND_ALIAS                   = 65536 # Variable c_long
SND_FILENAME                = 131072 # Variable c_long
SND_RESOURCE                = 262148 # Variable c_long
SND_ALIAS_ID                = 1114112 # Variable c_long

SOCKET_ERROR = -1 # Variable c_int

SOCK_STREAM    = 1 # Variable c_int
SOCK_DGRAM     = 2 # Variable c_int
SOCK_RAW       = 3 # Variable c_int
SOCK_RDM       = 4 # Variable c_int
SOCK_SEQPACKET = 5 # Variable c_int

SOFTDIST_ADSTATE_NONE             = 0 # Variable c_int
SOFTDIST_FLAG_USAGE_EMAIL         = 1 # Variable c_int
SOFTDIST_ADSTATE_AVAILABLE        = 1 # Variable c_int
SOFTDIST_FLAG_USAGE_PRECACHE      = 2 # Variable c_int
SOFTDIST_ADSTATE_DOWNLOADED       = 2 # Variable c_int
SOFTDIST_ADSTATE_INSTALLED        = 3 # Variable c_int
SOFTDIST_FLAG_USAGE_AUTOINSTALL   = 4 # Variable c_int
SOFTDIST_FLAG_DELETE_SUBSCRIPTION = 8 # Variable c_int

SOFTKEYBOARD_TYPE_T1 = 1 # Variable c_int
SOFTKEYBOARD_TYPE_C1 = 2 # Variable c_int

SOL_SOCKET = 65535 # Variable c_int

SORT_KOREAN_KSC           = win32con.SORT_KOREAN_KSC # 0
SORT_CHINESE_BIG5         = win32con.SORT_CHINESE_BIG5 # 0
SORT_DEFAULT              = win32con.SORT_DEFAULT # 0
SORT_GEORGIAN_TRADITIONAL = 0 # Variable c_int
SORT_HUNGARIAN_DEFAULT    = 0 # Variable c_int
SORT_CHINESE_PRCP         = 0 # Variable c_int
SORT_JAPANESE_XJIS        = win32con.SORT_JAPANESE_XJIS # 0
SORT_GEORGIAN_MODERN      = 1 # Variable c_int
SORT_KOREAN_UNICODE       = win32con.SORT_KOREAN_UNICODE # 1
SORT_GERMAN_PHONE_BOOK    = 1 # Variable c_int
SORT_JAPANESE_UNICODE     = win32con.SORT_JAPANESE_UNICODE # 1
SORT_CHINESE_UNICODE      = win32con.SORT_CHINESE_UNICODE # 1
SORT_HUNGARIAN_TECHNICAL  = 1 # Variable c_int
SORT_CHINESE_PRC          = 2 # Variable c_int
SORT_CHINESE_BOPOMOFO     = 3 # Variable c_int
SORT_STRINGSORT           = 4096 # Variable c_int

SO_DEBUG                 = 1 # Variable c_int
SO_ACCEPTCONN            = 2 # Variable c_int
SO_REUSEADDR             = 4 # Variable c_int
SO_KEEPALIVE             = 8 # Variable c_int
SO_SYNCHRONOUS_ALERT     = 16 # Variable c_int
SO_DONTROUTE             = 16 # Variable c_int
SO_SYNCHRONOUS_NONALERT  = 32 # Variable c_int
SO_BROADCAST             = 32 # Variable c_int
SO_USELOOPBACK           = 64 # Variable c_int
SO_LINGER                = 128 # Variable c_int
SO_OOBINLINE             = 256 # Variable c_int
SO_SNDBUF                = 4097 # Variable c_int
SO_RCVBUF                = 4098 # Variable c_int
SO_SNDLOWAT              = 4099 # Variable c_int
SO_RCVLOWAT              = 4100 # Variable c_int
SO_SNDTIMEO              = 4101 # Variable c_int
SO_RCVTIMEO              = 4102 # Variable c_int
SO_ERROR                 = 4103 # Variable c_int
SO_TYPE                  = 4104 # Variable c_int
SO_CONNDATA              = 28672 # Variable c_int
SO_CONNOPT               = 28673 # Variable c_int
SO_DISCDATA              = 28674 # Variable c_int
SO_DISCOPT               = 28675 # Variable c_int
SO_CONNDATALEN           = 28676 # Variable c_int
SO_CONNOPTLEN            = 28677 # Variable c_int
SO_DISCDATALEN           = 28678 # Variable c_int
SO_DISCOPTLEN            = 28679 # Variable c_int
SO_OPENTYPE              = 28680 # Variable c_int
SO_MAXDG                 = 28681 # Variable c_int
SO_MAXPATHDG             = 28682 # Variable c_int
SO_UPDATE_ACCEPT_CONTEXT = 28683 # Variable c_int
SO_CONNECT_TIME          = 28684 # Variable c_int
SO_DONTLINGER            = 4294967167 # Variable c_uint

SPAPI_E_ERROR_NOT_INSTALLED         = -2146496512 # Variable c_long
SPAPI_E_INVALID_FILTER_DRIVER       = -2146500052 # Variable c_long
SPAPI_E_DI_DONT_INSTALL             = -2146500053 # Variable c_long
SPAPI_E_INVALID_INF_LOGCONFIG       = -2146500054 # Variable c_long
SPAPI_E_NO_DEVICE_ICON              = -2146500055 # Variable c_long
SPAPI_E_NO_COMPAT_DRIVERS           = -2146500056 # Variable c_long
SPAPI_E_INVALID_COINSTALLER         = -2146500057 # Variable c_long
SPAPI_E_DI_POSTPROCESSING_REQUIRED  = -2146500058 # Variable c_long
SPAPI_E_NO_SUCH_DEVICE_INTERFACE    = -2146500059 # Variable c_long
SPAPI_E_INVALID_PROPPAGE_PROVIDER   = -2146500060 # Variable c_long
SPAPI_E_NO_CONFIGMGR_SERVICES       = -2146500061 # Variable c_long
SPAPI_E_MACHINE_UNAVAILABLE         = -2146500062 # Variable c_long
SPAPI_E_REMOTE_COMM_FAILURE         = -2146500063 # Variable c_long
SPAPI_E_INVALID_MACHINENAME         = -2146500064 # Variable c_long
SPAPI_E_INVALID_REFERENCE_STRING    = -2146500065 # Variable c_long
SPAPI_E_NO_SUCH_INTERFACE_CLASS     = -2146500066 # Variable c_long
SPAPI_E_BAD_INTERFACE_INSTALLSECT   = -2146500067 # Variable c_long
SPAPI_E_DEVICE_INTERFACE_REMOVED    = -2146500068 # Variable c_long
SPAPI_E_DEVICE_INTERFACE_ACTIVE     = -2146500069 # Variable c_long
SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE = -2146500070 # Variable c_long
SPAPI_E_NO_ASSOCIATED_SERVICE       = -2146500071 # Variable c_long
SPAPI_E_NO_CLASS_DRIVER_LIST        = -2146500072 # Variable c_long
SPAPI_E_BAD_SERVICE_INSTALLSECT     = -2146500073 # Variable c_long
SPAPI_E_FILEQUEUE_LOCKED            = -2146500074 # Variable c_long
SPAPI_E_NO_CLASSINSTALL_PARAMS      = -2146500075 # Variable c_long
SPAPI_E_DI_BAD_PATH                 = -2146500076 # Variable c_long
SPAPI_E_DEVINFO_DATA_LOCKED         = -2146500077 # Variable c_long
SPAPI_E_DEVINFO_LIST_LOCKED         = -2146500078 # Variable c_long
SPAPI_E_NO_DEVICE_SELECTED          = -2146500079 # Variable c_long
SPAPI_E_INVALID_HWPROFILE           = -2146500080 # Variable c_long
SPAPI_E_DI_NOFILECOPY               = -2146500081 # Variable c_long
SPAPI_E_DI_DO_DEFAULT               = -2146500082 # Variable c_long
SPAPI_E_INVALID_CLASS_INSTALLER     = -2146500083 # Variable c_long
SPAPI_E_CANT_LOAD_CLASS_ICON        = -2146500084 # Variable c_long
SPAPI_E_NO_SUCH_DEVINST             = -2146500085 # Variable c_long
SPAPI_E_NO_INF                      = -2146500086 # Variable c_long
SPAPI_E_INVALID_REG_PROPERTY        = -2146500087 # Variable c_long
SPAPI_E_DEVINFO_NOT_REGISTERED      = -2146500088 # Variable c_long
SPAPI_E_DEVINST_ALREADY_EXISTS      = -2146500089 # Variable c_long
SPAPI_E_INVALID_CLASS               = -2146500090 # Variable c_long
SPAPI_E_INVALID_DEVINST_NAME        = -2146500091 # Variable c_long
SPAPI_E_KEY_DOES_NOT_EXIST          = -2146500092 # Variable c_long
SPAPI_E_NO_DRIVER_SELECTED          = -2146500093 # Variable c_long
SPAPI_E_DUPLICATE_FOUND             = -2146500094 # Variable c_long
SPAPI_E_CLASS_MISMATCH              = -2146500095 # Variable c_long
SPAPI_E_NO_ASSOCIATED_CLASS         = -2146500096 # Variable c_long
SPAPI_E_LINE_NOT_FOUND              = -2146500350 # Variable c_long
SPAPI_E_SECTION_NOT_FOUND           = -2146500351 # Variable c_long
SPAPI_E_WRONG_INF_STYLE             = -2146500352 # Variable c_long
SPAPI_E_GENERAL_SYNTAX              = -2146500605 # Variable c_long
SPAPI_E_SECTION_NAME_TOO_LONG       = -2146500606 # Variable c_long
SPAPI_E_BAD_SECTION_NAME_LINE       = -2146500607 # Variable c_long
SPAPI_E_EXPECTED_SECTION_NAME       = -2146500608 # Variable c_long

SPECIFIC_RIGHTS_ALL = win32con.SPECIFIC_RIGHTS_ALL # 65535

SPIF_UPDATEINIFILE    = win32con.SPIF_UPDATEINIFILE # 1
SPIF_SENDWININICHANGE = win32con.SPIF_SENDWININICHANGE # 2
SPIF_SENDCHANGE       = win32con.SPIF_SENDCHANGE # 2

SPI_GETMENUUNDERLINES         = win32con.SPI_GETMENUUNDERLINES # 4106
SPI_SETMENUUNDERLINES         = win32con.SPI_SETMENUUNDERLINES # 4107
SPI_GETACTIVEWNDTRKZORDER     = win32con.SPI_GETACTIVEWNDTRKZORDER # 4108
SPI_SETACTIVEWNDTRKZORDER     = win32con.SPI_SETACTIVEWNDTRKZORDER # 4109
SPI_GETHOTTRACKING            = win32con.SPI_GETHOTTRACKING # 4110
SPI_SETHOTTRACKING            = win32con.SPI_SETHOTTRACKING # 4111
SPI_GETACTIVEWINDOWTRACKING   = win32con.SPI_GETACTIVEWINDOWTRACKING # 4096
SPI_SETACTIVEWINDOWTRACKING   = win32con.SPI_SETACTIVEWINDOWTRACKING # 4097
SPI_GETMENUANIMATION          = win32con.SPI_GETMENUANIMATION # 4098
SPI_SETMENUANIMATION          = win32con.SPI_SETMENUANIMATION # 4099
SPI_GETCOMBOBOXANIMATION      = win32con.SPI_GETCOMBOBOXANIMATION # 4100
SPI_SETCOMBOBOXANIMATION      = win32con.SPI_SETCOMBOBOXANIMATION # 4101
SPI_GETLISTBOXSMOOTHSCROLLING = win32con.SPI_GETLISTBOXSMOOTHSCROLLING # 4102
SPI_SETLISTBOXSMOOTHSCROLLING = win32con.SPI_SETLISTBOXSMOOTHSCROLLING # 4103
SPI_GETGRADIENTCAPTIONS       = win32con.SPI_GETGRADIENTCAPTIONS # 4104
SPI_SETGRADIENTCAPTIONS       = win32con.SPI_SETGRADIENTCAPTIONS # 4105
SPI_GETFOREGROUNDLOCKTIMEOUT  = win32con.SPI_GETFOREGROUNDLOCKTIMEOUT # 8192
SPI_SETFOREGROUNDLOCKTIMEOUT  = win32con.SPI_SETFOREGROUNDLOCKTIMEOUT # 8193
SPI_GETACTIVEWNDTRKTIMEOUT    = win32con.SPI_GETACTIVEWNDTRKTIMEOUT # 8194
SPI_SETACTIVEWNDTRKTIMEOUT    = win32con.SPI_SETACTIVEWNDTRKTIMEOUT # 8195
SPI_GETFOREGROUNDFLASHCOUNT   = win32con.SPI_GETFOREGROUNDFLASHCOUNT # 8196
SPI_SETFOREGROUNDFLASHCOUNT   = win32con.SPI_SETFOREGROUNDFLASHCOUNT # 8197
SPI_GETBEEP                   = win32con.SPI_GETBEEP # 1
SPI_SETBEEP                   = win32con.SPI_SETBEEP # 2
SPI_GETMOUSE                  = win32con.SPI_GETMOUSE # 3
SPI_SETMOUSE                  = win32con.SPI_SETMOUSE # 4
SPI_GETBORDER                 = win32con.SPI_GETBORDER # 5
SPI_SETBORDER                 = win32con.SPI_SETBORDER # 6
SPI_GETKEYBOARDSPEED          = win32con.SPI_GETKEYBOARDSPEED # 10
SPI_SETKEYBOARDSPEED          = win32con.SPI_SETKEYBOARDSPEED # 11
SPI_LANGDRIVER                = win32con.SPI_LANGDRIVER # 12
SPI_ICONHORIZONTALSPACING     = win32con.SPI_ICONHORIZONTALSPACING # 13
SPI_GETSCREENSAVETIMEOUT      = win32con.SPI_GETSCREENSAVETIMEOUT # 14
SPI_SETSCREENSAVETIMEOUT      = win32con.SPI_SETSCREENSAVETIMEOUT # 15
SPI_GETSCREENSAVEACTIVE       = win32con.SPI_GETSCREENSAVEACTIVE # 16
SPI_SETSCREENSAVEACTIVE       = win32con.SPI_SETSCREENSAVEACTIVE # 17
SPI_GETGRIDGRANULARITY        = win32con.SPI_GETGRIDGRANULARITY # 18
SPI_SETGRIDGRANULARITY        = win32con.SPI_SETGRIDGRANULARITY # 19
SPI_SETDESKWALLPAPER          = win32con.SPI_SETDESKWALLPAPER # 20
SPI_SETDESKPATTERN            = win32con.SPI_SETDESKPATTERN # 21
SPI_GETKEYBOARDDELAY          = win32con.SPI_GETKEYBOARDDELAY # 22
SPI_SETKEYBOARDDELAY          = win32con.SPI_SETKEYBOARDDELAY # 23
SPI_ICONVERTICALSPACING       = win32con.SPI_ICONVERTICALSPACING # 24
SPI_GETICONTITLEWRAP          = win32con.SPI_GETICONTITLEWRAP # 25
SPI_SETICONTITLEWRAP          = win32con.SPI_SETICONTITLEWRAP # 26
SPI_GETMENUDROPALIGNMENT      = win32con.SPI_GETMENUDROPALIGNMENT # 27
SPI_SETMENUDROPALIGNMENT      = win32con.SPI_SETMENUDROPALIGNMENT # 28
SPI_SETDOUBLECLKWIDTH         = win32con.SPI_SETDOUBLECLKWIDTH # 29
SPI_SETDOUBLECLKHEIGHT        = win32con.SPI_SETDOUBLECLKHEIGHT # 30
SPI_GETICONTITLELOGFONT       = win32con.SPI_GETICONTITLELOGFONT # 31
SPI_SETDOUBLECLICKTIME        = win32con.SPI_SETDOUBLECLICKTIME # 32
SPI_SETMOUSEBUTTONSWAP        = win32con.SPI_SETMOUSEBUTTONSWAP # 33
SPI_SETICONTITLELOGFONT       = win32con.SPI_SETICONTITLELOGFONT # 34
SPI_GETFASTTASKSWITCH         = win32con.SPI_GETFASTTASKSWITCH # 35
SPI_SETFASTTASKSWITCH         = win32con.SPI_SETFASTTASKSWITCH # 36
SPI_SETDRAGFULLWINDOWS        = win32con.SPI_SETDRAGFULLWINDOWS # 37
SPI_GETDRAGFULLWINDOWS        = win32con.SPI_GETDRAGFULLWINDOWS # 38
SPI_GETNONCLIENTMETRICS       = win32con.SPI_GETNONCLIENTMETRICS # 41
SPI_SETNONCLIENTMETRICS       = win32con.SPI_SETNONCLIENTMETRICS # 42
SPI_GETMINIMIZEDMETRICS       = win32con.SPI_GETMINIMIZEDMETRICS # 43
SPI_SETMINIMIZEDMETRICS       = win32con.SPI_SETMINIMIZEDMETRICS # 44
SPI_GETICONMETRICS            = win32con.SPI_GETICONMETRICS # 45
SPI_SETICONMETRICS            = win32con.SPI_SETICONMETRICS # 46
SPI_SETWORKAREA               = win32con.SPI_SETWORKAREA # 47
SPI_GETWORKAREA               = win32con.SPI_GETWORKAREA # 48
SPI_SETPENWINDOWS             = win32con.SPI_SETPENWINDOWS # 49
SPI_GETFILTERKEYS             = win32con.SPI_GETFILTERKEYS # 50
SPI_SETFILTERKEYS             = win32con.SPI_SETFILTERKEYS # 51
SPI_GETTOGGLEKEYS             = win32con.SPI_GETTOGGLEKEYS # 52
SPI_SETTOGGLEKEYS             = win32con.SPI_SETTOGGLEKEYS # 53
SPI_GETMOUSEKEYS              = win32con.SPI_GETMOUSEKEYS # 54
SPI_SETMOUSEKEYS              = win32con.SPI_SETMOUSEKEYS # 55
SPI_GETSHOWSOUNDS             = win32con.SPI_GETSHOWSOUNDS # 56
SPI_SETSHOWSOUNDS             = win32con.SPI_SETSHOWSOUNDS # 57
SPI_GETSTICKYKEYS             = win32con.SPI_GETSTICKYKEYS # 58
SPI_SETSTICKYKEYS             = win32con.SPI_SETSTICKYKEYS # 59
SPI_GETACCESSTIMEOUT          = win32con.SPI_GETACCESSTIMEOUT # 60
SPI_SETACCESSTIMEOUT          = win32con.SPI_SETACCESSTIMEOUT # 61
SPI_GETSERIALKEYS             = win32con.SPI_GETSERIALKEYS # 62
SPI_SETSERIALKEYS             = win32con.SPI_SETSERIALKEYS # 63
SPI_GETSOUNDSENTRY            = win32con.SPI_GETSOUNDSENTRY # 64
SPI_SETSOUNDSENTRY            = win32con.SPI_SETSOUNDSENTRY # 65
SPI_GETHIGHCONTRAST           = win32con.SPI_GETHIGHCONTRAST # 66
SPI_SETHIGHCONTRAST           = win32con.SPI_SETHIGHCONTRAST # 67
SPI_GETKEYBOARDPREF           = win32con.SPI_GETKEYBOARDPREF # 68
SPI_SETKEYBOARDPREF           = win32con.SPI_SETKEYBOARDPREF # 69
SPI_GETSCREENREADER           = win32con.SPI_GETSCREENREADER # 70
SPI_SETSCREENREADER           = win32con.SPI_SETSCREENREADER # 71
SPI_GETANIMATION              = win32con.SPI_GETANIMATION # 72
SPI_SETANIMATION              = win32con.SPI_SETANIMATION # 73
SPI_GETFONTSMOOTHING          = win32con.SPI_GETFONTSMOOTHING # 74
SPI_SETFONTSMOOTHING          = win32con.SPI_SETFONTSMOOTHING # 75
SPI_SETDRAGWIDTH              = win32con.SPI_SETDRAGWIDTH # 76
SPI_SETDRAGHEIGHT             = win32con.SPI_SETDRAGHEIGHT # 77
SPI_SETHANDHELD               = win32con.SPI_SETHANDHELD # 78
SPI_GETLOWPOWERTIMEOUT        = win32con.SPI_GETLOWPOWERTIMEOUT # 79
SPI_GETPOWEROFFTIMEOUT        = win32con.SPI_GETPOWEROFFTIMEOUT # 80
SPI_SETLOWPOWERTIMEOUT        = win32con.SPI_SETLOWPOWERTIMEOUT # 81
SPI_SETPOWEROFFTIMEOUT        = win32con.SPI_SETPOWEROFFTIMEOUT # 82
SPI_GETLOWPOWERACTIVE         = win32con.SPI_GETLOWPOWERACTIVE # 83
SPI_GETPOWEROFFACTIVE         = win32con.SPI_GETPOWEROFFACTIVE # 84
SPI_SETLOWPOWERACTIVE         = win32con.SPI_SETLOWPOWERACTIVE # 85
SPI_SETPOWEROFFACTIVE         = win32con.SPI_SETPOWEROFFACTIVE # 86
SPI_SETCURSORS                = win32con.SPI_SETCURSORS # 87
SPI_SETICONS                  = win32con.SPI_SETICONS # 88
SPI_GETDEFAULTINPUTLANG       = win32con.SPI_GETDEFAULTINPUTLANG # 89
SPI_SETDEFAULTINPUTLANG       = win32con.SPI_SETDEFAULTINPUTLANG # 90
SPI_SETLANGTOGGLE             = win32con.SPI_SETLANGTOGGLE # 91
SPI_GETWINDOWSEXTENSION       = win32con.SPI_GETWINDOWSEXTENSION # 92
SPI_SETMOUSETRAILS            = win32con.SPI_SETMOUSETRAILS # 93
SPI_GETMOUSETRAILS            = win32con.SPI_GETMOUSETRAILS # 94
SPI_SETSCREENSAVERRUNNING     = win32con.SPI_SETSCREENSAVERRUNNING # 97
SPI_GETMOUSEHOVERWIDTH        = win32con.SPI_GETMOUSEHOVERWIDTH # 98
SPI_SETMOUSEHOVERWIDTH        = win32con.SPI_SETMOUSEHOVERWIDTH # 99
SPI_GETMOUSEHOVERHEIGHT       = win32con.SPI_GETMOUSEHOVERHEIGHT # 100
SPI_SETMOUSEHOVERHEIGHT       = win32con.SPI_SETMOUSEHOVERHEIGHT # 101
SPI_GETMOUSEHOVERTIME         = win32con.SPI_GETMOUSEHOVERTIME # 102
SPI_SETMOUSEHOVERTIME         = win32con.SPI_SETMOUSEHOVERTIME # 103
SPI_GETWHEELSCROLLLINES       = win32con.SPI_GETWHEELSCROLLLINES # 104
SPI_SETWHEELSCROLLLINES       = win32con.SPI_SETWHEELSCROLLLINES # 105
SPI_GETSHOWIMEUI              = win32con.SPI_GETSHOWIMEUI # 110
SPI_SETSHOWIMEUI              = win32con.SPI_SETSHOWIMEUI # 111
SPI_GETMOUSESPEED             = win32con.SPI_GETMOUSESPEED # 112
SPI_SETMOUSESPEED             = win32con.SPI_SETMOUSESPEED # 113
SPI_GETSCREENSAVERRUNNING     = win32con.SPI_GETSCREENSAVERRUNNING # 114

SPLDS_DRIVER_KEY                     = 'DsDriver' # Variable POINTER(c_wchar)
SPLDS_SPOOLER_KEY                    = 'DsSpooler' # Variable POINTER(c_wchar)
SPLDS_USER_KEY                       = 'DsUser' # Variable POINTER(c_wchar)
SPLDS_ASSET_NUMBER                   = 'assetNumber' # Variable POINTER(c_wchar)
SPLDS_BYTES_PER_MINUTE               = 'bytesPerMinute' # Variable POINTER(c_wchar)
SPLDS_DESCRIPTION                    = 'description' # Variable POINTER(c_wchar)
SPLDS_DRIVER_NAME                    = 'driverName' # Variable POINTER(c_wchar)
SPLDS_DRIVER_VERSION                 = 'driverVersion' # Variable POINTER(c_wchar)
SPLDS_LOCATION                       = 'location' # Variable POINTER(c_wchar)
SPLDS_PORT_NAME                      = 'portName' # Variable POINTER(c_wchar)
SPLDS_PRINT_ATTRIBUTES               = 'printAttributes' # Variable POINTER(c_wchar)
SPLDS_PRINT_BIN_NAMES                = 'printBinNames' # Variable POINTER(c_wchar)
SPLDS_PRINT_COLLATE                  = 'printCollate' # Variable POINTER(c_wchar)
SPLDS_PRINT_COLOR                    = 'printColor' # Variable POINTER(c_wchar)
SPLDS_PRINT_DUPLEX_SUPPORTED         = 'printDuplexSupported' # Variable POINTER(c_wchar)
SPLDS_PRINT_END_TIME                 = 'printEndTime' # Variable POINTER(c_wchar)
SPLDS_PRINT_KEEP_PRINTED_JOBS        = 'printKeepPrintedJobs' # Variable POINTER(c_wchar)
SPLDS_PRINT_LANGUAGE                 = 'printLanguage' # Variable POINTER(c_wchar)
SPLDS_PRINT_MAC_ADDRESS              = 'printMACAddress' # Variable POINTER(c_wchar)
SPLDS_PRINT_MAX_RESOLUTION_SUPPORTED = 'printMaxResolutionSupported' # Variable POINTER(c_wchar)
SPLDS_PRINT_MAX_X_EXTENT             = 'printMaxXExtent' # Variable POINTER(c_wchar)
SPLDS_PRINT_MAX_Y_EXTENT             = 'printMaxYExtent' # Variable POINTER(c_wchar)
SPLDS_PRINT_MEDIA_READY              = 'printMediaReady' # Variable POINTER(c_wchar)
SPLDS_PRINT_MEDIA_SUPPORTED          = 'printMediaSupported' # Variable POINTER(c_wchar)
SPLDS_PRINT_MEMORY                   = 'printMemory' # Variable POINTER(c_wchar)
SPLDS_PRINT_MIN_X_EXTENT             = 'printMinXExtent' # Variable POINTER(c_wchar)
SPLDS_PRINT_MIN_Y_EXTENT             = 'printMinYExtent' # Variable POINTER(c_wchar)
SPLDS_PRINT_NETWORK_ADDRESS          = 'printNetworkAddress' # Variable POINTER(c_wchar)
SPLDS_PRINT_NOTIFY                   = 'printNotify' # Variable POINTER(c_wchar)
SPLDS_PRINT_NUMBER_UP                = 'printNumberUp' # Variable POINTER(c_wchar)
SPLDS_PRINT_ORIENTATIONS_SUPPORTED   = 'printOrientationsSupported' # Variable POINTER(c_wchar)
SPLDS_PRINT_OWNER                    = 'printOwner' # Variable POINTER(c_wchar)
SPLDS_PRINTER_CLASS                  = 'printQueue' # Variable POINTER(c_wchar)
SPLDS_PRINT_RATE                     = 'printRate' # Variable POINTER(c_wchar)
SPLDS_PRINT_RATE_UNIT                = 'printRateUnit' # Variable POINTER(c_wchar)
SPLDS_PRINT_SEPARATOR_FILE           = 'printSeparatorFile' # Variable POINTER(c_wchar)
SPLDS_PRINT_SHARE_NAME               = 'printShareName' # Variable POINTER(c_wchar)
SPLDS_PRINT_SPOOLING                 = 'printSpooling' # Variable POINTER(c_wchar)
SPLDS_PRINT_STAPLING_SUPPORTED       = 'printStaplingSupported' # Variable POINTER(c_wchar)
SPLDS_PRINT_START_TIME               = 'printStartTime' # Variable POINTER(c_wchar)
SPLDS_PRINT_STATUS                   = 'printStatus' # Variable POINTER(c_wchar)
SPLDS_PRINTER_LOCATIONS              = 'printerLocations' # Variable POINTER(c_wchar)
SPLDS_PRINTER_MODEL                  = 'printerModel' # Variable POINTER(c_wchar)
SPLDS_PRINTER_NAME                   = 'printerName' # Variable POINTER(c_wchar)
SPLDS_PRINTER_NAME_ALIASES           = 'printerNameAliases' # Variable POINTER(c_wchar)
SPLDS_PRIORITY                       = 'priority' # Variable POINTER(c_wchar)
SPLDS_SERVER_NAME                    = 'serverName' # Variable POINTER(c_wchar)
SPLDS_UNC_NAME                       = 'uNCName' # Variable POINTER(c_wchar)
SPLDS_URL                            = 'url' # Variable POINTER(c_wchar)
SPLDS_VERSION_NUMBER                 = 'versionNumber' # Variable POINTER(c_wchar)

SPLREG_ARCHITECTURE                      = 'Architecture' # Variable POINTER(c_wchar)
SPLREG_BEEP_ENABLED                      = 'BeepEnabled' # Variable POINTER(c_wchar)
SPLREG_DEFAULT_SPOOL_DIRECTORY           = 'DefaultSpoolDirectory' # Variable POINTER(c_wchar)
SPLREG_DS_PRESENT                        = 'DsPresent' # Variable POINTER(c_wchar)
SPLREG_EVENT_LOG                         = 'EventLog' # Variable POINTER(c_wchar)
SPLREG_MAJOR_VERSION                     = 'MajorVersion' # Variable POINTER(c_wchar)
SPLREG_MINOR_VERSION                     = 'MinorVersion' # Variable POINTER(c_wchar)
SPLREG_NET_POPUP                         = 'NetPopup' # Variable POINTER(c_wchar)
SPLREG_OS_VERSION                        = 'OSVersion' # Variable POINTER(c_wchar)
SPLREG_PORT_THREAD_PRIORITY              = 'PortThreadPriority' # Variable POINTER(c_wchar)
SPLREG_PORT_THREAD_PRIORITY_DEFAULT      = 'PortThreadPriorityDefault' # Variable POINTER(c_wchar)
SPLREG_SCHEDULER_THREAD_PRIORITY         = 'SchedulerThreadPriority' # Variable POINTER(c_wchar)
SPLREG_SCHEDULER_THREAD_PRIORITY_DEFAULT = 'SchedulerThreadPriorityDefault' # Variable POINTER(c_wchar)

SP_PARITY       = 1 # Variable c_ulong
SP_SERIALCOMM   = 1 # Variable c_ulong
SP_BAUD         = 2 # Variable c_ulong
SP_DATABITS     = 4 # Variable c_ulong
SP_STOPBITS     = 8 # Variable c_ulong
SP_HANDSHAKING  = 16 # Variable c_ulong
SP_PARITY_CHECK = 32 # Variable c_ulong
SP_RLSD         = 64 # Variable c_ulong
SP_NOTREPORTED  = win32con.SP_NOTREPORTED # 16384
SP_ERROR        = win32con.SP_ERROR # -1
SP_APPABORT     = win32con.SP_APPABORT # -2
SP_USERABORT    = win32con.SP_USERABORT # -3
SP_OUTOFDISK    = win32con.SP_OUTOFDISK # -4
SP_OUTOFMEMORY  = win32con.SP_OUTOFMEMORY # -5

SRVINFO_F_COSERVERINFO  = 0
SRVINFO_F_COSERVERINFO2 = 1

SSF_SOUNDSENTRYON = win32con.SSF_SOUNDSENTRYON # 1
SSF_AVAILABLE     = win32con.SSF_AVAILABLE # 2
SSF_INDICATOR     = win32con.SSF_INDICATOR # 4

SSGF_NONE    = win32con.SSGF_NONE # 0
SSGF_DISPLAY = win32con.SSGF_DISPLAY # 3

SSTF_NONE    = win32con.SSTF_NONE # 0
SSTF_CHARS   = win32con.SSTF_CHARS # 1
SSTF_BORDER  = win32con.SSTF_BORDER # 2
SSTF_DISPLAY = win32con.SSTF_DISPLAY # 3

SSWF_NONE    = win32con.SSWF_NONE # 0
SSWF_TITLE   = win32con.SSWF_TITLE # 1
SSWF_WINDOW  = win32con.SSWF_WINDOW # 2
SSWF_DISPLAY = win32con.SSWF_DISPLAY # 3
SSWF_CUSTOM  = win32con.SSWF_CUSTOM # 4

SS_LEFT           = win32con.SS_LEFT # 0
SS_CENTER         = win32con.SS_CENTER # 1
SS_RIGHT          = win32con.SS_RIGHT # 2
SS_ICON           = win32con.SS_ICON # 3
SS_BLACKRECT      = win32con.SS_BLACKRECT # 4
SS_GRAYRECT       = win32con.SS_GRAYRECT # 5
SS_WHITERECT      = win32con.SS_WHITERECT # 6
SS_BLACKFRAME     = win32con.SS_BLACKFRAME # 7
SS_GRAYFRAME      = win32con.SS_GRAYFRAME # 8
SS_WHITEFRAME     = win32con.SS_WHITEFRAME # 9
SS_USERITEM       = win32con.SS_USERITEM # 10
SS_SIMPLE         = win32con.SS_SIMPLE # 11
SS_LEFTNOWORDWRAP = win32con.SS_LEFTNOWORDWRAP # 12
SS_OWNERDRAW      = win32con.SS_OWNERDRAW # 13
SS_BITMAP         = win32con.SS_BITMAP # 14
SS_ENHMETAFILE    = win32con.SS_ENHMETAFILE # 15
SS_ETCHEDHORZ     = win32con.SS_ETCHEDHORZ # 16
SS_ETCHEDVERT     = win32con.SS_ETCHEDVERT # 17
SS_ETCHEDFRAME    = win32con.SS_ETCHEDFRAME # 18
SS_TYPEMASK       = win32con.SS_TYPEMASK # 31
SS_NOPREFIX       = win32con.SS_NOPREFIX # 128
SS_NOTIFY         = win32con.SS_NOTIFY # 256
SS_CENTERIMAGE    = win32con.SS_CENTERIMAGE # 512
SS_RIGHTJUST      = win32con.SS_RIGHTJUST # 1024
SS_REALSIZEIMAGE  = win32con.SS_REALSIZEIMAGE # 2048
SS_SUNKEN         = win32con.SS_SUNKEN # 4096
SS_ENDELLIPSIS    = win32con.SS_ENDELLIPSIS # 16384
SS_PATHELLIPSIS   = win32con.SS_PATHELLIPSIS # 32768
SS_ELLIPSISMASK   = win32con.SS_ELLIPSISMASK # 49152
SS_WORDELLIPSIS   = win32con.SS_WORDELLIPSIS # 49152

STANDARD_RIGHTS_WRITE    = win32con.STANDARD_RIGHTS_WRITE # 131072
STANDARD_RIGHTS_READ     = win32con.STANDARD_RIGHTS_READ # 131072
STANDARD_RIGHTS_EXECUTE  = win32con.STANDARD_RIGHTS_EXECUTE # 131072
STANDARD_RIGHTS_REQUIRED = win32con.STANDARD_RIGHTS_REQUIRED # 983040
STANDARD_RIGHTS_ALL      = win32con.STANDARD_RIGHTS_ALL # 2031616

STARTF_USESHOWWINDOW    = win32con.STARTF_USESHOWWINDOW # 1
STARTF_USESIZE          = win32con.STARTF_USESIZE # 2
STARTF_USEPOSITION      = win32con.STARTF_USEPOSITION # 4
STARTF_USECOUNTCHARS    = win32con.STARTF_USECOUNTCHARS # 8
STARTF_USEFILLATTRIBUTE = win32con.STARTF_USEFILLATTRIBUTE # 16
STARTF_RUNFULLSCREEN    = 32 # Variable c_int
STARTF_FORCEONFEEDBACK  = win32con.STARTF_FORCEONFEEDBACK # 64
STARTF_FORCEOFFFEEDBACK = win32con.STARTF_FORCEOFFFEEDBACK # 128
STARTF_USESTDHANDLES    = win32con.STARTF_USESTDHANDLES # 256
STARTF_USEHOTKEY        = win32con.STARTF_USEHOTKEY # 512

STATFLAG_DEFAULT = 0
STATFLAG_NONAME  = 1
STATFLAG_NOOPEN  = 2

STATUS_WAIT_0                   = win32con.STATUS_WAIT_0 # 0
STATUS_ABANDONED_WAIT_0         = win32con.STATUS_ABANDONED_WAIT_0 # 128
STATUS_USER_APC                 = win32con.STATUS_USER_APC # 192
STATUS_TIMEOUT                  = win32con.STATUS_TIMEOUT # 258
STATUS_PENDING                  = win32con.STATUS_PENDING # 259
STATUS_SEGMENT_NOTIFICATION     = win32con.STATUS_SEGMENT_NOTIFICATION # 1073741829
STATUS_GUARD_PAGE_VIOLATION     = win32con.STATUS_GUARD_PAGE_VIOLATION # -2147483647
STATUS_DATATYPE_MISALIGNMENT    = win32con.STATUS_DATATYPE_MISALIGNMENT # -2147483646
STATUS_BREAKPOINT               = win32con.STATUS_BREAKPOINT # -2147483645
STATUS_SINGLE_STEP              = win32con.STATUS_SINGLE_STEP # -2147483644
STATUS_ACCESS_VIOLATION         = win32con.STATUS_ACCESS_VIOLATION # -1073741819
STATUS_IN_PAGE_ERROR            = win32con.STATUS_IN_PAGE_ERROR # -1073741818
STATUS_INVALID_HANDLE           = win32con.STATUS_INVALID_HANDLE # -1073741816
STATUS_NO_MEMORY                = win32con.STATUS_NO_MEMORY # -1073741801
STATUS_ILLEGAL_INSTRUCTION      = win32con.STATUS_ILLEGAL_INSTRUCTION # -1073741795
STATUS_NONCONTINUABLE_EXCEPTION = win32con.STATUS_NONCONTINUABLE_EXCEPTION # -1073741787
STATUS_INVALID_DISPOSITION      = win32con.STATUS_INVALID_DISPOSITION # -1073741786
STATUS_ARRAY_BOUNDS_EXCEEDED    = win32con.STATUS_ARRAY_BOUNDS_EXCEEDED # -1073741684
STATUS_FLOAT_DENORMAL_OPERAND   = win32con.STATUS_FLOAT_DENORMAL_OPERAND # -1073741683
STATUS_FLOAT_DIVIDE_BY_ZERO     = win32con.STATUS_FLOAT_DIVIDE_BY_ZERO # -1073741682
STATUS_FLOAT_INEXACT_RESULT     = win32con.STATUS_FLOAT_INEXACT_RESULT # -1073741681
STATUS_FLOAT_INVALID_OPERATION  = win32con.STATUS_FLOAT_INVALID_OPERATION # -1073741680
STATUS_FLOAT_OVERFLOW           = win32con.STATUS_FLOAT_OVERFLOW # -1073741679
STATUS_FLOAT_STACK_CHECK        = win32con.STATUS_FLOAT_STACK_CHECK # -1073741678
STATUS_FLOAT_UNDERFLOW          = win32con.STATUS_FLOAT_UNDERFLOW # -1073741677
STATUS_INTEGER_DIVIDE_BY_ZERO   = win32con.STATUS_INTEGER_DIVIDE_BY_ZERO # -1073741676
STATUS_INTEGER_OVERFLOW         = win32con.STATUS_INTEGER_OVERFLOW # -1073741675
STATUS_PRIVILEGED_INSTRUCTION   = win32con.STATUS_PRIVILEGED_INSTRUCTION # -1073741674
STATUS_STACK_OVERFLOW           = win32con.STATUS_STACK_OVERFLOW # -1073741571
STATUS_CONTROL_C_EXIT           = win32con.STATUS_CONTROL_C_EXIT # -1073741510
STATUS_FLOAT_MULTIPLE_FAULTS    = 3221226164 # Variable c_ulong
STATUS_FLOAT_MULTIPLE_TRAPS     = 3221226165 # Variable c_ulong
STATUS_ILLEGAL_VLM_REFERENCE    = 3221226176 # Variable c_ulong

STDOLE2_LCID        = 0 # Variable c_int
STDOLE2_MINORVERNUM = 0 # Variable c_int
STDOLE2_MAJORVERNUM = 2 # Variable c_int

STDOLE_MINORVERNUM = 0 # Variable c_int
STDOLE_LCID        = 0 # Variable c_int
STDOLE_MAJORVERNUM = 1 # Variable c_int

STD_CUT           = 0 # Variable c_int
STD_COPY          = 1 # Variable c_int
STD_PASTE         = 2 # Variable c_int
STD_UNDO          = 3 # Variable c_int
STD_REDOW         = 4 # Variable c_int
STD_DELETE        = 5 # Variable c_int
STD_FILENEW       = 6 # Variable c_int
STD_FILEOPEN      = 7 # Variable c_int
STD_FILESAVE      = 8 # Variable c_int
STD_PRINTPRE      = 9 # Variable c_int
STD_PROPERTIES    = 10 # Variable c_int
STD_HELP          = 11 # Variable c_int
STD_FIND          = 12 # Variable c_int
STD_REPLACE       = 13 # Variable c_int
STD_PRINT         = 14 # Variable c_int
STD_ERROR_HANDLE  = 4294967284 # Variable c_ulong
STD_OUTPUT_HANDLE = 4294967285 # Variable c_ulong
STD_INPUT_HANDLE  = 4294967286 # Variable c_ulong

STGC_DEFAULT                            = 0
STGC_OVERWRITE                          = 1
STGC_ONLYIFCURRENT                      = 2
STGC_DANGEROUSLYCOMMITMERELYTODISKCACHE = 4
STGC_CONSOLIDATE                        = 8

STGFMT_DOCUMENT = 0 # Variable c_int
STGFMT_STORAGE  = 0 # Variable c_int
STGFMT_NATIVE   = 1 # Variable c_int
STGFMT_FILE     = 3 # Variable c_int
STGFMT_ANY      = 4 # Variable c_int
STGFMT_DOCFILE  = 5 # Variable c_int

STGMOVE_MOVE        = 0
STGMOVE_COPY        = 1
STGMOVE_SHALLOWCOPY = 2

STGM_DIRECT           = 0 # Variable c_long
STGM_FAILIFTHERE      = 0 # Variable c_long
STGM_READ             = 0 # Variable c_long
STGM_WRITE            = 1 # Variable c_long
STGM_READWRITE        = 2 # Variable c_long
STGM_SHARE_EXCLUSIVE  = 16 # Variable c_long
STGM_SHARE_DENY_WRITE = 32 # Variable c_long
STGM_SHARE_DENY_READ  = 48 # Variable c_long
STGM_SHARE_DENY_NONE  = 64 # Variable c_long
STGM_CREATE           = 4096 # Variable c_long
STGM_TRANSACTED       = 65536 # Variable c_long
STGM_CONVERT          = 131072 # Variable c_long
STGM_PRIORITY         = 262144 # Variable c_long
STGM_NOSCRATCH        = 1048576 # Variable c_long
STGM_NOSNAPSHOT       = 2097152 # Variable c_long
STGM_DELETEONRELEASE  = 67108864 # Variable c_long
STGM_SIMPLE           = 134217728 # Variable c_long

STGTY_STORAGE   = 1
STGTY_STREAM    = 2
STGTY_LOCKBYTES = 3
STGTY_PROPERTY  = 4
STGTY_REPEAT    = 256 # Variable c_long

STG_LAYOUT_SEQUENTIAL       = 0 # Variable c_long
STG_LAYOUT_INTERLEAVED      = 1 # Variable c_long
STG_S_CONVERTED             = 197120 # Variable c_long
STG_S_BLOCK                 = 197121 # Variable c_long
STG_S_RETRYNOW              = 197122 # Variable c_long
STG_S_MONITORING            = 197123 # Variable c_long
STG_S_MULTIPLEOPENS         = 197124 # Variable c_long
STG_S_CONSOLIDATIONFAILED   = 197125 # Variable c_long
STG_S_CANNOTCONSOLIDATE     = 197126 # Variable c_long
STG_TOEND                   = 4294967295 # Variable c_ulong
STG_E_TERMINATED            = -2147286526 # Variable c_long
STG_E_INCOMPLETE            = -2147286527 # Variable c_long
STG_E_BADBASEADDRESS        = -2147286768 # Variable c_long
STG_E_DOCFILECORRUPT        = -2147286775 # Variable c_long
STG_E_EXTANTMARSHALLINGS    = -2147286776 # Variable c_long
STG_E_NOTFILEBASEDSTORAGE   = -2147286777 # Variable c_long
STG_E_SHAREREQUIRED         = -2147286778 # Variable c_long
STG_E_OLDDLL                = -2147286779 # Variable c_long
STG_E_OLDFORMAT             = -2147286780 # Variable c_long
STG_E_CANTSAVE              = -2147286781 # Variable c_long
STG_E_REVERTED              = -2147286782 # Variable c_long
STG_E_NOTCURRENT            = -2147286783 # Variable c_long
STG_E_INUSE                 = -2147286784 # Variable c_long
STG_E_INVALIDFLAG           = -2147286785 # Variable c_long
STG_E_UNIMPLEMENTEDFUNCTION = -2147286786 # Variable c_long
STG_E_UNKNOWN               = -2147286787 # Variable c_long
STG_E_INVALIDNAME           = -2147286788 # Variable c_long
STG_E_INVALIDHEADER         = -2147286789 # Variable c_long
STG_E_ABNORMALAPIEXIT       = -2147286790 # Variable c_long
STG_E_PROPSETMISMATCHED     = -2147286800 # Variable c_long
STG_E_MEDIUMFULL            = -2147286928 # Variable c_long
STG_E_INVALIDPARAMETER      = -2147286953 # Variable c_long
STG_E_FILEALREADYEXISTS     = -2147286960 # Variable c_long
STG_E_LOCKVIOLATION         = -2147287007 # Variable c_long
STG_E_SHAREVIOLATION        = -2147287008 # Variable c_long
STG_E_READFAULT             = -2147287010 # Variable c_long
STG_E_WRITEFAULT            = -2147287011 # Variable c_long
STG_E_SEEKERROR             = -2147287015 # Variable c_long
STG_E_DISKISWRITEPROTECTED  = -2147287021 # Variable c_long
STG_E_NOMOREFILES           = -2147287022 # Variable c_long
STG_E_INVALIDPOINTER        = -2147287031 # Variable c_long
STG_E_INSUFFICIENTMEMORY    = -2147287032 # Variable c_long
STG_E_INVALIDHANDLE         = -2147287034 # Variable c_long
STG_E_ACCESSDENIED          = -2147287035 # Variable c_long
STG_E_TOOMANYOPENFILES      = -2147287036 # Variable c_long
STG_E_PATHNOTFOUND          = -2147287037 # Variable c_long
STG_E_FILENOTFOUND          = -2147287038 # Variable c_long
STG_E_INVALIDFUNCTION       = -2147287039 # Variable c_long

STM_SETICON  = win32con.STM_SETICON # 368
STM_GETICON  = win32con.STM_GETICON # 369
STM_SETIMAGE = win32con.STM_SETIMAGE # 370
STM_GETIMAGE = win32con.STM_GETIMAGE # 371
STM_MSGMAX   = win32con.STM_MSGMAX # 372

STN_CLICKED = win32con.STN_CLICKED # 0
STN_DBLCLK  = win32con.STN_DBLCLK # 1
STN_ENABLE  = win32con.STN_ENABLE # 2
STN_DISABLE = win32con.STN_DISABLE # 3

STOCK_LAST = win32con.STOCK_LAST # 16

STOPBITS_10 = 1 # Variable c_ushort
STOPBITS_15 = 2 # Variable c_ushort
STOPBITS_20 = 4 # Variable c_ushort

STREAM_SEEK_SET            = 0
STREAM_NORMAL_ATTRIBUTE    = win32con.STREAM_NORMAL_ATTRIBUTE # 0
STREAM_SEEK_CUR            = 1
STREAM_MODIFIED_WHEN_READ  = win32con.STREAM_MODIFIED_WHEN_READ # 1
STREAM_SEEK_END            = 2
STREAM_CONTAINS_SECURITY   = win32con.STREAM_CONTAINS_SECURITY # 2
STREAM_CONTAINS_PROPERTIES = win32con.STREAM_CONTAINS_PROPERTIES # 4
STREAM_SPARSE_ATTRIBUTE    = 8 # Variable c_int

STUB_UNMARSHAL              = 0
STUB_CALL_SERVER            = 1
STUB_MARSHAL                = 2
STUB_CALL_SERVER_NO_HRESULT = 3
STUB_PHASE                  = c_int # enum

STYLE_DESCRIPTION_SIZE = 32 # Variable c_int

ST_DEFAULT    = 0
ST_KEEPUNDO   = 1
ST_CONNECTED  = 1 # Variable c_int
ST_SELECTION  = 2
ST_ADVISE     = 2 # Variable c_int
ST_NEWCHARS   = 4
ST_ISLOCAL    = 4 # Variable c_int
ST_BLOCKED    = 8 # Variable c_int
ST_CLIENT     = 16 # Variable c_int
ST_TERMINATED = 32 # Variable c_int
ST_INLIST     = 64 # Variable c_int
ST_BLOCKNEXT  = 128 # Variable c_int
ST_ISSELF     = 256 # Variable c_int

SUBLANG_NEUTRAL                    = win32con.SUBLANG_NEUTRAL # 0
SUBLANG_NORWEGIAN_BOKMAL           = win32con.SUBLANG_NORWEGIAN_BOKMAL # 1
SUBLANG_ARABIC_SAUDI_ARABIA        = 1 # Variable c_int
SUBLANG_CHINESE_TRADITIONAL        = win32con.SUBLANG_CHINESE_TRADITIONAL # 1
SUBLANG_FRENCH                     = win32con.SUBLANG_FRENCH # 1
SUBLANG_SWEDISH                    = 1 # Variable c_int
SUBLANG_ITALIAN                    = win32con.SUBLANG_ITALIAN # 1
SUBLANG_DEFAULT                    = win32con.SUBLANG_DEFAULT # 1
SUBLANG_AZERI_LATIN                = 1 # Variable c_int
SUBLANG_ENGLISH_US                 = win32con.SUBLANG_ENGLISH_US # 1
SUBLANG_LITHUANIAN                 = 1 # Variable c_int
SUBLANG_KOREAN                     = 1 # Variable c_int
SUBLANG_GERMAN                     = win32con.SUBLANG_GERMAN # 1
SUBLANG_SPANISH                    = win32con.SUBLANG_SPANISH # 1
SUBLANG_MALAY_MALAYSIA             = 1 # Variable c_int
SUBLANG_URDU_PAKISTAN              = 1 # Variable c_int
SUBLANG_DUTCH                      = win32con.SUBLANG_DUTCH # 1
SUBLANG_UZBEK_LATIN                = 1 # Variable c_int
SUBLANG_PORTUGUESE_BRAZILIAN       = win32con.SUBLANG_PORTUGUESE_BRAZILIAN # 1
SUBLANG_GERMAN_SWISS               = win32con.SUBLANG_GERMAN_SWISS # 2
SUBLANG_LITHUANIAN_CLASSIC         = 2 # Variable c_int
SUBLANG_NORWEGIAN_NYNORSK          = win32con.SUBLANG_NORWEGIAN_NYNORSK # 2
SUBLANG_PORTUGUESE                 = win32con.SUBLANG_PORTUGUESE # 2
SUBLANG_NEPALI_INDIA               = 2 # Variable c_int
SUBLANG_SERBIAN_LATIN              = 2 # Variable c_int
SUBLANG_SPANISH_MEXICAN            = win32con.SUBLANG_SPANISH_MEXICAN # 2
SUBLANG_CHINESE_SIMPLIFIED         = win32con.SUBLANG_CHINESE_SIMPLIFIED # 2
SUBLANG_MALAY_BRUNEI_DARUSSALAM    = 2 # Variable c_int
SUBLANG_FRENCH_BELGIAN             = win32con.SUBLANG_FRENCH_BELGIAN # 2
SUBLANG_KASHMIRI_INDIA             = 2 # Variable c_int
SUBLANG_DUTCH_BELGIAN              = win32con.SUBLANG_DUTCH_BELGIAN # 2
SUBLANG_SYS_DEFAULT                = win32con.SUBLANG_SYS_DEFAULT # 2
SUBLANG_AZERI_CYRILLIC             = 2 # Variable c_int
SUBLANG_URDU_INDIA                 = 2 # Variable c_int
SUBLANG_ITALIAN_SWISS              = win32con.SUBLANG_ITALIAN_SWISS # 2
SUBLANG_UZBEK_CYRILLIC             = 2 # Variable c_int
SUBLANG_SWEDISH_FINLAND            = 2 # Variable c_int
SUBLANG_ARABIC_IRAQ                = 2 # Variable c_int
SUBLANG_ENGLISH_UK                 = win32con.SUBLANG_ENGLISH_UK # 2
SUBLANG_ARABIC_EGYPT               = 3 # Variable c_int
SUBLANG_ENGLISH_AUS                = win32con.SUBLANG_ENGLISH_AUS # 3
SUBLANG_SPANISH_MODERN             = win32con.SUBLANG_SPANISH_MODERN # 3
SUBLANG_SERBIAN_CYRILLIC           = 3 # Variable c_int
SUBLANG_CHINESE_HONGKONG           = win32con.SUBLANG_CHINESE_HONGKONG # 3
SUBLANG_FRENCH_CANADIAN            = win32con.SUBLANG_FRENCH_CANADIAN # 3
SUBLANG_GERMAN_AUSTRIAN            = win32con.SUBLANG_GERMAN_AUSTRIAN # 3
SUBLANG_CHINESE_SINGAPORE          = win32con.SUBLANG_CHINESE_SINGAPORE # 4
SUBLANG_SPANISH_GUATEMALA          = 4 # Variable c_int
SUBLANG_ARABIC_LIBYA               = 4 # Variable c_int
SUBLANG_FRENCH_SWISS               = win32con.SUBLANG_FRENCH_SWISS # 4
SUBLANG_GERMAN_LUXEMBOURG          = 4 # Variable c_int
SUBLANG_ENGLISH_CAN                = win32con.SUBLANG_ENGLISH_CAN # 4
SUBLANG_SPANISH_COSTA_RICA         = 5 # Variable c_int
SUBLANG_CHINESE_MACAU              = 5 # Variable c_int
SUBLANG_GERMAN_LIECHTENSTEIN       = 5 # Variable c_int
SUBLANG_ENGLISH_NZ                 = win32con.SUBLANG_ENGLISH_NZ # 5
SUBLANG_ARABIC_ALGERIA             = 5 # Variable c_int
SUBLANG_FRENCH_LUXEMBOURG          = 5 # Variable c_int
SUBLANG_ARABIC_MOROCCO             = 6 # Variable c_int
SUBLANG_ENGLISH_EIRE               = win32con.SUBLANG_ENGLISH_EIRE # 6
SUBLANG_FRENCH_MONACO              = 6 # Variable c_int
SUBLANG_SPANISH_PANAMA             = 6 # Variable c_int
SUBLANG_ARABIC_TUNISIA             = 7 # Variable c_int
SUBLANG_SPANISH_DOMINICAN_REPUBLIC = 7 # Variable c_int
SUBLANG_ENGLISH_SOUTH_AFRICA       = 7 # Variable c_int
SUBLANG_SPANISH_VENEZUELA          = 8 # Variable c_int
SUBLANG_ARABIC_OMAN                = 8 # Variable c_int
SUBLANG_ENGLISH_JAMAICA            = 8 # Variable c_int
SUBLANG_SPANISH_COLOMBIA           = 9 # Variable c_int
SUBLANG_ARABIC_YEMEN               = 9 # Variable c_int
SUBLANG_ENGLISH_CARIBBEAN          = 9 # Variable c_int
SUBLANG_ARABIC_SYRIA               = 10 # Variable c_int
SUBLANG_SPANISH_PERU               = 10 # Variable c_int
SUBLANG_ENGLISH_BELIZE             = 10 # Variable c_int
SUBLANG_ARABIC_JORDAN              = 11 # Variable c_int
SUBLANG_SPANISH_ARGENTINA          = 11 # Variable c_int
SUBLANG_ENGLISH_TRINIDAD           = 11 # Variable c_int
SUBLANG_SPANISH_ECUADOR            = 12 # Variable c_int
SUBLANG_ENGLISH_ZIMBABWE           = 12 # Variable c_int
SUBLANG_ARABIC_LEBANON             = 12 # Variable c_int
SUBLANG_SPANISH_CHILE              = 13 # Variable c_int
SUBLANG_ARABIC_KUWAIT              = 13 # Variable c_int
SUBLANG_ENGLISH_PHILIPPINES        = 13 # Variable c_int
SUBLANG_SPANISH_URUGUAY            = 14 # Variable c_int
SUBLANG_ARABIC_UAE                 = 14 # Variable c_int
SUBLANG_SPANISH_PARAGUAY           = 15 # Variable c_int
SUBLANG_ARABIC_BAHRAIN             = 15 # Variable c_int
SUBLANG_ARABIC_QATAR               = 16 # Variable c_int
SUBLANG_SPANISH_BOLIVIA            = 16 # Variable c_int
SUBLANG_SPANISH_EL_SALVADOR        = 17 # Variable c_int
SUBLANG_SPANISH_HONDURAS           = 18 # Variable c_int
SUBLANG_SPANISH_NICARAGUA          = 19 # Variable c_int
SUBLANG_SPANISH_PUERTO_RICO        = 20 # Variable c_int

SUCCESSFUL_ACCESS_ACE_FLAG = win32con.SUCCESSFUL_ACCESS_ACE_FLAG # 64

SWP_NOSIZE         = win32con.SWP_NOSIZE # 1
SWP_NOMOVE         = win32con.SWP_NOMOVE # 2
SWP_NOZORDER       = win32con.SWP_NOZORDER # 4
SWP_NOREDRAW       = win32con.SWP_NOREDRAW # 8
SWP_NOACTIVATE     = win32con.SWP_NOACTIVATE # 16
SWP_FRAMECHANGED   = win32con.SWP_FRAMECHANGED # 32
SWP_SHOWWINDOW     = win32con.SWP_SHOWWINDOW # 64
SWP_HIDEWINDOW     = win32con.SWP_HIDEWINDOW # 128
SWP_NOCOPYBITS     = win32con.SWP_NOCOPYBITS # 256
SWP_NOOWNERZORDER  = win32con.SWP_NOOWNERZORDER # 512
SWP_NOSENDCHANGING = win32con.SWP_NOSENDCHANGING # 1024
SWP_DEFERERASE     = win32con.SWP_DEFERERASE # 8192
SWP_ASYNCWINDOWPOS = win32con.SWP_ASYNCWINDOWPOS # 16384

SW_HIDE            = win32con.SW_HIDE # 0
SW_SHOWNORMAL      = win32con.SW_SHOWNORMAL # 1
SW_SCROLLCHILDREN  = win32con.SW_SCROLLCHILDREN # 1
SW_PARENTCLOSING   = win32con.SW_PARENTCLOSING # 1
SW_NORMAL          = win32con.SW_NORMAL # 1
SW_SHOWMINIMIZED   = win32con.SW_SHOWMINIMIZED # 2
SW_OTHERZOOM       = win32con.SW_OTHERZOOM # 2
SW_INVALIDATE      = win32con.SW_INVALIDATE # 2
SW_MAXIMIZE        = win32con.SW_MAXIMIZE # 3
SW_PARENTOPENING   = win32con.SW_PARENTOPENING # 3
SW_SHOWMAXIMIZED   = win32con.SW_SHOWMAXIMIZED # 3
SW_ERASE           = win32con.SW_ERASE # 4
SW_SHOWNOACTIVATE  = win32con.SW_SHOWNOACTIVATE # 4
SW_OTHERUNZOOM     = win32con.SW_OTHERUNZOOM # 4
SW_SHOW            = win32con.SW_SHOW # 5
SW_MINIMIZE        = win32con.SW_MINIMIZE # 6
SW_SHOWMINNOACTIVE = win32con.SW_SHOWMINNOACTIVE # 7
SW_SHOWNA          = win32con.SW_SHOWNA # 8
SW_RESTORE         = win32con.SW_RESTORE # 9
SW_SHOWDEFAULT     = win32con.SW_SHOWDEFAULT # 10
SW_MAX             = win32con.SW_MAX # 11
SW_FORCEMINIMIZE   = win32con.SW_FORCEMINIMIZE # 11

SYMBOL_CHARSET = win32con.SYMBOL_CHARSET # 2

SYSPAL_ERROR       = win32con.SYSPAL_ERROR # 0
SYSPAL_STATIC      = win32con.SYSPAL_STATIC # 1
SYSPAL_NOSTATIC    = win32con.SYSPAL_NOSTATIC # 2
SYSPAL_NOSTATIC256 = 3 # Variable c_int

SYSTEM_FLAG_REMOTE_BOOT_CLIENT = 1 # Variable c_int
SYSTEM_FLAG_DISKLESS_CLIENT    = 2 # Variable c_int
SYSTEM_AUDIT_ACE_TYPE          = win32con.SYSTEM_AUDIT_ACE_TYPE # 2
SYSTEM_ALARM_ACE_TYPE          = win32con.SYSTEM_ALARM_ACE_TYPE # 3
SYSTEM_AUDIT_OBJECT_ACE_TYPE   = 7 # Variable c_int
SYSTEM_ALARM_OBJECT_ACE_TYPE   = 8 # Variable c_int
SYSTEM_FONT                    = win32con.SYSTEM_FONT # 13
SYSTEM_FIXED_FONT              = win32con.SYSTEM_FIXED_FONT # 16

SYS_WIN16 = 0
SYS_WIN32 = 1
SYS_MAC   = 2

SZDDESYS_ITEM_FORMATS  = 'Formats' # Variable POINTER(c_wchar)
SZDDESYS_ITEM_HELP     = 'Help' # Variable POINTER(c_wchar)
SZDDESYS_ITEM_RTNMSG   = 'ReturnMessage' # Variable POINTER(c_wchar)
SZDDESYS_ITEM_STATUS   = 'Status' # Variable POINTER(c_wchar)
SZDDESYS_ITEM_SYSITEMS = 'SysItems' # Variable POINTER(c_wchar)
SZDDESYS_TOPIC         = 'System' # Variable POINTER(c_wchar)
SZDDESYS_ITEM_TOPICS   = 'Topics' # Variable POINTER(c_wchar)

SZDDE_ITEM_ITEMLIST = 'TopicItemList' # Variable POINTER(c_wchar)

SZM_CREATE = 0
SZM_DELETE = 1

SZ_ASYNC_CALLEE = 'AsyncCallee' # Variable POINTER(c_wchar)
SZ_URLCONTEXT   = 'URL Context' # Variable POINTER(c_wchar)

S_NORMAL       = win32con.S_NORMAL # 0
S_QUEUEEMPTY   = win32con.S_QUEUEEMPTY # 0
S_PERIOD512    = 0 # Variable c_int
S_OK           = 0 # Variable c_long
S_LEGATO       = win32con.S_LEGATO # 1
S_PERIOD1024   = 1 # Variable c_int
S_THRESHOLD    = win32con.S_THRESHOLD # 1
S_FALSE        = 1 # Variable c_long
S_PERIOD2048   = 2 # Variable c_int
S_ALLTHRESHOLD = win32con.S_ALLTHRESHOLD # 2
S_STACCATO     = win32con.S_STACCATO # 2
S_PERIODVOICE  = 3 # Variable c_int
S_WHITE512     = 4 # Variable c_int
S_WHITE1024    = 5 # Variable c_int
S_WHITE2048    = 6 # Variable c_int
S_WHITEVOICE   = 7 # Variable c_int
S_SERDVNA      = -1 # Variable c_int
S_SEROFM       = -2 # Variable c_int
S_SERMACT      = -3 # Variable c_int
S_SERQFUL      = -4 # Variable c_int
S_SERBDNT      = -5 # Variable c_int
S_SERDLN       = -6 # Variable c_int
S_SERDCC       = -7 # Variable c_int
S_SERDTP       = -8 # Variable c_int
S_SERDVL       = -9 # Variable c_int
S_SERDMD       = -10 # Variable c_int
S_SERDSH       = -11 # Variable c_int
S_SERDPT       = -12 # Variable c_int
S_SERDFQ       = -13 # Variable c_int
S_SERDDR       = -14 # Variable c_int
S_SERDSR       = -15 # Variable c_int
S_SERDST       = -16 # Variable c_int

TAPE_ERASE_SHORT             = win32con.TAPE_ERASE_SHORT # 0
TAPE_LOAD                    = win32con.TAPE_LOAD # 0
TAPE_FIXED_PARTITIONS        = win32con.TAPE_FIXED_PARTITIONS # 0
TAPE_SETMARKS                = win32con.TAPE_SETMARKS # 0
TAPE_REWIND                  = win32con.TAPE_REWIND # 0
TAPE_ABSOLUTE_POSITION       = win32con.TAPE_ABSOLUTE_POSITION # 0
TAPE_DRIVE_FIXED             = win32con.TAPE_DRIVE_FIXED # 1
TAPE_ERASE_LONG              = win32con.TAPE_ERASE_LONG # 1
TAPE_UNLOAD                  = win32con.TAPE_UNLOAD # 1
TAPE_LOGICAL_POSITION        = win32con.TAPE_LOGICAL_POSITION # 1
TAPE_ABSOLUTE_BLOCK          = win32con.TAPE_ABSOLUTE_BLOCK # 1
TAPE_SELECT_PARTITIONS       = win32con.TAPE_SELECT_PARTITIONS # 1
TAPE_FILEMARKS               = win32con.TAPE_FILEMARKS # 1
TAPE_DRIVE_SELECT            = win32con.TAPE_DRIVE_SELECT # 2
TAPE_LOGICAL_BLOCK           = win32con.TAPE_LOGICAL_BLOCK # 2
TAPE_INITIATOR_PARTITIONS    = win32con.TAPE_INITIATOR_PARTITIONS # 2
TAPE_TENSION                 = win32con.TAPE_TENSION # 2
TAPE_PSEUDO_LOGICAL_POSITION = win32con.TAPE_PSEUDO_LOGICAL_POSITION # 2
TAPE_SHORT_FILEMARKS         = win32con.TAPE_SHORT_FILEMARKS # 2
TAPE_LOCK                    = win32con.TAPE_LOCK # 3
TAPE_LONG_FILEMARKS          = win32con.TAPE_LONG_FILEMARKS # 3
TAPE_PSEUDO_LOGICAL_BLOCK    = win32con.TAPE_PSEUDO_LOGICAL_BLOCK # 3
TAPE_DRIVE_INITIATOR         = win32con.TAPE_DRIVE_INITIATOR # 4
TAPE_UNLOCK                  = win32con.TAPE_UNLOCK # 4
TAPE_SPACE_END_OF_DATA       = win32con.TAPE_SPACE_END_OF_DATA # 4
TAPE_SPACE_RELATIVE_BLOCKS   = win32con.TAPE_SPACE_RELATIVE_BLOCKS # 5
TAPE_FORMAT                  = win32con.TAPE_FORMAT # 5
TAPE_SPACE_FILEMARKS         = win32con.TAPE_SPACE_FILEMARKS # 6
TAPE_SPACE_SEQUENTIAL_FMKS   = win32con.TAPE_SPACE_SEQUENTIAL_FMKS # 7
TAPE_SPACE_SETMARKS          = win32con.TAPE_SPACE_SETMARKS # 8
TAPE_SPACE_SEQUENTIAL_SMKS   = win32con.TAPE_SPACE_SEQUENTIAL_SMKS # 9
TAPE_DRIVE_ERASE_SHORT       = win32con.TAPE_DRIVE_ERASE_SHORT # 16
TAPE_DRIVE_ERASE_LONG        = win32con.TAPE_DRIVE_ERASE_LONG # 32
TAPE_DRIVE_ERASE_BOP_ONLY    = win32con.TAPE_DRIVE_ERASE_BOP_ONLY # 64
TAPE_DRIVE_ERASE_IMMEDIATE   = win32con.TAPE_DRIVE_ERASE_IMMEDIATE # 128
TAPE_DRIVE_TAPE_CAPACITY     = win32con.TAPE_DRIVE_TAPE_CAPACITY # 256
TAPE_DRIVE_TAPE_REMAINING    = win32con.TAPE_DRIVE_TAPE_REMAINING # 512
TAPE_DRIVE_FIXED_BLOCK       = win32con.TAPE_DRIVE_FIXED_BLOCK # 1024
TAPE_DRIVE_VARIABLE_BLOCK    = win32con.TAPE_DRIVE_VARIABLE_BLOCK # 2048
TAPE_DRIVE_WRITE_PROTECT     = win32con.TAPE_DRIVE_WRITE_PROTECT # 4096
TAPE_DRIVE_EOT_WZ_SIZE       = win32con.TAPE_DRIVE_EOT_WZ_SIZE # 8192
TAPE_DRIVE_ECC               = win32con.TAPE_DRIVE_ECC # 65536
TAPE_DRIVE_COMPRESSION       = win32con.TAPE_DRIVE_COMPRESSION # 131072
TAPE_DRIVE_PADDING           = win32con.TAPE_DRIVE_PADDING # 262144
TAPE_DRIVE_REPORT_SMKS       = win32con.TAPE_DRIVE_REPORT_SMKS # 524288
TAPE_DRIVE_GET_ABSOLUTE_BLK  = win32con.TAPE_DRIVE_GET_ABSOLUTE_BLK # 1048576
TAPE_DRIVE_GET_LOGICAL_BLK   = win32con.TAPE_DRIVE_GET_LOGICAL_BLK # 2097152
TAPE_DRIVE_SET_EOT_WZ_SIZE   = win32con.TAPE_DRIVE_SET_EOT_WZ_SIZE # 4194304
TAPE_DRIVE_EJECT_MEDIA       = 16777216 # Variable c_int
TAPE_DRIVE_CLEAN_REQUESTS    = 33554432 # Variable c_int
TAPE_DRIVE_SET_CMP_BOP_ONLY  = 67108864 # Variable c_int
TAPE_DRIVE_HIGH_FEATURES     = 2147483648 # Variable c_uint
TAPE_DRIVE_RESERVED_BIT      = 2147483648 # Variable c_uint
TAPE_DRIVE_LOAD_UNLOAD       = win32con.TAPE_DRIVE_LOAD_UNLOAD # -2147483647
TAPE_DRIVE_TENSION           = win32con.TAPE_DRIVE_TENSION # -2147483646
TAPE_DRIVE_LOCK_UNLOCK       = win32con.TAPE_DRIVE_LOCK_UNLOCK # -2147483644
TAPE_DRIVE_REWIND_IMMEDIATE  = win32con.TAPE_DRIVE_REWIND_IMMEDIATE # -2147483640
TAPE_DRIVE_SET_BLOCK_SIZE    = win32con.TAPE_DRIVE_SET_BLOCK_SIZE # -2147483632
TAPE_DRIVE_LOAD_UNLD_IMMED   = win32con.TAPE_DRIVE_LOAD_UNLD_IMMED # -2147483616
TAPE_DRIVE_TENSION_IMMED     = win32con.TAPE_DRIVE_TENSION_IMMED # -2147483584
TAPE_DRIVE_LOCK_UNLK_IMMED   = win32con.TAPE_DRIVE_LOCK_UNLK_IMMED # -2147483520
TAPE_DRIVE_SET_ECC           = win32con.TAPE_DRIVE_SET_ECC # -2147483392
TAPE_DRIVE_SET_COMPRESSION   = win32con.TAPE_DRIVE_SET_COMPRESSION # -2147483136
TAPE_DRIVE_SET_PADDING       = win32con.TAPE_DRIVE_SET_PADDING # -2147482624
TAPE_DRIVE_SET_REPORT_SMKS   = win32con.TAPE_DRIVE_SET_REPORT_SMKS # -2147481600
TAPE_DRIVE_ABSOLUTE_BLK      = win32con.TAPE_DRIVE_ABSOLUTE_BLK # -2147479552
TAPE_DRIVE_ABS_BLK_IMMED     = win32con.TAPE_DRIVE_ABS_BLK_IMMED # -2147475456
TAPE_DRIVE_LOGICAL_BLK       = win32con.TAPE_DRIVE_LOGICAL_BLK # -2147467264
TAPE_DRIVE_LOG_BLK_IMMED     = win32con.TAPE_DRIVE_LOG_BLK_IMMED # -2147450880
TAPE_DRIVE_END_OF_DATA       = win32con.TAPE_DRIVE_END_OF_DATA # -2147418112
TAPE_DRIVE_RELATIVE_BLKS     = win32con.TAPE_DRIVE_RELATIVE_BLKS # -2147352576
TAPE_DRIVE_FILEMARKS         = win32con.TAPE_DRIVE_FILEMARKS # -2147221504
TAPE_DRIVE_SEQUENTIAL_FMKS   = win32con.TAPE_DRIVE_SEQUENTIAL_FMKS # -2146959360
TAPE_DRIVE_SETMARKS          = win32con.TAPE_DRIVE_SETMARKS # -2146435072
TAPE_DRIVE_SEQUENTIAL_SMKS   = win32con.TAPE_DRIVE_SEQUENTIAL_SMKS # -2145386496
TAPE_DRIVE_REVERSE_POSITION  = win32con.TAPE_DRIVE_REVERSE_POSITION # -2143289344
TAPE_DRIVE_SPACE_IMMEDIATE   = win32con.TAPE_DRIVE_SPACE_IMMEDIATE # -2139095040
TAPE_DRIVE_WRITE_SETMARKS    = win32con.TAPE_DRIVE_WRITE_SETMARKS # -2130706432
TAPE_DRIVE_WRITE_FILEMARKS   = win32con.TAPE_DRIVE_WRITE_FILEMARKS # -2113929216
TAPE_DRIVE_WRITE_SHORT_FMKS  = win32con.TAPE_DRIVE_WRITE_SHORT_FMKS # -2080374784
TAPE_DRIVE_WRITE_LONG_FMKS   = win32con.TAPE_DRIVE_WRITE_LONG_FMKS # -2013265920
TAPE_DRIVE_WRITE_MARK_IMMED  = win32con.TAPE_DRIVE_WRITE_MARK_IMMED # -1879048192
TAPE_DRIVE_FORMAT            = win32con.TAPE_DRIVE_FORMAT # -1610612736
TAPE_DRIVE_FORMAT_IMMEDIATE  = win32con.TAPE_DRIVE_FORMAT_IMMEDIATE # -1073741824

TARGET_IS_NT50_OR_LATER           = 0 # Variable c_int
TARGET_IS_NT40_OR_LATER           = 0 # Variable c_int
TARGET_IS_NT351_OR_WIN95_OR_LATER = 1 # Variable c_int

TA_LEFT       = win32con.TA_LEFT # 0
TA_NOUPDATECP = win32con.TA_NOUPDATECP # 0
TA_TOP        = win32con.TA_TOP # 0
TA_UPDATECP   = win32con.TA_UPDATECP # 1
TA_RIGHT      = win32con.TA_RIGHT # 2
TA_CENTER     = win32con.TA_CENTER # 6
TA_BOTTOM     = win32con.TA_BOTTOM # 8
TA_BASELINE   = win32con.TA_BASELINE # 24
TA_RTLREADING = 256 # Variable c_int
TA_MASK       = win32con.TA_MASK # 31

TBBF_LARGE = 1 # Variable c_int

TBCDRF_NOEDGES        = 65536 # Variable c_int
TBCDRF_HILITEHOTTRACK = 131072 # Variable c_int
TBCDRF_NOOFFSET       = 262144 # Variable c_int
TBCDRF_NOMARK         = 524288 # Variable c_int
TBCDRF_NOETCHEDEFFECT = 1048576 # Variable c_int

TBCD_TICS    = 1 # Variable c_int
TBCD_THUMB   = 2 # Variable c_int
TBCD_CHANNEL = 3 # Variable c_int

TBDDRET_DEFAULT      = 0 # Variable c_int
TBDDRET_NODEFAULT    = 1 # Variable c_int
TBDDRET_TREATPRESSED = 2 # Variable c_int

TBIF_BYINDEX = 0x80000000
TBIF_IMAGE   = 1 # Variable c_int
TBIF_TEXT    = 2 # Variable c_int
TBIF_STATE   = 4 # Variable c_int
TBIF_STYLE   = 8 # Variable c_int
TBIF_LPARAM  = 16 # Variable c_int
TBIF_COMMAND = 32 # Variable c_int
TBIF_SIZE    = 64 # Variable c_int

TBIMHT_AFTER      = 1 # Variable c_int
TBIMHT_BACKGROUND = 2 # Variable c_int

TBM_GETPOS         = 1024 # Variable c_int
TBM_GETRANGEMIN    = 1025 # Variable c_int
TBM_GETRANGEMAX    = 1026 # Variable c_int
TBM_GETTIC         = 1027 # Variable c_int
TBM_SETTIC         = 1028 # Variable c_int
TBM_SETPOS         = 1029 # Variable c_int
TBM_SETRANGE       = 1030 # Variable c_int
TBM_SETRANGEMIN    = 1031 # Variable c_int
TBM_SETRANGEMAX    = 1032 # Variable c_int
TBM_CLEARTICS      = 1033 # Variable c_int
TBM_SETSEL         = 1034 # Variable c_int
TBM_SETSELSTART    = 1035 # Variable c_int
TBM_SETSELEND      = 1036 # Variable c_int
TBM_GETPTICS       = 1038 # Variable c_int
TBM_GETTICPOS      = 1039 # Variable c_int
TBM_GETNUMTICS     = 1040 # Variable c_int
TBM_GETSELSTART    = 1041 # Variable c_int
TBM_GETSELEND      = 1042 # Variable c_int
TBM_CLEARSEL       = 1043 # Variable c_int
TBM_SETTICFREQ     = 1044 # Variable c_int
TBM_SETPAGESIZE    = 1045 # Variable c_int
TBM_GETPAGESIZE    = 1046 # Variable c_int
TBM_SETLINESIZE    = 1047 # Variable c_int
TBM_GETLINESIZE    = 1048 # Variable c_int
TBM_GETTHUMBRECT   = 1049 # Variable c_int
TBM_GETCHANNELRECT = 1050 # Variable c_int
TBM_SETTHUMBLENGTH = 1051 # Variable c_int
TBM_GETTHUMBLENGTH = 1052 # Variable c_int
TBM_SETTOOLTIPS    = 1053 # Variable c_int
TBM_GETTOOLTIPS    = 1054 # Variable c_int
TBM_SETTIPSIDE     = 1055 # Variable c_int
TBM_SETBUDDY       = 1056 # Variable c_int
TBM_GETBUDDY       = 1057 # Variable c_int

TBNF_IMAGE      = 1 # Variable c_int
TBNF_TEXT       = 2 # Variable c_int
TBNF_DI_SETITEM = 268435456 # Variable c_int

TBN_GETBUTTONINFOW = 4294966576 # Variable c_uint
TBN_LAST           = 4294966576 # Variable c_uint
TBN_GETINFOTIPW    = 4294966577 # Variable c_uint
TBN_GETINFOTIPA    = 4294966578 # Variable c_uint
TBN_GETDISPINFOW   = 4294966579 # Variable c_uint
TBN_GETDISPINFOA   = 4294966580 # Variable c_uint
TBN_DELETINGBUTTON = 4294966581 # Variable c_uint
TBN_DRAGOUT        = 4294966582 # Variable c_uint
TBN_HOTITEMCHANGE  = 4294966583 # Variable c_uint
TBN_GETOBJECT      = 4294966584 # Variable c_uint
TBN_DROPDOWN       = 4294966586 # Variable c_uint
TBN_CUSTHELP       = 4294966587 # Variable c_uint
TBN_TOOLBARCHANGE  = 4294966588 # Variable c_uint
TBN_QUERYDELETE    = 4294966589 # Variable c_uint
TBN_QUERYINSERT    = 4294966590 # Variable c_uint
TBN_RESET          = 4294966591 # Variable c_uint
TBN_ENDADJUST      = 4294966592 # Variable c_uint
TBN_BEGINADJUST    = 4294966593 # Variable c_uint
TBN_ENDDRAG        = 4294966594 # Variable c_uint
TBN_BEGINDRAG      = 4294966595 # Variable c_uint
TBN_GETBUTTONINFOA = 4294966596 # Variable c_uint
TBN_FIRST          = 4294966596 # Variable c_uint
TBN_DRAGOVER       = 4294966569
TBN_DUPACCELERATOR = 4294966571
TBN_INITCUSTOMIZE  = 4294966573
TBN_MAPACCELERATOR = 4294966568
TBN_RESTORE        = 4294966575
TBN_SAVE           = 4294966574
TBN_WRAPHOTITEM    = 4294966572
TBN_WRAPACCELERATOR = 4294966570

TCN_FOCUSCHANGE = 4294966742

TRBN_THUMBPOSCHANGING = 4294965794

TBSTATE_CHECKED       = 1 # Variable c_int
TBSTATE_PRESSED       = 2 # Variable c_int
TBSTATE_ENABLED       = 4 # Variable c_int
TBSTATE_HIDDEN        = 8 # Variable c_int
TBSTATE_INDETERMINATE = 16 # Variable c_int
TBSTATE_WRAP          = 32 # Variable c_int
TBSTATE_ELLIPSES      = 64 # Variable c_int
TBSTATE_MARKED        = 128 # Variable c_int

TBSTYLE_BUTTON          = 0 # Variable c_int
TBSTYLE_EX_DRAWDDARROWS = 1 # Variable c_int
TBSTYLE_SEP             = 1 # Variable c_int
TBSTYLE_CHECK           = 2 # Variable c_int
TBSTYLE_GROUP           = 4 # Variable c_int
TBSTYLE_CHECKGROUP      = 6 # Variable c_int
TBSTYLE_DROPDOWN        = 8 # Variable c_int
TBSTYLE_AUTOSIZE        = 16 # Variable c_int
TBSTYLE_NOPREFIX        = 32 # Variable c_int
TBSTYLE_TOOLTIPS        = 256 # Variable c_int
TBSTYLE_WRAPABLE        = 512 # Variable c_int
TBSTYLE_ALTDRAG         = 1024 # Variable c_int
TBSTYLE_FLAT            = 2048 # Variable c_int
TBSTYLE_LIST            = 4096 # Variable c_int
TBSTYLE_CUSTOMERASE     = 8192 # Variable c_int
TBSTYLE_REGISTERDROP    = 16384 # Variable c_int
TBSTYLE_TRANSPARENT     = 32768 # Variable c_int

TBS_RIGHT          = 0 # Variable c_int
TBS_BOTTOM         = 0 # Variable c_int
TBS_HORZ           = 0 # Variable c_int
TBS_AUTOTICKS      = 1 # Variable c_int
TBS_VERT           = 2 # Variable c_int
TBS_TOP            = 4 # Variable c_int
TBS_LEFT           = 4 # Variable c_int
TBS_BOTH           = 8 # Variable c_int
TBS_NOTICKS        = 16 # Variable c_int
TBS_ENABLESELRANGE = 32 # Variable c_int
TBS_FIXEDLENGTH    = 64 # Variable c_int
TBS_NOTHUMB        = 128 # Variable c_int
TBS_TOOLTIPS       = 256 # Variable c_int

TBTS_TOP    = 0 # Variable c_int
TBTS_LEFT   = 1 # Variable c_int
TBTS_BOTTOM = 2 # Variable c_int
TBTS_RIGHT  = 3 # Variable c_int

TB_LINEUP                = 0 # Variable c_int
TB_LINEDOWN              = 1 # Variable c_int
TB_PAGEUP                = 2 # Variable c_int
TB_PAGEDOWN              = 3 # Variable c_int
TB_THUMBPOSITION         = 4 # Variable c_int
TB_THUMBTRACK            = 5 # Variable c_int
TB_TOP                   = 6 # Variable c_int
TB_BOTTOM                = 7 # Variable c_int
TB_ENDTRACK              = 8 # Variable c_int
TB_ENABLEBUTTON          = 1025 # Variable c_int
TB_CHECKBUTTON           = 1026 # Variable c_int
TB_PRESSBUTTON           = 1027 # Variable c_int
TB_HIDEBUTTON            = 1028 # Variable c_int
TB_INDETERMINATE         = 1029 # Variable c_int
TB_MARKBUTTON            = 1030 # Variable c_int
TB_ISBUTTONENABLED       = 1033 # Variable c_int
TB_ISBUTTONCHECKED       = 1034 # Variable c_int
TB_ISBUTTONPRESSED       = 1035 # Variable c_int
TB_ISBUTTONHIDDEN        = 1036 # Variable c_int
TB_ISBUTTONINDETERMINATE = 1037 # Variable c_int
TB_ISBUTTONHIGHLIGHTED   = 1038 # Variable c_int
TB_SETSTATE              = 1041 # Variable c_int
TB_GETSTATE              = 1042 # Variable c_int
TB_ADDBITMAP             = 1043 # Variable c_int
TB_ADDBUTTONSA           = 1044 # Variable c_int
TB_INSERTBUTTONA         = 1045 # Variable c_int
TB_DELETEBUTTON          = 1046 # Variable c_int
TB_GETBUTTON             = 1047 # Variable c_int
TB_BUTTONCOUNT           = 1048 # Variable c_int
TB_COMMANDTOINDEX        = 1049 # Variable c_int
TB_SAVERESTOREA          = 1050 # Variable c_int
TB_CUSTOMIZE             = 1051 # Variable c_int
TB_ADDSTRINGA            = 1052 # Variable c_int
TB_GETITEMRECT           = 1053 # Variable c_int
TB_BUTTONSTRUCTSIZE      = 1054 # Variable c_int
TB_SETBUTTONSIZE         = 1055 # Variable c_int
TB_SETBITMAPSIZE         = 1056 # Variable c_int
TB_AUTOSIZE              = 1057 # Variable c_int
TB_GETTOOLTIPS           = 1059 # Variable c_int
TB_SETTOOLTIPS           = 1060 # Variable c_int
TB_SETPARENT             = 1061 # Variable c_int
TB_SETROWS               = 1063 # Variable c_int
TB_GETROWS               = 1064 # Variable c_int
TB_GETBITMAPFLAGS        = 1065 # Variable c_int
TB_SETCMDID              = 1066 # Variable c_int
TB_CHANGEBITMAP          = 1067 # Variable c_int
TB_GETBITMAP             = 1068 # Variable c_int
TB_GETBUTTONTEXTA        = 1069 # Variable c_int
TB_REPLACEBITMAP         = 1070 # Variable c_int
TB_SETINDENT             = 1071 # Variable c_int
TB_SETIMAGELIST          = 1072 # Variable c_int
TB_GETIMAGELIST          = 1073 # Variable c_int
TB_LOADIMAGES            = 1074 # Variable c_int
TB_GETRECT               = 1075 # Variable c_int
TB_SETHOTIMAGELIST       = 1076 # Variable c_int
TB_GETHOTIMAGELIST       = 1077 # Variable c_int
TB_SETDISABLEDIMAGELIST  = 1078 # Variable c_int
TB_GETDISABLEDIMAGELIST  = 1079 # Variable c_int
TB_SETSTYLE              = 1080 # Variable c_int
TB_GETSTYLE              = 1081 # Variable c_int
TB_GETBUTTONSIZE         = 1082 # Variable c_int
TB_SETBUTTONWIDTH        = 1083 # Variable c_int
TB_SETMAXTEXTROWS        = 1084 # Variable c_int
TB_GETTEXTROWS           = 1085 # Variable c_int
TB_GETOBJECT             = 1086 # Variable c_int
TB_GETBUTTONINFOW        = 1087 # Variable c_int
TB_SETBUTTONINFOW        = 1088 # Variable c_int
TB_GETBUTTONINFOA        = 1089 # Variable c_int
TB_SETBUTTONINFOA        = 1090 # Variable c_int
TB_INSERTBUTTONW         = 1091 # Variable c_int
TB_ADDBUTTONSW           = 1092 # Variable c_int
TB_HITTEST               = 1093 # Variable c_int
TB_SETDRAWTEXTFLAGS      = 1094 # Variable c_int
TB_GETHOTITEM            = 1095 # Variable c_int
TB_SETHOTITEM            = 1096 # Variable c_int
TB_SETANCHORHIGHLIGHT    = 1097 # Variable c_int
TB_GETANCHORHIGHLIGHT    = 1098 # Variable c_int
TB_GETBUTTONTEXTW        = 1099 # Variable c_int
TB_SAVERESTOREW          = 1100 # Variable c_int
TB_ADDSTRINGW            = 1101 # Variable c_int
TB_MAPACCELERATORA       = 1102 # Variable c_int
TB_GETINSERTMARK         = 1103 # Variable c_int
TB_SETINSERTMARK         = 1104 # Variable c_int
TB_INSERTMARKHITTEST     = 1105 # Variable c_int
TB_MOVEBUTTON            = 1106 # Variable c_int
TB_GETMAXSIZE            = 1107 # Variable c_int
TB_SETEXTENDEDSTYLE      = 1108 # Variable c_int
TB_GETEXTENDEDSTYLE      = 1109 # Variable c_int
TB_GETPADDING            = 1110 # Variable c_int
TB_SETPADDING            = 1111 # Variable c_int
TB_SETINSERTMARKCOLOR    = 1112 # Variable c_int
TB_GETINSERTMARKCOLOR    = 1113 # Variable c_int
TB_MAPACCELERATORW       = 1114 # Variable c_int

TCHT_NOWHERE     = 1 # Variable c_int
TCHT_ONITEMICON  = 2 # Variable c_int
TCHT_ONITEMLABEL = 4 # Variable c_int
TCHT_ONITEM      = 6 # Variable c_int

TCIF_TEXT       = 1 # Variable c_int
TCIF_IMAGE      = 2 # Variable c_int
TCIF_RTLREADING = 4 # Variable c_int
TCIF_PARAM      = 8 # Variable c_int
TCIF_STATE      = 16 # Variable c_int

TCIS_BUTTONPRESSED = 1 # Variable c_int
TCIS_HIGHLIGHTED   = 2 # Variable c_int

TCI_SRCCHARSET  = 1 # Variable c_int
TCI_SRCCODEPAGE = 2 # Variable c_int
TCI_SRCFONTSIG  = 3 # Variable c_int

TCM_FIRST            = 4864 # Variable c_int
TCM_GETIMAGELIST     = 4866 # Variable c_int
TCM_SETIMAGELIST     = 4867 # Variable c_int
TCM_GETITEMCOUNT     = 4868 # Variable c_int
TCM_GETITEMA         = 4869 # Variable c_int
TCM_SETITEMA         = 4870 # Variable c_int
TCM_INSERTITEMA      = 4871 # Variable c_int
TCM_DELETEITEM       = 4872 # Variable c_int
TCM_DELETEALLITEMS   = 4873 # Variable c_int
TCM_GETITEMRECT      = 4874 # Variable c_int
TCM_GETCURSEL        = 4875 # Variable c_int
TCM_SETCURSEL        = 4876 # Variable c_int
TCM_HITTEST          = 4877 # Variable c_int
TCM_SETITEMEXTRA     = 4878 # Variable c_int
TCM_ADJUSTRECT       = 4904 # Variable c_int
TCM_SETITEMSIZE      = 4905 # Variable c_int
TCM_REMOVEIMAGE      = 4906 # Variable c_int
TCM_SETPADDING       = 4907 # Variable c_int
TCM_GETROWCOUNT      = 4908 # Variable c_int
TCM_GETTOOLTIPS      = 4909 # Variable c_int
TCM_SETTOOLTIPS      = 4910 # Variable c_int
TCM_GETCURFOCUS      = 4911 # Variable c_int
TCM_SETCURFOCUS      = 4912 # Variable c_int
TCM_SETMINTABWIDTH   = 4913 # Variable c_int
TCM_DESELECTALL      = 4914 # Variable c_int
TCM_HIGHLIGHTITEM    = 4915 # Variable c_int
TCM_SETEXTENDEDSTYLE = 4916 # Variable c_int
TCM_GETEXTENDEDSTYLE = 4917 # Variable c_int
TCM_GETITEMW         = 4924 # Variable c_int
TCM_SETITEMW         = 4925 # Variable c_int
TCM_INSERTITEMW      = 4926 # Variable c_int

TCN_LAST        = 4294966716 # Variable c_uint
TCN_GETOBJECT   = 4294966743 # Variable c_uint
TCN_SELCHANGING = 4294966744 # Variable c_uint
TCN_SELCHANGE   = 4294966745 # Variable c_uint
TCN_FIRST       = 4294966746 # Variable c_uint
TCN_KEYDOWN     = 4294966746 # Variable c_uint

TCP_NODELAY   = 1 # Variable c_int
TCP_BSDURGENT = 28672 # Variable c_int

TCS_RIGHTJUSTIFY      = 0 # Variable c_int
TCS_SINGLELINE        = 0 # Variable c_int
TCS_TABS              = 0 # Variable c_int
TCS_EX_FLATSEPARATORS = 1 # Variable c_int
TCS_SCROLLOPPOSITE    = 1 # Variable c_int
TCS_BOTTOM            = 2 # Variable c_int
TCS_EX_REGISTERDROP   = 2 # Variable c_int
TCS_RIGHT             = 2 # Variable c_int
TCS_MULTISELECT       = 4 # Variable c_int
TCS_FLATBUTTONS       = 8 # Variable c_int
TCS_FORCEICONLEFT     = 16 # Variable c_int
TCS_FORCELABELLEFT    = 32 # Variable c_int
TCS_HOTTRACK          = 64 # Variable c_int
TCS_VERTICAL          = 128 # Variable c_int
TCS_BUTTONS           = 256 # Variable c_int
TCS_MULTILINE         = 512 # Variable c_int
TCS_FIXEDWIDTH        = 1024 # Variable c_int
TCS_RAGGEDRIGHT       = 2048 # Variable c_int
TCS_FOCUSONBUTTONDOWN = 4096 # Variable c_int
TCS_OWNERDRAWFIXED    = 8192 # Variable c_int
TCS_TOOLTIPS          = 16384 # Variable c_int
TCS_FOCUSNEVER        = 32768 # Variable c_int

TC_NORMAL       = win32con.TC_NORMAL # 0
TC_HARDERR      = win32con.TC_HARDERR # 1
TC_OP_CHARACTER = win32con.TC_OP_CHARACTER # 1
TC_OP_STROKE    = win32con.TC_OP_STROKE # 2
TC_GP_TRAP      = win32con.TC_GP_TRAP # 2
TC_SIGNAL       = win32con.TC_SIGNAL # 3
TC_CP_STROKE    = win32con.TC_CP_STROKE # 4
TC_CR_90        = win32con.TC_CR_90 # 8
TC_CR_ANY       = win32con.TC_CR_ANY # 16
TC_SF_X_YINDEP  = win32con.TC_SF_X_YINDEP # 32
TC_SA_DOUBLE    = win32con.TC_SA_DOUBLE # 64
TC_SA_INTEGER   = win32con.TC_SA_INTEGER # 128
TC_SA_CONTIN    = win32con.TC_SA_CONTIN # 256
TC_EA_DOUBLE    = win32con.TC_EA_DOUBLE # 512
TC_IA_ABLE      = win32con.TC_IA_ABLE # 1024
TC_UA_ABLE      = win32con.TC_UA_ABLE # 2048
TC_SO_ABLE      = win32con.TC_SO_ABLE # 4096
TC_RA_ABLE      = win32con.TC_RA_ABLE # 8192
TC_VA_ABLE      = win32con.TC_VA_ABLE # 16384
TC_RESERVED     = win32con.TC_RESERVED # 32768
TC_SCROLLBLT    = win32con.TC_SCROLLBLT # 65536

TF_DISCONNECT   = 1 # Variable c_int
TF_REUSE_SOCKET = 2 # Variable c_int
TF_WRITE_BEHIND = 4 # Variable c_int

THAI_CHARSET = win32con.THAI_CHARSET # 222

THREAD_PRIORITY_NORMAL       = win32con.THREAD_PRIORITY_NORMAL # 0
THREAD_PRIORITY_ABOVE_NORMAL = win32con.THREAD_PRIORITY_ABOVE_NORMAL # 1
THREAD_TERMINATE             = win32con.THREAD_TERMINATE # 1
THREAD_BASE_PRIORITY_MAX     = win32con.THREAD_BASE_PRIORITY_MAX # 2
THREAD_SUSPEND_RESUME        = win32con.THREAD_SUSPEND_RESUME # 2
THREAD_GET_CONTEXT           = win32con.THREAD_GET_CONTEXT # 8
THREAD_BASE_PRIORITY_LOWRT   = win32con.THREAD_BASE_PRIORITY_LOWRT # 15
THREAD_SET_CONTEXT           = win32con.THREAD_SET_CONTEXT # 16
THREAD_SET_INFORMATION       = win32con.THREAD_SET_INFORMATION # 32
THREAD_QUERY_INFORMATION     = win32con.THREAD_QUERY_INFORMATION # 64
THREAD_SET_THREAD_TOKEN      = win32con.THREAD_SET_THREAD_TOKEN # 128
THREAD_IMPERSONATE           = win32con.THREAD_IMPERSONATE # 256
THREAD_DIRECT_IMPERSONATION  = win32con.THREAD_DIRECT_IMPERSONATION # 512
THREAD_ALL_ACCESS            = 2032639 # Variable c_long
THREAD_PRIORITY_ERROR_RETURN = win32con.THREAD_PRIORITY_ERROR_RETURN # 2147483647
THREAD_PRIORITY_BELOW_NORMAL = win32con.THREAD_PRIORITY_BELOW_NORMAL # -1
THREAD_BASE_PRIORITY_MIN     = win32con.THREAD_BASE_PRIORITY_MIN # -2
THREAD_BASE_PRIORITY_IDLE    = win32con.THREAD_BASE_PRIORITY_IDLE # -15

TIMEOUT_ASYNC = 4294967295 # Variable c_uint

TIMERR_NOERROR = 0 # Variable c_int
TIMERR_BASE    = 96 # Variable c_int
TIMERR_NOCANDO = 97 # Variable c_int
TIMERR_STRUCT  = 129 # Variable c_int

TIMER_QUERY_STATE  = 1 # Variable c_int
TIMER_MODIFY_STATE = 2 # Variable c_int
TIMER_ALL_ACCESS   = 2031619 # Variable c_long

TIME_ONESHOT              = 0 # Variable c_int
TIME_ZONE_ID_UNKNOWN      = win32con.TIME_ZONE_ID_UNKNOWN # 0
TIME_CALLBACK_FUNCTION    = 0 # Variable c_int
TIME_ZONE_ID_STANDARD     = win32con.TIME_ZONE_ID_STANDARD # 1
TIME_NOMINUTESORSECONDS   = 1 # Variable c_int
TIME_MS                   = 1 # Variable c_int
TIME_PERIODIC             = 1 # Variable c_int
TIME_NOSECONDS            = 2 # Variable c_int
TIME_SAMPLES              = 2 # Variable c_int
TIME_ZONE_ID_DAYLIGHT     = win32con.TIME_ZONE_ID_DAYLIGHT # 2
TIME_NOTIMEMARKER         = 4 # Variable c_int
TIME_BYTES                = 4 # Variable c_int
TIME_SMPTE                = 8 # Variable c_int
TIME_FORCE24HOURFORMAT    = 8 # Variable c_int
TIME_CALLBACK_EVENT_SET   = 16 # Variable c_int
TIME_MIDI                 = 16 # Variable c_int
TIME_CALLBACK_EVENT_PULSE = 32 # Variable c_int
TIME_TICKS                = 32 # Variable c_int
TIME_ZONE_ID_INVALID      = 4294967295 # Variable c_ulong

TKF_TOGGLEKEYSON  = win32con.TKF_TOGGLEKEYSON # 1
TKF_AVAILABLE     = win32con.TKF_AVAILABLE # 2
TKF_HOTKEYACTIVE  = win32con.TKF_HOTKEYACTIVE # 4
TKF_CONFIRMHOTKEY = win32con.TKF_CONFIRMHOTKEY # 8
TKF_HOTKEYSOUND   = win32con.TKF_HOTKEYSOUND # 16
TKF_INDICATOR     = win32con.TKF_INDICATOR # 32

TKIND_ENUM      = 0
TKIND_RECORD    = 1
TKIND_MODULE    = 2
TKIND_INTERFACE = 3
TKIND_DISPATCH  = 4
TKIND_COCLASS   = 5
TKIND_ALIAS     = 6
TKIND_UNION     = 7
TKIND_MAX       = 8

TLS_MINIMUM_AVAILABLE = win32con.TLS_MINIMUM_AVAILABLE # 64
TLS_OUT_OF_INDEXES    = 4294967295 # Variable c_ulong

TME_HOVER  = win32con.TME_HOVER # 1
TME_LEAVE  = win32con.TME_LEAVE # 2
TME_QUERY  = win32con.TME_QUERY # 1073741824
TME_CANCEL = win32con.TME_CANCEL # -2147483648

TMPF_FIXED_PITCH = win32con.TMPF_FIXED_PITCH # 1
TMPF_VECTOR      = win32con.TMPF_VECTOR # 2
TMPF_TRUETYPE    = win32con.TMPF_TRUETYPE # 4
TMPF_DEVICE      = win32con.TMPF_DEVICE # 8

TOKEN_ASSIGN_PRIMARY    = win32con.TOKEN_ASSIGN_PRIMARY # 1
TOKEN_DUPLICATE         = win32con.TOKEN_DUPLICATE # 2
TOKEN_IMPERSONATE       = win32con.TOKEN_IMPERSONATE # 4
TOKEN_QUERY             = win32con.TOKEN_QUERY # 8
TOKEN_SOURCE_LENGTH     = win32con.TOKEN_SOURCE_LENGTH # 8
TOKEN_QUERY_SOURCE      = win32con.TOKEN_QUERY_SOURCE # 16
TOKEN_ADJUST_PRIVILEGES = win32con.TOKEN_ADJUST_PRIVILEGES # 32
TOKEN_ADJUST_GROUPS     = win32con.TOKEN_ADJUST_GROUPS # 64
TOKEN_ADJUST_DEFAULT    = win32con.TOKEN_ADJUST_DEFAULT # 128
TOKEN_ADJUST_SESSIONID  = 256 # Variable c_int
TOKEN_EXECUTE           = win32con.TOKEN_EXECUTE # 131072
TOKEN_READ              = win32con.TOKEN_READ # 131080
TOKEN_WRITE             = win32con.TOKEN_WRITE # 131296
TOKEN_ALL_ACCESS        = win32con.TOKEN_ALL_ACCESS # 983295

TOOLTIPS_CLASSA = 'tooltips_class32' # Variable POINTER(c_char)
TOOLTIPS_CLASSW = 'tooltips_class32' # Variable POINTER(c_wchar)

TPM_TOPALIGN     = win32con.TPM_TOPALIGN # 0
TPM_LEFTALIGN    = win32con.TPM_LEFTALIGN # 0
TPM_LEFTBUTTON   = win32con.TPM_LEFTBUTTON # 0
TPM_HORIZONTAL   = win32con.TPM_HORIZONTAL # 0
TPM_RIGHTBUTTON  = win32con.TPM_RIGHTBUTTON # 2
TPM_CENTERALIGN  = win32con.TPM_CENTERALIGN # 4
TPM_RIGHTALIGN   = win32con.TPM_RIGHTALIGN # 8
TPM_VCENTERALIGN = win32con.TPM_VCENTERALIGN # 16
TPM_BOTTOMALIGN  = win32con.TPM_BOTTOMALIGN # 32
TPM_VERTICAL     = win32con.TPM_VERTICAL # 64
TPM_NONOTIFY     = win32con.TPM_NONOTIFY # 128
TPM_RETURNCMD    = win32con.TPM_RETURNCMD # 256

TRACKBAR_CLASSA = 'msctls_trackbar32' # Variable POINTER(c_char)
TRACKBAR_CLASSW = 'msctls_trackbar32' # Variable POINTER(c_wchar)

TRANSFORM_CTM = win32con.TRANSFORM_CTM # 4107

TRANSPORT_TYPE_CN   = 1 # Variable c_int
TRANSPORT_TYPE_DG   = 2 # Variable c_int
TRANSPORT_TYPE_LPC  = 4 # Variable c_int
TRANSPORT_TYPE_WMSG = 8 # Variable c_int

TRUETYPE_FONTTYPE = win32con.TRUETYPE_FONTTYPE # 4

TRUNCATE_EXISTING = win32con.TRUNCATE_EXISTING # 5

TRUST_E_FAIL                 = -2146762485 # Variable c_long
TRUST_E_NOSIGNATURE          = -2146762496 # Variable c_long
TRUST_E_SUBJECT_NOT_TRUSTED  = -2146762748 # Variable c_long
TRUST_E_SUBJECT_FORM_UNKNOWN = -2146762749 # Variable c_long
TRUST_E_ACTION_UNKNOWN       = -2146762750 # Variable c_long
TRUST_E_PROVIDER_UNKNOWN     = -2146762751 # Variable c_long
TRUST_E_FINANCIAL_CRITERIA   = -2146869218 # Variable c_long
TRUST_E_BASIC_CONSTRAINTS    = -2146869223 # Variable c_long
TRUST_E_BAD_DIGEST           = -2146869232 # Variable c_long
TRUST_E_TIME_STAMP           = -2146869243 # Variable c_long
TRUST_E_CERT_SIGNATURE       = -2146869244 # Variable c_long
TRUST_E_COUNTER_SIGNER       = -2146869245 # Variable c_long
TRUST_E_NO_SIGNER_CERT       = -2146869246 # Variable c_long
TRUST_E_SYSTEM_ERROR         = -2146869247 # Variable c_long

TTDT_AUTOMATIC = 0 # Variable c_int
TTDT_RESHOW    = 1 # Variable c_int
TTDT_AUTOPOP   = 2 # Variable c_int
TTDT_INITIAL   = 3 # Variable c_int

TTF_IDISHWND    = 1 # Variable c_int
TTF_CENTERTIP   = 2 # Variable c_int
TTF_RTLREADING  = 4 # Variable c_int
TTF_SUBCLASS    = 16 # Variable c_int
TTF_TRACK       = 32 # Variable c_int
TTF_ABSOLUTE    = 128 # Variable c_int
TTF_TRANSPARENT = 256 # Variable c_int
TTF_DI_SETITEM  = 32768 # Variable c_int

TTM_ACTIVATE        = 1025 # Variable c_int
TTM_SETDELAYTIME    = 1027 # Variable c_int
TTM_ADDTOOLA        = 1028 # Variable c_int
TTM_DELTOOLA        = 1029 # Variable c_int
TTM_NEWTOOLRECTA    = 1030 # Variable c_int
TTM_RELAYEVENT      = 1031 # Variable c_int
TTM_GETTOOLINFOA    = 1032 # Variable c_int
TTM_SETTOOLINFOA    = 1033 # Variable c_int
TTM_HITTESTA        = 1034 # Variable c_int
TTM_GETTEXTA        = 1035 # Variable c_int
TTM_UPDATETIPTEXTA  = 1036 # Variable c_int
TTM_GETTOOLCOUNT    = 1037 # Variable c_int
TTM_ENUMTOOLSA      = 1038 # Variable c_int
TTM_GETCURRENTTOOLA = 1039 # Variable c_int
TTM_WINDOWFROMPOINT = 1040 # Variable c_int
TTM_TRACKACTIVATE   = 1041 # Variable c_int
TTM_TRACKPOSITION   = 1042 # Variable c_int
TTM_SETTIPBKCOLOR   = 1043 # Variable c_int
TTM_SETTIPTEXTCOLOR = 1044 # Variable c_int
TTM_GETDELAYTIME    = 1045 # Variable c_int
TTM_GETTIPBKCOLOR   = 1046 # Variable c_int
TTM_GETTIPTEXTCOLOR = 1047 # Variable c_int
TTM_SETMAXTIPWIDTH  = 1048 # Variable c_int
TTM_GETMAXTIPWIDTH  = 1049 # Variable c_int
TTM_SETMARGIN       = 1050 # Variable c_int
TTM_GETMARGIN       = 1051 # Variable c_int
TTM_POP             = 1052 # Variable c_int
TTM_UPDATE          = 1053 # Variable c_int
TTM_ADDTOOLW        = 1074 # Variable c_int
TTM_DELTOOLW        = 1075 # Variable c_int
TTM_NEWTOOLRECTW    = 1076 # Variable c_int
TTM_GETTOOLINFOW    = 1077 # Variable c_int
TTM_SETTOOLINFOW    = 1078 # Variable c_int
TTM_HITTESTW        = 1079 # Variable c_int
TTM_GETTEXTW        = 1080 # Variable c_int
TTM_UPDATETIPTEXTW  = 1081 # Variable c_int
TTM_ENUMTOOLSW      = 1082 # Variable c_int
TTM_GETCURRENTTOOLW = 1083 # Variable c_int

TTN_LAST         = 4294966747 # Variable c_uint
TTN_GETDISPINFOW = 4294966766 # Variable c_uint
TTN_POP          = 4294966774 # Variable c_uint
TTN_SHOW         = 4294966775 # Variable c_uint
TTN_GETDISPINFOA = 4294966776 # Variable c_uint
TTN_FIRST        = 4294966776 # Variable c_uint
TTN_LINKCLICK    = 4294966773
TTN_NEEDTEXTW    = TTN_GETDISPINFOW

TTS_ALWAYSTIP = 1 # Variable c_int
TTS_NOPREFIX  = 2 # Variable c_int

TTTOOLINFOA_V1_SIZE = 40 # Variable c_uint

TTTOOLINFOW_V1_SIZE = 40 # Variable c_uint

TT_PRIM_LINE    = win32con.TT_PRIM_LINE # 1
TT_AVAILABLE    = win32con.TT_AVAILABLE # 1
TT_ENABLED      = win32con.TT_ENABLED # 2
TT_PRIM_QSPLINE = win32con.TT_PRIM_QSPLINE # 2
TT_PRIM_CSPLINE = 3 # Variable c_int
TT_POLYGON_TYPE = win32con.TT_POLYGON_TYPE # 24

TURKISH_CHARSET = win32con.TURKISH_CHARSET # 162

TV_FIRST = 4352 # Variable c_int

TVCDRF_NOIMAGES = 65536 # Variable c_int

TVC_UNKNOWN    = 0 # Variable c_int
TVC_BYMOUSE    = 1 # Variable c_int
TVC_BYKEYBOARD = 2 # Variable c_int

TVE_COLLAPSE      = 1 # Variable c_int
TVE_EXPAND        = 2 # Variable c_int
TVE_TOGGLE        = 3 # Variable c_int
TVE_EXPANDPARTIAL = 16384 # Variable c_int
TVE_COLLAPSERESET = 32768 # Variable c_int

TVGN_ROOT            = 0 # Variable c_int
TVGN_NEXT            = 1 # Variable c_int
TVGN_PREVIOUS        = 2 # Variable c_int
TVGN_PARENT          = 3 # Variable c_int
TVGN_CHILD           = 4 # Variable c_int
TVGN_FIRSTVISIBLE    = 5 # Variable c_int
TVGN_NEXTVISIBLE     = 6 # Variable c_int
TVGN_PREVIOUSVISIBLE = 7 # Variable c_int
TVGN_DROPHILITE      = 8 # Variable c_int
TVGN_CARET           = 9 # Variable c_int
TVGN_LASTVISIBLE     = 10 # Variable c_int

TVHT_NOWHERE         = 1 # Variable c_int
TVHT_ONITEMICON      = 2 # Variable c_int
TVHT_ONITEMLABEL     = 4 # Variable c_int
TVHT_ONITEMINDENT    = 8 # Variable c_int
TVHT_ONITEMBUTTON    = 16 # Variable c_int
TVHT_ONITEMRIGHT     = 32 # Variable c_int
TVHT_ONITEMSTATEICON = 64 # Variable c_int
TVHT_ONITEM          = 70 # Variable c_int
TVHT_ABOVE           = 256 # Variable c_int
TVHT_BELOW           = 512 # Variable c_int
TVHT_TORIGHT         = 1024 # Variable c_int
TVHT_TOLEFT          = 2048 # Variable c_int

TVIF_TEXT          = 1 # Variable c_int
TVIF_IMAGE         = 2 # Variable c_int
TVIF_PARAM         = 4 # Variable c_int
TVIF_STATE         = 8 # Variable c_int
TVIF_HANDLE        = 16 # Variable c_int
TVIF_SELECTEDIMAGE = 32 # Variable c_int
TVIF_CHILDREN      = 64 # Variable c_int
TVIF_INTEGRAL      = 128 # Variable c_int
TVIF_DI_SETITEM    = 4096 # Variable c_int

TVINSERTSTRUCTA_V1_SIZE = 48 # Variable c_uint

TVINSERTSTRUCTW_V1_SIZE = 48 # Variable c_uint

TVIS_SELECTED       = 2 # Variable c_int
TVIS_CUT            = 4 # Variable c_int
TVIS_DROPHILITED    = 8 # Variable c_int
TVIS_BOLD           = 16 # Variable c_int
TVIS_EXPANDED       = 32 # Variable c_int
TVIS_EXPANDEDONCE   = 64 # Variable c_int
TVIS_EXPANDPARTIAL  = 128 # Variable c_int
TVIS_OVERLAYMASK    = 3840 # Variable c_int
TVIS_USERMASK       = 61440 # Variable c_int
TVIS_STATEIMAGEMASK = 61440 # Variable c_int

TVI_ROOT  = 4294901760 # Variable POINTER(_TREEITEM)
TVI_FIRST = 4294901761 # Variable POINTER(_TREEITEM)
TVI_LAST  = 4294901762 # Variable POINTER(_TREEITEM)
TVI_SORT  = 4294901763 # Variable POINTER(_TREEITEM)

TVM_INSERTITEMA        = 4352 # Variable c_int
TVM_DELETEITEM         = 4353 # Variable c_int
TVM_EXPAND             = 4354 # Variable c_int
TVM_GETITEMRECT        = 4356 # Variable c_int
TVM_GETCOUNT           = 4357 # Variable c_int
TVM_GETINDENT          = 4358 # Variable c_int
TVM_SETINDENT          = 4359 # Variable c_int
TVM_GETIMAGELIST       = 4360 # Variable c_int
TVM_SETIMAGELIST       = 4361 # Variable c_int
TVM_GETNEXTITEM        = 4362 # Variable c_int
TVM_SELECTITEM         = 4363 # Variable c_int
TVM_GETITEMA           = 4364 # Variable c_int
TVM_SETITEMA           = 4365 # Variable c_int
TVM_EDITLABELA         = 4366 # Variable c_int
TVM_GETEDITCONTROL     = 4367 # Variable c_int
TVM_GETVISIBLECOUNT    = 4368 # Variable c_int
TVM_HITTEST            = 4369 # Variable c_int
TVM_CREATEDRAGIMAGE    = 4370 # Variable c_int
TVM_SORTCHILDREN       = 4371 # Variable c_int
TVM_ENSUREVISIBLE      = 4372 # Variable c_int
TVM_SORTCHILDRENCB     = 4373 # Variable c_int
TVM_ENDEDITLABELNOW    = 4374 # Variable c_int
TVM_GETISEARCHSTRINGA  = 4375 # Variable c_int
TVM_SETTOOLTIPS        = 4376 # Variable c_int
TVM_GETTOOLTIPS        = 4377 # Variable c_int
TVM_SETINSERTMARK      = 4378 # Variable c_int
TVM_SETITEMHEIGHT      = 4379 # Variable c_int
TVM_GETITEMHEIGHT      = 4380 # Variable c_int
TVM_SETBKCOLOR         = 4381 # Variable c_int
TVM_SETTEXTCOLOR       = 4382 # Variable c_int
TVM_GETBKCOLOR         = 4383 # Variable c_int
TVM_GETTEXTCOLOR       = 4384 # Variable c_int
TVM_SETSCROLLTIME      = 4385 # Variable c_int
TVM_GETSCROLLTIME      = 4386 # Variable c_int
TVM_SETINSERTMARKCOLOR = 4389 # Variable c_int
TVM_GETINSERTMARKCOLOR = 4390 # Variable c_int
TVM_INSERTITEMW        = 4402 # Variable c_int
TVM_GETITEMW           = 4414 # Variable c_int
TVM_SETITEMW           = 4415 # Variable c_int
TVM_GETISEARCHSTRINGW  = 4416 # Variable c_int
TVM_EDITLABELW         = 4417 # Variable c_int
TVM_GETITEMSTATE       = TV_FIRST + 39

TVN_LAST            = 4294966797 # Variable c_uint
TVN_ENDLABELEDITW   = 4294966836 # Variable c_uint
TVN_BEGINLABELEDITW = 4294966837 # Variable c_uint
TVN_DELETEITEMW     = 4294966838 # Variable c_uint
TVN_BEGINRDRAGW     = 4294966839 # Variable c_uint
TVN_BEGINDRAGW      = 4294966840 # Variable c_uint
TVN_ITEMEXPANDEDW   = 4294966841 # Variable c_uint
TVN_ITEMEXPANDINGW  = 4294966842 # Variable c_uint
TVN_SETDISPINFOW    = 4294966843 # Variable c_uint
TVN_GETDISPINFOW    = 4294966844 # Variable c_uint
TVN_SELCHANGEDW     = 4294966845 # Variable c_uint
TVN_SELCHANGINGW    = 4294966846 # Variable c_uint
TVN_SINGLEEXPAND    = 4294966881 # Variable c_uint
TVN_GETINFOTIPW     = 4294966882 # Variable c_uint
TVN_GETINFOTIPA     = 4294966883 # Variable c_uint
TVN_KEYDOWN         = 4294966884 # Variable c_uint
TVN_ENDLABELEDITA   = 4294966885 # Variable c_uint
TVN_BEGINLABELEDITA = 4294966886 # Variable c_uint
TVN_DELETEITEMA     = 4294966887 # Variable c_uint
TVN_BEGINRDRAGA     = 4294966888 # Variable c_uint
TVN_BEGINDRAGA      = 4294966889 # Variable c_uint
TVN_ITEMEXPANDEDA   = 4294966890 # Variable c_uint
TVN_ITEMEXPANDINGA  = 4294966891 # Variable c_uint
TVN_SETDISPINFOA    = 4294966892 # Variable c_uint
TVN_GETDISPINFOA    = 4294966893 # Variable c_uint
TVN_SELCHANGEDA     = 4294966894 # Variable c_uint
TVN_SELCHANGINGA    = 4294966895 # Variable c_uint
TVN_FIRST           = 4294966896 # Variable c_uint
TVN_ASYNCDRAW       = 4294966876
TVN_ITEMCHANGED     = 4294966878
TVN_ITEMCHANGING    = 4294966880

TVSIL_NORMAL = 0 # Variable c_int
TVSIL_STATE  = 2 # Variable c_int

TVS_HASBUTTONS      = 1 # Variable c_int
TVS_HASLINES        = 2 # Variable c_int
TVS_LINESATROOT     = 4 # Variable c_int
TVS_EDITLABELS      = 8 # Variable c_int
TVS_DISABLEDRAGDROP = 16 # Variable c_int
TVS_SHOWSELALWAYS   = 32 # Variable c_int
TVS_RTLREADING      = 64 # Variable c_int
TVS_NOTOOLTIPS      = 128 # Variable c_int
TVS_CHECKBOXES      = 256 # Variable c_int
TVS_TRACKSELECT     = 512 # Variable c_int
TVS_SINGLEEXPAND    = 1024 # Variable c_int
TVS_INFOTIP         = 2048 # Variable c_int
TVS_FULLROWSELECT   = 4096 # Variable c_int
TVS_NOSCROLL        = 8192 # Variable c_int
TVS_NONEVENHEIGHT   = 16384 # Variable c_int

TYMED_NULL     = 0
TYMED_HGLOBAL  = 1
TYMED_FILE     = 2
TYMED_ISTREAM  = 4
TYMED_ISTORAGE = 8
TYMED_GDI      = 16
TYMED_MFPICT   = 32
TYMED_ENHMF    = 64

TYPE1_FONTTYPE = win32con.TYPE1_FONTTYPE # 131072

TYPEFLAG_FAPPOBJECT     = 1
TYPEFLAG_FCANCREATE     = 2
TYPEFLAG_FLICENSED      = 4
TYPEFLAG_FPREDECLID     = 8
TYPEFLAG_FHIDDEN        = 16
TYPEFLAG_FCONTROL       = 32
TYPEFLAG_FDUAL          = 64
TYPEFLAG_FNONEXTENSIBLE = 128
TYPEFLAG_FOLEAUTOMATION = 256
TYPEFLAG_FRESTRICTED    = 512
TYPEFLAG_FAGGREGATABLE  = 1024
TYPEFLAG_FREPLACEABLE   = 2048
TYPEFLAG_FDISPATCHABLE  = 4096
TYPEFLAG_FREVERSEBIND   = 8192

TYPE_E_CIRCULARTYPE            = -2147312508 # Variable c_long
TYPE_E_INCONSISTENTPROPFUNCS   = -2147312509 # Variable c_long
TYPE_E_CANTLOADLIBRARY         = -2147312566 # Variable c_long
TYPE_E_CANTCREATETMPFILE       = -2147316573 # Variable c_long
TYPE_E_IOERROR                 = -2147316574 # Variable c_long
TYPE_E_OUTOFBOUNDS             = -2147316575 # Variable c_long
TYPE_E_TYPEMISMATCH            = -2147316576 # Variable c_long
TYPE_E_INVALIDID               = -2147317553 # Variable c_long
TYPE_E_DUPLICATEID             = -2147317562 # Variable c_long
TYPE_E_SIZETOOBIG              = -2147317563 # Variable c_long
TYPE_E_BADMODULEKIND           = -2147317571 # Variable c_long
TYPE_E_DLLFUNCTIONNOTFOUND     = -2147319761 # Variable c_long
TYPE_E_UNKNOWNLCID             = -2147319762 # Variable c_long
TYPE_E_NAMECONFLICT            = -2147319763 # Variable c_long
TYPE_E_AMBIGUOUSNAME           = -2147319764 # Variable c_long
TYPE_E_ELEMENTNOTFOUND         = -2147319765 # Variable c_long
TYPE_E_WRONGTYPEKIND           = -2147319766 # Variable c_long
TYPE_E_INVALIDSTATE            = -2147319767 # Variable c_long
TYPE_E_QUALIFIEDNAMEDISALLOWED = -2147319768 # Variable c_long
TYPE_E_UNDEFINEDTYPE           = -2147319769 # Variable c_long
TYPE_E_LIBNOTREGISTERED        = -2147319779 # Variable c_long
TYPE_E_REGISTRYACCESS          = -2147319780 # Variable c_long
TYPE_E_UNSUPFORMAT             = -2147319783 # Variable c_long
TYPE_E_INVDATAREAD             = -2147319784 # Variable c_long
TYPE_E_FIELDNOTFOUND           = -2147319785 # Variable c_long
TYPE_E_BUFFERTOOSMALL          = -2147319786 # Variable c_long

TYSPEC_CLSID       = 0
TYSPEC_FILEEXT     = 1
TYSPEC_MIMETYPE    = 2
TYSPEC_PROGID      = 3
TYSPEC_IID         = 4
TYSPEC_TYPELIB     = 5
TYSPEC_FILENAME    = 6
TYSPEC_JAVACLASS   = 7
TYSPEC_PACKAGENAME = 8

UDM_SETRANGE   = 1125 # Variable c_int
UDM_GETRANGE   = 1126 # Variable c_int
UDM_SETPOS     = 1127 # Variable c_int
UDM_GETPOS     = 1128 # Variable c_int
UDM_SETBUDDY   = 1129 # Variable c_int
UDM_GETBUDDY   = 1130 # Variable c_int
UDM_SETACCEL   = 1131 # Variable c_int
UDM_GETACCEL   = 1132 # Variable c_int
UDM_SETBASE    = 1133 # Variable c_int
UDM_GETBASE    = 1134 # Variable c_int
UDM_SETRANGE32 = 1135 # Variable c_int
UDM_GETRANGE32 = 1136 # Variable c_int

UDN_LAST     = 4294966556 # Variable c_uint
UDN_DELTAPOS = 4294966574 # Variable c_uint
UDN_FIRST    = 4294966575 # Variable c_uint

UDS_WRAP        = 1 # Variable c_int
UDS_SETBUDDYINT = 2 # Variable c_int
UDS_ALIGNRIGHT  = 4 # Variable c_int
UDS_ALIGNLEFT   = 8 # Variable c_int
UDS_AUTOBUDDY   = 16 # Variable c_int
UDS_ARROWKEYS   = 32 # Variable c_int
UDS_HORZ        = 64 # Variable c_int
UDS_NOTHOUSANDS = 128 # Variable c_int
UDS_HOTTRACK    = 256 # Variable c_int

UD_MAXVAL = 32767 # Variable c_int
UD_MINVAL = -32767 # Variable c_int

UI_CAP_2700   = 1 # Variable c_int
UI_CAP_ROT90  = 2 # Variable c_int
UI_CAP_ROTANY = 4 # Variable c_int

UNICODE_NULL = '\x00' # Variable c_wchar

UNIQUE_NAME = 0 # Variable c_int

UNIVERSAL_NAME_INFO_LEVEL = 1 # Variable c_int

UNLOAD_DLL_DEBUG_EVENT = win32con.UNLOAD_DLL_DEBUG_EVENT # 7

UOI_FLAGS    = win32con.UOI_FLAGS # 1
UOI_NAME     = win32con.UOI_NAME # 2
UOI_TYPE     = win32con.UOI_TYPE # 3
UOI_USER_SID = win32con.UOI_USER_SID # 4

UPDFCACHE_NODATACACHE          = 1 # Variable c_int
UPDFCACHE_ONSAVECACHE          = 2 # Variable c_int
UPDFCACHE_ONSTOPCACHE          = 4 # Variable c_int
UPDFCACHE_NORMALCACHE          = 8 # Variable c_int
UPDFCACHE_IFBLANK              = 16 # Variable c_int
UPDFCACHE_IFBLANKORONSAVECACHE = 18 # Variable c_int
UPDFCACHE_ALLBUTNODATACACHE    = 2147483646 # Variable c_ulong
UPDFCACHE_ALL                  = 2147483647 # Variable c_ulong
UPDFCACHE_ONLYIFBLANK          = 2147483648 # Variable c_uint

UPDOWN_CLASSA = 'msctls_updown32' # Variable POINTER(c_char)
UPDOWN_CLASSW = 'msctls_updown32' # Variable POINTER(c_wchar)

URLACTION_MIN                                    = 4096 # Variable c_int
URLACTION_DOWNLOAD_MIN                           = 4096 # Variable c_int
URLACTION_DOWNLOAD_SIGNED_ACTIVEX                = 4097 # Variable c_int
URLACTION_DOWNLOAD_UNSIGNED_ACTIVEX              = 4100 # Variable c_int
URLACTION_DOWNLOAD_CURR_MAX                      = 4100 # Variable c_int
URLACTION_DOWNLOAD_MAX                           = 4607 # Variable c_int
URLACTION_ACTIVEX_MIN                            = 4608 # Variable c_int
URLACTION_ACTIVEX_RUN                            = 4608 # Variable c_int
URLACTION_ACTIVEX_OVERRIDE_OBJECT_SAFETY         = 4609 # Variable c_int
URLACTION_ACTIVEX_OVERRIDE_DATA_SAFETY           = 4610 # Variable c_int
URLACTION_ACTIVEX_OVERRIDE_SCRIPT_SAFETY         = 4611 # Variable c_int
URLACTION_ACTIVEX_CONFIRM_NOOBJECTSAFETY         = 4612 # Variable c_int
URLACTION_ACTIVEX_CURR_MAX                       = 4613 # Variable c_int
URLACTION_ACTIVEX_TREATASUNTRUSTED               = 4613 # Variable c_int
URLACTION_ACTIVEX_MAX                            = 5119 # Variable c_int
URLACTION_SCRIPT_MIN                             = 5120 # Variable c_int
URLACTION_SCRIPT_RUN                             = 5120 # Variable c_int
URLACTION_SCRIPT_OVERRIDE_SAFETY                 = 5121 # Variable c_int
URLACTION_SCRIPT_JAVA_USE                        = 5122 # Variable c_int
URLACTION_SCRIPT_CURR_MAX                        = 5125 # Variable c_int
URLACTION_SCRIPT_SAFE_ACTIVEX                    = 5125 # Variable c_int
URLACTION_SCRIPT_MAX                             = 5631 # Variable c_int
URLACTION_HTML_MIN                               = 5632 # Variable c_int
URLACTION_HTML_SUBMIT_FORMS                      = 5633 # Variable c_int
URLACTION_HTML_SUBMIT_FORMS_FROM                 = 5634 # Variable c_int
URLACTION_HTML_SUBMIT_FORMS_TO                   = 5635 # Variable c_int
URLACTION_HTML_FONT_DOWNLOAD                     = 5636 # Variable c_int
URLACTION_HTML_JAVA_RUN                          = 5637 # Variable c_int
URLACTION_HTML_CURR_MAX                          = 5637 # Variable c_int
URLACTION_HTML_MAX                               = 6143 # Variable c_int
URLACTION_SHELL_MIN                              = 6144 # Variable c_int
URLACTION_SHELL_INSTALL_DTITEMS                  = 6144 # Variable c_int
URLACTION_SHELL_MOVE_OR_COPY                     = 6146 # Variable c_int
URLACTION_SHELL_FILE_DOWNLOAD                    = 6147 # Variable c_int
URLACTION_SHELL_VERB                             = 6148 # Variable c_int
URLACTION_SHELL_CURR_MAX                         = 6149 # Variable c_int
URLACTION_SHELL_WEBVIEW_VERB                     = 6149 # Variable c_int
URLACTION_SHELL_MAX                              = 6655 # Variable c_int
URLACTION_CREDENTIALS_USE                        = 6656 # Variable c_int
URLACTION_NETWORK_MIN                            = 6656 # Variable c_int
URLACTION_AUTHENTICATE_CLIENT                    = 6657 # Variable c_int
URLACTION_NETWORK_CURR_MAX                       = 6657 # Variable c_int
URLACTION_NETWORK_MAX                            = 7167 # Variable c_int
URLACTION_JAVA_MIN                               = 7168 # Variable c_int
URLACTION_JAVA_CURR_MAX                          = 7168 # Variable c_int
URLACTION_JAVA_PERMISSIONS                       = 7168 # Variable c_int
URLACTION_JAVA_MAX                               = 7423 # Variable c_int
URLACTION_INFODELIVERY_NO_ADDING_CHANNELS        = 7424 # Variable c_int
URLACTION_INFODELIVERY_MIN                       = 7424 # Variable c_int
URLACTION_INFODELIVERY_NO_EDITING_CHANNELS       = 7425 # Variable c_int
URLACTION_INFODELIVERY_NO_REMOVING_CHANNELS      = 7426 # Variable c_int
URLACTION_INFODELIVERY_NO_ADDING_SUBSCRIPTIONS   = 7427 # Variable c_int
URLACTION_INFODELIVERY_NO_EDITING_SUBSCRIPTIONS  = 7428 # Variable c_int
URLACTION_INFODELIVERY_NO_REMOVING_SUBSCRIPTIONS = 7429 # Variable c_int
URLACTION_INFODELIVERY_CURR_MAX                  = 7430 # Variable c_int
URLACTION_INFODELIVERY_NO_CHANNEL_LOGGING        = 7430 # Variable c_int
URLACTION_INFODELIVERY_MAX                       = 7679 # Variable c_int
URLACTION_CHANNEL_SOFTDIST_MIN                   = 7680 # Variable c_int
URLACTION_CHANNEL_SOFTDIST_PERMISSIONS           = 7685 # Variable c_int
URLACTION_CHANNEL_SOFTDIST_MAX                   = 7935 # Variable c_int

URLMON_OPTION_USERAGENT         = 268435457 # Variable c_int
URLMON_OPTION_USERAGENT_REFRESH = 268435458 # Variable c_int

URLOSTRM_USECACHEDCOPY_ONLY = 1 # Variable c_int
URLOSTRM_USECACHEDCOPY      = 2 # Variable c_int
URLOSTRM_GETNEWESTVERSION   = 3 # Variable c_int

URLPOLICY_CREDENTIALS_SILENT_LOGON_OK     = 0 # Variable c_int
URLPOLICY_ALLOW                           = 0 # Variable c_int
URLPOLICY_JAVA_PROHIBIT                   = 0 # Variable c_int
URLPOLICY_AUTHENTICATE_CLEARTEXT_OK       = 0 # Variable c_int
URLPOLICY_QUERY                           = 1 # Variable c_int
URLPOLICY_DISALLOW                        = 3 # Variable c_int
URLPOLICY_MASK_PERMISSIONS                = 15 # Variable c_int
URLPOLICY_NOTIFY_ON_ALLOW                 = 16 # Variable c_int
URLPOLICY_NOTIFY_ON_DISALLOW              = 32 # Variable c_int
URLPOLICY_LOG_ON_ALLOW                    = 64 # Variable c_int
URLPOLICY_LOG_ON_DISALLOW                 = 128 # Variable c_int
URLPOLICY_JAVA_HIGH                       = 65536 # Variable c_int
URLPOLICY_CHANNEL_SOFTDIST_PROHIBIT       = 65536 # Variable c_int
URLPOLICY_AUTHENTICATE_CHALLENGE_RESPONSE = 65536 # Variable c_int
URLPOLICY_CREDENTIALS_MUST_PROMPT_USER    = 65536 # Variable c_int
URLPOLICY_CREDENTIALS_CONDITIONAL_PROMPT  = 131072 # Variable c_int
URLPOLICY_CHANNEL_SOFTDIST_PRECACHE       = 131072 # Variable c_int
URLPOLICY_JAVA_MEDIUM                     = 131072 # Variable c_int
URLPOLICY_CREDENTIALS_ANONYMOUS_ONLY      = 196608 # Variable c_int
URLPOLICY_AUTHENTICATE_MUTUAL_ONLY        = 196608 # Variable c_int
URLPOLICY_CHANNEL_SOFTDIST_AUTOINSTALL    = 196608 # Variable c_int
URLPOLICY_JAVA_LOW                        = 196608 # Variable c_int
URLPOLICY_JAVA_CUSTOM                     = 8388608 # Variable c_int

URLTEMPLATE_CUSTOM         = 0
URLTEMPLATE_PREDEFINED_MIN = 65536
URLTEMPLATE_LOW            = 65536
URLTEMPLATE_MEDIUM         = 69632
URLTEMPLATE_HIGH           = 73728
URLTEMPLATE_PREDEFINED_MAX = 131072

URLZONEREG_DEFAULT = 0
URLZONEREG_HKLM    = 1
URLZONEREG_HKCU    = 2

URLZONE_PREDEFINED_MIN = 0
URLZONE_LOCAL_MACHINE  = 0
URLZONE_INTRANET       = 1
URLZONE_TRUSTED        = 2
URLZONE_INTERNET       = 3
URLZONE_UNTRUSTED      = 4
URLZONE_PREDEFINED_MAX = 999
URLZONE_USER_MIN       = 1000
URLZONE_USER_MAX       = 10000

USERCLASSTYPE_FULL    = 1
USERCLASSTYPE_SHORT   = 2
USERCLASSTYPE_APPNAME = 3

USER_MARSHAL_FC_BYTE   = 1 # Variable c_int
USER_MARSHAL_FC_CHAR   = 2 # Variable c_int
USER_MARSHAL_FC_SMALL  = 3 # Variable c_int
USER_MARSHAL_FC_USMALL = 4 # Variable c_int
USER_MARSHAL_FC_WCHAR  = 5 # Variable c_int
USER_MARSHAL_FC_SHORT  = 6 # Variable c_int
USER_MARSHAL_FC_USHORT = 7 # Variable c_int
USER_MARSHAL_FC_LONG   = 8 # Variable c_int
USER_MARSHAL_FC_ULONG  = 9 # Variable c_int
USER_MARSHAL_FC_FLOAT  = 10 # Variable c_int
USER_MARSHAL_FC_HYPER  = 11 # Variable c_int
USER_MARSHAL_FC_DOUBLE = 12 # Variable c_int
USER_CALL_IS_ASYNC     = 256 # Variable c_int

VALID_INHERIT_FLAGS = win32con.VALID_INHERIT_FLAGS # 15

VARCMP_LT   = 0 # Variable c_int
VARCMP_EQ   = 1 # Variable c_int
VARCMP_GT   = 2 # Variable c_int
VARCMP_NULL = 3 # Variable c_int

VARFLAG_FREADONLY        = 1
VARFLAG_FSOURCE          = 2
VARFLAG_FBINDABLE        = 4
VARFLAG_FREQUESTEDIT     = 8
VARFLAG_FDISPLAYBIND     = 16
VARFLAG_FDEFAULTBIND     = 32
VARFLAG_FHIDDEN          = 64
VARFLAG_FRESTRICTED      = 128
VARFLAG_FDEFAULTCOLLELEM = 256
VARFLAG_FUIDEFAULT       = 512
VARFLAG_FNONBROWSABLE    = 1024
VARFLAG_FREPLACEABLE     = 2048
VARFLAG_FIMMEDIATEBIND   = 4096

VARIABLE_PITCH = win32con.VARIABLE_PITCH # 2

VARIANT_FALSE          = 0 # Variable c_short
VARIANT_NOVALUEPROP    = 1 # Variable c_int
VARIANT_ALPHABOOL      = 2 # Variable c_int
VARIANT_NOUSEROVERRIDE = 4 # Variable c_int
VARIANT_CALENDAR_HIJRI = 8 # Variable c_int
VARIANT_LOCALBOOL      = 16 # Variable c_int
VARIANT_TRUE           = -1 # Variable c_short

VAR_PERINSTANCE         = 0
VAR_STATIC              = 1
VAR_TIMEVALUEONLY       = 1 # Variable c_ulong
VAR_CONST               = 2
VAR_DATEVALUEONLY       = 2 # Variable c_ulong
VAR_DISPATCH            = 3
VAR_VALIDDATE           = 4 # Variable c_ulong
VAR_CALENDAR_HIJRI      = 8 # Variable c_ulong
VAR_LOCALBOOL           = 16 # Variable c_ulong
VAR_FORMAT_NOSUBSTITUTE = 32 # Variable c_ulong
VAR_FOURDIGITYEARS      = 64 # Variable c_ulong

VER_PLATFORM_WIN32s        = win32con.VER_PLATFORM_WIN32s # 0
VER_PLATFORM_WIN32_WINDOWS = win32con.VER_PLATFORM_WIN32_WINDOWS # 1
VER_PLATFORM_WIN32_NT      = win32con.VER_PLATFORM_WIN32_NT # 2

VFFF_ISSHAREDFILE = 1 # Variable c_int

VFF_CURNEDEST    = 1 # Variable c_int
VFF_FILEINUSE    = 2 # Variable c_int
VFF_BUFFTOOSMALL = 4 # Variable c_int

VFT2_UNKNOWN         = 0 # Variable c_long
VFT2_FONT_RASTER     = 1 # Variable c_long
VFT2_DRV_PRINTER     = 1 # Variable c_long
VFT2_DRV_KEYBOARD    = 2 # Variable c_long
VFT2_FONT_VECTOR     = 2 # Variable c_long
VFT2_FONT_TRUETYPE   = 3 # Variable c_long
VFT2_DRV_LANGUAGE    = 3 # Variable c_long
VFT2_DRV_DISPLAY     = 4 # Variable c_long
VFT2_DRV_MOUSE       = 5 # Variable c_long
VFT2_DRV_NETWORK     = 6 # Variable c_long
VFT2_DRV_SYSTEM      = 7 # Variable c_long
VFT2_DRV_INSTALLABLE = 8 # Variable c_long
VFT2_DRV_SOUND       = 9 # Variable c_long
VFT2_DRV_COMM        = 10 # Variable c_long
VFT2_DRV_INPUTMETHOD = 11 # Variable c_long

VFT_UNKNOWN    = 0 # Variable c_long
VFT_APP        = 1 # Variable c_long
VFT_DLL        = 2 # Variable c_long
VFT_DRV        = 3 # Variable c_long
VFT_FONT       = 4 # Variable c_long
VFT_VXD        = 5 # Variable c_long
VFT_STATIC_LIB = 7 # Variable c_long

VIETNAMESE_CHARSET = win32con.VIETNAMESE_CHARSET # 163

VIEW_LARGEICONS       = 0 # Variable c_int
VIEW_SMALLICONS       = 1 # Variable c_int
VIEW_LIST             = 2 # Variable c_int
VIEW_DETAILS          = 3 # Variable c_int
VIEW_SORTNAME         = 4 # Variable c_int
VIEW_SORTSIZE         = 5 # Variable c_int
VIEW_SORTDATE         = 6 # Variable c_int
VIEW_SORTTYPE         = 7 # Variable c_int
VIEW_PARENTFOLDER     = 8 # Variable c_int
VIEW_NETCONNECT       = 9 # Variable c_int
VIEW_NETDISCONNECT    = 10 # Variable c_int
VIEW_NEWFOLDER        = 11 # Variable c_int
VIEW_VIEWMENU         = 12 # Variable c_int
VIEW_S_ALREADY_FROZEN = 262464 # Variable c_long
VIEW_S_FIRST          = 262464 # Variable c_long
VIEW_S_LAST           = 262479 # Variable c_long
VIEW_E_FIRST          = 2147746112 # Variable c_ulong
VIEW_E_LAST           = 2147746127 # Variable c_ulong
VIEW_E_DRAW           = -2147221184 # Variable c_long

VIFF_FORCEINSTALL  = 1 # Variable c_int
VIFF_DONTDELETEOLD = 2 # Variable c_int

VIF_TEMPFILE         = 1 # Variable c_long
VIF_MISMATCH         = 2 # Variable c_long
VIF_SRCOLD           = 4 # Variable c_long
VIF_DIFFLANG         = 8 # Variable c_long
VIF_DIFFCODEPG       = 16 # Variable c_long
VIF_DIFFTYPE         = 32 # Variable c_long
VIF_WRITEPROT        = 64 # Variable c_long
VIF_FILEINUSE        = 128 # Variable c_long
VIF_OUTOFSPACE       = 256 # Variable c_long
VIF_ACCESSVIOLATION  = 512 # Variable c_long
VIF_SHARINGVIOLATION = 1024 # Variable c_long
VIF_CANNOTCREATE     = 2048 # Variable c_long
VIF_CANNOTDELETE     = 4096 # Variable c_long
VIF_CANNOTRENAME     = 8192 # Variable c_long
VIF_CANNOTDELETECUR  = 16384 # Variable c_long
VIF_OUTOFMEMORY      = 32768 # Variable c_long
VIF_CANNOTREADSRC    = 65536 # Variable c_long
VIF_CANNOTREADDST    = 131072 # Variable c_long
VIF_BUFFTOOSMALL     = 262144 # Variable c_long

VK_LBUTTON    = win32con.VK_LBUTTON # 1
VK_RBUTTON    = win32con.VK_RBUTTON # 2
VK_CANCEL     = win32con.VK_CANCEL # 3
VK_MBUTTON    = win32con.VK_MBUTTON # 4
VK_BACK       = win32con.VK_BACK # 8
VK_TAB        = win32con.VK_TAB # 9
VK_CLEAR      = win32con.VK_CLEAR # 12
VK_RETURN     = win32con.VK_RETURN # 13
VK_SHIFT      = win32con.VK_SHIFT # 16
VK_CONTROL    = win32con.VK_CONTROL # 17
VK_MENU       = win32con.VK_MENU # 18
VK_PAUSE      = win32con.VK_PAUSE # 19
VK_CAPITAL    = win32con.VK_CAPITAL # 20
VK_HANGUL     = win32con.VK_HANGUL # 21
VK_HANGEUL    = win32con.VK_HANGEUL # 21
VK_KANA       = win32con.VK_KANA # 21
VK_JUNJA      = win32con.VK_JUNJA # 23
VK_FINAL      = win32con.VK_FINAL # 24
VK_KANJI      = win32con.VK_KANJI # 25
VK_HANJA      = win32con.VK_HANJA # 25
VK_ESCAPE     = win32con.VK_ESCAPE # 27
VK_CONVERT    = win32con.VK_CONVERT # 28
VK_NONCONVERT = win32con.VK_NONCONVERT # 29
VK_ACCEPT     = win32con.VK_ACCEPT # 30
VK_MODECHANGE = win32con.VK_MODECHANGE # 31
VK_SPACE      = win32con.VK_SPACE # 32
VK_PRIOR      = win32con.VK_PRIOR # 33
VK_NEXT       = win32con.VK_NEXT # 34
VK_END        = win32con.VK_END # 35
VK_HOME       = win32con.VK_HOME # 36
VK_LEFT       = win32con.VK_LEFT # 37
VK_UP         = win32con.VK_UP # 38
VK_RIGHT      = win32con.VK_RIGHT # 39
VK_DOWN       = win32con.VK_DOWN # 40
VK_SELECT     = win32con.VK_SELECT # 41
VK_PRINT      = win32con.VK_PRINT # 42
VK_EXECUTE    = win32con.VK_EXECUTE # 43
VK_SNAPSHOT   = win32con.VK_SNAPSHOT # 44
VK_INSERT     = win32con.VK_INSERT # 45
VK_DELETE     = win32con.VK_DELETE # 46
VK_HELP       = win32con.VK_HELP # 47
VK_LWIN       = win32con.VK_LWIN # 91
VK_RWIN       = win32con.VK_RWIN # 92
VK_APPS       = win32con.VK_APPS # 93
VK_NUMPAD0    = win32con.VK_NUMPAD0 # 96
VK_NUMPAD1    = win32con.VK_NUMPAD1 # 97
VK_NUMPAD2    = win32con.VK_NUMPAD2 # 98
VK_NUMPAD3    = win32con.VK_NUMPAD3 # 99
VK_NUMPAD4    = win32con.VK_NUMPAD4 # 100
VK_NUMPAD5    = win32con.VK_NUMPAD5 # 101
VK_NUMPAD6    = win32con.VK_NUMPAD6 # 102
VK_NUMPAD7    = win32con.VK_NUMPAD7 # 103
VK_NUMPAD8    = win32con.VK_NUMPAD8 # 104
VK_NUMPAD9    = win32con.VK_NUMPAD9 # 105
VK_MULTIPLY   = win32con.VK_MULTIPLY # 106
VK_ADD        = win32con.VK_ADD # 107
VK_SEPARATOR  = win32con.VK_SEPARATOR # 108
VK_SUBTRACT   = win32con.VK_SUBTRACT # 109
VK_DECIMAL    = win32con.VK_DECIMAL # 110
VK_DIVIDE     = win32con.VK_DIVIDE # 111
VK_F1         = win32con.VK_F1 # 112
VK_F2         = win32con.VK_F2 # 113
VK_F3         = win32con.VK_F3 # 114
VK_F4         = win32con.VK_F4 # 115
VK_F5         = win32con.VK_F5 # 116
VK_F6         = win32con.VK_F6 # 117
VK_F7         = win32con.VK_F7 # 118
VK_F8         = win32con.VK_F8 # 119
VK_F9         = win32con.VK_F9 # 120
VK_F10        = win32con.VK_F10 # 121
VK_F11        = win32con.VK_F11 # 122
VK_F12        = win32con.VK_F12 # 123
VK_F13        = win32con.VK_F13 # 124
VK_F14        = win32con.VK_F14 # 125
VK_F15        = win32con.VK_F15 # 126
VK_F16        = win32con.VK_F16 # 127
VK_F17        = win32con.VK_F17 # 128
VK_F18        = win32con.VK_F18 # 129
VK_F19        = win32con.VK_F19 # 130
VK_F20        = win32con.VK_F20 # 131
VK_F21        = win32con.VK_F21 # 132
VK_F22        = win32con.VK_F22 # 133
VK_F23        = win32con.VK_F23 # 134
VK_F24        = win32con.VK_F24 # 135
VK_NUMLOCK    = win32con.VK_NUMLOCK # 144
VK_SCROLL     = win32con.VK_SCROLL # 145
VK_LSHIFT     = win32con.VK_LSHIFT # 160
VK_RSHIFT     = win32con.VK_RSHIFT # 161
VK_LCONTROL   = win32con.VK_LCONTROL # 162
VK_RCONTROL   = win32con.VK_RCONTROL # 163
VK_LMENU      = win32con.VK_LMENU # 164
VK_RMENU      = win32con.VK_RMENU # 165
VK_PROCESSKEY = win32con.VK_PROCESSKEY # 229
VK_PACKET     = 231
VK_ATTN       = win32con.VK_ATTN # 246
VK_CRSEL      = win32con.VK_CRSEL # 247
VK_EXSEL      = win32con.VK_EXSEL # 248
VK_EREOF      = win32con.VK_EREOF # 249
VK_PLAY       = win32con.VK_PLAY # 250
VK_ZOOM       = win32con.VK_ZOOM # 251
VK_NONAME     = win32con.VK_NONAME # 252
VK_PA1        = win32con.VK_PA1 # 253
VK_OEM_CLEAR  = win32con.VK_OEM_CLEAR # 254

VOS_UNKNOWN       = 0 # Variable c_long
VOS__BASE         = 0 # Variable c_long
VOS__WINDOWS16    = 1 # Variable c_long
VOS__PM16         = 2 # Variable c_long
VOS__PM32         = 3 # Variable c_long
VOS__WINDOWS32    = 4 # Variable c_long
VOS_DOS           = 65536 # Variable c_long
VOS_DOS_WINDOWS16 = 65537 # Variable c_long
VOS_DOS_WINDOWS32 = 65540 # Variable c_long
VOS_OS216         = 131072 # Variable c_long
VOS_OS216_PM16    = 131074 # Variable c_long
VOS_OS232         = 196608 # Variable c_long
VOS_OS232_PM32    = 196611 # Variable c_long
VOS_NT            = 262144 # Variable c_long
VOS_NT_WINDOWS32  = 262148 # Variable c_long

VS_VERSION_INFO      = 1 # Variable c_int
VS_FF_DEBUG          = 1 # Variable c_long
VS_FF_PRERELEASE     = 2 # Variable c_long
VS_FF_PATCHED        = 4 # Variable c_long
VS_FF_PRIVATEBUILD   = 8 # Variable c_long
VS_FF_INFOINFERRED   = 16 # Variable c_long
VS_FF_SPECIALBUILD   = 32 # Variable c_long
VS_FFI_FILEFLAGSMASK = 63 # Variable c_long
VS_USER_DEFINED      = 100 # Variable c_int
VS_FFI_STRUCVERSION  = 65536 # Variable c_long
VS_FFI_SIGNATURE     = 4277077181 # Variable c_ulong

VTBIT_I2      = 4 # Variable c_int
VTBIT_I4      = 8 # Variable c_int
VTBIT_R4      = 16 # Variable c_int
VTBIT_R8      = 32 # Variable c_int
VTBIT_CY      = 64 # Variable c_int
VTBIT_DECIMAL = 16384 # Variable c_int
VTBIT_I1      = 65536 # Variable c_int
VTBIT_UI1     = 131072 # Variable c_int
VTBIT_UI2     = 262144 # Variable c_int
VTBIT_UI4     = 524288 # Variable c_int

VT_EMPTY           = 0
VT_NULL            = 1
VT_I2              = 2
VT_I4              = 3
VT_R4              = 4
VT_R8              = 5
VT_CY              = 6
VT_DATE            = 7
VT_BSTR            = 8
VT_DISPATCH        = 9
VT_ERROR           = 10
VT_BOOL            = 11
VT_VARIANT         = 12
VT_UNKNOWN         = 13
VT_DECIMAL         = 14
VT_I1              = 16
VT_UI1             = 17
VT_UI2             = 18
VT_UI4             = 19
VT_I8              = 20
VT_UI8             = 21
VT_INT             = 22
VT_UINT            = 23
VT_VOID            = 24
VT_HRESULT         = 25
VT_PTR             = 26
VT_SAFEARRAY       = 27
VT_CARRAY          = 28
VT_USERDEFINED     = 29
VT_LPSTR           = 30
VT_LPWSTR          = 31
VT_RECORD          = 36
VT_FILETIME        = 64
VT_BLOB            = 65
VT_STREAM          = 66
VT_STORAGE         = 67
VT_STREAMED_OBJECT = 68
VT_STORED_OBJECT   = 69
VT_BLOB_OBJECT     = 70
VT_CF              = 71
VT_CLSID           = 72
VT_BSTR_BLOB       = 4095
VT_ILLEGALMASKED   = 4095
VT_TYPEMASK        = 4095
VT_VECTOR          = 4096
VT_ARRAY           = 8192
VT_BYREF           = 16384
VT_RESERVED        = 32768
VT_ILLEGAL         = 65535

WAIT_OBJECT_0    = win32con.WAIT_OBJECT_0 # 0
WAIT_ABANDONED_0 = win32con.WAIT_ABANDONED_0 # 128
WAIT_ABANDONED   = win32con.WAIT_ABANDONED # 128
WAIT_TIMEOUT     = win32con.WAIT_TIMEOUT # 258
WAIT_FAILED      = win32con.WAIT_FAILED # -1

WAVECAPS_PITCH          = 1 # Variable c_int
WAVECAPS_PLAYBACKRATE   = 2 # Variable c_int
WAVECAPS_VOLUME         = 4 # Variable c_int
WAVECAPS_LRVOLUME       = 8 # Variable c_int
WAVECAPS_SYNC           = 16 # Variable c_int
WAVECAPS_SAMPLEACCURATE = 32 # Variable c_int
WAVECAPS_DIRECTSOUND    = 64 # Variable c_int

WAVERR_BASE         = 32 # Variable c_int
WAVERR_BADFORMAT    = 32 # Variable c_int
WAVERR_STILLPLAYING = 33 # Variable c_int
WAVERR_UNPREPARED   = 34 # Variable c_int
WAVERR_SYNC         = 35 # Variable c_int
WAVERR_LASTERROR    = 35 # Variable c_int

WAVE_INVALIDFORMAT       = 0 # Variable c_int
WAVE_FORMAT_PCM          = 1 # Variable c_int
WAVE_FORMAT_QUERY        = 1 # Variable c_int
WAVE_FORMAT_1M08         = 1 # Variable c_int
WAVE_ALLOWSYNC           = 2 # Variable c_int
WAVE_FORMAT_1S08         = 2 # Variable c_int
WAVE_FORMAT_1M16         = 4 # Variable c_int
WAVE_MAPPED              = 4 # Variable c_int
WAVE_FORMAT_1S16         = 8 # Variable c_int
WAVE_FORMAT_DIRECT       = 8 # Variable c_int
WAVE_FORMAT_DIRECT_QUERY = 9 # Variable c_int
WAVE_FORMAT_2M08         = 16 # Variable c_int
WAVE_FORMAT_2S08         = 32 # Variable c_int
WAVE_FORMAT_2M16         = 64 # Variable c_int
WAVE_FORMAT_2S16         = 128 # Variable c_int
WAVE_FORMAT_4M08         = 256 # Variable c_int
WAVE_FORMAT_4S08         = 512 # Variable c_int
WAVE_FORMAT_4M16         = 1024 # Variable c_int
WAVE_FORMAT_4S16         = 2048 # Variable c_int
WAVE_MAPPER              = 4294967295 # Variable c_uint

WA_INACTIVE    = win32con.WA_INACTIVE # 0
WA_ACTIVE      = win32con.WA_ACTIVE # 1
WA_CLICKACTIVE = win32con.WA_CLICKACTIVE # 2

WB_LEFT        = win32con.WB_LEFT # 0
WB_RIGHT       = win32con.WB_RIGHT # 1
WB_ISDELIMITER = win32con.WB_ISDELIMITER # 2

WC_DISCARDNS      = 16 # Variable c_int
WC_SEPCHARS       = 32 # Variable c_int
WC_DEFAULTCHAR    = 64 # Variable c_int
WC_COMPOSITECHECK = 512 # Variable c_int
WC_DIALOG         = 206704 # Variable POINTER(c_wchar)
WC_COMBOBOXEXA    = 'ComboBoxEx32' # Variable POINTER(c_char)
WC_COMBOBOXEXW    = 'ComboBoxEx32' # Variable POINTER(c_wchar)
WC_NATIVEFONTCTLA = 'NativeFontCtl' # Variable POINTER(c_char)
WC_NATIVEFONTCTLW = 'NativeFontCtl' # Variable POINTER(c_wchar)
WC_HEADERA        = 'SysHeader32' # Variable POINTER(c_char)
WC_HEADERW        = 'SysHeader32' # Variable POINTER(c_wchar)
WC_IPADDRESSA     = 'SysIPAddress32' # Variable POINTER(c_char)
WC_IPADDRESSW     = 'SysIPAddress32' # Variable POINTER(c_wchar)
WC_LISTVIEWA      = 'SysListView32' # Variable POINTER(c_char)
WC_LISTVIEWW      = 'SysListView32' # Variable POINTER(c_wchar)
WC_PAGESCROLLERA  = 'SysPager' # Variable POINTER(c_char)
WC_PAGESCROLLERW  = 'SysPager' # Variable POINTER(c_wchar)
WC_TABCONTROLA    = 'SysTabControl32' # Variable POINTER(c_char)
WC_TABCONTROLW    = 'SysTabControl32' # Variable POINTER(c_wchar)
WC_TREEVIEWA      = 'SysTreeView32' # Variable POINTER(c_char)
WC_TREEVIEWW      = 'SysTreeView32' # Variable POINTER(c_wchar)

WDT_INPROC_CALL = 1215587415 # Variable c_int
WDT_REMOTE_CALL = 1383359575 # Variable c_int

WGL_FONT_LINES      = 0 # Variable c_int
WGL_FONT_POLYGONS   = 1 # Variable c_int
WGL_SWAP_MAIN_PLANE = 1 # Variable c_int
WGL_SWAP_OVERLAY1   = 2 # Variable c_int
WGL_SWAP_OVERLAY2   = 4 # Variable c_int
WGL_SWAP_OVERLAY3   = 8 # Variable c_int
WGL_SWAP_OVERLAY4   = 16 # Variable c_int
WGL_SWAP_OVERLAY5   = 32 # Variable c_int
WGL_SWAP_OVERLAY6   = 64 # Variable c_int
WGL_SWAP_OVERLAY7   = 128 # Variable c_int
WGL_SWAP_OVERLAY8   = 256 # Variable c_int
WGL_SWAP_OVERLAY9   = 512 # Variable c_int
WGL_SWAP_OVERLAY10  = 1024 # Variable c_int
WGL_SWAP_OVERLAY11  = 2048 # Variable c_int
WGL_SWAP_OVERLAY12  = 4096 # Variable c_int
WGL_SWAP_OVERLAY13  = 8192 # Variable c_int
WGL_SWAP_OVERLAY14  = 16384 # Variable c_int
WGL_SWAP_OVERLAY15  = 32768 # Variable c_int
WGL_SWAP_UNDERLAY1  = 65536 # Variable c_int
WGL_SWAP_UNDERLAY2  = 131072 # Variable c_int
WGL_SWAP_UNDERLAY3  = 262144 # Variable c_int
WGL_SWAP_UNDERLAY4  = 524288 # Variable c_int
WGL_SWAP_UNDERLAY5  = 1048576 # Variable c_int
WGL_SWAP_UNDERLAY6  = 2097152 # Variable c_int
WGL_SWAP_UNDERLAY7  = 4194304 # Variable c_int
WGL_SWAP_UNDERLAY8  = 8388608 # Variable c_int
WGL_SWAP_UNDERLAY9  = 16777216 # Variable c_int
WGL_SWAP_UNDERLAY10 = 33554432 # Variable c_int
WGL_SWAP_UNDERLAY11 = 67108864 # Variable c_int
WGL_SWAP_UNDERLAY12 = 134217728 # Variable c_int
WGL_SWAP_UNDERLAY13 = 268435456 # Variable c_int
WGL_SWAP_UNDERLAY14 = 536870912 # Variable c_int
WGL_SWAP_UNDERLAY15 = 1073741824 # Variable c_int

WHDR_DONE      = 1 # Variable c_int
WHDR_PREPARED  = 2 # Variable c_int
WHDR_BEGINLOOP = 4 # Variable c_int
WHDR_ENDLOOP   = 8 # Variable c_int
WHDR_INQUEUE   = 16 # Variable c_int

WHITE_BRUSH = win32con.WHITE_BRUSH # 0
WHITE_PEN   = win32con.WHITE_PEN # 6

WH_JOURNALRECORD   = win32con.WH_JOURNALRECORD # 0
WH_JOURNALPLAYBACK = win32con.WH_JOURNALPLAYBACK # 1
WH_KEYBOARD        = win32con.WH_KEYBOARD # 2
WH_GETMESSAGE      = win32con.WH_GETMESSAGE # 3
WH_CALLWNDPROC     = win32con.WH_CALLWNDPROC # 4
WH_CBT             = win32con.WH_CBT # 5
WH_SYSMSGFILTER    = win32con.WH_SYSMSGFILTER # 6
WH_MOUSE           = win32con.WH_MOUSE # 7
WH_HARDWARE        = win32con.WH_HARDWARE # 8
WH_DEBUG           = win32con.WH_DEBUG # 9
WH_SHELL           = win32con.WH_SHELL # 10
WH_FOREGROUNDIDLE  = win32con.WH_FOREGROUNDIDLE # 11
WH_CALLWNDPROCRET  = win32con.WH_CALLWNDPROCRET # 12
WH_MAX             = win32con.WH_MAX # 14
WH_MIN             = win32con.WH_MIN # -1
WH_MSGFILTER       = win32con.WH_MSGFILTER # -1

WINDOW_BUFFER_SIZE_EVENT = 4 # Variable c_int

WININETINFO_OPTION_LOCK_HANDLE = 65534 # Variable c_int

WINSTA_ENUMDESKTOPS      = win32con.WINSTA_ENUMDESKTOPS # 1
WINSTA_READATTRIBUTES    = win32con.WINSTA_READATTRIBUTES # 2
WINSTA_ACCESSCLIPBOARD   = win32con.WINSTA_ACCESSCLIPBOARD # 4
WINSTA_CREATEDESKTOP     = win32con.WINSTA_CREATEDESKTOP # 8
WINSTA_WRITEATTRIBUTES   = win32con.WINSTA_WRITEATTRIBUTES # 16
WINSTA_ACCESSGLOBALATOMS = win32con.WINSTA_ACCESSGLOBALATOMS # 32
WINSTA_EXITWINDOWS       = win32con.WINSTA_EXITWINDOWS # 64
WINSTA_ENUMERATE         = win32con.WINSTA_ENUMERATE # 256
WINSTA_READSCREEN        = win32con.WINSTA_READSCREEN # 512

WIN_CERT_TYPE_X509             = 1 # Variable c_int
WIN_CERT_TYPE_PKCS_SIGNED_DATA = 2 # Variable c_int
WIN_CERT_TYPE_RESERVED_1       = 3 # Variable c_int
WIN_CERT_REVISION_1_0          = 256 # Variable c_int
WIN_CERT_REVISION_2_0          = 512 # Variable c_int

WIZ_CXBMP  = 80 # Variable c_int
WIZ_BODYX  = 92 # Variable c_int
WIZ_CYDLG  = 140 # Variable c_int
WIZ_BODYCX = 184 # Variable c_int
WIZ_CXDLG  = 276 # Variable c_int

WMSZ_LEFT        = win32con.WMSZ_LEFT # 1
WMSZ_RIGHT       = win32con.WMSZ_RIGHT # 2
WMSZ_TOP         = win32con.WMSZ_TOP # 3
WMSZ_TOPLEFT     = win32con.WMSZ_TOPLEFT # 4
WMSZ_TOPRIGHT    = win32con.WMSZ_TOPRIGHT # 5
WMSZ_BOTTOM      = win32con.WMSZ_BOTTOM # 6
WMSZ_BOTTOMLEFT  = win32con.WMSZ_BOTTOMLEFT # 7
WMSZ_BOTTOMRIGHT = win32con.WMSZ_BOTTOMRIGHT # 8

WM_NULL                   = win32con.WM_NULL # 0
WM_CREATE                 = win32con.WM_CREATE # 1
WM_DESTROY                = win32con.WM_DESTROY # 2
WM_MOVE                   = win32con.WM_MOVE # 3
WM_SIZE                   = win32con.WM_SIZE # 5
WM_ACTIVATE               = win32con.WM_ACTIVATE # 6
WM_SETFOCUS               = win32con.WM_SETFOCUS # 7
WM_KILLFOCUS              = win32con.WM_KILLFOCUS # 8
WM_ENABLE                 = win32con.WM_ENABLE # 10
WM_SETREDRAW              = win32con.WM_SETREDRAW # 11
WM_SETTEXT                = win32con.WM_SETTEXT # 12
WM_GETTEXT                = win32con.WM_GETTEXT # 13
WM_GETTEXTLENGTH          = win32con.WM_GETTEXTLENGTH # 14
WM_PAINT                  = win32con.WM_PAINT # 15
WM_CLOSE                  = win32con.WM_CLOSE # 16
WM_QUERYENDSESSION        = win32con.WM_QUERYENDSESSION # 17
WM_QUIT                   = win32con.WM_QUIT # 18
WM_QUERYOPEN              = win32con.WM_QUERYOPEN # 19
WM_ERASEBKGND             = win32con.WM_ERASEBKGND # 20
WM_SYSCOLORCHANGE         = win32con.WM_SYSCOLORCHANGE # 21
WM_ENDSESSION             = win32con.WM_ENDSESSION # 22
WM_SHOWWINDOW             = win32con.WM_SHOWWINDOW # 24
WM_WININICHANGE           = win32con.WM_WININICHANGE # 26
WM_DEVMODECHANGE          = win32con.WM_DEVMODECHANGE # 27
WM_ACTIVATEAPP            = win32con.WM_ACTIVATEAPP # 28
WM_FONTCHANGE             = win32con.WM_FONTCHANGE # 29
WM_TIMECHANGE             = win32con.WM_TIMECHANGE # 30
WM_CANCELMODE             = win32con.WM_CANCELMODE # 31
WM_SETCURSOR              = win32con.WM_SETCURSOR # 32
WM_MOUSEACTIVATE          = win32con.WM_MOUSEACTIVATE # 33
WM_CHILDACTIVATE          = win32con.WM_CHILDACTIVATE # 34
WM_QUEUESYNC              = win32con.WM_QUEUESYNC # 35
WM_GETMINMAXINFO          = win32con.WM_GETMINMAXINFO # 36
WM_PAINTICON              = win32con.WM_PAINTICON # 38
WM_ICONERASEBKGND         = win32con.WM_ICONERASEBKGND # 39
WM_NEXTDLGCTL             = win32con.WM_NEXTDLGCTL # 40
WM_SPOOLERSTATUS          = win32con.WM_SPOOLERSTATUS # 42
WM_DRAWITEM               = win32con.WM_DRAWITEM # 43
WM_MEASUREITEM            = win32con.WM_MEASUREITEM # 44
WM_DELETEITEM             = win32con.WM_DELETEITEM # 45
WM_VKEYTOITEM             = win32con.WM_VKEYTOITEM # 46
WM_CHARTOITEM             = win32con.WM_CHARTOITEM # 47
WM_SETFONT                = win32con.WM_SETFONT # 48
WM_GETFONT                = win32con.WM_GETFONT # 49
WM_SETHOTKEY              = win32con.WM_SETHOTKEY # 50
WM_GETHOTKEY              = win32con.WM_GETHOTKEY # 51
WM_QUERYDRAGICON          = win32con.WM_QUERYDRAGICON # 55
WM_COMPAREITEM            = win32con.WM_COMPAREITEM # 57
WM_COMPACTING             = win32con.WM_COMPACTING # 65
WM_COMMNOTIFY             = win32con.WM_COMMNOTIFY # 68
WM_WINDOWPOSCHANGING      = win32con.WM_WINDOWPOSCHANGING # 70
WM_WINDOWPOSCHANGED       = win32con.WM_WINDOWPOSCHANGED # 71
WM_POWER                  = win32con.WM_POWER # 72
WM_COPYDATA               = win32con.WM_COPYDATA # 74
WM_CANCELJOURNAL          = win32con.WM_CANCELJOURNAL # 75
WM_NOTIFY                 = win32con.WM_NOTIFY # 78
WM_INPUTLANGCHANGEREQUEST = win32con.WM_INPUTLANGCHANGEREQUEST # 80
WM_INPUTLANGCHANGE        = win32con.WM_INPUTLANGCHANGE # 81
WM_TCARD                  = win32con.WM_TCARD # 82
WM_HELP                   = win32con.WM_HELP # 83
WM_USERCHANGED            = win32con.WM_USERCHANGED # 84
WM_NOTIFYFORMAT           = win32con.WM_NOTIFYFORMAT # 85
WM_CONTEXTMENU            = win32con.WM_CONTEXTMENU # 123
WM_STYLECHANGING          = win32con.WM_STYLECHANGING # 124
WM_STYLECHANGED           = win32con.WM_STYLECHANGED # 125
WM_DISPLAYCHANGE          = win32con.WM_DISPLAYCHANGE # 126
WM_GETICON                = win32con.WM_GETICON # 127
WM_SETICON                = win32con.WM_SETICON # 128
WM_NCCREATE               = win32con.WM_NCCREATE # 129
WM_NCDESTROY              = win32con.WM_NCDESTROY # 130
WM_NCCALCSIZE             = win32con.WM_NCCALCSIZE # 131
WM_NCHITTEST              = win32con.WM_NCHITTEST # 132
WM_NCPAINT                = win32con.WM_NCPAINT # 133
WM_NCACTIVATE             = win32con.WM_NCACTIVATE # 134
WM_GETDLGCODE             = win32con.WM_GETDLGCODE # 135
WM_SYNCPAINT              = win32con.WM_SYNCPAINT # 136
WM_NCMOUSEMOVE            = win32con.WM_NCMOUSEMOVE # 160
WM_NCLBUTTONDOWN          = win32con.WM_NCLBUTTONDOWN # 161
WM_NCLBUTTONUP            = win32con.WM_NCLBUTTONUP # 162
WM_NCLBUTTONDBLCLK        = win32con.WM_NCLBUTTONDBLCLK # 163
WM_NCRBUTTONDOWN          = win32con.WM_NCRBUTTONDOWN # 164
WM_NCRBUTTONUP            = win32con.WM_NCRBUTTONUP # 165
WM_NCRBUTTONDBLCLK        = win32con.WM_NCRBUTTONDBLCLK # 166
WM_NCMBUTTONDOWN          = win32con.WM_NCMBUTTONDOWN # 167
WM_NCMBUTTONUP            = win32con.WM_NCMBUTTONUP # 168
WM_NCMBUTTONDBLCLK        = win32con.WM_NCMBUTTONDBLCLK # 169
WM_KEYDOWN                = win32con.WM_KEYDOWN # 256
WM_KEYFIRST               = win32con.WM_KEYFIRST # 256
WM_KEYUP                  = win32con.WM_KEYUP # 257
WM_CHAR                   = win32con.WM_CHAR # 258
WM_DEADCHAR               = win32con.WM_DEADCHAR # 259
WM_SYSKEYDOWN             = win32con.WM_SYSKEYDOWN # 260
WM_SYSKEYUP               = win32con.WM_SYSKEYUP # 261
WM_SYSCHAR                = win32con.WM_SYSCHAR # 262
WM_SYSDEADCHAR            = win32con.WM_SYSDEADCHAR # 263
WM_KEYLAST                = win32con.WM_KEYLAST # 264
WM_IME_STARTCOMPOSITION   = win32con.WM_IME_STARTCOMPOSITION # 269
WM_IME_ENDCOMPOSITION     = win32con.WM_IME_ENDCOMPOSITION # 270
WM_IME_KEYLAST            = win32con.WM_IME_KEYLAST # 271
WM_IME_COMPOSITION        = win32con.WM_IME_COMPOSITION # 271
WM_INITDIALOG             = win32con.WM_INITDIALOG # 272
WM_COMMAND                = win32con.WM_COMMAND # 273
WM_SYSCOMMAND             = win32con.WM_SYSCOMMAND # 274
WM_TIMER                  = win32con.WM_TIMER # 275
WM_HSCROLL                = win32con.WM_HSCROLL # 276
WM_VSCROLL                = win32con.WM_VSCROLL # 277
WM_INITMENU               = win32con.WM_INITMENU # 278
WM_INITMENUPOPUP          = win32con.WM_INITMENUPOPUP # 279
WM_MENUSELECT             = win32con.WM_MENUSELECT # 287
WM_MENUCHAR               = win32con.WM_MENUCHAR # 288
WM_ENTERIDLE              = win32con.WM_ENTERIDLE # 289
WM_MENUCOMMAND            = win32con.WM_MENUCOMMAND # 294
WM_CTLCOLORMSGBOX         = win32con.WM_CTLCOLORMSGBOX # 306
WM_CTLCOLOREDIT           = win32con.WM_CTLCOLOREDIT # 307
WM_CTLCOLORLISTBOX        = win32con.WM_CTLCOLORLISTBOX # 308
WM_CTLCOLORBTN            = win32con.WM_CTLCOLORBTN # 309
WM_CTLCOLORDLG            = win32con.WM_CTLCOLORDLG # 310
WM_CTLCOLORSCROLLBAR      = win32con.WM_CTLCOLORSCROLLBAR # 311
WM_CTLCOLORSTATIC         = win32con.WM_CTLCOLORSTATIC # 312
WM_MOUSEMOVE              = win32con.WM_MOUSEMOVE # 512
WM_MOUSEFIRST             = win32con.WM_MOUSEFIRST # 512
WM_LBUTTONDOWN            = win32con.WM_LBUTTONDOWN # 513
WM_LBUTTONUP              = win32con.WM_LBUTTONUP # 514
WM_LBUTTONDBLCLK          = win32con.WM_LBUTTONDBLCLK # 515
WM_RBUTTONDOWN            = win32con.WM_RBUTTONDOWN # 516
WM_RBUTTONUP              = win32con.WM_RBUTTONUP # 517
WM_RBUTTONDBLCLK          = win32con.WM_RBUTTONDBLCLK # 518
WM_MBUTTONDOWN            = win32con.WM_MBUTTONDOWN # 519
WM_MBUTTONUP              = win32con.WM_MBUTTONUP # 520
WM_MBUTTONDBLCLK          = win32con.WM_MBUTTONDBLCLK # 521
WM_MOUSELAST              = win32con.WM_MOUSELAST # 522
WM_MOUSEWHEEL             = win32con.WM_MOUSEWHEEL # 522
WM_PARENTNOTIFY           = win32con.WM_PARENTNOTIFY # 528
WM_ENTERMENULOOP          = win32con.WM_ENTERMENULOOP # 529
WM_EXITMENULOOP           = win32con.WM_EXITMENULOOP # 530
WM_NEXTMENU               = win32con.WM_NEXTMENU # 531
WM_SIZING                 = win32con.WM_SIZING # 532
WM_CAPTURECHANGED         = win32con.WM_CAPTURECHANGED # 533
WM_MOVING                 = win32con.WM_MOVING # 534
WM_POWERBROADCAST         = win32con.WM_POWERBROADCAST # 536
WM_DEVICECHANGE           = win32con.WM_DEVICECHANGE # 537
WM_MDICREATE              = win32con.WM_MDICREATE # 544
WM_MDIDESTROY             = win32con.WM_MDIDESTROY # 545
WM_MDIACTIVATE            = win32con.WM_MDIACTIVATE # 546
WM_MDIRESTORE             = win32con.WM_MDIRESTORE # 547
WM_MDINEXT                = win32con.WM_MDINEXT # 548
WM_MDIMAXIMIZE            = win32con.WM_MDIMAXIMIZE # 549
WM_MDITILE                = win32con.WM_MDITILE # 550
WM_MDICASCADE             = win32con.WM_MDICASCADE # 551
WM_MDIICONARRANGE         = win32con.WM_MDIICONARRANGE # 552
WM_MDIGETACTIVE           = win32con.WM_MDIGETACTIVE # 553
WM_MDISETMENU             = win32con.WM_MDISETMENU # 560
WM_ENTERSIZEMOVE          = win32con.WM_ENTERSIZEMOVE # 561
WM_EXITSIZEMOVE           = win32con.WM_EXITSIZEMOVE # 562
WM_DROPFILES              = win32con.WM_DROPFILES # 563
WM_MDIREFRESHMENU         = win32con.WM_MDIREFRESHMENU # 564
WM_IME_SETCONTEXT         = win32con.WM_IME_SETCONTEXT # 641
WM_IME_NOTIFY             = win32con.WM_IME_NOTIFY # 642
WM_IME_CONTROL            = win32con.WM_IME_CONTROL # 643
WM_IME_COMPOSITIONFULL    = win32con.WM_IME_COMPOSITIONFULL # 644
WM_IME_SELECT             = win32con.WM_IME_SELECT # 645
WM_IME_CHAR               = win32con.WM_IME_CHAR # 646
WM_IME_KEYDOWN            = win32con.WM_IME_KEYDOWN # 656
WM_IME_KEYUP              = win32con.WM_IME_KEYUP # 657
WM_MOUSEHOVER             = win32con.WM_MOUSEHOVER # 673
WM_MOUSELEAVE             = win32con.WM_MOUSELEAVE # 675
WM_CUT                    = win32con.WM_CUT # 768
WM_COPY                   = win32con.WM_COPY # 769
WM_PASTE                  = win32con.WM_PASTE # 770
WM_CLEAR                  = win32con.WM_CLEAR # 771
WM_UNDO                   = win32con.WM_UNDO # 772
WM_RENDERFORMAT           = win32con.WM_RENDERFORMAT # 773
WM_RENDERALLFORMATS       = win32con.WM_RENDERALLFORMATS # 774
WM_DESTROYCLIPBOARD       = win32con.WM_DESTROYCLIPBOARD # 775
WM_DRAWCLIPBOARD          = win32con.WM_DRAWCLIPBOARD # 776
WM_PAINTCLIPBOARD         = win32con.WM_PAINTCLIPBOARD # 777
WM_VSCROLLCLIPBOARD       = win32con.WM_VSCROLLCLIPBOARD # 778
WM_SIZECLIPBOARD          = win32con.WM_SIZECLIPBOARD # 779
WM_ASKCBFORMATNAME        = win32con.WM_ASKCBFORMATNAME # 780
WM_CHANGECBCHAIN          = win32con.WM_CHANGECBCHAIN # 781
WM_HSCROLLCLIPBOARD       = win32con.WM_HSCROLLCLIPBOARD # 782
WM_QUERYNEWPALETTE        = win32con.WM_QUERYNEWPALETTE # 783
WM_PALETTEISCHANGING      = win32con.WM_PALETTEISCHANGING # 784
WM_PALETTECHANGED         = win32con.WM_PALETTECHANGED # 785
WM_HOTKEY                 = win32con.WM_HOTKEY # 786
WM_PRINT                  = win32con.WM_PRINT # 791
WM_PRINTCLIENT            = win32con.WM_PRINTCLIENT # 792
WM_HANDHELDFIRST          = win32con.WM_HANDHELDFIRST # 856
WM_HANDHELDLAST           = win32con.WM_HANDHELDLAST # 863
WM_AFXFIRST               = win32con.WM_AFXFIRST # 864
WM_AFXLAST                = win32con.WM_AFXLAST # 895
WM_PENWINFIRST            = win32con.WM_PENWINFIRST # 896
WM_PENWINLAST             = win32con.WM_PENWINLAST # 911
WM_DDE_INITIATE           = 992  # Variable c_int
WM_DDE_FIRST              = 992  # Variable c_int
WM_DDE_TERMINATE          = 993  # Variable c_int
WM_DDE_ADVISE             = 994  # Variable c_int
WM_DDE_UNADVISE           = 995  # Variable c_int
WM_DDE_ACK                = 996  # Variable c_int
WM_DDE_DATA               = 997  # Variable c_int
WM_DDE_REQUEST            = 998  # Variable c_int
WM_DDE_POKE               = 999  # Variable c_int
WM_DDE_EXECUTE            = 1000  # Variable c_int
WM_DDE_LAST               = 1000  # Variable c_int
WM_PSD_PAGESETUPDLG       = win32con.WM_PSD_PAGESETUPDLG # 1024
WM_USER                   = win32con.WM_USER # 1024
WM_CHOOSEFONT_GETLOGFONT  = win32con.WM_CHOOSEFONT_GETLOGFONT # 1025
WM_PSD_FULLPAGERECT       = win32con.WM_PSD_FULLPAGERECT # 1025
WM_PSD_MINMARGINRECT      = win32con.WM_PSD_MINMARGINRECT # 1026
WM_PSD_MARGINRECT         = win32con.WM_PSD_MARGINRECT # 1027
WM_PSD_GREEKTEXTRECT      = win32con.WM_PSD_GREEKTEXTRECT # 1028
WM_PSD_ENVSTAMPRECT       = win32con.WM_PSD_ENVSTAMPRECT # 1029
WM_PSD_YAFULLPAGERECT     = win32con.WM_PSD_YAFULLPAGERECT # 1030
WM_CHOOSEFONT_SETLOGFONT  = win32con.WM_CHOOSEFONT_SETLOGFONT # 1125
WM_CHOOSEFONT_SETFLAGS    = win32con.WM_CHOOSEFONT_SETFLAGS # 1126
WM_APP                    = win32con.WM_APP # 32768

WNCON_FORNETCARD = 1 # Variable c_int
WNCON_NOTROUTED  = 2 # Variable c_int
WNCON_SLOWLINK   = 4 # Variable c_int
WNCON_DYNAMIC    = 8 # Variable c_int

WNFMT_MULTILINE   = 1 # Variable c_int
WNFMT_ABBREVIATED = 2 # Variable c_int
WNFMT_INENUM      = 16 # Variable c_int
WNFMT_CONNECTION  = 32 # Variable c_int

WNNC_NET_MSNET      = 65536 # Variable c_int
WNNC_NET_LANMAN     = 131072 # Variable c_int
WNNC_NET_NETWARE    = 196608 # Variable c_int
WNNC_NET_VINES      = 262144 # Variable c_int
WNNC_NET_10NET      = 327680 # Variable c_int
WNNC_NET_LOCUS      = 393216 # Variable c_int
WNNC_NET_SUN_PC_NFS = 458752 # Variable c_int
WNNC_NET_LANSTEP    = 524288 # Variable c_int
WNNC_NET_9TILES     = 589824 # Variable c_int
WNNC_NET_LANTASTIC  = 655360 # Variable c_int
WNNC_NET_AS400      = 720896 # Variable c_int
WNNC_NET_FTP_NFS    = 786432 # Variable c_int
WNNC_NET_PATHWORKS  = 851968 # Variable c_int
WNNC_NET_LIFENET    = 917504 # Variable c_int
WNNC_NET_POWERLAN   = 983040 # Variable c_int
WNNC_NET_BWNFS      = 1048576 # Variable c_int
WNNC_NET_COGENT     = 1114112 # Variable c_int
WNNC_NET_FARALLON   = 1179648 # Variable c_int
WNNC_NET_APPLETALK  = 1245184 # Variable c_int
WNNC_NET_INTERGRAPH = 1310720 # Variable c_int
WNNC_NET_SYMFONET   = 1376256 # Variable c_int
WNNC_NET_CLEARCASE  = 1441792 # Variable c_int
WNNC_NET_FRONTIER   = 1507328 # Variable c_int
WNNC_NET_BMC        = 1572864 # Variable c_int
WNNC_NET_DCE        = 1638400 # Variable c_int
WNNC_NET_DECORB     = 2097152 # Variable c_int
WNNC_NET_PROTSTOR   = 2162688 # Variable c_int
WNNC_NET_FJ_REDIR   = 2228224 # Variable c_int
WNNC_NET_DISTINCT   = 2293760 # Variable c_int
WNNC_NET_TWINS      = 2359296 # Variable c_int
WNNC_NET_RDR2SAMPLE = 2424832 # Variable c_int

WPF_SETMINPOSITION     = win32con.WPF_SETMINPOSITION # 1
WPF_RESTORETOMAXIMIZED = win32con.WPF_RESTORETOMAXIMIZED # 2

WRITE_DAC   = win32con.WRITE_DAC # 262144
WRITE_OWNER = win32con.WRITE_OWNER # 524288

WSADESCRIPTION_LEN = 256 # Variable c_int

WSAHOST_NOT_FOUND = 11001 # Variable c_int

WSANO_RECOVERY = 11003 # Variable c_int
WSANO_DATA     = 11004 # Variable c_int

WSASYS_STATUS_LEN = 128 # Variable c_int

WSATRY_AGAIN = 11002 # Variable c_int

WSB_PROP_CYVSCROLL = 1 # Variable c_long
WSB_PROP_CXHSCROLL = 2 # Variable c_long
WSB_PROP_CYHSCROLL = 4 # Variable c_long
WSB_PROP_CXVSCROLL = 8 # Variable c_long
WSB_PROP_CXHTHUMB  = 16 # Variable c_long
WSB_PROP_CYVTHUMB  = 32 # Variable c_long
WSB_PROP_VBKGCOLOR = 64 # Variable c_long
WSB_PROP_HBKGCOLOR = 128 # Variable c_long
WSB_PROP_VSTYLE    = 256 # Variable c_long
WSB_PROP_HSTYLE    = 512 # Variable c_long
WSB_PROP_WINSTYLE  = 1024 # Variable c_long
WSB_PROP_PALETTE   = 2048 # Variable c_long
WSB_PROP_MASK      = 4095 # Variable c_long

WSF_VISIBLE = win32con.WSF_VISIBLE # 1

WS_EX_LTRREADING       = win32con.WS_EX_LTRREADING # 0
WS_EX_RIGHTSCROLLBAR   = win32con.WS_EX_RIGHTSCROLLBAR # 0
WS_OVERLAPPED          = win32con.WS_OVERLAPPED # 0
WS_EX_LEFT             = win32con.WS_EX_LEFT # 0
WS_EX_DLGMODALFRAME    = win32con.WS_EX_DLGMODALFRAME # 1
WS_EX_NOPARENTNOTIFY   = win32con.WS_EX_NOPARENTNOTIFY # 4
WS_EX_TOPMOST          = win32con.WS_EX_TOPMOST # 8
WS_EX_ACCEPTFILES      = win32con.WS_EX_ACCEPTFILES # 16
WS_EX_TRANSPARENT      = win32con.WS_EX_TRANSPARENT # 32
WS_EX_MDICHILD         = win32con.WS_EX_MDICHILD # 64
WS_EX_TOOLWINDOW       = win32con.WS_EX_TOOLWINDOW # 128
WS_EX_WINDOWEDGE       = win32con.WS_EX_WINDOWEDGE # 256
WS_EX_PALETTEWINDOW    = win32con.WS_EX_PALETTEWINDOW # 392
WS_EX_CLIENTEDGE       = win32con.WS_EX_CLIENTEDGE # 512
WS_EX_OVERLAPPEDWINDOW = win32con.WS_EX_OVERLAPPEDWINDOW # 768
WS_EX_CONTEXTHELP      = win32con.WS_EX_CONTEXTHELP # 1024
WS_EX_RIGHT            = win32con.WS_EX_RIGHT # 4096
WS_EX_RTLREADING       = win32con.WS_EX_RTLREADING # 8192
WS_EX_LEFTSCROLLBAR    = win32con.WS_EX_LEFTSCROLLBAR # 16384
WS_EX_CONTROLPARENT    = win32con.WS_EX_CONTROLPARENT # 65536
WS_TABSTOP             = win32con.WS_TABSTOP # 65536
WS_MAXIMIZEBOX         = win32con.WS_MAXIMIZEBOX # 65536
WS_GROUP               = win32con.WS_GROUP # 131072
WS_MINIMIZEBOX         = win32con.WS_MINIMIZEBOX # 131072
WS_EX_STATICEDGE       = win32con.WS_EX_STATICEDGE # 131072
WS_EX_APPWINDOW        = win32con.WS_EX_APPWINDOW # 262144
WS_THICKFRAME          = win32con.WS_THICKFRAME # 262144
WS_SYSMENU             = win32con.WS_SYSMENU # 524288
WS_HSCROLL             = win32con.WS_HSCROLL # 1048576
WS_VSCROLL             = win32con.WS_VSCROLL # 2097152
WS_DLGFRAME            = win32con.WS_DLGFRAME # 4194304
WS_BORDER              = win32con.WS_BORDER # 8388608
WS_CAPTION             = win32con.WS_CAPTION # 12582912
WS_OVERLAPPEDWINDOW    = win32con.WS_OVERLAPPEDWINDOW # 13565952
WS_MAXIMIZE            = win32con.WS_MAXIMIZE # 16777216
WS_CLIPCHILDREN        = win32con.WS_CLIPCHILDREN # 33554432
WS_CLIPSIBLINGS        = win32con.WS_CLIPSIBLINGS # 67108864
WS_DISABLED            = win32con.WS_DISABLED # 134217728
WS_VISIBLE             = win32con.WS_VISIBLE # 268435456
WS_MINIMIZE            = win32con.WS_MINIMIZE # 536870912
WS_CHILDWINDOW         = win32con.WS_CHILDWINDOW # 1073741824
WS_CHILD               = win32con.WS_CHILD # 1073741824
WS_POPUP               = win32con.WS_POPUP # -2147483648
WS_POPUPWINDOW         = win32con.WS_POPUPWINDOW # -2138570752

WT_EXECUTEDEFAULT      = 0 # Variable c_int
WT_EXECUTEINIOTHREAD   = 1 # Variable c_int
WT_EXECUTEINUITHREAD   = 2 # Variable c_int
WT_EXECUTEINWAITTHREAD = 4 # Variable c_int
WT_EXECUTEDELETEWAIT   = 8 # Variable c_int
WT_EXECUTEINLONGTHREAD = 16 # Variable c_int

WVR_ALIGNTOP    = win32con.WVR_ALIGNTOP # 16
WVR_ALIGNLEFT   = win32con.WVR_ALIGNLEFT # 32
WVR_ALIGNBOTTOM = win32con.WVR_ALIGNBOTTOM # 64
WVR_ALIGNRIGHT  = win32con.WVR_ALIGNRIGHT # 128
WVR_HREDRAW     = win32con.WVR_HREDRAW # 256
WVR_VREDRAW     = win32con.WVR_VREDRAW # 512
WVR_REDRAW      = win32con.WVR_REDRAW # 768
WVR_VALIDRECTS  = win32con.WVR_VALIDRECTS # 1024

XCLASS_BOOL         = 4096 # Variable c_int
XCLASS_DATA         = 8192 # Variable c_int
XCLASS_FLAGS        = 16384 # Variable c_int
XCLASS_NOTIFICATION = 32768 # Variable c_int
XCLASS_MASK         = 64512 # Variable c_int

XLAT_SERVER = 1
XLAT_CLIENT = 2
XLAT_SIDE   = c_int # enum

XMLELEMTYPE_ELEMENT  = 0
XMLELEMTYPE_TEXT     = 1
XMLELEMTYPE_COMMENT  = 2
XMLELEMTYPE_DOCUMENT = 3
XMLELEMTYPE_DTD      = 4
XMLELEMTYPE_PI       = 5
XMLELEMTYPE_OTHER    = 6

XST_NULL           = 0 # Variable c_int
XST_INCOMPLETE     = 1 # Variable c_int
XST_CONNECTED      = 2 # Variable c_int
XST_INIT1          = 3 # Variable c_int
XST_INIT2          = 4 # Variable c_int
XST_REQSENT        = 5 # Variable c_int
XST_DATARCVD       = 6 # Variable c_int
XST_POKESENT       = 7 # Variable c_int
XST_POKEACKRCVD    = 8 # Variable c_int
XST_EXECSENT       = 9 # Variable c_int
XST_EXECACKRCVD    = 10 # Variable c_int
XST_ADVSENT        = 11 # Variable c_int
XST_UNADVSENT      = 12 # Variable c_int
XST_ADVACKRCVD     = 13 # Variable c_int
XST_UNADVACKRCVD   = 14 # Variable c_int
XST_ADVDATASENT    = 15 # Variable c_int
XST_ADVDATAACKRCVD = 16 # Variable c_int

XTYPF_NOBLOCK = 2 # Variable c_int
XTYPF_NODATA  = 4 # Variable c_int
XTYPF_ACKREQ  = 8 # Variable c_int

XTYP_SHIFT           = 4 # Variable c_int
XTYP_MASK            = 240 # Variable c_int
XTYP_ADVSTART        = 4144 # Variable c_int
XTYP_CONNECT         = 4194 # Variable c_int
XTYP_ADVREQ          = 8226 # Variable c_int
XTYP_REQUEST         = 8368 # Variable c_int
XTYP_WILDCONNECT     = 8418 # Variable c_int
XTYP_ADVDATA         = 16400 # Variable c_int
XTYP_EXECUTE         = 16464 # Variable c_int
XTYP_POKE            = 16528 # Variable c_int
XTYP_ERROR           = 32770 # Variable c_int
XTYP_ADVSTOP         = 32832 # Variable c_int
XTYP_CONNECT_CONFIRM = 32882 # Variable c_int
XTYP_XACT_COMPLETE   = 32896 # Variable c_int
XTYP_REGISTER        = 32930 # Variable c_int
XTYP_DISCONNECT      = 32962 # Variable c_int
XTYP_UNREGISTER      = 32978 # Variable c_int
XTYP_MONITOR         = 33010 # Variable c_int

ZAFLAGS_CUSTOM_EDIT            = 1
ZAFLAGS_ADD_SITES              = 2
ZAFLAGS_REQUIRE_VERIFICATION   = 4
ZAFLAGS_INCLUDE_PROXY_OVERRIDE = 8
ZAFLAGS_INCLUDE_INTRANET_SITES = 16
ZAFLAGS_NO_UI                  = 32
ZAFLAGS_SUPPORTS_VERIFICATION  = 64
ZAFLAGS_UNC_AS_INTRANET        = 128

_ACL_INFORMATION_CLASS = c_int # enum

_AUDIT_EVENT_TYPE = c_int # enum

_CM_ERROR_CONTROL_TYPE = c_int # enum
_CM_SERVICE_LOAD_TYPE  = c_int # enum
_CM_SERVICE_NODE_TYPE  = c_int # enum

_EXCEPTION_DISPOSITION = c_int # enum

_GET_FILEEX_INFO_LEVELS = c_int # enum

_MAX_DRIVE = 3 # Variable c_int
_MAX_DIR   = 256 # Variable c_int
_MAX_FNAME = 256 # Variable c_int
_MAX_EXT   = 256 # Variable c_int
_MAX_PATH  = 260 # Variable c_int

_OUT_TO_DEFAULT = 0 # Variable c_int
_OUT_TO_STDERR  = 1 # Variable c_int
_OUT_TO_MSGBOX  = 2 # Variable c_int

_REPORT_ERRMODE = 3 # Variable c_int

_RPC_ASYNC_EVENT        = c_int # enum
_RPC_NOTIFICATION_TYPES = c_int # enum

_SC_ACTION_TYPE = c_int # enum

_SECURITY_IMPERSONATION_LEVEL = c_int # enum

_SID_NAME_USE = c_int # enum

_TOKEN_INFORMATION_CLASS = c_int # enum
_TOKEN_TYPE              = c_int # enum

_WIN32_IE = 1024 # Variable c_int

__MIDL_IBindStatusCallback_0003      = c_int # enum
__MIDL_IBindStatusCallback_0001      = c_int # enum
__MIDL_IBindStatusCallback_0002      = c_int # enum
__MIDL_ICodeInstall_0001             = c_int # enum
__MIDL_IInternetZoneManager_0002     = c_int # enum
__MIDL_IInternetSecurityManager_0001 = c_int # enum
__MIDL_IInternetSecurityManager_0002 = c_int # enum
__MIDL_IBindStatusCallback_0004      = c_int # enum
__MIDL_IInternetZoneManager_0001     = c_int # enum

__REQUIRED_RPCNDR_H_VERSION__ = 440 # Variable c_int

__RPCNDR_H_VERSION__ = 450 # Variable c_int

_tagOIBDG_FLAGS = c_int # enum
_tagPARSEACTION = c_int # enum
_tagPI_FLAGS    = c_int # enum
_tagPSUACTION   = c_int # enum
_tagQUERYOPTION = c_int # enum

chx1  = 1040 # Variable c_int
chx2  = 1041 # Variable c_int
chx3  = 1042 # Variable c_int
chx4  = 1043 # Variable c_int
chx5  = 1044 # Variable c_int
chx6  = 1045 # Variable c_int
chx7  = 1046 # Variable c_int
chx8  = 1047 # Variable c_int
chx9  = 1048 # Variable c_int
chx10 = 1049 # Variable c_int
chx11 = 1050 # Variable c_int
chx12 = 1051 # Variable c_int
chx13 = 1052 # Variable c_int
chx14 = 1053 # Variable c_int
chx15 = 1054 # Variable c_int
chx16 = 1055 # Variable c_int

cmb1  = 1136 # Variable c_int
cmb2  = 1137 # Variable c_int
cmb3  = 1138 # Variable c_int
cmb4  = 1139 # Variable c_int
cmb5  = 1140 # Variable c_int
cmb6  = 1141 # Variable c_int
cmb7  = 1142 # Variable c_int
cmb8  = 1143 # Variable c_int
cmb9  = 1144 # Variable c_int
cmb10 = 1145 # Variable c_int
cmb11 = 1146 # Variable c_int
cmb12 = 1147 # Variable c_int
cmb13 = 1148 # Variable c_int
cmb14 = 1149 # Variable c_int
cmb15 = 1150 # Variable c_int
cmb16 = 1151 # Variable c_int

ctlFirst = 1024 # Variable c_int
ctlLast  = 1279 # Variable c_int

edt1  = 1152 # Variable c_int
edt2  = 1153 # Variable c_int
edt3  = 1154 # Variable c_int
edt4  = 1155 # Variable c_int
edt5  = 1156 # Variable c_int
edt6  = 1157 # Variable c_int
edt7  = 1158 # Variable c_int
edt8  = 1159 # Variable c_int
edt9  = 1160 # Variable c_int
edt10 = 1161 # Variable c_int
edt11 = 1162 # Variable c_int
edt12 = 1163 # Variable c_int
edt13 = 1164 # Variable c_int
edt14 = 1165 # Variable c_int
edt15 = 1166 # Variable c_int
edt16 = 1167 # Variable c_int

frm1 = 1076 # Variable c_int
frm2 = 1077 # Variable c_int
frm3 = 1078 # Variable c_int
frm4 = 1079 # Variable c_int

grp1 = 1072 # Variable c_int
grp2 = 1073 # Variable c_int
grp3 = 1074 # Variable c_int
grp4 = 1075 # Variable c_int

ico1 = 1084 # Variable c_int
ico2 = 1085 # Variable c_int
ico3 = 1086 # Variable c_int
ico4 = 1087 # Variable c_int

lst1  = 1120 # Variable c_int
lst2  = 1121 # Variable c_int
lst3  = 1122 # Variable c_int
lst4  = 1123 # Variable c_int
lst5  = 1124 # Variable c_int
lst6  = 1125 # Variable c_int
lst7  = 1126 # Variable c_int
lst8  = 1127 # Variable c_int
lst9  = 1128 # Variable c_int
lst10 = 1129 # Variable c_int
lst11 = 1130 # Variable c_int
lst12 = 1131 # Variable c_int
lst13 = 1132 # Variable c_int
lst14 = 1133 # Variable c_int
lst15 = 1134 # Variable c_int
lst16 = 1135 # Variable c_int

psh1  = 1024 # Variable c_int
psh2  = 1025 # Variable c_int
psh3  = 1026 # Variable c_int
psh4  = 1027 # Variable c_int
psh5  = 1028 # Variable c_int
psh6  = 1029 # Variable c_int
psh7  = 1030 # Variable c_int
psh8  = 1031 # Variable c_int
psh9  = 1032 # Variable c_int
psh10 = 1033 # Variable c_int
psh11 = 1034 # Variable c_int
psh12 = 1035 # Variable c_int
psh13 = 1036 # Variable c_int
psh14 = 1037 # Variable c_int
psh15 = 1038 # Variable c_int
psh16 = 1039 # Variable c_int

rad1  = 1056 # Variable c_int
rad2  = 1057 # Variable c_int
rad3  = 1058 # Variable c_int
rad4  = 1059 # Variable c_int
rad5  = 1060 # Variable c_int
rad6  = 1061 # Variable c_int
rad7  = 1062 # Variable c_int
rad8  = 1063 # Variable c_int
rad9  = 1064 # Variable c_int
rad10 = 1065 # Variable c_int
rad11 = 1066 # Variable c_int
rad12 = 1067 # Variable c_int
rad13 = 1068 # Variable c_int
rad14 = 1069 # Variable c_int
rad15 = 1070 # Variable c_int
rad16 = 1071 # Variable c_int

rct1 = 1080 # Variable c_int
rct2 = 1081 # Variable c_int
rct3 = 1082 # Variable c_int
rct4 = 1083 # Variable c_int

scr1 = 1168 # Variable c_int
scr2 = 1169 # Variable c_int
scr3 = 1170 # Variable c_int
scr4 = 1171 # Variable c_int
scr5 = 1172 # Variable c_int
scr6 = 1173 # Variable c_int
scr7 = 1174 # Variable c_int
scr8 = 1175 # Variable c_int

stc1  = 1088 # Variable c_int
stc2  = 1089 # Variable c_int
stc3  = 1090 # Variable c_int
stc4  = 1091 # Variable c_int
stc5  = 1092 # Variable c_int
stc6  = 1093 # Variable c_int
stc7  = 1094 # Variable c_int
stc8  = 1095 # Variable c_int
stc9  = 1096 # Variable c_int
stc10 = 1097 # Variable c_int
stc11 = 1098 # Variable c_int
stc12 = 1099 # Variable c_int
stc13 = 1100 # Variable c_int
stc14 = 1101 # Variable c_int
stc15 = 1102 # Variable c_int
stc16 = 1103 # Variable c_int
stc17 = 1104 # Variable c_int
stc18 = 1105 # Variable c_int
stc19 = 1106 # Variable c_int
stc20 = 1107 # Variable c_int
stc21 = 1108 # Variable c_int
stc22 = 1109 # Variable c_int
stc23 = 1110 # Variable c_int
stc24 = 1111 # Variable c_int
stc25 = 1112 # Variable c_int
stc26 = 1113 # Variable c_int
stc27 = 1114 # Variable c_int
stc28 = 1115 # Variable c_int
stc29 = 1116 # Variable c_int
stc30 = 1117 # Variable c_int
stc31 = 1118 # Variable c_int
stc32 = 1119 # Variable c_int

tagADVF            = c_int # enum
tagAPPINFOTYPE     = c_int # enum
tagBINDSPEED       = c_int # enum
tagBINDSTATUS      = c_int # enum
tagBINDSTRING      = c_int # enum
tagBIND_FLAGS      = c_int # enum
tagCALLCONV        = c_int # enum
tagCALLTYPE        = c_int # enum
tagCHANGEKIND      = c_int # enum
tagCLSCTX          = c_int # enum
tagCOINIT          = c_int # enum
tagDATADIR         = c_int # enum
tagDCOM_CALL_STATE = c_int # enum
tagDESCKIND        = c_int # enum
tagDISCARDCACHE    = c_int # enum
tagDVASPECT        = c_int # enum
tagEXTCONN         = c_int # enum
tagFUNCFLAGS       = c_int # enum
tagFUNCKIND        = c_int # enum
tagINVOKEKIND      = c_int # enum
tagLIBFLAGS        = c_int # enum
tagLOCKTYPE        = c_int # enum
tagMEMCTX          = c_int # enum
tagMKREDUCE        = c_int # enum
tagMKSYS           = c_int # enum
tagMSHCTX          = c_int # enum
tagMSHLFLAGS       = c_int # enum
tagOLECLOSE        = c_int # enum
tagOLECONTF        = c_int # enum
tagOLEGETMONIKER   = c_int # enum
tagOLELINKBIND     = c_int # enum
tagOLEMISC         = c_int # enum
tagOLERENDER       = c_int # enum
tagOLEUPDATE       = c_int # enum
tagOLEVERBATTRIB   = c_int # enum
tagOLEWHICHMK      = c_int # enum
tagPENDINGMSG      = c_int # enum
tagPENDINGTYPE     = c_int # enum
tagREGCLS          = c_int # enum
tagREGKIND         = c_int # enum
tagSERVERCALL      = c_int # enum
tagSF_TYPE         = c_int # enum
tagSTATFLAG        = c_int # enum
tagSTDMSHLFLAGS    = c_int # enum
tagSTGC            = c_int # enum
tagSTGMOVE         = c_int # enum
tagSTGTY           = c_int # enum
tagSTREAM_SEEK     = c_int # enum
tagSYSKIND         = c_int # enum
tagTYMED           = c_int # enum
tagTYPEFLAGS       = c_int # enum
tagTYPEKIND        = c_int # enum
tagTYSPEC          = c_int # enum
tagURLTEMPLATE     = c_int # enum
tagURLZONE         = c_int # enum
tagUSERCLASSTYPE   = c_int # enum
tagVARFLAGS        = c_int # enum
tagVARKIND         = c_int # enum

ABSOLUTE = win32con.ABSOLUTE # 1
ABORTDOC = win32con.ABORTDOC # 2

ASPECTX  = win32con.ASPECTX # 40
ASPECTY  = win32con.ASPECTY # 42
ASPECTXY = win32con.ASPECTXY # 44
ASYNCH   = 128 # Variable c_int

AclRevisionInformation = 1
AclSizeInformation     = 2

AuditEventObjectAccess           = 0
AuditEventDirectoryServiceAccess = 1
AutoLoad                         = 2

BLACKONWHITE = win32con.BLACKONWHITE # 1
BLACKNESS    = win32con.BLACKNESS # 66
BLTALIGNMENT = win32con.BLTALIGNMENT # 119

CCHDEVICENAME = win32con.CCHDEVICENAME # 32
CCHFORMNAME   = win32con.CCHFORMNAME # 32

CLRRTS       = 4 # Variable c_int
CLRDTR       = 6 # Variable c_int
CLRBREAK     = 9 # Variable c_int
CLIPCAPS     = win32con.CLIPCAPS # 36
CLOSECHANNEL = win32con.CLOSECHANNEL # 4112

COLORONCOLOR                        = win32con.COLORONCOLOR # 3
COMPLEXREGION                       = win32con.COMPLEXREGION # 3
COLORRES                            = win32con.COLORRES # 108
CONVERT10_S_FIRST                   = 262592 # Variable c_long
CONVERT10_S_NO_PRESENTATION         = 262592 # Variable c_long
CONVERT10_S_LAST                    = 262607 # Variable c_long
CONVERT10_E_FIRST                   = 2147746240 # Variable c_ulong
CONVERT10_E_LAST                    = 2147746255 # Variable c_ulong
COLOROKSTRINGA                      = win32con.COLOROKSTRINGA # commdlg_ColorOK
COLOROKSTRINGW                      = 'commdlg_ColorOK' # Variable POINTER(c_wchar)
CONVERT10_E_STG_DIB_TO_BITMAP       = -2147221050 # Variable c_long
CONVERT10_E_STG_NO_STD_STREAM       = -2147221051 # Variable c_long
CONVERT10_E_STG_FMT                 = -2147221052 # Variable c_long
CONVERT10_E_OLESTREAM_BITMAP_TO_DIB = -2147221053 # Variable c_long
CONVERT10_E_OLESTREAM_FMT           = -2147221054 # Variable c_long
CONVERT10_E_OLESTREAM_PUT           = -2147221055 # Variable c_long
CONVERT10_E_OLESTREAM_GET           = -2147221056 # Variable c_long

DEREGISTERED   = 5 # Variable c_int
DEVICEDATA     = win32con.DEVICEDATA # 19
DESKTOPVERTRES = win32con.DESKTOPVERTRES # 117
DESKTOPHORZRES = win32con.DESKTOPHORZRES # 118
DELETE         = win32con.DELETE # 65536

DOWNLOADFACE   = win32con.DOWNLOADFACE # 514
DOWNLOADHEADER = win32con.DOWNLOADHEADER # 4111

DRIVERVERSION     = win32con.DRIVERVERSION # 0
DRAFTMODE         = win32con.DRAFTMODE # 7
DRAWPATTERNRECT   = win32con.DRAWPATTERNRECT # 25
DRAGLISTMSGSTRING = 'commctrl_DragListMsg' # Variable POINTER(c_wchar)

DriverType  = 1
DrwFilePath = 5

ENDDOC               = win32con.ENDDOC # 11
ENABLEDUPLEX         = win32con.ENABLEDUPLEX # 28
ENUMPAPERBINS        = win32con.ENUMPAPERBINS # 31
ENUMPAPERMETRICS     = win32con.ENUMPAPERMETRICS # 34
ENABLERELATIVEWIDTHS = win32con.ENABLERELATIVEWIDTHS # 768
ENABLEPAIRKERNING    = win32con.ENABLEPAIRKERNING # 769

ExceptionContinueExecution = 0
ExeNamePath                = 0
ExceptionContinueSearch    = 1
ExceptionNestedException   = 2
ExceptionCollidedUnwind    = 3

FALSE = win32con.FALSE # 0
FALT  = win32con.FALT # 16

FILEOPENORD    = 1536 # Variable c_int
FINDDLGORD     = 1540 # Variable c_int
FIONREAD       = 1074030207 # Variable c_long
FIOASYNC       = 2147772029 # Variable c_ulong
FIONBIO        = 2147772030 # Variable c_ulong
FILEOKSTRINGA  = win32con.FILEOKSTRINGA # commdlg_FileNameOK
FILEOKSTRINGW  = 'commdlg_FileNameOK' # Variable POINTER(c_wchar)
FINDMSGSTRINGA = win32con.FINDMSGSTRINGA # commdlg_FindReplace
FINDMSGSTRINGW = 'commdlg_FindReplace' # Variable POINTER(c_wchar)

FLOODFILLBORDER  = win32con.FLOODFILLBORDER # 0
FLOODFILLSURFACE = win32con.FLOODFILLSURFACE # 1
FLUSHOUTPUT      = win32con.FLUSHOUTPUT # 6

FONTDLGORD     = 1542 # Variable c_int
FORMATDLGORD31 = 1543 # Variable c_int
FORMATDLGORD30 = 1544 # Variable c_int

GETCOLORTABLE          = win32con.GETCOLORTABLE # 5
GETPHYSPAGESIZE        = win32con.GETPHYSPAGESIZE # 12
GETPRINTINGOFFSET      = win32con.GETPRINTINGOFFSET # 13
GETSCALINGFACTOR       = win32con.GETSCALINGFACTOR # 14
GETPENWIDTH            = win32con.GETPENWIDTH # 16
GETTECHNOLGY           = win32con.GETTECHNOLGY # 20
GETTECHNOLOGY          = win32con.GETTECHNOLOGY # 20
GETVECTORPENSIZE       = win32con.GETVECTORPENSIZE # 26
GETVECTORBRUSHSIZE     = win32con.GETVECTORBRUSHSIZE # 27
GETSETPAPERBINS        = win32con.GETSETPAPERBINS # 29
GETSETPRINTORIENT      = win32con.GETSETPRINTORIENT # 30
GETSETPAPERMETRICS     = win32con.GETSETPAPERMETRICS # 35
GETDEVICEUNITS         = win32con.GETDEVICEUNITS # 42
GETEXTENDEDTEXTMETRICS = win32con.GETEXTENDEDTEXTMETRICS # 256
GETEXTENTTABLE         = win32con.GETEXTENTTABLE # 257
GETPAIRKERNTABLE       = win32con.GETPAIRKERNTABLE # 258
GETTRACKKERNTABLE      = win32con.GETTRACKKERNTABLE # 259
GETFACENAME            = win32con.GETFACENAME # 513
GETSETSCREENPARAMS     = win32con.GETSETSCREENPARAMS # 3072

GetFileExInfoStandard = 0
GetFileExMaxInfoLevel = 1

HELPMSGSTRINGA = win32con.HELPMSGSTRINGA # commdlg_help
HELPMSGSTRINGW = 'commdlg_help' # Variable POINTER(c_wchar)

HORZSIZE = win32con.HORZSIZE # 4
HORZRES  = win32con.HORZRES # 8

HTNOWHERE     = win32con.HTNOWHERE # 0
HTCLIENT      = win32con.HTCLIENT # 1
HTCAPTION     = win32con.HTCAPTION # 2
HTSYSMENU     = win32con.HTSYSMENU # 3
HTGROWBOX     = win32con.HTGROWBOX # 4
HTMENU        = win32con.HTMENU # 5
HTHSCROLL     = win32con.HTHSCROLL # 6
HTVSCROLL     = win32con.HTVSCROLL # 7
HTMINBUTTON   = win32con.HTMINBUTTON # 8
HTMAXBUTTON   = win32con.HTMAXBUTTON # 9
HTLEFT        = win32con.HTLEFT # 10
HTRIGHT       = win32con.HTRIGHT # 11
HTTOP         = win32con.HTTOP # 12
HTTOPLEFT     = win32con.HTTOPLEFT # 13
HTTOPRIGHT    = win32con.HTTOPRIGHT # 14
HTBOTTOM      = win32con.HTBOTTOM # 15
HTBOTTOMLEFT  = win32con.HTBOTTOMLEFT # 16
HTBOTTOMRIGHT = win32con.HTBOTTOMRIGHT # 17
HTBORDER      = win32con.HTBORDER # 18
HTOBJECT      = win32con.HTOBJECT # 19
HTCLOSE       = win32con.HTCLOSE # 20
HTHELP        = win32con.HTHELP # 21
HTTRANSPARENT = win32con.HTTRANSPARENT # -1
HTERROR       = win32con.HTERROR # -2

IDOK     = win32con.IDOK # 1
IDCANCEL = win32con.IDCANCEL # 2
IDABORT  = win32con.IDABORT # 3
IDRETRY  = win32con.IDRETRY # 4
IDIGNORE = win32con.IDIGNORE # 5
IDYES    = win32con.IDYES # 6
IDNO     = win32con.IDNO # 7
IDCLOSE  = win32con.IDCLOSE # 8
IDHELP   = win32con.IDHELP # 9

INFOTIPSIZE = 1024 # Variable c_int
INFINITE    = 4294967295 # Variable c_uint

JOYSTICKID1 = 0 # Variable c_int
JOYSTICKID2 = 1 # Variable c_int

JobObjectBasicAccountingInformation         = 1
JobObjectBasicLimitInformation              = 2
JobObjectBasicProcessIdList                 = 3
JobObjectBasicUIRestrictions                = 4
JobObjectSecurityLimitInformation           = 5
JobObjectEndOfJobTimeInformation            = 6
JobObjectAssociateCompletionPortInformation = 7

LBSELCHSTRINGA = win32con.LBSELCHSTRINGA # commdlg_LBSelChangedNotify
LBSELCHSTRINGW = 'commdlg_LBSelChangedNotify' # Variable POINTER(c_wchar)

LOGPIXELSX = win32con.LOGPIXELSX # 88
LOGPIXELSY = win32con.LOGPIXELSY # 90

LPTR = win32con.LPTR # 64
LPTx = 128 # Variable c_int

MARKPARITY            = win32con.MARKPARITY # 3
MAXSTRETCHBLTMODE     = win32con.MAXSTRETCHBLTMODE # 4
MAXPNAMELEN           = 32 # Variable c_int
MAXPROPPAGES          = 100 # Variable c_int
MAXCHAR               = win32con.MAXCHAR # 127
MAXBYTE               = win32con.MAXBYTE # 255
MAXERRORLENGTH        = 256 # Variable c_int
MAXLOGICALLOGNAMESIZE = 256 # Variable c_int
MAXGETHOSTSTRUCT      = 1024 # Variable c_int
MAXSHORT              = win32con.MAXSHORT # 32767
MAXINTATOM            = win32con.MAXINTATOM # 49152
MAXWORD               = win32con.MAXWORD # 65535
MAXLONG               = win32con.MAXLONG # 2147483647
MAXDWORD              = win32con.MAXDWORD # -1

MERGEPAINT = win32con.MERGEPAINT # 12255782
MERGECOPY  = win32con.MERGECOPY # 12583114

MIDIPATCHSIZE = 128 # Variable c_int
MINCHAR       = win32con.MINCHAR # 128
MINSHORT      = win32con.MINSHORT # 32768
MINLONG       = win32con.MINLONG # -2147483648
MIDIMAPPER    = 4294967295 # Variable c_uint

NCBCALL        = 16 # Variable c_int
NCBNAMSZ       = 16 # Variable c_int
NCBLISTEN      = 17 # Variable c_int
NCBHANGUP      = 18 # Variable c_int
NCBSEND        = 20 # Variable c_int
NCBRECV        = 21 # Variable c_int
NCBRECVANY     = 22 # Variable c_int
NCBCHAINSEND   = 23 # Variable c_int
NCBDGSEND      = 32 # Variable c_int
NCBDGRECV      = 33 # Variable c_int
NCBDGSENDBC    = 34 # Variable c_int
NCBDGRECVBC    = 35 # Variable c_int
NCBADDNAME     = 48 # Variable c_int
NCBDELNAME     = 49 # Variable c_int
NCBRESET       = 50 # Variable c_int
NCBASTAT       = 51 # Variable c_int
NCBSSTAT       = 52 # Variable c_int
NCBCANCEL      = 53 # Variable c_int
NCBADDGRNAME   = 54 # Variable c_int
NCBENUM        = 55 # Variable c_int
NCBUNLINK      = 112 # Variable c_int
NCBSENDNA      = 113 # Variable c_int
NCBCHAINSENDNA = 114 # Variable c_int
NCBLANSTALERT  = 115 # Variable c_int
NCBACTION      = 119 # Variable c_int
NCBFINDNAME    = 120 # Variable c_int
NCBTRACE       = 121 # Variable c_int

NEWFRAME         = win32con.NEWFRAME # 1
NEWTRANSPARENT   = 3 # Variable c_int
NEXTBAND         = win32con.NEXTBAND # 3
NEWFILEOPENORD   = 1547 # Variable c_int
NEWOBJECTOPENORD = 1548 # Variable c_int

NOERROR     = 0 # Variable c_int
NONZEROLPTR = win32con.NONZEROLPTR # 0
NOPARITY    = win32con.NOPARITY # 0
NONZEROLHND = win32con.NONZEROLHND # 2
NOTSRCERASE = win32con.NOTSRCERASE # 1114278
NOTSRCCOPY  = win32con.NOTSRCCOPY # 3342344

NULL        = win32con.NULL # 0
NULLREGION  = win32con.NULLREGION # 1
NUMBRUSHES  = win32con.NUMBRUSHES # 16
NUMPENS     = win32con.NUMPENS # 18
NUMMARKERS  = win32con.NUMMARKERS # 20
NUMFONTS    = win32con.NUMFONTS # 22
NUMCOLORS   = win32con.NUMCOLORS # 24
NUMRESERVED = win32con.NUMRESERVED # 106

ONESTOPBIT   = win32con.ONESTOPBIT # 0
ONE5STOPBITS = win32con.ONE5STOPBITS # 1

OPAQUE      = win32con.OPAQUE # 2
OPENCHANNEL = win32con.OPENCHANNEL # 4110

PASSTHROUGH     = win32con.PASSTHROUGH # 19
PAGESETUPDLGORD = 1546 # Variable c_int
PATINVERT       = win32con.PATINVERT # 5898313
PATCOPY         = win32con.PATCOPY # 15728673
PATPAINT        = win32con.PATPAINT # 16452105

PHYSICALWIDTH   = win32con.PHYSICALWIDTH # 110
PHYSICALHEIGHT  = win32con.PHYSICALHEIGHT # 111
PHYSICALOFFSETX = win32con.PHYSICALOFFSETX # 112
PHYSICALOFFSETY = win32con.PHYSICALOFFSETY # 113

PRINTDLGORD    = 1538 # Variable c_int
PRNSETUPDLGORD = 1539 # Variable c_int

QUERYESCSUPPORT = win32con.QUERYESCSUPPORT # 8
QUERYROPSUPPORT = 40 # Variable c_int
QUERYDIBSUPPORT = 3073 # Variable c_int

REGISTERING     = 0 # Variable c_int
RELATIVE        = win32con.RELATIVE # 2
REGISTERED      = 4 # Variable c_int
RESETDEV        = 7 # Variable c_int
REPLACEDLGORD   = 1541 # Variable c_int
REBARCLASSNAMEA = 'ReBarWindow32' # Variable POINTER(c_char)
REBARCLASSNAMEW = 'ReBarWindow32' # Variable POINTER(c_wchar)

RpcCallComplete             = 0
RpcNotificationTypeNone     = 0
RpcNotificationTypeEvent    = 1
RpcSendComplete             = 1
RpcNotificationTypeApc      = 2
RpcReceiveComplete          = 2
RpcNotificationTypeIoc      = 3
RpcNotificationTypeHwnd     = 4
RpcNotificationTypeCallback = 5

SCALINGFACTORX = win32con.SCALINGFACTORX # 114
SCALINGFACTORY = win32con.SCALINGFACTORY # 115

SETXOFF           = 1 # Variable c_int
SETXON            = 2 # Variable c_int
SETRTS            = 3 # Variable c_int
SETCOLORTABLE     = win32con.SETCOLORTABLE # 4
SETDTR            = 5 # Variable c_int
SETBREAK          = 8 # Variable c_int
SETABORTPROC      = win32con.SETABORTPROC # 9
SETCOPYCOUNT      = win32con.SETCOPYCOUNT # 17
SELECTPAPERSOURCE = win32con.SELECTPAPERSOURCE # 18
SETLINECAP        = win32con.SETLINECAP # 21
SETLINEJOIN       = win32con.SETLINEJOIN # 22
SETMITERLIMIT     = win32con.SETMITERLIMIT # 23
SETDIBSCALING     = win32con.SETDIBSCALING # 32
SELECTDIB         = 41 # Variable c_int
SETKERNTRACK      = win32con.SETKERNTRACK # 770
SETALLJUSTVALUES  = win32con.SETALLJUSTVALUES # 771
SETCHARSET        = win32con.SETCHARSET # 772
SETRGBSTRINGA     = win32con.SETRGBSTRINGA # commdlg_SetRGBColor
SETRGBSTRINGW     = 'commdlg_SetRGBColor' # Variable POINTER(c_wchar)

SHAREVISTRINGA = win32con.SHAREVISTRINGA # commdlg_ShareViolation
SHAREVISTRINGW = 'commdlg_ShareViolation' # Variable POINTER(c_wchar)

SIMPLEREGION = win32con.SIMPLEREGION # 2
SIZEPALETTE  = win32con.SIZEPALETTE # 104
SIOCGHIWAT   = 1074033409 # Variable c_long
SIOCGLOWAT   = 1074033411 # Variable c_long
SIOCATMARK   = 1074033415 # Variable c_long
SIOCSHIWAT   = 2147775232 # Variable c_ulong
SIOCSLOWAT   = 2147775234 # Variable c_ulong

SRCERASE  = win32con.SRCERASE # 4457256
SRCINVERT = win32con.SRCINVERT # 6684742
SRCAND    = win32con.SRCAND # 8913094
SRCCOPY   = win32con.SRCCOPY # 13369376
SRCPAINT  = win32con.SRCPAINT # 15597702

STRICT           = 1 # Variable c_int
STARTDOC         = win32con.STARTDOC # 10
STRETCHBLT       = win32con.STRETCHBLT # 2048
STATUSCLASSNAMEA = 'msctls_statusbar32' # Variable POINTER(c_char)
STATUSCLASSNAMEW = 'msctls_statusbar32' # Variable POINTER(c_wchar)

SecurityAnonymous      = 0
SecurityIdentification = 1
SecurityImpersonation  = 2
SevereError            = 2
SecurityDelegation     = 3
SetupNamePath          = 6

SidTypeUser           = 1
SidTypeGroup          = 2
SidTypeDomain         = 3
SidTypeAlias          = 4
SidTypeWellKnownGroup = 5
SidTypeDeletedAccount = 6
SidTypeInvalid        = 7
SidTypeUnknown        = 8
SidTypeComputer       = 9

TECHNOLOGY = win32con.TECHNOLOGY # 2
TEXTCAPS   = win32con.TEXTCAPS # 34

TOOLBARCLASSNAMEA = 'ToolbarWindow32' # Variable POINTER(c_char)
TOOLBARCLASSNAMEW = 'ToolbarWindow32' # Variable POINTER(c_wchar)

TRANSPARENT = win32con.TRANSPARENT # 1
TRUE        = win32con.TRUE # 1

TokenPrimary            = 1
TokenUser               = 1
TokenGroups             = 2
TokenImpersonation      = 2
TokenPrivileges         = 3
TokenOwner              = 4
TokenPrimaryGroup       = 5
TokenDefaultDacl        = 6
TokenSource             = 7
TokenType               = 8
TokenImpersonationLevel = 9
TokenStatistics         = 10
TokenRestrictedSids     = 11
TokenSessionId          = 12

VERTSIZE = win32con.VERTSIZE # 6
VERTRES  = win32con.VERTRES # 10

WHITEONBLACK = win32con.WHITEONBLACK # 2
WHITENESS    = win32con.WHITENESS # 16711778

WINDING = win32con.WINDING # 2
WINVER  = win32con.WINVER # 1280

WSABASEERR         = 10000 # Variable c_int
WSAEINTR           = 10004 # Variable c_int
WSAEBADF           = 10009 # Variable c_int
WSAEACCES          = 10013 # Variable c_int
WSAEFAULT          = 10014 # Variable c_int
WSAEINVAL          = 10022 # Variable c_int
WSAEMFILE          = 10024 # Variable c_int
WSAEWOULDBLOCK     = 10035 # Variable c_int
WSAEINPROGRESS     = 10036 # Variable c_int
WSAEALREADY        = 10037 # Variable c_int
WSAENOTSOCK        = 10038 # Variable c_int
WSAEDESTADDRREQ    = 10039 # Variable c_int
WSAEMSGSIZE        = 10040 # Variable c_int
WSAEPROTOTYPE      = 10041 # Variable c_int
WSAENOPROTOOPT     = 10042 # Variable c_int
WSAEPROTONOSUPPORT = 10043 # Variable c_int
WSAESOCKTNOSUPPORT = 10044 # Variable c_int
WSAEOPNOTSUPP      = 10045 # Variable c_int
WSAEPFNOSUPPORT    = 10046 # Variable c_int
WSAEAFNOSUPPORT    = 10047 # Variable c_int
WSAEADDRINUSE      = 10048 # Variable c_int
WSAEADDRNOTAVAIL   = 10049 # Variable c_int
WSAENETDOWN        = 10050 # Variable c_int
WSAENETUNREACH     = 10051 # Variable c_int
WSAENETRESET       = 10052 # Variable c_int
WSAECONNABORTED    = 10053 # Variable c_int
WSAECONNRESET      = 10054 # Variable c_int
WSAENOBUFS         = 10055 # Variable c_int
WSAEISCONN         = 10056 # Variable c_int
WSAENOTCONN        = 10057 # Variable c_int
WSAESHUTDOWN       = 10058 # Variable c_int
WSAETOOMANYREFS    = 10059 # Variable c_int
WSAETIMEDOUT       = 10060 # Variable c_int
WSAECONNREFUSED    = 10061 # Variable c_int
WSAELOOP           = 10062 # Variable c_int
WSAENAMETOOLONG    = 10063 # Variable c_int
WSAEHOSTDOWN       = 10064 # Variable c_int
WSAEHOSTUNREACH    = 10065 # Variable c_int
WSAENOTEMPTY       = 10066 # Variable c_int
WSAEPROCLIM        = 10067 # Variable c_int
WSAEUSERS          = 10068 # Variable c_int
WSAEDQUOT          = 10069 # Variable c_int
WSAESTALE          = 10070 # Variable c_int
WSAEREMOTE         = 10071 # Variable c_int
WSASYSNOTREADY     = 10091 # Variable c_int
WSAVERNOTSUPPORTED = 10092 # Variable c_int
WSANOTINITIALISED  = 10093 # Variable c_int
WSAEDISCON         = 10101 # Variable c_int

Win32ServiceOwnProcess   = 16
Win32ServiceShareProcess = 32

_ALPHA                = 259 # Variable c_int
_BLANK                = 64 # Variable c_int
_CLASSPATHTYPE        = c_int # enum
_CONTROL              = 32 # Variable c_int
_DIGIT                = 4 # Variable c_int
_HEX                  = 128 # Variable c_int
_JOBOBJECTINFOCLASS   = c_int # enum
_LEADBYTE             = 32768 # Variable c_int
_LOWER                = 2 # Variable c_int
_NLSCMPERROR          = win32con._NLSCMPERROR # 2147483647
_PUNCT                = 16 # Variable c_int
_SPACE                = 8 # Variable c_int
_SRVINFO              = c_int # enum
_UPPER                = 1 # Variable c_int
_URLZONEREG           = c_int # enum
cbNDRContext          = 20 # Variable c_int
xmlelemTYPE           = c_int # enum
ALTERNATE             = win32con.ALTERNATE # 1
AdapterType           = 4
BANDINFO              = win32con.BANDINFO # 24
BITSPIXEL             = win32con.BITSPIXEL # 12
BootLoad              = 0
CBEMAXSTRLEN          = 260 # Variable c_int
CFSEPCHAR             = '+' # Variable c_char
CURVECAPS             = win32con.CURVECAPS # 28
CWCSTORAGENAME        = 32 # Variable c_int
CabFilePath           = 3
CriticalError         = 3
DIFFERENCE            = win32con.DIFFERENCE # 11
DLGWINDOWEXTRA        = win32con.DLGWINDOWEXTRA # 30
DSTINVERT             = win32con.DSTINVERT # 5570569
DUPLICATE             = 6 # Variable c_int
DemandLoad            = 3
DisableLoad           = 4
DllNamePath           = 1
EPSPRINTING           = win32con.EPSPRINTING # 33
ERROR                 = win32con.ERROR # 0
EVENPARITY            = win32con.EVENPARITY # 2
EXTTEXTOUT            = win32con.EXTTEXTOUT # 512
FCONTROL              = win32con.FCONTROL # 8
FNOINVERT             = win32con.FNOINVERT # 2
FSHIFT                = win32con.FSHIFT # 4
FileSystemType        = 2
GHND                  = win32con.GHND # 66
GPTR                  = win32con.GPTR # 64
HALFTONE              = win32con.HALFTONE # 4
IGNORE                = 0 # Variable c_int
IgnoreError           = 0
InfFilePath           = 4
LHND                  = win32con.LHND # 66
LINECAPS              = win32con.LINECAPS # 30
MFCOMMENT             = win32con.MFCOMMENT # 15
MOUSETRAILS           = win32con.MOUSETRAILS # 39
MULTIFILEOPENORD      = 1537 # Variable c_int
MaxJobObjectInfoClass = 8
NormalError           = 1
ODDPARITY             = win32con.ODDPARITY # 1
PDEVICESIZE           = win32con.PDEVICESIZE # 26
PLANES                = win32con.PLANES # 14
POLYGONALCAPS         = win32con.POLYGONALCAPS # 32
RASTERCAPS            = win32con.RASTERCAPS # 38
RUNDLGORD             = 1545 # Variable c_int
RecognizerType        = 8
SOMAXCONN             = 5 # Variable c_int
SPACEPARITY           = win32con.SPACEPARITY # 4
SYNCHRONIZE           = win32con.SYNCHRONIZE # 1048576
SystemLoad            = 1
TWOSTOPBITS           = win32con.TWOSTOPBITS # 2
TlbNamePath           = 2
UNICODE               = 1 # Variable c_int
VARENUM               = c_int # enum
VREFRESH              = win32con.VREFRESH # 116
WEOF                  = '\uffff' # Variable c_wchar
