from flask import Blueprint, render_template, request, jsonify, current_app
from flask_login import login_required, current_user
import os, requests, base64, json
from pathlib import Path
from datetime import datetime
from applications.models import AiFileParser
from applications.common.utils.http import table_api, fail_api, success_api
from applications.extensions import db, flask_mail
bp = Blueprint('parser', __name__, url_prefix='/')

upload_pdf_directory = r"\upload\pdf"
# 测试
@bp.get('/test')
def test():
    return "123"


# script_path = Path(__file__).resolve()
# script_dir = script_path.parent   

@bp.get("/ai_index_page")
def ai_index_page():
    print("123")
    return render_template('system/parser/main.html')

status_dic = {0:"未解析",2:"解析成功"}
@bp.get("/ai_index")
def ai_index():
    query = db.session.query(AiFileParser).filter().layui_paginate()
    data = []
    for row in query.items:
        path_parts = json.loads(row.file_path)
        if path_parts[0].endswith(':') and not path_parts[0].endswith(os.sep):  
            path_parts[0] += os.sep 
        path = os.path.join(*path_parts)
        data.append({
            "id":row.id,
            "file_path":path,
            "file_id":row.file_id,
            "status":status_dic[row.status]
        })
    return table_api(data=data,count=query.total)


@bp.route("/detail/<int:id>")
def detail(id):
    data = AiFileParser.query.get(id)
    path_parts = json.loads(data.file_path)
    if path_parts[0].endswith(':') and not path_parts[0].endswith(os.sep):  
        path_parts[0] += os.sep 
        data.file_path = os.path.join(*path_parts)
        with open('./tmp/pdf/4.pdf', 'rb') as file:  
            pdf_data = file.read()  

        # 将二进制数据编码为Base64字符串  
        base64_pdf = base64.b64encode(pdf_data).decode('utf-8')
        full_base64_string = f'data:application/pdf;base64,{base64_pdf}'
        
    return render_template('system/parser/detail.html',data=data,pdf_base64=full_base64_string)



@bp.route("/upload_page")
def upload_page():
    return render_template('system/parser/upload.html')


@bp.post("/get_ai_info")
def get_ai_info():
    data = request.json  
    file_code = data.get('file_code') 
    if file_code is None:  
        return fail_api(msg = "file_code不能为空")
    ai_info = AiFileParser.query.filter(AiFileParser.file_id==file_code).first()
    if ai_info is None:
        return fail_api(msg = "请传递正确的file_code")
    
    res = {
            'msg': "成功",
            'code': 0,
            'data': ai_info.kimi_ai_parser
        }
    return jsonify(res)



# 普通文件上传
@bp.post('/upload')
def upload():
    
    try:
        if 'file' not in request.files:
            return fail_api(msg='文件不存在')

        file = request.files['file']
        filename = file.filename
        ext = filename.rsplit('.')[-1]
        # print("============>",ext)
        # columns_to_read = ['ASIN', 'Product Title', 'Brand', 'Glance Views']
        if ext != 'pdf':
            return fail_api(msg='请上传pdf文件')
        
    except Exception as e:
        return fail_api(msg=f"文件上传异常: {e}")
    
    file_code = request.form.get('file_code')
    parser_engine = request.form.get('parser_engine')
    print(file_code,parser_engine)
    project_root = current_app.config.get('PROJECT_ROOT')
    full_directory = project_root + upload_pdf_directory
    now = get_current_datetime()
    # 指定文件保存的路径（这里只是示例，你可能需要根据你的应用进行调整）  
    file_name = f"\{now}.pdf"
    # file_path = os.path.join(full_directory, "" + now + "."+filetype)
    if not os.path.exists(full_directory):  
        os.makedirs(full_directory)  
    # full_path = os.path.join(bsolute_file_path, filename)  
    bsolute_file_path = full_directory + file_name
    file.save(bsolute_file_path)
    path_list = str(bsolute_file_path).split('\\')
    new_ai_file_parser = AiFileParser(
            file_path=json.dumps(path_list),
            file_id =  file_code,
            parser_engine = parser_engine,
            status = 0,
        )
    db.session.add(new_ai_file_parser)  
    db.session.commit()
    return success_api(msg="上传成功")

# base64 encoded 上传
@bp.route("/base64_upload", methods=['POST'])
def base64_upload():
    project_root = current_app.config.get('PROJECT_ROOT')
    full_directory = project_root + upload_pdf_directory
    data = request.json  
    base64_pdf = data.get('pdf_base64')  
    file_code = data.get('file_code')  
    parser_engine = data.get('parser_engine')
    print(file_code,parser_engine)
    if base64_pdf is None or file_code is None:  
        return jsonify({'error': 'Missing PDF or file_code'}), 400  
  
    # 检查base64字符串是否以正确的头部开始（可选，但有助于验证输入）  
    if not base64_pdf.startswith('data:application/pdf;base64,'):  
        return jsonify({'error': 'Invalid Base64 string'}), 400  
  
    # 移除Base64字符串的头部（如果存在）  
    base64_pdf = base64_pdf.split(',')[1]  
  
    # 解码Base64字符串为二进制数据  
    pdf_data = base64.b64decode(base64_pdf)  
    now = get_current_datetime()
    # 指定文件保存的路径（这里只是示例，你可能需要根据你的应用进行调整）  
    file_name = f"\{now}.pdf"
    # file_path = os.path.join(full_directory, "" + now + "."+filetype)
    if not os.path.exists(full_directory):  
        os.makedirs(full_directory)  
    # full_path = os.path.join(bsolute_file_path, filename)  
    bsolute_file_path = full_directory + file_name
    # 将解码后的数据写入文件  
    with open(bsolute_file_path, 'wb') as file:  
        file.write(pdf_data)  
    path_list = str(bsolute_file_path).split('\\')
    new_ai_file_parser = AiFileParser(
            file_path=json.dumps(path_list),
            file_id =  file_code,
            parser_engine = parser_engine,
            status = 0,
        )
    db.session.add(new_ai_file_parser)  
    db.session.commit()
    # return jsonify({'message': 'PDF uploaded successfully', 'path_list': path_list}), 200
    return success_api(msg="增加成功")

def get_current_datetime():
    # 获取当前时间  
    now = datetime.now()  
    # 格式化时间字符串  
    formatted_time = now.strftime("%Y%m%d%H%M%S") 
    return formatted_time
