import datetime
from applications.extensions import db

class AiFileParser(db.Model):
    __tablename__ = 'ai_file_parser'
    id = db.Column(db.Integer, primary_key=True)
    file_path = db.Column(db.String(255), unique=True, nullable=False)
    wx_ai_parser = db.Column(db.Text, nullable=False)
    gpt_ai_parser = db.Column(db.Text, nullable=False)
    kimi_ai_parser = db.Column(db.Text, nullable=False)
    file_id = db.Column(db.String(255), nullable=False)
    parser_engine = db.Column(db.String(255), nullable=False)
    prompt_id = db.Column(db.Integer, nullable=False)
    status = db.Column(db.Integer, nullable=False)
    create_date = db.Column(db.DateTime, default=datetime.datetime.now, onupdate=datetime.datetime.now, comment='更新时间')
    
    
    def __repr__(self):
        return '<User %r>' % self.id
    
    def to_dict(self):
        return {c.name: getattr(self, c.name) for c in self.__table__.columns}
